/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.ui.dialog;

import com.inkwellideas.ographer.data.ViewLevel;
import com.inkwellideas.ographer.io.UserPrefs;
import com.inkwellideas.ographer.task.GenerateEmpiresTask;
import com.inkwellideas.ographer.ui.MapUI;
import com.inkwellideas.ographer.ui.Worldographer;
import com.inkwellideas.ographer.ui.widget.FocusSpinner;
import com.inkwellideas.ographer.ui.widget.StyledDialog;
import com.inkwellideas.ographer.undo.UndoActionGroup;
import java.util.Optional;
import java.util.Random;
import javafx.collections.FXCollections;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.GridPane;
import javafx.stage.Window;

public class GenerateRiversDialog {
    private final MapUI mapUI;
    private final Worldographer worldographer;

    public GenerateRiversDialog(Worldographer worldographer, MapUI mapUI) {
        this.worldographer = worldographer;
        this.mapUI = mapUI;
    }

    public void showGenerateRiversDialog() {
        if (this.mapUI.getMapData().getTerrain(ViewLevel.WORLD) == null) {
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.setTitle("World View Level Needed");
            alert.setContentText("The river generator needs uses data from the World view level.  Your map must create that first.");
            alert.showAndWait();
            return;
        }
        StyledDialog d = new StyledDialog(true, (Window)this.worldographer.getPrimaryStage(), "Generate Rivers");
        d.setHeaderText("Enter the number of rivers to add.");
        GridPane grid = new GridPane();
        grid.setHgap(10.0);
        grid.setVgap(10.0);
        grid.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        grid.add((Node)new Label("Rivers #/10000 tiles:"), 0, 0);
        FocusSpinner riversSpinner = new FocusSpinner(1, 400, UserPrefs.PREFS.getInt("riversNumber", 10));
        riversSpinner.setEditable(true);
        grid.add(riversSpinner, 1, 0);
        Label shapeFeatureLabel = new Label("Use Shapes or Features?");
        shapeFeatureLabel.setTooltip(new Tooltip("Features are prettier, shapes are more flexible/dynamic."));
        grid.add((Node)shapeFeatureLabel, 0, 1);
        Object[] riverTypes = new String[]{"Features", "Shapes - Classic", "Shapes - Textured"};
        ComboBox riverTypeCombo = new ComboBox(FXCollections.observableArrayList((Object[])riverTypes));
        riverTypeCombo.getSelectionModel().select((Object)UserPrefs.PREFS.get("riversType", "Shapes - Classic"));
        grid.add((Node)riverTypeCombo, 1, 1);
        d.getDialogPane().setContent((Node)grid);
        ButtonType yes = new ButtonType("OK");
        ButtonType cancel = new ButtonType("Cancel");
        d.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{yes, cancel});
        Optional result = d.showAndWait();
        if (result.isPresent() && result.get() == yes) {
            UserPrefs.PREFS.putInt("riversNumber", (Integer)riversSpinner.getValue());
            UserPrefs.PREFS.put("riversType", (String)riverTypeCombo.getValue());
            try {
                UserPrefs.PREFS.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
            UndoActionGroup uag = new UndoActionGroup();
            GenerateEmpiresTask task = new GenerateEmpiresTask(false, true, false, false, false, this.worldographer, this.mapUI, null, uag, "", false, (Integer)riversSpinner.getValue(), (String)riverTypeCombo.getValue(), 0, null, false, this.mapUI.getMapData().getNotes(), 0, new Random(), 0.0, 0.0, false, false, false, false, null, null, 0);
            task.setOnSucceeded(te -> {
                this.mapUI.getController().getUndoRedoHandler().push(uag);
                this.mapUI.draw();
            });
            new Thread((Runnable)((Object)task)).start();
        }
    }
}

