/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.ui.dialog;

import com.inkwellideas.ographer.data.ViewLevel;
import com.inkwellideas.ographer.io.FileSaveLoad;
import com.inkwellideas.ographer.model.Feature;
import com.inkwellideas.ographer.model.Note;
import com.inkwellideas.ographer.model.NoteTable;
import com.inkwellideas.ographer.model.TableData;
import com.inkwellideas.ographer.ui.Worldographer;
import com.inkwellideas.ographer.ui.widget.StyledDialog;
import com.inkwellideas.ographer.undo.UndoActionGroup;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.TreeSet;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.embed.swing.SwingFXUtils;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Color;
import javafx.scene.web.HTMLEditor;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import javafx.util.Callback;
import javax.imageio.ImageIO;

public class NoteDialog
extends Dialog<Boolean> {
    Map<String, NoteTable> origNoteTables;
    CheckBox worldCheckBox;
    CheckBox continentCheckBox;
    CheckBox kingdomCheckBox;
    CheckBox provinceCheckBox;

    public NoteDialog(Note note, Worldographer worldographer) {
        TextField filenameLabel;
        ColorPicker colorpicker;
        HTMLEditor details;
        TextField title;
        GridPane grid;
        ButtonType cancelButtonType;
        ButtonType deleteButtonType;
        ButtonType saveButtonType;
        block10: {
            block9: {
                this.origNoteTables = new TreeMap<String, NoteTable>();
                this.worldCheckBox = new CheckBox("World  ");
                this.continentCheckBox = new CheckBox("Continent  ");
                this.kingdomCheckBox = new CheckBox("Kingdom  ");
                this.provinceCheckBox = new CheckBox("Province  ");
                this.setTitle("Note: " + note.getTitle());
                this.setHeaderText("Note");
                this.setResizable(true);
                if (note.getTableData() != null) {
                    this.origNoteTables = new TreeMap<String, NoteTable>();
                    for (String tablekey : note.getTableData().keySet()) {
                        NoteTable oldnt = note.getTableData().get(tablekey);
                        TableData newheadings = new TableData(oldnt.getHeadings().getA(), oldnt.getHeadings().getB(), oldnt.getHeadings().getC(), oldnt.getHeadings().getD(), oldnt.getHeadings().getE(), oldnt.getHeadings().getF(), oldnt.getHeadings().getG(), oldnt.getHeadings().getH());
                        ArrayList<TableData> data = new ArrayList<TableData>();
                        for (TableData olddata : oldnt.getData()) {
                            data.add(new TableData(olddata.getA(), olddata.getB(), olddata.getC(), olddata.getD(), olddata.getE(), olddata.getF(), olddata.getG(), olddata.getH()));
                        }
                        this.origNoteTables.put(tablekey, new NoteTable(newheadings, (ObservableList<TableData>)FXCollections.observableArrayList(data)));
                    }
                }
                saveButtonType = new ButtonType("Save", ButtonBar.ButtonData.APPLY);
                deleteButtonType = new ButtonType("Delete", ButtonBar.ButtonData.LEFT);
                cancelButtonType = new ButtonType("Close", ButtonBar.ButtonData.CANCEL_CLOSE);
                if (note.getParent() != null && note.getParent() instanceof Feature) {
                    this.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{saveButtonType, cancelButtonType});
                } else {
                    this.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{saveButtonType, cancelButtonType, deleteButtonType});
                }
                grid = new GridPane();
                grid.setHgap(10.0);
                grid.setVgap(10.0);
                grid.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
                title = new TextField(note.getTitle());
                title.setPromptText("Title");
                details = new HTMLEditor();
                details.setMaxHeight(400.0);
                details.setHtmlText(note.getDetails());
                colorpicker = new ColorPicker(note.getColor());
                colorpicker.setMinHeight(25.0);
                grid.add((Node)new Label("Title:"), 0, 0);
                grid.add((Node)title, 1, 0);
                grid.add((Node)new Label("Color:"), 0, 1);
                grid.add((Node)colorpicker, 1, 1);
                grid.add((Node)new Label("File:"), 0, 2);
                HBox filebox = new HBox();
                filebox.setSpacing(5.0);
                filenameLabel = new TextField(note.getFilename());
                filenameLabel.setEditable(false);
                filenameLabel.setMinWidth(300.0);
                filenameLabel.setMaxWidth(300.0);
                filebox.getChildren().add((Object)filenameLabel);
                Button changebutton = new Button("Change File");
                changebutton.setOnAction(event -> {
                    File f;
                    FileChooser fc = new FileChooser();
                    fc.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Worldographer XML (*.wxx)", new String[]{"*.wxx", "GIF Picture (*.gif)", "*.gif", "JPeG Picture (*.jpg)", "*.jpg", "PNG Picture (*.png)", "*.png"}));
                    File d = FileSaveLoad.getLastUsedDir();
                    if (d != null) {
                        fc.setInitialDirectory(d);
                    }
                    if ((f = fc.showOpenDialog(null)) != null) {
                        filenameLabel.setText(f.getAbsoluteFile().getAbsoluteFile().getPath());
                    }
                });
                filebox.getChildren().add((Object)changebutton);
                Button openbutton = new Button("Open File");
                openbutton.setOnAction(event -> {
                    if (filenameLabel.getText().endsWith(".wxx")) {
                        new FileSaveLoad(worldographer).loadFile(new File(filenameLabel.getText()), false, Integer.MAX_VALUE, Integer.MAX_VALUE, 0, false);
                    } else {
                        Alert imgdialog = new Alert(Alert.AlertType.INFORMATION);
                        imgdialog.setTitle("Image");
                        imgdialog.setResizable(true);
                        imgdialog.setHeaderText(filenameLabel.getText());
                        String filename = filenameLabel.getText();
                        try {
                            BufferedImage bufferedImage = ImageIO.read(new File(filename));
                            WritableImage img = SwingFXUtils.toFXImage((BufferedImage)bufferedImage, null);
                            ImageView iv = new ImageView((Image)img);
                            ScrollPane sp = new ScrollPane();
                            sp.setContent((Node)iv);
                            sp.setPrefSize(600.0, 400.0);
                            imgdialog.getDialogPane().setContent((Node)sp);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        imgdialog.show();
                    }
                });
                filebox.getChildren().add((Object)openbutton);
                grid.add((Node)filebox, 1, 2);
                if (worldographer.getMapUI().getViewLevel() == ViewLevel.WORLD) break block9;
                if (worldographer.getMapUI().getViewLevel() == ViewLevel.CONTINENT) break block9;
                if (worldographer.getMapUI().getViewLevel() == ViewLevel.KINGDOM) break block9;
                if (worldographer.getMapUI().getViewLevel() != ViewLevel.PROVINCE) break block10;
            }
            grid.add((Node)new Label("View Levels:"), 0, 4);
            this.worldCheckBox.setSelected(note.isWorld());
            this.continentCheckBox.setSelected(note.isContinent());
            this.kingdomCheckBox.setSelected(note.isKingdom());
            this.provinceCheckBox.setSelected(note.isProvince());
            HBox box = new HBox(new Node[]{this.worldCheckBox, this.continentCheckBox, this.kingdomCheckBox, this.provinceCheckBox});
            grid.add((Node)box, 1, 4);
        }
        TabPane tabPane = new TabPane();
        grid.add((Node)tabPane, 0, 5, 2, 1);
        this.addTabPanes(note, details, tabPane);
        if (note.getParent() != null && note.getParent() instanceof Feature) {
            Feature f = note.getParent();
            Button regenDetails = new Button("Regenerate Details");
            regenDetails.setOnAction(event -> {
                Dialog d = new Dialog();
                d.setTitle("Confirm Replacing Details");
                d.setHeaderText("Confirm Replacing Details.");
                d.getDialogPane().setContent((Node)new Label("Regenerating Details will delete the existing text.  Do you wish to continue?"));
                ButtonType yes = new ButtonType("OK");
                ButtonType cancel = new ButtonType("Cancel");
                d.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{yes, cancel});
                Optional result = d.showAndWait();
                if (result.isPresent() && result.get() == yes) {
                    int selected = tabPane.getSelectionModel().getSelectedIndex();
                    if (note.getDetails() == null || note.getDetails().trim().equals("")) {
                        note.generateNoteInfo(note.getOriginalViewLevel(), f.getTypeName());
                    } else {
                        note.setDetails("");
                        note.generateNoteInfo(note.getOriginalViewLevel(), f.getTypeName());
                        details.setHtmlText(note.getDetails());
                    }
                    tabPane.getTabs().removeAll((Collection)tabPane.getTabs());
                    this.addTabPanes(note, details, tabPane);
                    tabPane.getSelectionModel().select(selected);
                }
            });
            grid.add((Node)regenDetails, 0, 6, 2, 1);
        }
        this.getDialogPane().setContent((Node)grid);
        this.setResultConverter(dialogButton -> {
            if (dialogButton == saveButtonType) {
                Worldographer.getMapUI().getController().getUndoRedoHandler().setChanged(true);
                note.setTitle(title.getText());
                if (note.getTableData() != null) {
                    TreeMap<String, NoteTable> newNoteTables = new TreeMap<String, NoteTable>();
                    for (String tablekey : note.getTableData().keySet()) {
                        NoteTable oldnt = note.getTableData().get(tablekey);
                        TableData newheadings = new TableData(NoteDialog.swapOutSmartQuotes(oldnt.getHeadings().getA()), NoteDialog.swapOutSmartQuotes(oldnt.getHeadings().getB()), NoteDialog.swapOutSmartQuotes(oldnt.getHeadings().getC()), NoteDialog.swapOutSmartQuotes(oldnt.getHeadings().getD()), NoteDialog.swapOutSmartQuotes(oldnt.getHeadings().getE()), NoteDialog.swapOutSmartQuotes(oldnt.getHeadings().getF()), NoteDialog.swapOutSmartQuotes(oldnt.getHeadings().getG()), NoteDialog.swapOutSmartQuotes(oldnt.getHeadings().getH()));
                        ArrayList<TableData> data = new ArrayList<TableData>();
                        for (TableData olddata : oldnt.getData()) {
                            data.add(new TableData(NoteDialog.swapOutSmartQuotes(olddata.getA()), NoteDialog.swapOutSmartQuotes(olddata.getB()), NoteDialog.swapOutSmartQuotes(olddata.getC()), NoteDialog.swapOutSmartQuotes(olddata.getD()), NoteDialog.swapOutSmartQuotes(olddata.getE()), NoteDialog.swapOutSmartQuotes(olddata.getF()), NoteDialog.swapOutSmartQuotes(olddata.getG()), NoteDialog.swapOutSmartQuotes(olddata.getH())));
                        }
                        newNoteTables.put(tablekey, new NoteTable(newheadings, (ObservableList<TableData>)FXCollections.observableArrayList(data)));
                    }
                    note.setTableData(newNoteTables);
                }
                note.setDetails(NoteDialog.swapOutSmartQuotes(details.getHtmlText()));
                note.setWorld(this.worldCheckBox.isSelected());
                note.setContinent(this.continentCheckBox.isSelected());
                note.setKingdom(this.kingdomCheckBox.isSelected());
                note.setProvince(this.provinceCheckBox.isSelected());
                note.setColor((Color)colorpicker.getValue());
                note.setFilename(filenameLabel.getText());
                UndoActionGroup uag = new UndoActionGroup();
                worldographer.getMapUI().getMapData().addNewNote(worldographer.getMapUI().getViewLevel(), uag, note);
                worldographer.getMapUI().getController().getUndoRedoHandler().push(uag);
                this.close();
            } else if (dialogButton == deleteButtonType) {
                StyledDialog d = new StyledDialog(true, (Window)worldographer.getPrimaryStage(), "Confirm Delete");
                d.setHeaderText("Confirm Delete.");
                d.getDialogPane().setContent((Node)new Label("Are you sure you wish to delete this note?"));
                ButtonType yes = new ButtonType("OK");
                ButtonType cancel = new ButtonType("Cancel");
                d.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{yes, cancel});
                Optional result = d.showAndWait();
                if (result.isPresent() && result.get() == yes) {
                    UndoActionGroup uag = new UndoActionGroup();
                    worldographer.getMapUI().getController().deleteNote(note, uag);
                    worldographer.getMapUI().getController().getUndoRedoHandler().push(uag);
                    this.close();
                }
            } else if (dialogButton == cancelButtonType) {
                this.close();
            }
            return null;
        });
    }

    private static String swapOutSmartQuotes(String detailsText) {
        detailsText = detailsText.replaceAll("\u2019", "'");
        detailsText = detailsText.replaceAll("\u2018", "'");
        detailsText = detailsText.replaceAll("\u201c", "\"");
        if ((detailsText = detailsText.replaceAll("\u201d", "\"")).contains("\u0002")) {
            System.out.println("found it");
        }
        detailsText = detailsText.replaceAll("\u0002", "");
        return detailsText;
    }

    private void addTabPanes(Note note, HTMLEditor details, TabPane tabPane) {
        tabPane.getTabs().add((Object)new Tab("Details", (Node)details));
        for (String key : note.getTableData().keySet()) {
            TableView tableview = new TableView();
            tableview.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
            KeyCodeCombination keyCodeCopy = new KeyCodeCombination(KeyCode.C, new KeyCombination.Modifier[]{KeyCombination.CONTROL_ANY});
            tableview.setOnKeyPressed(event -> {
                if (keyCodeCopy.match(event)) {
                    this.copySelectionToClipboard(tableview);
                }
            });
            tableview.setOnMouseClicked(event -> {
                if (event.isPopupTrigger()) {
                    ContextMenu cm = new ContextMenu();
                    MenuItem copy = new MenuItem("Copy");
                    copy.setOnAction(evt -> this.copySelectionToClipboard(tableview));
                    cm.getItems().add((Object)copy);
                    cm.show((Node)tableview, event.getScreenX(), event.getScreenY());
                }
            });
            BorderPane bp = new BorderPane();
            bp.setCenter((Node)tableview);
            tableview.setEditable(true);
            TableData columns = note.getTableData().get(key).getHeadings();
            TableColumn<TableData, String> aCol = this.createTableColumn(columns, "a");
            TableColumn<TableData, String> bCol = this.createTableColumn(columns, "b");
            TableColumn<TableData, String> cCol = this.createTableColumn(columns, "c");
            TableColumn<TableData, String> dCol = this.createTableColumn(columns, "d");
            TableColumn<TableData, String> eCol = this.createTableColumn(columns, "e");
            TableColumn<TableData, String> fCol = this.createTableColumn(columns, "f");
            TableColumn<TableData, String> gCol = this.createTableColumn(columns, "g");
            TableColumn<TableData, String> hCol = this.createTableColumn(columns, "h");
            tableview.getColumns().addAll((Object[])new TableColumn[]{aCol, bCol, cCol, dCol, eCol, fCol, gCol, hCol});
            tableview.setItems(note.getTableData().get(key).getData());
            GridPane gp = new GridPane();
            tabPane.getTabs().add((Object)new Tab(key, (Node)bp));
            if (note.getParent() != null && note.getParent() instanceof Feature) {
                Feature f = note.getParent();
                Button regentabbutton = new Button("Regenerate Tab");
                regentabbutton.setOnAction(event -> {
                    Dialog d = new Dialog();
                    d.setTitle("Confirm Replacing Details");
                    d.setHeaderText("Confirm Replacing Details.");
                    d.getDialogPane().setContent((Node)new Label("Regenerating Details will delete the existing text.  Do you wish to continue?"));
                    ButtonType yes = new ButtonType("OK");
                    ButtonType cancel = new ButtonType("Cancel");
                    d.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{yes, cancel});
                    Optional result = d.showAndWait();
                    if (result.isPresent() && result.get() == yes) {
                        int selected = tabPane.getSelectionModel().getSelectedIndex();
                        if (note.getDetails() == null || note.getDetails().trim().equals("")) {
                            note.generateNoteInfo(note.getOriginalViewLevel(), f.getTypeName(), key);
                        } else {
                            note.setDetails("");
                            note.generateNoteInfo(note.getOriginalViewLevel(), f.getTypeName());
                            details.setHtmlText(note.getDetails());
                        }
                        tabPane.getTabs().removeAll((Collection)tabPane.getTabs());
                        this.addTabPanes(note, details, tabPane);
                        tabPane.getSelectionModel().select(selected);
                    }
                });
                gp.add((Node)regentabbutton, 1, 0);
            }
            Button addrowbutton = new Button("Add Row");
            addrowbutton.setOnAction(e -> note.getTableData().get(key).getData().add((Object)new TableData("new row", "", "", "", "", "", "", "")));
            gp.setAlignment(Pos.CENTER);
            gp.add((Node)addrowbutton, 2, 0);
            bp.setBottom((Node)gp);
        }
    }

    private TableColumn<TableData, String> createTableColumn(TableData columns, String col) {
        TableColumn aCol = switch (col) {
            case "a" -> new TableColumn(columns.getA());
            case "b" -> new TableColumn(columns.getB());
            case "c" -> new TableColumn(columns.getC());
            case "d" -> new TableColumn(columns.getD());
            case "e" -> new TableColumn(columns.getE());
            case "f" -> new TableColumn(columns.getF());
            case "g" -> new TableColumn(columns.getG());
            default -> new TableColumn(columns.getH());
        };
        aCol.setCellValueFactory((Callback)new PropertyValueFactory(col));
        Callback cellFactory = p -> new EditingCell();
        aCol.setCellFactory(cellFactory);
        aCol.setOnEditCommit(t -> {
            switch (col) {
                case "a": {
                    ((TableData)t.getTableView().getItems().get(t.getTablePosition().getRow())).setA((String)t.getNewValue());
                    break;
                }
                case "b": {
                    ((TableData)t.getTableView().getItems().get(t.getTablePosition().getRow())).setB((String)t.getNewValue());
                    break;
                }
                case "c": {
                    ((TableData)t.getTableView().getItems().get(t.getTablePosition().getRow())).setC((String)t.getNewValue());
                    break;
                }
                case "d": {
                    ((TableData)t.getTableView().getItems().get(t.getTablePosition().getRow())).setD((String)t.getNewValue());
                    break;
                }
                case "e": {
                    ((TableData)t.getTableView().getItems().get(t.getTablePosition().getRow())).setE((String)t.getNewValue());
                    break;
                }
                case "f": {
                    ((TableData)t.getTableView().getItems().get(t.getTablePosition().getRow())).setF((String)t.getNewValue());
                    break;
                }
                case "g": {
                    ((TableData)t.getTableView().getItems().get(t.getTablePosition().getRow())).setG((String)t.getNewValue());
                    break;
                }
                default: {
                    ((TableData)t.getTableView().getItems().get(t.getTablePosition().getRow())).setH((String)t.getNewValue());
                }
            }
        });
        return aCol;
    }

    public void copySelectionToClipboard(TableView<?> table) {
        TreeSet<Integer> rows = new TreeSet<Integer>();
        for (TablePosition tablePosition : table.getSelectionModel().getSelectedCells()) {
            rows.add(tablePosition.getRow());
        }
        StringBuilder strb = new StringBuilder();
        boolean firstRow = true;
        for (Integer row : rows) {
            if (!firstRow) {
                strb.append('\n');
            }
            firstRow = false;
            boolean firstCol = true;
            for (TableColumn column : table.getColumns()) {
                if (!firstCol) {
                    strb.append('\t');
                }
                firstCol = false;
                Object cellData = column.getCellData(row.intValue());
                strb.append(cellData == null ? "" : cellData.toString());
            }
        }
        ClipboardContent clipboardContent = new ClipboardContent();
        clipboardContent.putString(strb.toString());
        Clipboard.getSystemClipboard().setContent((Map)clipboardContent);
    }

    static class EditingCell
    extends TableCell<TableData, String> {
        private TextField textField;

        public void startEdit() {
            if (!this.isEmpty()) {
                super.startEdit();
                this.createTextField();
                this.setText(null);
                this.setGraphic((Node)this.textField);
                this.textField.selectAll();
            }
        }

        public void cancelEdit() {
            super.cancelEdit();
            this.setText((String)this.getItem());
            this.setGraphic(null);
        }

        public void updateItem(String item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
            } else if (this.isEditing()) {
                if (this.textField != null) {
                    this.textField.setText(this.getString());
                }
                this.setText(null);
                this.setGraphic((Node)this.textField);
            } else {
                this.setText(this.getString());
                this.setGraphic(null);
            }
        }

        private void createTextField() {
            this.textField = new TextField(this.getString());
            this.textField.setMinWidth(this.getWidth() - this.getGraphicTextGap() * 2.0);
            this.textField.focusedProperty().addListener((arg0, arg1, arg2) -> {
                if (!arg2.booleanValue()) {
                    this.commitEdit(this.textField.getText());
                }
            });
        }

        private String getString() {
            return this.getItem() == null ? "" : (String)this.getItem();
        }
    }
}

