/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.ui.dialog;

import com.inkwellideas.ographer.data.CheckUtils;
import com.inkwellideas.ographer.io.FileSaveLoad;
import com.inkwellideas.ographer.io.UserPrefs;
import com.inkwellideas.ographer.map.Terrain;
import com.inkwellideas.ographer.model.Feature;
import com.inkwellideas.ographer.model.FeatureType;
import com.inkwellideas.ographer.model.TerrainType;
import com.inkwellideas.ographer.model.TextureType;
import com.inkwellideas.ographer.ui.widget.StyledDialog;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Optional;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.stage.Window;

public class OtherDialog {
    public void showOtherDialog(Stage parentStage) {
        String s = UserPrefs.PREFS.get("lik2025", "");
        boolean valid = CheckUtils.check2025Dates(s);
        boolean haderror = false;
        while (!valid) {
            Alert alert;
            StyledDialog d = new StyledDialog(true, (Window)parentStage, "Generate Roads");
            d.setTitle("Worldographer 2025 Key/Code");
            d.setHeaderText("Do you have a license key/code?");
            VBox vbox = new VBox();
            if (haderror) {
                vbox.getChildren().add((Object)new Label("Your license key didn't work.  Double check 1's vs. L's and 0's vs O's.\n"));
            }
            vbox.getChildren().add((Object)new Label("Worldographer 2025 has many new features, behind-the-scenes changes, and UI\nimprovements. So the pro version does require a new key license key. \nHowever, it is one key for making any type of map (world/region maps, battlemats,\ncosmic/star maps, and city/village maps.\n "));
            TextField tf = new TextField("");
            HBox hbox = new HBox(new Node[]{new Label("Enter key/code: "), tf});
            hbox.setAlignment(Pos.CENTER);
            vbox.getChildren().add((Object)hbox);
            d.getDialogPane().setContent((Node)vbox);
            ButtonType yes = new ButtonType("OK");
            ButtonType no = new ButtonType("No (Free/Trial Mode)", ButtonBar.ButtonData.CANCEL_CLOSE);
            d.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{yes, no});
            Optional result = d.showAndWait();
            if (result.isPresent() && result.get() == yes) {
                s = tf.getText().trim();
                valid = CheckUtils.check2025Dates(s);
                if (valid) {
                    UserPrefs.PREFS.put("lik2025", s);
                    FileSaveLoad.flushPrefs();
                    alert = new Alert(Alert.AlertType.INFORMATION);
                    alert.setTitle("License Accepted");
                    alert.setContentText("Your license key was accepted.\n\nThank you for supporting the many hours\nof development behind Worldographer!\n");
                    alert.showAndWait();
                    continue;
                }
                haderror = true;
                continue;
            }
            alert = new Alert(Alert.AlertType.INFORMATION);
            alert.setTitle("Free/Trial Mode");
            alert.setContentText("No license detected. Defaulting to the 'free' version.\n\nYou'll need a pro license to use the 'power-user' features such as:\n* World/Region Map levels: drill down to add detail.\n* Configuring terrain, features, textures, grid.\n* Expanding/Reducing columns & rows of terrain.\n* Add Notes to the map.\n* Generate coasts, rivers, and nations quickly.\n* Trace an under-laid image.\n* Terrain Wizard (fill in a partly blank map).\n* Generate settlement maps with over 5000 people.\n* Specialty battlemat maps for stores, taverns, etc.\n* A room generator for battlemats.\n\nAnd a license supports continued development.\n\nGet a license at https://store.inkwellideas.com.\nThen enter a license here or use the File menu's Check/Update License.\n");
            alert.showAndWait();
            break;
        }
        if (valid) {
            try {
                URL propsURL = new URL("http://www.worldographer.com/world-con/" + s + ".txt");
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(propsURL.openStream()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (UserPrefs.FULL = valid) {
            TextureType.loadUserTextures(UserPrefs.CONFIG_FOLDER);
        }
        if (UserPrefs.FULL) {
            TerrainType.loadUserTerrain(Terrain.DEFAULT_TERRAIN, UserPrefs.CONFIG_FOLDER);
        }
        if (UserPrefs.FULL) {
            FeatureType.loadUserFeatures(Feature.DEFAULT_FEATURES, UserPrefs.CONFIG_FOLDER);
            Feature.featureTypes.putAll(Feature.DEFAULT_FEATURES);
        }
    }
}

