/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.ui.dialog;

import com.inkwellideas.ographer.data.MapLayer;
import com.inkwellideas.ographer.generator.city.CityDataGenerator;
import com.inkwellideas.ographer.io.LoadGeneratorData;
import com.inkwellideas.ographer.io.UserPrefs;
import com.inkwellideas.ographer.map.MapDataSetup;
import com.inkwellideas.ographer.task.GenerateCityTask;
import com.inkwellideas.ographer.ui.Worldographer;
import com.inkwellideas.ographer.ui.dialog.StartNewMapDialog;
import com.inkwellideas.ographer.ui.toolbox.LayersToolbox;
import com.inkwellideas.ographer.ui.widget.StyledDialog;
import java.io.InputStream;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.stage.Window;

public class StartNewCityDialog {
    public void startNewCityMap(MapDataSetup setup, Worldographer worldographer) {
        this.startNewCityMap(setup, worldographer.layersToolbox, worldographer);
    }

    public void startNewCityMap(MapDataSetup setup, LayersToolbox layersToolbox, Worldographer worldographer) {
        Integer pop = setup.city.population;
        if (pop > 5000 && !UserPrefs.FULL) {
            setup.city.population = 5000;
            StyledDialog d = new StyledDialog(true, (Window)worldographer.getPrimaryStage(), "Population Limit");
            d.setHeaderText("Population Limit - Using 5000 Instead");
            Label statusLabel = new Label("No license detected. Defaulting to the 'free' version.\n\nYou'll need a pro license to use the 'power-user' features such as:\n* World/Region Map levels: drill down to add detail.\n* Configuring terrain, features, textures, grid.\n* Expanding/Reducing columns & rows of terrain.\n* Add Notes to the map.\n* Generate coasts, rivers, and nations quickly.\n* Trace an under-laid image.\n* Terrain Wizard (fill in a partly blank map).\n* Generate settlement maps with over 5000 people.\n* Specialty battlemat maps for stores, taverns, etc.\n* A room generator for battlemats.\n\nAnd a license supports continued development.\n\nGet a license at https://store.inkwellideas.com.\nThen enter a license here or use the File menu's Check/Update License.\n");
            d.getDialogPane().setContent((Node)statusLabel);
            ButtonType ok = new ButtonType("OK");
            d.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ok});
            d.showAndWait();
        }
        new StartNewMapDialog().startNewMap(setup, worldographer);
        MapLayer vegLayer = worldographer.getMapUI().getMapData().getMapLayer("Vegetation");
        if (vegLayer == null) {
            vegLayer = new MapLayer("Vegetation");
            List<MapLayer> layers = worldographer.getMapUI().getMapData().getMapLayers();
            for (int i = 0; i < layers.size(); ++i) {
                if (!layers.get(i).getName().equals("Features")) continue;
                layers.add(i + 1, vegLayer);
                worldographer.getMapUI().getMapData().getMapLayers().add(i, vegLayer);
                layersToolbox.layersTableView.getItems().add(i + 1, (Object)vegLayer);
                break;
            }
        }
        if (CityDataGenerator.settlementData.buildings.size() == 0) {
            try {
                InputStream is = new LoadGeneratorData().getCityMedieval();
                CityDataGenerator.parseSettings(is, false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (setup.city.dontGenerate) {
            return;
        }
        GenerateCityTask generateCityTask = new GenerateCityTask(setup, worldographer, GenerateCityTask.CITYGEN.ALL, worldographer.getMapUI());
        generateCityTask.setOnSucceeded(wse -> {
            worldographer.getCancelButton().setDisable(true);
            worldographer.addStatus("City/town complete. Building placement fail reasons: coast/river:" + GenerateCityTask.buildingFailsCoastRiver + " road:" + GenerateCityTask.buildingFailsRoad + " other building:" + GenerateCityTask.buildingFailsOtherBuilding);
            worldographer.getMapUI().draw();
        });
        worldographer.addStatus("Starting city generator task.");
        new Thread((Runnable)((Object)generateCityTask)).start();
    }
}

