/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.ui.setup;

import com.inkwellideas.ographer.data.HexOrientation;
import com.inkwellideas.ographer.data.LabelStyle;
import com.inkwellideas.ographer.data.ViewLevel;
import com.inkwellideas.ographer.information.Information;
import com.inkwellideas.ographer.io.FileSaveLoad;
import com.inkwellideas.ographer.io.UserPrefs;
import com.inkwellideas.ographer.map.MapDataSetup;
import com.inkwellideas.ographer.map.MapLogic;
import com.inkwellideas.ographer.map.MapProjection;
import com.inkwellideas.ographer.map.MapShape;
import com.inkwellideas.ographer.map.Terrain;
import com.inkwellideas.ographer.model.Feature;
import com.inkwellideas.ographer.model.ShapeStyle;
import com.inkwellideas.ographer.task.GenerateEmpiresTask;
import com.inkwellideas.ographer.task.GenerateMapTask;
import com.inkwellideas.ographer.task.GenerateRegionTask;
import com.inkwellideas.ographer.task.TerrainWizardTask;
import com.inkwellideas.ographer.ui.MapUI;
import com.inkwellideas.ographer.ui.Worldographer;
import com.inkwellideas.ographer.ui.dialog.StandardDialog;
import com.inkwellideas.ographer.ui.dialog.StartNewMapDialog;
import com.inkwellideas.ographer.ui.widget.FocusSpinner;
import com.inkwellideas.ographer.ui.widget.PopupStage;
import com.inkwellideas.ographer.undo.UndoActionGroup;
import com.inkwellideas.ographer.util.SafePreferences;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Spinner;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.util.Pair;

public class SetupWorldRegionScreen
extends PopupStage {
    String[][] defaultTerrain = new String[][]{{"Classic/Flat Desert Rocky", "Desert is added late in the process."}, {"Classic/Flat Desert Sandy", "Slightly varying desert added late in the process."}, {"Classic/Flat Grassland", "Some farmland is replaced as clusters of grassland"}, {"Classic/Flat Farmland", "Land masses are added to the world as farmland"}, {"Classic/Flat Forest Deciduous", "Forest is placed after Mountains are determined."}, {"Classic/Flat Forest Deciduous Heavy", "Some forest new the center of forest clusters is made 'heavy'."}, {"Classic/Hills Forest Deciduous", "Forest placed on hills is forested hills (hills are generated earlier)."}, {"Classic/Mountains Forest Deciduous", "Forest placed on mountains (generated earlier) = forested mountains."}, {"Classic/Flat Forest Jungle", "Forest near the equator & depending on 'Tropical' setting = jungle."}, {"Classic/Flat Forest Jungle Heavy", "Heavy Forest = jungle if near the equator & 'Tropical' setting."}, {"Classic/Hills Forest Jungle", "Forested Hills =  jungle if near the equator & 'Tropical' setting"}, {"Classic/Mountains Forest Jungle", "Forested Mountains = jungle if near the equator & 'Tropical' setting"}, {"Classic/Flat Forest Evergreen", "Forest near the poles and depending on 'Icy' setting = evergreen."}, {"Classic/Flat Forest Evergreen Heavy", "Heavy Forest near the poles and depending on 'Icy' setting = evergreen."}, {"Classic/Hills Forest Evergreen", "Forested Hills near the poles and depending on 'Icy' setting = evergreen."}, {"Classic/Mountains Forest Evergreen", "Forested Mountains near the poles and depending on 'Icy' setting = evergreen."}, {"Classic/Hills", "When placing land, if masses overlap = hills.  Lines of hills are also added."}, {"Classic/Mountains", "When placing land, if land overlaps hills = mountains. More lines are adeded."}, {"Classic/Flat Swamp", "Some coastal forests are made swamp based on the 'Swamp' setting."}, {"Classic/Flat Moor", "Some icy/cold coastal forests are made into moors based on the 'Swamp' setting"}, {"Classic/Other Badlands", "A few hills are converted into badlands."}, {"Classic/Water Ocean", "The map starts as all ocean."}};
    private Stage popupStage;
    private final Worldographer worldographer;
    private final Spinner<Integer> hexesWideSpinner = new FocusSpinner<Integer>(1, 10000, 100);
    private final Spinner<Integer> hexesHighSpinner = new FocusSpinner<Integer>(1, 10000, 50);
    private final Spinner<Double> hexWidthSpinner = new FocusSpinner<Double>(1.0, 100000.0, 46.18);
    private final Spinner<Double> hexHeightSpinner = new FocusSpinner<Double>(1.0, 100000.0, 40.0);
    private final Spinner<Integer> triangleSizeSpinner = new FocusSpinner<Integer>(1, 1000, 12);
    private final Spinner<Integer> seedSpinner = new FocusSpinner<Integer>(1, 1000000, (int)(Math.random() * 1000000.0));
    private final RadioButton oneTerrainButton = new RadioButton("All one terrain:");
    private final RadioButton genTerrainButton = new RadioButton("Generate terrain:");
    private final RadioButton isFullWorldButton = new RadioButton("Is a full world");
    private final RadioButton isRegionButton = new RadioButton("Is one region");
    public static final String SMALL_ISLANDS = "Small Islands";
    public static final String SMALL_CONTINENTS = "Islands & Small Continents";
    public static final String CONTINENTS = "Continents & Some Islands";
    public static final String LARGE_CONTINENTS = "Mostly Large Continents";
    private final String[] landForms = new String[]{"Small Islands", "Islands & Small Continents", "Continents & Some Islands", "Mostly Large Continents"};
    private final Spinner<Integer> landFrequencyCombo = new FocusSpinner<Integer>(0, 100, 30);
    private final Spinner<Integer> mountainFrequencyCombo = new FocusSpinner<Integer>(0, 100, 30);
    private final Spinner<Integer> vegetationFrequencyCombo = new FocusSpinner<Integer>(0, 100, 30);
    private final Spinner<Integer> desertFrequencyCombo = new FocusSpinner<Integer>(0, 100, 30);
    private final Spinner<Integer> swampFrequencyCombo = new FocusSpinner<Integer>(0, 100, 30);
    private final Spinner<Integer> swampContinueFrequencyCombo = new FocusSpinner<Integer>(0, 100, 30);
    private final Spinner<Integer> icyCombo = new FocusSpinner<Integer>(0, 100, 30);
    private final Spinner<Integer> tropicalCombo = new FocusSpinner<Integer>(0, 100, 30);
    private final Spinner<Integer> numNationsCombo = new FocusSpinner<Integer>(1, 100, 30);
    private final ComboBox<String> landFormsCombo = new ComboBox(FXCollections.observableArrayList((Object[])this.landForms));
    private final Spinner<Integer> clusterCombo = new FocusSpinner<Integer>(0, 100, 50);
    private final CheckBox clusterDrift = new CheckBox("Allow Drift");
    private final ComboBox<HexOrientation> orientationCombo = new ComboBox();
    private final ComboBox<MapProjection> projectionCombo = new ComboBox();
    private final ComboBox<ViewLevel> viewLevelCombo = new ComboBox();
    private final CheckBox useSuggestedPixelSizes = new CheckBox("Use Suggested Pixel Sizes:");
    private final ComboBox<String> terrainCombo = new ComboBox(FXCollections.observableArrayList(Terrain.DEFAULT_TERRAIN.keySet()));
    private final ComboBox<TerrainStyle> terrainStyleCombo = new ComboBox(FXCollections.observableArrayList((Object[])new TerrainStyle[]{TerrainStyle.Classic, TerrainStyle.Isometric}));
    private final Canvas previewCanvas = new Canvas();
    private final Label previewNoteLabel = new Label(" (Auto-updates if tiles wide & high <= 1000.)");
    private Label previewStatusLabelx;
    SafePreferences prefs = new SafePreferences("com/inkwellideas/worldographer2025");
    MapDataSetup setup = null;
    final List<Pair<String, Double[]>> terrainToProbabilities = new ArrayList<Pair<String, Double[]>>();
    List<ComboBox<String>> regionTerrainTypeCombos = new ArrayList<ComboBox<String>>();
    List<ComboBox<String>> worldTerrainTypeCombos = new ArrayList<ComboBox<String>>();
    FocusSpinner<Double>[][] regionTerrainPercentSpinners = null;
    Label[] regionLastColumnLabels = null;
    CheckBox coastsCheckBox = new CheckBox("Generate Coasts:");
    ComboBox<String> coastsCombo;
    CheckBox seaCheckBox = new CheckBox("Convert Coastal Ocean Hexes to Sea");
    CheckBox riverCheckBox = new CheckBox("Generate Rivers  #/10000 tiles:");
    private final Spinner<Integer> riverSpinner = new FocusSpinner<Integer>(0, 100, 10);
    CheckBox empiresCheckBox = new CheckBox("Generate Empires");
    private final Spinner<Integer> empireSizeSpinner = new FocusSpinner<Integer>(0, 1000, 25);
    private final Spinner<Integer> distanceBetweenFeaturesSpinner = new Spinner(2, 10, 3);
    private CheckBox empiresOneColorCheckBox = new CheckBox("All one color?");
    private ColorPicker empiresColorPicker = new ColorPicker(Color.DARKRED);
    private CheckBox empiresTranslucencyCheckbox = new CheckBox("Translucent Fill");
    CheckBox roadsCheckBox = new CheckBox("Generate Roads");
    ColorPicker roadsColorPicker = new ColorPicker(Color.color((double)0.1, (double)0.1, (double)0.1));
    String[] lineOptions = new String[]{"Straight", "Fractal-ish", "Curves"};
    ComboBox<String> roadStyleOptionsComboBox = new ComboBox(FXCollections.observableArrayList((Object[])this.lineOptions));
    CheckBox roadsVillagesCheckBox = new CheckBox("Villages/Forts");
    CheckBox roadsRuinsCheckBox = new CheckBox("Ruins");
    ColorPicker roadsSecondaryColorPicker = new ColorPicker(Color.TAN);
    CheckBox hexCrawlCheckBox = new CheckBox("Generate Hex Crawl ");
    private final Spinner<Integer> hexCrawlLandChanceeSpinner = new FocusSpinner<Integer>(0, 100, 15);
    private final Spinner<Integer> hexCrawlWaterChanceeSpinner = new FocusSpinner<Integer>(0, 100, 2);
    String[] riverTypes = new String[]{"Features", "Shapes - Classic", "Shapes - Textured"};
    private final ComboBox<String> riverTypeCombo = new ComboBox(FXCollections.observableArrayList((Object[])this.riverTypes));
    long lastPreviewSent = 0L;
    Task<Map> priorTask = null;

    public SetupWorldRegionScreen(Worldographer ms) {
        this.worldographer = ms;
        Double[] d1 = new Double[]{26.0, 10.0, 5.0, 5.0, 5.0, 1.0, 1.0, 1.0, 5.0, 4.0, 37.0};
        this.terrainToProbabilities.add((Pair<String, Double[]>)new Pair((Object)"Classic/Flat Desert Rocky", (Object)d1));
        Double[] d2 = new Double[]{10.0, 26.0, 5.0, 5.0, 5.0, 1.0, 1.0, 1.0, 5.0, 4.0, 37.0};
        this.terrainToProbabilities.add((Pair<String, Double[]>)new Pair((Object)"Classic/Flat Desert Sandy", (Object)d2));
        Double[] d3 = new Double[]{4.0, 4.0, 26.0, 6.0, 6.0, 4.0, 4.0, 1.0, 3.0, 3.0, 39.0};
        this.terrainToProbabilities.add((Pair<String, Double[]>)new Pair((Object)"Classic/Flat Grassland", (Object)d3));
        Double[] d4 = new Double[]{2.0, 2.0, 11.0, 30.0, 5.0, 5.0, 3.0, 3.0, 2.0, 2.0, 35.0};
        this.terrainToProbabilities.add((Pair<String, Double[]>)new Pair((Object)"Classic/Flat Farmland", (Object)d4));
        Double[] d5 = new Double[]{2.0, 2.0, 5.0, 8.0, 18.0, 9.0, 8.0, 7.0, 3.0, 3.0, 35.0};
        this.terrainToProbabilities.add((Pair<String, Double[]>)new Pair((Object)"Classic/Flat Forest Deciduous", (Object)d5));
        Double[] d6 = new Double[]{2.0, 2.0, 5.0, 7.0, 10.0, 14.0, 8.0, 8.0, 3.0, 3.0, 38.0};
        this.terrainToProbabilities.add((Pair<String, Double[]>)new Pair((Object)"Classic/Flat Forest Deciduous Heavy", (Object)d6));
        Double[] d7 = new Double[]{3.0, 3.0, 5.0, 5.0, 6.0, 6.0, 16.0, 8.0, 8.0, 6.0, 34.0};
        this.terrainToProbabilities.add((Pair<String, Double[]>)new Pair((Object)"Classic/Hills Forest Deciduous", (Object)d7));
        Double[] d8 = new Double[]{3.0, 3.0, 5.0, 5.0, 6.0, 6.0, 8.0, 16.0, 6.0, 8.0, 34.0};
        this.terrainToProbabilities.add((Pair<String, Double[]>)new Pair((Object)"Classic/Mountains Forest Deciduous", (Object)d8));
        Double[] d9 = new Double[]{4.0, 4.0, 6.0, 4.0, 4.0, 4.0, 10.0, 6.0, 18.0, 6.0, 34.0};
        this.terrainToProbabilities.add((Pair<String, Double[]>)new Pair((Object)"Classic/Hills", (Object)d9));
        Double[] d10 = new Double[]{4.0, 4.0, 6.0, 4.0, 4.0, 4.0, 6.0, 10.0, 6.0, 18.0, 34.0};
        this.terrainToProbabilities.add((Pair<String, Double[]>)new Pair((Object)"Classic/Mountains", (Object)d10));
        Double[] d11 = new Double[]{0.0, 0.0, 0.5, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 92.5};
        this.terrainToProbabilities.add((Pair<String, Double[]>)new Pair((Object)"Classic/Water Ocean", (Object)d11));
    }

    public void start(Stage popStage) {
        this.popupStage = popStage;
        this.popupStage.setTitle("Worldographer World/Kingdom Setup Screen");
        BorderPane border = new BorderPane();
        border.setPadding(new Insets(4.0, 4.0, 4.0, 4.0));
        border.setLeft((Node)this.getSizePane());
        border.setCenter((Node)this.getPreviewPane());
        border.setRight((Node)this.getTerrainPane());
        Button generateButton = new Button("Generate Map");
        generateButton.setOnAction(e -> this.callGenerateMapTask(this.popupStage, false));
        GridPane grid = new GridPane();
        grid.setAlignment(Pos.CENTER_RIGHT);
        grid.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        grid.add((Node)generateButton, 0, 1);
        border.setBottom((Node)grid);
        ScrollPane sp = new ScrollPane();
        sp.setContent((Node)border);
        Pane root = new Pane(new Node[]{sp});
        int width = 1024;
        int height = 780;
        this.setLocationAndPopup(root, width, height, this.worldographer, this.popupStage);
        this.callGenerateMapTask(this.popupStage, true);
    }

    private void callGenerateMapTask(Stage primaryStage, boolean preview) {
        this.callGenerateMapTask(primaryStage, preview, false);
    }

    private void callGenerateMapTask(Stage primaryStage, boolean preview, boolean userInitiated) {
        if (preview && !userInitiated) {
            if (MapProjection.FLAT.equals(this.projectionCombo.getValue()) && ((Integer)this.hexesWideSpinner.getValue() > 1000 || (Integer)this.hexesHighSpinner.getValue() > 1000)) {
                return;
            }
            if (MapProjection.ICOSAHEDRAL.equals(this.projectionCombo.getValue()) && (Integer)this.triangleSizeSpinner.getValue() > 50) {
                return;
            }
        }
        if (this.priorTask != null) {
            System.out.println("killing prior");
            if (this.priorTask.isRunning()) {
                this.priorTask.cancel();
            }
            this.priorTask = null;
        }
        long sendTime = System.nanoTime();
        if (preview) {
            this.lastPreviewSent = sendTime;
        }
        Terrain[][] t = new Terrain[((Integer)this.hexesWideSpinner.getValue()).intValue()][((Integer)this.hexesHighSpinner.getValue()).intValue()];
        if (((MapProjection)((Object)this.projectionCombo.getValue())).equals((Object)MapProjection.ICOSAHEDRAL)) {
            int triangleSize = (Integer)this.triangleSizeSpinner.getValue();
            t = new Terrain[(int)((double)triangleSize * 5.5 + 2.0)][triangleSize * 3 + 1];
        }
        this.setup = new MapDataSetup();
        for (int y = 0; y < t[0].length; ++y) {
            for (int x = 0; x < t.length; ++x) {
                t[x][y] = new Terrain("Empty", true);
            }
        }
        this.setup.sendTime = sendTime;
        this.setup.setTerrainByViewLevel((ViewLevel)((Object)this.viewLevelCombo.getValue()), t);
        this.setup.hexWidth = (Double)this.hexWidthSpinner.getValue();
        this.setup.hexHeight = (Double)this.hexHeightSpinner.getValue();
        this.setup.hexOrientation = (HexOrientation)((Object)this.orientationCombo.getValue());
        this.setup.view.triangleSize = (Integer)this.triangleSizeSpinner.getValue();
        this.setup.mapProjection = (MapProjection)((Object)this.projectionCombo.getValue());
        this.setup.generateOneTerrain = this.genTerrainButton.isSelected();
        this.setup.solidTerrain = (String)this.terrainCombo.getSelectionModel().getSelectedItem();
        this.setup.iconStyle = (TerrainStyle)((Object)this.terrainStyleCombo.getSelectionModel().getSelectedItem());
        this.setup.numNations = (Integer)this.numNationsCombo.getValue();
        this.setup.riverType = (String)this.riverTypeCombo.getValue();
        this.setup.numRivers = this.riverCheckBox.isSelected() ? (Integer)this.riverSpinner.getValue() : 0;
        this.setup.coastType = this.coastsCheckBox.isSelected() ? (String)this.coastsCombo.getSelectionModel().getSelectedItem() : null;
        this.prefs.put("iconStyle", ((TerrainStyle)((Object)this.terrainStyleCombo.getSelectionModel().getSelectedItem())).toString());
        String terrain = (String)this.terrainCombo.getSelectionModel().getSelectedItem();
        if (this.genTerrainButton.isSelected()) {
            terrain = this.isRegionButton.isSelected() ? "Region" : "World";
        }
        this.prefs.put("terrainGen", terrain);
        this.prefs.put("landFrequency", String.valueOf(this.landFrequencyCombo.getValue()));
        this.prefs.put("landForm", (String)this.landFormsCombo.getValue());
        this.prefs.put("clusterx", String.valueOf(this.clusterCombo.getValue()));
        this.prefs.putBoolean("clusterDriftx", this.clusterDrift.isSelected());
        this.prefs.put("mtnFrequency", String.valueOf(this.mountainFrequencyCombo.getValue()));
        this.prefs.put("vegFrequency", String.valueOf(this.vegetationFrequencyCombo.getValue()));
        this.prefs.put("desertFrequency", String.valueOf(this.desertFrequencyCombo.getValue()));
        this.prefs.put("swampFrequency", String.valueOf(this.swampFrequencyCombo.getValue()));
        this.prefs.put("swampContinueFrequency", String.valueOf(this.swampContinueFrequencyCombo.getValue()));
        this.prefs.put("icy", String.valueOf(this.icyCombo.getValue()));
        this.prefs.put("tropical", String.valueOf(this.tropicalCombo.getValue()));
        this.prefs.put("numNations", String.valueOf(this.numNationsCombo.getValue()));
        this.prefs.put("hexOrientation", String.valueOf(this.orientationCombo.getValue()));
        this.prefs.put("mapProjection", String.valueOf(this.projectionCombo.getSelectionModel().getSelectedItem()));
        this.prefs.put("useSuggestedPixelSizes", "" + this.useSuggestedPixelSizes.isSelected());
        this.prefs.put("hexWidth", String.valueOf(this.hexWidthSpinner.getValue()));
        this.prefs.put("hexHeight", String.valueOf(this.hexHeightSpinner.getValue()));
        this.prefs.put("triangleSize", String.valueOf(this.triangleSizeSpinner.getValue()));
        this.prefs.put("hexesWide", String.valueOf(this.hexesWideSpinner.getValue()));
        this.prefs.put("hexesHigh", String.valueOf(this.hexesHighSpinner.getValue()));
        this.prefs.put("initialView", String.valueOf(this.viewLevelCombo.getSelectionModel().getSelectedItem()));
        this.prefs.put("coastType", (String)this.coastsCombo.getValue());
        this.prefs.putBoolean("coastsChecked", this.coastsCheckBox.isSelected());
        this.prefs.putBoolean("coastsConvertOceans", this.seaCheckBox.isSelected());
        this.prefs.putBoolean("riverChecked", this.riverCheckBox.isSelected());
        this.prefs.putInt("riversNumber", (Integer)this.riverSpinner.getValue());
        this.prefs.put("riversType", (String)this.riverTypeCombo.getValue());
        this.prefs.putBoolean("empiresChecked", this.empiresCheckBox.isSelected());
        this.prefs.putInt("empiresNum", (Integer)this.empireSizeSpinner.getValue());
        this.prefs.putBoolean("empiresOneColorChecked", this.empiresOneColorCheckBox.isSelected());
        this.prefs.putBoolean("empiresTranslucencyChecked", this.empiresTranslucencyCheckbox.isSelected());
        this.prefs.put("empireColor", ((Color)this.empiresColorPicker.getValue()).toString());
        this.prefs.putInt("empireFeatureDistances", (Integer)this.distanceBetweenFeaturesSpinner.getValue());
        this.prefs.putBoolean("hexCrawlChecked", this.hexCrawlCheckBox.isSelected());
        this.prefs.putInt("hexCrawlLandChance", (Integer)this.hexCrawlLandChanceeSpinner.getValue());
        this.prefs.putInt("hexCrawlWaterChance", (Integer)this.hexCrawlWaterChanceeSpinner.getValue());
        this.prefs.putBoolean("roadsGenCheckbox", this.roadsCheckBox.isSelected());
        this.prefs.put("roadsColor", ((Color)this.roadsColorPicker.getValue()).toString());
        this.prefs.put("roadStyle", (String)this.roadStyleOptionsComboBox.getValue());
        this.prefs.putBoolean("villagesRoadsCheckbox", this.roadsCheckBox.isSelected());
        this.prefs.putBoolean("ruinsRoadsCheckbox", this.roadsRuinsCheckBox.isSelected());
        this.prefs.put("roadsSecondaryColor", ((Color)this.roadsSecondaryColorPicker.getValue()).toString());
        if (this.genTerrainButton.isSelected()) {
            if (this.isRegionButton.isSelected()) {
                GenerateRegionTask generateRegionTask = new GenerateRegionTask(this.worldographer, this.setup, this.terrainToProbabilities, (TerrainStyle)((Object)this.terrainStyleCombo.getSelectionModel().getSelectedItem()), (ViewLevel)((Object)this.viewLevelCombo.getValue()));
                if (preview) {
                    this.previewStatusLabelx.textProperty().bind((ObservableValue)generateRegionTask.messageProperty());
                }
                generateRegionTask.setOnSucceeded(wse -> {
                    this.setup = (MapDataSetup)generateRegionTask.getValue();
                    Terrain[][] t1 = this.setup.getTerrainByViewLevel((ViewLevel)((Object)((Object)this.viewLevelCombo.getValue())));
                    if (preview) {
                        this.updatePreview(this.setup.sendTime, t1);
                    } else {
                        HashMap<String, LabelStyle> labelStyleMap = new HashMap<String, LabelStyle>();
                        LabelStyle.setupLabelStyles(labelStyleMap, (ViewLevel)((Object)((Object)this.viewLevelCombo.getValue())));
                        this.setup.labelStyles = labelStyleMap;
                        HashMap<String, ShapeStyle> shapeStyleMap = new HashMap<String, ShapeStyle>();
                        ShapeStyle.setupShapeStyles(shapeStyleMap, (ViewLevel)((Object)((Object)this.viewLevelCombo.getValue())));
                        this.setup.shapeStyles = shapeStyleMap;
                        this.setup.setTerrainByViewLevel((ViewLevel)((Object)((Object)this.viewLevelCombo.getValue())), t1);
                        this.setup.setTerrainByViewLevel((ViewLevel)((Object)((Object)this.viewLevelCombo.getValue())), t1);
                        MapLogic.setElevations(t1, (HexOrientation)((Object)((Object)this.orientationCombo.getValue())));
                        ArrayList<Feature> features = new ArrayList<Feature>();
                        this.setup.features = features;
                        MapUI mapUI = new StartNewMapDialog().startNewMap(this.setup, this.worldographer);
                        primaryStage.close();
                        TerrainWizardTask trtask = new TerrainWizardTask(this.worldographer, mapUI.getController().getUndoRedoHandler(), mapUI.viewLevel, mapUI.getMapData().getTerrain(mapUI.viewLevel), true);
                        if (preview) {
                            this.previewStatusLabelx.textProperty().bind((ObservableValue)generateRegionTask.messageProperty());
                        }
                        trtask.addEventFilter(ActionEvent.ACTION, event -> trtask.cancel());
                        trtask.setOnSucceeded(wse1 -> {
                            if (preview) {
                                this.updatePreview(this.setup.sendTime, t1);
                            } else {
                                mapUI.draw();
                            }
                        });
                        new Thread((Runnable)((Object)trtask)).start();
                    }
                });
                new Thread((Runnable)((Object)generateRegionTask)).start();
            } else {
                HashMap<String, String> terrainSubstitutions = new HashMap<String, String>();
                for (int i = 0; i < this.worldTerrainTypeCombos.size(); ++i) {
                    if (((String)this.worldTerrainTypeCombos.get(i).getSelectionModel().getSelectedItem()).equals(this.defaultTerrain[i][0])) continue;
                    terrainSubstitutions.put(this.defaultTerrain[i][0], (String)this.worldTerrainTypeCombos.get(i).getSelectionModel().getSelectedItem());
                }
                GenerateMapTask generatemaptask = new GenerateMapTask(this.worldographer, this.setup, (ViewLevel)((Object)this.viewLevelCombo.getValue()), (TerrainStyle)((Object)this.terrainStyleCombo.getSelectionModel().getSelectedItem()), (Integer)this.landFrequencyCombo.getValue(), (String)this.landFormsCombo.getValue(), ((Integer)this.clusterCombo.getValue()).intValue(), this.clusterDrift.isSelected(), (Integer)this.mountainFrequencyCombo.getValue(), (Integer)this.vegetationFrequencyCombo.getValue(), (Integer)this.desertFrequencyCombo.getValue(), (Integer)this.swampFrequencyCombo.getValue(), (Integer)this.swampContinueFrequencyCombo.getValue(), (Integer)this.icyCombo.getValue(), (Integer)this.tropicalCombo.getValue(), preview, (Integer)this.seedSpinner.getValue(), terrainSubstitutions);
                if (preview) {
                    this.previewStatusLabelx.textProperty().bind((ObservableValue)generatemaptask.messageProperty());
                }
                generatemaptask.setOnSucceeded(wse -> {
                    this.worldographer.getCancelButton().setDisable(true);
                    this.setup = (MapDataSetup)generatemaptask.getValue();
                    Terrain[][] t12 = this.setup.getTerrainByViewLevel((ViewLevel)((Object)((Object)this.viewLevelCombo.getValue())));
                    if (preview) {
                        this.updatePreview(this.setup.sendTime, t12);
                    } else {
                        HashMap<String, LabelStyle> labelStyleMap = new HashMap<String, LabelStyle>();
                        LabelStyle.setupLabelStyles(labelStyleMap, (ViewLevel)((Object)((Object)this.viewLevelCombo.getValue())));
                        this.setup.labelStyles = labelStyleMap;
                        HashMap<String, ShapeStyle> shapeStyleMap = new HashMap<String, ShapeStyle>();
                        ShapeStyle.setupShapeStyles(shapeStyleMap, (ViewLevel)((Object)((Object)this.viewLevelCombo.getValue())));
                        this.setup.shapeStyles = shapeStyleMap;
                        this.setup.setTerrainByViewLevel((ViewLevel)((Object)((Object)this.viewLevelCombo.getValue())), t12);
                        MapLogic.setElevations(t12, (HexOrientation)((Object)((Object)this.orientationCombo.getValue())));
                        MapUI mapUI = new StartNewMapDialog().startNewMap(this.setup, this.worldographer);
                        if (this.coastsCheckBox.isSelected() || this.riverCheckBox.isSelected() || this.empiresCheckBox.isSelected() || this.hexCrawlCheckBox.isSelected() || this.roadsCheckBox.isSelected()) {
                            UndoActionGroup uag = new UndoActionGroup();
                            List<Information> infos = mapUI.getMapData().getInformation();
                            List<Information> nations = null;
                            if (infos != null) {
                                for (Information info : infos) {
                                    if (!"Nations".equals(info.getName())) continue;
                                    nations = info.children;
                                }
                            }
                            this.worldographer.addStatus("Generating empires...", false);
                            GenerateEmpiresTask task = new GenerateEmpiresTask(UserPrefs.FULL && this.coastsCheckBox.isSelected(), UserPrefs.FULL && this.riverCheckBox.isSelected(), UserPrefs.FULL && this.empiresCheckBox.isSelected(), UserPrefs.FULL && this.hexCrawlCheckBox.isSelected(), UserPrefs.FULL && this.roadsCheckBox.isSelected(), this.worldographer, mapUI, nations, uag, (String)this.coastsCombo.getSelectionModel().getSelectedItem(), this.seaCheckBox.isSelected(), this.setup.numRivers, this.setup.riverType, (Integer)this.numNationsCombo.getValue(), this.empiresOneColorCheckBox.isSelected() ? (Color)this.empiresColorPicker.getValue() : null, false, mapUI.getMapData().getNotes(), (Integer)this.empireSizeSpinner.getValue(), new Random(), (double)((Integer)this.hexCrawlLandChanceeSpinner.getValue()).intValue() / 100.0, (double)((Integer)this.hexCrawlWaterChanceeSpinner.getValue()).intValue() / 100.0, this.roadsVillagesCheckBox.isSelected(), this.roadsRuinsCheckBox.isSelected(), "Curves".equals(this.roadStyleOptionsComboBox.getSelectionModel().getSelectedItem()), "Fractal-ish".equals(this.roadStyleOptionsComboBox.getSelectionModel().getSelectedItem()), (Color)this.roadsColorPicker.getValue(), (Color)this.roadsSecondaryColorPicker.getValue(), (Integer)this.distanceBetweenFeaturesSpinner.getValue());
                            task.setOnSucceeded(te -> {
                                task.updateMessage("Generation complete.");
                                primaryStage.close();
                            });
                            new Thread((Runnable)((Object)task)).start();
                        } else {
                            primaryStage.close();
                        }
                    }
                });
                new Thread((Runnable)((Object)generatemaptask)).start();
            }
        } else {
            for (int y = 0; y < t[0].length; ++y) {
                for (int x = 0; x < t.length; ++x) {
                    t[x][y] = new Terrain((String)this.terrainCombo.getSelectionModel().getSelectedItem(), true);
                }
            }
            if (preview) {
                this.updatePreview(this.setup.sendTime, t);
            } else {
                HashMap<String, LabelStyle> labelStyleMap = new HashMap<String, LabelStyle>();
                LabelStyle.setupLabelStyles(labelStyleMap, (ViewLevel)((Object)this.viewLevelCombo.getValue()));
                this.setup.labelStyles = labelStyleMap;
                HashMap<String, ShapeStyle> shapeStyleMap = new HashMap<String, ShapeStyle>();
                ShapeStyle.setupShapeStyles(shapeStyleMap, (ViewLevel)((Object)this.viewLevelCombo.getValue()));
                this.setup.shapeStyles = shapeStyleMap;
                this.setup.setTerrainByViewLevel((ViewLevel)((Object)this.viewLevelCombo.getValue()), t);
                MapLogic.setElevations(t, (HexOrientation)((Object)this.orientationCombo.getValue()));
                ArrayList<MapShape> shapes = new ArrayList<MapShape>();
                ArrayList<Feature> features = new ArrayList<Feature>();
                this.setup.shapes = shapes;
                this.setup.features = features;
                new StartNewMapDialog().startNewMap(this.setup, this.worldographer);
                primaryStage.close();
            }
        }
    }

    private void updatePreview(long sendTime, Terrain[][] t12) {
        System.out.println(sendTime + ":" + this.lastPreviewSent);
        if (sendTime != this.lastPreviewSent) {
            return;
        }
        this.drawPreviewTerrain(t12);
        if (this.genTerrainButton.isSelected() && this.isRegionButton.isSelected()) {
            this.setup.setTerrainByViewLevel((ViewLevel)((Object)this.viewLevelCombo.getValue()), t12);
            MapLogic.setElevations(t12, (HexOrientation)((Object)this.orientationCombo.getValue()));
            ArrayList<Feature> features = new ArrayList<Feature>();
            this.setup.features = features;
            HashMap<String, LabelStyle> labelStyleMap = new HashMap<String, LabelStyle>();
            LabelStyle.setupLabelStyles(labelStyleMap, (ViewLevel)((Object)this.viewLevelCombo.getValue()));
            this.setup.labelStyles = labelStyleMap;
            HashMap<String, ShapeStyle> shapeStyleMap = new HashMap<String, ShapeStyle>();
            ShapeStyle.setupShapeStyles(shapeStyleMap, (ViewLevel)((Object)this.viewLevelCombo.getValue()));
            this.setup.shapeStyles = shapeStyleMap;
            MapUI mapUI = new StartNewMapDialog().startNewMap(this.setup, this.worldographer, true);
            TerrainWizardTask trtask = new TerrainWizardTask(this.worldographer, mapUI.getController().getUndoRedoHandler(), mapUI.viewLevel, mapUI.getMapData().getTerrain(mapUI.viewLevel), true);
            trtask.addEventFilter(ActionEvent.ACTION, event -> trtask.cancel());
            trtask.setOnSucceeded(wse1 -> {
                Terrain[][] terrain = mapUI.getMapData().getTerrain((ViewLevel)((Object)((Object)this.viewLevelCombo.getValue())));
                this.drawPreviewTerrain(terrain);
            });
            new Thread((Runnable)((Object)trtask)).start();
        }
    }

    private void drawPreviewTerrain(Terrain[][] t12) {
        int canvasW = (int)this.previewCanvas.getWidth();
        int canvasH = (int)this.previewCanvas.getHeight();
        double tilew = 1.0 * (double)canvasW / (double)t12.length;
        double tileh = tilew * (Double)this.hexHeightSpinner.getValue() / (Double)this.hexWidthSpinner.getValue();
        double tileh2 = 1.0 * (double)canvasH / (double)t12[0].length;
        double tilew2 = tileh2 * (Double)this.hexWidthSpinner.getValue() / (Double)this.hexHeightSpinner.getValue();
        if (tileh2 < tileh || tilew2 < tilew) {
            tilew = tilew2;
            tileh = tileh2;
        }
        GraphicsContext gc = this.previewCanvas.getGraphicsContext2D();
        gc.clearRect(0.0, 0.0, (double)canvasW, (double)canvasH);
        int maxX = t12.length;
        int maxY = t12[0].length;
        System.out.println("drawing preview tilew:" + tilew + " tileh:" + tileh);
        for (int i = 0; i < maxX; ++i) {
            int x = (int)(1.0 * (double)maxX / (double)t12.length * (double)i);
            for (int j = 0; j < maxY; ++j) {
                int y = (int)(1.0 * (double)maxY / (double)t12[i].length * (double)j);
                if (t12[x][y].getTypeName().equals("Empty")) {
                    gc.setFill((Paint)Color.BLACK);
                } else if (t12[x][y].isIcy()) {
                    if (t12[x][y].getTypeName().toLowerCase().contains("water")) {
                        gc.setFill((Paint)Color.ALICEBLUE);
                    } else {
                        gc.setFill((Paint)Color.WHITE);
                    }
                } else if (t12[x][y].getBackgroundColor() != null) {
                    gc.setFill((Paint)t12[x][y].getBackgroundColor());
                } else {
                    gc.setFill((Paint)t12[x][y].getType().getBgColor());
                }
                gc.fillRect((double)x * tilew, (double)y * tileh, tilew, tileh);
            }
        }
    }

    private GridPane getPreviewPane() {
        GridPane grid = new GridPane();
        grid.setHgap(3.0);
        grid.setVgap(3.0);
        grid.setPadding(new Insets(3.0, 3.0, 3.0, 3.0));
        grid.setAlignment(Pos.TOP_CENTER);
        Label titlelabel = new Label("Preview");
        titlelabel.setFont(Font.font((String)"Tahoma", (FontWeight)FontWeight.NORMAL, (double)20.0));
        grid.add((Node)titlelabel, 0, 0, 3, 1);
        HBox buttonBox = new HBox();
        Button previewButton = new Button("Update Preview");
        previewButton.setOnAction(e -> this.callGenerateMapTask(this.popupStage, true, true));
        buttonBox.getChildren().add((Object)previewButton);
        if (((MapProjection)((Object)this.projectionCombo.getValue())).equals((Object)MapProjection.ICOSAHEDRAL)) {
            this.previewNoteLabel.setText(" (Auto-updates if triangle side size <= 50.)");
        }
        buttonBox.getChildren().add((Object)this.previewNoteLabel);
        grid.add((Node)buttonBox, 0, 1, 3, 1);
        HBox statusBox = new HBox();
        statusBox.getChildren().add((Object)new Label("Status: "));
        this.previewStatusLabelx = new Label("Not started.");
        statusBox.getChildren().add((Object)this.previewStatusLabelx);
        grid.add((Node)statusBox, 0, 2, 3, 1);
        this.previewCanvas.setWidth(400.0);
        this.previewCanvas.setHeight(200.0);
        this.previewCanvas.getGraphicsContext2D().setFill((Paint)Color.ALICEBLUE);
        this.previewCanvas.getGraphicsContext2D().fillRect(0.0, 0.0, this.previewCanvas.getWidth(), this.previewCanvas.getHeight());
        grid.add((Node)this.previewCanvas, 0, 3, 3, 1);
        Object[] options = new String[]{"Isometric coast features (adds water)", "Classic coasts features (adds water)", "Colored coast shapes (adds land)"};
        boolean haveRingLordWaterEdges = false;
        for (String fname : Feature.featureTypes.keySet()) {
            if (!fname.toLowerCase().contains("water edge") || fname.toLowerCase().contains("blue")) continue;
            haveRingLordWaterEdges = true;
            break;
        }
        if (haveRingLordWaterEdges) {
            String[] opts2 = new String[]{"Isometric coast features (adds water)", "Classic coasts features (adds water)", "Ring Lord coasts features (adds water)", "Colored coast shapes (adds land)"};
            options = opts2;
        }
        this.coastsCombo = new ComboBox(FXCollections.observableArrayList((Object[])options));
        String coast = this.prefs.get("coastType", "Colored coast shapes (adds land)");
        if (coast.contains("shapess")) {
            coast = "Colored coast shapes (adds land)";
        }
        this.coastsCombo.getSelectionModel().select((Object)coast);
        this.coastsCombo.setMaxWidth(270.0);
        this.coastsCheckBox.setSelected(this.prefs.getBoolean("coastsChecked", false));
        HBox coastsRow = new HBox(new Node[]{this.coastsCheckBox, this.coastsCombo});
        coastsRow.setAlignment(Pos.CENTER_LEFT);
        grid.add((Node)coastsRow, 0, 4, 3, 1);
        this.seaCheckBox.setSelected(this.prefs.getBoolean("coastsConvertOceans", false));
        HBox seaRow = new HBox(new Node[]{new Label("     "), this.seaCheckBox});
        grid.add((Node)seaRow, 0, 5, 3, 1);
        this.riverCheckBox.setSelected(this.prefs.getBoolean("riverChecked", false));
        grid.add((Node)this.riverCheckBox, 0, 6);
        this.riverSpinner.getValueFactory().setValue((Object)this.prefs.getInt("riversNumber", 10));
        this.riverSpinner.setMaxWidth(70.0);
        grid.add(this.riverSpinner, 1, 6);
        grid.add(this.riverTypeCombo, 2, 6);
        this.riverTypeCombo.setMaxWidth(120.0);
        this.riverTypeCombo.getSelectionModel().select((Object)this.prefs.get("riversType", "Shapes - Classic"));
        this.empiresCheckBox.setSelected(this.prefs.getBoolean("empiresChecked", false));
        this.empireSizeSpinner.setMaxWidth(70.0);
        Label maxSettlements = new Label(" Max #Settlements/Empire:");
        this.empireSizeSpinner.getValueFactory().setValue((Object)this.prefs.getInt("empiresNum", 20));
        HBox empiresRow = new HBox(new Node[]{this.empiresCheckBox, maxSettlements, this.empireSizeSpinner});
        empiresRow.setAlignment(Pos.CENTER_LEFT);
        maxSettlements.setAlignment(Pos.CENTER);
        grid.add((Node)empiresRow, 0, 7, 3, 1);
        this.distanceBetweenFeaturesSpinner.getValueFactory().setValue((Object)UserPrefs.PREFS.getInt("empireFeatureDistances", 3));
        this.distanceBetweenFeaturesSpinner.setEditable(true);
        this.distanceBetweenFeaturesSpinner.setMaxWidth(60.0);
        HBox empiresRow2 = new HBox(new Node[]{new Label("       Distance Between Cities/Towns/Etc. :"), this.distanceBetweenFeaturesSpinner});
        empiresRow2.setAlignment(Pos.CENTER_LEFT);
        grid.add((Node)empiresRow2, 0, 8, 3, 1);
        this.empiresOneColorCheckBox.setSelected(this.prefs.getBoolean("empiresOneColorChecked", false));
        this.empiresColorPicker.setValue((Object)Color.valueOf((String)this.prefs.get("empireColor", "#b80000")));
        this.empiresTranslucencyCheckbox.setSelected(this.prefs.getBoolean("empiresTranslucencyChecked", false));
        HBox empiresColorRow = new HBox(new Node[]{new Label("     "), this.empiresOneColorCheckBox, this.empiresColorPicker, this.empiresTranslucencyCheckbox});
        empiresColorRow.setAlignment(Pos.CENTER_LEFT);
        grid.add((Node)empiresColorRow, 0, 9, 3, 1);
        this.hexCrawlLandChanceeSpinner.setMaxWidth(70.0);
        this.hexCrawlWaterChanceeSpinner.setMaxWidth(70.0);
        this.hexCrawlCheckBox.setSelected(this.prefs.getBoolean("hexCrawlChecked", false));
        this.hexCrawlLandChanceeSpinner.getValueFactory().setValue((Object)this.prefs.getInt("hexCrawlLandChance", 15));
        this.hexCrawlWaterChanceeSpinner.getValueFactory().setValue((Object)this.prefs.getInt("hexCrawlWaterChance", 2));
        HBox hexCrawlRow = new HBox(new Node[]{this.hexCrawlCheckBox, new Label("  Land:"), this.hexCrawlLandChanceeSpinner, new Label("% Water:"), this.hexCrawlWaterChanceeSpinner, new Label("%")});
        hexCrawlRow.setAlignment(Pos.CENTER_LEFT);
        grid.add((Node)hexCrawlRow, 0, 10, 3, 1);
        this.roadsCheckBox.setSelected(this.prefs.getBoolean("roadsGenCheckbox", false));
        this.roadsColorPicker.setValue((Object)Color.valueOf((String)this.prefs.get("roadsColor", "#1a1a1a")));
        this.roadStyleOptionsComboBox.getSelectionModel().select((Object)this.prefs.get("roadStyle", "Fractal-ish"));
        this.roadsColorPicker.setMaxWidth(90.0);
        this.roadsSecondaryColorPicker.setMaxWidth(90.0);
        this.roadStyleOptionsComboBox.setMaxWidth(100.0);
        HBox roadsRow = new HBox(new Node[]{this.roadsCheckBox, new Label(" Color:"), this.roadsColorPicker, new Label(" Style:"), this.roadStyleOptionsComboBox});
        roadsRow.setAlignment(Pos.CENTER_LEFT);
        grid.add((Node)roadsRow, 0, 11, 3, 1);
        this.roadsVillagesCheckBox.setSelected(this.prefs.getBoolean("villagesRoadsCheckbox", false));
        this.roadsRuinsCheckBox.setSelected(this.prefs.getBoolean("ruinsRoadsCheckbox", false));
        this.roadsSecondaryColorPicker.setValue((Object)Color.valueOf((String)this.prefs.get("roadsSecondaryColor", "#d2b48c")));
        HBox roadsVillageRow = new HBox(new Node[]{new Label("     Include: "), this.roadsVillagesCheckBox, this.roadsRuinsCheckBox, this.roadsSecondaryColorPicker});
        roadsVillageRow.setAlignment(Pos.CENTER_LEFT);
        grid.add((Node)roadsVillageRow, 0, 12, 3, 1);
        Label note = new Label("These can be used via the Generate menu when a map is open.\nAuto-generating coasts/rivers/crawls/roads are Pro features.");
        HBox noteRow = new HBox(new Node[]{note});
        noteRow.setAlignment(Pos.CENTER);
        grid.add((Node)noteRow, 0, 13, 3, 1);
        return grid;
    }

    private GridPane getSizePane() {
        GridPane grid = new GridPane();
        grid.setAlignment(Pos.CENTER);
        grid.setAlignment(Pos.TOP_CENTER);
        Label titlelabel = new Label("Map Attributes");
        titlelabel.setFont(Font.font((String)"Tahoma", (FontWeight)FontWeight.NORMAL, (double)20.0));
        grid.add((Node)titlelabel, 0, 0, 2, 1);
        Label orientationLabel = new Label("Hex Orientation:");
        orientationLabel.setTooltip(new Tooltip("Sets how the map's hexes will be lined up: either with the columns\nlooking orderly or the rowing lining up."));
        this.orientationCombo.setTooltip(new Tooltip("Sets how the map's hexes will be lined up: either with the columns\nlooking orderly or the rowing lining up."));
        this.orientationCombo.getItems().addAll((Object[])new HexOrientation[]{HexOrientation.COLUMNS, HexOrientation.ROWS});
        HexOrientation hor = HexOrientation.COLUMNS;
        String ho = this.prefs.get("hexOrientation", "Columns Line Up");
        if ("Rows Line Up".equals(ho)) {
            hor = HexOrientation.ROWS;
        }
        this.orientationCombo.setValue((Object)hor);
        this.orientationCombo.valueProperty().addListener(event -> {
            this.updatePixelSizes();
            this.callGenerateMapTask(this.popupStage, true);
        });
        grid.add((Node)orientationLabel, 0, 1);
        grid.add(this.orientationCombo, 1, 1);
        GridPane flatgrid = new GridPane();
        GridPane isogrid = new GridPane();
        Label projectionLabel = new Label("Map Projection:");
        projectionLabel.setTooltip(new Tooltip("Will the map have a flat projection (most common, like a simple rectangle)\nor will it be icosahedral (like a flattened out d20)."));
        this.projectionCombo.getItems().addAll((Object[])new MapProjection[]{MapProjection.FLAT, MapProjection.ICOSAHEDRAL});
        MapProjection mpr = MapProjection.FLAT;
        String mprs = this.prefs.get("mapProjection", "Flat");
        if (mprs.equalsIgnoreCase("Icosahedral")) {
            mpr = MapProjection.ICOSAHEDRAL;
        }
        this.projectionCombo.setValue((Object)mpr);
        this.projectionCombo.valueProperty().addListener((ov, old, newp) -> {
            if (newp == MapProjection.FLAT) {
                grid.getChildren().remove((Object)isogrid);
                grid.add((Node)flatgrid, 0, 3, 2, 2);
                this.previewNoteLabel.setText(" (Auto-updates if tiles wide & high <= 1000.)");
            } else {
                grid.getChildren().remove((Object)flatgrid);
                grid.add((Node)isogrid, 0, 3, 2, 2);
                this.previewNoteLabel.setText(" (Auto-updates if triangle side size <= 50.)");
            }
            this.callGenerateMapTask(this.popupStage, true);
        });
        grid.add((Node)projectionLabel, 0, 2);
        grid.add(this.projectionCombo, 1, 2);
        flatgrid.setAlignment(Pos.CENTER);
        Label wideLabel = new Label("Hexes Wide:");
        wideLabel.setTooltip(new Tooltip("The number of hexes wide to make the map. Pro users can expand this via Expand/Shrink\nColumns/Rows on the Tools menu."));
        flatgrid.add((Node)wideLabel, 0, 0);
        this.hexesWideSpinner.setTooltip(new Tooltip("The number of hexes wide to make the map. Pro users can expand this via Expand/Shrink\nColumns/Rows on the Tools menu."));
        this.hexesWideSpinner.getValueFactory().setValue((Object)Integer.parseInt(this.prefs.get("hexesWide", "100")));
        this.hexesWideSpinner.valueProperty().addListener(event -> this.callGenerateMapTask(this.popupStage, true));
        flatgrid.add(this.hexesWideSpinner, 1, 0);
        Label highLabel = new Label("Hexes High:");
        highLabel.setTooltip(new Tooltip("The number of hexes high to make the map. Pro users can expand this via Expand/Shrink\nColumns/Rows on the Tools menu."));
        flatgrid.add((Node)highLabel, 0, 1);
        this.hexesHighSpinner.setTooltip(new Tooltip("The number of hexes high to make the map. Pro users can expand this via Expand/Shrink\nColumns/Rows on the Tools menu."));
        this.hexesHighSpinner.getValueFactory().setValue((Object)Integer.parseInt(this.prefs.get("hexesHigh", "50")));
        this.hexesHighSpinner.valueProperty().addListener(event -> this.callGenerateMapTask(this.popupStage, true));
        flatgrid.add(this.hexesHighSpinner, 1, 1);
        isogrid.setAlignment(Pos.CENTER);
        Label tsLabel = new Label("Triangle Side Size:");
        tsLabel.setTooltip(new Tooltip("The number of hexes each side of each triangle of the map. This can not be changed later."));
        isogrid.add((Node)tsLabel, 0, 0);
        String ts = this.prefs.get("triangleSize", this.prefs.get("triangleSize", "12"));
        this.triangleSizeSpinner.setTooltip(new Tooltip("The number of hexes each side of each triangle of the map. This can not be changed later."));
        this.triangleSizeSpinner.getValueFactory().setValue((Object)Integer.parseInt(ts));
        this.triangleSizeSpinner.valueProperty().addListener(event -> this.callGenerateMapTask(this.popupStage, true));
        isogrid.add(this.triangleSizeSpinner, 1, 0);
        Label tshLabel = new Label("(# hexes per edge of each triangle section.)");
        isogrid.add((Node)tshLabel, 0, 1, 2, 2);
        grid.add((Node)(this.projectionCombo.getValue() == MapProjection.FLAT ? flatgrid : isogrid), 0, 3, 2, 3);
        Label widthLabel = new Label("Hex Width (pixels):");
        widthLabel.setTooltip(new Tooltip("Sets the number of pixels wide each hex will be. See below for size suggestions.\nThis value can always be changed when viewing the map to zoom in/out."));
        grid.add((Node)widthLabel, 0, 6);
        this.hexWidthSpinner.setTooltip(new Tooltip("Sets the number of pixels wide each hex will be. See below for size suggestions.\nThis value can always be changed when viewing the map to zoom in/out."));
        this.hexWidthSpinner.getValueFactory().setValue((Object)Double.valueOf(this.prefs.get("hexWidth", "46.18")));
        this.hexWidthSpinner.setMinWidth(80.0);
        this.hexWidthSpinner.setMaxWidth(80.0);
        this.hexWidthSpinner.setEditable(true);
        this.hexWidthSpinner.valueProperty().addListener(event -> this.callGenerateMapTask(this.popupStage, true));
        grid.add(this.hexWidthSpinner, 1, 6);
        Label heightLabel = new Label("Hex Height (pixels):");
        heightLabel.setTooltip(new Tooltip("Sets the number of pixels high each hex will be. See below for size suggestions.\nThis value can always be changed when viewing the map to zoom in/out."));
        grid.add((Node)heightLabel, 0, 7);
        this.hexHeightSpinner.setTooltip(new Tooltip("Sets the number of pixels high each hex will be. See below for size suggestions.\nThis value can always be changed when viewing the map to zoom in/out."));
        this.hexHeightSpinner.getValueFactory().setValue((Object)Double.valueOf(this.prefs.get("hexHeight", "40")));
        this.hexHeightSpinner.setMinWidth(80.0);
        this.hexHeightSpinner.setMaxWidth(80.0);
        this.hexHeightSpinner.setEditable(true);
        this.hexHeightSpinner.valueProperty().addListener(event -> this.callGenerateMapTask(this.popupStage, true));
        grid.add(this.hexHeightSpinner, 1, 7);
        Label levelLabel = new Label("Initial View Level:");
        levelLabel.setTooltip(new Tooltip("Sets the view level of the map. Worldographer's pro version lets you switch a map between\nWorld, Continent, Kingdom, & Province levels. When switching, you can set the ratio of hexes\nbetween levels to 6:1 or any other way you'd like. If you like to world build top-down, start\nwith a World level map. If you want to make just a campaign starting area, pick Kingdom for \nsmall region of 5 to 8 mile hexes (drill down to province later for 1 mile hexes if you wish."));
        this.viewLevelCombo.getItems().addAll((Object[])new ViewLevel[]{ViewLevel.WORLD, ViewLevel.CONTINENT, ViewLevel.KINGDOM});
        this.viewLevelCombo.setTooltip(new Tooltip("Sets the view level of the map. Worldographer's pro version lets you switch a map between\nWorld, Continent, Kingdom, & Province levels. When switching, you can set the ratio of hexes\nbetween levels to 6:1 or any other way you'd like. If you like to world build top-down, start\nwith a World level map. If you want to make just a campaign starting area, pick Kingdom for \nsmall region of 5 to 8 mile hexes (drill down to province later for 1 mile hexes if you wish."));
        ViewLevel iv = ViewLevel.WORLD;
        String ivs = this.prefs.get("initialView", "WORLD");
        if (ivs.equals("CONTINENT")) {
            iv = ViewLevel.CONTINENT;
        }
        if (ivs.equals("KINGDOM")) {
            iv = ViewLevel.KINGDOM;
        }
        this.viewLevelCombo.setValue((Object)iv);
        this.viewLevelCombo.valueProperty().addListener(event -> this.callGenerateMapTask(this.popupStage, true));
        grid.add((Node)levelLabel, 0, 8);
        grid.add(this.viewLevelCombo, 1, 8);
        this.useSuggestedPixelSizes.setSelected(Boolean.valueOf(this.prefs.get("useSuggestedPixelSizes", "true")).booleanValue());
        this.useSuggestedPixelSizes.setOnAction(event -> this.updatePixelSizes());
        this.useSuggestedPixelSizes.setTooltip(new Tooltip("If checked, the hex sizes change as describe below if you can the hex orientation or terrain icons."));
        grid.add((Node)this.useSuggestedPixelSizes, 0, 9, 2, 1);
        Label tips1Label = new Label("* If using classic icons and columns orientation, use width\n   of 46.18 and height of 40.\n* If using classic icons and rows orient\u00abation, use width\n   of 40 and height of 46.18.\n* If using isometric icons and columns orientation, use width\n   of 86.5 and height of 50.\n* If using isometric icons and rows orientation, use width\n   of 75 and height of 56.25.\n* You can change the above while viewing the map.\n* If using an icosahedral projection, a hex orientation of\n   rows gives a more even map. If using columns, use a\n   triangle size that is a multiple of 4.");
        tips1Label.setStyle("-fx-font-size: 10px");
        grid.add((Node)tips1Label, 0, 11, 2, 1);
        Label seedLabel = new Label("Random Seed:");
        seedLabel.setTooltip(new Tooltip("Number used to set up the random generator. If this same number is set as the seed and all other settings\nare the same, the map generated will be the same. Note: a new version of Worldographer may make changes\nto the generator and then the same seed likely won't make the same map."));
        grid.add((Node)seedLabel, 0, 15);
        this.seedSpinner.setMinWidth(100.0);
        this.seedSpinner.setMaxWidth(100.0);
        this.seedSpinner.setEditable(true);
        this.seedSpinner.setTooltip(new Tooltip("Number used to set up the random generator. If this same number is set as the seed and all other settings\nare the same, the map generated will be the same. Note: a new version of Worldographer may make changes\nto the generator and then the same seed likely won't make the same map."));
        this.seedSpinner.valueProperty().addListener(event -> this.callGenerateMapTask(this.popupStage, true));
        grid.add(this.seedSpinner, 1, 15);
        Button configureTerrainButton = new Button("Configure Terrain Used");
        configureTerrainButton.setOnAction(e -> this.showWorldTerrainSettingsDialog());
        grid.add((Node)configureTerrainButton, 0, 16, 2, 1);
        Button resetDefaultsButton = new Button("Reset Map Size & Terrain Defaults");
        resetDefaultsButton.setOnAction(e -> this.resetDefaults());
        grid.add((Node)resetDefaultsButton, 0, 17, 2, 1);
        return grid;
    }

    private void updatePixelSizes() {
        if (this.useSuggestedPixelSizes.isSelected()) {
            if (this.orientationCombo.getValue() == HexOrientation.COLUMNS) {
                if (this.terrainStyleCombo.getValue() == TerrainStyle.Isometric) {
                    this.hexWidthSpinner.getValueFactory().setValue((Object)86.5);
                    this.hexHeightSpinner.getValueFactory().setValue((Object)50.0);
                } else {
                    this.hexWidthSpinner.getValueFactory().setValue((Object)46.18);
                    this.hexHeightSpinner.getValueFactory().setValue((Object)40.0);
                }
            } else if (this.orientationCombo.getValue() == HexOrientation.ROWS) {
                if (this.terrainStyleCombo.getValue() == TerrainStyle.Isometric) {
                    this.hexWidthSpinner.getValueFactory().setValue((Object)75.0);
                    this.hexHeightSpinner.getValueFactory().setValue((Object)56.25);
                } else {
                    this.hexWidthSpinner.getValueFactory().setValue((Object)40.0);
                    this.hexHeightSpinner.getValueFactory().setValue((Object)46.18);
                }
            }
        }
    }

    private void addWorldPaneRow(GridPane grid, String labelText, String toolTipText, Spinner spinner, int row, Object preset) {
        spinner.getValueFactory().setValue(preset);
        spinner.setMaxWidth(80.0);
        spinner.setMaxHeight(12.0);
        spinner.valueProperty().addListener(event -> this.callGenerateMapTask(this.popupStage, true));
        Label lfLabel = new Label(labelText);
        lfLabel.setTooltip(new Tooltip(toolTipText));
        grid.add((Node)lfLabel, 0, row);
        spinner.setTooltip(new Tooltip(toolTipText));
        grid.add((Node)spinner, 1, row);
        Label percentLabel = new Label("%");
        grid.add((Node)percentLabel, 2, row);
    }

    private void resetDefaults() {
        this.genTerrainButton.setSelected(true);
        this.isFullWorldButton.setSelected(true);
        this.landFrequencyCombo.getValueFactory().setValue((Object)30);
        this.landFormsCombo.getSelectionModel().select((Object)LARGE_CONTINENTS);
        this.mountainFrequencyCombo.getValueFactory().setValue((Object)30);
        this.vegetationFrequencyCombo.getValueFactory().setValue((Object)35);
        this.desertFrequencyCombo.getValueFactory().setValue((Object)25);
        this.swampFrequencyCombo.getValueFactory().setValue((Object)5);
        this.swampContinueFrequencyCombo.getValueFactory().setValue((Object)40);
        this.icyCombo.getValueFactory().setValue((Object)20);
        this.tropicalCombo.getValueFactory().setValue((Object)15);
        this.clusterCombo.getValueFactory().setValue((Object)70);
        this.clusterDrift.setSelected(false);
        this.numNationsCombo.getValueFactory().setValue((Object)10);
        this.orientationCombo.getSelectionModel().select((Object)HexOrientation.COLUMNS);
        this.projectionCombo.getSelectionModel().select((Object)MapProjection.FLAT);
        this.useSuggestedPixelSizes.setSelected(true);
        this.hexWidthSpinner.getValueFactory().setValue((Object)46.18);
        this.hexHeightSpinner.getValueFactory().setValue((Object)40.0);
        this.hexesHighSpinner.getValueFactory().setValue((Object)100);
        this.hexesWideSpinner.getValueFactory().setValue((Object)200);
        this.viewLevelCombo.getSelectionModel().select((Object)ViewLevel.WORLD);
    }

    private GridPane getTerrainPane() {
        GridPane grid = new GridPane();
        grid.setAlignment(Pos.CENTER);
        grid.setAlignment(Pos.TOP_CENTER);
        String oneterrain = this.prefs.get("terrainGen", "World");
        Integer landFreq = Integer.valueOf(this.prefs.get("landFrequency", "30"));
        String landForm = this.prefs.get("landForm", LARGE_CONTINENTS);
        Integer mtnFreq = Integer.valueOf(this.prefs.get("mtnFrequency", "30"));
        Integer vegFreq = Integer.valueOf(this.prefs.get("vegFrequency", "35"));
        Integer desertFreq = Integer.valueOf(this.prefs.get("desertFrequency", "25"));
        Integer swampFreq = Integer.valueOf(this.prefs.get("swampFrequency", "5"));
        Integer swampContinueFreq = Integer.valueOf(this.prefs.get("swampContinueFrequency", "40"));
        Integer icy = Integer.valueOf(this.prefs.get("icy", "20"));
        Integer tropical = Integer.valueOf(this.prefs.get("tropical", "15"));
        ToggleGroup tggroup = new ToggleGroup();
        Label scenetitle = new Label("Terrain Generation");
        scenetitle.setFont(Font.font((String)"Tahoma", (FontWeight)FontWeight.NORMAL, (double)20.0));
        grid.add((Node)scenetitle, 0, 0, 2, 1);
        grid.add((Node)this.oneTerrainButton, 0, 1, 1, 1);
        this.oneTerrainButton.setToggleGroup(tggroup);
        this.oneTerrainButton.setOnAction(event -> this.callGenerateMapTask(this.popupStage, true));
        this.terrainCombo.getSelectionModel().select((Object)"Blank");
        this.terrainCombo.setMaxWidth(170.0);
        this.terrainCombo.setOnAction(event -> this.callGenerateMapTask(this.popupStage, true));
        grid.add(this.terrainCombo, 1, 1, 2, 1);
        this.genTerrainButton.setToggleGroup(tggroup);
        this.genTerrainButton.setOnAction(event -> this.callGenerateMapTask(this.popupStage, true));
        grid.add((Node)this.genTerrainButton, 0, 3, 2, 1);
        GridPane innergrid2 = new GridPane();
        innergrid2.setAlignment(Pos.CENTER);
        innergrid2.add((Node)this.isRegionButton, 0, 0, 1, 1);
        Button regionConfigButton = new Button("Configure");
        innergrid2.add((Node)regionConfigButton, 1, 0);
        regionConfigButton.setOnAction(e -> this.showRegionSettingsDialog());
        innergrid2.add((Node)this.isFullWorldButton, 0, 1, 2, 1);
        ToggleGroup wrgroup = new ToggleGroup();
        this.isRegionButton.setToggleGroup(wrgroup);
        this.isRegionButton.setOnAction(event -> this.callGenerateMapTask(this.popupStage, true));
        this.isFullWorldButton.setToggleGroup(wrgroup);
        this.isFullWorldButton.setSelected(true);
        this.isFullWorldButton.setOnAction(event -> this.callGenerateMapTask(this.popupStage, true));
        if (!oneterrain.equals("World") && !oneterrain.equals("Region")) {
            this.oneTerrainButton.setSelected(true);
            this.terrainCombo.getSelectionModel().select((Object)oneterrain);
        } else {
            this.genTerrainButton.setSelected(true);
            if (oneterrain.equals("World")) {
                this.isFullWorldButton.setSelected(true);
            } else {
                this.isRegionButton.setSelected(true);
            }
        }
        this.addWorldPaneRow(innergrid2, "Land Frequency", "Traget percentage of the map that will be land.", this.landFrequencyCombo, 2, landFreq);
        this.addWorldPaneRow(innergrid2, "Mountain/Hill Frequency", "Target percentage of the land that will be hills or mountains.", this.mountainFrequencyCombo, 3, mtnFreq);
        this.addWorldPaneRow(innergrid2, "Vegetation Frequency", "Target percentage of the land that will be forests.", this.vegetationFrequencyCombo, 4, vegFreq);
        this.addWorldPaneRow(innergrid2, "Desert Frequency", "Target percentage of the non hill/mountain/forest land that will be desert.", this.desertFrequencyCombo, 5, desertFreq);
        this.addWorldPaneRow(innergrid2, "Coastal Forest -> Swamp", "Chance that a coastal forest will be turned into swamp or moors.", this.swampFrequencyCombo, 6, swampFreq);
        this.addWorldPaneRow(innergrid2, "     Swamp Continues", "Chance that forest near a swamp/moor becomes swamp/moor .", this.swampContinueFrequencyCombo, 7, swampContinueFreq);
        this.addWorldPaneRow(innergrid2, "Icy", "What percentage of the planet is icy.", this.icyCombo, 8, icy);
        this.addWorldPaneRow(innergrid2, "Tropical", "What percentage of the planet is tropical.", this.tropicalCombo, 9, tropical);
        grid.add((Node)innergrid2, 0, 4, 2, 7);
        Label landrFormlabel = new Label("Land Forms:");
        landrFormlabel.setTooltip(new Tooltip("Goal for the resulting map, but depends on the factors above.\nEx: A 'Small Islands' map may look like a large contient if the Land Frequency is relatively high."));
        grid.add((Node)landrFormlabel, 0, 11);
        this.landFormsCombo.getSelectionModel().select((Object)landForm);
        this.landFormsCombo.setMaxWidth(160.0);
        this.landFormsCombo.setTooltip(new Tooltip("Goal for the resulting map, but depends on the factors above.\nEx: A 'Small Islands' map may look like a large contient if the Land Frequency is relatively high."));
        this.landFormsCombo.valueProperty().addListener(event -> this.callGenerateMapTask(this.popupStage, true));
        grid.add(this.landFormsCombo, 1, 11);
        Label clusterlabel = new Label("Cluster:");
        clusterlabel.setTooltip(new Tooltip("When starting new islands/landmasses, this controls if the system should take the closer\nof two options to the original landmass (or original landmass if 'Allow Drift' is off."));
        grid.add((Node)clusterlabel, 0, 12);
        HBox clusterBox = new HBox();
        this.clusterCombo.setMaxWidth(70.0);
        this.clusterCombo.getValueFactory().setValue((Object)Integer.valueOf(this.prefs.get("clusterx", "70")));
        clusterBox.getChildren().add(this.clusterCombo);
        this.clusterCombo.setTooltip(new Tooltip("When starting new islands/landmasses, this controls if the system should take the closer\nof two options to the original landmass (or original landmass if 'Allow Drift' is off."));
        this.clusterCombo.valueProperty().addListener(event -> this.callGenerateMapTask(this.popupStage, true));
        clusterBox.getChildren().add((Object)new Label("%  "));
        clusterBox.getChildren().add((Object)this.clusterDrift);
        this.clusterDrift.setSelected(this.prefs.getBoolean("clusterDriftx", false));
        this.clusterDrift.setTooltip(new Tooltip("When starting new islands/landmasses and clustering, should it use the original\nlandmass location (if checked) or use the previous landmass location."));
        grid.add((Node)clusterBox, 1, 12);
        this.clusterDrift.setOnAction(event -> this.callGenerateMapTask(this.popupStage, true));
        Label nationslabel = new Label("# Nations:");
        nationslabel.setTooltip(new Tooltip("Number of nations to create in the World Info (on the Data menu)--you can add/edit/delete\nthem there. Also used for Generate Nations/Empires on the Generate menu."));
        grid.add((Node)nationslabel, 0, 13);
        this.numNationsCombo.setMaxWidth(70.0);
        this.numNationsCombo.getValueFactory().setValue((Object)Integer.parseInt(this.prefs.get("numNations", "10")));
        this.numNationsCombo.setTooltip(new Tooltip("Number of nations to create in the World Info (on the Data menu)--you can add/edit/delete\nthem there. Also used for Generate Nations/Empires on the Generate menu."));
        grid.add(this.numNationsCombo, 1, 13);
        Label terrainstylelabel = new Label("Terrain Icons:");
        terrainstylelabel.setTooltip(new Tooltip("Sets the initial set of icons to use. Classic: flat/simple icons similar to those popular\nin the 1980s; Isometric: semi-realistic isometric icons similar to 2000s strategy games."));
        grid.add((Node)terrainstylelabel, 0, 14);
        String iconStyleString = this.prefs.get("iconStyle", null);
        TerrainStyle ts = TerrainStyle.Classic;
        if ("Isometric".equals(iconStyleString)) {
            ts = TerrainStyle.Isometric;
        }
        this.terrainStyleCombo.getSelectionModel().select((Object)ts);
        this.terrainStyleCombo.setTooltip(new Tooltip("Sets the initial set of icons to use. Classic: flat/simple icons similar to those popular\nin the 1980s; Isometric: semi-realistic isometric icons similar to 2000s strategy games."));
        grid.add(this.terrainStyleCombo, 1, 14);
        this.terrainStyleCombo.valueProperty().addListener(event -> {
            this.updatePixelSizes();
            this.callGenerateMapTask(this.popupStage, true);
        });
        return grid;
    }

    private void showRegionSettingsDialog() {
        int i;
        Dialog d = new Dialog();
        d.getDialogPane().setMinSize(1080.0, 600.0);
        d.setTitle("Region Setttings");
        d.setHeaderText("Each field is the percentage chance the row's terrain will have the column's terrain adjacent to it.");
        GridPane grid = new GridPane();
        grid.setHgap(5.0);
        grid.setVgap(10.0);
        grid.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        grid.add((Node)new Label("Terrain"), 0, 1);
        Label[] columnLabels = new Label[this.terrainToProbabilities.size()];
        for (i = 0; i < this.terrainToProbabilities.size(); ++i) {
            Object key = (String)this.terrainToProbabilities.get(i).getKey();
            int slashIndex = ((String)key).indexOf(47);
            if (slashIndex > 0) {
                key = ((String)key).substring(slashIndex + 1);
            }
            if (((String)key).startsWith("Flat ")) {
                key = "F" + ((String)key).substring(4);
            }
            columnLabels[i] = new Label((String)key);
            columnLabels[i].setTooltip(new Tooltip((String)key));
            columnLabels[i].setMaxWidth(75.0);
            columnLabels[i].setMinWidth(75.0);
            grid.add((Node)columnLabels[i], i + 1, 1);
        }
        this.regionTerrainPercentSpinners = new FocusSpinner[this.terrainToProbabilities.size()][((Double[])this.terrainToProbabilities.get(0).getValue()).length];
        this.regionLastColumnLabels = new Label[this.terrainToProbabilities.size()];
        for (i = 0; i < this.terrainToProbabilities.size(); ++i) {
            int ii = i;
            ComboBox terraintypecombo = new ComboBox(FXCollections.observableArrayList(Terrain.DEFAULT_TERRAIN.keySet()));
            this.regionTerrainTypeCombos.add((ComboBox<String>)terraintypecombo);
            terraintypecombo.getSelectionModel().select((Object)((String)this.terrainToProbabilities.get(i).getKey()));
            terraintypecombo.valueProperty().addListener((ov, old, newp) -> {
                this.terrainToProbabilities.set(ii, (Pair<String, Double[]>)new Pair(newp, (Object)((Double[])this.terrainToProbabilities.get(ii).getValue())));
                Object key = newp;
                int slashIndex = ((String)key).indexOf(47);
                if (slashIndex > 0) {
                    key = ((String)key).substring(slashIndex + 1);
                }
                if (((String)key).startsWith("Flat ")) {
                    key = "F" + ((String)key).substring(4);
                }
                columnLabels[ii].setText((String)key);
                columnLabels[ii].setTooltip(new Tooltip((String)key));
            });
            grid.add((Node)terraintypecombo, 0, i + 2);
            for (int j = 0; j < ((Double[])this.terrainToProbabilities.get(i).getValue()).length - 1; ++j) {
                this.regionTerrainPercentSpinners[i][j] = new FocusSpinner(0.0, 100.0, ((Double[])this.terrainToProbabilities.get(i).getValue())[j]);
                int jj = j;
                this.regionTerrainPercentSpinners[i][j].valueProperty().addListener((obs, oldValue, newValue) -> {
                    System.err.println(this.terrainToProbabilities.size() + " setting region:" + ii + ":" + jj + ":" + oldValue + ":" + newValue);
                    ((Double[])this.terrainToProbabilities.get((int)ii).getValue())[jj] = newValue;
                    double subtotal = 0.0;
                    for (int k = 0; k < ((Double[])this.terrainToProbabilities.get(ii).getValue()).length - 1; ++k) {
                        subtotal += ((Double[])this.terrainToProbabilities.get(ii).getValue())[k].doubleValue();
                    }
                    if (subtotal > 100.0) {
                        ((Double[])this.terrainToProbabilities.get((int)ii).getValue())[jj] = oldValue;
                        this.regionTerrainPercentSpinners[ii][jj].getValueFactory().setValue(oldValue);
                    } else {
                        ((Double[])this.terrainToProbabilities.get((int)ii).getValue())[10] = 100.0 - subtotal;
                        this.regionLastColumnLabels[ii].setText("" + ((Double[])this.terrainToProbabilities.get(ii).getValue())[10]);
                    }
                });
                this.regionTerrainPercentSpinners[i][j].setMaxWidth(75.0);
                this.regionTerrainPercentSpinners[i][j].setMinWidth(75.0);
                grid.add(this.regionTerrainPercentSpinners[i][j], j + 1, i + 2);
            }
            this.regionLastColumnLabels[i] = new Label("" + ((Double[])this.terrainToProbabilities.get(i).getValue())[10]);
            grid.add((Node)this.regionLastColumnLabels[i], 11, i + 2);
        }
        Button loadSettingsButton = new Button("Load Settings");
        loadSettingsButton.setOnAction(event -> this.loadSettings(true));
        grid.add((Node)loadSettingsButton, 3, this.terrainToProbabilities.size() + 2, 2, 1);
        Button saveSettingsButton = new Button("Save Settings");
        saveSettingsButton.setOnAction(event -> this.saveSettings(true));
        grid.add((Node)saveSettingsButton, 5, this.terrainToProbabilities.size() + 2, 2, 1);
        d.getDialogPane().setContent((Node)grid);
        ButtonType buttonTypeCancel = new ButtonType("OK", ButtonBar.ButtonData.CANCEL_CLOSE);
        d.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{buttonTypeCancel});
        d.showAndWait();
    }

    private void showWorldTerrainSettingsDialog() {
        Dialog d = new Dialog();
        d.getDialogPane().setPrefSize(1000.0, 600.0);
        d.setTitle("World Terrain Setttings");
        d.setHeaderText("Change the terrain used from the original/classic set");
        BorderPane borderPane = new BorderPane();
        GridPane grid = new GridPane();
        ScrollPane sp = new ScrollPane((Node)grid);
        borderPane.setCenter((Node)sp);
        grid.setHgap(5.0);
        grid.setVgap(5.0);
        grid.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        grid.add((Node)new Label("You can change the terrain used for world generaion on this screen.\nNote: 'Is full world' must be checked (on the main new World/Kingdom Setup Screen) for these to be used.\n      Also note changing these defaults will cause the conversion to an isometric map to fail."), 0, 0, 3, 1);
        grid.add((Node)new Label("Default Terrain"), 0, 1);
        grid.add((Node)new Label("Customized Terrain"), 1, 1);
        grid.add((Node)new Label("Description"), 2, 1);
        for (int i = 0; i < this.defaultTerrain.length; ++i) {
            Label nameLabel = new Label(this.defaultTerrain[i][0].substring(8));
            nameLabel.setMinWidth(180.0);
            nameLabel.setMaxWidth(180.0);
            grid.add((Node)nameLabel, 0, i + 2);
            ComboBox terraintypecombo = new ComboBox();
            ArrayList<String> list = new ArrayList<String>(Terrain.DEFAULT_TERRAIN.keySet());
            ObservableList observableList = FXCollections.observableArrayList(list);
            FilteredList filteredItems = new FilteredList(observableList, p -> true);
            terraintypecombo.getEditor().textProperty().addListener((obs, oldValue, newValue) -> {
                TextField editor = terraintypecombo.getEditor();
                String selected = (String)terraintypecombo.getSelectionModel().getSelectedItem();
                Platform.runLater(() -> {
                    if (selected == null || !selected.equals(editor.getText())) {
                        filteredItems.setPredicate(item -> item.toUpperCase().contains(newValue.toUpperCase()));
                    }
                });
            });
            terraintypecombo.setItems((ObservableList)filteredItems);
            terraintypecombo.setMaxWidth(270.0);
            terraintypecombo.setMinWidth(270.0);
            terraintypecombo.getSelectionModel().select((Object)this.defaultTerrain[i][0]);
            terraintypecombo.setEditable(true);
            this.worldTerrainTypeCombos.add((ComboBox<String>)terraintypecombo);
            grid.add((Node)new Label(this.defaultTerrain[i][1]), 2, i + 2);
            grid.add((Node)terraintypecombo, 1, i + 2);
        }
        GridPane bottomGrid = new GridPane();
        bottomGrid.setHgap(5.0);
        bottomGrid.setVgap(5.0);
        bottomGrid.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        Button loadSettingsButton = new Button("Load Settings");
        loadSettingsButton.setOnAction(event -> this.loadSettings(false));
        bottomGrid.add((Node)loadSettingsButton, 1, 0, 1, 1);
        Button saveSettingsButton = new Button("Save Settings");
        saveSettingsButton.setOnAction(event -> this.saveSettings(false));
        bottomGrid.add((Node)saveSettingsButton, 2, 0, 1, 1);
        borderPane.setBottom((Node)bottomGrid);
        d.getDialogPane().setContent((Node)borderPane);
        ButtonType buttonTypeCancel = new ButtonType("OK", ButtonBar.ButtonData.CANCEL_CLOSE);
        d.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{buttonTypeCancel});
        d.showAndWait();
    }

    public void loadSettings(boolean isRegion) {
        File f;
        FileChooser fc = new FileChooser();
        FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("Properties (*.properties)", new String[]{"*.properties"});
        fc.getExtensionFilters().add((Object)extFilter);
        File d = FileSaveLoad.getLastUsedDir();
        if (d != null) {
            fc.setInitialDirectory(d);
        }
        if ((f = fc.showOpenDialog(null)) != null) {
            try {
                if (isRegion) {
                    this.terrainToProbabilities.clear();
                }
                FileReader fr = new FileReader(f);
                BufferedReader br = new BufferedReader(fr);
                ArrayList<String> lines = new ArrayList<String>();
                String line = br.readLine();
                ArrayList<CallSite> errorList = new ArrayList<CallSite>();
                int linecount = 0;
                while (line != null) {
                    if (!line.trim().equals("")) {
                        lines.add(line);
                    }
                    if (isRegion) {
                        key = line.substring(0, line.indexOf(61));
                        String vals = line.substring(line.indexOf("=") + 1);
                        String[] valsArray = vals.split(",");
                        Double[] valDoubles = new Double[valsArray.length];
                        for (int i = 0; i < valsArray.length; ++i) {
                            valDoubles[i] = Double.valueOf(valsArray[i]);
                            if (i == valsArray.length - 1) continue;
                            this.regionTerrainPercentSpinners[linecount][i].getValueFactory().setValue((Object)valDoubles[i]);
                        }
                        this.terrainToProbabilities.add((Pair<String, Double[]>)new Pair((Object)key, (Object)valDoubles));
                        this.regionTerrainTypeCombos.get(linecount).getSelectionModel().select((Object)key);
                    } else {
                        key = line.substring(0, line.indexOf(61));
                        String val = line.substring(line.indexOf("=") + 1);
                        if (!Terrain.terrainTypes.containsKey(val)) {
                            errorList.add((CallSite)((Object)(val + " not found.")));
                        } else {
                            for (int i = 0; i < this.defaultTerrain.length; ++i) {
                                if (!key.equals(this.defaultTerrain[i][0])) continue;
                                this.worldTerrainTypeCombos.get(i).getSelectionModel().select((Object)val);
                            }
                        }
                    }
                    ++linecount;
                    line = br.readLine();
                }
                this.worldographer.addStatus("Loaded " + (isRegion ? "region" : "world") + " terrain settings successfully. TerrainToProbabilities size:" + this.terrainToProbabilities.size(), false);
                if (errorList.size() > 0) {
                    Object details = "";
                    for (int i = 0; i < errorList.size(); ++i) {
                        if (i != 0) {
                            details = (String)details + "\n";
                        }
                        details = (String)details + (String)errorList.get(i);
                    }
                    StandardDialog.showDialog(this.worldographer.getPrimaryStage(), "Load Settings", "Load Settings Errors", "Some of the terrain properties weren't set correctly. Show details for more information.", (String)details, null);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void saveSettings(boolean isRegion) {
        File f;
        FileChooser fc = new FileChooser();
        FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("Properties (*.properties)", new String[]{"*.properties"});
        fc.getExtensionFilters().add((Object)extFilter);
        File d = FileSaveLoad.getLastUsedDir();
        if (d != null) {
            fc.setInitialDirectory(d);
        }
        if ((f = fc.showSaveDialog(null)) != null) {
            Object out = "";
            if (isRegion) {
                for (i = 0; i < this.terrainToProbabilities.size(); ++i) {
                    if (i != 0) {
                        out = (String)out + "\n";
                    }
                    String key = (String)this.terrainToProbabilities.get(i).getKey();
                    out = (String)out + key + "=";
                    Double[] vals = (Double[])this.terrainToProbabilities.get(i).getValue();
                    for (int j = 0; j < vals.length; ++j) {
                        if (j != 0) {
                            out = (String)out + ",";
                        }
                        out = (String)out + vals[j];
                    }
                }
            } else {
                for (i = 0; i < this.defaultTerrain.length; ++i) {
                    if (i != 0) {
                        out = (String)out + "\n";
                    }
                    out = (String)out + this.defaultTerrain[i][0] + "=" + (String)this.worldTerrainTypeCombos.get(i).getSelectionModel().getSelectedItem();
                }
            }
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(f);
                OutputStreamWriter w = new OutputStreamWriter(fos);
                w.write((String)out);
                w.flush();
                fos.close();
                this.worldographer.addStatus("Saved " + (isRegion ? "region" : "world") + " terrain settings successfully", false);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public Stage getPopupStage() {
        return this.popupStage;
    }

    public static enum TerrainStyle {
        Classic,
        Isometric;

    }
}

