/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.ui.toolbox;

import com.inkwellideas.ographer.io.LoadImage;
import com.inkwellideas.ographer.model.Feature;
import com.inkwellideas.ographer.model.TextureType;
import com.inkwellideas.ographer.ui.Worldographer;
import com.inkwellideas.ographer.ui.toolbox.ShapesToolbox;
import com.inkwellideas.ographer.ui.toolbox.Toolbox;
import com.inkwellideas.ographer.ui.widget.FocusSpinner;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Spinner;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;

public class RoomToolbox
extends Toolbox {
    public ToggleButton newRoomButton = new ToggleButton("New Room");
    public Spinner<Double> tilesWideSpinner = new FocusSpinner<Double>(0.0, 100.0, 5.0, 0.5);
    public Spinner<Double> tilesHighSpinner = new FocusSpinner<Double>(0.0, 100.0, 5.0, 0.5);
    public Spinner<Integer> doorsTopSpinner = new FocusSpinner<Integer>(0, 100, 1, 1);
    public Spinner<Integer> doorsLeftSpinner = new FocusSpinner<Integer>(0, 100, 1, 1);
    public Spinner<Integer> doorsBottomSpinner = new FocusSpinner<Integer>(0, 100, 1, 1);
    public Spinner<Integer> doorsRightSpinner = new FocusSpinner<Integer>(0, 100, 1, 1);
    public Spinner<Integer> windowsTopSpinner = new FocusSpinner<Integer>(0, 100, 1, 1);
    public Spinner<Integer> windowsLeftSpinner = new FocusSpinner<Integer>(0, 100, 1, 1);
    public Spinner<Integer> windowsBottomSpinner = new FocusSpinner<Integer>(0, 100, 1, 1);
    public Spinner<Integer> windowsRightSpinner = new FocusSpinner<Integer>(0, 100, 1, 1);
    public Spinner<Integer> torchesTopSpinner = new FocusSpinner<Integer>(0, 100, 1, 1);
    public Spinner<Integer> torchesLeftSpinner = new FocusSpinner<Integer>(0, 100, 1, 1);
    public Spinner<Integer> torchesBottomSpinner = new FocusSpinner<Integer>(0, 100, 1, 1);
    public Spinner<Integer> torchesRightSpinner = new FocusSpinner<Integer>(0, 100, 1, 1);
    public Spinner<Integer> chairsSpinner = new FocusSpinner<Integer>(0, 8, 1, 1);
    public Spinner<Integer> sofasSpinner = new FocusSpinner<Integer>(0, 4, 1, 1);
    public Spinner<Integer> tablesSpinner = new FocusSpinner<Integer>(0, 20, 1, 1);
    public Spinner<Integer> bedsSpinner = new FocusSpinner<Integer>(0, 50, 1, 1);
    public Spinner<Integer> wallBookcasesSpinner = new FocusSpinner<Integer>(0, 100, 100, 10);
    static ObservableList<TextureType> texturesList = FXCollections.observableArrayList(TextureType.ALL_TEXTURES.values());
    public ComboBox<TextureType> floorTextureFillCombo = new ComboBox(texturesList);
    public ComboBox<TextureType> wallTextureStrokeCombo = new ComboBox(texturesList);
    public static String[] roomTypes = new String[]{"Empty/Hall", "Barracks", "Bedroom", "Dining", "Kitchen", "Library", "Study"};
    static ObservableList<String> roomList = FXCollections.observableArrayList((Object[])roomTypes);
    public ComboBox<String> roomTypeCombo = new ComboBox(roomList);
    public static String[] furniture = new String[]{"Pine", "Walnut", "Weathered"};
    static ObservableList<String> furnitureStyles = FXCollections.observableArrayList((Object[])furniture);
    public ComboBox<String> furnitureStylesCombo = new ComboBox(furnitureStyles);
    public CheckBox centerDoorsCheckBox = new CheckBox("Center Doors if wall < 2 tiles wide");
    public static String[] statues = new String[]{"None", "Corners", "Center of Walls", "Center of Room"};
    static ObservableList<String> statuesList = FXCollections.observableArrayList((Object[])statues);
    public ComboBox<String> statuesCombo = new ComboBox(statuesList);
    public static String[] bedType = new String[]{"Single", "Double", "Bunk"};
    static ObservableList<String> bedTypesList = FXCollections.observableArrayList((Object[])bedType);
    public ComboBox<String> bedTypeCombo = new ComboBox(bedTypesList);
    public static String[] walls = new String[]{"Top", "Left", "Bottom", "Right"};
    static ObservableList<String> wallsList = FXCollections.observableArrayList((Object[])walls);
    public ComboBox<String> bedWallsCombo = new ComboBox(wallsList);
    public ComboBox<String> heatSourcesWallsCombo = new ComboBox(wallsList);
    public static String[] cookSources = new String[]{"Cookery", "Firepit", "Fireplace"};
    static ObservableList<String> cookSourcesList = FXCollections.observableArrayList((Object[])cookSources);
    public ComboBox<String> heatSourcesCombo = new ComboBox(cookSourcesList);
    private Map<String, ToggleButton> featureButtons = new HashMap<String, ToggleButton>();
    List<ToggleButton> tableButtons = new ArrayList<ToggleButton>();
    List<ToggleButton> deskButtons = new ArrayList<ToggleButton>();
    List<ToggleButton> chairButtons = new ArrayList<ToggleButton>();
    List<ToggleButton> bookcaseButtons = new ArrayList<ToggleButton>();
    List<ToggleButton> bedButtons = new ArrayList<ToggleButton>();

    public RoomToolbox(Worldographer worldographer) {
        super(worldographer);
    }

    @Override
    public void setup(ToggleButton toggleButton) {
        this.createToolbox("Rooms", "other_imgs/hide_all_but_24.png", this.createRoomDrawer(this.worldographer.toggleGroup), 370, 85, true);
        this.stage.show();
        this.stage.setOnCloseRequest(event -> toggleButton.setSelected(false));
    }

    public Node createRoomDrawer(ToggleGroup toggleGroup) {
        ScrollPane scrollPane = new ScrollPane();
        BorderPane mainPane = new BorderPane();
        scrollPane.setContent((Node)mainPane);
        GridPane grid2 = new GridPane();
        mainPane.setTop((Node)grid2);
        grid2.setAlignment(Pos.TOP_LEFT);
        grid2.setHgap(5.0);
        grid2.setVgap(5.0);
        grid2.setPadding(new Insets(3.0, 3.0, 3.0, 3.0));
        Button instructionsbutton = new Button("", (Node)new ImageView(LoadImage.image("other_imgs/question.png")));
        instructionsbutton.setTooltip(new Tooltip("Help"));
        instructionsbutton.setOnAction(event -> {
            Dialog d = new Dialog();
            d.setTitle("Fog of War/Exploration Instructions");
            d.setHeaderText("How to Use Fog of War/Exploration in Worldographer");
            WebView view = new WebView();
            view.setMinSize(300.0, 300.0);
            view.setPrefSize(550.0, 350.0);
            WebEngine textengine = view.getEngine();
            textengine.loadContent("<style type=\"text/css\">p {font-family: Futura,Trebuchet MS,Arial,sans-serif; font-size:0.875em; padding: 0; margin: 0}\nh1,h2,h3 {font-family: Futura,Trebuchet MS,Arial,sans-serif; padding: 0; margin: 0}</style><ul>\n<p>Note: You need to make sure the \"Show GM Only Items\" checkbox on the \"View Options\" drawer is unchecked for\nthe Fog of War feature to work properly.  Otherwise, that setting is forcing all of the map to be shown.</p>\n<li>Select Area: Select an area by clicking the 'Select Map Area' button then click-dragging an area on the map or\nclicking the points of a polygon on the map. The selected area will turn yellow.\nThis area can either be set as the only area seen or the\narea hidden (see below). The area hidden or seen will be tile-based (hex or square, depending on map\ntype).  If the selected area touches any portion of a tile, it is in the selected area and will be\nhidden/seen.</li>\n<li>Temporarily Show All: In case you lose track of what is where, you can toggle this on and off to\nshow all the tiles on the map. Don't forget to hide your screen (turn off screen sharing) from your\nplayers first. Press this button again to deselect it and all the tiles that were hidden will be hidden\nagain, including any changes you made (added hidden/shown tiles) while it was selected.</li>\n<li>Hide All But Selected: Usually, once you select the initial region that the PCs know, click\nthis to hide the rest of the map. After that first use, you usually don't use this button again\nunless there is some reason the PCs would forget an area and you want to start the exploration over.</li>\n<li>Show Selected: This is probably the most commonly used button here (along with select area, which\ncan be left on).  Once you already have the next area the PCs can see selected on the map, click this\nand that area will be shown.</li>\n<li>Hide Selected: Did you accidentally reveal too much of the map?  Or is there a reason the PCs\nno longer know an area? Select an area on the map and then click this button to hide that region.</li></ul>\n");
            d.getDialogPane().setContent((Node)view);
            ButtonType yes = new ButtonType("OK");
            d.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{yes});
            d.showAndWait();
        });
        instructionsbutton.setAlignment(Pos.TOP_CENTER);
        this.newRoomButton.setToggleGroup(toggleGroup);
        grid2.add((Node)this.newRoomButton, 0, 0);
        grid2.add(this.roomTypeCombo, 1, 0);
        grid2.add((Node)new Label("Floor Texture:"), 0, 1);
        this.floorTextureFillCombo.setCellFactory(c -> new ShapesToolbox.TextureListCell());
        this.floorTextureFillCombo.setButtonCell((ListCell)new ShapesToolbox.TextureListCell());
        this.floorTextureFillCombo.getSelectionModel().select((Object)TextureType.ALL_TEXTURES.get("Pavers Light"));
        grid2.add(this.floorTextureFillCombo, 1, 1);
        grid2.add((Node)new Label("Wall Texture:"), 0, 2);
        this.wallTextureStrokeCombo.setCellFactory(c -> new ShapesToolbox.TextureListCell());
        this.wallTextureStrokeCombo.setButtonCell((ListCell)new ShapesToolbox.TextureListCell());
        this.wallTextureStrokeCombo.getSelectionModel().select((Object)TextureType.ALL_TEXTURES.get("Rock Dark"));
        grid2.add(this.wallTextureStrokeCombo, 1, 2);
        grid2.add((Node)new Label("Tiles Wide:"), 0, 3);
        this.tilesWideSpinner.setMaxWidth(80.0);
        grid2.add(this.tilesWideSpinner, 1, 3);
        grid2.add((Node)new Label("Tiles High:"), 0, 4);
        this.tilesHighSpinner.setMaxWidth(80.0);
        grid2.add(this.tilesHighSpinner, 1, 4);
        Label doorsLabel = new Label("Doors:");
        doorsLabel.setAlignment(Pos.TOP_LEFT);
        grid2.add((Node)doorsLabel, 0, 5);
        FlowPane doorsPane = new FlowPane();
        grid2.add((Node)doorsPane, 1, 5, 2, 1);
        doorsPane.getChildren().add((Object)this.makeHBoxForLabelAndSpinner("Top:", 60, this.doorsTopSpinner));
        doorsPane.getChildren().add((Object)this.makeHBoxForLabelAndSpinner(" Left:", 60, this.doorsLeftSpinner));
        doorsPane.getChildren().add((Object)this.makeHBoxForLabelAndSpinner(" Bottom:", 60, this.doorsBottomSpinner));
        doorsPane.getChildren().add((Object)this.makeHBoxForLabelAndSpinner(" Right:", 60, this.doorsRightSpinner));
        Label windowsLabel = new Label("Windows:");
        windowsLabel.setAlignment(Pos.TOP_LEFT);
        grid2.add((Node)windowsLabel, 0, 6);
        FlowPane windowsPane = new FlowPane();
        grid2.add((Node)windowsPane, 1, 6, 2, 1);
        windowsPane.getChildren().add((Object)this.makeHBoxForLabelAndSpinner("Top:", 60, this.windowsTopSpinner));
        windowsPane.getChildren().add((Object)this.makeHBoxForLabelAndSpinner(" Left:", 60, this.windowsLeftSpinner));
        windowsPane.getChildren().add((Object)this.makeHBoxForLabelAndSpinner(" Bottom:", 60, this.windowsBottomSpinner));
        windowsPane.getChildren().add((Object)this.makeHBoxForLabelAndSpinner(" Right:", 60, this.windowsRightSpinner));
        Label torchesLabel = new Label("Torches:");
        torchesLabel.setAlignment(Pos.TOP_LEFT);
        grid2.add((Node)torchesLabel, 0, 7);
        FlowPane torchesPane = new FlowPane();
        grid2.add((Node)torchesPane, 1, 7, 2, 1);
        torchesPane.getChildren().add((Object)this.makeHBoxForLabelAndSpinner("Top:", 60, this.torchesTopSpinner));
        torchesPane.getChildren().add((Object)this.makeHBoxForLabelAndSpinner(" Left:", 60, this.torchesLeftSpinner));
        torchesPane.getChildren().add((Object)this.makeHBoxForLabelAndSpinner(" Bottom:", 60, this.torchesBottomSpinner));
        torchesPane.getChildren().add((Object)this.makeHBoxForLabelAndSpinner(" Right:", 60, this.torchesRightSpinner));
        grid2.add((Node)new Label("Furniture:"), 0, 10);
        this.furnitureStylesCombo.setMaxWidth(150.0);
        grid2.add(this.furnitureStylesCombo, 1, 10);
        this.furnitureStylesCombo.getSelectionModel().select((Object)"Pine");
        this.statuesCombo.getSelectionModel().select(0);
        this.bedWallsCombo.getSelectionModel().select(0);
        this.bedTypeCombo.getSelectionModel().select(0);
        this.heatSourcesWallsCombo.getSelectionModel().select(0);
        this.heatSourcesCombo.getSelectionModel().select(0);
        GridPane detailsPane = new GridPane();
        mainPane.setCenter((Node)detailsPane);
        this.roomTypeCombo.setOnAction(event -> this.updateDetailsPane(detailsPane));
        return scrollPane;
    }

    private HBox makeHBoxForLabelAndSpinner(String labelText, int maxSpinnerWidth, Spinner spinner) {
        spinner.setMaxWidth((double)maxSpinnerWidth);
        HBox box = new HBox(new Node[]{new Label(labelText), spinner});
        box.setAlignment(Pos.CENTER_LEFT);
        return box;
    }

    private void updateDetailsPane(GridPane detailsPane) {
        detailsPane.getChildren().clear();
        if (((String)this.roomTypeCombo.getValue()).equals("Empty/Hall")) {
            detailsPane.add((Node)this.centerDoorsCheckBox, 0, 0, 2, 1);
        } else if (((String)this.roomTypeCombo.getValue()).equals("Library")) {
            this.addLibraryControls(detailsPane);
        } else if (((String)this.roomTypeCombo.getValue()).equals("Bedroom")) {
            this.addBedroomControls(detailsPane);
        } else if (((String)this.roomTypeCombo.getValue()).equals("Barracks")) {
            this.addBarracksControls(detailsPane);
        } else if (((String)this.roomTypeCombo.getValue()).equals("Dining")) {
            this.addDiningControls(detailsPane);
        } else if (((String)this.roomTypeCombo.getValue()).equals("Kitchen")) {
            this.addKitchenControls(detailsPane);
        } else if (((String)this.roomTypeCombo.getValue()).equals("Study")) {
            this.addStudyControls(detailsPane);
        }
    }

    private void addDiningControls(GridPane detailsPane) {
        this.tableButtons = new ArrayList<ToggleButton>();
        this.chairButtons = new ArrayList<ToggleButton>();
        detailsPane.add((Node)new Label("Max Tables:"), 0, 1);
        detailsPane.add(this.tablesSpinner, 1, 1);
        detailsPane.add((Node)new Label("Table Types:"), 0, 3, 2, 1);
        HBox tablesBox = new HBox();
        HBox chairsBox = new HBox();
        for (String fName : Feature.featureTypes.keySet()) {
            ToggleButton fButton;
            if (fName.toLowerCase().contains(" table") || fName.toLowerCase().contains("table ") || fName.equalsIgnoreCase("table")) {
                fButton = this.makeFeatureToggleButton(new Feature(fName), 80);
                if (fName.equals("Battlemat/Table Rectangle Weathered")) {
                    fButton.setSelected(true);
                }
                tablesBox.getChildren().add((Object)fButton);
                this.tableButtons.add(fButton);
                continue;
            }
            if (!fName.toLowerCase().contains(" chair") && !fName.toLowerCase().contains("chair ") && !fName.equalsIgnoreCase("chair")) continue;
            fButton = this.makeFeatureToggleButton(new Feature(fName), 80);
            if (fName.equals("Battlemat/Chair Weathered")) {
                fButton.setSelected(true);
            }
            chairsBox.getChildren().add((Object)fButton);
            this.chairButtons.add(fButton);
        }
        detailsPane.add((Node)new ScrollPane((Node)tablesBox), 0, 4, 2, 1);
        detailsPane.add((Node)new Label("Chair Types:"), 0, 5, 2, 1);
        detailsPane.add((Node)new ScrollPane((Node)chairsBox), 0, 6, 2, 1);
    }

    private void addBarracksControls(GridPane detailsPane) {
        this.bedButtons = new ArrayList<ToggleButton>();
        detailsPane.add((Node)new Label("Bed Types:"), 0, 3, 2, 1);
        HBox bedsBox = new HBox();
        for (String fName : Feature.featureTypes.keySet()) {
            if (!fName.toLowerCase().contains(" bed") && !fName.toLowerCase().contains("bed ")) continue;
            ToggleButton fButton = this.makeFeatureToggleButton(new Feature(fName), 80);
            if (fName.equals("Battlemat/Bed Blue Pine")) {
                fButton.setSelected(true);
            }
            bedsBox.getChildren().add((Object)fButton);
            this.bedButtons.add(fButton);
        }
        detailsPane.add((Node)new ScrollPane((Node)bedsBox), 0, 4, 2, 1);
    }

    private void addStudyControls(GridPane detailsPane) {
        this.deskButtons = new ArrayList<ToggleButton>();
        this.bookcaseButtons = new ArrayList<ToggleButton>();
        this.chairButtons = new ArrayList<ToggleButton>();
        detailsPane.add((Node)new Label("Max Bookcases:"), 0, 1);
        detailsPane.add(this.wallBookcasesSpinner, 1, 1);
        detailsPane.add((Node)new Label("Desk Types:"), 0, 3, 2, 1);
        HBox desksBox = new HBox();
        HBox chairsBox = new HBox();
        HBox bookcasesBox = new HBox();
        for (String fName : Feature.featureTypes.keySet()) {
            ToggleButton fButton;
            if (fName.toLowerCase().contains(" desk") || fName.toLowerCase().contains("desk ") || fName.equalsIgnoreCase("desk")) {
                fButton = this.makeFeatureToggleButton(new Feature(fName), 80);
                if (fName.equals("Battlemat/Desk Walnut")) {
                    fButton.setSelected(true);
                }
                desksBox.getChildren().add((Object)fButton);
                this.deskButtons.add(fButton);
                continue;
            }
            if (fName.toLowerCase().contains(" chair") || fName.toLowerCase().contains("chair ") || fName.equalsIgnoreCase("chair")) {
                fButton = this.makeFeatureToggleButton(new Feature(fName), 80);
                if (fName.equals("Battlemat/Chair Walnut")) {
                    fButton.setSelected(true);
                }
                chairsBox.getChildren().add((Object)fButton);
                this.chairButtons.add(fButton);
                continue;
            }
            if (!fName.toLowerCase().contains(" bookcase") && !fName.toLowerCase().contains("bookcase ") && !fName.equalsIgnoreCase("bookcase")) continue;
            fButton = this.makeFeatureToggleButton(new Feature(fName), 80);
            if (fName.equals("Battlemat/Bookcase Walnut")) {
                fButton.setSelected(true);
            }
            bookcasesBox.getChildren().add((Object)fButton);
            this.bookcaseButtons.add(fButton);
        }
        detailsPane.add((Node)new ScrollPane((Node)desksBox), 0, 4, 2, 1);
        detailsPane.add((Node)new Label("Chair Types:"), 0, 5, 2, 1);
        detailsPane.add((Node)new ScrollPane((Node)chairsBox), 0, 6, 2, 1);
        detailsPane.add((Node)new Label("Bookcase Types:"), 0, 7, 2, 1);
        detailsPane.add((Node)new ScrollPane((Node)bookcasesBox), 0, 8, 2, 1);
    }

    public List<String> getSelectedTables() {
        ArrayList<String> selectedTables = new ArrayList<String>();
        for (ToggleButton tb : this.tableButtons) {
            if (!tb.isSelected()) continue;
            selectedTables.add(((Feature)tb.getUserData()).getTypeName());
        }
        return selectedTables;
    }

    public List<String> getSelectedBeds() {
        ArrayList<String> selectedBeds = new ArrayList<String>();
        for (ToggleButton tb : this.bedButtons) {
            if (!tb.isSelected()) continue;
            selectedBeds.add(((Feature)tb.getUserData()).getTypeName());
        }
        return selectedBeds;
    }

    public List<String> getSelectedBookcases() {
        ArrayList<String> selectedTables = new ArrayList<String>();
        for (ToggleButton tb : this.bookcaseButtons) {
            if (!tb.isSelected()) continue;
            selectedTables.add(((Feature)tb.getUserData()).getTypeName());
        }
        return selectedTables;
    }

    public List<String> getSelectedDesks() {
        ArrayList<String> selectedTables = new ArrayList<String>();
        for (ToggleButton tb : this.deskButtons) {
            if (!tb.isSelected()) continue;
            selectedTables.add(((Feature)tb.getUserData()).getTypeName());
        }
        return selectedTables;
    }

    public List<String> getSelectedChairs() {
        ArrayList<String> selectedChairs = new ArrayList<String>();
        for (ToggleButton tb : this.chairButtons) {
            if (!tb.isSelected()) continue;
            selectedChairs.add(((Feature)tb.getUserData()).getTypeName());
        }
        return selectedChairs;
    }

    private void addBedroomControls(GridPane detailsPane) {
        detailsPane.add((Node)new Label("Bed Wall:"), 0, 1);
        detailsPane.add(this.bedWallsCombo, 1, 1);
        detailsPane.add((Node)new Label("Bed Type:"), 0, 2);
        detailsPane.add(this.bedTypeCombo, 1, 2);
    }

    private void addKitchenControls(GridPane detailsPane) {
        detailsPane.add((Node)new Label("Heat Source Wall:"), 0, 1);
        detailsPane.add(this.heatSourcesWallsCombo, 1, 1);
        detailsPane.add((Node)new Label("Heat Source:"), 0, 2);
        detailsPane.add(this.heatSourcesCombo, 1, 2);
    }

    private void addLibraryControls(GridPane detailsPane) {
        detailsPane.add((Node)new Label("Statues:"), 0, 0);
        detailsPane.add(this.statuesCombo, 1, 0);
        detailsPane.add((Node)new Label("Sofas:"), 0, 1);
        detailsPane.add(this.sofasSpinner, 1, 1);
        detailsPane.add((Node)new Label("Chairs:"), 0, 2);
        detailsPane.add(this.chairsSpinner, 1, 2);
        detailsPane.add((Node)new Label("Wall Bookcases:"), 0, 3);
        HBox bookcases = new HBox();
        bookcases.getChildren().add(this.wallBookcasesSpinner);
        bookcases.getChildren().add((Object)new Label("%"));
        detailsPane.add((Node)bookcases, 1, 3);
    }

    private ToggleButton makeFeatureToggleButton(Feature f, int size) {
        ToggleButton button = this.featureButtons.get(f.getTypeName());
        if (button == null) {
            Image icon = f.type().getIcon();
            ImageView iv = new ImageView(icon);
            iv.setPreserveRatio(true);
            iv.setFitHeight((double)size);
            iv.setFitWidth((double)size);
            button = new ToggleButton("", (Node)iv);
            button.setUserData((Object)f);
            button.setTooltip(new Tooltip(f.getTypeName()));
            this.featureButtons.put(f.getTypeName(), button);
        }
        return button;
    }
}

