/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.ui.widget;

import com.inkwellideas.ographer.io.FileSaveLoad;
import com.inkwellideas.ographer.io.UserPrefs;
import com.inkwellideas.ographer.map.Terrain;
import com.inkwellideas.ographer.model.Feature;
import com.inkwellideas.ographer.model.FeatureType;
import com.inkwellideas.ographer.model.TerrainType;
import com.inkwellideas.ographer.model.TextureType;
import com.inkwellideas.ographer.ui.Worldographer;
import com.inkwellideas.ographer.ui.configure.ConfigureLabelStylesScreen;
import com.inkwellideas.ographer.ui.dialog.AddCustomFeatureTerrainTexture;
import com.inkwellideas.ographer.ui.dialog.ConfigurationDialog;
import com.inkwellideas.ographer.ui.dialog.StandardDialog;
import com.inkwellideas.ographer.ui.widget.StyledDialog;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javafx.application.Platform;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBoxTreeItem;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.control.cell.CheckBoxTreeCell;
import javafx.scene.layout.VBox;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;

public class WorldographerConfigMenuBar {
    public void createMenuBarConfig(final Worldographer worldographer, Menu menuConfigure, MenuItem saveConfig, MenuItem loadConfig) {
        MenuItem showConfigFolderMenuItem = new MenuItem("Show Configuration Folder");
        showConfigFolderMenuItem.setOnAction(t -> StandardDialog.showDialog(worldographer.getPrimaryStage(), "Configuration Folder", "Configuration Folder Location", "You can add icons to Worldographer automatically by placing them in subfolders of the following folder:\n" + UserPrefs.CONFIG_FOLDER + "\nFull instructions are on the Worldographer website.  See the Instructions menu and pick the How to Easily Add Custom\n Icons link. Note: Restart Worldographer after changing the contents of the Worldographer folder to see changes.", null, ""));
        MenuItem changeConfigFolderMenuItem = new MenuItem("Change Configuration Folder");
        changeConfigFolderMenuItem.setOnAction(t -> {
            File f;
            DirectoryChooser fc = new DirectoryChooser();
            File d = FileSaveLoad.getLastUsedDir();
            if (d != null) {
                fc.setInitialDirectory(d);
            }
            if ((f = fc.showDialog(null)) != null) {
                UserPrefs.CONFIG_FOLDER = f.getAbsolutePath();
                UserPrefs.PREFS.put("configfolder", f.getAbsolutePath());
                StandardDialog.showDialog(worldographer.getPrimaryStage(), "Configuration Folder Updated", "Configuration Folder Updated", "You need to restart Worldographer for this change to take effect.\n\nThe configuration folder is now: " + f.getAbsolutePath(), null, "");
            }
            Worldographer.pingUsage("http://www.worldographer.com/usage/menu_changeConfigFolder.txt");
        });
        MenuItem addConfigSubfoldersMenuItem = new MenuItem("Add Configuration Subfolders");
        addConfigSubfoldersMenuItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(this){

            public void handle(ActionEvent t) {
                if (UserPrefs.FULL) {
                    final File rootfile = new File(UserPrefs.PREFS.get("configfolder", ""));
                    final CheckBoxTreeItem root = new CheckBoxTreeItem((Object)"Root node");
                    this.addSubfoldersToTree((TreeItem<String>)root, rootfile, true);
                    root.setExpanded(true);
                    TreeView treeView = new TreeView((TreeItem)root);
                    treeView.setShowRoot(false);
                    treeView.setCellFactory(e -> new CheckBoxTreeCell());
                    StyledDialog d2 = new StyledDialog(true, (Window)worldographer.getPrimaryStage(), "Add Configuration Subfolders");
                    VBox box = new VBox();
                    box.getChildren().add((Object)new Label("This tree is based on all the subfolders of your\nconfiguration folder that have features, terrain, or\ntextures subfolders of their own.\n"));
                    box.getChildren().add((Object)treeView);
                    d2.getDialogPane().setContent((Node)box);
                    ButtonType ok1 = new ButtonType("OK");
                    ButtonType cancel = new ButtonType("Cancel");
                    d2.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ok1, cancel});
                    Optional result = d2.showAndWait();
                    if (result.isPresent() && result.get() == ok1) {
                        Task<Void> task = new Task<Void>(this){
                            int terrainCount = 0;
                            int featureCount = 0;
                            int textureCount = 0;
                            final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            public Void call() {
                                this.loadSelected((CheckBoxTreeItem<String>)root, "", rootfile);
                                return null;
                            }

                            private void loadSelected(CheckBoxTreeItem<String> node, String parentfolders, File parent) {
                                for (TreeItem child : node.getChildren()) {
                                    CheckBoxTreeItem cbchild = (CheckBoxTreeItem)child;
                                    File childfile = new File(String.valueOf(parent.getAbsoluteFile()) + File.separator + (String)child.getValue());
                                    if (cbchild.isSelected()) {
                                        for (File subdir : Objects.requireNonNull(childfile.listFiles())) {
                                            if (subdir.isDirectory() && "features".equalsIgnoreCase(subdir.getName())) {
                                                this.featureCount = this.this$1.loadFeaturesRecurse((String)child.getValue(), subdir, this.featureCount);
                                                System.out.println("featureCount:" + this.featureCount);
                                                continue;
                                            }
                                            if (subdir.isDirectory() && "terrain".equalsIgnoreCase(subdir.getName())) {
                                                this.terrainCount = this.this$1.loadTerrainRecurse((String)child.getValue(), subdir, this.terrainCount);
                                                continue;
                                            }
                                            if (!subdir.isDirectory() || !"textures".equalsIgnoreCase(subdir.getName())) continue;
                                            this.textureCount = this.this$1.loadTexturesRecurse(subdir, this.textureCount);
                                            this.this$1.worldographer.shapesToolbox.updateTextures();
                                        }
                                    }
                                    this.loadSelected((CheckBoxTreeItem<String>)cbchild, parentfolders + "/" + ((String)child.getValue()).toLowerCase(), childfile);
                                }
                                System.out.println("featureCount2:" + this.featureCount);
                                final int finalTerrainCount = this.terrainCount;
                                final int finalFeatureCount = this.featureCount;
                                final int finalTextureCount = this.textureCount;
                                System.out.println("finalFeatureCount:" + finalFeatureCount);
                                Platform.runLater((Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        Worldographer.getWorldographer().addStatus(finalTerrainCount + " terrain, " + finalFeatureCount + " features, & " + finalTextureCount + " textures added.", false);
                                    }
                                });
                            }
                        };
                        new Thread((Runnable)task).start();
                    }
                    Worldographer.pingUsage("http://www.worldographer.com/usage/menu_configSubfolders.txt");
                } else {
                    StandardDialog.showDialog(worldographer.getPrimaryStage(), "Pro Feature", "Adding custom terrain is only available if using a Pro version license.", "Sorry, some features are reserved for our Pro/paid version. \nIf you find the software useful, considering unlocking these special features and supporting \nthe many hours of work to create Worldographer with a Pro license. \nSee www.worldographer.com for details.\n", null, "");
                }
            }

            private int loadFeaturesRecurse(String folder, File featuresDir, int count) {
                for (File childfile : Objects.requireNonNull(featuresDir.listFiles())) {
                    if (childfile.isDirectory()) {
                        count = this.loadFeaturesRecurse(folder, childfile, count);
                        continue;
                    }
                    String category = folder + " ";
                    boolean success = FeatureType.loadUserFeatureSingleFile(category, Feature.featureTypes, childfile);
                    if (success) {
                        ++count;
                    }
                    if (!success || Worldographer.featureCategories.contains((Object)folder)) continue;
                    Worldographer.featureCategories.add((Object)folder);
                }
                return count;
            }

            private int loadTerrainRecurse(String folder, File terrainDir, int count) {
                for (File childfile : Objects.requireNonNull(terrainDir.listFiles())) {
                    if (childfile.isDirectory()) {
                        count = this.loadTerrainRecurse(folder, childfile, count);
                        continue;
                    }
                    String category = folder + " ";
                    boolean success = TerrainType.loadUserTerrainSingleFile(category, Terrain.terrainTypes, childfile, -1.0, null);
                    if (success) {
                        ++count;
                    }
                    if (!success || Worldographer.terrainCategories.contains((Object)folder)) continue;
                    Worldographer.terrainCategories.add((Object)folder);
                }
                return count;
            }

            private int loadTexturesRecurse(File textureDir, int count) {
                for (File childfile : Objects.requireNonNull(textureDir.listFiles())) {
                    if (childfile.isDirectory()) {
                        count = this.loadTexturesRecurse(childfile, count);
                        continue;
                    }
                    boolean success = TextureType.loadUserTextureSingleFile(childfile);
                    if (!success) continue;
                    ++count;
                }
                return count;
            }

            private boolean addSubfoldersToTree(TreeItem<String> parentItem, File parentfile, boolean istoplevel) {
                if (parentfile == null || parentfile.listFiles() == null) {
                    return false;
                }
                boolean hadadirectorywewant = false;
                for (File f : Objects.requireNonNull(parentfile.listFiles())) {
                    boolean b;
                    if (!f.isDirectory()) continue;
                    String lowercasename = f.getName().toLowerCase();
                    boolean bl = b = "features".equals(lowercasename) || "terrain".equals(lowercasename) || "textures".equals(lowercasename);
                    if (istoplevel && b) continue;
                    if (b) {
                        hadadirectorywewant = true;
                        continue;
                    }
                    CheckBoxTreeItem childNode = new CheckBoxTreeItem((Object)f.getName());
                    parentItem.getChildren().add((Object)childNode);
                    boolean result = this.addSubfoldersToTree((TreeItem<String>)childNode, f, false);
                    if (result) {
                        hadadirectorywewant = true;
                    }
                    if (result || childNode.getChildren().size() != 0) continue;
                    parentItem.getChildren().remove((Object)childNode);
                }
                return hadadirectorywewant;
            }
        });
        MenuItem customTerrain = new MenuItem("Add Custom Terrain");
        customTerrain.setOnAction(t -> {
            if (UserPrefs.FULL) {
                FileChooser fc = new FileChooser();
                fc.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Portable Network Graphic (*.png)", new String[]{"*.png"}));
                fc.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Graphic Interchange Format (*.gif)", new String[]{"*.gif"}));
                fc.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Joint Photographer Experts Group (*.jpg)", new String[]{"*.jpg"}));
                File d = FileSaveLoad.getLastUsedDir();
                if (d != null) {
                    fc.setInitialDirectory(d);
                }
                List fs = fc.showOpenMultipleDialog((Window)worldographer.getPrimaryStage());
                WorldographerConfigMenuBar.addCustomTerrain(worldographer, fs);
            } else {
                StandardDialog.showDialog(worldographer.getPrimaryStage(), "Pro Feature", "Adding custom terrain is only available if using a Pro version license.", "Sorry, some features are reserved for our Pro/paid version. \nIf you find the software useful, considering unlocking these special features and supporting \nthe many hours of work to create Worldographer with a Pro license. \nSee www.worldographer.com for details.\n", null, "");
            }
        });
        MenuItem customTerrainFolder = new MenuItem("Add Custom Terrain Folder");
        customTerrainFolder.setOnAction(t -> {
            if (UserPrefs.FULL) {
                DirectoryChooser dc = new DirectoryChooser();
                File d = FileSaveLoad.getLastUsedDir();
                if (d != null) {
                    dc.setInitialDirectory(d);
                }
                File folder = dc.showDialog((Window)worldographer.getPrimaryStage());
                ArrayList<File> fs = new ArrayList<File>();
                WorldographerConfigMenuBar.getAllImageFilesRecurse(folder, fs);
                WorldographerConfigMenuBar.addCustomTerrain(worldographer, fs);
            } else {
                StandardDialog.showDialog(worldographer.getPrimaryStage(), "Pro Feature", "Adding custom terrain is only available if using a Pro version license.", "Sorry, some features are reserved for our Pro/paid version. \nIf you find the software useful, considering unlocking these special features and supporting \nthe many hours of work to create Worldographer with a Pro license. \nSee www.worldographer.com for details.\n", null, "");
            }
        });
        MenuItem customFeaturesFolder = new MenuItem("Add Custom Features Folder");
        customFeaturesFolder.setOnAction(t -> {
            if (UserPrefs.FULL) {
                DirectoryChooser dc = new DirectoryChooser();
                File d = FileSaveLoad.getLastUsedDir();
                if (d != null) {
                    dc.setInitialDirectory(d);
                }
                File folder = dc.showDialog((Window)worldographer.getPrimaryStage());
                ArrayList<File> fs = new ArrayList<File>();
                WorldographerConfigMenuBar.getAllImageFilesRecurse(folder, fs);
                WorldographerConfigMenuBar.addCustomFeatures(worldographer, fs);
            } else {
                StandardDialog.showDialog(worldographer.getPrimaryStage(), "Pro Feature", "Adding custom features is only available if using a Pro version license.", "Sorry, some features are reserved for our Pro/paid version. \nIf you find the software useful, considering unlocking these special features and supporting \nthe many hours of work to create Worldographer with a Pro license. \nSee www.worldographer.com for details.\n", null, "");
            }
        });
        MenuItem customFeatures = new MenuItem("Add Custom Features");
        customFeatures.setOnAction(t -> {
            if (UserPrefs.FULL) {
                FileChooser fc = new FileChooser();
                fc.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Portable Network Graphic (*.png)", new String[]{"*.png"}));
                fc.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Graphic Interchange Format (*.gif)", new String[]{"*.gif"}));
                fc.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Joint Photographer Experts Group (*.jpg)", new String[]{"*.jpg"}));
                File d = FileSaveLoad.getLastUsedDir();
                if (d != null) {
                    fc.setInitialDirectory(d);
                }
                List fs = fc.showOpenMultipleDialog((Window)worldographer.getPrimaryStage());
                WorldographerConfigMenuBar.addCustomFeatures(worldographer, fs);
            } else {
                StandardDialog.showDialog(worldographer.getPrimaryStage(), "Pro Feature", "Adding custom features is only available if using a Pro version license.", "Sorry, some features are reserved for our Pro/paid version. \nIf you find the software useful, considering unlocking these special features and supporting \nthe many hours of work to create Worldographer with a Pro license. \nSee www.worldographer.com for details.\n", null, "");
            }
        });
        MenuItem customTextures = new MenuItem("Add Custom Textures");
        customTextures.setOnAction(t -> {
            if (UserPrefs.FULL) {
                FileChooser fc = new FileChooser();
                fc.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Portable Network Graphic (*.png)", new String[]{"*.png"}));
                fc.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Graphic Interchange Format (*.gif)", new String[]{"*.gif"}));
                fc.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Joint Photographer Experts Group (*.jpg)", new String[]{"*.jpg"}));
                File d = FileSaveLoad.getLastUsedDir();
                if (d != null) {
                    fc.setInitialDirectory(d);
                }
                List fs = fc.showOpenMultipleDialog((Window)worldographer.getPrimaryStage());
                int count = 0;
                if (fs != null) {
                    for (File f : fs) {
                        TextureType.loadUserTextureSingleFile(f);
                        ++count;
                    }
                }
                worldographer.shapesToolbox.updateTextures();
                final int finalCount = count;
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Worldographer.getWorldographer().addStatus(finalCount + " textures added. Choose 'Configure Textures' from the Configure menu to customize.", false);
                    }
                });
                Worldographer.pingUsage("http://www.worldographer.com/usage/menu_addCustomTextures.txt");
            } else {
                StandardDialog.showDialog(worldographer.getPrimaryStage(), "Pro Feature", "Adding custom textures is only available if using a Pro version license.", "Sorry, some features are reserved for our Pro/paid version. \nIf you find the software useful, considering unlocking these special features and supporting \nthe many hours of work to create Worldographer with a Pro license. \nSee www.worldographer.com for details.\n", null, "");
            }
        });
        MenuItem configureTerrain = new MenuItem("Configure Terrain");
        configureTerrain.setOnAction(event -> new ConfigurationDialog().launchConfigureTerrain(worldographer));
        MenuItem configureFeatures = new MenuItem("Configure Features");
        configureFeatures.setOnAction(event -> new ConfigurationDialog().launchConfigureFeatures(worldographer));
        MenuItem configureTextures = new MenuItem("Configure Textures");
        configureTextures.setOnAction(event -> new ConfigurationDialog().launchConfigureTextures(worldographer));
        MenuItem configureLabelStyles = new MenuItem("Configure Label Styles");
        configureLabelStyles.setOnAction(event -> {
            if (Worldographer.getMapUI() == null) {
                StandardDialog.showDialog(worldographer.getPrimaryStage(), "No Map Open", "Label Styles are Part of a Map.", "Label styles are part of a specific map. Create or Load a map to configure the map's styles.", null, null);
            } else if (UserPrefs.FULL) {
                Stage stage = new Stage();
                ConfigureLabelStylesScreen ss = new ConfigureLabelStylesScreen(worldographer);
                ss.start(stage);
                stage.show();
            } else {
                StandardDialog.showDialog(worldographer.getPrimaryStage(), "Pro Feature", "Configuring label styles is only available if using a Pro version license.", "Sorry, some features are reserved for our Pro/paid version. \nIf you find the software useful, considering unlocking these special features and supporting \nthe many hours of work to create Worldographer with a Pro license. \nSee www.worldographer.com for details.\n", null, "");
            }
        });
        MenuItem configureDynamicTerrain = new MenuItem("Configure Dynamic Terrain");
        configureDynamicTerrain.setOnAction(event -> new ConfigurationDialog().launchConfigureDynamicTerrain(worldographer));
        MenuItem configureSettlementData = new MenuItem("Configure Settlement Data");
        configureSettlementData.setOnAction(event -> new ConfigurationDialog().launchConfigureCityData(worldographer));
        MenuItem configureWorldNameData = new MenuItem("Configure World & Name Data");
        configureWorldNameData.setOnAction(event -> new ConfigurationDialog().launchConfigureWorldNameData(worldographer));
        menuConfigure.getItems().addAll((Object[])new MenuItem[]{saveConfig, loadConfig, new SeparatorMenuItem(), showConfigFolderMenuItem, changeConfigFolderMenuItem, addConfigSubfoldersMenuItem, new SeparatorMenuItem(), customTerrain, customTerrainFolder, customFeatures, customFeaturesFolder, customTextures, new SeparatorMenuItem(), configureTerrain, configureFeatures, configureTextures, configureLabelStyles, new SeparatorMenuItem(), configureDynamicTerrain, configureSettlementData, configureWorldNameData});
    }

    private static void addCustomFeatures(Worldographer worldographer, List<File> fs) {
        int count = 0;
        if (fs != null) {
            count = new AddCustomFeatureTerrainTexture().addCustomFeatureTerrainTexture(worldographer, fs, "Features", count, (List<String>)Worldographer.featureCategories);
        }
        worldographer.featuresToolbox.updateFeatureButtons();
        final int finalCount = count;
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                Worldographer.getWorldographer().addStatus(finalCount + " features added. Choose 'Configure Features' from the Configure menu to customize.", false);
            }
        });
        Worldographer.pingUsage("http://www.worldographer.com/usage/menu_addCustomFeatures.txt");
    }

    private static void getAllImageFilesRecurse(File folder, List<File> fs) {
        for (File f : Objects.requireNonNull(folder.listFiles())) {
            if (f.isDirectory()) {
                WorldographerConfigMenuBar.getAllImageFilesRecurse(f, fs);
                continue;
            }
            if (!f.getName().endsWith(".png") && !f.getName().endsWith(".gif") && !f.getName().endsWith(".jpg") && !f.getName().endsWith(".jpeg")) continue;
            fs.add(f);
        }
    }

    private static void addCustomTerrain(Worldographer worldographer, List<File> fs) {
        int count = 0;
        if (fs != null) {
            count = new AddCustomFeatureTerrainTexture().addCustomFeatureTerrainTexture(worldographer, fs, "Terrain", count, (List<String>)Worldographer.terrainCategories);
        }
        worldographer.terrainToolbox.updateTerrainButtonsFlow();
        final int finalCount = count;
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                Worldographer.getWorldographer().addStatus(finalCount + " terrain added. Choose 'Configure Features' from the Configure menu to customize.", false);
            }
        });
        Worldographer.pingUsage("http://www.worldographer.com/usage/menu_addCustomTerrain.txt");
    }
}

