/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.html2md.converter;

import com.vladsch.flexmark.ast.Reference;
import com.vladsch.flexmark.html.renderer.HeaderIdGeneratorFactory;
import com.vladsch.flexmark.html.renderer.LinkStatus;
import com.vladsch.flexmark.html.renderer.LinkType;
import com.vladsch.flexmark.html.renderer.ResolvedLink;
import com.vladsch.flexmark.html2md.converter.DelegatingNodeRendererFactoryWrapper;
import com.vladsch.flexmark.html2md.converter.ExtensionConversion;
import com.vladsch.flexmark.html2md.converter.HtmlConverterCoreNodeRendererFactory;
import com.vladsch.flexmark.html2md.converter.HtmlConverterOptions;
import com.vladsch.flexmark.html2md.converter.HtmlConverterPhase;
import com.vladsch.flexmark.html2md.converter.HtmlConverterState;
import com.vladsch.flexmark.html2md.converter.HtmlLinkResolver;
import com.vladsch.flexmark.html2md.converter.HtmlLinkResolverFactory;
import com.vladsch.flexmark.html2md.converter.HtmlMarkdownWriter;
import com.vladsch.flexmark.html2md.converter.HtmlNodeConverterContext;
import com.vladsch.flexmark.html2md.converter.HtmlNodeConverterSubContext;
import com.vladsch.flexmark.html2md.converter.HtmlNodeRenderer;
import com.vladsch.flexmark.html2md.converter.HtmlNodeRendererFactory;
import com.vladsch.flexmark.html2md.converter.HtmlNodeRendererHandler;
import com.vladsch.flexmark.html2md.converter.LinkConversion;
import com.vladsch.flexmark.html2md.converter.NodeRenderingHandlerWrapper;
import com.vladsch.flexmark.html2md.converter.PhasedHtmlNodeRenderer;
import com.vladsch.flexmark.html2md.converter.internal.HtmlConverterCoreNodeRenderer;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.Ref;
import com.vladsch.flexmark.util.Utils;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.builder.BuilderBase;
import com.vladsch.flexmark.util.builder.Extension;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.DataKey;
import com.vladsch.flexmark.util.data.DataSet;
import com.vladsch.flexmark.util.data.MutableDataHolder;
import com.vladsch.flexmark.util.data.ScopedDataSet;
import com.vladsch.flexmark.util.dependency.DependencyHandler;
import com.vladsch.flexmark.util.dependency.FlatDependencyHandler;
import com.vladsch.flexmark.util.dependency.ResolvedDependencies;
import com.vladsch.flexmark.util.format.RomanNumeral;
import com.vladsch.flexmark.util.format.TableFormatOptions;
import com.vladsch.flexmark.util.format.options.TableCaptionHandling;
import com.vladsch.flexmark.util.html.Attributes;
import com.vladsch.flexmark.util.html.CellAlignment;
import com.vladsch.flexmark.util.html.LineFormattingAppendable;
import com.vladsch.flexmark.util.html.LineFormattingAppendableImpl;
import com.vladsch.flexmark.util.sequence.BasedSequenceImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.TextNode;

public class FlexmarkHtmlConverter {
    public static final DataKey<Integer> FORMAT_FLAGS = new DataKey<Integer>("FORMAT_FLAGS", 134);
    public static final DataKey<Integer> MAX_BLANK_LINES = new DataKey<Integer>("MAX_BLANK_LINES", 2);
    public static final DataKey<Integer> MAX_TRAILING_BLANK_LINES = new DataKey<Integer>("MAX_TRAILING_BLANK_LINES", 1);
    public static final DataKey<Boolean> LIST_CONTENT_INDENT = new DataKey<Boolean>("LIST_CONTENT_INDENT", true);
    public static final DataKey<Boolean> SETEXT_HEADINGS = new DataKey<Boolean>("SETEXT_HEADINGS", true);
    public static final DataKey<Boolean> OUTPUT_UNKNOWN_TAGS = new DataKey<Boolean>("OUTPUT_UNKNOWN_TAGS", false);
    public static final DataKey<Boolean> TYPOGRAPHIC_QUOTES = new DataKey<Boolean>("TYPOGRAPHIC_QUOTES", true);
    public static final DataKey<Boolean> TYPOGRAPHIC_SMARTS = new DataKey<Boolean>("TYPOGRAPHIC_SMARTS", true);
    public static final DataKey<Boolean> EXTRACT_AUTO_LINKS = new DataKey<Boolean>("EXTRACT_AUTO_LINKS", true);
    public static final DataKey<Boolean> OUTPUT_ATTRIBUTES_ID = new DataKey<Boolean>("OUTPUT_ATTRIBUTES_ID", true);
    public static final DataKey<String> OUTPUT_ATTRIBUTES_NAMES_REGEX = new DataKey<String>("OUTPUT_ATTRIBUTES_NAMES_REGEX", "");
    public static final DataKey<Boolean> WRAP_AUTO_LINKS = new DataKey<Boolean>("WRAP_AUTO_LINKS", true);
    public static final DataKey<Boolean> RENDER_COMMENTS = new DataKey<Boolean>("RENDER_COMMENTS", false);
    public static final DataKey<Boolean> DOT_ONLY_NUMERIC_LISTS = new DataKey<Boolean>("DOT_ONLY_NUMERIC_LISTS", true);
    public static final DataKey<Boolean> COMMENT_ORIGINAL_NON_NUMERIC_LIST_ITEM = new DataKey<Boolean>("COMMENT_ORIGINAL_NON_NUMERIC_LIST_ITEM", false);
    public static final DataKey<Boolean> PRE_CODE_PRESERVE_EMPHASIS = new DataKey<Boolean>("PRE_CODE_PRESERVE_EMPHASIS", false);
    public static final DataKey<Character> ORDERED_LIST_DELIMITER = new DataKey<Character>("ORDERED_LIST_DELIMITER", Character.valueOf('.'));
    public static final DataKey<Character> UNORDERED_LIST_DELIMITER = new DataKey<Character>("UNORDERED_LIST_DELIMITER", Character.valueOf('*'));
    public static final DataKey<Integer> DEFINITION_MARKER_SPACES = new DataKey<Integer>("DEFINITION_MARKER_SPACES", 3);
    public static final DataKey<Integer> MIN_SETEXT_HEADING_MARKER_LENGTH = new DataKey<Integer>("MIN_SETEXT_HEADING_MARKER_LENGTH", 3);
    public static final DataKey<String> CODE_INDENT = new DataKey<String>("CODE_INDENT", "    ");
    public static final DataKey<String> NBSP_TEXT = new DataKey<String>("NBSP_TEXT", " ");
    public static final DataKey<String> EOL_IN_TITLE_ATTRIBUTE = new DataKey<String>("EOL_IN_TITLE_ATTRIBUTE", " ");
    public static final DataKey<String> THEMATIC_BREAK = new DataKey<String>("THEMATIC_BREAK", "*** ** * ** ***");
    public static final DataKey<String[]> UNWRAPPED_TAGS = new DataKey<String[]>("UNWRAPPED_TAGS", new String[]{"article", "address", "frameset", "section", "small", "iframe"});
    public static final DataKey<String[]> WRAPPED_TAGS = new DataKey<String[]>("WRAPPED_TAGS", new String[]{"kbd", "var"});
    public static final DataKey<String> OUTPUT_ID_ATTRIBUTE_REGEX = new DataKey<String>("OUTPUT_ID_ATTRIBUTE_REGEX", "^user-content-(.*)$");
    public static final DataKey<Integer> TABLE_MIN_SEPARATOR_COLUMN_WIDTH = TableFormatOptions.FORMAT_TABLE_MIN_SEPARATOR_COLUMN_WIDTH;
    public static final DataKey<Integer> TABLE_MIN_SEPARATOR_DASHES = TableFormatOptions.FORMAT_TABLE_MIN_SEPARATOR_DASHES;
    public static final DataKey<Boolean> TABLE_LEAD_TRAIL_PIPES = TableFormatOptions.FORMAT_TABLE_LEAD_TRAIL_PIPES;
    public static final DataKey<Boolean> TABLE_SPACE_AROUND_PIPES = TableFormatOptions.FORMAT_TABLE_SPACE_AROUND_PIPES;
    public static final DataKey<TableCaptionHandling> TABLE_CAPTION = TableFormatOptions.FORMAT_TABLE_CAPTION;
    public static final DataKey<Boolean> LISTS_END_ON_DOUBLE_BLANK = new DataKey<Boolean>("LISTS_END_ON_DOUBLE_BLANK", false);
    public static final DataKey<Boolean> DIV_AS_PARAGRAPH = new DataKey<Boolean>("DIV_AS_PARAGRAPH", false);
    public static final DataKey<Boolean> BR_AS_PARA_BREAKS = new DataKey<Boolean>("BR_AS_PARA_BREAKS", true);
    public static final DataKey<Boolean> BR_AS_EXTRA_BLANK_LINES = new DataKey<Boolean>("BR_AS_EXTRA_BLANK_LINES", true);
    public static final DataKey<Boolean> ADD_TRAILING_EOL = new DataKey<Boolean>("ADD_TRAILING_EOL", true);
    public static final DataKey<Boolean> SKIP_HEADING_1 = new DataKey<Boolean>("SKIP_HEADING_1", false);
    public static final DataKey<Boolean> SKIP_HEADING_2 = new DataKey<Boolean>("SKIP_HEADING_2", false);
    public static final DataKey<Boolean> SKIP_HEADING_3 = new DataKey<Boolean>("SKIP_HEADING_3", false);
    public static final DataKey<Boolean> SKIP_HEADING_4 = new DataKey<Boolean>("SKIP_HEADING_4", false);
    public static final DataKey<Boolean> SKIP_HEADING_5 = new DataKey<Boolean>("SKIP_HEADING_5", false);
    public static final DataKey<Boolean> SKIP_HEADING_6 = new DataKey<Boolean>("SKIP_HEADING_6", false);
    public static final DataKey<Boolean> SKIP_ATTRIBUTES = new DataKey<Boolean>("SKIP_ATTRIBUTES", false);
    public static final DataKey<Boolean> SKIP_FENCED_CODE = new DataKey<Boolean>("SKIP_FENCED_CODE", false);
    public static final DataKey<Boolean> SKIP_CHAR_ESCAPE = new DataKey<Boolean>("SKIP_CHAR_ESCAPE", false);
    public static final DataKey<ExtensionConversion> EXT_INLINE_STRONG = new DataKey<ExtensionConversion>("EXT_INLINE_STRONG", ExtensionConversion.MARKDOWN);
    public static final DataKey<ExtensionConversion> EXT_INLINE_EMPHASIS = new DataKey<ExtensionConversion>("EXT_INLINE_EMPHASIS", ExtensionConversion.MARKDOWN);
    public static final DataKey<ExtensionConversion> EXT_INLINE_CODE = new DataKey<ExtensionConversion>("EXT_INLINE_CODE", ExtensionConversion.MARKDOWN);
    public static final DataKey<ExtensionConversion> EXT_INLINE_DEL = new DataKey<ExtensionConversion>("EXT_INLINE_DEL", ExtensionConversion.MARKDOWN);
    public static final DataKey<ExtensionConversion> EXT_INLINE_INS = new DataKey<ExtensionConversion>("EXT_INLINE_INS", ExtensionConversion.MARKDOWN);
    public static final DataKey<ExtensionConversion> EXT_INLINE_SUB = new DataKey<ExtensionConversion>("EXT_INLINE_SUB", ExtensionConversion.MARKDOWN);
    public static final DataKey<ExtensionConversion> EXT_INLINE_SUP = new DataKey<ExtensionConversion>("EXT_INLINE_SUP", ExtensionConversion.MARKDOWN);
    public static final DataKey<ExtensionConversion> EXT_MATH = new DataKey<ExtensionConversion>("EXT_MATH", ExtensionConversion.HTML);
    public static final DataKey<ExtensionConversion> EXT_TABLES = new DataKey<ExtensionConversion>("EXT_TABLES", ExtensionConversion.MARKDOWN);
    public static final DataKey<LinkConversion> EXT_INLINE_LINK = new DataKey<LinkConversion>("EXT_INLINE_LINK", LinkConversion.MARKDOWN_EXPLICIT);
    public static final DataKey<LinkConversion> EXT_INLINE_IMAGE = new DataKey<LinkConversion>("EXT_INLINE_IMAGE", LinkConversion.MARKDOWN_EXPLICIT);
    public static final DataKey<Ref<Document>> FOR_DOCUMENT = new DataKey<Ref<Document>>("FOR_DOCUMENT", new Ref<Document>(null));
    public static final DataKey<? extends Map<String, String>> TYPOGRAPHIC_REPLACEMENT_MAP = new DataKey("TYPOGRAPHIC_REPLACEMENT_MAP", new HashMap());
    public static final DataKey<Boolean> DUMP_HTML_TREE = new DataKey<Boolean>("DUMP_HTML_TREE", false);
    public static final DataKey<Boolean> IGNORE_TABLE_HEADING_AFTER_ROWS = new DataKey<Boolean>("IGNORE_TABLE_HEADING_AFTER_ROWS", true);
    public static final String A_NODE = "a";
    public static final String ABBR_NODE = "abbr";
    public static final String ASIDE_NODE = "aside";
    public static final String BR_NODE = "br";
    public static final String BLOCKQUOTE_NODE = "blockquote";
    public static final String CODE_NODE = "code";
    public static final String IMG_NODE = "img";
    public static final String DEL_NODE = "del";
    public static final String STRIKE_NODE = "strike";
    public static final String DIV_NODE = "div";
    public static final String DD_NODE = "dd";
    public static final String DL_NODE = "dl";
    public static final String DT_NODE = "dt";
    public static final String I_NODE = "i";
    public static final String EM_NODE = "em";
    public static final String B_NODE = "b";
    public static final String STRONG_NODE = "strong";
    public static final String EMOJI_NODE = "g-emoji";
    public static final String INPUT_NODE = "input";
    public static final String INS_NODE = "ins";
    public static final String U_NODE = "u";
    public static final String SUB_NODE = "sub";
    public static final String SUP_NODE = "sup";
    public static final String HR_NODE = "hr";
    public static final String OL_NODE = "ol";
    public static final String UL_NODE = "ul";
    public static final String LI_NODE = "li";
    public static final String TABLE_NODE = "table";
    public static final String TBODY_NODE = "tbody";
    public static final String TD_NODE = "td";
    public static final String TH_NODE = "th";
    public static final String THEAD_NODE = "thead";
    public static final String TR_NODE = "tr";
    public static final String CAPTION_NODE = "caption";
    public static final String SVG_NODE = "svg";
    public static final String P_NODE = "p";
    public static final String PRE_NODE = "pre";
    public static final String MATH_NODE = "math";
    public static final String SPAN_NODE = "span";
    public static final String TEXT_NODE = "#text";
    public static final String COMMENT_NODE = "#comment";
    public static final String H1_NODE = "h1";
    public static final String H2_NODE = "h2";
    public static final String H3_NODE = "h3";
    public static final String H4_NODE = "h4";
    public static final String H5_NODE = "h5";
    public static final String H6_NODE = "h6";
    public static final String DEFAULT_NODE = "";
    public static String[] EXPLICIT_LINK_TEXT_TAGS = new String[]{"img"};
    private static final Map<Object, CellAlignment> TABLE_CELL_ALIGNMENTS = new LinkedHashMap<Object, CellAlignment>();
    private static final String EMOJI_ALT_PREFIX = "emoji ";
    private static final Map<String, String> SPECIAL_CHARS_MAP;
    private static final String TYPOGRAPHIC_QUOTES_PIPED = "\u201c|\u201d|\u2018|\u2019|\u00ab|\u00bb|&ldquo;|&rdquo;|&lsquo;|&rsquo;|&apos;|&laquo;|&raquo;";
    private static final String TYPOGRAPHIC_SMARTS_PIPED = "\u2026|\u2013|\u2014|&hellip;|&endash;|&emdash;";
    private static final Pattern NUMERIC_DOT_LIST;
    private static final Pattern NUMERIC_PAREN_LIST;
    private static final Pattern NON_NUMERIC_DOT_LIST;
    private static final Pattern NON_NUMERIC_PAREN_LIST;
    private static final Pattern BULLET_LIST;
    private static final Pattern ALPHA_NUMERAL;
    public static final DataKey<Map<Object, CellAlignment>> TABLE_CELL_ALIGNMENT_MAP;
    final List<HtmlNodeRendererFactory> nodeConverterFactories;
    final HtmlConverterOptions htmlConverterOptions;
    private final DataHolder options;
    private final Builder builder;
    private final List<DelegatingNodeRendererFactoryWrapper> nodeRendererFactories;
    private final List<HtmlLinkResolverFactory> linkResolverFactories;
    private static final Iterator<? extends org.jsoup.nodes.Node> NULL_ITERATOR;
    public static final Iterable<? extends org.jsoup.nodes.Node> NULL_ITERABLE;

    private FlexmarkHtmlConverter(Builder builder) {
        this.builder = new Builder(builder);
        this.options = new DataSet(builder);
        this.htmlConverterOptions = new HtmlConverterOptions(this.options);
        this.nodeConverterFactories = new ArrayList<HtmlNodeRendererFactory>(builder.nodeRendererFactories.size() + 1);
        this.nodeConverterFactories.addAll(builder.nodeRendererFactories);
        ArrayList<DelegatingNodeRendererFactoryWrapper> nodeRenderers = new ArrayList<DelegatingNodeRendererFactoryWrapper>(builder.nodeRendererFactories.size());
        for (int i = builder.nodeRendererFactories.size() - 1; i >= 0; --i) {
            HtmlNodeRendererFactory nodeRendererFactory = builder.nodeRendererFactories.get(i);
            Set[] myDelegates = new Set[]{null};
            nodeRenderers.add(new DelegatingNodeRendererFactoryWrapper(nodeRenderers, nodeRendererFactory));
        }
        HtmlConverterCoreNodeRendererFactory nodeRendererFactory = new HtmlConverterCoreNodeRendererFactory();
        nodeRenderers.add(new DelegatingNodeRendererFactoryWrapper(nodeRenderers, nodeRendererFactory));
        RendererDependencyHandler resolver = new RendererDependencyHandler();
        this.nodeRendererFactories = ((RendererDependencies)resolver.resolveDependencies(nodeRenderers)).getNodeRendererFactories();
        this.nodeConverterFactories.add(new HtmlNodeRendererFactory(){

            @Override
            public HtmlNodeRenderer apply(DataHolder options) {
                return new HtmlConverterCoreNodeRenderer(options);
            }
        });
        this.linkResolverFactories = FlatDependencyHandler.computeDependencies(builder.linkResolverFactories);
    }

    public DataHolder getOptions() {
        return new DataSet(this.builder);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(DataHolder options) {
        return new Builder(options);
    }

    public void convert(String html, Appendable output) {
        org.jsoup.nodes.Document document = Jsoup.parse(html);
        if (DUMP_HTML_TREE.getFrom(this.getOptions()).booleanValue()) {
            LineFormattingAppendableImpl trace = new LineFormattingAppendableImpl(0);
            trace.setIndentPrefix("  ");
            FlexmarkHtmlConverter.dumpHtmlTree(trace, document.body());
            System.out.println(trace.toString(0));
        }
        MainHtmlConverter converter = new MainHtmlConverter(this.options, new HtmlMarkdownWriter(this.htmlConverterOptions.formatFlags), document, null);
        converter.render(document);
        converter.flushTo(output, this.htmlConverterOptions.maxTrailingBlankLines);
    }

    public String convert(String html) {
        return this.convert(html, 1);
    }

    public String convert(String html, int maxBlankLines) {
        org.jsoup.nodes.Document document = Jsoup.parse(html);
        if (DUMP_HTML_TREE.getFrom(this.getOptions()).booleanValue()) {
            LineFormattingAppendableImpl trace = new LineFormattingAppendableImpl(0);
            trace.setIndentPrefix("  ");
            FlexmarkHtmlConverter.dumpHtmlTree(trace, document.body());
            System.out.println(trace.toString(0));
        }
        MainHtmlConverter converter = new MainHtmlConverter(this.options, new HtmlMarkdownWriter(this.htmlConverterOptions.formatFlags), document, null);
        converter.render(document);
        boolean eolEnd = maxBlankLines >= 0 && converter.getMarkdown().getPendingEOL() > 0;
        String s = converter.getMarkdown().toString(maxBlankLines);
        return eolEnd ? s : Utils.removeSuffix(s, "\n");
    }

    public static void dumpHtmlTree(LineFormattingAppendable out, org.jsoup.nodes.Node node) {
        out.line().append(node.nodeName());
        for (Attribute attribute : node.attributes().asList()) {
            out.append(' ').append(attribute.getKey()).append("=\"").append(attribute.getValue()).append("\"");
        }
        out.line().indent();
        for (org.jsoup.nodes.Node child : node.childNodes()) {
            FlexmarkHtmlConverter.dumpHtmlTree(out, child);
        }
        out.unIndent();
    }

    public void convert(org.jsoup.nodes.Node node, Appendable output, int maxTrailingBlankLines) {
        MainHtmlConverter renderer = new MainHtmlConverter(this.options, new HtmlMarkdownWriter(this.htmlConverterOptions.formatFlags), node.ownerDocument(), null);
        renderer.render(node);
        renderer.flushTo(output, maxTrailingBlankLines);
    }

    public String convert(org.jsoup.nodes.Node node) {
        StringBuilder sb = new StringBuilder();
        this.convert(node, sb, 0);
        return sb.toString();
    }

    public FlexmarkHtmlConverter withOptions(DataHolder options) {
        return options == null ? this : new FlexmarkHtmlConverter(new Builder(this.builder, options));
    }

    static void processTextNodes(HtmlNodeConverterContext context, org.jsoup.nodes.Node node, boolean stripIdAttribute, CharSequence textPrefix, CharSequence textSuffix) {
        org.jsoup.nodes.Node child;
        context.pushState(node);
        HtmlMarkdownWriter markdown = context.getMarkdown();
        while ((child = context.next()) != null) {
            if (child instanceof TextNode) {
                if (textPrefix != null && textPrefix.length() > 0) {
                    markdown.append(textPrefix);
                }
                String text = ((TextNode)child).getWholeText();
                String preparedText = context.prepareText(text);
                markdown.append(preparedText);
                if (textSuffix == null || textSuffix.length() <= 0) continue;
                markdown.append(textSuffix);
                continue;
            }
            if (!(child instanceof Element)) continue;
            context.render(child);
        }
        if (stripIdAttribute) {
            context.excludeAttributes("id");
        }
        int nodeCount = node.parent().childNodeSize();
        if (node.parent().childNode(nodeCount - 1) == node) {
            context.transferIdToParent();
        }
        context.popState(markdown);
    }

    static void wrapTextNodes(HtmlNodeConverterContext context, org.jsoup.nodes.Node node, CharSequence wrapText, boolean needSpaceAround) {
        String text = context.processTextNodes(node);
        String prefixBefore = null;
        String appendAfter = null;
        boolean addSpaceBefore = false;
        boolean addSpaceAfter = false;
        HtmlMarkdownWriter out = context.getMarkdown();
        if (!text.isEmpty() && needSpaceAround) {
            if ("\u00a0 \t\n".indexOf(text.charAt(0)) != -1) {
                prefixBefore = context.prepareText(text.substring(0, 1));
                text = text.substring(1);
            } else if (text.startsWith("&nbsp;")) {
                prefixBefore = "&nbsp;";
                text = text.substring(prefixBefore.length());
            } else {
                boolean bl = addSpaceBefore = out.getPendingEOL() != 0 && !out.isPendingSpace() && out.offsetWithPending() != 0 && out.getPendingEOL() <= 0;
            }
            if (!text.isEmpty() && "\u00a0 \t\n".indexOf(text.charAt(text.length() - 1)) != -1) {
                appendAfter = context.prepareText(text.substring(text.length() - 1));
                text = text.substring(0, text.length() - 1);
            } else if (text.endsWith("&nbsp;")) {
                appendAfter = "&nbsp;";
                text = text.substring(0, text.length() - appendAfter.length());
            } else {
                String nextText;
                org.jsoup.nodes.Node next = context.peek();
                addSpaceAfter = true;
                if (next instanceof TextNode && !(nextText = ((TextNode)next).getWholeText()).isEmpty() && Character.isWhitespace(nextText.charAt(0))) {
                    addSpaceAfter = false;
                }
            }
        }
        if (!text.isEmpty()) {
            int pos;
            for (pos = text.length() - 1; pos >= 0 && Character.isWhitespace(text.charAt(pos)); --pos) {
            }
            if (++pos > 0) {
                if (prefixBefore != null) {
                    out.append(prefixBefore);
                }
                if (addSpaceBefore) {
                    out.append(' ');
                }
                text = text.substring(0, pos);
                out.append(wrapText);
                out.append(text);
                out.append(wrapText);
                if (appendAfter != null) {
                    out.append(appendAfter);
                }
                if (addSpaceAfter) {
                    out.append(' ');
                }
            }
        }
    }

    static void processConditional(HtmlNodeConverterContext context, ExtensionConversion extensionConversion, org.jsoup.nodes.Node node, Runnable processNode) {
        if (extensionConversion.isParsed()) {
            if (!extensionConversion.isSuppressed()) {
                processNode.run();
            }
        } else {
            context.processWrapped(node, null, true);
        }
    }

    static void appendOuterHtml(HtmlNodeConverterSubContext context, org.jsoup.nodes.Node node) {
        String text = node.outerHtml();
        int head = text.indexOf(">");
        int tail = text.lastIndexOf("</");
        if (head != -1 && tail != -1) {
            context.markdown.append(text.substring(0, head + 1));
            int iMax = node.childNodeSize();
            if (iMax > 0) {
                for (int i = 0; i < iMax; ++i) {
                    FlexmarkHtmlConverter.appendOuterHtml(context, node.childNode(i));
                }
            } else {
                context.markdown.append(context.escapeSpecialChars(text.substring(head + 1, tail)));
            }
            context.markdown.append(text.substring(tail));
        } else if (head == -1) {
            context.markdown.append(context.escapeSpecialChars(text));
        } else {
            context.markdown.append(text);
        }
    }

    public static void processWrapped(HtmlNodeConverterSubContext context, org.jsoup.nodes.Node node, Boolean isBlock, boolean escapeMarkdown) {
        if (node instanceof Element && (isBlock == null && ((Element)node).isBlock() || isBlock != null && isBlock.booleanValue())) {
            String s = node.toString();
            int pos = s.indexOf(">");
            ((HtmlMarkdownWriter)((HtmlMarkdownWriter)context.markdown.lineIf(isBlock != null)).append(s.substring(0, pos + 1))).lineIf(isBlock != null);
            FlexmarkHtmlConverter.processHtmlTree(context, node, false, null);
            int endPos = s.lastIndexOf("<");
            ((HtmlMarkdownWriter)((HtmlMarkdownWriter)context.markdown.lineIf(isBlock != null)).append(s.substring(endPos))).lineIf(isBlock != null);
        } else if (escapeMarkdown) {
            FlexmarkHtmlConverter.appendOuterHtml(context, node);
        } else {
            context.markdown.append(node.toString());
        }
    }

    static void processHtmlTree(HtmlNodeConverterSubContext context, org.jsoup.nodes.Node parent, boolean outputAttributes, Runnable prePopAction) {
        org.jsoup.nodes.Node node;
        context.pushState(parent);
        HtmlConverterState oldState = context.getState();
        if (prePopAction != null) {
            oldState.addPrePopAction(prePopAction);
        }
        while ((node = context.next()) != null) {
            context.render(node);
        }
        if (oldState != context.getState()) {
            throw new IllegalStateException("State not equal after process " + FlexmarkHtmlConverter.dumpState(context));
        }
        oldState.runPrePopActions();
        context.popState(outputAttributes ? context.markdown : null);
    }

    static String dumpState(HtmlNodeConverterContext context) {
        Stack<HtmlConverterState> stateStack = context.getStateStack();
        if (!stateStack.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            while (!stateStack.isEmpty()) {
                HtmlConverterState state = stateStack.pop();
                sb.append("\n").append(state == null ? "null" : state.toString());
            }
            return sb.toString();
        }
        return DEFAULT_NODE;
    }

    static void processDefault(HtmlNodeConverterSubContext subContext, org.jsoup.nodes.Node node, boolean outputUnknownTags) {
        if (outputUnknownTags) {
            subContext.processWrapped(node, null, false);
        } else {
            subContext.processUnwrapped(node);
        }
    }

    static {
        TABLE_CELL_ALIGNMENTS.put(Pattern.compile("\\bleft\\b"), CellAlignment.LEFT);
        TABLE_CELL_ALIGNMENTS.put(Pattern.compile("\\bcenter\\b"), CellAlignment.CENTER);
        TABLE_CELL_ALIGNMENTS.put(Pattern.compile("\\bright\\b"), CellAlignment.RIGHT);
        TABLE_CELL_ALIGNMENTS.put("text-left", CellAlignment.LEFT);
        TABLE_CELL_ALIGNMENTS.put("text-center", CellAlignment.CENTER);
        TABLE_CELL_ALIGNMENTS.put("text-right", CellAlignment.RIGHT);
        SPECIAL_CHARS_MAP = new HashMap<String, String>();
        SPECIAL_CHARS_MAP.put("\u201c", "\"");
        SPECIAL_CHARS_MAP.put("\u201d", "\"");
        SPECIAL_CHARS_MAP.put("&ldquo;", "\"");
        SPECIAL_CHARS_MAP.put("&rdquo;", "\"");
        SPECIAL_CHARS_MAP.put("\u2018", "'");
        SPECIAL_CHARS_MAP.put("\u2019", "'");
        SPECIAL_CHARS_MAP.put("&lsquo;", "'");
        SPECIAL_CHARS_MAP.put("&rsquo;", "'");
        SPECIAL_CHARS_MAP.put("&apos;", "'");
        SPECIAL_CHARS_MAP.put("\u00ab", "<<");
        SPECIAL_CHARS_MAP.put("&laquo;", "<<");
        SPECIAL_CHARS_MAP.put("\u00bb", ">>");
        SPECIAL_CHARS_MAP.put("&raquo;", ">>");
        SPECIAL_CHARS_MAP.put("\u2026", "...");
        SPECIAL_CHARS_MAP.put("&hellip;", "...");
        SPECIAL_CHARS_MAP.put("\u2013", "--");
        SPECIAL_CHARS_MAP.put("&endash;", "--");
        SPECIAL_CHARS_MAP.put("\u2014", "---");
        SPECIAL_CHARS_MAP.put("&emdash;", "---");
        NUMERIC_DOT_LIST = Pattern.compile("^(\\d+)\\.\\s*$");
        NUMERIC_PAREN_LIST = Pattern.compile("^(\\d+)\\)\\s*$");
        NON_NUMERIC_DOT_LIST = Pattern.compile("^((?:(?:" + RomanNumeral.ROMAN_NUMERAL.pattern() + ")|(?:" + RomanNumeral.LOWERCASE_ROMAN_NUMERAL.pattern() + ")|[a-z]+|[A-Z]+))\\.\\s*$");
        NON_NUMERIC_PAREN_LIST = Pattern.compile("^((?:[a-z]+|[A-Z]+))\\)\\s*$");
        BULLET_LIST = Pattern.compile("^([\u00b7])\\s*$");
        ALPHA_NUMERAL = Pattern.compile("^[a-z]+|[A-Z]+$");
        TABLE_CELL_ALIGNMENT_MAP = new DataKey<Map<Object, CellAlignment>>("TABLE_CELL_ALIGNMENT_MAP", TABLE_CELL_ALIGNMENTS);
        NULL_ITERATOR = new Iterator<org.jsoup.nodes.Node>(){

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public org.jsoup.nodes.Node next() {
                return null;
            }

            @Override
            public void remove() {
            }
        };
        NULL_ITERABLE = new Iterable<org.jsoup.nodes.Node>(){

            @Override
            public Iterator<org.jsoup.nodes.Node> iterator() {
                return null;
            }
        };
    }

    private class MainHtmlConverter
    extends HtmlNodeConverterSubContext {
        private final org.jsoup.nodes.Document document;
        private final Document myForDocument;
        private final Map<String, HtmlNodeRendererHandler> renderers;
        private final List<PhasedHtmlNodeRenderer> phasedFormatters;
        private final Set<HtmlConverterPhase> renderingPhases;
        private final DataHolder myOptions;
        private HtmlConverterPhase phase;
        private final HtmlConverterOptions myHtmlConverterOptions;
        private final Pattern specialCharsPattern;
        private Stack<HtmlConverterState> myStateStack;
        private Map<String, String> mySpecialCharsMap;
        private HtmlConverterState myState;
        private boolean myTrace;
        private boolean myInlineCode;
        private Parser myParser;
        private HashMap<LinkType, HashMap<String, ResolvedLink>> resolvedLinkMap;
        private HtmlLinkResolver[] myHtmlLinkResolvers;
        private HashMap<String, Reference> myReferenceUrlToReferenceMap;
        private HashSet<Reference> myExternalReferences;

        @Override
        public HtmlConverterState getState() {
            return this.myState;
        }

        MainHtmlConverter(DataHolder options, HtmlMarkdownWriter out, org.jsoup.nodes.Document document, DataHolder parentOptions) {
            int i;
            super(out);
            this.myParser = null;
            this.resolvedLinkMap = new HashMap();
            this.myOptions = new ScopedDataSet(parentOptions, options);
            this.renderers = new HashMap<String, HtmlNodeRendererHandler>(32);
            this.renderingPhases = new HashSet<HtmlConverterPhase>(HtmlConverterPhase.values().length);
            this.phasedFormatters = new ArrayList<PhasedHtmlNodeRenderer>(FlexmarkHtmlConverter.this.nodeConverterFactories.size());
            this.resolvedLinkMap = null;
            this.myHtmlLinkResolvers = new HtmlLinkResolver[FlexmarkHtmlConverter.this.linkResolverFactories.size()];
            out.setContext(this);
            this.myHtmlConverterOptions = new HtmlConverterOptions(this.myOptions);
            this.specialCharsPattern = this.myHtmlConverterOptions.typographicQuotes && this.myHtmlConverterOptions.typographicSmarts ? Pattern.compile("\u201c|\u201d|\u2018|\u2019|\u00ab|\u00bb|&ldquo;|&rdquo;|&lsquo;|&rsquo;|&apos;|&laquo;|&raquo;|\u2026|\u2013|\u2014|&hellip;|&endash;|&emdash;") : (this.myHtmlConverterOptions.typographicQuotes ? Pattern.compile(FlexmarkHtmlConverter.TYPOGRAPHIC_QUOTES_PIPED) : (this.myHtmlConverterOptions.typographicSmarts ? Pattern.compile(FlexmarkHtmlConverter.TYPOGRAPHIC_SMARTS_PIPED) : null));
            this.myStateStack = new Stack();
            this.myReferenceUrlToReferenceMap = new HashMap();
            this.myExternalReferences = new HashSet();
            this.myState = null;
            Map<String, String> typographicReplacementMap = TYPOGRAPHIC_REPLACEMENT_MAP.getFrom(this.myOptions);
            this.mySpecialCharsMap = !typographicReplacementMap.isEmpty() ? typographicReplacementMap : SPECIAL_CHARS_MAP;
            for (i = FlexmarkHtmlConverter.this.nodeConverterFactories.size() - 1; i >= 0; --i) {
                HtmlNodeRendererFactory htmlNodeRendererFactory = FlexmarkHtmlConverter.this.nodeConverterFactories.get(i);
                HtmlNodeRenderer htmlNodeRenderer = htmlNodeRendererFactory.apply(this.myOptions);
                Set<HtmlNodeRendererHandler<?>> formattingHandlers = htmlNodeRenderer.getHtmlNodeRendererHandlers();
                if (formattingHandlers == null) continue;
                for (HtmlNodeRendererHandler<?> nodeType : formattingHandlers) {
                    this.renderers.put(nodeType.getTagName(), nodeType);
                }
                if (!(htmlNodeRenderer instanceof PhasedHtmlNodeRenderer)) continue;
                Set<HtmlConverterPhase> phases = ((PhasedHtmlNodeRenderer)htmlNodeRenderer).getHtmlConverterPhases();
                if (phases != null) {
                    if (phases.isEmpty()) {
                        throw new IllegalStateException("PhasedNodeFormatter with empty Phases");
                    }
                    this.renderingPhases.addAll(phases);
                    this.phasedFormatters.add((PhasedHtmlNodeRenderer)htmlNodeRenderer);
                    continue;
                }
                throw new IllegalStateException("PhasedNodeFormatter with null Phases");
            }
            for (i = 0; i < FlexmarkHtmlConverter.this.linkResolverFactories.size(); ++i) {
                this.myHtmlLinkResolvers[i] = ((HtmlLinkResolverFactory)FlexmarkHtmlConverter.this.linkResolverFactories.get(i)).apply(this);
            }
            this.document = document;
            this.myForDocument = (Document)FlexmarkHtmlConverter.FOR_DOCUMENT.getFrom((DataHolder)options).value;
        }

        @Override
        public HashMap<String, Reference> getReferenceUrlToReferenceMap() {
            return this.myReferenceUrlToReferenceMap;
        }

        @Override
        public HashSet<Reference> getExternalReferences() {
            return this.myExternalReferences;
        }

        @Override
        public boolean isTrace() {
            return this.myTrace;
        }

        @Override
        public Stack<HtmlConverterState> getStateStack() {
            return this.myStateStack;
        }

        @Override
        public void setTrace(boolean trace) {
            this.myTrace = trace;
        }

        @Override
        public Node parseMarkdown(String markdown) {
            if (this.myParser == null) {
                this.myParser = Parser.builder(this.myOptions).build();
            }
            return this.myParser.parse(markdown);
        }

        @Override
        public Reference getOrCreateReference(String url, String text, String title) {
            Node document;
            Node firstChild;
            Reference reference = this.myReferenceUrlToReferenceMap.get(url);
            if (reference != null) {
                if (title != null && !title.trim().isEmpty()) {
                    if (reference.getTitle().isBlank()) {
                        reference.setTitle(BasedSequenceImpl.of(title));
                        return reference;
                    }
                    if (reference.getTitle().equals(title.trim())) {
                        return reference;
                    }
                }
                return reference;
            }
            String referenceId = text;
            if (this.myReferenceUrlToReferenceMap.containsKey(referenceId)) {
                int i = 1;
                while (this.myReferenceUrlToReferenceMap.containsKey(referenceId = text + "_" + i)) {
                    ++i;
                }
            }
            StringBuilder sb = new StringBuilder().append("[").append(referenceId).append("]: ").append(url);
            if (title != null && !title.trim().isEmpty()) {
                sb.append(" '").append(title.replace("'", "\\'")).append("'");
            }
            if ((firstChild = (document = this.parseMarkdown(sb.toString())).getFirstChild()) instanceof Reference) {
                reference = (Reference)firstChild;
                this.myReferenceUrlToReferenceMap.put(url, reference);
                return reference;
            }
            return null;
        }

        @Override
        public ResolvedLink resolveLink(LinkType linkType, CharSequence url, Boolean urlEncode) {
            return this.resolveLink(linkType, url, null, urlEncode);
        }

        @Override
        public ResolvedLink resolveLink(LinkType linkType, CharSequence url, Attributes attributes, Boolean urlEncode) {
            String urlSeq = String.valueOf(url);
            ResolvedLink resolvedLink = new ResolvedLink(linkType, urlSeq, attributes);
            if (!urlSeq.isEmpty()) {
                HtmlLinkResolver htmlLinkResolver;
                org.jsoup.nodes.Node currentNode = this.getCurrentNode();
                HtmlLinkResolver[] htmlLinkResolverArray = this.myHtmlLinkResolvers;
                int n = htmlLinkResolverArray.length;
                for (int i = 0; i < n && (resolvedLink = (htmlLinkResolver = htmlLinkResolverArray[i]).resolveLink(currentNode, this, resolvedLink)).getStatus() == LinkStatus.UNKNOWN; ++i) {
                }
            }
            return resolvedLink;
        }

        @Override
        public org.jsoup.nodes.Node getCurrentNode() {
            return this.myRenderingNode;
        }

        @Override
        public DataHolder getOptions() {
            return this.myOptions;
        }

        @Override
        public HtmlConverterOptions getHtmlConverterOptions() {
            return FlexmarkHtmlConverter.this.htmlConverterOptions;
        }

        @Override
        public org.jsoup.nodes.Document getDocument() {
            return this.document;
        }

        @Override
        public Document getForDocument() {
            return this.myForDocument;
        }

        @Override
        public HtmlConverterPhase getFormattingPhase() {
            return this.phase;
        }

        @Override
        public void render(org.jsoup.nodes.Node node) {
            this.renderNode(node, this);
        }

        @Override
        public void delegateRender() {
            this.renderByPreviousHandler(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void renderByPreviousHandler(HtmlNodeConverterSubContext subContext) {
            if (subContext.getRenderingNode() != null) {
                NodeRenderingHandlerWrapper nodeRenderer = subContext.renderingHandlerWrapper.myPreviousRenderingHandler;
                if (nodeRenderer != null) {
                    org.jsoup.nodes.Node oldNode = subContext.getRenderingNode();
                    NodeRenderingHandlerWrapper prevWrapper = subContext.renderingHandlerWrapper;
                    try {
                        subContext.renderingHandlerWrapper = nodeRenderer;
                        nodeRenderer.myRenderingHandler.render(oldNode, subContext, subContext.getMarkdown());
                    }
                    finally {
                        subContext.setRenderingNode(oldNode);
                        subContext.renderingHandlerWrapper = prevWrapper;
                    }
                }
            } else {
                throw new IllegalStateException("renderingByPreviousHandler called outside node rendering code");
            }
        }

        @Override
        public HtmlNodeConverterContext getSubContext() {
            HtmlMarkdownWriter writer = new HtmlMarkdownWriter(this.getMarkdown().getOptions());
            return new SubHtmlNodeConverter(this, writer);
        }

        void renderNode(org.jsoup.nodes.Node node, HtmlNodeConverterSubContext subContext) {
            if (node instanceof org.jsoup.nodes.Document) {
                for (HtmlConverterPhase phase : HtmlConverterPhase.values()) {
                    if (phase != HtmlConverterPhase.DOCUMENT && !this.renderingPhases.contains((Object)phase)) continue;
                    this.phase = phase;
                    if (this.phase == HtmlConverterPhase.DOCUMENT) {
                        FlexmarkHtmlConverter.processHtmlTree(subContext, this.document.body(), false, null);
                        continue;
                    }
                    for (PhasedHtmlNodeRenderer phasedFormatter : this.phasedFormatters) {
                        if (!phasedFormatter.getHtmlConverterPhases().contains((Object)phase)) continue;
                        subContext.myRenderingNode = node;
                        phasedFormatter.renderDocument(subContext, subContext.markdown, (org.jsoup.nodes.Document)node, phase);
                        subContext.myRenderingNode = null;
                    }
                }
            } else {
                HtmlNodeRendererHandler nodeRenderer = this.renderers.get(node.nodeName().toLowerCase());
                if (nodeRenderer == null) {
                    nodeRenderer = this.renderers.get(FlexmarkHtmlConverter.DEFAULT_NODE);
                }
                if (nodeRenderer != null) {
                    org.jsoup.nodes.Node oldNode = this.myRenderingNode;
                    subContext.myRenderingNode = node;
                    nodeRenderer.render(node, subContext, subContext.markdown);
                    subContext.myRenderingNode = oldNode;
                } else {
                    throw new IllegalStateException("Core Node Formatter should implement generic empty tag renderer");
                }
            }
        }

        @Override
        public void renderChildren(org.jsoup.nodes.Node parent, boolean outputAttributes, Runnable prePopAction) {
            FlexmarkHtmlConverter.processHtmlTree(this, parent, outputAttributes, prePopAction);
        }

        @Override
        public void pushState(org.jsoup.nodes.Node parent) {
            this.myStateStack.push(this.myState);
            this.myState = new HtmlConverterState(parent);
            this.processAttributes(parent);
        }

        @Override
        public void excludeAttributes(String ... excludes) {
            for (String exclude : excludes) {
                this.myState.myAttributes.remove(exclude);
            }
        }

        @Override
        public void processAttributes(org.jsoup.nodes.Node node) {
            Attributes attributes = this.myState.myAttributes;
            if (this.myHtmlConverterOptions.outputAttributesIdAttr || !this.myHtmlConverterOptions.outputAttributesNamesRegex.isEmpty()) {
                org.jsoup.nodes.Attributes nodeAttributes = node.attributes();
                boolean idDone = false;
                if (this.myHtmlConverterOptions.outputAttributesIdAttr) {
                    String id = nodeAttributes.get("id");
                    if (id == null || id.isEmpty()) {
                        id = nodeAttributes.get("name");
                    }
                    if (id != null && !id.isEmpty()) {
                        attributes.replaceValue("id", id);
                        idDone = true;
                    }
                }
                if (!this.myHtmlConverterOptions.outputAttributesNamesRegex.isEmpty()) {
                    for (Attribute attribute : nodeAttributes) {
                        if (idDone && (attribute.getKey().equals("id") || attribute.getKey().equals("name")) || !attribute.getKey().matches(this.myHtmlConverterOptions.outputAttributesNamesRegex)) continue;
                        attributes.replaceValue(attribute.getKey(), attribute.getValue());
                    }
                }
            }
        }

        @Override
        public int outputAttributes(LineFormattingAppendable out, String initialSep) {
            Attributes attributes = this.myState.myAttributes;
            int startOffset = out.offsetWithPending();
            if (!attributes.isEmpty() && !this.myHtmlConverterOptions.skipAttributes) {
                String sep = FlexmarkHtmlConverter.DEFAULT_NODE;
                out.append(initialSep);
                out.append("{");
                for (String attrName : attributes.keySet()) {
                    String value = attributes.getValue(attrName);
                    out.append(sep);
                    if (attrName.equals("id") || attrName.equals("name")) {
                        Matcher matcher;
                        boolean handled = false;
                        if (!this.myHtmlConverterOptions.outputIdAttributeRegex.isEmpty() && (matcher = this.myHtmlConverterOptions.outputIdAttributeRegexPattern.matcher(value)).matches()) {
                            StringBuilder sb = new StringBuilder();
                            int iMax = matcher.groupCount();
                            for (int i = 0; i < iMax; ++i) {
                                String group = matcher.group(i + 1);
                                if (group == null || group.isEmpty()) continue;
                                sb.append(group);
                            }
                            value = sb.toString().trim();
                            handled = value.isEmpty();
                        }
                        if (!handled) {
                            out.append("#").append(value);
                        }
                    } else if (attrName.equals("class")) {
                        out.append(".").append(value);
                    } else {
                        out.append(attrName).append("=");
                        if (!value.contains("\"")) {
                            out.append('\"').append(value).append('\"');
                        } else if (!value.contains("'")) {
                            out.append('\'').append(value).append('\'');
                        } else {
                            out.append('\"').append(value.replace("\"", "\\\"")).append('\"');
                        }
                    }
                    sep = " ";
                }
                out.append("}");
                this.myState.myAttributes.clear();
            }
            return out.offsetWithPending() - startOffset;
        }

        @Override
        public void transferIdToParent() {
            HtmlConverterState state;
            if (this.myStateStack.isEmpty()) {
                throw new IllegalStateException("transferIdToParent with an empty stack");
            }
            com.vladsch.flexmark.util.html.Attribute attribute = this.myState.myAttributes.get("id");
            this.myState.myAttributes.remove("id");
            if (attribute != null && !attribute.getValue().isEmpty() && (state = this.myStateStack.peek()) != null) {
                state.myAttributes.addValue("id", attribute.getValue());
            }
        }

        @Override
        public void transferToParentExcept(String ... excludes) {
            if (this.myStateStack.isEmpty()) {
                throw new IllegalStateException("transferIdToParent with an empty stack");
            }
            Attributes attributes = new Attributes(this.myState.myAttributes);
            this.myState.myAttributes.clear();
            for (String exclude : excludes) {
                this.myState.myAttributes.addValue(attributes.get(exclude));
                attributes.remove(exclude);
            }
            if (!attributes.isEmpty()) {
                HtmlConverterState parentState = this.myStateStack.peek();
                for (String attrName : attributes.keySet()) {
                    parentState.myAttributes.addValue(attributes.get(attrName));
                }
            }
        }

        @Override
        public void transferToParentOnly(String ... includes) {
            if (this.myStateStack.isEmpty()) {
                throw new IllegalStateException("transferIdToParent with an empty stack");
            }
            Attributes attributes = new Attributes();
            for (String include : includes) {
                com.vladsch.flexmark.util.html.Attribute attribute = this.myState.myAttributes.get(include);
                if (attribute == null) continue;
                this.myState.myAttributes.remove(include);
                attributes.addValue(attribute);
            }
            if (!attributes.isEmpty()) {
                HtmlConverterState parentState = this.myStateStack.peek();
                for (String attrName : attributes.keySet()) {
                    parentState.myAttributes.addValue(attributes.get(attrName));
                }
            }
        }

        @Override
        public void popState(LineFormattingAppendable out) {
            if (this.myStateStack.isEmpty()) {
                throw new IllegalStateException("popState with an empty stack");
            }
            if (out != null) {
                this.outputAttributes(out, FlexmarkHtmlConverter.DEFAULT_NODE);
            }
            this.myState = this.myStateStack.pop();
        }

        @Override
        public org.jsoup.nodes.Node peek() {
            if (this.myState.myIndex < this.myState.myElements.size()) {
                return this.myState.myElements.get(this.myState.myIndex);
            }
            return null;
        }

        @Override
        public org.jsoup.nodes.Node peek(int skip) {
            if (this.myState.myIndex + skip >= 0 && this.myState.myIndex + skip < this.myState.myElements.size()) {
                return this.myState.myElements.get(this.myState.myIndex + skip);
            }
            return null;
        }

        @Override
        public org.jsoup.nodes.Node next() {
            org.jsoup.nodes.Node next = this.peek();
            if (next != null) {
                ++this.myState.myIndex;
            }
            return next;
        }

        @Override
        public void skip() {
            org.jsoup.nodes.Node next = this.peek();
            if (next != null) {
                ++this.myState.myIndex;
            }
        }

        @Override
        public org.jsoup.nodes.Node next(int skip) {
            if (skip > 0) {
                org.jsoup.nodes.Node next = this.peek(skip - 1);
                if (next != null) {
                    this.myState.myIndex += skip;
                }
                return next;
            }
            return this.peek();
        }

        @Override
        public void skip(int skip) {
            org.jsoup.nodes.Node next;
            if (skip > 0 && (next = this.peek(skip - 1)) != null) {
                this.myState.myIndex += skip;
            }
        }

        private String dumpState() {
            if (!this.myStateStack.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                while (!this.myStateStack.isEmpty()) {
                    HtmlConverterState state = this.myStateStack.pop();
                    sb.append("\n").append(state == null ? "null" : state.toString());
                }
                return sb.toString();
            }
            return FlexmarkHtmlConverter.DEFAULT_NODE;
        }

        @Override
        public void processUnwrapped(org.jsoup.nodes.Node element) {
            this.processUnwrapped(this, element);
        }

        void processUnwrapped(HtmlNodeConverterSubContext context, org.jsoup.nodes.Node element) {
            FlexmarkHtmlConverter.processHtmlTree(context, element, false, null);
        }

        @Override
        public void processWrapped(org.jsoup.nodes.Node node, Boolean isBlock, boolean escapeMarkdown) {
            FlexmarkHtmlConverter.processWrapped(this, node, isBlock, escapeMarkdown);
        }

        @Override
        public void processTextNodes(org.jsoup.nodes.Node node, boolean stripIdAttribute) {
            this.processTextNodes(node, stripIdAttribute, null, null);
        }

        @Override
        public void processTextNodes(org.jsoup.nodes.Node node, boolean stripIdAttribute, CharSequence wrapText) {
            this.processTextNodes(node, stripIdAttribute, wrapText, wrapText);
        }

        @Override
        public void processTextNodes(org.jsoup.nodes.Node node, boolean stripIdAttribute, CharSequence textPrefix, CharSequence textSuffix) {
            FlexmarkHtmlConverter.processTextNodes(this, node, stripIdAttribute, textPrefix, textSuffix);
        }

        @Override
        public void wrapTextNodes(org.jsoup.nodes.Node node, CharSequence wrapText, boolean needSpaceAround) {
            FlexmarkHtmlConverter.wrapTextNodes(this, node, wrapText, needSpaceAround);
        }

        @Override
        public String processTextNodes(org.jsoup.nodes.Node node) {
            org.jsoup.nodes.Node child;
            this.pushState(node);
            HtmlNodeConverterContext subContext = this.getSubContext();
            while ((child = this.next()) != null) {
                if (child instanceof TextNode) {
                    String text = ((TextNode)child).getWholeText();
                    subContext.getMarkdown().append(this.prepareText(text));
                    continue;
                }
                if (!(child instanceof Element)) continue;
                subContext.render(child);
            }
            this.transferIdToParent();
            this.popState(null);
            return subContext.getMarkdown().toString(-1);
        }

        @Override
        public void appendOuterHtml(org.jsoup.nodes.Node node) {
            FlexmarkHtmlConverter.appendOuterHtml(this, node);
        }

        @Override
        public boolean isInlineCode() {
            return this.myInlineCode;
        }

        @Override
        public void setInlineCode(boolean inlineCode) {
            this.myInlineCode = inlineCode;
        }

        @Override
        public void inlineCode(Runnable inlineRunnable) {
            boolean oldInlineCode = this.myInlineCode;
            this.myInlineCode = true;
            try {
                inlineRunnable.run();
            }
            finally {
                this.myInlineCode = oldInlineCode;
            }
        }

        @Override
        public String prepareText(String text) {
            return this.prepareText(text, this.myInlineCode);
        }

        @Override
        public String prepareText(String text, boolean inCode) {
            if (this.specialCharsPattern != null) {
                Matcher matcher = this.specialCharsPattern.matcher(text);
                int length = text.length();
                StringBuilder sb = new StringBuilder(length * 2);
                int lastPos = 0;
                while (matcher.find()) {
                    String raw;
                    String mapped;
                    if (lastPos < matcher.start()) {
                        sb.append(text, lastPos, matcher.start());
                    }
                    if ((mapped = this.mySpecialCharsMap.get(raw = matcher.group())) != null) {
                        sb.append(mapped);
                    } else {
                        sb.append(raw);
                    }
                    lastPos = matcher.end();
                }
                if (lastPos < length) {
                    sb.append(text, lastPos, length);
                }
                text = sb.toString();
            }
            text = !inCode ? this.escapeSpecialChars(text) : text.replace("\u00a0", " ");
            return text;
        }

        @Override
        public String escapeSpecialChars(String text) {
            if (!this.myHtmlConverterOptions.skipCharEscape) {
                text = text.replace("\\", "\\\\");
                text = text.replace("*", "\\*");
                text = text.replace("~", "\\~");
                text = text.replace("^", "\\^");
                text = text.replace("&", "\\&");
                text = text.replace("<", "\\<").replace(">", "\\>");
                text = text.replace("[", "\\[").replace("]", "\\]");
                text = text.replace("|", "\\|").replace("`", "\\`");
                text = text.replace("\u00a0", this.myHtmlConverterOptions.nbspText);
            }
            return text;
        }

        @Override
        public void processConditional(ExtensionConversion extensionConversion, org.jsoup.nodes.Node node, Runnable processNode) {
            FlexmarkHtmlConverter.processConditional(this, extensionConversion, node, processNode);
        }

        @Override
        public void renderDefault(org.jsoup.nodes.Node node) {
            FlexmarkHtmlConverter.processDefault(this, node, this.getHtmlConverterOptions().outputUnknownTags);
        }

        private class SubHtmlNodeConverter
        extends HtmlNodeConverterSubContext
        implements HtmlNodeConverterContext {
            private final MainHtmlConverter myMainNodeRenderer;

            public SubHtmlNodeConverter(MainHtmlConverter mainNodeRenderer, HtmlMarkdownWriter out) {
                super(out);
                this.myMainNodeRenderer = mainNodeRenderer;
            }

            @Override
            public DataHolder getOptions() {
                return this.myMainNodeRenderer.getOptions();
            }

            @Override
            public HtmlConverterOptions getHtmlConverterOptions() {
                return this.myMainNodeRenderer.getHtmlConverterOptions();
            }

            @Override
            public org.jsoup.nodes.Document getDocument() {
                return this.myMainNodeRenderer.getDocument();
            }

            @Override
            public HtmlConverterPhase getFormattingPhase() {
                return this.myMainNodeRenderer.getFormattingPhase();
            }

            @Override
            public void render(org.jsoup.nodes.Node node) {
                this.myMainNodeRenderer.renderNode(node, this);
            }

            @Override
            public org.jsoup.nodes.Node getCurrentNode() {
                return this.myRenderingNode;
            }

            @Override
            public HtmlNodeConverterContext getSubContext() {
                HtmlMarkdownWriter htmlWriter = new HtmlMarkdownWriter(this.markdown.getOptions());
                htmlWriter.setContext(this);
                return new SubHtmlNodeConverter(this.myMainNodeRenderer, htmlWriter);
            }

            @Override
            public void renderChildren(org.jsoup.nodes.Node parent, boolean outputAttributes, Runnable prePopAction) {
                FlexmarkHtmlConverter.processHtmlTree(this, parent, outputAttributes, prePopAction);
            }

            @Override
            public Document getForDocument() {
                return this.myMainNodeRenderer.getForDocument();
            }

            @Override
            public ResolvedLink resolveLink(LinkType linkType, CharSequence url, Boolean urlEncode) {
                return this.myMainNodeRenderer.resolveLink(linkType, url, urlEncode);
            }

            @Override
            public ResolvedLink resolveLink(LinkType linkType, CharSequence url, Attributes attributes, Boolean urlEncode) {
                return this.myMainNodeRenderer.resolveLink(linkType, url, attributes, urlEncode);
            }

            @Override
            public void pushState(org.jsoup.nodes.Node parent) {
                this.myMainNodeRenderer.pushState(parent);
            }

            @Override
            public void popState(LineFormattingAppendable out) {
                this.myMainNodeRenderer.popState(out);
            }

            @Override
            public void processAttributes(org.jsoup.nodes.Node node) {
                this.myMainNodeRenderer.processAttributes(node);
            }

            @Override
            public int outputAttributes(LineFormattingAppendable out, String initialSep) {
                return this.myMainNodeRenderer.outputAttributes(out, initialSep);
            }

            @Override
            public void transferIdToParent() {
                this.myMainNodeRenderer.transferIdToParent();
            }

            @Override
            public void transferToParentExcept(String ... excludes) {
                this.myMainNodeRenderer.transferToParentExcept(excludes);
            }

            @Override
            public void transferToParentOnly(String ... includes) {
                this.myMainNodeRenderer.transferToParentOnly(includes);
            }

            @Override
            public org.jsoup.nodes.Node peek() {
                return this.myMainNodeRenderer.peek();
            }

            @Override
            public org.jsoup.nodes.Node peek(int skip) {
                return this.myMainNodeRenderer.peek(skip);
            }

            @Override
            public org.jsoup.nodes.Node next() {
                return this.myMainNodeRenderer.next();
            }

            @Override
            public void skip() {
                this.myMainNodeRenderer.skip();
            }

            @Override
            public org.jsoup.nodes.Node next(int skip) {
                return this.myMainNodeRenderer.next(skip);
            }

            @Override
            public void skip(int skip) {
                this.myMainNodeRenderer.skip(skip);
            }

            @Override
            public void delegateRender() {
                this.myMainNodeRenderer.renderByPreviousHandler(this);
            }

            @Override
            public HashMap<String, Reference> getReferenceUrlToReferenceMap() {
                return this.myMainNodeRenderer.getReferenceUrlToReferenceMap();
            }

            @Override
            public HashSet<Reference> getExternalReferences() {
                return this.myMainNodeRenderer.getExternalReferences();
            }

            @Override
            public Reference getOrCreateReference(String url, String text, String title) {
                return this.myMainNodeRenderer.getOrCreateReference(url, text, title);
            }

            @Override
            public Node parseMarkdown(String markdown) {
                return this.myMainNodeRenderer.parseMarkdown(markdown);
            }

            @Override
            public void processUnwrapped(org.jsoup.nodes.Node element) {
                this.myMainNodeRenderer.processUnwrapped(this, element);
            }

            @Override
            public void processWrapped(org.jsoup.nodes.Node node, Boolean isBlock, boolean escapeMarkdown) {
                FlexmarkHtmlConverter.processWrapped(this, node, isBlock, escapeMarkdown);
            }

            @Override
            public void appendOuterHtml(org.jsoup.nodes.Node node) {
                FlexmarkHtmlConverter.appendOuterHtml(this, node);
            }

            @Override
            public boolean isInlineCode() {
                return this.myMainNodeRenderer.isInlineCode();
            }

            @Override
            public void setInlineCode(boolean inlineCode) {
                this.myMainNodeRenderer.setInlineCode(inlineCode);
            }

            @Override
            public void inlineCode(Runnable inlineRunnable) {
                this.myMainNodeRenderer.inlineCode(inlineRunnable);
            }

            @Override
            public String escapeSpecialChars(String text) {
                return this.myMainNodeRenderer.escapeSpecialChars(text);
            }

            @Override
            public String prepareText(String text) {
                return this.myMainNodeRenderer.prepareText(text);
            }

            @Override
            public String prepareText(String text, boolean inCode) {
                return this.myMainNodeRenderer.prepareText(text, inCode);
            }

            @Override
            public String processTextNodes(org.jsoup.nodes.Node node) {
                return this.myMainNodeRenderer.processTextNodes(node);
            }

            @Override
            public void excludeAttributes(String ... excludes) {
                this.myMainNodeRenderer.excludeAttributes(excludes);
            }

            @Override
            public void processTextNodes(org.jsoup.nodes.Node node, boolean stripIdAttribute) {
                this.processTextNodes(node, stripIdAttribute, null, null);
            }

            @Override
            public void processTextNodes(org.jsoup.nodes.Node node, boolean stripIdAttribute, CharSequence wrapText) {
                this.processTextNodes(node, stripIdAttribute, wrapText, wrapText);
            }

            @Override
            public void processTextNodes(org.jsoup.nodes.Node node, boolean stripIdAttribute, CharSequence textPrefix, CharSequence textSuffix) {
                FlexmarkHtmlConverter.processTextNodes(this, node, stripIdAttribute, textPrefix, textSuffix);
            }

            @Override
            public void wrapTextNodes(org.jsoup.nodes.Node node, CharSequence wrapText, boolean needSpaceAround) {
                FlexmarkHtmlConverter.wrapTextNodes(this, node, wrapText, needSpaceAround);
            }

            @Override
            public void processConditional(ExtensionConversion extensionConversion, org.jsoup.nodes.Node node, Runnable processNode) {
                FlexmarkHtmlConverter.processConditional(this, extensionConversion, node, processNode);
            }

            @Override
            public void renderDefault(org.jsoup.nodes.Node node) {
                FlexmarkHtmlConverter.processDefault(this, node, this.getHtmlConverterOptions().outputUnknownTags);
            }

            @Override
            public HtmlConverterState getState() {
                return this.myMainNodeRenderer.getState();
            }

            @Override
            public boolean isTrace() {
                return this.myMainNodeRenderer.isTrace();
            }

            @Override
            public void setTrace(boolean trace) {
                this.myMainNodeRenderer.setTrace(trace);
            }

            @Override
            public Stack<HtmlConverterState> getStateStack() {
                return this.myMainNodeRenderer.getStateStack();
            }
        }
    }

    private static class RendererDependencyHandler
    extends DependencyHandler<DelegatingNodeRendererFactoryWrapper, RendererDependencyStage, RendererDependencies> {
        private RendererDependencyHandler() {
        }

        @Override
        protected Class getDependentClass(DelegatingNodeRendererFactoryWrapper dependent) {
            return dependent.getFactory().getClass();
        }

        @Override
        protected RendererDependencies createResolvedDependencies(List<RendererDependencyStage> stages) {
            return new RendererDependencies(stages);
        }

        @Override
        protected RendererDependencyStage createStage(List<DelegatingNodeRendererFactoryWrapper> dependents) {
            return new RendererDependencyStage(dependents);
        }
    }

    public static class RendererDependencies
    extends ResolvedDependencies<RendererDependencyStage> {
        private final List<DelegatingNodeRendererFactoryWrapper> nodeRendererFactories;

        public RendererDependencies(List<RendererDependencyStage> dependentStages) {
            super(dependentStages);
            ArrayList<DelegatingNodeRendererFactoryWrapper> blockPreProcessorFactories = new ArrayList<DelegatingNodeRendererFactoryWrapper>();
            for (RendererDependencyStage stage : dependentStages) {
                blockPreProcessorFactories.addAll(stage.dependents);
            }
            this.nodeRendererFactories = blockPreProcessorFactories;
        }

        public List<DelegatingNodeRendererFactoryWrapper> getNodeRendererFactories() {
            return this.nodeRendererFactories;
        }
    }

    public static class RendererDependencyStage {
        private final List<DelegatingNodeRendererFactoryWrapper> dependents;

        public RendererDependencyStage(List<DelegatingNodeRendererFactoryWrapper> dependents) {
            this.dependents = dependents;
        }
    }

    public static interface HtmlConverterExtension
    extends Extension {
        public void rendererOptions(MutableDataHolder var1);

        public void extend(Builder var1);
    }

    public static class Builder
    extends BuilderBase<Builder> {
        List<HtmlNodeRendererFactory> nodeRendererFactories = new ArrayList<HtmlNodeRendererFactory>();
        List<HtmlLinkResolverFactory> linkResolverFactories = new ArrayList<HtmlLinkResolverFactory>();
        HeaderIdGeneratorFactory htmlIdGeneratorFactory = null;

        public Builder() {
        }

        public Builder(DataHolder options) {
            super(options);
            this.loadExtensions();
        }

        public Builder(Builder other) {
            super(other);
            this.linkResolverFactories.addAll(other.linkResolverFactories);
        }

        public Builder(Builder other, DataHolder options) {
            this(other);
            this.withOptions(options);
        }

        public FlexmarkHtmlConverter build() {
            return new FlexmarkHtmlConverter(this);
        }

        @Override
        protected void removeApiPoint(Object apiPoint) {
            if (apiPoint instanceof HtmlNodeRendererFactory) {
                this.nodeRendererFactories.remove(apiPoint);
            } else if (apiPoint instanceof HtmlLinkResolverFactory) {
                this.linkResolverFactories.remove(apiPoint);
            } else if (apiPoint instanceof HeaderIdGeneratorFactory) {
                this.htmlIdGeneratorFactory = null;
            } else {
                throw new IllegalStateException("Unknown data point type: " + apiPoint.getClass().getName());
            }
        }

        @Override
        protected void preloadExtension(Extension extension) {
            if (extension instanceof HtmlConverterExtension) {
                HtmlConverterExtension htmlConverterExtension = (HtmlConverterExtension)extension;
                htmlConverterExtension.rendererOptions(this);
            }
        }

        @Override
        protected boolean loadExtension(Extension extension) {
            if (extension instanceof HtmlConverterExtension) {
                HtmlConverterExtension htmlConverterExtension = (HtmlConverterExtension)extension;
                htmlConverterExtension.extend(this);
                return true;
            }
            return false;
        }

        public Builder htmlNodeRendererFactory(HtmlNodeRendererFactory htmlNodeRendererFactory) {
            this.nodeRendererFactories.add(htmlNodeRendererFactory);
            return this;
        }

        public Builder linkResolverFactory(HtmlLinkResolverFactory linkResolverFactory) {
            this.linkResolverFactories.add(linkResolverFactory);
            this.addExtensionApiPoint(linkResolverFactory);
            return this;
        }
    }
}

