/*
 * Decompiled with CFR 0.152.
 */
package atlantafx.base.controls;

import atlantafx.base.controls.BehaviorSkinBase;
import atlantafx.base.controls.Calendar;
import atlantafx.base.controls.CalendarBehavior;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.Chronology;
import java.time.format.DateTimeFormatter;
import java.time.format.DecimalStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.ValueRange;
import java.time.temporal.WeekFields;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.DateCell;
import javafx.scene.control.Label;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.util.Callback;

public class CalendarSkin
extends BehaviorSkinBase<Calendar, CalendarBehavior> {
    final DateTimeFormatter yearFormatter = DateTimeFormatter.ofPattern("y");
    final DateTimeFormatter monthFormatter = DateTimeFormatter.ofPattern("MMMM");
    final DateTimeFormatter weekNumberFormatter = DateTimeFormatter.ofPattern("w");
    final DateTimeFormatter dayCellFormatter = DateTimeFormatter.ofPattern("d");
    final DateTimeFormatter monthFormatterSO = DateTimeFormatter.ofPattern("LLLL");
    final DateTimeFormatter weekDayNameFormatter = DateTimeFormatter.ofPattern("ccc");
    protected final VBox rootPane = new VBox();
    protected CalendarGrid calendarGrid;
    protected Button forwardButton;
    protected Button backButton;
    protected Label monthLabel;
    protected Label yearLabel;
    protected final List<DateCell> dayNameCells = new ArrayList<DateCell>();
    protected final List<DateCell> weekNumberCells = new ArrayList<DateCell>();
    protected final List<DateCell> dayCells = new ArrayList<DateCell>();
    protected LocalDate[] dayCellDates;
    protected DateCell lastFocusedDayCell = null;
    protected final int daysPerWeek = this.getDaysPerWeek();
    private final ObjectProperty<YearMonth> displayedYearMonth = new SimpleObjectProperty((Object)this, "displayedYearMonth");
    private final ObjectBinding<LocalDate> firstDayOfMonth = Bindings.createObjectBinding(() -> ((YearMonth)this.displayedYearMonth.get()).atDay(1), (Observable[])new Observable[]{this.displayedYearMonth});

    public ObjectProperty<YearMonth> displayedYearMonthProperty() {
        return this.displayedYearMonth;
    }

    public LocalDate getFirstDayOfMonth() {
        return (LocalDate)this.firstDayOfMonth.get();
    }

    public CalendarSkin(Calendar control) {
        super(control);
        this.createUI();
        this.registerChangeListener((ObservableValue)control.valueProperty(), e -> {
            LocalDate date = control.getValue();
            this.displayedYearMonthProperty().set((Object)(date != null ? YearMonth.from(date) : YearMonth.now(ZoneId.systemDefault())));
            this.updateValues();
            control.fireEvent((Event)new ActionEvent());
        });
        this.registerChangeListener((ObservableValue)control.showWeekNumbersProperty(), e -> {
            this.updateGrid();
            this.updateWeekNumberCells();
        });
        this.registerChangeListener((ObservableValue)control.topNodeProperty(), e -> {
            Node node = control.getTopNode();
            if (node == null) {
                this.rootPane.getChildren().removeIf(c -> c.getStyleClass().contains((Object)"top-node"));
            } else {
                if (!node.getStyleClass().contains((Object)"top-node")) {
                    node.getStyleClass().add((Object)"top-node");
                }
                this.rootPane.getChildren().add(0, (Object)node);
            }
        });
        this.registerChangeListener((ObservableValue)control.bottomNodeProperty(), e -> {
            Node node = control.getBottomNode();
            if (node == null) {
                this.rootPane.getChildren().removeIf(c -> c.getStyleClass().contains((Object)"bottom-node"));
            } else {
                if (!node.getStyleClass().contains((Object)"bottom-node")) {
                    node.getStyleClass().add((Object)"bottom-node");
                }
                this.rootPane.getChildren().add((Object)node);
            }
        });
    }

    @Override
    public CalendarBehavior createDefaultBehavior() {
        return new CalendarBehavior((Calendar)((Object)this.getControl()), this);
    }

    public Locale getLocale() {
        return Locale.getDefault(Locale.Category.FORMAT);
    }

    public Scene getScene() {
        return ((Calendar)((Object)this.getControl())).getScene();
    }

    public Chronology getPrimaryChronology() {
        return ((Calendar)((Object)this.getControl())).getChronology();
    }

    public int getMonthsPerYear() {
        ValueRange range = this.getPrimaryChronology().range(ChronoField.MONTH_OF_YEAR);
        return (int)(range.getMaximum() - range.getMinimum() + 1L);
    }

    public int getDaysPerWeek() {
        ValueRange range = this.getPrimaryChronology().range(ChronoField.DAY_OF_WEEK);
        return (int)(range.getMaximum() - range.getMinimum() + 1L);
    }

    protected void createUI() {
        DateCell cell;
        int i;
        LocalDate value;
        if (((Calendar)((Object)this.getControl())).getTopNode() != null) {
            ((Calendar)((Object)this.getControl())).getTopNode().getStyleClass().add((Object)"top-node");
            this.rootPane.getChildren().add((Object)((Calendar)((Object)this.getControl())).getTopNode());
        }
        this.displayedYearMonth.set((Object)((value = ((Calendar)((Object)this.getControl())).getValue()) != null ? YearMonth.from(value) : YearMonth.now(ZoneId.systemDefault())));
        this.displayedYearMonth.addListener((observable, oldValue, newValue) -> this.updateValues());
        this.rootPane.getChildren().add((Object)this.createMonthYearPane());
        this.calendarGrid = new CalendarGrid();
        this.calendarGrid.getStyleClass().add((Object)"calendar-grid");
        this.calendarGrid.setFocusTraversable(true);
        this.calendarGrid.setVgap(-1.0);
        this.calendarGrid.setHgap(-1.0);
        for (i = 0; i < this.daysPerWeek; ++i) {
            cell = new DateCell();
            cell.getStyleClass().add((Object)"day-name-cell");
            this.dayNameCells.add(cell);
        }
        for (i = 0; i < 6; ++i) {
            cell = new DateCell();
            cell.getStyleClass().add((Object)"week-number-cell");
            this.weekNumberCells.add(cell);
        }
        this.createDayCells();
        this.updateGrid();
        this.rootPane.getStyleClass().addAll((Object[])new String[]{"date-picker-popup", "calendar"});
        this.rootPane.getChildren().add((Object)this.calendarGrid);
        if (((Calendar)((Object)this.getControl())).getBottomNode() != null) {
            ((Calendar)((Object)this.getControl())).getBottomNode().getStyleClass().add((Object)"bottom-node");
            this.rootPane.getChildren().add((Object)((Calendar)((Object)this.getControl())).getBottomNode());
        }
        this.getChildren().add((Object)this.rootPane);
        ((Calendar)((Object)this.getControl())).setOnKeyPressed(e -> ((CalendarBehavior)this.behavior).onKeyPressed((KeyEvent)e));
        this.refresh();
    }

    protected HBox createMonthYearPane() {
        HBox monthYearPane = new HBox();
        monthYearPane.getStyleClass().add((Object)"month-year-pane");
        this.backButton = new Button();
        this.backButton.getStyleClass().addAll((Object[])new String[]{"back-button"});
        this.backButton.setOnMouseClicked(((CalendarBehavior)this.behavior)::moveBackward);
        StackPane leftArrow = new StackPane();
        leftArrow.getStyleClass().add((Object)"left-arrow");
        leftArrow.setMaxSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.backButton.setGraphic((Node)leftArrow);
        Region spacer = new Region();
        HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
        this.monthLabel = new Label();
        this.monthLabel.getStyleClass().add((Object)"month-label");
        this.yearLabel = new Label();
        this.yearLabel.getStyleClass().add((Object)"year-label");
        this.forwardButton = new Button();
        this.forwardButton.getStyleClass().addAll((Object[])new String[]{"forward-button"});
        this.forwardButton.setOnMouseClicked(((CalendarBehavior)this.behavior)::moveForward);
        StackPane rightArrow = new StackPane();
        rightArrow.getStyleClass().add((Object)"right-arrow");
        rightArrow.setMaxSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.forwardButton.setGraphic((Node)rightArrow);
        monthYearPane.getChildren().addAll((Object[])new Node[]{this.monthLabel, this.yearLabel, spacer, this.backButton, this.forwardButton});
        return monthYearPane;
    }

    public void refresh() {
        this.updateDayNameCells();
        this.updateValues();
    }

    public void updateValues() {
        this.updateWeekNumberCells();
        this.updateDayCells();
        this.updateMonthYearPane();
    }

    public void updateGrid() {
        int i;
        this.calendarGrid.getColumnConstraints().clear();
        this.calendarGrid.getChildren().clear();
        int nCols = this.daysPerWeek + (((Calendar)((Object)this.getControl())).isShowWeekNumbers() ? 1 : 0);
        ColumnConstraints columnConstraints = new ColumnConstraints();
        columnConstraints.setPercentWidth(100.0);
        for (i = 0; i < nCols; ++i) {
            this.calendarGrid.getColumnConstraints().add((Object)columnConstraints);
        }
        for (i = 0; i < this.daysPerWeek; ++i) {
            this.calendarGrid.add((Node)this.dayNameCells.get(i), i + nCols - this.daysPerWeek, 1);
        }
        if (((Calendar)((Object)this.getControl())).isShowWeekNumbers()) {
            for (i = 0; i < 6; ++i) {
                this.calendarGrid.add((Node)this.weekNumberCells.get(i), 0, i + 2);
            }
        }
        for (int row = 0; row < 6; ++row) {
            for (int col = 0; col < this.daysPerWeek; ++col) {
                this.calendarGrid.add((Node)this.dayCells.get(row * this.daysPerWeek + col), col + nCols - this.daysPerWeek, row + 2);
            }
        }
    }

    public void updateDayNameCells() {
        int firstDayOfWeek = WeekFields.of(this.getLocale()).getFirstDayOfWeek().getValue();
        LocalDate date = LocalDate.of(2009, 7, 12 + firstDayOfWeek);
        for (int i = 0; i < this.daysPerWeek; ++i) {
            String name = this.weekDayNameFormatter.withLocale(this.getLocale()).format(date.plus(i, ChronoUnit.DAYS));
            this.dayNameCells.get(i).setText(CalendarSkin.capitalize(name));
        }
    }

    public void updateWeekNumberCells() {
        if (((Calendar)((Object)this.getControl())).isShowWeekNumbers()) {
            Locale locale = this.getLocale();
            int maxWeeksPerMonth = 6;
            LocalDate firstOfMonth = ((YearMonth)this.displayedYearMonth.get()).atDay(1);
            for (int i = 0; i < 6; ++i) {
                LocalDate date = firstOfMonth.plus(i, ChronoUnit.WEEKS);
                String cellText = this.weekNumberFormatter.withLocale(locale).withDecimalStyle(DecimalStyle.of(locale)).format(date);
                this.weekNumberCells.get(i).setText(cellText);
            }
        }
    }

    public void updateDayCells() {
        Locale locale = this.getLocale();
        Chronology chrono = this.getPrimaryChronology();
        YearMonth curMonth = (YearMonth)this.displayedYearMonth.get();
        int firstOfMonthIdx = this.determineFirstOfMonthDayOfWeek();
        YearMonth prevMonth = null;
        YearMonth nextMonth = null;
        int daysInCurMonth = -1;
        int daysInPrevMonth = -1;
        for (int i = 0; i < 6 * this.daysPerWeek; ++i) {
            DateCell dayCell = this.dayCells.get(i);
            dayCell.getStyleClass().setAll((Object[])new String[]{"cell", "date-cell", "day-cell"});
            dayCell.setDisable(false);
            dayCell.setStyle(null);
            dayCell.setGraphic(null);
            dayCell.setTooltip(null);
            try {
                LocalDate date;
                daysInCurMonth = daysInCurMonth == -1 ? curMonth.lengthOfMonth() : daysInCurMonth;
                YearMonth month = curMonth;
                int day = i - firstOfMonthIdx + 1;
                if (i < firstOfMonthIdx) {
                    if (prevMonth == null) {
                        prevMonth = curMonth.minusMonths(1L);
                        daysInPrevMonth = prevMonth.lengthOfMonth();
                    }
                    month = prevMonth;
                    day = i + daysInPrevMonth - firstOfMonthIdx + 1;
                    dayCell.getStyleClass().add((Object)"previous-month");
                } else if (i >= firstOfMonthIdx + daysInCurMonth) {
                    if (nextMonth == null) {
                        nextMonth = curMonth.plusMonths(1L);
                    }
                    month = nextMonth;
                    day = i - daysInCurMonth - firstOfMonthIdx + 1;
                    dayCell.getStyleClass().add((Object)"next-month");
                }
                this.dayCellDates[i] = date = month.atDay(day);
                ChronoLocalDate cDate = chrono.date(date);
                dayCell.setDisable(false);
                if (CalendarSkin.isToday(date)) {
                    dayCell.getStyleClass().add((Object)"today");
                }
                if (date.equals(((Calendar)((Object)this.getControl())).getValue())) {
                    dayCell.getStyleClass().add((Object)"selected");
                }
                String cellText = this.dayCellFormatter.withLocale(locale).withChronology(chrono).withDecimalStyle(DecimalStyle.of(locale)).format(cDate);
                dayCell.setText(cellText);
                dayCell.updateItem(date, false);
                continue;
            }
            catch (DateTimeException ex) {
                dayCell.setText(" ");
                dayCell.setDisable(true);
            }
        }
    }

    private int determineFirstOfMonthDayOfWeek() {
        int firstDayOfWeek = WeekFields.of(this.getLocale()).getFirstDayOfWeek().getValue();
        int firstOfMonthIdx = ((YearMonth)this.displayedYearMonth.get()).atDay(1).getDayOfWeek().getValue() - firstDayOfWeek;
        return firstOfMonthIdx < 0 ? firstOfMonthIdx + this.daysPerWeek : firstOfMonthIdx;
    }

    public void updateMonthYearPane() {
        YearMonth yearMonth = (YearMonth)this.displayedYearMonth.get();
        this.monthLabel.setText(this.formatMonth(yearMonth));
        this.yearLabel.setText(this.formatYear(yearMonth));
        this.backButton.setDisable(!this.canGoMonthBack());
        this.forwardButton.setDisable(!this.canGoMonthForward());
    }

    protected String formatMonth(YearMonth yearMonth) {
        Chronology chrono = this.getPrimaryChronology();
        try {
            ChronoLocalDate chronoDate = chrono.date(yearMonth.atDay(1));
            String str = this.monthFormatterSO.withLocale(this.getLocale()).withChronology(chrono).format(chronoDate);
            if (Character.isDigit(str.charAt(0))) {
                str = this.monthFormatter.withLocale(this.getLocale()).withChronology(chrono).format(chronoDate);
            }
            return CalendarSkin.capitalize(str);
        }
        catch (DateTimeException ex) {
            return "";
        }
    }

    protected String formatYear(YearMonth yearMonth) {
        Chronology chrono = this.getPrimaryChronology();
        try {
            ChronoLocalDate chronoDate = chrono.date(yearMonth.atDay(1));
            return this.yearFormatter.withLocale(this.getLocale()).withChronology(chrono).withDecimalStyle(DecimalStyle.of(this.getLocale())).format(chronoDate);
        }
        catch (DateTimeException ex) {
            return "";
        }
    }

    public void forward(int offset, ChronoUnit unit, boolean focusDayCell) {
        YearMonth yearMonth = (YearMonth)this.displayedYearMonth.get();
        DateCell dateCell = this.lastFocusedDayCell;
        if (dateCell == null || !this.getDayCellDate(dateCell).getMonth().equals(yearMonth.getMonth())) {
            dateCell = this.findDayCellForDate(yearMonth.atDay(1));
        }
        this.goToDayCell(dateCell, offset, unit, focusDayCell);
    }

    public void goToDayCell(DateCell dateCell, int offset, ChronoUnit unit, boolean focusDayCell) {
        this.goToDate(this.getDayCellDate(dateCell).plus(offset, unit), focusDayCell);
    }

    public void goToDate(LocalDate date, boolean focusDayCell) {
        if (Calendar.isValidDate(this.getPrimaryChronology(), date)) {
            this.displayedYearMonth.set((Object)YearMonth.from(date));
            if (focusDayCell) {
                this.findDayCellForDate(date).requestFocus();
            }
        }
    }

    private DateCell findDayCellForDate(LocalDate date) {
        for (int i = 0; i < this.dayCellDates.length; ++i) {
            if (!date.equals(this.dayCellDates[i])) continue;
            return this.dayCells.get(i);
        }
        return this.dayCells.get(this.dayCells.size() / 2 + 1);
    }

    public void selectDayCell(DateCell dateCell) {
        ((Calendar)((Object)this.getControl())).setValue(this.getDayCellDate(dateCell));
    }

    private LocalDate getDayCellDate(DateCell dateCell) {
        return this.dayCellDates[this.dayCells.indexOf(dateCell)];
    }

    protected void createDayCells() {
        EventHandler dayCellActionHandler = e -> {
            if (e.getButton() != MouseButton.PRIMARY) {
                return;
            }
            DateCell dayCell = (DateCell)e.getSource();
            this.selectDayCell(dayCell);
            this.lastFocusedDayCell = dayCell;
        };
        for (int row = 0; row < 6; ++row) {
            for (int col = 0; col < this.daysPerWeek; ++col) {
                DateCell dayCell = this.createDayCell();
                dayCell.addEventHandler(MouseEvent.MOUSE_CLICKED, dayCellActionHandler);
                this.dayCells.add(dayCell);
            }
        }
        this.dayCellDates = new LocalDate[6 * this.daysPerWeek];
    }

    protected DateCell createDayCell() {
        Callback<Calendar, DateCell> factory = ((Calendar)((Object)this.getControl())).getDayCellFactory();
        return Objects.requireNonNullElseGet(factory != null ? (DateCell)factory.call((Object)((Calendar)((Object)this.getControl()))) : null, DateCell::new);
    }

    public void rememberFocusedDayCell() {
        Node node = ((Calendar)((Object)this.getControl())).getScene().getFocusOwner();
        if (node instanceof DateCell) {
            DateCell dc;
            this.lastFocusedDayCell = dc = (DateCell)node;
        }
    }

    public boolean canGoMonthBack() {
        return Calendar.isValidDate(this.getPrimaryChronology(), this.getFirstDayOfMonth(), -1, ChronoUnit.DAYS);
    }

    public boolean canGoMonthForward() {
        return Calendar.isValidDate(this.getPrimaryChronology(), this.getFirstDayOfMonth(), 1, ChronoUnit.MONTHS);
    }

    public boolean canGoYearBack() {
        return Calendar.isValidDate(this.getPrimaryChronology(), this.getFirstDayOfMonth(), -1, ChronoUnit.YEARS);
    }

    public boolean canGoYearForward() {
        return Calendar.isValidDate(this.getPrimaryChronology(), this.getFirstDayOfMonth(), 1, ChronoUnit.YEARS);
    }

    public void clearFocus() {
        LocalDate focusDate = Objects.requireNonNullElseGet(((Calendar)((Object)this.getControl())).getValue(), LocalDate::now);
        if (YearMonth.from(focusDate).equals(this.displayedYearMonth.get())) {
            this.goToDate(focusDate, true);
        } else {
            this.backButton.requestFocus();
        }
    }

    private static String capitalize(String word) {
        int firstChar;
        if (((String)word).length() > 0 && !Character.isTitleCase(firstChar = ((String)word).codePointAt(0))) {
            word = new String(new int[]{Character.toTitleCase(firstChar)}, 0, 1) + ((String)word).substring(Character.offsetByCodePoints((CharSequence)word, 0, 1));
        }
        return word;
    }

    private static boolean isToday(LocalDate date) {
        return date != null && date.equals(CalendarSkin.today());
    }

    private static LocalDate today() {
        return LocalDate.now(ZoneId.systemDefault());
    }

    protected class CalendarGrid
    extends GridPane {
        protected CalendarGrid() {
        }

        protected double computePrefWidth(double height) {
            double width = super.computePrefWidth(height);
            int nCols = CalendarSkin.this.daysPerWeek + (((Calendar)((Object)CalendarSkin.this.getControl())).isShowWeekNumbers() ? 1 : 0);
            double snapHGap = this.snapSpaceX(this.getHgap());
            double hGaps = snapHGap * (double)(nCols - 1);
            double left = this.snapSpaceX(this.getInsets().getLeft());
            double right = this.snapSpaceX(this.getInsets().getRight());
            double contentWidth = width - left - right - hGaps;
            return this.snapSizeX(contentWidth / (double)nCols) * (double)nCols + left + right + hGaps;
        }

        protected void layoutChildren() {
            if (this.getWidth() > 0.0 && this.getHeight() > 0.0) {
                super.layoutChildren();
            }
        }
    }
}

