/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.generator.battlemat;

import com.inkwellideas.ographer.data.MapLayer;
import com.inkwellideas.ographer.data.ViewLevel;
import com.inkwellideas.ographer.generator.battlemat.BattlematDataGenerator;
import com.inkwellideas.ographer.map.MapShape;
import com.inkwellideas.ographer.map.Terrain;
import com.inkwellideas.ographer.model.Feature;
import com.inkwellideas.ographer.model.TextureType;
import java.util.List;
import javafx.geometry.Point2D;
import javafx.scene.paint.Color;
import javafx.scene.paint.ImagePattern;
import javafx.scene.shape.Polygon;

public class MakeHouse {
    public static void makeHouseMainStairs(List<MapShape> shapes, Polygon kitchenpoly, List<Feature> features, double kitchenleft, double kitchentop, double kitchenright, double kitchenbottom, String stroketexture, String filltexture, MapLayer ml, MapLayer shapelayer) {
        BattlematDataGenerator.makeRoom(shapes, kitchenpoly, kitchenleft, kitchentop, kitchenright - 1.0, kitchenbottom, stroketexture, filltexture, shapelayer, "room");
        Feature kitchenfire1 = new Feature("Battlemat/Stairs Wood", false, false, false, false, null, 90.0, null, 90.0, 200.0, false, false, null, "stairs", false, false, false, false, ml);
        kitchenfire1.setLocation(ViewLevel.BATTLEMAT, new Point2D((kitchenleft + 2.0) * 300.0, (kitchentop + 0.5) * 300.0));
        features.add(kitchenfire1);
        Feature kitchendoor = new Feature("Battlemat/Door Wood", false, false, false, false, null, 0.0, null, -1.0, -1.0, false, false, null, "door", false, false, false, false, ml);
        kitchendoor.setLocation(ViewLevel.BATTLEMAT, new Point2D((kitchenleft + 0.5) * 300.0, kitchenbottom * 300.0));
        features.add(kitchendoor);
        BattlematDataGenerator.makeRoom(shapes, kitchenpoly, kitchenright - 1.0, kitchentop, kitchenright, kitchenbottom, stroketexture, filltexture, shapelayer, "room");
        Feature closetdoor = new Feature("Battlemat/Door Wood", false, false, false, false, null, 0.0, null, -1.0, -1.0, false, false, null, "door", false, false, false, false, ml);
        closetdoor.setLocation(ViewLevel.BATTLEMAT, new Point2D((kitchenright - 0.5) * 300.0, kitchenbottom * 300.0));
        features.add(closetdoor);
    }

    public static void makeHouseTopStairs(List<MapShape> shapes, Polygon kitchenpoly, List<Feature> features, double kitchenleft, double kitchentop, double kitchenright, double kitchenbottom, String stroketexture, String filltexture, MapLayer ml, MapLayer shapelayer) {
        BattlematDataGenerator.makeRoom(shapes, kitchenpoly, kitchenleft + 1.0, kitchentop, kitchenright, kitchenbottom, stroketexture, filltexture, shapelayer, "room");
        Feature kitchenfire1 = new Feature("Battlemat/Stairs Wood", false, false, false, false, null, 90.0, null, 90.0, 200.0, false, false, null, "stairs", false, false, false, false, ml);
        kitchenfire1.setLocation(ViewLevel.BATTLEMAT, new Point2D((kitchenleft + 2.0) * 300.0, (kitchentop + 0.5) * 300.0));
        features.add(kitchenfire1);
        Feature kitchendoor = new Feature("Battlemat/Door Wood", false, false, false, false, null, 0.0, null, -1.0, -1.0, false, false, null, "door", false, false, false, false, ml);
        kitchendoor.setLocation(ViewLevel.BATTLEMAT, new Point2D((kitchenright - 0.5) * 300.0, kitchenbottom * 300.0));
        features.add(kitchendoor);
        BattlematDataGenerator.makeRoom(shapes, kitchenpoly, kitchenleft, kitchentop, kitchenleft + 1.0, kitchenbottom, stroketexture, filltexture, shapelayer, "room");
        Feature closetdoor = new Feature("Battlemat/Door Wood", false, false, false, false, null, 0.0, null, -1.0, -1.0, false, false, null, "door", false, false, false, false, ml);
        closetdoor.setLocation(ViewLevel.BATTLEMAT, new Point2D((kitchenleft + 0.5) * 300.0, kitchenbottom * 300.0));
        features.add(closetdoor);
    }

    public static void makeHouseLargeFrontRoom(List<MapShape> shapes, Polygon kitchenpoly, List<Feature> features, double kitchenleft, double kitchentop, double kitchenright, double kitchenbottom, String stroketexture, String filltexture, MapLayer ml, MapLayer shapelayer) {
        String furniture = "Pine";
        double ff = Math.random();
        if (ff < 0.33) {
            furniture = "Walnut";
        } else if (ff < 0.66) {
            furniture = "Weathered";
        }
        BattlematDataGenerator.makeRoom(shapes, kitchenpoly, kitchenleft, kitchentop, kitchenright, kitchenbottom, stroketexture, filltexture, shapelayer, "room");
        Feature kitchenfire1 = new Feature("Battlemat/Fireplace", false, false, false, false, null, 0.0, null, 90.0, 70.0, false, false, null, "table", false, false, false, false, ml);
        kitchenfire1.setLocation(ViewLevel.BATTLEMAT, new Point2D((kitchenleft + 2.0) * 300.0, (kitchentop + 0.2) * 300.0));
        features.add(kitchenfire1);
        Feature kitchendoor = new Feature("Battlemat/Door Wood", false, false, false, false, null, 0.0, null, -1.0, -1.0, false, false, null, "door", false, false, false, false, ml);
        kitchendoor.setLocation(ViewLevel.BATTLEMAT, new Point2D((kitchenleft + 0.5) * 300.0, kitchenbottom * 300.0));
        features.add(kitchendoor);
        Feature barrel1 = new Feature("Battlemat/Barrel Wood", false, false, false, false, null, 90.0, null, -1.0, -1.0, false, false, null, "table", false, false, false, false, ml);
        barrel1.setLocation(ViewLevel.BATTLEMAT, new Point2D((kitchenleft + 1.5) * 300.0, (kitchenbottom - 0.35) * 300.0));
        features.add(barrel1);
        Feature bookcase1 = new Feature("Battlemat/Bookcase " + furniture, false, false, false, false, null, 270.0, null, 90.0, 50.0, false, false, null, "table", false, false, false, false, ml);
        bookcase1.setLocation(ViewLevel.BATTLEMAT, new Point2D((kitchenleft + 0.2) * 300.0, (kitchentop + 0.5) * 300.0));
        features.add(bookcase1);
        String chair = MakeHouse.getChair(furniture);
        Feature chair1 = new Feature(chair, false, false, false, false, null, 180.0, null, -1.0, -1.0, false, false, null, "chair", false, false, false, false, ml);
        chair1.setLocation(ViewLevel.BATTLEMAT, new Point2D((kitchenright - 1.5) * 300.0, (kitchenbottom - 0.25) * 300.0));
        features.add(chair1);
        Feature chair2 = new Feature(chair, false, false, false, false, null, 180.0, null, -1.0, -1.0, false, false, null, "chair", false, false, false, false, ml);
        chair2.setLocation(ViewLevel.BATTLEMAT, new Point2D((kitchenright - 1.0) * 300.0, (kitchenbottom - 0.25) * 300.0));
        features.add(chair2);
        Feature chair3 = new Feature(chair, false, false, false, false, null, 180.0, null, -1.0, -1.0, false, false, null, "chair", false, false, false, false, ml);
        chair3.setLocation(ViewLevel.BATTLEMAT, new Point2D((kitchenright - 0.5) * 300.0, (kitchenbottom - 0.25) * 300.0));
        features.add(chair3);
        Feature chair4 = new Feature(chair, false, false, false, false, null, 0.0, null, -1.0, -1.0, false, false, null, "chair", false, false, false, false, ml);
        chair4.setLocation(ViewLevel.BATTLEMAT, new Point2D((kitchenright - 1.5) * 300.0, (kitchenbottom - 1.25) * 300.0));
        features.add(chair4);
        Feature chair5 = new Feature(chair, false, false, false, false, null, 0.0, null, -1.0, -1.0, false, false, null, "chair", false, false, false, false, ml);
        chair5.setLocation(ViewLevel.BATTLEMAT, new Point2D((kitchenright - 1.0) * 300.0, (kitchenbottom - 1.25) * 300.0));
        features.add(chair5);
        Feature chair6 = new Feature(chair, false, false, false, false, null, 0.0, null, -1.0, -1.0, false, false, null, "chair", false, false, false, false, ml);
        chair6.setLocation(ViewLevel.BATTLEMAT, new Point2D((kitchenright - 0.5) * 300.0, (kitchenbottom - 1.25) * 300.0));
        features.add(chair6);
        Feature kitchentable1 = new Feature("Battlemat/Table Rectangle " + furniture, false, false, false, false, null, 0.0, null, 200.0, 100.0, false, false, null, "table", false, false, false, false, ml);
        kitchentable1.setLocation(ViewLevel.BATTLEMAT, new Point2D((kitchenright - 1.0) * 300.0, (kitchenbottom - 0.75) * 300.0));
        features.add(kitchentable1);
        Feature window4 = new Feature("Battlemat/Window No Light", false, false, false, false, null, 0.0, null, -1.0, -1.0, false, false, null, "window", false, false, false, false, ml);
        window4.setLocation(ViewLevel.BATTLEMAT, new Point2D((kitchenleft + 1.5) * 300.0, kitchenbottom * 300.0));
        features.add(0, window4);
        Feature window5 = new Feature("Battlemat/Window No Light", false, false, false, false, null, 0.0, null, -1.0, -1.0, false, false, null, "window", false, false, false, false, ml);
        window5.setLocation(ViewLevel.BATTLEMAT, new Point2D((kitchenleft + 2.5) * 300.0, kitchenbottom * 300.0));
        features.add(0, window5);
    }

    public static void makeHouseKitchen(List<MapShape> shapes, Polygon kitchenpoly, List<Feature> features, double kitchenleft, double kitchentop, double kitchenright, double kitchenbottom, String stroketexture, String filltexture, MapLayer ml, MapLayer shapelayer) {
        String furniture = "Pine";
        double ff = Math.random();
        if (ff < 0.33) {
            furniture = "Walnut";
        } else if (ff < 0.66) {
            furniture = "Weathered";
        }
        BattlematDataGenerator.makeRoom(shapes, kitchenpoly, kitchenleft, kitchentop, kitchenright, kitchenbottom, stroketexture, filltexture, shapelayer, "room");
        Feature kitchenfire1 = new Feature("Battlemat/Fireplace", false, false, false, false, null, 270.0, null, 90.0, 70.0, false, false, null, "table", false, false, false, false, ml);
        kitchenfire1.setLocation(ViewLevel.BATTLEMAT, new Point2D((kitchenleft + 0.25) * 300.0, (kitchenbottom - 1.5) * 300.0));
        features.add(kitchenfire1);
        Feature kitchendoor = new Feature("Battlemat/Door Wood", false, false, false, false, null, 90.0, null, -1.0, -1.0, false, false, null, "door", false, false, false, false, ml);
        kitchendoor.setLocation(ViewLevel.BATTLEMAT, new Point2D(kitchenleft * 300.0, (kitchenbottom - 0.5) * 300.0));
        features.add(kitchendoor);
        Feature barrel1 = new Feature("Battlemat/Barrel Wood", false, false, false, false, null, 90.0, null, -1.0, -1.0, false, false, null, "table", false, false, false, false, ml);
        barrel1.setLocation(ViewLevel.BATTLEMAT, new Point2D((kitchenright - 0.35) * 300.0, (kitchentop + 0.35) * 300.0));
        features.add(barrel1);
        Feature bookcase1 = new Feature("Battlemat/Bookcase " + furniture, false, false, false, false, null, 180.0, null, 90.0, 50.0, false, false, null, "table", false, false, false, false, ml);
        bookcase1.setLocation(ViewLevel.BATTLEMAT, new Point2D((kitchenleft + 0.5) * 300.0, (kitchenbottom - 0.2) * 300.0));
        features.add(bookcase1);
        Feature kitchentable1 = new Feature("Battlemat/Table Rectangle " + furniture, false, false, false, false, null, 90.0, null, 150.0, 100.0, false, false, null, "table", false, false, false, false, ml);
        kitchentable1.setLocation(ViewLevel.BATTLEMAT, new Point2D((kitchenright - 0.5) * 300.0, (kitchenbottom - 0.75) * 300.0));
        features.add(kitchentable1);
        Feature window5 = new Feature("Battlemat/Window No Light", false, false, false, false, null, 0.0, null, -1.0, -1.0, false, false, null, "window", false, false, false, false, ml);
        window5.setLocation(ViewLevel.BATTLEMAT, new Point2D((kitchenleft + 1.5) * 300.0, kitchenbottom * 300.0));
        features.add(0, window5);
    }

    public static void makeHouseBedroom(List<MapShape> shapes, List<Feature> features, String stroketexture, String filltexture, Polygon guestroompoly, double guestroomleft, double guestroomtop, double guestroomright, double guestroombottom, boolean shiftbedright, MapLayer ml, MapLayer shapelayer) {
        BattlematDataGenerator.makeRoom(shapes, guestroompoly, guestroomleft, guestroomtop, guestroomright, guestroombottom, stroketexture, filltexture, shapelayer, "room");
        String furniture = "Pine";
        double ff = Math.random();
        if (ff < 0.33) {
            furniture = "Walnut";
        } else if (ff < 0.66) {
            furniture = "Weathered";
        }
        Feature ownerbed = new Feature(MakeHouse.getDoubleBed(furniture), false, false, false, false, null, 0.0, null, -1.0, -1.0, false, false, null, "bed", false, false, false, false, ml);
        ownerbed.setLocation(ViewLevel.BATTLEMAT, new Point2D((guestroomleft + (shiftbedright ? 1.25 : 1.0)) * 300.0, (guestroomtop + 0.8) * 300.0));
        features.add(ownerbed);
        if (guestroombottom - guestroomtop >= 3.0) {
            Feature ownerchair = new Feature(MakeHouse.getChair(furniture), false, false, false, false, null, 90.0, null, -1.0, -1.0, false, false, null, "chair", false, false, false, false, ml);
            ownerchair.setLocation(ViewLevel.BATTLEMAT, new Point2D((guestroomleft + 0.5) * 300.0, (guestroombottom - 0.7) * 300.0));
            features.add(ownerchair);
            Feature ownerdesk = new Feature(MakeHouse.getDesk(furniture), false, false, false, false, null, 270.0, null, -1.0, -1.0, false, false, null, "desk", false, false, false, false, ml);
            ownerdesk.setLocation(ViewLevel.BATTLEMAT, new Point2D((guestroomleft + 0.3) * 300.0, (guestroombottom - 0.7) * 300.0));
            features.add(ownerdesk);
        }
        Feature ownerdoor = new Feature("Battlemat/Door Wood", false, false, false, false, null, 0.0, null, -1.0, -1.0, false, false, null, "door", false, false, false, false, ml);
        ownerdoor.setLocation(ViewLevel.BATTLEMAT, new Point2D((guestroomleft + 1.0) * 300.0, guestroombottom * 300.0));
        features.add(ownerdoor);
        Feature window = new Feature("Battlemat/Window No Light", false, false, false, false, null, 0.0, null, -1.0, -1.0, false, false, null, "window", false, false, false, false, ml);
        window.setLocation(ViewLevel.BATTLEMAT, new Point2D((guestroomleft + 1.0) * 300.0, guestroomtop * 300.0));
        features.add(0, window);
    }

    public static void makeHouseMasterBedroom(List<MapShape> shapes, List<Feature> features, String stroketexture, String filltexture, Polygon guestroompoly, double guestroomleft, double guestroomtop, double guestroomright, double guestroombottom, MapLayer ml, MapLayer shapelayer) {
        String furniture = "Pine";
        double ff = Math.random();
        if (ff < 0.33) {
            furniture = "Walnut";
        } else if (ff < 0.66) {
            furniture = "Weathered";
        }
        BattlematDataGenerator.makeRoom(shapes, guestroompoly, guestroomleft, guestroomtop, guestroomright, guestroombottom, stroketexture, filltexture, shapelayer, "room");
        Feature ownerbed = new Feature(MakeHouse.getDoubleBed(furniture), false, false, false, false, null, 90.0, null, -1.0, -1.0, false, false, null, "bed", false, false, false, false, ml);
        ownerbed.setLocation(ViewLevel.BATTLEMAT, new Point2D((guestroomright - 0.75) * 300.0, (guestroombottom - 1.0) * 300.0));
        features.add(ownerbed);
        Feature ownerchair = new Feature(MakeHouse.getChair(furniture), false, false, false, false, null, 180.0, null, -1.0, -1.0, false, false, null, "chair", false, false, false, false, ml);
        ownerchair.setLocation(ViewLevel.BATTLEMAT, new Point2D((guestroomleft + 0.5) * 300.0, (guestroomtop + 0.5) * 300.0));
        features.add(ownerchair);
        Feature ownerdesk = new Feature(MakeHouse.getDesk(furniture), false, false, false, false, null, 0.0, null, -1.0, -1.0, false, false, null, "desk", false, false, false, false, ml);
        ownerdesk.setLocation(ViewLevel.BATTLEMAT, new Point2D((guestroomleft + 0.7) * 300.0, (guestroomtop + 0.3) * 300.0));
        features.add(ownerdesk);
        Feature ownerdoor = new Feature("Battlemat/Door Wood", false, false, false, false, null, 90.0, null, -1.0, -1.0, false, false, null, "door", false, false, false, false, ml);
        ownerdoor.setLocation(ViewLevel.BATTLEMAT, new Point2D(guestroomleft * 300.0, (guestroombottom - 0.5) * 300.0));
        features.add(ownerdoor);
        Feature window = new Feature("Battlemat/Window No Light", false, false, false, false, null, 90.0, null, -1.0, -1.0, false, false, null, "window", false, false, false, false, ml);
        window.setLocation(ViewLevel.BATTLEMAT, new Point2D(guestroomright * 300.0, (guestroomtop + 1.0) * 300.0));
        features.add(0, window);
    }

    public static void makeHouseLoft(List<MapShape> shapes, List<Feature> features, String stroketexture, String filltexture, Polygon guestroompoly, double guestroomleft, double guestroomtop, double guestroomright, double guestroombottom, MapLayer ml, MapLayer shapelayer) {
        String furniture = "Pine";
        double ff = Math.random();
        if (ff < 0.33) {
            furniture = "Walnut";
        } else if (ff < 0.66) {
            furniture = "Weathered";
        }
        BattlematDataGenerator.makeRoom(shapes, guestroompoly, guestroomleft, guestroomtop, guestroomright, guestroombottom, stroketexture, filltexture, shapelayer, "room");
        Feature ownerbed = new Feature(MakeHouse.getDoubleBed(furniture), false, false, false, false, null, 180.0, null, -1.0, -1.0, false, false, null, "bed", false, false, false, false, ml);
        ownerbed.setLocation(ViewLevel.BATTLEMAT, new Point2D((guestroomleft + 0.75) * 300.0, (guestroombottom - 0.75) * 300.0));
        features.add(ownerbed);
        String bed = MakeHouse.getBed(furniture);
        Feature bed1 = new Feature(bed, false, false, false, false, null, 180.0, null, -1.0, -1.0, false, false, null, "bed", false, false, false, false, ml);
        bed1.setLocation(ViewLevel.BATTLEMAT, new Point2D((guestroomright - 1.5) * 300.0, (guestroombottom - 0.75) * 300.0));
        features.add(bed1);
        Feature bed2 = new Feature(bed, false, false, false, false, null, 180.0, null, -1.0, -1.0, false, false, null, "bed", false, false, false, false, ml);
        bed2.setLocation(ViewLevel.BATTLEMAT, new Point2D((guestroomright - 0.5) * 300.0, (guestroombottom - 0.75) * 300.0));
        features.add(bed2);
        Feature window1 = new Feature("Battlemat/Window No Light", false, false, false, false, null, 90.0, null, -1.0, -1.0, false, false, null, "window", false, false, false, false, ml);
        window1.setLocation(ViewLevel.BATTLEMAT, new Point2D(guestroomleft * 300.0, (guestroombottom - 1.0) * 300.0));
        features.add(0, window1);
        Feature window = new Feature("Battlemat/Window No Light", false, false, false, false, null, 90.0, null, -1.0, -1.0, false, false, null, "window", false, false, false, false, ml);
        window.setLocation(ViewLevel.BATTLEMAT, new Point2D(guestroomright * 300.0, (guestroombottom - 1.0) * 300.0));
        features.add(0, window);
    }

    public static void makeHouseBedroomLeft(List<MapShape> shapes, List<Feature> features, String stroketexture, String filltexture, Polygon guestroompoly, double guestroomleft, double guestroomtop, double guestroomright, double guestroombottom, MapLayer ml, MapLayer shapelayer) {
        String furniture = "Pine";
        double ff = Math.random();
        if (ff < 0.33) {
            furniture = "Walnut";
        } else if (ff < 0.66) {
            furniture = "Weathered";
        }
        BattlematDataGenerator.makeRoom(shapes, guestroompoly, guestroomleft, guestroomtop, guestroomright, guestroombottom, stroketexture, filltexture, shapelayer, "room");
        Feature ownerbed = new Feature(MakeHouse.getDoubleBed(furniture), false, false, false, false, null, 270.0, null, -1.0, -1.0, false, false, null, "bed", false, false, false, false, ml);
        ownerbed.setLocation(ViewLevel.BATTLEMAT, new Point2D((guestroomleft + 0.8) * 300.0, (guestroomtop + 1.0) * 300.0));
        features.add(ownerbed);
        Feature ownerdoor = new Feature("Battlemat/Door Wood", false, false, false, false, null, 90.0, null, -1.0, -1.0, false, false, null, "door", false, false, false, false, ml);
        ownerdoor.setLocation(ViewLevel.BATTLEMAT, new Point2D(guestroomright * 300.0, (guestroombottom - 0.5) * 300.0));
        features.add(ownerdoor);
        Feature window = new Feature("Battlemat/Window No Light", false, false, false, false, null, 90.0, null, -1.0, -1.0, false, false, null, "window", false, false, false, false, ml);
        window.setLocation(ViewLevel.BATTLEMAT, new Point2D(guestroomleft * 300.0, (guestroomtop + 1.0) * 300.0));
        features.add(0, window);
    }

    public static void makeHouseMainRoom(List<MapShape> shapes, List<Feature> features, String stroketexture, String filltexture, Polygon guestroompoly, double guestroomleft, double guestroomtop, double guestroomright, double guestroombottom, boolean windowsonsidesfront, boolean windowright, MapLayer ml, MapLayer shapelayer) {
        String furniture = "Pine";
        double ff = Math.random();
        if (ff < 0.33) {
            furniture = "Walnut";
        } else if (ff < 0.66) {
            furniture = "Weathered";
        }
        BattlematDataGenerator.makeRoom(shapes, guestroompoly, guestroomleft, guestroomtop, guestroomright, guestroombottom, stroketexture, filltexture, shapelayer, "room");
        Feature bookcase1 = new Feature("Battlemat/Bookcase " + furniture, false, false, false, false, null, 270.0, null, 90.0, 50.0, false, false, null, "table", false, false, false, false, ml);
        bookcase1.setLocation(ViewLevel.BATTLEMAT, new Point2D((guestroomleft + 0.2) * 300.0, (guestroombottom - 0.5) * 300.0));
        features.add(bookcase1);
        String chair = MakeHouse.getChair(furniture);
        Feature chair1 = new Feature(chair, false, false, false, false, null, 270.0, null, -1.0, -1.0, false, false, null, "chair", false, false, false, false, ml);
        chair1.setLocation(ViewLevel.BATTLEMAT, new Point2D((guestroomleft + 0.8) * 300.0, (guestroombottom - 1.0) * 300.0));
        features.add(chair1);
        Feature chair2 = new Feature(chair, false, false, false, false, null, 270.0, null, -1.0, -1.0, false, false, null, "chair", false, false, false, false, ml);
        chair2.setLocation(ViewLevel.BATTLEMAT, new Point2D((guestroomleft + 0.8) * 300.0, (guestroombottom - 1.5) * 300.0));
        features.add(chair2);
        Feature chair3 = new Feature(chair, false, false, false, false, null, 270.0, null, -1.0, -1.0, false, false, null, "chair", false, false, false, false, ml);
        chair3.setLocation(ViewLevel.BATTLEMAT, new Point2D((guestroomleft + 0.8) * 300.0, (guestroombottom - 2.0) * 300.0));
        features.add(chair3);
        Feature chair4 = new Feature(chair, false, false, false, false, null, 90.0, null, -1.0, -1.0, false, false, null, "chair", false, false, false, false, ml);
        chair4.setLocation(ViewLevel.BATTLEMAT, new Point2D((guestroomleft + 1.6) * 300.0, (guestroombottom - 1.0) * 300.0));
        features.add(chair4);
        Feature chair5 = new Feature(chair, false, false, false, false, null, 90.0, null, -1.0, -1.0, false, false, null, "chair", false, false, false, false, ml);
        chair5.setLocation(ViewLevel.BATTLEMAT, new Point2D((guestroomleft + 1.6) * 300.0, (guestroombottom - 1.5) * 300.0));
        features.add(chair5);
        Feature chair6 = new Feature(chair, false, false, false, false, null, 90.0, null, -1.0, -1.0, false, false, null, "chair", false, false, false, false, ml);
        chair6.setLocation(ViewLevel.BATTLEMAT, new Point2D((guestroomleft + 1.6) * 300.0, (guestroombottom - 2.0) * 300.0));
        features.add(chair6);
        Feature kitchentable1 = new Feature("Battlemat/Table Rectangle " + furniture, false, false, false, false, null, 90.0, null, 150.0, 100.0, false, false, null, "table", false, false, false, false, ml);
        kitchentable1.setLocation(ViewLevel.BATTLEMAT, new Point2D((guestroomleft + 1.2) * 300.0, (guestroombottom - 1.5) * 300.0));
        features.add(kitchentable1);
        Feature ownerdoor = new Feature("Battlemat/Door Wood", false, false, false, false, null, 0.0, null, -1.0, -1.0, false, false, null, "door", false, false, false, false, ml);
        ownerdoor.setLocation(ViewLevel.BATTLEMAT, new Point2D((guestroomleft + 1.0) * 300.0, guestroombottom * 300.0));
        features.add(ownerdoor);
        if (windowsonsidesfront) {
            Feature window1 = new Feature("Battlemat/Window No Light", false, false, false, false, null, 90.0, null, -1.0, -1.0, false, false, null, "window", false, false, false, false, ml);
            window1.setLocation(ViewLevel.BATTLEMAT, new Point2D(guestroomleft * 300.0, (guestroombottom - 1.5) * 300.0));
            features.add(0, window1);
            if (windowright) {
                Feature window = new Feature("Battlemat/Window No Light", false, false, false, false, null, 90.0, null, -1.0, -1.0, false, false, null, "window", false, false, false, false, ml);
                window.setLocation(ViewLevel.BATTLEMAT, new Point2D(guestroomright * 300.0, (guestroombottom - 1.5) * 300.0));
                features.add(0, window);
            }
        } else {
            Feature window1 = new Feature("Battlemat/Window No Light", false, false, false, false, null, 0.0, null, -1.0, -1.0, false, false, null, "window", false, false, false, false, ml);
            window1.setLocation(ViewLevel.BATTLEMAT, new Point2D((guestroomleft + 0.5) * 300.0, guestroombottom * 300.0));
            features.add(0, window1);
            if (windowright) {
                Feature window = new Feature("Battlemat/Window No Light", false, false, false, false, null, 0.0, null, -1.0, -1.0, false, false, null, "window", false, false, false, false, ml);
                window.setLocation(ViewLevel.BATTLEMAT, new Point2D((guestroomright - 0.5) * 300.0, guestroombottom * 300.0));
                features.add(0, window);
            }
        }
    }

    public static String getBed(String furniture) {
        String[] opts = new String[]{"Battlemat/Bed", "Battlemat/Bed Red", "Battlemat/Bed Blue"};
        int r = (int)(Math.random() * (double)opts.length);
        return opts[r] + " " + furniture;
    }

    public static String getDoubleBed(String furniture) {
        String[] opts = new String[]{"Battlemat/Bed Double", "Battlemat/Bed Double Red", "Battlemat/Bed Double Blue"};
        int r = (int)(Math.random() * (double)opts.length);
        return opts[r] + " " + furniture;
    }

    public static String getChair(String finish) {
        return "Battlemat/Chair " + finish;
    }

    public static String getDesk(String finish) {
        return "Battlemat/Desk " + finish;
    }

    public static Terrain[][] generateHouse(Terrain[][] t, List<MapShape> shapes, List<Feature> features, MapLayer ml, MapLayer shapelayer) {
        ImagePattern rockdktexture = new ImagePattern(TextureType.ALL_TEXTURES.get("Rock Dark").getIcon(), 0.0, 0.0, 50.0, 25.0, false);
        String mainfloor = "Wood";
        double mf = Math.random();
        if (mf < 0.3) {
            mainfloor = "Wood Dark";
        } else if (mf < 0.7) {
            mainfloor = "Wood Light";
        }
        String kitchenfloor = "Cobblestone Light";
        double kf = Math.random();
        if (kf < 0.33) {
            kitchenfloor = "Cobblestone Dark";
        } else if (kf < 0.66) {
            kitchenfloor = "Cobblestone";
        }
        String topfloor = "Wood Light";
        double tf = Math.random();
        if (tf < 0.33) {
            topfloor = "Wood";
        } else if (tf < 0.66) {
            topfloor = "Wood Dark";
        }
        double rnd = Math.random();
        double maxX = 0.0;
        double maxY = 0.0;
        if (rnd < 0.25) {
            double rnd2 = Math.random();
            Polygon backpoly = new Polygon();
            double backleft = 1.0;
            double backtop = 4.0;
            double backright = 5.0;
            double backbottom = 5.0;
            MakeHouse.makeHouseMainStairs(shapes, backpoly, features, backleft, backtop, backright, backbottom, "Rock Dark", mainfloor, ml, shapelayer);
            Polygon mainpoly = new Polygon();
            double mainleft = 1.0;
            double maintop = 5.0;
            double mainright = 5.0;
            double mainbottom = rnd2 < 0.6 ? 8.0 : 7.0;
            MakeHouse.makeHouseLargeFrontRoom(shapes, mainpoly, features, mainleft, maintop, mainright, mainbottom, "Rock Dark", kitchenfloor, ml, shapelayer);
            MapShape upstairsOutside = BattlematDataGenerator.makeRoom(6.0, 0.0, t.length, t[0].length, "Rock Dark", 0.0, Color.LIGHTBLUE, shapelayer);
            shapes.add(upstairsOutside);
            Polygon loftpoly = new Polygon();
            double loftleft = 7.0;
            double lofttop = 5.0;
            double loftright = 11.0;
            double loftbottom = rnd2 < 0.3 ? 8.0 : 7.0;
            maxX = loftright;
            maxY = loftleft;
            MakeHouse.makeHouseLoft(shapes, features, "Rock Dark", mainfloor, loftpoly, loftleft, lofttop, loftright, loftbottom, ml, shapelayer);
            Polygon topbackpoly = new Polygon();
            double topbackleft = 7.0;
            double topbacktop = 4.0;
            double topbackright = 11.0;
            double topbackbottom = 5.0;
            MakeHouse.makeHouseTopStairs(shapes, topbackpoly, features, topbackleft, topbacktop, topbackright, topbackbottom, "Rock Dark", mainfloor, ml, shapelayer);
            if ((double)t.length < topbackright + 2.0 || (double)t[0].length < topbackbottom + 4.0) {
                Terrain[][] t2 = new Terrain[Math.max((int)(topbackright + 2.0), t.length)][Math.max((int)(topbackbottom + 2.0), t[0].length)];
                for (int i = 0; i < t2.length; ++i) {
                    for (int j = 0; j < t2[i].length; ++j) {
                        t2[i][j] = new Terrain("Blank", false);
                    }
                }
                t = t2;
            }
            MapShape sky = BattlematDataGenerator.makeRoom(topbackleft - 1.0, 0.0, topbackright, t[0].length, "Rock Dark", 0.0, Color.LIGHTBLUE, shapelayer);
            shapes.add(0, sky);
        } else if (rnd < 0.6) {
            double rnd2 = Math.random();
            Polygon room1poly = new Polygon();
            double room1left = 3.0;
            double room1top = rnd2 < 0.4 ? 4.0 : 5.0;
            double room1right = 5.0;
            double room1bottom = 7.0;
            MakeHouse.makeHouseBedroom(shapes, features, "Rock Dark", topfloor, room1poly, room1left, room1top, room1right, room1bottom, true, ml, shapelayer);
            double rnd3 = Math.random();
            Polygon room2poly = new Polygon();
            double room2left = 5.0;
            double room2top = rnd3 < 0.4 ? 4.0 : 5.0;
            double room2right = 7.0;
            double room2bottom = 7.0;
            MakeHouse.makeHouseBedroom(shapes, features, "Rock Dark", topfloor, room2poly, room2left, room2top, room2right, room2bottom, true, ml, shapelayer);
            double rnd4 = Math.random();
            Polygon kitchenpoly = new Polygon();
            double kitchenleft = 3.0;
            double kitchentop = 7.0;
            double kitchenright = 7.0;
            double kitchenbottom = rnd4 < 0.4 ? 10.0 : 9.0;
            MakeHouse.makeHouseLargeFrontRoom(shapes, kitchenpoly, features, kitchenleft, kitchentop, kitchenright, kitchenbottom, "Rock Dark", kitchenfloor, ml, shapelayer);
            if ((double)t.length < kitchenright + 2.0 || (double)t[0].length < kitchenbottom + 4.0) {
                Terrain[][] t2 = new Terrain[Math.max((int)(kitchenright + 2.0), t.length)][Math.max((int)(kitchenbottom + 2.0), t[0].length)];
                for (int i = 0; i < t2.length; ++i) {
                    for (int j = 0; j < t2[i].length; ++j) {
                        t2[i][j] = new Terrain("Blank", false);
                    }
                }
                t = t2;
            }
        } else if (rnd < 0.85) {
            Polygon roompoly = new Polygon();
            double roomleft = 3.0;
            double roomtop = 5.0;
            double roomright = 6.0;
            double roombottom = 8.0;
            MakeHouse.makeHouseMainRoom(shapes, features, "Rock Dark", topfloor, roompoly, roomleft, roomtop, roomright, roombottom, true, false, ml, shapelayer);
            Polygon kitchenpoly = new Polygon();
            double kitchenleft = 6.0;
            double kitchentop = 6.0;
            double kitchenright = 8.0;
            double kitchenbottom = 8.0;
            MakeHouse.makeHouseKitchen(shapes, kitchenpoly, features, kitchenleft, kitchentop, kitchenright, kitchenbottom, "Rock Dark", kitchenfloor, ml, shapelayer);
            Polygon roommasterpoly = new Polygon();
            double roommasterleft = 5.0;
            double roommastertop = 4.0;
            double roommasterright = 8.0;
            double roommasterbottom = 6.0;
            MakeHouse.makeHouseMasterBedroom(shapes, features, "Rock Dark", topfloor, roommasterpoly, roommasterleft, roommastertop, roommasterright, roommasterbottom, ml, shapelayer);
            Polygon room2poly = new Polygon();
            double room2left = 3.0;
            double room2top = 3.0;
            double room2right = 5.0;
            double room2bottom = 5.0;
            MakeHouse.makeHouseBedroom(shapes, features, "Rock Dark", topfloor, room2poly, room2left, room2top, room2right, room2bottom, false, ml, shapelayer);
            Polygon closetpoly = new Polygon();
            BattlematDataGenerator.makeRoom(shapes, closetpoly, 6.0, 3.0, 8.0, 4.0, "Rock Dark", topfloor, shapelayer, "room");
            Feature door = new Feature("Battlemat/Door Wood", false, false, false, false, null, 0.0, null, -1.0, -1.0, false, false, null, "door", false, false, false, false, ml);
            door.setLocation(ViewLevel.BATTLEMAT, new Point2D(2100.0, 1200.0));
            features.add(door);
            Polygon closet2poly = new Polygon();
            BattlematDataGenerator.makeRoom(shapes, closet2poly, 5.0, 3.0, 6.0, 4.0, "Rock Dark", topfloor, shapelayer, "room");
            Feature door2 = new Feature("Battlemat/Door Wood", false, false, false, false, null, 90.0, null, -1.0, -1.0, false, false, null, "door", false, false, false, false, ml);
            door2.setLocation(ViewLevel.BATTLEMAT, new Point2D(1500.0, 1050.0));
            features.add(door2);
            if ((double)t.length < kitchenright + 2.0 || (double)t[0].length < kitchenbottom + 4.0) {
                Terrain[][] t2 = new Terrain[Math.max((int)(kitchenright + 2.0), t.length)][Math.max((int)(kitchenbottom + 2.0), t[0].length)];
                for (int i = 0; i < t2.length; ++i) {
                    for (int j = 0; j < t2[i].length; ++j) {
                        t2[i][j] = new Terrain("Blank", false);
                    }
                }
                t = t2;
            }
        } else {
            double rnd2 = Math.random();
            Polygon kitchenpoly = new Polygon();
            double kitchenleft = 9.0;
            double kitchentop = 6.0;
            double kitchenright = 11.0;
            double kitchenbottom = 8.0;
            MakeHouse.makeHouseKitchen(shapes, kitchenpoly, features, kitchenleft, kitchentop, kitchenright, kitchenbottom, "Rock Dark", kitchenfloor, ml, shapelayer);
            Polygon room1poly = new Polygon();
            double room1left = 7.0;
            double room1top = rnd2 < 0.4 ? 5.0 : 4.0;
            double room1right = 9.0;
            double room1bottom = 7.0;
            MakeHouse.makeHouseBedroom(shapes, features, "Rock Dark", topfloor, room1poly, room1left, room1top, room1right, room1bottom, true, ml, shapelayer);
            Polygon room2poly = new Polygon();
            double room2left = 5.0;
            double room2top = 6.0;
            double room2right = 7.0;
            double room2bottom = 8.0;
            MakeHouse.makeHouseBedroomLeft(shapes, features, "Rock Dark", topfloor, room2poly, room2left, room2top, room2right, room2bottom, ml, shapelayer);
            Polygon roompoly = new Polygon();
            double roomleft = 7.0;
            double roomtop = 7.0;
            double roomright = 9.0;
            double roombottom = 10.0;
            MakeHouse.makeHouseMainRoom(shapes, features, "Rock Dark", topfloor, roompoly, roomleft, roomtop, roomright, roombottom, true, true, ml, shapelayer);
            if ((double)t.length < kitchenright + 2.0 || (double)t[0].length < roombottom + 2.0) {
                Terrain[][] t2 = new Terrain[Math.max((int)(kitchenright + 2.0), t.length)][Math.max((int)(roombottom + 2.0), t[0].length)];
                for (int i = 0; i < t2.length; ++i) {
                    for (int j = 0; j < t2[i].length; ++j) {
                        t2[i][j] = new Terrain("Blank", false);
                    }
                }
                t = t2;
            }
        }
        MapShape ms = BattlematDataGenerator.makeRoomCreatePolygon(0.0, 0.0, t.length, t[0].length, "Rock Dark", 0.0, "Forest Floor", shapelayer, "ground");
        shapes.add(0, ms);
        return t;
    }
}

