/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.generator.battlemat;

import com.inkwellideas.ographer.data.MapLayer;
import com.inkwellideas.ographer.data.ViewLevel;
import com.inkwellideas.ographer.generator.battlemat.BattlematDataGenerator;
import com.inkwellideas.ographer.generator.battlemat.MakeHouse;
import com.inkwellideas.ographer.map.MapShape;
import com.inkwellideas.ographer.map.Terrain;
import com.inkwellideas.ographer.model.Feature;
import com.inkwellideas.ographer.model.TextureType;
import java.util.List;
import javafx.geometry.Point2D;
import javafx.scene.paint.Color;
import javafx.scene.paint.ImagePattern;
import javafx.scene.shape.Polygon;

public class MakeStore {
    public static Terrain[][] generateStore(Terrain[][] t, List<MapShape> shapes, List<Feature> features, MapLayer ml, MapLayer shapelayer) {
        double i;
        Feature box1;
        ImagePattern rockdktexture = new ImagePattern(TextureType.ALL_TEXTURES.get("Rock Dark").getIcon(), 0.0, 0.0, 50.0, 25.0, false);
        String mainfloor = "Wood";
        double mf = Math.random();
        if (mf < 0.3) {
            mainfloor = "Wood Dark";
        } else if (mf < 0.7) {
            mainfloor = "Wood Light";
        }
        String storagefloor = "Cobblestone Light";
        double kf = Math.random();
        if (kf < 0.33) {
            storagefloor = "Cobblestone Dark";
        } else if (kf < 0.66) {
            storagefloor = "Cobblestone";
        }
        String topfloor = "Wood Light";
        double tf = Math.random();
        if (tf < 0.33) {
            topfloor = "Wood";
        } else if (tf < 0.66) {
            topfloor = "Wood Dark";
        }
        Polygon mainpoly = new Polygon();
        double mainleft = 3.0;
        double maintop = 5.0;
        double mainright = (int)(Math.random() * 2.0) + 7;
        double mainbottom = (int)(Math.random() * 3.0) + 9;
        MakeStore.makeStoreMainRoom(shapes, features, "Rock Dark", mainfloor, mainpoly, mainleft, maintop, mainright, mainbottom, ml, shapelayer);
        boolean hasupperlevel = Math.random() < 0.5;
        Polygon storagepoly = new Polygon();
        double storageleft = 3.0;
        double storagetop = 5 - ((int)(Math.random() * 2.0) + 2);
        double storagebottom = 5.0;
        BattlematDataGenerator.makeRoom(shapes, storagepoly, storageleft, storagetop, mainright, storagebottom, "Rock Dark", storagefloor, shapelayer, "room");
        Feature backdoor = new Feature("Battlemat/Door Wood", false, false, false, false, null, 0.0, null, -1.0, -1.0, false, false, null, "door", false, false, false, false, ml);
        backdoor.setLocation(ViewLevel.BATTLEMAT, new Point2D((storageleft + 0.5) * 300.0, storagetop * 300.0));
        features.add(backdoor);
        Feature srdoor = new Feature("Battlemat/Door Wood", false, false, false, false, null, 0.0, null, -1.0, -1.0, false, false, null, "door", false, false, false, false, ml);
        srdoor.setLocation(ViewLevel.BATTLEMAT, new Point2D((storageleft + 0.5) * 300.0, storagebottom * 300.0));
        features.add(srdoor);
        if (hasupperlevel) {
            Polygon stairwallpoly = new Polygon();
            BattlematDataGenerator.makeRoom(shapes, stairwallpoly, mainright - 3.0, storagetop + 1.0, mainright, storagetop + 1.0, "Rock Dark", storagefloor, shapelayer, "room");
            Feature stairdoor = new Feature("Battlemat/Door Wood", false, false, false, false, null, 0.0, null, -1.0, -1.0, false, false, null, "door", false, false, false, false, ml);
            stairdoor.setLocation(ViewLevel.BATTLEMAT, new Point2D((mainright - 0.5) * 300.0, (storagetop + 1.0) * 300.0));
            features.add(stairdoor);
            Feature box0 = new Feature("Battlemat/Box Wood", false, false, false, false, null, 0.0, null, 50.0, 50.0, false, false, null, "table", false, false, false, false, ml);
            box0.setLocation(ViewLevel.BATTLEMAT, new Point2D((mainright - 1.1) * 300.0, (storagetop + 0.6) * 300.0));
            features.add(box0);
            box1 = new Feature("Battlemat/Box Wood", false, false, false, false, null, 0.0, null, 50.0, 50.0, false, false, null, "table", false, false, false, false, ml);
            box1.setLocation(ViewLevel.BATTLEMAT, new Point2D((mainright - 0.7) * 300.0, (storagetop + 0.2) * 300.0));
            features.add(box1);
            Feature box2 = new Feature("Battlemat/Box Wood", false, false, false, false, null, 0.0, null, 50.0, 50.0, false, false, null, "table", false, false, false, false, ml);
            box2.setLocation(ViewLevel.BATTLEMAT, new Point2D((mainright - 0.25) * 300.0, (storagetop + 0.3) * 300.0));
            features.add(box2);
            Feature stair1 = new Feature("Battlemat/Stairs Wood", false, false, false, false, null, 90.0, null, 90.0, 200.0, false, false, null, "stairs", false, false, false, false, ml);
            stair1.setLocation(ViewLevel.BATTLEMAT, new Point2D((mainright - 2.0) * 300.0, (storagetop + 0.5) * 300.0));
            features.add(stair1);
            double bedroom1left = mainright + 3.0;
            double bedroom1right = mainright + 3.0 + (mainright - mainleft) / 2.0;
            double bedroomtop = mainbottom - (mainbottom - storagetop - 1.0) / 2.0;
            MakeStore.makeStoreUpstairsBedroom(shapes, features, "Rock Dark", topfloor, new Polygon(), bedroom1left, bedroomtop, bedroom1right, mainbottom, true, false, ml, shapelayer);
            double bedroom2right = mainright + 3.0 + (mainright - mainleft);
            MakeStore.makeStoreUpstairsBedroom(shapes, features, "Rock Dark", topfloor, new Polygon(), bedroom1right, bedroomtop, bedroom2right, mainbottom, false, true, ml, shapelayer);
            MakeStore.makeStoreUpstairsMainroom(shapes, features, "Rock Dark", topfloor, new Polygon(), bedroom1left, storagetop, bedroom2right, bedroomtop, ml, shapelayer);
            if ((double)t.length < bedroom2right + 2.0 || (double)t[0].length < mainbottom + 2.0) {
                Terrain[][] t2 = new Terrain[Math.max((int)(bedroom2right + 2.0), t.length)][Math.max((int)(mainbottom + 2.0), t[0].length)];
                for (int i2 = 0; i2 < t2.length; ++i2) {
                    for (int j = 0; j < t2[i2].length; ++j) {
                        t2[i2][j] = new Terrain("Blank", false);
                    }
                }
                t = t2;
            }
            MapShape sky = BattlematDataGenerator.makeRoom(bedroom1left - 1.0, 0.0, bedroom2right + 1.0, t[0].length, "Rock Dark", 0.0, Color.LIGHTBLUE, shapelayer);
            shapes.add(1, sky);
        } else if ((double)t.length < mainright + 2.0 || (double)t[0].length < mainbottom + 2.0) {
            Terrain[][] t2 = new Terrain[Math.max((int)(mainright + 2.0), t.length)][Math.max((int)(mainbottom + 2.0), t[0].length)];
            for (int i3 = 0; i3 < t2.length; ++i3) {
                for (int j = 0; j < t2[i3].length; ++j) {
                    t2[i3][j] = new Terrain("Blank", false);
                }
            }
            t = t2;
        }
        MapShape forestFloor = BattlematDataGenerator.makeRoom(0.0, 0.0, t.length, t[0].length, "Rock Dark", 0.0, "Forest Floor", shapelayer);
        shapes.add(0, forestFloor);
        for (i = storageleft + 1.1; i < mainright - 0.2; i += 0.45) {
            box1 = new Feature("Battlemat/Box Wood", false, false, false, false, null, 0.0, null, 50.0, 50.0, false, false, null, "table", false, false, false, false, ml);
            box1.setLocation(ViewLevel.BATTLEMAT, new Point2D(i * 300.0, (storagebottom - 0.25) * 300.0));
            features.add(box1);
        }
        for (i = storageleft + 1.32; i < mainright - 0.45; i += 0.45) {
            box1 = new Feature("Battlemat/Box Wood", false, false, false, false, null, 0.0, null, 50.0, 50.0, false, false, null, "table", false, false, false, false, ml);
            box1.setLocation(ViewLevel.BATTLEMAT, new Point2D(i * 300.0, (storagebottom - 0.25) * 300.0));
            features.add(box1);
        }
        if (storagebottom - storagetop > 2.0) {
            Feature box12;
            double i4;
            double y = storagetop + 0.25;
            if (hasupperlevel) {
                y = storagetop + 1.25;
            }
            for (i4 = storageleft + 2.1; i4 < mainright - 1.2; i4 += 0.45) {
                box12 = new Feature("Battlemat/Box Wood", false, false, false, false, null, 0.0, null, 50.0, 50.0, false, false, null, "table", false, false, false, false, ml);
                box12.setLocation(ViewLevel.BATTLEMAT, new Point2D(i4 * 300.0, y * 300.0));
                features.add(box12);
            }
            for (i4 = storageleft + 2.32; i4 < mainright - 1.45; i4 += 0.45) {
                box12 = new Feature("Battlemat/Box Wood", false, false, false, false, null, 0.0, null, 50.0, 50.0, false, false, null, "table", false, false, false, false, ml);
                box12.setLocation(ViewLevel.BATTLEMAT, new Point2D(i4 * 300.0, y * 300.0));
                features.add(box12);
            }
        }
        return t;
    }

    private static void makeStoreUpstairsMainroom(List<MapShape> shapes, List<Feature> features, String stroketexture, String filltexture, Polygon mainroompoly, double mainroomleft, double mainroomtop, double mainroomright, double mainroombottom, MapLayer ml, MapLayer shapelayer) {
        String furniture = "Pine";
        double ff = Math.random();
        if (ff < 0.33) {
            furniture = "Walnut";
        } else if (ff < 0.66) {
            furniture = "Weathered";
        }
        BattlematDataGenerator.makeRoom(shapes, mainroompoly, mainroomleft, mainroomtop, mainroomright, mainroombottom, stroketexture, filltexture, shapelayer, "room");
        Feature stair1 = new Feature("Battlemat/Stairs Wood", false, false, false, false, null, 90.0, null, 90.0, 200.0, false, false, null, "stairs", false, false, false, false, ml);
        stair1.setLocation(ViewLevel.BATTLEMAT, new Point2D((mainroomright - 2.0) * 300.0, (mainroomtop + 0.5) * 300.0));
        features.add(stair1);
        Polygon stairwallpoly = new Polygon();
        BattlematDataGenerator.makeRoom(shapes, stairwallpoly, mainroomright - 3.0, mainroomtop + 1.0, mainroomright - 1.0, mainroomtop + 1.0, "Rock Dark", filltexture, shapelayer, "room");
        Polygon stairwallpoly2 = new Polygon();
        BattlematDataGenerator.makeRoom(shapes, stairwallpoly2, mainroomright - 3.0, mainroomtop + 1.0, mainroomright - 3.0, mainroomtop, "Rock Dark", filltexture, shapelayer, "room");
        String chair = MakeHouse.getChair(furniture);
        Feature chair1 = new Feature(chair, false, false, false, false, null, 0.0, null, -1.0, -1.0, false, false, null, "chair", false, false, false, false, ml);
        chair1.setLocation(ViewLevel.BATTLEMAT, new Point2D((mainroomleft + 0.8) * 300.0, (mainroomtop + 1.7) * 300.0));
        features.add(chair1);
        Feature chair2 = new Feature(chair, false, false, false, false, null, 0.0, null, -1.0, -1.0, false, false, null, "chair", false, false, false, false, ml);
        chair2.setLocation(ViewLevel.BATTLEMAT, new Point2D((mainroomleft + 1.2) * 300.0, (mainroomtop + 1.7) * 300.0));
        features.add(chair2);
        Feature chair3 = new Feature(chair, false, false, false, false, null, 0.0, null, -1.0, -1.0, false, false, null, "chair", false, false, false, false, ml);
        chair3.setLocation(ViewLevel.BATTLEMAT, new Point2D((mainroomleft + 1.6) * 300.0, (mainroomtop + 1.7) * 300.0));
        features.add(chair3);
        Feature chair4 = new Feature(chair, false, false, false, false, null, 180.0, null, -1.0, -1.0, false, false, null, "chair", false, false, false, false, ml);
        chair4.setLocation(ViewLevel.BATTLEMAT, new Point2D((mainroomleft + 0.8) * 300.0, (mainroomtop + 2.5) * 300.0));
        features.add(chair4);
        Feature chair5 = new Feature(chair, false, false, false, false, null, 180.0, null, -1.0, -1.0, false, false, null, "chair", false, false, false, false, ml);
        chair5.setLocation(ViewLevel.BATTLEMAT, new Point2D((mainroomleft + 1.2) * 300.0, (mainroomtop + 2.5) * 300.0));
        features.add(chair5);
        Feature chair6 = new Feature(chair, false, false, false, false, null, 180.0, null, -1.0, -1.0, false, false, null, "chair", false, false, false, false, ml);
        chair6.setLocation(ViewLevel.BATTLEMAT, new Point2D((mainroomleft + 1.6) * 300.0, (mainroomtop + 2.5) * 300.0));
        features.add(chair6);
        Feature kitchentable1 = new Feature("Battlemat/Table Rectangle " + furniture, false, false, false, false, null, 0.0, null, 125.0, 100.0, false, false, null, "table", false, false, false, false, ml);
        kitchentable1.setLocation(ViewLevel.BATTLEMAT, new Point2D((mainroomleft + 1.2) * 300.0, (mainroomtop + 2.1) * 300.0));
        features.add(kitchentable1);
        Feature kitchentable2 = new Feature("Battlemat/Table Rectangle " + furniture, false, false, false, false, null, 0.0, null, 125.0, 100.0, false, false, null, "table", false, false, false, false, ml);
        kitchentable2.setLocation(ViewLevel.BATTLEMAT, new Point2D((mainroomright - 1.2) * 300.0, (mainroomtop + 2.1) * 300.0));
        features.add(kitchentable2);
        Feature kitchenfire1 = new Feature("Battlemat/Fireplace", false, false, false, false, null, 180.0, null, 90.0, 70.0, false, false, null, "table", false, false, false, false, ml);
        kitchenfire1.setLocation(ViewLevel.BATTLEMAT, new Point2D((mainroomleft + (mainroomright - mainroomleft) / 2.0) * 300.0, (mainroombottom - 0.2) * 300.0));
        features.add(kitchenfire1);
        Feature window1 = new Feature("Battlemat/Window No Light", false, false, false, false, null, 90.0, null, -1.0, -1.0, false, false, null, "Window", false, false, false, false, ml);
        window1.setLocation(ViewLevel.BATTLEMAT, new Point2D(mainroomleft * 300.0, (mainroomtop + 2.0) * 300.0));
        features.add(window1);
        Feature window2 = new Feature("Battlemat/Window No Light", false, false, false, false, null, 90.0, null, -1.0, -1.0, false, false, null, "Window", false, false, false, false, ml);
        window2.setLocation(ViewLevel.BATTLEMAT, new Point2D(mainroomright * 300.0, (mainroomtop + 2.0) * 300.0));
        features.add(window2);
    }

    private static void makeStoreUpstairsBedroom(List<MapShape> shapes, List<Feature> features, String stroketexture, String filltexture, Polygon guestroompoly, double guestroomleft, double guestroomtop, double guestroomright, double guestroombottom, boolean windowleft, boolean windowright, MapLayer ml, MapLayer shapelayer) {
        String furniture = "Pine";
        double ff = Math.random();
        if (ff < 0.33) {
            furniture = "Walnut";
        } else if (ff < 0.66) {
            furniture = "Weathered";
        }
        BattlematDataGenerator.makeRoom(shapes, guestroompoly, guestroomleft, guestroomtop, guestroomright, guestroombottom, stroketexture, filltexture, shapelayer, "room");
        String bed = MakeHouse.getDoubleBed(furniture);
        Feature ownerbed = new Feature(bed, false, false, false, false, null, 180.0, null, -1.0, -1.0, false, false, null, "bed", false, false, false, false, ml);
        if (windowleft) {
            ownerbed.setLocation(ViewLevel.BATTLEMAT, new Point2D((guestroomright - 0.8) * 300.0, (guestroombottom - 0.8) * 300.0));
        } else if (windowright) {
            ownerbed.setLocation(ViewLevel.BATTLEMAT, new Point2D((guestroomleft + 0.8) * 300.0, (guestroombottom - 0.8) * 300.0));
        }
        features.add(ownerbed);
        Feature ownerchair = new Feature(MakeHouse.getChair(furniture), false, false, false, false, null, 90.0, null, -1.0, -1.0, false, false, null, "chair", false, false, false, false, ml);
        if (windowleft) {
            ownerchair.setLocation(ViewLevel.BATTLEMAT, new Point2D((guestroomleft + 0.5) * 300.0, (guestroomtop + 0.7) * 300.0));
        } else if (windowright) {
            ownerchair.setLocation(ViewLevel.BATTLEMAT, new Point2D((guestroomright - 0.5) * 300.0, (guestroomtop + 0.7) * 300.0));
            ownerchair.setRotate(270.0);
        }
        features.add(ownerchair);
        Feature ownerdesk = new Feature(MakeHouse.getDesk(furniture), false, false, false, false, null, 270.0, null, -1.0, -1.0, false, false, null, "desk", false, false, false, false, ml);
        if (windowleft) {
            ownerdesk.setLocation(ViewLevel.BATTLEMAT, new Point2D((guestroomleft + 0.3) * 300.0, (guestroomtop + 0.7) * 300.0));
        } else if (windowright) {
            ownerdesk.setLocation(ViewLevel.BATTLEMAT, new Point2D((guestroomright - 0.3) * 300.0, (guestroomtop + 0.7) * 300.0));
            ownerdesk.setRotate(90.0);
        }
        features.add(ownerdesk);
        Feature ownerdoor = new Feature("Battlemat/Door Wood", false, false, false, false, null, 0.0, null, -1.0, -1.0, false, false, null, "door", false, false, false, false, ml);
        if (windowleft) {
            ownerdoor.setLocation(ViewLevel.BATTLEMAT, new Point2D((guestroomright - 1.0) * 300.0, guestroomtop * 300.0));
        } else if (windowright) {
            ownerdoor.setLocation(ViewLevel.BATTLEMAT, new Point2D((guestroomleft + 1.0) * 300.0, guestroomtop * 300.0));
        }
        features.add(ownerdoor);
        Feature window = new Feature("Battlemat/Window No Light", false, false, false, false, null, 0.0, null, -1.0, -1.0, false, false, null, "Window", false, false, false, false, ml);
        if (windowleft) {
            window.setLocation(ViewLevel.BATTLEMAT, new Point2D((guestroomleft + 0.65) * 300.0, guestroombottom * 300.0));
        } else if (windowright) {
            window.setLocation(ViewLevel.BATTLEMAT, new Point2D((guestroomright - 0.65) * 300.0, guestroombottom * 300.0));
        }
        features.add(window);
    }

    private static void makeStoreMainRoom(List<MapShape> shapes, List<Feature> features, String stroketexture, String filltexture, Polygon roompoly, double roomleft, double roomtop, double roomright, double roombottom, MapLayer ml, MapLayer shapelayer) {
        Feature bookcase1;
        double y;
        String furniture = "Pine";
        double ff = Math.random();
        if (ff < 0.33) {
            furniture = "Walnut";
        } else if (ff < 0.66) {
            furniture = "Weathered";
        }
        BattlematDataGenerator.makeRoom(shapes, roompoly, roomleft, roomtop, roomright, roombottom, stroketexture, filltexture, shapelayer, "room");
        if (Math.random() < 0.7) {
            for (y = roomtop + 1.5; y < roombottom; y += 1.0) {
                bookcase1 = new Feature("Battlemat/Bookcase " + furniture, false, false, false, false, null, 270.0, null, -1.0, -1.0, false, false, null, "table", false, false, false, false, ml);
                bookcase1.setLocation(ViewLevel.BATTLEMAT, new Point2D((roomleft + 0.2) * 300.0, y * 300.0));
                features.add(bookcase1);
            }
        }
        if (Math.random() < 0.7) {
            for (y = roomtop + 1.5; y < roombottom; y += 1.0) {
                bookcase1 = new Feature("Battlemat/Bookcase " + furniture, false, false, false, false, null, 90.0, null, -1.0, -1.0, false, false, null, "table", false, false, false, false, ml);
                bookcase1.setLocation(ViewLevel.BATTLEMAT, new Point2D((roomright - 0.2) * 300.0, y * 300.0));
                features.add(bookcase1);
            }
        }
        for (double d = roombottom - 1.0; d > roomtop + 1.5; d -= 2.0) {
            Feature table1 = new Feature("Battlemat/Table Rectangle Long " + furniture, false, false, false, false, null, 90.0, null, -1.0, -1.0, false, false, null, "table", false, false, false, false, ml);
            table1.setLocation(ViewLevel.BATTLEMAT, new Point2D((roomleft + 1.1) * 300.0, d * 300.0));
            features.add(table1);
            Feature table2 = new Feature("Battlemat/Table Rectangle Long " + furniture, false, false, false, false, null, 90.0, null, -1.0, -1.0, false, false, null, "table", false, false, false, false, ml);
            table2.setLocation(ViewLevel.BATTLEMAT, new Point2D((roomright - 1.1) * 300.0, d * 300.0));
            features.add(table2);
        }
        if (roomright - roomleft == 5.0) {
            Feature tablem = new Feature("Battlemat/Table Rectangle Long " + furniture, false, false, false, false, null, 90.0, null, -1.0, -1.0, false, false, null, "table", false, false, false, false, ml);
            tablem.setLocation(ViewLevel.BATTLEMAT, new Point2D((roomleft + 2.5) * 300.0, (roombottom - 1.75) * 300.0));
            features.add(tablem);
        }
        if (roomright - roomleft > 5.0) {
            Feature tablem = new Feature("Battlemat/Table Rectangle Long " + furniture, false, false, false, false, null, 90.0, null, -1.0, -1.0, false, false, null, "table", false, false, false, false, ml);
            tablem.setLocation(ViewLevel.BATTLEMAT, new Point2D((roomleft + (roomright - roomleft / 2.0 - 0.7)) * 300.0, (roombottom - 1.25) * 300.0));
            features.add(tablem);
            Feature tablem2 = new Feature("Battlemat/Table Rectangle Long " + furniture, false, false, false, false, null, 90.0, null, -1.0, -1.0, false, false, null, "table", false, false, false, false, ml);
            tablem2.setLocation(ViewLevel.BATTLEMAT, new Point2D((roomleft + (roomright - roomleft / 2.0 + 0.7)) * 300.0, (roombottom - 1.25) * 300.0));
            features.add(tablem2);
        }
        if (roombottom - roomtop > 4.0) {
            Feature tablem = new Feature("Battlemat/Table Rectangle Long " + furniture, false, false, false, false, null, 0.0, null, -1.0, -1.0, false, false, null, "table", false, false, false, false, ml);
            tablem.setLocation(ViewLevel.BATTLEMAT, new Point2D((roomleft + (roomright - roomleft) / 2.0) * 300.0, (roomtop + 0.9) * 300.0));
            features.add(tablem);
        }
        Feature ownerdoor = new Feature("Battlemat/Door Wood", false, false, false, false, null, 0.0, null, -1.0, -1.0, false, false, null, "door", false, false, false, false, ml);
        ownerdoor.setLocation(ViewLevel.BATTLEMAT, new Point2D((roomleft + (roomright - roomleft) / 2.0) * 300.0, roombottom * 300.0));
        features.add(ownerdoor);
        Feature windowf1 = new Feature("Battlemat/Window No Light", false, false, false, false, null, 0.0, null, -1.0, -1.0, false, false, null, "Window", false, false, false, false, ml);
        windowf1.setLocation(ViewLevel.BATTLEMAT, new Point2D((roomleft + 1.0) * 300.0, roombottom * 300.0));
        features.add(windowf1);
        Feature windowf2 = new Feature("Battlemat/Window No Light", false, false, false, false, null, 0.0, null, -1.0, -1.0, false, false, null, "Window", false, false, false, false, ml);
        windowf2.setLocation(ViewLevel.BATTLEMAT, new Point2D((roomright - 1.0) * 300.0, roombottom * 300.0));
        features.add(windowf2);
        Feature windowl = new Feature("Battlemat/Window No Light", false, false, false, false, null, 90.0, null, -1.0, -1.0, false, false, null, "Window", false, false, false, false, ml);
        windowl.setLocation(ViewLevel.BATTLEMAT, new Point2D(roomleft * 300.0, (roomtop + 0.5) * 300.0));
        features.add(windowl);
        Feature windowr = new Feature("Battlemat/Window No Light", false, false, false, false, null, 90.0, null, -1.0, -1.0, false, false, null, "Window", false, false, false, false, ml);
        windowr.setLocation(ViewLevel.BATTLEMAT, new Point2D(roomright * 300.0, (roomtop + 0.5) * 300.0));
        features.add(windowr);
    }
}

