/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.map;

import com.inkwellideas.ographer.data.HexOrientation;
import com.inkwellideas.ographer.data.LabelStyle;
import com.inkwellideas.ographer.data.MapLayer;
import com.inkwellideas.ographer.data.ViewLevel;
import com.inkwellideas.ographer.information.Information;
import com.inkwellideas.ographer.map.MapData;
import com.inkwellideas.ographer.map.MapKeySettings;
import com.inkwellideas.ographer.map.MapLabel;
import com.inkwellideas.ographer.map.MapProjection;
import com.inkwellideas.ographer.map.MapShape;
import com.inkwellideas.ographer.map.Terrain;
import com.inkwellideas.ographer.map.component.GridDataSetup;
import com.inkwellideas.ographer.map.component.NumberingData;
import com.inkwellideas.ographer.map.component.ShowDataSetup;
import com.inkwellideas.ographer.map.component.TraceDataSetup;
import com.inkwellideas.ographer.map.component.ViewLevelDataSetup;
import com.inkwellideas.ographer.map.generator.CitySetup;
import com.inkwellideas.ographer.model.Feature;
import com.inkwellideas.ographer.model.Note;
import com.inkwellideas.ographer.model.ShapeStyle;
import com.inkwellideas.ographer.ui.setup.SetupWorldRegionScreen;
import com.inkwellideas.ographer.undo.Point;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javafx.scene.paint.Color;
import javafx.scene.shape.Polygon;

public class MapDataSetup {
    public ShowDataSetup show = new ShowDataSetup();
    public ViewLevelDataSetup view = new ViewLevelDataSetup();
    public GridDataSetup grid = new GridDataSetup();
    public TraceDataSetup trace = new TraceDataSetup();
    public NumberingData numbering = new NumberingData();
    public CitySetup city = new CitySetup();
    public MapData.Type type = MapData.Type.WORLD;
    public List<MapLayer> mapLayers;
    public Terrain[][] settlementTerrain;
    public Terrain[][] battleMatTerrain;
    public Terrain[][] cosmicTerrain;
    public Terrain[][] worldTerrain;
    public Terrain[][] continentTerrain;
    public Terrain[][] kingdomTerrain;
    public Terrain[][] provinceTerrain;
    public Map<MapLayer, Map<Point, Terrain>> extraTerrainByLayer = new HashMap<MapLayer, Map<Point, Terrain>>();
    public Set<Note> notes = new HashSet<Note>();
    public List<Feature> features = new ArrayList<Feature>();
    public List<MapShape> shapes = new ArrayList<MapShape>();
    public List<MapLabel> labels = new ArrayList<MapLabel>();
    public List<Information> information;
    public double hexWidth;
    public double hexHeight;
    public HexOrientation hexOrientation;
    public MapProjection mapProjection;
    public Integer numNations;
    public String hexNumbering;
    public MapKeySettings mapKeySettings;
    public Map<String, LabelStyle> labelStyles;
    public Map<String, ShapeStyle> shapeStyles;
    public File filename;
    public String release;
    public double schema;
    public String version;
    public Double versionNum;
    public String lastViewLevel;
    public SetupWorldRegionScreen.TerrainStyle terrainStyle;
    public SetupWorldRegionScreen.TerrainStyle iconStyle;
    public long sendTime;
    public boolean generateOneTerrain;
    public String solidTerrain;
    public Color bgColor;
    public String generate;
    public Polygon selectedAreaPoly;
    public String riverType;
    public Integer numRivers;
    public String coastType;
    public double hScrollBar;
    public double vScrollBar;

    public Terrain[][] getTerrainByViewLevel(ViewLevel viewLevel) {
        switch (viewLevel) {
            case WORLD: {
                return this.worldTerrain;
            }
            case CONTINENT: {
                return this.continentTerrain;
            }
            case KINGDOM: {
                return this.kingdomTerrain;
            }
            case PROVINCE: {
                return this.provinceTerrain;
            }
            case SETTLEMENT: {
                return this.settlementTerrain;
            }
            case BATTLEMAT: {
                return this.battleMatTerrain;
            }
            case COSMIC: {
                return this.cosmicTerrain;
            }
        }
        return null;
    }

    public void setTerrainByViewLevel(ViewLevel viewLevel, Terrain[][] t) {
        switch (viewLevel) {
            case WORLD: {
                this.worldTerrain = t;
                break;
            }
            case CONTINENT: {
                this.continentTerrain = t;
                break;
            }
            case KINGDOM: {
                this.kingdomTerrain = t;
                break;
            }
            case PROVINCE: {
                this.provinceTerrain = t;
                break;
            }
            case SETTLEMENT: {
                this.settlementTerrain = t;
                break;
            }
            case BATTLEMAT: {
                this.battleMatTerrain = t;
                break;
            }
            case COSMIC: {
                this.cosmicTerrain = t;
                break;
            }
            default: {
                throw new RuntimeException("Invalid terrain view level.");
            }
        }
    }
}

