/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.task;

import com.inkwellideas.ographer.map.MapData;
import com.inkwellideas.ographer.map.MapDataIO;
import com.inkwellideas.ographer.model.Note;
import com.inkwellideas.ographer.ui.MapUI;
import com.inkwellideas.ographer.ui.Worldographer;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.TreeMap;
import javafx.application.Platform;
import javafx.concurrent.Task;
import javafx.geometry.Point2D;
import javafx.scene.shape.Rectangle;
import javax.imageio.ImageIO;

public class ExportNotesTask
extends Task<MapData> {
    final MapData mapData;
    final MapUI mapUI;
    final File file;
    final BufferedImage image;
    final Worldographer worldographer;
    final Rectangle rectangle;
    final boolean includeWorldInfo;
    final boolean includeNotes;
    final boolean includeFeatureImages;
    final String format;

    public ExportNotesTask(MapUI mapUI, boolean includeWorldInfo, boolean includeNotes, String format, boolean includeFeatureImages, Worldographer worldographer, File file, BufferedImage bi, Rectangle rect) {
        this.mapData = mapUI.getMapData();
        this.mapUI = mapUI;
        this.includeWorldInfo = includeWorldInfo;
        this.includeNotes = includeNotes;
        this.includeFeatureImages = includeFeatureImages;
        this.format = format;
        this.worldographer = worldographer;
        this.file = file;
        this.image = bi;
        double x = rect.getX();
        double y = rect.getY();
        double width = rect.getWidth();
        double height = rect.getHeight();
        if (width < 0.0) {
            width = Math.abs(width);
            x -= width;
        }
        if (height < 0.0) {
            height = Math.abs(height);
            y -= height;
        }
        this.rectangle = new Rectangle(x * 300.0 / mapUI.getMapData().getTileWidth(), y * 300.0 / mapUI.getMapData().getTileHeight(), width * 300.0 / mapUI.getMapData().getTileWidth(), height * 300.0 / mapUI.getMapData().getTileHeight());
    }

    protected MapData call() throws InterruptedException {
        Platform.runLater(() -> this.worldographer.addStatus("Exporting notes..."));
        File imagefolder = this.file.getParentFile();
        try {
            int count = 0;
            int skipped = 0;
            TreeMap<String, Note> exportNotes = new TreeMap<String, Note>();
            if (this.includeNotes) {
                for (Note n : this.mapUI.getMapData().getNotes()) {
                    exportNotes.put(n.getTitle(), n);
                }
            }
            if (this.includeNotes && this.includeFeatureImages) {
                for (Note n : this.mapUI.getMapData().getNotes()) {
                    int finalCount = count;
                    int finalSkipped = skipped;
                    Platform.runLater(() -> this.worldographer.addStatus("Exporting note image " + (finalCount + 1) + "/" + this.mapUI.getMapData().getNotes().size() + " skipped:" + finalSkipped, true));
                    double w = Math.abs(225);
                    double h = Math.abs(300);
                    if (n.getParent() != null) {
                        w = Math.abs(n.getParent().getScaleFallbackType() * 3.0);
                        h = Math.abs(n.getParent().getScaleHtFallbackType() * 3.0);
                    }
                    if (w > h) {
                        h = w;
                    }
                    Point2D pt = null;
                    if (n.getParent() != null && n.getParent().getLocation(this.mapUI.viewLevel) != null) {
                        pt = n.getParent().getLocation(this.mapUI.getViewLevel());
                    } else if (n.getLocation(this.mapUI.viewLevel) != null) {
                        pt = n.getLocation(this.mapUI.viewLevel);
                    }
                    if (pt != null && this.rectangle.contains(pt)) {
                        pt = new Point2D(pt.getX() * this.mapUI.getMapData().getTileWidth() / 300.0 - w / 2.0, pt.getY() * this.mapUI.getMapData().getTileHeight() / 300.0 - h / 2.0);
                        double tmpW = w;
                        double tmpH = h;
                        if (pt.getX() + w > (double)this.image.getWidth()) {
                            tmpW = (double)this.image.getWidth() - pt.getX();
                        }
                        if (pt.getY() + h > (double)this.image.getHeight()) {
                            tmpH = (double)this.image.getHeight() - pt.getY();
                        }
                        Rectangle rect = new Rectangle(Math.max(0.0, pt.getX()), Math.max(0.0, pt.getY()), tmpW, tmpH);
                        File imagefile = new File(String.valueOf(imagefolder) + File.separator + n.getKeyInt() + ".png");
                        BufferedImage cropped = this.image.getSubimage((int)rect.getX(), (int)rect.getY(), (int)rect.getWidth(), (int)rect.getHeight());
                        FileOutputStream fos = new FileOutputStream(imagefile);
                        boolean result = ImageIO.write((RenderedImage)cropped, "png", fos);
                        fos.flush();
                        fos.close();
                    } else {
                        ++skipped;
                    }
                    ++count;
                }
                Platform.runLater(() -> this.worldographer.addStatus("Exporting notes webpage.", false));
            }
            MapDataIO.exportNotes(this.mapUI.getMapData(), exportNotes, this.mapUI.getViewLevel(), this.file, this.includeWorldInfo, this.includeNotes, this.includeFeatureImages, this.format);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Platform.runLater(() -> this.worldographer.addStatus("Exporting notes finished.", false));
        return this.mapData;
    }
}

