/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.ui;

import com.inkwellideas.ographer.data.HexOrientation;
import com.inkwellideas.ographer.data.MapLayer;
import com.inkwellideas.ographer.data.ViewLevel;
import com.inkwellideas.ographer.map.MapData;
import com.inkwellideas.ographer.map.MapLabel;
import com.inkwellideas.ographer.map.MapShape;
import com.inkwellideas.ographer.map.Terrain;
import com.inkwellideas.ographer.model.Feature;
import com.inkwellideas.ographer.ui.Xform;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.application.Application;
import javafx.geometry.Point2D;
import javafx.geometry.Point3D;
import javafx.scene.Camera;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.PerspectiveCamera;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.paint.Color;
import javafx.scene.paint.Material;
import javafx.scene.paint.Paint;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.Cylinder;
import javafx.scene.shape.DrawMode;
import javafx.scene.shape.Mesh;
import javafx.scene.shape.MeshView;
import javafx.scene.shape.Polygon;
import javafx.scene.shape.Sphere;
import javafx.scene.shape.TriangleMesh;
import javafx.stage.Stage;

public class MapScene
extends Application {
    final Group root = new Group();
    final Xform world = new Xform();
    final PerspectiveCamera camera = new PerspectiveCamera(true);
    final Xform cameraXform = new Xform();
    final Xform cameraXform2 = new Xform();
    final Xform cameraXform3 = new Xform();
    private static final double CAMERA_INITIAL_DISTANCE = -1500.0;
    private static final double CAMERA_INITIAL_X_ANGLE = -230.0;
    private static final double CAMERA_INITIAL_Y_ANGLE = 180.0;
    private static final double CAMERA_NEAR_CLIP = 0.1;
    private static final double CAMERA_FAR_CLIP = 10000.0;
    private static final double CONTROL_MULTIPLIER = 0.1;
    private static final double SHIFT_MULTIPLIER = 10.0;
    private static final double MOUSE_SPEED = 1.0;
    private static final double ROTATION_SPEED = 1.0;
    private static final double TRACK_SPEED = 1.0;
    double mousePosX;
    double mousePosY;
    double mouseOldX;
    double mouseOldY;
    double mouseDeltaX;
    double mouseDeltaY;
    TriangleMesh hexMesh;
    final MapData mapData;
    Polygon[][] p;
    final Group knight = null;

    public void start(Stage primaryStage) {
        this.buildCamera();
        this.createMeshes();
        Scene scene = new Scene((Parent)this.root, 1024.0, 768.0, true);
        scene.setFill((Paint)Color.BISQUE);
        this.handleKeyboard(scene, (Node)this.world);
        this.handleMouse(scene, (Node)this.world);
        this.root.getChildren().add((Object)this.world);
        primaryStage.setTitle("Molecule Sample Application");
        primaryStage.setScene(scene);
        primaryStage.show();
        scene.setCamera((Camera)this.camera);
    }

    public MapScene(MapData md, ViewLevel viewLevel) {
        this.mapData = md;
        HashMap<String, List<Feature>> featuresByLayer = new HashMap<String, List<Feature>>();
        for (Feature feature : this.mapData.getFeatures()) {
            if (feature == null) continue;
            if (!featuresByLayer.containsKey(feature.getMapLayer().getName())) {
                featuresByLayer.put(feature.getMapLayer().getName(), new ArrayList());
            }
            ((List)featuresByLayer.get(feature.getMapLayer().getName())).add(feature);
        }
        HashMap<String, List<MapLabel>> labelsByLayer = new HashMap<String, List<MapLabel>>();
        for (MapLabel mapLabel : this.mapData.getMapLabels()) {
            if (!labelsByLayer.containsKey(mapLabel.getMapLayer().getName())) {
                labelsByLayer.put(mapLabel.getMapLayer().getName(), new ArrayList());
            }
            ((List)labelsByLayer.get(mapLabel.getMapLayer().getName())).add(mapLabel);
        }
        HashMap<String, List<MapShape>> hashMap = new HashMap<String, List<MapShape>>();
        for (MapShape ms : this.mapData.getShapes()) {
            if (ms.getMapLayer() == null) continue;
            if (!hashMap.containsKey(ms.getMapLayer().getName())) {
                hashMap.put(ms.getMapLayer().getName(), new ArrayList());
            }
            ((List)hashMap.get(ms.getMapLayer().getName())).add(ms);
        }
        int n2 = this.mapData.getMapLayers().size() - 1;
        n2 = this.drawFeaturesLabelsShapesByLayers(md, viewLevel, this.world, featuresByLayer, labelsByLayer, hashMap, n2, "Terrain Water");
        this.drawTerrain(md, viewLevel, this.world);
        int n4 = this.drawFeaturesLabelsShapesByLayers(md, viewLevel, this.world, featuresByLayer, labelsByLayer, hashMap, n2, "Terrain Land");
        n4 = this.drawFeaturesLabelsShapesByLayers(md, viewLevel, this.world, featuresByLayer, labelsByLayer, hashMap, n4, "All the rest don't match this string...");
    }

    public TriangleMesh createHexMesh(float widthSidetoSide, float height) {
        this.hexMesh = new TriangleMesh();
        this.hexMesh.getTexCoords().addAll(new float[]{0.0f, 0.0f});
        float s1 = widthSidetoSide;
        float w1 = s1 * 1.1547f;
        float h1 = height;
        this.hexMesh.getPoints().addAll(new float[]{0.0f, 0.0f, 0.0f, w1 / 2.0f, 0.0f, 0.0f, w1 / 4.0f, -s1 / 2.0f, 0.0f, -w1 / 4.0f, -s1 / 2.0f, 0.0f, -w1 / 2.0f, 0.0f, 0.0f, -w1 / 4.0f, s1 / 2.0f, 0.0f, w1 / 4.0f, s1 / 2.0f, 0.0f, w1 / 2.0f, 0.0f, h1, w1 / 4.0f, -s1 / 2.0f, h1, -w1 / 4.0f, -s1 / 2.0f, h1, -w1 / 2.0f, 0.0f, h1, -w1 / 4.0f, s1 / 2.0f, h1, w1 / 4.0f, s1 / 2.0f, h1, 0.0f, 0.0f, h1});
        this.hexMesh.getFaces().addAll(new int[]{0, 0, 1, 0, 2, 0, 0, 0, 2, 0, 3, 0, 0, 0, 3, 0, 4, 0, 0, 0, 4, 0, 5, 0, 0, 0, 5, 0, 6, 0, 0, 0, 6, 0, 1, 0, 1, 0, 12, 0, 7, 0, 1, 0, 6, 0, 12, 0, 2, 0, 7, 0, 8, 0, 2, 0, 1, 0, 7, 0, 3, 0, 8, 0, 9, 0, 3, 0, 2, 0, 8, 0, 4, 0, 9, 0, 10, 0, 4, 0, 3, 0, 9, 0, 5, 0, 10, 0, 11, 0, 5, 0, 4, 0, 10, 0, 6, 0, 11, 0, 12, 0, 6, 0, 5, 0, 11, 0, 13, 0, 7, 0, 8, 0, 13, 0, 8, 0, 9, 0, 13, 0, 9, 0, 10, 0, 13, 0, 10, 0, 11, 0, 13, 0, 11, 0, 12, 0, 13, 0, 12, 0, 7, 0});
        return this.hexMesh;
    }

    public void createMeshes() {
        TriangleMesh pyramidMesh = new TriangleMesh();
        pyramidMesh.getTexCoords().addAll(new float[]{0.0f, 0.0f});
        float h = 100.0f;
        float s = 100.0f;
        pyramidMesh.getPoints().addAll(new float[]{0.0f, 0.0f, 0.0f, 0.0f, h, -s / 2.0f, -s / 2.0f, h, 0.0f, s / 2.0f, h, 0.0f, 0.0f, h, s / 2.0f});
        pyramidMesh.getFaces().addAll(new int[]{0, 0, 2, 0, 1, 0, 0, 0, 1, 0, 3, 0, 0, 0, 3, 0, 4, 0, 0, 0, 4, 0, 2, 0, 4, 0, 1, 0, 2, 0, 4, 0, 3, 0, 1, 0});
        MeshView pyramid = new MeshView((Mesh)pyramidMesh);
        pyramid.setDrawMode(DrawMode.FILL);
        pyramid.setMaterial((Material)new PhongMaterial(Color.BLUEVIOLET));
        pyramid.setTranslateX(200.0);
        pyramid.setTranslateY(100.0);
        pyramid.setTranslateZ(200.0);
        this.root.getChildren().add((Object)pyramid);
    }

    private int drawFeaturesLabelsShapesByLayers(MapData md, ViewLevel vl, Group world, Map<String, List<Feature>> featuresByLayer, Map<String, List<MapLabel>> labelsByLayer, Map<String, List<MapShape>> shapesByLayer, int layercount, String lastlayername) {
        while (layercount >= 0) {
            MapLayer currentMapLayer = this.mapData.getMapLayers().get(layercount);
            if (currentMapLayer.isVisible()) {
                this.drawFeatures(md, vl, world, featuresByLayer.get(currentMapLayer.getName()), false, "", "");
            }
            if (--layercount < 0 || !this.mapData.getMapLayers().get(layercount).getName().equals(lastlayername)) continue;
            return layercount;
        }
        return layercount;
    }

    private void drawFeatures(MapData md, ViewLevel viewLevel, Group world, List<Feature> layerfeatures, boolean isShowGMOnly, String showTags, String hideTags) {
        if (layerfeatures == null) {
            return;
        }
        for (Feature f : layerfeatures) {
            Point2D floc;
            if (viewLevel == ViewLevel.WORLD && !f.isWorld() || viewLevel == ViewLevel.CONTINENT && !f.isContinent() || viewLevel == ViewLevel.KINGDOM && !f.isKingdom() || (floc = f.getLocation(viewLevel)) == null) continue;
            double fw = f.getScaleFallbackType();
            double fth = f.getScaleHtFallbackType();
            if (fth <= 0.0) {
                fth = f.getScaleFallbackType();
            }
            double fh = fth;
            if (f.isGmOnly() && !isShowGMOnly) continue;
            if (!f.getTags().equals("")) {
                int yr;
                String featuretag;
                boolean found;
                if (!showTags.equals("")) {
                    String[] showTagArray = showTags.split(";");
                    found = false;
                    block13: for (String s : showTagArray) {
                        s = s.trim().toLowerCase();
                        for (String t : f.getTags().split(";")) {
                            featuretag = t.trim().toLowerCase();
                            if (s.startsWith("year:")) {
                                yr = 0;
                                try {
                                    yr = Integer.parseInt(s.substring(5));
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                                if (!featuretag.startsWith("years:")) continue;
                                String[] yearranges = featuretag.split(":");
                                for (int i = 1; i < yearranges.length; ++i) {
                                    String[] years = yearranges[i].split("/");
                                    int start = 0;
                                    try {
                                        start = Integer.parseInt(years[0]);
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        // empty catch block
                                    }
                                    int end = 0;
                                    try {
                                        end = Integer.parseInt(years[1]);
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        // empty catch block
                                    }
                                    if (yr < start || yr > end) continue;
                                    found = true;
                                    break;
                                }
                                if (!found) continue;
                                continue block13;
                            }
                            if (!featuretag.equals(s)) continue;
                            found = true;
                            continue block13;
                        }
                    }
                    if (!found) continue;
                }
                if (!hideTags.equals("")) {
                    String[] hideTagArray = hideTags.split(";");
                    found = false;
                    block16: for (String h : hideTagArray) {
                        h = h.trim().toLowerCase();
                        for (String t : f.getTags().split(";")) {
                            featuretag = t.trim().toLowerCase();
                            if (h.startsWith("year!:")) {
                                yr = 0;
                                try {
                                    yr = Integer.parseInt(h.substring(6));
                                }
                                catch (NumberFormatException yearranges) {
                                    // empty catch block
                                }
                                boolean yearfound = false;
                                if (!featuretag.startsWith("years:")) continue;
                                String[] yearranges = featuretag.split(":");
                                for (int i = 1; i < yearranges.length; ++i) {
                                    String[] years = yearranges[i].split("/");
                                    int start = 0;
                                    try {
                                        start = Integer.parseInt(years[0]);
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        // empty catch block
                                    }
                                    int end = 0;
                                    try {
                                        end = Integer.parseInt(years[1]);
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        // empty catch block
                                    }
                                    if (yr < start || yr > end) continue;
                                    yearfound = true;
                                    break;
                                }
                                if (yearfound) continue;
                                found = true;
                                continue block16;
                            }
                            if (!featuretag.equals(h)) continue;
                            found = true;
                        }
                    }
                    if (found) continue;
                }
            }
            ImageView iv = new ImageView(f.getType().getIcon());
            double w = fw * md.getTileWidth() / 100.0;
            double h = fh * md.getTileHeight() / 100.0;
            iv.setX(floc.getX() * md.getTileWidth() / 300.0 - w / 2.0);
            iv.setY(floc.getY() * md.getTileHeight() / 300.0 - h / 2.0);
            iv.setPreserveRatio(false);
            iv.setFitWidth(w);
            iv.setFitHeight(h);
            world.getChildren().add((Object)iv);
        }
    }

    private void drawTerrain(MapData md, ViewLevel viewLevel, Group world) {
        this.p = new Polygon[md.getTerrain(viewLevel).length][md.getTerrain(viewLevel)[0].length];
        double wpt75 = this.mapData.getTileWidth() * 0.75;
        double hpt75 = this.mapData.getTileHeight() * 0.75;
        if (this.knight != null) {
            world.getChildren().add((Object)this.knight);
            this.knight.setTranslateX(10.0);
            this.knight.setTranslateY(10.0);
            this.knight.setTranslateZ(-10.0);
            this.knight.setScaleX(10.0);
            this.knight.setScaleY(10.0);
            this.knight.setScaleZ(10.0);
            this.knight.setRotationAxis(new Point3D(1.0, 0.0, 0.0));
            this.knight.setRotate(270.0);
        }
        for (int i = 0; i < md.getTerrain(viewLevel).length; ++i) {
            for (int j = 0; j < md.getTerrain(viewLevel)[i].length; ++j) {
                Point2D pt = this.calculateTerrainPointXY(i, j, 0.0, 0.0, this.mapData.getTileWidth(), this.mapData.getTileHeight());
                MeshView hex = new MeshView((Mesh)this.createHexMesh(40.0f, 1.0f));
                hex.setDrawMode(DrawMode.FILL);
                Color bg = md.getTerrain(viewLevel)[i][j].getBackgroundColor();
                if (bg == null) {
                    bg = md.getTerrain(viewLevel)[i][j].getType().getBgColor();
                }
                hex.setMaterial((Material)new PhongMaterial(bg));
                hex.setTranslateX(pt.getX());
                hex.setTranslateY(pt.getY());
                hex.setTranslateZ(20.0);
                world.getChildren().add((Object)hex);
                int x = i;
                int y = j;
                float h = (float)this.mapData.getTileHeight();
                float s = (float)this.mapData.getTileHeight();
                if (md.getTerrain(viewLevel)[i][j].getTypeName().contains("Mountains")) {
                    TriangleMesh pyramidMesh = new TriangleMesh();
                    pyramidMesh.getTexCoords().addAll(new float[]{0.0f, 0.0f});
                    pyramidMesh.getPoints().addAll(new float[]{0.0f, 0.0f, 0.0f, 0.0f, -s / 4.0f, h / 2.0f, -s / 4.0f, 0.0f, h / 2.0f, s / 4.0f, 0.0f, h / 2.0f, 0.0f, s / 4.0f, h / 2.0f});
                    pyramidMesh.getFaces().addAll(new int[]{0, 0, 1, 0, 2, 0, 0, 0, 3, 0, 1, 0, 0, 0, 4, 0, 3, 0, 0, 0, 2, 0, 4, 0, 4, 0, 2, 0, 1, 0, 4, 0, 1, 0, 3, 0});
                    double[] xs = new double[]{-this.mapData.getTileWidth() / 6.0, 0.0, this.mapData.getTileWidth() / 7.0};
                    double[] ys = new double[]{-this.mapData.getTileHeight() / 5.0, this.mapData.getTileHeight() / 6.0, -this.mapData.getTileHeight() / 4.0};
                    ArrayList<MeshView> mntns = new ArrayList<MeshView>();
                    for (int k = 0; k < xs.length; ++k) {
                        MeshView pyramid = new MeshView((Mesh)pyramidMesh);
                        pyramid.setDrawMode(DrawMode.FILL);
                        if (md.getTerrain(viewLevel)[i][j].getTypeName().contains("Forest")) {
                            pyramid.setMaterial((Material)new PhongMaterial(Color.GREEN));
                        } else {
                            pyramid.setMaterial((Material)new PhongMaterial(Color.SADDLEBROWN));
                        }
                        pyramid.setTranslateX(pt.getX() + this.mapData.getTileWidth() / 2.0 + xs[k]);
                        pyramid.setTranslateY(pt.getY() + this.mapData.getTileHeight() / 2.0 + ys[k]);
                        pyramid.setTranslateZ((double)(-h / 2.0f));
                        mntns.add(pyramid);
                        world.getChildren().add((Object)pyramid);
                    }
                    continue;
                }
                if (md.getTerrain(viewLevel)[i][j].getTypeName().contains("Hills")) {
                    TriangleMesh coneMesh = new TriangleMesh();
                    for (int k = 0; k < 3; ++k) {
                        MeshView cone = new MeshView((Mesh)coneMesh);
                        cone.setDrawMode(DrawMode.FILL);
                        if (md.getTerrain(viewLevel)[i][j].getTypeName().contains("Forest")) {
                            cone.setMaterial((Material)new PhongMaterial(Color.GREEN));
                        } else {
                            cone.setMaterial((Material)new PhongMaterial(Color.TAN));
                        }
                        cone.setTranslateX(pt.getX() + this.mapData.getTileWidth() * (double)(k + 1) / 4.0);
                        if (k == 0) {
                            cone.setTranslateY(pt.getY() + this.mapData.getTileHeight() * 0.63);
                        }
                        if (k == 1) {
                            cone.setTranslateY(pt.getY() + this.mapData.getTileHeight() * 0.3);
                        }
                        if (k == 2) {
                            cone.setTranslateY(pt.getY() + this.mapData.getTileHeight() * 0.66);
                        }
                        cone.setTranslateZ((double)(-h / 5.0f));
                        cone.setRotationAxis(new Point3D(1.0, 0.0, 0.0));
                        cone.setRotate(270.0);
                        world.getChildren().add((Object)cone);
                    }
                    continue;
                }
                if (md.getTerrain(viewLevel)[i][j].getTypeName().contains("Forest")) {
                    double[] xs = new double[]{-this.mapData.getTileWidth() / 4.0, this.mapData.getTileWidth() / 5.0, 0.0, -this.mapData.getTileWidth() / 5.0, this.mapData.getTileWidth() / 4.0};
                    double[] ys = new double[]{this.mapData.getTileHeight() / 5.0, this.mapData.getTileHeight() / 4.0, 0.0, -this.mapData.getTileHeight() / 4.0, -this.mapData.getTileHeight() / 5.0};
                    if (md.getTerrain(viewLevel)[i][j].getTypeName().contains("Heavy")) {
                        double[] xs2 = new double[]{this.mapData.getTileWidth() / 8.0, -this.mapData.getTileWidth() / 5.0, this.mapData.getTileWidth() / 4.0, -this.mapData.getTileWidth() / 6.0, -this.mapData.getTileWidth() / 4.0, 0.0, this.mapData.getTileWidth() / 4.0, -this.mapData.getTileWidth() / 4.0, this.mapData.getTileWidth() / 4.0, this.mapData.getTileWidth() / 6.0, -this.mapData.getTileWidth() / 8.0};
                        double[] ys2 = new double[]{-this.mapData.getTileHeight() / 3.0, -this.mapData.getTileHeight() / 4.0, -this.mapData.getTileHeight() / 5.0, -this.mapData.getTileHeight() / 6.0, -this.mapData.getTileHeight() / 9.0, 0.0, this.mapData.getTileHeight() / 9.0, this.mapData.getTileHeight() / 6.0, this.mapData.getTileHeight() / 6.0, this.mapData.getTileHeight() / 5.0, this.mapData.getTileHeight() / 4.0};
                        xs = xs2;
                        ys = ys2;
                    }
                    for (int k = 0; k < xs.length; ++k) {
                        Cylinder cyl = new Cylinder((double)(h / 30.0f), (double)(h / 10.0f));
                        cyl.setDrawMode(DrawMode.FILL);
                        cyl.setMaterial((Material)new PhongMaterial(Color.SADDLEBROWN));
                        cyl.setTranslateX(pt.getX() + this.mapData.getTileWidth() / 2.0 + xs[k]);
                        cyl.setTranslateY(pt.getY() + this.mapData.getTileHeight() / 2.0 + ys[k]);
                        cyl.setTranslateZ((double)(-h / 10.0f));
                        cyl.setRotationAxis(new Point3D(1.0, 0.0, 0.0));
                        cyl.setRotate(90.0);
                        world.getChildren().add((Object)cyl);
                        Sphere sphere = new Sphere(this.mapData.getTileWidth() / 10.0);
                        sphere.setDrawMode(DrawMode.FILL);
                        sphere.setMaterial((Material)new PhongMaterial(Color.GREEN));
                        sphere.setTranslateX(pt.getX() + this.mapData.getTileWidth() / 2.0 + xs[k]);
                        sphere.setTranslateY(pt.getY() + this.mapData.getTileHeight() / 2.0 + ys[k]);
                        sphere.setTranslateZ((double)(-h / 4.0f));
                        world.getChildren().add((Object)sphere);
                    }
                    continue;
                }
                Image image = md.getTerrain(viewLevel)[i][j].getType().getIcon();
                if (image == null) continue;
                ImageView iv = new ImageView(image);
                double w = this.mapData.getTileWidth() * md.getTerrain(viewLevel)[i][j].getType().getIconSize();
                double ht = this.mapData.getTileHeight() * md.getTerrain(viewLevel)[i][j].getType().getIconSize();
                iv.setX(pt.getX() + (this.mapData.getTileWidth() - w) / 2.0);
                iv.setY(pt.getY() + (this.mapData.getTileHeight() - ht) / 2.0);
                iv.setFitWidth(w);
                iv.setPreserveRatio(true);
                world.getChildren().add((Object)iv);
            }
        }
    }

    public void updateTerrain(int i, int j, Terrain t) {
        this.p[i][j].setFill((Paint)t.getType().getBgColor());
    }

    public Point2D calculateTerrainPointXY(int x, int y, double offseth, double offsetv, double hexWidth, double hexHeight) {
        if (this.mapData.getTileOrientation() == HexOrientation.COLUMNS) {
            return new Point2D((double)x * hexWidth * 3.0 / 4.0 - offseth, (double)y * hexHeight + (x % 2 == 0 ? 0.0 : hexHeight / 2.0) - offsetv);
        }
        if (this.mapData.getTileOrientation() == HexOrientation.ROWS) {
            return new Point2D((double)x * hexWidth + (y % 2 == 0 ? 0.0 : hexWidth / 2.0) - offseth, (double)y * hexHeight * 3.0 / 4.0 - offsetv);
        }
        return new Point2D((double)x * hexWidth - offseth, (double)y * hexHeight - offsetv);
    }

    private void buildCamera() {
        this.root.getChildren().add((Object)this.cameraXform);
        this.cameraXform.getChildren().add((Object)this.cameraXform2);
        this.cameraXform2.getChildren().add((Object)this.cameraXform3);
        this.cameraXform3.getChildren().add((Object)this.camera);
        this.cameraXform3.setRotateZ(180.0);
        this.camera.setNearClip(0.1);
        this.camera.setFarClip(10000.0);
        this.camera.setTranslateX(512.0);
        this.camera.setTranslateY(384.0);
        this.camera.setTranslateZ(-1500.0);
        this.cameraXform.ry.setAngle(180.0);
        this.cameraXform.rx.setAngle(-230.0);
    }

    private void handleMouse(Scene scene, Node root) {
        scene.setOnMousePressed(me -> {
            this.mousePosX = me.getSceneX();
            this.mousePosY = me.getSceneY();
            this.mouseOldX = me.getSceneX();
            this.mouseOldY = me.getSceneY();
        });
        scene.setOnMouseDragged(me -> {
            this.mouseOldX = this.mousePosX;
            this.mouseOldY = this.mousePosY;
            this.mousePosX = me.getSceneX();
            this.mousePosY = me.getSceneY();
            this.mouseDeltaX = this.mousePosX - this.mouseOldX;
            this.mouseDeltaY = this.mousePosY - this.mouseOldY;
            double modifier = 1.0;
            if (me.isControlDown()) {
                modifier = 0.1;
            }
            if (me.isShiftDown()) {
                modifier = 10.0;
            }
            if (me.isPrimaryButtonDown()) {
                this.cameraXform.ry.setAngle(this.cameraXform.ry.getAngle() - this.mouseDeltaX * modifier * 1.0);
                this.cameraXform.rx.setAngle(this.cameraXform.rx.getAngle() + this.mouseDeltaY * modifier * 1.0);
            } else if (me.isSecondaryButtonDown()) {
                double z = this.camera.getTranslateZ();
                double newZ = z + this.mouseDeltaX * 1.0 * modifier;
                this.camera.setTranslateZ(newZ);
            } else if (me.isMiddleButtonDown()) {
                this.cameraXform2.t.setX(this.cameraXform2.t.getX() + this.mouseDeltaX * 1.0 * modifier * 1.0);
                this.cameraXform2.t.setY(this.cameraXform2.t.getY() + this.mouseDeltaY * 1.0 * modifier * 1.0);
            }
        });
    }

    private void handleKeyboard(Scene scene, Node root) {
        scene.setOnKeyPressed(event -> {
            switch (event.getCode()) {
                case Z: {
                    this.cameraXform2.t.setX(0.0);
                    this.cameraXform2.t.setY(0.0);
                    this.cameraXform.ry.setAngle(180.0);
                    this.cameraXform.rx.setAngle(-230.0);
                    break;
                }
                case O: {
                    this.cameraXform2.t.setX(0.0);
                    this.cameraXform2.t.setY(0.0);
                    this.cameraXform.ry.setAngle(180.0);
                    this.cameraXform.rx.setAngle(180.0);
                    break;
                }
                case X: {
                    break;
                }
            }
        });
    }

    public static void main(String[] args) {
        MapScene.launch((String[])args);
    }
}

