/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.ui;

import com.inkwellideas.ographer.map.MapShape;
import com.inkwellideas.ographer.ui.MapUI;
import javafx.geometry.Point2D;
import javafx.scene.shape.Polygon;
import javafx.scene.shape.Shape;

public class PointUtility {
    public static Point2D convertPtToFlat(double sectionwidth, double sectionheight, double x, double y) {
        x -= 150.0;
        if ((y -= 300.0) < sectionheight) {
            double percentdistancefrompoleto60inverse = sectionheight / y;
            for (int k = 4; k >= 0; --k) {
                double threshold = (double)k * sectionwidth;
                double midpoint = threshold + sectionwidth / 2.0;
                if (x > midpoint) {
                    return new Point2D(midpoint + (x - midpoint) * percentdistancefrompoleto60inverse + 150.0, y + 300.0);
                }
                if (!(x > threshold)) continue;
                return new Point2D(midpoint - (midpoint - x) * percentdistancefrompoleto60inverse + 150.0, y + 300.0);
            }
        } else if (y > sectionheight * 2.0) {
            double percentdistancefrompoleto120inverse = sectionheight / (3.0 * sectionheight - y);
            for (int k = 4; k >= 0; --k) {
                double threshold = ((double)k + 0.5) * sectionwidth;
                double midpoint = threshold + sectionwidth / 2.0;
                if (x > midpoint) {
                    return new Point2D(midpoint + (x - midpoint) * percentdistancefrompoleto120inverse + 150.0, y + 300.0);
                }
                if (!(x > threshold)) continue;
                return new Point2D(midpoint - (midpoint - x) * percentdistancefrompoleto120inverse + 150.0, y + 300.0);
            }
        } else {
            double percentdistancefrom60to120 = (y - sectionheight) / sectionheight;
            if (x < sectionwidth / 2.0 && x < sectionwidth / 2.0 * percentdistancefrom60to120) {
                return new Point2D(x + sectionwidth * 5.0 + 150.0, y + 300.0);
            }
        }
        return new Point2D(x + 150.0, y + 300.0);
    }

    public static Point2D convertPtToIcosahedral(double sectionwidth, double sectionheight, double x, double y) {
        x -= 150.0;
        if ((y -= 300.0) < sectionheight) {
            double percentdistancefrompoleto60 = y / sectionheight;
            for (int k = 4; k >= 0; --k) {
                double threshold = (double)k * sectionwidth;
                double midpoint = threshold + sectionwidth / 2.0;
                if (x > midpoint) {
                    return new Point2D(150.0 + midpoint + (x - midpoint) * percentdistancefrompoleto60, y + 300.0);
                }
                if (!(x > threshold)) continue;
                return new Point2D(150.0 + midpoint - (midpoint - x) * percentdistancefrompoleto60, y + 300.0);
            }
        } else if (y > sectionheight * 2.0) {
            double percentdistancefrompoleto120 = (3.0 * sectionheight - y) / sectionheight;
            for (int k = 4; k >= 0; --k) {
                double threshold = ((double)k + 0.5) * sectionwidth;
                double midpoint = threshold + sectionwidth / 2.0;
                if (x > midpoint) {
                    return new Point2D(150.0 + midpoint + (x - midpoint) * percentdistancefrompoleto120, y + 300.0);
                }
                if (!(x > threshold)) continue;
                return new Point2D(150.0 + midpoint - (midpoint - x) * percentdistancefrompoleto120, y + 300.0);
            }
        } else {
            double percentdistancefrom60to120 = (y - sectionheight) / sectionheight;
            if (x < sectionwidth / 2.0 && x < sectionwidth / 2.0 * percentdistancefrom60to120) {
                return new Point2D(150.0 + x + sectionwidth * 5.0, y + 300.0);
            }
        }
        return new Point2D(x + 150.0, y + 300.0);
    }

    public static boolean isPointInAnyCoastlinePolygon(MapUI mapUI, Shape shapetoskip, double x, double y) {
        for (MapShape ms : mapUI.getMapData().getShapes()) {
            if (!ms.getTags().toLowerCase().contains("coastline") || ms.getShape() == shapetoskip || !(ms.getShape() instanceof Polygon) || !ms.getShape().contains(x, y)) continue;
            return true;
        }
        return false;
    }
}

