/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.ui.configure;

import com.inkwellideas.ographer.ui.Worldographer;
import javafx.application.Application;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.OverrunStyle;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.text.TextAlignment;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.kordamp.ikonli.javafx.FontIcon;

public abstract class ConfigureScreen
extends Application {
    final Worldographer worldographer;
    Stage primaryStage;
    String title;
    String configureLabel;
    String configureTitle;
    String configureHeader;
    String configureScreenHelpText;
    protected final BorderPane border = new BorderPane();
    int width;
    int height;

    public ConfigureScreen(Worldographer ms, int width, int height) {
        this.worldographer = ms;
        this.width = width;
        this.height = height;
        this.setValues();
        Worldographer.pingUsage("http://www.worldographer.com/usage/configure_" + ((Object)((Object)this)).getClass().getSimpleName() + ".txt");
    }

    public abstract void setValues();

    public void start(Stage primaryStage) {
        this.primaryStage = primaryStage;
        this.primaryStage.setTitle(this.title);
        this.primaryStage.initOwner((Window)this.worldographer.getPrimaryStage());
        this.border.setTop((Node)this.createTopBar());
        this.border.setBottom((Node)this.createBottomBar());
        this.border.setCenter(this.createGrid());
        this.border.setPadding(new Insets(3.0));
        Scene scene = new Scene((Parent)this.border, (double)this.width, (double)this.height);
        this.primaryStage.setScene(scene);
        this.primaryStage.show();
    }

    protected abstract Node createGrid();

    protected HBox createBottomBar() {
        HBox box = new HBox();
        Label label = new Label(" ");
        HBox.setHgrow((Node)label, (Priority)Priority.ALWAYS);
        label.setMaxWidth(Double.MAX_VALUE);
        box.getChildren().add((Object)label);
        Label label2 = new Label("     ");
        box.getChildren().add((Object)label2);
        Button closeButton = new Button("Close");
        closeButton.setOnAction(event -> {
            this.worldographer.colorPickerWithSelectorList.clear();
            this.primaryStage.close();
        });
        box.getChildren().add((Object)closeButton);
        Button applyCloseButton = new Button("Apply");
        applyCloseButton.setOnAction(event -> {
            this.worldographer.colorPickerWithSelectorList.clear();
            this.applyChanges(true);
        });
        box.getChildren().add((Object)applyCloseButton);
        return box;
    }

    protected abstract void applyChanges(boolean var1);

    private HBox createTopBar() {
        HBox box = new HBox();
        Label label = new Label(this.configureLabel);
        HBox.setHgrow((Node)label, (Priority)Priority.ALWAYS);
        label.setMaxWidth(Double.MAX_VALUE);
        box.getChildren().add((Object)label);
        Button helpButton = new Button("");
        helpButton.setPadding(new Insets(1.0, 1.0, 1.0, 1.0));
        FontIcon helpIcon = new FontIcon();
        helpIcon.setStyle("-fx-icon-code:mdi2i-information;-fx-icon-size:32;");
        helpButton.setGraphic((Node)helpIcon);
        helpButton.setTooltip(new Tooltip("Instructions"));
        helpButton.setStyle("-fx-font-size: 9px");
        helpButton.setTextAlignment(TextAlignment.CENTER);
        helpButton.setTextOverrun(OverrunStyle.ELLIPSIS);
        helpButton.setContentDisplay(ContentDisplay.TOP);
        helpButton.setOnAction(event -> {
            Dialog d = new Dialog();
            d.initOwner((Window)this.primaryStage);
            d.setTitle(this.configureTitle);
            d.setHeaderText(this.configureHeader);
            WebView view = new WebView();
            view.setMinSize(300.0, 300.0);
            view.setPrefSize(550.0, 350.0);
            WebEngine textengine = view.getEngine();
            textengine.loadContent("<style type=\"text/css\">p {font-family: Futura,Trebuchet MS,Arial,sans-serif; font-size:0.875em; padding: 0; margin: 0} h1,h2,h3 {font-family: Futura,Trebuchet MS,Arial,sans-serif; padding: 0; margin: 0}</style>" + this.configureScreenHelpText);
            d.getDialogPane().setContent((Node)view);
            ButtonType yes = new ButtonType("OK");
            d.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{yes});
            d.showAndWait();
        });
        box.getChildren().add((Object)helpButton);
        return box;
    }
}

