/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.ui.dialog;

import com.inkwellideas.ographer.data.ViewLevel;
import com.inkwellideas.ographer.ui.Worldographer;
import com.inkwellideas.ographer.ui.toolbox.ViewLevelBox;
import com.inkwellideas.ographer.ui.widget.StyledDialog;
import java.util.Optional;
import javafx.collections.FXCollections;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.stage.Window;

public class ChildMapNumTilesDialog {
    public int showChildMapNumTilesDialog(Worldographer worldographer, ViewLevel oldValue, ViewLevelBox viewLevelBox) {
        StyledDialog numtilesdialog = new StyledDialog(true, (Window)worldographer.getPrimaryStage(), "Worldographer Child Map Setup");
        numtilesdialog.setHeaderText("Select Number of Tiles");
        Label questionLabel = new Label("How many tiles across should the child map have per tile in the parent map?\nSelect '0' to delete the map level that is a child to the current map level.\n\nWARNING!\n\nThis feature can use up a lot of memory. If your World map level is 100x50 \nand you expand it 6:1, it will make a Continent level of 600x300. Then if you\ndo 6:1 again to the Kingdom level you'll get 3600x1800. And if you do 6:1\na 3rd time for the Province level you'll have 21600x10800 tiles.\n\nWe recommend only having a map level of 10000+ tiles in either dimension \nif your computer has 32GB+ of memory (RAM, not HD space) and only having \na map of 5000+ tiles in either dimension if your computer has 16+ GB.\n\nFinally, if you may be using very large maps, please save your map as a new\nfilename then close & reload it because the load process is memory intensive\nand can take time. Saving to a new file lets you go back to the old file.\n\nThese numbers are rough guidelines. You can try map sizes like these & larger\nbut if preformance is poor or loading maps takes too long, fall back to the\nfile with a smaller size.\n");
        Object[] numbers = new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30};
        ComboBox numtilescombo = new ComboBox(FXCollections.observableArrayList((Object[])numbers));
        numtilescombo.getSelectionModel().select(6);
        numtilescombo.setMinWidth(80.0);
        HBox hbox = new HBox();
        hbox.getChildren().add((Object)questionLabel);
        hbox.getChildren().add((Object)numtilescombo);
        numtilesdialog.getDialogPane().setContent((Node)hbox);
        ButtonType ok1 = new ButtonType("OK");
        ButtonType cancel = new ButtonType("Cancel");
        numtilesdialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ok1, cancel});
        Optional result = numtilesdialog.showAndWait();
        if (result.isPresent() && result.get() == cancel) {
            viewLevelBox.viewLevelCombo.getSelectionModel().select((Object)oldValue);
            return -1;
        }
        return (Integer)numtilescombo.getSelectionModel().getSelectedItem();
    }
}

