/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.ui.dialog;

import com.inkwellideas.ographer.data.MapLayer;
import com.inkwellideas.ographer.data.ViewLevel;
import com.inkwellideas.ographer.io.UserPrefs;
import com.inkwellideas.ographer.map.MapDataSetup;
import com.inkwellideas.ographer.model.Feature;
import com.inkwellideas.ographer.model.FeatureType;
import com.inkwellideas.ographer.model.TextureType;
import com.inkwellideas.ographer.task.GenerateCityTask;
import com.inkwellideas.ographer.ui.MapUI;
import com.inkwellideas.ographer.ui.Worldographer;
import com.inkwellideas.ographer.ui.dialog.StandardDialog;
import com.inkwellideas.ographer.ui.setup.SetupCityScreen;
import com.inkwellideas.ographer.ui.widget.FocusSpinner;
import com.inkwellideas.ographer.ui.widget.StyledDialog;
import java.lang.constant.Constable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.prefs.Preferences;
import javafx.collections.FXCollections;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.OverrunStyle;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Spinner;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.image.ImageView;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.shape.Polygon;
import javafx.stage.Window;

public class CityGeneratorUI {
    private final Worldographer worldographer;

    public CityGeneratorUI(Worldographer worldographer) {
        this.worldographer = worldographer;
    }

    public void handleGenCoastMI() {
        if (UserPrefs.FULL) {
            StyledDialog d2;
            CityGeneratorUI cityGeneratorUI = this;
            if (cityGeneratorUI.worldographer.getMapUI().getMapData() == null) {
                StandardDialog.showNoMapOpenDialog(this.worldographer.getPrimaryStage(), "Generate Settlement Coast");
                return;
            }
            CityGeneratorUI cityGeneratorUI2 = this;
            if (cityGeneratorUI2.worldographer.getMapUI().viewLevel != ViewLevel.SETTLEMENT) {
                d2 = new StyledDialog(true, (Window)this.worldographer.getPrimaryStage(), "Generate Settlement Coast");
                d2.setHeaderText("Generate Settlement Coast is used for City/Village/Settlement maps.");
                d2.setContentText("This feature is the first step of making a city or village or settlement map.");
                ButtonType ok1 = new ButtonType("OK");
                ButtonType cancel = new ButtonType("Cancel");
                d2.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ok1, cancel});
                Optional result = d2.showAndWait();
                if (result.isPresent() && result.get() == cancel) {
                    return;
                }
            }
            d2 = new StyledDialog(true, (Window)this.worldographer.getPrimaryStage(), "Generate Settlement Coast");
            d2.setHeaderText("Select the start and end clock positions of the coastline:");
            GridPane grid = new GridPane();
            grid.setAlignment(Pos.CENTER);
            grid.setHgap(5.0);
            grid.setVgap(5.0);
            grid.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
            grid.setAlignment(Pos.TOP_CENTER);
            Object[] clocks = new String[]{"12:00", "1:00", "2:00", "3:00", "4:00", "5:00", "6:00", "7:00", "8:00", "9:00", "10:00", "11:00"};
            ComboBox coastStartCombo = new ComboBox(FXCollections.observableArrayList((Object[])clocks));
            coastStartCombo.getSelectionModel().select((Object)"12:00");
            ComboBox coastEndCombo = new ComboBox(FXCollections.observableArrayList((Object[])clocks));
            coastEndCombo.getSelectionModel().select((Object)"4:00");
            grid.add((Node)new Label("Coast Begin & End:"), 1, 4);
            grid.add((Node)coastStartCombo, 2, 4);
            grid.add((Node)coastEndCombo, 3, 4);
            d2.getDialogPane().setContent((Node)grid);
            ButtonType ok1 = new ButtonType("OK");
            ButtonType cancel = new ButtonType("Cancel");
            d2.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ok1, cancel});
            Optional result = d2.showAndWait();
            if (result.isPresent() && result.get() == cancel) {
                return;
            }
            MapDataSetup setup = new MapDataSetup();
            String start = (String)coastStartCombo.getValue();
            int startint = Integer.parseInt(start.substring(0, start.indexOf(":")));
            if (startint == 12) {
                startint = 0;
            }
            String end = (String)coastEndCombo.getValue();
            int endint = Integer.parseInt(end.substring(0, end.indexOf(":")));
            setup.city.hasCoast = true;
            setup.city.coastStart = startint;
            setup.city.coastEnd = endint;
            this.launchTask(setup, GenerateCityTask.CITYGEN.COAST);
        } else {
            StandardDialog.showDialog(this.worldographer.getPrimaryStage(), "Pro Feature", "Generate Settlement Coast is only available if using a City/Settlement Pro version license.", "Sorry, some features are reserved for our Pro/paid version. \nIf you find the software useful, considering unlocking these special features and supporting \nthe many hours of work to create Worldographer with a Pro license. \nSee www.worldographer.com for details.\n", null, "");
        }
    }

    public void handleGenRiverMI() {
        StyledDialog d2;
        CityGeneratorUI cityGeneratorUI = this;
        if (cityGeneratorUI.worldographer.getMapUI().getMapData() == null) {
            StandardDialog.showNoMapOpenDialog(this.worldographer.getPrimaryStage(), "Generate Settlement River");
            return;
        }
        CityGeneratorUI cityGeneratorUI2 = this;
        if (cityGeneratorUI2.worldographer.getMapUI().viewLevel != ViewLevel.SETTLEMENT) {
            d2 = new StyledDialog(true, (Window)this.worldographer.getPrimaryStage(), "Generate Settlement River");
            d2.setHeaderText("Generate Settlement River is used for City/Village/Settlement maps.");
            d2.setContentText("This feature is an early step of making a city or village or settlement map.");
            ButtonType ok1 = new ButtonType("OK");
            ButtonType cancel = new ButtonType("Cancel");
            d2.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ok1, cancel});
            Optional result = d2.showAndWait();
            if (result.isPresent() && result.get() == cancel) {
                return;
            }
        }
        d2 = new StyledDialog(true, (Window)this.worldographer.getPrimaryStage(), "Generate Settlement River");
        d2.setHeaderText("Select the start and end clock positions of the coastline:");
        GridPane grid = new GridPane();
        grid.setAlignment(Pos.CENTER);
        grid.setHgap(5.0);
        grid.setVgap(5.0);
        grid.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        grid.setAlignment(Pos.TOP_CENTER);
        Object[] clocks = new String[]{"12:00", "1:00", "2:00", "3:00", "4:00", "5:00", "6:00", "7:00", "8:00", "9:00", "10:00", "11:00"};
        ComboBox riverStartCombo = new ComboBox(FXCollections.observableArrayList((Object[])clocks));
        riverStartCombo.getSelectionModel().select((Object)"12:00");
        ComboBox riverEndCombo = new ComboBox(FXCollections.observableArrayList((Object[])clocks));
        riverEndCombo.getSelectionModel().select((Object)"4:00");
        grid.add((Node)new Label("River Begin & End:"), 1, 4);
        grid.add((Node)riverStartCombo, 2, 4);
        grid.add((Node)riverEndCombo, 3, 4);
        d2.getDialogPane().setContent((Node)grid);
        ButtonType ok1 = new ButtonType("OK");
        ButtonType cancel = new ButtonType("Cancel");
        d2.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ok1, cancel});
        Optional result = d2.showAndWait();
        if (result.isPresent() && result.get() == cancel) {
            return;
        }
        MapDataSetup setup = new MapDataSetup();
        String start = (String)riverStartCombo.getValue();
        int startint = Integer.parseInt(start.substring(0, start.indexOf(":")));
        if (startint == 12) {
            startint = 0;
        }
        String end = (String)riverEndCombo.getValue();
        int endint = Integer.parseInt(end.substring(0, end.indexOf(":")));
        setup.city.hasRiver = true;
        setup.city.riverStart = startint;
        setup.city.riverEnd = endint;
        this.launchTask(setup, GenerateCityTask.CITYGEN.RIVER);
    }

    public void handleGenMainRoadsMI() {
        StyledDialog d2;
        CityGeneratorUI cityGeneratorUI = this;
        if (cityGeneratorUI.worldographer.getMapUI().getMapData() == null) {
            StandardDialog.showNoMapOpenDialog(this.worldographer.getPrimaryStage(), "Generate Main Roads");
            return;
        }
        CityGeneratorUI cityGeneratorUI2 = this;
        if (cityGeneratorUI2.worldographer.getMapUI().viewLevel != ViewLevel.SETTLEMENT) {
            d2 = new StyledDialog(true, (Window)this.worldographer.getPrimaryStage(), "Generate Main Roads");
            d2.setHeaderText("Generate Main Roads is used for City/Village/Settlement maps.");
            d2.setContentText("This feature an early step of making a city or village or settlement map.");
            ButtonType ok1 = new ButtonType("OK");
            ButtonType cancel = new ButtonType("Cancel");
            d2.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ok1, cancel});
            Optional result = d2.showAndWait();
            if (result.isPresent() && result.get() == cancel) {
                return;
            }
        }
        d2 = new StyledDialog(true, (Window)this.worldographer.getPrimaryStage(), "Generate Main Roads");
        d2.setHeaderText("Select the start and end clock positions of the two Main Roads:");
        GridPane grid = new GridPane();
        grid.setAlignment(Pos.CENTER);
        grid.setHgap(5.0);
        grid.setVgap(5.0);
        grid.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        grid.setAlignment(Pos.TOP_CENTER);
        Object[] clocks = new String[]{"12:00", "1:00", "2:00", "3:00", "4:00", "5:00", "6:00", "7:00", "8:00", "9:00", "10:00", "11:00"};
        ComboBox mainRoad1StartCombo = new ComboBox(FXCollections.observableArrayList((Object[])clocks));
        ComboBox mainRoad1EndCombo = new ComboBox(FXCollections.observableArrayList((Object[])clocks));
        ComboBox mainRoad2StartCombo = new ComboBox(FXCollections.observableArrayList((Object[])clocks));
        ComboBox mainRoad2EndCombo = new ComboBox(FXCollections.observableArrayList((Object[])clocks));
        FocusSpinner windinessSpinner = new FocusSpinner(0.0, 1.0, 0.1);
        CheckBox makeMainRoadsPerpendicular = new CheckBox("Road 2 Perpendicular");
        int mainroad1start = (int)(Math.random() * 6.0);
        int mainroad1end = (mainroad1start + 4 + (int)(Math.random() * 4.0)) % 12;
        int mainroad2start = mainroad1start + 2 + (int)Math.random() * 3;
        int mainroad2end = (mainroad2start + 4 + (int)(Math.random() * 4.0)) % 12;
        grid.add((Node)new Label("Main Road 1:"), 0, 6);
        mainRoad1StartCombo.getSelectionModel().select(mainroad1start);
        mainRoad1EndCombo.getSelectionModel().select(mainroad1end);
        HBox mainroad1box = new HBox();
        mainroad1box.getChildren().add((Object)mainRoad1StartCombo);
        mainroad1box.getChildren().add((Object)mainRoad1EndCombo);
        grid.add((Node)mainroad1box, 1, 6);
        HBox windinessbox = new HBox();
        windinessbox.getChildren().add((Object)new Label("Windy-ness:"));
        windinessbox.getChildren().add(windinessSpinner);
        grid.add((Node)windinessbox, 2, 6, 2, 1);
        grid.add((Node)new Label("Main Road 2:"), 0, 7);
        mainRoad2StartCombo.getSelectionModel().select(mainroad2start);
        mainRoad2EndCombo.getSelectionModel().select(mainroad2end);
        HBox mainroad2box = new HBox();
        mainroad2box.getChildren().add((Object)mainRoad2StartCombo);
        mainroad2box.getChildren().add((Object)mainRoad2EndCombo);
        grid.add((Node)mainroad2box, 1, 7);
        grid.add((Node)makeMainRoadsPerpendicular, 2, 7, 2, 1);
        ToggleGroup rgroup = new ToggleGroup();
        RadioButton roadTextureRB = new RadioButton("Road Texture:");
        RadioButton roadColorRB = new RadioButton("Color:");
        roadTextureRB.setToggleGroup(rgroup);
        roadColorRB.setToggleGroup(rgroup);
        Preferences prefs = Preferences.userRoot().node("com/inkwellideas/worldographer2025");
        if (prefs.get("roadtype", "texture").equals("texture")) {
            roadTextureRB.setSelected(true);
        } else {
            roadColorRB.setSelected(true);
        }
        grid.add((Node)roadTextureRB, 0, 8);
        ComboBox roadTextureCombo = new ComboBox(this.worldographer.shapesToolbox.texturesList);
        String rtt = prefs.get("roadtexture", "Cobblestone Light");
        roadTextureCombo.getSelectionModel().select((Object)TextureType.ALL_TEXTURES.get(rtt));
        grid.add((Node)roadTextureCombo, 1, 8);
        grid.add((Node)roadColorRB, 2, 8);
        String rcolorstr = prefs.get("roadcolor", null);
        Color rcolor = Color.LIGHTGRAY;
        if (rcolorstr != null) {
            String[] colorstrs = rcolorstr.split(",");
            Color.color((double)Double.valueOf(colorstrs[0]), (double)Double.valueOf(colorstrs[1]), (double)Double.valueOf(colorstrs[2]));
        }
        ColorPicker roadColorPicker = new ColorPicker(rcolor);
        grid.add((Node)roadColorPicker, 3, 8);
        d2.getDialogPane().setContent((Node)grid);
        ButtonType ok1 = new ButtonType("OK");
        ButtonType cancel = new ButtonType("Cancel");
        d2.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ok1, cancel});
        Optional result = d2.showAndWait();
        if (result.isPresent() && result.get() == cancel) {
            return;
        }
        MapDataSetup setup = new MapDataSetup();
        setup.city.mainRoad1Start = (String)mainRoad1StartCombo.getValue();
        setup.city.mainRoad2Start = (String)mainRoad2StartCombo.getValue();
        setup.city.mainRoad1End = (String)mainRoad1EndCombo.getValue();
        setup.city.mainRoad2End = (String)mainRoad2EndCombo.getValue();
        setup.city.mainRoadsPerpendicular = makeMainRoadsPerpendicular.isSelected();
        setup.city.windiness = (Double)windinessSpinner.getValue();
        setup.city.roadtype = roadTextureRB.isSelected() ? "texture" : "color";
        setup.city.roadtexture = (TextureType)roadTextureCombo.getValue();
        setup.city.roadcolor = (Color)roadColorPicker.getValue();
        this.launchTask(setup, GenerateCityTask.CITYGEN.MAINROADS);
    }

    public void handleGenWallMI() {
        StyledDialog d2;
        CityGeneratorUI cityGeneratorUI = this;
        if (cityGeneratorUI.worldographer.getMapUI().getMapData() == null) {
            StandardDialog.showNoMapOpenDialog(this.worldographer.getPrimaryStage(), "Generate Wall");
            return;
        }
        CityGeneratorUI cityGeneratorUI2 = this;
        if (cityGeneratorUI2.worldographer.getMapUI().viewLevel != ViewLevel.SETTLEMENT) {
            d2 = new StyledDialog(true, (Window)this.worldographer.getPrimaryStage(), "Generate Wall");
            d2.setHeaderText("Generate Wall is used for City/Village/Settlement maps.");
            d2.setContentText("This feature an early optional step of making a city or village or settlement map.");
            ButtonType ok1 = new ButtonType("OK");
            ButtonType cancel = new ButtonType("Cancel");
            d2.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ok1, cancel});
            Optional result = d2.showAndWait();
            if (result.isPresent() && result.get() == cancel) {
                return;
            }
        }
        d2 = new StyledDialog(true, (Window)this.worldographer.getPrimaryStage(), "Generate Wall");
        d2.setHeaderText("Select the number of towers and radius of the wall:");
        GridPane grid = new GridPane();
        grid.setAlignment(Pos.CENTER);
        grid.setHgap(5.0);
        grid.setVgap(5.0);
        grid.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        grid.setAlignment(Pos.TOP_CENTER);
        Label numTowers = new Label("#Towers:");
        FocusSpinner wallTowerSpinner = new FocusSpinner(1, 100, 8);
        FocusSpinner wallRadiusSpinner = new FocusSpinner(1, 1000, 15);
        grid.add((Node)numTowers, 0, 7);
        grid.add(wallTowerSpinner, 1, 7);
        grid.add((Node)new Label("Radius (#tiles):"), 0, 8);
        grid.add(wallRadiusSpinner, 1, 8);
        d2.getDialogPane().setContent((Node)grid);
        ButtonType ok1 = new ButtonType("OK");
        ButtonType cancel = new ButtonType("Cancel");
        d2.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ok1, cancel});
        Optional result = d2.showAndWait();
        if (result.isPresent() && result.get() == cancel) {
            return;
        }
        MapDataSetup setup = new MapDataSetup();
        setup.city.hasWall = true;
        setup.city.wallTowers = (Integer)wallTowerSpinner.getValue();
        setup.city.wallRadius = (Integer)wallRadiusSpinner.getValue();
        this.launchTask(setup, GenerateCityTask.CITYGEN.WALL);
    }

    public void handleGenStreetsMI() {
        StyledDialog d2;
        CityGeneratorUI cityGeneratorUI = this;
        if (cityGeneratorUI.worldographer.getMapUI().getMapData() == null) {
            StandardDialog.showNoMapOpenDialog(this.worldographer.getPrimaryStage(), "Generate Streets");
            return;
        }
        CityGeneratorUI cityGeneratorUI2 = this;
        if (cityGeneratorUI2.worldographer.getMapUI().viewLevel != ViewLevel.SETTLEMENT) {
            d2 = new StyledDialog(true, (Window)this.worldographer.getPrimaryStage(), "Generate Streets");
            d2.setHeaderText("Generate Streets is used for City/Village/Settlement maps.");
            d2.setContentText("This feature a key step of making a city or village or settlement map.");
            ButtonType ok1 = new ButtonType("OK");
            ButtonType cancel = new ButtonType("Cancel");
            d2.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ok1, cancel});
            Optional result = d2.showAndWait();
            if (result.isPresent() && result.get() == cancel) {
                return;
            }
        }
        d2 = new StyledDialog(true, (Window)this.worldographer.getPrimaryStage(), "Generate Streets");
        d2.setHeaderText("Select the settings for generating streets:");
        GridPane grid = new GridPane();
        grid.setAlignment(Pos.CENTER);
        grid.setHgap(5.0);
        grid.setVgap(5.0);
        grid.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        grid.setAlignment(Pos.TOP_CENTER);
        grid.add((Node)new Label("Street Layout:"), 0, 1, 2, 1);
        ComboBox streetLayoutCombo = new ComboBox(FXCollections.observableArrayList((Object[])SetupCityScreen.LAYOUTS.values()));
        streetLayoutCombo.getSelectionModel().select((Object)SetupCityScreen.LAYOUTS.Random);
        grid.add((Node)streetLayoutCombo, 2, 1, 2, 1);
        FocusSpinner numStreetsSpinner = new FocusSpinner(1, 10000, 150);
        grid.add((Node)new Label("Number of Streets:"), 0, 3, 2, 1);
        grid.add(numStreetsSpinner, 2, 3, 2, 1);
        grid.add((Node)new Label("Skip %:"), 0, 4, 2, 1);
        FocusSpinner skipChanceSpinner = new FocusSpinner(1, 100, 15);
        grid.add(skipChanceSpinner, 2, 4, 2, 1);
        Label distanceLabel = new Label("Distance Between Streets:");
        distanceLabel.setMinWidth(65.0);
        grid.add((Node)distanceLabel, 0, 5, 2, 1);
        FocusSpinner streetDistanceSpinner = new FocusSpinner(1.0, 100.0, 4.0);
        streetDistanceSpinner.setMaxWidth(70.0);
        streetDistanceSpinner.setMinWidth(70.0);
        grid.add(streetDistanceSpinner, 2, 5, 2, 1);
        ToggleGroup rgroup = new ToggleGroup();
        RadioButton roadTextureRB = new RadioButton("Road Texture:");
        RadioButton roadColorRB = new RadioButton("Color:");
        roadTextureRB.setToggleGroup(rgroup);
        roadColorRB.setToggleGroup(rgroup);
        Preferences prefs = Preferences.userRoot().node("com/inkwellideas/worldographer2025");
        if (prefs.get("roadtype", "texture").equals("texture")) {
            roadTextureRB.setSelected(true);
        } else {
            roadColorRB.setSelected(true);
        }
        grid.add((Node)roadTextureRB, 0, 8);
        ComboBox roadTextureCombo = new ComboBox(this.worldographer.shapesToolbox.texturesList);
        String rtt = prefs.get("roadtexture", "Cobblestone Light");
        roadTextureCombo.getSelectionModel().select((Object)TextureType.ALL_TEXTURES.get(rtt));
        grid.add((Node)roadTextureCombo, 1, 8);
        grid.add((Node)roadColorRB, 2, 8);
        String rcolorstr = prefs.get("roadcolor", null);
        Color rcolor = Color.LIGHTGRAY;
        if (rcolorstr != null) {
            String[] colorstrs = rcolorstr.split(",");
            Color.color((double)Double.valueOf(colorstrs[0]), (double)Double.valueOf(colorstrs[1]), (double)Double.valueOf(colorstrs[2]));
        }
        ColorPicker roadColorPicker = new ColorPicker(rcolor);
        grid.add((Node)roadColorPicker, 3, 8);
        d2.getDialogPane().setContent((Node)grid);
        ButtonType ok1 = new ButtonType("OK");
        ButtonType cancel = new ButtonType("Cancel");
        d2.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ok1, cancel});
        Optional result = d2.showAndWait();
        if (result.isPresent() && result.get() == cancel) {
            return;
        }
        MapDataSetup setup = new MapDataSetup();
        setup.city.streetLayout = (SetupCityScreen.LAYOUTS)((Object)streetLayoutCombo.getSelectionModel().getSelectedItem());
        setup.city.numStreets = (Integer)numStreetsSpinner.getValue();
        setup.city.skipChance = (Integer)skipChanceSpinner.getValue();
        setup.city.roadtype = roadTextureRB.isSelected() ? "texture" : "color";
        setup.city.roadtexture = (TextureType)roadTextureCombo.getValue();
        setup.city.roadcolor = (Color)roadColorPicker.getValue();
        setup.city.streetDistance = (Double)streetDistanceSpinner.getValue();
        this.launchTask(setup, GenerateCityTask.CITYGEN.STREETS);
    }

    public void handleGenBuildingsMI(Worldographer worldographer, MapUI mapUI) {
        Constable val;
        if (worldographer.getMapUI().getMapData() == null) {
            StandardDialog.showNoMapOpenDialog(worldographer.getPrimaryStage(), "Generate Settlement Buildings");
            return;
        }
        if (worldographer.getMapUI().viewLevel != ViewLevel.SETTLEMENT) {
            StyledDialog d2 = new StyledDialog(true, (Window)worldographer.getPrimaryStage(), "Generate Settlement Buildings");
            d2.setHeaderText("Generate Settlement Buildings is used for City/Village/Settlement maps.");
            d2.setContentText("This feature is one of the last steps of making a city or village or settlement map.");
            ButtonType ok1 = new ButtonType("OK");
            ButtonType cancel = new ButtonType("Cancel");
            d2.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ok1, cancel});
            Optional result = d2.showAndWait();
            if (result.isPresent() && result.get() == cancel) {
                return;
            }
        }
        Polygon selectedAreaPoly = null;
        if (mapUI.selectPts != null && mapUI.selectPts.size() > 0) {
            selectedAreaPoly = new Polygon();
            for (Point2D pt : mapUI.selectPts) {
                selectedAreaPoly.getPoints().add((Object)pt.getX());
                selectedAreaPoly.getPoints().add((Object)pt.getY());
            }
        }
        MapDataSetup setup = new MapDataSetup();
        setup.selectedAreaPoly = selectedAreaPoly;
        StyledDialog d2 = new StyledDialog(true, (Window)worldographer.getPrimaryStage(), "Generate Settlement Buildings");
        d2.setHeaderText("Select the settings for placing buildings:");
        GridPane grid = new GridPane();
        grid.setAlignment(Pos.CENTER);
        grid.setHgap(5.0);
        grid.setVgap(5.0);
        grid.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        grid.setAlignment(Pos.TOP_CENTER);
        FocusSpinner populationSpinner = new FocusSpinner(1, 10000000, 5000);
        grid.add((Node)new Label("Population:"), 0, 3);
        grid.add(populationSpinner, 1, 3);
        CheckBox denseCB = new CheckBox("Dense Buildings");
        grid.add((Node)denseCB, 1, 4);
        grid.add((Node)new Label("Building Road Distance:"), 0, 5);
        FocusSpinner extraPushBackSpinner = new FocusSpinner(0, 400, 20);
        extraPushBackSpinner.setMaxWidth(100.0);
        HBox epbox = new HBox();
        epbox.getChildren().add(extraPushBackSpinner);
        epbox.getChildren().add((Object)new Label("% tile"));
        grid.add((Node)epbox, 1, 5);
        ComboBox buildingLabelCombo = new ComboBox(FXCollections.observableArrayList((Object[])SetupCityScreen.buildingLabelOptions));
        buildingLabelCombo.getSelectionModel().select(0);
        grid.add((Node)new Label("Building Labels:"), 0, 6);
        grid.add((Node)buildingLabelCombo, 1, 6);
        HashMap<String, Spinner<Integer>> spinners = new HashMap<String, Spinner<Integer>>();
        HashMap<String, CheckBox> onRoads = new HashMap<String, CheckBox>();
        if (selectedAreaPoly != null) {
            FlowPane buildingsPane = new FlowPane();
            Label filterLabel = new Label("Filter:");
            grid.add((Node)filterLabel, 0, 5);
            TextField filterTextField = new TextField("");
            grid.add((Node)filterTextField, 1, 5);
            filterTextField.setOnAction(t -> this.createBuildingsPane(buildingsPane, spinners, onRoads, filterTextField.getText()));
            this.createBuildingsPane(buildingsPane, spinners, onRoads, null);
            ScrollPane sp = new ScrollPane((Node)buildingsPane);
            sp.setMaxSize(400.0, 400.0);
            grid.add((Node)sp, 0, 6, 2, 4);
        }
        d2.getDialogPane().setContent((Node)grid);
        ButtonType ok1 = new ButtonType("OK");
        ButtonType cancel = new ButtonType("Cancel");
        d2.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ok1, cancel});
        Optional result = d2.showAndWait();
        if (result.isPresent() && result.get() == cancel) {
            return;
        }
        if (spinners.size() > 0) {
            HashMap<String, Integer> buildingCounts = new HashMap<String, Integer>();
            for (String key : spinners.keySet()) {
                val = (Integer)((Spinner)spinners.get(key)).getValue();
                if (val <= 0) continue;
                buildingCounts.put(key, (Integer)val);
            }
            setup.city.buildingCounts = buildingCounts;
        }
        if (onRoads.size() > 0) {
            HashMap<String, Boolean> onRoadVals = new HashMap<String, Boolean>();
            for (String key : onRoads.keySet()) {
                val = Boolean.valueOf(((CheckBox)onRoads.get(key)).isSelected());
                onRoadVals.put(key, (Boolean)val);
            }
            setup.city.buildingsOnRoads = onRoadVals;
        }
        setup.city.population = (Integer)populationSpinner.getValue();
        setup.city.dense = denseCB.isSelected();
        setup.city.extraPushBack = (Integer)extraPushBackSpinner.getValue();
        setup.city.buildingLabels = (String)buildingLabelCombo.getValue();
        Integer pop = setup.city.population;
        if (pop > 5000 && !UserPrefs.FULL) {
            setup.city.population = 5000;
            StyledDialog d3 = new StyledDialog(true, (Window)worldographer.getPrimaryStage(), "Population Limit");
            d3.setHeaderText("Population Limit");
            Label statusLabel2 = new Label("The free version of the city building functionality limits cities to\nadding 5000 people at a time. Your population will be reduced to 5000.\n\nGo to store.inkwellideas.com to get a city/village building license.\nThen go to the File menu and select Check/Update City/Village License.\n");
            d3.getDialogPane().setContent((Node)statusLabel2);
            ButtonType ok2 = new ButtonType("OK");
            d3.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ok2});
            d3.showAndWait();
        }
        this.launchTask(setup, GenerateCityTask.CITYGEN.BUILDINGS);
    }

    public void handleGenVegetationMI(Worldographer worldographer, MapUI mapUI) {
        StyledDialog d2;
        if (mapUI.getMapData() == null) {
            StandardDialog.showNoMapOpenDialog(worldographer.getPrimaryStage(), "Generate Vegetation");
            return;
        }
        if (mapUI.viewLevel != ViewLevel.SETTLEMENT) {
            d2 = new StyledDialog(true, (Window)worldographer.getPrimaryStage(), "Generate Vegetation");
            d2.setHeaderText("Generate Vegetation is used for City/Village/Settlement maps.");
            d2.setContentText("This feature is the last step of making a city or village or settlement map.");
            ButtonType ok1 = new ButtonType("OK");
            ButtonType cancel = new ButtonType("Cancel");
            d2.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ok1, cancel});
            Optional result = d2.showAndWait();
            if (result.isPresent() && result.get() == cancel) {
                return;
            }
        }
        d2 = new StyledDialog(true, (Window)worldographer.getPrimaryStage(), "Generate Vegetation Buildings");
        d2.setHeaderText("Select the percentage of vegetation:");
        GridPane grid = new GridPane();
        grid.setAlignment(Pos.CENTER);
        grid.setHgap(5.0);
        grid.setVgap(5.0);
        grid.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        grid.setAlignment(Pos.TOP_CENTER);
        FocusSpinner deciduousSpinner = new FocusSpinner(0, 100, 20);
        FocusSpinner evergreenSpinner = new FocusSpinner(0, 100, 5);
        FocusSpinner tropicalSpinner = new FocusSpinner(0, 100, 0);
        grid.add((Node)new Label("Decididuous:"), 0, 0);
        grid.add(deciduousSpinner, 1, 0);
        grid.add((Node)new Label("Evergreen:"), 0, 1);
        grid.add(evergreenSpinner, 1, 1);
        grid.add((Node)new Label("Tropical:"), 0, 2);
        grid.add(tropicalSpinner, 1, 2);
        d2.getDialogPane().setContent((Node)grid);
        ButtonType ok1 = new ButtonType("OK");
        ButtonType cancel = new ButtonType("Cancel");
        d2.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ok1, cancel});
        Optional result = d2.showAndWait();
        if (result.isPresent() && result.get() == cancel) {
            return;
        }
        MapDataSetup setup = new MapDataSetup();
        setup.city.deciduous = (Integer)deciduousSpinner.getValue();
        setup.city.tropical = (Integer)tropicalSpinner.getValue();
        setup.city.evergreen = (Integer)evergreenSpinner.getValue();
        MapLayer veglayer = mapUI.getMapData().getMapLayer("Vegetation");
        if (veglayer == null) {
            veglayer = new MapLayer("Vegetation");
            List<MapLayer> layers = mapUI.getMapData().getMapLayers();
            for (int i = 0; i < layers.size(); ++i) {
                if (!layers.get(i).getName().equals("Features")) continue;
                layers.add(i, veglayer);
                mapUI.getMapData().getMapLayers().add(i + 1, veglayer);
                if (worldographer.layersToolbox.layersTableView == null) break;
                worldographer.layersToolbox.layersTableView.getItems().add(i + 1, (Object)veglayer);
                break;
            }
        }
        this.launchTask(setup, GenerateCityTask.CITYGEN.VEGETATION);
    }

    public FlowPane createBuildingsPane(FlowPane flowPane, Map<String, Spinner<Integer>> spinners, Map<String, CheckBox> onRoadBoxes, String filter) {
        if ("".equals(filter)) {
            filter = null;
        }
        flowPane.getChildren().clear();
        flowPane.setMaxWidth(550.0);
        flowPane.setVgap(5.0);
        flowPane.setHgap(5.0);
        for (String key : Feature.featureTypes.keySet()) {
            if (!key.toLowerCase().contains("structure") || filter != null && !key.toLowerCase().contains(filter)) continue;
            VBox box = new VBox();
            box.setAlignment(Pos.BOTTOM_CENTER);
            FeatureType ft = Feature.featureTypes.get(key);
            ImageView iv = new ImageView(ft.getIcon());
            double w = ft.getIcon().getWidth();
            double h = ft.getIcon().getHeight();
            if (w > h) {
                iv.setFitWidth(60.0);
                iv.setFitHeight(h / w * 60.0);
            } else {
                iv.setFitHeight(60.0);
                iv.setFitWidth(w / h * 60.0);
            }
            box.getChildren().add((Object)iv);
            FocusSpinner spinner = new FocusSpinner(0, 1000, 0);
            spinner.setMaxWidth(55.0);
            spinners.put(key, spinner);
            box.getChildren().add(spinner);
            CheckBox onRoad = new CheckBox("On Road?");
            onRoad.setSelected(true);
            onRoadBoxes.put(key, onRoad);
            box.getChildren().add((Object)onRoad);
            Label l = new Label(key);
            l.setTooltip(new Tooltip(key));
            l.setMaxWidth(90.0);
            l.setTextOverrun(OverrunStyle.LEADING_ELLIPSIS);
            box.getChildren().add((Object)l);
            flowPane.getChildren().add((Object)box);
        }
        return flowPane;
    }

    private void launchTask(MapDataSetup setup, GenerateCityTask.CITYGEN generateType) {
        CityGeneratorUI cityGeneratorUI = this;
        GenerateCityTask generateMapTask = new GenerateCityTask(setup, this.worldographer, generateType, cityGeneratorUI.worldographer.getMapUI());
        this.worldographer.getCancelButton().setDisable(false);
        this.worldographer.getCancelButton().setOnAction(t -> {
            generateMapTask.cancel();
            this.worldographer.getCancelButton().setDisable(true);
            CityGeneratorUI cityGeneratorUI = this;
            cityGeneratorUI.worldographer.getMapUI().draw();
        });
        generateMapTask.setOnSucceeded(wse -> {
            CityGeneratorUI cityGeneratorUI = this;
            cityGeneratorUI.worldographer.getMapUI().draw();
        });
        new Thread((Runnable)((Object)generateMapTask)).start();
    }
}

