/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.ui.dialog;

import com.inkwellideas.ographer.io.UserPrefs;
import com.inkwellideas.ographer.ui.Worldographer;
import com.inkwellideas.ographer.ui.configure.ConfigureCityDataScreen;
import com.inkwellideas.ographer.ui.configure.ConfigureDynamicTerrainScreen;
import com.inkwellideas.ographer.ui.configure.ConfigureFeaturesScreen;
import com.inkwellideas.ographer.ui.configure.ConfigureTerrainScreen;
import com.inkwellideas.ographer.ui.configure.ConfigureTexturesScreen;
import com.inkwellideas.ographer.ui.configure.ConfigureWorldAndNamesDataScreen;
import com.inkwellideas.ographer.ui.dialog.StandardDialog;
import com.inkwellideas.ographer.ui.widget.StyledDialog;
import java.util.Optional;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.layout.GridPane;
import javafx.stage.Stage;
import javafx.stage.Window;

public class ConfigurationDialog {
    public void launchConfigureDynamicTerrain(Worldographer worldographer) {
        if (UserPrefs.FULL) {
            Stage stage = new Stage();
            ConfigureDynamicTerrainScreen ss = new ConfigureDynamicTerrainScreen(worldographer);
            ss.start(stage);
            stage.show();
        } else {
            StandardDialog.showDialog(worldographer.getPrimaryStage(), "License Required", "Configuring dynamic terrain data is only available if using a paid license.", "The free version of the city building functionality does not allow you to configure\nthe settlement data (adjust buildings used, price lists, personalities, etc.).\n\nGo to store.inkwellideas.com to get a city/village functionality license.\nThen go to the File menu and select Check/Update City/Village License.\n", null, "");
        }
    }

    public void launchConfigureCityData(Worldographer worldographer) {
        if (UserPrefs.FULL) {
            Stage stage = new Stage();
            ConfigureCityDataScreen ss = new ConfigureCityDataScreen(worldographer);
            ss.start(stage);
            stage.show();
        } else {
            StandardDialog.showDialog(worldographer.getPrimaryStage(), "City/Village License Required", "Configuring settlement data is only available if using a City/Village license.", "The free version of the city building functionality does not allow you to configure\nthe settlement data (adjust buildings used, price lists, personalities, etc.).\n\nGo to store.inkwellideas.com to get a city/village functionality license.\nThen go to the File menu and select Check/Update City/Village License.\n", null, "");
        }
    }

    public void launchConfigureWorldNameData(Worldographer worldographer) {
        if (UserPrefs.FULL) {
            Stage stage = new Stage();
            ConfigureWorldAndNamesDataScreen ss = new ConfigureWorldAndNamesDataScreen(worldographer);
            ss.start(stage);
            stage.show();
        } else {
            StandardDialog.showDialog(worldographer.getPrimaryStage(), "Pro Feature", "Configuring world & name data is only available if using a Pro version license.", "Sorry, some features are reserved for our Pro/paid version. \nIf you find the software useful, considering unlocking these special features and supporting \nthe many hours of work to create Worldographer with a Pro license. \nSee www.worldographer.com for details.\n", null, "");
        }
    }

    public void launchConfigureFeatures(Worldographer worldographer) {
        if (UserPrefs.FULL) {
            StyledDialog d = new StyledDialog(true, (Window)worldographer.getPrimaryStage(), "Worldographer Configure Features");
            d.setHeaderText("Select the style of features you wish to configure.");
            GridPane gp = new GridPane();
            gp.add((Node)new Label("Feature Style: "), 0, 1);
            ComboBox terrainStyleBox = new ComboBox(Worldographer.featureCategories);
            terrainStyleBox.getSelectionModel().select((Object)"Classic");
            gp.add((Node)terrainStyleBox, 1, 1);
            d.getDialogPane().setContent((Node)gp);
            ButtonType yes = new ButtonType("Continue");
            ButtonType no = new ButtonType("Cancel");
            d.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{yes, no});
            Optional result = d.showAndWait();
            if (result.isPresent() && result.get() == yes) {
                String name = (String)terrainStyleBox.getSelectionModel().getSelectedItem();
                Stage stage = new Stage();
                ConfigureFeaturesScreen ss = new ConfigureFeaturesScreen(worldographer, name);
                ss.start(stage);
                stage.show();
            }
        } else {
            StandardDialog.showDialog(worldographer.getPrimaryStage(), "Pro Feature", "Configuring features is only available if using a Pro version license.", "Sorry, some features are reserved for our Pro/paid version. If you find the software useful, considering unlocking these special features and supporting the many hours of work to create Worldographer with a Pro license. See www.worldographer.com for details.", null, "");
        }
    }

    public void launchConfigureTerrain(Worldographer worldographer) {
        if (UserPrefs.FULL) {
            StyledDialog d = new StyledDialog(true, (Window)worldographer.getPrimaryStage(), "Worldographer Configure Terrain");
            d.setHeaderText("Select the style of terrain you wish to configure.");
            GridPane gp = new GridPane();
            gp.add((Node)new Label("Note: Removing the main built-in classic terrain (farmland, hills, light forest, forested\nhills, mountains, etc.--all the terrain found on a newly generated map) will prevent the\nsystem from generating new maps maps until restarted even if you are using isometric\nterrain. Removing classic or isometric terrain will likely interfere with the tool that\nconverts between these two terrain types.\n"), 0, 0, 2, 1);
            gp.add((Node)new Label("Terrain Style: "), 0, 1);
            ComboBox terrainStyleBox = new ComboBox(Worldographer.terrainCategories);
            terrainStyleBox.getSelectionModel().select((Object)"Classic");
            gp.add((Node)terrainStyleBox, 1, 1);
            d.getDialogPane().setContent((Node)gp);
            ButtonType yes = new ButtonType("Continue");
            ButtonType no = new ButtonType("Cancel");
            d.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{yes, no});
            Optional result = d.showAndWait();
            if (result.isPresent() && result.get() == yes) {
                String name = (String)terrainStyleBox.getSelectionModel().getSelectedItem();
                Stage stage = new Stage();
                ConfigureTerrainScreen ss = new ConfigureTerrainScreen(worldographer, name);
                ss.start(stage);
                stage.show();
            }
        } else {
            StandardDialog.showDialog(worldographer.getPrimaryStage(), "Pro Feature", "Configuring terrain is only available if using a Pro version license.", "Sorry, some features are reserved for our Pro/paid version. \nIf you find the software useful, considering unlocking these special features and supporting \nthe many hours of work to create Worldographer with a Pro license. \nSee www.worldographer.com for details.\n", null, "");
        }
    }

    public void launchConfigureTextures(Worldographer worldographer) {
        if (UserPrefs.FULL) {
            Stage stage = new Stage();
            ConfigureTexturesScreen ss = new ConfigureTexturesScreen(worldographer);
            ss.start(stage);
            stage.show();
        } else {
            StandardDialog.showDialog(worldographer.getPrimaryStage(), "Pro Feature", "Configuring textures is only available if using a Pro version license.", "Sorry, some features are reserved for our Pro/paid version. If you find the software useful, considering unlocking these special features and supporting the many hours of work to create Worldographer with a Pro license. See www.worldographer.com for details.", null, "");
        }
    }
}

