/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.ui.dialog;

import com.inkwellideas.ographer.data.HexOrientation;
import com.inkwellideas.ographer.data.ViewLevel;
import com.inkwellideas.ographer.map.MapData;
import com.inkwellideas.ographer.map.MapDataSetup;
import com.inkwellideas.ographer.map.MapProjection;
import com.inkwellideas.ographer.map.MapShape;
import com.inkwellideas.ographer.map.Terrain;
import com.inkwellideas.ographer.ui.MapUI;
import com.inkwellideas.ographer.ui.Worldographer;
import com.inkwellideas.ographer.ui.widget.DraggableTab;
import com.inkwellideas.ographer.ui.widget.StyledDialog;
import java.util.Locale;
import java.util.Optional;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.stage.Window;

public class StartNewMapDialog {
    public MapUI startNewMap(MapDataSetup data, Worldographer worldographer) {
        return this.startNewMap(data, worldographer, false);
    }

    public MapUI startNewMap(MapDataSetup setup, Worldographer worldographer, boolean preview) {
        MapData mapData = new MapData(setup);
        if (setup.filename != null) {
            mapData.setFile(setup.filename);
        }
        String lastViewLevel = setup.lastViewLevel;
        ViewLevel initialvl = ViewLevel.WORLD;
        if (lastViewLevel != null && !"".equals(lastViewLevel)) {
            initialvl = ViewLevel.valueOf(lastViewLevel);
        } else {
            if (mapData.getTerrain(initialvl) == null) {
                initialvl = ViewLevel.CONTINENT;
            }
            if (mapData.getTerrain(initialvl) == null) {
                initialvl = ViewLevel.KINGDOM;
            }
            if (mapData.getTerrain(initialvl) == null) {
                initialvl = ViewLevel.PROVINCE;
            }
            if (mapData.getTerrain(initialvl) == null) {
                initialvl = ViewLevel.BATTLEMAT;
            }
            if (mapData.getTerrain(initialvl) == null) {
                initialvl = ViewLevel.SETTLEMENT;
            }
            if (mapData.getTerrain(initialvl) == null) {
                initialvl = ViewLevel.COSMIC;
            }
            if (mapData.getShapes() != null && mapData.getShapes().size() > 0) {
                initialvl = mapData.getShapes().get(0).getCurrentShapeViewLevel();
                for (MapShape ms : mapData.getShapes()) {
                    if (ms.getCurrentShapeViewLevel() == initialvl) continue;
                }
            }
        }
        this.pingUsage(setup);
        MapUI mapUI = new MapUI(mapData, initialvl, worldographer.WLogger);
        if (preview) {
            return mapUI;
        }
        worldographer.setMapUI(mapUI);
        if (mapData.getTileOrientation() == HexOrientation.SQUARE) {
            mapData.getGrid().setSquare(1);
        }
        mapData.setupUndoRedoHandler(worldographer.WLogger);
        Object tabname = "Map " + Worldographer.mapcount;
        if (mapData.getFile() != null) {
            tabname = mapData.getFile().getName();
        } else {
            ++Worldographer.mapcount;
        }
        DraggableTab tab = new DraggableTab((String)tabname);
        tab.setContent((Node)worldographer.getMapUI());
        tab.setOnCloseRequest(e -> {
            if (((MapUI)tab.getContent()).getController().getUndoRedoHandler().isChanged()) {
                StyledDialog d = new StyledDialog(true, (Window)worldographer.getPrimaryStage(), "Confirm Close");
                d.setHeaderText("Changes Not Saved.");
                d.getDialogPane().setContent((Node)new Label("Changes you've made to the map you're closing haven't been saved.\n\nAre you sure you wish to close the tab?"));
                ButtonType yes = new ButtonType("OK");
                ButtonType cancel = new ButtonType("Cancel");
                d.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{yes, cancel});
                Optional result = d.showAndWait();
                if (result.isPresent() && result.get() == cancel) {
                    e.consume();
                } else if (worldographer.tabPane.getTabs().size() == 1) {
                    worldographer.splitPane.getItems().remove((Object)worldographer.rightControls);
                }
            } else if (worldographer.tabPane.getTabs().size() == 1) {
                worldographer.splitPane.getItems().remove((Object)worldographer.rightControls);
            }
        });
        worldographer.tabPane.getTabs().add((Object)tab);
        worldographer.tabPane.getSelectionModel().select((Object)tab);
        if (worldographer.tabPane.getTabs().size() == 1) {
            worldographer.toggleGroup.selectedToggleProperty().addListener((ov, toggle, new_toggle) -> {
                worldographer.getMapUI().hoverObject = null;
                worldographer.getMapUI().getCurrentObjects().clear();
                if (!worldographer.viewOptions.noteButton.isSelected()) {
                    worldographer.getMapUI().getMapData().getShow().setNotes(false);
                }
                worldographer.getMapUI().draw();
            });
            if (!worldographer.worldographerMenuBar.toolboxMenuItem.isSelected()) {
                worldographer.createRightTabControls(initialvl);
            }
        }
        if (initialvl.equals((Object)ViewLevel.BATTLEMAT)) {
            worldographer.terrainToolbox.terrainFilterComboBox.getSelectionModel().select((Object)"Floor");
            worldographer.featuresToolbox.featureFilterComboBox.getSelectionModel().select((Object)"Battlemat");
        } else if (initialvl.equals((Object)ViewLevel.COSMIC)) {
            worldographer.terrainToolbox.terrainFilterComboBox.getSelectionModel().select((Object)"Cosmic");
            worldographer.featuresToolbox.featureFilterComboBox.getSelectionModel().select((Object)"Cosmic");
        } else if (initialvl.equals((Object)ViewLevel.SETTLEMENT)) {
            worldographer.terrainToolbox.terrainFilterComboBox.getSelectionModel().select((Object)"Floor");
            worldographer.featuresToolbox.featureFilterComboBox.getSelectionModel().select((Object)"Structure");
        } else {
            double ratio = worldographer.getMapUI().getMapData().getTileWidth() / worldographer.getMapUI().getMapData().getTileHeight();
            if (ratio > 1.65 && ratio < 1.8) {
                worldographer.terrainToolbox.terrainFilterComboBox.getSelectionModel().select((Object)"ISO Cols");
                worldographer.featuresToolbox.featureFilterComboBox.getSelectionModel().select((Object)"Isometric Region");
            } else if (ratio > 1.25 && ratio < 1.4) {
                worldographer.terrainToolbox.terrainFilterComboBox.getSelectionModel().select((Object)"ISO Rows");
                worldographer.featuresToolbox.featureFilterComboBox.getSelectionModel().select((Object)"Isometric Region");
            } else {
                worldographer.terrainToolbox.terrainFilterComboBox.getSelectionModel().select((Object)"Classic");
                worldographer.featuresToolbox.featureFilterComboBox.getSelectionModel().select((Object)"Classic");
            }
        }
        worldographer.terrainToolbox.updateTerrainButtonsFlow();
        worldographer.featuresToolbox.updateFeatureButtons();
        worldographer.getMapUI().canvas.addEventHandler(MouseEvent.MOUSE_MOVED, worldographer::handleMouseMoved);
        worldographer.getMapUI().canvas.addEventHandler(MouseEvent.MOUSE_DRAGGED, worldographer::handleMouseDragged);
        worldographer.getMapUI().canvas.addEventHandler(MouseEvent.MOUSE_RELEASED, worldographer::handleMouseReleased);
        worldographer.getMapUI().canvas.addEventHandler(MouseEvent.MOUSE_CLICKED, worldographer::handleMouseClicked);
        worldographer.getMapUI().canvas.addEventHandler(MouseEvent.MOUSE_EXITED, worldographer::handleMouseExited);
        worldographer.getMapUI().canvas.setOnScroll(event -> worldographer.handleScrollEvent((ScrollEvent)event, mapData));
        return worldographer.getMapUI();
    }

    private void pingUsage(MapDataSetup setup) {
        Object terrainStyle;
        String orientation;
        ViewLevel vl = ViewLevel.WORLD;
        if (setup.worldTerrain != null) {
            vl = ViewLevel.WORLD;
        }
        if (setup.continentTerrain != null) {
            vl = ViewLevel.CONTINENT;
        }
        if (setup.provinceTerrain != null) {
            vl = ViewLevel.PROVINCE;
        }
        if (setup.kingdomTerrain != null) {
            vl = ViewLevel.KINGDOM;
        }
        if (setup.settlementTerrain != null) {
            vl = ViewLevel.SETTLEMENT;
        }
        if (setup.battleMatTerrain != null) {
            vl = ViewLevel.BATTLEMAT;
        }
        if (setup.cosmicTerrain != null) {
            vl = ViewLevel.COSMIC;
        }
        String size = "triangle-" + setup.view.triangleSize;
        MapProjection mapProjection = setup.mapProjection;
        if (mapProjection == MapProjection.FLAT) {
            Terrain[][] ter = setup.getTerrainByViewLevel(vl);
            size = ter.length + "-" + ter[0].length;
        }
        if ((orientation = setup.hexOrientation.toString()).contains(" ")) {
            orientation = orientation.substring(0, orientation.indexOf(" "));
        }
        String loadOrCreate = "Create";
        if (setup.filename != null) {
            loadOrCreate = "Load";
        }
        if ((terrainStyle = setup.terrainStyle) == null) {
            Terrain[][] ter = setup.getTerrainByViewLevel(vl);
            for (int i = 0; i < 5; ++i) {
                if (!ter[(int)(Math.random() * (double)ter.length)][(int)(Math.random() * (double)ter[0].length)].getTypeName().toLowerCase(Locale.ROOT).contains("iso")) continue;
                terrainStyle = "Isometric";
                break;
            }
            if (terrainStyle == null) {
                terrainStyle = "Classic";
            }
        }
        Worldographer.pingUsage("http://www.worldographer.com/usage/" + loadOrCreate + "_" + String.valueOf((Object)vl) + "_" + String.valueOf(terrainStyle) + "_" + orientation + "_" + String.valueOf((Object)mapProjection) + "_" + size + ".txt");
    }
}

