/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.ui.toolbox;

import com.inkwellideas.ographer.io.LoadImage;
import com.inkwellideas.ographer.map.Terrain;
import com.inkwellideas.ographer.ui.Worldographer;
import com.inkwellideas.ographer.ui.toolbox.Toolbox;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.OverrunStyle;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.Tooltip;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.text.TextAlignment;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;

public class FogOfWarToolbox
extends Toolbox {
    public FogOfWarToolbox(Worldographer worldographer) {
        super(worldographer);
    }

    @Override
    public void setup(ToggleButton toggleButton) {
        this.createToolbox("Fog of War/Explore", "other_imgs/hide_all_but_24.png", (Node)this.createFogOfWarDrawer(), 370, 85, true);
        this.stage.show();
        this.stage.setOnCloseRequest(event -> toggleButton.setSelected(false));
    }

    public GridPane createFogOfWarDrawer() {
        GridPane grid2 = new GridPane();
        grid2.setAlignment(Pos.CENTER);
        grid2.setHgap(5.0);
        grid2.setVgap(5.0);
        grid2.setPadding(new Insets(3.0, 3.0, 3.0, 3.0));
        HBox box = new HBox();
        Button instructionsbutton = new Button("", (Node)new ImageView(LoadImage.image("other_imgs/question.png")));
        instructionsbutton.setTooltip(new Tooltip("Help"));
        instructionsbutton.setOnAction(event -> {
            Dialog d = new Dialog();
            d.setTitle("Fog of War/Exploration Instructions");
            d.setHeaderText("How to Use Fog of War/Exploration in Worldographer");
            WebView view = new WebView();
            view.setMinSize(300.0, 300.0);
            view.setPrefSize(550.0, 350.0);
            WebEngine textengine = view.getEngine();
            textengine.loadContent("<style type=\"text/css\">p {font-family: Futura,Trebuchet MS,Arial,sans-serif; font-size:0.875em; padding: 0; margin: 0}\nh1,h2,h3 {font-family: Futura,Trebuchet MS,Arial,sans-serif; padding: 0; margin: 0}</style><ul>\n<p>Note: You need to make sure the \"Show GM Only Items\" checkbox on the \"View Options\" drawer is unchecked for\nthe Fog of War feature to work properly.  Otherwise, that setting is forcing all of the map to be shown.</p>\n<li>Select Area: Select an area by clicking the 'Select Map Area' button then click-dragging an area on the map or\nclicking the points of a polygon on the map. The selected area will turn yellow.\nThis area can either be set as the only area seen or the\narea hidden (see below). The area hidden or seen will be tile-based (hex or square, depending on map\ntype).  If the selected area touches any portion of a tile, it is in the selected area and will be\nhidden/seen.</li>\n<li>Temporarily Show All: In case you lose track of what is where, you can toggle this on and off to\nshow all the tiles on the map. Don't forget to hide your screen (turn off screen sharing) from your\nplayers first. Press this button again to deselect it and all the tiles that were hidden will be hidden\nagain, including any changes you made (added hidden/shown tiles) while it was selected.</li>\n<li>Hide All But Selected: Usually, once you select the initial region that the PCs know, click\nthis to hide the rest of the map. After that first use, you usually don't use this button again\nunless there is some reason the PCs would forget an area and you want to start the exploration over.</li>\n<li>Show Selected: This is probably the most commonly used button here (along with select area, which\ncan be left on).  Once you already have the next area the PCs can see selected on the map, click this\nand that area will be shown.</li>\n<li>Hide Selected: Did you accidentally reveal too much of the map?  Or is there a reason the PCs\nno longer know an area? Select an area on the map and then click this button to hide that region.</li></ul>\n");
            d.getDialogPane().setContent((Node)view);
            ButtonType yes = new ButtonType("OK");
            d.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{yes});
            d.showAndWait();
        });
        instructionsbutton.setAlignment(Pos.TOP_CENTER);
        this.worldographer.selectMapAreaToggle.setToggleGroup(this.worldographer.toggleGroup);
        this.worldographer.selectMapAreaToggle.setStyle("-fx-font-size: 10px");
        this.worldographer.selectMapAreaToggle.setTextAlignment(TextAlignment.CENTER);
        this.worldographer.selectMapAreaToggle.setTextOverrun(OverrunStyle.ELLIPSIS);
        this.worldographer.selectMapAreaToggle.setContentDisplay(ContentDisplay.TOP);
        this.worldographer.selectMapAreaToggle.setMinWidth(60.0);
        this.worldographer.selectMapAreaToggle.setTooltip(new Tooltip("Select an area by clicking the 'Select Map Area' button then click-dragging an area on the map or\nclicking the points of a polygon on the map. The selected area will turn yellow."));
        box.getChildren().add((Object)this.worldographer.selectMapAreaToggle);
        this.worldographer.selectMapAreaToggle.setOnAction(event -> {
            this.worldographer.worldographerMenuBar.selectItem.setSelected(this.worldographer.selectMapAreaToggle.isSelected());
            FogOfWarToolbox fogOfWarToolbox = this;
            fogOfWarToolbox.worldographer.getMapUI().selectPts.clear();
            FogOfWarToolbox fogOfWarToolbox2 = this;
            fogOfWarToolbox2.worldographer.getMapUI().draw();
        });
        box.getChildren().add((Object)new Label(" "));
        ToggleButton tempShowAll = new ToggleButton("Temporarily\nShow All", (Node)new ImageView(LoadImage.image("other_imgs/temp_show_all.png")));
        tempShowAll.setTooltip(new Tooltip("Toggle this to show all the tiles on the map. Don't forget to hide your screen from your\nplayers first. Press this button again to deselect it and all the tiles that were hidden will be hidden again, including\nany changes you made (added hidden/shown tiles) while it was selected."));
        tempShowAll.setStyle("-fx-font-size: 10px");
        tempShowAll.setTextAlignment(TextAlignment.CENTER);
        tempShowAll.setTextOverrun(OverrunStyle.ELLIPSIS);
        tempShowAll.setContentDisplay(ContentDisplay.TOP);
        tempShowAll.setMinWidth(60.0);
        box.getChildren().add((Object)tempShowAll);
        tempShowAll.setOnAction(event -> {
            if (tempShowAll.isSelected()) {
                Terrain[][] t;
                FogOfWarToolbox fogOfWarToolbox = this;
                FogOfWarToolbox fogOfWarToolbox2 = this;
                for (Terrain[] terrains : t = fogOfWarToolbox.worldographer.getMapUI().getMapData().getTerrain(fogOfWarToolbox2.worldographer.getMapUI().getViewLevel())) {
                    for (int j = 0; j < t[0].length; ++j) {
                        terrains[j].setTempGMOnly(terrains[j].isGmOnly());
                        terrains[j].setGmOnly(false);
                    }
                }
            } else {
                Terrain[][] t;
                FogOfWarToolbox fogOfWarToolbox = this;
                FogOfWarToolbox fogOfWarToolbox3 = this;
                for (Terrain[] terrains : t = fogOfWarToolbox.worldographer.getMapUI().getMapData().getTerrain(fogOfWarToolbox3.worldographer.getMapUI().getViewLevel())) {
                    for (int j = 0; j < t[0].length; ++j) {
                        terrains[j].setGmOnly(terrains[j].getExtraInfo().isTempGMOnly());
                    }
                }
            }
            FogOfWarToolbox fogOfWarToolbox = this;
            fogOfWarToolbox.worldographer.getMapUI().draw();
        });
        box.getChildren().add((Object)new Label("  "));
        Button hideallbutselectedbutton = new Button("Hide All But\nSelected", (Node)new ImageView(LoadImage.image("other_imgs/hide_all_but.png")));
        hideallbutselectedbutton.setTooltip(new Tooltip("Usually, once you select the initial region that the PCs know, click this to hide\nthe rest of the map. After that first use, you usually don't use this button again\nunless there is some reason the PCs would forget an area and you want to start over."));
        hideallbutselectedbutton.setStyle("-fx-font-size: 10px");
        hideallbutselectedbutton.setTextAlignment(TextAlignment.CENTER);
        hideallbutselectedbutton.setTextOverrun(OverrunStyle.ELLIPSIS);
        hideallbutselectedbutton.setContentDisplay(ContentDisplay.TOP);
        hideallbutselectedbutton.setMinWidth(60.0);
        box.getChildren().add((Object)hideallbutselectedbutton);
        hideallbutselectedbutton.setOnAction(event -> {
            Terrain[][] t;
            FogOfWarToolbox fogOfWarToolbox = this;
            FogOfWarToolbox fogOfWarToolbox2 = this;
            for (Terrain[] terrains : t = fogOfWarToolbox.worldographer.getMapUI().getMapData().getTerrain(fogOfWarToolbox2.worldographer.getMapUI().getViewLevel())) {
                for (int j = 0; j < t[0].length; ++j) {
                    terrains[j].setGmOnly(true);
                }
            }
            this.worldographer.setSelectedGMOnly(false);
            FogOfWarToolbox fogOfWarToolbox3 = this;
            fogOfWarToolbox3.worldographer.getMapUI().draw();
        });
        box.getChildren().add((Object)new Label(" "));
        Button showselectedbutton = new Button("Show\nSelected", (Node)new ImageView(LoadImage.image("other_imgs/show_selected.png")));
        showselectedbutton.setTooltip(new Tooltip("Once you already have the next area the PCs can see selected on the map (via 'Select area')\nclick this and that area will be shown."));
        showselectedbutton.setStyle("-fx-font-size: 10px");
        showselectedbutton.setTextAlignment(TextAlignment.CENTER);
        showselectedbutton.setTextOverrun(OverrunStyle.ELLIPSIS);
        showselectedbutton.setContentDisplay(ContentDisplay.TOP);
        showselectedbutton.setMinWidth(60.0);
        box.getChildren().add((Object)showselectedbutton);
        showselectedbutton.setOnAction(event -> {
            this.worldographer.setSelectedGMOnly(false);
            FogOfWarToolbox fogOfWarToolbox = this;
            fogOfWarToolbox.worldographer.getMapUI().draw();
        });
        Button hideselectedbutton = new Button("Hide\nSelected", (Node)new ImageView(LoadImage.image("other_imgs/hide_selected.png")));
        hideselectedbutton.setTooltip(new Tooltip("Select an area on the map and then click this button to hide that region."));
        hideselectedbutton.setStyle("-fx-font-size: 10px");
        hideselectedbutton.setTextAlignment(TextAlignment.CENTER);
        hideselectedbutton.setTextOverrun(OverrunStyle.ELLIPSIS);
        hideselectedbutton.setContentDisplay(ContentDisplay.TOP);
        hideselectedbutton.setMinWidth(60.0);
        box.getChildren().add((Object)hideselectedbutton);
        hideselectedbutton.setOnAction(event -> {
            this.worldographer.setSelectedGMOnly(true);
            FogOfWarToolbox fogOfWarToolbox = this;
            fogOfWarToolbox.worldographer.getMapUI().draw();
        });
        box.getChildren().add((Object)new Label("  "));
        box.getChildren().add((Object)instructionsbutton);
        grid2.add((Node)box, 0, 0);
        grid2.add((Node)new Label("Make sure the GM Only \"Show\" checkbox  is off.\n(On the bottom of the Worldographer window.)"), 0, 1);
        return grid2;
    }
}

