/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.ui.toolbox;

import com.inkwellideas.ographer.data.MapLayer;
import com.inkwellideas.ographer.data.MapObject;
import com.inkwellideas.ographer.data.ViewLevel;
import com.inkwellideas.ographer.io.LoadImage;
import com.inkwellideas.ographer.io.UserPrefs;
import com.inkwellideas.ographer.map.MapLabel;
import com.inkwellideas.ographer.ui.Worldographer;
import com.inkwellideas.ographer.ui.configure.ConfigureLabelStylesScreen;
import com.inkwellideas.ographer.ui.dialog.StandardDialog;
import com.inkwellideas.ographer.ui.toolbox.FeaturesToolbox;
import com.inkwellideas.ographer.ui.toolbox.Toolbox;
import com.inkwellideas.ographer.ui.widget.ColorPickerWithSelector;
import com.inkwellideas.ographer.ui.widget.FocusSpinner;
import com.inkwellideas.ographer.undo.UndoActionGroup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.OverrunStyle;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Spinner;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;
import javafx.scene.text.TextAlignment;
import javafx.stage.Stage;
import javafx.util.Pair;
import org.kordamp.ikonli.javafx.FontIcon;

public class LabelsToolbox
extends Toolbox {
    TextArea labelTA;
    public ToggleButton newLabelButton;
    public ToggleButton labelSelectButton;
    ColorPicker labelColorPicker;
    ColorPicker labelOutlineColorBGCP;
    ColorPicker labelBackgroundCP;
    public Spinner<Double> labelScaleSpinner;
    Spinner<Double> labelOutlineSizeSpinner;
    public Spinner<Double> labelRotateSpinner;
    Spinner<Double> labelScaleFactorSpinner;
    public ComboBox<MapLayer> labelsMapLayerCombo;
    CheckBox labelGMOnlyCB;
    CheckBox labelBoldCB;
    CheckBox labelItalicCB;
    CheckBox labelBackgroundCB;
    CheckBox labelWorldCB;
    CheckBox labelContinentCB;
    CheckBox labelKingdomCB;
    CheckBox labelProvinceCB;
    Button labelDeleteButton;
    Button labelDeselectButton;
    TextField labelTagsTF;
    ComboBox<String> labelStyleCombo;
    ComboBox<String> labelFontCombo;
    ComboBox<TextAlignment> textAlignmentComboBox;
    public ColorPickerWithSelector labelColorPickerWSelector;
    public ColorPickerWithSelector labelOutlineColorPickerWSelector;
    public ColorPickerWithSelector labelBackgroundColorPickerWSelector;
    final List<String> textStyles = new ArrayList<String>();

    public LabelsToolbox(Worldographer worldographer) {
        super(worldographer);
    }

    @Override
    public void setup(ToggleButton toggleButton) {
        this.createToolbox("Labels", "other_imgs/labels_24.png", (Node)this.createLabelsDrawer(this.worldographer.toggleGroup, this.worldographer.featuresToolbox, this.worldographer.undoEnabled), 450, 350, true);
        this.stage.show();
        this.stage.setOnCloseRequest(event -> toggleButton.setSelected(false));
    }

    public void updateSelectionControls(MapLabel ml) {
        this.labelTA.setText(ml.getText());
        this.labelsMapLayerCombo.getSelectionModel().select((Object)ml.getMapLayer());
        this.labelOutlineSizeSpinner.getValueFactory().setValue((Object)ml.getOutlineSize());
        this.labelScaleSpinner.getValueFactory().setValue((Object)ml.getScale(this.mapUI().viewLevel));
        this.labelRotateSpinner.getValueFactory().setValue((Object)ml.getRotate());
        this.labelGMOnlyCB.setSelected(ml.isGmOnly());
        this.labelBoldCB.setSelected(ml.isBold());
        this.labelItalicCB.setSelected(ml.isItalic());
        this.labelWorldCB.setSelected(ml.isWorld());
        this.labelContinentCB.setSelected(ml.isContinent());
        this.labelKingdomCB.setSelected(ml.isKingdom());
        this.labelProvinceCB.setSelected(ml.isProvince());
        this.labelTagsTF.setText(ml.getTags());
        this.labelFontCombo.getSelectionModel().select((Object)ml.getFontFace());
        this.labelStyleCombo.getSelectionModel().select((Object)ml.getStyle());
        this.textAlignmentComboBox.getSelectionModel().select((Object)ml.getTextAlignment());
        if (ml.getColor() != null) {
            this.labelColorPicker.setValue((Object)ml.getColor());
        }
        if (ml.getOutlineColor() != null) {
            this.labelOutlineColorBGCP.setValue((Object)ml.getOutlineColor());
        }
    }

    public void initLabelsControls() {
        this.newLabelButton = new ToggleButton("New Label");
        FontIcon newLabelIcon = new FontIcon();
        newLabelIcon.setStyle("-fx-icon-code:mdi2s-star-plus;-fx-icon-size:32;");
        this.newLabelButton.setGraphic((Node)newLabelIcon);
        this.labelTA = new TextArea("");
        this.textStyles.clear();
        this.textStyles.add("Use Custom Style");
        ObservableList soptions = FXCollections.observableArrayList(this.textStyles);
        this.labelStyleCombo = new ComboBox(soptions);
        this.labelRotateSpinner = new FocusSpinner<Double>(0.0, 360.0, 0.0);
        this.labelsMapLayerCombo = new ComboBox(this.worldographer.observableLayers);
        this.labelTagsTF = new TextField();
        this.labelSelectButton = new ToggleButton("Select");
        FontIcon selectIcon = new FontIcon();
        selectIcon.setStyle("-fx-icon-code:mdi2s-selection-ellipse-arrow-inside;-fx-icon-size:32;");
        this.labelSelectButton.setGraphic((Node)selectIcon);
        this.labelDeselectButton = new Button("De-select\n(Ctrl-D)", (Node)new ImageView(LoadImage.image("other_imgs/deselect.png")));
        FontIcon deselectIcon = new FontIcon();
        deselectIcon.setStyle("-fx-icon-code:mdi2s-selection-off;-fx-icon-size:20;");
        this.labelDeselectButton.setGraphic((Node)deselectIcon);
        this.labelDeleteButton = new Button("Delete");
        FontIcon deleteIcon = new FontIcon();
        deleteIcon.setStyle("-fx-icon-code:mdi2d-delete;-fx-icon-size:32;");
        this.labelDeleteButton.setGraphic((Node)deleteIcon);
        ObservableList foptions = FXCollections.observableArrayList((Collection)Font.getFamilies());
        this.labelFontCombo = new ComboBox(foptions);
        this.labelColorPicker = new ColorPicker();
        this.labelColorPickerWSelector = new ColorPickerWithSelector(this.labelColorPicker);
        this.labelOutlineColorBGCP = new ColorPicker();
        this.labelOutlineColorPickerWSelector = new ColorPickerWithSelector(this.labelOutlineColorBGCP);
        this.labelScaleSpinner = new FocusSpinner<Double>(1.0, 1000.0, 75.0);
        this.labelOutlineSizeSpinner = new FocusSpinner<Double>(0.0, 100.0, 0.0);
        this.labelBoldCB = new CheckBox("Bold");
        this.labelItalicCB = new CheckBox("Italic");
        this.labelBackgroundCB = new CheckBox("Background");
        this.labelBackgroundCP = new ColorPicker();
        this.labelBackgroundColorPickerWSelector = new ColorPickerWithSelector(this.labelBackgroundCP);
        this.labelGMOnlyCB = new CheckBox("GM Only");
        this.labelGMOnlyCB.setOnAction(event -> {
            this.mapUI().getController().updateGMOnly(this.worldographer.undoEnabled, this.mapUI().getCurrentObjects(), this.labelGMOnlyCB.isSelected());
            this.mapUI().draw();
        });
        this.textAlignmentComboBox = new ComboBox(FXCollections.observableArrayList((Object[])TextAlignment.values()));
        this.textAlignmentComboBox.setValue((Object)TextAlignment.CENTER);
        this.labelWorldCB = new CheckBox("World");
        this.labelContinentCB = new CheckBox("Continent");
        this.labelKingdomCB = new CheckBox("Kingdom");
        this.labelProvinceCB = new CheckBox("Province");
        this.labelWorldCB.setSelected(true);
        this.labelContinentCB.setSelected(true);
        this.labelKingdomCB.setSelected(true);
        this.labelProvinceCB.setSelected(true);
    }

    public BorderPane createLabelsDrawer(ToggleGroup toggleGroup, FeaturesToolbox featuresToolbox, boolean undoEnabled) {
        BorderPane labelsborderpane = new BorderPane();
        FlowPane topPane = new FlowPane();
        topPane.setHgap(5.0);
        topPane.setVgap(5.0);
        topPane.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        this.newLabelButton.setToggleGroup(toggleGroup);
        this.newLabelButton.setTooltip(new Tooltip("Select this then click on the map where you want your label centered.\nThe text in the text area below will appear there with the selected settings."));
        this.newLabelButton.setUserData((Object)new MapLabel("", "", (String)featuresToolbox.featuresLabelFontCombo.getSelectionModel().getSelectedItem(), (Color)featuresToolbox.featuresLabelColorCP.getValue(), 0.0, (Color)featuresToolbox.featuresLabelOutlineColorCP.getValue(), null, 0.0, false, false, false, false, false, false, false, TextAlignment.CENTER, "", null));
        this.newLabelButton.setStyle("-fx-font-size: 9px");
        this.newLabelButton.setTextAlignment(TextAlignment.CENTER);
        this.newLabelButton.setTextOverrun(OverrunStyle.ELLIPSIS);
        this.newLabelButton.setContentDisplay(ContentDisplay.TOP);
        topPane.getChildren().add((Object)this.newLabelButton);
        this.labelSelectButton.setStyle("-fx-font-size: 9px");
        this.labelSelectButton.setTooltip(new Tooltip("Click this, then click a label on the map to update all the settings on this panel\nto match that label. Also when selected, move it, rotate it, or change any of the\nsettings below. Control-click to select multiple labels--this lets you move several\nat once & a setting change on this panel will apply to all of them."));
        this.labelSelectButton.setTextAlignment(TextAlignment.CENTER);
        this.labelSelectButton.setTextOverrun(OverrunStyle.ELLIPSIS);
        this.labelSelectButton.setContentDisplay(ContentDisplay.TOP);
        this.labelSelectButton.setToggleGroup(toggleGroup);
        topPane.getChildren().add((Object)this.labelSelectButton);
        this.labelDeselectButton.setStyle("-fx-font-size: 9px");
        this.labelDeselectButton.setTooltip(new Tooltip("De-selects the currently selected shape."));
        this.labelDeselectButton.setTextAlignment(TextAlignment.CENTER);
        this.labelDeselectButton.setTextOverrun(OverrunStyle.ELLIPSIS);
        this.labelDeselectButton.setContentDisplay(ContentDisplay.TOP);
        this.labelDeselectButton.setAlignment(Pos.BASELINE_RIGHT);
        topPane.getChildren().add((Object)this.labelDeselectButton);
        this.labelDeselectButton.setOnAction(event -> {
            this.mapUI().getCurrentObjects().clear();
            this.mapUI().hoverObject = null;
            this.mapUI().draw();
        });
        Label spacer2 = new Label("    ");
        topPane.getChildren().add((Object)spacer2);
        this.labelDeleteButton.setStyle("-fx-font-size: 9px");
        this.labelDeleteButton.setTooltip(new Tooltip("Deletes the selected features."));
        this.labelDeleteButton.setTextAlignment(TextAlignment.CENTER);
        this.labelDeleteButton.setTextOverrun(OverrunStyle.ELLIPSIS);
        this.labelDeleteButton.setContentDisplay(ContentDisplay.TOP);
        this.labelDeleteButton.setAlignment(Pos.CENTER_RIGHT);
        VBox deleteBox = new VBox(new Node[]{this.labelDeleteButton});
        deleteBox.setFillWidth(true);
        topPane.getChildren().add((Object)deleteBox);
        this.labelDeleteButton.setOnAction(event -> this.deleteLabel());
        labelsborderpane.setTop((Node)topPane);
        GridPane labelTFGrid = new GridPane();
        labelTFGrid.setHgap(5.0);
        labelTFGrid.setVgap(5.0);
        labelTFGrid.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        Label textlabel = new Label("Text:");
        labelTFGrid.add((Node)textlabel, 0, 1);
        this.textAlignmentComboBox.setOnAction(event -> {
            for (Object e : this.mapUI().getCurrentObjects()) {
                if (!(e instanceof MapLabel)) continue;
                this.mapUI().getController().updateLabelTextAlignment(undoEnabled, (MapLabel)e, (TextAlignment)this.textAlignmentComboBox.getSelectionModel().getSelectedItem());
                this.mapUI().draw();
            }
        });
        this.labelTA.setPrefRowCount(3);
        this.labelTA.setTooltip(new Tooltip("Enter the text of your label here."));
        this.labelTA.setPrefColumnCount(12);
        this.labelTA.textProperty().addListener((observable, oldValue, newValue) -> {
            for (Object e : this.mapUI().getCurrentObjects()) {
                if (!(e instanceof MapLabel)) continue;
                this.mapUI().getController().updateLabelText(undoEnabled, (MapLabel)e, (String)newValue);
                this.mapUI().draw();
            }
        });
        labelTFGrid.add((Node)this.labelTA, 0, 2, 2, 1);
        Label alignLabel = new Label("Align:");
        alignLabel.setTooltip(new Tooltip("Left, Center, or Right justify the text.  (Justify is not fully supported\nby the graphics library we use.)"));
        labelTFGrid.add((Node)alignLabel, 0, 3);
        labelTFGrid.add(this.textAlignmentComboBox, 1, 3);
        this.textAlignmentComboBox.setTooltip(new Tooltip("Left, Center, or Right justify the text.  (Justify is not fully supported\nby the graphics library we use.)"));
        Label labelRotateLabel = new Label("Rotate:");
        labelRotateLabel.setTooltip(new Tooltip("The selected feature will be rotated by the chosen number of degrees, clockwise."));
        labelTFGrid.add((Node)labelRotateLabel, 0, 4);
        this.labelRotateSpinner.setMaxWidth(80.0);
        this.labelRotateSpinner.setMinWidth(80.0);
        this.labelRotateSpinner.setTooltip(new Tooltip("The selected feature will be rotated by the chosen number of degrees, clockwise."));
        this.labelRotateSpinner.setEditable(true);
        labelTFGrid.add(this.labelRotateSpinner, 1, 4);
        this.labelRotateSpinner.valueProperty().addListener((observable, oldValue, newValue) -> {
            for (Object e : this.mapUI().getCurrentObjects()) {
                if (!(e instanceof MapLabel)) continue;
                this.mapUI().getController().updateLabelRotate(undoEnabled, (MapLabel)e, (double)newValue, ((MapLabel)e).getRotate());
                this.mapUI().draw();
            }
        });
        Label layerlabel = new Label("Layer:");
        layerlabel.setTooltip(new Tooltip("The selected label can be moved among the map's various layers. A map has several layers such\nas Labels, Grid, Features, Above Terrain, & more. Labels (and shapes and features) can actually be placed on any layer.\nSee the Layers drawer/toolbox to turn then on/off or reorder them."));
        labelTFGrid.add((Node)layerlabel, 0, 5);
        MapLayer labelslayer = this.mapUI().getMapData().getMapLayer("Labels");
        if (labelslayer == null) {
            labelslayer = this.mapUI().getMapData().getMapLayers().get(0);
        }
        this.labelsMapLayerCombo.getSelectionModel().select((Object)labelslayer);
        this.labelsMapLayerCombo.setTooltip(new Tooltip("The selected label can be moved among the map's various layers. A map has several layers such\nas Labels, Grid, Features, Above Terrain, & more. Labels (and shapes and features) can actually be placed on any layer.\nSee the Layers drawer/toolbox to turn then on/off or reorder them."));
        this.labelsMapLayerCombo.setMaxWidth(120.0);
        this.labelsMapLayerCombo.setOnAction(event -> {
            for (Object e : this.mapUI().getCurrentObjects()) {
                if (!(e instanceof MapLabel) || this.labelsMapLayerCombo.getSelectionModel().getSelectedItem() == null) continue;
                this.mapUI().getController().updateLabelLayer(undoEnabled, (MapLabel)e, (MapLayer)this.labelsMapLayerCombo.getSelectionModel().getSelectedItem());
                this.mapUI().draw();
            }
        });
        labelTFGrid.add(this.labelsMapLayerCombo, 1, 5);
        Label textstylelabel = new Label("Style:");
        textstylelabel.setTooltip(new Tooltip("Set the label to use a pre-set style with this drop-down box."));
        labelTFGrid.add((Node)textstylelabel, 0, 6);
        labelTFGrid.add(this.labelStyleCombo, 0, 7, 2, 1);
        this.labelStyleCombo.setTooltip(new Tooltip("Set the label to use a pre-set style with this drop-down box."));
        Button configureStyleButton = new Button("", (Node)new ImageView(this.worldographer.from("other_imgs/configure.png")));
        configureStyleButton.setOnAction(event -> {
            if (UserPrefs.FULL) {
                Stage stage = new Stage();
                ConfigureLabelStylesScreen ss = new ConfigureLabelStylesScreen(this.worldographer);
                ss.start(stage);
                stage.show();
            } else {
                StandardDialog.showDialog(this.worldographer.getPrimaryStage(), "Pro Feature", "Configuring label styles is only available if using a Pro version license.", "Sorry, some features are reserved for our Pro/paid version. If you find the software useful, considering unlocking these special features and supporting the many hours of work to create Worldographer with a Pro license. See www.worldographer.com for details.", null, "");
            }
        });
        configureStyleButton.setAlignment(Pos.CENTER_RIGHT);
        VBox csBox = new VBox(new Node[]{configureStyleButton});
        csBox.setAlignment(Pos.CENTER_RIGHT);
        csBox.setFillWidth(true);
        labelTFGrid.add((Node)csBox, 1, 6);
        this.labelStyleCombo.valueProperty().addListener((observable, oldValue, newValue) -> {
            for (Object e : this.mapUI().getCurrentObjects()) {
                if (!(e instanceof MapLabel)) continue;
                this.mapUI().getController().updateLabelStyle(undoEnabled, (MapLabel)e, (String)newValue);
                this.mapUI().draw();
            }
        });
        labelTFGrid.add((Node)this.labelGMOnlyCB, 0, 8, 2, 1);
        this.labelGMOnlyCB.setTooltip(new Tooltip("The selected label will be marked as 'GM Only'. So if the 'GM Only' checkbox on\nWorldographer's bottom toolbar is un-checked, the feature won't be shown."));
        Label tagslabel = new Label("Tags:");
        tagslabel.setTooltip(new Tooltip("The selected label will be marked with the tags in the textfield. These tags are used with\nthe 'Show Objs w/' and 'Hide Objs w/' fields in the controls below the map."));
        labelTFGrid.add((Node)tagslabel, 0, 9);
        this.labelTagsTF.setMaxWidth(160.0);
        this.labelTagsTF.setTooltip(new Tooltip("The selected feature will be marked with the tags in the textfield. These tags are used with\nthe 'Show Objs w/' and 'Hide Objs w/' fields in the controls below the map."));
        this.labelTagsTF.textProperty().addListener((observable, oldValue, newValue) -> {
            for (Object e : this.mapUI().getCurrentObjects()) {
                if (!(e instanceof MapLabel)) continue;
                this.mapUI().getController().updateLabelTags(undoEnabled, (MapLabel)e, (String)newValue);
                this.mapUI().draw();
            }
        });
        labelTFGrid.add((Node)this.labelTagsTF, 0, 10, 2, 1);
        GridPane labelLevelGrid = new GridPane();
        labelLevelGrid.setHgap(2.0);
        labelLevelGrid.setVgap(2.0);
        labelLevelGrid.setPadding(new Insets(2.0, 2.0, 2.0, 2.0));
        this.labelWorldCB.setSelected(true);
        this.labelWorldCB.setTooltip(new Tooltip("Toggles if the selected label should be shown on the World map level.\nNote: you can't toggle this off if it is the map level you're currently viewing."));
        this.labelWorldCB.setOnAction(event -> {
            for (MapObject mo : this.mapUI().getCurrentObjects()) {
                if (!(mo instanceof MapLabel)) continue;
                if (this.mapUI().viewLevel == ViewLevel.WORLD && !this.labelWorldCB.isSelected()) {
                    this.labelWorldCB.setSelected(true);
                    return;
                }
                this.mapUI().getController().updateLabelWorld(undoEnabled, (MapLabel)mo, this.labelWorldCB.isSelected());
                this.mapUI().draw();
            }
        });
        labelLevelGrid.add((Node)this.labelWorldCB, 0, 0);
        this.labelContinentCB.setSelected(true);
        this.labelContinentCB.setTooltip(new Tooltip("Toggles if the selected label should be shown on the Continent map level.\nNote: you can't toggle this off if it is the map level you're currently viewing."));
        this.labelContinentCB.setOnAction(event -> {
            for (MapObject mo : this.mapUI().getCurrentObjects()) {
                if (!(mo instanceof MapLabel)) continue;
                if (this.mapUI().viewLevel == ViewLevel.CONTINENT && !this.labelContinentCB.isSelected()) {
                    this.labelContinentCB.setSelected(true);
                    return;
                }
                this.mapUI().getController().updateLabelContinent(undoEnabled, (MapLabel)mo, this.labelContinentCB.isSelected());
                this.mapUI().draw();
            }
        });
        labelLevelGrid.add((Node)this.labelContinentCB, 1, 0);
        this.labelKingdomCB.setSelected(true);
        this.labelKingdomCB.setTooltip(new Tooltip("Toggles if the selected label should be shown on the Kingdom map level.\nNote: you can't toggle this off if it is the map level you're currently viewing."));
        this.labelKingdomCB.setOnAction(event -> {
            for (MapObject mo : this.mapUI().getCurrentObjects()) {
                if (!(mo instanceof MapLabel)) continue;
                if (this.mapUI().viewLevel == ViewLevel.KINGDOM && !this.labelKingdomCB.isSelected()) {
                    this.labelKingdomCB.setSelected(true);
                    return;
                }
                this.mapUI().getController().updateLabelKingdom(undoEnabled, (MapLabel)mo, this.labelKingdomCB.isSelected());
                this.mapUI().draw();
            }
        });
        labelLevelGrid.add((Node)this.labelKingdomCB, 0, 1);
        this.labelProvinceCB.setSelected(true);
        this.labelProvinceCB.setTooltip(new Tooltip("Toggles if the selected label should be shown on the Province map level.\nNote: you can't toggle this off if it is the map level you're currently viewing."));
        this.labelProvinceCB.setOnAction(event -> {
            for (MapObject mo : this.mapUI().getCurrentObjects()) {
                if (!(mo instanceof MapLabel)) continue;
                if (this.mapUI().viewLevel == ViewLevel.PROVINCE && !this.labelProvinceCB.isSelected()) {
                    this.labelProvinceCB.setSelected(true);
                    return;
                }
                this.mapUI().getController().updateLabelProvince(undoEnabled, (MapLabel)mo, this.labelProvinceCB.isSelected());
                this.mapUI().draw();
            }
        });
        labelLevelGrid.add((Node)this.labelProvinceCB, 1, 1);
        labelTFGrid.add((Node)labelLevelGrid, 0, 11, 2, 1);
        GridPane labelOptionsGrid = new GridPane();
        labelOptionsGrid.setHgap(5.0);
        labelOptionsGrid.setVgap(5.0);
        labelOptionsGrid.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        Label labelOptionsLabel = new Label("Custom Style Options");
        labelOptionsLabel.setStyle("-fx-font-weight: bold");
        labelOptionsGrid.add((Node)labelOptionsLabel, 0, 0, 2, 1);
        labelOptionsGrid.setMaxWidth(170.0);
        Label labelfontlabel = new Label("Label Font:");
        labelfontlabel.setTooltip(new Tooltip("Choose the font face of the label, if it doesn't have a pre-set style."));
        labelOptionsGrid.add((Node)labelfontlabel, 0, 1);
        this.labelFontCombo.setMaxWidth(120.0);
        this.labelFontCombo.setTooltip(new Tooltip("Choose the font face of the label, if it doesn't have a pre-set style."));
        labelOptionsGrid.add(this.labelFontCombo, 0, 2);
        this.labelFontCombo.valueProperty().addListener((observable, oldValue, newValue) -> {
            for (Object e : this.mapUI().getCurrentObjects()) {
                if (!(e instanceof MapLabel)) continue;
                this.mapUI().getController().updateLabelFontFace(undoEnabled, (MapLabel)e, (String)newValue);
                this.mapUI().draw();
            }
        });
        Label labelcolorlabel = new Label("Label Color:");
        labelcolorlabel.setTooltip(new Tooltip("Choose the font color of the label, if it doesn't have a pre-set style."));
        labelOptionsGrid.add((Node)labelcolorlabel, 0, 3);
        if (this.labelColorPicker.getCustomColors().size() <= 1) {
            this.labelColorPicker.getCustomColors().addAll((Object[])Worldographer.customColors);
        }
        this.labelColorPicker.setMaxWidth(120.0);
        this.labelColorPicker.setTooltip(new Tooltip("Choose the font color of the label, if it doesn't have a pre-set style."));
        labelOptionsGrid.add(this.labelColorPickerWSelector.getNode(), 0, 4);
        this.labelColorPicker.setOnAction(event -> {
            for (Object e : this.mapUI().getCurrentObjects()) {
                if (!(e instanceof MapLabel)) continue;
                this.mapUI().getController().updateLabelColor(undoEnabled, (MapLabel)e, (Color)this.labelColorPicker.getValue());
                this.mapUI().draw();
            }
        });
        Label labeloutlinesizelabel = new Label("Outline Size:");
        labeloutlinesizelabel.setTooltip(new Tooltip("Choose the width of an outline for the label, if it doesn't have a pre-set style."));
        labelOptionsGrid.add((Node)labeloutlinesizelabel, 0, 5);
        this.labelOutlineSizeSpinner.setMaxWidth(80.0);
        this.labelOutlineSizeSpinner.setTooltip(new Tooltip("Choose the width of an outline for the label, if it doesn't have a pre-set style."));
        labelOptionsGrid.add(this.labelOutlineSizeSpinner, 0, 6);
        this.labelOutlineSizeSpinner.valueProperty().addListener((observable, oldValue, newValue) -> {
            for (Object e : this.mapUI().getCurrentObjects()) {
                if (!(e instanceof MapLabel)) continue;
                this.mapUI().getController().updateLabelOutlineSize(undoEnabled, (MapLabel)e, (Double)newValue);
                this.mapUI().draw();
            }
        });
        Label labeloutlinecolorlabel = new Label("Outline Color:");
        labeloutlinecolorlabel.setTooltip(new Tooltip("Choose the color of an outline for the label, if it doesn't have a pre-set style."));
        labelOptionsGrid.add((Node)labeloutlinecolorlabel, 0, 7);
        if (this.labelOutlineColorBGCP.getCustomColors().size() <= 1) {
            this.labelOutlineColorBGCP.getCustomColors().addAll((Object[])Worldographer.customColors);
        }
        this.labelOutlineColorBGCP.setMaxWidth(120.0);
        this.labelOutlineColorBGCP.setTooltip(new Tooltip("Choose the color of an outline for the label, if it doesn't have a pre-set style."));
        labelOptionsGrid.add(this.labelOutlineColorPickerWSelector.getNode(), 0, 8);
        this.labelOutlineColorBGCP.setOnAction(event -> {
            for (Object e : this.mapUI().getCurrentObjects()) {
                if (!(e instanceof MapLabel)) continue;
                this.mapUI().getController().updateLabelOutlineColor(undoEnabled, (MapLabel)e, (Color)this.labelOutlineColorBGCP.getValue());
                this.mapUI().draw();
            }
        });
        Label labelScaleLabel = new Label("Size (tile ht%):");
        labelScaleLabel.setTooltip(new Tooltip("Choose the size (as a percentage of a tile's height) of an outline for the label,\nif it doesn't have a pre-set style."));
        labelOptionsGrid.add((Node)labelScaleLabel, 0, 9);
        this.labelScaleSpinner.setMaxWidth(80.0);
        this.labelScaleSpinner.setTooltip(new Tooltip("Choose the size (as a percentage of a tile's height) of an outline for the label,\nif it doesn't have a pre-set style."));
        labelOptionsGrid.add(this.labelScaleSpinner, 0, 10);
        this.labelScaleSpinner.setEditable(true);
        this.labelScaleSpinner.valueProperty().addListener((observable, oldValue, newValue) -> {
            for (Object e : this.mapUI().getCurrentObjects()) {
                if (!(e instanceof MapLabel)) continue;
                this.mapUI().getController().updateLabelScale(undoEnabled, (MapLabel)e, (Double)oldValue, (Double)newValue);
                this.mapUI().draw();
            }
        });
        labelOptionsGrid.add((Node)new Label("Style:"), 0, 11);
        HBox styleBox = new HBox();
        Font f = this.labelBoldCB.getFont();
        f = Font.font((String)f.getFamily(), (FontWeight)FontWeight.BOLD, (FontPosture)FontPosture.REGULAR, (double)f.getSize());
        this.labelBoldCB.setFont(f);
        this.labelBoldCB.setTooltip(new Tooltip("If checked the label will be bolded, if it doesn't have a pre-set style."));
        this.labelBoldCB.setOnAction(event -> {
            for (Object e : this.mapUI().getCurrentObjects()) {
                if (!(e instanceof MapLabel)) continue;
                this.mapUI().getController().updateLabelBold(undoEnabled, (MapLabel)e, this.labelBoldCB.isSelected());
                this.mapUI().draw();
            }
        });
        styleBox.getChildren().add((Object)this.labelBoldCB);
        f = this.labelItalicCB.getFont();
        f = Font.font((String)f.getFamily(), (FontWeight)FontWeight.NORMAL, (FontPosture)FontPosture.ITALIC, (double)f.getSize());
        this.labelItalicCB.setFont(f);
        this.labelItalicCB.setTooltip(new Tooltip("If checked the label will be in italics, if it doesn't have a pre-set style."));
        this.labelItalicCB.setOnAction(event -> {
            for (Object e : this.mapUI().getCurrentObjects()) {
                if (!(e instanceof MapLabel)) continue;
                this.mapUI().getController().updateLabelItalic(undoEnabled, (MapLabel)e, this.labelItalicCB.isSelected());
                this.mapUI().draw();
            }
        });
        styleBox.getChildren().add((Object)this.labelItalicCB);
        labelOptionsGrid.add((Node)styleBox, 0, 12);
        this.labelBackgroundCB.setOnAction(event -> {
            for (Object e : this.mapUI().getCurrentObjects()) {
                if (e instanceof MapLabel) {
                    if (this.labelBackgroundCB.isSelected()) {
                        this.mapUI().getController().updateLabelBackgroundColor(undoEnabled, (MapLabel)e, (Color)this.labelBackgroundCP.getValue());
                    } else {
                        this.mapUI().getController().updateLabelBackgroundColor(undoEnabled, (MapLabel)e, null);
                    }
                }
                this.mapUI().draw();
            }
        });
        this.labelBackgroundCB.setTooltip(new Tooltip("If checked and if the label doesn't have a pre-set style, it will have a background\nwith a color matching the color chosen with the adjacent color chooser."));
        labelOptionsGrid.add((Node)this.labelBackgroundCB, 0, 13);
        this.labelBackgroundCP.setMaxWidth(120.0);
        this.labelBackgroundCP.setTooltip(new Tooltip("If the adjacent checkbox is checked and the label doesn't have a pre-set style,\nthe selected color will be used for a background under the label."));
        this.labelBackgroundCP.setOnAction(event -> {
            for (Object e : this.mapUI().getCurrentObjects()) {
                if (!(e instanceof MapLabel)) continue;
                this.mapUI().getController().updateLabelBackgroundColor(undoEnabled, (MapLabel)e, (Color)this.labelBackgroundCP.getValue());
                this.mapUI().draw();
            }
        });
        labelOptionsGrid.add(this.labelBackgroundColorPickerWSelector.getNode(), 0, 14);
        SplitPane splitPane = new SplitPane();
        splitPane.setOrientation(Orientation.HORIZONTAL);
        splitPane.getItems().add((Object)new ScrollPane((Node)labelTFGrid));
        splitPane.getItems().add((Object)new ScrollPane((Node)labelOptionsGrid));
        labelsborderpane.setCenter((Node)splitPane);
        return labelsborderpane;
    }

    public BorderPane createLabelsDrawerOLD(ToggleGroup toggleGroup, FeaturesToolbox featuresToolbox, boolean undoEnabled) {
        BorderPane labelsborderpane = new BorderPane();
        GridPane labelTFGrid = new GridPane();
        labelTFGrid.setAlignment(Pos.TOP_CENTER);
        labelTFGrid.setHgap(5.0);
        labelTFGrid.setVgap(5.0);
        labelTFGrid.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        this.newLabelButton.setToggleGroup(toggleGroup);
        this.newLabelButton.setTooltip(new Tooltip("Select this then click on the map where you want your label centered.\nThe text in the text area below will appear there with the selected settings."));
        this.newLabelButton.setUserData((Object)new MapLabel("", "", (String)featuresToolbox.featuresLabelFontCombo.getSelectionModel().getSelectedItem(), (Color)featuresToolbox.featuresLabelColorCP.getValue(), 0.0, (Color)featuresToolbox.featuresLabelOutlineColorCP.getValue(), null, 0.0, false, false, false, false, false, false, false, TextAlignment.CENTER, "", null));
        labelTFGrid.add((Node)this.newLabelButton, 0, 0, 2, 1);
        Label textlabel = new Label("Text:");
        labelTFGrid.add((Node)textlabel, 0, 1);
        HBox alignbox = new HBox();
        alignbox.setAlignment(Pos.CENTER_RIGHT);
        Label alignLabel = new Label("Align:");
        alignLabel.setTooltip(new Tooltip("Left, Center, or Right justify the text.  (Justify is not fully supported\nby the graphics library we use.)"));
        alignbox.getChildren().add((Object)alignLabel);
        alignbox.getChildren().add(this.textAlignmentComboBox);
        this.textAlignmentComboBox.setTooltip(new Tooltip("Left, Center, or Right justify the text.  (Justify is not fully supported\nby the graphics library we use.)"));
        labelTFGrid.add((Node)alignbox, 1, 1);
        this.textAlignmentComboBox.setOnAction(event -> {
            for (MapObject mo : this.mapUI().getCurrentObjects()) {
                if (!(mo instanceof MapLabel)) continue;
                this.mapUI().getController().updateLabelTextAlignment(undoEnabled, (MapLabel)mo, (TextAlignment)this.textAlignmentComboBox.getSelectionModel().getSelectedItem());
                this.mapUI().draw();
            }
        });
        this.labelTA.setPrefRowCount(3);
        this.labelTA.setTooltip(new Tooltip("Enter the text of your label here."));
        this.labelTA.setPrefColumnCount(12);
        this.labelTA.textProperty().addListener((observable, oldValue, newValue) -> {
            for (MapObject mo : this.mapUI().getCurrentObjects()) {
                if (!(mo instanceof MapLabel)) continue;
                this.mapUI().getController().updateLabelText(undoEnabled, (MapLabel)mo, (String)newValue);
                this.mapUI().draw();
            }
        });
        labelTFGrid.add((Node)this.labelTA, 0, 2, 2, 1);
        Button configureStyleButton = new Button("", (Node)new ImageView(this.worldographer.from("other_imgs/configure.png")));
        configureStyleButton.setPadding(new Insets(1.0, 1.0, 1.0, 1.0));
        configureStyleButton.setOnAction(event -> {
            if (UserPrefs.FULL) {
                Stage stage = new Stage();
                ConfigureLabelStylesScreen ss = new ConfigureLabelStylesScreen(this.worldographer);
                ss.start(stage);
                stage.show();
            } else {
                StandardDialog.showDialog(this.worldographer.getPrimaryStage(), "Pro Feature", "Configuring label styles is only available if using a Pro version license.", "Sorry, some features are reserved for our Pro/paid version. If you find the software useful, considering unlocking these special features and supporting the many hours of work to create Worldographer with a Pro license. See www.worldographer.com for details.", null, "");
            }
        });
        Label labelRotateLabel = new Label("Rotate:");
        labelRotateLabel.setTooltip(new Tooltip("The selected feature will be rotated by the chosen number of degrees, clockwise."));
        labelTFGrid.add((Node)labelRotateLabel, 0, 3);
        this.labelRotateSpinner.setMaxWidth(80.0);
        this.labelRotateSpinner.setTooltip(new Tooltip("The selected feature will be rotated by the chosen number of degrees, clockwise."));
        this.labelRotateSpinner.setEditable(true);
        labelTFGrid.add(this.labelRotateSpinner, 0, 4);
        this.labelRotateSpinner.valueProperty().addListener((observable, oldValue, newValue) -> {
            for (MapObject mo : this.mapUI().getCurrentObjects()) {
                if (!(mo instanceof MapLabel)) continue;
                this.mapUI().getController().updateLabelRotate(undoEnabled, (MapLabel)mo, (double)newValue, ((MapLabel)mo).getRotate());
                this.mapUI().draw();
            }
        });
        Label layerlabel = new Label("Layer:");
        layerlabel.setTooltip(new Tooltip("The selected label can be moved among the map's various layers. A map has several layers such\nas Labels, Grid, Features, Above Terrain, & more. Labels (and shapes and features) can actually be placed on any layer.\nSee the Layers drawer/toolbox to turn then on/off or reorder them."));
        labelTFGrid.add((Node)layerlabel, 1, 3);
        MapLayer labelslayer = this.mapUI().getMapData().getMapLayer("Labels");
        if (labelslayer == null) {
            labelslayer = this.mapUI().getMapData().getMapLayers().get(0);
        }
        this.labelsMapLayerCombo.getSelectionModel().select((Object)labelslayer);
        this.labelsMapLayerCombo.setTooltip(new Tooltip("The selected label can be moved among the map's various layers. A map has several layers such\nas Labels, Grid, Features, Above Terrain, & more. Labels (and shapes and features) can actually be placed on any layer.\nSee the Layers drawer/toolbox to turn then on/off or reorder them."));
        this.labelsMapLayerCombo.setMaxWidth(120.0);
        this.labelsMapLayerCombo.setOnAction(event -> {
            for (MapObject mo : this.mapUI().getCurrentObjects()) {
                if (!(mo instanceof MapLabel) || this.labelsMapLayerCombo.getSelectionModel().getSelectedItem() == null) continue;
                this.mapUI().getController().updateLabelLayer(undoEnabled, (MapLabel)mo, (MapLayer)this.labelsMapLayerCombo.getSelectionModel().getSelectedItem());
                this.mapUI().draw();
            }
        });
        labelTFGrid.add(this.labelsMapLayerCombo, 1, 4);
        Label textstylelabel = new Label("Style:");
        textstylelabel.setTooltip(new Tooltip("Set the label to use a pre-set style with this drop-down box."));
        HBox box = new HBox();
        box.getChildren().add((Object)textstylelabel);
        box.getChildren().add(this.labelStyleCombo);
        this.labelStyleCombo.setTooltip(new Tooltip("Set the label to use a pre-set style with this drop-down box."));
        box.getChildren().add((Object)configureStyleButton);
        labelTFGrid.add((Node)box, 0, 6, 4, 1);
        this.labelStyleCombo.valueProperty().addListener((observable, oldValue, newValue) -> {
            for (MapObject mo : this.mapUI().getCurrentObjects()) {
                if (!(mo instanceof MapLabel)) continue;
                this.mapUI().getController().updateLabelStyle(undoEnabled, (MapLabel)mo, (String)newValue);
                this.mapUI().draw();
            }
        });
        labelTFGrid.add((Node)this.labelGMOnlyCB, 0, 7, 2, 1);
        this.labelGMOnlyCB.setTooltip(new Tooltip("The selected label will be marked as 'GM Only'. So if the 'GM Only' checkbox on\nWorldographer's bottom toolbar is un-checked, the feature won't be shown."));
        Label tagslabel = new Label("Tags:");
        tagslabel.setTooltip(new Tooltip("The selected label will be marked with the tags in the textfield. These tags are used with\nthe 'Show Objs w/' and 'Hide Objs w/' fields in the controls below the map."));
        labelTFGrid.add((Node)tagslabel, 0, 8, 2, 1);
        this.labelTagsTF.setMaxWidth(160.0);
        this.labelTagsTF.setTooltip(new Tooltip("The selected feature will be marked with the tags in the textfield. These tags are used with\nthe 'Show Objs w/' and 'Hide Objs w/' fields in the controls below the map."));
        this.labelTagsTF.textProperty().addListener((observable, oldValue, newValue) -> {
            for (MapObject mo : this.mapUI().getCurrentObjects()) {
                if (!(mo instanceof MapLabel)) continue;
                this.mapUI().getController().updateLabelTags(undoEnabled, (MapLabel)mo, (String)newValue);
                this.mapUI().draw();
            }
        });
        labelTFGrid.add((Node)this.labelTagsTF, 0, 9, 2, 1);
        GridPane labelLevelGrid = new GridPane();
        labelLevelGrid.setHgap(2.0);
        labelLevelGrid.setVgap(2.0);
        labelLevelGrid.setPadding(new Insets(2.0, 2.0, 2.0, 2.0));
        this.labelWorldCB.setSelected(true);
        this.labelWorldCB.setTooltip(new Tooltip("Toggles if the selected label should be shown on the World map level.\nNote: you can't toggle this off if it is the map level you're currently viewing."));
        this.labelWorldCB.setOnAction(event -> {
            for (MapObject mo : this.mapUI().getCurrentObjects()) {
                if (!(mo instanceof MapLabel)) continue;
                if (this.mapUI().viewLevel == ViewLevel.WORLD && !this.labelWorldCB.isSelected()) {
                    this.labelWorldCB.setSelected(true);
                    return;
                }
                this.mapUI().getController().updateLabelWorld(undoEnabled, (MapLabel)mo, this.labelWorldCB.isSelected());
                this.mapUI().draw();
            }
        });
        labelLevelGrid.add((Node)this.labelWorldCB, 0, 0);
        this.labelContinentCB.setSelected(true);
        this.labelContinentCB.setTooltip(new Tooltip("Toggles if the selected label should be shown on the Continent map level.\nNote: you can't toggle this off if it is the map level you're currently viewing."));
        this.labelContinentCB.setOnAction(event -> {
            for (MapObject mo : this.mapUI().getCurrentObjects()) {
                if (!(mo instanceof MapLabel)) continue;
                if (this.mapUI().viewLevel == ViewLevel.CONTINENT && !this.labelContinentCB.isSelected()) {
                    this.labelContinentCB.setSelected(true);
                    return;
                }
                this.mapUI().getController().updateLabelContinent(undoEnabled, (MapLabel)mo, this.labelContinentCB.isSelected());
                this.mapUI().draw();
            }
        });
        labelLevelGrid.add((Node)this.labelContinentCB, 1, 0);
        this.labelKingdomCB.setSelected(true);
        this.labelKingdomCB.setTooltip(new Tooltip("Toggles if the selected label should be shown on the Kingdom map level.\nNote: you can't toggle this off if it is the map level you're currently viewing."));
        this.labelKingdomCB.setOnAction(event -> {
            for (MapObject mo : this.mapUI().getCurrentObjects()) {
                if (!(mo instanceof MapLabel)) continue;
                if (this.mapUI().viewLevel == ViewLevel.KINGDOM && !this.labelKingdomCB.isSelected()) {
                    this.labelKingdomCB.setSelected(true);
                    return;
                }
                this.mapUI().getController().updateLabelKingdom(undoEnabled, (MapLabel)mo, this.labelKingdomCB.isSelected());
                this.mapUI().draw();
            }
        });
        labelLevelGrid.add((Node)this.labelKingdomCB, 0, 1);
        this.labelProvinceCB.setSelected(true);
        this.labelProvinceCB.setTooltip(new Tooltip("Toggles if the selected label should be shown on the Province map level.\nNote: you can't toggle this off if it is the map level you're currently viewing."));
        this.labelProvinceCB.setOnAction(event -> {
            for (MapObject mo : this.mapUI().getCurrentObjects()) {
                if (!(mo instanceof MapLabel)) continue;
                if (this.mapUI().viewLevel == ViewLevel.PROVINCE && !this.labelProvinceCB.isSelected()) {
                    this.labelProvinceCB.setSelected(true);
                    return;
                }
                this.mapUI().getController().updateLabelProvince(undoEnabled, (MapLabel)mo, this.labelProvinceCB.isSelected());
                this.mapUI().draw();
            }
        });
        labelLevelGrid.add((Node)this.labelProvinceCB, 1, 1);
        Label sflabel = new Label("Level Change Scale: ");
        sflabel.setTooltip(new Tooltip("Controls how much a label's size should be scaled when switching map levels\n(World/Continent/Kingdom/Province) for World/Region maps. If the change between\nlevels is 500% (5 hexes across in a child map per hex in the parent) and this is set\nto 100%, then the stroke/border will be 500% larger, but if 0%, it will be no larger\nand if set to 50% it will be 250% (50% of the 500%). Usually it is best to leave it 0%."));
        HBox sfbox = new HBox();
        sfbox.getChildren().add((Object)sflabel);
        sfbox.getChildren().add(this.labelScaleFactorSpinner);
        this.labelScaleFactorSpinner.setMaxWidth(70.0);
        this.labelScaleFactorSpinner.setTooltip(new Tooltip("Controls how much a label's size should be scaled when switching map levels\n(World/Continent/Kingdom/Province) for World/Region maps. If the change between\nlevels is 500% (5 hexes across in a child map per hex in the parent) and this is set\nto 100%, then the stroke/border will be 500% larger, but if 0%, it will be no larger\nand if set to 50% it will be 250% (50% of the 500%). Usually it is best to leave it 0%."));
        sfbox.getChildren().add((Object)new Label("%"));
        this.labelScaleFactorSpinner.valueProperty().addListener((observable, oldValue, newValue) -> {
            UndoActionGroup uag = new UndoActionGroup();
            for (MapObject mo : this.mapUI().getCurrentObjects()) {
                if (!(mo instanceof MapLabel)) continue;
                MapLabel ml = (MapLabel)mo;
                this.mapUI().getController().updateLabelScaleFactor(undoEnabled, ml, (Double)newValue, this.mapUI().viewLevel, uag);
            }
            this.mapUI().getController().getUndoRedoHandler().push(uag);
            this.mapUI().draw();
        });
        labelLevelGrid.add((Node)sfbox, 0, 2, 2, 1);
        labelTFGrid.add((Node)labelLevelGrid, 0, 10, 2, 1);
        labelsborderpane.setCenter((Node)labelTFGrid);
        GridPane labelOptionsGrid = new GridPane();
        labelOptionsGrid.setHgap(5.0);
        labelOptionsGrid.setVgap(5.0);
        labelOptionsGrid.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        BorderPane topborderpane = new BorderPane();
        HBox topbox = new HBox();
        this.labelSelectButton.setStyle("-fx-font-size: 9px");
        this.labelSelectButton.setTooltip(new Tooltip("Click this, then click a label on the map to update all the settings on this panel\nto match that label. Also when selected, move it, rotate it, or change any of the\nsettings below. Control-click to select multiple labels--this lets you move several\nat once & a setting change on this panel will apply to all of them."));
        this.labelSelectButton.setTextAlignment(TextAlignment.CENTER);
        this.labelSelectButton.setTextOverrun(OverrunStyle.ELLIPSIS);
        this.labelSelectButton.setContentDisplay(ContentDisplay.TOP);
        this.labelSelectButton.setToggleGroup(toggleGroup);
        topbox.getChildren().add((Object)this.labelSelectButton);
        this.labelDeselectButton.setStyle("-fx-font-size: 9px");
        this.labelDeselectButton.setTooltip(new Tooltip("De-selects the currently selected shape."));
        this.labelDeselectButton.setTextAlignment(TextAlignment.CENTER);
        this.labelDeselectButton.setTextOverrun(OverrunStyle.ELLIPSIS);
        this.labelDeselectButton.setContentDisplay(ContentDisplay.TOP);
        this.labelDeselectButton.setAlignment(Pos.BASELINE_RIGHT);
        topbox.getChildren().add((Object)this.labelDeselectButton);
        this.labelDeselectButton.setOnAction(event -> {
            this.mapUI().getCurrentObjects().clear();
            this.mapUI().hoverObject = null;
            this.mapUI().draw();
        });
        Label spacer2 = new Label("    ");
        topbox.getChildren().add((Object)spacer2);
        this.labelDeleteButton.setStyle("-fx-font-size: 9px");
        this.labelDeleteButton.setTooltip(new Tooltip("Deletes the selected features."));
        this.labelDeleteButton.setTextAlignment(TextAlignment.CENTER);
        this.labelDeleteButton.setTextOverrun(OverrunStyle.ELLIPSIS);
        this.labelDeleteButton.setContentDisplay(ContentDisplay.TOP);
        topbox.getChildren().add((Object)this.labelDeleteButton);
        this.labelDeleteButton.setOnAction(event -> this.deleteLabel());
        topborderpane.setRight((Node)topbox);
        labelOptionsGrid.add((Node)topborderpane, 0, 0, 3, 1);
        Label labelOptionsLabel = new Label("Custom Style Options:");
        labelOptionsLabel.setStyle("-fx-font-weight: bold");
        labelOptionsGrid.add((Node)labelOptionsLabel, 0, 1, 3, 1);
        Label labelfontlabel = new Label("Label Font:");
        labelfontlabel.setTooltip(new Tooltip("Choose the font face of the label, if it doesn't have a pre-set style."));
        labelOptionsGrid.add((Node)labelfontlabel, 0, 2, 3, 1);
        this.labelFontCombo.setMaxWidth(200.0);
        this.labelFontCombo.setTooltip(new Tooltip("Choose the font face of the label, if it doesn't have a pre-set style."));
        labelOptionsGrid.add(this.labelFontCombo, 0, 3, 3, 1);
        this.labelFontCombo.valueProperty().addListener((observable, oldValue, newValue) -> {
            for (MapObject mo : this.mapUI().getCurrentObjects()) {
                if (!(mo instanceof MapLabel)) continue;
                this.mapUI().getController().updateLabelFontFace(undoEnabled, (MapLabel)mo, (String)newValue);
                this.mapUI().draw();
            }
        });
        Label labelcolorlabel = new Label("Label Color:");
        labelcolorlabel.setTooltip(new Tooltip("Choose the font color of the label, if it doesn't have a pre-set style."));
        labelOptionsGrid.add((Node)labelcolorlabel, 0, 4);
        if (this.labelColorPicker.getCustomColors().size() <= 1) {
            this.labelColorPicker.getCustomColors().addAll((Object[])Worldographer.customColors);
        }
        this.labelColorPicker.setMaxWidth(120.0);
        this.labelColorPicker.setTooltip(new Tooltip("Choose the font color of the label, if it doesn't have a pre-set style."));
        labelOptionsGrid.add((Node)this.labelColorPicker, 1, 4, 2, 1);
        this.labelColorPicker.setOnAction(event -> {
            for (MapObject mo : this.mapUI().getCurrentObjects()) {
                if (!(mo instanceof MapLabel)) continue;
                this.mapUI().getController().updateLabelColor(undoEnabled, (MapLabel)mo, (Color)this.labelColorPicker.getValue());
                this.mapUI().draw();
            }
        });
        Label labeloutlinesizelabel = new Label("Outline Size:");
        labeloutlinesizelabel.setTooltip(new Tooltip("Choose the width of an outline for the label, if it doesn't have a pre-set style."));
        labelOptionsGrid.add((Node)labeloutlinesizelabel, 0, 6);
        this.labelOutlineSizeSpinner.setMaxWidth(60.0);
        this.labelOutlineSizeSpinner.setTooltip(new Tooltip("Choose the width of an outline for the label, if it doesn't have a pre-set style."));
        labelOptionsGrid.add(this.labelOutlineSizeSpinner, 1, 6);
        this.labelOutlineSizeSpinner.valueProperty().addListener((observable, oldValue, newValue) -> {
            for (MapObject mo : this.mapUI().getCurrentObjects()) {
                if (!(mo instanceof MapLabel)) continue;
                this.mapUI().getController().updateLabelOutlineSize(undoEnabled, (MapLabel)mo, (Double)newValue);
                this.mapUI().draw();
            }
        });
        Label labeloutlinecolorlabel = new Label("Outline Color:");
        labeloutlinecolorlabel.setTooltip(new Tooltip("Choose the color of an outline for the label, if it doesn't have a pre-set style."));
        labelOptionsGrid.add((Node)labeloutlinecolorlabel, 0, 7);
        if (this.labelOutlineColorBGCP.getCustomColors().size() <= 1) {
            this.labelOutlineColorBGCP.getCustomColors().addAll((Object[])Worldographer.customColors);
        }
        this.labelOutlineColorBGCP.setMaxWidth(120.0);
        this.labelOutlineColorBGCP.setTooltip(new Tooltip("Choose the color of an outline for the label, if it doesn't have a pre-set style."));
        labelOptionsGrid.add((Node)this.labelOutlineColorBGCP, 1, 7);
        this.labelOutlineColorBGCP.setOnAction(event -> {
            for (MapObject mo : this.mapUI().getCurrentObjects()) {
                if (!(mo instanceof MapLabel)) continue;
                this.mapUI().getController().updateLabelOutlineColor(undoEnabled, (MapLabel)mo, (Color)this.labelOutlineColorBGCP.getValue());
                this.mapUI().draw();
            }
        });
        Label labelScaleLabel = new Label("Size (tile ht%):");
        labelScaleLabel.setTooltip(new Tooltip("Choose the size (as a percentage of a tile's height) of an outline for the label,\nif it doesn't have a pre-set style."));
        labelOptionsGrid.add((Node)labelScaleLabel, 0, 8);
        this.labelScaleSpinner.setMaxWidth(60.0);
        this.labelScaleSpinner.setTooltip(new Tooltip("Choose the size (as a percentage of a tile's height) of an outline for the label,\nif it doesn't have a pre-set style."));
        labelOptionsGrid.add(this.labelScaleSpinner, 1, 8, 2, 1);
        this.labelScaleSpinner.setEditable(true);
        this.labelScaleSpinner.valueProperty().addListener((observable, oldValue, newValue) -> {
            for (MapObject mo : this.mapUI().getCurrentObjects()) {
                if (!(mo instanceof MapLabel)) continue;
                this.mapUI().getController().updateLabelScale(undoEnabled, (MapLabel)mo, (Double)oldValue, (Double)newValue);
                this.mapUI().draw();
            }
        });
        Font f = this.labelBoldCB.getFont();
        f = Font.font((String)f.getFamily(), (FontWeight)FontWeight.BOLD, (FontPosture)FontPosture.REGULAR, (double)f.getSize());
        this.labelBoldCB.setFont(f);
        this.labelBoldCB.setTooltip(new Tooltip("If checked the label will be bolded, if it doesn't have a pre-set style."));
        this.labelBoldCB.setOnAction(event -> {
            for (MapObject mo : this.mapUI().getCurrentObjects()) {
                if (!(mo instanceof MapLabel)) continue;
                this.mapUI().getController().updateLabelBold(undoEnabled, (MapLabel)mo, this.labelBoldCB.isSelected());
                this.mapUI().draw();
            }
        });
        labelOptionsGrid.add((Node)this.labelBoldCB, 0, 9);
        f = this.labelItalicCB.getFont();
        f = Font.font((String)f.getFamily(), (FontWeight)FontWeight.NORMAL, (FontPosture)FontPosture.ITALIC, (double)f.getSize());
        this.labelItalicCB.setFont(f);
        this.labelItalicCB.setTooltip(new Tooltip("If checked the label will be in italics, if it doesn't have a pre-set style."));
        this.labelItalicCB.setOnAction(event -> {
            for (MapObject mo : this.mapUI().getCurrentObjects()) {
                if (!(mo instanceof MapLabel)) continue;
                this.mapUI().getController().updateLabelItalic(undoEnabled, (MapLabel)mo, this.labelItalicCB.isSelected());
                this.mapUI().draw();
            }
        });
        labelOptionsGrid.add((Node)this.labelItalicCB, 1, 9);
        this.labelBackgroundCB.setOnAction(event -> {
            for (MapObject mo : this.mapUI().getCurrentObjects()) {
                if (mo instanceof MapLabel) {
                    if (this.labelBackgroundCB.isSelected()) {
                        this.mapUI().getController().updateLabelBackgroundColor(undoEnabled, (MapLabel)mo, (Color)this.labelBackgroundCP.getValue());
                    } else {
                        this.mapUI().getController().updateLabelBackgroundColor(undoEnabled, (MapLabel)mo, null);
                    }
                }
                this.mapUI().draw();
            }
        });
        this.labelBackgroundCB.setTooltip(new Tooltip("If checked and if the label doesn't have a pre-set style, it will have a background\nwith a color matching the color chosen with the adjacent color chooser."));
        labelOptionsGrid.add((Node)this.labelBackgroundCB, 0, 10);
        this.labelBackgroundCP.setMaxWidth(120.0);
        this.labelBackgroundCP.setTooltip(new Tooltip("If the adjacent checkbox is checked and the label doesn't have a pre-set style,\nthe selected color will be used for a background under the label."));
        this.labelBackgroundCP.setOnAction(event -> {
            for (MapObject mo : this.mapUI().getCurrentObjects()) {
                if (!(mo instanceof MapLabel)) continue;
                this.mapUI().getController().updateLabelBackgroundColor(undoEnabled, (MapLabel)mo, (Color)this.labelBackgroundCP.getValue());
                this.mapUI().draw();
            }
        });
        labelOptionsGrid.add((Node)this.labelBackgroundCP, 1, 10);
        labelsborderpane.setRight((Node)labelOptionsGrid);
        return labelsborderpane;
    }

    public void deleteLabel() {
        for (MapObject mo : this.mapUI().getCurrentObjects()) {
            if (!(mo instanceof MapLabel)) continue;
            this.mapUI().getController().deleteLabel((MapLabel)mo);
            this.mapUI().hoverObject = null;
            this.mapUI().draw();
        }
    }

    public void updateTextStylesList() {
        if (this.labelStyleCombo == null) {
            return;
        }
        this.textStyles.clear();
        this.textStyles.add("Use Custom Style");
        this.textStyles.addAll(Worldographer.getMapUI().getMapData().getLabelStyles().keySet());
        for (String s2 : Worldographer.getMapUI().getMapData().getLabelStyles().keySet()) {
            if (this.labelStyleCombo.getItems().contains((Object)s2)) continue;
            this.labelStyleCombo.getItems().add((Object)s2);
        }
        this.labelStyleCombo.getItems().removeIf(s -> !Worldographer.getMapUI().getMapData().getLabelStyles().containsKey(s) && !"Use Custom Style".equals(s));
        if (this.mapUI() != null) {
            this.mapUI().draw();
        }
    }

    public MapLabel makeMapLabel(MouseEvent t) {
        Color backgroundColor = this.labelBackgroundCB.isSelected() ? (Color)this.labelBackgroundCP.getValue() : null;
        MapLabel ml = new MapLabel((String)this.labelStyleCombo.getSelectionModel().getSelectedItem(), this.labelTA.getText(), (String)this.labelFontCombo.getSelectionModel().getSelectedItem(), (Color)this.labelColorPicker.getValue(), (Double)this.labelOutlineSizeSpinner.getValue(), (Color)this.labelOutlineColorBGCP.getValue(), backgroundColor, (Double)this.labelRotateSpinner.getValue(), this.labelWorldCB.isSelected(), this.labelContinentCB.isSelected(), this.labelKingdomCB.isSelected(), this.labelProvinceCB.isSelected(), this.labelBoldCB.isSelected(), this.labelItalicCB.isSelected(), this.labelGMOnlyCB.isSelected(), (TextAlignment)this.textAlignmentComboBox.getValue(), this.labelTagsTF.getText(), (MapLayer)this.labelsMapLayerCombo.getSelectionModel().getSelectedItem());
        Pair pair = new Pair((Object)this.mapUI().getModelCoordsFromScreenPt(t.getX(), t.getY()), (Object)((Double)this.labelScaleSpinner.getValue()));
        ml.setLocationAndScale(this.mapUI().getViewLevel(), (Pair<Point2D, Double>)pair);
        return ml;
    }

    public void placeMapLabel(MouseEvent t, MapLabel o) {
        if (o != null) {
            Color backgroundcolor = this.labelBackgroundCB.isSelected() ? (Color)this.labelBackgroundCP.getValue() : null;
            this.mapUI().getController().placeMapLabel(this.mapUI().viewLevel, (String)this.labelStyleCombo.getSelectionModel().getSelectedItem(), this.labelTA.getText(), (String)this.labelFontCombo.getSelectionModel().getSelectedItem(), (Color)this.labelColorPicker.getValue(), (Double)this.labelOutlineSizeSpinner.getValue(), (Color)this.labelOutlineColorBGCP.getValue(), backgroundcolor, (Double)this.labelRotateSpinner.getValue(), this.labelWorldCB.isSelected(), this.labelContinentCB.isSelected(), this.labelKingdomCB.isSelected(), this.labelProvinceCB.isSelected(), this.labelBoldCB.isSelected(), this.labelItalicCB.isSelected(), this.labelGMOnlyCB.isSelected(), (TextAlignment)this.textAlignmentComboBox.getValue(), 1.0, this.labelTagsTF.getText(), (MapLayer)this.labelsMapLayerCombo.getSelectionModel().getSelectedItem(), this.mapUI().getModelCoordsFromScreenPt(t.getX(), t.getY()), (Double)this.labelScaleSpinner.getValue());
            this.mapUI().draw();
            System.out.println("placeMapLabel:");
        }
    }
}

