/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.ui.toolbox;

import com.inkwellideas.ographer.data.ViewLevel;
import com.inkwellideas.ographer.map.MapProjection;
import com.inkwellideas.ographer.ui.Worldographer;
import com.inkwellideas.ographer.ui.toolbox.Toolbox;
import javafx.application.Platform;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.text.TextAlignment;
import org.kordamp.ikonli.javafx.FontIcon;

public class MiniMapToolbox
extends Toolbox {
    public ToggleButton panButton;
    public CheckBox preserveAspectCB;

    public MiniMapToolbox(Worldographer worldographer) {
        super(worldographer);
    }

    @Override
    public void setup(ToggleButton toggleButton) {
        MiniMapToolbox miniMapToolbox = this;
        this.createToolbox("Mini Map", "other_imgs/minimap_24.png", (Node)this.createMiniMap(miniMapToolbox.worldographer.getMapUI().getViewLevel()), 530, 300, true);
        this.stage.show();
        this.stage.setOnCloseRequest(event -> toggleButton.setSelected(false));
    }

    public VBox createMiniMap(ViewLevel initialvl) {
        GridPane grid = new GridPane();
        grid.setHgap(5.0);
        grid.setVgap(5.0);
        grid.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        grid.setPadding(new Insets(3.0));
        if (this.worldographer.viewLevelBox.overviewLabel == null) {
            this.worldographer.viewLevelBox.updateViewLevelBox(initialvl);
            this.worldographer.viewLevelBox.overviewLabel = new Label();
            Thread th = new Thread(() -> {
                while (true) {
                    try {
                        while (true) {
                            Thread.sleep(20000L);
                            Platform.runLater(() -> this.worldographer.viewLevelBox.updateOverviewLabel(false));
                        }
                    }
                    catch (Exception exception) {
                        continue;
                    }
                    break;
                }
            });
            th.start();
        }
        this.worldographer.viewLevelBox.overviewLabel.setMinSize(200.0, 200.0);
        this.worldographer.viewLevelBox.overviewLabel.setMaxSize(500.0, 200.0);
        this.worldographer.viewLevelBox.overviewLabel.addEventHandler(MouseEvent.MOUSE_DRAGGED, event -> {
            MiniMapToolbox miniMapToolbox = this;
            double basew = miniMapToolbox.worldographer.getMapUI().computeTotalMapWidthPixelsBaseTileSize();
            MiniMapToolbox miniMapToolbox2 = this;
            double basev = miniMapToolbox2.worldographer.getMapUI().computeTotalMapHeightPixelsBaseTileSize();
            MiniMapToolbox miniMapToolbox3 = this;
            MiniMapToolbox miniMapToolbox4 = this;
            MiniMapToolbox miniMapToolbox5 = this;
            miniMapToolbox3.worldographer.getMapUI().hScrollBar.setValue(event.getX() / this.worldographer.viewLevelBox.overviewLabel.getWidth() * basew - miniMapToolbox4.worldographer.getMapUI().canvas.getWidth() / 2.0 * 300.0 / miniMapToolbox5.worldographer.getMapUI().getMapData().getTileWidth());
            MiniMapToolbox miniMapToolbox6 = this;
            MiniMapToolbox miniMapToolbox7 = this;
            MiniMapToolbox miniMapToolbox8 = this;
            miniMapToolbox6.worldographer.getMapUI().vScrollBar.setValue(event.getY() / this.worldographer.viewLevelBox.overviewLabel.getHeight() * basev - miniMapToolbox7.worldographer.getMapUI().canvas.getHeight() / 2.0 * 300.0 / miniMapToolbox8.worldographer.getMapUI().getMapData().getTileHeight());
            MiniMapToolbox miniMapToolbox9 = this;
            miniMapToolbox9.worldographer.getMapUI().canvas.draw();
            this.worldographer.viewLevelBox.updateOverviewLabel(true);
        });
        MiniMapToolbox miniMapToolbox = this;
        miniMapToolbox.worldographer.getMapUI().hScrollBar.valueProperty().addListener((observable, oldValue, newValue) -> this.worldographer.viewLevelBox.updateOverviewLabel(true));
        MiniMapToolbox miniMapToolbox2 = this;
        miniMapToolbox2.worldographer.getMapUI().vScrollBar.valueProperty().addListener((observable, oldValue, newValue) -> this.worldographer.viewLevelBox.updateOverviewLabel(true));
        grid.add((Node)this.worldographer.viewLevelBox.overviewLabel, 0, 0, 1, 7);
        HBox panRefreshBox = new HBox();
        panRefreshBox.setAlignment(Pos.CENTER);
        panRefreshBox.getChildren().add((Object)this.panButton);
        Button refreshOverviewButton = new Button("");
        FontIcon refreshIcon = new FontIcon();
        refreshIcon.setStyle("-fx-icon-code:mdi2r-refresh;-fx-icon-size:24;");
        refreshOverviewButton.setGraphic((Node)refreshIcon);
        refreshOverviewButton.setTooltip(new Tooltip("By default the mini-map updates every 20 seconds. Click this to force it to update."));
        refreshOverviewButton.setTextAlignment(TextAlignment.CENTER);
        refreshOverviewButton.setOnAction(event -> this.worldographer.viewLevelBox.updateOverviewLabel(false));
        panRefreshBox.getChildren().add((Object)refreshOverviewButton);
        HBox zoomBox = new HBox();
        zoomBox.setAlignment(Pos.CENTER);
        Button zoominbutton = new Button("");
        FontIcon zoomIcon = new FontIcon();
        zoomIcon.setStyle("-fx-icon-code:mdi2m-magnify-plus;-fx-icon-size:24;");
        zoominbutton.setGraphic((Node)zoomIcon);
        zoominbutton.setTooltip(new Tooltip("Zooms the map in by making the tiles/hexes larger."));
        zoominbutton.setOnAction(event -> {
            MiniMapToolbox miniMapToolbox = this;
            MiniMapToolbox miniMapToolbox2 = this;
            MiniMapToolbox miniMapToolbox3 = this;
            Point2D centerModelPt = miniMapToolbox.worldographer.getMapUI().getModelCoordsFromScreenPt(miniMapToolbox2.worldographer.getMapUI().canvas.getWidth() / 2.0, miniMapToolbox3.worldographer.getMapUI().canvas.getHeight() / 2.0);
            this.worldographer.viewLevelBox.zoomIn(centerModelPt);
        });
        grid.add((Node)panRefreshBox, 1, 0, 2, 1);
        zoomBox.getChildren().add((Object)zoominbutton);
        Button zoomoutbutton = new Button("");
        FontIcon zoomOutIcon = new FontIcon();
        zoomOutIcon.setStyle("-fx-icon-code:mdi2m-magnify-minus;-fx-icon-size:24;");
        zoomoutbutton.setGraphic((Node)zoomOutIcon);
        zoomoutbutton.setTooltip(new Tooltip("Zooms the map out by making the tiles/hexes smaller."));
        zoomoutbutton.setOnAction(event -> {
            MiniMapToolbox miniMapToolbox = this;
            MiniMapToolbox miniMapToolbox2 = this;
            MiniMapToolbox miniMapToolbox3 = this;
            Point2D centerModelPt = miniMapToolbox.worldographer.getMapUI().getModelCoordsFromScreenPt(miniMapToolbox2.worldographer.getMapUI().canvas.getWidth() / 2.0, miniMapToolbox3.worldographer.getMapUI().canvas.getHeight() / 2.0);
            this.worldographer.viewLevelBox.zoomOut(centerModelPt);
        });
        zoomBox.getChildren().add((Object)zoomoutbutton);
        grid.add((Node)zoomBox, 1, 1, 2, 1);
        Label widthLabel = new Label("Tile Width:");
        widthLabel.setMinWidth(75.0);
        widthLabel.setTooltip(new Tooltip("Changes the width in pixels of the tiles/hexes. If Preserve Aspect Ratio is checked\nthe height spinner will also change proportionally."));
        grid.add((Node)widthLabel, 1, 2);
        this.worldographer.viewLevelBox.tileWidthSpinner.setMinWidth(85.0);
        grid.add(this.worldographer.viewLevelBox.tileWidthSpinner, 2, 2);
        Label heightLabel = new Label("Tile Height:");
        heightLabel.setMinWidth(75.0);
        heightLabel.setTooltip(new Tooltip("Changes the height in pixels of the tiles/hexes. If Preserve Aspect Ratio is checked\nthe width spinner will also change proportionally."));
        grid.add((Node)heightLabel, 1, 3);
        this.worldographer.viewLevelBox.tileHeightSpinner.setMinWidth(85.0);
        grid.add(this.worldographer.viewLevelBox.tileHeightSpinner, 2, 3);
        this.preserveAspectCB.setSelected(true);
        this.preserveAspectCB.setTooltip(new Tooltip("If checked, changing the tile height or width will change the other proportionally."));
        grid.add((Node)this.preserveAspectCB, 1, 4, 2, 1);
        this.worldographer.viewLevelBox.levelbox = new GridPane();
        grid.add((Node)this.worldographer.viewLevelBox.levelbox, 1, 5, 2, 1);
        this.worldographer.viewLevelBox.updateViewLevelBox(initialvl);
        HBox maskbox = new HBox();
        maskbox.setAlignment(Pos.CENTER);
        MiniMapToolbox miniMapToolbox3 = this;
        this.worldographer.maskLabel.setVisible(miniMapToolbox3.worldographer.getMapUI().getMapData().getMapProjection() == MapProjection.ICOSAHEDRAL);
        MiniMapToolbox miniMapToolbox4 = this;
        this.worldographer.maskColorPicker.setVisible(miniMapToolbox4.worldographer.getMapUI().getMapData().getMapProjection() == MapProjection.ICOSAHEDRAL);
        this.worldographer.maskColorPicker.setOnAction(event -> {
            MiniMapToolbox miniMapToolbox = this;
            miniMapToolbox.worldographer.getMapUI().getMapData().setMaskColor((Color)this.worldographer.maskColorPicker.getValue());
            MiniMapToolbox miniMapToolbox2 = this;
            miniMapToolbox2.worldographer.getMapUI().draw();
        });
        maskbox.getChildren().add((Object)this.worldographer.maskLabel);
        maskbox.getChildren().add((Object)this.worldographer.maskColorPicker);
        grid.add((Node)maskbox, 1, 6, 2, 1);
        this.worldographer.rightControls = new VBox();
        this.worldographer.rightControls.getChildren().add((Object)grid);
        Thread th = new Thread(() -> {
            try {
                Thread.sleep(2000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Platform.runLater(() -> this.worldographer.viewLevelBox.updateOverviewLabel(false));
        });
        th.start();
        return this.worldographer.rightControls;
    }

    public void initMiniMapControls(ToggleGroup toggleGroup) {
        this.panButton = new ToggleButton("");
        FontIcon panIcon = new FontIcon();
        panIcon.setStyle("-fx-icon-code:mdi2p-pan;-fx-icon-size:24;");
        this.panButton.setGraphic((Node)panIcon);
        this.panButton.setTooltip(new Tooltip("When toggled on, you can click & drag the main map to move it around."));
        this.panButton.setTextAlignment(TextAlignment.CENTER);
        toggleGroup.getToggles().add((Object)this.panButton);
        this.preserveAspectCB = new CheckBox("Preserve Aspect");
    }

    public boolean preserveAspectCB() {
        return this.preserveAspectCB.isSelected();
    }
}

