/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.ui.toolbox;

import com.inkwellideas.ographer.data.MapLayer;
import com.inkwellideas.ographer.data.MapObject;
import com.inkwellideas.ographer.data.ViewLevel;
import com.inkwellideas.ographer.io.UserPrefs;
import com.inkwellideas.ographer.map.MapLogic;
import com.inkwellideas.ographer.map.ResourceType;
import com.inkwellideas.ographer.map.Terrain;
import com.inkwellideas.ographer.map.TerrainExtraInfo;
import com.inkwellideas.ographer.model.TerrainType;
import com.inkwellideas.ographer.ui.Worldographer;
import com.inkwellideas.ographer.ui.configure.ConfigureSingleTerrainScreen;
import com.inkwellideas.ographer.ui.dialog.ConfigurationDialog;
import com.inkwellideas.ographer.ui.toolbox.FeaturesToolbox;
import com.inkwellideas.ographer.ui.toolbox.Toolbox;
import com.inkwellideas.ographer.ui.widget.ColorPickerWithSelector;
import com.inkwellideas.ographer.ui.widget.FocusSpinner;
import com.inkwellideas.ographer.undo.Point;
import com.inkwellideas.ographer.undo.UndoActionGroup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.SnapshotParameters;
import javafx.scene.canvas.Canvas;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.OverrunStyle;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Spinner;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.input.ContextMenuEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.TextAlignment;
import javafx.scene.transform.Scale;
import javafx.scene.transform.Transform;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Pair;
import org.kordamp.ikonli.javafx.FontIcon;

public class TerrainToolbox
extends Toolbox {
    public final HashMap<String, ToggleButton> terrainButtons = new HashMap();
    private ToggleButton paintBucketTerrainToggle;
    private ToggleButton wideAreaTerrainToggle;
    private ToggleButton useSimilarNamedTerrainToggle;
    public ToggleButton shuffleTerrainToggle;
    public ToggleButton dynamicTerrainToggle;
    public ToggleButton terrainCoastlineButton;
    public ToggleButton terrainSelectButton;
    public Button terrainDeleteButton;
    public Spinner<Integer> terrainElevationSpinner;
    public CheckBox overrideColorCB;
    public ColorPicker overrideTerrainBGCP;
    private BorderPane terrainBorderPane;
    private List<Spinner<Integer>> terrainResourceSpinners;
    private CheckBox terrainGMOnlyCB;
    private CheckBox terrainOverrideValues;
    private CheckBox terrainIcyCB;
    public TextField filterTerrainTF;
    private GridPane terrainGrid;
    private FlowPane terrainFlowPane;
    private ScrollPane terrainButtonsScrollPane = new ScrollPane();
    public ComboBox<MapLayer> terrainMapLayerCombo;
    private Spinner<Integer> iconSizeSpinner;
    public ColorPickerWithSelector backgroundCPWSelector;
    public ObservableList<MapLayer> observableLayers = FXCollections.observableList(new ArrayList());
    FlowPane topBox = new FlowPane();
    FlowPane terrainOptionsPane;
    FlowPane terrainSettingsPane = new FlowPane();
    public ComboBox<String> terrainFilterComboBox;

    public TerrainToolbox(Worldographer worldographer) {
        super(worldographer);
    }

    @Override
    public void setup(ToggleButton toggleButton) {
        this.createToolbox("Terrain", "other_imgs/terrain_24.png", this.createTerrainDrawer(this.worldographer.undoEnabled), 400, 500, true);
        this.stage.show();
        this.stage.setOnCloseRequest(event -> toggleButton.setSelected(false));
    }

    public Node createTerrainDrawer(boolean undoEnabled) {
        this.terrainBorderPane = new BorderPane();
        this.topBox = new FlowPane();
        this.topBox.setPadding(new Insets(5.0, 0.0, 5.0, 0.0));
        this.topBox.setHgap(10.0);
        this.topBox.setVgap(5.0);
        HBox filterBox = this.createFilterBox();
        HBox terrainSelectBox = this.createSelectCoastConfigureBox();
        terrainSelectBox.setAlignment(Pos.CENTER_LEFT);
        this.topBox.getChildren().add((Object)filterBox);
        this.topBox.getChildren().add((Object)this.createSizeBox());
        this.topBox.getChildren().add((Object)terrainSelectBox);
        HBox bucketAndWideBox = this.createBucketAndWideBox();
        bucketAndWideBox.setAlignment(Pos.CENTER_RIGHT);
        this.topBox.getChildren().add((Object)bucketAndWideBox);
        this.topBox.getChildren().add((Object)this.useSimilarNamedTerrainToggle);
        this.topBox.getChildren().add((Object)this.shuffleTerrainToggle);
        this.topBox.getChildren().add((Object)this.dynamicTerrainToggle);
        this.topBox.getChildren().add((Object)this.terrainDeleteButton);
        this.terrainBorderPane.setTop((Node)this.topBox);
        this.updateTerrainButtonsFlow();
        this.terrainButtonsScrollPane.setContent((Node)this.terrainFlowPane);
        this.terrainButtonsScrollPane.setFitToWidth(true);
        this.terrainButtonsScrollPane.setMaxWidth(1000.0);
        this.terrainButtonsScrollPane.setPrefWidth(1000.0);
        this.terrainBorderPane.setCenter((Node)this.terrainButtonsScrollPane);
        Label terrainOptionsLabel = new Label("Options:");
        terrainOptionsLabel.setStyle("-fx-font-weight: bold");
        FlowPane bottomBox = new FlowPane();
        bottomBox.setHgap(5.0);
        bottomBox.setVgap(5.0);
        bottomBox.setPadding(new Insets(5.0, 0.0, 5.0, 0.0));
        this.terrainOptionsPane = new FlowPane();
        this.terrainOptionsPane.setHgap(5.0);
        this.terrainOptionsPane.getChildren().add((Object)this.terrainIcyCB);
        this.terrainIcyCB.setTooltip(new Tooltip("Check this box to change the selected LTerrain (or new LTerrain) to 'icy'.\nIf the LTerrain has a background it turns white."));
        this.terrainIcyCB.setOnAction(event -> {
            for (Object e : this.mapUI().getCurrentObjects()) {
                if (!(e instanceof Terrain)) continue;
                this.mapUI().getController().updateTerrainIcy(undoEnabled, (Terrain)e, this.terrainIcyCB.isSelected());
                this.mapUI().draw();
            }
        });
        this.terrainOptionsPane.getChildren().add((Object)this.terrainGMOnlyCB);
        Label layerLabel = new Label("Layer:");
        layerLabel.setTooltip(new Tooltip("The selected Terrain can be moved among the map's various layers. A map has several layers such\nas Labels, Grid, Features, Above Terrain, & more. Terrain (and features shapes and labels) can actually be placed on any layer.\nSee the Layers drawer/toolbox to turn then on/off or reorder them."));
        MapLayer terrainlayer = this.mapUI().getMapData().getMapLayer("Terrain Land");
        if (terrainlayer == null) {
            terrainlayer = this.mapUI().getMapData().getMapLayers().get(0);
        }
        this.terrainMapLayerCombo.getSelectionModel().select((Object)terrainlayer);
        this.terrainMapLayerCombo.setTooltip(new Tooltip("The selected Terrain can be moved among the map's various layers. A map has several layers such\nas Labels, Grid, Features, Above Terrain, & more. Terrain (and features shapes and labels) can actually be placed on any layer.\nSee the Layers drawer/toolbox to turn then on/off or reorder them."));
        this.terrainMapLayerCombo.setMaxWidth(120.0);
        this.terrainMapLayerCombo.setOnAction(event -> {
            if (this.terrainMapLayerCombo.getSelectionModel().getSelectedItem() != null) {
                for (Object e : this.mapUI().getCurrentObjects()) {
                    if (!(e instanceof Terrain)) continue;
                    Terrain t = (Terrain)e;
                    this.mapUI().getController().updateExtraTerrainMapLayer(undoEnabled, t, (MapLayer)this.terrainMapLayerCombo.getSelectionModel().getSelectedItem());
                    this.mapUI().draw();
                }
            }
        });
        HBox layerBox = new HBox(new Node[]{layerLabel, this.terrainMapLayerCombo});
        layerBox.setAlignment(Pos.CENTER);
        this.terrainOptionsPane.getChildren().add((Object)layerBox);
        this.terrainGMOnlyCB.setTooltip(new Tooltip("The selected LTerrain will be marked as 'GM Only'. So if the 'GM Only' checkbox on\nWorldographer's bottom toolbar is un-checked, the LTerrain won't be shown."));
        this.overrideColorCB.setOnAction(event -> {
            for (Object e : this.mapUI().getCurrentObjects()) {
                if (!(e instanceof Terrain)) continue;
                Color color = this.overrideColorCB.isSelected() ? (Color)this.overrideTerrainBGCP.getValue() : null;
                this.mapUI().getController().updateTerrainBackgroundColor(undoEnabled, (Terrain)e, color);
                this.mapUI().draw();
            }
        });
        this.overrideColorCB.setTooltip(new Tooltip("If checked, the selected LTerrain (or new LTerrain) will use the background color set\nby the adjacent color chooser."));
        this.overrideTerrainBGCP.setTooltip(new Tooltip("If the adjacent checkbox is selected, this sets the selected LTerrain's (or new LTerrain) \nbackground color to the selected color."));
        if (this.overrideTerrainBGCP.getCustomColors().size() <= 1) {
            this.overrideTerrainBGCP.getCustomColors().addAll((Object[])Worldographer.customColors);
        }
        this.overrideTerrainBGCP.setOnAction(event -> {
            for (Object e : this.mapUI().getCurrentObjects()) {
                if (!(e instanceof Terrain)) continue;
                Color color = this.overrideColorCB.isSelected() ? (Color)this.overrideTerrainBGCP.getValue() : null;
                this.mapUI().getController().updateTerrainBackgroundColor(undoEnabled, (Terrain)e, color);
                this.mapUI().draw();
            }
        });
        HBox bgColorBox = new HBox(new Node[]{this.overrideColorCB, this.backgroundCPWSelector.getNode()});
        bgColorBox.setAlignment(Pos.CENTER);
        this.terrainOptionsPane.getChildren().add((Object)bgColorBox);
        bottomBox.getChildren().add((Object)this.terrainOptionsPane);
        Label space = new Label(" ");
        space.setPrefWidth(30.0);
        space.setMaxWidth(30.0);
        space.setMaxHeight(2.0);
        bottomBox.getChildren().add((Object)space);
        this.terrainButtonsScrollPane.widthProperty().addListener((observable, oldBounds, bounds) -> {
            space.setPrefWidth((Double)bounds - this.terrainIcyCB.getWidth() - this.terrainGMOnlyCB.getWidth() - this.overrideColorCB.getWidth() - this.overrideTerrainBGCP.getWidth() - 100.0);
            space.setMaxWidth((Double)bounds - this.terrainIcyCB.getWidth() - this.terrainGMOnlyCB.getWidth() - this.overrideColorCB.getWidth() - this.overrideTerrainBGCP.getWidth() - 100.0);
            space.setMinWidth((Double)bounds - this.terrainIcyCB.getWidth() - this.terrainGMOnlyCB.getWidth() - this.overrideColorCB.getWidth() - this.overrideTerrainBGCP.getWidth() - 100.0);
        });
        this.terrainSettingsPane.setHgap(5.0);
        Label elevLabel = new Label("Elevation:");
        elevLabel.setAlignment(Pos.CENTER);
        bottomBox.getChildren().add((Object)elevLabel);
        this.terrainElevationSpinner.setEditable(true);
        this.terrainElevationSpinner.setMaxWidth(90.0);
        this.terrainElevationSpinner.setMaxHeight(14.0);
        this.terrainElevationSpinner.valueProperty().addListener((observable, oldValue, newValue) -> {
            for (Object e : this.mapUI().getCurrentObjects()) {
                if (!(e instanceof Terrain)) continue;
                this.mapUI().getController().updateTerrainElevation(undoEnabled, (Terrain)e, (int)newValue);
                this.mapUI().draw();
            }
        });
        HBox elevBox = new HBox(new Node[]{elevLabel, this.terrainElevationSpinner});
        elevBox.setAlignment(Pos.CENTER);
        bottomBox.getChildren().add((Object)elevBox);
        int index = 0;
        for (TerrainExtraInfo.ResourceType rt : TerrainExtraInfo.ResourceType.values()) {
            Label label = new Label(String.valueOf((Object)rt) + ":");
            label.setAlignment(Pos.CENTER);
            this.terrainResourceSpinners.get(index).setMaxWidth(75.0);
            this.terrainResourceSpinners.get(index).setMaxHeight(20.0);
            this.terrainResourceSpinners.get(index).setEditable(true);
            this.terrainResourceSpinners.get(index).valueProperty().addListener((observable, oldValue, newValue) -> {
                for (Object e : this.mapUI().getCurrentObjects()) {
                    if (!(e instanceof Terrain)) continue;
                    this.mapUI().getController().updateTerrainResource(undoEnabled, (Terrain)e, newValue.byteValue(), rt.value());
                    this.mapUI().draw();
                }
            });
            HBox abox = new HBox(new Node[]{label, (Node)this.terrainResourceSpinners.get(index)});
            abox.setAlignment(Pos.CENTER);
            bottomBox.getChildren().add((Object)abox);
            ++index;
        }
        this.terrainOverrideValues = new CheckBox("Use above resources for new Terrain");
        bottomBox.getChildren().add((Object)this.terrainOverrideValues);
        this.terrainBorderPane.setBottom((Node)bottomBox);
        this.terrainGrid.setHgap(5.0);
        this.terrainGrid.setVgap(5.0);
        this.terrainBorderPane.setPadding(new Insets(5.0));
        return this.terrainBorderPane;
    }

    public void clearTerrainButtons() {
        this.terrainButtons.clear();
    }

    public void updateTerrainButtonsFlow() {
        Object[] terraintypenames;
        int size = (Integer)this.iconSizeSpinner.getValue();
        if (this.terrainFlowPane == null) {
            return;
        }
        this.terrainFlowPane.getChildren().removeAll((Collection)this.terrainFlowPane.getChildren());
        this.terrainFlowPane.setHgap(4.0);
        this.terrainFlowPane.setVgap(4.0);
        String[] textToMatchArray = new String[]{};
        if (this.filterTerrainTF.getText() != null) {
            textToMatchArray = this.filterTerrainTF.getText().toLowerCase().split(" ");
        }
        for (Object o : terraintypenames = Terrain.terrainTypes.keySet().toArray()) {
            String typename = ((String)o).toLowerCase();
            Terrain t = new Terrain((String)o, true);
            boolean textMatches = true;
            for (String textFromFilter : textToMatchArray) {
                if (typename.contains(textFromFilter)) continue;
                textMatches = false;
                break;
            }
            if (this.filterTerrainTF.getText() != null && !textMatches) continue;
            String fave = "\t" + t.getTypeName() + "\t";
            if (!"All Terrain".equals(this.terrainFilterComboBox.getSelectionModel().getSelectedItem()) && (!"Favorites".equals(this.terrainFilterComboBox.getSelectionModel().getSelectedItem()) || !UserPrefs.FAVORITE_TERRAIN.contains(fave)) && !typename.toLowerCase(Locale.ROOT).contains(((String)this.terrainFilterComboBox.getSelectionModel().getSelectedItem()).toLowerCase(Locale.ROOT) + "/")) continue;
            ToggleButton button = this.terrainButtons.get(t.getTypeName() + ":" + size);
            if (button == null) {
                button = new ToggleButton();
                this.createTerrainButton(t, button, true, size);
                this.terrainButtons.put(t.getTypeName() + ":" + size, button);
                button.setOnContextMenuRequested(event1 -> this.setupTerrainButtonContextMenu((ContextMenuEvent)event1, fave, t.getTypeName()));
            }
            this.terrainFlowPane.getChildren().add((Object)button);
        }
        if (this.mapUI() != null) {
            this.mapUI().lastTerrainFilterCombo = (String)this.terrainFilterComboBox.getValue();
            this.mapUI().lastTerrainFilterText = this.filterTerrainTF.getText();
            this.mapUI().draw();
        }
    }

    private void setupTerrainButtonContextMenu(ContextMenuEvent event1, String fave, String typename) {
        MenuItem mitem;
        ContextMenu cm = new ContextMenu();
        MenuItem editMenuItem = new MenuItem("Configure");
        cm.getItems().add((Object)editMenuItem);
        editMenuItem.setOnAction(event -> {
            Stage stage = new Stage();
            ConfigureSingleTerrainScreen ss = new ConfigureSingleTerrainScreen(this.worldographer, typename);
            ss.start(stage);
            stage.show();
        });
        if (UserPrefs.FAVORITE_TERRAIN.contains(fave)) {
            mitem = new MenuItem("Remove From Favorites");
            mitem.setOnAction(event -> {
                int index = UserPrefs.FAVORITE_TERRAIN.indexOf(fave);
                if (index >= 0) {
                    UserPrefs.FAVORITE_TERRAIN = UserPrefs.FAVORITE_TERRAIN.substring(0, index) + UserPrefs.FAVORITE_TERRAIN.substring(index + fave.length());
                    UserPrefs.PREFS.put("favorites terrain", UserPrefs.FAVORITE_TERRAIN);
                    this.updateTerrainButtonsFlow();
                }
            });
        } else {
            mitem = new MenuItem("Add To Favorites");
            mitem.setOnAction(event -> {
                UserPrefs.FAVORITE_TERRAIN = UserPrefs.FAVORITE_TERRAIN + fave;
                UserPrefs.PREFS.put("favorites terrain", UserPrefs.FAVORITE_TERRAIN);
            });
        }
        cm.getItems().add((Object)mitem);
        cm.setAnchorX(event1.getScreenX());
        cm.setAnchorY(event1.getScreenY());
        cm.show((Window)this.worldographer.getPrimaryStage());
    }

    private HBox createBucketAndWideBox() {
        HBox bucketAndWideBox = new HBox();
        bucketAndWideBox.setAlignment(Pos.CENTER);
        bucketAndWideBox.getChildren().add((Object)this.paintBucketTerrainToggle);
        bucketAndWideBox.getChildren().add((Object)this.wideAreaTerrainToggle);
        return bucketAndWideBox;
    }

    private HBox createSelectCoastConfigureBox() {
        HBox terrainSelectBox = new HBox();
        terrainSelectBox.getChildren().add((Object)this.terrainSelectButton);
        terrainSelectBox.getChildren().add((Object)new Label(" "));
        terrainSelectBox.getChildren().add((Object)this.terrainCoastlineButton);
        Button configureTerrainButton = TerrainToolbox.makeButtonWithStyleIcon("Configure", "mdi2c-cog", 32, "-fx-font-size: 9px", "Configure Terrain\nOpens a dialog to configure LTerrain (change the icon, background, etc.)", 60, 72);
        configureTerrainButton.setOnAction(event -> new ConfigurationDialog().launchConfigureTerrain(this.worldographer));
        terrainSelectBox.getChildren().add((Object)configureTerrainButton);
        return terrainSelectBox;
    }

    private HBox createFilterBox() {
        HBox filterBox = new HBox();
        filterBox.setAlignment(Pos.CENTER);
        Label filterLabel = new Label("");
        FontIcon filterIcon = new FontIcon();
        filterIcon.setStyle("-fx-icon-code:mdi2f-filter;-fx-icon-size:32;");
        filterLabel.setGraphic((Node)filterIcon);
        filterLabel.setTooltip(new Tooltip("Filter Terrain items in the list by name."));
        filterBox.getChildren().add((Object)filterLabel);
        filterBox.getChildren().add((Object)this.filterTerrainTF);
        this.filterTerrainTF.setOnAction(event -> this.updateTerrainButtonsFlow());
        this.filterTerrainTF.setMaxWidth(100.0);
        this.filterTerrainTF.setTooltip(new Tooltip("Filter Terrain items in the list by name."));
        Label spacer = new Label(" ");
        filterBox.getChildren().add((Object)spacer);
        this.terrainFilterComboBox.getSelectionModel().select((Object)"All Terrain");
        this.terrainFilterComboBox.setTooltip(new Tooltip("Filter Terrain items in the list by type."));
        this.terrainFilterComboBox.setOnAction(event -> this.updateTerrainButtonsFlow());
        filterBox.getChildren().add(this.terrainFilterComboBox);
        return filterBox;
    }

    public HBox createSizeBox() {
        HBox sizeBox = new HBox();
        sizeBox.setAlignment(Pos.CENTER);
        Label sizeLabel = new Label("");
        FontIcon sizeIcon = new FontIcon();
        sizeIcon.setStyle("-fx-icon-code:mdi2i-image-size-select-small;-fx-icon-size:28;");
        sizeLabel.setGraphic((Node)sizeIcon);
        sizeLabel.setStyle("-fx-font-size: 9px");
        sizeLabel.setTextAlignment(TextAlignment.CENTER);
        sizeLabel.setTextOverrun(OverrunStyle.ELLIPSIS);
        sizeLabel.setContentDisplay(ContentDisplay.TOP);
        sizeLabel.setTooltip(new Tooltip("Change icon size."));
        sizeBox.getChildren().add((Object)sizeLabel);
        this.iconSizeSpinner.setTooltip(new Tooltip("Change icon size."));
        this.iconSizeSpinner.setMinWidth(70.0);
        this.iconSizeSpinner.setMaxWidth(70.0);
        this.iconSizeSpinner.setEditable(true);
        this.iconSizeSpinner.valueProperty().addListener((obs, oldValue, newValue) -> Platform.runLater(() -> this.updateTerrainButtonsFlow()));
        sizeBox.getChildren().add(this.iconSizeSpinner);
        return sizeBox;
    }

    public void setTerrainButtonImage(Terrain t, ToggleButton button, String tn, double size) {
        ImageView iv;
        if (tn.startsWith("ISO Cols ")) {
            iv = new ImageView(t.type().getIcon());
            iv.setFitHeight(size * 0.9);
            iv.setFitWidth(size * 1.4);
        } else if (tn.startsWith("ISO Cols ") || tn.startsWith("ISO Rows ")) {
            iv = new ImageView(t.type().getIcon());
            iv.setFitHeight(size * 1.4);
            iv.setFitWidth(size * 0.9);
        } else {
            Image icon = t.type().getIcon();
            Canvas c = new Canvas();
            if (icon == null) {
                c.setWidth(size);
                c.setHeight(size);
            } else {
                c.setWidth(icon.getWidth());
                c.setHeight(icon.getHeight());
            }
            if (t.type().getBgColor() != null) {
                c.getGraphicsContext2D().setFill((Paint)t.type().getBgColor());
                c.getGraphicsContext2D().fillRect(0.0, 0.0, c.getWidth(), c.getHeight());
            }
            if (icon != null) {
                c.getGraphicsContext2D().drawImage(icon, 0.0, 0.0);
            }
            WritableImage wimg = new WritableImage((int)size, (int)size);
            SnapshotParameters ssparams = new SnapshotParameters();
            ssparams.setTransform((Transform)new Scale(size / c.getWidth(), size / c.getHeight()));
            c.snapshot(ssparams, wimg);
            iv = new ImageView((Image)wimg);
            iv.setFitHeight(size);
            iv.setFitWidth(size);
        }
        button.setGraphic((Node)iv);
    }

    public ToggleButton createTerrainButton(Terrain t, ToggleButton button, boolean addToToggleGroup, double size) {
        String tn = t.getTypeName();
        this.setTerrainButtonImage(t, button, tn, size);
        if (tn.contains("/")) {
            tn = tn.substring(tn.lastIndexOf(47) + 1);
        }
        if (tn.startsWith("ISO Cols ") || tn.startsWith("ISO Rows ")) {
            tn = tn.substring(9);
        }
        tn = tn.replace("Deciduous", "Decid.");
        tn = tn.replace("Evergreen", "Evrgr.");
        tn = tn.replace("Mountain", "Mtn");
        tn = tn.replace("Heavy", "Hvy");
        tn = tn.replace("Light", "Lt");
        tn = tn.replace("Flat ", "");
        tn = tn.replace("Parchment ", "");
        button.setText(tn);
        button.setWrapText(true);
        button.setStyle("-fx-font-size: 9px");
        button.setUserData((Object)t);
        if (addToToggleGroup) {
            button.setToggleGroup(this.worldographer.toggleGroup);
        }
        button.setTooltip(new Tooltip(t.getTypeName()));
        button.setMinSize(size * 1.2, size * 1.2);
        button.setMaxSize(size * 1.2, size * 2.4);
        button.setTextAlignment(TextAlignment.CENTER);
        button.setAlignment(Pos.TOP_CENTER);
        button.setTextOverrun(OverrunStyle.ELLIPSIS);
        button.setContentDisplay(ContentDisplay.TOP);
        return button;
    }

    public void placeTerrain(MouseEvent t, Terrain terrain) {
        ArrayList<Terrain> terrainList = new ArrayList<Terrain>();
        if (this.useSimilarNamedTerrainToggle.isSelected()) {
            if (terrain.getTypeName().lastIndexOf(32) > 2) {
                for (TerrainType t2 : Terrain.terrainTypes.values()) {
                    tname = terrain.getTypeName().substring(0, terrain.getTypeName().lastIndexOf(32)).toLowerCase();
                    if (!t2.getType().toLowerCase().startsWith(tname) || Math.abs(t2.getType().length() - terrain.getTypeName().length()) >= 4) continue;
                    terrainList.add(new Terrain(t2.getType(), true));
                }
            } else if (terrain.getTypeName().lastIndexOf(95) > 2) {
                for (TerrainType t2 : Terrain.terrainTypes.values()) {
                    tname = terrain.getTypeName().substring(0, terrain.getTypeName().lastIndexOf(95)).toLowerCase();
                    if (!t2.getType().toLowerCase().startsWith(tname) || Math.abs(t2.getType().length() - terrain.getTypeName().length()) >= 4) continue;
                    terrainList.add(new Terrain(t2.getType(), true));
                }
            }
        } else {
            terrainList.add(new Terrain(terrain.getTypeName(), true));
        }
        if (this.shuffleTerrainToggle.isSelected()) {
            int i;
            int length = terrainList.size();
            for (i = 0; i < length; ++i) {
                terrainList.add(new Terrain(((Terrain)terrainList.get(i)).getTypeName(), true));
            }
            for (i = 0; i < length; ++i) {
                String[] similar = ((Terrain)terrainList.get(i)).getType().getSimilarTerrain();
                if (similar == null) continue;
                for (int j = 0; j < similar.length; ++j) {
                    terrainList.add(new Terrain(similar[j], true));
                }
            }
        }
        terrainList.add(terrain);
        terrain = terrain.clone();
        Color overrideBGColor = this.overrideColorCB.isSelected() ? (Color)this.overrideTerrainBGCP.getValue() : null;
        MapLayer ml = (MapLayer)this.terrainMapLayerCombo.getSelectionModel().getSelectedItem();
        if (ml == null) {
            ml = terrain.getTypeName().contains("Water") ? this.mapUI().getMapData().getMapLayer("Terrain Water") : this.mapUI().getMapData().getMapLayer("Terrain Land");
        }
        if (!ml.getName().equals("Terrain Land") && !ml.getName().equals("Terrain Water")) {
            Point2D gridCoords = this.mapUI().getTerrainFromScenePt(t.getX(), t.getY());
            Pair modelCoords = this.mapUI().getModelPtFromTerrain(gridCoords.getX(), gridCoords.getY());
            modelCoords = new Pair((Object)((Double)modelCoords.getKey() - 150.0), (Object)((Double)modelCoords.getValue() - 150.0));
            terrain.setBackgroundColor(overrideBGColor);
            terrain.setIcy(this.terrainIcyCB.isSelected());
            if (this.wideAreaTerrainToggle.isSelected()) {
                Map<Point, Terrain> terrainAdjCoords = MapLogic.getAdjTerrainPoint(this.mapUI().getMapData().getTerrain(this.mapUI().viewLevel), this.mapUI().getMapData().getTileOrientation(), (int)gridCoords.getX(), (int)gridCoords.getY());
                for (Point pt : terrainAdjCoords.keySet()) {
                    Pair modelAdjCoords = this.mapUI().getModelPtFromTerrain(pt.getX(), pt.getY());
                    modelAdjCoords = new Pair((Object)((Double)modelAdjCoords.getKey() - 150.0), (Object)((Double)modelAdjCoords.getValue() - 150.0));
                    Terrain newTerrain = ((Terrain)terrainList.get((int)(Math.random() * (double)terrainList.size()))).clone();
                    newTerrain.setIcy(terrain.isIcy());
                    newTerrain.setBackgroundColor(terrain.getBackgroundColor());
                    this.mapUI().getController().addExtraTerrain(newTerrain, ml, (Pair<Double, Double>)modelAdjCoords, null);
                }
                Terrain newTerrain = ((Terrain)terrainList.get((int)(Math.random() * (double)terrainList.size()))).clone();
                newTerrain.setIcy(terrain.isIcy());
                newTerrain.setBackgroundColor(terrain.getBackgroundColor());
                this.mapUI().getController().addExtraTerrain(newTerrain, ml, (Pair<Double, Double>)modelCoords, null);
            } else if (this.paintBucketTerrainToggle.isSelected()) {
                Terrain previousTerrainThisLocation = null;
                Map<Point, Terrain> extraTerrainThisLayer = this.mapUI().getMapData().getExtraTerrainByLayer().get(ml);
                if (extraTerrainThisLayer != null) {
                    previousTerrainThisLocation = extraTerrainThisLayer.get(new Point((Double)modelCoords.getKey(), (Double)modelCoords.getValue()));
                }
                Terrain newTerrain = ((Terrain)terrainList.get((int)(Math.random() * (double)terrainList.size()))).clone();
                newTerrain.setIcy(terrain.isIcy());
                newTerrain.setBackgroundColor(terrain.getBackgroundColor());
                this.mapUI().getController().addExtraTerrain(newTerrain, ml, (Pair<Double, Double>)modelCoords, null);
                Map<Point, Terrain> terrainAdjGridCoords = MapLogic.getAdjTerrainPoint(this.mapUI().getMapData().getTerrain(this.mapUI().viewLevel), this.mapUI().getMapData().getTileOrientation(), (int)gridCoords.getX(), (int)gridCoords.getY());
                this.changeAdjacentMatchingTerrainOtherLayers(newTerrain, ml, terrainList, previousTerrainThisLocation, terrainAdjGridCoords);
            } else {
                Terrain newTerrain = ((Terrain)terrainList.get((int)(Math.random() * (double)terrainList.size()))).clone();
                newTerrain.setIcy(terrain.isIcy());
                newTerrain.setBackgroundColor(terrain.getBackgroundColor());
                this.mapUI().getController().addExtraTerrain(newTerrain, ml, (Pair<Double, Double>)modelCoords, null);
            }
            this.mapUI().draw();
            return;
        }
        byte[] resources = new byte[this.terrainResourceSpinners.size()];
        for (int i = 0; i < ResourceType.values().length; ++i) {
            resources[i] = ((Integer)this.terrainResourceSpinners.get(i).getValue()).byteValue();
        }
        boolean anyChanged = this.mapUI().getController().placeTerrain(t.getX(), t.getY(), terrainList, this.wideAreaTerrainToggle.isSelected(), this.paintBucketTerrainToggle.isSelected(), this.dynamicTerrainToggle.isSelected(), resources, this.worldographer.worldographerMenuBar.autoUpdateOtherLevelsItem.isSelected(), overrideBGColor, this.terrainGMOnlyCB.isSelected(), this.terrainIcyCB.isSelected(), this.terrainOverrideValues.isSelected(), (Integer)this.terrainElevationSpinner.getValue(), t.isAltDown());
        if (this.mapUI().viewLevel == ViewLevel.PROVINCE) {
            Point2D coords = this.mapUI().getTerrainFromScenePt(t.getX(), t.getY());
            Terrain[][] ter = this.mapUI().getMapData().getTerrain(this.mapUI().viewLevel);
            int maxx = Math.min(ter.length, (int)coords.getX() + this.mapUI().getMapData().getView().getProvinceFactor() / 2 + 2);
            for (int x2 = Math.max(0, (int)coords.getX() - this.mapUI().getMapData().getView().getProvinceFactor() / 2 - 2); x2 < maxx; ++x2) {
                int maxy = Math.min(ter[0].length, (int)coords.getY() + this.mapUI().getMapData().getView().getProvinceFactor() / 2 + 2);
                for (int y2 = Math.max(0, (int)coords.getY() - this.mapUI().getMapData().getView().getProvinceFactor() / 2 - 2); y2 < maxy; ++y2) {
                    if (x2 < 0 || y2 < 0) continue;
                    ter[x2][y2].setSavable(true);
                }
            }
        }
        if (anyChanged) {
            this.mapUI().draw();
        }
    }

    private void changeAdjacentMatchingTerrainOtherLayers(Terrain terrainToGetProperties, MapLayer ml, List<Terrain> terrainList, Terrain previousTerrainOriginalLocation, Map<Point, Terrain> terrainAdjGridCoords) {
        for (Point adjGridCoords : terrainAdjGridCoords.keySet()) {
            Map<Point, Terrain> extraTerrainThisLayer = this.mapUI().getMapData().getExtraTerrainByLayer().get(ml);
            if (extraTerrainThisLayer == null) continue;
            Pair modelCoords = this.mapUI().getModelPtFromTerrain(adjGridCoords.getX(), adjGridCoords.getY());
            Terrain previousTerrainThisLocation = extraTerrainThisLayer.get(new Point((Double)(modelCoords = new Pair((Object)((Double)modelCoords.getKey() - 150.0), (Object)((Double)modelCoords.getValue() - 150.0))).getKey(), (Double)modelCoords.getValue()));
            if (previousTerrainThisLocation == null || !previousTerrainOriginalLocation.getTypeName().equals(previousTerrainThisLocation.getTypeName()) || previousTerrainOriginalLocation.isIcy() != previousTerrainThisLocation.isIcy()) continue;
            Terrain newTerrain = terrainList.get((int)(Math.random() * (double)terrainList.size())).clone().clone();
            newTerrain.setIcy(terrainToGetProperties.isIcy());
            newTerrain.setBackgroundColor(terrainToGetProperties.getBackgroundColor());
            this.mapUI().getController().addExtraTerrain(newTerrain, ml, (Pair<Double, Double>)modelCoords, null);
            Map<Point, Terrain> newTerrainAdjGridCoords = MapLogic.getAdjTerrainPoint(this.mapUI().getMapData().getTerrain(this.mapUI().viewLevel), this.mapUI().getMapData().getTileOrientation(), (int)adjGridCoords.getX(), (int)adjGridCoords.getY());
            this.changeAdjacentMatchingTerrainOtherLayers(terrainToGetProperties, ml, terrainList, previousTerrainOriginalLocation, newTerrainAdjGridCoords);
        }
    }

    public void updateSelectionControls(Terrain t) {
        this.terrainElevationSpinner.getValueFactory().setValue((Object)t.getElevation());
        if (t.getBackgroundColor() != null) {
            this.overrideTerrainBGCP.setValue((Object)t.getBackgroundColor());
            this.overrideColorCB.setSelected(true);
        } else {
            this.overrideColorCB.setSelected(false);
        }
        for (int i = 0; i < this.terrainResourceSpinners.size(); ++i) {
            this.terrainResourceSpinners.get(i).getValueFactory().setValue((Object)t.getExtraInfo().getResources()[i]);
        }
        this.terrainGMOnlyCB.setSelected(t.isGmOnly());
        this.terrainIcyCB.setSelected(t.isIcy());
    }

    public void init(Number bounds, FeaturesToolbox featuresToolbox) {
        this.terrainBorderPane.setMaxWidth((Double)bounds - 25.0);
        this.terrainGrid.setMaxWidth((Double)bounds - 25.0);
        this.terrainGrid.setPrefWidth((Double)bounds - 25.0);
        Platform.runLater(() -> this.updateTerrainButtonsFlow());
    }

    public void initTerrainControls() {
        int buttonW = 60;
        int buttonH = 70;
        this.terrainBorderPane = new BorderPane();
        this.filterTerrainTF = new TextField("");
        this.terrainGrid = new GridPane();
        this.terrainFlowPane = new FlowPane();
        this.iconSizeSpinner = new Spinner(24, 200, 40, 1);
        this.terrainFilterComboBox = new ComboBox();
        this.terrainFilterComboBox.setItems(Worldographer.terrainCategories);
        ToggleGroup paintWideToggleGroup = new ToggleGroup();
        this.paintBucketTerrainToggle = Toolbox.makeToggleButtonWithStyleIcon("Terrain Fill", "mdi2f-format-color-fill", 32, "-fx-font-size: 9px", "Terrain Fill\nIf checked, when placing Terrain all adjacent Terrain of the same original\ntype will change to the new type.", paintWideToggleGroup, buttonW, buttonH);
        this.wideAreaTerrainToggle = Toolbox.makeToggleButtonWithStyleIcon("Wide Area", "mdi2h-hexagon-multiple", 32, "-fx-font-size: 9px", "Wide Area\nIf checked, when placing Terrain each immediately adjacent Terrain\nwill change to the new type.", paintWideToggleGroup, buttonW, buttonH);
        this.useSimilarNamedTerrainToggle = Toolbox.makeToggleButtonWithStyleIcon("Similar", "mdi2a-alphabetical-variant", 32, "-fx-font-size: 9px", "Use Similar Named Terrain\nIf selected, when placing Terrain any terrain that had the same name but\nonly varies by the last character or two many be used instead.", null, buttonW, buttonH);
        this.terrainSelectButton = Toolbox.makeToggleButtonWithStyleIcon("Select", "mdi2s-selection-ellipse-arrow-inside", 32, "-fx-font-size: 9px", "Select Terrain\nWhen selected, clicking a tile on the map updates the values below (icy, background\nelevation, resources) with that location's values. Changes to those will change the\nselected Terrain.", this.worldographer.toggleGroup, buttonW, buttonH);
        this.shuffleTerrainToggle = Toolbox.makeToggleButtonWithStyleIcon("Shuffle", "mdi2s-shuffle-variant", 32, "-fx-font-size: 9px", "Shuffle Related Terrain\nWhen selected Worldographer will randomly swap in some 'related' terrain based on the\n'Related Terrain' column in the Configure Terrain window when adding terrain to the map..", null, buttonW, buttonH);
        this.dynamicTerrainToggle = Toolbox.makeToggleButtonWithStyleIcon("Dynamic", "mdi2p-puzzle-star", 32, "-fx-font-size: 9px", "Dynamic Terrain.", null, buttonW, buttonH);
        this.terrainCoastlineButton = Toolbox.makeToggleButtonWithStyleIcon("Coast", "mdi2w-water-plus", 32, "-fx-font-size: 9px", "Make Coastline\nWhen selected, clicking a tile on the map adds a coastline to the tile.\nIf you click a water hex, then strips of land are added if any land tiles are adjacent.\nIf you click a land hex that has isometric LTerrain, then an water LFeature is added on top.", this.worldographer.toggleGroup, buttonW, buttonH);
        this.overrideColorCB = new CheckBox("Override BG:");
        this.terrainDeleteButton = TerrainToolbox.makeButtonWithStyleIcon("Delete", "mdi2d-delete", 32, "-fx-font-size: 9px", "Deletes the currently selected shape(s).", buttonW, buttonH);
        this.terrainDeleteButton.setOnAction(ActionListener -> this.deleteTerrain());
        this.terrainElevationSpinner = new FocusSpinner<Integer>(-100000, 100000, 1000);
        this.terrainIcyCB = new CheckBox("Icy");
        this.terrainGMOnlyCB = new CheckBox("GM Only");
        this.terrainGMOnlyCB.setOnAction(event -> {
            this.mapUI().getController().updateGMOnly(this.worldographer.undoEnabled, this.mapUI().getCurrentObjects(), this.terrainGMOnlyCB.isSelected());
            this.mapUI().draw();
        });
        this.overrideTerrainBGCP = new ColorPicker();
        this.backgroundCPWSelector = new ColorPickerWithSelector(this.overrideTerrainBGCP);
        this.terrainMapLayerCombo = new ComboBox(this.observableLayers);
        this.terrainResourceSpinners = new ArrayList<Spinner<Integer>>(ResourceType.values().length);
        for (int i = 0; i < ResourceType.values().length; ++i) {
            this.terrainResourceSpinners.add(i, new FocusSpinner(0, 100, 10));
        }
    }

    public void deleteTerrain() {
        UndoActionGroup uag = new UndoActionGroup();
        boolean deletedTerrain = false;
        ArrayList todelete = new ArrayList();
        for (MapObject mo : this.mapUI().getCurrentObjects()) {
            if (!(mo instanceof Terrain)) continue;
            Pair<MapLayer, Point> deleted = this.mapUI().getController().deleteTerrain((Terrain)mo, uag);
            if (deleted != null && deleted.getKey() != null) {
                deletedTerrain = true;
            }
            this.mapUI().hoverObject = null;
            this.mapUI().draw();
        }
        if (deletedTerrain) {
            this.mapUI().getController().getUndoRedoHandler().push(uag);
        }
        this.mapUI().getCurrentObjects().removeAll(todelete);
    }
}

