/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.ui.widget;

import com.inkwellideas.ographer.ui.Worldographer;
import com.inkwellideas.ographer.ui.toolbox.Toolbox;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.ToggleButton;
import javafx.scene.layout.HBox;
import org.kordamp.ikonli.javafx.FontIcon;

public class ColorPickerWithSelector {
    final ColorPicker colorPicker;
    final ToggleButton selectorButton;
    HBox hBox = new HBox();

    public ColorPickerWithSelector(ColorPicker colorPicker) {
        this.colorPicker = colorPicker;
        this.selectorButton = Toolbox.makeToggleButtonWithStyleIcon("", "mdi2e-eyedropper", 24, "-fx-font-size: 9px", "Select this button then click on the map to match the\ncolor picker's color to the color where you clicked.", null, 32, 32);
        this.selectorButton.setUserData((Object)colorPicker);
        this.selectorButton.setOnAction(event -> {
            System.out.println("ColorPickerWithSelector:" + this.selectorButton.isSelected());
            if (this.selectorButton.isSelected()) {
                FontIcon fontIcon = new FontIcon();
                fontIcon.setStyle("-fx-icon-code:mdi2e-eyedropper;-fx-icon-size:32;");
                Worldographer.primaryStage.getScene().setCursor(Cursor.CROSSHAIR);
            } else {
                Worldographer.primaryStage.getScene().setCursor(Cursor.DEFAULT);
            }
        });
        this.hBox.setAlignment(Pos.CENTER);
        this.hBox.getChildren().addAll((Object[])new Node[]{colorPicker, this.selectorButton});
    }

    public void setMaxWidth(double value) {
        this.hBox.setMaxWidth(value);
    }

    public Node getNode() {
        return this.hBox;
    }

    public ToggleButton getSelectorButton() {
        return this.selectorButton;
    }

    public ColorPicker getColorPicker() {
        return this.colorPicker;
    }
}

