/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.util;

import java.io.IOException;
import java.io.OutputStream;
import java.util.prefs.BackingStoreException;
import java.util.prefs.NodeChangeListener;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;

public class SafePreferences {
    Preferences prefs = null;

    public SafePreferences(String nodeName) {
        this.prefs = Preferences.userRoot().node(nodeName);
    }

    public void put(String key, String value) {
        this.prefs.put(key, value);
    }

    public String get(String key, String def) {
        try {
            String s = this.prefs.get(key, def);
            if ("null".equals(s)) {
                return def;
            }
            return s;
        }
        catch (Exception e) {
            e.printStackTrace();
            return def;
        }
    }

    public void remove(String key) {
        this.prefs.remove(key);
    }

    public void clear() throws BackingStoreException {
        this.prefs.clear();
    }

    public void putInt(String key, int value) {
        this.prefs.putInt(key, value);
    }

    public int getInt(String key, int def) {
        try {
            return this.prefs.getInt(key, def);
        }
        catch (Exception e) {
            e.printStackTrace();
            return def;
        }
    }

    public void putLong(String key, long value) {
        this.prefs.putLong(key, value);
    }

    public long getLong(String key, long def) {
        try {
            return this.prefs.getLong(key, def);
        }
        catch (Exception e) {
            e.printStackTrace();
            return def;
        }
    }

    public void putBoolean(String key, boolean value) {
        this.prefs.putBoolean(key, value);
    }

    public boolean getBoolean(String key, boolean def) {
        try {
            return this.prefs.getBoolean(key, def);
        }
        catch (Exception e) {
            e.printStackTrace();
            return def;
        }
    }

    public void putFloat(String key, float value) {
        this.prefs.putFloat(key, value);
    }

    public float getFloat(String key, float def) {
        try {
            return this.prefs.getFloat(key, def);
        }
        catch (Exception e) {
            e.printStackTrace();
            return def;
        }
    }

    public void putDouble(String key, double value) {
        this.prefs.putDouble(key, value);
    }

    public double getDouble(String key, double def) {
        try {
            return this.prefs.getDouble(key, def);
        }
        catch (Exception e) {
            e.printStackTrace();
            return def;
        }
    }

    public void putByteArray(String key, byte[] value) {
        this.prefs.putByteArray(key, value);
    }

    public byte[] getByteArray(String key, byte[] def) {
        try {
            return this.prefs.getByteArray(key, def);
        }
        catch (Exception e) {
            e.printStackTrace();
            return def;
        }
    }

    public String[] keys() throws BackingStoreException {
        return this.prefs.keys();
    }

    public String[] childrenNames() throws BackingStoreException {
        return this.prefs.childrenNames();
    }

    public Preferences parent() {
        return this.prefs.parent();
    }

    public Preferences node(String pathName) {
        return this.prefs.node(pathName);
    }

    public boolean nodeExists(String pathName) throws BackingStoreException {
        return this.prefs.nodeExists(pathName);
    }

    public void removeNode() throws BackingStoreException {
        this.prefs.removeNode();
    }

    public String name() {
        return this.prefs.name();
    }

    public String absolutePath() {
        return this.prefs.absolutePath();
    }

    public boolean isUserNode() {
        return this.prefs.isUserNode();
    }

    public String toString() {
        return this.prefs.toString();
    }

    public void flush() throws BackingStoreException {
        this.prefs.flush();
    }

    public void sync() throws BackingStoreException {
        this.prefs.sync();
    }

    public void addPreferenceChangeListener(PreferenceChangeListener pcl) {
        this.prefs.addPreferenceChangeListener(pcl);
    }

    public void removePreferenceChangeListener(PreferenceChangeListener pcl) {
        this.prefs.removePreferenceChangeListener(pcl);
    }

    public void addNodeChangeListener(NodeChangeListener ncl) {
        this.prefs.addNodeChangeListener(ncl);
    }

    public void removeNodeChangeListener(NodeChangeListener ncl) {
        this.prefs.removeNodeChangeListener(ncl);
    }

    public void exportNode(OutputStream os) throws IOException, BackingStoreException {
        this.prefs.exportNode(os);
    }

    public void exportSubtree(OutputStream os) throws IOException, BackingStoreException {
        this.prefs.exportSubtree(os);
    }
}

