/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ast;

import com.vladsch.flexmark.ast.LinkNodeBase;
import com.vladsch.flexmark.ast.RefNode;
import com.vladsch.flexmark.ast.util.ReferenceRepository;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.ast.ReferenceNode;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.PrefixedSubSequence;

public class Reference
extends LinkNodeBase
implements ReferenceNode<ReferenceRepository, Reference, RefNode> {
    protected BasedSequence openingMarker = BasedSequence.NULL;
    protected BasedSequence reference = BasedSequence.NULL;
    protected BasedSequence closingMarker = BasedSequence.NULL;

    @Override
    public BasedSequence[] getSegments() {
        return new BasedSequence[]{this.openingMarker, this.reference, this.closingMarker, this.urlOpeningMarker, this.url, this.pageRef, this.anchorMarker, this.anchorRef, this.urlClosingMarker, this.titleOpeningMarker, this.title, this.titleClosingMarker};
    }

    @Override
    public BasedSequence[] getSegmentsForChars() {
        return new BasedSequence[]{this.openingMarker, this.reference, this.closingMarker, PrefixedSubSequence.of(" ", this.closingMarker.getEmptySuffix()), this.urlOpeningMarker, this.pageRef, this.anchorMarker, this.anchorRef, this.urlClosingMarker, this.titleOpeningMarker, this.title, this.titleClosingMarker};
    }

    @Override
    public int compareTo(Reference other) {
        return this.getReference().compareTo(other.getReference());
    }

    @Override
    public RefNode getReferencingNode(Node node) {
        return node instanceof RefNode ? (RefNode)node : null;
    }

    @Override
    public void getAstExtra(StringBuilder out) {
        Reference.delimitedSegmentSpanChars(out, this.openingMarker, this.reference, this.closingMarker, "ref");
        Reference.delimitedSegmentSpanChars(out, this.urlOpeningMarker, this.url, this.urlClosingMarker, "url");
        Reference.delimitedSegmentSpanChars(out, this.titleOpeningMarker, this.title, this.titleClosingMarker, "title");
    }

    public Reference(BasedSequence label, BasedSequence url, BasedSequence title) {
        super(BasedSequence.NULL);
        this.openingMarker = (BasedSequence)label.subSequence(0, 1);
        this.reference = (BasedSequence)((BasedSequence)label.subSequence(1, label.length() - 2)).trim();
        this.closingMarker = (BasedSequence)label.subSequence(label.length() - 2, label.length());
        this.setUrlChars(url);
        if (title != null) {
            this.titleOpeningMarker = (BasedSequence)title.subSequence(0, 1);
            this.title = (BasedSequence)title.subSequence(1, title.length() - 1);
            this.titleClosingMarker = (BasedSequence)title.subSequence(title.length() - 1, title.length());
        }
        this.setCharsFromContent();
    }

    public BasedSequence getOpeningMarker() {
        return this.openingMarker;
    }

    public void setOpeningMarker(BasedSequence openingMarker) {
        this.openingMarker = openingMarker;
    }

    public BasedSequence getClosingMarker() {
        return this.closingMarker;
    }

    public void setClosingMarker(BasedSequence closingMarker) {
        this.closingMarker = closingMarker;
    }

    @Override
    public BasedSequence getUrlOpeningMarker() {
        return this.urlOpeningMarker;
    }

    @Override
    public void setUrlOpeningMarker(BasedSequence urlOpeningMarker) {
        this.urlOpeningMarker = urlOpeningMarker;
    }

    @Override
    public BasedSequence getUrlClosingMarker() {
        return this.urlClosingMarker;
    }

    @Override
    public void setUrlClosingMarker(BasedSequence urlClosingMarker) {
        this.urlClosingMarker = urlClosingMarker;
    }

    @Override
    public BasedSequence getTitleOpeningMarker() {
        return this.titleOpeningMarker;
    }

    @Override
    public void setTitleOpeningMarker(BasedSequence titleOpeningMarker) {
        this.titleOpeningMarker = titleOpeningMarker;
    }

    @Override
    public BasedSequence getTitleClosingMarker() {
        return this.titleClosingMarker;
    }

    @Override
    public void setTitleClosingMarker(BasedSequence titleClosingMarker) {
        this.titleClosingMarker = titleClosingMarker;
    }

    public BasedSequence getReference() {
        return this.reference;
    }

    public void setReference(BasedSequence reference) {
        this.reference = reference;
    }

    @Override
    public BasedSequence getUrl() {
        return this.url;
    }

    @Override
    public void setUrl(BasedSequence url) {
        this.url = url;
    }

    @Override
    public BasedSequence getPageRef() {
        return this.pageRef;
    }

    @Override
    public void setPageRef(BasedSequence pageRef) {
        this.pageRef = pageRef;
    }

    @Override
    public BasedSequence getAnchorMarker() {
        return this.anchorMarker;
    }

    @Override
    public void setAnchorMarker(BasedSequence anchorMarker) {
        this.anchorMarker = anchorMarker;
    }

    @Override
    public BasedSequence getAnchorRef() {
        return this.anchorRef;
    }

    @Override
    public void setAnchorRef(BasedSequence anchorRef) {
        this.anchorRef = anchorRef;
    }

    @Override
    public BasedSequence getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(BasedSequence title) {
        this.title = title;
    }

    @Override
    protected String toStringAttributes() {
        return "reference=" + this.reference + ", url=" + this.url;
    }
}

