/*
 * Decompiled with CFR 0.152.
 */
package atlantafx.base.controls;

import atlantafx.base.controls.ToggleSwitchSkin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.css.converter.EnumConverter;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.geometry.HorizontalDirection;
import javafx.scene.AccessibleAttribute;
import javafx.scene.control.Labeled;
import javafx.scene.control.Skin;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;

public class ToggleSwitch
extends Labeled
implements Toggle {
    protected static final String DEFAULT_STYLE_CLASS = "toggle-switch";
    protected static final PseudoClass PSEUDO_CLASS_SELECTED = PseudoClass.getPseudoClass((String)"selected");
    protected static final PseudoClass PSEUDO_CLASS_RIGHT = PseudoClass.getPseudoClass((String)"right");
    private BooleanProperty selected;
    private ObjectProperty<ToggleGroup> toggleGroup;
    private ObjectProperty<HorizontalDirection> labelPosition;

    public ToggleSwitch() {
        this.initialize();
    }

    public ToggleSwitch(String text) {
        super(text);
        this.initialize();
    }

    protected Skin<?> createDefaultSkin() {
        return new ToggleSwitchSkin(this);
    }

    private void initialize() {
        this.getStyleClass().setAll((Object[])new String[]{DEFAULT_STYLE_CLASS});
    }

    public final BooleanProperty selectedProperty() {
        if (this.selected == null) {
            this.selected = new BooleanPropertyBase(){

                protected void invalidated() {
                    boolean selected = this.get();
                    ToggleGroup tg = ToggleSwitch.this.getToggleGroup();
                    ToggleSwitch.this.pseudoClassStateChanged(PSEUDO_CLASS_SELECTED, selected);
                    ToggleSwitch.this.notifyAccessibleAttributeChanged(AccessibleAttribute.SELECTED);
                    if (tg != null) {
                        if (selected) {
                            tg.selectToggle((Toggle)ToggleSwitch.this);
                        } else if (tg.getSelectedToggle() == ToggleSwitch.this) {
                            if (!tg.getSelectedToggle().isSelected()) {
                                for (Toggle toggle : tg.getToggles()) {
                                    if (!toggle.isSelected()) continue;
                                    return;
                                }
                            }
                            tg.selectToggle(null);
                        }
                    }
                }

                public Object getBean() {
                    return ToggleSwitch.this;
                }

                public String getName() {
                    return "selected";
                }
            };
        }
        return this.selected;
    }

    public final void setSelected(boolean value) {
        this.selectedProperty().set(value);
    }

    public final boolean isSelected() {
        return this.selected != null && this.selected.get();
    }

    public final ObjectProperty<ToggleGroup> toggleGroupProperty() {
        if (this.toggleGroup == null) {
            this.toggleGroup = new ObjectPropertyBase<ToggleGroup>(){
                private ToggleGroup old;

                protected void invalidated() {
                    ToggleGroup tg = (ToggleGroup)this.get();
                    if (tg != null && !tg.getToggles().contains((Object)ToggleSwitch.this)) {
                        if (this.old != null) {
                            this.old.getToggles().remove((Object)ToggleSwitch.this);
                        }
                        tg.getToggles().add((Object)ToggleSwitch.this);
                    } else if (tg == null) {
                        this.old.getToggles().remove((Object)ToggleSwitch.this);
                    }
                    this.old = tg;
                }

                public Object getBean() {
                    return ToggleSwitch.this;
                }

                public String getName() {
                    return "toggleGroup";
                }
            };
        }
        return this.toggleGroup;
    }

    public final void setToggleGroup(ToggleGroup value) {
        this.toggleGroupProperty().set((Object)value);
    }

    public final ToggleGroup getToggleGroup() {
        return this.toggleGroup == null ? null : (ToggleGroup)this.toggleGroup.get();
    }

    public final ObjectProperty<HorizontalDirection> labelPositionProperty() {
        if (this.labelPosition == null) {
            this.labelPosition = new StyleableObjectProperty<HorizontalDirection>(HorizontalDirection.LEFT){

                public Object getBean() {
                    return ToggleSwitch.this;
                }

                public String getName() {
                    return "labelPosition";
                }

                protected void invalidated() {
                    HorizontalDirection v = (HorizontalDirection)this.get();
                    ToggleSwitch.this.pseudoClassStateChanged(PSEUDO_CLASS_RIGHT, v == HorizontalDirection.RIGHT);
                }

                public CssMetaData<ToggleSwitch, HorizontalDirection> getCssMetaData() {
                    return StyleableProperties.LABEL_POSITION;
                }
            };
        }
        return this.labelPosition;
    }

    public final void setLabelPosition(HorizontalDirection pos) {
        this.labelPositionProperty().setValue((Object)pos);
    }

    public final HorizontalDirection getLabelPosition() {
        return this.labelPosition == null ? HorizontalDirection.LEFT : (HorizontalDirection)this.labelPosition.getValue();
    }

    public void fire() {
        if (!this.isDisabled()) {
            this.setSelected(!this.isSelected());
            this.fireEvent((Event)new ActionEvent());
        }
    }

    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    private static class StyleableProperties {
        private static final CssMetaData<ToggleSwitch, HorizontalDirection> LABEL_POSITION = new CssMetaData<ToggleSwitch, HorizontalDirection>("-fx-label-position", (StyleConverter)new EnumConverter(HorizontalDirection.class), HorizontalDirection.LEFT){

            public boolean isSettable(ToggleSwitch c) {
                return c.labelPositionProperty() == null || !c.labelPositionProperty().isBound();
            }

            public StyleableProperty<HorizontalDirection> getStyleableProperty(ToggleSwitch c) {
                ObjectProperty<HorizontalDirection> val = c.labelPositionProperty();
                return (StyleableProperty)val;
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList<CssMetaData<ToggleSwitch, HorizontalDirection>> styleables = new ArrayList<CssMetaData<ToggleSwitch, HorizontalDirection>>(Labeled.getClassCssMetaData());
            styleables.add(LABEL_POSITION);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

