/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.generator.battlemat;

import com.inkwellideas.ographer.data.Direction;
import com.inkwellideas.ographer.data.MapLayer;
import com.inkwellideas.ographer.data.ViewLevel;
import com.inkwellideas.ographer.generator.battlemat.BattlematDataGenerator;
import com.inkwellideas.ographer.map.MapShape;
import com.inkwellideas.ographer.map.Terrain;
import com.inkwellideas.ographer.model.Feature;
import java.util.ArrayList;
import java.util.List;
import javafx.geometry.Point2D;
import javafx.scene.paint.Color;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.Polygon;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;

public class MakeTavern {
    public static Terrain[][] generateTavern(Terrain[][] t, List<MapShape> shapes, List<Feature> features, MapLayer ml, MapLayer shapelayer) {
        double right;
        double left;
        double bottom;
        double top;
        String furniture = "Pine";
        double ff = Math.random();
        if (ff < 0.33) {
            furniture = "Walnut";
        } else if (ff < 0.66) {
            furniture = "Weathered";
        }
        String mainfloor = "Cobblestone Light";
        double mf = Math.random();
        if (mf < 0.2) {
            mainfloor = "Cobblestone Dark";
        } else if (mf < 0.35) {
            mainfloor = "Cobblestone";
        } else if (mf < 0.5) {
            mainfloor = "Wood";
        } else if (mf < 0.65) {
            mainfloor = "Wood Dark";
        } else if (mf < 0.85) {
            mainfloor = "Wood Light";
        }
        String kitchenfloor = "Cobblestone Light";
        double kf = Math.random();
        if (kf < 0.33) {
            kitchenfloor = "Cobblestone Dark";
        } else if (kf < 0.66) {
            kitchenfloor = "Cobblestone";
        }
        String topfloor = "Wood Light";
        double tf = Math.random();
        if (tf < 0.33) {
            topfloor = "Wood";
        } else if (tf < 0.66) {
            topfloor = "Wood Dark";
        }
        double mainroomleft = 6.0;
        double mainroomtop = 6.0;
        double mainroomright = 11 + (int)(Math.random() * 4.0);
        double mainroombottom = 11 + (int)(Math.random() * 4.0);
        Polygon kitchenpoly = new Polygon();
        double kitchenleft = 3.0;
        double kitchentop = 9.0;
        double kitchenright = 9.0;
        double kitchenbottom = 15.0;
        Direction kitchenLoc = Direction.values()[(int)(Math.random() * 4.0)];
        Polygon pantrypoly = new Polygon();
        double pantryleft = 0.0;
        double pantryright = 0.0;
        double pantrytop = 0.0;
        double pantrybottom = 0.0;
        Polygon ownerspoly = new Polygon();
        double ownersleft = 0.0;
        double ownersright = 0.0;
        double ownerstop = 0.0;
        double ownersbottom = 0.0;
        int kitchenwidth = 3 + (int)(Math.random() * 2.0);
        int kitchenheight = 3 + (int)(Math.random() * 2.0);
        Direction ownersroomlocation = null;
        if (kitchenLoc == Direction.NORTH) {
            kitchenleft = Math.random() < 0.5 ? mainroomleft : mainroomright - (double)kitchenwidth;
            kitchenright = kitchenleft + (double)kitchenwidth;
            kitchentop = mainroomtop - (double)kitchenheight;
            kitchenbottom = mainroomtop;
            if (kitchenleft == mainroomleft) {
                pantryleft = kitchenright;
                pantryright = pantryleft + 3.0 + (double)((int)(Math.random() * 2.0));
            } else {
                pantryright = kitchenleft;
                pantryleft = pantryright - (double)(3 + (int)(Math.random() * 2.0));
            }
            pantrytop = kitchentop;
            pantrybottom = kitchenbottom;
            if ((kitchenright - kitchenleft) * (kitchenbottom - kitchentop) < (pantryright - pantryleft) * (pantrybottom - pantrytop)) {
                top = kitchentop;
                bottom = kitchenbottom;
                left = kitchenleft;
                right = kitchenright;
                kitchentop = pantrytop;
                kitchenbottom = pantrybottom;
                kitchenleft = pantryleft;
                kitchenright = pantryright;
                pantrytop = top;
                pantrybottom = bottom;
                pantryleft = left;
                pantryright = right;
            }
            if ((double)kitchenwidth + pantryright - pantryleft < mainroomright - mainroomleft) {
                if (kitchenleft == mainroomleft) {
                    ownersright = mainroomright;
                    ownersleft = pantryright;
                    if (ownersright - ownersleft < 2.0) {
                        ownersright = mainroomright + 2.0;
                        ownersroomlocation = Direction.EAST;
                    }
                } else {
                    ownersright = pantryleft;
                    ownersleft = mainroomleft;
                    if (ownersright - ownersleft < 2.0) {
                        ownersleft = mainroomleft - 2.0;
                        ownersroomlocation = Direction.WEST;
                    }
                }
                ownerstop = pantrytop;
                ownersbottom = pantrybottom;
            }
        }
        if (kitchenLoc == Direction.SOUTH) {
            kitchenleft = Math.random() < 0.5 ? mainroomleft : mainroomright - (double)kitchenwidth;
            kitchenright = kitchenleft + (double)kitchenwidth;
            kitchentop = mainroombottom;
            kitchenbottom = mainroombottom + (double)kitchenheight;
            if (kitchenleft == mainroomleft) {
                pantryleft = kitchenright;
                pantryright = pantryleft + 3.0 + (double)((int)(Math.random() * 2.0));
            } else {
                pantryright = kitchenleft;
                pantryleft = pantryright - (double)(3 + (int)(Math.random() * 2.0));
            }
            pantrytop = kitchentop;
            pantrybottom = kitchenbottom;
            if ((kitchenright - kitchenleft) * (kitchenbottom - kitchentop) < (pantryright - pantryleft) * (pantrybottom - pantrytop)) {
                top = kitchentop;
                bottom = kitchenbottom;
                left = kitchenleft;
                right = kitchenright;
                kitchentop = pantrytop;
                kitchenbottom = pantrybottom;
                kitchenleft = pantryleft;
                kitchenright = pantryright;
                pantrytop = top;
                pantrybottom = bottom;
                pantryleft = left;
                pantryright = right;
            }
            if ((double)kitchenwidth + pantryright - pantryleft < mainroomright - mainroomleft) {
                if (kitchenleft == mainroomleft) {
                    ownersright = mainroomright;
                    ownersleft = pantryright;
                    if (ownersright - ownersleft < 2.0) {
                        ownersright = mainroomright + 2.0;
                        ownersroomlocation = Direction.EAST;
                    }
                } else {
                    ownersright = pantryleft;
                    ownersleft = mainroomleft;
                    if (ownersright - ownersleft < 2.0) {
                        ownersleft = mainroomleft - 2.0;
                        ownersroomlocation = Direction.WEST;
                    }
                }
                ownerstop = pantrytop;
                ownersbottom = pantrybottom;
            }
        }
        if (kitchenLoc == Direction.EAST) {
            kitchentop = Math.random() < 0.5 ? mainroomtop : mainroombottom - (double)kitchenheight;
            kitchenbottom = kitchentop + (double)kitchenheight;
            kitchenleft = mainroomright;
            kitchenright = mainroomright + (double)kitchenwidth;
            if (kitchentop == mainroomtop) {
                pantrytop = kitchenbottom;
                pantrybottom = pantrytop + 3.0 + (double)((int)(Math.random() * 2.0));
            } else {
                pantrybottom = kitchentop;
                pantrytop = pantrybottom - (double)(3 + (int)(Math.random() * 2.0));
            }
            pantryright = kitchenright;
            pantryleft = kitchenleft;
            if ((kitchenright - kitchenleft) * (kitchenbottom - kitchentop) < (pantryright - pantryleft) * (pantrybottom - pantrytop)) {
                top = kitchentop;
                bottom = kitchenbottom;
                left = kitchenleft;
                right = kitchenright;
                kitchentop = pantrytop;
                kitchenbottom = pantrybottom;
                kitchenleft = pantryleft;
                kitchenright = pantryright;
                pantrytop = top;
                pantrybottom = bottom;
                pantryleft = left;
                pantryright = right;
            }
            if ((double)kitchenheight + pantrybottom - pantrytop < mainroombottom - mainroomtop) {
                if (kitchentop == mainroomtop) {
                    ownersbottom = mainroombottom;
                    ownerstop = pantrybottom;
                    if (ownersbottom - ownerstop < 2.0) {
                        ownersbottom = mainroombottom + 2.0;
                        ownersroomlocation = Direction.SOUTH;
                    }
                } else {
                    ownersbottom = pantrytop;
                    ownerstop = mainroomtop;
                    if (ownersbottom - ownerstop < 2.0) {
                        ownerstop = mainroomtop - 2.0;
                        ownersroomlocation = Direction.NORTH;
                    }
                }
                ownersleft = pantryleft;
                ownersright = pantryright;
            }
        }
        if (kitchenLoc == Direction.WEST) {
            kitchentop = Math.random() < 0.5 ? mainroomtop : mainroombottom - (double)kitchenheight;
            kitchenbottom = kitchentop + (double)kitchenheight;
            kitchenleft = mainroomleft - (double)kitchenwidth;
            kitchenright = mainroomleft;
            if (kitchentop == mainroomtop) {
                pantrytop = kitchenbottom;
                pantrybottom = pantrytop + 3.0 + (double)((int)(Math.random() * 2.0));
            } else {
                pantrybottom = kitchentop;
                pantrytop = pantrybottom - (double)(3 + (int)(Math.random() * 2.0));
            }
            pantryright = kitchenright;
            pantryleft = kitchenleft;
            if ((kitchenright - kitchenleft) * (kitchenbottom - kitchentop) < (pantryright - pantryleft) * (pantrybottom - pantrytop)) {
                top = kitchentop;
                bottom = kitchenbottom;
                left = kitchenleft;
                right = kitchenright;
                kitchentop = pantrytop;
                kitchenbottom = pantrybottom;
                kitchenleft = pantryleft;
                kitchenright = pantryright;
                pantrytop = top;
                pantrybottom = bottom;
                pantryleft = left;
                pantryright = right;
            }
            if ((double)kitchenheight + pantrybottom - pantrytop < mainroombottom - mainroomtop) {
                if (kitchentop == mainroomtop) {
                    ownersbottom = mainroombottom;
                    ownerstop = pantrybottom;
                    if (ownersbottom - ownerstop < 2.0) {
                        ownersbottom = mainroombottom + 2.0;
                        ownersroomlocation = Direction.SOUTH;
                    }
                } else {
                    ownersbottom = pantrytop;
                    ownerstop = mainroomtop;
                    if (ownersbottom - ownerstop < 2.0) {
                        ownerstop = mainroomtop - 2.0;
                        ownersroomlocation = Direction.NORTH;
                    }
                }
                ownersleft = pantryleft;
                ownersright = pantryright;
            }
        }
        Direction sideroomlocation = null;
        if (ownersroomlocation != null) {
            sideroomlocation = ownersroomlocation;
        }
        if (sideroomlocation == null) {
            while (sideroomlocation == null || sideroomlocation == kitchenLoc) {
                sideroomlocation = Direction.values()[(int)(Math.random() * (double)Direction.values().length)];
            }
        }
        int numsiderooms = -1;
        if (ownersroomlocation == null && Math.random() < 0.4) {
            numsiderooms = 0;
        }
        Polygon[] sideroomspolys = null;
        double[] sideroomsleft = null;
        double[] sideroomsright = null;
        double[] sideroomstop = null;
        double[] sideroomsbottom = null;
        int largerroom = -1;
        if (sideroomlocation == Direction.EAST || sideroomlocation == Direction.WEST) {
            if (numsiderooms != 0) {
                numsiderooms = (int)(mainroombottom - mainroomtop) / 2;
                if ((mainroombottom - mainroomtop) % 2.0 != 0.0) {
                    largerroom = (int)(Math.random() * (double)numsiderooms);
                }
                sideroomspolys = new Polygon[numsiderooms];
                sideroomsleft = new double[numsiderooms];
                sideroomsright = new double[numsiderooms];
                sideroomstop = new double[numsiderooms];
                sideroomsbottom = new double[numsiderooms];
                double top2 = mainroomtop;
                for (i = 0; i < numsiderooms; ++i) {
                    sideroomspolys[i] = new Polygon();
                    if (sideroomlocation == Direction.EAST) {
                        sideroomsleft[i] = mainroomright;
                        sideroomsright[i] = mainroomright + 2.0;
                    } else {
                        sideroomsleft[i] = mainroomleft - 2.0;
                        sideroomsright[i] = mainroomleft;
                    }
                    sideroomstop[i] = top2;
                    top2 += 2.0;
                    if (largerroom == i) {
                        top2 += 1.0;
                    }
                    sideroomsbottom[i] = top2;
                }
            } else {
                sideroomspolys = null;
            }
        } else if (sideroomlocation == Direction.SOUTH || sideroomlocation == Direction.NORTH) {
            if (numsiderooms != 0) {
                numsiderooms = (int)(mainroomright - mainroomleft) / 2;
                if ((mainroomright - mainroomleft) % 2.0 != 0.0) {
                    largerroom = (int)(Math.random() * (double)numsiderooms);
                }
                sideroomspolys = new Polygon[numsiderooms];
                sideroomsleft = new double[numsiderooms];
                sideroomsright = new double[numsiderooms];
                sideroomstop = new double[numsiderooms];
                sideroomsbottom = new double[numsiderooms];
                double left2 = mainroomleft;
                for (i = 0; i < numsiderooms; ++i) {
                    sideroomspolys[i] = new Polygon();
                    sideroomsleft[i] = left2;
                    left2 += 2.0;
                    if (largerroom == i) {
                        left2 += 1.0;
                    }
                    sideroomsright[i] = left2;
                    if (sideroomlocation == Direction.SOUTH) {
                        sideroomstop[i] = mainroombottom;
                        sideroomsbottom[i] = mainroombottom + 2.0;
                        continue;
                    }
                    sideroomstop[i] = mainroomtop - 2.0;
                    sideroomsbottom[i] = mainroomtop;
                }
            } else {
                sideroomspolys = null;
            }
        }
        int sideroomprivy = (int)(Math.random() * (double)numsiderooms);
        MapShape mainroom = BattlematDataGenerator.makeRoom(mainroomleft, mainroomtop, mainroomright, mainroombottom, "Rock Dark", 0.15, mainfloor, shapelayer);
        shapes.add(mainroom);
        MapShape kitchen = BattlematDataGenerator.makeRoom(kitchenleft, kitchentop, kitchenright, kitchenbottom, "Rock Dark", 0.15, kitchenfloor, shapelayer);
        shapes.add(kitchen);
        MapShape pantry = BattlematDataGenerator.makeRoom(pantryleft, pantrytop, pantryright, pantrybottom, "Rock Dark", 0.15, kitchenfloor, shapelayer);
        shapes.add(pantry);
        if (ownersleft != 0.0) {
            MapShape ownersRoon = BattlematDataGenerator.makeRoom(ownersleft, ownerstop, ownersright, ownersbottom, "Rock Dark", 0.15, topfloor, shapelayer);
            shapes.add(ownersRoon);
        }
        if (sideroomspolys != null) {
            for (int i = 0; i < sideroomspolys.length; ++i) {
                MapShape sideRoom = BattlematDataGenerator.makeRoom(sideroomsleft[i], sideroomstop[i], sideroomsright[i], sideroomsbottom[i], "Rock Dark", 0.15, mainfloor, shapelayer);
                shapes.add(sideRoom);
            }
        }
        MakeTavern.furnishKitchen(features, kitchenLoc, kitchenleft, kitchentop, kitchenright, kitchenbottom, pantrytop, pantryleft, ml, furniture);
        MakeTavern.furnishPantry(features, kitchenLoc, pantryleft, pantrytop, pantryright, pantrybottom, "Rock Dark", ml);
        String[] chairorstools = new String[]{"Chair", "Stool", ""};
        String chairorstool = chairorstools[(int)(Math.random() * (double)chairorstools.length)];
        for (int i = 0; i < numsiderooms; ++i) {
            MakeTavern.furnishSideRoom(features, sideroomlocation, sideroomsleft[i], sideroomstop[i], sideroomsright[i], sideroomsbottom[i], ml, furniture, chairorstool);
        }
        Direction entrance = Direction.values()[(int)(Math.random() * 4.0)];
        while (entrance == kitchenLoc || entrance == sideroomlocation) {
            entrance = Direction.values()[(int)(Math.random() * 4.0)];
        }
        MakeTavern.makeAndFurnishEntrance(shapes, features, ml, shapelayer, mainfloor, mainroomleft, mainroomtop, mainroomright, mainroombottom, entrance);
        int privyx = 1;
        int privyy = 1;
        if (entrance != Direction.SOUTH) {
            privyx = 17;
            privyy = 17;
        }
        if (entrance == Direction.EAST) {
            privyx = 1;
            privyy = 17;
        }
        Polygon privypoly = new Polygon();
        int offsetx = 0;
        int offsety = 0;
        MapShape privy = BattlematDataGenerator.makeRoom(privyx + offsetx, privyy + offsety, privyx + offsetx + 2, privyy + offsety + 2, "Rock Dark", 0.15, mainfloor, shapelayer);
        shapes.add(privy);
        MakeTavern.furnishPrivy(shapes, features, entrance, privyx + offsetx, privyy + offsety, privyx + offsetx + 2, privyy + offsety + 2, ml);
        MakeTavern.generateTavernMainRoom(shapes, features, ml, shapelayer, furniture, mainroomleft, mainroomtop, mainroomright, mainroombottom, kitchentop, kitchenbottom, kitchenLoc, sideroomlocation, chairorstool);
        if (ownersleft != 0.0) {
            MakeTavern.furnishOwnersRoom(features, kitchenLoc, ownersleft, ownerstop, ownersright, ownersbottom, ml, furniture);
        }
        if (t.length < 20 || t[0].length < 20) {
            Terrain[][] t2 = new Terrain[Math.max(20, t.length)][Math.max(20, t[0].length)];
            for (int i = 0; i < t2.length; ++i) {
                for (int j = 0; j < t2[i].length; ++j) {
                    t2[i][j] = new Terrain("Blank", false);
                }
            }
            t = t2;
        }
        MapShape forestFloor = BattlematDataGenerator.makeRoom(0.0, 0.0, t.length, t[0].length, "Rock Dark", 0.0, "Forest Floor", shapelayer);
        forestFloor.setTags("ground");
        shapes.add(0, forestFloor);
        return t;
    }

    private static void generateTavernMainRoom(List<MapShape> shapes, List<Feature> features, MapLayer ml, MapLayer shapelayer, String furniture, double mainroomleft, double mainroomtop, double mainroomright, double mainroombottom, double kitchentop, double kitchenbottom, Direction kitchenLoc, Direction sideroomlocation, String chairorstool) {
        int totalbails;
        Feature bar = new Feature("Battlemat/Table Rectangle Long " + furniture, false, false, false, false, null, 0.0, null, 400.0, 60.0, false, false, null, "bar", false, false, false, false, ml);
        String barchairorstool = Math.random() < 0.5 ? "Chair" : "Stool";
        switch (kitchenLoc) {
            case EAST: 
            case WEST: {
                int bailcount;
                bar.setRotate(90.0);
                double barlocy = Math.random() * (mainroombottom - mainroomtop - bar.getScaleFallbackType() / 100.0) + bar.getScaleFallbackType() / 100.0 / 2.0 + mainroomtop;
                bar.setLocation(ViewLevel.BATTLEMAT, new Point2D((kitchenLoc == Direction.WEST ? mainroomleft + 0.85 : mainroomright - 0.85) * 300.0, barlocy * 300.0));
                for (bailcount = 0; bailcount < 20 && MakeTavern.doesFeatureOverlapOthers(features, bar).size() > 0; ++bailcount) {
                    if (Math.random() < 0.6) {
                        bar.setScale(400.0);
                    } else {
                        bar.setScale(300.0);
                    }
                    barlocy = Math.random() * (mainroombottom - mainroomtop - bar.getScaleFallbackType() / 100.0) + bar.getScaleFallbackType() / 100.0 / 2.0 + mainroomtop;
                    bar.setLocation(ViewLevel.BATTLEMAT, new Point2D((kitchenLoc == Direction.WEST ? mainroomleft + 0.85 : mainroomright - 0.85) * 300.0, barlocy * 300.0));
                }
                if (bailcount >= 20) break;
                if (bar.getScale() == 400.0) {
                    for (i = 0; i < 6; ++i) {
                        chair = new Feature("Battlemat/" + barchairorstool + " " + furniture, false, false, false, false, null, kitchenLoc == Direction.WEST ? 90.0 : 270.0, null, -1.0, -1.0, false, false, null, "chair", false, false, false, false, ml);
                        features.add(chair);
                        chair.setLocation(ViewLevel.BATTLEMAT, new Point2D((kitchenLoc == Direction.WEST ? mainroomleft + 1.05 : mainroomright - 1.05) * 300.0, (barlocy - 1.35 + (double)i * 0.535) * 300.0));
                    }
                } else {
                    for (i = 0; i < 4; ++i) {
                        chair = new Feature("Battlemat/" + barchairorstool + " " + furniture, false, false, false, false, null, kitchenLoc == Direction.WEST ? 90.0 : 270.0, null, -1.0, -1.0, false, false, null, "chair", false, false, false, false, ml);
                        features.add(chair);
                        chair.setLocation(ViewLevel.BATTLEMAT, new Point2D((kitchenLoc == Direction.WEST ? mainroomleft + 1.05 : mainroomright - 1.05) * 300.0, (barlocy - 0.9 + (double)i * 0.6) * 300.0));
                    }
                }
                features.add(bar);
                break;
            }
            case NORTH: 
            case SOUTH: {
                int bailcount;
                double barlocx = Math.random() * (mainroomright - mainroomleft - bar.getScaleFallbackType() / 100.0) + bar.getScaleFallbackType() / 100.0 / 2.0 + mainroomleft;
                bar.setLocation(ViewLevel.BATTLEMAT, new Point2D(barlocx * 300.0, (kitchenLoc == Direction.NORTH ? kitchenbottom + 0.85 : kitchentop + 0.85) * 300.0));
                for (bailcount = 0; bailcount < 20 && MakeTavern.doesFeatureOverlapOthers(features, bar).size() > 0; ++bailcount) {
                    if (Math.random() < 0.6) {
                        bar.setScale(400.0);
                    } else {
                        bar.setScale(300.0);
                    }
                    barlocx = Math.random() * (mainroomright - mainroomleft - bar.getScaleFallbackType() / 100.0) + bar.getScaleFallbackType() / 100.0 / 2.0 + mainroomleft;
                    bar.setLocation(ViewLevel.BATTLEMAT, new Point2D(barlocx * 300.0, (kitchenLoc == Direction.NORTH ? kitchenbottom + 0.85 : kitchentop - 0.85) * 300.0));
                }
                if (bailcount >= 20) break;
                if (bar.getScale() == 400.0) {
                    for (i = 0; i < 6; ++i) {
                        chair = new Feature("Battlemat/" + barchairorstool + " " + furniture, false, false, false, false, null, kitchenLoc == Direction.NORTH ? 180.0 : 0.0, null, -1.0, -1.0, false, false, null, "chair", false, false, false, false, ml);
                        features.add(chair);
                        chair.setLocation(ViewLevel.BATTLEMAT, new Point2D((barlocx - 1.35 + (double)i * 0.535) * 300.0, (kitchenLoc == Direction.NORTH ? kitchenbottom + 1.05 : kitchentop - 1.05) * 300.0));
                    }
                } else {
                    for (i = 0; i < 4; ++i) {
                        chair = new Feature("Battlemat/" + barchairorstool + " " + furniture, false, false, false, false, null, kitchenLoc == Direction.NORTH ? 180.0 : 0.0, null, -1.0, -1.0, false, false, null, "chair", false, false, false, false, ml);
                        features.add(chair);
                        chair.setLocation(ViewLevel.BATTLEMAT, new Point2D((barlocx - 0.9 + (double)i * 0.6) * 300.0, (kitchenLoc == Direction.NORTH ? kitchenbottom + 1.05 : kitchentop - 1.05) * 300.0));
                    }
                }
                features.add(bar);
            }
        }
        Feature stagetest = null;
        for (totalbails = 0; totalbails < 10; ++totalbails) {
            double stagew = 1.2 + Math.random() * (mainroomright - mainroomleft) / 6.0;
            double stageh = 1.2 + Math.random() * (mainroombottom - mainroomtop) / 6.0;
            double[] locx = new double[]{mainroomleft + 0.075, mainroomright - 0.075 - stagew, mainroomleft + 0.075, mainroomright - 0.075 - stagew};
            double[] locy = new double[]{mainroombottom - 0.075 - stageh, mainroombottom - 0.075 - stageh, mainroomtop + 0.075, mainroomtop + 0.075};
            int selection = (int)(Math.random() * (double)locx.length);
            stagetest = new Feature("Battlemat/Table Benches Rectangle " + furniture, false, false, false, false, null, 0.0, null, stagew * 100.0, stageh * 100.0, null, "table", false, false, false, false, ml);
            stagetest.setLocation(ViewLevel.BATTLEMAT, (locx[selection] + stagew / 2.0) * 300.0, (locy[selection] + stageh / 2.0) * 300.0);
            if (MakeTavern.doesFeatureOverlapOthers(features, stagetest).size() > 0) {
                ++totalbails;
                continue;
            }
            features.add(stagetest);
            break;
        }
        if (totalbails < 10) {
            Polygon stagepoly = new Polygon();
            String stagewood = "Wood";
            double sf = Math.random();
            if (sf < 0.33) {
                stagewood = "Wood Dark";
            } else if (sf < 0.67) {
                stagewood = "Wood Light";
            }
            MapShape stagems = BattlematDataGenerator.makeRoom(stagetest.getLocation(ViewLevel.BATTLEMAT).getX() / 300.0 - stagetest.getScale() / 100.0 / 2.0, stagetest.getLocation(ViewLevel.BATTLEMAT).getY() / 300.0 - stagetest.getScaleHt() / 100.0 / 2.0, stagetest.getLocation(ViewLevel.BATTLEMAT).getX() / 300.0 + stagetest.getScale() / 100.0 / 2.0, stagetest.getLocation(ViewLevel.BATTLEMAT).getY() / 300.0 + stagetest.getScaleHt() / 100.0 / 2.0, "Rock Dark", 0.0, stagewood, shapelayer);
            shapes.add(stagems);
            stagems.setDsColor(Color.BLACK);
            stagems.setDropShadow(true);
            stagems.setDsRadius(20.0);
            stagems.setDsSpread(0.1);
        }
        double tableareatop = mainroomtop + (kitchenLoc == Direction.NORTH || sideroomlocation == Direction.NORTH ? 0.75 : 0.0);
        double tablearealeft = mainroomleft + (kitchenLoc == Direction.WEST || sideroomlocation == Direction.WEST ? 0.75 : 0.0);
        double tableareabottom = mainroombottom - (kitchenLoc == Direction.SOUTH || sideroomlocation == Direction.SOUTH ? 0.75 : 0.0);
        double tablearearight = mainroomright - (kitchenLoc == Direction.EAST || sideroomlocation == Direction.EAST ? 0.75 : 0.0);
        ArrayList<Feature> horizontalTables = new ArrayList<Feature>();
        ArrayList<Feature> verticalTables = new ArrayList<Feature>();
        for (int k = 0; k < 2; ++k) {
            int numtablestopbottom = (int)((tableareabottom - tableareatop) / (k == 1 ? 1.8 : 1.4));
            double tableSpacingTopBottom = (tableareabottom - tableareatop) / (double)numtablestopbottom;
            int numtablesleftright = (int)((tablearearight - tablearealeft) / (k == 1 ? 1.4 : 1.8));
            double tableSpacingLeftRight = (tablearearight - tablearealeft) / (double)numtablesleftright;
            for (int j = 0; j < numtablesleftright; ++j) {
                for (int i = 0; i < numtablestopbottom; ++i) {
                    Feature table = new Feature("Battlemat/Table Benches Rectangle " + furniture, false, false, false, false, null, k == 1 ? 90.0 : 0.0, null, 160.0, 130.0, null, "table", false, false, false, false, ml);
                    if (k == 0) {
                        horizontalTables.add(table);
                    } else {
                        verticalTables.add(table);
                    }
                    table.setLocation(ViewLevel.BATTLEMAT, new Point2D((tablearealeft + (tableSpacingLeftRight / 2.0 + (double)j * tableSpacingLeftRight)) * 300.0, (tableareatop + tableSpacingTopBottom / 2.0 + (double)i * tableSpacingTopBottom) * 300.0));
                    if (MakeTavern.doesFeatureOverlapOthers(features, table).size() <= 0) continue;
                    horizontalTables.remove(table);
                    verticalTables.remove(table);
                }
            }
        }
        if (!chairorstool.equals("")) {
            MakeTavern.replaceTableBenchesWithStoolsChairs(ml, furniture, horizontalTables);
            MakeTavern.replaceTableBenchesWithStoolsChairs(ml, furniture, verticalTables);
        }
        if (horizontalTables.size() > verticalTables.size()) {
            features.addAll(horizontalTables);
        } else if (horizontalTables.size() < verticalTables.size()) {
            features.addAll(verticalTables);
        } else if (Math.random() < 0.5) {
            features.addAll(horizontalTables);
        } else {
            features.addAll(verticalTables);
        }
        int maxcount = (int)((mainroombottom - mainroomtop) * (mainroomright - mainroomleft) / 40.0) + 1;
        for (int count = 0; count < maxcount; ++count) {
            Feature fireplace = new Feature("Battlemat/Fireplace", false, false, false, false, null, 0.0, null, -1.0, -1.0, false, false, null, "fireplace", false, false, false, false, ml);
            features.add(fireplace);
            MakeTavern.placeFurnitureAgainstWall(features, mainroomleft, mainroomtop, mainroomright, mainroombottom, fireplace, kitchenLoc, fireplace.getScaleFallbackType() / 100.0, fireplace.getScaleHtFallbackType() / 100.0, 0.15, 0, 100);
        }
        features.remove(stagetest);
        MakeTavern.placeWindowsInMainRoom(features, ml, mainroomleft, mainroomtop, mainroomright, mainroombottom, kitchenLoc, sideroomlocation);
    }

    private static void makeTavernPrivateRoom(List<MapShape> shapes, List<Feature> features, String stroketexture, String filltexture, Polygon privateroompoly, double privateroomleft, double privateroomtop, double privateroomright, double privateroombottom, MapLayer ml, MapLayer shapelayer, String furniture) {
        boolean divided;
        MapShape ms = BattlematDataGenerator.makeRoom(privateroomleft, privateroomtop, privateroomright, privateroombottom, stroketexture, 0.1, filltexture, shapelayer);
        shapes.add(ms);
        boolean bl = divided = Math.random() < 0.5;
        if (divided) {
            Polygon apoly = new Polygon();
            Polygon bpoly = new Polygon();
            MapShape ms1 = BattlematDataGenerator.makeRoom(privateroomleft + 3.0, privateroomtop, privateroomright, privateroombottom, stroketexture, 0.1, filltexture, shapelayer);
            shapes.add(ms1);
            MapShape ms2 = BattlematDataGenerator.makeRoom(privateroomleft + 3.0, privateroomtop + 1.5, privateroomright, privateroombottom - 1.5, stroketexture, 0.1, filltexture, shapelayer);
            shapes.add(ms2);
            Feature door = new Feature("Battlemat/Door Wood", false, false, false, false, null, 90.0, null, -1.0, -1.0, null, "door", false, false, false, false, ml);
            door.setLocation(ViewLevel.BATTLEMAT, new Point2D((privateroomleft + 3.0) * 300.0, (privateroomtop + 2.0) * 300.0));
            features.add(door);
            Feature adoor = new Feature("Battlemat/Door Wood", false, false, false, false, null, 0.0, null, -1.0, -1.0, null, "door", false, false, false, false, ml);
            adoor.setLocation(ViewLevel.BATTLEMAT, new Point2D((privateroomright - 1.5) * 300.0, (privateroomtop + 1.5) * 300.0));
            features.add(adoor);
            Feature bdoor = new Feature("Battlemat/Door Wood", false, false, false, false, null, 0.0, null, -1.0, -1.0, null, "door", false, false, false, false, ml);
            bdoor.setLocation(ViewLevel.BATTLEMAT, new Point2D((privateroomright - 1.5) * 300.0, (privateroombottom - 1.5) * 300.0));
            features.add(bdoor);
        }
        double tablew = 2.0;
        double tableh = 1.0;
        double i = privateroomleft + tablew + 0.5;
        while (i <= privateroomright) {
            double j = privateroomtop + 0.65;
            while (j <= privateroombottom - 0.5) {
                if (!(divided && i > privateroomleft + 3.0 && j > privateroomtop + 1.0 && j < privateroombottom - 1.0)) {
                    Feature table1 = new Feature("Battlemat/Table Benches Rectangle " + furniture, false, false, false, false, null, 0.0, null, tablew * 100.0, 100.0, null, "table", false, false, false, false, ml);
                    table1.setLocation(ViewLevel.BATTLEMAT, new Point2D((i - tablew / 2.0) * 300.0, j * 300.0));
                    features.add(table1);
                }
                j = j + tableh + 0.35;
            }
            i = i + tablew + 0.75;
        }
        Feature commonroomdoor = new Feature("Battlemat/Door Wood", false, false, false, false, null, 90.0, null, -1.0, -1.0, null, "door", false, false, false, false, ml);
        commonroomdoor.setLocation(ViewLevel.BATTLEMAT, new Point2D(privateroomright * 300.0, ((privateroombottom - privateroomtop) / 2.0 + privateroomtop) * 300.0));
        features.add(commonroomdoor);
        Feature window1 = new Feature("Battlemat/Window No Light", false, false, false, false, null, 0.0, null, -1.0, -1.0, null, "Window", false, false, false, false, ml);
        window1.setLocation(ViewLevel.BATTLEMAT, new Point2D((privateroomleft + 3.0) * 300.0, privateroomtop * 300.0));
        features.add(window1);
        Feature window2 = new Feature("Battlemat/Window No Light", false, false, false, false, null, 90.0, null, -1.0, -1.0, null, "Window", false, false, false, false, ml);
        window2.setLocation(ViewLevel.BATTLEMAT, new Point2D(privateroomleft * 300.0, (privateroomtop + 2.0) * 300.0));
        features.add(window2);
    }

    private static void makeTavernStorageRoom(List<MapShape> shapes, Polygon storagepoly, List<Feature> features, double storageleft, double storagetop, double storageright, double storagebottom, String stroketexture, String filltexture, MapLayer ml, MapLayer shapelayer, String furniture) {
        MapShape ms = BattlematDataGenerator.makeRoom(storageleft, storagetop, storageright, storagebottom, stroketexture, 0.15, filltexture, shapelayer);
        shapes.add(ms);
        Feature storagedoor = new Feature("Battlemat/Door Wood", false, false, false, false, null, 0.0, null, -1.0, -1.0, null, "door", false, false, false, false, ml);
        storagedoor.setLocation(ViewLevel.BATTLEMAT, new Point2D((storageleft + 0.5) * 300.0, storagebottom * 300.0));
        features.add(storagedoor);
        Feature barrel1 = new Feature("Battlemat/Barrel Wood", false, false, false, false, null, 90.0, null, -1.0, -1.0, null, "table", false, false, false, false, ml);
        barrel1.setLocation(ViewLevel.BATTLEMAT, new Point2D((storageleft + 0.35) * 300.0, (storagetop + 0.35) * 300.0));
        features.add(barrel1);
        Feature barrel2 = new Feature("Battlemat/Barrel Wood", false, false, false, false, null, 90.0, null, -1.0, -1.0, null, "table", false, false, false, false, ml);
        barrel2.setLocation(ViewLevel.BATTLEMAT, new Point2D((storageleft + 0.95) * 300.0, (storagetop + 0.35) * 300.0));
        features.add(barrel2);
        Feature barrel3 = new Feature("Battlemat/Barrel Wood", false, false, false, false, null, 90.0, null, -1.0, -1.0, null, "table", false, false, false, false, ml);
        barrel3.setLocation(ViewLevel.BATTLEMAT, new Point2D((storageleft + 0.35) * 300.0, (storagetop + 0.95) * 300.0));
        features.add(barrel3);
        Feature bookcase1 = new Feature("Battlemat/Bookcase " + furniture, false, false, false, false, null, 0.0, null, 180.0, 60.0, null, "table", false, false, false, false, ml);
        bookcase1.setLocation(ViewLevel.BATTLEMAT, new Point2D((storageright - 1.0) * 300.0, (storagetop + 0.2) * 300.0));
        features.add(bookcase1);
        Feature bookcase2 = new Feature("Battlemat/Bookcase " + furniture, false, false, false, false, null, 180.0, null, 180.0, 60.0, null, "table", false, false, false, false, ml);
        bookcase2.setLocation(ViewLevel.BATTLEMAT, new Point2D((storageright - 1.0) * 300.0, (storagebottom - 0.2) * 300.0));
        features.add(bookcase2);
    }

    public static void furnishOwnersRoom(List<Feature> features, Direction loc, double left, double top, double right, double bottom, MapLayer featurelayer, String furniture) {
        Feature backdoor = new Feature("Battlemat/Door Wood", false, false, false, false, null, 0.0, null, 70.0, 45.0, false, false, null, "door", false, false, false, false, featurelayer);
        features.add(backdoor);
        Feature window = new Feature("Battlemat/Window No Light", false, false, false, false, null, 0.0, null, -1.0, -1.0, false, false, null, "Window", false, false, false, false, featurelayer);
        features.add(window);
        int backdoorx = 0;
        int backdoory = 0;
        if (loc == Direction.NORTH || loc == Direction.SOUTH) {
            backdoorx = (int)(Math.random() * (right - left - 1.0));
            backdoor.setLocation(ViewLevel.BATTLEMAT, new Point2D((left + (double)backdoorx + 0.5) * 300.0, (loc == Direction.SOUTH ? bottom : top) * 300.0));
        } else {
            backdoory = (int)(Math.random() * (bottom - top - 1.0));
            backdoor.setLocation(ViewLevel.BATTLEMAT, new Point2D((loc == Direction.EAST ? right : left) * 300.0, (top + (double)backdoory + 0.5) * 300.0));
            backdoor.setRotate(90.0);
        }
        String[] colors = new String[]{"Blue ", "Red ", ""};
        String color = colors[(int)(Math.random() * (double)colors.length)];
        Feature bed = new Feature("Battlemat/Bed Double " + color + furniture, false, false, false, false, null, 0.0, null, -1.0, -1.0, null, "bed", false, false, false, false, featurelayer);
        features.add(bed);
        MakeTavern.placeFurnitureAgainstWall(features, left, top, right, bottom, bed, null, bed.getScaleFallbackType() / 100.0, bed.getScaleHtFallbackType() / 100.0, 0.0, 0, 20);
        if (!features.contains(bed)) {
            bed = new Feature("Battlemat/Bed " + color + furniture, false, false, false, false, null, 0.0, null, -1.0, -1.0, null, "bed", false, false, false, false, featurelayer);
            features.add(bed);
        }
        Feature desk = new Feature("Battlemat/Desk " + furniture, false, false, false, false, null, 0.0, null, -1.0, -1.0, null, "bed", false, false, false, false, featurelayer);
        features.add(desk);
        MakeTavern.placeFurnitureAgainstWall(features, left, top, right, bottom, desk, null, desk.getScaleFallbackType() / 100.0, desk.getScaleHtFallbackType() / 100.0, 0.0, 0, 20);
        if (features.contains(desk)) {
            Feature chair = new Feature("Battlemat/Chair " + furniture, false, false, false, false, null, 90.0, null, -1.0, -1.0, null, "bed", false, false, false, false, featurelayer);
            features.add(features.size() - 1, chair);
            if (desk.getRotate() == 0.0) {
                chair.setLocation(ViewLevel.BATTLEMAT, desk.getLocation(ViewLevel.BATTLEMAT).getX(), desk.getLocation(ViewLevel.BATTLEMAT).getY() + 50.0);
                chair.setRotate(180.0);
            } else if (desk.getRotate() == 180.0) {
                chair.setLocation(ViewLevel.BATTLEMAT, desk.getLocation(ViewLevel.BATTLEMAT).getX(), desk.getLocation(ViewLevel.BATTLEMAT).getY() - 50.0);
                chair.setRotate(0.0);
            } else if (desk.getRotate() == 90.0) {
                chair.setLocation(ViewLevel.BATTLEMAT, desk.getLocation(ViewLevel.BATTLEMAT).getX() - 50.0, desk.getLocation(ViewLevel.BATTLEMAT).getY());
                chair.setRotate(270.0);
            } else {
                chair.setLocation(ViewLevel.BATTLEMAT, desk.getLocation(ViewLevel.BATTLEMAT).getX() + 50.0, desk.getLocation(ViewLevel.BATTLEMAT).getY());
                chair.setRotate(90.0);
            }
        }
        if (loc == Direction.NORTH || loc == Direction.SOUTH) {
            int tries;
            int windowx = (int)(Math.random() * (right - left - 1.0));
            for (tries = 0; windowx == backdoory && tries < 20; ++tries) {
                windowx = (int)(Math.random() * (right - left - 1.0));
            }
            if (tries < 20) {
                window.setLocation(ViewLevel.BATTLEMAT, new Point2D((left + (double)windowx + 0.5) * 300.0, (loc == Direction.SOUTH ? bottom : top) * 300.0));
            }
        } else {
            int tries;
            int windowy = (int)(Math.random() * (bottom - top - 1.0));
            for (tries = 0; windowy == backdoory && tries < 20; ++tries) {
                windowy = (int)(Math.random() * (bottom - top - 1.0));
            }
            if (tries < 20) {
                window.setRotate(90.0);
                window.setLocation(ViewLevel.BATTLEMAT, new Point2D((loc == Direction.EAST ? right : left) * 300.0, (top + (double)windowy + 0.5) * 300.0));
            }
        }
    }

    public static void furnishPrivy(List<MapShape> shapes, List<Feature> features, Direction loc, double left, double top, double right, double bottom, MapLayer featurelayer) {
        Path path = new Path();
        Feature door = new Feature("Battlemat/Door Wood", false, false, false, false, null, 0.0, null, 70.0, 45.0, false, false, null, "door", false, false, false, false, featurelayer);
        features.add(door);
        Feature privy = new Feature("Battlemat/Privy", false, false, false, false, null, 0.0, null, 92.0, -1.0, null, "privy", false, false, false, false, featurelayer);
        features.add(privy);
        Feature washbasin = new Feature("Battlemat/Wash Basin", false, false, false, false, null, 0.0, null, 90.0, -1.0, null, "wash basin", false, false, false, false, featurelayer);
        features.add(washbasin);
        if (loc == Direction.NORTH) {
            path.getElements().add((Object)new MoveTo((left + 1.0) * 300.0, (top + 1.0) * 300.0));
            path.getElements().add((Object)new LineTo((left + 1.0) * 300.0, top * 300.0));
            door.setLocation(ViewLevel.BATTLEMAT, new Point2D((left + (right - left) / 2.0) * 300.0, bottom * 300.0));
            privy.setLocation(ViewLevel.BATTLEMAT, new Point2D((left + 0.5) * 300.0, (top + 0.28) * 300.0));
            washbasin.setLocation(ViewLevel.BATTLEMAT, new Point2D((right - 0.5) * 300.0, (top + 0.25) * 300.0));
        } else if (loc == Direction.SOUTH) {
            path.getElements().add((Object)new MoveTo((left + 1.0) * 300.0, bottom * 300.0));
            path.getElements().add((Object)new LineTo((left + 1.0) * 300.0, (bottom - 1.0) * 300.0));
            door.setLocation(ViewLevel.BATTLEMAT, new Point2D((left + (right - left) / 2.0) * 300.0, top * 300.0));
            privy.setLocation(ViewLevel.BATTLEMAT, new Point2D((left + 0.5) * 300.0, (bottom - 0.28) * 300.0));
            washbasin.setLocation(ViewLevel.BATTLEMAT, new Point2D((right - 0.5) * 300.0, (bottom - 0.25) * 300.0));
        } else if (loc == Direction.EAST) {
            path.getElements().add((Object)new MoveTo(right * 300.0, (top + 1.0) * 300.0));
            path.getElements().add((Object)new LineTo((right - 1.0) * 300.0, (top + 1.0) * 300.0));
            door.setLocation(ViewLevel.BATTLEMAT, new Point2D(left * 300.0, (top + (bottom - top) / 2.0) * 300.0));
            door.setRotate(90.0);
            privy.setRotate(90.0);
            privy.setLocation(ViewLevel.BATTLEMAT, new Point2D((right - 0.28) * 300.0, (top + 0.5) * 300.0));
            washbasin.setRotate(90.0);
            washbasin.setLocation(ViewLevel.BATTLEMAT, new Point2D((right - 0.25) * 300.0, (bottom - 0.5) * 300.0));
        } else {
            path.getElements().add((Object)new MoveTo(left * 300.0, (top + 1.0) * 300.0));
            path.getElements().add((Object)new LineTo((left + 1.0) * 300.0, (top + 1.0) * 300.0));
            door.setLocation(ViewLevel.BATTLEMAT, new Point2D(right * 300.0, (top + 0.5) * 300.0));
            door.setRotate(90.0);
            privy.setRotate(90.0);
            privy.setLocation(ViewLevel.BATTLEMAT, new Point2D((left + 0.28) * 300.0, (top + 0.5) * 300.0));
            washbasin.setRotate(90.0);
            washbasin.setLocation(ViewLevel.BATTLEMAT, new Point2D((left + 0.25) * 300.0, (bottom - 0.5) * 300.0));
        }
        MapShape ms = BattlematDataGenerator.makeRoom((Shape)path, "Rock Dark", null, 0.15, featurelayer, "room");
        shapes.add(ms);
    }

    public static void placeWindowsInMainRoom(List<Feature> features, MapLayer ml, double mainroomleft, double mainroomtop, double mainroomright, double mainroombottom, Direction kitchenLoc, Direction sideroomlocation) {
        for (Direction direction : Direction.values()) {
            if (kitchenLoc == direction || sideroomlocation == direction) continue;
            int numwindows = (int)((mainroomright - mainroomleft - 1.0) / 2.0);
            double distancebwwindowshalved = (mainroomright - mainroomleft) / (double)numwindows / 2.0;
            if (direction == Direction.EAST || direction == Direction.WEST) {
                numwindows = (int)((mainroombottom - mainroomtop - 1.0) / 2.0);
                distancebwwindowshalved = (mainroombottom - mainroomtop) / (double)numwindows / 2.0;
            }
            for (int i = 0; i < numwindows; ++i) {
                Feature window = new Feature("Battlemat/Window No Light", false, false, false, false, null, 0.0, null, -1.0, -1.0, false, false, null, "Window", false, false, false, false, ml);
                if (direction == Direction.NORTH || direction == Direction.SOUTH) {
                    window.setLocation(ViewLevel.BATTLEMAT, (mainroomleft + distancebwwindowshalved + (double)(i * 2) * distancebwwindowshalved) * 300.0, direction == Direction.NORTH ? mainroomtop * 300.0 : mainroombottom * 300.0);
                } else {
                    window.setLocation(ViewLevel.BATTLEMAT, direction == Direction.EAST ? mainroomright * 300.0 : mainroomleft * 300.0, (mainroomtop + distancebwwindowshalved + (double)(i * 2) * distancebwwindowshalved) * 300.0);
                }
                List<Feature> overlaps = MakeTavern.doesFeatureOverlapOthers(features, window);
                boolean overlapsDoorOrFireplace = false;
                for (Feature f : overlaps) {
                    if (!f.getTypeName().contains("Door") && !f.getTypeName().contains("Fireplace")) continue;
                    overlapsDoorOrFireplace = true;
                    break;
                }
                if (overlapsDoorOrFireplace) continue;
                if (direction == Direction.EAST || direction == Direction.WEST) {
                    window.setRotate(90.0);
                }
                features.add(window);
            }
        }
    }

    public static void replaceTableBenchesWithStoolsChairs(MapLayer ml, String furniture, List<Feature> tables) {
        ArrayList<Feature> toAdd = new ArrayList<Feature>();
        for (Feature f : tables) {
            Feature chair;
            int i;
            f.setType("Battlemat/Table Rectangle " + furniture);
            f.setScaleHt(100.0);
            Point2D tableLoc = f.getLocation(ViewLevel.BATTLEMAT);
            if (f.getRotate() == 0.0 || f.getRotate() == 180.0) {
                for (i = 0; i < 6; ++i) {
                    chair = new Feature("Battlemat/Chair " + furniture, false, false, false, false, null, i % 2 == 0 ? f.getRotate() : f.getRotate() + 180.0, null, 45.0, -1.0, null, "chair", false, false, false, false, ml);
                    chair.setLocation(ViewLevel.BATTLEMAT, tableLoc.getX() - 112.0 + (double)(112 * (i / 2)), tableLoc.getY() + (double)(i % 2 == 0 ? -130 : 130));
                    toAdd.add(chair);
                }
                continue;
            }
            for (i = 0; i < 6; ++i) {
                chair = new Feature("Battlemat/Chair " + furniture, false, false, false, false, null, i % 2 == 0 ? f.getRotate() + 180.0 : f.getRotate(), null, 45.0, -1.0, null, "chair", false, false, false, false, ml);
                chair.setLocation(ViewLevel.BATTLEMAT, tableLoc.getX() + (double)(i % 2 == 0 ? -130 : 130), tableLoc.getY() - 112.0 + (double)(112 * (i / 2)));
                toAdd.add(chair);
            }
        }
        for (Feature f : toAdd) {
            tables.add(0, f);
        }
    }

    public static void makeAndFurnishEntrance(List<MapShape> shapes, List<Feature> features, MapLayer ml, MapLayer shapelayer, String mainfloor, double mainroomleft, double mainroomtop, double mainroomright, double mainroombottom, Direction entrance) {
        double doorlocy;
        double doorlocx;
        Polygon entrancepoly = new Polygon();
        double entranceleft = 0.0;
        double entrancetop = 0.0;
        double entranceright = 0.0;
        double entrancebottom = 0.0;
        Polygon pathpoly = new Polygon();
        Polygon porchpoly = new Polygon();
        Feature door = new Feature("Battlemat/Door Wood", false, false, false, false, null, 0.0, null, 70.0, 45.0, false, false, null, "door", false, false, false, false, ml);
        features.add(door);
        if (entrance == Direction.NORTH || entrance == Direction.SOUTH) {
            doorlocx = mainroomleft + (double)((int)(Math.random() * (mainroomright - mainroomleft))) + 0.5;
            double d = doorlocy = entrance == Direction.NORTH ? mainroomtop : mainroombottom;
            if (Math.random() < 0.5) {
                MapShape porch = BattlematDataGenerator.makeRoom(mainroomleft, entrance == Direction.NORTH ? doorlocy - 1.0 : doorlocy, mainroomright, entrance == Direction.NORTH ? doorlocy : doorlocy + 1.0, "Rock Dark", 0.0, mainfloor, shapelayer);
                shapes.remove(porch);
                shapes.add(0, porch);
            }
            MapShape path = BattlematDataGenerator.makeRoom(doorlocx - 0.45, entrance == Direction.NORTH ? 0.0 : doorlocy, doorlocx + 0.45, entrance == Direction.NORTH ? doorlocy : 20.0, "Rock Dark", 0.0, "Desert Floor", shapelayer);
            path.setTags("path");
            shapes.remove(path);
            shapes.add(0, path);
            if (Math.random() < 0.5) {
                entranceleft = doorlocx - 0.5;
                entranceright = doorlocx + 0.5;
                entrancetop = entrance == Direction.NORTH ? doorlocy - 1.0 : doorlocy;
                entrancebottom = entrance == Direction.NORTH ? doorlocy : doorlocy + 1.0;
                MapShape entranceshape = BattlematDataGenerator.makeRoom(entranceleft, entrancetop, entranceright, entrancebottom, "Rock Dark", 0.15, mainfloor, shapelayer);
                shapes.add(entranceshape);
                Feature outerdoor = new Feature("Battlemat/Door Wood", false, false, false, false, null, 0.0, null, 70.0, 45.0, false, false, null, "door", false, false, false, false, ml);
                features.add(outerdoor);
                outerdoor.setLocation(ViewLevel.BATTLEMAT, new Point2D(doorlocx * 300.0, (entrance == Direction.NORTH ? doorlocy - 1.0 : doorlocy + 1.0) * 300.0));
            }
        } else {
            door.setRotate(90.0);
            doorlocx = entrance == Direction.EAST ? mainroomright : mainroomleft;
            doorlocy = mainroomtop + (double)((int)(Math.random() * (mainroombottom - mainroomtop))) + 0.5;
            if (Math.random() < 0.5) {
                MapShape porch = BattlematDataGenerator.makeRoom(entrance == Direction.EAST ? doorlocx : doorlocx + 1.0, mainroomtop, entrance == Direction.EAST ? doorlocx + 1.0 : doorlocx - 1.0, mainroombottom, "Rock Dark", 0.0, mainfloor, shapelayer);
                shapes.remove(porch);
                shapes.add(0, porch);
            }
            MapShape path = BattlematDataGenerator.makeRoom(entrance == Direction.EAST ? doorlocx : 0.0, doorlocy - 0.45, entrance == Direction.EAST ? 20.0 : doorlocx, doorlocy + 0.45, "Rock Dark", 0.0, "Desert Floor", shapelayer);
            shapes.remove(path);
            path.setTags("path");
            shapes.add(0, path);
            if (Math.random() < 0.5) {
                entranceleft = entrance == Direction.EAST ? doorlocx : doorlocx - 1.0;
                entranceright = entrance == Direction.EAST ? doorlocx + 1.0 : doorlocx;
                entrancetop = doorlocy - 0.5;
                entrancebottom = doorlocy + 0.5;
                MapShape entranceway = BattlematDataGenerator.makeRoom(entranceleft, entrancetop, entranceright, entrancebottom, "Rock Dark", 0.15, mainfloor, shapelayer);
                shapes.add(entranceway);
                Feature outerdoor = new Feature("Battlemat/Door Wood", false, false, false, false, null, 90.0, null, 70.0, 45.0, false, false, null, "door", false, false, false, false, ml);
                features.add(outerdoor);
                outerdoor.setLocation(ViewLevel.BATTLEMAT, new Point2D((entrance == Direction.EAST ? doorlocx + 1.0 : doorlocx - 1.0) * 300.0, doorlocy * 300.0));
            }
        }
        door.setLocation(ViewLevel.BATTLEMAT, new Point2D(doorlocx * 300.0, doorlocy * 300.0));
    }

    public static void furnishSideRoom(List<Feature> features, Direction loc, double left, double top, double right, double bottom, MapLayer featurelayer, String furniture, String chairorstool) {
        Feature window = new Feature("Battlemat/Window No Light", false, false, false, false, null, 0.0, null, -1.0, -1.0, false, false, null, "Window", false, false, false, false, featurelayer);
        Feature door = new Feature("Battlemat/Door Wood", false, false, false, false, null, 0.0, null, 70.0, 45.0, false, false, null, "door", false, false, false, false, featurelayer);
        features.add(door);
        ArrayList<Feature> newfeatures = new ArrayList<Feature>();
        if (loc == Direction.NORTH) {
            door.setLocation(ViewLevel.BATTLEMAT, new Point2D((left + (right - left) / 2.0) * 300.0, bottom * 300.0));
            Feature table = new Feature("Battlemat/Table Benches Rectangle " + furniture, false, false, false, false, null, 90.0, null, 160.0, 130.0, null, "table", false, false, false, false, featurelayer);
            newfeatures.add(table);
            table.setLocation(ViewLevel.BATTLEMAT, new Point2D((left + (right - left) / 2.0) * 300.0, (top + 0.8) * 300.0));
            window.setLocation(ViewLevel.BATTLEMAT, new Point2D((left + (right - left) / 2.0) * 300.0, top * 300.0));
        } else if (loc == Direction.SOUTH) {
            door.setLocation(ViewLevel.BATTLEMAT, new Point2D((left + (right - left) / 2.0) * 300.0, top * 300.0));
            Feature table = new Feature("Battlemat/Table Benches Rectangle " + furniture, false, false, false, false, null, 90.0, null, 160.0, 130.0, null, "table", false, false, false, false, featurelayer);
            newfeatures.add(table);
            table.setLocation(ViewLevel.BATTLEMAT, new Point2D((left + (right - left) / 2.0) * 300.0, (bottom - 0.8) * 300.0));
            window.setLocation(ViewLevel.BATTLEMAT, new Point2D((left + (right - left) / 2.0) * 300.0, bottom * 300.0));
        } else if (loc == Direction.EAST) {
            door.setLocation(ViewLevel.BATTLEMAT, new Point2D(left * 300.0, (top + (bottom - top) / 2.0) * 300.0));
            door.setRotate(90.0);
            Feature table = new Feature("Battlemat/Table Benches Rectangle " + furniture, false, false, false, false, null, 0.0, null, 160.0, 130.0, null, "table", false, false, false, false, featurelayer);
            newfeatures.add(table);
            table.setLocation(ViewLevel.BATTLEMAT, new Point2D((right - 0.8) * 300.0, (top + (bottom - top) / 2.0) * 300.0));
            window.setRotate(90.0);
            window.setLocation(ViewLevel.BATTLEMAT, new Point2D(right * 300.0, (top + (bottom - top) / 2.0) * 300.0));
        } else {
            door.setLocation(ViewLevel.BATTLEMAT, new Point2D(right * 300.0, (top + (bottom - top) / 2.0) * 300.0));
            door.setRotate(90.0);
            Feature table = new Feature("Battlemat/Table Benches Rectangle " + furniture, false, false, false, false, null, 0.0, null, 160.0, 130.0, null, "table", false, false, false, false, featurelayer);
            newfeatures.add(table);
            table.setLocation(ViewLevel.BATTLEMAT, new Point2D((left + 0.8) * 300.0, (top + (bottom - top) / 2.0) * 300.0));
            window.setRotate(90.0);
            window.setLocation(ViewLevel.BATTLEMAT, new Point2D(left * 300.0, (top + (bottom - top) / 2.0) * 300.0));
        }
        if (!chairorstool.equals("")) {
            MakeTavern.replaceTableBenchesWithStoolsChairs(featurelayer, furniture, newfeatures);
        }
        features.addAll(newfeatures);
        features.add(window);
    }

    public static void furnishPantry(List<Feature> features, Direction loc, double left, double top, double right, double bottom, String strokename, MapLayer featurelayer) {
        Feature backdoor = new Feature("Battlemat/Door Wood", false, false, false, false, null, 0.0, null, 70.0, 45.0, false, false, null, "door", false, false, false, false, featurelayer);
        features.add(backdoor);
        if (loc == Direction.NORTH || loc == Direction.SOUTH) {
            int x = (int)(Math.random() * (right - left));
            backdoor.setLocation(ViewLevel.BATTLEMAT, (left + (double)x + 0.5) * 300.0, (loc == Direction.NORTH ? top : bottom) * 300.0);
        } else {
            int y = (int)(Math.random() * (bottom - top));
            backdoor.setRotate(90.0);
            backdoor.setLocation(ViewLevel.BATTLEMAT, (loc == Direction.EAST ? right : left) * 300.0, (top + (double)y + 0.5) * 300.0);
        }
        Point2D backdoorloc = backdoor.getLocation(ViewLevel.BATTLEMAT);
        int maxcount = (int)(((bottom - top) * 2.0 + (right - left) * 2.0) * 1.5);
        for (int count = 0; count < maxcount; ++count) {
            String[] types = new String[]{"Crate", "Crate Light", "Crate Medium", "Barrel Wood"};
            Feature crate = new Feature("Battlemat/" + types[(int)(Math.random() * (double)types.length)], false, false, false, false, null, (double)((int)(Math.random() * 4.0)) * 90.0, null, -1.0, -1.0, false, false, null, "storage", false, false, false, false, featurelayer);
            features.add(crate);
            MakeTavern.placeFurnitureAgainstWall(features, left, top, right, bottom, crate, null, crate.getScaleFallbackType() / 98.0, crate.getScaleHtFallbackType() / 98.0, 0.0, 0, 20);
        }
    }

    public static void furnishKitchen(List<Feature> features, Direction kitchenLoc, double kitchenleft, double kitchentop, double kitchenright, double kitchenbottom, double pantrytop, double pantryleft, MapLayer featurelayer, String furniture) {
        Feature door = new Feature("Battlemat/Door Wood", false, false, false, false, null, 0.0, null, 70.0, 45.0, false, false, null, "door", false, false, false, false, featurelayer);
        features.add(door);
        Feature pantrydoor = new Feature("Battlemat/Door Wood", false, false, false, false, null, 90.0, null, 70.0, 45.0, false, false, null, "door", false, false, false, false, featurelayer);
        features.add(pantrydoor);
        Feature backdoor = new Feature("Battlemat/Door Wood", false, false, false, false, null, 0.0, null, 70.0, 45.0, false, false, null, "door", false, false, false, false, featurelayer);
        features.add(backdoor);
        Feature kitchenfire1 = new Feature("Battlemat/Fireplace", false, false, false, false, null, 0.0, null, -1.0, -1.0, null, "table", false, false, false, false, featurelayer);
        features.add(kitchenfire1);
        Feature kitchenfire2 = new Feature("Battlemat/Fireplace", false, false, false, false, null, 0.0, null, -1.0, -1.0, null, "table", false, false, false, false, featurelayer);
        features.add(kitchenfire2);
        Feature sidetable = new Feature("Battlemat/Table Rectangle " + furniture, false, false, false, false, null, 0.0, null, -1.0, -1.0, null, "table", false, false, false, false, featurelayer);
        features.add(sidetable);
        Feature sidetable2 = new Feature("Battlemat/Table Rectangle " + furniture, false, false, false, false, null, 0.0, null, -1.0, -1.0, null, "table", false, false, false, false, featurelayer);
        features.add(sidetable2);
        Feature centertable = new Feature("Battlemat/Table Rectangle " + furniture, false, false, false, false, null, 0.0, null, -1.0, -1.0, null, "table", false, false, false, false, featurelayer);
        features.add(centertable);
        Feature window = new Feature("Battlemat/Window No Light", false, false, false, false, null, 0.0, null, -1.0, -1.0, false, false, null, "Window", false, false, false, false, featurelayer);
        features.add(window);
        switch (kitchenLoc) {
            case NORTH: 
            case SOUTH: {
                int doorloc = Math.random() < 0.5 ? 0 : (int)(kitchenright - kitchenleft - 1.0);
                door.setLocation(ViewLevel.BATTLEMAT, new Point2D((kitchenleft + (double)doorloc + 0.5) * 300.0, (kitchenLoc == Direction.NORTH ? kitchenbottom : kitchentop) * 300.0));
                int pantrydoorloc = (int)(Math.random() * (kitchenbottom - kitchentop));
                if (kitchenright == pantryleft) {
                    pantrydoor.setLocation(ViewLevel.BATTLEMAT, new Point2D(kitchenright * 300.0, (kitchenbottom - (double)pantrydoorloc - 0.5) * 300.0));
                } else {
                    pantrydoor.setLocation(ViewLevel.BATTLEMAT, new Point2D(kitchenleft * 300.0, (kitchenbottom - (double)pantrydoorloc - 0.5) * 300.0));
                }
                centertable.setLocation(ViewLevel.BATTLEMAT, new Point2D((kitchenleft + (kitchenright - kitchenleft) / 2.0) * 300.0, (kitchenLoc == Direction.NORTH ? kitchentop + 1.0 : kitchenbottom - 1.0) * 300.0));
                centertable.setRotate(90.0);
                Direction fireplacewall = kitchenLoc == Direction.NORTH ? Direction.SOUTH : Direction.NORTH;
                MakeTavern.placeFurnitureAgainstWall(features, kitchenleft, kitchentop, kitchenright, kitchenbottom, kitchenfire1, fireplacewall, 1.5, 0.58, 0.0, 0, 20);
                MakeTavern.placeFurnitureAgainstWall(features, kitchenleft, kitchentop, kitchenright, kitchenbottom, sidetable, null, sidetable.getScaleFallbackType() / 100.0, sidetable.getScaleHtFallbackType() / 100.0, 0.0, 0, 20);
                MakeTavern.placeFurnitureAgainstWall(features, kitchenleft, kitchentop, kitchenright, kitchenbottom, kitchenfire2, null, 1.5, 0.58, 0.0, 0, 20);
                MakeTavern.placeFurnitureAgainstWall(features, kitchenleft, kitchentop, kitchenright, kitchenbottom, sidetable2, null, sidetable2.getScaleFallbackType() / 100.0, sidetable2.getScaleHtFallbackType() / 100.0, 0.0, 0, 100);
                window.setLocation(ViewLevel.BATTLEMAT, new Point2D((kitchenleft + (kitchenright - kitchenleft) / 2.0) * 300.0, (kitchenLoc == Direction.NORTH ? kitchentop : kitchenbottom) * 300.0));
                break;
            }
            case EAST: 
            case WEST: {
                int doorloc = Math.random() < 0.5 ? 0 : (int)(kitchenbottom - kitchentop - 1.0);
                door.setLocation(ViewLevel.BATTLEMAT, new Point2D((kitchenLoc == Direction.WEST ? kitchenright : kitchenleft) * 300.0, (kitchentop + (double)doorloc + 0.5) * 300.0));
                door.setRotate(90.0);
                int pantrydoorloc = (int)(Math.random() * (kitchenright - kitchenleft));
                pantrydoor.setRotate(0.0);
                if (kitchenbottom == pantrytop) {
                    pantrydoor.setLocation(ViewLevel.BATTLEMAT, new Point2D((kitchenleft + (double)pantrydoorloc + 0.5) * 300.0, kitchenbottom * 300.0));
                } else {
                    pantrydoor.setLocation(ViewLevel.BATTLEMAT, new Point2D((kitchenleft + (double)pantrydoorloc + 0.5) * 300.0, kitchentop * 300.0));
                }
                centertable.setLocation(ViewLevel.BATTLEMAT, new Point2D((kitchenLoc == Direction.WEST ? kitchenleft + 1.0 : kitchenright - 1.0) * 300.0, (kitchentop + (kitchenbottom - kitchentop) / 2.0) * 300.0));
                centertable.setRotate(0.0);
                Direction fireplacewall = kitchenLoc == Direction.WEST ? Direction.EAST : Direction.WEST;
                MakeTavern.placeFurnitureAgainstWall(features, kitchenleft, kitchentop, kitchenright, kitchenbottom, kitchenfire1, fireplacewall, 1.5, 0.58, 0.0, 0, 20);
                MakeTavern.placeFurnitureAgainstWall(features, kitchenleft, kitchentop, kitchenright, kitchenbottom, sidetable, null, sidetable.getScaleFallbackType() / 100.0, sidetable.getScaleHtFallbackType() / 100.0, 0.0, 0, 20);
                MakeTavern.placeFurnitureAgainstWall(features, kitchenleft, kitchentop, kitchenright, kitchenbottom, kitchenfire2, null, 1.5, 0.58, 0.0, 0, 20);
                MakeTavern.placeFurnitureAgainstWall(features, kitchenleft, kitchentop, kitchenright, kitchenbottom, sidetable2, null, sidetable2.getScaleFallbackType() / 100.0, sidetable2.getScaleHtFallbackType() / 100.0, 0.0, 0, 100);
                window.setLocation(ViewLevel.BATTLEMAT, new Point2D((kitchenLoc == Direction.EAST ? kitchenright : kitchenleft) * 300.0, (kitchentop + (kitchenbottom - kitchentop) / 2.0) * 300.0));
                window.setRotate(90.0);
            }
        }
    }

    public static int placeFurnitureAgainstWall(List<Feature> features, double wallleft, double walltop, double wallright, double wallbottom, Feature f, Direction preferredWall, double w, double h, double offset, int initrotate, int maxtries) {
        int bailcount;
        for (bailcount = 0; bailcount < maxtries && (f.getLocation(ViewLevel.BATTLEMAT) == null || MakeTavern.doesFeatureOverlapOthers(features, f).size() > 0); ++bailcount) {
            Direction wall = Direction.values()[(int)(Math.random() * (double)Direction.values().length)];
            if (preferredWall != null && bailcount < maxtries / 2) {
                wall = preferredWall;
            }
            double x = 0.0;
            double y = 0.0;
            if (wall == Direction.SOUTH) {
                f.setRotate(initrotate + 180);
                x = Math.random() * (wallright - wallleft - w) + w / 2.0;
                y = h / 2.0;
                f.setLocation(ViewLevel.BATTLEMAT, (wallleft + x) * 300.0, (wallbottom - y + offset) * 300.0);
                continue;
            }
            if (wall == Direction.NORTH) {
                f.setRotate(initrotate);
                x = Math.random() * (wallright - wallleft - w) + w / 2.0;
                y = h / 2.0;
                f.setLocation(ViewLevel.BATTLEMAT, (wallleft + x) * 300.0, (walltop + y - offset) * 300.0);
                continue;
            }
            if (wall == Direction.EAST) {
                f.setRotate(initrotate + 90);
                x = h / 2.0;
                y = Math.random() * (wallbottom - walltop - w) + w / 2.0;
                f.setLocation(ViewLevel.BATTLEMAT, (wallright - x + offset) * 300.0, (walltop + y) * 300.0);
                continue;
            }
            f.setRotate(initrotate + 270);
            x = h / 2.0;
            y = Math.random() * (wallbottom - walltop - w) + w / 2.0;
            f.setLocation(ViewLevel.BATTLEMAT, (wallleft + x - offset) * 300.0, (walltop + y) * 300.0);
        }
        if (bailcount >= maxtries) {
            features.remove(f);
        }
        return bailcount;
    }

    public static List<Feature> doesFeatureOverlapOthers(List<Feature> features, Feature newfeature) {
        Point2D newfloc = newfeature.getLocation(ViewLevel.BATTLEMAT);
        boolean rotated = newfeature.getRotate() == 90.0 || newfeature.getRotate() == 270.0;
        ArrayList<Feature> overlappingItems = new ArrayList<Feature>();
        Rectangle newbounds = new Rectangle(newfloc.getX() - 3.0 * (rotated ? newfeature.getScaleHtFallbackType() : newfeature.getScaleFallbackType()) / 2.0, newfloc.getY() - 3.0 * (rotated ? newfeature.getScaleFallbackType() : newfeature.getScaleHtFallbackType()) / 2.0, 3.0 * (rotated ? newfeature.getScaleHtFallbackType() : newfeature.getScaleFallbackType()), 3.0 * (rotated ? newfeature.getScaleFallbackType() : newfeature.getScaleHtFallbackType()));
        for (Feature f : features) {
            Point2D loc;
            if (f == newfeature || (f.getTypeName().startsWith("Battlemat/Crate") || f.getTypeName().startsWith("Battlemat/Barrel")) && (newfeature.getTypeName().startsWith("Battlemat/Crate") || newfeature.getTypeName().startsWith("Battlemat/Barrel")) || (loc = f.getLocation(ViewLevel.BATTLEMAT)) == null) continue;
            Rectangle bounds = new Rectangle(loc.getX() - 3.0 * (rotated ? f.getScaleHtFallbackType() : f.getScaleFallbackType()) / 2.0, loc.getY() - 3.0 * (rotated ? f.getScaleFallbackType() : f.getScaleHtFallbackType()) / 2.0, 3.0 * (rotated ? f.getScaleHtFallbackType() : f.getScaleFallbackType()), 3.0 * (rotated ? f.getScaleFallbackType() : f.getScaleHtFallbackType()));
            if (f.getTypeName().contains("Door")) {
                if (f.getRotate() == 90.0 || f.getRotate() == 270.0) {
                    bounds.setX(bounds.getX() + bounds.getWidth() / 2.0 - 210.0);
                    bounds.setWidth(420.0);
                } else {
                    bounds.setY(bounds.getY() + bounds.getHeight() / 2.0 - 210.0);
                    bounds.setHeight(420.0);
                }
            }
            if (!newbounds.intersects(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight())) continue;
            overlappingItems.add(f);
        }
        return overlappingItems;
    }
}

