/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.generator.battlemat;

import com.inkwellideas.ographer.data.MapLayer;
import com.inkwellideas.ographer.data.ViewLevel;
import com.inkwellideas.ographer.generator.battlemat.BattlematDataGenerator;
import com.inkwellideas.ographer.map.MapShape;
import com.inkwellideas.ographer.map.Terrain;
import com.inkwellideas.ographer.model.Feature;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javafx.geometry.Point2D;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.Polygon;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;

public class Tower {
    public static Terrain[][] generateTower(Terrain[][] t, List<MapShape> shapes, List<Feature> features, MapLayer featureLayer, MapLayer shapelayer, Map<String, Object> options) {
        int level;
        double tf;
        Polygon groundPoly = new Polygon();
        shapes.add(BattlematDataGenerator.makeRoom(0.0, 0.0, 20.0, 20.0, "Rock Dark", 0.0, "Forest Floor", shapelayer));
        String furniture = "Pine";
        double ff = Math.random();
        if (ff < 0.33) {
            furniture = "Walnut";
        } else if (ff < 0.66) {
            furniture = "Weathered";
        }
        String mainfloor = "Cobblestone Light";
        double mf = Math.random();
        if (mf < 0.2) {
            mainfloor = "Cobblestone Dark";
        } else if (mf < 0.35) {
            mainfloor = "Cobblestone";
        } else if (mf < 0.5) {
            mainfloor = "Wood";
        } else if (mf < 0.65) {
            mainfloor = "Wood Dark";
        } else if (mf < 0.85) {
            mainfloor = "Wood Light";
        }
        double kf = Math.random();
        if (kf < 0.33 || kf < 0.66) {
            // empty if block
        }
        if ((tf = Math.random()) < 0.33 || tf < 0.66) {
            // empty if block
        }
        HashSet<Rectangle> featureBoundingBoxes = new HashSet<Rectangle>();
        boolean complete = false;
        int x = 0;
        int y = 0;
        int wrapLevels = (Integer)options.get("levels wrap");
        int roof = level = (Integer)options.get("levels above") + 1;
        int bottomLevel = (Integer)options.get("levels below");
        int levelWidth = (Integer)options.get("level width");
        String purpose = (String)options.get("purpose");
        String stairLoc = (String)options.get("stair location");
        double stairLocX = 4.0;
        double stairLocY = 4.0;
        if (stairLoc.contains("Lower")) {
            stairLocY = 3 + levelWidth - 1;
        }
        if (stairLoc.contains("Right")) {
            stairLocX = 3 + levelWidth - 1;
        }
        double stairRotate = 270.0;
        if (stairLocX > 5.0 && stairLocY > 5.0) {
            stairRotate = 90.0;
        } else if (stairLocX > 5.0) {
            stairRotate = 0.0;
        } else if (stairLocY > 5.0) {
            stairRotate = 180.0;
        }
        int maxX = 0;
        int maxY = 0;
        while (!complete) {
            if (x >= wrapLevels) {
                ++y;
                x = 0;
            }
            if (x > maxX) {
                maxX = x;
            }
            if (y > maxY) {
                maxY = y;
            }
            String texture = null;
            if (level == 1) {
                texture = "Forest Floor";
            }
            if (level == 0) {
                if (level < -bottomLevel) {
                    complete = true;
                }
                --level;
                continue;
            }
            if (level < 0) {
                texture = "Cobblestone";
            }
            Polygon poly = new Polygon();
            shapes.add(BattlematDataGenerator.makeRoom(x * (levelWidth + 6), y * (levelWidth + 6), (x + 1) * (levelWidth + 6), (y + 1) * (levelWidth + 6), "Rock Dark", 0.0, texture, shapelayer));
            if (texture == null) {
                poly.setFill((Paint)Color.LIGHTBLUE);
            }
            Polygon roomPoly = new Polygon();
            double roomLeft = x * (levelWidth + 6) + 3;
            double roomTop = y * (levelWidth + 6) + 3;
            double roomRight = (x + 1) * (levelWidth + 6) - 3;
            double roomBottom = (y + 1) * (levelWidth + 6) - 3;
            shapes.add(BattlematDataGenerator.makeRoom(roomLeft, roomTop, roomRight, roomBottom, "Rock Dark", 0.15, mainfloor, shapelayer));
            Feature stair = new Feature("Battlemat/Stairs Stone Spiral Square", false, false, false, false, null, stairRotate, null, -1.0, -1.0, false, false, null, "stair", false, false, false, false, shapelayer);
            stair.setLocation(ViewLevel.BATTLEMAT, new Point2D(((double)(x * (levelWidth + 6)) + stairLocX) * 300.0, ((double)(y * (levelWidth + 6)) + stairLocY) * 300.0));
            features.add(stair);
            Path path = new Path();
            if (stairRotate == 0.0) {
                path.getElements().add((Object)new MoveTo(((double)(x * (levelWidth + 6)) + stairLocX - 1.0) * 300.0, ((double)(y * (levelWidth + 6)) + stairLocY) * 300.0));
                path.getElements().add((Object)new LineTo(((double)(x * (levelWidth + 6)) + stairLocX - 1.0) * 300.0, ((double)(y * (levelWidth + 6)) + stairLocY - 1.0) * 300.0));
                path.getElements().add((Object)new LineTo(((double)(x * (levelWidth + 6)) + stairLocX + 1.0) * 300.0, ((double)(y * (levelWidth + 6)) + stairLocY - 1.0) * 300.0));
                path.getElements().add((Object)new LineTo(((double)(x * (levelWidth + 6)) + stairLocX + 1.0) * 300.0, ((double)(y * (levelWidth + 6)) + stairLocY + 1.0) * 300.0));
                path.getElements().add((Object)new LineTo(((double)(x * (levelWidth + 6)) + stairLocX) * 300.0, ((double)(y * (levelWidth + 6)) + stairLocY + 1.0) * 300.0));
            } else if (stairRotate == 90.0) {
                path.getElements().add((Object)new MoveTo(((double)(x * (levelWidth + 6)) + stairLocX) * 300.0, ((double)(y * (levelWidth + 6)) + stairLocY - 1.0) * 300.0));
                path.getElements().add((Object)new LineTo(((double)(x * (levelWidth + 6)) + stairLocX + 1.0) * 300.0, ((double)(y * (levelWidth + 6)) + stairLocY - 1.0) * 300.0));
                path.getElements().add((Object)new LineTo(((double)(x * (levelWidth + 6)) + stairLocX + 1.0) * 300.0, ((double)(y * (levelWidth + 6)) + stairLocY + 1.0) * 300.0));
                path.getElements().add((Object)new LineTo(((double)(x * (levelWidth + 6)) + stairLocX - 1.0) * 300.0, ((double)(y * (levelWidth + 6)) + stairLocY + 1.0) * 300.0));
                path.getElements().add((Object)new LineTo(((double)(x * (levelWidth + 6)) + stairLocX - 1.0) * 300.0, ((double)(y * (levelWidth + 6)) + stairLocY) * 300.0));
            } else if (stairRotate == 180.0) {
                path.getElements().add((Object)new MoveTo(((double)(x * (levelWidth + 6)) + stairLocX + 1.0) * 300.0, ((double)(y * (levelWidth + 6)) + stairLocY) * 300.0));
                path.getElements().add((Object)new LineTo(((double)(x * (levelWidth + 6)) + stairLocX + 1.0) * 300.0, ((double)(y * (levelWidth + 6)) + stairLocY + 1.0) * 300.0));
                path.getElements().add((Object)new LineTo(((double)(x * (levelWidth + 6)) + stairLocX - 1.0) * 300.0, ((double)(y * (levelWidth + 6)) + stairLocY + 1.0) * 300.0));
                path.getElements().add((Object)new LineTo(((double)(x * (levelWidth + 6)) + stairLocX - 1.0) * 300.0, ((double)(y * (levelWidth + 6)) + stairLocY - 1.0) * 300.0));
                path.getElements().add((Object)new LineTo(((double)(x * (levelWidth + 6)) + stairLocX) * 300.0, ((double)(y * (levelWidth + 6)) + stairLocY - 1.0) * 300.0));
            } else if (stairRotate == 270.0) {
                path.getElements().add((Object)new MoveTo(((double)(x * (levelWidth + 6)) + stairLocX) * 300.0, ((double)(y * (levelWidth + 6)) + stairLocY + 1.0) * 300.0));
                path.getElements().add((Object)new LineTo(((double)(x * (levelWidth + 6)) + stairLocX - 1.0) * 300.0, ((double)(y * (levelWidth + 6)) + stairLocY + 1.0) * 300.0));
                path.getElements().add((Object)new LineTo(((double)(x * (levelWidth + 6)) + stairLocX - 1.0) * 300.0, ((double)(y * (levelWidth + 6)) + stairLocY - 1.0) * 300.0));
                path.getElements().add((Object)new LineTo(((double)(x * (levelWidth + 6)) + stairLocX + 1.0) * 300.0, ((double)(y * (levelWidth + 6)) + stairLocY - 1.0) * 300.0));
                path.getElements().add((Object)new LineTo(((double)(x * (levelWidth + 6)) + stairLocX + 1.0) * 300.0, ((double)(y * (levelWidth + 6)) + stairLocY) * 300.0));
            }
            MapShape stairMS = BattlematDataGenerator.makeRoom((Shape)path, "Rock Dark", null, 0.15, featureLayer, "room");
            shapes.add(stairMS);
            featureBoundingBoxes.add(new Rectangle(((double)(x * (levelWidth + 6)) + stairLocX) * 300.0 - 300.0, ((double)(y * (levelWidth + 6)) + stairLocY) * 300.0 - 300.0, 600.0, 600.0));
            if (roof == level) {
                Polygon crenelation = new Polygon();
                MapShape ms = BattlematDataGenerator.makeRoom(roomLeft, roomTop, roomRight, roomBottom, "Rock Light", 0.15, null, shapelayer);
                ms.setStrokeType(MapShape.StrokeType.DASHED);
                shapes.add(ms);
                if (purpose.contains("Wizard")) {
                    Feature magicCircle = new Feature("Battlemat/Magic Circle", false, false, false, false, null, 0.0, null, 200.0, 200.0, false, false, null, "magic", false, false, false, false, featureLayer);
                    magicCircle.setLocation(ViewLevel.BATTLEMAT, new Point2D(((double)(x * (levelWidth + 6) + 3) + (double)levelWidth / 2.0) * 300.0, ((double)(y * (levelWidth + 6) + 3) + (double)levelWidth / 2.0) * 300.0));
                    features.add(magicCircle);
                }
            } else {
                double rangeY;
                double minY;
                double rangeX;
                int tries;
                String levelType = (String)options.get("levelType" + level);
                boolean placed = false;
                for (tries = 0; !placed && level == 0 && tries < 10; ++tries) {
                    double doorLocX;
                    int doorRotate = (int)(Math.random() * 4.0) * 90;
                    double d = doorRotate == 0 || doorRotate == 180 ? (double)(x * (levelWidth + 6) + 3) + (double)levelWidth / 2.0 : (doorLocX = (double)(doorRotate == 90 ? x * (levelWidth + 6) + 3 : x * (levelWidth + 6) + 3 + levelWidth));
                    double doorLocY = doorRotate == 90 || doorRotate == 270 ? (double)(y * (levelWidth + 6) + 3) + (double)levelWidth / 2.0 : (double)(doorRotate == 0 ? y * (levelWidth + 6) + 3 : y * (levelWidth + 6) + 3 + levelWidth);
                    Rectangle fRect = new Rectangle(doorLocX * 300.0 - 130.0, doorLocY * 300.0 - 130.0, 260.0, 260.0);
                    double fWidth = 260.0;
                    double fHeight = 260.0;
                    boolean intersect = BattlematDataGenerator.isIntersect(featureBoundingBoxes, doorLocX, doorLocY, fWidth, fHeight);
                    if (intersect) continue;
                    BattlematDataGenerator.placeFeature(features, featureLayer, featureBoundingBoxes, doorRotate, doorLocX, doorLocY, -1.0, -1.0, "Battlemat/Door " + furniture, "door");
                    placed = true;
                }
                if ("Barracks".equals(levelType) || "Jail".equals(levelType)) {
                    if (levelWidth == 4) {
                        if ("Barracks".equals(levelType)) {
                            if (stairRotate == 0.0) {
                                path.getElements().add((Object)new MoveTo(((double)(x * (levelWidth + 6)) + stairLocX) * 300.0, ((double)(y * (levelWidth + 6)) + stairLocY + 1.0) * 300.0));
                                path.getElements().add((Object)new LineTo(((double)(x * (levelWidth + 6)) + stairLocX - 1.0) * 300.0, ((double)(y * (levelWidth + 6)) + stairLocY + 1.0) * 300.0));
                                path.getElements().add((Object)new LineTo(((double)(x * (levelWidth + 6)) + stairLocX - 1.0) * 300.0, ((double)(y * (levelWidth + 6)) + stairLocY) * 300.0));
                                BattlematDataGenerator.placeFeature(features, featureLayer, featureBoundingBoxes, 90, (double)(x * (levelWidth + 6)) + stairLocX - 1.0, (double)(y * (levelWidth + 6)) + stairLocY + 0.5, -1.0, -1.0, "Battlemat/Door " + furniture, "door");
                            } else if (stairRotate == 90.0) {
                                path.getElements().add((Object)new MoveTo(((double)(x * (levelWidth + 6)) + stairLocX - 1.0) * 300.0, ((double)(y * (levelWidth + 6)) + stairLocY) * 300.0));
                                path.getElements().add((Object)new LineTo(((double)(x * (levelWidth + 6)) + stairLocX - 1.0) * 300.0, ((double)(y * (levelWidth + 6)) + stairLocY - 1.0) * 300.0));
                                path.getElements().add((Object)new LineTo(((double)(x * (levelWidth + 6)) + stairLocX) * 300.0, ((double)(y * (levelWidth + 6)) + stairLocY - 1.0) * 300.0));
                                BattlematDataGenerator.placeFeature(features, featureLayer, featureBoundingBoxes, 90, (double)(x * (levelWidth + 6)) + stairLocX - 1.0, (double)(y * (levelWidth + 6)) + stairLocY - 0.5, -1.0, -1.0, "Battlemat/Door " + furniture, "door");
                            } else if (stairRotate == 180.0) {
                                path.getElements().add((Object)new MoveTo(((double)(x * (levelWidth + 6)) + stairLocX + 1.0) * 300.0, ((double)(y * (levelWidth + 6)) + stairLocY) * 300.0));
                                path.getElements().add((Object)new LineTo(((double)(x * (levelWidth + 6)) + stairLocX + 1.0) * 300.0, ((double)(y * (levelWidth + 6)) + stairLocY - 1.0) * 300.0));
                                path.getElements().add((Object)new LineTo(((double)(x * (levelWidth + 6)) + stairLocX) * 300.0, ((double)(y * (levelWidth + 6)) + stairLocY - 1.0) * 300.0));
                                BattlematDataGenerator.placeFeature(features, featureLayer, featureBoundingBoxes, 90, (double)(x * (levelWidth + 6)) + stairLocX + 1.0, (double)(y * (levelWidth + 6)) + stairLocY - 0.5, -1.0, -1.0, "Battlemat/Door " + furniture, "door");
                            } else if (stairRotate == 270.0) {
                                path.getElements().add((Object)new MoveTo(((double)(x * (levelWidth + 6)) + stairLocX + 1.0) * 300.0, ((double)(y * (levelWidth + 6)) + stairLocY) * 300.0));
                                path.getElements().add((Object)new LineTo(((double)(x * (levelWidth + 6)) + stairLocX + 1.0) * 300.0, ((double)(y * (levelWidth + 6)) + stairLocY + 1.0) * 300.0));
                                path.getElements().add((Object)new LineTo(((double)(x * (levelWidth + 6)) + stairLocX) * 300.0, ((double)(y * (levelWidth + 6)) + stairLocY + 1.0) * 300.0));
                                BattlematDataGenerator.placeFeature(features, featureLayer, featureBoundingBoxes, 90, (double)(x * (levelWidth + 6)) + stairLocX + 1.0, (double)(y * (levelWidth + 6)) + stairLocY + 0.5, -1.0, -1.0, "Battlemat/Door " + furniture, "door");
                            }
                        } else if (stairRotate == 0.0) {
                            for (i = 0; i < 3; ++i) {
                                BattlematDataGenerator.placeFeature(features, featureLayer, featureBoundingBoxes, 90, (double)(x * (levelWidth + 6)) + stairLocX - 1.0, (double)(y * (levelWidth + 6)) + stairLocY + (double)i + 0.5, -1.0, -1.0, "Battlemat/Bars", "door");
                            }
                        } else if (stairRotate == 90.0) {
                            for (i = 0; i < 3; ++i) {
                                BattlematDataGenerator.placeFeature(features, featureLayer, featureBoundingBoxes, 90, (double)(x * (levelWidth + 6)) + stairLocX - 1.0, (double)(y * (levelWidth + 6)) + stairLocY - (double)i - 0.5, -1.0, -1.0, "Battlemat/Bars", "door");
                            }
                        } else if (stairRotate == 180.0) {
                            for (i = 0; i < 3; ++i) {
                                BattlematDataGenerator.placeFeature(features, featureLayer, featureBoundingBoxes, 90, (double)(x * (levelWidth + 6)) + stairLocX + 1.0, (double)(y * (levelWidth + 6)) + stairLocY - (double)i - 0.5, -1.0, -1.0, "Battlemat/Bars", "door");
                            }
                        } else if (stairRotate == 270.0) {
                            for (i = 0; i < 3; ++i) {
                                BattlematDataGenerator.placeFeature(features, featureLayer, featureBoundingBoxes, 90, (double)(x * (levelWidth + 6)) + stairLocX + 1.0, (double)(y * (levelWidth + 6)) + stairLocY + (double)i + 0.5, -1.0, -1.0, "Battlemat/Bars", "door");
                            }
                        }
                        double minX = (double)(x * (levelWidth + 6) + 3) + 0.85;
                        rangeX = 0.0;
                        minY = (double)(y * (levelWidth + 6)) + 3.4;
                        rangeY = (double)levelWidth - 0.8;
                        Object itemType = "Battlemat/Bed " + furniture;
                        if ("Jail".equals(levelType)) {
                            itemType = "Battlemat/Bed Strawmat";
                        }
                        String itemTags = "bed";
                        for (i = 0; i < 10; ++i) {
                            BattlematDataGenerator.checkAndPlaceFeature(features, featureLayer, featureBoundingBoxes, (String)itemType, itemTags, minX, rangeX, minY, rangeY, "Jail".equals(levelType) ? 0.0 : 270.0);
                        }
                        for (i = 0; i < 10; ++i) {
                            BattlematDataGenerator.checkAndPlaceFeature(features, featureLayer, featureBoundingBoxes, (String)itemType, itemTags, (double)(x * (levelWidth + 6) + 3 + levelWidth) - 0.85, rangeX, minY, rangeY, "Jail".equals(levelType) ? 0.0 : 90.0);
                        }
                    } else if ("Barracks".equals(levelType)) {
                        Feature f;
                        int i;
                        int i2;
                        int roomWidth = 2;
                        if (levelWidth >= 6) {
                            roomWidth = levelWidth == 6 && Math.random() < 0.5 ? 2 : 3;
                        }
                        int top = y * (levelWidth + 6) + 3;
                        if (stairRotate == 270.0) {
                            top += 2;
                        }
                        int bottom = y * (levelWidth + 6) + 3 + levelWidth;
                        if (stairRotate == 180.0) {
                            bottom -= 2;
                        }
                        for (i2 = top; i2 < bottom; i2 += 2) {
                            int diff = 2;
                            if (i2 == top && (bottom - top) % 2 == 1) {
                                diff = 3;
                            }
                            shapes.add(BattlematDataGenerator.makeRoom(x * (levelWidth + 6) + 3, i2, x * (levelWidth + 6) + 3 + roomWidth, i2 + diff, "Rock Dark", 0.15, mainfloor, shapelayer));
                            BattlematDataGenerator.placeFeature(features, featureLayer, featureBoundingBoxes, 90, x * (levelWidth + 6) + 3 + roomWidth, i2 + 1, -1.0, -1.0, "Battlemat/Door " + furniture, "door");
                            if (diff != 3) continue;
                            ++i2;
                        }
                        if (levelWidth >= 7 || roomWidth == 2 && levelWidth == 6) {
                            roomWidth = 3;
                        }
                        top = y * (levelWidth + 6) + 3;
                        if (stairRotate == 0.0) {
                            top += 2;
                        }
                        bottom = y * (levelWidth + 6) + 3 + levelWidth;
                        if (stairRotate == 90.0) {
                            bottom -= 2;
                        }
                        for (i2 = top; i2 < bottom; i2 += 2) {
                            int diff = 2;
                            if (i2 == top && (bottom - top) % 2 == 1) {
                                diff = 3;
                            }
                            shapes.add(BattlematDataGenerator.makeRoom(x * (levelWidth + 6) + 3 + levelWidth - roomWidth, i2, x * (levelWidth + 6) + 3 + levelWidth, i2 + diff, "Rock Dark", 0.15, mainfloor, shapelayer));
                            BattlematDataGenerator.placeFeature(features, featureLayer, featureBoundingBoxes, 90, x * (levelWidth + 6) + 3 + levelWidth - roomWidth, i2 + 1, -1.0, -1.0, "Battlemat/Door " + furniture, "door");
                            if (diff != 3) continue;
                            ++i2;
                        }
                        double minX = (double)(x * (levelWidth + 6) + 3) + 0.75;
                        double rangeX2 = 0.0;
                        double minY2 = (double)(y * (levelWidth + 6)) + 3.5;
                        double rangeY2 = 0.0;
                        String itemType = "Battlemat/Bed " + furniture;
                        String itemTags = "bed";
                        for (i = 0; i <= levelWidth - 1; ++i) {
                            f = BattlematDataGenerator.checkAndPlaceFeature(new Random(), false, featureLayer, featureBoundingBoxes, 65.0, -1.0, itemType, itemTags, minX, rangeX2, minY2 + (double)i, rangeY2, 270.0, 10, null, false);
                            if (f == null) continue;
                            features.add(f);
                        }
                        for (i = 0; i <= levelWidth - 1; ++i) {
                            f = BattlematDataGenerator.checkAndPlaceFeature(new Random(), false, featureLayer, featureBoundingBoxes, 65.0, -1.0, itemType, itemTags, (double)(x * (levelWidth + 6) + 3 + levelWidth) - 0.75, rangeX2, minY2 + (double)i, rangeY2, 90.0, 10, null, false);
                            if (f == null) continue;
                            features.add(f);
                        }
                    } else {
                        if (stairRotate == 0.0) {
                            BattlematDataGenerator.placeFeature(features, featureLayer, featureBoundingBoxes, 90, (double)(x * (levelWidth + 6)) + stairLocX, (double)(y * (levelWidth + 6)) + stairLocY + 1.5, -1.0, -1.0, "Battlemat/Bars", "door");
                            BattlematDataGenerator.placeFeature(features, featureLayer, featureBoundingBoxes, 0, (double)(x * (levelWidth + 6)) + stairLocX - 0.5, (double)(y * (levelWidth + 6)) + stairLocY + 2.0, -1.0, -1.0, "Battlemat/Bars", "door");
                            BattlematDataGenerator.placeFeature(features, featureLayer, featureBoundingBoxes, 0, (double)(x * (levelWidth + 6)) + stairLocX - 1.5, (double)(y * (levelWidth + 6)) + stairLocY + 2.0, -1.0, -1.0, "Battlemat/Bars", "door");
                            BattlematDataGenerator.placeFeature(features, featureLayer, featureBoundingBoxes, 90, (double)(x * (levelWidth + 6)) + stairLocX - 2.0, (double)(y * (levelWidth + 6)) + stairLocY + 1.5, -1.0, -1.0, "Battlemat/Bars", "door");
                            BattlematDataGenerator.placeFeature(features, featureLayer, featureBoundingBoxes, 90, (double)(x * (levelWidth + 6)) + stairLocX - 2.0, (double)(y * (levelWidth + 6)) + stairLocY + 0.5, -1.0, -1.0, "Battlemat/Bars", "door");
                            BattlematDataGenerator.placeFeature(features, featureLayer, featureBoundingBoxes, 0, (double)(x * (levelWidth + 6)) + stairLocX - 1.5, (double)(y * (levelWidth + 6)) + stairLocY, -1.0, -1.0, "Battlemat/Bars", "door");
                            BattlematDataGenerator.placeFeature(features, featureLayer, featureBoundingBoxes, 0, (double)(x * (levelWidth + 6)) + stairLocX - 1.2, (double)(y * (levelWidth + 6)) + stairLocY + 1.2, 150.0, -1.0, "Battlemat/Table Rectangle Long " + furniture, "table");
                        }
                        if (stairRotate == 90.0) {
                            BattlematDataGenerator.placeFeature(features, featureLayer, featureBoundingBoxes, 90, (double)(x * (levelWidth + 6)) + stairLocX, (double)(y * (levelWidth + 6)) + stairLocY - 1.5, -1.0, -1.0, "Battlemat/Bars", "door");
                            BattlematDataGenerator.placeFeature(features, featureLayer, featureBoundingBoxes, 0, (double)(x * (levelWidth + 6)) + stairLocX - 0.5, (double)(y * (levelWidth + 6)) + stairLocY - 2.0, -1.0, -1.0, "Battlemat/Bars", "door");
                            BattlematDataGenerator.placeFeature(features, featureLayer, featureBoundingBoxes, 0, (double)(x * (levelWidth + 6)) + stairLocX - 1.5, (double)(y * (levelWidth + 6)) + stairLocY - 2.0, -1.0, -1.0, "Battlemat/Bars", "door");
                            BattlematDataGenerator.placeFeature(features, featureLayer, featureBoundingBoxes, 90, (double)(x * (levelWidth + 6)) + stairLocX - 2.0, (double)(y * (levelWidth + 6)) + stairLocY - 1.5, -1.0, -1.0, "Battlemat/Bars", "door");
                            BattlematDataGenerator.placeFeature(features, featureLayer, featureBoundingBoxes, 90, (double)(x * (levelWidth + 6)) + stairLocX - 2.0, (double)(y * (levelWidth + 6)) + stairLocY - 0.5, -1.0, -1.0, "Battlemat/Bars", "door");
                            BattlematDataGenerator.placeFeature(features, featureLayer, featureBoundingBoxes, 0, (double)(x * (levelWidth + 6)) + stairLocX - 1.5, (double)(y * (levelWidth + 6)) + stairLocY, -1.0, -1.0, "Battlemat/Bars", "door");
                            BattlematDataGenerator.placeFeature(features, featureLayer, featureBoundingBoxes, 0, (double)(x * (levelWidth + 6)) + stairLocX - 1.2, (double)(y * (levelWidth + 6)) + stairLocY - 1.2, 150.0, -1.0, "Battlemat/Table Rectangle Long " + furniture, "table");
                        }
                        if (stairRotate == 180.0) {
                            BattlematDataGenerator.placeFeature(features, featureLayer, featureBoundingBoxes, 90, (double)(x * (levelWidth + 6)) + stairLocX, (double)(y * (levelWidth + 6)) + stairLocY - 1.5, -1.0, -1.0, "Battlemat/Bars", "door");
                            BattlematDataGenerator.placeFeature(features, featureLayer, featureBoundingBoxes, 0, (double)(x * (levelWidth + 6)) + stairLocX + 0.5, (double)(y * (levelWidth + 6)) + stairLocY - 2.0, -1.0, -1.0, "Battlemat/Bars", "door");
                            BattlematDataGenerator.placeFeature(features, featureLayer, featureBoundingBoxes, 0, (double)(x * (levelWidth + 6)) + stairLocX + 1.5, (double)(y * (levelWidth + 6)) + stairLocY - 2.0, -1.0, -1.0, "Battlemat/Bars", "door");
                            BattlematDataGenerator.placeFeature(features, featureLayer, featureBoundingBoxes, 90, (double)(x * (levelWidth + 6)) + stairLocX + 2.0, (double)(y * (levelWidth + 6)) + stairLocY - 1.5, -1.0, -1.0, "Battlemat/Bars", "door");
                            BattlematDataGenerator.placeFeature(features, featureLayer, featureBoundingBoxes, 90, (double)(x * (levelWidth + 6)) + stairLocX + 2.0, (double)(y * (levelWidth + 6)) + stairLocY - 0.5, -1.0, -1.0, "Battlemat/Bars", "door");
                            BattlematDataGenerator.placeFeature(features, featureLayer, featureBoundingBoxes, 0, (double)(x * (levelWidth + 6)) + stairLocX + 1.5, (double)(y * (levelWidth + 6)) + stairLocY, -1.0, -1.0, "Battlemat/Bars", "door");
                            BattlematDataGenerator.placeFeature(features, featureLayer, featureBoundingBoxes, 0, (double)(x * (levelWidth + 6)) + stairLocX + 1.2, (double)(y * (levelWidth + 6)) + stairLocY - 1.2, 150.0, -1.0, "Battlemat/Table Rectangle Long " + furniture, "table");
                        }
                        if (stairRotate == 270.0) {
                            BattlematDataGenerator.placeFeature(features, featureLayer, featureBoundingBoxes, 90, (double)(x * (levelWidth + 6)) + stairLocX, (double)(y * (levelWidth + 6)) + stairLocY + 1.5, -1.0, -1.0, "Battlemat/Bars", "door");
                            BattlematDataGenerator.placeFeature(features, featureLayer, featureBoundingBoxes, 0, (double)(x * (levelWidth + 6)) + stairLocX + 0.5, (double)(y * (levelWidth + 6)) + stairLocY + 2.0, -1.0, -1.0, "Battlemat/Bars", "door");
                            BattlematDataGenerator.placeFeature(features, featureLayer, featureBoundingBoxes, 0, (double)(x * (levelWidth + 6)) + stairLocX + 1.5, (double)(y * (levelWidth + 6)) + stairLocY + 2.0, -1.0, -1.0, "Battlemat/Bars", "door");
                            BattlematDataGenerator.placeFeature(features, featureLayer, featureBoundingBoxes, 90, (double)(x * (levelWidth + 6)) + stairLocX + 2.0, (double)(y * (levelWidth + 6)) + stairLocY + 1.5, -1.0, -1.0, "Battlemat/Bars", "door");
                            BattlematDataGenerator.placeFeature(features, featureLayer, featureBoundingBoxes, 90, (double)(x * (levelWidth + 6)) + stairLocX + 2.0, (double)(y * (levelWidth + 6)) + stairLocY + 0.5, -1.0, -1.0, "Battlemat/Bars", "door");
                            BattlematDataGenerator.placeFeature(features, featureLayer, featureBoundingBoxes, 0, (double)(x * (levelWidth + 6)) + stairLocX + 1.5, (double)(y * (levelWidth + 6)) + stairLocY, -1.0, -1.0, "Battlemat/Bars", "door");
                            BattlematDataGenerator.placeFeature(features, featureLayer, featureBoundingBoxes, 0, (double)(x * (levelWidth + 6)) + stairLocX + 1.2, (double)(y * (levelWidth + 6)) + stairLocY + 1.2, 150.0, -1.0, "Battlemat/Table Rectangle Long " + furniture, "table");
                        }
                        double minX = (double)(x * (levelWidth + 6) + 3) + 0.75;
                        double rangeX3 = 0.0;
                        double minY3 = (double)(y * (levelWidth + 6)) + 3.4;
                        rangeY = (double)levelWidth - 0.8;
                        String itemType = "Battlemat/Bed Strawmat";
                        String itemTags = "bed";
                        for (i = 0; i < 10; ++i) {
                            BattlematDataGenerator.checkAndPlaceFeature(features, featureLayer, featureBoundingBoxes, itemType, itemTags, minX, rangeX3, minY3, rangeY, 0.0);
                        }
                        minX = (double)(x * (levelWidth + 6) + 3 + levelWidth) - 0.75;
                        for (i = 0; i < 10; ++i) {
                            BattlematDataGenerator.checkAndPlaceFeature(features, featureLayer, featureBoundingBoxes, itemType, itemTags, minX, rangeX3, minY3, rangeY, 0.0);
                        }
                        minX = (double)(x * (levelWidth + 6) + 3) + 0.4;
                        rangeX3 = (double)levelWidth - 0.8;
                        minY3 = (double)(y * (levelWidth + 6)) + 3.75;
                        rangeY = 0.0;
                        for (i = 0; i < 10; ++i) {
                            BattlematDataGenerator.checkAndPlaceFeature(features, featureLayer, featureBoundingBoxes, itemType, itemTags, minX, rangeX3, minY3, rangeY, 90.0);
                        }
                        minY3 = (double)(y * (levelWidth + 6) + 3 + levelWidth) - 0.75;
                        for (i = 0; i < 10; ++i) {
                            BattlematDataGenerator.checkAndPlaceFeature(features, featureLayer, featureBoundingBoxes, itemType, itemTags, minX, rangeX3, minY3, rangeY, 90.0);
                        }
                    }
                }
                if ("Storage".equals(levelType)) {
                    Feature f;
                    int i;
                    double minX = (double)(x * (levelWidth + 6) + 3) + 0.4;
                    rangeX = (double)levelWidth - 0.8;
                    minY = (double)(y * (levelWidth + 6)) + 3.4;
                    rangeY = (double)levelWidth - 0.8;
                    for (i = 0; i < levelWidth * 2; ++i) {
                        f = BattlematDataGenerator.checkAndPlaceFeature(features, featureLayer, featureBoundingBoxes, Math.random() < 0.5 ? "Battlemat/Crate Light" : "Battlemat/Crate Medium", "crate", minX, 0.0, minY, rangeY, 0.0);
                        if (f == null) continue;
                        Object[] bb = featureBoundingBoxes.toArray();
                        featureBoundingBoxes.remove(bb[0]);
                    }
                    for (i = 0; i < levelWidth * 2; ++i) {
                        f = BattlematDataGenerator.checkAndPlaceFeature(features, featureLayer, featureBoundingBoxes, Math.random() < 0.5 ? "Battlemat/Crate Light" : "Battlemat/Crate Medium", "crate", minX + rangeX, 0.0, minY, rangeY, 0.0);
                        if (f == null) continue;
                        Object[] bb = featureBoundingBoxes.toArray();
                        featureBoundingBoxes.remove(bb[0]);
                    }
                    for (i = 0; i < levelWidth * 2; ++i) {
                        f = BattlematDataGenerator.checkAndPlaceFeature(features, featureLayer, featureBoundingBoxes, Math.random() < 0.5 ? "Battlemat/Crate Light" : "Battlemat/Crate Medium", "crate", minX, rangeX, minY, 0.0, 0.0);
                        if (f == null) continue;
                        Object[] bb = featureBoundingBoxes.toArray();
                        featureBoundingBoxes.remove(bb[0]);
                    }
                    for (i = 0; i < levelWidth * 2; ++i) {
                        f = BattlematDataGenerator.checkAndPlaceFeature(features, featureLayer, featureBoundingBoxes, Math.random() < 0.5 ? "Battlemat/Crate Light" : "Battlemat/Crate Medium", "crate", minX, rangeX, minY + rangeY, 0.0, 0.0);
                        if (f == null) continue;
                        Object[] bb = featureBoundingBoxes.toArray();
                        featureBoundingBoxes.remove(bb[0]);
                    }
                }
                if ("Dining".equals(levelType)) {
                    Path pantryPath = new Path();
                    if (stairRotate == 0.0) {
                        path.getElements().add((Object)new MoveTo((double)((x * (levelWidth + 6) + 3) * 300), ((double)(y * (levelWidth + 6)) + stairLocY + 1.0) * 300.0));
                        path.getElements().add((Object)new LineTo(((double)(x * (levelWidth + 6)) + stairLocX - 1.0) * 300.0, ((double)(y * (levelWidth + 6)) + stairLocY + 1.0) * 300.0));
                        path.getElements().add((Object)new LineTo(((double)(x * (levelWidth + 6)) + stairLocX - 1.0) * 300.0, ((double)(y * (levelWidth + 6)) + stairLocY) * 300.0));
                        BattlematDataGenerator.placeFeature(features, featureLayer, featureBoundingBoxes, 90, (double)(x * (levelWidth + 6)) + stairLocX - 1.0, (double)(y * (levelWidth + 6)) + stairLocY + 0.5, -1.0, -1.0, "Battlemat/Door " + furniture, "door");
                        path.getElements().add((Object)new MoveTo((double)((x * (levelWidth + 6) + 3 + 2) * 300), ((double)(y * (levelWidth + 6)) + stairLocY + 1.0) * 300.0));
                        path.getElements().add((Object)new LineTo((double)((x * (levelWidth + 6) + 3 + 2) * 300), (double)((y * (levelWidth + 6) + 3 + levelWidth) * 300)));
                        BattlematDataGenerator.placeFeature(features, featureLayer, featureBoundingBoxes, 0, (double)(x * (levelWidth + 6) + 3) + 1.5, (double)(y * (levelWidth + 6)) + stairLocY + 1.0, -1.0, -1.0, "Battlemat/Door " + furniture, "door");
                        double minX = (double)(x * (levelWidth + 6) + 3) + 0.35;
                        rangeX = 0.0;
                        double minY4 = (double)(y * (levelWidth + 6)) + 3.85;
                        rangeY = 0.3;
                        int rotate = 270;
                        String itemType = "Battlemat/Cookery A";
                        itemTags = "fireplace";
                        BattlematDataGenerator.checkAndPlaceFeature(features, featureLayer, featureBoundingBoxes, itemType, itemTags, minX, rangeX, minY4, rangeY, rotate);
                        minX = (double)(x * (levelWidth + 6) + 3) + 0.35;
                        rangeX = 0.0;
                        minY4 = (double)(y * (levelWidth + 6) + 3) + 0.6;
                        rangeY = 0.0;
                        rotate = 0;
                        BattlematDataGenerator.checkAndPlaceFeature(features, featureLayer, featureBoundingBoxes, itemType, itemTags, minX, rangeX, minY4, rangeY, rotate);
                        BattlematDataGenerator.checkAndPlaceFeature(features, featureLayer, featureBoundingBoxes, "Battlemat/Table Rectangle Long " + furniture, itemTags, x * (levelWidth + 6) + 3 + levelWidth - 3, 0.0, (double)(y * (levelWidth + 6) + 3) + 0.35, 0.0, 0.0);
                        double tableX = (double)(x * (levelWidth + 6) + 3 + 2) + (double)(levelWidth - 2) / 2.0;
                        double tableY = (double)(y * (levelWidth + 6) + 3) + ((double)levelWidth - 1.0);
                        BattlematDataGenerator.placeFeature(features, featureLayer, featureBoundingBoxes, 90, tableX + 0.5, tableY, -1.0, -1.0, "Battlemat/Chair " + furniture, "chair");
                        BattlematDataGenerator.placeFeature(features, featureLayer, featureBoundingBoxes, 90, tableX + 0.5, tableY - 0.5, -1.0, -1.0, "Battlemat/Chair " + furniture, "chair");
                        BattlematDataGenerator.placeFeature(features, featureLayer, featureBoundingBoxes, 90, tableX + 0.5, tableY + 0.5, -1.0, -1.0, "Battlemat/Chair " + furniture, "chair");
                        BattlematDataGenerator.placeFeature(features, featureLayer, featureBoundingBoxes, 270, tableX - 0.5, tableY, -1.0, -1.0, "Battlemat/Chair " + furniture, "chair");
                        BattlematDataGenerator.placeFeature(features, featureLayer, featureBoundingBoxes, 270, tableX - 0.5, tableY - 0.5, -1.0, -1.0, "Battlemat/Chair " + furniture, "chair");
                        BattlematDataGenerator.placeFeature(features, featureLayer, featureBoundingBoxes, 270, tableX - 0.5, tableY + 0.5, -1.0, -1.0, "Battlemat/Chair " + furniture, "chair");
                        BattlematDataGenerator.placeFeature(features, featureLayer, featureBoundingBoxes, 90, tableX, tableY, 220.0, 100.0, "Battlemat/Table Rectangle " + furniture, "chair");
                    } else if (stairRotate == 90.0) {
                        path.getElements().add((Object)new MoveTo((double)((x * (levelWidth + 6) + 3) * 300), ((double)(y * (levelWidth + 6)) + stairLocY - 1.0) * 300.0));
                        path.getElements().add((Object)new LineTo(((double)(x * (levelWidth + 6)) + stairLocX - 1.0) * 300.0, ((double)(y * (levelWidth + 6)) + stairLocY - 1.0) * 300.0));
                        path.getElements().add((Object)new LineTo(((double)(x * (levelWidth + 6)) + stairLocX - 1.0) * 300.0, ((double)(y * (levelWidth + 6)) + stairLocY) * 300.0));
                        BattlematDataGenerator.placeFeature(features, featureLayer, featureBoundingBoxes, 90, (double)(x * (levelWidth + 6)) + stairLocX - 1.0, (double)(y * (levelWidth + 6)) + stairLocY - 0.5, -1.0, -1.0, "Battlemat/Door " + furniture, "door");
                        double minX = (double)(x * (levelWidth + 6) + 3) + 0.35;
                        rangeX = 0.0;
                        double minY5 = (double)(y * (levelWidth + 6) + 3 + levelWidth - 2) + 0.85;
                        rangeY = 0.3;
                        int rotate = 270;
                        String itemType = "Battlemat/Cookery A";
                        itemTags = "fireplace";
                        BattlematDataGenerator.checkAndPlaceFeature(features, featureLayer, featureBoundingBoxes, itemType, itemTags, minX, rangeX, minY5, rangeY, rotate);
                        BattlematDataGenerator.checkAndPlaceFeature(features, featureLayer, featureBoundingBoxes, "Battlemat/Table Rectangle Long " + furniture, itemTags, x * (levelWidth + 6) + 3 + levelWidth - 3, 0.0, (double)(y * (levelWidth + 6) + 3 + levelWidth) - 0.35, 0.0, 0.0);
                        path.getElements().add((Object)new MoveTo((double)((x * (levelWidth + 6) + 3 + 2) * 300), (double)((y * (levelWidth + 6) + 3) * 300)));
                        path.getElements().add((Object)new LineTo((double)((x * (levelWidth + 6) + 3 + 2) * 300), (double)((y * (levelWidth + 6) + 3 + levelWidth - 2) * 300)));
                        BattlematDataGenerator.placeFeature(features, featureLayer, featureBoundingBoxes, 0, (double)(x * (levelWidth + 6) + 3) + 1.5, (double)(y * (levelWidth + 6)) + stairLocY - 1.0, -1.0, -1.0, "Battlemat/Door " + furniture, "door");
                        double tableX = (double)(x * (levelWidth + 6) + 3 + 2) + (double)(levelWidth - 2) / 2.0;
                        double tableY = (double)(y * (levelWidth + 6) + 3) + (double)(levelWidth - 2) / 2.0;
                        BattlematDataGenerator.placeFeature(features, featureLayer, featureBoundingBoxes, 90, tableX + 0.5, tableY, -1.0, -1.0, "Battlemat/Chair " + furniture, "chair");
                        BattlematDataGenerator.placeFeature(features, featureLayer, featureBoundingBoxes, 90, tableX + 0.5, tableY - 0.5, -1.0, -1.0, "Battlemat/Chair " + furniture, "chair");
                        BattlematDataGenerator.placeFeature(features, featureLayer, featureBoundingBoxes, 90, tableX + 0.5, tableY + 0.5, -1.0, -1.0, "Battlemat/Chair " + furniture, "chair");
                        BattlematDataGenerator.placeFeature(features, featureLayer, featureBoundingBoxes, 270, tableX - 0.5, tableY, -1.0, -1.0, "Battlemat/Chair " + furniture, "chair");
                        BattlematDataGenerator.placeFeature(features, featureLayer, featureBoundingBoxes, 270, tableX - 0.5, tableY - 0.5, -1.0, -1.0, "Battlemat/Chair " + furniture, "chair");
                        BattlematDataGenerator.placeFeature(features, featureLayer, featureBoundingBoxes, 270, tableX - 0.5, tableY + 0.5, -1.0, -1.0, "Battlemat/Chair " + furniture, "chair");
                        BattlematDataGenerator.placeFeature(features, featureLayer, featureBoundingBoxes, 90, tableX, tableY, 220.0, 100.0, "Battlemat/Table Rectangle " + furniture, "chair");
                    } else if (stairRotate == 180.0) {
                        path.getElements().add((Object)new MoveTo((double)((x * (levelWidth + 6) + 3 + levelWidth) * 300), ((double)(y * (levelWidth + 6)) + stairLocY - 1.0) * 300.0));
                        path.getElements().add((Object)new LineTo(((double)(x * (levelWidth + 6)) + stairLocX + 1.0) * 300.0, ((double)(y * (levelWidth + 6)) + stairLocY - 1.0) * 300.0));
                        path.getElements().add((Object)new LineTo(((double)(x * (levelWidth + 6)) + stairLocX + 1.0) * 300.0, ((double)(y * (levelWidth + 6)) + stairLocY) * 300.0));
                        BattlematDataGenerator.placeFeature(features, featureLayer, featureBoundingBoxes, 90, (double)(x * (levelWidth + 6)) + stairLocX + 1.0, (double)(y * (levelWidth + 6)) + stairLocY - 0.5, -1.0, -1.0, "Battlemat/Door " + furniture, "door");
                        double minX = (double)(x * (levelWidth + 6) + 3 + levelWidth) - 0.35;
                        rangeX = 0.0;
                        double minY6 = (double)(y * (levelWidth + 6) + 3 + levelWidth - 2) + 0.85;
                        rangeY = 0.3;
                        int rotate = 90;
                        String itemType = "Battlemat/Cookery A";
                        itemTags = "fireplace";
                        BattlematDataGenerator.checkAndPlaceFeature(features, featureLayer, featureBoundingBoxes, itemType, itemTags, minX, rangeX, minY6, rangeY, rotate);
                        BattlematDataGenerator.checkAndPlaceFeature(features, featureLayer, featureBoundingBoxes, "Battlemat/Table Rectangle Long " + furniture, itemTags, x * (levelWidth + 6) + 3 + levelWidth - 2, 0.0, (double)(y * (levelWidth + 6) + 3 + levelWidth) - 0.35, 0.0, 0.0);
                        path.getElements().add((Object)new MoveTo((double)((x * (levelWidth + 6) + 3 + levelWidth - 2) * 300), (double)((y * (levelWidth + 6) + 3) * 300)));
                        path.getElements().add((Object)new LineTo((double)((x * (levelWidth + 6) + 3 + levelWidth - 2) * 300), (double)((y * (levelWidth + 6) + 3 + levelWidth - 2) * 300)));
                        BattlematDataGenerator.placeFeature(features, featureLayer, featureBoundingBoxes, 0, (double)(x * (levelWidth + 6) + 3 + levelWidth) - 1.5, (double)(y * (levelWidth + 6)) + stairLocY - 1.0, -1.0, -1.0, "Battlemat/Door " + furniture, "door");
                        double tableX = (double)(x * (levelWidth + 6) + 3) + (double)(levelWidth - 2) / 2.0;
                        double tableY = (double)(y * (levelWidth + 6) + 3) + (double)(levelWidth - 2) / 2.0;
                        BattlematDataGenerator.placeFeature(features, featureLayer, featureBoundingBoxes, 90, tableX + 0.5, tableY, -1.0, -1.0, "Battlemat/Chair " + furniture, "chair");
                        BattlematDataGenerator.placeFeature(features, featureLayer, featureBoundingBoxes, 90, tableX + 0.5, tableY - 0.5, -1.0, -1.0, "Battlemat/Chair " + furniture, "chair");
                        BattlematDataGenerator.placeFeature(features, featureLayer, featureBoundingBoxes, 90, tableX + 0.5, tableY + 0.5, -1.0, -1.0, "Battlemat/Chair " + furniture, "chair");
                        BattlematDataGenerator.placeFeature(features, featureLayer, featureBoundingBoxes, 270, tableX - 0.5, tableY, -1.0, -1.0, "Battlemat/Chair " + furniture, "chair");
                        BattlematDataGenerator.placeFeature(features, featureLayer, featureBoundingBoxes, 270, tableX - 0.5, tableY - 0.5, -1.0, -1.0, "Battlemat/Chair " + furniture, "chair");
                        BattlematDataGenerator.placeFeature(features, featureLayer, featureBoundingBoxes, 270, tableX - 0.5, tableY + 0.5, -1.0, -1.0, "Battlemat/Chair " + furniture, "chair");
                        BattlematDataGenerator.placeFeature(features, featureLayer, featureBoundingBoxes, 90, tableX, tableY, 220.0, 100.0, "Battlemat/Table Rectangle " + furniture, "chair");
                    } else if (stairRotate == 270.0) {
                        path.getElements().add((Object)new MoveTo((double)((x * (levelWidth + 6) + 3 + levelWidth) * 300), ((double)(y * (levelWidth + 6)) + stairLocY + 1.0) * 300.0));
                        path.getElements().add((Object)new LineTo(((double)(x * (levelWidth + 6)) + stairLocX + 1.0) * 300.0, ((double)(y * (levelWidth + 6)) + stairLocY + 1.0) * 300.0));
                        path.getElements().add((Object)new LineTo(((double)(x * (levelWidth + 6)) + stairLocX + 1.0) * 300.0, ((double)(y * (levelWidth + 6)) + stairLocY) * 300.0));
                        BattlematDataGenerator.placeFeature(features, featureLayer, featureBoundingBoxes, 90, (double)(x * (levelWidth + 6)) + stairLocX + 1.0, (double)(y * (levelWidth + 6)) + stairLocY + 0.5, -1.0, -1.0, "Battlemat/Door " + furniture, "door");
                        path.getElements().add((Object)new MoveTo((double)((x * (levelWidth + 6) + 3 + levelWidth - 2) * 300), ((double)(y * (levelWidth + 6)) + stairLocY + 1.0) * 300.0));
                        path.getElements().add((Object)new LineTo((double)((x * (levelWidth + 6) + 3 + levelWidth - 2) * 300), (double)((y * (levelWidth + 6) + 3 + levelWidth) * 300)));
                        BattlematDataGenerator.placeFeature(features, featureLayer, featureBoundingBoxes, 0, (double)(x * (levelWidth + 6)) + stairLocX + 2.5, (double)(y * (levelWidth + 6)) + stairLocY + 1.0, -1.0, -1.0, "Battlemat/Door " + furniture, "door");
                        double minX = (double)(x * (levelWidth + 6) + 3 + levelWidth) - 0.35;
                        rangeX = 0.0;
                        double minY7 = y * (levelWidth + 6) + 4;
                        rangeY = 0.0;
                        int rotate = 90;
                        String itemType = "Battlemat/Cookery A";
                        itemTags = "fireplace";
                        BattlematDataGenerator.checkAndPlaceFeature(features, featureLayer, featureBoundingBoxes, itemType, itemTags, minX, rangeX, minY7, rangeY, rotate);
                        minX = x * (levelWidth + 6) + 3 + 2 + 1;
                        rangeX = 0.0;
                        minY7 = (double)(y * (levelWidth + 6) + 3) + 0.8;
                        rangeY = 0.0;
                        rotate = 0;
                        BattlematDataGenerator.checkAndPlaceFeature(features, featureLayer, featureBoundingBoxes, "Battlemat/Table Rectangle Long " + furniture, itemTags, (double)(x * (levelWidth + 6) + 3) + 3.1, 0.0, (double)(y * (levelWidth + 6) + 3) + 0.35, 0.0, 0.0);
                        double tableX = (double)(x * (levelWidth + 6) + 3) + (double)(levelWidth - 2) / 2.0;
                        double tableY = (double)(y * (levelWidth + 6) + 3) + (double)(levelWidth - 2) / 2.0;
                        BattlematDataGenerator.placeFeature(features, featureLayer, featureBoundingBoxes, 90, tableX + 0.5, tableY, -1.0, -1.0, "Battlemat/Chair " + furniture, "chair");
                        BattlematDataGenerator.placeFeature(features, featureLayer, featureBoundingBoxes, 90, tableX + 0.5, tableY - 0.5, -1.0, -1.0, "Battlemat/Chair " + furniture, "chair");
                        BattlematDataGenerator.placeFeature(features, featureLayer, featureBoundingBoxes, 90, tableX + 0.5, tableY + 0.5, -1.0, -1.0, "Battlemat/Chair " + furniture, "chair");
                        BattlematDataGenerator.placeFeature(features, featureLayer, featureBoundingBoxes, 270, tableX - 0.5, tableY, -1.0, -1.0, "Battlemat/Chair " + furniture, "chair");
                        BattlematDataGenerator.placeFeature(features, featureLayer, featureBoundingBoxes, 270, tableX - 0.5, tableY - 0.5, -1.0, -1.0, "Battlemat/Chair " + furniture, "chair");
                        BattlematDataGenerator.placeFeature(features, featureLayer, featureBoundingBoxes, 270, tableX - 0.5, tableY + 0.5, -1.0, -1.0, "Battlemat/Chair " + furniture, "chair");
                        BattlematDataGenerator.placeFeature(features, featureLayer, featureBoundingBoxes, 90, tableX, tableY, 220.0, 100.0, "Battlemat/Table Rectangle " + furniture, "chair");
                    }
                    MapShape kitchenMS = BattlematDataGenerator.makeRoom((Shape)path, "Rock Dark", null, 0.15, featureLayer, "room");
                    shapes.add(kitchenMS);
                    MapShape pantryMS = BattlematDataGenerator.makeRoom((Shape)pantryPath, "Rock Dark", null, 0.15, featureLayer, "room");
                    shapes.add(pantryMS);
                }
                if ("Leader's Chambers".equals(levelType)) {
                    String[] items = new String[]{"Battlemat/Bed Double Blue " + furniture, "Battlemat/Desk " + furniture, "Battlemat/Wardrobe " + furniture, "Battlemat/Bookcase " + furniture};
                    String[] itemTags = new String[]{"bed", "desk", "wardrobe", "bookcase"};
                    double[] itemOffsets = new double[]{0.9, 0.25, 0.4, 0.2};
                    int itemCount = 0;
                    for (int i = 0; i < 100; ++i) {
                        boolean intersect;
                        Feature feature;
                        double ht;
                        int wall = (int)(Math.random() * 4.0);
                        double itemX = 0.0;
                        double itemY = 0.0;
                        int rotate = 0;
                        if (wall == 0 || wall == 2) {
                            int loc = (int)(Math.random() * (double)levelWidth);
                            itemX = (double)(x * (levelWidth + 6) + 3 + loc) + 0.5;
                            if (wall == 2) {
                                itemY = (double)(y * (levelWidth + 6) + 3 + levelWidth) - itemOffsets[itemCount];
                                rotate = 180;
                            } else {
                                itemY = (double)(y * (levelWidth + 6) + 3) + itemOffsets[itemCount];
                            }
                        }
                        if (wall == 1 || wall == 3) {
                            int loc = (int)(Math.random() * (double)levelWidth);
                            itemY = (double)(y * (levelWidth + 6) + 3 + loc) + 0.5;
                            if (wall == 3) {
                                itemX = (double)(x * (levelWidth + 6) + 3) + itemOffsets[itemCount];
                                rotate = 270;
                            } else {
                                itemX = (double)(x * (levelWidth + 6) + 3 + levelWidth) - itemOffsets[itemCount];
                                rotate = 90;
                            }
                            if (loc == 0 || loc == levelWidth - 1) {
                                itemY = loc == 0 ? (itemY += 0.04) : (itemY -= 0.04);
                            }
                        }
                        if ((ht = (feature = new Feature(items[itemCount], false, false, false, false, null, rotate, null, -1.0, -1.0, false, false, null, itemTags[itemCount], false, false, false, false, featureLayer)).getScaleHtFallbackType()) <= 0.0) {
                            ht = feature.getScaleFallbackType();
                        }
                        if (!(intersect = BattlematDataGenerator.isIntersect(featureBoundingBoxes, itemX, itemY, rotate == 0 || rotate == 180 ? feature.getScaleFallbackType() * 3.0 : ht * 3.0, rotate == 0 || rotate == 180 ? ht * 3.0 : feature.getScaleFallbackType() * 3.0))) {
                            if (items[itemCount].contains("Desk")) {
                                double chairX = itemX;
                                double chairY = itemY;
                                if (rotate == 0) {
                                    chairY += 0.2;
                                } else if (rotate == 180) {
                                    chairY -= 0.2;
                                } else if (rotate == 90) {
                                    chairX -= 0.2;
                                } else if (rotate == 270) {
                                    chairX += 0.2;
                                }
                                BattlematDataGenerator.placeFeature(features, featureLayer, featureBoundingBoxes, (rotate + 180) % 360, chairX, chairY, -1.0, -1.0, "Battlemat/Chair " + furniture, "chair");
                            }
                            placed = true;
                            BattlematDataGenerator.placeFeature(features, featureLayer, featureBoundingBoxes, rotate, itemX, itemY, -1.0, -1.0, items[itemCount], itemTags[itemCount]);
                            ++itemCount;
                        }
                        if (itemCount == items.length) break;
                    }
                }
                if ("Library".equals(levelType)) {
                    int chairLoc = (int)(Math.random() * 5.0);
                    double chairLoc1X = (double)(x * (levelWidth + 6) + 3) + (double)levelWidth / 2.0 - 0.5;
                    double chairLoc1Y = (double)(y * (levelWidth + 6) + 3) + (double)levelWidth / 2.0 - 0.25;
                    double chairLoc2X = (double)(x * (levelWidth + 6) + 3) + (double)levelWidth / 2.0 + 0.5;
                    double chairLoc2Y = (double)(y * (levelWidth + 6) + 3) + (double)levelWidth / 2.0 - 0.25;
                    double chairRotate = 0.0;
                    if (chairLoc == 0) {
                        chairLoc1Y = (double)(y * (levelWidth + 6) + 3) + 0.5;
                        chairLoc2Y = (double)(y * (levelWidth + 6) + 3) + 0.5;
                    }
                    if (chairLoc == 1) {
                        chairLoc1X = (double)(x * (levelWidth + 6) + 3 + levelWidth) - 0.5;
                        chairLoc2X = (double)(x * (levelWidth + 6) + 3 + levelWidth) - 0.5;
                        chairLoc1Y = (double)(y * (levelWidth + 6) + 3) + (double)levelWidth / 2.0 - 0.5;
                        chairLoc2Y = (double)(y * (levelWidth + 6) + 3) + (double)levelWidth / 2.0 + 0.5;
                        chairRotate = 90.0;
                    }
                    if (chairLoc == 2) {
                        chairLoc1Y = (double)(y * (levelWidth + 6) + 3 + levelWidth) - 0.5;
                        chairLoc2Y = (double)(y * (levelWidth + 6) + 3 + levelWidth) - 0.5;
                        chairRotate = 180.0;
                    }
                    if (chairLoc == 3) {
                        chairLoc1X = (double)(x * (levelWidth + 6) + 3) + 0.5;
                        chairLoc2X = (double)(x * (levelWidth + 6) + 3) + 0.5;
                        chairLoc1Y = (double)(y * (levelWidth + 6) + 3) + (double)levelWidth / 2.0 - 0.5;
                        chairLoc2Y = (double)(y * (levelWidth + 6) + 3) + (double)levelWidth / 2.0 + 0.5;
                        chairRotate = 270.0;
                    }
                    if (Math.random() < 0.5) {
                        if (chairLoc == 0 || chairLoc == 2 || chairLoc == 4) {
                            chairLoc1X = (double)(x * (levelWidth + 6) + 3) + (double)levelWidth / 2.0;
                            chairRotate = chairLoc == 2 ? 90.0 : 0.0;
                        } else {
                            chairLoc1Y = (double)(y * (levelWidth + 6) + 3) + (double)levelWidth / 2.0;
                            chairRotate = chairLoc == 1 ? 0.0 : 180.0;
                        }
                        intersect = BattlematDataGenerator.isIntersect(featureBoundingBoxes, chairLoc1X, chairLoc1Y, chairLoc == 0 || chairLoc == 2 || chairLoc == 4 ? 450.0 : 150.0, chairLoc == 0 || chairLoc == 2 || chairLoc == 4 ? 150.0 : 450.0);
                        if (!intersect) {
                            BattlematDataGenerator.placeFeature(features, featureLayer, featureBoundingBoxes, (int)chairRotate, chairLoc1X, chairLoc1Y, -1.0, -1.0, "Battlemat/Sofa Modern Black", "chair");
                        }
                    } else {
                        boolean intersect2;
                        intersect = BattlematDataGenerator.isIntersect(featureBoundingBoxes, chairLoc1X, chairLoc1Y, 150.0, 150.0);
                        if (!intersect) {
                            BattlematDataGenerator.placeFeature(features, featureLayer, featureBoundingBoxes, (int)chairRotate, chairLoc1X, chairLoc1Y, -1.0, -1.0, "Battlemat/Chair Upholstered Black", "chair");
                        }
                        if (!(intersect2 = BattlematDataGenerator.isIntersect(featureBoundingBoxes, chairLoc2X, chairLoc2Y, 150.0, 150.0))) {
                            BattlematDataGenerator.placeFeature(features, featureLayer, featureBoundingBoxes, (int)chairRotate, chairLoc2X, chairLoc2Y, -1.0, -1.0, "Battlemat/Chair Upholstered Black", "chair");
                        }
                    }
                    for (int i = 0; i < 100; ++i) {
                        boolean intersect;
                        int loc;
                        int wall = (int)(Math.random() * 4.0);
                        double bookcaseX = 0.0;
                        double bookcaseY = 0.0;
                        int bookcaseRotate = 0;
                        int bookcaseW = 100;
                        if (wall == 0 || wall == 2) {
                            loc = (int)(Math.random() * (double)levelWidth);
                            bookcaseX = (double)(x * (levelWidth + 6) + 3 + loc) + 0.5;
                            if (wall == 2) {
                                bookcaseY = (double)(y * (levelWidth + 6) + 3 + levelWidth) - 0.2;
                                bookcaseRotate = 180;
                            } else {
                                bookcaseY = (double)(y * (levelWidth + 6) + 3) + 0.2;
                            }
                            if (loc == 0 || loc == levelWidth - 1) {
                                bookcaseW = 92;
                                bookcaseX = loc == 0 ? (bookcaseX += 0.04) : (bookcaseX -= 0.04);
                            }
                        }
                        if (wall == 1 || wall == 3) {
                            loc = (int)(Math.random() * (double)levelWidth);
                            bookcaseY = (double)(y * (levelWidth + 6) + 3 + loc) + 0.5;
                            if (wall == 3) {
                                bookcaseX = (double)(x * (levelWidth + 6) + 3) + 0.2;
                                bookcaseRotate = 270;
                            } else {
                                bookcaseX = (double)(x * (levelWidth + 6) + 3 + levelWidth) - 0.2;
                                bookcaseRotate = 90;
                            }
                            if (loc == 0 || loc == levelWidth - 1) {
                                bookcaseW = 92;
                                bookcaseY = loc == 0 ? (bookcaseY += 0.04) : (bookcaseY -= 0.04);
                            }
                        }
                        if (intersect = BattlematDataGenerator.isIntersect(featureBoundingBoxes, bookcaseX, bookcaseY, bookcaseRotate == 0 || bookcaseRotate == 180 ? (double)(bookcaseW * 3) : 125.0, bookcaseRotate == 0 || bookcaseRotate == 180 ? 125.0 : (double)(bookcaseW * 3))) continue;
                        BattlematDataGenerator.placeFeature(features, featureLayer, featureBoundingBoxes, bookcaseRotate, bookcaseX, bookcaseY, bookcaseW, 41.67, "Battlemat/Bookcase " + furniture, "chair");
                    }
                }
                if ("Audience Hall".equals(levelType)) {
                    Feature rug = BattlematDataGenerator.placeFeature(features, featureLayer, featureBoundingBoxes, 0, (double)(x * (levelWidth + 6) + 3) + (double)levelWidth / 2.0, (double)(y * (levelWidth + 6) + 3) + (double)levelWidth / 2.0, ((double)levelWidth - 2.2) * 100.0, ((double)levelWidth - 2.2) * 100.0, "Battlemat/Rug Square", "rug");
                    features.remove(rug);
                    features.add(features.size() - 1, rug);
                    featureBoundingBoxes.remove(rug);
                    placed = false;
                    int throneRotate = 0;
                    for (tries = 0; !placed && tries < 10; ++tries) {
                        double throneLocX;
                        throneRotate = (int)(Math.random() * 4.0) * 90;
                        double d = throneRotate == 90 || throneRotate == 270 ? (double)(x * (levelWidth + 6) + 3) + (double)levelWidth / 2.0 : (throneLocX = throneRotate == 0 ? (double)(x * (levelWidth + 6) + 3) + 0.5 : (double)(x * (levelWidth + 6) + 3 + levelWidth) - 0.5);
                        double throneLocY = throneRotate == 0 || throneRotate == 180 ? (double)(y * (levelWidth + 6) + 3) + (double)levelWidth / 2.0 : (throneRotate == 90 ? (double)(y * (levelWidth + 6) + 3) + 0.5 : (double)(y * (levelWidth + 6) + 3 + levelWidth) - 0.5);
                        Rectangle fRect = new Rectangle(throneLocX * 300.0 - 130.0, throneLocY * 300.0 - 130.0, 260.0, 260.0);
                        double fWidth = 260.0;
                        double fHeight = 260.0;
                        boolean intersect = BattlematDataGenerator.isIntersect(featureBoundingBoxes, throneLocX, throneLocY, fWidth, fHeight);
                        if (intersect) continue;
                        String throneType = Math.random() < 0.5 ? "Battlemat/Throne Golden" : "Battlemat/Throne Wooden";
                        BattlematDataGenerator.placeFeature(features, featureLayer, featureBoundingBoxes, throneRotate, throneLocX, throneLocY, -1.0, -1.0, throneType, "throne");
                        placed = true;
                    }
                    placed = false;
                    for (tries = 0; !placed && tries < 10; ++tries) {
                        double fHeight;
                        double fWidth;
                        double benchLocX;
                        double d = throneRotate == 90 || throneRotate == 270 ? (double)(x * (levelWidth + 6) + 3) + (double)levelWidth / 2.0 : (benchLocX = throneRotate == 180 ? (double)(x * (levelWidth + 6) + 3) + 0.5 : (double)(x * (levelWidth + 6) + 3 + levelWidth) - 0.5);
                        double benchLocY = throneRotate == 0 || throneRotate == 180 ? (double)(y * (levelWidth + 6) + 3) + (double)levelWidth / 2.0 : (throneRotate == 270 ? (double)(y * (levelWidth + 6) + 3) + 0.5 : (double)(y * (levelWidth + 6) + 3 + levelWidth) - 0.5);
                        boolean intersect = BattlematDataGenerator.isIntersect(featureBoundingBoxes, benchLocX, benchLocY, fWidth = throneRotate == 90 || throneRotate == 270 ? 600.0 : 150.0, fHeight = throneRotate == 90 || throneRotate == 270 ? 150.0 : 600.0);
                        if (intersect) continue;
                        BattlematDataGenerator.placeFeature(features, featureLayer, featureBoundingBoxes, (throneRotate + 90) % 360, benchLocX, benchLocY, -1.0, -1.0, "Battlemat/Bench Walnut", "throne");
                        placed = true;
                    }
                    String statuesOrColumnsType = Math.random() < 0.5 ? "Battlemat/Statue" : "Battlemat/Column Corner";
                    for (int i = 0; i < 4; ++i) {
                        placed = false;
                        for (tries = 0; !placed && tries < 10; ++tries) {
                            double throneLocY;
                            int rotate = i * 90 + 45;
                            double throneLocX = rotate == 225 || rotate == 315 ? (double)(x * (levelWidth + 6) + 4) : (double)(x * (levelWidth + 6) + 3 + levelWidth - 1);
                            double d = throneLocY = rotate == 45 || rotate == 315 ? (double)(y * (levelWidth + 6) + 3 + 1) : (double)(y * (levelWidth + 6) + 3 + levelWidth - 1);
                            if (statuesOrColumnsType.contains("Corner")) {
                                rotate -= 45;
                            }
                            Rectangle fRect = new Rectangle(throneLocX * 300.0 - 130.0, throneLocY * 300.0 - 130.0, 260.0, 260.0);
                            double fWidth = 260.0;
                            double fHeight = 260.0;
                            boolean intersect = BattlematDataGenerator.isIntersect(featureBoundingBoxes, throneLocX, throneLocY, fWidth, fHeight);
                            if (intersect) continue;
                            BattlematDataGenerator.placeFeature(features, featureLayer, featureBoundingBoxes, rotate, throneLocX, throneLocY, -1.0, -1.0, statuesOrColumnsType, "statue");
                            placed = true;
                        }
                    }
                }
            }
            ++x;
            if (--level >= -bottomLevel) continue;
            complete = true;
        }
        maxX = (maxX + 1) * (levelWidth + 6);
        maxY = (maxY + 1) * (levelWidth + 6);
        if (t.length < maxX || t[0].length < maxY) {
            Terrain[][] t2 = new Terrain[Math.max(maxX, t.length)][Math.max(maxY, t[0].length)];
            System.out.println("t2:" + t2.length + ":" + t2[0].length);
            for (int i = 0; i < t2.length; ++i) {
                for (int j = 0; j < t2[i].length; ++j) {
                    t2[i][j] = new Terrain("Blank", false);
                }
            }
            t = t2;
        }
        return t;
    }
}

