/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.generator.world;

import com.inkwellideas.ographer.data.HexOrientation;
import com.inkwellideas.ographer.data.ViewLevel;
import com.inkwellideas.ographer.information.Information;
import com.inkwellideas.ographer.map.MapData;
import com.inkwellideas.ographer.map.MapLogic;
import com.inkwellideas.ographer.map.Terrain;
import com.inkwellideas.ographer.model.Feature;
import java.util.List;
import java.util.Map;
import javafx.geometry.Point2D;

public class WorldSimulator {
    final MapData mapData;
    final int startingFactions = 6;

    public WorldSimulator(MapData md, boolean clearInfo) {
        this.mapData = md;
        if (clearInfo) {
            List<Information> list = md.getInformation();
        }
    }

    public void advance() {
        Terrain[][] terrain = this.mapData.getTerrain(ViewLevel.WORLD);
        boolean terraintype = false;
        if (terrain != null && (terrain[0][0].getTypeName().contains("ISO ") || terrain[5][5].getTypeName().contains("ISO "))) {
            terraintype = true;
        }
        boolean citytownvillagecount = false;
        for (Feature f : this.mapData.getFeatures()) {
            if (!f.getTypeName().contains("Village") && !f.getTypeName().contains("Town") && !f.getTypeName().contains("City") && !f.getTypeName().contains("Capital")) continue;
            citytownvillagecount = false;
        }
        if (!citytownvillagecount) {
            int count = 0;
            int villagesplaced = 0;
            while (count < 300 && villagesplaced < 6) {
                ++count;
                int x = (int)(Math.random() * (double)(terrain.length - 2)) + 1;
                int y = (int)(Math.random() * (double)(terrain[x].length - 2)) + 1;
                Map<String, Integer> resourcessum = MapLogic.getAdjacentResourcesSum(terrain, this.mapData.getTileOrientation(), x, y);
                if (resourcessum.get("Crops") == null || resourcessum.get("Crops") + resourcessum.get("Animals") <= 300 || resourcessum.get("Lumber") + resourcessum.get("Metals") + resourcessum.get("Rock") <= 200) continue;
                Feature village = new Feature(!terraintype ? "Settlement Village" : "Settlement Isometric Medieval Village A", false, false, false, false, null, 0.0, null, !terraintype ? 75.0 : 50.0, -1.0, false, false, null, "", true, true, true, true, this.mapData.getMapLayer("Features"));
                double locx = x * 300 * 3 / 4 + 150;
                double locy = y * 300 + (x % 2 == 0 ? 0 : 150) + 150;
                if (this.mapData.getTileOrientation() == HexOrientation.ROWS) {
                    locx = x * 300 + (y % 2 == 0 ? 0 : 150) + 150;
                    locy = y * 300 * 3 / 4 + 150;
                }
                village.setLocation(ViewLevel.WORLD, new Point2D(locx, locy));
                this.mapData.getFeatures().add(village);
                ++villagesplaced;
            }
        }
    }
}

