/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.io;

import com.inkwellideas.ographer.data.FeatureDecoration;
import com.inkwellideas.ographer.data.HexOrientation;
import com.inkwellideas.ographer.data.LabelStyle;
import com.inkwellideas.ographer.data.MapLayer;
import com.inkwellideas.ographer.data.ViewLevel;
import com.inkwellideas.ographer.information.Information;
import com.inkwellideas.ographer.map.MapData;
import com.inkwellideas.ographer.map.MapDataSetTerrain;
import com.inkwellideas.ographer.map.MapDataSetup;
import com.inkwellideas.ographer.map.MapLabel;
import com.inkwellideas.ographer.map.MapProjection;
import com.inkwellideas.ographer.map.MapShape;
import com.inkwellideas.ographer.map.Terrain;
import com.inkwellideas.ographer.map.component.NumberingData;
import com.inkwellideas.ographer.map.mapping.FeatureImportMappings;
import com.inkwellideas.ographer.map.mapping.MapItemImportMappings;
import com.inkwellideas.ographer.map.mapping.TerrainImportMappings;
import com.inkwellideas.ographer.map.mapping.TextureImportMappings;
import com.inkwellideas.ographer.model.Feature;
import com.inkwellideas.ographer.model.FeatureType;
import com.inkwellideas.ographer.model.Note;
import com.inkwellideas.ographer.model.ShapeStyle;
import com.inkwellideas.ographer.model.TerrainType;
import com.inkwellideas.ographer.model.TextureType;
import com.inkwellideas.ographer.task.LoadMapTask;
import com.inkwellideas.ographer.ui.MapUI;
import com.inkwellideas.ographer.ui.Worldographer;
import com.inkwellideas.ographer.ui.setup.SetupWorldRegionScreen;
import com.inkwellideas.ographer.util.Base64;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javafx.embed.swing.SwingFXUtils;
import javafx.geometry.Point2D;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.Image;
import javafx.scene.paint.ImagePattern;
import javafx.scene.paint.Paint;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.Polygon;
import javafx.scene.shape.Shape;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;
import javafx.scene.text.TextAlignment;
import javafx.util.Pair;
import javax.imageio.ImageIO;

public class Import {
    static Worldographer worldographer;

    public static MapDataSetup importFile(Worldographer world, File file, ViewLevel level, int xhexadj, int yhexadj, MapData mapdata, HexOrientation hexorientation) throws Exception {
        String t;
        int hexh;
        int hexw;
        StringTokenizer st2;
        worldographer = world;
        MapDataSetup setup = new MapDataSetup();
        ArrayList<MapLayer> mapLayers = new ArrayList<MapLayer>();
        mapLayers.add(new MapLayer("Labels"));
        mapLayers.add(new MapLayer("Grid"));
        mapLayers.add(new MapLayer("Features"));
        mapLayers.add(new MapLayer("Above Terrain"));
        mapLayers.add(new MapLayer("Terrain Land"));
        mapLayers.add(new MapLayer("Above Water"));
        mapLayers.add(new MapLayer("Terrain Water"));
        mapLayers.add(new MapLayer("Below All"));
        setup.mapLayers = mapLayers;
        ArrayList<MapLabel> mapLabels = new ArrayList();
        if (mapdata != null) {
            mapLabels = mapdata.getMapLabels();
        }
        ArrayList<Feature> features = new ArrayList();
        if (mapdata != null) {
            features = mapdata.getFeatures();
        }
        ArrayList<MapShape> mapShapes = new ArrayList();
        if (mapdata != null) {
            mapShapes = mapdata.getShapes();
        }
        HashSet<Note> notes = new HashSet<Note>();
        if (mapdata != null) {
            notes.addAll(mapdata.getNotes());
        }
        ArrayList<StringTokenizer> mapItemLinesToParse = new ArrayList<StringTokenizer>();
        FileReader fr = null;
        FileInputStream fis = new FileInputStream(file);
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)fis, StandardCharsets.UTF_16));
        String s = br.readLine();
        long linecount = 1L;
        if (!s.contains("ographer")) {
            fis.close();
            fr = new FileReader(file);
            br = new BufferedReader(fr);
            s = br.readLine();
            ++linecount;
        }
        StringTokenizer st = new StringTokenizer(s, ", ");
        int width = Integer.parseInt(st.nextToken());
        int height = Integer.parseInt(st.nextToken());
        int uploadid = 0;
        String zoom = st.nextToken();
        String mask = "";
        boolean truerows = false;
        boolean showhexnumbers = false;
        if (zoom.contains("x")) {
            st2 = new StringTokenizer(zoom, "x");
            hexw = Integer.parseInt(st2.nextToken());
            hexh = Integer.parseInt(st2.nextToken());
        } else {
            double z = Double.parseDouble(zoom);
            hexw = (int)(36.0 * z);
            hexh = (int)(36.0 * z);
        }
        if (st.hasMoreTokens()) {
            String rc = st.nextToken();
            if (rc.startsWith("id:")) {
                uploadid = Integer.parseInt(rc.substring(rc.indexOf(":") + 1));
                rc = st.nextToken();
            }
            if ("truerows".equals(rc)) {
                truerows = true;
            }
        }
        if (hexorientation == null) {
            hexorientation = truerows ? HexOrientation.ROWS : HexOrientation.COLUMNS;
        }
        if (st.hasMoreTokens() && "icosahedral".equals(t = st.nextToken())) {
            mask = "icosahedral";
        }
        s = br.readLine();
        ++linecount;
        if (s.startsWith("show/hide")) {
            st2 = new StringTokenizer(s, "\t");
            while (st2.hasMoreTokens()) {
                if (!"show:hex_numbers".equals(st2.nextToken())) continue;
                showhexnumbers = true;
            }
            s = br.readLine();
            ++linecount;
        }
        HashMap<String, TerrainType> terrainTemplateTerrainTypes = new HashMap<String, TerrainType>();
        HashMap<String, FeatureType> terrainTemplateFeatureTypes = new HashMap<String, FeatureType>();
        Terrain[][] t2 = null;
        HashMap<String, LabelStyle> labelStyleMap = new HashMap<String, LabelStyle>();
        while (s.startsWith("line_template") || s.startsWith("text_template") || s.startsWith("terrain_template")) {
            StringTokenizer st22 = new StringTokenizer(s, "\t");
            String type = st22.nextToken();
            if (!"line_template".equals(type)) {
                if ("text_template".equals(type)) {
                    Pair<String, LabelStyle> stylePair = Import.importHex1TextTemplate(st22);
                    labelStyleMap.put((String)stylePair.getKey(), (LabelStyle)stylePair.getValue());
                } else if ("terrain_template".equals(type)) {
                    String name = st22.nextToken();
                    String category = st22.nextToken();
                    double scale = Double.parseDouble(st22.nextToken());
                    String bgcolorstring = st22.nextToken();
                    javafx.scene.paint.Color bgcolor = null;
                    if (!bgcolorstring.equals("nobackgroundcolor")) {
                        Color awtc = new Color(Integer.parseInt(bgcolorstring));
                        bgcolor = new javafx.scene.paint.Color((double)awtc.getRed() / 255.0, (double)awtc.getGreen() / 255.0, (double)awtc.getBlue() / 255.0, (double)awtc.getAlpha() / 255.0);
                    }
                    boolean isFeature = st22.nextToken().equalsIgnoreCase("true");
                    boolean isDrawBorder = st22.nextToken().equalsIgnoreCase("true");
                    boolean isFill = st22.nextToken().equalsIgnoreCase("true");
                    boolean isUseIcon = st22.nextToken().equalsIgnoreCase("true");
                    String fname = null;
                    Object simplefname = null;
                    boolean isCustom = false;
                    if (st22.hasMoreTokens() && ((fname = st22.nextToken()).equalsIgnoreCase("true") || fname.equalsIgnoreCase("false"))) {
                        isCustom = fname.equalsIgnoreCase("true");
                        fname = null;
                    }
                    if (st22.hasMoreTokens()) {
                        isCustom = st22.nextToken().equalsIgnoreCase("true");
                    }
                    if (!isFeature) {
                        boolean needtoaddtoterraintypes = true;
                        if (!terrainTemplateTerrainTypes.containsKey(name) && TerrainImportMappings.TERRAIN_IMPORT_MAPPINGS.containsKey(name)) {
                            name = TerrainImportMappings.TERRAIN_IMPORT_MAPPINGS.get(name);
                            needtoaddtoterraintypes = false;
                        }
                        if (needtoaddtoterraintypes) {
                            TerrainType tt = new TerrainType(name, null, scale, bgcolor, 100, !isCustom);
                            terrainTemplateTerrainTypes.put(name, tt);
                            Terrain.terrainTypes.put(name, tt);
                        }
                    } else {
                        if (!terrainTemplateFeatureTypes.containsKey(name) && FeatureImportMappings.FEATURE_IMPORT_MAPPINGS.containsKey(name)) {
                            name = FeatureImportMappings.FEATURE_IMPORT_MAPPINGS.get(name);
                        }
                        FeatureType ft = new FeatureType(name, null, scale, !isCustom);
                        terrainTemplateFeatureTypes.put(name, ft);
                    }
                }
            }
            s = br.readLine();
            ++linecount;
        }
        if (s.startsWith("map-key")) {
            s = Import.importHex1MapKey(br, s);
        }
        String hexnumbering = null;
        if (s.startsWith("hexes")) {
            hexnumbering = s;
            s = br.readLine();
        }
        List<String> terrainStrings = Import.importHex1TerrainToStringArray(br, s, width, height);
        s = terrainStrings.remove(terrainStrings.size() - 1);
        double xpixeladj = (double)xhexadj * 300.0;
        double ypixeladj = (double)yhexadj * 300.0;
        if (hexorientation == HexOrientation.ROWS) {
            ypixeladj *= 0.75;
        } else {
            xpixeladj *= 0.75;
        }
        while (s != null) {
            st = new StringTokenizer(s, "\t,");
            String s2 = st.nextToken();
            if ("line".equalsIgnoreCase(s2)) {
                Import.importHex1Lines(mapShapes, st, level, xpixeladj, ypixeladj, mapLayers.get(2));
            } else if ("contour".equalsIgnoreCase(s2)) {
                Import.importHex1Shapes(mapShapes, st, level, xpixeladj, ypixeladj, mapLayers.get(6), mapLayers.get(2), mapLayers.get(2), mapLayers.get(0), mapLayers.get(0));
            } else if ("text".equalsIgnoreCase(s2)) {
                Import.importHex1MapLabels(mapLabels, st, br, truerows, level, xpixeladj, ypixeladj, mapLayers.get(0));
            } else if ("symbol".equalsIgnoreCase(s2)) {
                Import.importHex1SimpleSymbol(features, st, level, xpixeladj, ypixeladj, mapLayers.get(1));
            } else if (!"freeterrain".equalsIgnoreCase(s2)) {
                if ("mapitem".equalsIgnoreCase(s2)) {
                    mapItemLinesToParse.add(st);
                } else if ("~~~~~~~~*&Begin Note".equals(s2)) {
                    linecount = Import.importHex1Note(level, notes, br, linecount, st, "Note", hexorientation, xpixeladj, ypixeladj);
                } else if (!"~~~~~~~~*&Begin PreNote".equals(s2) && !"~~~~~~~~*&Begin PostNote".equals(s2)) {
                    if ("~~~~~~~~*&Begin Icon".equals(s2)) {
                        TerrainType tt;
                        type = st.hasMoreTokens() ? st.nextToken() : "unknown " + System.nanoTime() % 100000L;
                        desc = new StringBuilder();
                        s3 = br.readLine();
                        while (!s3.contains("~~~~~~~~*&End Icon")) {
                            desc = desc.append(s3);
                            s3 = br.readLine();
                        }
                        ba = (byte[])Base64.decodeToObject(desc.toString().trim());
                        in = new ByteArrayInputStream(ba);
                        BufferedImage image = ImageIO.read(in);
                        if (!terrainTemplateTerrainTypes.containsKey(type) && TerrainImportMappings.TERRAIN_IMPORT_MAPPINGS.containsKey(type)) {
                            type = TerrainImportMappings.TERRAIN_IMPORT_MAPPINGS.get(type);
                        }
                        if ((tt = (TerrainType)terrainTemplateTerrainTypes.get(type)) != null) {
                            if (TerrainImportMappings.TERRAIN_IMPORT_MAPPINGS.containsKey(type)) {
                                type = TerrainImportMappings.TERRAIN_IMPORT_MAPPINGS.get(type);
                                tt.setType((String)type);
                            }
                            tt.setIcon((Image)SwingFXUtils.toFXImage((BufferedImage)image, null));
                            Terrain.terrainTypes.put((String)type, tt);
                        } else {
                            FeatureType ft;
                            if (!terrainTemplateFeatureTypes.containsKey(type) && FeatureImportMappings.FEATURE_IMPORT_MAPPINGS.containsKey(type)) {
                                type = FeatureImportMappings.FEATURE_IMPORT_MAPPINGS.get(type);
                            }
                            if ((ft = (FeatureType)terrainTemplateFeatureTypes.get(type)) != null) {
                                if (FeatureImportMappings.FEATURE_IMPORT_MAPPINGS.containsKey(type)) {
                                    type = FeatureImportMappings.FEATURE_IMPORT_MAPPINGS.get(type);
                                    ft.setType((String)type);
                                }
                                ft.setIcon((Image)SwingFXUtils.toFXImage((BufferedImage)image, null));
                                Feature.featureTypes.put((String)type, ft);
                            }
                        }
                    } else if ("~~~~~~~~*&Begin Simple Icon".equals(s2)) {
                        type = st.hasMoreTokens() ? st.nextToken() : "unknown " + System.nanoTime() % 100000L;
                        desc = new StringBuilder();
                        s3 = br.readLine();
                        while (!s3.contains("~~~~~~~~*&End Simple Icon")) {
                            desc = desc.append(s3);
                            s3 = br.readLine();
                        }
                    } else if ("~~~~~~~~*&Begin CustomMapItem".equals(s2)) {
                        Import.importHex1CustomMapItem(br, st);
                    } else if ("~~~~~~~~*&Begin CustomSimpleMapItem".equals(s2)) {
                        String name = null;
                        if (st.hasMoreTokens()) {
                            name = st.nextToken();
                        }
                        desc = new StringBuilder();
                        s3 = br.readLine();
                        while (!s3.contains("~~~~~~~~*&End CustomSimpleMapItem")) {
                            desc.append(s3);
                            s3 = br.readLine();
                        }
                        ba = (byte[])Base64.decodeToObject(desc.toString().trim());
                        in = new ByteArrayInputStream(ba);
                        BufferedImage bufferedImage = ImageIO.read(in);
                    }
                }
            }
            s = br.readLine();
        }
        t2 = Import.importHex1Terrain(level, terrainStrings, width, height, features, hexorientation, terrainTemplateTerrainTypes, xhexadj, yhexadj, mapdata, mapLayers);
        for (StringTokenizer stx : mapItemLinesToParse) {
            Import.importHex1MapItem(level, features, stx, xpixeladj, ypixeladj, mapLayers.get(1));
        }
        if (fr != null) {
            fr.close();
        } else {
            fis.close();
        }
        setup.view.continentFactor = 1;
        setup.view.kingdomFactor = 1;
        setup.view.provinceFactor = 1;
        setup.view.worldToContinentHOffset = 0.0;
        setup.view.continentToKingdomHOffset = 0.0;
        setup.view.kingdomToProvinceHOffset = 0.0;
        setup.view.worldToContinentVOffset = 0.0;
        setup.view.continentToKingdomVOffset = 0.0;
        setup.view.kingdomToProvinceVOffset = 0.0;
        setup.hexWidth = hexw;
        setup.hexHeight = hexh;
        setup.hexOrientation = hexorientation;
        setup.mapProjection = MapProjection.FLAT;
        setup.setTerrainByViewLevel(level, t2);
        setup.generateOneTerrain = false;
        setup.solidTerrain = null;
        setup.iconStyle = SetupWorldRegionScreen.TerrainStyle.Isometric;
        setup.notes = notes;
        setup.features = features;
        setup.shapes = mapShapes;
        setup.labels = mapLabels;
        setup.information = new ArrayList<Information>();
        setup.hexNumbering = hexnumbering;
        setup.labelStyles = labelStyleMap;
        HashMap<String, ShapeStyle> shapeStyleMap = new HashMap<String, ShapeStyle>();
        shapeStyleMap.put("River", ShapeStyle.RIVER);
        shapeStyleMap.put("River Isometric", ShapeStyle.RIVER_ISOMETRIC);
        shapeStyleMap.put("Coast Isometric", ShapeStyle.COAST_ISOMETRIC);
        shapeStyleMap.put("Road", ShapeStyle.ROAD);
        shapeStyleMap.put("Trail", ShapeStyle.TRAIL);
        shapeStyleMap.put("Border", ShapeStyle.BORDER);
        shapeStyleMap.put("Shipping", ShapeStyle.SHIPPING);
        setup.shapeStyles = shapeStyleMap;
        return setup;
    }

    private static Pair<String, LabelStyle> importHex1TextTemplate(StringTokenizer st2) {
        String name = st2.nextToken();
        String face = st2.nextToken().trim();
        Double sz = Double.parseDouble(st2.nextToken().trim());
        int sy = Integer.parseInt(st2.nextToken().trim());
        String c = st2.nextToken().trim();
        Color awtc = new Color(Integer.parseInt(c));
        javafx.scene.paint.Color color = new javafx.scene.paint.Color((double)awtc.getRed() / 255.0, (double)awtc.getGreen() / 255.0, (double)awtc.getBlue() / 255.0, (double)awtc.getAlpha() / 255.0);
        javafx.scene.paint.Color outlinecolor = null;
        if (st2.hasMoreTokens()) {
            String osz = st2.nextToken().trim();
            String oc = st2.nextToken().trim();
            Color awtoc = new Color(Integer.parseInt(oc));
            outlinecolor = new javafx.scene.paint.Color((double)awtoc.getRed() / 255.0, (double)awtoc.getGreen() / 255.0, (double)awtoc.getBlue() / 255.0, (double)awtoc.getAlpha() / 255.0);
        }
        LabelStyle ls = new LabelStyle(name, face, color, 0.0, outlinecolor, sz, sy == 1, sy == 2, null);
        return new Pair((Object)name, (Object)ls);
    }

    private static void importHex1Shapes(List<MapShape> mapShapes, StringTokenizer st, ViewLevel level, double xadjust, double yadjust, MapLayer belowallml, MapLayer aboveterrainml, MapLayer shapesml, MapLayer abovemapitemsml, MapLayer aboveallml) {
        TextureType tt;
        String texturestr;
        String next;
        String bcs;
        String fcs;
        String tags = st.nextToken();
        if (tags.contains("political") || tags.contains("infrastructure") || tags.contains("natural") || tags.contains("gm_only")) {
            fcs = st.nextToken();
        } else {
            fcs = tags;
            tags = "";
        }
        int type = 0;
        Polygon p = new Polygon();
        if (fcs.startsWith("type:")) {
            type = Integer.parseInt(fcs.substring(fcs.indexOf(":") + 1));
            fcs = st.nextToken();
        }
        Color awtfc = null;
        Color awtbc = null;
        if (fcs.startsWith("color:")) {
            awtfc = new Color(Integer.parseInt(fcs.substring(fcs.indexOf(":") + 1)));
            p.setFill((Paint)new javafx.scene.paint.Color((double)awtfc.getRed() / 255.0, (double)awtfc.getGreen() / 255.0, (double)awtfc.getBlue() / 255.0, (double)awtfc.getAlpha() / 255.0));
        }
        if ((bcs = st.nextToken()).startsWith("color:")) {
            awtbc = new Color(Integer.parseInt(bcs.substring(bcs.indexOf(":") + 1)));
            p.setStroke((Paint)new javafx.scene.paint.Color((double)awtbc.getRed() / 255.0, (double)awtbc.getGreen() / 255.0, (double)awtbc.getBlue() / 255.0, (double)awtbc.getAlpha() / 255.0));
        }
        String layerstr = st.nextToken();
        MapShape.CreationType creationStyle = MapShape.CreationType.BASIC;
        if (layerstr.startsWith("creationstyle:")) {
            if ("FRACTAL".equals(layerstr.substring(layerstr.indexOf(":") + 1))) {
                creationStyle = MapShape.CreationType.FRACTAL;
            } else if ("CURVE".equals(layerstr.substring(layerstr.indexOf(":") + 1))) {
                creationStyle = MapShape.CreationType.CURVE;
            }
            layerstr = st.nextToken();
        }
        int layer = 275;
        if (layerstr.startsWith("layer:")) {
            layer = Integer.parseInt(layerstr.substring(layerstr.indexOf(":") + 1));
            next = st.nextToken();
        } else {
            next = layerstr;
        }
        boolean roomorcorridor = false;
        if (next.startsWith("roomorcorr:")) {
            roomorcorridor = Boolean.parseBoolean(next.substring(next.indexOf(":") + 1));
            next = st.nextToken();
        }
        boolean snap = false;
        if (next.startsWith("snap:")) {
            snap = Boolean.parseBoolean(next.substring(next.indexOf(":") + 1));
            next = st.nextToken();
        }
        MapShape ms = new MapShape(level, level, (Shape)p, creationStyle, MapShape.StrokeType.SIMPLE, tags.contains("gm_only"), tags, 16.0, 16.0, 8.0, 10.0, true, true, true, true, shapesml);
        if (layer == 225) {
            ms.setMapLayer(belowallml);
        } else if (layer == 275) {
            ms.setMapLayer(aboveterrainml);
        } else if (layer == 325) {
            ms.setMapLayer(abovemapitemsml);
        } else if (layer == 375) {
            ms.setMapLayer(aboveallml);
        }
        double o = Double.parseDouble(next);
        double w = Double.parseDouble(st.nextToken()) / 100.0;
        p.setStrokeWidth(w * 3.0);
        Integer sa = Integer.valueOf(st.nextToken());
        Integer ea = Integer.valueOf(st.nextToken());
        Integer cl = Integer.valueOf(st.nextToken());
        int count = 0;
        while (st.hasMoreTokens()) {
            if (count % 2 == 0) {
                p.getPoints().add((Object)(Double.parseDouble(st.nextToken()) + xadjust));
            } else {
                p.getPoints().add((Object)(Double.parseDouble(st.nextToken()) + yadjust));
            }
            ++count;
        }
        ms.setShape((Shape)p);
        ms.getShape().setOpacity(o);
        if (!fcs.startsWith("color:") && (texturestr = TextureImportMappings.TEXTURE_IMPORT_MAPPINGS.get(fcs)) != null && (tt = TextureType.ALL_TEXTURES.get(texturestr)) != null) {
            ms.getShape().setFill((Paint)new ImagePattern(tt.getIcon(), 0.0, 0.0, 100.0, 100.0, false));
            ms.setFillTexture(tt);
        }
        if (!bcs.startsWith("color:") && (texturestr = TextureImportMappings.TEXTURE_IMPORT_MAPPINGS.get(bcs)) != null && (tt = TextureType.ALL_TEXTURES.get(texturestr)) != null) {
            ms.getShape().setStroke((Paint)new ImagePattern(tt.getIcon(), 0.0, 0.0, 100.0, 100.0, false));
            ms.setStrokeTexture(tt);
        }
        mapShapes.add(0, ms);
    }

    private static void importHex1Lines(List<MapShape> mapShapes, StringTokenizer st, ViewLevel level, double xadjust, double yadjust, MapLayer ml) {
        String cs;
        String ty = st.nextToken();
        String texture = null;
        String hashinvert = "";
        if (ty.contains("political") || ty.contains("infrastructure") || ty.contains("natural") || ty.contains("gm_only") || ty.trim().equals("")) {
            cs = st.nextToken();
        } else {
            cs = ty;
            ty = "";
        }
        MapShape.StrokeType style = MapShape.StrokeType.SIMPLE;
        MapShape.CreationType creationStyle = MapShape.CreationType.BASIC;
        if (cs.startsWith("creationstyle:")) {
            String scs = cs.substring(cs.indexOf(":") + 1);
            if ("FRACTAL".equals(scs)) {
                creationStyle = MapShape.CreationType.FRACTAL;
            }
            if ("CURVE".equals(scs)) {
                creationStyle = MapShape.CreationType.CURVE;
            }
            cs = st.nextToken();
        }
        if (cs.startsWith("texture:")) {
            texture = cs.substring(cs.indexOf(":") + 1);
            cs = st.nextToken();
        }
        if (cs.startsWith("style:")) {
            String stylestr = cs.substring(cs.indexOf(":") + 1);
            if (Character.isDigit(stylestr.charAt(0))) {
                int stylenum = Integer.parseInt("" + stylestr.charAt(0));
                if (stylenum == 1) {
                    style = MapShape.StrokeType.DASHED;
                } else if (stylenum == 2) {
                    style = MapShape.StrokeType.DOTTED;
                } else if (stylenum == 3) {
                    style = MapShape.StrokeType.ELEVATION;
                } else if (stylenum == 5) {
                    style = MapShape.StrokeType.RAILROAD;
                }
            }
            cs = st.nextToken();
        }
        if (cs.startsWith("hashinvert:")) {
            hashinvert = cs.substring(cs.indexOf(":") + 1);
            if (style == MapShape.StrokeType.ELEVATION && hashinvert.equalsIgnoreCase("true")) {
                style = MapShape.StrokeType.ELEV_INVERTED;
            }
            cs = st.nextToken();
        }
        String c = cs;
        String w = st.nextToken();
        Path p = new Path();
        Color awtc = new Color(Integer.parseInt(c));
        javafx.scene.paint.Color color = new javafx.scene.paint.Color((double)awtc.getRed() / 255.0, (double)awtc.getGreen() / 255.0, (double)awtc.getBlue() / 255.0, (double)awtc.getAlpha() / 255.0);
        p.setStroke((Paint)color);
        p.setStrokeWidth(Double.parseDouble(w) / 300.0);
        MapShape ms = new MapShape(level, level, (Shape)p, creationStyle, style, ty.contains("gm_only"), ty, 16.0, 16.0, 8.0, 8.0, true, true, true, true, ml);
        ms.setStrokeType(style);
        p.setStrokeLineCap(StrokeLineCap.ROUND);
        p.setStrokeLineJoin(StrokeLineJoin.ROUND);
        boolean first = true;
        while (st.hasMoreTokens()) {
            if (first) {
                first = false;
                MoveTo moveTo = new MoveTo();
                moveTo.setX(xadjust + Double.parseDouble(st.nextToken()));
                moveTo.setY(yadjust + Double.parseDouble(st.nextToken()));
                p.getElements().add((Object)moveTo);
                continue;
            }
            if (ms.getCreationType() == MapShape.CreationType.CURVE) {
                int ptcount;
                Double[] pts = new Double[6];
                for (int i = 0; i < pts.length; ++i) {
                    pts[i] = null;
                }
                for (ptcount = 0; st.hasMoreTokens() && ptcount < 6; ++ptcount) {
                    pts[ptcount] = Double.parseDouble(st.nextToken());
                }
                if (ptcount != 6) continue;
                CubicCurveTo cubicTo = new CubicCurveTo();
                cubicTo.setControlX1(xadjust + pts[0]);
                cubicTo.setControlY1(yadjust + pts[1]);
                cubicTo.setControlX2(xadjust + pts[2]);
                cubicTo.setControlY2(yadjust + pts[3]);
                cubicTo.setX(xadjust + pts[4]);
                cubicTo.setY(yadjust + pts[5]);
                p.getElements().add((Object)cubicTo);
                continue;
            }
            LineTo lineTo = new LineTo();
            lineTo.setX(xadjust + Double.parseDouble(st.nextToken()));
            lineTo.setY(yadjust + Double.parseDouble(st.nextToken()));
            p.getElements().add((Object)lineTo);
        }
        mapShapes.add(ms);
    }

    private static void importHex1MapLabels(List<MapLabel> mapLabels, StringTokenizer st, BufferedReader br, boolean truerows, ViewLevel level, double xadjust, double yadjust, MapLayer layer) throws Exception {
        Object ty = st.nextToken();
        if ("n/a".equals(ty)) {
            ty = "";
        }
        boolean gmonly = false;
        if (ty != null && ((String)ty).contains("gm_only")) {
            gmonly = true;
            int index = ((String)ty).indexOf("gm_only");
            int endindex = index + 7;
            if (endindex < ((String)ty).length()) {
                ++endindex;
            }
            ty = ((String)ty).substring(0, index) + (endindex < ((String)ty).length() ? ((String)ty).substring(endindex + 1) : "");
        }
        double fontsize = Double.parseDouble(st.nextToken()) / 3.0;
        int fontstyle = Integer.parseInt(st.nextToken());
        Color awtc = new Color(Integer.parseInt(st.nextToken()));
        javafx.scene.paint.Color c = new javafx.scene.paint.Color((double)awtc.getRed() / 255.0, (double)awtc.getGreen() / 255.0, (double)awtc.getBlue() / 255.0, (double)awtc.getAlpha() / 255.0);
        String next = st.nextToken();
        float rotation = 0.0f;
        if (next.startsWith("rotation:")) {
            String r = next.substring(next.indexOf(58) + 1);
            rotation = Float.parseFloat(r);
            next = st.nextToken();
        }
        javafx.scene.paint.Color outlinecolor = null;
        if (next.startsWith("outlinecolor:")) {
            String oc = next.substring(next.indexOf(58) + 1);
            Color awtoutlinecolor = new Color(Integer.parseInt(oc));
            outlinecolor = new javafx.scene.paint.Color((double)awtoutlinecolor.getRed() / 255.0, (double)awtoutlinecolor.getGreen() / 255.0, (double)awtoutlinecolor.getBlue() / 255.0, (double)awtoutlinecolor.getAlpha() / 255.0);
            next = st.nextToken();
        }
        float outlinesize = 0.0f;
        if (next.startsWith("outlinesize:")) {
            String os = next.substring(next.indexOf(58) + 1);
            outlinesize = Float.parseFloat(os) / 2.0f;
            next = st.nextToken();
        }
        if (outlinesize == 0.0f) {
            outlinecolor = null;
        }
        double mlx = xadjust + Double.parseDouble(next);
        double mly = yadjust + Double.parseDouble(st.nextToken());
        String fontface = br.readLine();
        fontface = fontface.substring(fontface.indexOf(9) + 1);
        String strtext = br.readLine();
        if (!(strtext = strtext.substring(strtext.indexOf(9) + 1)).trim().equals("")) {
            MapLabel ml = new MapLabel("", strtext, fontface, c, outlinesize, outlinecolor, null, rotation, true, true, true, true, fontstyle == 1, fontstyle == 2, gmonly, TextAlignment.CENTER, (String)ty, layer);
            Canvas canvas = new Canvas(250.0, 250.0);
            GraphicsContext gc = canvas.getGraphicsContext2D();
            gc.setFont(Font.font((String)fontface, (FontWeight)(fontstyle == 1 ? FontWeight.BOLD : FontWeight.NORMAL), (FontPosture)(fontstyle == 2 ? FontPosture.ITALIC : FontPosture.REGULAR), (double)fontsize));
            float width = (float)MapUI.getFontStringWidth(gc.getFont(), strtext);
            double dx = Math.cos(Math.toRadians(rotation)) * (double)width;
            double dy = Math.sin(Math.toRadians(rotation)) * (double)width;
            ml.setLocationAndScale(level, (Pair<Point2D, Double>)new Pair((Object)new Point2D(mlx + dx, mly + dy), (Object)fontsize));
            mapLabels.add(ml);
        }
    }

    public static void importHex1HexNumbersx(MapData mapData, String s) {
        StringTokenizer st2 = new StringTokenizer(s, "\t");
        st2.nextToken();
        mapData.getNumbering().setFontName(st2.nextToken());
        mapData.getNumbering().setFontSize(Integer.parseInt(st2.nextToken()));
        int style = Integer.parseInt(st2.nextToken());
        if (style == 1) {
            mapData.getNumbering().setFontStyle(NumberingData.FontStyle.BOLD);
        } else if (style == 2) {
            mapData.getNumbering().setFontStyle(NumberingData.FontStyle.ITALIC);
        } else {
            mapData.getNumbering().setFontStyle(NumberingData.FontStyle.PLAIN);
        }
        Color awtc = new Color(Integer.parseInt(st2.nextToken()));
        mapData.getNumbering().setFontColor(new javafx.scene.paint.Color((double)awtc.getRed() / 255.0, (double)awtc.getGreen() / 255.0, (double)awtc.getBlue() / 255.0, (double)awtc.getAlpha() / 255.0));
        String order = st2.nextToken();
        if ("Col Row".equals(order)) {
            mapData.getNumbering().setOrder(NumberingData.OrderNumbers.COL_ROW);
        } else {
            mapData.getNumbering().setOrder(NumberingData.OrderNumbers.ROW_COL);
        }
        String pos = st2.nextToken();
        if ("Top".equals(pos)) {
            mapData.getNumbering().setPosition(NumberingData.NumberPosition.TOP);
        } else {
            mapData.getNumbering().setPosition(NumberingData.NumberPosition.BOTTOM);
        }
        mapData.getNumbering().setFirstColumn(Integer.parseInt(st2.nextToken()));
        String separator = st2.nextToken();
        if (st2.hasMoreTokens()) {
            mapData.getNumbering().setSeparator(separator);
            mapData.getNumbering().setFirstRow(Integer.parseInt(st2.nextToken()));
            if (st2.hasMoreTokens()) {
                // empty if block
            }
        } else {
            mapData.getNumbering().setSeparator("");
            mapData.getNumbering().setFirstRow(Integer.parseInt(separator));
        }
    }

    private static String importHex1MapKey(BufferedReader br, String s) throws IOException {
        String enabled = s.substring(s.indexOf(9) + 1);
        s = br.readLine();
        while (!s.startsWith("end-map-key")) {
            String text;
            String size;
            String style;
            Color color;
            String face;
            StringTokenizer st2 = new StringTokenizer(s, "\t");
            String discard = st2.nextToken();
            if (s.startsWith("title")) {
                face = st2.nextToken();
                color = new Color(Integer.parseInt(st2.nextToken()));
                style = st2.nextToken();
                size = st2.nextToken();
                text = "";
                if (st2.hasMoreTokens()) {
                    text = st2.nextToken();
                }
            }
            if (s.startsWith("scale")) {
                face = st2.nextToken();
                color = new Color(Integer.parseInt(st2.nextToken()));
                style = st2.nextToken();
                size = st2.nextToken();
                text = "";
                if (st2.hasMoreTokens()) {
                    text = st2.nextToken();
                }
            }
            if (s.startsWith("item-font")) {
                face = st2.nextToken();
                color = new Color(Integer.parseInt(st2.nextToken()));
                style = st2.nextToken();
                String string = st2.nextToken();
            }
            if (s.startsWith("entry")) {
                // empty if block
            }
            s = br.readLine();
        }
        s = br.readLine();
        return s;
    }

    private static List<String> importHex1TerrainToStringArray(BufferedReader br, String s, int width, int height) throws IOException {
        ArrayList<String> sout = new ArrayList<String>();
        boolean first = true;
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                StringTokenizer st;
                sout.add(s);
                if (s.startsWith("class ")) {
                    st = new StringTokenizer(s, " ");
                    st.nextToken();
                    String tt = st.nextToken();
                    tt = tt.substring(tt.lastIndexOf(46));
                    StringBuilder terraintype = new StringBuilder("" + tt.charAt(1));
                    for (int i = 2; i < tt.length(); ++i) {
                        char c = tt.charAt(i);
                        if (Character.isUpperCase(c)) {
                            terraintype.append(" ").append(c);
                            continue;
                        }
                        terraintype.append(c);
                    }
                } else {
                    st = new StringTokenizer(s, "\t");
                    String terraintype = st.nextToken();
                    if ("Jungle Mountainss".equals(terraintype)) {
                        terraintype = "Jungle Mountains";
                    }
                }
                boolean showterrainicon = true;
                while (st.hasMoreTokens()) {
                    String s2 = st.nextToken();
                    if (!s2.startsWith("hasfeatures")) continue;
                    int featurecount = Integer.parseInt(s2.substring(s2.indexOf(58) + 1));
                    for (int i = 0; i < featurecount; ++i) {
                        String fs = br.readLine();
                        sout.add(fs);
                    }
                }
                s = br.readLine();
            }
        }
        sout.add(s);
        return sout;
    }

    private static Terrain[][] importHex1Terrain(ViewLevel vl, List<String> terrainstrings, int width, int height, List<Feature> features, HexOrientation hexorientation, Map<String, TerrainType> terrainTemplateTerrainTypes, int xadj, int yadj, MapData mapdata, ArrayList<MapLayer> mapLayers) throws IOException {
        boolean first = true;
        Terrain[][] t = new Terrain[width][height];
        if (mapdata != null) {
            t = mapdata.getTerrain(vl);
        }
        int count = 0;
        for (int x = xadj; x < width + xadj; ++x) {
            for (int y = yadj; y < height + yadj; ++y) {
                StringTokenizer st;
                if (x >= width + xadj || y >= height + yadj) {
                    ++count;
                    continue;
                }
                String s = terrainstrings.get(count);
                ++count;
                if (s.startsWith("class ")) {
                    st = new StringTokenizer(s, " ");
                    st.nextToken();
                    String tt = st.nextToken();
                    tt = tt.substring(tt.lastIndexOf(46));
                    StringBuilder terraintype = new StringBuilder("" + tt.charAt(1));
                    for (int i = 2; i < tt.length(); ++i) {
                        char c = tt.charAt(i);
                        if (Character.isUpperCase(c)) {
                            terraintype.append(" ").append(c);
                            continue;
                        }
                        terraintype.append(c);
                    }
                    if (x < t.length && y < t[x].length) {
                        t[x][y] = new Terrain(terraintype.toString(), true);
                    }
                } else {
                    st = new StringTokenizer(s, "\t");
                    Object terraintype = st.nextToken();
                    if ("Jungle Mountainss".equals(terraintype)) {
                        terraintype = "Jungle Mountains";
                    }
                    if (LoadMapTask.v1Tov2TerrainTypes.containsKey(terraintype = MapDataSetTerrain.convertTerrainType((String)terraintype, terrainTemplateTerrainTypes))) {
                        terraintype = LoadMapTask.v1Tov2TerrainTypes.get(terraintype);
                    } else if (((String)terraintype).startsWith("ISO Cols ")) {
                        if (Terrain.DEFAULT_TERRAIN.containsKey("ISO Cols/" + ((String)terraintype).substring(9))) {
                            terraintype = "ISO Cols/" + ((String)terraintype).substring(9);
                        }
                    } else if (((String)terraintype).startsWith("ISO Rows ") && Terrain.DEFAULT_TERRAIN.containsKey("ISO Rows/" + ((String)terraintype).substring(9))) {
                        terraintype = "ISO Rows/" + ((String)terraintype).substring(9);
                    }
                    if (!Terrain.DEFAULT_TERRAIN.containsKey(terraintype)) {
                        worldographer.addStatus("Terrain type:" + (String)terraintype + " not found.");
                    }
                    if (x < t.length && y < t[x].length) {
                        t[x][y] = new Terrain((String)terraintype, true);
                    }
                }
                boolean showterrainicon = true;
                boolean fillhexbottom = false;
                while (st.hasMoreTokens()) {
                    String s2 = st.nextToken();
                    if ("icy".equals(s2)) {
                        if (x >= t.length || y >= t[x].length) continue;
                        t[x][y].setIcy(true);
                        continue;
                    }
                    if ("ringed".equals(s2)) {
                        String c = st.nextToken();
                        continue;
                    }
                    if (s2.startsWith("elevation:")) {
                        if (x >= t.length || y >= t[x].length) continue;
                        t[x][y].setElevation(Integer.parseInt(s2.substring(s2.indexOf(":") + 1)));
                        continue;
                    }
                    if (s2.startsWith("gmonly")) {
                        if (x >= t.length || y >= t[x].length) continue;
                        t[x][y].setGmOnly(true);
                        continue;
                    }
                    if (s2.startsWith("cropped")) continue;
                    if (s2.startsWith("no-terrain-icon")) {
                        showterrainicon = false;
                        continue;
                    }
                    if (s2.startsWith("fill-hex-bottom")) {
                        fillhexbottom = true;
                        continue;
                    }
                    if (!s2.startsWith("hasfeatures")) continue;
                    int featurecount = Integer.parseInt(s2.substring(s2.indexOf(58) + 1));
                    for (int i = 0; i < featurecount; ++i) {
                        double ptx;
                        String fs = terrainstrings.get(count);
                        ++count;
                        StringTokenizer fst = new StringTokenizer(fs, "\t");
                        if (!fst.hasMoreTokens() || !fst.nextToken().equals("feature")) continue;
                        Object featurename = null;
                        int locationx = -1;
                        int locationy = -1;
                        javafx.scene.paint.Color featurecolor = null;
                        javafx.scene.paint.Color ringcolor = null;
                        boolean fgmonly = false;
                        float featurescale = -1.0f;
                        float rotation = 0.0f;
                        ArrayList<FeatureDecoration> featuredecs = new ArrayList<FeatureDecoration>();
                        while (fst.hasMoreTokens()) {
                            String str = fst.nextToken();
                            if (str.startsWith("type:")) {
                                featurename = str.substring(str.indexOf(58) + 1);
                                continue;
                            }
                            if (str.startsWith("locationx:")) {
                                locationx = Integer.parseInt(str.substring(str.indexOf(58) + 1));
                                continue;
                            }
                            if (str.startsWith("locationy:")) {
                                locationy = Integer.parseInt(str.substring(str.indexOf(58) + 1));
                                continue;
                            }
                            if (str.startsWith("featurecolor:")) {
                                String fcs = str.substring(str.indexOf(58) + 1);
                                Color awtc = new Color(Integer.parseInt(fcs));
                                featurecolor = new javafx.scene.paint.Color((double)awtc.getRed() / 255.0, (double)awtc.getGreen() / 255.0, (double)awtc.getBlue() / 255.0, 1.0 - (double)awtc.getAlpha() / 255.0);
                                continue;
                            }
                            if (str.startsWith("ringcolor:")) {
                                String rcs = str.substring(str.indexOf(58) + 1);
                                if (rcs == null) continue;
                                Color awtc = new Color(Integer.parseInt(rcs));
                                ringcolor = new javafx.scene.paint.Color((double)awtc.getRed() / 255.0, (double)awtc.getGreen() / 255.0, (double)awtc.getBlue() / 255.0, (double)awtc.getAlpha() / 255.0);
                                continue;
                            }
                            if (str.startsWith("gmonly:")) {
                                fgmonly = "true".equalsIgnoreCase(str.substring(str.indexOf(58) + 1));
                                continue;
                            }
                            if (str.startsWith("featurescale:")) {
                                featurescale = Float.parseFloat(str.substring(str.indexOf(58) + 1)) * 100.0f;
                                continue;
                            }
                            if (str.startsWith("rotation:")) {
                                rotation = Float.parseFloat(str.substring(str.indexOf(58) + 1));
                                continue;
                            }
                            if (!str.startsWith("featuredec:")) continue;
                            String dec = str.substring(str.indexOf(58) + 1);
                            str = fst.nextToken();
                            int pos = Integer.parseInt(str.substring(str.indexOf(58) + 1));
                            str = fst.nextToken();
                            String face = str.substring(str.indexOf(58) + 1);
                            str = fst.nextToken();
                            String style = str.substring(str.indexOf(58) + 1);
                            str = fst.nextToken();
                            int size = Integer.parseInt(str.substring(str.indexOf(58) + 1));
                            str = fst.nextToken();
                            Color fdawtcolor = new Color(Integer.parseInt(str.substring(str.indexOf(58) + 1)));
                            javafx.scene.paint.Color fdcolor = new javafx.scene.paint.Color((double)fdawtcolor.getRed() / 255.0, (double)fdawtcolor.getGreen() / 255.0, (double)fdawtcolor.getBlue() / 255.0, (double)fdawtcolor.getAlpha() / 255.0);
                            featuredecs.add(new FeatureDecoration(dec, fdcolor, (double)pos * 30.0));
                        }
                        if (!Feature.featureTypes.containsKey(featurename)) {
                            String type2;
                            if (FeatureImportMappings.FEATURE_IMPORT_MAPPINGS.containsKey(featurename)) {
                                featurename = FeatureImportMappings.FEATURE_IMPORT_MAPPINGS.get(featurename);
                            }
                            if ((type2 = LoadMapTask.v1Tov2FeatureTypes.get(featurename)) != null) {
                                featurename = type2;
                            } else {
                                for (int k = 0; k < LoadMapTask.terrainPrefixes.length; k += 2) {
                                    if (!((String)featurename).startsWith(LoadMapTask.terrainPrefixes[k]) || !Feature.DEFAULT_FEATURES.containsKey(LoadMapTask.terrainPrefixes[k + 1] + ((String)featurename).substring(LoadMapTask.terrainPrefixes[k].length()))) continue;
                                    featurename = LoadMapTask.terrainPrefixes[k + 1] + ((String)featurename).substring(LoadMapTask.terrainPrefixes[k].length());
                                    break;
                                }
                            }
                        }
                        if (!Feature.featureTypes.containsKey(featurename)) {
                            worldographer.addStatus("feature not found:" + featurename);
                            continue;
                        }
                        if (featurescale < 1.0f) {
                            featurescale = (float)Feature.featureTypes.get((Object)featurename).iconSize * 100.0f;
                        }
                        Feature f = new Feature((String)featurename, false, !showterrainicon, fgmonly, fillhexbottom, ringcolor, rotation, featurecolor, featurescale, -1.0, false, false, null, "", true, true, true, true, mapLayers.get(1));
                        for (int j = 0; j < featuredecs.size() && j < f.getFeatureDecorations().length; ++j) {
                            f.getFeatureDecorations()[j] = (FeatureDecoration)featuredecs.get(j);
                        }
                        double d = hexorientation == HexOrientation.COLUMNS ? (double)(x * 300 * 3 / 4 + 150) : (ptx = (double)(x * 300 + (y % 2 == 0 ? 150 : 300)));
                        double pty = hexorientation == HexOrientation.COLUMNS ? (double)(y * 300 + (x % 2 == 0 ? 150 : 300)) : (double)(y * 300 * 3 / 4);
                        f.setLocation(vl, ptx, pty);
                        if (featuredecs.size() > 0) {
                            FeatureDecoration[] featureDecorations = new FeatureDecoration[featuredecs.size()];
                            for (int k = 0; k < featureDecorations.length; ++k) {
                                featureDecorations[k] = (FeatureDecoration)featuredecs.get(k);
                            }
                            f.setFeatureDecorations(featureDecorations);
                        }
                        features.add(f);
                    }
                }
            }
        }
        return t;
    }

    private static void importHex1SimpleSymbol(List<Feature> features, StringTokenizer st, ViewLevel level, double xadjust, double yadjust, MapLayer ml) {
        String ty = st.nextToken();
        int x = Integer.parseInt(st.nextToken());
        int y = Integer.parseInt(st.nextToken());
        Color awtc = new Color(Integer.parseInt(st.nextToken()));
        javafx.scene.paint.Color c = new javafx.scene.paint.Color((double)awtc.getRed() / 255.0, (double)awtc.getGreen() / 255.0, (double)awtc.getBlue() / 255.0, (double)awtc.getAlpha() / 255.0);
        boolean gmonly = false;
        if (st.hasMoreTokens()) {
            gmonly = Boolean.parseBoolean(st.nextToken());
        }
        Feature f = new Feature(ty, true, false, gmonly, false, null, 0.0, c, 40.0, 40.0, false, false, null, "", true, true, true, true, ml);
        f.setLocation(level, (double)x + xadjust, (double)y + yadjust);
        if (f.getType() != null) {
            features.add(f);
        }
    }

    private static long importHex1Note(ViewLevel vl, Set<Note> notes, BufferedReader br, long linecount, StringTokenizer st, String key, HexOrientation hexorientation, double xadjust, double yadjust) throws IOException {
        int ptx;
        int x = Integer.parseInt(st.nextToken());
        int y = Integer.parseInt(st.nextToken());
        int n = hexorientation == HexOrientation.COLUMNS ? x * 300 * 3 / 4 + 50 : (ptx = x * 300 + (y % 2 == 0 ? 50 : 200) + (int)xadjust);
        int pty = hexorientation == HexOrientation.COLUMNS ? y * 300 + (x % 2 == 0 ? 150 : 300) : y * 300 * 3 / 4 + (int)yadjust;
        String title = br.readLine();
        String link = null;
        if (title != null && title.startsWith("**link:")) {
            link = title;
            link = link.substring(7);
            title = br.readLine();
        }
        ++linecount;
        StringBuilder desc = new StringBuilder();
        String s3 = br.readLine();
        ++linecount;
        while (!s3.contains("~~~~~~~~*&End " + key)) {
            desc = desc.append(s3).append('\n');
            s3 = br.readLine();
            ++linecount;
        }
        if (desc.length() > 0) {
            desc = new StringBuilder(desc.substring(0, desc.length() - 1));
        }
        Note n2 = new Note(vl, ptx, pty);
        n2.setTitle(title);
        n2.setDetails(desc.toString());
        notes.add(n2);
        return linecount;
    }

    private static void importHex1CustomMapItem(BufferedReader br, StringTokenizer st) throws IOException {
        String name = null;
        if (st.hasMoreTokens()) {
            name = st.nextToken();
        }
        StringBuilder desc = new StringBuilder();
        String s3 = br.readLine();
        while (!s3.contains("~~~~~~~~*&End CustomMapItem")) {
            desc.append(s3);
            s3 = br.readLine();
        }
        byte[] ba = (byte[])Base64.decodeToObject(desc.toString().trim());
        ByteArrayInputStream in = new ByteArrayInputStream(ba);
        BufferedImage image = ImageIO.read(in);
        Feature.featureTypes.put(name, new FeatureType(name, (Image)SwingFXUtils.toFXImage((BufferedImage)image, null), false));
    }

    private static void importHex1MapItem(ViewLevel level, List<Feature> features, StringTokenizer stx, double xadjust, double yadjust, MapLayer ml) {
        Image icon;
        Feature f;
        String importshape;
        String shape = "0";
        int x = 0;
        int y = 0;
        String texture = "";
        String label = "";
        int outlinecolor = 0;
        int fillcolor = 0;
        int labeltextcolor = 0;
        int labelbgcolor = 0;
        int rotation = 0;
        double miwidth = -1.0;
        double miheight = -1.0;
        boolean showroofline = false;
        boolean gmonly = false;
        while (stx.hasMoreTokens()) {
            String str = stx.nextToken();
            if (str.startsWith("shape:")) {
                shape = str.substring(str.indexOf(58) + 1);
                continue;
            }
            if (str.startsWith("locationx:")) {
                x = Integer.parseInt(str.substring(str.indexOf(58) + 1));
                continue;
            }
            if (str.startsWith("locationy:")) {
                y = Integer.parseInt(str.substring(str.indexOf(58) + 1));
                continue;
            }
            if (str.startsWith("texture:")) {
                texture = str.substring(str.indexOf(58) + 1);
                continue;
            }
            if (str.startsWith("outlinecolor:")) {
                outlinecolor = Integer.parseInt(str.substring(str.indexOf(58) + 1));
                continue;
            }
            if (str.startsWith("fillcolor:")) {
                fillcolor = Integer.parseInt(str.substring(str.indexOf(58) + 1));
                continue;
            }
            if (str.startsWith("rotation:")) {
                rotation = Integer.parseInt(str.substring(str.indexOf(58) + 1));
                continue;
            }
            if (str.startsWith("width:")) {
                miwidth = Double.parseDouble(str.substring(str.indexOf(58) + 1));
                continue;
            }
            if (str.startsWith("height:")) {
                miheight = Double.parseDouble(str.substring(str.indexOf(58) + 1));
                continue;
            }
            if (str.startsWith("showroofline:")) {
                showroofline = "true".equalsIgnoreCase(str.substring(str.indexOf(58) + 1));
                continue;
            }
            if (str.startsWith("gmonly:")) {
                gmonly = "true".equalsIgnoreCase(str.substring(str.indexOf(58) + 1));
                continue;
            }
            if (str.startsWith("label:")) {
                label = str.substring(str.indexOf(58) + 1);
                continue;
            }
            if (str.startsWith("labeltextcolor:")) {
                labeltextcolor = Integer.parseInt(str.substring(str.indexOf(58) + 1));
                continue;
            }
            if (!str.startsWith("labelbgcolor:")) continue;
            labelbgcolor = Integer.parseInt(str.substring(str.indexOf(58) + 1));
        }
        if (!Feature.featureTypes.containsKey(shape) && (importshape = MapItemImportMappings.MAP_ITEM_IMPORT_MAPPINGS.get(shape)) != null) {
            shape = importshape;
        }
        MapLabel featureLabel = null;
        if (!label.equalsIgnoreCase("")) {
            featureLabel = new MapLabel("City", label, "Arial", javafx.scene.paint.Color.BLACK, 1.0, javafx.scene.paint.Color.LIGHTGRAY, null, 0.0, true, true, true, true, false, false, gmonly, TextAlignment.CENTER, "", ml);
        }
        if ((f = new Feature(shape, true, false, gmonly, false, null, rotation, null, miwidth, miheight, false, false, featureLabel, "", true, true, true, true, ml)).getType() != null && (icon = f.getType().getIcon()) != null) {
            f.setScale(miwidth * icon.getWidth() / 300.0);
            f.setScaleHt(miheight * icon.getHeight() / 300.0);
        }
        f.setLocation(level, (double)x + xadjust, (double)y + yadjust);
        if (f.getType() != null) {
            features.add(f);
        }
    }
}

