/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.map;

import com.inkwellideas.ographer.data.HexOrientation;
import com.inkwellideas.ographer.data.LabelStyle;
import com.inkwellideas.ographer.data.MapLayer;
import com.inkwellideas.ographer.data.ViewLevel;
import com.inkwellideas.ographer.generator.world.WorldAndNameData;
import com.inkwellideas.ographer.generator.world.WorldSimulator;
import com.inkwellideas.ographer.information.Information;
import com.inkwellideas.ographer.map.MapDataIO;
import com.inkwellideas.ographer.map.MapDataSetup;
import com.inkwellideas.ographer.map.MapKeySettings;
import com.inkwellideas.ographer.map.MapLabel;
import com.inkwellideas.ographer.map.MapProjection;
import com.inkwellideas.ographer.map.MapShape;
import com.inkwellideas.ographer.map.ResourceType;
import com.inkwellideas.ographer.map.Terrain;
import com.inkwellideas.ographer.map.component.GridData;
import com.inkwellideas.ographer.map.component.NumberingData;
import com.inkwellideas.ographer.map.component.ShowData;
import com.inkwellideas.ographer.map.component.TraceData;
import com.inkwellideas.ographer.map.component.ViewLevelData;
import com.inkwellideas.ographer.model.Feature;
import com.inkwellideas.ographer.model.FeatureType;
import com.inkwellideas.ographer.model.Note;
import com.inkwellideas.ographer.model.ShapeStyle;
import com.inkwellideas.ographer.model.TerrainType;
import com.inkwellideas.ographer.ui.Worldographer;
import com.inkwellideas.ographer.ui.toolbox.WLogger;
import com.inkwellideas.ographer.undo.Point;
import com.inkwellideas.ographer.undo.UndoAction;
import com.inkwellideas.ographer.undo.UndoActionGroup;
import com.inkwellideas.ographer.undo.UndoRedoHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javafx.geometry.Point2D;
import javafx.scene.paint.Color;
import javafx.util.Pair;

public class MapData {
    private ViewLevelData view = new ViewLevelData();
    private TraceData trace = new TraceData();
    private GridData grid = new GridData();
    private ShowData show = new ShowData();
    private NumberingData numbering = new NumberingData();
    private final MapKeySettings mapKeySettings;
    private List<Information> information;
    private File file = null;
    private WorldSimulator worldSimulator;
    private Terrain[][] terrainWorldLevel;
    private Terrain[][] terrainContinentLevel;
    private Terrain[][] terrainKingdomLevel;
    private Terrain[][] terrainProvinceLevel;
    private Terrain[][] terrainBattlematLevel;
    private Terrain[][] terrainSettlementLevel;
    private Terrain[][] terrainCosmicLevel;
    private Map<MapLayer, Map<Point, Terrain>> extraTerrainByLayer;
    private Set<Note> notes;
    private Color maskColor = Color.GRAY;
    private HexOrientation hexOrientation;
    private MapProjection mapProjection;
    private List<MapLayer> mapLayers;
    private List<Feature> features;
    private List<MapShape> shapes;
    private List<MapLabel> labels;
    private double hexWidth;
    private double hexHeight;
    private Map<String, LabelStyle> labelStyles;
    private Map<String, ShapeStyle> shapeStyles;

    public MapData(MapDataSetup setup) {
        String cat;
        int index;
        this.terrainSettlementLevel = setup.settlementTerrain;
        this.terrainBattlematLevel = setup.battleMatTerrain;
        this.terrainCosmicLevel = setup.cosmicTerrain;
        this.terrainWorldLevel = setup.worldTerrain;
        this.terrainKingdomLevel = setup.kingdomTerrain;
        this.terrainProvinceLevel = setup.provinceTerrain;
        this.terrainContinentLevel = setup.continentTerrain;
        this.extraTerrainByLayer = setup.extraTerrainByLayer;
        this.labelStyles = setup.labelStyles;
        this.shapeStyles = setup.shapeStyles;
        if (this.notes == null) {
            this.notes = new HashSet<Note>();
        }
        this.notes.addAll(setup.notes);
        this.setMapLayers(setup.mapLayers);
        if (this.getMapLayers() == null) {
            this.setMapLayers(new ArrayList<MapLayer>());
            this.getMapLayers().add(new MapLayer("Labels"));
            this.getMapLayers().add(new MapLayer("Grid"));
            this.getMapLayers().add(new MapLayer("Features"));
            this.getMapLayers().add(new MapLayer("Above Terrain"));
            this.getMapLayers().add(new MapLayer("Terrain Land"));
            this.getMapLayers().add(new MapLayer("Above Water"));
            this.getMapLayers().add(new MapLayer("Terrain Water"));
            this.getMapLayers().add(new MapLayer("Below All"));
        }
        for (TerrainType tt : Terrain.terrainTypes.values()) {
            index = tt.getType().indexOf("/");
            if (index <= 0 || Worldographer.terrainCategories.contains((Object)(cat = tt.getType().substring(0, index)))) continue;
            Worldographer.terrainCategories.add((Object)cat);
        }
        this.setFeatures(setup.features);
        for (FeatureType ft : Feature.featureTypes.values()) {
            index = ft.getType().indexOf("/");
            if (index <= 0 || Worldographer.featureCategories.contains((Object)(cat = ft.getType().substring(0, index)))) continue;
            Worldographer.featureCategories.add((Object)cat);
        }
        this.setShapes(setup.shapes);
        this.setLabels(setup.labels);
        this.hexWidth = setup.hexWidth;
        this.hexHeight = setup.hexHeight;
        this.hexOrientation = setup.hexOrientation;
        this.mapProjection = setup.mapProjection;
        this.getShow().apply(setup.show);
        this.getView().apply(setup.view, this);
        this.getGrid().apply(setup.grid);
        this.getNumbering().apply(setup.numbering);
        this.information = setup.information;
        if (this.information == null) {
            this.information = this.terrainSettlementLevel != null ? WorldAndNameData.generateAllInfo(0) : (this.terrainBattlematLevel != null ? WorldAndNameData.generateAllInfo(0) : (this.terrainCosmicLevel != null ? WorldAndNameData.generateAllInfo(0) : WorldAndNameData.generateAllInfo(setup.numNations)));
        }
        this.getTrace().apply(setup.trace);
        this.mapKeySettings = setup.mapKeySettings == null ? new MapKeySettings() : setup.mapKeySettings;
        for (MapLayer mapLayer : setup.extraTerrainByLayer.keySet()) {
            this.getExtraTerrainByLayer().put(mapLayer, setup.extraTerrainByLayer.get(mapLayer));
            for (Point pt : setup.extraTerrainByLayer.get(mapLayer).keySet()) {
                setup.extraTerrainByLayer.get(mapLayer).get(pt).setMapLayerAndLocation((Pair<MapLayer, Point>)new Pair((Object)mapLayer, (Object)pt));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public MapData(MapData source, ViewLevel viewLevel) {
        ViewLevelData viewLevelData;
        if (viewLevel == ViewLevel.SETTLEMENT) {
            this.terrainSettlementLevel = source.getTerrain(ViewLevel.SETTLEMENT);
        }
        if (viewLevel == ViewLevel.BATTLEMAT) {
            this.terrainBattlematLevel = source.getTerrain(ViewLevel.BATTLEMAT);
        }
        if (viewLevel == ViewLevel.COSMIC) {
            this.terrainCosmicLevel = source.getTerrain(ViewLevel.COSMIC);
        }
        if (viewLevel == ViewLevel.WORLD) {
            this.terrainWorldLevel = source.getTerrain(ViewLevel.WORLD);
        }
        if (viewLevel == ViewLevel.KINGDOM) {
            this.terrainKingdomLevel = source.getTerrain(ViewLevel.KINGDOM);
        }
        if (viewLevel == ViewLevel.CONTINENT) {
            this.terrainContinentLevel = source.getTerrain(ViewLevel.CONTINENT);
        }
        if (viewLevel == ViewLevel.PROVINCE) {
            this.terrainProvinceLevel = source.getTerrain(ViewLevel.PROVINCE);
        }
        ArrayList<MapLayer> destLayers = new ArrayList<MapLayer>();
        HashMap<String, MapLayer> destLayersMap = new HashMap<String, MapLayer>();
        for (MapLayer mapLayer : source.getMapLayers()) {
            MapLayer mapLayer2 = new MapLayer(mapLayer.getName());
            destLayers.add(mapLayer2);
            destLayersMap.put(mapLayer.getName(), mapLayer2);
        }
        this.setMapLayers(destLayers);
        HashMap<MapLayer, Map<Point, Terrain>> destExtraTerrainByLayer = new HashMap<MapLayer, Map<Point, Terrain>>();
        for (MapLayer mapLayer : source.extraTerrainByLayer.keySet()) {
            MapLayer mapLayer3 = (MapLayer)destLayersMap.get(mapLayer.getName());
            Map map = (Map)destExtraTerrainByLayer.get(mapLayer3);
            if (map == null) {
                HashMap hashMap = new HashMap();
                destExtraTerrainByLayer.put(mapLayer3, hashMap);
            }
            for (Point pt : source.extraTerrainByLayer.get(mapLayer).keySet()) {
                void var9_19;
                Terrain t = source.extraTerrainByLayer.get(mapLayer).get(pt);
                var9_19.put(new Point(pt.getX(), pt.getY()), t.clone());
            }
        }
        this.extraTerrainByLayer = destExtraTerrainByLayer;
        this.labelStyles = source.getLabelStyles();
        this.shapeStyles = source.getShapeStyles();
        HashSet<Note> hashSet = new HashSet<Note>();
        for (Note note : source.getNotes()) {
            hashSet.add((Note)note.clone());
        }
        this.setNotes(hashSet);
        ArrayList<Feature> arrayList = new ArrayList<Feature>();
        for (Feature feature : source.getFeatures()) {
            arrayList.add(feature.clone());
        }
        this.setFeatures(arrayList);
        ArrayList<MapShape> arrayList2 = new ArrayList<MapShape>();
        for (MapShape mapShape : source.getShapes()) {
            arrayList2.add(mapShape.clone());
        }
        this.setShapes(arrayList2);
        ArrayList<MapLabel> arrayList3 = new ArrayList<MapLabel>();
        for (MapLabel label : source.getLabels()) {
            arrayList3.add(label.clone());
        }
        this.setLabels(arrayList3);
        this.hexWidth = source.hexWidth;
        this.hexHeight = source.hexHeight;
        this.hexOrientation = source.hexOrientation;
        this.mapProjection = source.mapProjection;
        ShowData showData = new ShowData();
        showData.setFeatureLabels(source.show.isFeatureLabels());
        showData.setGMOnly(source.show.isGMOnly());
        showData.setGMOnlyGlow(source.show.isGMOnlyGlow());
        showData.setGrid(source.show.isGrid());
        showData.setGridNumbers(source.show.isGridNumbers());
        showData.setShadows(source.show.isShadows());
        showData.setNotes(source.show.isNotes());
        this.show = showData;
        this.view = viewLevelData = new ViewLevelData();
        GridData gridData = new GridData();
        gridData.setOffsetX(source.grid.getOffsetX());
        gridData.setOffsetY(source.grid.getOffsetY());
        gridData.setSquare(source.grid.getSquare());
        gridData.setSquareHeight(source.grid.getSquareHeight());
        gridData.setSquareWidth(source.grid.getSquareWidth());
        gridData.width = source.grid.getWidth();
        gridData.color = source.grid.getColor();
        this.grid = gridData;
        NumberingData numberingData = new NumberingData();
        numberingData.setFirstColumn(source.numbering.getFirstColumn());
        numberingData.setFirstRow(source.numbering.getFirstRow());
        numberingData.setFontColor(source.numbering.getFontColor());
        numberingData.setFontName(source.numbering.getFontName());
        numberingData.setFontSize(source.numbering.getFontSize());
        numberingData.setFontStyle(source.numbering.getFontStyle());
        numberingData.setPosition(source.numbering.getPosition());
        numberingData.setPrePadNums(source.numbering.getPrePadNums());
        numberingData.setOrder(source.numbering.getOrder());
        numberingData.setSeparator(source.numbering.getSeparator());
        this.numbering = numberingData;
        this.grid = source.getGrid();
        this.numbering = source.numbering;
        this.information = source.information;
        this.trace = source.trace;
        this.mapKeySettings = source.mapKeySettings == null ? new MapKeySettings() : source.mapKeySettings;
        for (MapLayer mapLayer : source.extraTerrainByLayer.keySet()) {
            this.getExtraTerrainByLayer().put(mapLayer, source.extraTerrainByLayer.get(mapLayer));
            for (Point pt : source.extraTerrainByLayer.get(mapLayer).keySet()) {
                source.extraTerrainByLayer.get(mapLayer).get(pt).setMapLayerAndLocation((Pair<MapLayer, Point>)new Pair((Object)mapLayer, (Object)pt));
            }
        }
    }

    public void setupUndoRedoHandler(WLogger WLogger2) {
        new UndoRedoHandler(this, WLogger2);
    }

    public MapKeySettings getMapKeySettings() {
        return this.mapKeySettings;
    }

    public Map<String, LabelStyle> getLabelStyles() {
        return this.labelStyles;
    }

    public Map<String, ShapeStyle> getShapeStyles() {
        return this.shapeStyles;
    }

    public WorldSimulator getWorldSimulator() {
        return this.worldSimulator;
    }

    public void setWorldSimulator(WorldSimulator worldSimulator) {
        this.worldSimulator = worldSimulator;
    }

    public Terrain[][] getTerrain(ViewLevel vl) {
        return switch (vl) {
            case ViewLevel.COSMIC -> this.terrainCosmicLevel;
            case ViewLevel.CONTINENT -> this.terrainContinentLevel;
            case ViewLevel.KINGDOM -> this.terrainKingdomLevel;
            case ViewLevel.PROVINCE -> this.terrainProvinceLevel;
            case ViewLevel.SETTLEMENT -> this.terrainSettlementLevel;
            case ViewLevel.BATTLEMAT -> this.terrainBattlematLevel;
            default -> this.terrainWorldLevel;
        };
    }

    public void setTerrain(Terrain[][] t, ViewLevel level) {
        switch (level) {
            case COSMIC: {
                this.terrainCosmicLevel = t;
                break;
            }
            case CONTINENT: {
                this.terrainContinentLevel = t;
                break;
            }
            case KINGDOM: {
                this.terrainKingdomLevel = t;
                break;
            }
            case PROVINCE: {
                this.terrainProvinceLevel = t;
                break;
            }
            case SETTLEMENT: {
                this.terrainSettlementLevel = t;
                break;
            }
            case BATTLEMAT: {
                this.terrainBattlematLevel = t;
                break;
            }
            default: {
                this.terrainWorldLevel = t;
            }
        }
    }

    public Map<MapLayer, Map<Point, Terrain>> getExtraTerrainByLayer() {
        return this.extraTerrainByLayer;
    }

    public void setExtraTerrainByLayer(Map<MapLayer, Map<Point, Terrain>> extraTerrainByLayer) {
        this.extraTerrainByLayer = extraTerrainByLayer;
    }

    public MapLayer getMapLayer(String key) {
        for (MapLayer ml : this.getMapLayers()) {
            if (!key.equals(ml.getName())) continue;
            return ml;
        }
        return null;
    }

    public MapLayer getOrCreateMapLayer(String key, String createAboveThisML) {
        for (MapLayer ml : this.getMapLayers()) {
            if (!key.equals(ml.getName())) continue;
            return ml;
        }
        MapLayer ml = new MapLayer(key);
        int found = 0;
        for (int i = 0; i < this.getMapLayers().size(); ++i) {
            if (!this.getMapLayers().get(i).getName().equalsIgnoreCase(createAboveThisML)) continue;
            found = i;
            break;
        }
        this.getMapLayers().add(found, ml);
        Worldographer.getWorldographer().layersToolbox.layersTableView.getItems().add(found, (Object)ml);
        return ml;
    }

    public List<MapLayer> getMapLayers() {
        return this.mapLayers;
    }

    public void setMapLayers(List<MapLayer> mapLayers) {
        this.mapLayers = mapLayers;
    }

    public Point2D getParentTerrainCoords(int x, int y, ViewLevel currentLevel, boolean onlyReturnExactChildren) {
        double parentX;
        if (currentLevel == ViewLevel.WORLD) {
            return null;
        }
        int expansionRatio = this.getView().getKingdomFactor();
        if (currentLevel == ViewLevel.CONTINENT) {
            expansionRatio = this.getView().getContinentFactor();
        }
        int halfExpansion = expansionRatio / 2;
        if (this.getTileOrientation() == HexOrientation.COLUMNS) {
            double parentY;
            double parentX2 = (double)x * 1.0 / (double)expansionRatio;
            double d = parentY = parentX2 % 2.0 == 0.0 ? (double)y * 1.0 / (double)expansionRatio : (double)(y - halfExpansion) * 1.0 / (double)expansionRatio;
            if (!onlyReturnExactChildren || parentX2 % 1.0 == 0.0 && parentY % 1.0 == 0.0) {
                return new Point2D((double)((int)parentX2), (double)((int)parentY));
            }
            return null;
        }
        double parentY = (double)y * 1.0 / (double)expansionRatio;
        double d = parentX = parentY % 2.0 == 0.0 ? (double)x * 1.0 / (double)expansionRatio : (double)(x - halfExpansion) * 1.0 / (double)expansionRatio;
        if (!onlyReturnExactChildren || parentX % 1.0 == 0.0 && parentY % 1.0 == 0.0) {
            return new Point2D((double)((int)parentX), (double)((int)parentY));
        }
        return null;
    }

    public void addNewFeature(ViewLevel vl, UndoActionGroup uag, Feature f, double x, double y) {
        f.setLocation(vl, x, y);
        if (this.getTerrain(ViewLevel.CONTINENT) != null) {
            this.updateFeatureLocationNewLevel(vl, ViewLevel.CONTINENT, f);
        }
        if (this.getTerrain(ViewLevel.KINGDOM) != null) {
            this.updateFeatureLocationNewLevel(vl, ViewLevel.KINGDOM, f);
        }
        if (this.getTerrain(ViewLevel.PROVINCE) != null) {
            this.updateFeatureLocationNewLevel(vl, ViewLevel.PROVINCE, f);
        }
        if (this.getTerrain(ViewLevel.WORLD) != null) {
            this.updateFeatureLocationNewLevel(vl, ViewLevel.WORLD, f);
        }
        if (this.getTerrain(ViewLevel.SETTLEMENT) != null) {
            this.updateFeatureLocationNewLevel(vl, ViewLevel.SETTLEMENT, f);
        }
        if (this.getTerrain(ViewLevel.BATTLEMAT) != null) {
            this.updateFeatureLocationNewLevel(vl, ViewLevel.BATTLEMAT, f);
        }
        this.getFeatures().add(f);
        UndoAction ua = new UndoAction(UndoAction.Action.ADD, UndoAction.Thing.FEATURE, f, null, null, null, null, null);
        uag.addAction(ua);
    }

    public void addNewNote(ViewLevel vl, UndoActionGroup uag, Note n) {
        if (this.getTerrain(ViewLevel.CONTINENT) != null) {
            this.updateNoteLocationNewLevel(vl, ViewLevel.CONTINENT, n);
        }
        if (this.getTerrain(ViewLevel.KINGDOM) != null) {
            this.updateNoteLocationNewLevel(vl, ViewLevel.KINGDOM, n);
        }
        if (this.getTerrain(ViewLevel.PROVINCE) != null) {
            this.updateNoteLocationNewLevel(vl, ViewLevel.PROVINCE, n);
        }
        if (this.getTerrain(ViewLevel.WORLD) != null) {
            this.updateNoteLocationNewLevel(vl, ViewLevel.WORLD, n);
        }
        if (this.getTerrain(ViewLevel.SETTLEMENT) != null) {
            this.updateNoteLocationNewLevel(vl, ViewLevel.SETTLEMENT, n);
        }
        if (this.getTerrain(ViewLevel.BATTLEMAT) != null) {
            this.updateNoteLocationNewLevel(vl, ViewLevel.BATTLEMAT, n);
        }
        this.getNotes().add(n);
        UndoAction ua = new UndoAction(UndoAction.Action.ADD, UndoAction.Thing.NOTE, n, null, null, null, null, null);
        uag.addAction(ua);
    }

    public void addNewMapLabel(ViewLevel vl, MapLabel ml, Point2D pt, double scale) {
        ml.setLocationAndScale(vl, (Pair<Point2D, Double>)new Pair((Object)pt, (Object)scale));
        this.updateLabel(vl, ml, ViewLevel.CONTINENT, ViewLevel.KINGDOM, ViewLevel.PROVINCE);
        this.updateLabel(vl, ml, ViewLevel.WORLD, ViewLevel.SETTLEMENT, ViewLevel.BATTLEMAT);
        this.getMapLabels().add(ml);
    }

    private void updateLabel(ViewLevel vl, MapLabel ml, ViewLevel world, ViewLevel settlement, ViewLevel battlemat) {
        if (vl != world && this.getTerrain(world) != null) {
            this.updateMapLabelLocationNewLevel(vl, world, ml);
        }
        if (vl != settlement && this.getTerrain(settlement) != null) {
            this.updateMapLabelLocationNewLevel(vl, settlement, ml);
        }
        if (vl != battlemat && this.getTerrain(battlemat) != null) {
            this.updateMapLabelLocationNewLevel(vl, battlemat, ml);
        }
    }

    public boolean changeTerrain(UndoActionGroup uag, List<Terrain> terrainList, Point2D coords, ViewLevel vl, ViewLevel originalViewLevel, boolean autoUpdateOtherLevels, Color overrideTerrainBGCPValue, boolean terrainGMOnly, boolean terrainIcy, boolean terrainOverrideValues, int terrainElevation, byte[] terrainResources) {
        boolean wasChanged = false;
        if (coords.getX() < 0.0 || coords.getY() < 0.0 || coords.getX() > (double)(this.getTerrain(vl).length - 1) || coords.getY() > (double)(this.getTerrain(vl)[0].length - 1)) {
            return false;
        }
        Terrain changed = this.getTerrain(vl)[(int)coords.getX()][(int)coords.getY()];
        Terrain terrain = terrainList.get(0);
        if (terrainList.size() > 1) {
            terrain = terrainList.get((int)(Math.random() * (double)terrainList.size()));
        }
        String newType = terrain.getTypeName();
        Terrain newTerrain = new Terrain(newType, false);
        if (!newType.equals(changed.getTypeName())) {
            wasChanged = true;
        }
        if (overrideTerrainBGCPValue != null) {
            if (!overrideTerrainBGCPValue.equals((Object)changed.getBackgroundColor())) {
                newTerrain.setBackgroundColor(overrideTerrainBGCPValue);
                wasChanged = true;
            }
        } else if (changed.getBackgroundColor() != null) {
            newTerrain.setBackgroundColor(null);
            wasChanged = true;
        }
        if (terrainGMOnly != changed.isGmOnly()) {
            newTerrain.setGmOnly(terrainGMOnly);
            wasChanged = true;
        }
        if (terrainIcy != changed.isIcy()) {
            wasChanged = true;
        }
        newTerrain.setIcy(terrainIcy);
        if (!wasChanged) {
            return false;
        }
        if (terrainOverrideValues) {
            newTerrain.setElevation(terrainElevation);
            for (int i = 0; i < ResourceType.values().length; ++i) {
                newTerrain.getExtraInfo().getResources()[i] = terrainResources[i];
            }
        } else {
            newTerrain.setElevation(terrain.getType().getElevation());
            newTerrain.generateResources();
        }
        Terrain toChange = this.getTerrain(vl)[(int)coords.getX()][(int)coords.getY()];
        String toName = toChange.getTypeName();
        if (toName != null) {
            Terrain originalCopy = new Terrain(toName, false);
            originalCopy.makeEqual(toChange);
            toChange.makeEqual(newTerrain);
            UndoAction ua = new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.TERRAIN, null, newTerrain, originalCopy, (int)coords.getX(), (int)coords.getY(), (Object)vl);
            uag.addAction(ua);
            if (autoUpdateOtherLevels) {
                List<Pair<Integer, Integer>> childrenCoordsToChange;
                Point2D parentCoordsToChange;
                if ((originalViewLevel == ViewLevel.CONTINENT && vl == ViewLevel.CONTINENT || originalViewLevel == ViewLevel.KINGDOM && vl == ViewLevel.CONTINENT || originalViewLevel == ViewLevel.KINGDOM && vl == ViewLevel.KINGDOM) && (parentCoordsToChange = this.getParentTerrainCoords((int)coords.getX(), (int)coords.getY(), vl, true)) != null) {
                    ViewLevel parentViewLevel = ViewLevel.CONTINENT;
                    if (vl == ViewLevel.CONTINENT) {
                        parentViewLevel = ViewLevel.WORLD;
                    }
                    if (this.getTerrain(parentViewLevel) != null) {
                        this.changeTerrain(uag, terrainList, parentCoordsToChange, parentViewLevel, originalViewLevel, autoUpdateOtherLevels, overrideTerrainBGCPValue, terrainGMOnly, terrainIcy, terrainOverrideValues, terrainElevation, terrainResources);
                    }
                }
                if ((originalViewLevel == ViewLevel.WORLD && vl == ViewLevel.WORLD || originalViewLevel == ViewLevel.CONTINENT && vl == ViewLevel.CONTINENT || originalViewLevel == ViewLevel.WORLD && vl == ViewLevel.CONTINENT) && (childrenCoordsToChange = this.getChildrenTerrainCoords((int)coords.getX(), (int)coords.getY(), vl)) != null) {
                    ViewLevel childViewLevel = ViewLevel.CONTINENT;
                    if (vl == ViewLevel.CONTINENT) {
                        childViewLevel = ViewLevel.KINGDOM;
                    }
                    if (this.getTerrain(childViewLevel) != null) {
                        for (Pair<Integer, Integer> childCoordinate : childrenCoordsToChange) {
                            if ((Integer)childCoordinate.getKey() < 0 || (Integer)childCoordinate.getValue() < 0 || (Integer)childCoordinate.getKey() >= this.getTerrain(childViewLevel).length || (Integer)childCoordinate.getValue() >= this.getTerrain(childViewLevel)[0].length) continue;
                            this.changeTerrain(uag, terrainList, new Point2D((double)((Integer)childCoordinate.getKey()).intValue(), (double)((Integer)childCoordinate.getValue()).intValue()), childViewLevel, originalViewLevel, autoUpdateOtherLevels, overrideTerrainBGCPValue, terrainGMOnly, terrainIcy, terrainOverrideValues, terrainElevation, terrainResources);
                        }
                    }
                }
            }
        } else {
            toChange.makeEqual(newTerrain);
        }
        return true;
    }

    public List<Pair<Integer, Integer>> getChildrenTerrainCoords(int x, int y, ViewLevel currentLevel) {
        if (currentLevel == ViewLevel.KINGDOM) {
            return null;
        }
        int expansionRatio = this.getView().getKingdomFactor();
        if (currentLevel == ViewLevel.WORLD) {
            expansionRatio = this.getView().getContinentFactor();
        }
        int halfExpansion = expansionRatio / 2;
        ArrayList<Pair<Integer, Integer>> list = new ArrayList<Pair<Integer, Integer>>();
        if (this.getTileOrientation() == HexOrientation.COLUMNS) {
            int newX = x * expansionRatio;
            int newY = y * expansionRatio + (x % 2 == 0 ? 0 : halfExpansion);
            for (int i = newX - expansionRatio; i < newX + expansionRatio; ++i) {
                double valX = (newX - i) * (newX - i);
                for (int j = newY - expansionRatio; j < newY + expansionRatio; ++j) {
                    double valY = ((double)(newY - j) + 0.15) * ((double)(newY - j) + 0.15);
                    double val = Math.sqrt(valX + valY);
                    if (!(val <= (double)expansionRatio * 1.167 / 2.0) && (!(valX >= valY) || !(val <= (double)expansionRatio * 1.3 / 2.0))) continue;
                    list.add((Pair<Integer, Integer>)new Pair((Object)i, (Object)j));
                }
            }
        } else {
            int newY = y * expansionRatio;
            int newX = x * expansionRatio + (y % 2 == 0 ? 0 : halfExpansion);
            for (int i = newX - expansionRatio; i < newX + expansionRatio; ++i) {
                double valX = (newX - i) * (newX - i);
                for (int j = newY - expansionRatio; j < newY + expansionRatio; ++j) {
                    double valY = ((double)(newY - j) + 0.15) * ((double)(newY - j) + 0.15);
                    double val = Math.sqrt(valX + valY);
                    if (!(val <= (double)expansionRatio * 1.167 / 2.0) && (!(valX >= valY) || !(val <= (double)expansionRatio * 1.3 / 2.0))) continue;
                    list.add((Pair<Integer, Integer>)new Pair((Object)i, (Object)j));
                }
            }
        }
        return list;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public List<Information> getInformation() {
        return this.information;
    }

    public void setInformation(List<Information> information) {
        this.information = information;
    }

    public Set<Note> getNotes() {
        return this.notes;
    }

    public Note getNoteNearPoint(ViewLevel vl, double x, double y) {
        for (Note n : this.notes) {
            Point2D loc = n.getLocation(vl);
            if (loc == null || !(x > loc.getX() - 30.0) || !(x < loc.getX() + 30.0) || !(y > loc.getY() - 30.0) || !(y < loc.getY() + 30.0)) continue;
            return n;
        }
        return null;
    }

    public void setNotes(Set<Note> notes) {
        this.notes = notes;
    }

    public List<Feature> getFeatures() {
        return this.features;
    }

    public void setFeatures(List<Feature> features) {
        this.features = features;
    }

    public List<MapLabel> getMapLabels() {
        return this.getLabels();
    }

    public void setMapLabels(List<MapLabel> labels) {
        this.setLabels(labels);
    }

    public List<MapShape> getShapes() {
        return this.shapes;
    }

    public void setShapes(List<MapShape> shapes) {
        this.shapes = shapes;
    }

    public Color getMaskColor() {
        return this.maskColor;
    }

    public void setMaskColor(Color maskColor) {
        this.maskColor = maskColor;
    }

    public void updateFeatureLocationNewLevel(ViewLevel priorViewLevel, ViewLevel newViewLevel, Feature f) {
        Point2D loc = f.getLocation(priorViewLevel);
        if (loc != null) {
            f.setLocation(newViewLevel, this.calculateCoordinateAtNewLevel(priorViewLevel, newViewLevel, loc));
        }
    }

    public void updateMapLabelLocationNewLevel(ViewLevel priorViewLevel, ViewLevel newViewLevel, MapLabel ml) {
        ml.updateLocation(priorViewLevel, newViewLevel, this);
    }

    public void updateNoteLocationNewLevel(ViewLevel priorViewLevel, ViewLevel newViewLevel, Note n) {
        Point2D location = n.getLocation(priorViewLevel);
        if (location != null) {
            Point2D newLocation = this.calculateCoordinateAtNewLevel(priorViewLevel, newViewLevel, location);
            n.setLocation(newViewLevel, newLocation);
        }
    }

    public Point2D calculateCoordinateAtNewLevel(ViewLevel priorViewLevel, ViewLevel newViewLevel, Point2D loc) {
        return this.calculateCoordinateAtNewLevel(priorViewLevel, newViewLevel, loc.getX(), loc.getY());
    }

    public Point2D calculateCoordinateAtNewLevel(ViewLevel priorViewLevel, ViewLevel newViewLevel, double x, double y) {
        switch (newViewLevel) {
            case WORLD: {
                switch (priorViewLevel) {
                    case CONTINENT: {
                        return new Point2D(x / (double)this.getView().getContinentFactor() + this.getView().getWorldToContinentHOffset() * 300.0 / (double)this.getView().getContinentFactor(), y / (double)this.getView().getContinentFactor() + this.getView().getWorldToContinentVOffset() * 300.0 / (double)this.getView().getContinentFactor());
                    }
                    case KINGDOM: {
                        return new Point2D((x / (double)this.getView().getKingdomFactor() + this.getView().getContinentToKingdomHOffset() * 300.0 / (double)this.getView().getKingdomFactor()) / (double)this.getView().getContinentFactor() + this.getView().getWorldToContinentHOffset() * 300.0 / (double)this.getView().getContinentFactor(), (y / (double)this.getView().getKingdomFactor() + this.getView().getContinentToKingdomVOffset() * 300.0 / (double)this.getView().getKingdomFactor()) / (double)this.getView().getContinentFactor() + this.getView().getWorldToContinentVOffset() * 300.0 / (double)this.getView().getContinentFactor());
                    }
                    case PROVINCE: {
                        return new Point2D(((x / (double)this.getView().getKingdomFactor() + this.getView().getContinentToKingdomHOffset() * 300.0 / (double)this.getView().getKingdomFactor()) / (double)this.getView().getContinentFactor() + this.getView().getWorldToContinentHOffset() * 300.0 / (double)this.getView().getContinentFactor()) / (double)this.getView().getProvinceFactor() + this.getView().getKingdomToProvinceHOffset() * 300.0 / (double)this.getView().getProvinceFactor(), ((y / (double)this.getView().getKingdomFactor() + this.getView().getContinentToKingdomVOffset() * 300.0 / (double)this.getView().getKingdomFactor()) / (double)this.getView().getContinentFactor() + this.getView().getWorldToContinentVOffset() * 300.0 / (double)this.getView().getContinentFactor()) / (double)this.getView().getProvinceFactor() + this.getView().getKingdomToProvinceVOffset() * 300.0 / (double)this.getView().getProvinceFactor());
                    }
                    case WORLD: {
                        return new Point2D(x, y);
                    }
                }
            }
            case CONTINENT: {
                switch (priorViewLevel) {
                    case WORLD: {
                        return new Point2D(x * (double)this.getView().getContinentFactor() - this.getView().getWorldToContinentHOffset() * 300.0, y * (double)this.getView().getContinentFactor() - this.getView().getWorldToContinentVOffset() * 300.0);
                    }
                    case CONTINENT: {
                        return new Point2D(x, y);
                    }
                    case KINGDOM: {
                        return new Point2D(x / (double)this.getView().getKingdomFactor() + this.getView().getContinentToKingdomHOffset() * 300.0 / (double)this.getView().getKingdomFactor(), y / (double)this.getView().getKingdomFactor() + this.getView().getContinentToKingdomVOffset() * 300.0 / (double)this.getView().getKingdomFactor());
                    }
                    case PROVINCE: {
                        return new Point2D((x / (double)this.getView().getKingdomFactor() + this.getView().getContinentToKingdomHOffset() * 300.0 / (double)this.getView().getKingdomFactor()) / (double)this.getView().getProvinceFactor() + this.getView().getKingdomToProvinceHOffset() * 300.0 / (double)this.getView().getProvinceFactor(), (y / (double)this.getView().getKingdomFactor() + this.getView().getContinentToKingdomVOffset() * 300.0 / (double)this.getView().getKingdomFactor()) / (double)this.getView().getProvinceFactor() + this.getView().getKingdomToProvinceVOffset() * 300.0 / (double)this.getView().getProvinceFactor());
                    }
                }
            }
            case KINGDOM: {
                switch (priorViewLevel) {
                    case WORLD: {
                        return new Point2D((x * (double)this.getView().getContinentFactor() - this.getView().getWorldToContinentHOffset() * 300.0) * (double)this.getView().getKingdomFactor() - this.getView().getContinentToKingdomHOffset() * 300.0, (y * (double)this.getView().getContinentFactor() - this.getView().getWorldToContinentVOffset() * 300.0) * (double)this.getView().getKingdomFactor() - this.getView().getContinentToKingdomVOffset() * 300.0);
                    }
                    case CONTINENT: {
                        return new Point2D(x * (double)this.getView().getKingdomFactor() - this.getView().getContinentToKingdomHOffset() * 300.0, y * (double)this.getView().getKingdomFactor() - this.getView().getContinentToKingdomVOffset() * 300.0);
                    }
                    case KINGDOM: {
                        return new Point2D(x, y);
                    }
                    case PROVINCE: {
                        return new Point2D(x / (double)this.getView().getProvinceFactor() + this.getView().getKingdomToProvinceHOffset() * 300.0 / (double)this.getView().getProvinceFactor(), y / (double)this.getView().getProvinceFactor() + this.getView().getKingdomToProvinceVOffset() * 300.0 / (double)this.getView().getProvinceFactor());
                    }
                }
            }
            case PROVINCE: {
                switch (priorViewLevel) {
                    case WORLD: {
                        return new Point2D(((x * (double)this.getView().getContinentFactor() - this.getView().getWorldToContinentHOffset() * 300.0) * (double)this.getView().getKingdomFactor() - this.getView().getContinentToKingdomHOffset() * 300.0) * (double)this.getView().getProvinceFactor() - this.getView().getKingdomToProvinceHOffset() * 300.0, ((y * (double)this.getView().getContinentFactor() - this.getView().getWorldToContinentVOffset() * 300.0) * (double)this.getView().getKingdomFactor() - this.getView().getContinentToKingdomVOffset() * 300.0) * (double)this.getView().getProvinceFactor() - this.getView().getKingdomToProvinceVOffset() * 300.0);
                    }
                    case CONTINENT: {
                        return new Point2D((x * (double)this.getView().getKingdomFactor() - this.getView().getContinentToKingdomHOffset() * 300.0) * (double)this.getView().getProvinceFactor() - this.getView().getKingdomToProvinceHOffset() * 300.0, (y * (double)this.getView().getKingdomFactor() - this.getView().getContinentToKingdomVOffset() * 300.0) * (double)this.getView().getProvinceFactor() - this.getView().getKingdomToProvinceVOffset() * 300.0);
                    }
                    case KINGDOM: {
                        return new Point2D(x * (double)this.getView().getProvinceFactor() - this.getView().getKingdomToProvinceHOffset() * 300.0, y * (double)this.getView().getProvinceFactor() - this.getView().getKingdomToProvinceVOffset() * 300.0);
                    }
                    case PROVINCE: {
                        return new Point2D(x, y);
                    }
                }
                break;
            }
            case SETTLEMENT: 
            case BATTLEMAT: {
                return new Point2D(x, y);
            }
        }
        return null;
    }

    public double getTileWidth() {
        return this.hexWidth;
    }

    public void setTileWidthHeight(double hexWidth, double hexHeight, boolean preserveAspect) {
        if (hexWidth < 0.0 && preserveAspect) {
            hexWidth = this.hexWidth * hexHeight / this.hexHeight;
        } else if (hexHeight < 0.0 && preserveAspect) {
            hexHeight = this.hexHeight * hexWidth / this.hexWidth;
        }
        if (hexHeight > 0.0) {
            this.hexHeight = hexHeight;
        }
        if (hexWidth > 0.0) {
            this.hexWidth = hexWidth;
        }
    }

    public double getTileHeight() {
        return this.hexHeight;
    }

    public HexOrientation getTileOrientation() {
        return this.hexOrientation;
    }

    public void setHexOrientation(HexOrientation hexOrientation) {
        this.hexOrientation = hexOrientation;
    }

    public MapProjection getMapProjection() {
        return this.mapProjection;
    }

    public void setMapProjection(MapProjection mapProjection) {
        this.mapProjection = mapProjection;
    }

    public Map<String, Integer> makeTerrainMap() {
        Integer count = 0;
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        count = this.makeTerrainMapOneLevel(count, map, ViewLevel.COSMIC);
        count = this.makeTerrainMapOneLevel(count, map, ViewLevel.WORLD);
        count = this.makeTerrainMapOneLevel(count, map, ViewLevel.CONTINENT);
        count = this.makeTerrainMapOneLevel(count, map, ViewLevel.KINGDOM);
        count = this.makeTerrainMapOneLevel(count, map, ViewLevel.PROVINCE);
        count = this.makeTerrainMapOneLevel(count, map, ViewLevel.SETTLEMENT);
        this.makeTerrainMapOneLevel(count, map, ViewLevel.BATTLEMAT);
        return map;
    }

    private Integer makeTerrainMapOneLevel(Integer count, Map<String, Integer> map, ViewLevel vl) {
        if (this.getTerrain(vl) != null) {
            Terrain[][] t;
            Terrain[][] terrainArray = t = this.getTerrain(vl);
            int n = terrainArray.length;
            for (int i = 0; i < n; ++i) {
                Terrain[] terrains;
                for (Terrain terrain : terrains = terrainArray[i]) {
                    String name;
                    if (terrain == null || map.containsKey(name = MapDataIO.toEscapedXML(terrain.getTypeName()))) continue;
                    map.put(name, count);
                    Integer n2 = count;
                    count = count + 1;
                }
            }
        }
        return count;
    }

    boolean isTextureUsed(String key) {
        for (MapShape ms : this.getShapes()) {
            if (ms.getFillTexture() != null && key.equals(ms.getFillTexture().getType())) {
                return true;
            }
            if (ms.getStrokeTexture() == null || !key.equals(ms.getStrokeTexture().getType())) continue;
            return true;
        }
        return false;
    }

    boolean isFeatureUsed(String key) {
        for (Feature f : this.getFeatures()) {
            if (!key.equals(f.getType().getType())) continue;
            return true;
        }
        return false;
    }

    boolean isTerrainUsed(String key) {
        if (this.isTerrainUsedViewLevel(ViewLevel.WORLD, key)) {
            return true;
        }
        if (this.isTerrainUsedViewLevel(ViewLevel.CONTINENT, key)) {
            return true;
        }
        if (this.isTerrainUsedViewLevel(ViewLevel.KINGDOM, key)) {
            return true;
        }
        if (this.isTerrainUsedViewLevel(ViewLevel.SETTLEMENT, key)) {
            return true;
        }
        return this.isTerrainUsedViewLevel(ViewLevel.BATTLEMAT, key);
    }

    private boolean isTerrainUsedViewLevel(ViewLevel vl, String key) {
        if (this.getTerrain(vl) != null) {
            for (int i = 0; i < this.getTerrain(vl).length; ++i) {
                for (int j = 0; j < this.getTerrain(vl)[i].length; ++j) {
                    if (this.getTerrain(vl)[i][j].getTypeName() == null || !this.getTerrain(vl)[i][j].getTypeName().equals(key)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public Pair<Double, Double> getModelPtFromTerrain(int i, int j) {
        if (this.getTileOrientation() == HexOrientation.COLUMNS) {
            return new Pair((Object)((double)i * 300.0 * 3.0 / 4.0 + 150.0), (Object)((double)j * 300.0 + (double)(i % 2 == 1 ? 300 : 150)));
        }
        if (this.getTileOrientation() == HexOrientation.ROWS) {
            return new Pair((Object)((double)i * 300.0 + (double)(j % 2 == 1 ? 300 : 150)), (Object)((double)j * 300.0 * 3.0 / 4.0 + 150.0));
        }
        return new Pair((Object)((double)i * 300.0 + 150.0), (Object)((double)j * 300.0 + 150.0));
    }

    public static Pair<Double, Double> getModelPtFromTerrain(int i, int j, HexOrientation ho) {
        if (ho == HexOrientation.COLUMNS) {
            return new Pair((Object)((double)i * 300.0 * 3.0 / 4.0 + 150.0), (Object)((double)j * 300.0 + (double)(i % 2 == 1 ? 300 : 150)));
        }
        if (ho == HexOrientation.ROWS) {
            return new Pair((Object)((double)i * 300.0 + (double)(j % 2 == 1 ? 300 : 150)), (Object)((double)j * 300.0 * 3.0 / 4.0 + 150.0));
        }
        return new Pair((Object)((double)i * 300.0 + 150.0), (Object)((double)j * 300.0 + 150.0));
    }

    public Pair<Integer, Integer> getTerrainFromModelPt(double x, double y) {
        if (this.getTileOrientation() == HexOrientation.SQUARE) {
            return new Pair((Object)((int)(x / 300.0)), (Object)((int)(y / 300.0)));
        }
        if (this.getTileOrientation() == HexOrientation.COLUMNS) {
            int i = (int)(x / 300.0 * 4.0 / 3.0);
            int j = (int)((i % 2 == 0 ? y : y - 150.0) / 300.0);
            return new Pair((Object)i, (Object)j);
        }
        int j = (int)(y / 300.0 * 4.0 / 3.0);
        int i = (int)((j % 2 == 0 ? x : x - 150.0) / 300.0);
        return new Pair((Object)i, (Object)j);
    }

    public ViewLevelData getView() {
        return this.view;
    }

    public TraceData getTrace() {
        return this.trace;
    }

    public GridData getGrid() {
        return this.grid;
    }

    public ShowData getShow() {
        return this.show;
    }

    public NumberingData getNumbering() {
        return this.numbering;
    }

    public List<MapLabel> getLabels() {
        return this.labels;
    }

    public void setLabels(List<MapLabel> labels) {
        this.labels = labels;
    }

    public static enum Type {
        WORLD,
        BATTLEMAT,
        CITY;

    }
}

