/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.map;

import com.inkwellideas.ographer.data.ViewLevel;
import com.inkwellideas.ographer.information.Information;
import com.inkwellideas.ographer.map.MapData;
import com.inkwellideas.ographer.map.ResourceType;
import com.inkwellideas.ographer.map.Terrain;
import com.inkwellideas.ographer.model.Feature;
import com.inkwellideas.ographer.model.Note;
import com.inkwellideas.ographer.model.TextureType;
import com.inkwellideas.ographer.task.SaveMapTask;
import com.vladsch.flexmark.html2md.converter.FlexmarkHtmlConverter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;

public class MapDataIO {
    public static final String ESCAPE_CHARS = "<>&\"'";
    public static final List<String> ESCAPE_STRINGS = List.of(new String[]{"&lt;", "&gt;", "&amp;", "&quot;", "&apos;"});

    public static void saveConfigFile(File file, MapData md) throws Exception {
        FileOutputStream fos = new FileOutputStream(file);
        BufferedWriter w = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_16));
        w.write("<map type=\"WORLD-CONFIG\">");
        MapDataIO.writeConfigString(md, w);
        w.write("</map>");
        w.close();
    }

    public static void writeConfigString(MapData md, Writer w) throws IOException {
        w.write("<configuration>\n");
        w.write("  <terrain-config>\n");
        for (String key : Terrain.terrainTypes.keySet()) {
            if (Terrain.terrainTypes.get((Object)key).isDefaultAndUnchanged || md != null && !md.isTerrainUsed(key)) continue;
            Terrain.terrainTypes.get(key).writeXMLString(w);
            w.flush();
        }
        w.write("  </terrain-config>\n");
        w.write("  <feature-config>\n");
        for (String key : Feature.featureTypes.keySet()) {
            if (Feature.featureTypes.get((Object)key).isDefaultAndUnchanged || md != null && !md.isFeatureUsed(key)) continue;
            Feature.featureTypes.get(key).writeXMLString(w);
            w.flush();
        }
        w.write("  </feature-config>\n");
        w.write("  <texture-config>\n");
        for (String key : TextureType.ALL_TEXTURES.keySet()) {
            if (TextureType.ALL_TEXTURES.get((Object)key).isDefaultAndUnchanged || md != null && !md.isTextureUsed(key)) continue;
            TextureType.ALL_TEXTURES.get(key).writeXMLString(w);
            w.flush();
        }
        w.write("  </texture-config>\n");
        w.write("  <text-config>\n");
        if (md != null) {
            for (String key : md.getLabelStyles().keySet()) {
                String s = md.getLabelStyles().get(key).getXMLString() + "\n";
                w.write(s);
                w.flush();
            }
        }
        w.write("  </text-config>\n");
        w.write("  <shape-config>\n");
        if (md != null && md.getShapeStyles() != null) {
            for (String key : md.getShapeStyles().keySet()) {
                w.write(md.getShapeStyles().get(key).getXMLString() + "\n");
                w.flush();
            }
        }
        w.write("  </shape-config>\n");
        w.write("  </configuration>\n");
        w.flush();
    }

    public static String toEscapedXML(String content) {
        return MapDataIO.toEscapedXML(content, true);
    }

    public static String toEscapedXML(String content, boolean escapeHTML) {
        String result = content;
        if (content != null && content.length() > 0) {
            boolean modified = false;
            StringBuilder stringBuilder = new StringBuilder(content.length());
            int count = content.length();
            for (int i = 0; i < count; ++i) {
                String character = content.substring(i, i + 1);
                int pos = -1;
                if (escapeHTML) {
                    pos = ESCAPE_CHARS.indexOf(character);
                }
                if (pos > -1) {
                    stringBuilder.append(ESCAPE_STRINGS.get(pos));
                    modified = true;
                    continue;
                }
                String UNICODE_HIGH = "\u007f";
                String UNICODE_LOW = " ";
                if (character.compareTo(UNICODE_LOW) > -1 && character.compareTo(UNICODE_HIGH) < 1) {
                    stringBuilder.append(character);
                    continue;
                }
                stringBuilder.append("&#").append((int)character.charAt(0)).append(";");
                modified = true;
            }
            if (modified) {
                result = stringBuilder.toString();
            }
        }
        return result;
    }

    public static void getTilesXMLString(MapData mapData, Writer w, Map<String, Integer> terrainMap, SaveMapTask task) throws IOException {
        MapDataIO.getTilesXMLStringViewLevel(mapData, ViewLevel.COSMIC, w, terrainMap, task);
        MapDataIO.getTilesXMLStringViewLevel(mapData, ViewLevel.WORLD, w, terrainMap, task);
        MapDataIO.getTilesXMLStringViewLevel(mapData, ViewLevel.CONTINENT, w, terrainMap, task);
        MapDataIO.getTilesXMLStringViewLevel(mapData, ViewLevel.KINGDOM, w, terrainMap, task);
        MapDataIO.getTilesXMLStringViewLevel(mapData, ViewLevel.PROVINCE, w, terrainMap, task);
        MapDataIO.getTilesXMLStringViewLevel(mapData, ViewLevel.SETTLEMENT, w, terrainMap, task);
        MapDataIO.getTilesXMLStringViewLevel(mapData, ViewLevel.BATTLEMAT, w, terrainMap, task);
    }

    public static void getTilesXMLStringViewLevel(MapData mapData, ViewLevel vl, Writer w, Map<String, Integer> terrainMap, SaveMapTask task) throws IOException {
        Terrain[][] t = mapData.getTerrain(vl);
        if (t != null) {
            long totalTiles = (long)t.length * (long)t[0].length;
            long count = 0L;
            w.write("<tiles viewLevel=\"" + String.valueOf((Object)vl) + "\" tilesWide=\"" + t.length + "\" tilesHigh=\"" + t[0].length + "\">\n");
            for (Terrain[] terrains : t) {
                w.write("<tilerow>\n");
                for (Terrain terrain : terrains) {
                    if (count % 1000L == 0L) {
                        task.updateMessagePublic("Saving " + String.valueOf((Object)vl) + " Tiles: " + count + "/" + totalTiles);
                    }
                    ++count;
                    if (terrain == null || !terrain.isSavable()) {
                        w.write("null\n");
                        continue;
                    }
                    String escapedName = MapDataIO.toEscapedXML(terrain.getTypeName());
                    w.write(String.valueOf(terrainMap.get(escapedName)) + "\t" + terrain.getElevation() + "\t" + (terrain.isIcy() ? "1" : "0") + "\t" + (terrain.isGmOnly() ? "1" : "0"));
                    if (terrain.getExtraInfo().areAllResourcesButFirstZero()) {
                        w.write("\t" + terrain.getExtraInfo().getResources()[0] + "\tZ");
                    } else {
                        for (int k = 0; k < ResourceType.values().length; ++k) {
                            w.write("\t" + terrain.getExtraInfo().getResources()[k]);
                        }
                    }
                    if (terrain.getBackgroundColor() != null) {
                        w.write("\t" + terrain.getBackgroundColor().getRed() + "," + terrain.getBackgroundColor().getGreen() + "," + terrain.getBackgroundColor().getBlue() + "," + terrain.getBackgroundColor().getOpacity());
                    }
                    w.write("\n");
                }
                w.write("</tilerow>\n");
                w.flush();
            }
            w.write("</tiles>\n");
        }
        w.flush();
    }

    public static void exportNotes(MapData mapData, Map<String, Note> notesMap, ViewLevel viewLevel, File file, boolean includeWorldInfo, boolean includeFeatureImages, boolean includeNotes, String format) throws IOException {
        StringBuilder sb = new StringBuilder("<h1>Map Notes Export</h1>\n");
        for (Information info : mapData.getInformation()) {
            if (!includeWorldInfo) continue;
            MapDataIO.exportInfoHelper(sb, info, 1);
        }
        if (includeNotes) {
            sb.append("<h1>Other Notes</h1>\n");
            for (Note n : notesMap.values()) {
                String details = n.getDetails();
                int begin = details.indexOf("<body");
                int end = details.indexOf("</body");
                if (begin >= 0 && end > begin && (begin = (details = details.substring(begin, end)).indexOf(">")) > 0) {
                    details = details.substring(begin + 1);
                }
                sb.append("<h2>").append(n.getTitle()).append("</h2>\n");
                if (includeFeatureImages && (n.getParent() != null && n.getParent().getLocation(viewLevel) != null || n.getLocation(viewLevel) != null)) {
                    sb.append("<img src=\"").append(n.getKeyInt()).append(".png\" alt=\"Small map of this feature's area.\">\n");
                }
                sb.append(details).append("\n");
                sb.append(n.getTableDataHTMLString());
            }
        }
        Object out = format.contains("HTML") ? "<html><head><title>Map Notes Export</title></head>\n<body>\n" + sb.toString() + "\n</body></html>" : (format.contains("MarkDown") ? FlexmarkHtmlConverter.builder().build().convert(sb.toString()) : sb.toString());
        BufferedWriter w = new BufferedWriter(new FileWriter(file));
        w.write((String)out);
        w.close();
    }

    private static void exportInfoHelper(StringBuilder sb, Information info, int indent) {
        String details = info.getText();
        int begin = details.indexOf("<body");
        int end = details.indexOf("</body");
        if (begin >= 0 && end > begin && (begin = (details = details.substring(begin, end)).indexOf(">")) > 0) {
            details = details.substring(begin + 1);
        }
        if (details.trim().length() == 0) {
            sb.append("<h" + (indent + 1) + ">").append(info.getName() + "</h" + (indent + 1) + ">\n");
        }
        sb.append(details).append("\n");
        if (info.children != null && info.children.size() > 0) {
            for (Information child : info.children) {
                MapDataIO.exportInfoHelper(sb, child, Math.max(indent + 1, 3));
            }
        }
    }
}

