/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.map;

import com.inkwellideas.ographer.data.HexOrientation;
import com.inkwellideas.ographer.data.MapLayer;
import com.inkwellideas.ographer.data.ViewLevel;
import com.inkwellideas.ographer.generator.city.CityDataGenerator;
import com.inkwellideas.ographer.generator.world.WorldAndNameData;
import com.inkwellideas.ographer.information.Culture;
import com.inkwellideas.ographer.information.Information;
import com.inkwellideas.ographer.information.Nation;
import com.inkwellideas.ographer.map.MapData;
import com.inkwellideas.ographer.map.MapLabel;
import com.inkwellideas.ographer.map.MapShape;
import com.inkwellideas.ographer.map.ResourceType;
import com.inkwellideas.ographer.map.Terrain;
import com.inkwellideas.ographer.model.Feature;
import com.inkwellideas.ographer.model.Note;
import com.inkwellideas.ographer.model.TerrainType;
import com.inkwellideas.ographer.model.TextureType;
import com.inkwellideas.ographer.task.GenerateEmpiresTask;
import com.inkwellideas.ographer.ui.MapUI;
import com.inkwellideas.ographer.ui.Worldographer;
import com.inkwellideas.ographer.undo.Point;
import com.inkwellideas.ographer.undo.UndoAction;
import com.inkwellideas.ographer.undo.UndoActionGroup;
import com.inkwellideas.ographer.undo.UndoRedoHandler;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import javafx.geometry.Point2D;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import javafx.scene.paint.ImagePattern;
import javafx.scene.paint.Paint;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.Polygon;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.text.TextAlignment;
import javafx.util.Pair;

public class MapLogic {
    static final String[] ALTERNATES = new String[]{"A", "B", "C", "D"};
    public static boolean canceled;

    public static void addRivers(UndoActionGroup uag, Terrain[][] terrain, ViewLevel viewLevel, HexOrientation ho, GenerateEmpiresTask empiresTask, String riverType, List<Feature> features, List<MapShape> mapShapes, int numbertoadd, MapLayer ml) {
        canceled = false;
        int minLength = Math.min(terrain.length, terrain[0].length);
        minLength /= 8;
        int count = 0;
        int fails = 0;
        ArrayList<Terrain> terrainused = new ArrayList<Terrain>();
        ArrayList<Double> points = new ArrayList<Double>();
        ArrayList<Point2D> linepoints = new ArrayList<Point2D>();
        Path path = null;
        while (count < numbertoadd && fails < numbertoadd * 100 && !canceled) {
            double priory;
            double priorx;
            if (empiresTask != null) {
                empiresTask.updateMessage("Adding rivers: " + count + "/" + numbertoadd + " fails:" + fails + " min length:" + minLength);
            }
            ArrayList<Terrain> tempterrainused = new ArrayList<Terrain>();
            int x = (int)(Math.random() * (double)terrain.length);
            int y = (int)(Math.random() * (double)terrain[x].length);
            tempterrainused.add(terrain[x][y]);
            ArrayList<Point2D> othersidepoints = new ArrayList<Point2D>();
            if (terrain[x][y].getTypeName().toLowerCase().contains("water") || terrain[x][y].getTypeName().toLowerCase().contains("desert") || terrainused.contains(terrain[x][y])) continue;
            if (ho == HexOrientation.COLUMNS) {
                if (riverType.equals("Features")) {
                    priorx = x;
                    priory = y;
                } else {
                    priorx = (double)(x * 300 * 3 / 4 + 75) + Math.random() * 150.0;
                    priory = (double)(y * 300 + (x % 2 == 0 ? 0 : 150) + 75) + Math.random() * 150.0;
                }
            } else if (riverType.equals("Features")) {
                priorx = x;
                priory = y;
            } else {
                priorx = (double)(x * 300 + (y % 2 == 0 ? 0 : 150) + 75) + Math.random() * 150.0;
                priory = (double)(y * 300 * 3 / 4 + 75) + Math.random() * 150.0;
            }
            boolean firstpoint = true;
            boolean done = false;
            boolean success = false;
            int longriver = 0;
            double crops = terrain[x][y].getExtraInfo().getOneResource("Crops");
            terrain[x][y].setOneResource("Crops", (byte)Math.min(90.0, crops * 1.1));
            double animals = terrain[x][y].getExtraInfo().getOneResource("Animals");
            terrain[x][y].setOneResource("Animals", (byte)Math.min(90.0, animals * 1.1));
            while (!done) {
                double nexty;
                double nextx;
                Pair<Pair<Integer, Integer>, Terrain> minAdjTerrain = MapLogic.getAnyLowerAdjTerrain(terrain, ho, x, y, tempterrainused);
                if (minAdjTerrain == null) {
                    ++fails;
                    break;
                }
                if (terrainused.contains(minAdjTerrain.getValue()) || tempterrainused.contains(minAdjTerrain.getValue())) {
                    ++fails;
                    break;
                }
                tempterrainused.add((Terrain)minAdjTerrain.getValue());
                x = (Integer)((Pair)minAdjTerrain.getKey()).getKey();
                y = (Integer)((Pair)minAdjTerrain.getKey()).getValue();
                if (ho == HexOrientation.COLUMNS) {
                    if (riverType.equals("Features")) {
                        nextx = x;
                        nexty = y;
                    } else {
                        nextx = x * 300 * 3 / 4 + 75;
                        nexty = y * 300 + (x % 2 == 0 ? 0 : 150) + 75;
                    }
                } else if (riverType.equals("Features")) {
                    nextx = x;
                    nexty = y;
                } else {
                    nextx = (double)(x * 300 + (y % 2 == 0 ? 0 : 150) + 75) + Math.random() * 150.0;
                    nexty = (double)(y * 300 * 3 / 4 + 75) + Math.random() * 150.0;
                }
                double rise = 0.0;
                double slope = 0.0;
                linepoints.add(new Point2D(priorx, priory));
                if (firstpoint) {
                    points.add(priorx);
                    points.add(priory);
                    firstpoint = false;
                    path = new Path();
                    path.getElements().add((Object)new MoveTo(priorx, priory));
                } else {
                    rise = -(nexty - priory);
                    double run = nextx - priorx;
                    slope = rise / run;
                    MapLogic.addSidePoints(points, othersidepoints, priorx, priory, rise, slope);
                    double maxadjx = (nextx - priorx) / 20.0;
                    double maxadjy = (nexty - priory) / 20.0;
                    for (int i = 1; i < 10; ++i) {
                        double adjx = Math.random() * maxadjx * 2.0 - maxadjx;
                        double adjy = Math.random() * maxadjy * 2.0 - maxadjy;
                        double newx = priorx + (nextx - priorx) / 10.0 * (double)i;
                        double newy = priory + (nexty - priory) / 10.0 * (double)i;
                        MapLogic.addSidePoints(points, othersidepoints, newx + adjx, newy + adjy, rise, slope);
                    }
                    path.getElements().add((Object)new LineTo(priorx, priory));
                }
                priorx = nextx;
                priory = nexty;
                boolean intersectsitself = false;
                for (int m = 0; m < points.size() - 4; m += 2) {
                    int n;
                    for (n = 0; n < m - 4 && MapLogic.intersection(((Double)points.get(m)).floatValue(), ((Double)points.get(m + 1)).floatValue(), ((Double)points.get(m + 2)).floatValue(), ((Double)points.get(m + 3)).floatValue(), ((Double)points.get(n)).floatValue(), ((Double)points.get(n + 1)).floatValue(), ((Double)points.get(n + 2)).floatValue(), ((Double)points.get(n + 3)).floatValue()) == null; n += 2) {
                    }
                    for (n = m + 4; n < points.size() - 4 && MapLogic.intersection(((Double)points.get(m)).floatValue(), ((Double)points.get(m + 1)).floatValue(), ((Double)points.get(m + 2)).floatValue(), ((Double)points.get(m + 3)).floatValue(), ((Double)points.get(n)).floatValue(), ((Double)points.get(n + 1)).floatValue(), ((Double)points.get(n + 2)).floatValue(), ((Double)points.get(n + 3)).floatValue()) == null; n += 2) {
                    }
                }
                if (intersectsitself) {
                    ++fails;
                    break;
                }
                if (terrain[x][y].getTypeName().toLowerCase().contains("water")) {
                    if (longriver < minLength && fails < numbertoadd / 2 || longriver < minLength * 3 / 4 && fails < numbertoadd * 3 / 4 || longriver < minLength / 2) {
                        ++fails;
                        break;
                    }
                    MapLogic.addSidePoints(points, othersidepoints, priorx, priory, rise, slope);
                    success = true;
                    done = true;
                }
                ++longriver;
            }
            if (success) {
                terrainused.addAll(tempterrainused);
                if (riverType.equals("Features")) {
                    for (int i = 0; i < linepoints.size(); ++i) {
                        Point2D nextPt;
                        Point2D pt = (Point2D)linepoints.get(i);
                        if (i == linepoints.size() - 1) {
                            Point2D priorPt = (Point2D)linepoints.get(i - 1);
                            int entrance = MapLogic.getRiverHexEntranceOrExit(pt, priorPt);
                            Map<Integer, Terrain> adjTerrain = MapLogic.getAdjTerrainByDirections(terrain, ho, (int)pt.getX(), (int)pt.getY());
                            ArrayList<Integer> adjWater = new ArrayList<Integer>();
                            int modifier = (int)(Math.random() * 6.0);
                            for (int j = 0 + modifier; j < 6 + modifier; ++j) {
                                if (adjTerrain.get(j % 6) == null || !adjTerrain.get(j % 6).getTypeName().toLowerCase().contains("water")) continue;
                                adjWater.add(j % 6);
                            }
                            int mouthFace = (Integer)adjWater.get(0);
                            int mouthRotate = (mouthFace * 60 + 240) % 360;
                            MapLogic.addRiverHexSectionFeatureBasedOnEntranceExit(uag, features, viewLevel, ml, pt, priorPt, entrance, mouthFace, true);
                            double terrainX = pt.getX() * 300.0 * 3.0 / 4.0 + 150.0;
                            double terrainY = pt.getY() * 300.0 + (double)(pt.getX() % 2.0 == 0.0 ? 0 : 150) + 150.0;
                            Feature mouth = new Feature("Classic Water/Classic Shore Mouth One Side A", false, false, false, false, null, mouthRotate, null, 101.0, 101.0, false, false, null, "", true, true, true, true, ml);
                            mouth.setLocation(viewLevel, terrainX, terrainY);
                            features.add(mouth);
                            uag.addAction(new UndoAction(UndoAction.Action.ADD, UndoAction.Thing.FEATURE, mouth, null, null, null, null, null));
                            continue;
                        }
                        if (i == 0) {
                            nextPt = (Point2D)linepoints.get(i + 1);
                            int rotate = 0;
                            double oTypeNum = Math.random();
                            String featureType = "Classic Water/Classic River Origin A";
                            if (oTypeNum < 0.25) {
                                featureType = "Classic Water/Classic River Origin B";
                            } else if (oTypeNum < 0.5) {
                                featureType = "Classic Water/Classic River Origin C";
                            } else if (oTypeNum < 0.75) {
                                featureType = "Classic Water/Classic River Origin D";
                            }
                            rotate = pt.getX() == nextPt.getX() ? (pt.getY() < nextPt.getY() ? 240 : 60) : (pt.getX() % 2.0 == 0.0 ? (pt.getX() == nextPt.getX() + 1.0 ? (pt.getY() == nextPt.getY() ? 300 : 0) : (pt.getY() == nextPt.getY() ? 180 : 120)) : (pt.getX() == nextPt.getX() + 1.0 ? (pt.getY() == nextPt.getY() ? 0 : 300) : (pt.getY() == nextPt.getY() ? 120 : 180)));
                            Feature origin = new Feature(featureType, false, false, false, false, null, rotate, null, 101.0, 101.0, false, false, null, "", true, true, true, true, ml);
                            double terrainX = pt.getX() * 300.0 * 3.0 / 4.0 + 150.0;
                            double terrainY = pt.getY() * 300.0 + (double)(pt.getX() % 2.0 == 0.0 ? 0 : 150) + 150.0;
                            origin.setLocation(viewLevel, terrainX, terrainY);
                            features.add(origin);
                            uag.addAction(new UndoAction(UndoAction.Action.ADD, UndoAction.Thing.FEATURE, origin, null, null, null, null, null));
                            continue;
                        }
                        nextPt = (Point2D)linepoints.get(i + 1);
                        Point2D priorPt = (Point2D)linepoints.get(i - 1);
                        int entrance = MapLogic.getRiverHexEntranceOrExit(pt, priorPt);
                        int exit = MapLogic.getRiverHexEntranceOrExit(pt, nextPt);
                        MapLogic.addRiverHexSectionFeatureBasedOnEntranceExit(uag, features, viewLevel, ml, pt, priorPt, entrance, exit, false);
                    }
                } else {
                    Polygon p = new Polygon();
                    linepoints.add(new Point2D(priorx, priory));
                    List<Point2D> fractalizedpts = MapLogic.fractalize(linepoints, 80.0, 5.0);
                    for (Point2D pt2d : fractalizedpts) {
                        p.getPoints().add((Object)pt2d.getX());
                        p.getPoints().add((Object)pt2d.getY());
                    }
                    int oneTenthPoints = fractalizedpts.size() / 10;
                    double strokeWidth = 0.03;
                    for (int i = 1; i < fractalizedpts.size(); ++i) {
                        if (i % oneTenthPoints == 1) {
                            path = new Path();
                            path.setStroke((Paint)new Color(0.55, 0.7, 0.85, 1.0));
                            MapShape ms2 = new MapShape(ViewLevel.WORLD, viewLevel, (Shape)path, MapShape.CreationType.BASIC, MapShape.StrokeType.SIMPLE, false, "river", 0.0, 0.0, 0.0, 0.0, true, true, true, true, ml);
                            if (riverType.equals("Shapes - Textured")) {
                                ImagePattern stroketexture = new ImagePattern(TextureType.ALL_TEXTURES.get("Sea").getIcon(), 0.0, 0.0, 50.0, 25.0, false);
                                ms2.setStrokeTexture(TextureType.ALL_TEXTURES.get("Sea"));
                                path.setStroke((Paint)stroketexture);
                            }
                            path.setStrokeWidth(strokeWidth);
                            strokeWidth += 0.01;
                            path.setStrokeLineCap(StrokeLineCap.ROUND);
                            path.setStrokeLineJoin(StrokeLineJoin.ROUND);
                            mapShapes.add(ms2);
                            uag.addAction(new UndoAction(UndoAction.Action.ADD, UndoAction.Thing.MAP_SHAPE, ms2, null, null, null, null, null));
                            path.getElements().add((Object)new MoveTo(fractalizedpts.get(i - 1).getX(), fractalizedpts.get(i - 1).getY()));
                        }
                        path.getElements().add((Object)new LineTo(fractalizedpts.get(i).getX(), fractalizedpts.get(i).getY()));
                    }
                }
                ++count;
            } else {
                ++fails;
            }
            linepoints.clear();
            points.clear();
            othersidepoints.clear();
            path = new Path();
        }
    }

    private static void addRiverHexSectionFeatureBasedOnEntranceExit(UndoActionGroup uag, List<Feature> features, ViewLevel viewLevel, MapLayer ml, Point2D pt, Point2D priorPt, int entrance, int exit, boolean isMouth) {
        int rotate = 0;
        String riverFeature = "";
        if (exit < entrance) {
            int temp = exit;
            exit = entrance;
            entrance = temp;
        }
        if (entrance == 0) {
            if (exit == 1) {
                riverFeature = "0-1";
            } else if (exit == 2) {
                riverFeature = "0-2";
            } else if (exit == 3) {
                riverFeature = "0-3";
            } else if (exit == 4) {
                riverFeature = "0-2";
                rotate = 240;
            } else {
                riverFeature = "0-1";
                rotate = 300;
            }
        } else if (entrance == 1) {
            if (exit == 2) {
                riverFeature = "0-1";
                rotate = 60;
            } else if (exit == 3) {
                riverFeature = "0-2";
                rotate = 60;
            } else if (exit == 4) {
                riverFeature = "0-3";
                rotate = 60;
            } else {
                riverFeature = "0-2";
                rotate = 300;
            }
        } else if (entrance == 2) {
            if (exit == 3) {
                riverFeature = "0-1";
                rotate = 120;
            } else if (exit == 4) {
                riverFeature = "0-2";
                rotate = 120;
            } else {
                riverFeature = "0-3";
                rotate = 120;
            }
        } else if (entrance == 3) {
            if (exit == 4) {
                riverFeature = "0-1";
                rotate = 180;
            } else {
                riverFeature = "0-2";
                rotate = 180;
            }
        } else if (entrance == 4) {
            riverFeature = "0-1";
            rotate = 240;
        }
        String featureType = "Classic Water/Classic River " + riverFeature + " " + ALTERNATES[(int)(Math.random() * 4.0)];
        if (isMouth) {
            featureType = "Classic Water/Classic River " + riverFeature + " A";
        }
        Feature river = new Feature(featureType, false, false, false, false, null, rotate, null, 101.0, 101.0, false, false, null, "river", true, true, true, true, ml);
        double terrainX = pt.getX() * 300.0 * 3.0 / 4.0 + 150.0;
        double terrainY = pt.getY() * 300.0 + (double)(pt.getX() % 2.0 == 0.0 ? 0 : 150) + 150.0;
        river.setLocation(viewLevel, terrainX, terrainY);
        features.add(river);
        uag.addAction(new UndoAction(UndoAction.Action.ADD, UndoAction.Thing.FEATURE, river, null, null, null, null, null));
    }

    private static int getRiverHexEntranceOrExit(Point2D pt, Point2D otherPt) {
        int entrance = 0;
        if (pt.getX() % 2.0 == 0.0) {
            if (otherPt.getX() < pt.getX() && otherPt.getY() < pt.getY()) {
                entrance = 5;
            } else if (otherPt.getX() == pt.getX() && otherPt.getY() < pt.getY()) {
                entrance = 0;
            } else if (otherPt.getX() > pt.getX() && otherPt.getY() < pt.getY()) {
                entrance = 1;
            } else if (otherPt.getX() > pt.getX() && otherPt.getY() == pt.getY()) {
                entrance = 2;
            } else if (otherPt.getX() == pt.getX() && otherPt.getY() > pt.getY()) {
                entrance = 3;
            } else if (otherPt.getX() < pt.getX() && otherPt.getY() == pt.getY()) {
                entrance = 4;
            }
        } else if (otherPt.getX() < pt.getX() && otherPt.getY() == pt.getY()) {
            entrance = 5;
        } else if (otherPt.getX() == pt.getX() && otherPt.getY() < pt.getY()) {
            entrance = 0;
        } else if (otherPt.getX() > pt.getX() && otherPt.getY() == pt.getY()) {
            entrance = 1;
        } else if (otherPt.getX() > pt.getX() && otherPt.getY() >= pt.getY()) {
            entrance = 2;
        } else if (otherPt.getX() == pt.getX() && otherPt.getY() > pt.getY()) {
            entrance = 3;
        } else if (otherPt.getX() < pt.getX() && otherPt.getY() > pt.getY()) {
            entrance = 4;
        }
        return entrance;
    }

    public static List<Point2D> fractalize(List<Point2D> pointsin, double lengthlimit, double maxchange) {
        ArrayList<Point2D> pointsout = new ArrayList<Point2D>();
        for (int i = 0; i < pointsin.size() - 1; ++i) {
            Point2D thispt = pointsin.get(i);
            Point2D nextpt = pointsin.get(i + 1);
            pointsout.addAll(MapLogic.fractalizeHelper(thispt, nextpt, lengthlimit, maxchange));
        }
        return pointsout;
    }

    private static List<Point2D> fractalizeHelper(Point2D pt, Point2D nextpt, double lengthlimit, double maxchange) {
        ArrayList<Point2D> pointsout = new ArrayList<Point2D>();
        double distance = pt.distance(nextpt);
        if (distance < lengthlimit) {
            pointsout.add(nextpt);
            return pointsout;
        }
        int dx = (int)(Math.random() * distance * 2.0 / maxchange - distance / maxchange);
        int dy = (int)(Math.random() * distance * 2.0 / maxchange - distance / maxchange);
        if (dx < 2 && dy < 2) {
            if (Math.random() < 0.5) {
                dy = 2;
            } else {
                dx = 2;
            }
        }
        Point2D midpoint = new Point2D((pt.getX() + nextpt.getX()) / 2.0 + (double)dx, (pt.getY() + nextpt.getY()) / 2.0 + (double)dy);
        pointsout.addAll(MapLogic.fractalizeHelper(pt, midpoint, lengthlimit, maxchange));
        pointsout.addAll(MapLogic.fractalizeHelper(midpoint, nextpt, lengthlimit, maxchange));
        return pointsout;
    }

    private static List<Point2D> makeLineIntoRiverPolygon(List<Point2D> pointsin) {
        ArrayList<Point2D> pointsout = new ArrayList<Point2D>();
        Point2D prevpt = pointsin.get(0);
        double railwidthoffset = 30.0;
        double slopex = 0.0;
        double slopey = 0.0;
        for (int i = 0; i < pointsin.size(); ++i) {
            Point2D pt = pointsin.get(i);
            Point2D nextpt = null;
            if (i < pointsin.size() - 1) {
                nextpt = pointsin.get(i + 1);
            }
            if (nextpt != null) {
                slopex = nextpt.getX() - prevpt.getX();
                slopey = nextpt.getY() - prevpt.getY();
            }
            MapLogic.calculateRiverBorderPoints(pointsout, slopex, slopey, pt);
            prevpt = pt;
        }
        return pointsout;
    }

    private static void calculateRiverBorderPoints(ArrayList<Point2D> pointsOut, double slopeX, double slopeY, Point2D pt) {
        double slope = slopeY / slopeX;
        double hypotlength = 30.0;
        double dy = Math.abs(hypotlength / Math.sqrt(slope * slope + 1.0));
        double dx = Math.abs(slope / dy);
        if (Double.isInfinite(dx)) {
            dx = 30.0;
        }
        if (Double.isInfinite(dy)) {
            dy = 30.0;
        }
        if (slope > 0.0 && slope < 0.0) {
            if (slopeX > 0.0) {
                dx = 0.0;
                dy = -30.0;
            } else {
                dx = 0.0;
                dy = 30.0;
            }
        } else if (slope < 2.0 && slope > 0.0) {
            if (slopeY > 0.0) {
                dx = 15.0;
                dy = -15.0;
            } else {
                dx = -15.0;
                dy = 15.0;
            }
        } else if (slope > -2.0) {
            if (slopeY > 0.0) {
                dx = -15.0;
                dy = -15.0;
            } else {
                dx = 15.0;
                dy = 15.0;
            }
        } else {
            dx = slopeY > 0.0 ? 30.0 : -30.0;
            dy = 0.0;
        }
        pointsOut.add(pointsOut.size() / 2, new Point2D(pt.getX() + dx, pt.getY() + dy));
        pointsOut.add(pointsOut.size() / 2 + 1, new Point2D(pt.getX() - dx, pt.getY() - dy));
    }

    private static void addSidePoints(List<Double> points, List<Point2D> othersidepoints, double priorx, double priory, double rise, double slope) {
        if (slope > 1.0 && rise > 0.0) {
            points.add(priorx + 10.0);
            points.add(priory + 5.0);
            othersidepoints.add(new Point2D(priorx - 10.0, priory - 5.0));
        } else if (slope > 1.0 && rise < 0.0) {
            points.add(priorx - 10.0);
            points.add(priory - 5.0);
            othersidepoints.add(new Point2D(priorx + 10.0, priory + 5.0));
        } else if (slope > 0.0 && rise > 0.0) {
            points.add(priorx + 5.0);
            points.add(priory + 10.0);
            othersidepoints.add(new Point2D(priorx - 5.0, priory - 10.0));
        } else if (slope > 0.0 && rise < 0.0) {
            points.add(priorx - 5.0);
            points.add(priory - 10.0);
            othersidepoints.add(new Point2D(priorx + 5.0, priory + 10.0));
        } else if (slope > -1.0 && rise > 0.0) {
            points.add(priorx + 5.0);
            points.add(priory + 10.0);
            othersidepoints.add(new Point2D(priorx - 10.0, priory + 5.0));
        } else if (slope > -1.0 && rise < 0.0) {
            points.add(priorx - 5.0);
            points.add(priory + 10.0);
            othersidepoints.add(new Point2D(priorx + 5.0, priory - 10.0));
        } else if (rise > 0.0) {
            points.add(priorx + 10.0);
            points.add(priory + 5.0);
            othersidepoints.add(new Point2D(priorx - 10.0, priory + 5.0));
        } else if (rise < 0.0) {
            points.add(priorx - 10.0);
            points.add(priory + 5.0);
            othersidepoints.add(new Point2D(priorx + 10.0, priory - 5.0));
        }
    }

    public static Pair<Pair<Integer, Integer>, Terrain> getAnyLowerAdjTerrain(Terrain[][] terrain, HexOrientation ho, int i, int j, List<Terrain> tempTerrainUsed) {
        int min = terrain[i][j].getElevation();
        min = (int)((double)min * 1.1);
        HashMap<Pair, Terrain> possibleMatches = new HashMap<Pair, Terrain>();
        if (ho.equals((Object)HexOrientation.ROWS)) {
            Terrain east;
            Terrain west;
            if (i > 0 && (west = terrain[i - 1][j]).getElevation() < min) {
                possibleMatches.put(new Pair((Object)(i - 1), (Object)j), west);
            }
            if (i + 1 < terrain.length && (east = terrain[i + 1][j]).getElevation() < min) {
                possibleMatches.put(new Pair((Object)(i + 1), (Object)j), east);
            }
            if (j % 2 == 0) {
                if (i > 0 && j > 0 && (northwest = terrain[i - 1][j - 1]).getElevation() < min) {
                    possibleMatches.put(new Pair((Object)(i - 1), (Object)(j - 1)), northwest);
                }
                if (j > 0 && (northeast = terrain[i][j - 1]).getElevation() < min) {
                    possibleMatches.put(new Pair((Object)i, (Object)(j - 1)), northeast);
                }
                if (j + 1 < terrain[i].length && (southeast = terrain[i][j + 1]).getElevation() < min) {
                    possibleMatches.put(new Pair((Object)i, (Object)(j + 1)), southeast);
                }
                if (i > 0 && j + 1 < terrain[i].length && (southwest = terrain[i - 1][j + 1]).getElevation() < min) {
                    possibleMatches.put(new Pair((Object)(i - 1), (Object)(j + 1)), southwest);
                }
            } else {
                if (j > 0 && (northwest = terrain[i][j - 1]).getElevation() < min) {
                    possibleMatches.put(new Pair((Object)i, (Object)(j - 1)), northwest);
                }
                if (i + 1 < terrain.length && j > 0 && (northeast = terrain[i + 1][j - 1]).getElevation() < min) {
                    possibleMatches.put(new Pair((Object)(i + 1), (Object)(j - 1)), northeast);
                }
                if (i + 1 < terrain.length && j + 1 < terrain[i].length && (southeast = terrain[i + 1][j + 1]).getElevation() < min) {
                    possibleMatches.put(new Pair((Object)(i + 1), (Object)(j + 1)), southeast);
                }
                if (j + 1 < terrain[i].length && (southwest = terrain[i][j + 1]).getElevation() < min) {
                    possibleMatches.put(new Pair((Object)i, (Object)(j + 1)), southwest);
                }
            }
        } else {
            Terrain south;
            Terrain north;
            if (j > 0 && (north = terrain[i][j - 1]).getElevation() < min && !tempTerrainUsed.contains(north)) {
                possibleMatches.put(new Pair((Object)i, (Object)(j - 1)), north);
            }
            if (j + 1 < terrain[i].length && (south = terrain[i][j + 1]).getElevation() < min && !tempTerrainUsed.contains(south)) {
                possibleMatches.put(new Pair((Object)i, (Object)(j + 1)), south);
            }
            if (i % 2 == 0) {
                if (i > 0 && j > 0 && (northwest = terrain[i - 1][j - 1]).getElevation() < min && !tempTerrainUsed.contains(northwest)) {
                    possibleMatches.put(new Pair((Object)(i - 1), (Object)(j - 1)), northwest);
                }
                if (i > 0 && (southwest = terrain[i - 1][j]).getElevation() < min && !tempTerrainUsed.contains(southwest)) {
                    possibleMatches.put(new Pair((Object)(i - 1), (Object)j), southwest);
                }
                if (i + 1 < terrain.length && j > 0 && (northeast = terrain[i + 1][j - 1]).getElevation() < min && !tempTerrainUsed.contains(northeast)) {
                    possibleMatches.put(new Pair((Object)(i + 1), (Object)(j - 1)), northeast);
                }
                if (i + 1 < terrain.length && (southeast = terrain[i + 1][j]).getElevation() < min && !tempTerrainUsed.contains(southeast)) {
                    possibleMatches.put(new Pair((Object)(i + 1), (Object)j), southeast);
                }
            } else {
                if (i > 0 && (northwest = terrain[i - 1][j]).getElevation() < min && !tempTerrainUsed.contains(northwest)) {
                    possibleMatches.put(new Pair((Object)(i - 1), (Object)j), northwest);
                }
                if (i > 0 && j + 1 < terrain[i].length && (southwest = terrain[i - 1][j + 1]).getElevation() < min && !tempTerrainUsed.contains(southwest)) {
                    possibleMatches.put(new Pair((Object)(i - 1), (Object)(j + 1)), southwest);
                }
                if (i + 1 < terrain.length && (northeast = terrain[i + 1][j]).getElevation() < min && !tempTerrainUsed.contains(northeast)) {
                    possibleMatches.put(new Pair((Object)(i + 1), (Object)j), northeast);
                }
                if (i + 1 < terrain.length && j + 1 < terrain[i].length && (southeast = terrain[i + 1][j + 1]).getElevation() < min && !tempTerrainUsed.contains(southeast)) {
                    possibleMatches.put(new Pair((Object)(i + 1), (Object)(j + 1)), southeast);
                }
            }
        }
        if (possibleMatches.size() == 0) {
            return null;
        }
        Object key = possibleMatches.keySet().toArray()[(int)(Math.random() * (double)possibleMatches.size())];
        Pair typedkey = (Pair)key;
        return new Pair((Object)typedkey, (Object)((Terrain)possibleMatches.get(typedkey)));
    }

    public static void addCoastlines(UndoActionGroup uag, Worldographer worldographer, MapData md, ViewLevel vl, GenerateEmpiresTask task, String coastType, boolean changeToSea) {
        int i;
        Terrain[][] terrain = md.getTerrain(vl);
        MapLayer ml = md.getMapLayer("Coasts");
        if (ml == null) {
            int found = 0;
            for (i = 0; i < worldographer.observableLayers.size(); ++i) {
                if (coastType.contains("shapes")) {
                    if (!((MapLayer)worldographer.observableLayers.get(i)).getName().equalsIgnoreCase("Above Water")) continue;
                    found = i;
                    break;
                }
                if (!((MapLayer)worldographer.observableLayers.get(i)).getName().equalsIgnoreCase("Above Terrain")) continue;
                found = i;
                break;
            }
            ml = new MapLayer("Coasts");
            worldographer.observableLayers.add(found, (Object)ml);
            md.getMapLayers().add(found, ml);
        }
        if (coastType.toLowerCase().contains("isometric")) {
            HashMap<String, List<String>> shoreTypesToShores = new HashMap<String, List<String>>();
            HashMap<String, List<String>> shoreTypesToShoresRocky = new HashMap<String, List<String>>();
            MapLogic.setupShoresForCoasts(shoreTypesToShores, shoreTypesToShoresRocky);
            for (int i2 = 0; i2 < terrain.length; ++i2) {
                if (task != null) {
                    task.updateMessage("Checking & adding isometric coasts: " + (int)(0.44 + (double)i2 * 100.0 / (double)terrain.length) + "%");
                }
                for (int j = 0; j < terrain[i2].length; ++j) {
                    String tname = terrain[i2][j].getTypeName().toLowerCase();
                    boolean useRockyCoast = tname.contains("mountain") || tname.contains("volcano") || tname.contains("badlands") || tname.contains("rocky");
                    MapLogic.addISOCoastlineToTile(uag, md, i2, j, vl, ml, changeToSea, useRockyCoast ? shoreTypesToShoresRocky : shoreTypesToShores, useRockyCoast);
                }
            }
        } else if (coastType.toLowerCase().contains("classic") || coastType.toLowerCase().contains("ring lord")) {
            HashMap<String, List<String>> shoreTypesToShores = new HashMap<String, List<String>>();
            MapLogic.setupShoresForCoastsClassic(shoreTypesToShores, coastType);
            for (i = 0; i < terrain.length; ++i) {
                if (task != null) {
                    task.updateMessage("Checking & adding classic coasts: " + (int)(0.44 + (double)i * 100.0 / (double)terrain.length) + "%");
                }
                for (int j = 0; j < terrain[i].length; ++j) {
                    MapLogic.addClassicCoastlineToTile(uag, md, i, j, vl, ml, changeToSea, shoreTypesToShores, coastType.toLowerCase().contains("classic") ? "Blue " : "");
                }
            }
        } else {
            List<MapShape> mapShapes = md.getShapes();
            for (i = 0; i < terrain.length; ++i) {
                if (task != null) {
                    task.updateMessage("Checking & adding shape coasts: " + (int)(0.44 + (double)i * 100.0 / (double)terrain.length) + "%");
                }
                for (int j = 0; j < terrain[i].length; ++j) {
                    MapLogic.addCoastlineToTile(uag, md, mapShapes, i, j, 75, vl, ml, changeToSea);
                }
            }
        }
    }

    public static void setupShoresForCoasts(Map<String, List<String>> shoreTypesToShores, Map<String, List<String>> shoreTypesToShoresRocky) {
        for (String ft : Feature.featureTypes.keySet()) {
            List<String> shores;
            if (!ft.toLowerCase().startsWith("isometric region/shore ")) continue;
            String key = ft.substring(0, ft.lastIndexOf(" ")).toLowerCase();
            if (key.toLowerCase().contains("rocky")) {
                shores = shoreTypesToShoresRocky.get(key);
                if (shores == null) {
                    shores = new ArrayList<String>();
                    shoreTypesToShoresRocky.put(key, shores);
                }
                shores.add(ft);
                continue;
            }
            shores = shoreTypesToShores.get(key);
            if (shores == null) {
                shores = new ArrayList<String>();
                shoreTypesToShores.put(key, shores);
            }
            shores.add(ft);
        }
    }

    public static void setupShoresForCoastsClassic(Map<String, List<String>> shoreTypesToShores, String coastType) {
        for (String ft : Feature.featureTypes.keySet()) {
            String ftLowerCase = ft.toLowerCase();
            if (!ftLowerCase.contains("coasts ") || !ftLowerCase.contains(" water edge") || (!coastType.toLowerCase().contains("classic") || !ftLowerCase.contains("blue")) && (coastType.toLowerCase().contains("classic") || ftLowerCase.contains("blue"))) continue;
            String key = ft.substring(ft.indexOf("Coasts "), ft.lastIndexOf(" ")).toLowerCase();
            List<String> shores = shoreTypesToShores.get(key);
            if (shores == null) {
                shores = new ArrayList<String>();
                shoreTypesToShores.put(key, shores);
            }
            shores.add(ft);
            if (ft.endsWith(" A")) {
                shores.add(ft);
                shores.add(ft);
                shores.add(ft);
            }
            if (!ft.endsWith(" B")) continue;
            shores.add(ft);
            shores.add(ft);
        }
    }

    public static boolean replaceMountains(UndoActionGroup uag, ViewLevel vl, MapData md, Terrain[][] terrain, MapLayer mountainsLayer) {
        boolean changed = false;
        ArrayList<String> mountainTypes = new ArrayList<String>();
        ArrayList<String> mountainArcticTypes = new ArrayList<String>();
        ArrayList<String> mountainDeciduousTypes = new ArrayList<String>();
        ArrayList<String> mountainEvergreenTypes = new ArrayList<String>();
        ArrayList<String> mountainJungleTypes = new ArrayList<String>();
        ArrayList<String> mountainMixedTypes = new ArrayList<String>();
        ArrayList<String> volcanoTypes = new ArrayList<String>();
        MapLogic.replaceMountainsSetupFeatures(mountainTypes, mountainArcticTypes, mountainDeciduousTypes, mountainEvergreenTypes, mountainJungleTypes, mountainMixedTypes, volcanoTypes);
        ArrayList<String> arcticTerrainTypes = new ArrayList<String>();
        ArrayList<String> deciduousTerrainTypes = new ArrayList<String>();
        ArrayList<String> evergreenTerrainTypes = new ArrayList<String>();
        ArrayList<String> jungleTerrainTypes = new ArrayList<String>();
        ArrayList<String> mixedTerrainTypes = new ArrayList<String>();
        ArrayList<String> volcanoTerrainTypes = new ArrayList<String>();
        MapLogic.replaceMountainsSetupTerrain(md, arcticTerrainTypes, deciduousTerrainTypes, evergreenTerrainTypes, jungleTerrainTypes, mixedTerrainTypes, volcanoTerrainTypes);
        for (int j = 0; j < terrain[0].length; ++j) {
            for (int i = 0; i < terrain.length; ++i) {
                changed = MapLogic.replaceTerrainSingleHex(uag, vl, md, terrain, null, mountainsLayer, changed, mountainTypes, mountainDeciduousTypes, mountainEvergreenTypes, mountainJungleTypes, mountainMixedTypes, mountainArcticTypes, volcanoTypes, arcticTerrainTypes, deciduousTerrainTypes, evergreenTerrainTypes, jungleTerrainTypes, mixedTerrainTypes, volcanoTerrainTypes, j, i);
            }
        }
        return changed;
    }

    public static void replaceMountainsSetupTerrain(MapData md, List<String> arcticTerrainTypes, List<String> deciduousTerrainTypes, List<String> evergreenTerrainTypes, List<String> jungleTerrainTypes, List<String> mixedTerrainTypes, List<String> volcanoTerrainTypes) {
        String hexType = "cols";
        if (md.getTileOrientation() == HexOrientation.ROWS) {
            hexType = "rows";
        }
        for (String tt : Terrain.terrainTypes.keySet()) {
            if (tt.toLowerCase().contains("arctic") && tt.toLowerCase().contains("base")) {
                arcticTerrainTypes.add(tt);
            }
            if (!tt.toLowerCase().startsWith("iso " + hexType) || tt.toLowerCase().contains("mountain")) continue;
            if (tt.toLowerCase().contains("deciduous forest")) {
                deciduousTerrainTypes.add(tt);
            }
            if (tt.toLowerCase().contains("evergreen forest")) {
                evergreenTerrainTypes.add(tt);
            }
            if (tt.toLowerCase().contains("jungle forest")) {
                jungleTerrainTypes.add(tt);
            }
            if (tt.toLowerCase().contains("mixed forest")) {
                mixedTerrainTypes.add(tt);
            }
            if (!tt.toLowerCase().contains("other volcano") || !tt.toLowerCase().contains("base")) continue;
            volcanoTerrainTypes.add(tt);
        }
    }

    public static void replaceMountainsSetupFeatures(List<String> mountainTypes, List<String> mountainArcticTypes, List<String> mountainDeciduousTypes, List<String> mountainEvergreenTypes, List<String> mountainJungleTypes, List<String> mountainMixedTypes, List<String> volcanoTypes) {
        for (String ft : Feature.featureTypes.keySet()) {
            if (ft.toLowerCase().contains("iso-d") || ft.toLowerCase().contains("iso-e") || ft.toLowerCase().contains("iso-f")) continue;
            if (ft.toLowerCase().startsWith("isometric region/mountain transparent iso")) {
                mountainTypes.add(ft);
                continue;
            }
            if (ft.toLowerCase().startsWith("isometric region/mountain transparent arctic")) {
                mountainArcticTypes.add(ft);
                continue;
            }
            if (ft.toLowerCase().startsWith("isometric region/mountain transparent deciduous")) {
                mountainDeciduousTypes.add(ft);
                continue;
            }
            if (ft.toLowerCase().startsWith("isometric region/mountain transparent evergreen")) {
                mountainEvergreenTypes.add(ft);
                continue;
            }
            if (ft.toLowerCase().startsWith("isometric region/mountain transparent jungle")) {
                mountainJungleTypes.add(ft);
                continue;
            }
            if (ft.toLowerCase().startsWith("isometric region/mountain transparent mixed")) {
                mountainMixedTypes.add(ft);
                continue;
            }
            if (!ft.toLowerCase().startsWith("other volcano")) continue;
            volcanoTypes.add(ft);
        }
    }

    public static boolean replaceTerrainSingleHex(UndoActionGroup uag, ViewLevel vl, MapData md, Terrain[][] terrain, Terrain[][] substituteTerrain, MapLayer mountainsLayer, boolean changed, List<String> mountainTypes, List<String> mountainDeciduousTypes, List<String> mountainEvergreenTypes, List<String> mountainJungleTypes, List<String> mountainMixedTypes, List<String> mountainArcticTypes, List<String> volcanoTypes, List<String> arcticTerrainTypes, List<String> deciduousTerrainTypes, List<String> evergreenTerrainTypes, List<String> jungleTerrainTypes, List<String> mixedTerrainTypes, List<String> volcanoTerrainTypes, int row, int col) {
        if (terrain[col][row].getTypeName().toLowerCase().contains("mountain") && terrain[col][row].getTypeName().toLowerCase().contains("iso ") && !terrain[col][row].getTypeName().toLowerCase().contains("only")) {
            if (terrain[col][row].getTypeName().toLowerCase().contains("deciduous")) {
                t = new Terrain(deciduousTerrainTypes.get((int)((double)deciduousTerrainTypes.size() * Math.random())), true);
                tl = new ArrayList<Terrain>();
                tl.add(t);
                md.changeTerrain(uag, tl, new Point2D((double)col, (double)row), vl, vl, true, null, false, false, false, terrain[col][row].getElevation(), terrain[col][row].getExtraInfo().getResources());
            } else if (terrain[col][row].getTypeName().toLowerCase().contains("evergreen")) {
                t = new Terrain(evergreenTerrainTypes.get((int)((double)evergreenTerrainTypes.size() * Math.random())), true);
                tl = new ArrayList();
                tl.add(t);
                md.changeTerrain(uag, tl, new Point2D((double)col, (double)row), vl, vl, true, null, false, false, false, terrain[col][row].getElevation(), terrain[col][row].getExtraInfo().getResources());
            } else if (terrain[col][row].getTypeName().toLowerCase().contains("jungle")) {
                t = new Terrain(jungleTerrainTypes.get((int)((double)jungleTerrainTypes.size() * Math.random())), true);
                tl = new ArrayList();
                tl.add(t);
                md.changeTerrain(uag, tl, new Point2D((double)col, (double)row), vl, vl, true, null, false, false, false, terrain[col][row].getElevation(), terrain[col][row].getExtraInfo().getResources());
            } else if (terrain[col][row].getTypeName().toLowerCase().contains("mixed")) {
                t = new Terrain(mixedTerrainTypes.get((int)((double)mixedTerrainTypes.size() * Math.random())), true);
                tl = new ArrayList();
                tl.add(t);
                md.changeTerrain(uag, tl, new Point2D((double)col, (double)row), vl, vl, true, null, false, false, false, terrain[col][row].getElevation(), terrain[col][row].getExtraInfo().getResources());
            } else if (terrain[col][row].getTypeName().toLowerCase().contains("arctic")) {
                t = new Terrain(arcticTerrainTypes.get((int)((double)arcticTerrainTypes.size() * Math.random())), true);
                tl = new ArrayList();
                tl.add(t);
                md.changeTerrain(uag, tl, new Point2D((double)col, (double)row), vl, vl, true, null, false, false, false, terrain[col][row].getElevation(), terrain[col][row].getExtraInfo().getResources());
            } else {
                t = new Terrain("ISO " + (md.getTileOrientation() == HexOrientation.COLUMNS ? "Cols" : "Rows") + "/Mountain Base Only", true);
                tl = new ArrayList();
                tl.add(t);
                md.changeTerrain(uag, tl, new Point2D((double)col, (double)row), vl, vl, true, null, false, false, false, terrain[col][row].getElevation(), terrain[col][row].getExtraInfo().getResources());
            }
            List<String> mt = mountainTypes;
            if (terrain[col][row].getTypeName().toLowerCase().contains("deciduous")) {
                mt = mountainDeciduousTypes;
            } else if (terrain[col][row].getTypeName().toLowerCase().contains("evergreen")) {
                mt = mountainEvergreenTypes;
            } else if (terrain[col][row].getTypeName().toLowerCase().contains("jungle")) {
                mt = mountainJungleTypes;
            } else if (terrain[col][row].getTypeName().toLowerCase().contains("mixed")) {
                mt = mountainMixedTypes;
            } else if (terrain[col][row].getTypeName().toLowerCase().contains("arctic")) {
                mt = mountainArcticTypes;
            }
            Map<Integer, Terrain> adjacentTerrain = MapLogic.getAdjTerrainByDirections(substituteTerrain != null ? substituteTerrain : terrain, md.getTileOrientation(), col, row);
            double centerX = 0.0;
            double centerY = 0.0;
            if (md.getTileOrientation() == HexOrientation.ROWS) {
                boolean placedUpperLeft = false;
                boolean placedUpperRight = false;
                if (adjacentTerrain.get(3).getTypeName().toLowerCase().contains("mountain") && adjacentTerrain.get(4).getTypeName().toLowerCase().contains("mountain") && adjacentTerrain.get(5).getTypeName().toLowerCase().contains("mountain")) {
                    MapLogic.addFeature(uag, vl, md, mountainsLayer, col, row, Math.random() * 20.0 - 80.0, Math.random() * 20.0 - 85.0, "mountain", mt);
                    placedUpperLeft = true;
                }
                if (adjacentTerrain.get(0).getTypeName().toLowerCase().contains("mountain") && adjacentTerrain.get(1).getTypeName().toLowerCase().contains("mountain") && adjacentTerrain.get(2).getTypeName().toLowerCase().contains("mountain")) {
                    MapLogic.addFeature(uag, vl, md, mountainsLayer, col, row, Math.random() * 20.0 + 60.0, Math.random() * 20.0 - 85.0, "mountain", mt);
                    placedUpperRight = true;
                }
                if (!placedUpperLeft) {
                    MapLogic.addFeature(uag, vl, md, mountainsLayer, col, row, Math.random() * 30.0 - 70.0, Math.random() * 100.0 - 50.0, "mountain", mt);
                }
                if (!placedUpperRight) {
                    MapLogic.addFeature(uag, vl, md, mountainsLayer, col, row, Math.random() * 20.0 + 60.0, Math.random() * 100.0 - 50.0, "mountain", mt);
                }
                if (placedUpperLeft) {
                    MapLogic.addFeature(uag, vl, md, mountainsLayer, col, row, Math.random() * 20.0 - 80.0, Math.random() * 20.0 + 65.0, "mountain", mt);
                }
                if (placedUpperRight) {
                    MapLogic.addFeature(uag, vl, md, mountainsLayer, col, row, Math.random() * 20.0 + 60.0, Math.random() * 20.0 + 65.0, "mountain", mt);
                }
                changed = true;
            }
            if (md.getTileOrientation() == HexOrientation.COLUMNS) {
                if (adjacentTerrain.get(0) != null && adjacentTerrain.get(0).getTypeName().toLowerCase().contains("mountain")) {
                    centerY += 20.0;
                }
                if (adjacentTerrain.get(1) != null && adjacentTerrain.get(1).getTypeName().toLowerCase().contains("mountain")) {
                    centerX -= 20.0;
                    centerY += 20.0;
                }
                if (adjacentTerrain.get(2) != null && adjacentTerrain.get(2).getTypeName().toLowerCase().contains("mountain")) {
                    centerX -= 20.0;
                    centerY -= 20.0;
                }
                if (adjacentTerrain.get(3) != null && adjacentTerrain.get(3).getTypeName().toLowerCase().contains("mountain")) {
                    centerY -= 20.0;
                }
                if (adjacentTerrain.get(4) != null && adjacentTerrain.get(4).getTypeName().toLowerCase().contains("mountain")) {
                    centerX += 20.0;
                    centerY -= 20.0;
                }
                if (adjacentTerrain.get(5) != null && adjacentTerrain.get(5).getTypeName().toLowerCase().contains("mountain")) {
                    centerX += 20.0;
                    centerY += 20.0;
                }
                if (centerX > 20.0) {
                    centerX = 20.0;
                }
                if (centerX < -20.0) {
                    centerX = -20.0;
                }
                if (adjacentTerrain.get(0) != null && adjacentTerrain.get(0).getTypeName().toLowerCase().contains("mountain")) {
                    MapLogic.addFeature(uag, vl, md, mountainsLayer, col, row, Math.random() * 20.0 - 10.0, Math.random() * 20.0 - 150.0, "mountain", mt);
                }
                if (adjacentTerrain.get(5) != null && adjacentTerrain.get(5).getTypeName().toLowerCase().contains("mountain")) {
                    MapLogic.addFeature(uag, vl, md, mountainsLayer, col, row, Math.random() * 20.0 - 100.0, Math.random() * 20.0 - 85.0, "mountain", mt);
                }
                if (adjacentTerrain.get(1) != null && adjacentTerrain.get(1).getTypeName().toLowerCase().contains("mountain")) {
                    MapLogic.addFeature(uag, vl, md, mountainsLayer, col, row, Math.random() * 20.0 + 100.0, Math.random() * 20.0 - 85.0, "mountain", mt);
                }
                MapLogic.addFeature(uag, vl, md, mountainsLayer, col, row, Math.random() * 40.0 + centerX - 20.0, Math.random() * 20.0 + centerX - 10.0, "mountain", mt);
                changed = true;
            }
        } else if (terrain[col][row].getTypeName().toLowerCase().contains("volcano") && terrain[col][row].getTypeName().toLowerCase().contains("iso ") && !terrain[col][row].getTypeName().toLowerCase().contains("base")) {
            Terrain t = new Terrain(volcanoTerrainTypes.get((int)((double)volcanoTerrainTypes.size() * Math.random())), true);
            ArrayList<Terrain> tl = new ArrayList<Terrain>();
            tl.add(t);
            md.changeTerrain(uag, tl, new Point2D((double)col, (double)row), vl, vl, true, null, false, false, false, terrain[col][row].getElevation(), terrain[col][row].getExtraInfo().getResources());
            MapLogic.addFeature(uag, vl, md, mountainsLayer, col, row, Math.random() * 40.0 - 20.0, Math.random() * 40.0 - 20.0, "volcano", volcanoTypes);
        }
        return changed;
    }

    private static void addFeature(UndoActionGroup uag, ViewLevel vl, MapData md, MapLayer ml, int i, int j, double offsetx, double offsety, String tags, List<String> featureTypes) {
        Feature feature = new Feature(featureTypes.get((int)(Math.random() * (double)featureTypes.size())), true, false, false, false, null, 0.0, null, -1.0, -1.0, false, false, null, tags, true, true, true, true, ml);
        double locx = 0.0;
        double locy = 0.0;
        if (md.getTileOrientation() == HexOrientation.COLUMNS) {
            locx = i * 300 * 3 / 4 + 150;
            locy = j * 300 + (i % 2 == 0 ? 0 : 150) + 150;
        }
        if (md.getTileOrientation() == HexOrientation.ROWS) {
            locx = i * 300 + (j % 2 == 0 ? 0 : 150) + 150;
            locy = j * 300 * 3 / 4 + 150;
        }
        feature.setLocation(vl, new Point2D(locx += offsetx, locy += offsety));
        feature.setWorld(vl == ViewLevel.WORLD);
        feature.setContinent(vl == ViewLevel.CONTINENT);
        feature.setKingdom(vl == ViewLevel.KINGDOM);
        feature.setProvince(vl == ViewLevel.PROVINCE);
        md.addNewFeature(vl, uag, feature, locx, locy);
    }

    public static boolean isTerrainLand(Terrain t) {
        return t != null && !t.getTypeName().toLowerCase().contains("water") && !t.getTypeName().equals("Empty") && !t.getTypeName().equals("Blank");
    }

    public static void addClassicCoastlineToTile(UndoActionGroup uag, MapData md, int i, int j, ViewLevel vl, MapLayer ml, boolean changeToSea, Map<String, List<String>> shoreTypesToShores, String extraKey) {
        Terrain[][] terrain = md.getTerrain(vl);
        HexOrientation ho = md.getTileOrientation();
        boolean wascoast = false;
        TreeMap coastsByCoord = new TreeMap();
        if (!terrain[i][j].getTypeName().toLowerCase().contains("water")) {
            MapLogic.addClassicCoastsToTile(uag, md, i, j, vl, ml, shoreTypesToShores, terrain, ho, extraKey);
        }
        if (changeToSea && terrain[i][j].getTypeName().toLowerCase().contains("water")) {
            boolean wasIcy = terrain[i][j].isIcy();
            Map<Integer, Terrain> adjacentTerrain = MapLogic.getAdjTerrainByDirections(terrain, ho, i, j);
            for (Terrain t : adjacentTerrain.values()) {
                if (t.getTypeName().toLowerCase().contains("water")) continue;
                Terrain newt = new Terrain("Classic/Water Sea", true);
                newt.setIcy(wasIcy);
                ArrayList<Terrain> tl = new ArrayList<Terrain>();
                tl.add(newt);
                md.changeTerrain(uag, tl, new Point2D((double)i, (double)j), vl, vl, true, null, false, terrain[i][j].isIcy(), false, terrain[i][j].getElevation(), terrain[i][j].getExtraInfo().getResources());
            }
        }
    }

    public static void addISOCoastlineToTile(UndoActionGroup uag, MapData md, int i, int j, ViewLevel vl, MapLayer ml, boolean changeToSea, Map<String, List<String>> shoreTypesToShores, boolean isRocky) {
        Terrain[][] terrain = md.getTerrain(vl);
        HexOrientation ho = md.getTileOrientation();
        if (!terrain[i][j].getTypeName().toLowerCase().contains("water")) {
            MapLogic.addISOCoastsToTile(uag, md, i, j, vl, ml, shoreTypesToShores, isRocky, terrain, ho);
        }
        if (changeToSea && terrain[i][j].getTypeName().toLowerCase().contains("water")) {
            Map<Integer, Terrain> adjacentTerrain = MapLogic.getAdjTerrainByDirections(terrain, ho, i, j);
            for (Terrain t : adjacentTerrain.values()) {
                if (t.getTypeName().toLowerCase().contains("water")) continue;
                boolean wasIcy = terrain[i][j].isIcy();
                Terrain newt = new Terrain("ISO " + (md.getTileOrientation() == HexOrientation.COLUMNS ? "Cols" : "Rows") + "/Water Sea", true);
                newt.setIcy(wasIcy);
                ArrayList<Terrain> tl = new ArrayList<Terrain>();
                tl.add(newt);
                md.changeTerrain(uag, tl, new Point2D((double)i, (double)j), vl, vl, true, null, false, terrain[i][j].isIcy(), false, terrain[i][j].getElevation(), terrain[i][j].getExtraInfo().getResources());
            }
        }
    }

    private static void addClassicCoastsToTile(UndoActionGroup uag, MapData md, int i, int j, ViewLevel vl, MapLayer ml, Map<String, List<String>> shoreTypesToShores, Terrain[][] terrain, HexOrientation ho, String extraKey) {
        int count;
        int maxTries = 20;
        Map<Integer, Terrain> adjacentTerrain = MapLogic.getAdjTerrainByDirections(terrain, ho, i, j);
        boolean horizontalFlip = Math.random() < 0.5;
        int extraRowRotate = ho == HexOrientation.COLUMNS ? 0 : 30;
        ArrayList<Double> waters = new ArrayList<Double>();
        for (Integer index : adjacentTerrain.keySet()) {
            if (!adjacentTerrain.get(index).getTypeName().toLowerCase().contains("water")) continue;
            waters.add((double)index.intValue() * 1.0);
        }
        for (count = 0; waters.size() >= 5 && count < maxTries; ++count) {
            int which = (int)(Math.random() * 6.0);
            MapLogic.checkAnyNumSidesAddCoast(waters, "Coasts 5 " + extraKey + "Water Edges", horizontalFlip, false, (which * 60 + (horizontalFlip ? 240 : 0)) % 360 + extraRowRotate, shoreTypesToShores, md, uag, vl, i, j, ml, which, 5);
        }
        for (count = 0; waters.size() >= 4 && count < maxTries; ++count) {
            int which = (int)(Math.random() * 6.0);
            MapLogic.checkAnyNumSidesAddCoast(waters, "Coasts 4 " + extraKey + "Water Edges", horizontalFlip, false, (which * 60 + (horizontalFlip ? 240 : 300)) % 360 + extraRowRotate, shoreTypesToShores, md, uag, vl, i, j, ml, which, 4);
        }
        for (count = 0; waters.size() >= 3 && count < maxTries; ++count) {
            int which = (int)(Math.random() * 6.0);
            MapLogic.checkAnyNumSidesAddCoast(waters, "Coasts 3 " + extraKey + "Water Edges", horizontalFlip, false, (which * 60 + 240) % 360 + extraRowRotate, shoreTypesToShores, md, uag, vl, i, j, ml, which, 3);
        }
        for (count = 0; waters.size() >= 2 && count < maxTries; ++count) {
            int which = (int)(Math.random() * 6.0);
            MapLogic.checkAnyNumSidesAddCoast(waters, "Coasts 2 " + extraKey + "Water Edges", horizontalFlip, false, (which * 60 + (horizontalFlip ? 240 : 180)) % 360 + extraRowRotate, shoreTypesToShores, md, uag, vl, i, j, ml, which, 2);
        }
        if (waters.contains(0.0)) {
            MapLogic.addSingleIsoCoastToTile(md, uag, vl, i, j, ml, horizontalFlip, false, (horizontalFlip ? 240 : 120) + extraRowRotate, "Coasts 1 " + extraKey + "Water Edge", ho == HexOrientation.COLUMNS ? 100 : 115, shoreTypesToShores);
        }
        if (waters.contains(1.0)) {
            MapLogic.addSingleIsoCoastToTile(md, uag, vl, i, j, ml, horizontalFlip, false, (horizontalFlip ? 300 : 180) + extraRowRotate, "Coasts 1 " + extraKey + "Water Edge", ho == HexOrientation.COLUMNS ? 100 : 115, shoreTypesToShores);
        }
        if (waters.contains(2.0)) {
            MapLogic.addSingleIsoCoastToTile(md, uag, vl, i, j, ml, horizontalFlip, false, (horizontalFlip ? 0 : 240) + extraRowRotate, "Coasts 1 " + extraKey + "Water Edge", ho == HexOrientation.COLUMNS ? 100 : 115, shoreTypesToShores);
        }
        if (waters.contains(3.0)) {
            MapLogic.addSingleIsoCoastToTile(md, uag, vl, i, j, ml, horizontalFlip, false, (horizontalFlip ? 60 : 300) + extraRowRotate, "Coasts 1 " + extraKey + "Water Edge", ho == HexOrientation.COLUMNS ? 100 : 115, shoreTypesToShores);
        }
        if (waters.contains(4.0)) {
            MapLogic.addSingleIsoCoastToTile(md, uag, vl, i, j, ml, horizontalFlip, false, (horizontalFlip ? 120 : 0) + extraRowRotate, "Coasts 1 " + extraKey + "Water Edge", ho == HexOrientation.COLUMNS ? 100 : 115, shoreTypesToShores);
        }
        if (waters.contains(5.0)) {
            MapLogic.addSingleIsoCoastToTile(md, uag, vl, i, j, ml, horizontalFlip, false, (horizontalFlip ? 180 : 60) + extraRowRotate, "Coasts 1 " + extraKey + "Water Edge", ho == HexOrientation.COLUMNS ? 100 : 115, shoreTypesToShores);
        }
    }

    private static void addISOCoastsToTile(UndoActionGroup uag, MapData md, int i, int j, ViewLevel vl, MapLayer ml, Map<String, List<String>> shoreTypesToShores, boolean isRocky, Terrain[][] terrain, HexOrientation ho) {
        Map<Integer, Terrain> adjacentTerrain = MapLogic.getAdjTerrainByDirections(terrain, ho, i, j);
        if (ho == HexOrientation.COLUMNS) {
            int count;
            ArrayList<Double> waters = new ArrayList<Double>();
            for (Integer index : adjacentTerrain.keySet()) {
                if (!adjacentTerrain.get(index).getTypeName().toLowerCase().contains("water")) continue;
                waters.add((double)index.intValue() * 1.0);
            }
            for (count = 0; waters.size() >= 5 && count < 6; ++count) {
                int which = (int)(Math.random() * 6.0);
                if (which == 0) {
                    MapLogic.checkAnyNumSidesAddCoast(waters, "Isometric Region/Shore " + (isRocky ? "Rocky " : "") + "5 Edge Angle COL", false, false, 0.0, shoreTypesToShores, md, uag, vl, i, j, ml, 0.0, 5);
                }
                if (which == 1) {
                    MapLogic.checkAnyNumSidesAddCoast(waters, "Isometric Region/Shore " + (isRocky ? "Rocky " : "") + "5 Edge Side COL", Math.random() < 0.5, false, 0.0, shoreTypesToShores, md, uag, vl, i, j, ml, 1.0, 5);
                }
                if (which == 2) {
                    MapLogic.checkAnyNumSidesAddCoast(waters, "Isometric Region/Shore " + (isRocky ? "Rocky " : "") + "5 Edge Angle COL", true, false, 0.0, shoreTypesToShores, md, uag, vl, i, j, ml, 2.0, 5);
                }
                if (which == 3) {
                    MapLogic.checkAnyNumSidesAddCoast(waters, "Isometric Region/Shore " + (isRocky ? "Rocky " : "") + "5 Edge Angle COL", true, true, 0.0, shoreTypesToShores, md, uag, vl, i, j, ml, 3.0, 5);
                }
                if (which == 4) {
                    MapLogic.checkAnyNumSidesAddCoast(waters, "Isometric Region/Shore " + (isRocky ? "Rocky " : "") + "5 Edge Side COL", Math.random() < 0.5, true, 0.0, shoreTypesToShores, md, uag, vl, i, j, ml, 4.0, 5);
                }
                if (which != 5) continue;
                MapLogic.checkAnyNumSidesAddCoast(waters, "Isometric Region/Shore " + (isRocky ? "Rocky " : "") + "5 Edge Angle COL", false, true, 0.0, shoreTypesToShores, md, uag, vl, i, j, ml, 5.0, 5);
            }
            for (count = 0; waters.size() >= 4 && count < 10; ++count) {
                int which = (int)(Math.random() * 6.0);
                if (which == 0) {
                    MapLogic.checkAnyNumSidesAddCoast(waters, "Isometric Region/Shore " + (isRocky ? "Rocky " : "") + "4 Edge Angle Angle COL", false, Math.random() < 0.5, 0.0, shoreTypesToShores, md, uag, vl, i, j, ml, 0.0, 4);
                }
                if (which == 1) {
                    MapLogic.checkAnyNumSidesAddCoast(waters, "Isometric Region/Shore " + (isRocky ? "Rocky " : "") + "4 Edge Angle Side COL", false, false, 0.0, shoreTypesToShores, md, uag, vl, i, j, ml, 1.0, 4);
                }
                if (which == 2) {
                    MapLogic.checkAnyNumSidesAddCoast(waters, "Isometric Region/Shore " + (isRocky ? "Rocky " : "") + "4 Edge Angle Side COL", true, false, 0.0, shoreTypesToShores, md, uag, vl, i, j, ml, 2.0, 4);
                }
                if (which == 3) {
                    MapLogic.checkAnyNumSidesAddCoast(waters, "Isometric Region/Shore " + (isRocky ? "Rocky " : "") + "4 Edge Angle Angle COL", true, Math.random() < 0.5, 0.0, shoreTypesToShores, md, uag, vl, i, j, ml, 3.0, 4);
                }
                if (which == 4) {
                    MapLogic.checkAnyNumSidesAddCoast(waters, "Isometric Region/Shore " + (isRocky ? "Rocky " : "") + "4 Edge Angle Side COL", true, true, 0.0, shoreTypesToShores, md, uag, vl, i, j, ml, 4.0, 4);
                }
                if (which != 5) continue;
                MapLogic.checkAnyNumSidesAddCoast(waters, "Isometric Region/Shore " + (isRocky ? "Rocky " : "") + "4 Edge Angle Side COL", false, true, 0.0, shoreTypesToShores, md, uag, vl, i, j, ml, 5.0, 4);
            }
            for (count = 0; waters.size() >= 3 && count < 15; ++count) {
                int which = (int)(Math.random() * 6.0);
                if (which == 0) {
                    MapLogic.checkAnyNumSidesAddCoast(waters, "Isometric Region/Shore " + (isRocky ? "Rocky " : "") + "Angle Angle Side COL", false, true, 0.0, shoreTypesToShores, md, uag, vl, i, j, ml, 0.0, 3);
                }
                if (which == 1) {
                    MapLogic.checkAnyNumSidesAddCoast(waters, "Isometric Region/Shore " + (isRocky ? "Rocky " : "") + "Angle Angle Side COL", false, false, 0.0, shoreTypesToShores, md, uag, vl, i, j, ml, 1.0, 3);
                }
                if (which == 2) {
                    MapLogic.checkAnyNumSidesAddCoast(waters, "Isometric Region/Shore " + (isRocky ? "Rocky " : "") + "Angle Angle Side COL", true, false, 0.0, shoreTypesToShores, md, uag, vl, i, j, ml, 3.0, 3);
                }
                if (which == 3) {
                    MapLogic.checkAnyNumSidesAddCoast(waters, "Isometric Region/Shore " + (isRocky ? "Rocky " : "") + "Angle Angle Side COL", true, true, 0.0, shoreTypesToShores, md, uag, vl, i, j, ml, 4.0, 3);
                }
                if (which == 4) {
                    MapLogic.checkAnyNumSidesAddCoast(waters, "Isometric Region/Shore " + (isRocky ? "Rocky " : "") + "Angle Side Angle COL", Math.random() < 0.5, false, 0.0, shoreTypesToShores, md, uag, vl, i, j, ml, 2.0, 3);
                }
                if (which != 5) continue;
                MapLogic.checkAnyNumSidesAddCoast(waters, "Isometric Region/Shore " + (isRocky ? "Rocky " : "") + "Angle Side Angle COL", Math.random() < 0.5, true, 0.0, shoreTypesToShores, md, uag, vl, i, j, ml, 5.0, 3);
            }
            for (count = 0; waters.size() >= 2 && count < 15; ++count) {
                int which = (int)(Math.random() * 6.0);
                if (which == 0) {
                    MapLogic.checkAnyNumSidesAddCoast(waters, "Isometric Region/Shore " + (isRocky ? "Rocky " : "") + "Angle Side COL", false, true, 0.0, shoreTypesToShores, md, uag, vl, i, j, ml, 0.0, 2);
                }
                if (which == 1) {
                    MapLogic.checkAnyNumSidesAddCoast(waters, "Isometric Region/Shore " + (isRocky ? "Rocky " : "") + "Angle Angle COL", false, Math.random() < 0.5, 0.0, shoreTypesToShores, md, uag, vl, i, j, ml, 1.0, 2);
                }
                if (which == 2) {
                    MapLogic.checkAnyNumSidesAddCoast(waters, "Isometric Region/Shore " + (isRocky ? "Rocky " : "") + "Angle Side COL", false, false, 0.0, shoreTypesToShores, md, uag, vl, i, j, ml, 2.0, 2);
                }
                if (which == 3) {
                    MapLogic.checkAnyNumSidesAddCoast(waters, "Isometric Region/Shore " + (isRocky ? "Rocky " : "") + "Angle Side COL", true, false, 0.0, shoreTypesToShores, md, uag, vl, i, j, ml, 3.0, 2);
                }
                if (which == 4) {
                    MapLogic.checkAnyNumSidesAddCoast(waters, "Isometric Region/Shore " + (isRocky ? "Rocky " : "") + "Angle Angle COL", true, Math.random() < 0.5, 0.0, shoreTypesToShores, md, uag, vl, i, j, ml, 4.0, 2);
                }
                if (which != 5) continue;
                MapLogic.checkAnyNumSidesAddCoast(waters, "Isometric Region/Shore " + (isRocky ? "Rocky " : "") + "Angle Side COL", true, true, 0.0, shoreTypesToShores, md, uag, vl, i, j, ml, 5.0, 2);
            }
            if (waters.contains(0.0)) {
                MapLogic.addSingleIsoCoastToTile(md, uag, vl, i, j, ml, Math.random() < 0.5, true, 0.0, "Isometric Region/Shore " + (isRocky ? "Rocky " : "") + "Side COL", 100.0, shoreTypesToShores);
            }
            if (waters.contains(1.0)) {
                MapLogic.addSingleIsoCoastToTile(md, uag, vl, i, j, ml, false, true, 0.0, "Isometric Region/Shore " + (isRocky ? "Rocky " : "") + "Angle COL", 100.0, shoreTypesToShores);
            }
            if (waters.contains(2.0)) {
                MapLogic.addSingleIsoCoastToTile(md, uag, vl, i, j, ml, false, false, 0.0, "Isometric Region/Shore " + (isRocky ? "Rocky " : "") + "Angle COL", 100.0, shoreTypesToShores);
            }
            if (waters.contains(3.0)) {
                MapLogic.addSingleIsoCoastToTile(md, uag, vl, i, j, ml, Math.random() < 0.5, false, 0.0, "Isometric Region/Shore " + (isRocky ? "Rocky " : "") + "Side COL", 100.0, shoreTypesToShores);
            }
            if (waters.contains(4.0)) {
                MapLogic.addSingleIsoCoastToTile(md, uag, vl, i, j, ml, true, false, 0.0, "Isometric Region/Shore " + (isRocky ? "Rocky " : "") + "Angle COL", 100.0, shoreTypesToShores);
            }
            if (waters.contains(5.0)) {
                MapLogic.addSingleIsoCoastToTile(md, uag, vl, i, j, ml, true, true, 0.0, "Isometric Region/Shore " + (isRocky ? "Rocky " : "") + "Angle COL", 100.0, shoreTypesToShores);
            }
        } else {
            int count;
            ArrayList<Double> waters = new ArrayList<Double>();
            for (Integer index : adjacentTerrain.keySet()) {
                if (!adjacentTerrain.get(index).getTypeName().toLowerCase().contains("water")) continue;
                waters.add((double)index.intValue() * 1.0);
            }
            for (count = 0; waters.size() >= 5 && count < 10; ++count) {
                int which = (int)(Math.random() * 6.0);
                if (which == 0) {
                    MapLogic.checkAnyNumSidesAddCoast(waters, "Isometric Region/Shore " + (isRocky ? "Rocky " : "") + "5 Edge Angle ROW", true, false, 0.0, shoreTypesToShores, md, uag, vl, i, j, ml, 1.0, 5);
                }
                if (which == 1) {
                    MapLogic.checkAnyNumSidesAddCoast(waters, "Isometric Region/Shore " + (isRocky ? "Rocky " : "") + "5 Edge Side ROW", true, Math.random() < 0.5, 0.0, shoreTypesToShores, md, uag, vl, i, j, ml, 2.0, 5);
                }
                if (which == 2) {
                    MapLogic.checkAnyNumSidesAddCoast(waters, "Isometric Region/Shore " + (isRocky ? "Rocky " : "") + "5 Edge Angle ROW", true, true, 0.0, shoreTypesToShores, md, uag, vl, i, j, ml, 3.0, 5);
                }
                if (which == 3) {
                    MapLogic.checkAnyNumSidesAddCoast(waters, "Isometric Region/Shore " + (isRocky ? "Rocky " : "") + "5 Edge Angle ROW", false, true, 0.0, shoreTypesToShores, md, uag, vl, i, j, ml, 4.0, 5);
                }
                if (which == 4) {
                    MapLogic.checkAnyNumSidesAddCoast(waters, "Isometric Region/Shore " + (isRocky ? "Rocky " : "") + "5 Edge Side ROW", false, Math.random() < 0.5, 0.0, shoreTypesToShores, md, uag, vl, i, j, ml, 5.0, 5);
                }
                if (which != 5) continue;
                MapLogic.checkAnyNumSidesAddCoast(waters, "Isometric Region/Shore " + (isRocky ? "Rocky " : "") + "5 Edge Angle ROW", false, false, 0.0, shoreTypesToShores, md, uag, vl, i, j, ml, 0.0, 5);
            }
            for (count = 0; waters.size() >= 4 && count < 10; ++count) {
                int which = (int)(Math.random() * 6.0);
                if (which == 0) {
                    MapLogic.checkAnyNumSidesAddCoast(waters, "Isometric Region/Shore " + (isRocky ? "Rocky " : "") + "4 Edge Angle Angle ROW", Math.random() < 0.5, false, 0.0, shoreTypesToShores, md, uag, vl, i, j, ml, 1.0, 4);
                }
                if (which == 1) {
                    MapLogic.checkAnyNumSidesAddCoast(waters, "Isometric Region/Shore " + (isRocky ? "Rocky " : "") + "4 Edge Angle Side ROW", true, false, 0.0, shoreTypesToShores, md, uag, vl, i, j, ml, 2.0, 4);
                }
                if (which == 2) {
                    MapLogic.checkAnyNumSidesAddCoast(waters, "Isometric Region/Shore " + (isRocky ? "Rocky " : "") + "4 Edge Angle Side ROW", true, true, 0.0, shoreTypesToShores, md, uag, vl, i, j, ml, 3.0, 4);
                }
                if (which == 3) {
                    MapLogic.checkAnyNumSidesAddCoast(waters, "Isometric Region/Shore " + (isRocky ? "Rocky " : "") + "4 Edge Angle Angle ROW", Math.random() < 0.5, true, 0.0, shoreTypesToShores, md, uag, vl, i, j, ml, 4.0, 4);
                }
                if (which == 4) {
                    MapLogic.checkAnyNumSidesAddCoast(waters, "Isometric Region/Shore " + (isRocky ? "Rocky " : "") + "4 Edge Angle Side ROW", false, true, 0.0, shoreTypesToShores, md, uag, vl, i, j, ml, 5.0, 4);
                }
                if (which != 5) continue;
                MapLogic.checkAnyNumSidesAddCoast(waters, "Isometric Region/Shore " + (isRocky ? "Rocky " : "") + "4 Edge Angle Side ROW", false, false, 0.0, shoreTypesToShores, md, uag, vl, i, j, ml, 0.0, 4);
            }
            for (count = 0; waters.size() >= 3 && count < 15; ++count) {
                int which = (int)(Math.random() * 6.0);
                if (which == 0) {
                    MapLogic.checkAnyNumSidesAddCoast(waters, "Isometric Region/Shore " + (isRocky ? "Rocky " : "") + "Angle Angle Side ROW", false, false, 0.0, shoreTypesToShores, md, uag, vl, i, j, ml, 1.0, 3);
                }
                if (which == 1) {
                    MapLogic.checkAnyNumSidesAddCoast(waters, "Isometric Region/Shore " + (isRocky ? "Rocky " : "") + "Angle Angle Side ROW", true, false, 0.0, shoreTypesToShores, md, uag, vl, i, j, ml, 2.0, 3);
                }
                if (which == 2) {
                    MapLogic.checkAnyNumSidesAddCoast(waters, "Isometric Region/Shore " + (isRocky ? "Rocky " : "") + "Angle Side Angle ROW", true, false, 0.0, shoreTypesToShores, md, uag, vl, i, j, ml, 3.0, 3);
                }
                if (which == 3) {
                    MapLogic.checkAnyNumSidesAddCoast(waters, "Isometric Region/Shore " + (isRocky ? "Rocky " : "") + "Angle Angle Side ROW", true, true, 0.0, shoreTypesToShores, md, uag, vl, i, j, ml, 4.0, 3);
                }
                if (which == 4) {
                    MapLogic.checkAnyNumSidesAddCoast(waters, "Isometric Region/Shore " + (isRocky ? "Rocky " : "") + "Angle Angle Side ROW", false, true, 0.0, shoreTypesToShores, md, uag, vl, i, j, ml, 5.0, 3);
                }
                if (which != 5) continue;
                MapLogic.checkAnyNumSidesAddCoast(waters, "Isometric Region/Shore " + (isRocky ? "Rocky " : "") + "Angle Side Angle ROW", false, true, 0.0, shoreTypesToShores, md, uag, vl, i, j, ml, 0.0, 3);
            }
            for (count = 0; waters.size() >= 2 && count < 15; ++count) {
                int which = (int)(Math.random() * 6.0);
                if (which == 0) {
                    MapLogic.checkAnyNumSidesAddCoast(waters, "Isometric Region/Shore " + (isRocky ? "Rocky " : "") + "Side Angle ROW", false, true, 0.0, shoreTypesToShores, md, uag, vl, i, j, ml, 0.0, 2);
                }
                if (which == 1) {
                    MapLogic.checkAnyNumSidesAddCoast(waters, "Isometric Region/Shore " + (isRocky ? "Rocky " : "") + "Side Angle ROW", false, false, 0.0, shoreTypesToShores, md, uag, vl, i, j, ml, 1.0, 2);
                }
                if (which == 2) {
                    MapLogic.checkAnyNumSidesAddCoast(waters, "Isometric Region/Shore " + (isRocky ? "Rocky " : "") + "Angle Angle ROW", Math.random() < 0.5, false, 0.0, shoreTypesToShores, md, uag, vl, i, j, ml, 2.0, 2);
                }
                if (which == 3) {
                    MapLogic.checkAnyNumSidesAddCoast(waters, "Isometric Region/Shore " + (isRocky ? "Rocky " : "") + "Side Angle ROW", true, false, 0.0, shoreTypesToShores, md, uag, vl, i, j, ml, 3.0, 2);
                }
                if (which == 4) {
                    MapLogic.checkAnyNumSidesAddCoast(waters, "Isometric Region/Shore " + (isRocky ? "Rocky " : "") + "Side Angle ROW", true, true, 0.0, shoreTypesToShores, md, uag, vl, i, j, ml, 4.0, 2);
                }
                if (which != 5) continue;
                MapLogic.checkAnyNumSidesAddCoast(waters, "Isometric Region/Shore " + (isRocky ? "Rocky " : "") + "Angle Angle ROW", Math.random() < 0.5, true, 0.0, shoreTypesToShores, md, uag, vl, i, j, ml, 5.0, 2);
            }
            if (waters.contains(0.0)) {
                MapLogic.addSingleIsoCoastToTile(md, uag, vl, i, j, ml, false, true, 0.0, "Isometric Region/Shore " + (isRocky ? "Rocky " : "") + "Angle ROW", 100.0, shoreTypesToShores);
            }
            if (waters.contains(1.0)) {
                MapLogic.addSingleIsoCoastToTile(md, uag, vl, i, j, ml, false, Math.random() < 0.5, 0.0, "Isometric Region/Shore " + (isRocky ? "Rocky " : "") + "Side ROW", 100.0, shoreTypesToShores);
            }
            if (waters.contains(2.0)) {
                MapLogic.addSingleIsoCoastToTile(md, uag, vl, i, j, ml, false, false, 0.0, "Isometric Region/Shore " + (isRocky ? "Rocky " : "") + "Angle ROW", 100.0, shoreTypesToShores);
            }
            if (waters.contains(3.0)) {
                MapLogic.addSingleIsoCoastToTile(md, uag, vl, i, j, ml, true, false, 0.0, "Isometric Region/Shore " + (isRocky ? "Rocky " : "") + "Angle ROW", 100.0, shoreTypesToShores);
            }
            if (waters.contains(4.0)) {
                MapLogic.addSingleIsoCoastToTile(md, uag, vl, i, j, ml, true, Math.random() < 0.5, 0.0, "Isometric Region/Shore " + (isRocky ? "Rocky " : "") + "Side ROW", 100.0, shoreTypesToShores);
            }
            if (waters.contains(5.0)) {
                MapLogic.addSingleIsoCoastToTile(md, uag, vl, i, j, ml, true, true, 0.0, "Isometric Region/Shore " + (isRocky ? "Rocky " : "") + "Angle ROW", 100.0, shoreTypesToShores);
            }
        }
    }

    private static void checkAnyNumSidesAddCoast(List<Double> waters, String fname, boolean hflip, boolean vflip, double rotate, Map<String, List<String>> shoreTypesToShores, MapData md, UndoActionGroup uag, ViewLevel vl, int i, int j, MapLayer ml, double firstwater, int sidescount) {
        if (shoreTypesToShores.get(fname.toLowerCase()) == null || shoreTypesToShores.get(fname.toLowerCase()).size() == 0) {
            return;
        }
        boolean isValid = true;
        for (int k = 0; k < sidescount; ++k) {
            if (waters.contains((firstwater + (double)k) % 6.0)) continue;
            isValid = false;
            break;
        }
        if (isValid) {
            int scale = md.getTileOrientation() == HexOrientation.COLUMNS ? 100 : 115;
            MapLogic.addSingleIsoCoastToTile(md, uag, vl, i, j, ml, hflip, vflip, rotate, fname, scale, shoreTypesToShores);
            for (int k = 0; k < sidescount; ++k) {
                waters.remove((firstwater + (double)k) % 6.0);
            }
        }
    }

    private static void addSingleIsoCoastToTile(MapData md, UndoActionGroup uag, ViewLevel vl, int i, int j, MapLayer ml, boolean hflip, boolean vflip, double rotate, String fname, double scale, Map<String, List<String>> shoreTypesToShores) {
        List<String> possibleShores = shoreTypesToShores.get(fname.toLowerCase());
        String shore = possibleShores.get((int)(Math.random() * (double)possibleShores.size()));
        if (!shore.startsWith(" Isometric")) {
            scale *= 1.025;
        }
        Feature coast = new Feature(shore, false, false, false, false, null, rotate, null, scale, -1.0, hflip, vflip, null, "coast", vl == ViewLevel.WORLD, vl == ViewLevel.CONTINENT, vl == ViewLevel.KINGDOM, vl == ViewLevel.PROVINCE, ml);
        double locx = i * 300 * 3 / 4 + 150;
        double locy = (double)(j * 300 + (i % 2 == 0 ? 0 : 150)) + 149.9 + Math.random() * 0.2;
        if (md.getTileOrientation() == HexOrientation.ROWS) {
            locx = i * 300 + (j % 2 == 0 ? 0 : 150) + 150;
            locy = (double)(j * 300 * 3 / 4) + 149.9 + Math.random() * 0.2;
        }
        md.addNewFeature(vl, uag, coast, locx, locy);
    }

    public static void addCoastlineToTile(UndoActionGroup uag, MapData md, List<MapShape> mapshapes, int i, int j, int averagewidth, ViewLevel vl, MapLayer ml, boolean changeToSea) {
        Terrain[][] terrain = md.getTerrain(vl);
        HexOrientation ho = md.getTileOrientation();
        boolean wascoast = false;
        if (averagewidth < 7) {
            averagewidth = 7;
        }
        TreeMap<String, MapShape> coastsByCoord = new TreeMap<String, MapShape>();
        block0: for (MapShape ms1 : mapshapes) {
            String[] tags;
            for (String tag : tags = ms1.getTags().split(" ")) {
                if (!tag.startsWith("Grid:")) continue;
                coastsByCoord.put(tag, ms1);
                continue block0;
            }
        }
        if (terrain[i][j].getTypeName().toLowerCase().contains("water")) {
            String tname;
            Map<Integer, Terrain> adjacentTerrain = MapLogic.getAdjTerrainByDirections(terrain, ho, i, j);
            double x = i * 300 * 3 / 4 + 150;
            double y = (double)(j * 300 + (i % 2 == 0 ? 0 : 150)) + 149.9 + Math.random() * 0.2;
            if (ho == HexOrientation.COLUMNS) {
                MapShape swnms;
                Point sw;
                double randommidy2;
                double randommidx2;
                double distance2;
                double edge1y2;
                MapShape ms;
                List<Point2D> pts;
                MapShape senms;
                List<Point2D> pts2;
                MapShape nsms;
                Point n;
                double ltpty;
                double ltptx;
                double rtptx;
                double rtpt;
                double randommidy;
                double randommidx;
                double distance;
                double edge1y;
                double edge1x;
                double random;
                double randommidy22;
                List<Point2D> pts3;
                double randommidy3;
                double randommidx3;
                Terrain north = adjacentTerrain.get(0);
                Terrain northeast = adjacentTerrain.get(1);
                Terrain southeast = adjacentTerrain.get(2);
                Terrain south = adjacentTerrain.get(3);
                Terrain southwest = adjacentTerrain.get(4);
                Terrain northwest = adjacentTerrain.get(5);
                if (MapLogic.isTerrainLand(north)) {
                    MapShape ms2;
                    MapShape nenwms;
                    Point ne;
                    List<Point2D> pts4;
                    MapShape nwnems;
                    randommidx3 = -75.0 + Math.random() * 150.0;
                    randommidy3 = -125.0 + Math.random() * 250.0 * (double)averagewidth / 150.0;
                    double ltpt = 1.0 - Math.random() * (double)averagewidth / 150.0;
                    double ltptx2 = ltpt * 75.0 - 150.0;
                    double ltpty2 = ltpt * -150.0;
                    double rtpt2 = 1.0 - Math.random() * (double)averagewidth / 150.0;
                    double rtptx2 = 150.0 - rtpt2 * 75.0;
                    double rtpty = rtpt2 * -150.0;
                    Point nw = MapLogic.getAdjTerrainCoordByDirections(terrain, ho, i, j, 5);
                    if (nw != null && (nwnems = (MapShape)coastsByCoord.get("Grid:" + (int)nw.getX() + "," + (int)nw.getY() + "NE")) != null && (pts4 = nwnems.getShapePoints()).size() > 3) {
                        ltptx2 = pts4.get(pts4.size() - 3).getX() - x;
                        ltpty2 = pts4.get(pts4.size() - 3).getY() - y;
                    }
                    if ((ne = MapLogic.getAdjTerrainCoordByDirections(terrain, ho, i, j, 1)) != null && (nenwms = (MapShape)coastsByCoord.get("Grid:" + (int)ne.getX() + "," + (int)ne.getY() + "NW")) != null && (pts3 = nenwms.getShapePoints()).size() > 3) {
                        rtptx2 = pts3.get(2).getX() - x;
                        rtpty = pts3.get(2).getY() - y;
                    }
                    if (Math.random() < 0.6) {
                        ms2 = MapLogic.createCoast(mapshapes, x, y, -112.5, -225.0, -75.0, -150.0, ltptx2, ltpty2, randommidx3, randommidy3, rtptx2, rtpty, 75.0, -150.0, 112.5, -225.0, null, north, 10, vl, ml, "Grid:" + i + "," + j + "N");
                    } else {
                        randommidx3 = -75.0 + Math.random() * 75.0;
                        double randommidx22 = Math.random() * 75.0;
                        randommidy22 = -125.0 + Math.random() * 250.0 * (double)averagewidth / 150.0;
                        ms2 = MapLogic.createCoast(mapshapes, x, y, -112.5, -225.0, -75.0, -150.0, ltptx2, ltpty2, randommidx3, randommidy3, randommidx22, randommidy22, rtptx2, rtpty, 75.0, -150.0, 112.5, -225.0, null, north, 6, vl, ml, "Grid:" + i + "," + j + "N");
                    }
                    uag.addAction(new UndoAction(UndoAction.Action.ADD, UndoAction.Thing.MAP_SHAPE, ms2, null, null, null, null, null));
                    wascoast = true;
                }
                if (MapLogic.isTerrainLand(northeast)) {
                    Point se;
                    random = Math.random();
                    edge1x = 75.0 + random * 75.0;
                    edge1y = -150.0 + random * 150.0;
                    distance = Math.random() * 250.0 * (double)averagewidth / 150.0;
                    randommidx = edge1x - distance * 2.0 / 3.0;
                    randommidy = edge1y + distance / 3.0;
                    rtpt = Math.random() * (double)averagewidth / 150.0;
                    rtptx = rtpt * 75.0;
                    double rtpty = -150.0;
                    double ltpt = Math.random() * (double)averagewidth / 150.0;
                    ltptx = 150.0 - ltpt * 75.0;
                    ltpty = ltpt * 150.0;
                    n = MapLogic.getAdjTerrainCoordByDirections(terrain, ho, i, j, 0);
                    if (n != null && (nsms = (MapShape)coastsByCoord.get("Grid:" + (int)n.getX() + "," + (int)n.getY() + "SE")) != null && (pts2 = nsms.getShapePoints()).size() > 3) {
                        rtptx = pts2.get(pts2.size() - 3).getX() - x;
                        rtpty = pts2.get(pts2.size() - 3).getY() - y;
                    }
                    if ((se = MapLogic.getAdjTerrainCoordByDirections(terrain, ho, i, j, 2)) != null && (senms = (MapShape)coastsByCoord.get("Grid:" + (int)se.getX() + "," + (int)se.getY() + "N")) != null && (pts = senms.getShapePoints()).size() > 3) {
                        ltptx = pts.get(2).getX() - x;
                        ltpty = pts.get(2).getY() - y;
                    }
                    if (Math.random() < 0.6) {
                        ms = MapLogic.createCoast(mapshapes, x, y, 112.5, -225.0, 75.0, -150.0, rtptx, rtpty, randommidx, randommidy, ltptx, ltpty, 150.0, 0.0, 200.0, 0.0, null, northeast, 10, vl, ml, "Grid:" + i + "," + j + "NE");
                    } else {
                        distance = Math.random() * 250.0 * (double)averagewidth / 150.0;
                        double edge1x2 = 120.0 + random * 30.0;
                        edge1y2 = -75.0 + random * 75.0;
                        distance2 = Math.random() * 250.0 * (double)averagewidth / 150.0;
                        randommidx2 = edge1x2 - distance2 * 2.0 / 3.0;
                        randommidy2 = edge1y2 + distance2 / 3.0;
                        ms = MapLogic.createCoast(mapshapes, x, y, 112.5, -225.0, 75.0, -150.0, rtptx, rtpty, randommidx, randommidy, randommidx2, randommidy2, ltptx, ltpty, 150.0, 0.0, 200.0, 0.0, null, northeast, 10, vl, ml, "Grid:" + i + "," + j + "NE");
                    }
                    uag.addAction(new UndoAction(UndoAction.Action.ADD, UndoAction.Thing.MAP_SHAPE, ms, null, null, null, null, null));
                    wascoast = true;
                }
                if (MapLogic.isTerrainLand(northwest)) {
                    random = Math.random();
                    edge1x = -75.0 - random * 75.0;
                    edge1y = -150.0 + random * 150.0;
                    distance = Math.random() * 250.0 * (double)averagewidth / 150.0;
                    randommidx = edge1x + distance * 2.0 / 3.0;
                    randommidy = edge1y + distance / 3.0;
                    double ltpt = Math.random() * (double)averagewidth / 150.0;
                    double ltptx3 = ltpt * -75.0;
                    double ltpty3 = -150.0;
                    double rtpt3 = Math.random() * (double)averagewidth / 150.0;
                    double rtptx3 = rtpt3 * 75.0 - 150.0;
                    double rtpty = rtpt3 * 150.0;
                    n = MapLogic.getAdjTerrainCoordByDirections(terrain, ho, i, j, 0);
                    if (n != null && (nsms = (MapShape)coastsByCoord.get("Grid:" + (int)n.getX() + "," + (int)n.getY() + "SW")) != null && (pts2 = nsms.getShapePoints()).size() > 3) {
                        ltptx3 = pts2.get(2).getX() - x;
                        ltpty3 = pts2.get(2).getY() - y;
                    }
                    if ((sw = MapLogic.getAdjTerrainCoordByDirections(terrain, ho, i, j, 4)) != null && (senms = (MapShape)coastsByCoord.get("Grid:" + (int)sw.getX() + "," + (int)sw.getY() + "N")) != null && (pts = senms.getShapePoints()).size() > 3) {
                        rtptx3 = pts.get(pts.size() - 3).getX() - x;
                        rtpty = pts.get(pts.size() - 3).getY() - y;
                    }
                    if (Math.random() < 0.6) {
                        ms = MapLogic.createCoast(mapshapes, x, y, -200.0, 0.0, -150.0, 0.0, rtptx3, rtpty, randommidx, randommidy, ltptx3, ltpty3, -75.0, -150.0, -112.5, -225.0, null, northwest, 5, vl, ml, "Grid:" + i + "," + j + "NW");
                    } else {
                        distance = Math.random() * 250.0 * (double)averagewidth / 150.0;
                        double edge1x2 = -75.0 - random * 30.0;
                        edge1y2 = -75.0 + random * 75.0;
                        distance2 = Math.random() * 250.0 * (double)averagewidth / 150.0;
                        randommidx2 = edge1x2 + distance2 * 2.0 / 3.0;
                        randommidy2 = edge1y2 + distance2 / 3.0;
                        ms = MapLogic.createCoast(mapshapes, x, y, -200.0, 0.0, -150.0, 0.0, rtptx3, rtpty, randommidx, randommidy, randommidx2, randommidy2, ltptx3, ltpty3, -75.0, -150.0, -112.5, -225.0, null, northwest, 5, vl, ml, "Grid:" + i + "," + j + "NW");
                    }
                    uag.addAction(new UndoAction(UndoAction.Action.ADD, UndoAction.Thing.MAP_SHAPE, ms, null, null, null, null, null));
                    wascoast = true;
                }
                if (MapLogic.isTerrainLand(south)) {
                    MapShape ms3;
                    MapShape swnms2;
                    Point sw2;
                    List<Point2D> pts5;
                    MapShape senwms;
                    randommidx3 = -75.0 + Math.random() * 150.0;
                    randommidy3 = 125.0 - Math.random() * (double)averagewidth * 2.0;
                    double rtpt4 = Math.random();
                    double rtptx4 = 150.0 - rtpt4 * 75.0;
                    double rtpty = rtpt4 * 150.0;
                    double ltpt = Math.random();
                    double ltptx4 = -75.0 + ltpt * -75.0;
                    double ltpty4 = 150.0 - ltpt * 150.0;
                    Point se = MapLogic.getAdjTerrainCoordByDirections(terrain, ho, i, j, 2);
                    if (se != null && (senwms = (MapShape)coastsByCoord.get("Grid:" + (int)se.getX() + "," + (int)se.getY() + "SW")) != null && (pts5 = senwms.getShapePoints()).size() > 3) {
                        rtptx4 = pts5.get(pts5.size() - 3).getX() - x;
                        rtpty = pts5.get(pts5.size() - 3).getY() - y;
                    }
                    if ((sw2 = MapLogic.getAdjTerrainCoordByDirections(terrain, ho, i, j, 4)) != null && (swnms2 = (MapShape)coastsByCoord.get("Grid:" + (int)sw2.getX() + "," + (int)sw2.getY() + "SE")) != null && (pts3 = swnms2.getShapePoints()).size() > 3) {
                        ltptx4 = pts3.get(2).getX() - x;
                        ltpty4 = pts3.get(2).getY() - y;
                    }
                    if (Math.random() < 0.6) {
                        ms3 = MapLogic.createCoast(mapshapes, x, y, 112.5, 225.0, 75.0, 150.0, rtptx4, rtpty, randommidx3, randommidy3, ltptx4, ltpty4, -75.0, 150.0, -112.5, 225.0, null, south, 5, vl, ml, "Grid:" + i + "," + j + "S");
                    } else {
                        randommidx3 = Math.random() * 75.0;
                        double randommidx23 = -75.0 + Math.random() * 75.0;
                        randommidy22 = 125.0 - Math.random() * (double)averagewidth * 2.0;
                        ms3 = MapLogic.createCoast(mapshapes, x, y, 112.5, 225.0, 75.0, 150.0, rtptx4, rtpty, randommidx3, randommidy3, randommidx23, randommidy22, ltptx4, ltpty4, -75.0, 150.0, -112.5, 225.0, null, south, 5, vl, ml, "Grid:" + i + "," + j + "S");
                    }
                    uag.addAction(new UndoAction(UndoAction.Action.ADD, UndoAction.Thing.MAP_SHAPE, ms3, null, null, null, null, null));
                    wascoast = true;
                }
                if (MapLogic.isTerrainLand(southeast)) {
                    Point s;
                    MapShape nesms;
                    random = Math.random();
                    edge1x = 75.0 + random * 75.0;
                    edge1y = 150.0 - random * 150.0;
                    distance = Math.random() * 250.0 * (double)averagewidth / 150.0;
                    randommidx = edge1x - distance * 2.0 / 3.0;
                    randommidy = edge1y - distance / 3.0;
                    rtpt = Math.random();
                    rtptx = 150.0 - rtpt * 75.0;
                    double rtpty = rtpt * -150.0;
                    double ltpt = Math.random();
                    ltptx = ltpt * 75.0;
                    ltpty = 150.0;
                    Point ne = MapLogic.getAdjTerrainCoordByDirections(terrain, ho, i, j, 1);
                    if (ne != null && (nesms = (MapShape)coastsByCoord.get("Grid:" + (int)ne.getX() + "," + (int)ne.getY() + "S")) != null && (pts2 = nesms.getShapePoints()).size() > 3) {
                        rtptx = pts2.get(pts2.size() - 3).getX() - x;
                        rtpty = pts2.get(pts2.size() - 3).getY() - y;
                    }
                    if ((s = MapLogic.getAdjTerrainCoordByDirections(terrain, ho, i, j, 3)) != null && (swnms = (MapShape)coastsByCoord.get("Grid:" + (int)s.getX() + "," + (int)s.getY() + "NE")) != null && (pts = swnms.getShapePoints()).size() > 3) {
                        ltptx = pts.get(2).getX() - x;
                        ltpty = pts.get(2).getY() - y;
                    }
                    if (Math.random() < 0.6) {
                        ms = MapLogic.createCoast(mapshapes, x, y, 200.0, 0.0, 150.0, 0.0, rtptx, rtpty, randommidx, randommidy, ltptx, ltpty, 75.0, 150.0, 112.5, 225.0, null, southeast, 5, vl, ml, "Grid:" + i + "," + j + "SE");
                    } else {
                        distance = Math.random() * 250.0 * (double)averagewidth / 150.0;
                        double edge1x2 = 75.0 + random * 30.0;
                        edge1y2 = 75.0 + random * 75.0;
                        distance2 = Math.random() * 250.0 * (double)averagewidth / 150.0;
                        randommidx2 = edge1x2 - distance2 * 2.0 / 3.0;
                        randommidy2 = edge1y2 - distance2 / 3.0;
                        ms = MapLogic.createCoast(mapshapes, x, y, 200.0, 0.0, 150.0, 0.0, rtptx, rtpty, randommidx, randommidy, randommidx2, randommidy2, ltptx, ltpty, 75.0, 150.0, 112.5, 225.0, null, southeast, 5, vl, ml, "Grid:" + i + "," + j + "SE");
                    }
                    uag.addAction(new UndoAction(UndoAction.Action.ADD, UndoAction.Thing.MAP_SHAPE, ms, null, null, null, null, null));
                    wascoast = true;
                }
                if (MapLogic.isTerrainLand(southwest)) {
                    MapShape nwsms;
                    random = Math.random();
                    edge1x = -75.0 - random * 75.0;
                    edge1y = 150.0 - random * 150.0;
                    distance = Math.random() * 250.0 * (double)averagewidth / 150.0;
                    randommidx = edge1x + distance * 2.0 / 3.0;
                    randommidy = edge1y - distance / 3.0;
                    rtpt = Math.random();
                    rtptx = -150.0 + rtpt * 75.0;
                    double rtpty = rtpt * -150.0;
                    double ltpt = Math.random();
                    ltptx = ltpt * 75.0 - 75.0;
                    ltpty = 150.0;
                    Point nw = MapLogic.getAdjTerrainCoordByDirections(terrain, ho, i, j, 0);
                    if (nw != null && (nwsms = (MapShape)coastsByCoord.get("Grid:" + (int)nw.getX() + "," + (int)nw.getY() + "S")) != null && (pts2 = nwsms.getShapePoints()).size() > 3) {
                        rtptx = pts2.get(2).getX() - x;
                        rtpty = pts2.get(2).getY() - y;
                    }
                    if ((sw = MapLogic.getAdjTerrainCoordByDirections(terrain, ho, i, j, 4)) != null && (swnms = (MapShape)coastsByCoord.get("Grid:" + (int)sw.getX() + "," + (int)sw.getY() + "NW")) != null && (pts = swnms.getShapePoints()).size() > 3) {
                        ltptx = pts.get(pts.size() - 3).getX() - x;
                        ltpty = pts.get(pts.size() - 3).getY() - y;
                    }
                    if (Math.random() < 0.6) {
                        ms = MapLogic.createCoast(mapshapes, x, y, -112.5, 225.0, -75.0, 150.0, ltptx, ltpty, randommidx, randommidy, rtptx, rtpty, -150.0, 0.0, -200.0, 0.0, null, southwest, 5, vl, ml, "Grid:" + i + "," + j + "SW");
                    } else {
                        distance = Math.random() * 250.0 * (double)averagewidth / 150.0;
                        double edge1x2 = -150.0 + random * 30.0;
                        edge1y2 = random * 75.0;
                        distance2 = Math.random() * 250.0 * (double)averagewidth / 150.0;
                        randommidx2 = edge1x2 + distance2 * 2.0 / 3.0;
                        randommidy2 = edge1y2 - distance2 / 3.0;
                        ms = MapLogic.createCoast(mapshapes, x, y, -112.5, 225.0, -75.0, 150.0, ltptx, ltpty, randommidx, randommidy, randommidx2, randommidy2, rtptx, rtpty, -150.0, 0.0, -200.0, 0.0, null, southwest, 5, vl, ml, "Grid:" + i + "," + j + "SW");
                    }
                    uag.addAction(new UndoAction(UndoAction.Action.ADD, UndoAction.Thing.MAP_SHAPE, ms, null, null, null, null, null));
                    wascoast = true;
                }
            } else {
                double rtptx;
                double ltptx;
                double ltpt;
                double randommidy2;
                double randommidx2;
                double distance2;
                double edge1y2;
                MapShape ms;
                List<Point2D> pts;
                double randommidy;
                double randommidx;
                double distance;
                double edge1y;
                double edge1x;
                double random;
                double randommidy23;
                MapShape ms4;
                List<Point2D> pts6;
                double rtpty;
                double rtptx5;
                double rtpt;
                double ltpty;
                double ltptx5;
                double ltpt2;
                double randommidy4;
                double randommidx4;
                x = i * 300 + (j % 2 == 0 ? 0 : 150) + 150;
                y = j * 300 * 3 / 4 + 150;
                Terrain northeast = adjacentTerrain.get(0);
                Terrain east = adjacentTerrain.get(1);
                Terrain southeast = adjacentTerrain.get(2);
                Terrain southwest = adjacentTerrain.get(3);
                Terrain west = adjacentTerrain.get(4);
                Terrain northwest = adjacentTerrain.get(5);
                if (MapLogic.isTerrainLand(west)) {
                    List<Point2D> pts7;
                    MapShape nenwms;
                    Point sw;
                    MapShape nwswms;
                    randommidx4 = -125.0 + Math.random() * (double)averagewidth * 2.0;
                    randommidy4 = -75.0 + Math.random() * 150.0;
                    ltpt2 = 1.0 - Math.random() * (double)averagewidth / 150.0;
                    ltptx5 = -ltpt2 * 150.0;
                    ltpty = ltpt2 * 75.0 - 150.0;
                    rtpt = 1.0 - Math.random() * (double)averagewidth / 150.0;
                    rtptx5 = -rtpt * 150.0;
                    rtpty = 150.0 - rtpt * 75.0;
                    Point nw = MapLogic.getAdjTerrainCoordByDirections(terrain, ho, i, j, 5);
                    if (nw != null && (nwswms = (MapShape)coastsByCoord.get("Grid:" + (int)nw.getX() + "," + (int)nw.getY() + "SW")) != null && (pts6 = nwswms.getShapePoints()).size() > 3) {
                        ltptx5 = pts6.get(pts6.size() - 3).getX() - x;
                        ltpty = pts6.get(pts6.size() - 3).getY() - y;
                    }
                    if ((sw = MapLogic.getAdjTerrainCoordByDirections(terrain, ho, i, j, 3)) != null && (nenwms = (MapShape)coastsByCoord.get("Grid:" + (int)sw.getX() + "," + (int)sw.getY() + "NW")) != null && (pts7 = nenwms.getShapePoints()).size() > 3) {
                        rtptx5 = pts7.get(2).getX() - x;
                        rtpty = pts7.get(2).getY() - y;
                    }
                    if (Math.random() < 0.6) {
                        ms4 = MapLogic.createCoast(mapshapes, x, y, -225.0, -112.5, -150.0, -75.0, ltptx5, ltpty, randommidx4, randommidy4, rtptx5, rtpty, -150.0, 75.0, -225.0, 112.5, null, west, 10, vl, ml, "Grid:" + i + "," + j + "W");
                    } else {
                        randommidy4 = -(Math.random() * 75.0);
                        double randommidx24 = -125.0 + Math.random() * (double)averagewidth * 2.0;
                        randommidy23 = Math.random() * 75.0;
                        ms4 = MapLogic.createCoast(mapshapes, x, y, -225.0, -112.5, -150.0, -75.0, ltptx5, ltpty, randommidx4, randommidy4, randommidx24, randommidy23, rtptx5, rtpty, -150.0, 75.0, -225.0, 112.5, null, west, 10, vl, ml, "Grid:" + i + "," + j + "W");
                    }
                    uag.addAction(new UndoAction(UndoAction.Action.ADD, UndoAction.Thing.MAP_SHAPE, ms4, null, null, null, null, null));
                    wascoast = true;
                }
                if (MapLogic.isTerrainLand(east)) {
                    List<Point2D> pts8;
                    MapShape senems;
                    Point se;
                    MapShape nenwms;
                    randommidx4 = 125.0 - Math.random() * (double)averagewidth * 2.0;
                    randommidy4 = -75.0 + Math.random() * 150.0;
                    ltpt2 = 1.0 - Math.random() * (double)averagewidth / 150.0;
                    ltptx5 = ltpt2 * 150.0;
                    ltpty = ltpt2 * 75.0 - 150.0;
                    rtpt = 1.0 - Math.random() * (double)averagewidth / 150.0;
                    rtptx5 = rtpt * 150.0;
                    rtpty = 150.0 - rtpt * 75.0;
                    Point ne = MapLogic.getAdjTerrainCoordByDirections(terrain, ho, i, j, 0);
                    if (ne != null && (nenwms = (MapShape)coastsByCoord.get("Grid:" + (int)ne.getX() + "," + (int)ne.getY() + "SE")) != null && (pts6 = nenwms.getShapePoints()).size() > 3) {
                        ltptx5 = pts6.get(2).getX() - x;
                        ltpty = pts6.get(2).getY() - y;
                    }
                    if ((se = MapLogic.getAdjTerrainCoordByDirections(terrain, ho, i, j, 2)) != null && (senems = (MapShape)coastsByCoord.get("Grid:" + (int)se.getX() + "," + (int)se.getY() + "NE")) != null && (pts8 = senems.getShapePoints()).size() > 3) {
                        rtptx5 = pts8.get(pts8.size() - 3).getX() - x;
                        rtpty = pts8.get(pts8.size() - 3).getY() - y;
                    }
                    if (Math.random() < 0.6) {
                        ms4 = MapLogic.createCoast(mapshapes, x, y, 225.0, 112.5, 150.0, 75.0, rtptx5, rtpty, randommidx4, randommidy4, ltptx5, ltpty, 150.0, -75.0, 225.0, -112.5, null, east, 10, vl, ml, "Grid:" + i + "," + j + "E");
                    } else {
                        randommidy4 = Math.random() * 75.0;
                        double randommidx25 = 125.0 - Math.random() * (double)averagewidth * 2.0;
                        randommidy23 = -(Math.random() * 75.0);
                        ms4 = MapLogic.createCoast(mapshapes, x, y, 225.0, 112.5, 150.0, 75.0, rtptx5, rtpty, randommidx4, randommidy4, randommidx25, randommidy23, ltptx5, ltpty, 150.0, -75.0, 225.0, -112.5, null, east, 10, vl, ml, "Grid:" + i + "," + j + "E");
                    }
                    uag.addAction(new UndoAction(UndoAction.Action.ADD, UndoAction.Thing.MAP_SHAPE, ms4, null, null, null, null, null));
                    wascoast = true;
                }
                if (MapLogic.isTerrainLand(northeast)) {
                    List<Point2D> pts9;
                    MapShape senwms;
                    Point se;
                    MapShape nwems;
                    random = Math.random();
                    edge1x = 150.0 - random * 150.0;
                    edge1y = -75.0 - random * 75.0;
                    distance = Math.random() * 250.0 * (double)averagewidth / 150.0;
                    randommidx = edge1x - distance / 3.0;
                    randommidy = edge1y + distance * 2.0 / 3.0;
                    double rtpt5 = 1.0 - Math.random() * (double)averagewidth / 150.0;
                    double rtptx6 = 150.0;
                    double rtpty2 = -(rtpt5 * 75.0);
                    double ltpt3 = Math.random() * (double)averagewidth / 150.0;
                    double ltptx6 = -ltpt3 * 150.0;
                    double ltpty5 = -150.0 + ltpt3 * 75.0;
                    Point nw = MapLogic.getAdjTerrainCoordByDirections(terrain, ho, i, j, 5);
                    if (nw != null && (nwems = (MapShape)coastsByCoord.get("Grid:" + (int)nw.getX() + "," + (int)nw.getY() + "E")) != null && (pts = nwems.getShapePoints()).size() > 3) {
                        ltptx6 = pts.get(2).getX() - x;
                        ltpty5 = pts.get(2).getY() - y;
                    }
                    if ((se = MapLogic.getAdjTerrainCoordByDirections(terrain, ho, i, j, 1)) != null && (senwms = (MapShape)coastsByCoord.get("Grid:" + (int)se.getX() + "," + (int)se.getY() + "NW")) != null && (pts9 = senwms.getShapePoints()).size() > 3) {
                        rtptx6 = pts9.get(pts9.size() - 3).getX() - x;
                        rtpty2 = pts9.get(pts9.size() - 3).getY() - y;
                    }
                    if (Math.random() < 0.6) {
                        ms = MapLogic.createCoast(mapshapes, x, y, 225.0, -112.5, 150.0, -75.0, rtptx6, rtpty2, randommidx, randommidy, ltptx6, ltpty5, 0.0, -150.0, 0.0, -225.0, null, northeast, 10, vl, ml, "Grid:" + i + "," + j + "NE");
                    } else {
                        edge1x = 150.0 - random * 75.0;
                        edge1y = -75.0 - random * 30.0;
                        distance = Math.random() * 250.0 * (double)averagewidth / 150.0;
                        double edge1x2 = 75.0 - random * 75.0;
                        edge1y2 = -120.0 - random * 30.0;
                        distance2 = Math.random() * 250.0 * (double)averagewidth / 150.0;
                        randommidx = edge1x - distance / 3.0;
                        randommidy = edge1y + distance * 2.0 / 3.0;
                        randommidx2 = edge1x2 - distance2 / 3.0;
                        randommidy2 = edge1y2 + distance2 * 2.0 / 3.0;
                        ms = MapLogic.createCoast(mapshapes, x, y, 225.0, -112.5, 150.0, -75.0, rtptx6, rtpty2, randommidx, randommidy, randommidx2, randommidy2, ltptx6, ltpty5, 0.0, -150.0, 0.0, -225.0, null, northeast, 10, vl, ml, "Grid:" + i + "," + j + "NE");
                    }
                    uag.addAction(new UndoAction(UndoAction.Action.ADD, UndoAction.Thing.MAP_SHAPE, ms, null, null, null, null, null));
                    wascoast = true;
                }
                if (MapLogic.isTerrainLand(southeast)) {
                    List<Point2D> pts10;
                    MapShape eswms;
                    Point e;
                    MapShape swems;
                    random = Math.random();
                    edge1x = 150.0 - random * 150.0;
                    edge1y = 75.0 + random * 75.0;
                    distance = Math.random() * 250.0 * (double)averagewidth / 150.0;
                    randommidx = edge1x - distance / 3.0;
                    randommidy = edge1y - distance * 2.0 / 3.0;
                    ltpt = Math.random() * (double)averagewidth / 150.0;
                    ltptx = -ltpt * 150.0;
                    double ltpty6 = 150.0 - ltpt * 75.0;
                    double rtpt6 = 1.0 - Math.random() * (double)averagewidth / 150.0;
                    rtptx = 150.0;
                    double rtpty3 = rtpt6 * 75.0;
                    Point sw = MapLogic.getAdjTerrainCoordByDirections(terrain, ho, i, j, 3);
                    if (sw != null && (swems = (MapShape)coastsByCoord.get("Grid:" + (int)sw.getX() + "," + (int)sw.getY() + "E")) != null && (pts = swems.getShapePoints()).size() > 3) {
                        ltptx = pts.get(pts.size() - 3).getX() - x;
                        ltpty6 = pts.get(pts.size() - 3).getY() - y;
                    }
                    if ((e = MapLogic.getAdjTerrainCoordByDirections(terrain, ho, i, j, 1)) != null && (eswms = (MapShape)coastsByCoord.get("Grid:" + (int)e.getX() + "," + (int)e.getY() + "SW")) != null && (pts10 = eswms.getShapePoints()).size() > 3) {
                        rtptx = pts10.get(2).getX() - x;
                        rtpty3 = pts10.get(2).getY() - y;
                    }
                    if (Math.random() < 0.6) {
                        ms = MapLogic.createCoast(mapshapes, x, y, 0.0, 225.0, 0.0, 150.0, ltptx, ltpty6, randommidx, randommidy, rtptx, rtpty3, 150.0, 75.0, 225.0, 112.5, null, southeast, 10, vl, ml, "Grid:" + i + "," + j + "SE");
                    } else {
                        edge1x = random * 75.0;
                        edge1y = 120.0 + random * 30.0;
                        randommidx = edge1x - distance / 3.0;
                        randommidy = edge1y - distance * 2.0 / 3.0;
                        double edge1x2 = 75.0 + random * 75.0;
                        edge1y2 = 75.0 + random * 30.0;
                        distance2 = Math.random() * 250.0 * (double)averagewidth / 150.0;
                        randommidx2 = edge1x2 - distance2 / 3.0;
                        randommidy2 = edge1y2 - distance2 * 2.0 / 3.0;
                        ms = MapLogic.createCoast(mapshapes, x, y, 0.0, 225.0, 0.0, 150.0, ltptx, ltpty6, randommidx, randommidy, randommidx2, randommidy2, rtptx, rtpty3, 150.0, 75.0, 225.0, 112.5, null, southeast, 10, vl, ml, "Grid:" + i + "," + j + "SE");
                    }
                    uag.addAction(new UndoAction(UndoAction.Action.ADD, UndoAction.Thing.MAP_SHAPE, ms, null, null, null, null, null));
                    wascoast = true;
                }
                if (MapLogic.isTerrainLand(southwest)) {
                    MapShape ms5;
                    List<Point2D> pts11;
                    MapShape swems;
                    Point w;
                    List<Point2D> pts12;
                    MapShape swnwms;
                    double edge1x2 = -Math.random() * 150.0;
                    double edge1y3 = 75.0 + Math.random() * 75.0;
                    double distance3 = Math.random() * 250.0 * (double)averagewidth / 150.0;
                    double randommidx5 = edge1x2 + distance3 / 3.0;
                    double randommidy5 = edge1y3 - distance3 * 2.0 / 3.0;
                    double ltpt4 = Math.random() * (double)averagewidth / 150.0;
                    double ltptx7 = ltpt4 * 150.0;
                    double ltpty7 = 150.0 - ltpt4 * 75.0;
                    double rtpt7 = 1.0 - Math.random() * (double)averagewidth / 150.0;
                    double rtptx7 = -150.0;
                    double rtpty4 = rtpt7 * 75.0;
                    Point sw = MapLogic.getAdjTerrainCoordByDirections(terrain, ho, i, j, 2);
                    if (sw != null && (swnwms = (MapShape)coastsByCoord.get("Grid:" + (int)sw.getX() + "," + (int)sw.getY() + "W")) != null && (pts12 = swnwms.getShapePoints()).size() > 3) {
                        ltptx7 = pts12.get(2).getX() - x;
                        ltpty7 = pts12.get(2).getY() - y;
                    }
                    if ((w = MapLogic.getAdjTerrainCoordByDirections(terrain, ho, i, j, 4)) != null && (swems = (MapShape)coastsByCoord.get("Grid:" + (int)w.getX() + "," + (int)w.getY() + "SE")) != null && (pts11 = swems.getShapePoints()).size() > 3) {
                        rtptx7 = pts11.get(pts11.size() - 3).getX() - x;
                        rtpty4 = pts11.get(pts11.size() - 3).getY() - y;
                    }
                    if (Math.random() < 0.6) {
                        ms5 = MapLogic.createCoast(mapshapes, x, y, -225.0, 112.5, -150.0, 75.0, rtptx7, rtpty4, randommidx5, randommidy5, ltptx7, ltpty7, 0.0, 150.0, 0.0, 225.0, null, southwest, 10, vl, ml, "Grid:" + i + "," + j + "SW");
                    } else {
                        edge1x2 = -Math.random() * 75.0 - 75.0;
                        edge1y3 = 75.0 + Math.random() * 30.0;
                        distance3 = Math.random() * 250.0 * (double)averagewidth / 150.0;
                        randommidx5 = edge1x2 + distance3 / 3.0;
                        randommidy5 = edge1y3 - distance3 * 2.0 / 3.0;
                        double edge1x22 = -Math.random() * 75.0;
                        double edge1y22 = 120.0 + Math.random() * 30.0;
                        double distance22 = Math.random() * 250.0 * (double)averagewidth / 150.0;
                        double randommidx26 = edge1x22 + distance22 / 3.0;
                        double randommidy24 = edge1y22 - distance22 * 2.0 / 3.0;
                        ms5 = MapLogic.createCoast(mapshapes, x, y, -225.0, 112.5, -150.0, 75.0, rtptx7, rtpty4, randommidx5, randommidy5, randommidx26, randommidy24, ltptx7, ltpty7, 0.0, 150.0, 0.0, 225.0, null, southwest, 10, vl, ml, "Grid:" + i + "," + j + "SW");
                    }
                    uag.addAction(new UndoAction(UndoAction.Action.ADD, UndoAction.Thing.MAP_SHAPE, ms5, null, null, null, null, null));
                    wascoast = true;
                }
                if (MapLogic.isTerrainLand(northwest)) {
                    List<Point2D> pts13;
                    MapShape newms;
                    Point ne;
                    MapShape wnems;
                    random = Math.random();
                    edge1x = -random * 150.0;
                    edge1y = -75.0 - random * 75.0;
                    distance = Math.random() * 250.0 * (double)averagewidth / 150.0;
                    randommidx = edge1x + distance / 3.0;
                    randommidy = edge1y + distance * 2.0 / 3.0;
                    ltpt = Math.random() * (double)averagewidth / 150.0;
                    ltptx = ltpt * 150.0;
                    double ltpty8 = -150.0 + ltpt * 75.0;
                    double rtpt8 = 1.0 - Math.random() * (double)averagewidth / 150.0;
                    rtptx = -150.0;
                    double rtpty5 = -(rtpt8 * 75.0);
                    Point w = MapLogic.getAdjTerrainCoordByDirections(terrain, ho, i, j, 4);
                    if (w != null && (wnems = (MapShape)coastsByCoord.get("Grid:" + (int)w.getX() + "," + (int)w.getY() + "NE")) != null && (pts = wnems.getShapePoints()).size() > 3) {
                        rtptx = pts.get(2).getX() - x;
                        rtpty5 = pts.get(2).getY() - y;
                    }
                    if ((ne = MapLogic.getAdjTerrainCoordByDirections(terrain, ho, i, j, 0)) != null && (newms = (MapShape)coastsByCoord.get("Grid:" + (int)ne.getX() + "," + (int)ne.getY() + "W")) != null && (pts13 = newms.getShapePoints()).size() > 3) {
                        ltptx = pts13.get(pts13.size() - 3).getX() - x;
                        ltpty8 = pts13.get(pts13.size() - 3).getY() - y;
                    }
                    if (Math.random() < 0.6) {
                        ms = MapLogic.createCoast(mapshapes, x, y, 0.0, -225.0, 0.0, -150.0, ltptx, ltpty8, randommidx, randommidy, rtptx, rtpty5, -150.0, -75.0, -225.0, -112.5, null, northwest, 10, vl, ml, "Grid:" + i + "," + j + "NW");
                    } else {
                        edge1x = -random * 75.0;
                        edge1y = -37.5 - random * 37.5;
                        distance = Math.random() * 250.0 * (double)averagewidth / 150.0;
                        randommidx = edge1x + distance / 3.0;
                        randommidy = edge1y + distance * 2.0 / 3.0;
                        double random2 = Math.random();
                        double edge1x2 = -random2 * 75.0 - 75.0;
                        double edge1y23 = -75.0 - random2 * 37.5;
                        double distance23 = Math.random() * 250.0 * (double)averagewidth / 150.0;
                        double randommidx27 = edge1x2 + distance23 / 3.0;
                        double randommidy25 = edge1y23 + distance23 * 2.0 / 3.0;
                        ms = MapLogic.createCoast(mapshapes, x, y, 0.0, -225.0, 0.0, -150.0, ltptx, ltpty8, randommidx, randommidy, randommidx27, randommidy25, rtptx, rtpty5, -150.0, -75.0, -225.0, -112.5, null, northwest, 10, vl, ml, "Grid:" + i + "," + j + "NW");
                    }
                    uag.addAction(new UndoAction(UndoAction.Action.ADD, UndoAction.Thing.MAP_SHAPE, ms, null, null, null, null, null));
                    wascoast = true;
                }
            }
            if (changeToSea && wascoast && terrain[i][j].getTypeName().endsWith(" Ocean") && Terrain.terrainTypes.containsKey(tname = terrain[i][j].getTypeName().substring(0, terrain[i][j].getTypeName().length() - 5) + "Sea")) {
                ArrayList<Terrain> tl = new ArrayList<Terrain>();
                tl.add(new Terrain(tname, true));
                ((Terrain)tl.get(0)).setIcy(terrain[i][j].isIcy());
                md.changeTerrain(uag, tl, new Point2D((double)i, (double)j), vl, vl, true, terrain[i][j].getBackgroundColor(), terrain[i][j].isGmOnly(), terrain[i][j].isIcy(), false, -1000, null);
            }
        }
    }

    private static MapShape createCoast(List<MapShape> mapshapes, double x, double y, double firstxoffset, double firstyoffset, double startxoffset, double startyoffset, double priorjoinxoffset, double priorjoinyoffset, double midxoffset, double midyoffset, double nextjoinxoffset, double nextjoinyoffset, double endxoffset, double endyoffset, double lastxoffset, double lastyoffset, Point2D extrapt, Terrain t, int numpts, ViewLevel vl, MapLayer ml, String tag) {
        ArrayList<Double> pts = new ArrayList<Double>();
        pts.add(x + firstxoffset);
        pts.add(y + firstyoffset);
        pts.add(x + startxoffset);
        pts.add(y + startyoffset);
        pts.add(x + priorjoinxoffset);
        pts.add(y + priorjoinyoffset);
        pts.addAll(MapLogic.addExtraPointsBetweenTwoPoints(x + priorjoinxoffset, y + priorjoinyoffset, x + midxoffset, y + midyoffset, numpts));
        pts.add(x + midxoffset);
        pts.add(y + midyoffset);
        pts.addAll(MapLogic.addExtraPointsBetweenTwoPoints(x + midxoffset, y + midyoffset, x + nextjoinxoffset, y + nextjoinyoffset, numpts));
        pts.add(x + nextjoinxoffset);
        pts.add(y + nextjoinyoffset);
        pts.add(x + endxoffset);
        pts.add(y + endyoffset);
        pts.add(x + lastxoffset);
        pts.add(y + lastyoffset);
        if (extrapt != null) {
            pts.add(x + extrapt.getX());
            pts.add(y + extrapt.getY());
        }
        Polygon p = new Polygon();
        p.getPoints().addAll(pts);
        MapShape ms = MapLogic.makeCoastPolygon(t, p, vl, ml);
        if (!Objects.equals(tag, "")) {
            ms.setTags(ms.getTags() + " " + tag);
        }
        mapshapes.add(ms);
        return ms;
    }

    private static MapShape createCoast(List<MapShape> mapshapes, double x, double y, double firstxoffset, double firstyoffset, double startxoffset, double startyoffset, double priorjoinxoffset, double priorjoinyoffset, double midxoffset, double midyoffset, double midxoffset2, double midyoffset2, double nextjoinxoffset, double nextjoinyoffset, double endxoffset, double endyoffset, double lastxoffset, double lastyoffset, Point2D extrapt, Terrain t, int numpts, ViewLevel vl, MapLayer ml, String tag) {
        ArrayList<Double> pts = new ArrayList<Double>();
        pts.add(x + firstxoffset);
        pts.add(y + firstyoffset);
        pts.add(x + startxoffset);
        pts.add(y + startyoffset);
        pts.add(x + priorjoinxoffset);
        pts.add(y + priorjoinyoffset);
        pts.addAll(MapLogic.addExtraPointsBetweenTwoPoints(x + priorjoinxoffset, y + priorjoinyoffset, x + midxoffset, y + midyoffset, numpts));
        pts.add(x + midxoffset);
        pts.add(y + midyoffset);
        pts.addAll(MapLogic.addExtraPointsBetweenTwoPoints(x + midxoffset, y + midyoffset, x + midxoffset2, y + midyoffset2, numpts));
        pts.add(x + midxoffset2);
        pts.add(y + midyoffset2);
        pts.addAll(MapLogic.addExtraPointsBetweenTwoPoints(x + midxoffset2, y + midyoffset2, x + nextjoinxoffset, y + nextjoinyoffset, numpts));
        pts.add(x + nextjoinxoffset);
        pts.add(y + nextjoinyoffset);
        pts.add(x + endxoffset);
        pts.add(y + endyoffset);
        pts.add(x + lastxoffset);
        pts.add(y + lastyoffset);
        if (extrapt != null) {
            pts.add(x + extrapt.getX());
            pts.add(y + extrapt.getY());
        }
        Polygon p = new Polygon();
        p.getPoints().addAll(pts);
        MapShape ms = MapLogic.makeCoastPolygon(t, p, vl, ml);
        if (!Objects.equals(tag, "")) {
            ms.setTags(ms.getTags() + " " + tag);
        }
        mapshapes.add(ms);
        return ms;
    }

    public static void nearestNeighborFill(MapUI mapUI, UndoRedoHandler undoRedoHandler, ViewLevel vl, Terrain[][] terrain, boolean addRandomnessToNewTerrain, Shape selectedArea) {
        Terrain[][] terrainorig = new Terrain[terrain.length][terrain[0].length];
        for (int x = 0; x < terrain.length; ++x) {
            for (int y = 0; y < terrain[0].length; ++y) {
                terrainorig[x][y] = new Terrain(terrain[x][y].getTypeName(), true);
            }
        }
        UndoActionGroup uag = new UndoActionGroup();
        undoRedoHandler.push(uag);
        for (int x = 0; x < terrain.length; ++x) {
            for (int y = 0; y < terrain[0].length; ++y) {
                Pair<Double, Double> pair = mapUI.getModelPtFromTerrain(x, y);
                if (selectedArea != null && !selectedArea.contains(new Point2D(((Double)pair.getKey()).doubleValue(), ((Double)pair.getValue()).doubleValue())) || !terrain[x][y].getTypeName().equals("Blank")) continue;
                double closestdistance = Double.MAX_VALUE;
                Terrain t = null;
                for (int xdiff = 0; xdiff < terrain.length; ++xdiff) {
                    for (int ydiff = 0; ydiff < terrain[0].length; ++ydiff) {
                        double tempcd;
                        if (x + xdiff < terrain.length && y + ydiff < terrain[0].length && !terrainorig[x + xdiff][y + ydiff].getTypeName().equals("Blank") && (tempcd = Math.sqrt(xdiff * xdiff + ydiff * ydiff)) < closestdistance) {
                            closestdistance = tempcd;
                            t = terrainorig[x + xdiff][y + ydiff];
                        }
                        if (x - xdiff >= 0 && y - ydiff >= 0 && !terrainorig[x - xdiff][y - ydiff].getTypeName().equals("Blank") && (tempcd = Math.sqrt(xdiff * xdiff + ydiff * ydiff)) < closestdistance) {
                            closestdistance = tempcd;
                            t = terrainorig[x - xdiff][y - ydiff];
                        }
                        if (x + xdiff < terrain.length && y - ydiff >= 0 && !terrainorig[x + xdiff][y - ydiff].getTypeName().equals("Blank") && (tempcd = Math.sqrt(xdiff * xdiff + ydiff * ydiff)) < closestdistance) {
                            closestdistance = tempcd;
                            t = terrainorig[x + xdiff][y - ydiff];
                        }
                        if (x - xdiff < 0 || y + ydiff >= terrain[0].length || terrainorig[x - xdiff][y + ydiff].getTypeName().equals("Blank") || !((tempcd = Math.sqrt(xdiff * xdiff + ydiff * ydiff)) < closestdistance)) continue;
                        closestdistance = tempcd;
                        t = terrainorig[x - xdiff][y + ydiff];
                    }
                }
                if (t == null) continue;
                Terrain oldt = terrain[x][y];
                terrain[x][y] = new Terrain(MapLogic.getNewType(t.getTypeName(), addRandomnessToNewTerrain), true);
                uag.addAction(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.TERRAIN, null, terrain[x][y], oldt, x, y, (Object)vl));
            }
        }
    }

    public static String getNewType(String oldtype, boolean addRandomnessToNewTerrain) {
        TerrainType tt = Terrain.terrainTypes.get(oldtype);
        if (addRandomnessToNewTerrain && tt.getSimilarTerrain() != null && tt.getSimilarTerrain().length > 0 && Math.random() < 0.1) {
            oldtype = tt.getSimilarTerrain()[(int)(Math.random() * (double)tt.getSimilarTerrain().length)];
        }
        if (oldtype.endsWith(" A") || oldtype.endsWith(" B") || oldtype.endsWith(" C") || oldtype.endsWith(" D") || oldtype.endsWith(" E")) {
            String[] suffixes;
            String ot = oldtype.substring(0, oldtype.length() - 2);
            ArrayList<String> types = new ArrayList<String>();
            for (String suf : suffixes = new String[]{" A", " B", " C", " D", " E", " F", " G", " H", " I", " J", " K", " L", " M", " N", " O", " P", " Q", " R", " S", " T", " U", " V", " W", " X", " Y", " Z"}) {
                TerrainType t = Terrain.terrainTypes.get(ot + suf);
                if (t == null) continue;
                types.add(t.getType());
            }
            return (String)types.get((int)(Math.random() * (double)types.size()));
        }
        return oldtype;
    }

    private static MapShape makeCoastPolygon(Terrain t, Polygon p, ViewLevel currentvl, MapLayer ml) {
        p.setStrokeWidth(0.0);
        String texturename = "Grass";
        if (t.getTypeName().startsWith("ISO ")) {
            if (t.getTypeName().toLowerCase().contains("forest") && t.getTypeName().toLowerCase().contains("deciduous")) {
                texturename = "Forest Deciduous";
            } else if (t.getTypeName().toLowerCase().contains("forest") && t.getTypeName().toLowerCase().contains("evergreen")) {
                texturename = "Forest Evergreen";
            } else if (t.getTypeName().toLowerCase().contains("desert") && t.getTypeName().toLowerCase().contains("rocky")) {
                texturename = "Desert Rocky";
            } else if (t.getTypeName().toLowerCase().contains("desert") && t.getTypeName().toLowerCase().contains("cactus")) {
                texturename = "Desert Rocky";
            } else if (t.getTypeName().toLowerCase().contains("desert") && t.getTypeName().toLowerCase().contains("sandy")) {
                texturename = "Desert Sandy";
            } else if (t.getTypeName().toLowerCase().contains("jungle")) {
                texturename = "Jungle";
            } else if (t.getTypeName().toLowerCase().contains("badlands")) {
                texturename = "Badlands";
            } else if (t.getTypeName().toLowerCase().contains("grassland")) {
                texturename = "Grassland";
            } else if (t.getTypeName().toLowerCase().contains("hills")) {
                texturename = "Hills";
            } else if (t.getTypeName().toLowerCase().contains("mountain")) {
                texturename = "Mountain";
            } else if (t.getTypeName().toLowerCase().contains("swamp")) {
                texturename = "Swamp";
            } else if (t.getTypeName().toLowerCase().contains("volcano")) {
                texturename = "Volcano";
            }
            TextureType tt = TextureType.ALL_TEXTURES.get(texturename);
            Image fillicon = tt.getIcon();
            p.setFill((Paint)new ImagePattern(fillicon, 0.0, 0.0, 100.0, 173.0, false));
            MapShape ms = new MapShape(ViewLevel.WORLD, currentvl, (Shape)p, MapShape.CreationType.BASIC, MapShape.StrokeType.SIMPLE, false, "coastline", 0.0, 0.0, 0.0, 0.0, true, true, true, true, ml);
            ms.setFillTexture(TextureType.ALL_TEXTURES.get(tt.getType()));
            return ms;
        }
        if (t.isIcy()) {
            p.setFill((Paint)Color.WHITE);
        } else if (t.getBackgroundColor() != null) {
            p.setFill((Paint)t.getBackgroundColor());
        } else {
            p.setFill((Paint)t.getType().getBgColor());
        }
        MapShape ms = new MapShape(ViewLevel.WORLD, currentvl, (Shape)p, MapShape.CreationType.BASIC, MapShape.StrokeType.SIMPLE, false, "coastline", 0.0, 0.0, 0.0, 0.0, true, true, true, true, ml);
        return ms;
    }

    private static List<Double> addExtraPointsBetweenTwoPoints(double priorx, double priory, double nextx, double nexty, int numtoadd) {
        ArrayList<Double> pts = new ArrayList<Double>();
        double maxadjx = (nextx - priorx) / (double)numtoadd / 2.0;
        double maxadjy = (nexty - priory) / (double)numtoadd / 2.0;
        for (int i = 0; i < numtoadd; ++i) {
            double adjx = Math.random() * maxadjx * 2.0 - maxadjx;
            double adjy = Math.random() * maxadjy * 2.0 - maxadjy;
            pts.add(priorx + (nextx - priorx) / (double)numtoadd * (double)i + adjx);
            pts.add(priory + (nexty - priory) / (double)numtoadd * (double)i + adjy);
        }
        return pts;
    }

    public static Map<Point, Terrain> getAdjTerrainPoint(Terrain[][] terrain, HexOrientation ho, int i, int j) {
        HashMap<Point, Terrain> out = new HashMap<Point, Terrain>();
        if (ho.equals((Object)HexOrientation.ROWS)) {
            if (i > 0) {
                out.put(new Point(i - 1, j), terrain[i - 1][j]);
            }
            if (i + 1 < terrain.length) {
                out.put(new Point(i + 1, j), terrain[i + 1][j]);
            }
            if (j % 2 == 0) {
                if (i > 0 && j > 0) {
                    out.put(new Point(i - 1, j - 1), terrain[i - 1][j - 1]);
                }
                if (j > 0) {
                    out.put(new Point(i, j - 1), terrain[i][j - 1]);
                }
                if (j + 1 < terrain[i].length) {
                    out.put(new Point(i, j + 1), terrain[i][j + 1]);
                }
                if (i > 0 && j + 1 < terrain[i].length) {
                    out.put(new Point(i - 1, j + 1), terrain[i - 1][j + 1]);
                }
            } else {
                if (j > 0) {
                    out.put(new Point(i, j - 1), terrain[i][j - 1]);
                }
                if (i + 1 < terrain.length && j > 0) {
                    out.put(new Point(i + 1, j - 1), terrain[i + 1][j - 1]);
                }
                if (i + 1 < terrain.length && j + 1 < terrain[i].length) {
                    out.put(new Point(i + 1, j + 1), terrain[i + 1][j + 1]);
                }
                if (j + 1 < terrain[i].length) {
                    out.put(new Point(i, j + 1), terrain[i][j + 1]);
                }
            }
        } else {
            if (j > 0) {
                out.put(new Point(i, j - 1), terrain[i][j - 1]);
            }
            if (j + 1 < terrain[i].length) {
                out.put(new Point(i, j + 1), terrain[i][j + 1]);
            }
            if (i % 2 == 0) {
                if (i > 0 && j > 0) {
                    out.put(new Point(i - 1, j - 1), terrain[i - 1][j - 1]);
                }
                if (i > 0) {
                    out.put(new Point(i - 1, j), terrain[i - 1][j]);
                }
                if (i + 1 < terrain.length && j > 0) {
                    out.put(new Point(i + 1, j - 1), terrain[i + 1][j - 1]);
                }
                if (i + 1 < terrain.length) {
                    out.put(new Point(i + 1, j), terrain[i + 1][j]);
                }
            } else {
                if (i > 0) {
                    out.put(new Point(i - 1, j), terrain[i - 1][j]);
                }
                if (i > 0 && j + 1 < terrain[i].length) {
                    out.put(new Point(i - 1, j + 1), terrain[i - 1][j + 1]);
                }
                if (i + 1 < terrain.length) {
                    out.put(new Point(i + 1, j), terrain[i + 1][j]);
                }
                if (i + 1 < terrain.length && j + 1 < terrain[i].length) {
                    out.put(new Point(i + 1, j + 1), terrain[i + 1][j + 1]);
                }
            }
        }
        return out;
    }

    public static Map<Integer, Terrain> getAdjTerrainByDirections(Terrain[][] terrain, HexOrientation ho, int i, int j) {
        HashMap<Integer, Terrain> out = new HashMap<Integer, Terrain>();
        if (ho.equals((Object)HexOrientation.ROWS)) {
            if (i > 0) {
                out.put(4, terrain[i - 1][j]);
            }
            if (i + 1 < terrain.length) {
                out.put(1, terrain[i + 1][j]);
            }
            if (j % 2 == 0) {
                if (i > 0 && j > 0) {
                    out.put(5, terrain[i - 1][j - 1]);
                }
                if (j > 0) {
                    out.put(0, terrain[i][j - 1]);
                }
                if (j + 1 < terrain[i].length) {
                    out.put(2, terrain[i][j + 1]);
                }
                if (i > 0 && j + 1 < terrain[i].length) {
                    out.put(3, terrain[i - 1][j + 1]);
                }
            } else {
                if (j > 0) {
                    out.put(5, terrain[i][j - 1]);
                }
                if (i + 1 < terrain.length && j > 0) {
                    out.put(0, terrain[i + 1][j - 1]);
                }
                if (i + 1 < terrain.length && j + 1 < terrain[i].length) {
                    out.put(2, terrain[i + 1][j + 1]);
                }
                if (j + 1 < terrain[i].length) {
                    out.put(3, terrain[i][j + 1]);
                }
            }
        } else {
            if (j > 0) {
                out.put(0, terrain[i][j - 1]);
            }
            if (j + 1 < terrain[i].length) {
                out.put(3, terrain[i][j + 1]);
            }
            if (i % 2 == 0) {
                if (i > 0 && j > 0) {
                    out.put(5, terrain[i - 1][j - 1]);
                }
                if (i > 0) {
                    out.put(4, terrain[i - 1][j]);
                }
                if (i + 1 < terrain.length && j > 0) {
                    out.put(1, terrain[i + 1][j - 1]);
                }
                if (i + 1 < terrain.length) {
                    out.put(2, terrain[i + 1][j]);
                }
            } else {
                if (i > 0) {
                    out.put(5, terrain[i - 1][j]);
                }
                if (i > 0 && j + 1 < terrain[i].length) {
                    out.put(4, terrain[i - 1][j + 1]);
                }
                if (i + 1 < terrain.length) {
                    out.put(1, terrain[i + 1][j]);
                }
                if (i + 1 < terrain.length && j + 1 < terrain[i].length) {
                    out.put(2, terrain[i + 1][j + 1]);
                }
            }
        }
        return out;
    }

    public static Point getAdjTerrainCoordByDirections(Terrain[][] terrain, HexOrientation ho, int i, int j, int direction) {
        if (ho.equals((Object)HexOrientation.ROWS)) {
            if (i > 0 && direction == 4) {
                return new Point(i - 1, j);
            }
            if (i + 1 < terrain.length && direction == 1) {
                return new Point(i + 1, j);
            }
            if (j % 2 == 0) {
                if (i > 0 && j > 0 && direction == 5) {
                    return new Point(i - 1, j - 1);
                }
                if (j > 0 && direction == 0) {
                    return new Point(i, j - 1);
                }
                if (j + 1 < terrain[i].length && direction == 2) {
                    return new Point(i, j + 1);
                }
                if (i > 0 && j + 1 < terrain[i].length && direction == 3) {
                    return new Point(i - 1, j + 1);
                }
            } else {
                if (j > 0 && direction == 5) {
                    return new Point(i, j - 1);
                }
                if (i + 1 < terrain.length && j > 0 && direction == 0) {
                    return new Point(i + 1, j - 1);
                }
                if (i + 1 < terrain.length && j + 1 < terrain[i].length && direction == 2) {
                    return new Point(i + 1, j + 1);
                }
                if (j + 1 < terrain[i].length && direction == 3) {
                    return new Point(i, j + 1);
                }
            }
        } else {
            if (j > 0 && direction == 0) {
                return new Point(i, j - 1);
            }
            if (j + 1 < terrain[i].length && direction == 3) {
                return new Point(i, j + 1);
            }
            if (i % 2 == 0) {
                if (i > 0 && j > 0 && direction == 5) {
                    return new Point(i - 1, j - 1);
                }
                if (i > 0 && direction == 4) {
                    return new Point(i - 1, j);
                }
                if (i + 1 < terrain.length && j > 0 && direction == 1) {
                    return new Point(i + 1, j - 1);
                }
                if (i + 1 < terrain.length && direction == 2) {
                    return new Point(i + 1, j);
                }
            } else {
                if (i > 0 && direction == 5) {
                    return new Point(i - 1, j);
                }
                if (i > 0 && j + 1 < terrain[i].length && direction == 4) {
                    return new Point(i - 1, j + 1);
                }
                if (i + 1 < terrain.length && direction == 1) {
                    return new Point(i + 1, j);
                }
                if (i + 1 < terrain.length && j + 1 < terrain[i].length && direction == 2) {
                    return new Point(i + 1, j + 1);
                }
            }
        }
        return null;
    }

    public static Pair<Integer, MapLayer> addEmpires(GenerateEmpiresTask empiresTask, Worldographer worldographer, List<Information> nations, ViewLevel vl, MapData mapData, UndoActionGroup uag, int numbertoadd, Color onecolor, boolean fill, Set<Note> notes, int sizeLimit, int distanceBetweenFeatures) {
        Pair newml = null;
        Terrain[][] terrain = mapData.getTerrain(vl);
        int terraintype = 0;
        if (terrain != null && (terrain[0][0].getTypeName().contains("ISO ") || terrain[5][5].getTypeName().contains("ISO "))) {
            terraintype = 1;
        }
        int numempirescount = 0;
        Color[] colors = new Color[]{new Color(1.0, 1.0, 1.0, 1.0), new Color(0.0, 0.0, 0.0, 1.0), new Color(1.0, 0.0, 0.0, 1.0), new Color(0.0, 1.0, 0.0, 1.0), new Color(0.0, 0.0, 1.0, 1.0), new Color(1.0, 1.0, 0.0, 1.0), new Color(0.0, 1.0, 1.0, 1.0), new Color(1.0, 0.0, 1.0, 1.0), new Color(0.5, 0.0, 0.0, 1.0), new Color(0.0, 0.5, 0.0, 1.0), new Color(0.0, 0.0, 0.5, 1.0), new Color(0.5, 0.5, 0.0, 1.0), new Color(0.0, 0.5, 0.5, 1.0), new Color(0.5, 0.0, 0.5, 1.0), new Color(0.75, 0.0, 0.0, 1.0), new Color(0.0, 0.75, 0.0, 1.0), new Color(0.0, 0.0, 0.75, 1.0), new Color(0.75, 0.75, 0.0, 1.0), new Color(0.0, 0.75, 0.75, 1.0), new Color(0.75, 0.0, 0.75, 1.0), new Color(0.25, 0.0, 0.0, 1.0), new Color(0.0, 0.25, 0.0, 1.0), new Color(0.0, 0.0, 0.25, 1.0), new Color(0.25, 0.25, 0.0, 1.0), new Color(0.0, 0.25, 0.25, 1.0), new Color(0.25, 0.0, 0.25, 1.0)};
        if (onecolor != null) {
            colors = new Color[]{onecolor};
        }
        int fails = 0;
        HashMap<Point, Terrain> allEmpiresTerrain = new HashMap<Point, Terrain>();
        HashSet<Pair<Integer, Integer>> featureLocations = new HashSet<Pair<Integer, Integer>>();
        while (numempirescount < numbertoadd && fails < 100) {
            Map<String, Integer> resourcessum;
            empiresTask.updateMessage("Placing Empire #" + (numempirescount + 1) + "/" + numbertoadd + " (fails:" + fails + "/100)");
            ArrayList<Polygon> empirepolygons = new ArrayList<Polygon>();
            Color empirecolor = colors[numempirescount % colors.length];
            HashMap<Point, Terrain> empireTerrain = new HashMap<Point, Terrain>();
            HashSet<Feature> empireFeatures = new HashSet<Feature>();
            int x = (int)(Math.random() * (double)(terrain.length - 2)) + 1;
            int y = (int)(Math.random() * (double)(terrain[x].length - 2)) + 1;
            if (allEmpiresTerrain.containsKey(new Point(x, y))) {
                ++fails;
                continue;
            }
            if (terrain[x][y].getTypeName().toLowerCase().contains("water")) {
                ++fails;
                continue;
            }
            MapLayer bordersLayer = mapData.getMapLayer("Borders");
            if (bordersLayer == null) {
                bordersLayer = new MapLayer("Borders");
                List<MapLayer> layers = mapData.getMapLayers();
                for (int i = 0; i < layers.size(); ++i) {
                    if (!layers.get(i).getName().equals("Features")) continue;
                    layers.add(i, bordersLayer);
                    newml = new Pair((Object)i, (Object)bordersLayer);
                    break;
                }
            }
            if ((resourcessum = MapLogic.getAdjacentResourcesSum(terrain, mapData.getTileOrientation(), x, y)).get("Crops") != null && resourcessum.get("Crops") + resourcessum.get("Animals") > 300 && resourcessum.get("Lumber") + resourcessum.get("Metals") + resourcessum.get("Rock") > 200) {
                Nation nation = null;
                if (nations != null && numempirescount - 1 < nations.size() && nations.get(numempirescount) != null) {
                    nation = (Nation)nations.get(numempirescount);
                }
                numempirescount = MapLogic.createNation(empiresTask, vl, mapData, uag, terrain, featureLocations, terraintype, numempirescount, numbertoadd, allEmpiresTerrain, empirepolygons, empirecolor, empireTerrain, empireFeatures, x, y, nation, mapData.getMapLayer("Features"), notes, sizeLimit, true, distanceBetweenFeatures);
            }
            empiresTask.updateMessage("Placing Empire #" + numempirescount + "/" + numbertoadd + " (fails:" + fails + "/100) Post actions");
            MapLogic.createNationPostActions(nations, mapData, uag, numempirescount, allEmpiresTerrain, empirepolygons, empirecolor, worldographer.getMapUI().getViewLevel(), empireTerrain, empireFeatures, bordersLayer, fill);
            fails = 0;
            empiresTask.updateMessage("Placing Empire #" + numempirescount + "/" + numbertoadd + " (fails:" + fails + "/100) Done");
        }
        return newml;
    }

    public static void createNationPostActions(List<Information> nations, MapData mapData, UndoActionGroup uag, int numempirescount, Map<Point, Terrain> allEmpiresTerrain, List<Polygon> empirepolygons, Color empirecolor, ViewLevel viewLevel, Map<Point, Terrain> empireTerrain, Set<Feature> empireFeatures, MapLayer bordersml, boolean fill) {
        HashMap<Point, Terrain> toAdd = new HashMap<Point, Terrain>();
        for (Point point : empireTerrain.keySet()) {
            Map<Point, Terrain> adjTerrain = MapLogic.getAdjTerrainPoint(mapData.getTerrain(viewLevel), mapData.getTileOrientation(), (int)point.getX(), (int)point.getY());
            HashMap<Point, Terrain> adjTerrainNotInEmpire = new HashMap<Point, Terrain>();
            for (Point k2 : adjTerrain.keySet()) {
                if (empireTerrain.containsKey(k2)) continue;
                adjTerrainNotInEmpire.put(k2, adjTerrain.get(k2));
            }
            if (adjTerrainNotInEmpire.size() != 1 && adjTerrainNotInEmpire.size() != 2) continue;
            for (Point k2 : adjTerrainNotInEmpire.keySet()) {
                toAdd.put(k2, (Terrain)adjTerrainNotInEmpire.get(k2));
                empirepolygons.add(MapLogic.createTerrainPolygon(mapData.getTileOrientation(), (int)k2.getX(), (int)k2.getY()));
            }
        }
        for (Point point : toAdd.keySet()) {
            empireTerrain.put(point, (Terrain)toAdd.get(point));
        }
        for (Point point : empireTerrain.keySet()) {
            allEmpiresTerrain.put(point, empireTerrain.get(point));
        }
        for (Feature feature : empireFeatures) {
        }
        if (empirepolygons.size() > 0) {
            ArrayList<Double> bounds = new ArrayList<Double>();
            Polygon polygon = MapLogic.convertPathToPolygon((Path)MapLogic.makeOverallPolygon3(empirepolygons, mapData.getMapLabels()), bounds);
            Color fillcolor = new Color(empirecolor.getRed(), empirecolor.getGreen(), empirecolor.getBlue(), 0.12);
            if (fill) {
                polygon.setFill((Paint)fillcolor);
            } else {
                polygon.setFill(null);
            }
            polygon.setStroke((Paint)empirecolor);
            polygon.setStrokeWidth(0.05);
            Object name = "empire " + numempirescount;
            if (nations != null && numempirescount - 1 < nations.size() && nations.get(numempirescount - 1) != null) {
                name = nations.get(numempirescount - 1).getName();
            }
            MapShape ms = new MapShape(ViewLevel.WORLD, viewLevel, (Shape)polygon, MapShape.CreationType.BASIC, MapShape.StrokeType.SIMPLE, false, (String)name, 0.0, 0.0, 0.0, 0.0, true, true, true, true, bordersml);
            ms.setSnapVertices(true);
            mapData.getShapes().add(ms);
            MapLayer mapLayer = mapData.getMapLayer("Labels");
            if (mapLayer == null) {
                mapLayer = new MapLayer("Labels");
            }
            uag.addAction(new UndoAction(UndoAction.Action.ADD, UndoAction.Thing.MAP_SHAPE, ms, null, null, null, null, null));
            MapLabel label = new MapLabel("Nation", (String)name, "Arial", Color.WHITE, 0.0, Color.WHITE, null, 0.0, true, true, false, false, false, false, false, TextAlignment.CENTER, "political nation", mapLayer);
            label.setLocationAndScale(ViewLevel.WORLD, new Point2D((Double)bounds.get(2) / 2.0 + (Double)bounds.get(0), (Double)bounds.get(3) / 2.0 + (Double)bounds.get(1)), 75.0);
            if (mapData.getTerrain(ViewLevel.KINGDOM) != null) {
                mapData.updateMapLabelLocationNewLevel(ViewLevel.WORLD, ViewLevel.KINGDOM, label);
            }
            if (mapData.getTerrain(ViewLevel.CONTINENT) != null) {
                mapData.updateMapLabelLocationNewLevel(ViewLevel.WORLD, ViewLevel.CONTINENT, label);
            }
            mapData.getMapLabels().add(label);
            uag.addAction(new UndoAction(UndoAction.Action.ADD, UndoAction.Thing.LABEL, label, null, null, null, null, null));
        }
    }

    public static int createNation(GenerateEmpiresTask empiresTask, ViewLevel vl, MapData mapData, UndoActionGroup uag, Terrain[][] terrain, Set<Pair<Integer, Integer>> allFeatureTerrainLocations, int terraintype, int numempirescount, int totalEmpiresCount, Map<Point, Terrain> allEmpiresTerrain, List<Polygon> empirepolygons, Color empirecolor, Map<Point, Terrain> empireTerrain, Set<Feature> empireFeatures, int x, int y, Nation nation, MapLayer ml, Set<Note> notes, int sizeLimit, boolean placeFreely, int distanceBetweenFeatures) {
        Feature city = new Feature(terraintype == 0 ? "Classic/Settlement Capital" : "Isometric Region/Settlement Medieval City A", false, false, false, false, null, 0.0, null, terraintype == 0 ? 75.0 : 50.0, -1.0, false, false, null, "", true, true, true, true, ml);
        String name = MapLogic.creatureLocationName(nation);
        MapLayer layer = mapData.getMapLayer("Labels");
        if (layer == null) {
            layer = new MapLayer("Labels");
            mapData.getMapLayers().add(0, layer);
        }
        city.setLabel(new MapLabel("City", name, "Arial", Color.BLACK, 0.0, Color.BLACK, null, 0.0, true, true, true, true, false, false, false, TextAlignment.CENTER, "town political", layer));
        city.setLabelDistance(50);
        double locx = (double)(x * 300 * 3 / 4 + 150) - (placeFreely ? -100.0 + Math.random() * 200.0 : 0.0);
        double locy = y * 300 + (x % 2 == 0 ? 0 : 150) + 150;
        if (mapData.getTileOrientation() == HexOrientation.ROWS) {
            locx = (double)(x * 300 + (y % 2 == 0 ? 0 : 150) + 150) - (placeFreely ? -100.0 + Math.random() * 200.0 : 0.0);
            locy = (double)(y * 300 * 3 / 4 + 150) - (placeFreely ? -100.0 + Math.random() * 200.0 : 0.0);
        }
        allFeatureTerrainLocations.add((Pair<Integer, Integer>)new Pair((Object)x, (Object)y));
        mapData.addNewFeature(vl, uag, city, locx, locy);
        Note n = new Note(vl, locx, locy);
        n.setTitle(name + " - capital");
        if (n.getDetails() == null || n.getDetails().equals("")) {
            n.generateNoteInfo(n.getOriginalViewLevel(), city.getTypeName());
        }
        n.setParent(city);
        mapData.addNewNote(vl, uag, n);
        empireFeatures.add(city);
        Polygon p = MapLogic.createTerrainPolygon(mapData.getTileOrientation(), x, y);
        empirepolygons.add(p);
        ++numempirescount;
        empireTerrain.put(new Point(x, y), terrain[x][y]);
        int empireGrowSize = distanceBetweenFeatures;
        MapLogic.growEmpire(terrain, mapData.getTileOrientation(), empireTerrain, x, y, empireGrowSize, empirecolor, empirepolygons, nation.getName() + ":  ");
        for (int i = 0; i < sizeLimit; ++i) {
            boolean foundcity = false;
            int foundcityfails = 0;
            MapLogic.addCityTownVillageToEmpire(empiresTask, numempirescount, totalEmpiresCount, nation, vl, mapData, allEmpiresTerrain, empireTerrain, empireFeatures, sizeLimit, allFeatureTerrainLocations, terraintype, x, y, foundcity, foundcityfails, empirecolor, -1, -1, empirepolygons, uag, ml, notes, empireGrowSize, placeFreely);
        }
        return numempirescount;
    }

    public static void generateRegionRoads(GenerateEmpiresTask task, Worldographer worldographer, MapUI mapUI, UndoActionGroup uag, Feature selectedFeature, boolean includeVillages, boolean includeRuins, boolean useCurves, boolean fractalize, Color color) {
        Pair roadsML = null;
        MapData mapData = mapUI.getMapData();
        MapLayer roadsLayer = mapData.getMapLayer("Roads");
        if (roadsLayer == null) {
            roadsLayer = new MapLayer("Roads");
            List<MapLayer> layers = mapData.getMapLayers();
            for (int i = 0; i < layers.size(); ++i) {
                if (!layers.get(i).getName().equals("Features")) continue;
                layers.add(i + 1, roadsLayer);
                roadsML = new Pair((Object)(i + 1), (Object)roadsLayer);
                worldographer.layersToolbox.layersTableView.getItems().add(((Integer)roadsML.getKey()).intValue(), (Object)((MapLayer)roadsML.getValue()));
                break;
            }
        }
        List<Point2D> roadTerrainPoints = MapLogic.getRoadEndPointsByTerrainCoords(mapUI);
        HashSet<Point2D> featurePoints = MapLogic.getFeaturePointsFiltered(mapUI, includeVillages, includeRuins, roadTerrainPoints);
        Map<Double, Pair<Point2D, Point2D>> distancesToFeatures = MapLogic.generateRegionRoadsComputeDistancesToFeatures(featurePoints);
        ArrayList<Point2D> roadPoints = new ArrayList<Point2D>();
        for (Point2D pt : roadTerrainPoints) {
            Pair<Double, Double> cpt = mapUI.getMapData().getModelPtFromTerrain((int)pt.getX(), (int)pt.getY());
            roadPoints.add(new Point2D(((Double)cpt.getKey()).doubleValue(), ((Double)cpt.getValue()).doubleValue()));
        }
        if (roadPoints.size() == 0) {
            MapLogic.generateRegionRoadsMakeFirstRoad(mapUI, uag, useCurves, fractalize, featurePoints, distancesToFeatures, roadPoints, roadsLayer, color);
        }
        if (selectedFeature != null) {
            MapLogic.generateRegionRoadsMakeRoadForSelectedFeature(mapUI, uag, selectedFeature, useCurves, fractalize, featurePoints, roadPoints, roadsLayer, color);
            return;
        }
        String type = "Cities/Towns";
        if (includeRuins || includeVillages) {
            type = includeVillages && includeRuins ? "Villages/Ruins" : (includeVillages ? "Villages" : "Ruins");
        }
        if (task != null) {
            task.updateMessage("Features remaining to check for " + type + " & make roads:" + featurePoints.size());
        } else {
            worldographer.addStatus("Features remaining to check for " + type + " & make roads:" + featurePoints.size());
        }
        while (featurePoints.size() > 0) {
            MapLogic.generateRegionRoadsMakeRoadsForRemainingFeatures(mapUI, uag, useCurves, fractalize, featurePoints, distancesToFeatures, roadPoints, roadsLayer, color);
            if (task != null) {
                task.updateMessage("Features remaining to check for " + type + " & make roads:" + featurePoints.size());
                continue;
            }
            worldographer.addStatus("Features remaining to check for " + type + " & make roads:" + featurePoints.size());
        }
        mapUI.draw();
    }

    private static void generateRegionRoadsMakeRoadsForRemainingFeatures(MapUI mapUI, UndoActionGroup uag, boolean useCurves, boolean fractalize, HashSet<Point2D> featurePoints, Map<Double, Pair<Point2D, Point2D>> distancesToFeatures, List<Point2D> roadPoints, MapLayer roadsLayer, Color color) {
        distancesToFeatures.clear();
        for (Point2D apt : roadPoints) {
            for (Point2D bpt : featurePoints) {
                if (apt == bpt) continue;
                distancesToFeatures.put(apt.distance(bpt) + Math.random(), (Pair<Point2D, Point2D>)new Pair((Object)apt, (Object)bpt));
            }
        }
        Double minDistance = distancesToFeatures.keySet().iterator().next();
        Pair<Point2D, Point2D> minDistanceFeatures = distancesToFeatures.get(minDistance);
        Path p = new Path();
        Point2D pt1 = (Point2D)minDistanceFeatures.getKey();
        Point2D pt2 = (Point2D)minDistanceFeatures.getValue();
        p.getElements().add((Object)new MoveTo(pt1.getX(), pt1.getY()));
        p.getElements().add((Object)new LineTo(pt2.getX(), pt2.getY()));
        if (fractalize || useCurves) {
            p = MapLogic.fractalize(p, 150, useCurves ? 0.3 : 1.0);
        }
        if (useCurves) {
            p = MapLogic.convertLineToCurve(p, 0.3);
        }
        MapShape ms = new MapShape(mapUI.viewLevel, mapUI.viewLevel, (Shape)p, MapShape.CreationType.BASIC, MapShape.StrokeType.SIMPLE, false, "road", 0.0, 0.0, 0.0, 0.0, true, true, true, true, roadsLayer);
        p.setStrokeWidth(0.05);
        p.setStroke((Paint)color);
        mapUI.getMapData().getShapes().add(ms);
        uag.addAction(new UndoAction(UndoAction.Action.ADD, UndoAction.Thing.MAP_SHAPE, ms, null, null, null, null, null));
        roadPoints.add(pt2);
        featurePoints.remove(pt2);
    }

    private static void generateRegionRoadsMakeRoadForSelectedFeature(MapUI mapUI, UndoActionGroup uag, Feature selectedFeature, boolean useCurves, boolean fractalize, HashSet<Point2D> featurePoints, List<Point2D> roadPoints, MapLayer roadsLayer, Color color) {
        double distance;
        Point2D fPoint = selectedFeature.getLocation(mapUI.viewLevel);
        Point2D closestPt = null;
        double closestDistance = Double.MAX_VALUE;
        for (Point2D apt : roadPoints) {
            distance = apt.distance(fPoint);
            if (!(distance < closestDistance) || !(distance > 150.0)) continue;
            closestPt = apt;
            closestDistance = distance;
        }
        for (Point2D apt : featurePoints) {
            distance = apt.distance(fPoint);
            if (!(distance < closestDistance) || !(distance > 150.0)) continue;
            closestPt = apt;
            closestDistance = distance;
        }
        Path p = new Path();
        p.getElements().add((Object)new MoveTo(fPoint.getX(), fPoint.getY()));
        p.getElements().add((Object)new LineTo(closestPt.getX(), closestPt.getY()));
        if (fractalize || useCurves) {
            p = MapLogic.fractalize(p, 150, useCurves ? 0.3 : 1.0);
        }
        if (useCurves) {
            p = MapLogic.convertLineToCurve(p, 0.3);
        }
        MapShape ms = new MapShape(mapUI.viewLevel, mapUI.viewLevel, (Shape)p, MapShape.CreationType.BASIC, MapShape.StrokeType.SIMPLE, false, "road", 0.0, 0.0, 0.0, 0.0, true, true, true, true, roadsLayer);
        p.setStrokeWidth(0.05);
        p.setStroke((Paint)color);
        mapUI.getMapData().getShapes().add(ms);
        uag.addAction(new UndoAction(UndoAction.Action.ADD, UndoAction.Thing.MAP_SHAPE, ms, null, null, null, null, null));
    }

    private static Map<Double, Pair<Point2D, Point2D>> generateRegionRoadsComputeDistancesToFeatures(HashSet<Point2D> featurePoints) {
        TreeMap<Double, Pair<Point2D, Point2D>> distancesToFeatures = new TreeMap<Double, Pair<Point2D, Point2D>>();
        for (Point2D apt : featurePoints) {
            for (Point2D bpt : featurePoints) {
                if (apt == bpt) continue;
                distancesToFeatures.put(apt.distance(bpt) + Math.random(), (Pair<Point2D, Point2D>)new Pair((Object)apt, (Object)bpt));
            }
        }
        return distancesToFeatures;
    }

    private static void generateRegionRoadsMakeFirstRoad(MapUI mapUI, UndoActionGroup uag, boolean useCurves, boolean fractalize, HashSet<Point2D> featurePoints, Map<Double, Pair<Point2D, Point2D>> distancesToFeatures, List<Point2D> roadPoints, MapLayer roadsLayer, Color color) {
        Double minDistance0 = distancesToFeatures.keySet().iterator().next();
        Pair<Point2D, Point2D> minDistanceFeatures0 = distancesToFeatures.get(minDistance0);
        Path p0 = new Path();
        Point2D pt01 = (Point2D)minDistanceFeatures0.getKey();
        Point2D pt02 = (Point2D)minDistanceFeatures0.getValue();
        p0.getElements().add((Object)new MoveTo(pt01.getX(), pt01.getY()));
        p0.getElements().add((Object)new LineTo(pt02.getX(), pt02.getY()));
        if (fractalize || useCurves) {
            p0 = MapLogic.fractalize(p0, 150, useCurves ? 0.3 : 1.0);
        }
        if (useCurves) {
            p0 = MapLogic.convertLineToCurve(p0, 0.3);
        }
        MapShape ms0 = new MapShape(mapUI.viewLevel, mapUI.viewLevel, (Shape)p0, MapShape.CreationType.BASIC, MapShape.StrokeType.SIMPLE, false, "road", 0.0, 0.0, 0.0, 0.0, true, true, true, true, roadsLayer);
        p0.setStrokeWidth(0.05);
        p0.setStroke((Paint)color);
        mapUI.getMapData().getShapes().add(ms0);
        roadPoints.add(pt01);
        roadPoints.add(pt02);
        featurePoints.remove(pt01);
        featurePoints.remove(pt02);
        uag.addAction(new UndoAction(UndoAction.Action.ADD, UndoAction.Thing.MAP_SHAPE, ms0, null, null, null, null, null));
    }

    private static HashSet<Point2D> getFeaturePointsFiltered(MapUI mapUI, boolean includeVillages, boolean includeRuins, List<Point2D> roadTerrainPoints) {
        HashSet<Point2D> featurePoints = new HashSet<Point2D>();
        for (Feature f : mapUI.getMapData().getFeatures()) {
            Point2D pt;
            Pair<Integer, Integer> modelPair;
            Point2D fpt = f.getLocation(mapUI.viewLevel);
            Pair<Integer, Integer> tpt = mapUI.getTerrainFromModelPt(fpt.getX(), fpt.getY());
            if (mapUI.getMapData().getTerrain(mapUI.viewLevel)[(Integer)tpt.getKey()][(Integer)tpt.getValue()].getTypeName().toLowerCase().contains("water")) continue;
            String fname = f.getTypeName().toLowerCase();
            if (fname.contains("town") || fname.contains("city") || fname.contains("capital") || fname.contains("castle")) {
                modelPair = mapUI.getMapData().getTerrainFromModelPt(f.getLocation(mapUI.viewLevel).getX(), f.getLocation(mapUI.viewLevel).getY());
                pt = new Point2D((double)((Integer)modelPair.getKey()).intValue(), (double)((Integer)modelPair.getValue()).intValue());
                if (roadTerrainPoints.contains(pt)) continue;
                featurePoints.add(f.getLocation(mapUI.viewLevel));
                continue;
            }
            if (includeVillages && fname.contains("village") || fname.contains("fort")) {
                modelPair = mapUI.getMapData().getTerrainFromModelPt(f.getLocation(mapUI.viewLevel).getX(), f.getLocation(mapUI.viewLevel).getY());
                pt = new Point2D((double)((Integer)modelPair.getKey()).intValue(), (double)((Integer)modelPair.getValue()).intValue());
                if (roadTerrainPoints.contains(pt)) continue;
                featurePoints.add(f.getLocation(mapUI.viewLevel));
                continue;
            }
            if (!includeRuins || !fname.contains("ruins") || roadTerrainPoints.contains(pt = new Point2D((double)((Integer)(modelPair = mapUI.getMapData().getTerrainFromModelPt(f.getLocation(mapUI.viewLevel).getX(), f.getLocation(mapUI.viewLevel).getY())).getKey()).intValue(), (double)((Integer)modelPair.getValue()).intValue()))) continue;
            featurePoints.add(f.getLocation(mapUI.viewLevel));
        }
        return featurePoints;
    }

    private static List<Point2D> getRoadEndPointsByTerrainCoords(MapUI mapUI) {
        ArrayList<Point2D> endPointsByTerrainCoord = new ArrayList<Point2D>();
        for (MapShape ms : mapUI.getMapData().getShapes()) {
            Pair<Integer, Integer> modelPair;
            MoveTo mt;
            Path p;
            if (!ms.getTags().toLowerCase().contains("road") || !(ms.getShape() instanceof Path) || (p = (Path)ms.getShape()).getElements().size() <= 1) continue;
            if (p.getElements().get(0) instanceof MoveTo) {
                mt = (MoveTo)p.getElements().get(0);
                modelPair = mapUI.getMapData().getTerrainFromModelPt(mt.getX(), mt.getY());
                endPointsByTerrainCoord.add(new Point2D((double)((Integer)modelPair.getKey()).intValue(), (double)((Integer)modelPair.getValue()).intValue()));
            } else if (p.getElements().get(0) instanceof LineTo) {
                mt = (LineTo)p.getElements().get(0);
                modelPair = mapUI.getMapData().getTerrainFromModelPt(mt.getX(), mt.getY());
                endPointsByTerrainCoord.add(new Point2D((double)((Integer)modelPair.getKey()).intValue(), (double)((Integer)modelPair.getValue()).intValue()));
            } else if (p.getElements().get(0) instanceof CubicCurveTo) {
                mt = (CubicCurveTo)p.getElements().get(0);
                modelPair = mapUI.getMapData().getTerrainFromModelPt(mt.getX(), mt.getY());
                endPointsByTerrainCoord.add(new Point2D((double)((Integer)modelPair.getKey()).intValue(), (double)((Integer)modelPair.getValue()).intValue()));
            }
            if (p.getElements().get(p.getElements().size() - 1) instanceof MoveTo) {
                mt = (MoveTo)p.getElements().get(p.getElements().size() - 1);
                modelPair = mapUI.getMapData().getTerrainFromModelPt(mt.getX(), mt.getY());
                endPointsByTerrainCoord.add(new Point2D((double)((Integer)modelPair.getKey()).intValue(), (double)((Integer)modelPair.getValue()).intValue()));
                continue;
            }
            if (p.getElements().get(p.getElements().size() - 1) instanceof LineTo) {
                mt = (LineTo)p.getElements().get(p.getElements().size() - 1);
                modelPair = mapUI.getMapData().getTerrainFromModelPt(mt.getX(), mt.getY());
                endPointsByTerrainCoord.add(new Point2D((double)((Integer)modelPair.getKey()).intValue(), (double)((Integer)modelPair.getValue()).intValue()));
                continue;
            }
            if (!(p.getElements().get(p.getElements().size() - 1) instanceof CubicCurveTo)) continue;
            mt = (CubicCurveTo)p.getElements().get(p.getElements().size() - 1);
            modelPair = mapUI.getMapData().getTerrainFromModelPt(mt.getX(), mt.getY());
            endPointsByTerrainCoord.add(new Point2D((double)((Integer)modelPair.getKey()).intValue(), (double)((Integer)modelPair.getValue()).intValue()));
        }
        return endPointsByTerrainCoord;
    }

    private static Path convertLineToCurve(Path input, double maxControlChangePercent) {
        Path out = new Path();
        MoveTo first = (MoveTo)input.getElements().get(0);
        out.getElements().add((Object)new MoveTo(first.getX(), first.getY()));
        double priorX = first.getX();
        double priorY = first.getY();
        for (int i = 1; i < input.getElements().size(); ++i) {
            double control2y;
            LineTo line = (LineTo)input.getElements().get(i);
            Point2D linePt = new Point2D(line.getX(), line.getY());
            double halfx = priorX + (line.getX() - priorX) / 2.0;
            double halfy = priorY + (line.getY() - priorY) / 2.0;
            double control1x = halfx - 150.0 * maxControlChangePercent + 300.0 * maxControlChangePercent * Math.random();
            double control1y = halfy - 150.0 * maxControlChangePercent + 300.0 * maxControlChangePercent * Math.random();
            double control2x = halfx - 150.0 * maxControlChangePercent + 300.0 * maxControlChangePercent * Math.random();
            if (linePt.distance(control2x, control2y = halfy - 150.0 * maxControlChangePercent + 300.0 * maxControlChangePercent * Math.random()) < linePt.distance(control1x, control1y)) {
                double tempx = control1x;
                double tempy = control1y;
                control1x = control2x;
                control1y = control2y;
                control2x = tempx;
                control2y = tempy;
            }
            CubicCurveTo curve = new CubicCurveTo(control1x, control1y, control2x, control2y, line.getX(), line.getY());
            out.getElements().add((Object)curve);
            priorX = line.getX();
            priorY = line.getY();
        }
        return out;
    }

    public static void genHexCrawlLocations(Worldographer worldographer, GenerateEmpiresTask task, MapUI mapUI, UndoActionGroup uag, Random r, double landFreq, double waterFreq) {
        HashSet<Point2D> terrainWithLocations = new HashSet<Point2D>();
        for (Feature f : mapUI.getMapData().getFeatures()) {
            terrainWithLocations.add(f.getLocation(ViewLevel.WORLD));
        }
        for (int x = 0; x < mapUI.getMapData().getTerrain(mapUI.viewLevel).length; ++x) {
            if (task != null) {
                task.updateMessage("Generating Hex Crawl locations:" + (double)x * 100.0 / (double)mapUI.getMapData().getTerrain(mapUI.viewLevel).length);
            }
            for (int y = 0; y < mapUI.getMapData().getTerrain(mapUI.viewLevel)[x].length; ++y) {
                if (mapUI.getMapData().getTerrain(mapUI.viewLevel)[x][y].getTypeName().toLowerCase().contains("water") ? r.nextDouble() > waterFreq : r.nextDouble() > landFreq) continue;
                double tlocx = x * 300 * 3 / 4 + 150;
                double tlocy = y * 300 + (x % 2 == 0 ? 0 : 150) + 150;
                if (mapUI.getMapData().getTileOrientation() == HexOrientation.ROWS) {
                    tlocx = x * 300 + (y % 2 == 0 ? 0 : 150) + 150;
                    tlocy = y * 300 * 3 / 4 + 150;
                }
                if (terrainWithLocations.contains(new Point2D(tlocx, tlocy))) continue;
                String level = "Minor";
                if (Math.random() < 0.5) {
                    level = "Medium";
                    if (Math.random() < 0.4) {
                        level = "Major";
                    }
                }
                MapLogic.getHexCrawlLocation(new Point2D(tlocx, tlocy), mapUI.getMapData().getTerrain(mapUI.viewLevel)[x][y], mapUI.getMapData(), ViewLevel.WORLD, worldographer, level, uag, false);
            }
        }
    }

    public static void getHexCrawlLocation(Point2D modelPt, Terrain ter, MapData mapData, ViewLevel viewLevel, Worldographer worldographer, String level, UndoActionGroup uag, boolean openDialog) {
        Worldographer.pingUsage("http://www.worldographer.com/usage/rightClick_generateHexCrawl-" + level + ".txt");
        Pair titleAndDetails = WorldAndNameData.generateRandomEncounter(ter.getTypeName(), level);
        if (titleAndDetails != null) {
            Note note = null;
            Feature feature = null;
            if (((String)titleAndDetails.getValue()).startsWith("Feature")) {
                boolean isClassicTerrain;
                Object featureType = null;
                boolean bl = isClassicTerrain = !mapData.getTerrain(viewLevel)[0][0].getTypeName().startsWith("ISO ");
                if (isClassicTerrain) {
                    Object key = (String)titleAndDetails.getKey();
                    if (!((String)key).contains("/")) {
                        key = "Classic/" + (String)key;
                    }
                    titleAndDetails = new Pair(key, (Object)((String)titleAndDetails.getValue()));
                }
                if (!isClassicTerrain) {
                    if ("Military Castle".equals(titleAndDetails.getKey())) {
                        featureType = "Military Isometric Castle A";
                    } else if ("Settlement City".equals(titleAndDetails.getKey())) {
                        featureType = "Settlement Medieval City A";
                    } else if ("Symbol Dungeon".equals(titleAndDetails.getKey())) {
                        featureType = "Other Other Dungeon A";
                    } else if ("Military Fort".equals(titleAndDetails.getKey())) {
                        featureType = "Military Fort A";
                    } else if ("Symbol Monster Lair".equals(titleAndDetails.getKey())) {
                        featureType = "Other Monster Lair A";
                    } else if ("Settlement Ruins".equals(titleAndDetails.getKey())) {
                        featureType = "Other Medieval Ruins A";
                    } else if ("Building Shrine".equals(titleAndDetails.getKey())) {
                        featureType = "Building Medieval Shrine A";
                    } else if ("Building Temple".equals(titleAndDetails.getKey())) {
                        featureType = "Building Medieval Temple A";
                    } else if ("Settlement Town".equals(titleAndDetails.getKey())) {
                        featureType = "Settlement Medieval Town A";
                    } else if ("Symbol Battle".equals(titleAndDetails.getKey())) {
                        featureType = "Other Battle A";
                    } else if ("Military Camp".equals(titleAndDetails.getKey())) {
                        featureType = "Settlement Medieval Camp A";
                    } else if ("Settlement Camp".equals(titleAndDetails.getKey())) {
                        featureType = "Other Medieval Logging Camp A";
                    } else if ("Settlement Village".equals(titleAndDetails.getKey())) {
                        featureType = "Settlement Medieval Village A";
                    } else if ("Military Fort".equals(titleAndDetails.getKey())) {
                        featureType = "Military Fort A";
                    } else if ("Building Palace".equals(titleAndDetails.getKey())) {
                        featureType = "Other Medieval Palace A";
                    } else if ("Building Pyramid".equals(titleAndDetails.getKey())) {
                        featureType = "Other Medieval Pyramid A";
                    } else if ("Building Tower".equals(titleAndDetails.getKey())) {
                        featureType = "Building Medieval Tower A";
                    } else if ("Building Waystation".equals(titleAndDetails.getKey())) {
                        featureType = "Building Medieval Waystation A";
                    } else if ("Symbol Crater".equals(titleAndDetails.getKey())) {
                        featureType = "Other Crater A";
                    } else if ("Natural Geyser".equals(titleAndDetails.getKey())) {
                        featureType = "Other Geyser A";
                    } else if ("Symbol Oasis".equals(titleAndDetails.getKey())) {
                        featureType = "Other Oasis A";
                    } else if ("Symbol Shipwreck".equals(titleAndDetails.getKey())) {
                        featureType = "Other Shipwreck A";
                    } else {
                        String title = (String)titleAndDetails.getKey();
                        String possibleFeature = title + " A";
                        if (Feature.featureTypes.containsKey(possibleFeature)) {
                            featureType = possibleFeature;
                        }
                    }
                    if (featureType != null) {
                        featureType = "Isometric Region/" + (String)featureType;
                    }
                }
                if (featureType == null && !((String)(featureType = (String)titleAndDetails.getKey())).startsWith("Classic/") && !((String)featureType).startsWith("Creature/")) {
                    featureType = "Classic/" + (String)featureType;
                }
                if (featureType != null && Feature.featureTypes.containsKey(featureType)) {
                    feature = new Feature((String)featureType, false, false, false, false, null, 0.0, null, isClassicTerrain ? 75.0 : 40.0, -1.0, false, false, null, "", true, true, true, true, mapData.getMapLayer("Features"));
                    feature.setLocation(viewLevel, new Point2D(modelPt.getX(), modelPt.getY()));
                    Point2D loc = feature.getLocation(viewLevel);
                    if (!((String)titleAndDetails.getValue()).equals("Feature::")) {
                        note = new Note(viewLevel, loc.getX(), loc.getY());
                        if (note.getDetails() == null || note.getDetails().equals("")) {
                            note.generateNoteInfo(note.getOriginalViewLevel(), feature.getTypeName());
                            note.setTitle((String)titleAndDetails.getKey());
                        }
                        note.setParent(feature);
                    }
                    mapData.addNewFeature(viewLevel, uag, feature, modelPt.getX(), modelPt.getY());
                }
            }
            if (!((String)titleAndDetails.getValue()).equals("Feature")) {
                Object details = (String)titleAndDetails.getValue();
                if (((String)details).startsWith("Feature::")) {
                    details = ((String)details).substring(9);
                }
                note = new Note(viewLevel, modelPt.getX(), modelPt.getY());
                note.setTitle((String)titleAndDetails.getKey());
                while (((String)details).contains("[")) {
                    String[] list = ((String)details).substring(((String)details).indexOf(91) + 1, ((String)details).indexOf(93)).split(",");
                    details = ((String)details).substring(0, ((String)details).indexOf(91)) + list[(int)(Math.random() * (double)list.length)] + ((String)details).substring(((String)details).indexOf("]") + 1);
                }
                note.setDetails((String)details);
                if (feature != null) {
                    note.setParent(feature);
                }
            }
            if (note != null) {
                uag.addAction(new UndoAction(UndoAction.Action.ADD, UndoAction.Thing.NOTE, note));
                worldographer.getMapUI().getMapData().addNewNote(viewLevel, uag, note);
                if (openDialog) {
                    worldographer.popNoteDialog(note);
                }
            }
        }
    }

    public static Polygon convertPathToPolygon(Path path, List<Double> bounds) {
        double minx = Double.MAX_VALUE;
        double miny = Double.MAX_VALUE;
        double maxx = Double.MIN_VALUE;
        double maxy = Double.MIN_VALUE;
        ArrayList<Double> points = new ArrayList<Double>();
        boolean i = false;
        for (PathElement el : path.getElements()) {
            if (el instanceof MoveTo) {
                MoveTo mt = (MoveTo)el;
                points.add(mt.getX());
                points.add(mt.getY());
            }
            if (!(el instanceof LineTo)) continue;
            LineTo lt = (LineTo)el;
            points.add(lt.getX());
            points.add(lt.getY());
            if (lt.getX() < minx) {
                minx = lt.getX();
            }
            if (lt.getY() < miny) {
                miny = lt.getY();
            }
            if (lt.getX() > maxx) {
                maxx = lt.getX();
            }
            if (!(lt.getY() > maxy)) continue;
            maxy = lt.getY();
        }
        bounds.add(minx);
        bounds.add(miny);
        bounds.add(maxx - minx);
        bounds.add(maxy - miny);
        Polygon newPolygon = new Polygon();
        newPolygon.getPoints().addAll(points);
        return newPolygon;
    }

    private static void addCityTownVillageToEmpire(GenerateEmpiresTask empiresTask, int numempirescount, int totalEmpiresToAdd, Nation nation, ViewLevel vl, MapData mapdata, Map<Point, Terrain> allEmpiresTerrain, Map<Point, Terrain> empireTerrain, Set<Feature> empireFeatures, int settlementsLimit, Set<Pair<Integer, Integer>> allFeatureTerrainLocations, int terraintype, int x, int y, boolean foundcity, int foundcityfails, Color empirecolor, int excludex, int excludey, List<Polygon> empirepolygons, UndoActionGroup uag, MapLayer ml, Set<Note> notes, int empireGrowSize, boolean placeFreely) {
        ArrayList<Pair<Point, Terrain>> edgeTerrain = MapLogic.computeEdgeTerrain(mapdata.getTerrain(vl), mapdata.getTileOrientation(), empireTerrain);
        if (empiresTask != null) {
            empiresTask.updateMessage("Placing Empire #" + (numempirescount + 1) + "/" + totalEmpiresToAdd + " settlement#:" + empireFeatures.size() + "/" + settlementsLimit);
        }
        while (!foundcity && foundcityfails < 10) {
            Pair<Point, Terrain> p = edgeTerrain.get((int)((double)edgeTerrain.size() * Math.random()));
            Point k = (Point)p.getKey();
            int cx = (int)k.getX();
            int cy = (int)k.getY();
            if (mapdata.getTerrain(vl)[cx][cy].getTypeName().toLowerCase().contains("water")) {
                ++foundcityfails;
                continue;
            }
            if (allEmpiresTerrain.containsKey(new Point(cx, cy))) {
                ++foundcityfails;
                continue;
            }
            Pair featureTerrainLoc = new Pair((Object)cx, (Object)cy);
            if (allFeatureTerrainLocations.contains(featureTerrainLoc)) {
                ++foundcityfails;
                continue;
            }
            String type = "town";
            Map<String, Integer> resourcessum = MapLogic.getAdjacentResourcesSum(mapdata.getTerrain(vl), mapdata.getTileOrientation(), cx, cy);
            if (resourcessum.get("Crops") != null && resourcessum.get("Crops") + resourcessum.get("Animals") > 200 && resourcessum.get("Lumber") + resourcessum.get("Metals") + resourcessum.get("Rock") > 100) {
                int numCities = 0;
                int numTowns = 0;
                for (Feature f : empireFeatures) {
                    if (f.getTypeName().toLowerCase().contains("city")) {
                        ++numCities;
                    }
                    if (!f.getTypeName().toLowerCase().contains("town")) continue;
                    ++numTowns;
                }
                Feature city2 = new Feature(terraintype == 0 ? "Classic/Settlement Town" : "Isometric Region/Settlement Medieval Town A", false, false, false, false, null, 0.0, null, terraintype == 0 ? 75.0 : 50.0, -1.0, false, false, null, "town political", false, true, true, true, ml);
                String name = MapLogic.creatureLocationName(nation);
                MapLayer layer = mapdata.getMapLayer("Labels");
                if (layer == null) {
                    layer = new MapLayer("Labels");
                    mapdata.getMapLayers().add(0, layer);
                }
                city2.setLabel(new MapLabel("City", name, "Arial", Color.BLACK, 0.0, Color.BLACK, null, 0.0, true, true, true, true, false, false, false, TextAlignment.CENTER, "town political", layer));
                city2.setLabelDistance(50);
                if (vl == ViewLevel.WORLD && resourcessum.get("Lumber") + resourcessum.get("Metals") + resourcessum.get("Rock") > 200 || vl == ViewLevel.CONTINENT && resourcessum.get("Lumber") + resourcessum.get("Metals") + resourcessum.get("Rock") > 250 && (double)numCities * 1.0 / (double)empireFeatures.size() < 0.25 || vl == ViewLevel.KINGDOM && resourcessum.get("Lumber") + resourcessum.get("Metals") + resourcessum.get("Rock") > 300 && (double)numCities * 1.0 / (double)empireFeatures.size() < 0.05) {
                    city2 = new Feature(terraintype == 0 ? "Classic/Settlement City" : "Isometric Region/Settlement Medieval City A", false, false, false, false, null, 0.0, null, terraintype == 0 ? 75.0 : 50.0, -1.0, false, false, null, "city political", true, true, true, true, ml);
                    type = "city";
                    city2.setLabel(new MapLabel("City", name, "Arial", Color.BLACK, 0.0, Color.BLACK, null, 0.0, true, true, true, true, false, false, false, TextAlignment.CENTER, "city political", layer));
                    city2.setLabelDistance(50);
                    MapLogic.growEmpire(mapdata.getTerrain(vl), mapdata.getTileOrientation(), empireTerrain, cx, cy, empireGrowSize, empirecolor, empirepolygons, nation.getName() + ":");
                } else if (vl == ViewLevel.CONTINENT && resourcessum.get("Lumber") + resourcessum.get("Metals") + resourcessum.get("Rock") > 150 || vl == ViewLevel.KINGDOM && resourcessum.get("Lumber") + resourcessum.get("Metals") + resourcessum.get("Rock") > 225 && (double)numTowns * 1.0 / (double)empireFeatures.size() < 0.25) {
                    city2 = new Feature(terraintype == 0 ? "Classic/Settlement Town" : "Isometric Region/Settlement Medieval Town A", false, false, false, false, null, 0.0, null, terraintype == 0 ? 75.0 : 50.0, -1.0, false, false, null, "town political", false, true, true, true, ml);
                    type = "town";
                    city2.setLabel(new MapLabel("City", name, "Arial", Color.BLACK, 0.0, Color.BLACK, null, 0.0, true, true, true, true, false, false, false, TextAlignment.CENTER, "town political", layer));
                    city2.setLabelDistance(50);
                    MapLogic.growEmpire(mapdata.getTerrain(vl), mapdata.getTileOrientation(), empireTerrain, cx, cy, empireGrowSize, empirecolor, empirepolygons, nation.getName() + ":");
                } else if ((resourcessum.get("Metals") > 100 || resourcessum.get("Rock") > 100) && vl == ViewLevel.KINGDOM) {
                    city2 = new Feature(terraintype == 0 ? "Classic/Resource Mines" : "Isometric Region/Other Medieval Mine A", false, false, false, false, null, 0.0, null, terraintype == 0 ? 75.0 : 50.0, -1.0, false, false, null, "mine infrastructure", false, false, true, true, ml);
                    type = "mines";
                } else if (resourcessum.get("Lumber") > 100 && vl == ViewLevel.KINGDOM) {
                    city2 = new Feature(terraintype == 0 ? "Classic/Resource Logging Camp" : "Isometric Region/Other Medieval Logging Camp A", false, false, false, false, null, 0.0, null, terraintype == 0 ? 75.0 : 50.0, -1.0, false, false, null, "lumber infrastructure", false, false, true, true, ml);
                    type = "logging camp";
                } else if (resourcessum.get("Animals") + resourcessum.get("Crops") + resourcessum.get("Brick") + resourcessum.get("Lumber") + resourcessum.get("Metals") + resourcessum.get("Rock") > 200 && vl == ViewLevel.KINGDOM) {
                    city2 = new Feature(terraintype == 0 ? "Classic/Settlement Village" : "Isometric Region/Settlement Medieval Village A", false, false, false, false, null, 0.0, null, terraintype == 0 ? 75.0 : 50.0, -1.0, false, false, null, "village political", false, false, true, true, ml);
                    type = "village";
                } else {
                    MapLogic.growEmpire(mapdata.getTerrain(vl), mapdata.getTileOrientation(), empireTerrain, cx, cy, empireGrowSize / 2, empirecolor, empirepolygons, nation.getName() + ":");
                }
                if (city2.getTypeName().toLowerCase().contains("town") && vl == ViewLevel.WORLD) {
                    ++foundcityfails;
                    continue;
                }
                allFeatureTerrainLocations.add((Pair<Integer, Integer>)new Pair((Object)cx, (Object)cy));
                double locx2 = (double)(cx * 300 * 3 / 4 + 150) - (placeFreely ? -100.0 + Math.random() * 200.0 : 0.0);
                double locy2 = (double)(cy * 300 + (cx % 2 == 0 ? 0 : 150) + 150) - (placeFreely ? -100.0 + Math.random() * 200.0 : 0.0);
                if (mapdata.getTileOrientation() == HexOrientation.ROWS) {
                    locx2 = (double)(cx * 300 + (cy % 2 == 0 ? 0 : 150) + 150) - (placeFreely ? -100.0 + Math.random() * 200.0 : 0.0);
                    locy2 = (double)(cy * 300 * 3 / 4 + 150) - (placeFreely ? -100.0 + Math.random() * 200.0 : 0.0);
                }
                mapdata.addNewFeature(vl, uag, city2, locx2, locy2);
                Note n = new Note(vl, locx2, locy2);
                n.setTitle(name + " - " + type);
                n.setParent(city2);
                if (n.getDetails() == null || n.getDetails().equals("")) {
                    n.generateNoteInfo(n.getOriginalViewLevel(), city2.getTypeName());
                }
                mapdata.addNewNote(vl, uag, n);
                empireFeatures.add(city2);
                foundcity = true;
                continue;
            }
            ++foundcityfails;
        }
    }

    private static String creatureLocationName(Nation nation) {
        String name = "";
        if (nation != null) {
            int i = (int)(Math.random() * (double)nation.getCultures().size());
            Culture c = nation.getCultures().get(i);
            name = WorldAndNameData.getNameDynamic(c.getLanguage(), WorldAndNameData.NameType.LocationName, null);
        }
        return name;
    }

    private static ArrayList<Pair<Point, Terrain>> computeEdgeTerrain(Terrain[][] terrain, HexOrientation ho, Map<Point, Terrain> empireTerrain) {
        ArrayList<Pair<Point, Terrain>> edgeTerrain = new ArrayList<Pair<Point, Terrain>>();
        for (Point key : empireTerrain.keySet()) {
            Terrain t = empireTerrain.get(key);
            Map<Point, Terrain> adjterrainmap = MapLogic.getAdjTerrainPoint(terrain, ho, (int)key.getX(), (int)key.getY());
            for (Point adjterrainkey : adjterrainmap.keySet()) {
                Terrain adjterrain = adjterrainmap.get(adjterrainkey);
                if (empireTerrain.containsValue(adjterrain)) continue;
                edgeTerrain.add((Pair<Point, Terrain>)new Pair((Object)key, (Object)t));
            }
        }
        return edgeTerrain;
    }

    private static void growEmpire(Terrain[][] terrain, HexOrientation ho, Map<Point, Terrain> empireTerrain, int ix, int iy, int empiregrowsize, Color empirecolor, List<Polygon> empirepolygons, String prefix) {
        Map<Point, Terrain> t = MapLogic.getAdjTerrainPoint(terrain, ho, ix, iy);
        for (Point key : t.keySet()) {
            Terrain t1 = t.get(key);
            if (empireTerrain.containsKey(key)) continue;
            Polygon p = MapLogic.createTerrainPolygon(ho, (int)key.getX(), (int)key.getY());
            empirepolygons.add(p);
            empireTerrain.put(key, t1);
            if (empiregrowsize <= 0) continue;
            MapLogic.growEmpire(terrain, ho, empireTerrain, (int)key.getX(), (int)key.getY(), empiregrowsize - 1, empirecolor, empirepolygons, prefix + "  ");
        }
    }

    private static Polygon createTerrainPolygon(HexOrientation ho, Integer x, Integer y) {
        Polygon p = new Polygon();
        if (ho == HexOrientation.ROWS) {
            double hexx = x * 300 + (y % 2 == 0 ? 0 : 150);
            double hexy = y * 300 * 3 / 4;
            p.getPoints().add((Object)(hexx + 150.0));
            p.getPoints().add((Object)hexy);
            p.getPoints().add((Object)(hexx + 300.0));
            p.getPoints().add((Object)(hexy + 75.0));
            p.getPoints().add((Object)(hexx + 300.0));
            p.getPoints().add((Object)(hexy + 225.0));
            p.getPoints().add((Object)(hexx + 150.0));
            p.getPoints().add((Object)(hexy + 300.0));
            p.getPoints().add((Object)hexx);
            p.getPoints().add((Object)(hexy + 225.0));
            p.getPoints().add((Object)hexx);
            p.getPoints().add((Object)(hexy + 75.0));
        } else {
            double hexx = (double)x.intValue() * 300.0 * 3.0 / 4.0;
            double hexy = y * 300 + (x % 2 == 0 ? 0 : 150);
            p.getPoints().add((Object)(hexx + 75.0));
            p.getPoints().add((Object)hexy);
            p.getPoints().add((Object)(hexx + 225.0));
            p.getPoints().add((Object)hexy);
            p.getPoints().add((Object)(hexx + 300.0));
            p.getPoints().add((Object)(hexy + 150.0));
            p.getPoints().add((Object)(hexx + 225.0));
            p.getPoints().add((Object)(hexy + 300.0));
            p.getPoints().add((Object)(hexx + 75.0));
            p.getPoints().add((Object)(hexy + 300.0));
            p.getPoints().add((Object)hexx);
            p.getPoints().add((Object)(hexy + 150.0));
        }
        return p;
    }

    private static Shape makeOverallPolygon3(List<Polygon> empirepolygons, List<MapLabel> labels) {
        Shape overall = (Shape)empirepolygons.remove(0);
        while (empirepolygons.size() > 0) {
            for (int i = 0; i < empirepolygons.size(); ++i) {
                if (Shape.intersect((Shape)overall, (Shape)((Shape)empirepolygons.get(i))) == null) continue;
                overall = Shape.union((Shape)overall, (Shape)((Shape)empirepolygons.remove(i)));
            }
        }
        return overall;
    }

    public static Map<String, Integer> getAdjacentResourcesSum(Terrain[][] terrain, HexOrientation ho, int i, int j) {
        HashMap<String, Integer> resources = new HashMap<String, Integer>();
        for (int k = 0; k < ResourceType.values().length; ++k) {
            resources.put(ResourceType.values()[k].name(), Integer.valueOf(terrain[i][j].getExtraInfo().getResources()[k]));
        }
        Map<Point, Terrain> adjTerrain = MapLogic.getAdjTerrainPoint(terrain, ho, i, j);
        for (Terrain t : adjTerrain.values()) {
            for (int k = 0; k < ResourceType.values().length; ++k) {
                Integer d1 = (Integer)resources.get(ResourceType.values()[k].name());
                Byte d2 = t.getExtraInfo().getResources()[k];
                if (d1 == null || d2 == null) continue;
                Integer sum = d1 + d2;
                resources.put(ResourceType.values()[k].name(), sum);
            }
        }
        return resources;
    }

    public static void setElevations(Terrain[][] terrain, HexOrientation ho) {
        TreeMap<CallSite, Terrain> terrainmap = new TreeMap<CallSite, Terrain>();
        for (int i = 0; i < terrain.length; ++i) {
            for (int j = 0; j < terrain[i].length; ++j) {
                terrainmap.put((CallSite)((Object)(Math.random() + " " + i + " " + j)), terrain[i][j]);
            }
        }
        for (String k : terrainmap.keySet()) {
            Terrain southeast;
            Terrain northeast;
            Terrain southwest;
            Terrain northwest;
            String[] vals = k.split(" ");
            int i = Integer.parseInt(vals[1]);
            int j = Integer.parseInt(vals[2]);
            Terrain t = (Terrain)terrainmap.get(k);
            if (!ho.equals((Object)HexOrientation.COLUMNS)) continue;
            if (j > 0) {
                Terrain north = terrain[i][j - 1];
                MapLogic.adjustTerrainElevation(t, north);
            }
            if (j + 1 < terrain[i].length) {
                Terrain south = terrain[i][j + 1];
                MapLogic.adjustTerrainElevation(t, south);
            }
            if (i % 2 == 0) {
                if (i > 0 && j > 0) {
                    northwest = terrain[i - 1][j - 1];
                    MapLogic.adjustTerrainElevation(t, northwest);
                }
                if (i > 0) {
                    southwest = terrain[i - 1][j];
                    MapLogic.adjustTerrainElevation(t, southwest);
                }
                if (i + 1 < terrain.length && j > 0) {
                    northeast = terrain[i + 1][j - 1];
                    MapLogic.adjustTerrainElevation(t, northeast);
                }
                if (i + 1 >= terrain.length) continue;
                southeast = terrain[i + 1][j];
                MapLogic.adjustTerrainElevation(t, southeast);
                continue;
            }
            if (i > 0) {
                northwest = terrain[i - 1][j];
                MapLogic.adjustTerrainElevation(t, northwest);
            }
            if (i > 0 && j + 1 < terrain[i].length) {
                southwest = terrain[i - 1][j + 1];
                MapLogic.adjustTerrainElevation(t, southwest);
            }
            if (i + 1 < terrain.length) {
                northeast = terrain[i + 1][j];
                MapLogic.adjustTerrainElevation(t, northeast);
            }
            if (i + 1 >= terrain.length || j + 1 >= terrain[i].length) continue;
            southeast = terrain[i + 1][j + 1];
            MapLogic.adjustTerrainElevation(t, southeast);
        }
    }

    public static void adjustTerrainElevation(Terrain t, Terrain adjacentt) {
        if (adjacentt.getTypeName().toLowerCase().contains("water")) {
            return;
        }
        if (t.getTypeName().toLowerCase().contains("mountain")) {
            if (adjacentt.getTypeName().toLowerCase().contains("mountain")) {
                t.setElevation(t.getElevation() + (int)((double)adjacentt.getElevation() * 0.1 * Math.random()));
                if (!t.getTypeName().toLowerCase().contains("forest")) {
                    t.setElevation(t.getElevation() + (int)((double)t.getElevation() * 0.1 * Math.random()));
                }
            }
        } else {
            int difference = (int)((double)(t.getType().getElevation() - adjacentt.getType().getElevation()) * 0.1 * Math.random());
            t.setElevation(t.getElevation() - difference);
        }
    }

    public static void breakUpARoomOrWallForDoorsWindowsx(List<MapShape> shapes, List<Rectangle> doorWindowBoundingBoxes) {
        System.out.println("start");
        for (int dwbCount = 0; dwbCount < doorWindowBoundingBoxes.size(); ++dwbCount) {
            System.out.println("outer loop begin again");
            Rectangle doorWindowBox = doorWindowBoundingBoxes.get(dwbCount);
            for (int shapeCount = 0; shapeCount < shapes.size(); ++shapeCount) {
                MapShape ms = shapes.get(shapeCount);
                if (!ms.getTags().toLowerCase().contains("room") && !ms.getTags().toLowerCase().contains("wall")) continue;
                List<Point2D> shapePts = ms.getShapePoints();
                if (ms.getShape() instanceof Polygon) {
                    shapePts.add(new Point2D(shapePts.get(0).getX(), shapePts.get(0).getY()));
                }
                for (int i = 0; i < shapePts.size(); ++i) {
                    ArrayList<Point2D> intersectPts = new ArrayList<Point2D>();
                    Point2D aPt = shapePts.get(i);
                    Point2D bPt = shapePts.get((i + 1) % shapePts.size());
                    Point2D intersectPt1 = MapLogic.intersection(aPt.getX(), aPt.getY(), bPt.getX(), bPt.getY(), doorWindowBox.getX() - 1.0, doorWindowBox.getY() - 1.0, doorWindowBox.getX() + doorWindowBox.getWidth() * 2.0 + 1.0, doorWindowBox.getY() - 1.0);
                    if (intersectPt1 == null) continue;
                    intersectPts.add(intersectPt1);
                    System.out.println("intersectPt1:" + String.valueOf(intersectPt1));
                }
            }
        }
    }

    public static void breakUpARoomOrWallForDoorsWindows(List<MapShape> shapes, List<Rectangle> doorWindowBoundingBoxes) {
        System.out.println("start");
        for (int dwbCount = 0; dwbCount < doorWindowBoundingBoxes.size(); ++dwbCount) {
            System.out.println("outer loop begin again");
            Rectangle doorWindowBox = doorWindowBoundingBoxes.get(dwbCount);
            for (int shapeCount = 0; shapeCount < shapes.size(); ++shapeCount) {
                System.out.println("shape loop begin again");
                MapShape ms = shapes.get(shapeCount);
                if (!ms.getTags().toLowerCase().contains("room") && !ms.getTags().toLowerCase().contains("wall")) continue;
                List<Point2D> shapePts = ms.getShapePoints();
                if (ms.getShape() instanceof Polygon) {
                    shapePts.add(new Point2D(shapePts.get(0).getX(), shapePts.get(0).getY()));
                }
                for (int i = 0; i < shapePts.size() - 1; ++i) {
                    Point2D intersectPt4;
                    Point2D intersectPt3;
                    Point2D intersectPt2;
                    ArrayList<Point2D> intersectPts = new ArrayList<Point2D>();
                    Point2D aPt = shapePts.get(i);
                    Point2D bPt = shapePts.get((i + 1) % shapePts.size());
                    Point2D intersectPt1 = MapLogic.intersection(aPt.getX(), aPt.getY(), bPt.getX(), bPt.getY(), doorWindowBox.getX() - 1.0, doorWindowBox.getY() - 1.0, doorWindowBox.getX() + doorWindowBox.getWidth() * 2.0 + 1.0, doorWindowBox.getY() - 1.0);
                    if (intersectPt1 != null) {
                        intersectPts.add(intersectPt1);
                        System.out.println("intersectPt1:" + String.valueOf(intersectPt1));
                    }
                    if ((intersectPt2 = MapLogic.intersection(aPt.getX(), aPt.getY(), bPt.getX(), bPt.getY(), doorWindowBox.getX() + doorWindowBox.getWidth() * 2.0 + 1.0, doorWindowBox.getY() - 1.0, doorWindowBox.getX() + doorWindowBox.getWidth() * 2.0 + 1.0, doorWindowBox.getY() + doorWindowBox.getHeight() * 2.0 + 1.0)) != null) {
                        intersectPts.add(intersectPt2);
                        System.out.println("intersectPt2:" + String.valueOf(intersectPt2));
                    }
                    if ((intersectPt3 = MapLogic.intersection(aPt.getX(), aPt.getY(), bPt.getX(), bPt.getY(), doorWindowBox.getX() + doorWindowBox.getWidth() * 2.0 + 1.0, doorWindowBox.getY() + doorWindowBox.getHeight() * 2.0 + 1.0, doorWindowBox.getX() - 1.0, doorWindowBox.getY() + doorWindowBox.getHeight() * 2.0 + 1.0)) != null) {
                        intersectPts.add(intersectPt3);
                        System.out.println("intersectPt3:" + String.valueOf(intersectPt3));
                    }
                    if ((intersectPt4 = MapLogic.intersection(aPt.getX(), aPt.getY(), bPt.getX(), bPt.getY(), doorWindowBox.getX() - 1.0, doorWindowBox.getY() + doorWindowBox.getHeight() * 2.0 + 1.0, doorWindowBox.getX() - 1.0, doorWindowBox.getY() - 1.0)) != null) {
                        intersectPts.add(intersectPt4);
                        System.out.println("intersectPt4:" + String.valueOf(intersectPt4));
                    }
                    if (intersectPts.size() != 2) continue;
                    if (ms.getTags().toLowerCase().contains("room")) {
                        ms.setTags("floor");
                    }
                    intersectPts.clear();
                    intersectPt1 = MapLogic.intersection(aPt.getX(), aPt.getY(), bPt.getX(), bPt.getY(), doorWindowBox.getX(), doorWindowBox.getY(), doorWindowBox.getX() + doorWindowBox.getWidth() * 2.0, doorWindowBox.getY());
                    if (intersectPt1 != null) {
                        intersectPts.add(intersectPt1);
                    }
                    if ((intersectPt2 = MapLogic.intersection(aPt.getX(), aPt.getY(), bPt.getX(), bPt.getY(), doorWindowBox.getX() + doorWindowBox.getWidth() * 2.0, doorWindowBox.getY(), doorWindowBox.getX() + doorWindowBox.getWidth() * 2.0, doorWindowBox.getY() + doorWindowBox.getHeight() * 2.0)) != null) {
                        intersectPts.add(intersectPt2);
                    }
                    if ((intersectPt3 = MapLogic.intersection(aPt.getX(), aPt.getY(), bPt.getX(), bPt.getY(), doorWindowBox.getX() + doorWindowBox.getWidth() * 2.0, doorWindowBox.getY() + doorWindowBox.getHeight() * 2.0, doorWindowBox.getX(), doorWindowBox.getY() + doorWindowBox.getHeight() * 2.0)) != null) {
                        intersectPts.add(intersectPt3);
                    }
                    if ((intersectPt4 = MapLogic.intersection(aPt.getX(), aPt.getY(), bPt.getX(), bPt.getY(), doorWindowBox.getX(), doorWindowBox.getY() + doorWindowBox.getHeight() * 2.0, doorWindowBox.getX(), doorWindowBox.getY())) != null) {
                        intersectPts.add(intersectPt4);
                    }
                    Point2D pt1 = (Point2D)intersectPts.get(0);
                    Point2D pt2 = (Point2D)intersectPts.get(1);
                    if (pt1.distance(shapePts.get(i)) > pt2.distance(shapePts.get(i))) {
                        pt1 = (Point2D)intersectPts.get(1);
                        pt2 = (Point2D)intersectPts.get(0);
                    }
                    MapShape ms1 = ms.clone();
                    ms1.getShape().setFill(null);
                    ms1.setTags("wall");
                    Path path1 = new Path();
                    path1.setStroke(ms.getShape().getStroke());
                    path1.setStrokeWidth(ms1.getShape().getStrokeWidth());
                    path1.getElements().add((Object)new MoveTo(shapePts.get(0).getX(), shapePts.get(0).getY()));
                    System.out.println("Add 0:" + shapePts.get(0).getX() / 300.0 + "," + shapePts.get(0).getY() / 300.0);
                    for (int j = 1; j <= i; ++j) {
                        System.out.println("  Add" + j + ":" + shapePts.get(j).getX() / 300.0 + "," + shapePts.get(j).getY() / 300.0);
                        path1.getElements().add((Object)new LineTo(shapePts.get(j).getX(), shapePts.get(j).getY()));
                    }
                    System.out.println("  pt1:" + pt1.getX() / 300.0 + "," + pt1.getY() / 300.0 + " pt2:" + pt2.getX() / 300.0 + "," + pt2.getY() / 300.0);
                    path1.getElements().add((Object)new LineTo(pt1.getX(), pt1.getY()));
                    ms1.setShape((Shape)path1);
                    MapShape ms2 = ms.clone();
                    ms2.getShape().setFill(null);
                    ms2.setTags("wall");
                    Path path2 = new Path();
                    path2.setStroke(ms.getShape().getStroke());
                    path2.setStrokeWidth(ms2.getShape().getStrokeWidth());
                    path2.getElements().add((Object)new MoveTo(pt2.getX(), pt2.getY()));
                    for (int j = i + 1; j < shapePts.size(); ++j) {
                        System.out.print("  2Add" + j + ":" + shapePts.get(j).getX() / 300.0 + "," + shapePts.get(j).getY() / 300.0);
                        path2.getElements().add((Object)new LineTo(shapePts.get(j).getX(), shapePts.get(j).getY()));
                    }
                    ms2.setShape((Shape)path2);
                    shapes.add(shapeCount + 1, ms1);
                    shapes.add(shapeCount + 1, ms2);
                    if (!ms.getTags().contains("floor")) {
                        shapes.remove(ms);
                        --shapeCount;
                        continue;
                    }
                    ms.getShape().setStrokeWidth(0.0);
                }
            }
        }
    }

    public static List<Shape> generateMainRoadsHelper(int wd, int ht, String choice1, String choice2, String choice3, String choice4, int linklength, double linkvariance, Point2D intersectPoint, List<MapShape> coasts, boolean tangent) {
        if (linkvariance < 0.0) {
            linkvariance = 0.0;
        }
        if (linkvariance > 2.0) {
            linkvariance = 2.0;
        }
        String[] options = new String[]{"12:00", "1:00", "2:00", "3:00", "4:00", "5:00", "6:00", "7:00", "8:00", "9:00", "10:00", "11:00"};
        int c1 = 2;
        int c2 = 8;
        int c3 = 11;
        int c4 = 5;
        ArrayList temphighways = new ArrayList();
        ArrayList<Shape> lines = new ArrayList<Shape>();
        ArrayList<Shape> lines2 = new ArrayList<Shape>();
        int attempts = 0;
        Path p = null;
        Path p2 = null;
        while (intersectPoint == null && attempts < 70) {
            ++attempts;
            c1 = "Random".equals(choice1) ? (int)(Math.random() * (double)options.length) : (Integer.parseInt(choice1.substring(0, choice1.indexOf(":"))) + 1) % 12;
            c2 = "Random".equals(choice2) ? (int)(Math.random() * (double)options.length) : (Integer.parseInt(choice2.substring(0, choice2.indexOf(":"))) + 1) % 12;
            c3 = "Random".equals(choice3) ? (int)(Math.random() * (double)options.length) : (Integer.parseInt(choice3.substring(0, choice3.indexOf(":"))) + 1) % 12;
            c4 = "Random".equals(choice4) ? (int)(Math.random() * (double)options.length) : (Integer.parseInt(choice4.substring(0, choice4.indexOf(":"))) + 1) % 12;
            ArrayList<Point2D> endPoints = new ArrayList<Point2D>();
            endPoints.add(MapLogic.genEndPoint(c1, wd, ht));
            endPoints.add(MapLogic.genEndPoint(c2, wd, ht));
            endPoints.add(MapLogic.genEndPoint(c3, wd, ht));
            endPoints.add(MapLogic.genEndPoint(c4, wd, ht));
            temphighways.clear();
            p = new Path();
            p.getElements().add((Object)new MoveTo(((Point2D)endPoints.get(0)).getX(), ((Point2D)endPoints.get(0)).getY()));
            p.getElements().add((Object)new LineTo(((Point2D)endPoints.get(1)).getX(), ((Point2D)endPoints.get(1)).getY()));
            p2 = new Path();
            if (tangent) {
                double dx = ((Point2D)endPoints.get(1)).getX() - ((Point2D)endPoints.get(0)).getX();
                double dy = ((Point2D)endPoints.get(1)).getY() - ((Point2D)endPoints.get(0)).getY();
                double interceptx = ((Point2D)endPoints.get(0)).getX() + dx / 2.0;
                double intercepty = ((Point2D)endPoints.get(0)).getY() + dy / 2.0;
                double negrecslope = -dx / dy;
                double b = intercepty / (negrecslope * intercepty);
                if (negrecslope > -0.5 && negrecslope < 0.5) {
                    endPoints.set(2, new Point2D(0.0, intercepty + b));
                    endPoints.set(3, new Point2D((double)wd, intercepty + negrecslope * (double)wd + b));
                } else {
                    endPoints.set(2, new Point2D(interceptx - b / negrecslope, 0.0));
                    endPoints.set(3, new Point2D(interceptx + ((double)ht - b) / negrecslope, (double)ht));
                }
            }
            p2.getElements().add((Object)new MoveTo(((Point2D)endPoints.get(2)).getX(), ((Point2D)endPoints.get(2)).getY()));
            p2.getElements().add((Object)new LineTo(((Point2D)endPoints.get(3)).getX(), ((Point2D)endPoints.get(3)).getY()));
            intersectPoint = MapLogic.intersection(((Point2D)endPoints.get(0)).getX(), ((Point2D)endPoints.get(0)).getY(), ((Point2D)endPoints.get(1)).getX(), ((Point2D)endPoints.get(1)).getY(), ((Point2D)endPoints.get(2)).getX(), ((Point2D)endPoints.get(2)).getY(), ((Point2D)endPoints.get(3)).getX(), ((Point2D)endPoints.get(3)).getY());
            if (intersectPoint == null || !(intersectPoint.getX() < (double)(wd / 4) || intersectPoint.getX() > (double)(wd / 4 * 3) || intersectPoint.getY() < (double)(ht / 4)) && !(intersectPoint.getY() > (double)(ht / 4 * 3))) continue;
            intersectPoint = null;
        }
        if (intersectPoint == null) {
            return new ArrayList<Shape>();
        }
        lines.add((Shape)MapLogic.fractalize(p, linklength, linkvariance));
        lines2.add((Shape)MapLogic.fractalize(p2, linklength, linkvariance));
        List<Shape> linesout = MapLogic.removeMainRoadsOverCoasts(coasts, lines);
        linesout.addAll(MapLogic.removeMainRoadsOverCoasts(coasts, lines2));
        return linesout;
    }

    private static List<Shape> removeMainRoadsOverCoasts(List<MapShape> coasts, List<Shape> lines) {
        if (coasts.size() == 0) {
            return lines;
        }
        ArrayList<Shape> linesout = new ArrayList<Shape>();
        for (Shape l : lines) {
            Path lineout = new Path();
            Path p = (Path)l;
            ArrayList<Point2D> pts = new ArrayList<Point2D>();
            for (int i = 0; i < p.getElements().size(); ++i) {
                PathElement pe = (PathElement)p.getElements().get(i);
                if (pe instanceof MoveTo) {
                    MoveTo mt = (MoveTo)pe;
                    pts.add(new Point2D(mt.getX(), mt.getY()));
                    continue;
                }
                if (!(pe instanceof LineTo)) continue;
                LineTo lt = (LineTo)pe;
                pts.add(new Point2D(lt.getX(), lt.getY()));
            }
            boolean moveto = true;
            for (Point2D pt : pts) {
                boolean coastcontains = false;
                for (MapShape coast : coasts) {
                    if (!coast.getShape().contains(pt)) continue;
                    coastcontains = true;
                    moveto = true;
                }
                if (coastcontains) continue;
                if (moveto) {
                    lineout.getElements().add((Object)new MoveTo(pt.getX(), pt.getY()));
                    moveto = false;
                    continue;
                }
                lineout.getElements().add((Object)new LineTo(pt.getX(), pt.getY()));
            }
            linesout.add((Shape)lineout);
        }
        return linesout;
    }

    public static Path fractalize(Path input, int maxsegmentlength, double variance) {
        MoveTo mt = (MoveTo)input.getElements().get(0);
        LineTo lt = (LineTo)input.getElements().get(1);
        double length = Math.sqrt((mt.getX() - lt.getX()) * (mt.getX() - lt.getX()) + (mt.getY() - lt.getY()) * (mt.getY() - lt.getY()));
        if (length > (double)maxsegmentlength) {
            Path p1 = new Path();
            p1.getElements().add((Object)mt);
            double diffx = lt.getX() - mt.getX() - (double)(maxsegmentlength - maxsegmentlength / 2) * variance * Math.random();
            double diffy = lt.getY() - mt.getY() - (double)(maxsegmentlength - maxsegmentlength / 2) * variance * Math.random();
            p1.getElements().add((Object)new LineTo(mt.getX() + diffx / 2.0, mt.getY() + diffy / 2.0));
            Path p2 = new Path();
            p2.getElements().add((Object)new MoveTo(mt.getX() + diffx / 2.0, mt.getY() + diffy / 2.0));
            p2.getElements().add((Object)lt);
            p1 = MapLogic.fractalize(p1, maxsegmentlength, variance);
            p2 = MapLogic.fractalize(p2, maxsegmentlength, variance);
            for (PathElement pe : p2.getElements()) {
                if (pe instanceof MoveTo) {
                    MoveTo mtx = (MoveTo)pe;
                    LineTo lineTo = new LineTo(mtx.getX(), mtx.getY());
                    continue;
                }
                if (!(pe instanceof LineTo)) continue;
                p1.getElements().add((Object)pe);
            }
            return p1;
        }
        return input;
    }

    public static List<Double> fractalize(double x1, double y1, double x2, double y2, int maxsegmentlength, double variance, double mapwidth, double mapheight) {
        boolean bothptsoffmap;
        ArrayList<Double> pts = new ArrayList<Double>();
        double length = Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2));
        pts.add(x1);
        pts.add(y1);
        boolean pt1offmap = x1 < 0.0 || y1 < 0.0 || x1 > mapwidth || y1 > mapheight;
        boolean pt2offmap = x2 < 0.0 || y2 < 0.0 || x2 > mapwidth || y2 > mapheight;
        boolean bl = bothptsoffmap = pt1offmap && pt2offmap;
        if (length > (double)maxsegmentlength && !bothptsoffmap) {
            double diffx = x2 - x1 - (double)(maxsegmentlength - maxsegmentlength / 2) * variance * Math.random();
            double diffy = y2 - y1 - (double)(maxsegmentlength - maxsegmentlength / 2) * variance * Math.random();
            pts.addAll(MapLogic.fractalize(x1, y1, x1 + diffx / 2.0, y1 + diffy / 2.0, maxsegmentlength, variance, mapwidth, mapheight));
            pts.add(x1 + diffx / 2.0);
            pts.add(y1 + diffy / 2.0);
            pts.addAll(MapLogic.fractalize(x1 + diffx / 2.0, y1 + diffy / 2.0, x2, y2, maxsegmentlength, variance, mapwidth, mapheight));
        }
        pts.add(x2);
        pts.add(y2);
        return pts;
    }

    public static Point2D intersection(double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4) {
        double denom = (y4 - y3) * (x2 - x1) - (x4 - x3) * (y2 - y1);
        if (denom == 0.0) {
            return null;
        }
        double ua = ((x4 - x3) * (y1 - y3) - (y4 - y3) * (x1 - x3)) / denom;
        double ub = ((x2 - x1) * (y1 - y3) - (y2 - y1) * (x1 - x3)) / denom;
        if (ua >= 0.0 && ua <= 1.0 && ub >= 0.0 && ub <= 1.0) {
            return new Point2D(x1 + ua * (x2 - x1), y1 + ua * (y2 - y1));
        }
        return null;
    }

    public static Map<String, Object> createStructureNoteDetails(String fname, double x, double y) {
        return CityDataGenerator.getNoteData(fname);
    }

    private static Point2D genEndPoint(int s1, int width, int height) {
        Point2D endpt1 = null;
        for (int i = 0; i < 12; ++i) {
            if (i < 3 && i == s1) {
                endpt1 = new Point2D((double)((int)((double)(width / 3) * Math.random()) + i * width / 3), -1.0);
                continue;
            }
            if (s1 < 6 && i == s1) {
                endpt1 = new Point2D((double)(width + 1), (double)((int)((double)(height / 3) * Math.random()) + (i - 3) * height / 3));
                continue;
            }
            if (s1 < 9 && i == s1) {
                endpt1 = new Point2D((double)(width - ((int)((double)(width / 3) * Math.random()) + (i - 6) * width / 3)), (double)(height + 1));
                continue;
            }
            if (i != s1) continue;
            endpt1 = new Point2D(-1.0, (double)(height - ((int)((double)(height / 3) * Math.random()) + (i - 9) * height / 3)));
        }
        return endpt1;
    }

    public static void adjustShapesLabelsFeatures(MapData mapData, ViewLevel viewLevel, Point2D diff, ViewLevel vl, double mapWidth, double mapHeight) {
        if (viewLevel == vl) {
            ArrayList<MapShape> shapesRemove = new ArrayList<MapShape>();
            for (MapShape mapShape : mapData.getShapes()) {
                boolean remove = true;
                mapShape.move(diff.getX(), diff.getY());
                List<Point2D> pts = mapShape.getShapePoints();
                for (Point2D pt : pts) {
                    if (!(pt.getX() > 0.0) || !(pt.getX() < mapWidth) || !(pt.getY() > 0.0) || !(pt.getY() < mapHeight)) continue;
                    remove = false;
                    break;
                }
                if (!remove) continue;
                shapesRemove.add(mapShape);
            }
            mapData.getShapes().removeAll(shapesRemove);
        }
        ArrayList<Feature> featuresRemove = new ArrayList<Feature>();
        for (Feature feature : mapData.getFeatures()) {
            Point2D pt;
            if (feature.getLocation(vl) == null || (pt = feature.getLocation(vl)) == null) continue;
            pt = pt.add(diff);
            feature.setLocation(vl, pt);
            if (!(pt.getX() < 0.0 || pt.getY() < 0.0 || pt.getX() > mapWidth) && !(pt.getY() > mapHeight)) continue;
            featuresRemove.add(feature);
        }
        mapData.getFeatures().removeAll(featuresRemove);
        ArrayList<MapLabel> labelsRemove = new ArrayList<MapLabel>();
        for (MapLabel ml : mapData.getMapLabels()) {
            Point2D pt;
            if (ml.getLocation(vl) == null || (pt = ml.getLocation(vl)) == null) continue;
            pt = pt.add(diff);
            ml.setLocationAndScale(vl, (Pair<Point2D, Double>)new Pair((Object)pt, (Object)ml.getScale(vl)));
            if (!(pt.getX() < 0.0 || pt.getY() < 0.0 || pt.getX() > mapWidth) && !(pt.getY() > mapHeight)) continue;
            labelsRemove.add(ml);
        }
        mapData.getMapLabels().removeAll(labelsRemove);
        ArrayList<Note> arrayList = new ArrayList<Note>();
        for (Note n : mapData.getNotes()) {
            Point2D pt = n.getLocation(viewLevel);
            if (pt == null) continue;
            n.setLocation(viewLevel, new Point2D(pt.getX() + diff.getX(), pt.getY() + diff.getY()));
            if (!(pt.getX() < 0.0 || pt.getY() < 0.0 || pt.getX() > mapWidth) && !(pt.getY() > mapHeight)) continue;
            arrayList.add(n);
        }
        mapData.getNotes().removeAll(arrayList);
        HashMap extraTerrainNew = new HashMap();
        for (MapLayer ml : mapData.getExtraTerrainByLayer().keySet()) {
            Map<Point, Terrain> map = mapData.getExtraTerrainByLayer().get(ml);
            HashMap<Point, Terrain> newMap = new HashMap<Point, Terrain>();
            for (Point pt : map.keySet()) {
                if (!(pt.getX() < 0.0 || pt.getY() < 0.0 || pt.getX() > mapWidth) && !(pt.getY() > mapHeight)) continue;
                Point newPt = new Point(pt.getX() + diff.getX(), pt.getY() + diff.getY());
                newMap.put(newPt, map.get(pt));
                System.out.println(pt.getX() + "," + pt.getY() + " as " + newPt.getX() + "," + newPt.getY() + " terrain:" + ((Terrain)newMap.get(newPt)).getTypeName());
            }
            extraTerrainNew.put(ml, newMap);
        }
        mapData.getExtraTerrainByLayer().clear();
        mapData.getExtraTerrainByLayer().putAll(extraTerrainNew);
    }
}

