/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.map;

import java.util.Arrays;
import javafx.scene.paint.Color;

public class TerrainExtraInfo {
    private Color backgroundColor = null;
    private byte[] resources = new byte[]{0, 0, 0, 0, 0, 0, 0};
    private boolean isIcy;
    private boolean isTempGMOnly = false;

    public TerrainExtraInfo() {
        this.isIcy = false;
    }

    public TerrainExtraInfo(boolean icy) {
        this.isIcy = icy;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.backgroundColor == null ? 0 : this.backgroundColor.hashCode());
        result = 31 * result + (this.isIcy ? 1231 : 1237);
        result = 31 * result + (this.isTempGMOnly ? 1231 : 1237);
        result = 31 * result + Arrays.hashCode(this.resources);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TerrainExtraInfo other = (TerrainExtraInfo)obj;
        if (this.backgroundColor == null ? other.backgroundColor != null : !this.backgroundColor.equals((Object)other.backgroundColor)) {
            return false;
        }
        if (this.isIcy != other.isIcy) {
            return false;
        }
        if (this.isTempGMOnly != other.isTempGMOnly) {
            return false;
        }
        return Arrays.equals(this.resources, other.resources);
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public void setResources(byte[] resources) {
        this.resources = resources;
    }

    public boolean isIcy() {
        return this.isIcy;
    }

    public void setIcy(boolean isIcy) {
        this.isIcy = isIcy;
    }

    public void setTempGMOnly(boolean isTempGMOnly) {
        this.isTempGMOnly = isTempGMOnly;
    }

    public byte[] getResources() {
        if (this.resources != null) {
            return this.resources;
        }
        return new byte[]{0, 0, 0, 0, 0, 0, 0};
    }

    public boolean areAllResourcesButFirstZero() {
        if (this.resources == null) {
            return true;
        }
        return this.resources[1] == 0 && this.resources[2] == 0 && this.resources[3] == 0 && this.resources[4] == 0 && this.resources[5] == 0 && this.resources[6] == 0;
    }

    public byte getOneResource(String key) {
        return this.getResources()[ResourceType.valueOf(key).value()];
    }

    public boolean isTempGMOnly() {
        return this.isTempGMOnly;
    }

    public static enum ResourceType {
        Animals(0),
        Brick(1),
        Crops(2),
        Gems(3),
        Lumber(4),
        Metals(5),
        Rock(6);

        private final int value;

        private ResourceType(int v) {
            this.value = v;
        }

        public int value() {
            return this.value;
        }
    }
}

