/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.task;

import com.inkwellideas.ographer.data.ViewLevel;
import com.inkwellideas.ographer.map.MapDataSetTerrain;
import com.inkwellideas.ographer.map.MapDataSetup;
import com.inkwellideas.ographer.map.Terrain;
import com.inkwellideas.ographer.model.Feature;
import com.inkwellideas.ographer.ui.Worldographer;
import com.inkwellideas.ographer.ui.setup.SetupWorldRegionScreen;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javafx.concurrent.Task;
import javafx.util.Pair;

public class GenerateRegionTask
extends Task<MapDataSetup> {
    final MapDataSetup data;
    final List<Pair<String, Double[]>> terrainToProbabilities;
    final SetupWorldRegionScreen.TerrainStyle terrainstyle;
    final ViewLevel viewLevel;
    final Worldographer worldographer;

    public GenerateRegionTask(Worldographer w, MapDataSetup setup, List<Pair<String, Double[]>> terrainToProbs, SetupWorldRegionScreen.TerrainStyle terrainstyle, ViewLevel vl) {
        this.worldographer = w;
        this.data = setup;
        this.terrainToProbabilities = terrainToProbs;
        this.terrainstyle = terrainstyle;
        this.viewLevel = vl;
        this.messageProperty().addListener((observable, oldValue, newValue) -> this.worldographer.addStatus((String)newValue));
    }

    protected MapDataSetup call() throws InterruptedException {
        Terrain[][] t = this.data.getTerrainByViewLevel(this.viewLevel);
        int filledcount = 0;
        for (int x = 0; x < t.length; ++x) {
            for (int y = 0; y < t[x].length; ++y) {
                t[x][y] = new Terrain("Blank", true);
            }
        }
        this.updateMessage("Blank terrrain created.");
        for (int i = 0; i < 11; ++i) {
            filledcount = this.fillAreasWSolidTerrain(new Terrain((String)this.terrainToProbabilities.get(i).getKey(), true), t, filledcount, i);
        }
        this.updateMessage("Finished terrain swatches.");
        while (filledcount < t.length * t[0].length * 3 / 8) {
            filledcount += this.addRandomTerrain(0, t);
        }
        this.updateMessage("Extra terrrain addded.");
        if (!this.isCancelled() && this.terrainstyle == SetupWorldRegionScreen.TerrainStyle.Isometric) {
            this.updateMessage("Setting isometric.");
            MapDataSetTerrain.setTerrainToIsometric(t, new ArrayList<Feature>(), null, this.data.hexOrientation, null);
        }
        this.updateMessage("Finished.");
        return this.data;
    }

    protected int fillAreasWSolidTerrain(Terrain t, Terrain[][] terrain, int filledcount, int terrainnum) {
        Double[] probs = (Double[])this.terrainToProbabilities.get(0).getValue();
        double probability = probs[terrainnum];
        probs = (Double[])this.terrainToProbabilities.get(1).getValue();
        probability += probs[terrainnum].doubleValue();
        probs = (Double[])this.terrainToProbabilities.get(2).getValue();
        probability += probs[terrainnum].doubleValue();
        probs = (Double[])this.terrainToProbabilities.get(3).getValue();
        probability += probs[terrainnum].doubleValue();
        probs = (Double[])this.terrainToProbabilities.get(4).getValue();
        probability += probs[terrainnum].doubleValue();
        probs = (Double[])this.terrainToProbabilities.get(5).getValue();
        probability += probs[terrainnum].doubleValue();
        probs = (Double[])this.terrainToProbabilities.get(6).getValue();
        probability += probs[terrainnum].doubleValue();
        probs = (Double[])this.terrainToProbabilities.get(7).getValue();
        probability += probs[terrainnum].doubleValue();
        probs = (Double[])this.terrainToProbabilities.get(8).getValue();
        probability += probs[terrainnum].doubleValue();
        probs = (Double[])this.terrainToProbabilities.get(9).getValue();
        probability += probs[terrainnum].doubleValue();
        probs = (Double[])this.terrainToProbabilities.get(10).getValue();
        int numhexestofill = (int)((double)(terrain.length + terrain[0].length) * (probability += probs[terrainnum].doubleValue()) / 20.0);
        int x = (int)(Math.random() * (double)terrain.length);
        int y = (int)(Math.random() * (double)terrain[0].length);
        terrain[x][y] = t;
        while (numhexestofill > 0) {
            int numhexes = (int)(Math.random() * (double)(numhexestofill + 1)) / 4 + 1;
            int startx = (int)(Math.random() * (double)terrain.length);
            int starty = (int)(Math.random() * (double)terrain[0].length);
            int dx = (int)(Math.random() * (double)numhexestofill);
            int dy = numhexes - Math.abs(dx);
            double ax = startx;
            double ay = starty;
            for (int i = 0; i < numhexes; ++i) {
                terrain[(int)ax][(int)ay] = t.clone();
                ++filledcount;
                boolean negativex = (int)(Math.random() * 2.0) == 1;
                boolean negativey = (int)(Math.random() * 2.0) == 1;
                ax += (negativex ? -1.0 : 1.0) * (double)dx / (double)numhexestofill;
                ay += (negativey ? -1.0 : 1.0) * (double)dy / (double)numhexestofill;
                if (ax < 0.0 || ax >= (double)terrain.length) {
                    i = numhexes;
                }
                if (ay < 0.0 || ay >= (double)terrain[0].length) {
                    i = numhexes;
                }
                --numhexestofill;
            }
        }
        return filledcount;
    }

    private int addRandomTerrain(int filledcount, Terrain[][] terrain) {
        Terrain t;
        int numHexesWide = terrain.length;
        int numHexesHigh = terrain[0].length;
        int x = (int)(Math.random() * (double)numHexesWide);
        int y = (int)(Math.random() * (double)numHexesHigh);
        ArrayList<Terrain> adjacentTerrain = new ArrayList<Terrain>();
        if (x > 0) {
            if (x % 2 == 0) {
                if (y < numHexesHigh - 1 && (t = terrain[x - 1][y + 1]) != null && this.terrainNameMatch(t.getTypeName())) {
                    adjacentTerrain.add(t);
                }
                if ((t = terrain[x - 1][y]) != null && this.terrainNameMatch(t.getTypeName())) {
                    adjacentTerrain.add(t);
                }
            } else {
                if (y > 0 && (t = terrain[x - 1][y - 1]) != null && this.terrainNameMatch(t.getTypeName())) {
                    adjacentTerrain.add(t);
                }
                if ((t = terrain[x - 1][y]) != null && this.terrainNameMatch(t.getTypeName())) {
                    adjacentTerrain.add(t);
                }
            }
        }
        if (y > 0 && (t = terrain[x][y - 1]) != null && this.terrainNameMatch(t.getTypeName())) {
            adjacentTerrain.add(t);
        }
        if (y < numHexesHigh - 1 && (t = terrain[x][y + 1]) != null && this.terrainNameMatch(t.getTypeName())) {
            adjacentTerrain.add(t);
        }
        if (x < numHexesWide - 1) {
            if (x % 2 == 0) {
                if (y < numHexesHigh - 1 && (t = terrain[x + 1][y + 1]) != null && this.terrainNameMatch(t.getTypeName())) {
                    adjacentTerrain.add(t);
                }
                if ((t = terrain[x + 1][y]) != null && this.terrainNameMatch(t.getTypeName())) {
                    adjacentTerrain.add(t);
                }
            } else {
                if (y > 0 && (t = terrain[x + 1][y - 1]) != null && this.terrainNameMatch(t.getTypeName())) {
                    adjacentTerrain.add(t);
                }
                if ((t = terrain[x + 1][y]) != null && this.terrainNameMatch(t.getTypeName())) {
                    adjacentTerrain.add(t);
                }
            }
        }
        if (adjacentTerrain.size() > 1) {
            double rockydesert = 0.0;
            double sandydesert = 0.0;
            double grassland = 0.0;
            double farmland = 0.0;
            double ltforest = 0.0;
            double hvyforest = 0.0;
            double fsthills = 0.0;
            double fstmountains = 0.0;
            double hills = 0.0;
            double mountains = 0.0;
            double ocean = 0.0;
            int terraincount = adjacentTerrain.size();
            HashMap<String, Integer> labelstonums = new HashMap<String, Integer>();
            for (int i = 0; i < this.terrainToProbabilities.size(); ++i) {
                labelstonums.put((String)this.terrainToProbabilities.get(i).getKey(), i);
            }
            for (Terrain t2 : adjacentTerrain) {
                Double[] probs = (Double[])this.terrainToProbabilities.get((Integer)labelstonums.get(t2.getTypeName())).getValue();
                if (probs == null) {
                    --terraincount;
                    continue;
                }
                rockydesert += probs[0] / 100.0;
                sandydesert += probs[1] / 100.0;
                grassland += probs[2] / 100.0;
                farmland += probs[3] / 100.0;
                hvyforest = (ltforest += probs[4] / 100.0) + probs[5] / 100.0;
                fsthills += probs[6] / 100.0;
                fstmountains += probs[7] / 100.0;
                hills += probs[8] / 100.0;
                mountains += probs[9] / 100.0;
                ocean += probs[10] / 100.0;
            }
            ocean /= (double)terraincount;
            double d = Math.random();
            Terrain t3 = null;
            t3 = d < rockydesert ? new Terrain((String)this.terrainToProbabilities.get(0).getKey(), true) : (d < rockydesert + sandydesert ? new Terrain((String)this.terrainToProbabilities.get(1).getKey(), true) : (d < rockydesert + sandydesert + grassland ? new Terrain((String)this.terrainToProbabilities.get(2).getKey(), true) : (d < rockydesert + sandydesert + grassland + farmland ? new Terrain((String)this.terrainToProbabilities.get(3).getKey(), true) : (d < rockydesert + sandydesert + grassland + farmland + ltforest ? new Terrain((String)this.terrainToProbabilities.get(4).getKey(), true) : (d < (rockydesert /= (double)terraincount) + (sandydesert /= (double)terraincount) + grassland + farmland + ltforest + hvyforest ? new Terrain((String)this.terrainToProbabilities.get(5).getKey(), true) : (d < rockydesert + sandydesert + (grassland /= (double)terraincount) + (farmland /= (double)terraincount) + ltforest + hvyforest + fsthills ? new Terrain((String)this.terrainToProbabilities.get(6).getKey(), true) : (d < rockydesert + sandydesert + grassland + farmland + (ltforest /= (double)terraincount) + (hvyforest /= (double)terraincount) + fsthills + fstmountains ? new Terrain((String)this.terrainToProbabilities.get(7).getKey(), true) : (d < rockydesert + sandydesert + grassland + farmland + ltforest + hvyforest + (fsthills /= (double)terraincount) + (fstmountains /= (double)terraincount) + hills ? new Terrain((String)this.terrainToProbabilities.get(8).getKey(), true) : (d < rockydesert + sandydesert + grassland + farmland + ltforest + hvyforest + fsthills + fstmountains + (hills /= (double)terraincount) + (mountains /= (double)terraincount) ? new Terrain((String)this.terrainToProbabilities.get(9).getKey(), true) : new Terrain((String)this.terrainToProbabilities.get(10).getKey(), true))))))))));
            terrain[x][y] = t3;
            ++filledcount;
        }
        return filledcount;
    }

    private boolean terrainNameMatch(String tname) {
        for (Pair<String, Double[]> terrainToProbability : this.terrainToProbabilities) {
            if (!((String)terrainToProbability.getKey()).equals(tname)) continue;
            return true;
        }
        return false;
    }
}

