/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.ui;

import com.inkwellideas.ographer.generator.world.WorldAndNameData;
import com.inkwellideas.ographer.information.Culture;
import com.inkwellideas.ographer.information.Information;
import com.inkwellideas.ographer.information.Nation;
import com.inkwellideas.ographer.information.Religion;
import com.inkwellideas.ographer.ui.Worldographer;
import com.inkwellideas.ographer.ui.dialog.StandardDialog;
import com.inkwellideas.ographer.ui.widget.PopupStage;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TextField;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.web.HTMLEditor;
import javafx.stage.Stage;
import javafx.util.Callback;
import javafx.util.Pair;

public class WorldBook
extends PopupStage
implements ChangeListener<TreeItem<Information>> {
    final BorderPane borderPane = new BorderPane();
    GridPane dataPane;
    HTMLEditor details;
    final Label culturesLabel = new Label("");
    ComboBox<Information> culturesCombo = new ComboBox();
    ComboBox<String> langsCombo = new ComboBox();
    final List<Information> infos;
    TreeView<Information> tree;
    Information currentInfo = null;
    public static String VERSION = "0.3";
    private Worldographer worldographer;

    public WorldBook(Worldographer worldographer, List<Information> info) {
        this.worldographer = worldographer;
        this.infos = info;
    }

    public void start(Stage popStage) {
        popStage.setTitle("World Information");
        this.setLocationAndPopup((Pane)this.borderPane, 900, 480, this.worldographer, popStage);
        TreeItem rootItem = new TreeItem((Object)new Culture("1", "2", "3"), null);
        rootItem.setExpanded(true);
        this.addChildTreeNodes((TreeItem<Information>)rootItem, this.infos, null);
        this.tree = new TreeView(rootItem);
        this.tree.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        this.tree.getSelectionModel().selectedItemProperty().addListener((ChangeListener)this);
        this.tree.setShowRoot(false);
        this.tree.setEditable(true);
        this.setupContextMenus(popStage);
        this.tree.setPrefSize(140.0, 440.0);
        this.borderPane.setLeft(this.tree);
        Button regeneratebutton = new Button("Regenerate All Data");
        regeneratebutton.setOnAction(event -> {
            Dialog d = new Dialog();
            d.setTitle("Confirm Regenerate All Data");
            d.setHeaderText("Are you sure?");
            d.getDialogPane().setContent((Node)new Label("Doing this will rewrite all the non-map data. Continue?"));
            ButtonType yes = new ButtonType("Yes");
            ButtonType no = new ButtonType("Cancel");
            d.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{yes, no});
            Optional result = d.showAndWait();
            if (result.isPresent() && result.get() == yes) {
                this.infos.removeAll(this.infos);
                this.infos.addAll(WorldAndNameData.generateAllInfo(10));
                this.rebuildTree(null);
            }
        });
        HBox topbox = new HBox();
        topbox.setAlignment(Pos.BASELINE_RIGHT);
        topbox.getChildren().add((Object)regeneratebutton);
        this.dataPane = new GridPane();
        this.dataPane.setHgap(5.0);
        this.dataPane.setVgap(5.0);
        this.dataPane.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        this.dataPane.add((Node)topbox, 0, 0, 3, 1);
        this.borderPane.setRight((Node)this.dataPane);
        this.details = new HTMLEditor();
        this.details.setPrefSize(640.0, 440.0);
        this.dataPane.add((Node)this.details, 0, 1, 3, 1);
        Button saveButton = new Button("Save");
        saveButton.setOnAction(event -> {
            if (this.tree.getSelectionModel().getSelectedItem() != null) {
                this.save((Information)((TreeItem)this.tree.getSelectionModel().getSelectedItem()).getValue());
            }
        });
        Button resetButton = new Button("Reset");
        resetButton.setOnAction(event -> this.details.setHtmlText(((Information)((TreeItem)this.tree.getSelectionModel().getSelectedItem()).getValue()).getText()));
        Button closeButton = new Button("Close");
        closeButton.setOnAction(event -> popStage.close());
        this.dataPane.add((Node)this.culturesLabel, 0, 2);
        HBox bottombox = new HBox();
        bottombox.getChildren().add((Object)new Label("Right-click tree to add, move, rename, & remove. Text auto-saves when switching notes."));
        this.dataPane.add((Node)bottombox, 0, 3, 2, 1);
        HBox buttonbox = new HBox();
        buttonbox.getChildren().add((Object)saveButton);
        buttonbox.getChildren().add((Object)resetButton);
        buttonbox.getChildren().add((Object)closeButton);
        buttonbox.setAlignment(Pos.BASELINE_RIGHT);
        this.dataPane.add((Node)buttonbox, 2, 3);
        popStage.show();
        this.tree.getSelectionModel().select(0);
    }

    private void rebuildTree(Information selection) {
        TreeItem arootItem = new TreeItem((Object)new Culture("1", "2", "3"), null);
        arootItem.setExpanded(true);
        TreeItem<Information> selected = this.addChildTreeNodes((TreeItem<Information>)arootItem, this.infos, selection);
        this.tree.setRoot(arootItem);
        if (selected != null) {
            this.tree.getSelectionModel().select(this.tree.getRow(selected));
        }
    }

    private void setupContextMenus(final Stage parentStage) {
        this.tree.setCellFactory((Callback)new Callback<TreeView<Information>, TreeCell<Information>>(this){
            final /* synthetic */ WorldBook this$0;
            {
                this.this$0 = this$0;
            }

            public TreeCell<Information> call(TreeView<Information> p) {
                TreeCell<Information> cell = new TreeCell<Information>(this){

                    protected void updateItem(Information file, boolean empty) {
                        super.updateItem((Object)file, empty);
                        if (empty) {
                            this.setText(null);
                        } else {
                            this.setText(file.toString());
                        }
                    }
                };
                ContextMenu cm = this.this$0.createContextMenu(parentStage, cell);
                cell.setContextMenu(cm);
                return cell;
            }
        });
    }

    private void getCultures(List<Information> input, List<Information> cultures) {
        for (Information i2 : input) {
            if (i2 instanceof Culture) {
                cultures.add(i2);
            }
            if (i2.children == null) continue;
            this.getCultures(i2.children, cultures);
        }
    }

    private ContextMenu createContextMenu(Stage parentStage, TreeCell<Information> cell) {
        ContextMenu cm = new ContextMenu();
        MenuItem addChildItem = new MenuItem("Add Child");
        addChildItem.setOnAction(event -> this.addChild(cell));
        cm.getItems().add((Object)addChildItem);
        MenuItem addBeforeItem = new MenuItem("Add Before");
        addBeforeItem.setOnAction(event -> this.addNode(cell, true, null));
        cm.getItems().add((Object)addBeforeItem);
        MenuItem addAfterItem = new MenuItem("Add After");
        addAfterItem.setOnAction(event -> this.addNode(cell, false, null));
        cm.getItems().add((Object)addAfterItem);
        MenuItem moveUpItem = new MenuItem("Move Up Within Level");
        moveUpItem.setOnAction(event -> {
            Pair<Information, Integer> parent;
            Information info = (Information)cell.getItem();
            if (info != null && (parent = this.findParent(info, this.infos)) != null) {
                if (parent.getKey() != null) {
                    ((Information)parent.getKey()).children.remove(info);
                    ((Information)parent.getKey()).addChild(Math.max(0, (Integer)parent.getValue() - 1), info);
                    this.rebuildTree(info);
                } else {
                    this.infos.remove(info);
                    this.infos.add(Math.max(0, (Integer)parent.getValue() - 1), info);
                    this.rebuildTree(info);
                }
            }
        });
        cm.getItems().add((Object)moveUpItem);
        MenuItem moveDownItem = new MenuItem("Move Down Within Level");
        moveDownItem.setOnAction(event -> {
            Pair<Information, Integer> parent;
            Information info = (Information)cell.getItem();
            if (info != null && (parent = this.findParent(info, this.infos)) != null) {
                if (parent.getKey() != null) {
                    ((Information)parent.getKey()).children.remove(info);
                    ((Information)parent.getKey()).addChild((Integer)parent.getValue() + 1, info);
                    this.rebuildTree(info);
                } else {
                    this.infos.remove(info);
                    this.infos.add((Integer)parent.getValue() + 1, info);
                    this.rebuildTree(info);
                }
            }
        });
        cm.getItems().add((Object)moveDownItem);
        MenuItem moveUpLevelItem = new MenuItem("Move Up A Level");
        moveUpLevelItem.setOnAction(event -> {
            Pair<Information, Integer> grandparent;
            Pair<Information, Integer> parent;
            Information info = (Information)cell.getItem();
            if (info != null && (parent = this.findParent(info, this.infos)) != null && (grandparent = this.findParent((Information)parent.getKey(), this.infos)) != null) {
                ((Information)parent.getKey()).children.remove(info);
                if (grandparent.getKey() != null) {
                    ((Information)grandparent.getKey()).addChild(info);
                    this.rebuildTree(info);
                } else {
                    this.infos.add(info);
                }
                this.rebuildTree(info);
            }
        });
        cm.getItems().add((Object)moveUpLevelItem);
        MenuItem moveDownLevelItem = new MenuItem("Move Down A Level");
        moveDownLevelItem.setOnAction(event -> {
            Information info = (Information)cell.getItem();
            if (info != null) {
                Pair<Information, Integer> parent = this.findParent(info, this.infos);
                Dialog d = new Dialog();
                d.setTitle("Select Child");
                d.setHeaderText("Select the destination item.");
                GridPane grid = new GridPane();
                grid.setHgap(10.0);
                grid.setVgap(10.0);
                grid.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
                grid.add((Node)new Label("Destination:"), 0, 0);
                ObservableList options = FXCollections.observableArrayList(this.infos);
                if (parent.getKey() != null) {
                    options = FXCollections.observableArrayList(((Information)parent.getKey()).children);
                }
                options.remove((Object)info);
                ComboBox combo = new ComboBox(options);
                grid.add((Node)combo, 1, 0);
                d.getDialogPane().setContent((Node)grid);
                ButtonType yes = new ButtonType("OK");
                ButtonType cancel = new ButtonType("Cancel");
                d.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{yes, cancel});
                Optional result = d.showAndWait();
                if (result.isPresent() && result.get() == yes) {
                    this.removeInfo(info, this.infos);
                    ((Information)combo.getSelectionModel().getSelectedItem()).addChild(info);
                    this.rebuildTree(info);
                }
            }
        });
        cm.getItems().add((Object)moveDownLevelItem);
        MenuItem renameItem = new MenuItem("Rename");
        renameItem.setOnAction(event -> {
            Information info = (Information)cell.getItem();
            Dialog d = new Dialog();
            d.setTitle("Rename");
            d.setHeaderText("Enter the new name.");
            GridPane grid = new GridPane();
            grid.setHgap(10.0);
            grid.setVgap(10.0);
            grid.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
            grid.add((Node)new Label("Name:"), 0, 0);
            TextField tf = new TextField(info.getName());
            grid.add((Node)tf, 1, 0);
            d.getDialogPane().setContent((Node)grid);
            ButtonType yes = new ButtonType("OK");
            ButtonType cancel = new ButtonType("Cancel");
            d.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{yes, cancel});
            Optional result = d.showAndWait();
            if (result.isPresent() && result.get() == yes) {
                String oldname = info.getName();
                info.setName(tf.getText());
                this.details.setHtmlText(this.details.getHtmlText().replace("<h2>" + oldname, "<h2>" + tf.getText()));
                this.rebuildTree(info);
            }
        });
        cm.getItems().add((Object)renameItem);
        MenuItem removeItem = new MenuItem("Remove");
        removeItem.setOnAction(event -> {
            Information info = (Information)cell.getItem();
            if (info != null) {
                boolean removed;
                boolean inuse = false;
                if (info instanceof Culture) {
                    for (Information i : this.infos) {
                        if (!this.checkForCulture(i, (Culture)info)) continue;
                        inuse = true;
                        break;
                    }
                    if (inuse) {
                        StandardDialog.showDialog(parentStage, "Can Not Remove", "Can not remove that culture.", "The culture is still in use for a religion or nation.", null, null);
                        return;
                    }
                    for (Information i : this.infos) {
                        this.removeCultureFromNations(i, (Culture)info);
                    }
                }
                if (removed = this.removeInfo(info, this.infos)) {
                    this.rebuildTree(null);
                }
            }
        });
        cm.getItems().add((Object)removeItem);
        return cm;
    }

    private boolean checkForCulture(Information i, Culture tofind) {
        List<Culture> cs;
        if (i instanceof Nation && (cs = ((Nation)i).getCultures()).size() > 0 && cs.get(0) == tofind) {
            return true;
        }
        if (i instanceof Religion && ((Religion)i).getCulture() == tofind) {
            return true;
        }
        if (i.children != null) {
            for (Information child : i.children) {
                boolean val = this.checkForCulture(child, tofind);
                if (!val) continue;
                return true;
            }
        }
        return false;
    }

    private void removeCultureFromNations(Information i, Culture tofind) {
        if (i instanceof Nation) {
            List<Culture> cs = ((Nation)i).getCultures();
            cs.removeIf(c -> c == tofind);
        }
        if (i.children != null) {
            for (Information child : i.children) {
                this.removeCultureFromNations(child, tofind);
            }
        }
    }

    private void addChild(TreeCell<Information> cell) {
        Information info = (Information)cell.getItem();
        if (info != null) {
            this.addNode(cell, true, (Pair<Information, Integer>)new Pair((Object)info, (Object)0));
        }
    }

    private void addNode(TreeCell<Information> cell, boolean isBefore, Pair<Information, Integer> parent) {
        Information info = (Information)cell.getItem();
        if (info != null) {
            if (parent == null) {
                parent = this.findParent(info, this.infos);
            }
            Information newInfo = null;
            if (parent != null) {
                if (parent.getKey() != null) {
                    if ("Cultures".equals(((Information)parent.getKey()).getName()) || parent.getKey() instanceof Culture) {
                        String lang = (String)this.promptFor("Select Language", "Select the culture's language.", "Language:", (ObservableList<Object>)FXCollections.observableArrayList(WorldAndNameData.LOCATION_NAME_TYPES));
                        if (lang == null) {
                            return;
                        }
                        newInfo = WorldAndNameData.generateCulture(lang);
                        newInfo.generateInfo();
                    } else if ("Religions".equals(info.getName()) || info instanceof Religion) {
                        ArrayList<Information> cultures = new ArrayList<Information>();
                        this.getCultures(this.infos, cultures);
                        Culture culture = (Culture)this.promptFor("Select Culture", "Select the religion's culture.", "Culture:", (ObservableList<Object>)FXCollections.observableArrayList(cultures));
                        if (culture == null) {
                            return;
                        }
                        newInfo = WorldAndNameData.generateReligion(culture);
                        newInfo.generateInfo();
                    } else if ("Nations".equals(info.getName()) || info instanceof Nation) {
                        ArrayList<Information> cultures = new ArrayList<Information>();
                        this.getCultures(this.infos, cultures);
                        Culture culture = (Culture)this.promptFor("Select Culture", "Select the nation's culture.", "Culture:", (ObservableList<Object>)FXCollections.observableArrayList(cultures));
                        if (culture == null) {
                            return;
                        }
                        newInfo = WorldAndNameData.generateNation(culture);
                        newInfo.generateInfo();
                    } else {
                        String name = this.showNamePromptDialog();
                        if (name == null) {
                            return;
                        }
                        newInfo = new Information(name, "<h2>" + name + "</h2><p>details</p>", null);
                    }
                    ((Information)parent.getKey()).addChild((Integer)parent.getValue() + (isBefore ? 0 : 1), newInfo);
                } else if (parent.getValue() != null) {
                    String name = this.showNamePromptDialog();
                    if (name == null) {
                        return;
                    }
                    this.infos.add((Integer)parent.getValue() + (isBefore ? 0 : 1), new Information(name, "<h2>" + name + "</h2><p>details</p>", null));
                }
            }
            if (info != null) {
                this.rebuildTree(newInfo);
            }
        }
    }

    private Object promptFor(String title, String header, String label, ObservableList<Object> options) {
        Dialog d = new Dialog();
        d.setTitle(title);
        d.setHeaderText(header);
        GridPane grid = new GridPane();
        grid.setHgap(10.0);
        grid.setVgap(10.0);
        grid.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        grid.add((Node)new Label(label), 0, 0);
        ComboBox combo = new ComboBox(options);
        grid.add((Node)combo, 1, 0);
        d.getDialogPane().setContent((Node)grid);
        ButtonType yes = new ButtonType("OK");
        ButtonType cancel = new ButtonType("Cancel");
        d.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{yes, cancel});
        Optional result = d.showAndWait();
        if (result.isPresent() && result.get() == yes) {
            return combo.getSelectionModel().getSelectedItem();
        }
        return null;
    }

    private Pair<Information, Integer> findParent(Information child, List<Information> nodes) {
        if (nodes == this.infos) {
            int count = 0;
            for (Information n : nodes) {
                if (n == child) {
                    return new Pair(null, (Object)count);
                }
                ++count;
            }
        }
        if (nodes == null) {
            return null;
        }
        for (Information n : nodes) {
            if (n.children == null) continue;
            int count = 0;
            for (Information n2 : n.children) {
                if (n2 == child) {
                    return new Pair((Object)n, (Object)count);
                }
                ++count;
            }
            Pair<Information, Integer> parent = this.findParent(child, n.children);
            if (parent == null) continue;
            return parent;
        }
        return null;
    }

    private boolean removeInfo(Information toremove, List<Information> nodes) {
        boolean removed = nodes.remove(toremove);
        if (removed) {
            return true;
        }
        if (!removed) {
            for (Information n : nodes) {
                if (n.children != null) {
                    removed = this.removeInfo(toremove, n.children);
                }
                if (!removed) continue;
                return true;
            }
        }
        return false;
    }

    private TreeItem<Information> addChildTreeNodes(TreeItem<Information> parentNode, List<Information> infos, Information selection) {
        TreeItem<Information> selected = null;
        for (Information info : infos) {
            TreeItem<Information> s;
            if (info == null) continue;
            TreeItem<Information> item = new TreeItem<Information>((Object)info);
            parentNode.getChildren().add((Object)item);
            if (info.children != null && (s = this.addChildTreeNodes(item, info.children, selection)) != null) {
                selected = s;
                item.setExpanded(true);
            }
            if (info != selection) continue;
            selected = item;
        }
        return selected;
    }

    private String showNamePromptDialog() {
        Dialog d = new Dialog();
        d.setTitle("New Information");
        d.setHeaderText("Enter the name of the new item.");
        GridPane grid = new GridPane();
        grid.setHgap(10.0);
        grid.setVgap(10.0);
        grid.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        grid.add((Node)new Label("Name:"), 0, 0);
        TextField tf = new TextField("New");
        grid.add((Node)tf, 1, 0);
        d.getDialogPane().setContent((Node)grid);
        ButtonType yes = new ButtonType("OK");
        ButtonType cancel = new ButtonType("Cancel");
        d.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{yes, cancel});
        Optional result = d.showAndWait();
        if (result.isPresent() && result.get() == yes) {
            return tf.getText();
        }
        return null;
    }

    public void changed(ObservableValue<? extends TreeItem<Information>> observableValue, TreeItem<Information> oldItem, TreeItem<Information> newItem) {
        if (oldItem != null && oldItem.getValue() != null) {
            this.save((Information)oldItem.getValue());
        }
        if (newItem == null || newItem.getValue() == null) {
            return;
        }
        this.details.setHtmlText(((Information)newItem.getValue()).getText());
        Information info = (Information)newItem.getValue();
        if (info instanceof Nation || info instanceof Religion) {
            this.culturesLabel.setText("Main Culture:");
            this.dataPane.getChildren().remove(this.culturesCombo);
            ArrayList<Information> cultures = new ArrayList<Information>();
            this.getCultures(this.infos, cultures);
            ObservableList culturesob = FXCollections.observableArrayList(cultures);
            this.culturesCombo = new ComboBox(culturesob);
            if (info instanceof Nation && ((Nation)info).getCultures().size() > 0) {
                this.culturesCombo.getSelectionModel().select((Object)((Nation)info).getCultures().get(0));
            }
            if (info instanceof Religion && ((Religion)info).getCulture() != null) {
                this.culturesCombo.getSelectionModel().select((Object)((Religion)info).getCulture());
            }
            this.dataPane.add(this.culturesCombo, 1, 2);
        } else if (info instanceof Culture) {
            this.culturesLabel.setText("Main Language:");
            this.dataPane.getChildren().remove(this.culturesCombo);
            ObservableList culturesob = FXCollections.observableArrayList(WorldAndNameData.PERSON_NAME_TYPES);
            this.langsCombo = new ComboBox(culturesob);
            this.langsCombo.getSelectionModel().select((Object)((Culture)info).getLanguage());
            this.dataPane.add(this.langsCombo, 1, 2);
        } else {
            this.culturesLabel.setText("");
        }
    }

    private void save(Information oldItem) {
        oldItem.setText(this.details.getHtmlText());
        if (oldItem instanceof Religion) {
            ((Religion)oldItem).setCulture((Culture)this.culturesCombo.getValue());
        }
        if (oldItem instanceof Nation) {
            List<Culture> cultures = ((Nation)oldItem).getCultures();
            if (cultures.size() > 0 && cultures.get(0) == this.culturesCombo.getValue()) {
                ((Nation)oldItem).getCultures().remove(0);
            }
            cultures.add(0, (Culture)this.culturesCombo.getValue());
        }
        if (oldItem instanceof Culture) {
            ((Culture)oldItem).setLanguage((String)this.langsCombo.getValue());
        }
        Worldographer.getMapUI().getController().getUndoRedoHandler().setChanged(true);
    }
}

