/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.ui;

import atlantafx.base.theme.CupertinoDark;
import atlantafx.base.theme.CupertinoLight;
import atlantafx.base.theme.Dracula;
import com.inkwellideas.ographer.data.HexOrientation;
import com.inkwellideas.ographer.data.MapLayer;
import com.inkwellideas.ographer.data.MapObject;
import com.inkwellideas.ographer.data.ViewLevel;
import com.inkwellideas.ographer.generator.battlemat.BattlematDataGenerator;
import com.inkwellideas.ographer.information.Information;
import com.inkwellideas.ographer.information.Nation;
import com.inkwellideas.ographer.io.AutoSave;
import com.inkwellideas.ographer.io.FileSaveLoad;
import com.inkwellideas.ographer.io.UserPrefs;
import com.inkwellideas.ographer.map.MapData;
import com.inkwellideas.ographer.map.MapLabel;
import com.inkwellideas.ographer.map.MapLogic;
import com.inkwellideas.ographer.map.MapProjection;
import com.inkwellideas.ographer.map.MapShape;
import com.inkwellideas.ographer.map.Terrain;
import com.inkwellideas.ographer.model.Feature;
import com.inkwellideas.ographer.model.Note;
import com.inkwellideas.ographer.model.TextureType;
import com.inkwellideas.ographer.ui.MapUI;
import com.inkwellideas.ographer.ui.WorldographerMenuBar;
import com.inkwellideas.ographer.ui.dialog.LicenseDialog;
import com.inkwellideas.ographer.ui.dialog.NoteDialog;
import com.inkwellideas.ographer.ui.gesture.KeyPress;
import com.inkwellideas.ographer.ui.gesture.RightClickMenu;
import com.inkwellideas.ographer.ui.toolbox.FeaturesToolbox;
import com.inkwellideas.ographer.ui.toolbox.FogOfWarToolbox;
import com.inkwellideas.ographer.ui.toolbox.LabelsToolbox;
import com.inkwellideas.ographer.ui.toolbox.LayersToolbox;
import com.inkwellideas.ographer.ui.toolbox.MiniMapToolbox;
import com.inkwellideas.ographer.ui.toolbox.RoomToolbox;
import com.inkwellideas.ographer.ui.toolbox.ShapesToolbox;
import com.inkwellideas.ographer.ui.toolbox.TerrainToolbox;
import com.inkwellideas.ographer.ui.toolbox.UnderlayToolbox;
import com.inkwellideas.ographer.ui.toolbox.ViewLevelBox;
import com.inkwellideas.ographer.ui.toolbox.ViewOptions;
import com.inkwellideas.ographer.ui.toolbox.WLogger;
import com.inkwellideas.ographer.ui.widget.ColorPickerWithSelector;
import com.inkwellideas.ographer.ui.widget.DraggableTab;
import com.inkwellideas.ographer.ui.widget.StyledDialog;
import com.inkwellideas.ographer.undo.CopyDataHolder;
import com.inkwellideas.ographer.undo.Point;
import com.inkwellideas.ographer.undo.UndoAction;
import com.inkwellideas.ographer.undo.UndoActionGroup;
import java.awt.AWTException;
import java.awt.Color;
import java.awt.Frame;
import java.awt.MouseInfo;
import java.awt.Robot;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import javafx.application.Application;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import javafx.geometry.Side;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SplitPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.DataFormat;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Arc;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.Polygon;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import javafx.scene.transform.Rotate;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javafx.util.Pair;

public class Worldographer
extends Application {
    public static boolean REPORTING = false;
    public static ObservableList<String> featureCategories = FXCollections.observableArrayList((Object[])new String[]{"All Features", "Favorites", "Battlemat", "Classic Water", "Classic", "Cosmic", "Creature", "General", "Isometric Region", "Lineart", "Perspective", "Structure", "Token"});
    public static ObservableList<String> terrainCategories = FXCollections.observableArrayList((Object[])new String[]{"All Terrain", "Favorites", "Classic", "Cosmic", "Floor", "Full Classic", "ISO Cols", "ISO Rows"});
    public final FeaturesToolbox featuresToolbox = new FeaturesToolbox(this);
    public final ShapesToolbox shapesToolbox = new ShapesToolbox(this);
    public final TerrainToolbox terrainToolbox = new TerrainToolbox(this);
    public final LabelsToolbox labelsToolbox = new LabelsToolbox(this);
    public final UnderlayToolbox underlayToolbox = new UnderlayToolbox(this);
    public final MiniMapToolbox miniMapToolbox = new MiniMapToolbox(this);
    public final LayersToolbox layersToolbox = new LayersToolbox(this);
    public final FogOfWarToolbox fogOfWarToolbox = new FogOfWarToolbox(this);
    public final RoomToolbox roomToolbox = new RoomToolbox(this);
    public final ViewOptions viewOptions = new ViewOptions();
    public final ViewLevelBox viewLevelBox = new ViewLevelBox(this);
    public final WLogger WLogger = new WLogger();
    public static final String version = "2.01";
    public static final String ROOT_NODE = "com/inkwellideas/worldographer2025";
    public static final DataFormat SERIALIZED_MIME_TYPE = new DataFormat(new String[]{"application/x-java-serialized-object"});
    public static boolean WAS_DRAGGING = false;
    public static final javafx.scene.paint.Color[] customColors = new javafx.scene.paint.Color[]{new javafx.scene.paint.Color(0.69, 0.69, 0.0, 1.0), new javafx.scene.paint.Color(1.0, 1.0, 0.6, 1.0), new javafx.scene.paint.Color(0.58, 0.78, 0.39, 1.0), new javafx.scene.paint.Color(0.627, 0.843, 0.42, 1.0), new javafx.scene.paint.Color(0.48, 0.7, 0.27, 1.0), new javafx.scene.paint.Color(0.9, 0.95, 0.61, 1.0), new javafx.scene.paint.Color(0.91, 0.81, 0.35, 1.0), new javafx.scene.paint.Color(0.7, 0.5, 0.0, 1.0), new javafx.scene.paint.Color(0.0, 0.4, 0.6, 1.0), new javafx.scene.paint.Color(0.55, 0.7, 0.85, 1.0), new javafx.scene.paint.Color(0.6, 0.8, 1.0, 1.0)};
    static boolean newui = false;
    public static int mapcount = 1;
    private static Frame splashFrame = null;
    public final TabPane tabPane = new TabPane();
    private static MapUI mapUI = null;
    public WorldographerMenuBar worldographerMenuBar;
    public SplitPane splitPane;
    public final ToggleGroup toggleGroup = new ToggleGroup();
    public VBox rightControls = null;
    Point2D mouseLocation;
    public boolean undoEnabled = true;
    CopyDataHolder copyDataHolder = null;
    public final Label maskLabel = new Label(" Mask:");
    public final ColorPicker maskColorPicker = new ColorPicker(javafx.scene.paint.Color.GRAY);
    double scrollbarxdragstart = 0.0;
    double scrollbarydragstart = 0.0;
    public ObservableList<MapLayer> observableLayers = FXCollections.observableList(new ArrayList());
    public Point2D arcDragCenter = null;
    public final ToggleButton selectMapAreaToggle = new ToggleButton("Select\nArea", (Node)new ImageView(this.from("other_imgs/select_area.png")));
    ContextMenu contextMenu = null;
    public Point2D rightClickModelPt = null;
    double rightClickTime = 0.0;
    long adjustView = 0L;
    final Map<Tab, Pair<Double, Double>> tabScrollBarSettings = new HashMap<Tab, Pair<Double, Double>>();
    final BorderPane mapObjectsBorderPane = new BorderPane();
    final ToggleButton selectButton = new ToggleButton("Select");
    final ToggleButton newTerrainButton = new ToggleButton("Place\nTerrain");
    final ToggleButton newFeatureButton = new ToggleButton("Place\nFeatures");
    final FlowPane terrainbuttonpane = new FlowPane();
    public static Stage primaryStage;
    private ListView<String> statusList = new ListView();
    private Button cancelButton = new Button("Cancel");
    private TabPane controlsTabPane = new TabPane();
    Tab layersTab;
    Tab terrainTab;
    Tab featuresTab;
    Tab shapesTab;
    Tab labelsTab;
    Tab roomsTab;
    Tab fogTab;
    Tab traceTab;
    public List<ColorPickerWithSelector> colorPickerWithSelectorList = new ArrayList<ColorPickerWithSelector>();
    private static Worldographer worldographer;

    public static void setSplashFrame(Frame f) {
        splashFrame = f;
    }

    public static void main(String[] args) {
        System.out.println("Worldographer\nRestoring defaults");
        Terrain.restoreDefaults();
        Feature.restoreDefaults(UserPrefs.CONFIG_FOLDER, UserPrefs.FULL);
        for (String arg : args) {
            if (!"newui".equals(arg)) continue;
            newui = true;
            break;
        }
        System.out.println("done restore");
        if (args.length > 0) {
            StringBuilder fnameBuilder = new StringBuilder();
            for (int i = 0; i < args.length; ++i) {
                if (args[i].startsWith("-D") || args[i].startsWith("com.inkwellideas.")) continue;
                if (i != 0) {
                    fnameBuilder.append(" ");
                }
                fnameBuilder.append(args[i]);
            }
            String fname = fnameBuilder.toString();
            if (!"".equals(fname)) {
                FileSaveLoad.loadfile = fname;
            }
        }
        System.out.println("Args checked");
        Worldographer.launch((String[])args);
    }

    public Image from(String location) {
        InputStream x = Worldographer.class.getResourceAsStream(location);
        if (x == null) {
            System.err.println("Unable to load image from " + Worldographer.class.getCanonicalName() + " " + location);
            return null;
        }
        return new Image(x);
    }

    public void start(Stage primaryStage) {
        System.out.println("Start");
        worldographer = this;
        Worldographer.primaryStage = primaryStage;
        this.WLogger.setup();
        System.out.println("Logger set");
        UserPrefs.load();
        System.out.println("Prefs loaded");
        primaryStage.setTitle("Worldographer 2025 v2.01 platform " + System.getProperty("java.version"));
        primaryStage.getIcons().add((Object)this.from("other_imgs/cornerlogo.png"));
        this.splitPane = new SplitPane();
        BorderPane mainborder = new BorderPane();
        Rectangle2D primaryScreenBounds = Screen.getPrimary().getVisualBounds();
        this.viewOptions.initViewOptionsControls();
        this.viewLevelBox.initControls();
        this.terrainToolbox.initTerrainControls();
        this.shapesToolbox.initShapesControls();
        this.miniMapToolbox.initMiniMapControls(this.toggleGroup);
        this.labelsToolbox.initLabelsControls();
        this.featuresToolbox.initFeaturesControls(this.undoEnabled);
        this.worldographerMenuBar = new WorldographerMenuBar(this);
        int width = (int)(primaryScreenBounds.getWidth() * 0.9);
        int height = (int)(primaryScreenBounds.getHeight() * 0.9);
        int largeSize = 2000;
        if (width > height && width > largeSize) {
            height = largeSize * height / width;
            width = largeSize;
        } else if (height > width && height > largeSize) {
            width = largeSize * width / height;
            height = largeSize;
        }
        Scene scene = new Scene((Parent)mainborder, (double)width, (double)height);
        primaryStage.setScene(scene);
        Worldographer.setTheme(UserPrefs.PREFS.get("theme", "Cupertino Dark"));
        scene.addEventFilter(KeyEvent.KEY_PRESSED, event -> KeyPress.handleKeyPress((KeyEvent)event, Worldographer.getMapUI(), this));
        VBox topBox = new VBox();
        topBox.getChildren().add((Object)this.worldographerMenuBar.createMenuBar());
        mainborder.setTop((Node)topBox);
        mainborder.setCenter((Node)this.splitPane);
        this.splitPane.getItems().add((Object)this.tabPane);
        this.tabPane.getSelectionModel().selectedItemProperty().addListener(this::tabPaneSelectionModelChange);
        mainborder.setBottom(this.viewOptions.createViewOptionsBar(primaryStage, this.toggleGroup, Worldographer.getMapUI()));
        primaryStage.show();
        primaryStage.setOnCloseRequest(this::onClose);
        scene.setOnKeyPressed(t -> {
            if (t.getCode() == KeyCode.UP || t.getCode() == KeyCode.DOWN || t.getCode() == KeyCode.LEFT || t.getCode() == KeyCode.RIGHT) {
                KeyPress.handleKeyPress(t, Worldographer.getMapUI(), this);
            }
        });
        this.setupResizeDetection();
        new LicenseDialog().showLicenseDialog((Window)primaryStage);
        UserPrefs.freeModeAlert();
        if (!"".equals(FileSaveLoad.loadfile)) {
            new FileSaveLoad(this).loadFile(new File(FileSaveLoad.loadfile), false, Integer.MAX_VALUE, Integer.MAX_VALUE, 0, false);
        }
        if (splashFrame != null) {
            splashFrame.dispose();
        }
        AutoSave.start(this);
    }

    public static void setTheme(String themeName) {
        Worldographer.getWorldographer().getPrimaryStage().getScene().getStylesheets().clear();
        if (themeName.equals("Cupertino Light")) {
            Application.setUserAgentStylesheet((String)new CupertinoLight().getUserAgentStylesheet());
            Worldographer.getWorldographer().getPrimaryStage().getScene().getStylesheets().add((Object)Worldographer.class.getResource("light-mode-toggle.css").toExternalForm());
        } else if (themeName.equals("Dracula")) {
            Application.setUserAgentStylesheet((String)new Dracula().getUserAgentStylesheet());
            Worldographer.getWorldographer().getPrimaryStage().getScene().getStylesheets().add((Object)Worldographer.class.getResource("dark-mode-toggle.css").toExternalForm());
        } else {
            Application.setUserAgentStylesheet((String)new CupertinoDark().getUserAgentStylesheet());
            Worldographer.getWorldographer().getPrimaryStage().getScene().getStylesheets().add((Object)Worldographer.class.getResource("dark-mode-toggle.css").toExternalForm());
        }
        Worldographer.getWorldographer().getPrimaryStage().getScene().getStylesheets().add((Object)Worldographer.class.getResource("restore-scrollbar.css").toExternalForm());
        UserPrefs.PREFS.put("theme", themeName);
    }

    public static Worldographer getWorldographer() {
        return worldographer;
    }

    public void addStatus(String message) {
        String old;
        boolean isUpdate = false;
        if (this.statusList.getItems().size() > 0 && (old = (String)this.statusList.getItems().get(this.statusList.getItems().size() - 1)).length() > 12 && message.length() > 12 && old.substring(0, 12).equals(message.substring(0, 12))) {
            isUpdate = true;
        }
        this.addStatus(message, isUpdate);
    }

    public void addStatus(String message, boolean isUpdate) {
        if (!isUpdate && this.statusList.getItems().size() > 30) {
            this.statusList.getItems().remove(0);
        }
        if (isUpdate && this.statusList.getItems().size() > 0) {
            this.statusList.getItems().remove(this.statusList.getItems().size() - 1);
        }
        this.statusList.getItems().add((Object)message);
        this.statusList.scrollTo(this.statusList.getItems().size() - 1);
    }

    public ListView<String> getStatusList() {
        return this.statusList;
    }

    public Button getCancelButton() {
        return this.cancelButton;
    }

    private void setupCosmicSpecificControls() {
        this.viewLevelBox.setupKingdomSpecificControls();
        this.worldographerMenuBar.setupWorldKingdomMenu();
        this.resetTerrainAndFeatureFilters();
        if (Worldographer.getMapUI().getMapData().getMapProjection() == MapProjection.ICOSAHEDRAL) {
            this.maskLabel.setVisible(true);
            this.maskColorPicker.setVisible(true);
        } else {
            this.maskLabel.setVisible(false);
            this.maskColorPicker.setVisible(false);
        }
        if (!this.worldographerMenuBar.toolboxMenuItem.isSelected() && this.controlsTabPane.getTabs().contains((Object)this.roomsTab)) {
            this.controlsTabPane.getTabs().remove((Object)this.roomsTab);
        }
        this.viewLevelBox.updateViewLevelBox(Worldographer.getMapUI().getViewLevel());
    }

    private void resetTerrainAndFeatureFilters() {
        if (this.terrainToolbox.terrainFilterComboBox != null && mapUI != null && Worldographer.mapUI.lastTerrainFilterCombo != null) {
            this.terrainToolbox.terrainFilterComboBox.getSelectionModel().select((Object)Worldographer.mapUI.lastTerrainFilterCombo);
            this.terrainToolbox.filterTerrainTF.setText(Worldographer.mapUI.lastTerrainFilterText);
        }
        if (this.featuresToolbox.featureFilterComboBox != null && mapUI != null && Worldographer.mapUI.lastFeatureFilterCombo != null) {
            this.featuresToolbox.featureFilterComboBox.getSelectionModel().select((Object)Worldographer.mapUI.lastFeatureFilterCombo);
            this.featuresToolbox.featureFilterTF.setText(Worldographer.mapUI.lastFeatureFilterText);
        }
    }

    private void setupWorldKingdomSpecificControls() {
        this.viewLevelBox.setupKingdomSpecificControls();
        this.worldographerMenuBar.setupWorldKingdomMenu();
        this.resetTerrainAndFeatureFilters();
        if (Worldographer.getMapUI().getMapData().getMapProjection() == MapProjection.ICOSAHEDRAL) {
            this.maskLabel.setVisible(true);
            this.maskColorPicker.setVisible(true);
        } else {
            this.maskLabel.setVisible(false);
            this.maskColorPicker.setVisible(false);
        }
        if (!this.worldographerMenuBar.toolboxMenuItem.isSelected() && this.controlsTabPane.getTabs().contains((Object)this.roomsTab)) {
            this.controlsTabPane.getTabs().remove((Object)this.roomsTab);
        }
        this.viewLevelBox.updateViewLevelBox(Worldographer.getMapUI().getViewLevel());
    }

    private void setupBattlematSpecificControls() {
        this.maskLabel.setVisible(false);
        this.maskColorPicker.setVisible(false);
        this.worldographerMenuBar.setupBattlematMenu();
        this.resetTerrainAndFeatureFilters();
        if (this.roomToolbox != null && !this.worldographerMenuBar.toolboxMenuItem.isSelected() && this.controlsTabPane.getTabs().size() > 4 && !this.controlsTabPane.getTabs().contains((Object)this.roomsTab)) {
            this.controlsTabPane.getTabs().add(5, (Object)this.roomsTab);
        }
        this.viewLevelBox.updateViewLevelBox(Worldographer.getMapUI().getViewLevel());
    }

    private void setupSettlementSpecificControls() {
        this.maskLabel.setVisible(false);
        this.maskColorPicker.setVisible(false);
        this.worldographerMenuBar.setupSettlementMenu();
        this.resetTerrainAndFeatureFilters();
        if (!this.worldographerMenuBar.toolboxMenuItem.isSelected() && this.controlsTabPane.getTabs().contains((Object)this.roomsTab)) {
            this.controlsTabPane.getTabs().remove((Object)this.roomsTab);
        }
        this.viewLevelBox.updateViewLevelBox(Worldographer.getMapUI().getViewLevel());
    }

    private void setupResizeDetection() {
        ChangeListener listener = (observable, oldValue, newValue) -> {
            if (Worldographer.getMapUI() == null) {
                return;
            }
            Worldographer.getMapUI().setMinWidth(primaryStage.getWidth() / 2.0);
            Worldographer.getMapUI().setMaxWidth(primaryStage.getWidth());
            Worldographer.getMapUI().setMaxHeight(primaryStage.getHeight() - 70.0);
            Worldographer.getMapUI().resetOverview();
            Worldographer.getMapUI().recaclulateMapSize();
            Worldographer.getMapUI().draw();
            this.viewLevelBox.updateOverviewLabel(false);
        };
        primaryStage.widthProperty().addListener(listener);
        primaryStage.heightProperty().addListener(listener);
    }

    public void updateSelectionControls() {
        this.undoEnabled = false;
        Object o = null;
        if (Worldographer.getMapUI().getCurrentObjects().size() > 0) {
            o = Worldographer.getMapUI().getCurrentObjects().get(0);
        }
        if (o == null) {
            return;
        }
        if (o instanceof Feature) {
            Feature f = o;
            this.featuresToolbox.updateSelectionControls(f);
        }
        if (o instanceof MapLabel) {
            MapLabel ml = o;
            this.labelsToolbox.updateSelectionControls(ml);
        }
        if (o instanceof Terrain) {
            Terrain t = o;
            this.terrainToolbox.updateSelectionControls(t);
        }
        if (o instanceof MapShape) {
            MapShape ms = o;
            this.shapesToolbox.updateSelectionControls(ms);
        }
        this.undoEnabled = true;
    }

    public void handleMouseMoved(MouseEvent t) {
        Object o = this.toggleGroup.getSelectedToggle();
        if (o != null) {
            o = this.toggleGroup.getSelectedToggle().getUserData();
        }
        if (o instanceof Feature) {
            Feature f = (Feature)o;
            this.featuresToolbox.handleMouseMoved(t.getX(), t.getY(), f);
        } else if (o instanceof MapLabel) {
            Worldographer.getMapUI().setPlacingObject(this.labelsToolbox.makeMapLabel(t));
            Worldographer.getMapUI().draw();
        } else if (this.roomToolbox.newRoomButton.isSelected()) {
            int i = (int)(t.getX() / mapUI.getMapData().getTileWidth() * 4.0 + Worldographer.mapUI.hScrollBar.getValue() / 300.0 * 4.0);
            int j = (int)(t.getY() / mapUI.getMapData().getTileHeight() * 4.0 + Worldographer.mapUI.vScrollBar.getValue() / 300.0 * 4.0);
            Point2D coords1 = new Point2D((double)i / 4.0, (double)j / 4.0);
            double topleftx = coords1.getX() - (Double)this.roomToolbox.tilesWideSpinner.getValue() / 2.0;
            double toplefty = coords1.getY() - (Double)this.roomToolbox.tilesHighSpinner.getValue() / 2.0;
            MapShape ms = BattlematDataGenerator.makeRoom(topleftx, toplefty, topleftx + (Double)this.roomToolbox.tilesWideSpinner.getValue(), toplefty + (Double)this.roomToolbox.tilesHighSpinner.getValue(), ((TextureType)this.roomToolbox.wallTextureStrokeCombo.getValue()).toString(), 0.15, ((TextureType)this.roomToolbox.floorTextureFillCombo.getValue()).toString(), mapUI.getMapData().getMapLayer("Above Terrain"));
            ms.setCurrentShapeViewLevel(Worldographer.mapUI.viewLevel);
            mapUI.setPlacingObject(ms);
            mapUI.draw();
        } else {
            Worldographer.getMapUI().setPlacingObject(null);
        }
        if (this.worldographerMenuBar.showHoverDetailsItem.isSelected() && this.toggleGroup.getSelectedToggle() == null) {
            boolean showterraintooltips = Worldographer.getMapUI().getViewLevel() == ViewLevel.WORLD || Worldographer.getMapUI().getViewLevel() == ViewLevel.CONTINENT || Worldographer.getMapUI().getViewLevel() == ViewLevel.KINGDOM || Worldographer.getMapUI().getViewLevel() == ViewLevel.PROVINCE;
            Point2D modelpt = Worldographer.getMapUI().getModelCoordsFromScreenPt(t.getX(), t.getY());
            Point2D ptonscreen = Worldographer.getMapUI().getScreenCoordsFromModelCoords(modelpt.getX(), modelpt.getY());
            this.addToolTip(modelpt, ptonscreen, showterraintooltips);
        }
        this.mouseLocation = new Point2D(t.getSceneX(), t.getSceneY());
        boolean triggered = false;
        block0: for (MapObject mo : Worldographer.getMapUI().getCurrentObjects()) {
            if (!(mo instanceof MapShape)) continue;
            MapShape ms = (MapShape)mo;
            for (Point2D pt : ms.getShapePoints()) {
                Point2D shapeptonscreen = Worldographer.getMapUI().getScreenCoordsFromModelCoords(pt.getX(), pt.getY());
                double diffx = Math.abs(shapeptonscreen.getX() - t.getX());
                double diffy = Math.abs(shapeptonscreen.getY() - t.getY());
                if (!(diffx < 5.0) || !(diffy < 5.0)) continue;
                Worldographer.getMapUI().hoverObject = pt;
                Worldographer.getMapUI().draw();
                triggered = true;
                continue block0;
            }
        }
        if (this.featuresToolbox.featuresSelectButton != null && this.featuresToolbox.featuresSelectButton.isSelected()) {
            Point2D modelpt = Worldographer.getMapUI().getModelCoordsFromScreenPt(t.getX(), t.getY());
            Feature f = this.getFeatureMouseIsOver(modelpt, false);
            if (f != null && f.getMapLayer() != null && f.getMapLayer().isVisible()) {
                Worldographer.getMapUI().hoverObject = f;
                Worldographer.getMapUI().draw();
                triggered = true;
            }
        } else if (this.labelsToolbox.labelSelectButton != null && this.labelsToolbox.labelSelectButton.isSelected()) {
            double offseth = Worldographer.getMapUI().hScrollBar.getValue() / Worldographer.getMapUI().hScrollBar.getMax() * (Worldographer.getMapUI().computeTotalMapWidthPixelsCurrentTileSize() - Worldographer.getMapUI().canvas.getWidth());
            double offsetv = Worldographer.getMapUI().vScrollBar.getValue() / Worldographer.getMapUI().vScrollBar.getMax() * (Worldographer.getMapUI().computeTotalMapHeightPixelsCurrentTileSize() - Worldographer.getMapUI().canvas.getHeight());
            Point2D modelpt = Worldographer.getMapUI().getModelCoordsFromScreenPt(t.getX(), t.getY());
            Point2D ptonscreen = new Point2D(modelpt.getX() * mapUI.getMapData().getTileWidth() / 300.0 - offseth, modelpt.getY() * mapUI.getMapData().getTileHeight() / 300.0 - offsetv);
            for (MapLabel ml : Worldographer.getMapUI().getMapData().getMapLabels()) {
                if (ml.getMapLayer() != null && !ml.getMapLayer().isVisible() || ml.getLocation(mapUI.getViewLevel()) == null || !Worldographer.mapUI.canvas.isInsideLabelBoundingBox(ml, ptonscreen)) continue;
                Worldographer.getMapUI().hoverObject = ml;
                Worldographer.getMapUI().draw();
                triggered = true;
            }
        } else if (ShapesToolbox.shapesSelectButton != null && ShapesToolbox.shapesSelectButton.isSelected()) {
            block3: for (MapShape ms : Worldographer.getMapUI().getMapData().getShapes()) {
                if (ms.getMapLayer() != null && !ms.getMapLayer().isVisible()) continue;
                for (Point2D pt : ms.getShapePoints()) {
                    Point2D shapeptonscreen = Worldographer.getMapUI().getScreenCoordsFromModelCoords(pt.getX(), pt.getY());
                    double diffx = Math.abs(shapeptonscreen.getX() - t.getX());
                    double diffy = Math.abs(shapeptonscreen.getY() - t.getY());
                    if (!(diffx < 5.0) || !(diffy < 5.0)) continue;
                    Worldographer.getMapUI().hoverObject = ms;
                    Worldographer.getMapUI().draw();
                    triggered = true;
                    continue block3;
                }
            }
        }
        if (Worldographer.getMapUI().hoverObject != null && !triggered) {
            Worldographer.getMapUI().hoverObject = null;
            Worldographer.getMapUI().draw();
        }
    }

    private void addToolTip(Point2D modelpt, Point2D ptonscreen, boolean showterraintooltips) {
        boolean set = false;
        for (Note n : Worldographer.getMapUI().getMapData().getNotes()) {
            Point2D loc = n.getLocation(Worldographer.getMapUI().viewLevel);
            double diffx = Math.abs(modelpt.getX() - loc.getX());
            double diffy = Math.abs(modelpt.getY() - loc.getY());
            if (!(diffx < 50.0) || !(diffy < 50.0)) continue;
            Object ttt = n.getTitle();
            if (n.getDetails() != null) {
                String[] html;
                ttt = (String)ttt + "\n";
                Object details = n.getDetails();
                for (String htmltag : html = new String[]{"<html", "<head", "</head", "<body", "<p></p>", "<p", "</p>", "<span", "</span", "<ul", "</ul", "<li", "</li", "</body", "</html"}) {
                    while (((String)details).contains(htmltag)) {
                        int start = ((String)details).indexOf(htmltag);
                        String sub = ((String)details).substring(start);
                        int end = sub.indexOf(">");
                        boolean hasnewline = htmltag.equals("</li") || htmltag.equals("</p>");
                        details = ((String)details).substring(0, start) + (hasnewline ? "\n" : "") + ((String)details).substring(start + end + 1);
                    }
                }
                details = ((String)details).replaceAll("&nbsp;", " ");
                ttt = (String)ttt + (String)details;
            }
            if (Worldographer.getMapUI().getToolTipText() != null && ((String)ttt).equals(Worldographer.getMapUI().getToolTipText().getValue())) continue;
            String[] lines = ((String)ttt).split("\n");
            ttt = "";
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i];
                if (i != 0) {
                    ttt = (String)ttt + "\n";
                }
                if (line.length() < 50) {
                    ttt = (String)ttt + line;
                    continue;
                }
                String[] words = line.split(" ");
                Object assembledLine = words[0];
                for (int j = 1; j < words.length; ++j) {
                    int length = ((String)assembledLine).length() + words[j].length() + 1;
                    if (length < 45) {
                        assembledLine = (String)assembledLine + " " + words[j];
                        continue;
                    }
                    ttt = (String)ttt + (String)assembledLine + "\n";
                    assembledLine = words[j];
                }
                if (((String)assembledLine).length() <= 0) continue;
                ttt = (String)ttt + (String)assembledLine;
            }
            Pair tooltip = new Pair((Object)new Point2D(ptonscreen.getX(), ptonscreen.getY()), ttt);
            Worldographer.getMapUI().setToolTipText((Pair<Point2D, String>)tooltip);
            Worldographer.getMapUI().draw();
            set = true;
        }
        if (!set) {
            for (Feature f : Worldographer.getMapUI().getMapData().getFeatures()) {
                double diffx = Math.abs(modelpt.getX() - f.getLocation(Worldographer.getMapUI().getViewLevel()).getX());
                double diffy = Math.abs(modelpt.getY() - f.getLocation(Worldographer.getMapUI().getViewLevel()).getY());
                if (!(diffx < 50.0) || !(diffy < 50.0)) continue;
                Pair tooltip = new Pair((Object)new Point2D(ptonscreen.getX(), ptonscreen.getY()), (Object)f.getTypeName());
                Worldographer.getMapUI().setToolTipText((Pair<Point2D, String>)tooltip);
                Worldographer.getMapUI().draw();
                set = true;
            }
        }
        if (showterraintooltips) {
            Terrain ter;
            Pair<Integer, Integer> tercoord = Worldographer.getMapUI().getTerrainFromModelPt(modelpt.getX(), modelpt.getY());
            if (!set && tercoord != null && (Integer)tercoord.getKey() >= 0 && (Integer)tercoord.getValue() >= 0 && (Integer)tercoord.getKey() < Worldographer.getMapUI().getMapData().getTerrain(Worldographer.getMapUI().getViewLevel()).length && (Integer)tercoord.getValue() < Worldographer.getMapUI().getMapData().getTerrain(Worldographer.getMapUI().getViewLevel())[(Integer)tercoord.getKey()].length && (ter = Worldographer.getMapUI().getMapData().getTerrain(Worldographer.getMapUI().getViewLevel())[(Integer)tercoord.getKey()][(Integer)tercoord.getValue()]) != null) {
                String ttt = ter.getTypeName() + " Elev:" + ter.getElevation() + "\nAnimals:" + ter.getExtraInfo().getResources()[0] + " Brick:" + ter.getExtraInfo().getResources()[1] + " Crops:" + ter.getExtraInfo().getResources()[2] + " Gems:" + ter.getExtraInfo().getResources()[3] + "\nLumber:" + ter.getExtraInfo().getResources()[3] + " Metals:" + ter.getExtraInfo().getResources()[4] + " Crops:" + ter.getExtraInfo().getResources()[5] + " Rock:" + ter.getExtraInfo().getResources()[6];
                if (Worldographer.getMapUI().getToolTipText() == null || !ttt.equals(Worldographer.getMapUI().getToolTipText().getValue())) {
                    Pair tooltip = new Pair((Object)new Point2D(ptonscreen.getX(), ptonscreen.getY()), (Object)ttt);
                    Worldographer.getMapUI().setToolTipText((Pair<Point2D, String>)tooltip);
                    Worldographer.getMapUI().draw();
                    set = true;
                }
            }
        }
        if (!set && Worldographer.getMapUI().getToolTipText() != null) {
            Worldographer.getMapUI().setToolTipText(null);
            Worldographer.getMapUI().draw();
        }
    }

    public void handleMouseDragged(MouseEvent t) {
        if (this.adjustView(t)) {
            return;
        }
        if (this.miniMapToolbox.panButton.isSelected() || t.isAltDown() || t.isMiddleButtonDown()) {
            if (Worldographer.getMapUI().dragStart == null) {
                Worldographer.getMapUI().dragStart = new Point2D(t.getX(), t.getY());
                this.scrollbarxdragstart = Worldographer.getMapUI().hScrollBar.getValue();
                this.scrollbarydragstart = Worldographer.getMapUI().vScrollBar.getValue();
            } else {
                double newx = this.scrollbarxdragstart - (t.getX() - Worldographer.getMapUI().dragStart.getX()) * 300.0 / Worldographer.getMapUI().getMapData().getTileWidth();
                double newy = this.scrollbarydragstart - (t.getY() - Worldographer.getMapUI().dragStart.getY()) * 300.0 / Worldographer.getMapUI().getMapData().getTileHeight();
                Worldographer.getMapUI().hScrollBar.setValue(newx);
                Worldographer.getMapUI().vScrollBar.setValue(newy);
                Worldographer.getMapUI().draw();
            }
            t.consume();
            return;
        }
        WAS_DRAGGING = true;
        if (this.worldographerMenuBar.selectItem.isSelected()) {
            if (!Worldographer.getMapUI().creatingDragSelectArea) {
                Worldographer.getMapUI().creatingDragSelectArea = true;
                Worldographer.getMapUI().selectPts.clear();
                Worldographer.getMapUI().selectPts.add(Worldographer.getMapUI().getModelCoordsFromScreenPt(t.getX(), t.getY()));
                return;
            }
            Point2D firstpt = Worldographer.getMapUI().selectPts.get(0);
            Worldographer.getMapUI().selectPts.clear();
            Worldographer.getMapUI().selectPts.add(firstpt);
            Point2D newpt = Worldographer.getMapUI().getModelCoordsFromScreenPt(t.getX(), t.getY());
            Worldographer.getMapUI().selectPts.add(new Point2D(newpt.getX(), Worldographer.getMapUI().selectPts.get(0).getY()));
            Worldographer.getMapUI().selectPts.add(newpt);
            Worldographer.getMapUI().selectPts.add(new Point2D(Worldographer.getMapUI().selectPts.get(0).getX(), newpt.getY()));
            Worldographer.getMapUI().draw();
            return;
        }
        if (this.toggleGroup.getSelectedToggle() == null) {
            return;
        }
        Object o = this.toggleGroup.getSelectedToggle().getUserData();
        if (o instanceof Terrain) {
            Terrain ter = (Terrain)o;
            this.terrainToolbox.placeTerrain(t, ter);
            return;
        }
        if (o instanceof Feature && Worldographer.getMapUI().selectedScalePt == null) {
            double distance = 0.0;
            if (Worldographer.getMapUI().dragPlaceFeatureLastPoint != null) {
                double x = (t.getX() - Worldographer.getMapUI().dragPlaceFeatureLastPoint.getX()) * 300.0 / Worldographer.getMapUI().getMapData().getTileWidth();
                double y = (t.getY() - Worldographer.getMapUI().dragPlaceFeatureLastPoint.getY()) * 300.0 / Worldographer.getMapUI().getMapData().getTileHeight();
                distance = x * x + y * y;
            }
            if (distance == 0.0 || distance > 20000.0) {
                double h;
                Feature f = (Feature)o;
                double w = this.featuresToolbox.featuresScaleCB.isSelected() ? (Double)this.featuresToolbox.featuresScaleSpinner.getValue() : -1.0;
                double diff = Math.random() * 0.4;
                w = w * 0.8 + diff * w;
                double d = h = this.featuresToolbox.featuresScaleHtCB.isSelected() ? (Double)this.featuresToolbox.featuresScaleHtSpinner.getValue() : -1.0;
                if (h != -1.0) {
                    h = h * 0.8 + diff * h;
                }
                this.featuresToolbox.placeFeature(t, f, w, h);
                Worldographer.getMapUI().dragPlaceFeatureLastPoint = new Point2D(t.getX(), t.getY());
            }
            return;
        }
        if (!t.isShiftDown() && !t.isControlDown() && this.shapesToolbox.isSelected()) {
            this.shapesToolbox.placeShapeOrAddPoints(t);
            return;
        }
        if (t.isControlDown() && Worldographer.getMapUI().getCurrentObjects().size() > 0 && Worldographer.getMapUI().draggingObject == null) {
            MapShape ms;
            for (MapObject mo : Worldographer.getMapUI().getCurrentObjects()) {
                if (!(mo instanceof MapShape)) continue;
                ms = (MapShape)mo;
                for (Point2D pt : ms.getShapePoints()) {
                    Point2D shapeptonscreen = Worldographer.getMapUI().getScreenCoordsFromModelCoords(pt.getX(), pt.getY());
                    double diffx = Math.abs(shapeptonscreen.getX() - t.getX());
                    double diffy = Math.abs(shapeptonscreen.getY() - t.getY());
                    if (!(diffx < 9.0) || !(diffy < 9.0)) continue;
                    Worldographer.getMapUI().draggingObjectParentOrig = ms.clone();
                    Worldographer.getMapUI().draggingObject = pt;
                    Worldographer.getMapUI().draggingObjectParent = ms;
                }
            }
            if (Worldographer.getMapUI().draggingObject == null) {
                Worldographer.getMapUI().dragShapeOrigsToCopies = new HashMap();
                for (MapObject mo : Worldographer.getMapUI().getCurrentObjects()) {
                    if (!(mo instanceof MapShape)) continue;
                    ms = (MapShape)mo;
                    if (Worldographer.getMapUI().draggingObject == null) {
                        Worldographer.getMapUI().draggingObject = mo;
                    }
                    if (ms == null || ms.getShape() == null) continue;
                    Worldographer.getMapUI().dragShapeOrigsToCopies.put(ms, ms.clone());
                }
                Worldographer.getMapUI().dragStart = Worldographer.getMapUI().getModelCoordsFromScreenPt(t.getX(), t.getY());
            }
        }
        for (MapObject mo : Worldographer.getMapUI().getCurrentObjects()) {
            boolean didaction;
            if (Worldographer.getMapUI().draggingObject == null && mo instanceof MapLabel && (didaction = this.resizeRotateMapLabel(t))) {
                return;
            }
            if (Worldographer.getMapUI().draggingObject != null || !(mo instanceof Feature) || !(didaction = this.resizeRotateFeature(t))) continue;
            return;
        }
        if (Worldographer.getMapUI().draggingObject == null) {
            for (MapObject mo : Worldographer.getMapUI().getCurrentObjects()) {
                if (mo instanceof Feature) {
                    Feature f = (Feature)mo;
                    Point2D fpt = f.getLocation(Worldographer.getMapUI().getViewLevel());
                    if (fpt == null) continue;
                    double fx = fpt.getX() - f.getScaleFallbackType() * 1.5;
                    double fy = fpt.getY() - (f.getScaleHtFallbackType() > 0.0 ? f.getScaleHtFallbackType() * 1.5 : f.getScaleFallbackType() * 1.5);
                    double foppx = fpt.getX() + f.getScaleFallbackType() * 1.5;
                    double foppy = fpt.getY() + (f.getScaleHtFallbackType() > 0.0 ? f.getScaleHtFallbackType() * 1.5 : f.getScaleFallbackType() * 1.5);
                    Rotate rotate = new Rotate();
                    rotate.setAngle(f.getRotate());
                    rotate.setPivotX((foppx - fx) / 2.0 + fx);
                    rotate.setPivotY((foppy - fy) / 2.0 + fy);
                    Point2D pt1 = rotate.transform(fx, fy);
                    Point2D pt2 = rotate.transform(foppx, foppy);
                    Polygon fshape = new Polygon();
                    fshape.getPoints().addAll((Object[])new Double[]{pt1.getX(), pt1.getY(), pt2.getX(), pt1.getY(), pt2.getX(), pt2.getY(), pt1.getX(), pt2.getY()});
                    fshape.setFill((Paint)javafx.scene.paint.Color.WHITE);
                    if (!fshape.contains(Worldographer.getMapUI().getModelCoordsFromScreenPt(t.getX(), t.getY()))) continue;
                    Worldographer.getMapUI().getCurrentObjects().add(f);
                    this.featuresToolbox.updateCB(f);
                    Worldographer.getMapUI().draggingObject = f;
                    Worldographer.getMapUI().dragStart = f.getLocation(Worldographer.getMapUI().getViewLevel());
                    for (Note n : Worldographer.getMapUI().getMapData().getNotes()) {
                        if (n.getParent() != f) continue;
                        Worldographer.getMapUI().alsoDragging.put(n, n.getLocation(Worldographer.getMapUI().getViewLevel()));
                    }
                    for (MapObject smo : Worldographer.getMapUI().getCurrentObjects()) {
                        if (smo == f || !(smo instanceof Feature)) continue;
                        Worldographer.getMapUI().alsoDragging.put(smo, ((Feature)smo).getLocation(Worldographer.getMapUI().getViewLevel()));
                        for (Note n : Worldographer.getMapUI().getMapData().getNotes()) {
                            if (n.getParent() != f) continue;
                            Worldographer.getMapUI().alsoDragging.put(n, n.getLocation(Worldographer.getMapUI().getViewLevel()));
                        }
                    }
                    continue;
                }
                if (!(mo instanceof Note)) continue;
                Note n = (Note)mo;
                Worldographer.getMapUI().alsoDragging.put(mo, n.getLocation(Worldographer.getMapUI().getViewLevel()));
            }
            for (MapLabel ml : Worldographer.getMapUI().getMapData().getMapLabels()) {
                if (!Worldographer.getMapUI().canvas.isInsideLabelBoundingBox(ml, new Point2D(t.getX(), t.getY()))) continue;
                Worldographer.getMapUI().draggingObject = ml;
                Worldographer.getMapUI().dragStart = ml.getLocation(Worldographer.getMapUI().getViewLevel());
                break;
            }
        }
        if (Worldographer.getMapUI().draggingObject != null) {
            double x = t.getX();
            double y = t.getY();
            if (!this.featuresToolbox.featuresPlaceFreelyCB.isSelected() && Worldographer.getMapUI().draggingObject instanceof Feature) {
                Point2D coords = Worldographer.getMapUI().getTerrainFromScenePt(t.getX(), t.getY());
                if (Worldographer.getMapUI().getMapData().getTileOrientation() == HexOrientation.COLUMNS) {
                    x = coords.getX() * 300.0 * 3.0 / 4.0 + 150.0;
                    y = coords.getY() * 300.0 + (double)(coords.getX() % 2.0 == 1.0 ? 300 : 150);
                } else if (Worldographer.getMapUI().getMapData().getTileOrientation() == HexOrientation.ROWS) {
                    x = coords.getX() * 300.0 + (double)(coords.getY() % 2.0 == 1.0 ? 300 : 150);
                    y = coords.getY() * 300.0 * 3.0 / 4.0 + 150.0;
                } else {
                    Point2D modelpt = Worldographer.getMapUI().getModelCoordsFromScreenPt(x, y);
                    x = (int)(modelpt.getX() + 37.0) / 75 * 75;
                    y = (int)(modelpt.getY() + 37.0) / 75 * 75;
                }
                ((Feature)Worldographer.getMapUI().draggingObject).setLocation(Worldographer.getMapUI().getViewLevel(), x, y);
                if (this.worldographerMenuBar.autoUpdateOtherLevelsItem.isSelected()) {
                    if (Worldographer.getMapUI().getViewLevel() != ViewLevel.WORLD && Worldographer.getMapUI().getMapData().getTerrain(ViewLevel.WORLD) != null) {
                        Worldographer.getMapUI().getMapData().updateFeatureLocationNewLevel(Worldographer.getMapUI().getViewLevel(), ViewLevel.WORLD, (Feature)Worldographer.getMapUI().draggingObject);
                    }
                    if (Worldographer.getMapUI().getViewLevel() != ViewLevel.CONTINENT && Worldographer.getMapUI().getMapData().getTerrain(ViewLevel.CONTINENT) != null) {
                        Worldographer.getMapUI().getMapData().updateFeatureLocationNewLevel(Worldographer.getMapUI().getViewLevel(), ViewLevel.CONTINENT, (Feature)Worldographer.getMapUI().draggingObject);
                    }
                    if (Worldographer.getMapUI().getViewLevel() != ViewLevel.KINGDOM && Worldographer.getMapUI().getMapData().getTerrain(ViewLevel.KINGDOM) != null) {
                        Worldographer.getMapUI().getMapData().updateFeatureLocationNewLevel(Worldographer.getMapUI().getViewLevel(), ViewLevel.KINGDOM, (Feature)Worldographer.getMapUI().draggingObject);
                    }
                }
                for (MapObject mo : Worldographer.getMapUI().alsoDragging.keySet()) {
                    Point2D alsodragstart;
                    if (mo instanceof Feature) {
                        Feature f = (Feature)mo;
                        alsodragstart = Worldographer.getMapUI().alsoDragging.get(mo);
                        newx = alsodragstart.getX() + x - Worldographer.getMapUI().dragStart.getX();
                        newy = alsodragstart.getY() + y - Worldographer.getMapUI().dragStart.getY();
                        f.setLocation(Worldographer.getMapUI().getViewLevel(), newx, newy);
                        if (this.worldographerMenuBar.autoUpdateOtherLevelsItem.isSelected()) {
                            if (Worldographer.getMapUI().getViewLevel() != ViewLevel.WORLD && Worldographer.getMapUI().getMapData().getTerrain(ViewLevel.WORLD) != null) {
                                Worldographer.getMapUI().getMapData().updateFeatureLocationNewLevel(Worldographer.getMapUI().getViewLevel(), ViewLevel.WORLD, f);
                            }
                            if (Worldographer.getMapUI().getViewLevel() != ViewLevel.CONTINENT && Worldographer.getMapUI().getMapData().getTerrain(ViewLevel.CONTINENT) != null) {
                                Worldographer.getMapUI().getMapData().updateFeatureLocationNewLevel(Worldographer.getMapUI().getViewLevel(), ViewLevel.CONTINENT, f);
                            }
                            if (Worldographer.getMapUI().getViewLevel() != ViewLevel.KINGDOM && Worldographer.getMapUI().getMapData().getTerrain(ViewLevel.KINGDOM) != null) {
                                Worldographer.getMapUI().getMapData().updateFeatureLocationNewLevel(Worldographer.getMapUI().getViewLevel(), ViewLevel.KINGDOM, f);
                            }
                        }
                    }
                    if (!(mo instanceof Note)) continue;
                    Note n = (Note)mo;
                    alsodragstart = Worldographer.getMapUI().alsoDragging.get(mo);
                    newx = alsodragstart.getX() + x - Worldographer.getMapUI().dragStart.getX();
                    newy = alsodragstart.getY() + y - Worldographer.getMapUI().dragStart.getY();
                    n.setLocation(Worldographer.getMapUI().getViewLevel(), new Point2D(newx, newy));
                    if (!this.worldographerMenuBar.autoUpdateOtherLevelsItem.isSelected()) continue;
                    if (Worldographer.getMapUI().getViewLevel() != ViewLevel.WORLD && Worldographer.getMapUI().getMapData().getTerrain(ViewLevel.WORLD) != null) {
                        Worldographer.getMapUI().getMapData().updateNoteLocationNewLevel(Worldographer.getMapUI().getViewLevel(), ViewLevel.WORLD, n);
                    }
                    if (Worldographer.getMapUI().getViewLevel() != ViewLevel.CONTINENT && Worldographer.getMapUI().getMapData().getTerrain(ViewLevel.CONTINENT) != null) {
                        Worldographer.getMapUI().getMapData().updateNoteLocationNewLevel(Worldographer.getMapUI().getViewLevel(), ViewLevel.CONTINENT, n);
                    }
                    if (Worldographer.getMapUI().getViewLevel() == ViewLevel.KINGDOM || Worldographer.getMapUI().getMapData().getTerrain(ViewLevel.KINGDOM) == null) continue;
                    Worldographer.getMapUI().getMapData().updateNoteLocationNewLevel(Worldographer.getMapUI().getViewLevel(), ViewLevel.KINGDOM, n);
                }
            } else if (Worldographer.getMapUI().draggingObject instanceof Feature) {
                Point2D modelcoords = Worldographer.getMapUI().getModelCoordsFromScreenPt(x, y);
                ((Feature)Worldographer.getMapUI().draggingObject).setLocation(Worldographer.getMapUI().getViewLevel(), modelcoords);
                if (this.worldographerMenuBar.autoUpdateOtherLevelsItem.isSelected()) {
                    if (Worldographer.getMapUI().getViewLevel() != ViewLevel.WORLD && Worldographer.getMapUI().getMapData().getTerrain(ViewLevel.WORLD) != null) {
                        Worldographer.getMapUI().getMapData().updateFeatureLocationNewLevel(Worldographer.getMapUI().getViewLevel(), ViewLevel.WORLD, (Feature)Worldographer.getMapUI().draggingObject);
                    }
                    if (Worldographer.getMapUI().getViewLevel() != ViewLevel.CONTINENT && Worldographer.getMapUI().getMapData().getTerrain(ViewLevel.CONTINENT) != null) {
                        Worldographer.getMapUI().getMapData().updateFeatureLocationNewLevel(Worldographer.getMapUI().getViewLevel(), ViewLevel.CONTINENT, (Feature)Worldographer.getMapUI().draggingObject);
                    }
                    if (Worldographer.getMapUI().getViewLevel() != ViewLevel.KINGDOM && Worldographer.getMapUI().getMapData().getTerrain(ViewLevel.KINGDOM) != null) {
                        Worldographer.getMapUI().getMapData().updateFeatureLocationNewLevel(Worldographer.getMapUI().getViewLevel(), ViewLevel.KINGDOM, (Feature)Worldographer.getMapUI().draggingObject);
                    }
                }
                for (MapObject mo : Worldographer.getMapUI().alsoDragging.keySet()) {
                    Point2D alsodragstart;
                    if (mo instanceof Feature) {
                        Feature f = (Feature)mo;
                        alsodragstart = Worldographer.getMapUI().alsoDragging.get(mo);
                        newx = alsodragstart.getX() + modelcoords.getX() - Worldographer.getMapUI().dragStart.getX();
                        newy = alsodragstart.getY() + modelcoords.getY() - Worldographer.getMapUI().dragStart.getY();
                        f.setLocation(Worldographer.getMapUI().getViewLevel(), newx, newy);
                        if (this.worldographerMenuBar.autoUpdateOtherLevelsItem.isSelected()) {
                            if (Worldographer.getMapUI().getViewLevel() != ViewLevel.WORLD && Worldographer.getMapUI().getMapData().getTerrain(ViewLevel.WORLD) != null) {
                                Worldographer.getMapUI().getMapData().updateFeatureLocationNewLevel(Worldographer.getMapUI().getViewLevel(), ViewLevel.WORLD, f);
                            }
                            if (Worldographer.getMapUI().getViewLevel() != ViewLevel.CONTINENT && Worldographer.getMapUI().getMapData().getTerrain(ViewLevel.CONTINENT) != null) {
                                Worldographer.getMapUI().getMapData().updateFeatureLocationNewLevel(Worldographer.getMapUI().getViewLevel(), ViewLevel.CONTINENT, f);
                            }
                            if (Worldographer.getMapUI().getViewLevel() != ViewLevel.KINGDOM && Worldographer.getMapUI().getMapData().getTerrain(ViewLevel.KINGDOM) != null) {
                                Worldographer.getMapUI().getMapData().updateFeatureLocationNewLevel(Worldographer.getMapUI().getViewLevel(), ViewLevel.KINGDOM, f);
                            }
                        }
                    }
                    if (!(mo instanceof Note)) continue;
                    Note n = (Note)mo;
                    alsodragstart = Worldographer.getMapUI().alsoDragging.get(mo);
                    newx = alsodragstart.getX() + modelcoords.getX() - Worldographer.getMapUI().dragStart.getX();
                    newy = alsodragstart.getY() + modelcoords.getY() - Worldographer.getMapUI().dragStart.getY();
                    n.setLocation(Worldographer.getMapUI().getViewLevel(), new Point2D(newx, newy));
                    if (!this.worldographerMenuBar.autoUpdateOtherLevelsItem.isSelected()) continue;
                    if (Worldographer.getMapUI().getViewLevel() != ViewLevel.WORLD && Worldographer.getMapUI().getMapData().getTerrain(ViewLevel.WORLD) != null) {
                        Worldographer.getMapUI().getMapData().updateNoteLocationNewLevel(Worldographer.getMapUI().getViewLevel(), ViewLevel.WORLD, n);
                    }
                    if (Worldographer.getMapUI().getViewLevel() != ViewLevel.CONTINENT && Worldographer.getMapUI().getMapData().getTerrain(ViewLevel.CONTINENT) != null) {
                        Worldographer.getMapUI().getMapData().updateNoteLocationNewLevel(Worldographer.getMapUI().getViewLevel(), ViewLevel.CONTINENT, n);
                    }
                    if (Worldographer.getMapUI().getViewLevel() == ViewLevel.KINGDOM || Worldographer.getMapUI().getMapData().getTerrain(ViewLevel.KINGDOM) == null) continue;
                    Worldographer.getMapUI().getMapData().updateNoteLocationNewLevel(Worldographer.getMapUI().getViewLevel(), ViewLevel.KINGDOM, n);
                }
            } else if (Worldographer.getMapUI().draggingObject instanceof MapLabel) {
                double scale = ((MapLabel)Worldographer.getMapUI().draggingObject).getScale(Worldographer.getMapUI().getViewLevel());
                ((MapLabel)Worldographer.getMapUI().draggingObject).setLocationAndScale(Worldographer.getMapUI().getViewLevel(), (Pair<Point2D, Double>)new Pair((Object)Worldographer.getMapUI().getModelCoordsFromScreenPt(x, y), (Object)scale));
                if (this.worldographerMenuBar.autoUpdateOtherLevelsItem.isSelected()) {
                    if (Worldographer.getMapUI().getViewLevel() != ViewLevel.WORLD && Worldographer.getMapUI().getMapData().getTerrain(ViewLevel.WORLD) != null) {
                        Worldographer.getMapUI().getMapData().updateMapLabelLocationNewLevel(Worldographer.getMapUI().getViewLevel(), ViewLevel.WORLD, (MapLabel)Worldographer.getMapUI().draggingObject);
                    }
                    if (Worldographer.getMapUI().getViewLevel() != ViewLevel.CONTINENT && Worldographer.getMapUI().getMapData().getTerrain(ViewLevel.CONTINENT) != null) {
                        Worldographer.getMapUI().getMapData().updateMapLabelLocationNewLevel(Worldographer.getMapUI().getViewLevel(), ViewLevel.CONTINENT, (MapLabel)Worldographer.getMapUI().draggingObject);
                    }
                    if (Worldographer.getMapUI().getViewLevel() != ViewLevel.KINGDOM && Worldographer.getMapUI().getMapData().getTerrain(ViewLevel.KINGDOM) != null) {
                        Worldographer.getMapUI().getMapData().updateMapLabelLocationNewLevel(Worldographer.getMapUI().getViewLevel(), ViewLevel.KINGDOM, (MapLabel)Worldographer.getMapUI().draggingObject);
                    }
                }
            } else if (Worldographer.getMapUI().draggingObject instanceof Point2D) {
                Point2D newpt = Worldographer.getMapUI().getModelCoordsFromScreenPt(x, y);
                if (Worldographer.getMapUI().draggingObjectParent == null) {
                    for (MapObject mo : Worldographer.getMapUI().getCurrentObjects()) {
                        if (!(mo instanceof MapShape)) continue;
                        MapShape ms = (MapShape)mo;
                        for (Point2D pt : ms.getShapePoints()) {
                            if (pt.getX() != ((Point2D)Worldographer.getMapUI().draggingObject).getX() || pt.getY() != ((Point2D)Worldographer.getMapUI().draggingObject).getY()) continue;
                            Worldographer.getMapUI().draggingObjectParent = ms.clone();
                            break;
                        }
                        if (Worldographer.getMapUI().draggingObjectParent == null) continue;
                        break;
                    }
                }
                if (Worldographer.getMapUI().draggingObjectParent.isSnapVertices()) {
                    newpt = this.getSnapModelPtFromModelPt(newpt);
                }
                Worldographer.getMapUI().draggingObjectParent.updatePoint((Point2D)Worldographer.getMapUI().draggingObject, newpt);
                Worldographer.getMapUI().draggingObject = newpt;
            } else if (Worldographer.getMapUI().dragShapeOrigsToCopies.size() > 0) {
                for (MapShape origms : Worldographer.getMapUI().dragShapeOrigsToCopies.keySet()) {
                    int i;
                    Polygon origp;
                    Shape shape = Worldographer.getMapUI().dragShapeOrigsToCopies.get(origms).getShape();
                    Point2D currentmodelpt = Worldographer.getMapUI().getModelCoordsFromScreenPt(t.getX(), t.getY());
                    double diffx = currentmodelpt.getX() - Worldographer.getMapUI().dragStart.getX();
                    double diffy = currentmodelpt.getY() - Worldographer.getMapUI().dragStart.getY();
                    if (shape instanceof Polygon) {
                        Polygon p = (Polygon)shape;
                        origp = (Polygon)origms.getShape();
                        for (i = 0; i < p.getPoints().size(); i += 2) {
                            try {
                                origp.getPoints().set(i, (Object)((Double)p.getPoints().get(i) + diffx));
                                origp.getPoints().set(i + 1, (Object)((Double)p.getPoints().get(i + 1) + diffy));
                                continue;
                            }
                            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                // empty catch block
                            }
                        }
                        continue;
                    }
                    if (shape instanceof Arc) {
                        Arc a = (Arc)shape;
                        Arc origa = (Arc)origms.getShape();
                        origa.setCenterX(a.getCenterX() + diffx);
                        origa.setCenterY(a.getCenterY() + diffy);
                        continue;
                    }
                    if (!(shape instanceof Path)) continue;
                    Path p = (Path)shape;
                    origp = (Path)origms.getShape();
                    for (i = 0; i < p.getElements().size(); ++i) {
                        PathElement pe = (PathElement)p.getElements().get(i);
                        PathElement origpe = (PathElement)origp.getElements().get(i);
                        if (pe instanceof MoveTo) {
                            MoveTo mt = (MoveTo)pe;
                            MoveTo origmt = (MoveTo)origpe;
                            origmt.setX(mt.getX() + diffx);
                            origmt.setY(mt.getY() + diffy);
                            continue;
                        }
                        if (pe instanceof LineTo) {
                            LineTo lt = (LineTo)pe;
                            LineTo origlt = (LineTo)origpe;
                            origlt.setX(lt.getX() + diffx);
                            origlt.setY(lt.getY() + diffy);
                            continue;
                        }
                        if (!(pe instanceof CubicCurveTo)) continue;
                        CubicCurveTo ct = (CubicCurveTo)pe;
                        CubicCurveTo origct = (CubicCurveTo)origpe;
                        origct.setX(ct.getX() + diffx);
                        origct.setY(ct.getY() + diffy);
                        origct.setControlX1(ct.getControlX1() + diffx);
                        origct.setControlY1(ct.getControlY1() + diffy);
                        origct.setControlX2(ct.getControlX2() + diffx);
                        origct.setControlY2(ct.getControlY2() + diffy);
                    }
                }
            }
            Worldographer.getMapUI().draw();
        }
    }

    public void handleScrollEvent(ScrollEvent event, MapData mapData) {
        if (event.isControlDown()) {
            for (MapObject mo : mapUI.getCurrentObjects()) {
                if (!(mo instanceof Feature)) continue;
                Feature f = (Feature)mo;
                if (event.getDeltaY() > 0.0) {
                    Worldographer.getMapUI().getController().updateFeatureRotate(true, f, (f.getRotate() - 15.0) % 360.0);
                }
                if (event.getDeltaY() < 0.0) {
                    Worldographer.getMapUI().getController().updateFeatureRotate(true, f, (f.getRotate() + 15.0) % 360.0);
                }
                this.featuresToolbox.featuresRotateSpinner.getValueFactory().setValue((Object)f.getRotate());
            }
            mapUI.draw();
            return;
        }
        double adj = 0.1;
        if (event.getDeltaY() < 0.0) {
            adj = -0.1;
        }
        double newwidth = mapData.getTileWidth() + mapData.getTileWidth() * adj;
        double newheight = mapData.getTileHeight() + mapData.getTileHeight() * adj;
        if (this.worldographerMenuBar.scrollWheelItem.isSelected() && newwidth >= 10.0 && newwidth <= 400.0 && newheight >= 10.0 && newheight <= 400.0) {
            Point2D mouseModelPt = Worldographer.getMapUI().getModelCoordsFromScreenPt(event.getSceneX(), event.getSceneY());
            Point2D oldupperLeftModelPt = Worldographer.getMapUI().getModelCoordsFromScreenPt(0.0, 0.0);
            double oldscreenmapwidth = Worldographer.getMapUI().computeTotalMapWidthPixelsCurrentTileSize();
            double oldscreenmapheight = Worldographer.getMapUI().computeTotalMapHeightPixelsCurrentTileSize();
            double oldmodeldistancefromleft = mouseModelPt.getX() - oldupperLeftModelPt.getX();
            double oldmodeldistancefromtop = mouseModelPt.getY() - oldupperLeftModelPt.getY();
            mapData.setTileWidthHeight(newwidth, newheight, false);
            double newscreenmapwidth = Worldographer.getMapUI().computeTotalMapWidthPixelsCurrentTileSize();
            double newscreenmapheight = Worldographer.getMapUI().computeTotalMapHeightPixelsCurrentTileSize();
            double newmodeldistancefromleft = oldmodeldistancefromleft * oldscreenmapwidth / newscreenmapwidth;
            double newmodeldistancefromtop = oldmodeldistancefromtop * oldscreenmapheight / newscreenmapheight;
            if (this.viewLevelBox.tileHeightSpinner != null) {
                this.viewLevelBox.tileHeightSpinner.getValueFactory().setValue((Object)newheight);
                Worldographer.getMapUI().recaclulateMapSize();
            } else {
                Worldographer.getMapUI().recaclulateMapSize();
            }
            if (this.viewLevelBox.tileWidthSpinner != null) {
                this.viewLevelBox.tileWidthSpinner.getValueFactory().setValue((Object)newwidth);
                Worldographer.getMapUI().recaclulateMapSize();
            } else {
                Worldographer.getMapUI().recaclulateMapSize();
            }
            Worldographer.getMapUI().hScrollBar.setValue(mouseModelPt.getX() - newmodeldistancefromleft);
            Worldographer.getMapUI().vScrollBar.setValue(mouseModelPt.getY() - newmodeldistancefromtop);
        }
        if (!this.worldographerMenuBar.scrollWheelItem.isSelected()) {
            Worldographer.getMapUI().hScrollBar.setValue(Worldographer.getMapUI().hScrollBar.getValue() - event.getDeltaX() * 300.0 / mapData.getTileWidth());
            Worldographer.getMapUI().vScrollBar.setValue(Worldographer.getMapUI().vScrollBar.getValue() - event.getDeltaY() * 300.0 / mapData.getTileHeight());
        }
    }

    private boolean adjustView(MouseEvent t) {
        boolean adjusted = false;
        if (t.getX() > Worldographer.getMapUI().canvas.getWidth() && this.adjustView < System.currentTimeMillis() + 500L) {
            Worldographer.getMapUI().hScrollBar.setValue(Worldographer.getMapUI().hScrollBar.getValue() + (t.getX() - Worldographer.getMapUI().canvas.getWidth()));
            this.adjustView = System.currentTimeMillis();
            Worldographer.getMapUI().draw();
            adjusted = true;
        }
        if (t.getX() < 0.0 && this.adjustView < System.currentTimeMillis() + 500L) {
            Worldographer.getMapUI().hScrollBar.setValue(Worldographer.getMapUI().hScrollBar.getValue() + t.getX());
            this.adjustView = System.currentTimeMillis();
            Worldographer.getMapUI().draw();
            adjusted = true;
        }
        if (t.getY() > Worldographer.getMapUI().canvas.getHeight() && this.adjustView < System.currentTimeMillis() + 500L) {
            Worldographer.getMapUI().vScrollBar.setValue(Worldographer.getMapUI().vScrollBar.getValue() + (t.getY() - Worldographer.getMapUI().canvas.getHeight()));
            this.adjustView = System.currentTimeMillis();
            Worldographer.getMapUI().draw();
            adjusted = true;
        }
        if (t.getY() < 0.0 && this.adjustView < System.currentTimeMillis() + 500L) {
            Worldographer.getMapUI().vScrollBar.setValue(Worldographer.getMapUI().vScrollBar.getValue() + t.getY());
            this.adjustView = System.currentTimeMillis();
            Worldographer.getMapUI().draw();
            adjusted = true;
        }
        return adjusted;
    }

    private boolean resizeRotateFeature(MouseEvent t) {
        boolean didaction = false;
        for (MapObject mo : Worldographer.getMapUI().getCurrentObjects()) {
            if (!(mo instanceof Feature)) continue;
            Feature f = (Feature)mo;
            double x = t.getX();
            double y = t.getY();
            double w = f.getScale() < 0.0 ? f.getType().getIconSize() * Worldographer.getMapUI().getMapData().getTileWidth() : f.getScale() / 100.0 * Worldographer.getMapUI().getMapData().getTileWidth();
            double h = f.getScaleHt() < 0.0 ? f.getScale() / 100.0 * Worldographer.getMapUI().getMapData().getTileHeight() : f.getScaleHt() / 100.0 * Worldographer.getMapUI().getMapData().getTileHeight();
            Point2D fcenteronscreen = Worldographer.getMapUI().getScreenCoordsFromModelCoords(f.getLocation(Worldographer.getMapUI().getViewLevel()).getX(), f.getLocation(Worldographer.getMapUI().getViewLevel()).getY());
            double diffx = Double.MIN_VALUE;
            double diffy = Double.MIN_VALUE;
            double rotatediffx = fcenteronscreen.getX() + Math.cos(Math.toRadians(f.getRotate())) * w / 2.0;
            double rotatediffy = fcenteronscreen.getY() + Math.sin(Math.toRadians(f.getRotate())) * w / 2.0;
            Rotate rotate = new Rotate();
            rotate.setAngle(f.getRotate());
            rotate.setPivotX(fcenteronscreen.getX());
            rotate.setPivotY(fcenteronscreen.getY());
            Point2D pt1 = rotate.transform(fcenteronscreen.getX() - w / 2.0, fcenteronscreen.getY() - h / 2.0);
            Point2D pt2 = rotate.transform(fcenteronscreen.getX() + w / 2.0, fcenteronscreen.getY() + h / 2.0);
            Point2D pt3 = rotate.transform(fcenteronscreen.getX() + w / 2.0, fcenteronscreen.getY() - h / 2.0);
            Point2D pt4 = rotate.transform(fcenteronscreen.getX() - w / 2.0, fcenteronscreen.getY() + h / 2.0);
            if (Worldographer.getMapUI().selectedRotate == null) {
                if (Math.abs(rotatediffx - x) < 5.0 && Math.abs(rotatediffy - y) < 5.0) {
                    if (Worldographer.getMapUI().initialRotate == -1.0) {
                        Worldographer.getMapUI().initialRotate = f.getRotate();
                    }
                    Worldographer.getMapUI().selectedRotate = f.getLocation(Worldographer.getMapUI().viewLevel);
                } else if (Worldographer.getMapUI().selectedScalePt != null) {
                    Rotate rotate2 = new Rotate();
                    rotate2.setAngle(-f.getRotate());
                    rotate2.setPivotX(fcenteronscreen.getX());
                    rotate2.setPivotY(fcenteronscreen.getY());
                    Point2D rotatedscaleptonscreen = rotate2.transform(t.getX(), t.getY());
                    diffx = Math.abs(rotatedscaleptonscreen.getX() - fcenteronscreen.getX());
                    diffy = Math.abs(rotatedscaleptonscreen.getY() - fcenteronscreen.getY());
                } else if (Math.abs(x - pt1.getX()) < 3.0 && Math.abs(y - pt1.getY()) < 3.0) {
                    if (Worldographer.getMapUI().initialScaleW == -1.0) {
                        Worldographer.getMapUI().initialScaleH = f.getScale();
                    }
                    if (Worldographer.getMapUI().initialScaleH == -1.0) {
                        Worldographer.getMapUI().initialRotate = f.getScaleHt();
                    }
                    Worldographer.getMapUI().selectedScalePt = pt1;
                    didaction = true;
                } else if (Math.abs(x - pt2.getX()) < 3.0 && Math.abs(y - pt2.getY()) < 3.0) {
                    if (Worldographer.getMapUI().initialScaleW == -1.0) {
                        Worldographer.getMapUI().initialScaleH = f.getScale();
                    }
                    if (Worldographer.getMapUI().initialScaleH == -1.0) {
                        Worldographer.getMapUI().initialRotate = f.getScaleHt();
                    }
                    Worldographer.getMapUI().selectedScalePt = pt2;
                    didaction = true;
                } else if (Math.abs(x - pt3.getX()) < 3.0 && Math.abs(y - pt3.getY()) < 3.0) {
                    if (Worldographer.getMapUI().initialScaleW == -1.0) {
                        Worldographer.getMapUI().initialScaleH = f.getScale();
                    }
                    if (Worldographer.getMapUI().initialScaleH == -1.0) {
                        Worldographer.getMapUI().initialRotate = f.getScaleHt();
                    }
                    Worldographer.getMapUI().selectedScalePt = pt3;
                    didaction = true;
                } else if (Math.abs(x - pt4.getX()) < 3.0 && Math.abs(y - pt4.getY()) < 3.0) {
                    if (Worldographer.getMapUI().initialScaleW == -1.0) {
                        Worldographer.getMapUI().initialScaleH = f.getScale();
                    }
                    if (Worldographer.getMapUI().initialScaleH == -1.0) {
                        Worldographer.getMapUI().initialRotate = f.getScaleHt();
                    }
                    Worldographer.getMapUI().selectedScalePt = pt4;
                    didaction = true;
                }
            }
            if (Worldographer.getMapUI().selectedRotate != null) {
                diffx = x - fcenteronscreen.getX();
                diffy = y - fcenteronscreen.getY();
                double newValue = Math.toDegrees(Math.atan(Math.abs(diffy) / Math.abs(diffx)));
                double newValue2 = Math.toDegrees(Math.atan(Math.abs(diffx) / Math.abs(diffy)));
                if (diffy < 0.0 && diffx < 0.0) {
                    newValue += 180.0;
                } else if (diffy < 0.0) {
                    newValue = newValue2 + 270.0;
                } else if (diffx < 0.0) {
                    newValue = newValue2 + 90.0;
                }
                f.setRotate(newValue);
                this.featuresToolbox.featuresRotateSpinner.getValueFactory().setValue((Object)newValue);
                Worldographer.getMapUI().draw();
                didaction = true;
                continue;
            }
            if (!(diffx > Double.MIN_VALUE)) continue;
            double scalex = diffx * 2.0 / Worldographer.getMapUI().getMapData().getTileWidth() * 100.0;
            double scaley = diffy * 2.0 / Worldographer.getMapUI().getMapData().getTileHeight() * 100.0;
            if (f.getScaleHt() < 0.0) {
                f.setScale(Math.max(scalex, scaley));
            } else {
                f.setScale(scalex);
                f.setScaleHt(scaley);
            }
            if (f.getScale() > 0.0) {
                this.featuresToolbox.featuresScaleSpinner.getValueFactory().setValue((Object)f.getScale());
            }
            if (f.getScaleHt() > 0.0) {
                this.featuresToolbox.featuresScaleHtSpinner.getValueFactory().setValue((Object)f.getScaleHt());
            }
            Worldographer.getMapUI().draw();
            didaction = true;
        }
        return didaction;
    }

    private boolean resizeRotateMapLabel(MouseEvent t) {
        MapData mapData = Worldographer.getMapUI().getMapData();
        boolean didaction = false;
        for (MapObject mo : Worldographer.getMapUI().getCurrentObjects()) {
            MapLabel ml = (MapLabel)mo;
            Point2D labellocation = ml.getLocation(Worldographer.getMapUI().viewLevel);
            Point2D screenlabellocation = Worldographer.getMapUI().getScreenCoordsFromModelCoords(labellocation.getX(), labellocation.getY());
            double rdiffy = Double.MIN_VALUE;
            List<Point2D> labelscreenboundingpoints = ml.getRotatedBoundingBoxPoints(mapData, mapData.getTileWidth(), mapData.getTileHeight(), mapData.getView().getContinentFactor(), mapData.getView().getKingdomFactor(), mapData.getView().getProvinceFactor(), Worldographer.getMapUI().hScrollBar.getValue(), Worldographer.getMapUI().vScrollBar.getValue(), Worldographer.getMapUI().getViewLevel());
            if (Worldographer.getMapUI().selectedRotate == null) {
                if (Worldographer.getMapUI().selectedScaleNW != null || Worldographer.getMapUI().selectedScaleSW != null || Worldographer.getMapUI().selectedScaleNE != null || Worldographer.getMapUI().selectedScaleSE != null) {
                    Point2D ptonscreen = Worldographer.getMapUI().getScreenCoordsFromModelCoords(labellocation.getX(), labellocation.getY());
                    Rotate r = new Rotate(-ml.getRotate(), screenlabellocation.getX(), screenlabellocation.getY());
                    Point2D derotatedshapeptonscreen = r.transform(ptonscreen);
                    Point2D derotatedt = r.transform(new Point2D(t.getX(), t.getY()));
                    rdiffy = Math.abs(derotatedshapeptonscreen.getY() - derotatedt.getY());
                } else {
                    int mlcount = 0;
                    if (!didaction) {
                        for (Point2D pt : labelscreenboundingpoints) {
                            Rotate r = new Rotate(-ml.getRotate(), screenlabellocation.getX(), screenlabellocation.getY());
                            Point2D derotatedshapeptonscreen = r.transform(pt);
                            Point2D derotatedt = r.transform(new Point2D(t.getX(), t.getY()));
                            double diffx = Math.abs(derotatedshapeptonscreen.getX() - derotatedt.getX());
                            double diffy = Math.abs(derotatedshapeptonscreen.getY() - derotatedt.getY());
                            if (diffx < 5.0 && diffy < 5.0) {
                                if (mlcount == 0) {
                                    Worldographer.getMapUI().selectedScaleNW = pt;
                                }
                                if (mlcount == 1) {
                                    Worldographer.getMapUI().selectedScaleNE = pt;
                                }
                                if (mlcount == 2) {
                                    Worldographer.getMapUI().selectedScaleSE = pt;
                                }
                                if (mlcount == 3) {
                                    Worldographer.getMapUI().selectedScaleSW = pt;
                                }
                                if (mlcount == 4) {
                                    Worldographer.getMapUI().selectedRotate = pt;
                                    if (Worldographer.getMapUI().initialRotate == -1.0) {
                                        Worldographer.getMapUI().initialRotate = ml.getRotate();
                                    }
                                } else if (Worldographer.getMapUI().initialScaleH == -1.0) {
                                    Worldographer.getMapUI().initialScaleH = ml.getScale(Worldographer.getMapUI().viewLevel);
                                }
                                didaction = true;
                            }
                            ++mlcount;
                        }
                    }
                }
            }
            if (Worldographer.getMapUI().selectedRotate != null) {
                if (Worldographer.getMapUI().initialRotate == -1.0) {
                    for (MapObject mo2 : Worldographer.getMapUI().getCurrentObjects()) {
                        if (!(mo2 instanceof MapLabel)) continue;
                        Worldographer.getMapUI().initialRotate = ((MapLabel)mo2).getRotate();
                        break;
                    }
                }
                double diffx = t.getX() - screenlabellocation.getX();
                double diffy = t.getY() - screenlabellocation.getY();
                double newValue = Math.toDegrees(Math.atan(Math.abs(diffy) / Math.abs(diffx)));
                double newValue2 = Math.toDegrees(Math.atan(Math.abs(diffx) / Math.abs(diffy)));
                if (diffy < 0.0 && diffx < 0.0) {
                    newValue += 180.0;
                } else if (diffy < 0.0) {
                    newValue = newValue2 + 270.0;
                } else if (diffx < 0.0) {
                    newValue = newValue2 + 90.0;
                }
                for (MapObject mo2 : Worldographer.getMapUI().getCurrentObjects()) {
                    if (!(mo2 instanceof MapLabel)) continue;
                    ((MapLabel)mo2).setRotate(newValue);
                    break;
                }
                this.labelsToolbox.labelRotateSpinner.getValueFactory().setValue((Object)newValue);
                Worldographer.getMapUI().draw();
                didaction = true;
                continue;
            }
            if (!(rdiffy > Double.MIN_VALUE)) continue;
            for (MapObject mo2 : Worldographer.getMapUI().getCurrentObjects()) {
                if (!(mo2 instanceof MapLabel)) continue;
                MapLabel selected = (MapLabel)mo2;
                double scale = rdiffy * 2.0 / mapData.getTileHeight() * 100.0;
                Point2D loc = selected.getLocation(Worldographer.getMapUI().viewLevel);
                selected.setLocationAndScale(Worldographer.getMapUI().viewLevel, (Pair<Point2D, Double>)new Pair((Object)loc, (Object)scale));
                this.labelsToolbox.labelScaleSpinner.getValueFactory().setValue((Object)scale);
            }
            Worldographer.getMapUI().draw();
            t.consume();
            didaction = true;
        }
        return didaction;
    }

    public void handleMouseReleased(MouseEvent t) {
        Worldographer.getMapUI().creatingDragSelectArea = false;
        this.arcDragCenter = null;
        if (Worldographer.getMapUI().selectedScaleNW != null || Worldographer.getMapUI().selectedScaleNE != null || Worldographer.getMapUI().selectedScaleSE != null || Worldographer.getMapUI().selectedScaleSW != null) {
            this.addResizeUndoAction();
        }
        if (Worldographer.getMapUI().selectedScaleNW != null) {
            Worldographer.getMapUI().selectedScaleNW = null;
            return;
        }
        if (Worldographer.getMapUI().selectedScaleNE != null) {
            Worldographer.getMapUI().selectedScaleNE = null;
            return;
        }
        if (Worldographer.getMapUI().selectedScaleSW != null) {
            Worldographer.getMapUI().selectedScaleSW = null;
            return;
        }
        if (Worldographer.getMapUI().selectedScaleSE != null) {
            Worldographer.getMapUI().selectedScaleSE = null;
            return;
        }
        Worldographer.getMapUI().selectedScalePt = null;
        if (Worldographer.getMapUI().selectedRotate != null) {
            for (MapObject mo : Worldographer.getMapUI().getCurrentObjects()) {
                if (mo instanceof Feature) {
                    Worldographer.getMapUI().getController().updateFeatureRotate(this.undoEnabled, (Feature)mo, ((Feature)mo).getRotate());
                }
                if (!(mo instanceof MapLabel)) continue;
                Worldographer.getMapUI().getController().updateLabelRotate(this.undoEnabled, (MapLabel)mo, ((MapLabel)mo).getRotate(), Worldographer.getMapUI().initialRotate);
            }
            Worldographer.getMapUI().selectedRotate = null;
            Worldographer.getMapUI().initialRotate = -1.0;
            Worldographer.getMapUI().draw();
            return;
        }
        if (Worldographer.getMapUI().draggingObject != null) {
            double x = t.getX();
            double y = t.getY();
            if (Worldographer.getMapUI().draggingObject instanceof Feature) {
                Point2D startPt = ((Feature)Worldographer.getMapUI().draggingObject).getLocation(Worldographer.getMapUI().getViewLevel());
                Worldographer.getMapUI().getController().getUndoRedoHandler().push(new UndoAction(UndoAction.Action.MODIFY_LOCATION, UndoAction.Thing.FEATURE, Worldographer.getMapUI().draggingObject, ((Feature)Worldographer.getMapUI().draggingObject).getLocation(Worldographer.getMapUI().viewLevel), Worldographer.getMapUI().dragStart, (Object)Worldographer.getMapUI().viewLevel, null, null));
                Worldographer.getMapUI().draggingObject = null;
                for (MapObject smo : Worldographer.getMapUI().alsoDragging.keySet()) {
                    if (smo instanceof Feature) {
                        Feature f = (Feature)smo;
                        Worldographer.getMapUI().getController().getUndoRedoHandler().push(new UndoAction(UndoAction.Action.MODIFY_LOCATION, UndoAction.Thing.FEATURE, smo, f.getLocation(Worldographer.getMapUI().viewLevel), Worldographer.getMapUI().alsoDragging.get(smo), (Object)Worldographer.getMapUI().viewLevel, null, null));
                    }
                    if (!(smo instanceof Note)) continue;
                    Note n = (Note)smo;
                    Worldographer.getMapUI().getController().getUndoRedoHandler().push(new UndoAction(UndoAction.Action.MODIFY_LOCATION, UndoAction.Thing.NOTE, smo, n.getLocation(Worldographer.getMapUI().viewLevel), Worldographer.getMapUI().alsoDragging.get(smo), (Object)Worldographer.getMapUI().viewLevel, null, null));
                }
            } else if (Worldographer.getMapUI().draggingObject instanceof MapLabel) {
                double scale = ((MapLabel)Worldographer.getMapUI().draggingObject).getScale(Worldographer.getMapUI().getViewLevel());
                ((MapLabel)Worldographer.getMapUI().draggingObject).setLocationAndScale(Worldographer.getMapUI().getViewLevel(), (Pair<Point2D, Double>)new Pair((Object)Worldographer.getMapUI().getModelCoordsFromScreenPt(x, y), (Object)scale));
                Worldographer.getMapUI().draggingObject = null;
            } else if (Worldographer.getMapUI().draggingObject instanceof Point2D) {
                MapShape mapShape = Worldographer.getMapUI().draggingObjectParent.clone();
                Worldographer.getMapUI().getController().getUndoRedoHandler().push(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.MAP_SHAPE, Worldographer.getMapUI().draggingObjectParent, mapShape, Worldographer.getMapUI().draggingObjectParentOrig, (Object)Worldographer.getMapUI().viewLevel, null, null));
                Worldographer.getMapUI().draggingObject = null;
                Worldographer.getMapUI().draggingObjectParent = null;
                Worldographer.getMapUI().draggingObjectParentOrig = null;
            } else if (Worldographer.getMapUI().dragShapeOrigsToCopies.size() > 0) {
                Point2D releasecoords = Worldographer.getMapUI().getModelCoordsFromScreenPt(x, y);
                for (MapShape ms : Worldographer.getMapUI().dragShapeOrigsToCopies.keySet()) {
                    Worldographer.getMapUI().getController().getUndoRedoHandler().push(new UndoAction(UndoAction.Action.MODIFY_LOCATION, UndoAction.Thing.MAP_SHAPE, ms, Worldographer.getMapUI().dragStart, releasecoords, (Object)Worldographer.getMapUI().viewLevel, null, null));
                }
                Worldographer.getMapUI().draggingObject = null;
                Worldographer.getMapUI().draggingObjectParent = null;
                Worldographer.getMapUI().dragShapeOrigsToCopies.clear();
            }
            Worldographer.getMapUI().alsoDragging.clear();
            Worldographer.getMapUI().draw();
        }
        if (Worldographer.getMapUI().dragStart != null) {
            Worldographer.getMapUI().dragStart = null;
        }
        Worldographer.getMapUI().draggingObject = null;
    }

    private void addResizeUndoAction() {
        for (MapObject mo : Worldographer.getMapUI().getCurrentObjects()) {
            MapObject old;
            if (mo instanceof Feature) {
                Feature f = (Feature)mo;
                old = f.clone();
                Worldographer.getMapUI().getController().getUndoRedoHandler().push(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.FEATURE, f, f.clone(), old, null, null, null));
            }
            if (!(mo instanceof MapLabel)) continue;
            MapLabel ml = (MapLabel)mo;
            old = ml.clone();
            Worldographer.getMapUI().getController().getUndoRedoHandler().push(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.LABEL, ml, ml.clone(), old, null, null, null));
        }
    }

    private Note findOrCreateNoteByLocation(Point2D coords) {
        Note n = null;
        for (Note n2 : Worldographer.getMapUI().getMapData().getNotes()) {
            Point2D pt = n2.getLocation(Worldographer.getMapUI().getViewLevel());
            if (pt == null || !(Math.abs(coords.getX() - pt.getX()) < 50.0) || !(Math.abs(coords.getY() - pt.getY()) < 50.0) || Worldographer.mapUI.viewLevel == ViewLevel.WORLD && !n2.isWorld() || Worldographer.mapUI.viewLevel == ViewLevel.CONTINENT && !n2.isContinent() || Worldographer.mapUI.viewLevel == ViewLevel.KINGDOM && !n2.isKingdom() || Worldographer.mapUI.viewLevel == ViewLevel.PROVINCE && !n2.isProvince()) continue;
            n = n2;
        }
        if (n == null) {
            n = new Note(Worldographer.getMapUI().getViewLevel(), coords.getX(), coords.getY());
        }
        return n;
    }

    public void popNoteDialog(Note note) {
        NoteDialog dialog = new NoteDialog(note, this);
        dialog.initOwner((Window)primaryStage);
        dialog.showAndWait();
        Worldographer.getMapUI().draw();
    }

    public void getNations(List<Information> input, List<Information> nations) {
        for (Information i2 : input) {
            if (i2 instanceof Nation) {
                nations.add(i2);
            }
            if (i2.children == null) continue;
            this.getNations(i2.children, nations);
        }
    }

    public void handleMouseExited(MouseEvent ignoredT) {
        if (Worldographer.getMapUI() != null) {
            boolean trigger = false;
            if (Worldographer.getMapUI().getToolTipText() != null) {
                Worldographer.getMapUI().setToolTipText(null);
                trigger = true;
            }
            if (Worldographer.getMapUI().getPlacingObject() != null) {
                Worldographer.getMapUI().setPlacingObject(null);
                trigger = true;
            }
            if (trigger) {
                Worldographer.getMapUI().draw();
            }
        }
    }

    public void handleMouseClicked(MouseEvent t) {
        boolean selectedshape;
        if (t.getButton() == MouseButton.MIDDLE) {
            return;
        }
        if (this.contextMenu != null) {
            this.contextMenu.hide();
        }
        if (WAS_DRAGGING) {
            WAS_DRAGGING = false;
            return;
        }
        boolean colorPickersSelected = false;
        for (ColorPickerWithSelector cps : this.colorPickerWithSelectorList) {
            if (!cps.getSelectorButton().isSelected()) continue;
            colorPickersSelected = true;
        }
        if (colorPickersSelected || this.shapesToolbox.shapesFillCPWSelector.getSelectorButton().isSelected() || this.shapesToolbox.shapesStrokeCPWSelector.getSelectorButton().isSelected() || this.terrainToolbox.backgroundCPWSelector.getSelectorButton().isSelected() || this.labelsToolbox.labelColorPickerWSelector.getSelectorButton().isSelected() || this.labelsToolbox.labelOutlineColorPickerWSelector.getSelectorButton().isSelected() || this.labelsToolbox.labelBackgroundColorPickerWSelector.getSelectorButton().isSelected() || this.featuresToolbox.featuresRingColorPickerWSelector.getSelectorButton().isSelected() || this.featuresToolbox.featuresOverrideColorPickerWSelector.getSelectorButton().isSelected() || this.featuresToolbox.labelColorPickerWSelector.getSelectorButton().isSelected() || this.featuresToolbox.labelOutlineColorPickerWSelector.getSelectorButton().isSelected() || this.featuresToolbox.labelBackgroundColorPickerWSelector.getSelectorButton().isSelected()) {
            this.updateColorPickersAndselectedMapObjects();
            Worldographer.getMapUI().draw();
            primaryStage.getScene().setCursor(Cursor.DEFAULT);
            return;
        }
        if (this.worldographerMenuBar.selectItem.isSelected()) {
            Worldographer.getMapUI().selectPts.add(Worldographer.getMapUI().getModelCoordsFromScreenPt(t.getX(), t.getY()));
            Worldographer.getMapUI().draw();
            return;
        }
        if (t.getButton() == MouseButton.SECONDARY) {
            if (this.rightClickTime > (double)(System.currentTimeMillis() - 500L)) {
                return;
            }
            this.rightClickModelPt = Worldographer.getMapUI().getModelCoordsFromScreenPt(t.getX(), t.getY());
            this.rightClickTime = System.currentTimeMillis();
            if (t.isControlDown()) {
                if (Worldographer.getMapUI().getViewLevel() == ViewLevel.WORLD && Worldographer.getMapUI().getMapData().getTerrain(ViewLevel.CONTINENT) != null) {
                    this.viewLevelBox.viewLevelCombo.getSelectionModel().select((Object)ViewLevel.CONTINENT);
                } else if (Worldographer.getMapUI().getViewLevel() == ViewLevel.CONTINENT && Worldographer.getMapUI().getMapData().getTerrain(ViewLevel.KINGDOM) != null) {
                    this.viewLevelBox.viewLevelCombo.getSelectionModel().select((Object)ViewLevel.KINGDOM);
                }
            } else if (t.isShiftDown()) {
                if (Worldographer.getMapUI().getViewLevel() == ViewLevel.KINGDOM && Worldographer.getMapUI().getMapData().getTerrain(ViewLevel.CONTINENT) != null) {
                    this.viewLevelBox.viewLevelCombo.getSelectionModel().select((Object)ViewLevel.CONTINENT);
                } else if (Worldographer.getMapUI().getViewLevel() == ViewLevel.CONTINENT && Worldographer.getMapUI().getMapData().getTerrain(ViewLevel.WORLD) != null) {
                    this.viewLevelBox.viewLevelCombo.getSelectionModel().select((Object)ViewLevel.WORLD);
                }
            } else if (!t.isAltDown()) {
                this.contextMenu = RightClickMenu.createRightClickMenu(t, Worldographer.getMapUI(), this);
                this.contextMenu.show((Node)Worldographer.getMapUI().canvas, t.getScreenX(), t.getScreenY());
            }
            return;
        }
        if (this.viewOptions.noteButton.isSelected()) {
            Note n = this.findOrCreateNoteByLocation(Worldographer.getMapUI().getModelCoordsFromScreenPt(t.getX(), t.getY()));
            this.popNoteDialog(n);
        }
        if (this.terrainToolbox.terrainSelectButton.isSelected()) {
            this.selectTerrain(t);
        }
        if (this.terrainToolbox.terrainCoastlineButton.isSelected()) {
            this.generateCoastlineForTile(t);
        }
        if (this.featuresToolbox.featuresSelectButton.isSelected()) {
            this.selectFeature(t);
            this.selectNote(t);
        }
        if (this.labelsToolbox.labelSelectButton.isSelected()) {
            this.selectMapLabel(t);
        }
        if (t.isShiftDown() && Worldographer.getMapUI().getCurrentObjects().size() > 0 && this.shapesToolbox.deletePointSelected()) {
            this.deletePoint(t);
        }
        if (this.roomToolbox.newRoomButton.isSelected()) {
            int i = (int)(t.getX() / mapUI.getMapData().getTileWidth() * 4.0 + Worldographer.mapUI.hScrollBar.getValue() / 300.0 * 4.0);
            int j = (int)(t.getY() / mapUI.getMapData().getTileHeight() * 4.0 + Worldographer.mapUI.vScrollBar.getValue() / 300.0 * 4.0);
            Point2D coords1 = new Point2D((double)i / 4.0, (double)j / 4.0);
            double topleftx = coords1.getX() - (Double)this.roomToolbox.tilesWideSpinner.getValue() / 2.0;
            double toplefty = coords1.getY() - (Double)this.roomToolbox.tilesHighSpinner.getValue() / 2.0;
            HashSet<Rectangle> featureBoundingBoxes = new HashSet<Rectangle>();
            for (Feature existingFeature : mapUI.getMapData().getFeatures()) {
                double ht = existingFeature.getScaleHtFallbackType();
                if (ht <= 0.0) {
                    ht = existingFeature.getScaleFallbackType();
                }
                if (existingFeature.getTypeName().contains("Door")) {
                    ht = existingFeature.getScaleFallbackType();
                }
                double rotate = existingFeature.getRotate();
                double locX = existingFeature.getLocation(Worldographer.mapUI.viewLevel).getX();
                double locY = existingFeature.getLocation(Worldographer.mapUI.viewLevel).getY();
                featureBoundingBoxes.add(new Rectangle(rotate == 0.0 || rotate == 180.0 ? locX - existingFeature.getScaleFallbackType() / 2.0 * 3.0 : locX - ht / 2.0 * 3.0, rotate == 0.0 || rotate == 180.0 ? locY - ht / 2.0 * 3.0 : locY - existingFeature.getScaleFallbackType() / 2.0 * 3.0, rotate == 0.0 || rotate == 180.0 ? existingFeature.getScaleFallbackType() * 3.0 : ht * 3.0, rotate == 0.0 || rotate == 180.0 ? ht * 3.0 : existingFeature.getScaleFallbackType() * 3.0));
            }
            List list = new ArrayList();
            if (((String)this.roomToolbox.roomTypeCombo.getValue()).equals("Empty/Hall")) {
                list = BattlematDataGenerator.makeRoomWithDoorsAndWindows(new Random(), topleftx, toplefty, topleftx + (Double)this.roomToolbox.tilesWideSpinner.getValue(), toplefty + (Double)this.roomToolbox.tilesHighSpinner.getValue(), ((TextureType)this.roomToolbox.wallTextureStrokeCombo.getValue()).toString(), 0.15, ((TextureType)this.roomToolbox.floorTextureFillCombo.getValue()).toString(), (String)this.roomToolbox.furnitureStylesCombo.getValue(), (Integer)this.roomToolbox.doorsTopSpinner.getValue(), (Integer)this.roomToolbox.doorsLeftSpinner.getValue(), (Integer)this.roomToolbox.doorsBottomSpinner.getValue(), (Integer)this.roomToolbox.doorsRightSpinner.getValue(), (Integer)this.roomToolbox.windowsTopSpinner.getValue(), (Integer)this.roomToolbox.windowsLeftSpinner.getValue(), (Integer)this.roomToolbox.windowsBottomSpinner.getValue(), (Integer)this.roomToolbox.windowsRightSpinner.getValue(), (Integer)this.roomToolbox.torchesTopSpinner.getValue(), (Integer)this.roomToolbox.torchesLeftSpinner.getValue(), (Integer)this.roomToolbox.torchesBottomSpinner.getValue(), (Integer)this.roomToolbox.torchesRightSpinner.getValue(), mapUI.getMapData().getMapLayer("Above Terrain"), mapUI.getMapData().getMapLayer("Features"), featureBoundingBoxes, this.roomToolbox.centerDoorsCheckBox.isSelected(), false);
            } else if (((String)this.roomToolbox.roomTypeCombo.getValue()).equals("Bedroom")) {
                list = BattlematDataGenerator.makeBedroom(new Random(), topleftx, toplefty, topleftx + (Double)this.roomToolbox.tilesWideSpinner.getValue(), toplefty + (Double)this.roomToolbox.tilesHighSpinner.getValue(), ((TextureType)this.roomToolbox.wallTextureStrokeCombo.getValue()).toString(), 0.15, ((TextureType)this.roomToolbox.floorTextureFillCombo.getValue()).toString(), (String)this.roomToolbox.furnitureStylesCombo.getValue(), (Integer)this.roomToolbox.doorsTopSpinner.getValue(), (Integer)this.roomToolbox.doorsLeftSpinner.getValue(), (Integer)this.roomToolbox.doorsBottomSpinner.getValue(), (Integer)this.roomToolbox.doorsRightSpinner.getValue(), (Integer)this.roomToolbox.windowsTopSpinner.getValue(), (Integer)this.roomToolbox.windowsLeftSpinner.getValue(), (Integer)this.roomToolbox.windowsBottomSpinner.getValue(), (Integer)this.roomToolbox.windowsRightSpinner.getValue(), (Integer)this.roomToolbox.torchesTopSpinner.getValue(), (Integer)this.roomToolbox.torchesLeftSpinner.getValue(), (Integer)this.roomToolbox.torchesBottomSpinner.getValue(), (Integer)this.roomToolbox.torchesRightSpinner.getValue(), mapUI.getMapData().getMapLayer("Above Terrain"), mapUI.getMapData().getMapLayer("Features"), featureBoundingBoxes, Worldographer.mapUI.viewLevel, (String)this.roomToolbox.bedWallsCombo.getValue(), (String)this.roomToolbox.bedTypeCombo.getValue());
            } else if (((String)this.roomToolbox.roomTypeCombo.getValue()).equals("Study")) {
                list = BattlematDataGenerator.makeStudy(new Random(), topleftx, toplefty, topleftx + (Double)this.roomToolbox.tilesWideSpinner.getValue(), toplefty + (Double)this.roomToolbox.tilesHighSpinner.getValue(), ((TextureType)this.roomToolbox.wallTextureStrokeCombo.getValue()).toString(), 0.15, ((TextureType)this.roomToolbox.floorTextureFillCombo.getValue()).toString(), (String)this.roomToolbox.furnitureStylesCombo.getValue(), (Integer)this.roomToolbox.doorsTopSpinner.getValue(), (Integer)this.roomToolbox.doorsLeftSpinner.getValue(), (Integer)this.roomToolbox.doorsBottomSpinner.getValue(), (Integer)this.roomToolbox.doorsRightSpinner.getValue(), (Integer)this.roomToolbox.windowsTopSpinner.getValue(), (Integer)this.roomToolbox.windowsLeftSpinner.getValue(), (Integer)this.roomToolbox.windowsBottomSpinner.getValue(), (Integer)this.roomToolbox.windowsRightSpinner.getValue(), (Integer)this.roomToolbox.torchesTopSpinner.getValue(), (Integer)this.roomToolbox.torchesLeftSpinner.getValue(), (Integer)this.roomToolbox.torchesBottomSpinner.getValue(), (Integer)this.roomToolbox.torchesRightSpinner.getValue(), mapUI.getMapData().getMapLayer("Above Terrain"), mapUI.getMapData().getMapLayer("Features"), featureBoundingBoxes, Worldographer.mapUI.viewLevel, this.roomToolbox.getSelectedDesks(), this.roomToolbox.getSelectedChairs(), this.roomToolbox.getSelectedBookcases(), (Integer)this.roomToolbox.wallBookcasesSpinner.getValue());
            } else if (((String)this.roomToolbox.roomTypeCombo.getValue()).equals("Dining")) {
                list = BattlematDataGenerator.makeDiningRoom(new Random(), topleftx, toplefty, topleftx + (Double)this.roomToolbox.tilesWideSpinner.getValue(), toplefty + (Double)this.roomToolbox.tilesHighSpinner.getValue(), ((TextureType)this.roomToolbox.wallTextureStrokeCombo.getValue()).toString(), 0.15, ((TextureType)this.roomToolbox.floorTextureFillCombo.getValue()).toString(), (String)this.roomToolbox.furnitureStylesCombo.getValue(), (Integer)this.roomToolbox.doorsTopSpinner.getValue(), (Integer)this.roomToolbox.doorsLeftSpinner.getValue(), (Integer)this.roomToolbox.doorsBottomSpinner.getValue(), (Integer)this.roomToolbox.doorsRightSpinner.getValue(), (Integer)this.roomToolbox.windowsTopSpinner.getValue(), (Integer)this.roomToolbox.windowsLeftSpinner.getValue(), (Integer)this.roomToolbox.windowsBottomSpinner.getValue(), (Integer)this.roomToolbox.windowsRightSpinner.getValue(), (Integer)this.roomToolbox.torchesTopSpinner.getValue(), (Integer)this.roomToolbox.torchesLeftSpinner.getValue(), (Integer)this.roomToolbox.torchesBottomSpinner.getValue(), (Integer)this.roomToolbox.torchesRightSpinner.getValue(), mapUI.getMapData().getMapLayer("Above Terrain"), mapUI.getMapData().getMapLayer("Features"), featureBoundingBoxes, Worldographer.mapUI.viewLevel, this.roomToolbox.getSelectedTables(), this.roomToolbox.getSelectedChairs(), (Integer)this.roomToolbox.tablesSpinner.getValue());
            } else if (((String)this.roomToolbox.roomTypeCombo.getValue()).equals("Barracks")) {
                list = BattlematDataGenerator.makeBarracks(new Random(), topleftx, toplefty, topleftx + (Double)this.roomToolbox.tilesWideSpinner.getValue(), toplefty + (Double)this.roomToolbox.tilesHighSpinner.getValue(), ((TextureType)this.roomToolbox.wallTextureStrokeCombo.getValue()).toString(), 0.15, ((TextureType)this.roomToolbox.floorTextureFillCombo.getValue()).toString(), (String)this.roomToolbox.furnitureStylesCombo.getValue(), (Integer)this.roomToolbox.doorsTopSpinner.getValue(), (Integer)this.roomToolbox.doorsLeftSpinner.getValue(), (Integer)this.roomToolbox.doorsBottomSpinner.getValue(), (Integer)this.roomToolbox.doorsRightSpinner.getValue(), (Integer)this.roomToolbox.windowsTopSpinner.getValue(), (Integer)this.roomToolbox.windowsLeftSpinner.getValue(), (Integer)this.roomToolbox.windowsBottomSpinner.getValue(), (Integer)this.roomToolbox.windowsRightSpinner.getValue(), (Integer)this.roomToolbox.torchesTopSpinner.getValue(), (Integer)this.roomToolbox.torchesLeftSpinner.getValue(), (Integer)this.roomToolbox.torchesBottomSpinner.getValue(), (Integer)this.roomToolbox.torchesRightSpinner.getValue(), mapUI.getMapData().getMapLayer("Above Terrain"), mapUI.getMapData().getMapLayer("Features"), featureBoundingBoxes, Worldographer.mapUI.viewLevel, this.roomToolbox.getSelectedBeds(), (Integer)this.roomToolbox.bedsSpinner.getValue());
            } else if (((String)this.roomToolbox.roomTypeCombo.getValue()).equals("Kitchen")) {
                list = BattlematDataGenerator.makeKitchen(new Random(), topleftx, toplefty, topleftx + (Double)this.roomToolbox.tilesWideSpinner.getValue(), toplefty + (Double)this.roomToolbox.tilesHighSpinner.getValue(), ((TextureType)this.roomToolbox.wallTextureStrokeCombo.getValue()).toString(), 0.15, ((TextureType)this.roomToolbox.floorTextureFillCombo.getValue()).toString(), (String)this.roomToolbox.furnitureStylesCombo.getValue(), (Integer)this.roomToolbox.doorsTopSpinner.getValue(), (Integer)this.roomToolbox.doorsLeftSpinner.getValue(), (Integer)this.roomToolbox.doorsBottomSpinner.getValue(), (Integer)this.roomToolbox.doorsRightSpinner.getValue(), (Integer)this.roomToolbox.windowsTopSpinner.getValue(), (Integer)this.roomToolbox.windowsLeftSpinner.getValue(), (Integer)this.roomToolbox.windowsBottomSpinner.getValue(), (Integer)this.roomToolbox.windowsRightSpinner.getValue(), (Integer)this.roomToolbox.torchesTopSpinner.getValue(), (Integer)this.roomToolbox.torchesLeftSpinner.getValue(), (Integer)this.roomToolbox.torchesBottomSpinner.getValue(), (Integer)this.roomToolbox.torchesRightSpinner.getValue(), mapUI.getMapData().getMapLayer("Above Terrain"), mapUI.getMapData().getMapLayer("Features"), featureBoundingBoxes, Worldographer.mapUI.viewLevel, (String)this.roomToolbox.heatSourcesWallsCombo.getValue(), (String)this.roomToolbox.heatSourcesCombo.getValue());
            } else if (((String)this.roomToolbox.roomTypeCombo.getValue()).equals("Library")) {
                list = BattlematDataGenerator.makeLibrary(new Random(), topleftx, toplefty, topleftx + (Double)this.roomToolbox.tilesWideSpinner.getValue(), toplefty + (Double)this.roomToolbox.tilesHighSpinner.getValue(), ((TextureType)this.roomToolbox.wallTextureStrokeCombo.getValue()).toString(), 0.15, ((TextureType)this.roomToolbox.floorTextureFillCombo.getValue()).toString(), (String)this.roomToolbox.furnitureStylesCombo.getValue(), (Integer)this.roomToolbox.doorsTopSpinner.getValue(), (Integer)this.roomToolbox.doorsLeftSpinner.getValue(), (Integer)this.roomToolbox.doorsBottomSpinner.getValue(), (Integer)this.roomToolbox.doorsRightSpinner.getValue(), (Integer)this.roomToolbox.windowsTopSpinner.getValue(), (Integer)this.roomToolbox.windowsLeftSpinner.getValue(), (Integer)this.roomToolbox.windowsBottomSpinner.getValue(), (Integer)this.roomToolbox.windowsRightSpinner.getValue(), (Integer)this.roomToolbox.torchesTopSpinner.getValue(), (Integer)this.roomToolbox.torchesLeftSpinner.getValue(), (Integer)this.roomToolbox.torchesBottomSpinner.getValue(), (Integer)this.roomToolbox.torchesRightSpinner.getValue(), mapUI.getMapData().getMapLayer("Above Terrain"), mapUI.getMapData().getMapLayer("Features"), featureBoundingBoxes, Worldographer.mapUI.viewLevel, (String)this.roomToolbox.statuesCombo.getValue(), (Integer)this.roomToolbox.wallBookcasesSpinner.getValue(), (Integer)this.roomToolbox.sofasSpinner.getValue(), (Integer)this.roomToolbox.chairsSpinner.getValue());
            }
            for (Object o : list) {
                if (o instanceof MapShape) {
                    mapUI.getMapData().getShapes().add((MapShape)o);
                }
                if (!(o instanceof Feature)) continue;
                mapUI.getMapData().getFeatures().add((Feature)o);
            }
            mapUI.draw();
        }
        if (selectedshape = this.selectShape(t)) {
            return;
        }
        if (!t.isShiftDown() && this.shapesToolbox.addPointsSelected()) {
            if (Worldographer.getMapUI().getCurrentObjects().size() == 0 && ShapesToolbox.shapesSelectButton.isSelected()) {
                return;
            }
            this.shapesToolbox.placeShapeOrAddPoints(t);
            return;
        }
        Object o = this.toggleGroup.getSelectedToggle();
        if (o == null) {
            return;
        }
        o = this.toggleGroup.getSelectedToggle().getUserData();
        if (o == null) {
            return;
        }
        if (o instanceof Terrain) {
            Terrain ter = (Terrain)o;
            this.terrainToolbox.placeTerrain(t, ter);
        } else if (o instanceof Feature) {
            Feature f = (Feature)o;
            this.featuresToolbox.placeFeature(t, f);
        } else if (o instanceof MapLabel) {
            MapLabel ml = (MapLabel)o;
            this.labelsToolbox.placeMapLabel(t, ml);
        }
    }

    private void updateColorPickersAndselectedMapObjects() {
        int xValue = MouseInfo.getPointerInfo().getLocation().x;
        int yValue = MouseInfo.getPointerInfo().getLocation().y;
        try {
            Robot robot = new Robot();
            Color color = robot.getPixelColor(xValue, yValue);
            javafx.scene.paint.Color jfxColor = javafx.scene.paint.Color.color((double)((double)color.getRed() / 255.0), (double)((double)color.getGreen() / 255.0), (double)((double)color.getBlue() / 255.0));
            for (MapObject mo : Worldographer.getMapUI().getCurrentObjects()) {
                if (mo instanceof MapShape) {
                    MapShape ms = (MapShape)mo;
                    if (this.shapesToolbox.shapesFillCPWSelector.getSelectorButton().isSelected() && ms.getShape().getFill() instanceof javafx.scene.paint.Color) {
                        mapUI.getController().updateShapeColorFill(true, null, ms, jfxColor);
                        continue;
                    }
                    if (!this.shapesToolbox.shapesStrokeCPWSelector.getSelectorButton().isSelected() || !(ms.getShape().getStroke() instanceof javafx.scene.paint.Color)) continue;
                    ArrayList<MapObject> msList = new ArrayList<MapObject>();
                    msList.add(ms);
                    mapUI.getController().updateShapeColorStroke(true, msList, jfxColor);
                    continue;
                }
                if (mo instanceof Feature) {
                    Feature f = (Feature)mo;
                    if (this.featuresToolbox.featuresOverrideColorPickerWSelector.getSelectorButton().isSelected()) {
                        mapUI.getController().updateFeatureOverrideColor(f, jfxColor);
                        continue;
                    }
                    if (this.featuresToolbox.featuresRingColorPickerWSelector.getSelectorButton().isSelected()) {
                        mapUI.getController().updateFeatureRingColor(f, jfxColor);
                        continue;
                    }
                    if (this.featuresToolbox.labelColorPickerWSelector.getSelectorButton().isSelected()) {
                        mapUI.getController().updateLabelColor(true, f.getLabel(), jfxColor);
                        continue;
                    }
                    if (this.featuresToolbox.labelOutlineColorPickerWSelector.getSelectorButton().isSelected()) {
                        mapUI.getController().updateLabelOutlineColor(true, f.getLabel(), jfxColor);
                        continue;
                    }
                    if (!this.featuresToolbox.labelBackgroundColorPickerWSelector.getSelectorButton().isSelected()) continue;
                    mapUI.getController().updateLabelBackgroundColor(true, f.getLabel(), jfxColor);
                    continue;
                }
                if (mo instanceof MapLabel) {
                    MapLabel l = (MapLabel)mo;
                    if (this.labelsToolbox.labelColorPickerWSelector.getSelectorButton().isSelected()) {
                        mapUI.getController().updateLabelColor(true, l, jfxColor);
                        continue;
                    }
                    if (this.labelsToolbox.labelOutlineColorPickerWSelector.getSelectorButton().isSelected()) {
                        mapUI.getController().updateLabelOutlineColor(true, l, jfxColor);
                        continue;
                    }
                    if (!this.labelsToolbox.labelBackgroundColorPickerWSelector.getSelectorButton().isSelected()) continue;
                    mapUI.getController().updateLabelBackgroundColor(true, l, jfxColor);
                    continue;
                }
                if (!(mo instanceof Terrain)) continue;
                Terrain ter = (Terrain)mo;
                if (!this.terrainToolbox.backgroundCPWSelector.getSelectorButton().isSelected() || !this.terrainToolbox.overrideColorCB.isSelected()) continue;
                mapUI.getController().updateTerrainBackgroundColor(true, ter, jfxColor);
            }
            for (ColorPickerWithSelector cps : this.colorPickerWithSelectorList) {
                if (!cps.getSelectorButton().isSelected()) continue;
                cps.getColorPicker().setValue((Object)jfxColor);
                cps.getSelectorButton().setSelected(false);
            }
            if (this.shapesToolbox.shapesFillCPWSelector.getSelectorButton().isSelected()) {
                this.shapesToolbox.shapesFillCPWSelector.getColorPicker().setValue((Object)jfxColor);
                this.shapesToolbox.shapesFillCPWSelector.getSelectorButton().setSelected(false);
            } else if (this.shapesToolbox.shapesStrokeCPWSelector.getSelectorButton().isSelected()) {
                this.shapesToolbox.shapesStrokeCPWSelector.getColorPicker().setValue((Object)jfxColor);
                this.shapesToolbox.shapesStrokeCPWSelector.getSelectorButton().setSelected(false);
            } else if (this.featuresToolbox.featuresOverrideColorPickerWSelector.getSelectorButton().isSelected()) {
                this.featuresToolbox.featuresOverrideColorPickerWSelector.getColorPicker().setValue((Object)jfxColor);
                this.featuresToolbox.featuresOverrideColorPickerWSelector.getSelectorButton().setSelected(false);
            } else if (this.featuresToolbox.featuresRingColorPickerWSelector.getSelectorButton().isSelected()) {
                this.featuresToolbox.featuresRingColorPickerWSelector.getColorPicker().setValue((Object)jfxColor);
                this.featuresToolbox.featuresRingColorPickerWSelector.getSelectorButton().setSelected(false);
            } else if (this.featuresToolbox.labelColorPickerWSelector.getSelectorButton().isSelected()) {
                this.featuresToolbox.labelColorPickerWSelector.getColorPicker().setValue((Object)jfxColor);
                this.featuresToolbox.labelColorPickerWSelector.getSelectorButton().setSelected(false);
            } else if (this.featuresToolbox.labelOutlineColorPickerWSelector.getSelectorButton().isSelected()) {
                this.featuresToolbox.labelOutlineColorPickerWSelector.getColorPicker().setValue((Object)jfxColor);
                this.featuresToolbox.labelOutlineColorPickerWSelector.getSelectorButton().setSelected(false);
            } else if (this.featuresToolbox.labelBackgroundColorPickerWSelector.getSelectorButton().isSelected()) {
                this.featuresToolbox.labelBackgroundColorPickerWSelector.getColorPicker().setValue((Object)jfxColor);
                this.featuresToolbox.labelBackgroundColorPickerWSelector.getSelectorButton().setSelected(false);
            } else if (this.labelsToolbox.labelColorPickerWSelector.getSelectorButton().isSelected()) {
                this.labelsToolbox.labelColorPickerWSelector.getColorPicker().setValue((Object)jfxColor);
                this.labelsToolbox.labelColorPickerWSelector.getSelectorButton().setSelected(false);
            } else if (this.labelsToolbox.labelOutlineColorPickerWSelector.getSelectorButton().isSelected()) {
                this.labelsToolbox.labelOutlineColorPickerWSelector.getColorPicker().setValue((Object)jfxColor);
                this.labelsToolbox.labelOutlineColorPickerWSelector.getSelectorButton().setSelected(false);
            } else if (this.labelsToolbox.labelBackgroundColorPickerWSelector.getSelectorButton().isSelected()) {
                this.labelsToolbox.labelBackgroundColorPickerWSelector.getColorPicker().setValue((Object)jfxColor);
                this.labelsToolbox.labelBackgroundColorPickerWSelector.getSelectorButton().setSelected(false);
            } else if (this.terrainToolbox.backgroundCPWSelector.getSelectorButton().isSelected() && this.terrainToolbox.overrideColorCB.isSelected()) {
                this.terrainToolbox.backgroundCPWSelector.getColorPicker().setValue((Object)jfxColor);
                this.terrainToolbox.backgroundCPWSelector.getSelectorButton().setSelected(false);
            }
        }
        catch (AWTException e) {
            throw new RuntimeException(e);
        }
    }

    public void generateCoastlineForTile(MouseEvent t) {
        Point2D terrain = Worldographer.getMapUI().getTerrainFromScenePt(t.getX(), t.getY());
        Point2D modelclickcoords = Worldographer.getMapUI().getModelCoordsFromScreenPt(t.getX(), t.getY());
        Pair<Double, Double> terrainmodelcoords = Worldographer.getMapUI().getModelPtFromTerrain((int)terrain.getX(), (int)terrain.getY());
        double diffx = Math.abs(modelclickcoords.getX() - (Double)terrainmodelcoords.getKey());
        double diffy = Math.abs(modelclickcoords.getY() - (Double)terrainmodelcoords.getValue());
        int distancefromcenter = (int)Math.sqrt(diffx * diffx + diffy * diffy);
        UndoActionGroup uag = new UndoActionGroup();
        String terrainTypeName = mapUI.getMapData().getTerrain(mapUI.getViewLevel())[(int)terrain.getX()][(int)terrain.getY()].getTypeName();
        if (terrainTypeName.toLowerCase().contains("water")) {
            MapLogic.addCoastlineToTile(uag, Worldographer.getMapUI().getMapData(), Worldographer.getMapUI().getMapData().getShapes(), (int)terrain.getX(), (int)terrain.getY(), (150 - distancefromcenter) * 3 / 4, Worldographer.getMapUI().viewLevel, Worldographer.getMapUI().getMapData().getMapLayer("Above Water"), false);
        } else if (terrainTypeName.toLowerCase().startsWith("iso ")) {
            boolean useRockyCoast = terrainTypeName.contains("mountain") || terrainTypeName.contains("volcano") || terrainTypeName.contains("badlands") || terrainTypeName.contains("rocky");
            MapLayer ml = mapUI.getMapData().getMapLayer("Above Terrain Y-Ordered");
            if (ml == null) {
                int found = 0;
                List<MapLayer> layers = mapUI.getMapData().getMapLayers();
                for (int i = 0; i < layers.size(); ++i) {
                    if (!layers.get(i).getName().equalsIgnoreCase("Above Terrain")) continue;
                    found = i;
                    break;
                }
                ml = new MapLayer("Above Terrain Y-Ordered");
                layers.add(found, ml);
            }
            HashMap<String, List<String>> shoreTypesToShores = new HashMap<String, List<String>>();
            HashMap<String, List<String>> shoreTypesToShoresRocky = new HashMap<String, List<String>>();
            MapLogic.setupShoresForCoasts(shoreTypesToShores, shoreTypesToShoresRocky);
            MapLogic.addISOCoastlineToTile(uag, mapUI.getMapData(), (int)terrain.getX(), (int)terrain.getY(), mapUI.getViewLevel(), ml, false, useRockyCoast ? shoreTypesToShoresRocky : shoreTypesToShores, useRockyCoast);
        }
        Worldographer.getMapUI().getController().getUndoRedoHandler().push(uag);
        Worldographer.getMapUI().draw();
    }

    private void deletePoint(MouseEvent t) {
        for (MapObject mo : Worldographer.getMapUI().getCurrentObjects()) {
            if (!(mo instanceof MapShape)) continue;
            MapShape ms = (MapShape)mo;
            for (int i = 0; i < ms.getShapePoints().size(); ++i) {
                Point2D pt = ms.getShapePoints().get(i);
                Point2D shapeptonscreen = Worldographer.getMapUI().getScreenCoordsFromModelCoords(pt.getX(), pt.getY());
                double diffx = Math.abs(shapeptonscreen.getX() - t.getX());
                double diffy = Math.abs(shapeptonscreen.getY() - t.getY());
                if (!(diffx < 5.0) || !(diffy < 5.0)) continue;
                Worldographer.getMapUI().getController().deletePointFromShape(this.undoEnabled, ms, pt);
                Worldographer.getMapUI().draggingObject = null;
                Worldographer.getMapUI().draw();
            }
        }
    }

    private void selectMapLabel(MouseEvent t) {
        double offseth = Worldographer.getMapUI().hScrollBar.getValue() / Worldographer.getMapUI().hScrollBar.getMax() * (Worldographer.getMapUI().computeTotalMapWidthPixelsCurrentTileSize() - Worldographer.getMapUI().canvas.getWidth());
        double offsetv = Worldographer.getMapUI().vScrollBar.getValue() / Worldographer.getMapUI().vScrollBar.getMax() * (Worldographer.getMapUI().computeTotalMapHeightPixelsCurrentTileSize() - Worldographer.getMapUI().canvas.getHeight());
        Point2D modelpt = Worldographer.getMapUI().getModelCoordsFromScreenPt(t.getX(), t.getY());
        Point2D ptonscreen = new Point2D(modelpt.getX() * mapUI.getMapData().getTileWidth() / 300.0 - offseth, modelpt.getY() * mapUI.getMapData().getTileHeight() / 300.0 - offsetv);
        for (MapLabel ml : Worldographer.getMapUI().getMapData().getMapLabels()) {
            if (ml.getMapLayer() != null && !ml.getMapLayer().isVisible() || ml.getLocation(mapUI.getViewLevel()) == null || !Worldographer.getMapUI().canvas.isInsideLabelBoundingBox(ml, ptonscreen)) continue;
            if (!t.isControlDown()) {
                Worldographer.getMapUI().getCurrentObjects().clear();
            }
            Worldographer.getMapUI().getCurrentObjects().add(ml);
            if (Worldographer.getMapUI().getCurrentObjects().size() == 1) {
                this.updateSelectionControls();
            }
            Worldographer.getMapUI().draw();
        }
        Worldographer.getMapUI().draw();
    }

    private void selectFeature(MouseEvent t) {
        Point2D clickModelPt = Worldographer.getMapUI().getModelCoordsFromScreenPt(t.getX(), t.getY());
        Feature f = this.getFeatureMouseIsOver(clickModelPt, true);
        if (f != null) {
            if (!t.isControlDown()) {
                Worldographer.getMapUI().getCurrentObjects().clear();
            }
            Worldographer.getMapUI().getCurrentObjects().add(f);
            if (Worldographer.getMapUI().getCurrentObjects().size() == 1) {
                this.updateSelectionControls();
            }
        }
        Worldographer.getMapUI().draw();
    }

    private void selectNote(MouseEvent t) {
        Point2D clickModelPt = Worldographer.getMapUI().getModelCoordsFromScreenPt(t.getX(), t.getY());
        Note n = mapUI.getMapData().getNoteNearPoint(Worldographer.mapUI.viewLevel, clickModelPt.getX(), clickModelPt.getY());
        if (n != null) {
            Worldographer.getMapUI().getCurrentObjects().add(n);
        }
    }

    private Feature getFeatureMouseIsOver(Point2D clickModelPt, boolean select) {
        ArrayList<Feature> featureMatches = new ArrayList<Feature>();
        for (Feature f : Worldographer.getMapUI().getMapData().getFeatures()) {
            double fh;
            Point2D fpt;
            if (f.getMapLayer() != null && !f.getMapLayer().isVisible() || (fpt = f.getLocation(Worldographer.getMapUI().getViewLevel())) == null) continue;
            double fw = f.getScaleFallbackType() * 1.5;
            if (fw < 5.0) {
                fw = 10.0;
            }
            double fx = fpt.getX() - fw;
            double htFactor = f.getScaleHt();
            if (htFactor <= 0.0 && f.getType().getIconHeight() > 0.0) {
                htFactor = f.getScale() * f.getType().getIconHeight() / f.getType().getIconSize();
            }
            if (htFactor <= 0.0) {
                htFactor = f.getScaleHtFallbackType();
            }
            if (htFactor <= 0.0) {
                htFactor = f.getScaleFallbackType();
            }
            if ((fh = htFactor * 1.5) < 10.0) {
                fh = 10.0;
            }
            double fy = fpt.getY() - fh;
            double fOppX = fpt.getX() + fw;
            double fOppY = fpt.getY() + fh;
            Rotate rotate = new Rotate();
            rotate.setAngle(f.getRotate());
            rotate.setPivotX(fpt.getX());
            rotate.setPivotY(fpt.getY());
            Polygon fShape = new Polygon();
            fShape.getPoints().addAll((Object[])new Double[]{fx, fy, fx, fOppY, fOppX, fOppY, fOppX, fy});
            fShape.setFill((Paint)javafx.scene.paint.Color.WHITE);
            if (!fShape.contains(clickModelPt)) continue;
            featureMatches.add(f);
        }
        if (!select) {
            if (featureMatches.size() == 0) {
                return null;
            }
            return (Feature)featureMatches.get(0);
        }
        if (featureMatches.size() == 1) {
            Worldographer.getMapUI().getCurrentObjects().add((MapObject)featureMatches.get(0));
            return (Feature)featureMatches.get(0);
        }
        if (featureMatches.size() > 1) {
            for (MapLayer ml : Worldographer.getMapUI().getMapData().getMapLayers()) {
                for (int i = featureMatches.size() - 1; i >= 0; --i) {
                    Feature f = (Feature)featureMatches.get(i);
                    if (f.getMapLayer() != ml) continue;
                    Worldographer.getMapUI().getCurrentObjects().add(f);
                    return f;
                }
            }
        }
        return null;
    }

    private void selectTerrain(MouseEvent t) {
        Point2D coords1 = Worldographer.getMapUI().getTerrainFromScenePt(t.getX(), t.getY());
        Pair<Double, Double> modelClickCoords = mapUI.getModelPtFromTerrain(coords1.getX(), coords1.getY());
        Point extraTerrainClickPt = new Point((Double)modelClickCoords.getKey() - 150.0, (Double)modelClickCoords.getValue() - 150.0);
        Terrain tx = Worldographer.getMapUI().getMapData().getTerrain(Worldographer.getMapUI().getViewLevel())[(int)coords1.getX()][(int)coords1.getY()];
        for (MapLayer ml : mapUI.getMapData().getMapLayers()) {
            Terrain ter;
            if (!ml.isVisible()) continue;
            if ((ml.getName().toLowerCase().equals("terrain land") || ml.getName().toLowerCase().equals("terrain water")) && !tx.getTypeName().toLowerCase().equals("border only")) {
                if (!t.isControlDown()) {
                    Worldographer.getMapUI().getCurrentObjects().clear();
                }
                Worldographer.getMapUI().getCurrentObjects().add(tx);
                tx.setGridTempX((int)coords1.getX());
                tx.setGridTempY((int)coords1.getY());
                if (Worldographer.getMapUI().getCurrentObjects().size() == 1) {
                    this.updateSelectionControls();
                }
                Worldographer.getMapUI().draw();
                return;
            }
            Map<Point, Terrain> map = mapUI.getMapData().getExtraTerrainByLayer().get(ml);
            if (map == null || (ter = map.get(extraTerrainClickPt)) == null) continue;
            if (!t.isControlDown()) {
                Worldographer.getMapUI().getCurrentObjects().clear();
            }
            Worldographer.getMapUI().getCurrentObjects().add(ter);
            if (Worldographer.getMapUI().getCurrentObjects().size() == 1) {
                this.updateSelectionControls();
            }
            Worldographer.getMapUI().draw();
            return;
        }
    }

    private boolean selectShape(MouseEvent t) {
        Point2D modelpt = Worldographer.getMapUI().getModelCoordsFromScreenPt(t.getX(), t.getY());
        boolean selectedatleastone = false;
        if (ShapesToolbox.shapesSelectButton.isSelected()) {
            boolean triggered = this.selectShapeHelper(modelpt, false, false);
            if (!triggered) {
                triggered = this.selectShapeHelper(modelpt, false, true);
            }
            if (triggered) {
                selectedatleastone = true;
            }
        }
        return selectedatleastone;
    }

    private boolean selectShapeHelper(Point2D modelpt, boolean triggered, boolean fill) {
        for (int i = 0; i < Worldographer.getMapUI().getMapData().getShapes().size(); ++i) {
            MapShape ms = Worldographer.getMapUI().getMapData().getShapes().get(i);
            if (ms.getMapLayer() != null && !ms.getMapLayer().isVisible()) continue;
            boolean filled = false;
            Paint unfilled = null;
            if (ms.getShape() == null) continue;
            if (ms.getShape().getFill() == null && fill) {
                filled = true;
                ms.getShape().setFill((Paint)new javafx.scene.paint.Color(1.0, 1.0, 1.0, 1.0));
            } else if (ms.getShape().getFill() != null && !fill) {
                unfilled = ms.getShape().getFill();
                ms.getShape().setFill(null);
            }
            if (this.worldographerMenuBar.selectInsidePolygonsItem.isSelected() && ms.getShape().contains(modelpt) || this.isClickNearShapePoint(modelpt, ms.getShapePoints())) {
                if (filled) {
                    ms.getShape().setFill(null);
                    filled = false;
                }
                if (unfilled != null) {
                    ms.getShape().setFill(unfilled);
                    unfilled = null;
                }
                Worldographer.getMapUI().getCurrentObjects().add(ms);
                Worldographer.getMapUI().draw();
                triggered = true;
            }
            if (filled) {
                ms.getShape().setFill(null);
            }
            if (unfilled != null) {
                ms.getShape().setFill(unfilled);
            }
            if (!triggered || Worldographer.getMapUI().getCurrentObjects().size() != 1) continue;
            this.updateSelectionControls();
        }
        return triggered;
    }

    private boolean isClickNearShapePoint(Point2D clickpt, List<Point2D> shapePoints) {
        for (Point2D shapept : shapePoints) {
            if (!(Math.abs(shapept.getX() - clickpt.getX()) < 20.0) || !(Math.abs(shapept.getY() - clickpt.getY()) < 20.0)) continue;
            return true;
        }
        return false;
    }

    public Point2D getSnapModelPtFromModelPt(Point2D modelpt) {
        int x = (int)modelpt.getX() + 37;
        int y = (int)modelpt.getY() + 43;
        modelpt = new Point2D((double)(x / 75) * 75.0, (double)(y / 75) * 75.0);
        return modelpt;
    }

    public void createRightTabControls(ViewLevel initialvl) {
        this.miniMapToolbox.createMiniMap(initialvl);
        this.controlsTabPane.setSide(Side.RIGHT);
        Node layersNode = this.layersToolbox.createLayersTable();
        Node terrainNode = this.terrainToolbox.createTerrainDrawer(this.undoEnabled);
        Node featuresNode = this.featuresToolbox.createFeaturesDrawer(this.undoEnabled);
        Pane shapesNode = this.shapesToolbox.createShapesDrawer();
        BorderPane labelsNode = this.labelsToolbox.createLabelsDrawer(this.toggleGroup, this.featuresToolbox, this.undoEnabled);
        Node roomsNode = this.roomToolbox.createRoomDrawer(this.toggleGroup);
        GridPane fogOfWarNode = this.fogOfWarToolbox.createFogOfWarDrawer();
        GridPane underlayNode = this.underlayToolbox.createTraceUnderlayDrawer();
        if (this.layersTab == null) {
            this.layersTab = new Tab("Layers", layersNode);
            this.layersTab.setClosable(false);
        } else {
            this.layersTab.setContent(layersNode);
        }
        if (this.terrainTab == null) {
            this.terrainTab = new Tab("Terrain", terrainNode);
            this.terrainTab.setClosable(false);
        } else {
            this.terrainTab.setContent(terrainNode);
        }
        if (this.featuresTab == null) {
            this.featuresTab = new Tab("Features", featuresNode);
            this.featuresTab.setClosable(false);
        } else {
            this.featuresTab.setContent(featuresNode);
        }
        if (this.shapesTab == null) {
            this.shapesTab = new Tab("Shapes", (Node)shapesNode);
            this.shapesTab.setClosable(false);
        } else {
            this.shapesTab.setContent((Node)shapesNode);
        }
        if (this.labelsTab == null) {
            this.labelsTab = new Tab("Labels", (Node)labelsNode);
            this.labelsTab.setClosable(false);
        } else {
            this.labelsTab.setContent((Node)labelsNode);
        }
        if (this.roomsTab == null) {
            this.roomsTab = new Tab("Rooms", roomsNode);
            this.roomsTab.setClosable(false);
        } else {
            this.roomsTab.setContent(roomsNode);
        }
        if (this.fogTab == null) {
            this.fogTab = new Tab("Fog Of War/Explore", (Node)fogOfWarNode);
            this.fogTab.setClosable(false);
        } else {
            this.fogTab.setContent((Node)fogOfWarNode);
        }
        if (this.traceTab == null) {
            this.traceTab = new Tab("Trace Underlay", (Node)underlayNode);
            this.traceTab.setClosable(false);
        } else {
            this.traceTab.setContent((Node)underlayNode);
        }
        this.controlsTabPane.getTabs().add((Object)this.terrainTab);
        this.controlsTabPane.getTabs().add((Object)this.featuresTab);
        this.controlsTabPane.getTabs().add((Object)this.shapesTab);
        this.controlsTabPane.getTabs().add((Object)this.labelsTab);
        if (initialvl == ViewLevel.BATTLEMAT) {
            this.controlsTabPane.getTabs().add((Object)this.roomsTab);
        }
        this.controlsTabPane.getTabs().add((Object)this.layersTab);
        this.controlsTabPane.getTabs().add((Object)this.fogTab);
        this.controlsTabPane.getTabs().add((Object)this.traceTab);
        this.rightControls.getChildren().add((Object)this.controlsTabPane);
        if (this.splitPane.getItems().size() < 2) {
            this.splitPane.getItems().add((Object)this.rightControls);
        }
        this.splitPane.setDividerPosition(0, 0.75);
        this.controlsTabPane.setMinWidth(100.0);
    }

    public void addToLayersTableView(int index, MapLayer ml) {
        this.layersToolbox.addToLayersTableView(index, ml);
    }

    private Node updateMapObjectsPane() {
        this.newTerrainButton.setOnAction(event -> this.updateMapObjectsPane());
        this.mapObjectsBorderPane.getChildren().clear();
        HBox topbox1 = new HBox();
        topbox1.getChildren().add((Object)this.selectButton);
        topbox1.getChildren().add((Object)this.newTerrainButton);
        topbox1.getChildren().add((Object)this.newFeatureButton);
        topbox1.getChildren().add((Object)this.labelsToolbox.newLabelButton);
        HBox topbox2 = new HBox();
        this.shapesToolbox.addShapesButtons(topbox2);
        FlowPane topflowpane = new FlowPane();
        topflowpane.getChildren().add((Object)topbox1);
        topflowpane.getChildren().add((Object)topbox2);
        this.mapObjectsBorderPane.setTop((Node)topflowpane);
        if (this.newTerrainButton.isSelected()) {
            Object[] terraintypenames;
            int tisocount = 0;
            for (Object o : terraintypenames = Terrain.terrainTypes.keySet().toArray()) {
                Terrain t = new Terrain((String)o, true);
                ToggleButton button = this.terrainToolbox.terrainButtons.get(t.getTypeName());
                if (button == null) {
                    button = new ToggleButton();
                    this.terrainToolbox.createTerrainButton(t, button, true, 48.0);
                    this.terrainToolbox.terrainButtons.put(t.getTypeName(), button);
                } else {
                    String tn = t.getTypeName();
                    this.terrainToolbox.setTerrainButtonImage(t, button, tn, 48.0);
                }
                this.terrainbuttonpane.getChildren().add((Object)button);
                if (++tisocount > 120) break;
            }
            int buttoncount = tisocount;
            ScrollPane terrainscrollpane = new ScrollPane((Node)this.terrainbuttonpane);
            terrainscrollpane.setFitToHeight(true);
            terrainscrollpane.setFitToWidth(true);
            terrainscrollpane.setVbarPolicy(ScrollPane.ScrollBarPolicy.ALWAYS);
            terrainscrollpane.widthProperty().addListener(event -> {
                int buttonsperline = (int)((terrainscrollpane.getWidth() - 15.0) / 80.0);
                int ht = buttoncount / buttonsperline + (buttoncount % buttonsperline == 0 ? 0 : 1);
                this.terrainbuttonpane.setPrefSize(terrainscrollpane.getWidth() - 15.0, (double)(ht * 75));
                this.terrainbuttonpane.setMinSize(terrainscrollpane.getWidth() - 15.0, (double)(ht * 75));
                this.terrainbuttonpane.setMaxSize(terrainscrollpane.getWidth() - 15.0, (double)(ht * 756));
            });
            this.mapObjectsBorderPane.setCenter((Node)terrainscrollpane);
        }
        return this.mapObjectsBorderPane;
    }

    public void setSelectedGMOnly(boolean gmonly) {
        Polygon p = new Polygon();
        for (int i = 0; i < Worldographer.getMapUI().selectPts.size(); ++i) {
            Point2D pt = MapUI.getScreenCoordsFromModelCoords(Worldographer.getMapUI().selectPts.get(i).getX(), Worldographer.getMapUI().selectPts.get(i).getY(), 0.0, 0.0, Worldographer.getMapUI().getMapData().getTileWidth(), Worldographer.getMapUI().getMapData().getTileHeight());
            p.getPoints().add((Object)pt.getX());
            p.getPoints().add((Object)pt.getY());
        }
        p.setFill((Paint)javafx.scene.paint.Color.RED);
        ((MapUI.ResizableCanvas)Worldographer.getMapUI().getCanvas()).setTerrainGMOnly((Shape)p, gmonly);
    }

    public Stage getPrimaryStage() {
        return primaryStage;
    }

    private void onClose(WindowEvent e) {
        if (Worldographer.getMapUI() != null) {
            StringBuilder changedmapnames = new StringBuilder();
            for (Tab t : this.tabPane.getTabs()) {
                MapUI mu = (MapUI)t.getContent();
                if (mu.getController().getUndoRedoHandler() == null || !mu.getController().getUndoRedoHandler().isChanged()) continue;
                changedmapnames.append("\u2022 ").append(((DraggableTab)t).getLabelText()).append("\n");
            }
            if (!changedmapnames.toString().equals("")) {
                StyledDialog d = new StyledDialog(true, (Window)primaryStage, "Confirm Close");
                d.setHeaderText("Changes Not Saved.");
                d.getDialogPane().setContent((Node)new Label("Changes you've made to the following maps haven't been saved:\n" + String.valueOf(changedmapnames) + "Are you sure you wish to close the program?"));
                ButtonType yes = new ButtonType("OK");
                ButtonType cancel = new ButtonType("Cancel");
                d.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{yes, cancel});
                Optional result = d.showAndWait();
                if (result.isPresent() && result.get() == yes) {
                    System.exit(0);
                } else {
                    e.consume();
                }
            } else {
                System.exit(0);
            }
        } else {
            System.exit(0);
        }
    }

    private void tabPaneSelectionModelChange(ObservableValue<? extends Tab> ov, Tab oldtab, Tab newtab) {
        if (Worldographer.getMapUI() != null) {
            this.tabScrollBarSettings.put(oldtab, (Pair<Double, Double>)new Pair((Object)Worldographer.getMapUI().hScrollBar.getValue(), (Object)Worldographer.getMapUI().vScrollBar.getValue()));
        }
        if (newtab == null) {
            return;
        }
        this.setMapUI((MapUI)newtab.getContent());
        ViewLevelBox.dontRecalculateViewLevels = true;
        for (String fc : featureCategories) {
            if (this.featuresToolbox.featureFilterComboBox.getItems().contains((Object)fc)) continue;
            this.featuresToolbox.featureFilterComboBox.getItems().add((Object)fc);
        }
        for (String tc : terrainCategories) {
            if (this.terrainToolbox.terrainFilterComboBox.getItems().contains((Object)tc)) continue;
            this.terrainToolbox.terrainFilterComboBox.getItems().add((Object)tc);
        }
        if (Worldographer.getMapUI().getViewLevel() == ViewLevel.SETTLEMENT) {
            this.setupSettlementSpecificControls();
        } else if (Worldographer.getMapUI().getViewLevel() == ViewLevel.BATTLEMAT) {
            this.setupBattlematSpecificControls();
        } else if (Worldographer.getMapUI().getViewLevel() == ViewLevel.COSMIC) {
            this.setupCosmicSpecificControls();
        } else {
            this.setupWorldKingdomSpecificControls();
        }
        ViewLevelBox.dontRecalculateViewLevels = false;
        Pair<Double, Double> scrollsettings = this.tabScrollBarSettings.get(newtab);
        if (scrollsettings != null) {
            Worldographer.getMapUI().hScrollBar.setValue(((Double)scrollsettings.getKey()).doubleValue());
            Worldographer.getMapUI().vScrollBar.setValue(((Double)scrollsettings.getValue()).doubleValue());
        }
        this.viewLevelBox.updateOverviewLabel(true);
        this.viewLevelBox.updateSpinners();
        this.updateLayersToolbox();
        if (this.featuresToolbox.featuresMapLayerCombo != null) {
            this.featuresToolbox.featuresMapLayerCombo.setItems(this.observableLayers);
        }
        if (this.terrainToolbox.terrainMapLayerCombo != null) {
            this.terrainToolbox.terrainMapLayerCombo.setItems(this.observableLayers);
        }
        this.viewOptions.update();
        this.shapesToolbox.updateShapeStyleList();
        this.labelsToolbox.updateTextStylesList();
        this.observableLayers.addListener(c -> {
            while (c.next()) {
                if (c.wasPermutated()) {
                    for (int i = c.getFrom(); i < c.getTo(); ++i) {
                    }
                    continue;
                }
                if (!c.wasUpdated()) continue;
            }
        });
        Worldographer.getMapUI().draw();
    }

    public void updateLayersToolbox() {
        MapLayer featureLayer = (MapLayer)this.featuresToolbox.featuresMapLayerCombo.getSelectionModel().getSelectedItem();
        MapLayer shapesLayer = (MapLayer)this.shapesToolbox.shapesMapLayerCombo.getSelectionModel().getSelectedItem();
        MapLayer terrainLayer = (MapLayer)this.terrainToolbox.terrainMapLayerCombo.getSelectionModel().getSelectedItem();
        MapLayer labelsLayer = (MapLayer)this.labelsToolbox.labelsMapLayerCombo.getSelectionModel().getSelectedItem();
        if (this.observableLayers == null) {
            this.observableLayers = FXCollections.observableList(Worldographer.getMapUI().getMapData().getMapLayers());
        } else {
            this.observableLayers.clear();
            this.observableLayers.addAll(Worldographer.getMapUI().getMapData().getMapLayers());
        }
        this.layersToolbox.layersTableView.setItems(this.observableLayers);
        if (featureLayer != null) {
            this.featuresToolbox.featuresMapLayerCombo.getSelectionModel().select((Object)featureLayer);
        }
        this.shapesToolbox.shapesMapLayerCombo.getSelectionModel().select((Object)shapesLayer);
        this.terrainToolbox.terrainMapLayerCombo.getSelectionModel().select((Object)terrainLayer);
        this.labelsToolbox.labelsMapLayerCombo.getSelectionModel().select((Object)labelsLayer);
    }

    public static MapUI getMapUI() {
        return mapUI;
    }

    public void setMapUI(MapUI mapUI) {
        Worldographer.mapUI = mapUI;
        this.viewOptions.setMapUI(Worldographer.getMapUI());
    }

    public static void pingUsage(String location) {
        if (!REPORTING) {
            return;
        }
        Thread th = new Thread(() -> {
            BufferedReader in1 = null;
            try {
                URL propsURL = new URL(location);
                in1 = new BufferedReader(new InputStreamReader(propsURL.openStream()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (in1 != null) {
                    try {
                        in1.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        th.start();
    }
}

