/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.ui;

import com.inkwellideas.ographer.data.HexOrientation;
import com.inkwellideas.ographer.data.MapLayer;
import com.inkwellideas.ographer.data.MapObject;
import com.inkwellideas.ographer.data.ViewLevel;
import com.inkwellideas.ographer.generator.world.WorldAndNameData;
import com.inkwellideas.ographer.information.Information;
import com.inkwellideas.ographer.io.FileSaveLoad;
import com.inkwellideas.ographer.io.UserPrefs;
import com.inkwellideas.ographer.map.MapData;
import com.inkwellideas.ographer.map.MapDataSetTerrain;
import com.inkwellideas.ographer.map.MapDataSetup;
import com.inkwellideas.ographer.map.MapLogic;
import com.inkwellideas.ographer.map.MapProjection;
import com.inkwellideas.ographer.map.MapShape;
import com.inkwellideas.ographer.map.Terrain;
import com.inkwellideas.ographer.model.Feature;
import com.inkwellideas.ographer.task.ExportNotesTask;
import com.inkwellideas.ographer.task.GenerateEmpiresTask;
import com.inkwellideas.ographer.ui.MapUI;
import com.inkwellideas.ographer.ui.WorldBook;
import com.inkwellideas.ographer.ui.Worldographer;
import com.inkwellideas.ographer.ui.configure.ConfigureMapKeyFrame;
import com.inkwellideas.ographer.ui.dialog.BlueColorShiftDialog;
import com.inkwellideas.ographer.ui.dialog.ChildMapNumTilesDialog;
import com.inkwellideas.ographer.ui.dialog.CityGeneratorUI;
import com.inkwellideas.ographer.ui.dialog.ConvertUnderlayMapDialog;
import com.inkwellideas.ographer.ui.dialog.CreateChildMapDialog;
import com.inkwellideas.ographer.ui.dialog.DPIDialog;
import com.inkwellideas.ographer.ui.dialog.ExpandShrinkTilesDialog;
import com.inkwellideas.ographer.ui.dialog.ExportPDFDialog;
import com.inkwellideas.ographer.ui.dialog.GenerateRiversDialog;
import com.inkwellideas.ographer.ui.dialog.LicenseDialog;
import com.inkwellideas.ographer.ui.dialog.LogDialog;
import com.inkwellideas.ographer.ui.dialog.MapLevelDialog;
import com.inkwellideas.ographer.ui.dialog.MemoryDialog;
import com.inkwellideas.ographer.ui.dialog.OtherDialog;
import com.inkwellideas.ographer.ui.dialog.StandardDialog;
import com.inkwellideas.ographer.ui.dialog.StartNewMapDialog;
import com.inkwellideas.ographer.ui.dialog.UpdaterDialog;
import com.inkwellideas.ographer.ui.setup.SetupBattlematScreen;
import com.inkwellideas.ographer.ui.setup.SetupCityScreen;
import com.inkwellideas.ographer.ui.setup.SetupCosmicScreen;
import com.inkwellideas.ographer.ui.setup.SetupWorldRegionScreen;
import com.inkwellideas.ographer.ui.toolbox.ViewLevelBox;
import com.inkwellideas.ographer.ui.widget.FocusSpinner;
import com.inkwellideas.ographer.ui.widget.StyledDialog;
import com.inkwellideas.ographer.ui.widget.WorldographerConfigMenuBar;
import com.inkwellideas.ographer.undo.CopyDataHolder;
import com.inkwellideas.ographer.undo.UndoAction;
import com.inkwellideas.ographer.undo.UndoActionGroup;
import com.inkwellideas.ographer.util.Base64;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.TreeMap;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javafx.animation.PathTransition;
import javafx.collections.FXCollections;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioButton;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.Spinner;
import javafx.scene.control.TextArea;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.shape.Arc;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.Polygon;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import javafx.scene.transform.Rotate;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Duration;
import javafx.util.Pair;
import javax.imageio.ImageIO;

public class WorldographerMenuBar {
    final MenuBar menuBar = new MenuBar();
    Menu menuTools;
    Menu menuGenerateWorld;
    Menu menuGenerateCity;
    Menu openRecentMap;
    MenuItem genChildMapItem;
    MenuItem genMapLevelItem;
    MenuItem deleteMapLevelItem;
    MenuItem genCoastsItem;
    MenuItem genRiversItem;
    MenuItem regenResourcesItem;
    MenuItem delCoastsItem;
    MenuItem genEmpiresItem;
    MenuItem getHexCrawlItem;
    MenuItem genCoastItem;
    MenuItem genRiverItem;
    MenuItem genRegionRoadsItem;
    MenuItem genMainRoadsItem;
    MenuItem genWallItem;
    MenuItem genBuildingsItem;
    MenuItem genVegetationItem;
    public CheckMenuItem selectItem;
    public CheckMenuItem autoSaveItem;
    CheckMenuItem showHoverDetailsItem;
    public CheckMenuItem autoUpdateOtherLevelsItem;
    public CheckMenuItem selectFeatureWhenPlaced;
    CheckMenuItem selectInsidePolygonsItem;
    public CheckMenuItem scrollWheelItem;
    MenuItem switchTerrainClassicMenuItem;
    MenuItem switchTerrainIsoMenuItem;
    MenuItem switchIconsRealMenuItem;
    MenuItem switchIconsSimpleMenuItem;
    CheckMenuItem excludeTerrainMI;
    CheckMenuItem excludeExtraTerrainMI;
    CheckMenuItem excludeFeaturesMI;
    CheckMenuItem excludeShapesMI;
    CheckMenuItem excludeLabelsMI;
    CheckMenuItem alignPasteWithGridMI;
    public CheckBox toolboxMenuItem;
    public final Worldographer worldographer;
    private final CityGeneratorUI generatorUI;

    MapUI mapUI() {
        WorldographerMenuBar worldographerMenuBar = this;
        return worldographerMenuBar.worldographer.getMapUI();
    }

    public WorldographerMenuBar(Worldographer worldographer) {
        this.worldographer = worldographer;
        this.generatorUI = new CityGeneratorUI(worldographer);
    }

    public Node createMenuBar() {
        Menu menuFile = new Menu("File");
        Menu menuEdit = new Menu("Edit");
        Menu menuOptions = new Menu("Options");
        this.menuTools = new Menu("Tools");
        Menu menuConfigure = new Menu("Configure");
        this.menuGenerateCity = new Menu("Generate");
        this.menuGenerateWorld = new Menu("Generate");
        Menu menuData = new Menu("Data");
        Menu menuHelp = new Menu("Help");
        Menu menuUpdate = new Menu("Update Available");
        MenuItem updateMI = new MenuItem("Get Update Info");
        updateMI.setOnAction(t -> new UpdaterDialog().getUpdateInfo(this.worldographer.getPrimaryStage(), "2.01"));
        this.menuBar.getMenus().addAll((Object[])new Menu[]{menuFile, menuEdit, menuOptions, this.menuTools, menuConfigure, menuData, menuHelp});
        if (new UpdaterDialog().checkIsOutdated("2.01")) {
            menuUpdate.getItems().addAll((Object[])new MenuItem[]{updateMI});
            this.menuBar.getMenus().add((Object)menuUpdate);
        }
        BorderPane box = new BorderPane();
        box.setLeft((Node)this.menuBar);
        this.createMenuBarFile(menuFile);
        MenuItem saveConfig = new MenuItem("Save Configuration");
        saveConfig.setOnAction(t -> {
            boolean success = new FileSaveLoad(this.worldographer).saveAsFile(true);
            if (success) {
                Alert alert = new Alert(Alert.AlertType.INFORMATION);
                alert.setTitle("Save Successful");
                alert.setHeaderText("Save Successful");
                alert.setContentText("The file was successfully saved.");
                alert.showAndWait();
            }
        });
        MenuItem loadConfig = new MenuItem("Load Configuration");
        loadConfig.setOnAction(t -> {
            File f;
            FileChooser fc = new FileChooser();
            FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("Worldographer XML (*.wxx)", new String[]{"*.wxx"});
            fc.getExtensionFilters().add((Object)extFilter);
            File d = FileSaveLoad.getLastUsedDir();
            if (d != null) {
                fc.setInitialDirectory(d);
            }
            if ((f = fc.showOpenDialog((Window)this.worldographer.getPrimaryStage())) != null) {
                new FileSaveLoad(this.worldographer).loadFile(f, true, Integer.MAX_VALUE, Integer.MAX_VALUE, 0, false);
            }
        });
        MenuItem undoItem = new MenuItem("Undo");
        undoItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.Z, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
        undoItem.setOnAction(t -> {
            WorldographerMenuBar worldographerMenuBar = this;
            if (worldographerMenuBar.worldographer.getMapUI().getMapData() == null) {
                return;
            }
            WorldographerMenuBar worldographerMenuBar2 = this;
            worldographerMenuBar2.worldographer.getMapUI().getController().getUndoRedoHandler().handleUndo();
            this.worldographer.updateSelectionControls();
            this.worldographer.updateLayersToolbox();
            WorldographerMenuBar worldographerMenuBar3 = this;
            worldographerMenuBar3.worldographer.getMapUI().draw();
        });
        MenuItem redoItem = new MenuItem("Redo");
        redoItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.Y, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
        redoItem.setOnAction(t -> {
            WorldographerMenuBar worldographerMenuBar = this;
            if (worldographerMenuBar.worldographer.getMapUI().getMapData() == null) {
                return;
            }
            WorldographerMenuBar worldographerMenuBar2 = this;
            worldographerMenuBar2.worldographer.getMapUI().getController().getUndoRedoHandler().handleRedo();
            this.worldographer.updateSelectionControls();
            this.worldographer.updateLayersToolbox();
            WorldographerMenuBar worldographerMenuBar3 = this;
            worldographerMenuBar3.worldographer.getMapUI().draw();
        });
        this.selectItem = new CheckMenuItem("Select Map Area (Drag Mouse)");
        this.selectItem.setOnAction(t -> {
            WorldographerMenuBar worldographerMenuBar = this;
            worldographerMenuBar.worldographer.getMapUI().selectPts.clear();
            this.worldographer.selectMapAreaToggle.setSelected(this.selectItem.isSelected());
            WorldographerMenuBar worldographerMenuBar2 = this;
            worldographerMenuBar2.worldographer.getMapUI().draw();
        });
        Menu cutCopyPasteOptions = new Menu("Cut/Copy/Paste Options");
        this.alignPasteWithGridMI = new CheckMenuItem("Align Paste With Grid");
        this.alignPasteWithGridMI.setSelected(true);
        this.excludeTerrainMI = new CheckMenuItem("Exclude Terrain");
        this.excludeExtraTerrainMI = new CheckMenuItem("Exclude Terrain on non-Terrain Layers");
        this.excludeFeaturesMI = new CheckMenuItem("Exclude Features");
        this.excludeShapesMI = new CheckMenuItem("Exclude Shapes");
        this.excludeLabelsMI = new CheckMenuItem("Exclude Labels");
        cutCopyPasteOptions.getItems().addAll((Object[])new MenuItem[]{this.alignPasteWithGridMI, this.excludeTerrainMI, this.excludeExtraTerrainMI, this.excludeFeaturesMI, this.excludeShapesMI, this.excludeLabelsMI});
        MenuItem cutItem = new MenuItem("Cut");
        cutItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.X, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
        cutItem.setOnAction(t -> {
            if (UserPrefs.FULL) {
                WorldographerMenuBar worldographerMenuBar = this;
                if (worldographerMenuBar.worldographer.getMapUI().getMapData() == null) {
                    return;
                }
                WorldographerMenuBar worldographerMenuBar2 = this;
                WorldographerMenuBar worldographerMenuBar3 = this;
                WorldographerMenuBar worldographerMenuBar4 = this;
                WorldographerMenuBar worldographerMenuBar5 = this;
                this.worldographer.copyDataHolder = new CopyDataHolder(this.worldographer, worldographerMenuBar2.worldographer.getMapUI().selectPts, worldographerMenuBar3.worldographer.getMapUI().viewLevel, worldographerMenuBar4.worldographer.getMapUI(), worldographerMenuBar5.worldographer.getMapUI().getController().getUndoRedoHandler(), this.excludeTerrainMI.isSelected(), this.excludeExtraTerrainMI.isSelected(), this.excludeFeaturesMI.isSelected(), this.excludeShapesMI.isSelected(), this.excludeLabelsMI.isSelected());
                WorldographerMenuBar worldographerMenuBar6 = this;
                WorldographerMenuBar worldographerMenuBar7 = this;
                this.worldographer.copyDataHolder.copyCutData(worldographerMenuBar6.worldographer.getMapUI().getMapData(), worldographerMenuBar7.worldographer.getMapUI().getCurrentObjects(), true, false);
                WorldographerMenuBar worldographerMenuBar8 = this;
                worldographerMenuBar8.worldographer.getMapUI().draw();
            } else {
                StandardDialog.showDialog(this.worldographer.getPrimaryStage(), "Pro Feature", "Cut/Copy/Paste is only available if using a Pro version license.", "Sorry, some features are reserved for our Pro/paid version. \nIf you find the software useful, considering unlocking these special features and supporting \nthe many hours of work to create Worldographer with a Pro license. \nSee www.worldographer.com for details.\n", null, "");
            }
        });
        MenuItem copyItem = new MenuItem("Copy");
        copyItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.C, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
        copyItem.setOnAction(t -> {
            if (UserPrefs.FULL) {
                WorldographerMenuBar worldographerMenuBar = this;
                if (worldographerMenuBar.worldographer.getMapUI().getMapData() == null) {
                    return;
                }
                WorldographerMenuBar worldographerMenuBar2 = this;
                WorldographerMenuBar worldographerMenuBar3 = this;
                WorldographerMenuBar worldographerMenuBar4 = this;
                WorldographerMenuBar worldographerMenuBar5 = this;
                this.worldographer.copyDataHolder = new CopyDataHolder(this.worldographer, worldographerMenuBar2.worldographer.getMapUI().selectPts, worldographerMenuBar3.worldographer.getMapUI().viewLevel, worldographerMenuBar4.worldographer.getMapUI(), worldographerMenuBar5.worldographer.getMapUI().getController().getUndoRedoHandler(), this.excludeTerrainMI.isSelected(), this.excludeExtraTerrainMI.isSelected(), this.excludeFeaturesMI.isSelected(), this.excludeShapesMI.isSelected(), this.excludeLabelsMI.isSelected());
                WorldographerMenuBar worldographerMenuBar6 = this;
                WorldographerMenuBar worldographerMenuBar7 = this;
                this.worldographer.copyDataHolder.copyCutData(worldographerMenuBar6.worldographer.getMapUI().getMapData(), worldographerMenuBar7.worldographer.getMapUI().getCurrentObjects(), false, false);
            } else {
                StandardDialog.showDialog(this.worldographer.getPrimaryStage(), "Pro Feature", "Cut/Copy/Paste is only available if using a Pro version license.", "Sorry, some features are reserved for our Pro/paid version. \nIf you find the software useful, considering unlocking these special features and supporting \nthe many hours of work to create Worldographer with a Pro license. \nSee www.worldographer.com for details.\n", null, "");
            }
        });
        MenuItem pasteItem = new MenuItem("Paste");
        pasteItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.V, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
        pasteItem.setOnAction(t -> this.pasteItemAction());
        MenuItem deleteItem = new MenuItem("Delete");
        deleteItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.DELETE, new KeyCombination.Modifier[0]));
        deleteItem.setOnAction(t -> this.deleteItemAction());
        menuEdit.getItems().addAll((Object[])new MenuItem[]{this.selectItem, cutCopyPasteOptions, cutItem, copyItem, pasteItem, new SeparatorMenuItem(), undoItem, redoItem, new SeparatorMenuItem(), deleteItem});
        ToggleButton minimapMI = new ToggleButton("", (Node)new ImageView(this.worldographer.from("other_imgs/minimap_24.png")));
        ToggleButton layersMI = new ToggleButton("", (Node)new ImageView(this.worldographer.from("other_imgs/layers_24.png")));
        ToggleButton terrainMI = new ToggleButton("", (Node)new ImageView(this.worldographer.from("other_imgs/terrain_24.png")));
        ToggleButton featuresMI = new ToggleButton("", (Node)new ImageView(this.worldographer.from("other_imgs/features_24.png")));
        ToggleButton shapesMI = new ToggleButton("", (Node)new ImageView(this.worldographer.from("other_imgs/new_polygon_24.png")));
        ToggleButton labelsMI = new ToggleButton("", (Node)new ImageView(this.worldographer.from("other_imgs/labels_24.png")));
        ToggleButton fogOfWarMI = new ToggleButton("", (Node)new ImageView(this.worldographer.from("other_imgs/hide_all_but_24.png")));
        ToggleButton traceUnderlayMI = new ToggleButton("", (Node)new ImageView(this.worldographer.from("other_imgs/trace_24.png")));
        this.toolboxMenuItem = new CheckBox("Use Toolboxes:");
        this.toolboxMenuItem.selectedProperty().setValue(Boolean.valueOf(Preferences.userRoot().node("com/inkwellideas/worldographer2025").getBoolean("toolboxes", false)));
        this.toolboxMenuItem.setOnAction(t -> {
            if (this.toolboxMenuItem.isSelected()) {
                if (this.worldographer.rightControls != null) {
                    this.worldographer.rightControls.getChildren().removeAll((Collection)this.worldographer.rightControls.getChildren());
                }
                this.worldographer.splitPane.getItems().remove((Object)this.worldographer.rightControls);
            } else {
                this.worldographer.miniMapToolbox.closeIfOpen(minimapMI);
                this.worldographer.layersToolbox.closeIfOpen(layersMI);
                this.worldographer.terrainToolbox.closeIfOpen(terrainMI);
                this.worldographer.featuresToolbox.closeIfOpen(featuresMI);
                this.worldographer.shapesToolbox.closeIfOpen(shapesMI);
                this.worldographer.labelsToolbox.closeIfOpen(labelsMI);
                this.worldographer.fogOfWarToolbox.closeIfOpen(fogOfWarMI);
                this.worldographer.underlayToolbox.closeIfOpen(traceUnderlayMI);
                if (this.mapUI() != null && this.mapUI().getMapData() != null) {
                    this.worldographer.createRightTabControls(this.mapUI().getViewLevel());
                    this.worldographer.splitPane.setDividerPosition(0, 0.75);
                }
            }
            UserPrefs.set("toolboxes", this.toolboxMenuItem.isSelected());
        });
        minimapMI.setTooltip(new Tooltip("Mini-Map"));
        minimapMI.setOnAction(t -> this.worldographer.miniMapToolbox.openCloseButton(minimapMI, this.toolboxMenuItem));
        layersMI.setTooltip(new Tooltip("Layers"));
        layersMI.setOnAction(t -> this.worldographer.layersToolbox.openCloseButton(layersMI, this.toolboxMenuItem));
        terrainMI.setTooltip(new Tooltip("Terrain"));
        terrainMI.setOnAction(t -> this.worldographer.terrainToolbox.openCloseButton(terrainMI, this.toolboxMenuItem));
        featuresMI.setTooltip(new Tooltip("Features"));
        featuresMI.setOnAction(t -> this.worldographer.featuresToolbox.openCloseButton(featuresMI, this.toolboxMenuItem));
        shapesMI.setTooltip(new Tooltip("Shapes"));
        shapesMI.setOnAction(t -> this.worldographer.shapesToolbox.openCloseButton(shapesMI, this.toolboxMenuItem));
        labelsMI.setTooltip(new Tooltip("Layers"));
        labelsMI.setOnAction(t -> this.worldographer.labelsToolbox.openCloseButton(labelsMI, this.toolboxMenuItem));
        fogOfWarMI.setTooltip(new Tooltip("Fog of War/Explore"));
        fogOfWarMI.setOnAction(t -> this.worldographer.fogOfWarToolbox.openCloseButton(fogOfWarMI, this.toolboxMenuItem));
        traceUnderlayMI.setTooltip(new Tooltip("Trace Underlay"));
        traceUnderlayMI.setOnAction(t -> this.worldographer.underlayToolbox.openCloseButton(traceUnderlayMI, this.toolboxMenuItem));
        HBox toolboxes = new HBox();
        HBox.setHgrow((Node)toolboxes, (Priority)Priority.ALWAYS);
        toolboxes.getChildren().addAll((Object[])new Node[]{this.toolboxMenuItem, minimapMI, layersMI, terrainMI, featuresMI, shapesMI, labelsMI, fogOfWarMI, traceUnderlayMI});
        toolboxes.setAlignment(Pos.BASELINE_RIGHT);
        box.setRight((Node)toolboxes);
        this.worldographer.getStatusList().setMaxHeight(40.0);
        this.worldographer.getStatusList().setPrefWidth(Double.MAX_VALUE);
        BorderPane statusPane = new BorderPane();
        Label statusL = new Label("  Status:");
        HBox statusLB = new HBox();
        statusLB.setAlignment(Pos.CENTER_LEFT);
        statusLB.getChildren().add((Object)statusL);
        statusPane.setLeft((Node)statusLB);
        statusPane.setCenter(this.worldographer.getStatusList());
        statusPane.setRight((Node)this.worldographer.getCancelButton());
        this.worldographer.getCancelButton().setDisable(this.worldographer.getCancelButton().getOnAction() == null);
        box.setCenter((Node)statusPane);
        statusPane.setPadding(new Insets(0.0, 5.0, 0.0, 5.0));
        Menu themeMI = new Menu("Set Theme");
        String theme = UserPrefs.PREFS.get("theme", "Cupertino Dark");
        RadioMenuItem darkThemeMI = new RadioMenuItem("Cupertino Dark");
        if (theme.equals(darkThemeMI.getText())) {
            darkThemeMI.setSelected(true);
        }
        darkThemeMI.setOnAction(t -> {
            if (darkThemeMI.isSelected()) {
                Worldographer.setTheme(darkThemeMI.getText());
            }
        });
        RadioMenuItem lightThemeMI = new RadioMenuItem("Cupertino Light");
        if (theme.equals(lightThemeMI.getText())) {
            lightThemeMI.setSelected(true);
        }
        lightThemeMI.setOnAction(t -> {
            if (lightThemeMI.isSelected()) {
                Worldographer.setTheme(lightThemeMI.getText());
            }
        });
        RadioMenuItem draculaThemeMI = new RadioMenuItem("Dracula");
        if (theme.equals(draculaThemeMI.getText())) {
            draculaThemeMI.setSelected(true);
        }
        draculaThemeMI.setOnAction(t -> {
            if (draculaThemeMI.isSelected()) {
                Worldographer.setTheme(draculaThemeMI.getText());
            }
        });
        ToggleGroup themeGroup = new ToggleGroup();
        themeGroup.getToggles().addAll((Object[])new Toggle[]{darkThemeMI, lightThemeMI, draculaThemeMI});
        themeMI.getItems().addAll((Object[])new MenuItem[]{darkThemeMI, lightThemeMI, draculaThemeMI});
        this.autoUpdateOtherLevelsItem = new CheckMenuItem("Auto-update Other Map Levels");
        this.autoUpdateOtherLevelsItem.selectedProperty().setValue(UserPrefs.get("autoUpdateOtherLevels", true));
        this.autoUpdateOtherLevelsItem.setOnAction(t -> UserPrefs.set("autoUpdateOtherLevels", this.autoUpdateOtherLevelsItem.isSelected()));
        this.selectFeatureWhenPlaced = new CheckMenuItem("Select New Feature When Placed");
        this.selectFeatureWhenPlaced.selectedProperty().setValue(UserPrefs.get("selectFeatureWhenPlaced", false));
        this.selectFeatureWhenPlaced.setOnAction(t -> UserPrefs.set("selectFeatureWhenPlaced", this.selectFeatureWhenPlaced.isSelected()));
        this.selectInsidePolygonsItem = new CheckMenuItem("Select Shapes by Clicking Inside Polygons");
        this.selectInsidePolygonsItem.selectedProperty().setValue(UserPrefs.get("selectInsidePolygons", false));
        this.selectInsidePolygonsItem.setOnAction(t -> UserPrefs.set("selectInsidePolygons", this.selectInsidePolygonsItem.isSelected()));
        this.scrollWheelItem = new CheckMenuItem("Scroll Wheel Zooms In/Out");
        this.scrollWheelItem.selectedProperty().setValue(UserPrefs.get("scrollWheelZoom", true));
        this.scrollWheelItem.setOnAction(t -> UserPrefs.set("scrollWheelZoom", this.scrollWheelItem.isSelected()));
        this.showHoverDetailsItem = new CheckMenuItem("Show Details on Hover");
        this.autoSaveItem = new CheckMenuItem("Autosave (file~.wxx)");
        this.autoSaveItem.selectedProperty().setValue(UserPrefs.get("autoSave", true));
        this.autoSaveItem.setOnAction(t -> UserPrefs.set("autoSave", this.autoSaveItem.isSelected()));
        menuOptions.getItems().addAll((Object[])new MenuItem[]{themeMI, this.autoUpdateOtherLevelsItem, this.showHoverDetailsItem, this.selectFeatureWhenPlaced, this.selectInsidePolygonsItem, this.scrollWheelItem, this.autoSaveItem});
        this.genRiversItem = new MenuItem("Generate Rivers");
        this.genRiversItem.setOnAction(t -> {
            if (UserPrefs.FULL) {
                if (this.mapUI().getMapData() == null) {
                    StandardDialog.showNoMapOpenDialog(this.worldographer.getPrimaryStage(), "Generate Rivers");
                    return;
                }
                WorldographerMenuBar worldographerMenuBar = this;
                new GenerateRiversDialog(this.worldographer, worldographerMenuBar.worldographer.getMapUI()).showGenerateRiversDialog();
                Worldographer.pingUsage("http://www.worldographer.com/usage/menu_generateRivers.txt");
            } else {
                StandardDialog.showDialog(this.worldographer.getPrimaryStage(), "Pro Feature", "Generate Rivers is only available if using a Pro version license.", "Sorry, some features are reserved for our Pro/paid version. \nIf you find the software useful, considering unlocking these special features and supporting \nthe many hours of work to create Worldographer with a Pro license. \nSee www.worldographer.com for details.\n", null, "");
            }
        });
        this.genChildMapItem = new MenuItem("Generate Child Map As New Map");
        this.genChildMapItem.setOnAction(t -> this.genChildMapAction());
        this.genMapLevelItem = new MenuItem("(Re)Generate Map Level");
        this.genMapLevelItem.setOnAction(t -> this.generateMapLevelAction());
        this.deleteMapLevelItem = new MenuItem("--Delete Map Level");
        this.deleteMapLevelItem.setOnAction(t -> this.deleteMapLevelAction());
        this.regenResourcesItem = new MenuItem("Regenerate Resources");
        this.regenResourcesItem.setOnAction(t -> this.regenrateResourcesDialog());
        this.genCoastsItem = new MenuItem("Generate Coasts");
        this.genCoastsItem.setOnAction(t -> this.genCoastsAction());
        this.delCoastsItem = new MenuItem("--Delete All Coasts");
        this.delCoastsItem.setOnAction(t -> this.deleteCoastsAction());
        this.genEmpiresItem = new MenuItem("Generate Nations/Empires");
        this.genEmpiresItem.setOnAction(t -> this.generateEmpiresAction());
        this.genRegionRoadsItem = new MenuItem("Generate Roads");
        this.genRegionRoadsItem.setOnAction(t -> this.generateRegionRoadsPrompt());
        this.getHexCrawlItem = new MenuItem("Generate Hex Crawl Locations");
        this.getHexCrawlItem.setOnAction(t -> this.generateHexCrawlAction());
        this.menuGenerateWorld.getItems().addAll((Object[])new MenuItem[]{this.genChildMapItem, this.genMapLevelItem, this.deleteMapLevelItem, this.genCoastsItem, this.delCoastsItem, this.genRiversItem, this.genEmpiresItem, this.getHexCrawlItem, this.genRegionRoadsItem, this.regenResourcesItem});
        this.genCoastItem = new MenuItem("Generate Coast");
        this.genCoastItem.setOnAction(t -> {
            this.generatorUI.handleGenCoastMI();
            Worldographer.pingUsage("http://www.worldographer.com/usage/menu_generateCityCoasts.txt");
        });
        this.genRiverItem = new MenuItem("Generate River");
        this.genRiverItem.setOnAction(t -> {
            this.generatorUI.handleGenRiverMI();
            Worldographer.pingUsage("http://www.worldographer.com/usage/menu_generateCityRivers.txt");
        });
        this.genMainRoadsItem = new MenuItem("Generate Main Roads");
        this.genMainRoadsItem.setOnAction(t -> {
            this.generatorUI.handleGenMainRoadsMI();
            Worldographer.pingUsage("http://www.worldographer.com/usage/menu_generateCityMainRoads.txt");
        });
        this.genWallItem = new MenuItem("Generate Wall");
        this.genWallItem.setOnAction(t -> this.generatorUI.handleGenWallMI());
        MenuItem genStreetsItem = new MenuItem("Generate Streets");
        genStreetsItem.setOnAction(t -> {
            this.generatorUI.handleGenStreetsMI();
            Worldographer.pingUsage("http://www.worldographer.com/usage/menu_generateCityStreets.txt");
        });
        this.genBuildingsItem = new MenuItem("Generate/Place Buildings");
        this.genBuildingsItem.setOnAction(t -> {
            WorldographerMenuBar worldographerMenuBar = this;
            this.generatorUI.handleGenBuildingsMI(this.worldographer, worldographerMenuBar.worldographer.getMapUI());
            Worldographer.pingUsage("http://www.worldographer.com/usage/menu_generateCityBuildings.txt");
        });
        this.genVegetationItem = new MenuItem("Generate Vegetation");
        this.genVegetationItem.setOnAction(t -> {
            WorldographerMenuBar worldographerMenuBar = this;
            this.generatorUI.handleGenVegetationMI(this.worldographer, worldographerMenuBar.worldographer.getMapUI());
            Worldographer.pingUsage("http://www.worldographer.com/usage/menu_generateCityVegetation.txt");
        });
        this.menuGenerateCity.getItems().addAll((Object[])new MenuItem[]{this.genCoastItem, this.genRiverItem, this.genMainRoadsItem, this.genWallItem, genStreetsItem, this.genBuildingsItem, this.genVegetationItem});
        MenuItem expandShrinkMapItem = new MenuItem("Expand/Shrink Columns/Rows");
        expandShrinkMapItem.setOnAction(t -> {
            if (UserPrefs.FULL) {
                if (this.mapUI().getMapData() == null) {
                    StandardDialog.showNoMapOpenDialog(this.worldographer.getPrimaryStage(), "Expand/Shrink Columns/Rows");
                    return;
                }
                new ExpandShrinkTilesDialog(this.worldographer.getPrimaryStage(), this.mapUI(), "Tiles");
            } else {
                StandardDialog.showDialog(this.worldographer.getPrimaryStage(), "Pro Feature", "Expanding/Shrinking the map columns/rows is only available if using a Pro version license.", "Sorry, some features are reserved for our Pro/paid version. \nIf you find the software useful, considering unlocking these special features and supporting \nthe many hours of work to create Worldographer with a Pro license. \nSee www.worldographer.com for details.\n", null, "");
            }
            Worldographer.pingUsage("http://www.worldographer.com/usage/menu_expandShrinkColsRows.txt");
        });
        MenuItem terrainWizardMapItem = new MenuItem("Terrain Wizard");
        terrainWizardMapItem.setOnAction(t -> {
            if (UserPrefs.FULL) {
                if (this.mapUI().getMapData() == null) {
                    StandardDialog.showNoMapOpenDialog(this.worldographer.getPrimaryStage(), "Terrain Wizard");
                    return;
                }
                Polygon selectedArea = null;
                if (this.mapUI().selectPts != null && this.mapUI().selectPts.size() > 0) {
                    selectedArea = new Polygon();
                    for (Point2D pt : this.mapUI().selectPts) {
                        selectedArea.getPoints().add((Object)pt.getX());
                        selectedArea.getPoints().add((Object)pt.getY());
                    }
                }
                MapLogic.nearestNeighborFill(this.mapUI(), this.mapUI().getController().getUndoRedoHandler(), this.mapUI().viewLevel, this.mapUI().getMapData().getTerrain(this.mapUI().viewLevel), this.worldographer.terrainToolbox.shuffleTerrainToggle.isSelected(), (Shape)selectedArea);
                this.mapUI().draw();
                Worldographer.pingUsage("http://www.worldographer.com/usage/menu_terrainWizard.txt");
            } else {
                StandardDialog.showDialog(this.worldographer.getPrimaryStage(), "Pro Feature", "Terrain Wizard is only available if using a Pro version license.", "Sorry, some features are reserved for our Pro/paid version. \nIf you find the software useful, considering unlocking these special features and supporting \nthe many hours of work to create Worldographer with a Pro license. \nSee www.worldographer.com for details.\n", null, "");
            }
        });
        this.switchTerrainIsoMenuItem = new MenuItem("Switch Terrain to Isometric Style");
        this.switchTerrainIsoMenuItem.setOnAction(t -> {
            if (UserPrefs.FULL) {
                if (this.mapUI().getMapData() == null) {
                    StandardDialog.showNoMapOpenDialog(this.worldographer.getPrimaryStage(), "Switch Terrain to Isometric Style");
                    return;
                }
                MapDataSetTerrain.setTerrainToIsometric(this.mapUI().getMapData().getTerrain(this.mapUI().viewLevel), this.mapUI().getMapData().getFeatures(), this.mapUI().viewLevel, this.mapUI().getMapData().getTileOrientation(), this.mapUI().getController().getUndoRedoHandler());
                this.mapUI().draw();
                Worldographer.pingUsage("http://www.worldographer.com/usage/menu_switchToIsometric.txt");
                this.worldographer.addStatus("Terrain switched to isometric.", false);
            } else {
                StandardDialog.showDialog(this.worldographer.getPrimaryStage(), "Pro Feature", "Switching Terrain is only available if using a Pro version license.", "Sorry, some features are reserved for our Pro/paid version. \nIf you find the software useful, considering unlocking these special features and supporting \nthe many hours of work to create Worldographer with a Pro license. \nSee www.worldographer.com for details.\n", null, "");
            }
        });
        this.switchTerrainClassicMenuItem = new MenuItem("Switch Terrain to Classic Style");
        this.switchTerrainClassicMenuItem.setOnAction(t -> {
            if (UserPrefs.FULL) {
                if (this.mapUI().getMapData() == null) {
                    StandardDialog.showNoMapOpenDialog(this.worldographer.getPrimaryStage(), "Switch Terrain to Classic Style");
                    return;
                }
                MapDataSetTerrain.setTerrainToClassic(this.mapUI().getMapData().getTerrain(this.mapUI().viewLevel), this.mapUI().getMapData().getFeatures(), this.mapUI().viewLevel, this.mapUI().getController().getUndoRedoHandler());
                this.mapUI().draw();
                Worldographer.pingUsage("http://www.worldographer.com/usage/menu_switchToClassic.txt");
                this.worldographer.addStatus("Terrain switched to classic.", false);
            } else {
                StandardDialog.showDialog(this.worldographer.getPrimaryStage(), "Pro Feature", "Switching Terrain is only available if using a Pro version license.", "Sorry, some features are reserved for our Pro/paid version. \nIf you find the software useful, considering unlocking these special features and supporting \nthe many hours of work to create Worldographer with a Pro license. \nSee www.worldographer.com for details.\n", null, "");
            }
        });
        this.switchIconsRealMenuItem = new MenuItem("Switch Icons to Realistic Style");
        this.switchIconsRealMenuItem.setOnAction(t -> {
            if (this.mapUI().getMapData() == null) {
                StandardDialog.showNoMapOpenDialog(this.worldographer.getPrimaryStage(), "Switch Icons to Realistic Style");
                return;
            }
            this.mapUI().setUseAlternateIcons(false);
            this.mapUI().draw();
            this.worldographer.addStatus("Map icons switched to realistic style.", false);
            Worldographer.pingUsage("http://www.worldographer.com/usage/menu_switchIconsToRealistic.txt");
        });
        this.switchIconsSimpleMenuItem = new MenuItem("Switch Icons to Simple Style");
        this.switchIconsSimpleMenuItem.setOnAction(t -> {
            if (this.mapUI().getMapData() == null) {
                StandardDialog.showNoMapOpenDialog(this.worldographer.getPrimaryStage(), "Switch Icons to Simple Style");
                return;
            }
            this.mapUI().setUseAlternateIcons(true);
            this.mapUI().draw();
            this.worldographer.addStatus("Map icons switched to simple style.", false);
            Worldographer.pingUsage("http://www.worldographer.com/usage/menu_switchIconsToSimple.txt");
        });
        MenuItem isoMountainsMenuItem = new MenuItem("Make Isometric Mountains Features");
        isoMountainsMenuItem.setOnAction(t -> {
            if (UserPrefs.FULL) {
                boolean changed;
                if (this.mapUI().getMapData() == null) {
                    StandardDialog.showNoMapOpenDialog(this.worldographer.getPrimaryStage(), "Isometric Mountains Features");
                    return;
                }
                UndoActionGroup uag = new UndoActionGroup();
                MapLayer mountainsLayer = this.mapUI().getMapData().getMapLayer("Mountains");
                if (mountainsLayer == null) {
                    int count;
                    mountainsLayer = new MapLayer("Mountains");
                    for (count = 0; count < this.mapUI().getMapData().getMapLayers().size() && !this.mapUI().getMapData().getMapLayers().get(count).getName().toLowerCase().contains("above terrain"); ++count) {
                    }
                    this.mapUI().getMapData().getMapLayers().add(count, mountainsLayer);
                    this.worldographer.addToLayersTableView(count, mountainsLayer);
                }
                if (changed = MapLogic.replaceMountains(uag, this.mapUI().viewLevel, this.mapUI().getMapData(), this.mapUI().getMapData().getTerrain(this.mapUI().getViewLevel()), mountainsLayer)) {
                    this.mapUI().getController().getUndoRedoHandler().push(uag);
                    this.mapUI().draw();
                    Worldographer.pingUsage("http://www.worldographer.com/usage/menu_switchMountainsToIsometric.txt");
                } else {
                    StandardDialog.showDialog(this.worldographer.getPrimaryStage(), "No Isometric Mountains", "No Isometric Mountains", "Your map was not changed because it had no \nisometric style mountain terrain.", null, "");
                }
            } else {
                StandardDialog.showDialog(this.worldographer.getPrimaryStage(), "Pro Feature", "Make Isometric Mountains into Features is only available if using a Pro version license.", "Sorry, some features are reserved for our Pro/paid version. \nIf you find the software useful, considering unlocking these special features and supporting \nthe many hours of work to create Worldographer with a Pro license. \nSee www.worldographer.com for details.\n", null, "");
            }
        });
        MenuItem convertUnderlayMenuItem = new MenuItem("Convert Underlay");
        convertUnderlayMenuItem.setOnAction(t -> {
            if (UserPrefs.FULL) {
                if (this.mapUI().getMapData() == null) {
                    StandardDialog.showNoMapOpenDialog(this.worldographer.getPrimaryStage(), "Convert Underlay");
                    return;
                }
                WorldographerMenuBar worldographerMenuBar = this;
                new ConvertUnderlayMapDialog().convertUnderlayMap(this.worldographer, worldographerMenuBar.worldographer.getMapUI(), this.worldographer.terrainToolbox);
                Worldographer.pingUsage("http://www.worldographer.com/usage/menu_convertUnderlay.txt");
            } else {
                StandardDialog.showDialog(this.worldographer.getPrimaryStage(), "Pro Feature", "Convert Underlay is only available if using a Pro version license.", "Sorry, some features are reserved for our Pro/paid version. \nIf you find the software useful, considering unlocking these special features and supporting \nthe many hours of work to create Worldographer with a Pro license. \nSee www.worldographer.com for details.\n", null, "");
            }
        });
        MenuItem mapkeyMI = new MenuItem("Setup Map Key");
        mapkeyMI.setOnAction(t -> {
            if (UserPrefs.FULL) {
                if (this.mapUI().getMapData() == null) {
                    StandardDialog.showNoMapOpenDialog(this.worldographer.getPrimaryStage(), "Setup Map Key");
                    return;
                }
                new ConfigureMapKeyFrame(this.worldographer, this.mapUI());
                Worldographer.pingUsage("http://www.worldographer.com/usage/menu_mapKey.txt");
            } else {
                StandardDialog.showDialog(this.worldographer.getPrimaryStage(), "Pro Feature", "The Map Key is only available if using a Pro version license.", "Sorry, some features are reserved for our Pro/paid version. \nIf you find the software useful, considering unlocking these special features and supporting \nthe many hours of work to create Worldographer with a Pro license. \nSee www.worldographer.com for details.\n", null, "");
            }
        });
        MenuItem breakUpWallsMI = new MenuItem("Break Up Walls");
        breakUpWallsMI.setOnAction(t -> {
            if (UserPrefs.FULL) {
                if (this.mapUI().getMapData() == null) {
                    StandardDialog.showNoMapOpenDialog(this.worldographer.getPrimaryStage(), "Break Up Walls");
                    return;
                }
                ArrayList<Rectangle> doorWindowBoundingBoxes = new ArrayList<Rectangle>();
                for (Feature f : this.mapUI().mapData.getFeatures()) {
                    double fh;
                    Point2D fpt = f.getLocation(ViewLevel.BATTLEMAT);
                    if (fpt == null || !f.getTypeName().toLowerCase().contains("door") && !f.getTypeName().toLowerCase().contains("window")) continue;
                    double fw = f.getScaleFallbackType() * 1.5;
                    if (fw < 5.0) {
                        fw = 10.0;
                    }
                    double fx = fpt.getX() - fw;
                    double htFactor = f.getScaleHt();
                    if (htFactor <= 0.0 && f.getType().getIconHeight() > 0.0) {
                        htFactor = f.getScale() * f.getType().getIconHeight() / f.getType().getIconSize();
                    }
                    if (htFactor <= 0.0) {
                        htFactor = f.getScaleHtFallbackType();
                    }
                    if (htFactor <= 0.0) {
                        htFactor = f.getScaleFallbackType();
                    }
                    if ((fh = htFactor * 1.5) < 10.0) {
                        fh = 10.0;
                    }
                    double fy = fpt.getY() - fh;
                    doorWindowBoundingBoxes.add(new Rectangle(fx, fy, fw, fw));
                }
                MapLogic.breakUpARoomOrWallForDoorsWindows(this.mapUI().mapData.getShapes(), doorWindowBoundingBoxes);
                this.mapUI().draw();
                Worldographer.pingUsage("http://www.worldographer.com/usage/menu_mapKey.txt");
            } else {
                StandardDialog.showDialog(this.worldographer.getPrimaryStage(), "Pro Feature", "The Map Key is only available if using a Pro version license.", "Sorry, some features are reserved for our Pro/paid version. \nIf you find the software useful, considering unlocking these special features and supporting \nthe many hours of work to create Worldographer with a Pro license. \nSee www.worldographer.com for details.\n", null, "");
            }
        });
        this.menuTools.getItems().addAll((Object[])new MenuItem[]{expandShrinkMapItem, breakUpWallsMI, terrainWizardMapItem, this.switchTerrainIsoMenuItem, this.switchTerrainClassicMenuItem, isoMountainsMenuItem, convertUnderlayMenuItem, mapkeyMI});
        new WorldographerConfigMenuBar().createMenuBarConfig(this.worldographer, menuConfigure, saveConfig, loadConfig);
        MenuItem setWorldBookFileItem = new MenuItem("Update World/Name Data File");
        setWorldBookFileItem.setOnAction(t -> {
            if (UserPrefs.FULL) {
                File f;
                File d = FileSaveLoad.getLastUsedDir();
                FileChooser fc = new FileChooser();
                FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("Properties (*.properties)", new String[]{"*.prop*"});
                fc.getExtensionFilters().add((Object)extFilter);
                if (d != null) {
                    fc.setInitialDirectory(d);
                }
                if ((f = fc.showOpenDialog((Window)this.worldographer.getPrimaryStage())) != null) {
                    try {
                        WorldAndNameData.loadProps(new FileInputStream(f));
                        WorldAndNameData.datafile = f.getPath() + File.separator + f.getName();
                    }
                    catch (FileNotFoundException e) {
                        StandardDialog.showException(this.worldographer.getPrimaryStage(), "Error", "Error", "There was an error while opening the file.", "The exception stacktrace was:", e);
                        e.printStackTrace();
                    }
                }
                Worldographer.pingUsage("http://www.worldographer.com/usage/menu_updateWorldNameDataFile.txt");
            } else {
                StandardDialog.showDialog(this.worldographer.getPrimaryStage(), "Pro Feature", "Updating the World/Name data file is a Pro version license.", "Sorry, some features are reserved for our Pro/paid version. \nIf you find the software useful, considering unlocking these special features and supporting \nthe many hours of work to create Worldographer with a Pro license. \nSee www.worldographer.com for details.\n", null, "");
            }
        });
        MenuItem worldInfoItem = new MenuItem("World Info");
        worldInfoItem.setOnAction(t -> {
            if (this.mapUI().getMapData() == null) {
                StandardDialog.showNoMapOpenDialog(this.worldographer.getPrimaryStage(), "World Info");
                return;
            }
            Stage stage = new Stage();
            WorldBook wb = new WorldBook(this.worldographer, this.mapUI().getMapData().getInformation());
            wb.start(stage);
            stage.show();
            Worldographer.pingUsage("https://www.worldographer.com/usage/menu_worldInfo.txt");
        });
        MenuItem terrainStatsItem = new MenuItem("Terrain Stats");
        terrainStatsItem.setOnAction(t -> {
            Terrain[][] ter = this.mapUI().getMapData().getTerrain(this.mapUI().getViewLevel());
            TreeMap<String, Integer> stats = new TreeMap<String, Integer>();
            for (Terrain[] terrains : ter) {
                for (Terrain terrain : terrains) {
                    Integer num = (Integer)stats.get(terrain.getTypeName());
                    if (num == null) {
                        num = 0;
                    }
                    Integer n = num;
                    num = num + 1;
                    stats.put(terrain.getTypeName(), num);
                }
            }
            double total = ter.length * ter[0].length;
            StringBuilder sb = new StringBuilder();
            for (String key : stats.keySet()) {
                Integer val = (Integer)stats.get(key);
                sb.append(key).append(":").append(val).append("=").append((int)((double)val.intValue() / total * 100.0 + 0.5)).append("%\n");
            }
            TextArea ta = new TextArea(sb.toString());
            ta.setEditable(false);
            StandardDialog.showContentDialog(this.worldographer.getPrimaryStage(), "Terrain Stats", "Your current map level has:", (Node)ta);
            Worldographer.pingUsage("http://www.worldographer.com/usage/menu_terrainStats.txt");
        });
        menuData.getItems().addAll((Object[])new MenuItem[]{setWorldBookFileItem, worldInfoItem, terrainStatsItem});
        MenuItem license = new MenuItem("License");
        license.setOnAction(t -> new LicenseDialog().viewLicense((Window)this.worldographer.getPrimaryStage()));
        MenuItem log = new MenuItem("Show Log");
        log.setOnAction(t -> {
            LogDialog logDialog = new LogDialog(this.worldographer, this.worldographer.WLogger.logTextArea, this.worldographer.WLogger.logMinorCheckBox);
            logDialog.show();
            this.worldographer.WLogger.addLogText("Log started. " + Instant.now().toString(), false);
        });
        MenuItem memory = new MenuItem("Show Memory Usage");
        memory.setOnAction(t -> {
            MemoryDialog memoryDialog = new MemoryDialog();
            memoryDialog.show(this.worldographer.getPrimaryStage());
        });
        MenuItem clearProperties = new MenuItem("Reset Properties");
        clearProperties.setOnAction(t -> {
            try {
                String key = UserPrefs.PREFS.get("lik2025", "");
                UserPrefs.PREFS.clear();
                UserPrefs.PREFS.put("lik2025", key);
                UserPrefs.PREFS.flush();
                Worldographer.getWorldographer().addStatus("Properties reset.");
            }
            catch (BackingStoreException e) {
                Worldographer.getWorldographer().addStatus("Properties failed to rest.");
                throw new RuntimeException(e);
            }
        });
        menuHelp.getItems().addAll((Object[])new MenuItem[]{license, log, memory, clearProperties});
        return box;
    }

    private void genChildMapAction() {
        if (UserPrefs.FULL) {
            ViewLevelBox.dontRecalculateViewLevels = true;
            if (this.mapUI().getMapData() == null) {
                StandardDialog.showNoMapOpenDialog(this.worldographer.getPrimaryStage(), "Generate Child Map As Separate Map");
                return;
            }
            if (this.mapUI().selectPts == null || this.mapUI().selectPts.size() < 2) {
                StandardDialog.showDialog(this.worldographer.getPrimaryStage(), "No Area Selected", "You must select an area of the map to use as the basis of the new map.", "To Select an area, choose 'Select Map Area' from the edit menu, then click one corner of the area you wish to use and drag to the opposite corner. The selected area should have a yellow tint.", null, "");
                return;
            }
            ViewLevel basevl = this.mapUI().getViewLevel();
            ViewLevel newvl = new MapLevelDialog(this.worldographer).showGenerateMapLevelDialog(basevl);
            MapData destinationMapData = new MapData(this.mapUI().getMapData(), basevl);
            double minX = Double.MAX_VALUE;
            double maxX = Double.MIN_VALUE;
            double minY = Double.MAX_VALUE;
            double maxY = Double.MIN_VALUE;
            for (Point2D ptx : this.mapUI().selectPts) {
                if (ptx.getX() < minX) {
                    minX = ptx.getX();
                }
                if (ptx.getX() > maxX) {
                    maxX = ptx.getX();
                }
                if (ptx.getY() < minY) {
                    minY = ptx.getY();
                }
                if (!(ptx.getY() > maxY)) continue;
                maxY = ptx.getY();
            }
            Point2D topLeft = new Point2D(minX, minY);
            Point2D bottomRight = new Point2D(maxX, maxY);
            Pair topLeftTile = this.mapUI().getTerrainFromModelPt(topLeft.getX(), topLeft.getY());
            if (this.mapUI().mapData.getTileOrientation() == HexOrientation.COLUMNS) {
                if ((Integer)topLeftTile.getKey() % 2 == 1) {
                    topLeftTile = new Pair((Object)((Integer)topLeftTile.getKey() - 1), (Object)((Integer)topLeftTile.getValue()));
                }
            } else if (this.mapUI().mapData.getTileOrientation() == HexOrientation.ROWS && (Integer)topLeftTile.getValue() % 2 == 1) {
                topLeftTile = new Pair((Object)((Integer)topLeftTile.getKey()), (Object)((Integer)topLeftTile.getValue() - 1));
            }
            Pair<Double, Double> topLeftCoords = MapData.getModelPtFromTerrain((Integer)topLeftTile.getKey(), (Integer)topLeftTile.getValue(), this.mapUI().getMapData().getTileOrientation());
            Pair<Integer, Integer> bottomRightTile = this.mapUI().getTerrainFromModelPt(bottomRight.getX(), bottomRight.getY());
            System.out.println("topLeft:" + String.valueOf(topLeftTile.getKey()) + "," + String.valueOf(topLeftTile.getValue()) + " bottomRight:" + String.valueOf(bottomRightTile.getKey()) + "," + String.valueOf(bottomRightTile.getValue()));
            Terrain[][] oldT = destinationMapData.getTerrain(basevl);
            Terrain[][] t = new Terrain[oldT.length - (Integer)topLeftTile.getKey() - (oldT.length - (Integer)bottomRightTile.getKey())][oldT[0].length - (Integer)topLeftTile.getValue() - (oldT[0].length - (Integer)bottomRightTile.getValue())];
            for (int i = 0; i < t.length; ++i) {
                for (int j = 0; j < t[i].length; ++j) {
                    t[i][j] = oldT[i + (Integer)topLeftTile.getKey()][j + (Integer)topLeftTile.getValue()];
                }
                destinationMapData.setTerrain(t, basevl);
            }
            Point2D diff = new Point2D(-((Double)topLeftCoords.getKey()).doubleValue() + 150.0, -((Double)topLeftCoords.getValue()).doubleValue() + 150.0);
            System.out.println("diff:" + diff.getX() + "," + diff.getY());
            Pair<Double, Double> wh = destinationMapData.getModelPtFromTerrain(t.length, t[0].length);
            MapLogic.adjustShapesLabelsFeatures(destinationMapData, basevl, diff, basevl, (Double)wh.getKey(), (Double)wh.getValue());
            new StartNewMapDialog().setupMapUI(destinationMapData, this.worldographer, false, basevl);
            int numhexes = new ChildMapNumTilesDialog().showChildMapNumTilesDialog(this.worldographer, (ViewLevel)((Object)this.worldographer.viewLevelBox.viewLevelCombo.getSelectionModel().getSelectedItem()), this.worldographer.viewLevelBox);
            if (numhexes > 0) {
                if (newvl == ViewLevel.KINGDOM && basevl == ViewLevel.PROVINCE || newvl == ViewLevel.PROVINCE && basevl == ViewLevel.KINGDOM) {
                    destinationMapData.getView().setProvinceFactor(numhexes);
                } else if (newvl == ViewLevel.KINGDOM && basevl == ViewLevel.CONTINENT || newvl == ViewLevel.CONTINENT && basevl == ViewLevel.KINGDOM) {
                    destinationMapData.getView().setKingdomFactor(numhexes);
                } else if (newvl == ViewLevel.WORLD && basevl == ViewLevel.CONTINENT || newvl == ViewLevel.CONTINENT && basevl == ViewLevel.WORLD) {
                    destinationMapData.getView().setContinentFactor(numhexes);
                }
                new CreateChildMapDialog(this.worldographer).createChildMap(basevl, newvl, numhexes, destinationMapData);
            }
        } else {
            StandardDialog.showDialog(this.worldographer.getPrimaryStage(), "Pro Feature", "Switching view levels is only available if using a Pro version license.", "Sorry, some features are reserved for our Pro/paid version. \nIf you find the software useful, considering unlocking these special features and supporting \nthe many hours of work to create Worldographer with a Pro license. \nSee www.worldographer.com for details.\n", null, "");
        }
    }

    private void generateRegionRoadsPrompt() {
        if (UserPrefs.FULL) {
            StyledDialog d = new StyledDialog(true, (Window)this.worldographer.getPrimaryStage(), "Generate Roads");
            d.setHeaderText("Choose the following options:");
            GridPane grid = new GridPane();
            grid.setHgap(10.0);
            grid.setVgap(10.0);
            grid.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
            CheckBox includeVillagesCheckBox = new CheckBox("Include Villages/Forts");
            includeVillagesCheckBox.setSelected(UserPrefs.PREFS.getBoolean("villagesRoadsCheckbox", false));
            grid.add((Node)includeVillagesCheckBox, 0, 0, 2, 1);
            CheckBox includeRuinsCheckBox = new CheckBox("Include Ruins");
            includeRuinsCheckBox.setSelected(UserPrefs.PREFS.getBoolean("ruinsRoadsCheckbox", false));
            grid.add((Node)includeRuinsCheckBox, 0, 1, 2, 1);
            Object[] lineOptions = new String[]{"Straight", "Fractal-ish", "Curves"};
            grid.add((Node)new Label("Line Type:"), 0, 2);
            ComboBox lineOptionsComboBox = new ComboBox(FXCollections.observableArrayList((Object[])lineOptions));
            lineOptionsComboBox.getSelectionModel().select((Object)UserPrefs.PREFS.get("roadStyle", "Fractal-ish"));
            grid.add((Node)lineOptionsComboBox, 1, 2);
            grid.add((Node)new Label("City/Town Road Color:"), 0, 3);
            ColorPicker colorPicker = new ColorPicker(Color.valueOf((String)UserPrefs.PREFS.get("roadsColor", "#1a1a1a")));
            grid.add((Node)colorPicker, 1, 3);
            grid.add((Node)new Label("Village/Ruins Road Color:"), 0, 4);
            ColorPicker colorPicker2 = new ColorPicker(Color.valueOf((String)UserPrefs.PREFS.get("roadsSecondaryColor", "#d2b48c")));
            grid.add((Node)colorPicker2, 1, 4);
            d.getDialogPane().setContent((Node)grid);
            ButtonType yes = new ButtonType("OK");
            ButtonType cancel = new ButtonType("Cancel");
            d.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{yes, cancel});
            Optional result = d.showAndWait();
            if (result.isPresent() && result.get() == yes) {
                UserPrefs.PREFS.put("roadsColor", ((Color)colorPicker.getValue()).toString());
                UserPrefs.PREFS.put("roadStyle", (String)lineOptionsComboBox.getValue());
                UserPrefs.PREFS.putBoolean("villagesRoadsCheckbox", includeVillagesCheckBox.isSelected());
                UserPrefs.PREFS.putBoolean("ruinsRoadsCheckbox", includeRuinsCheckBox.isSelected());
                UserPrefs.PREFS.put("roadsSecondaryColor", ((Color)colorPicker2.getValue()).toString());
                WorldographerMenuBar.flushPrefs();
                UndoActionGroup uag = new UndoActionGroup();
                GenerateEmpiresTask task = new GenerateEmpiresTask(false, false, false, false, true, this.worldographer, this.mapUI(), null, uag, "", false, 0, "", 0, null, false, this.mapUI().getMapData().getNotes(), 0, new Random(), 0.0, 0.0, includeVillagesCheckBox.isSelected(), includeRuinsCheckBox.isSelected(), "Curves".equals(lineOptionsComboBox.getSelectionModel().getSelectedItem()), "Fractal-ish".equals(lineOptionsComboBox.getSelectionModel().getSelectedItem()), (Color)colorPicker.getValue(), (Color)colorPicker2.getValue(), 0);
                task.setOnSucceeded(te -> {
                    this.worldographer.addStatus("Roads generated.", false);
                    this.mapUI().getController().getUndoRedoHandler().push(uag);
                    this.mapUI().draw();
                });
                new Thread((Runnable)((Object)task)).start();
            }
        } else {
            StandardDialog.showDialog(this.worldographer.getPrimaryStage(), "Pro Feature", "Generate Roads is only available if using a Pro version license.", "Sorry, some features are reserved for our Pro/paid version. \nIf you find the software useful, considering unlocking these special features and supporting \nthe many hours of work to create Worldographer with a Pro license. \nSee www.worldographer.com for details.\n", null, "");
        }
    }

    private void generateEmpiresAction() {
        if (UserPrefs.FULL) {
            if (this.mapUI().getMapData() == null) {
                StandardDialog.showNoMapOpenDialog(this.worldographer.getPrimaryStage(), "Generate Nations/Empires");
                return;
            }
            if (this.mapUI().viewLevel != ViewLevel.WORLD) {
                StandardDialog.showDialog(this.worldographer.getPrimaryStage(), "Wrong View Level", "The Nations/Empires Generator isn't optimized for non-World levels.", "Generating nations & empires uses distances based on typical world level hexes.\nPlease switch to that view level before generating nations & empires.\n", null, "");
                return;
            }
            List<Information> infos = this.mapUI().getMapData().getInformation();
            int numnations = 5;
            List<Information> nations = null;
            if (infos != null) {
                for (Information info : infos) {
                    if (!"Nations".equals(info.getName())) continue;
                    numnations = info.children.size();
                    nations = info.children;
                }
            }
            StyledDialog d = new StyledDialog(true, (Window)this.worldographer.getPrimaryStage(), "Generate Nations/Empires");
            d.setHeaderText("Choose the following options:");
            GridPane grid = new GridPane();
            grid.setHgap(10.0);
            grid.setVgap(10.0);
            grid.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
            grid.add((Node)new Label("# Nations/Empires:"), 0, 0);
            FocusSpinner empiresSpinner = new FocusSpinner(1, 400, numnations);
            empiresSpinner.setEditable(true);
            grid.add(empiresSpinner, 1, 0);
            grid.add((Node)new Label("Size limit (#settlements):"), 0, 1);
            Spinner sizeSpinner = new Spinner(3, 10000, UserPrefs.PREFS.getInt("empiresNum", 20));
            sizeSpinner.setEditable(true);
            grid.add((Node)sizeSpinner, 1, 1);
            CheckBox empiresOneColorCheckBox = new CheckBox("All one color?");
            empiresOneColorCheckBox.setSelected(UserPrefs.PREFS.getBoolean("empiresOneColorChecked", false));
            grid.add((Node)empiresOneColorCheckBox, 0, 2);
            ColorPicker colorpicker = new ColorPicker(Color.valueOf((String)UserPrefs.PREFS.get("empireColor", "#b80000")));
            grid.add((Node)colorpicker, 1, 2);
            CheckBox fillcheckbox = new CheckBox("Fill with translucency");
            fillcheckbox.setSelected(UserPrefs.PREFS.getBoolean("empiresTranslucencyChecked", false));
            grid.add((Node)fillcheckbox, 1, 3);
            grid.add((Node)new Label("Distance Between Towns/Forts/Etc. :"), 0, 4);
            Spinner distanceBetweenFeaturesSpinner = new Spinner(2, 10, UserPrefs.PREFS.getInt("empireFeatureDistances", 3));
            distanceBetweenFeaturesSpinner.setEditable(true);
            grid.add((Node)distanceBetweenFeaturesSpinner, 1, 4);
            d.getDialogPane().setContent((Node)grid);
            ButtonType yes = new ButtonType("OK");
            ButtonType cancel = new ButtonType("Cancel");
            d.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{yes, cancel});
            Optional result = d.showAndWait();
            if (result.isPresent() && result.get() == yes) {
                UserPrefs.PREFS.putInt("empiresNum", (Integer)sizeSpinner.getValue());
                UserPrefs.PREFS.putBoolean("empiresOneColorChecked", empiresOneColorCheckBox.isSelected());
                UserPrefs.PREFS.putBoolean("empiresTranslucencyChecked", fillcheckbox.isSelected());
                UserPrefs.PREFS.put("empireColor", ((Color)colorpicker.getValue()).toString());
                UserPrefs.PREFS.putInt("empireFeatureDistances", (Integer)distanceBetweenFeaturesSpinner.getValue());
                WorldographerMenuBar.flushPrefs();
                Worldographer.pingUsage("http://www.worldographer.com/usage/menu_generateEmpires.txt");
                UndoActionGroup uag = new UndoActionGroup();
                GenerateEmpiresTask task = new GenerateEmpiresTask(this.worldographer, this.mapUI(), nations, uag, (Integer)empiresSpinner.getValue(), empiresOneColorCheckBox.isSelected() ? (Color)colorpicker.getValue() : null, fillcheckbox.isSelected(), this.mapUI().getMapData().getNotes(), (Integer)sizeSpinner.getValue(), (Integer)distanceBetweenFeaturesSpinner.getValue());
                task.setOnSucceeded(te -> {
                    this.worldographer.addStatus("Empires generated.", false);
                    this.mapUI().getController().getUndoRedoHandler().push(uag);
                    this.mapUI().draw();
                });
                new Thread((Runnable)((Object)task)).start();
            }
        } else {
            StandardDialog.showDialog(this.worldographer.getPrimaryStage(), "Pro Feature", "Generate Empires is only available if using a Pro version license.", "Sorry, some features are reserved for our Pro/paid version. \nIf you find the software useful, considering unlocking these special features and supporting \nthe many hours of work to create Worldographer with a Pro license. \nSee www.worldographer.com for details.\n", null, "");
        }
    }

    private void generateHexCrawlAction() {
        if (UserPrefs.FULL) {
            StyledDialog d = new StyledDialog(true, (Window)this.worldographer.getPrimaryStage(), "Generate Hex Crawl Locations");
            d.setHeaderText("Choose the following options:");
            GridPane grid = new GridPane();
            grid.setHgap(10.0);
            grid.setVgap(10.0);
            grid.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
            grid.add((Node)new Label("Location Chance on Land:"), 0, 0);
            FocusSpinner landSpinner = new FocusSpinner(0, 100, UserPrefs.PREFS.getInt("hexCrawlLandChance", 15));
            landSpinner.setEditable(true);
            grid.add(landSpinner, 1, 0);
            grid.add((Node)new Label("Location Chance on Water:"), 0, 1);
            FocusSpinner waterSpinner = new FocusSpinner(0, 100, UserPrefs.PREFS.getInt("hexCrawlWaterChance", 2));
            waterSpinner.setEditable(true);
            grid.add(waterSpinner, 1, 1);
            d.getDialogPane().setContent((Node)grid);
            ButtonType yes = new ButtonType("OK");
            ButtonType cancel = new ButtonType("Cancel");
            d.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{yes, cancel});
            Optional result = d.showAndWait();
            if (result.isPresent() && result.get() == yes) {
                UserPrefs.PREFS.putInt("hexCrawlLandChance", (Integer)landSpinner.getValue());
                UserPrefs.PREFS.putInt("hexCrawlWaterChance", (Integer)waterSpinner.getValue());
                WorldographerMenuBar.flushPrefs();
                UndoActionGroup uag = new UndoActionGroup();
                MapLogic.genHexCrawlLocations(this.worldographer, null, this.mapUI(), uag, new Random(), (double)((Integer)landSpinner.getValue()).intValue() / 100.0, (double)((Integer)waterSpinner.getValue()).intValue() / 100.0);
                this.worldographer.addStatus("Hex crawls generated.", false);
                this.mapUI().getController().getUndoRedoHandler().push(uag);
                this.mapUI().draw();
            }
        } else {
            StandardDialog.showDialog(this.worldographer.getPrimaryStage(), "Pro Feature", "Generate Hex Crawl Locations is only available if using a Pro version license.", "Sorry, some features are reserved for our Pro/paid version. \nIf you find the software useful, considering unlocking these special features and supporting \nthe many hours of work to create Worldographer with a Pro license. \nSee www.worldographer.com for details.\n", null, "");
        }
    }

    private static void flushPrefs() {
        try {
            UserPrefs.PREFS.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void deleteCoastsAction() {
        if (this.mapUI().getMapData() == null) {
            StandardDialog.showNoMapOpenDialog(this.worldographer.getPrimaryStage(), "Delete Coasts");
            return;
        }
        if (this.mapUI().viewLevel != ViewLevel.WORLD) {
            StyledDialog d2 = new StyledDialog(true, (Window)this.worldographer.getPrimaryStage(), "Delete Coasts");
            d2.setHeaderText("Delete all shapes with the tag \"coastline\" and features with the tag \"coast\"?");
            d2.setContentText("Are you sure you wish to delete all coastlines?");
            ButtonType ok1 = new ButtonType("OK");
            ButtonType cancel = new ButtonType("Cancel");
            d2.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ok1, cancel});
            Optional result = d2.showAndWait();
            if (result.isPresent() && result.get() == cancel) {
                return;
            }
        }
        UndoActionGroup uag = new UndoActionGroup();
        Iterator<MapShape> iter = this.mapUI().getMapData().getShapes().iterator();
        while (iter.hasNext()) {
            MapShape ms = iter.next();
            if (!ms.getTags().toLowerCase().contains("coastline")) continue;
            iter.remove();
            uag.addAction(new UndoAction(UndoAction.Action.REMOVE, UndoAction.Thing.MAP_SHAPE, ms, null, ms, null, null, null));
        }
        Iterator<Feature> fiter = this.mapUI().getMapData().getFeatures().iterator();
        while (fiter.hasNext()) {
            Feature f = fiter.next();
            if (!f.getTags().toLowerCase().contains("coast")) continue;
            fiter.remove();
            uag.addAction(new UndoAction(UndoAction.Action.REMOVE, UndoAction.Thing.FEATURE, f, null, f, null, null, null));
        }
        this.mapUI().getController().getUndoRedoHandler().push(uag);
        this.mapUI().draw();
        this.worldographer.addStatus("Coasts deleted.", false);
    }

    private void genCoastsAction() {
        if (UserPrefs.FULL) {
            if (this.mapUI().getMapData() == null) {
                StandardDialog.showNoMapOpenDialog(this.worldographer.getPrimaryStage(), "Generate Coasts");
                return;
            }
            StyledDialog d2 = new StyledDialog(true, (Window)this.worldographer.getPrimaryStage(), "Generate Coasts");
            d2.setHeaderText("Change Coastal Terrain to Sea.");
            d2.setContentText("Do you wish to also change coastal waters from ocean to sea?\nNote: If you plan to use map levels (world/continent/etc.), polygons are best.");
            CheckBox seaCB = new CheckBox("Convert adjacent water hexes to sea?");
            seaCB.setSelected(UserPrefs.PREFS.getBoolean("coastsConvertOceans", false));
            Object[] options = new String[]{"Isometric coast features (adds water)", "Classic coasts features (adds water)", "Colored coast shapes (adds land)"};
            boolean haveRingLordWaterEdges = false;
            for (String fname : Feature.featureTypes.keySet()) {
                if (!fname.toLowerCase().contains("water edge") || fname.toLowerCase().contains("blue")) continue;
                haveRingLordWaterEdges = true;
                break;
            }
            if (haveRingLordWaterEdges) {
                String[] opts2 = new String[]{"Isometric coast features (adds water)", "Classic coasts features (adds water)", "Ring Lord coasts features (adds water)", "Colored coast shapes (adds land)"};
                options = opts2;
            }
            ComboBox coastsCombo = new ComboBox(FXCollections.observableArrayList((Object[])options));
            String coast = UserPrefs.PREFS.get("coastType", "Colored coast shapes (adds land)");
            if (coast.contains("shapess")) {
                coast = "Colored coast shapes (adds land)";
            }
            coastsCombo.getSelectionModel().select((Object)coast);
            VBox vbox = new VBox();
            vbox.getChildren().add((Object)seaCB);
            vbox.getChildren().add((Object)coastsCombo);
            d2.getDialogPane().setContent((Node)vbox);
            ButtonType ok1 = new ButtonType("OK");
            ButtonType cancel = new ButtonType("Cancel");
            d2.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ok1, cancel});
            Optional result = d2.showAndWait();
            if (result.isPresent() && result.get() == ok1) {
                UserPrefs.PREFS.put("coastType", (String)coastsCombo.getValue());
                UserPrefs.PREFS.putBoolean("coastsConvertOceans", seaCB.isSelected());
                WorldographerMenuBar.flushPrefs();
                UndoActionGroup uag = new UndoActionGroup();
                GenerateEmpiresTask task = new GenerateEmpiresTask(true, false, false, false, false, this.worldographer, this.mapUI(), null, uag, (String)coastsCombo.getValue(), seaCB.isSelected(), 0, "", 0, null, false, this.mapUI().getMapData().getNotes(), 0, new Random(), 0.0, 0.0, false, false, false, false, null, null, 0);
                task.setOnSucceeded(te -> {
                    this.mapUI().getController().getUndoRedoHandler().push(uag);
                    this.mapUI().draw();
                    this.worldographer.addStatus("Coastline generated.", false);
                });
                new Thread((Runnable)((Object)task)).start();
            }
            Worldographer.pingUsage("http://www.worldographer.com/usage/menu_generateCoasts.txt");
        } else {
            StandardDialog.showDialog(this.worldographer.getPrimaryStage(), "Pro Feature", "Generate Coasts is only available if using a Pro version license.", "Sorry, some features are reserved for our Pro/paid version. \nIf you find the software useful, considering unlocking these special features and supporting \nthe many hours of work to create Worldographer with a Pro license. \nSee www.worldographer.com for details.\n", null, "");
        }
    }

    private void deleteMapLevelAction() {
        if (UserPrefs.FULL) {
            if (this.mapUI().getMapData() == null) {
                StandardDialog.showNoMapOpenDialog(this.worldographer.getPrimaryStage(), "Delete Map Level");
                return;
            }
            ViewLevel vl = new MapLevelDialog(this.worldographer).showDeleteMapLevelDialog();
            if (vl != null) {
                if (vl == this.mapUI().getViewLevel()) {
                    if (vl == ViewLevel.KINGDOM) {
                        if (this.mapUI().getMapData().getTerrain(ViewLevel.CONTINENT) != null) {
                            this.worldographer.viewLevelBox.viewLevelCombo.getSelectionModel().select((Object)ViewLevel.CONTINENT);
                        } else if (this.mapUI().getMapData().getTerrain(ViewLevel.WORLD) != null) {
                            this.worldographer.viewLevelBox.viewLevelCombo.getSelectionModel().select((Object)ViewLevel.WORLD);
                        }
                    } else if (vl == ViewLevel.CONTINENT) {
                        if (this.mapUI().getMapData().getTerrain(ViewLevel.KINGDOM) != null) {
                            this.worldographer.viewLevelBox.viewLevelCombo.getSelectionModel().select((Object)ViewLevel.KINGDOM);
                        } else if (this.mapUI().getMapData().getTerrain(ViewLevel.WORLD) != null) {
                            this.worldographer.viewLevelBox.viewLevelCombo.getSelectionModel().select((Object)ViewLevel.WORLD);
                        }
                    } else if (vl == ViewLevel.WORLD) {
                        if (this.mapUI().getMapData().getTerrain(ViewLevel.CONTINENT) != null) {
                            this.worldographer.viewLevelBox.viewLevelCombo.getSelectionModel().select((Object)ViewLevel.CONTINENT);
                        } else if (this.mapUI().getMapData().getTerrain(ViewLevel.KINGDOM) != null) {
                            this.worldographer.viewLevelBox.viewLevelCombo.getSelectionModel().select((Object)ViewLevel.KINGDOM);
                        }
                    }
                }
                this.mapUI().getMapData().setTerrain(null, vl);
            }
        } else {
            StandardDialog.showDialog(this.worldographer.getPrimaryStage(), "Pro Feature", "Multiple view levels is only available if using a Pro version license.", "Sorry, some features are reserved for our Pro/paid version. \nIf you find the software useful, considering unlocking these special features and supporting \nthe many hours of work to create Worldographer with a Pro license. \nSee www.worldographer.com for details.\n", null, "");
        }
    }

    private void regenrateResourcesDialog() {
        if (this.mapUI().viewLevel == ViewLevel.WORLD || this.mapUI().viewLevel == ViewLevel.CONTINENT || this.mapUI().viewLevel == ViewLevel.KINGDOM || this.mapUI().viewLevel == ViewLevel.PROVINCE) {
            StyledDialog d2 = new StyledDialog(true, (Window)this.worldographer.getPrimaryStage(), "Regenerate Resources");
            d2.setHeaderText("Regenerate Animal, Brick, Lumber, etc. Values");
            d2.setContentText("This will regenerate the values for your maps various resources.  Do you wish to continue?");
            ButtonType ok1 = new ButtonType("OK");
            ButtonType cancel = new ButtonType("Cancel");
            d2.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ok1, cancel});
            Optional result = d2.showAndWait();
            if (result.isPresent() && result.get() == cancel) {
                return;
            }
            this.mapUI().getController().regenerateResources(this.mapUI().viewLevel);
            this.mapUI().draw();
            this.worldographer.addStatus("The resources of this map level were regenerated.", false);
        }
    }

    private void generateMapLevelAction() {
        if (UserPrefs.FULL) {
            ViewLevelBox.dontRecalculateViewLevels = true;
            if (this.mapUI().getMapData() == null) {
                StandardDialog.showNoMapOpenDialog(this.worldographer.getPrimaryStage(), "(Re)Generate Map Level");
                return;
            }
            ViewLevel basevl = new MapLevelDialog(this.worldographer).showGenerateMapLevelDialog(null);
            ViewLevel newvl = new MapLevelDialog(this.worldographer).showGenerateMapLevelDialog(basevl);
            int numhexes = new ChildMapNumTilesDialog().showChildMapNumTilesDialog(this.worldographer, (ViewLevel)((Object)this.worldographer.viewLevelBox.viewLevelCombo.getSelectionModel().getSelectedItem()), this.worldographer.viewLevelBox);
            if (numhexes == 0) {
                ViewLevel vl = ViewLevel.KINGDOM;
                if (this.mapUI().getViewLevel() == ViewLevel.WORLD) {
                    vl = ViewLevel.CONTINENT;
                }
                this.mapUI().getMapData().setTerrain(null, vl);
            } else if (numhexes > 0) {
                if (newvl == ViewLevel.KINGDOM && basevl == ViewLevel.PROVINCE || newvl == ViewLevel.PROVINCE && basevl == ViewLevel.KINGDOM) {
                    this.mapUI().getMapData().getView().setProvinceFactor(numhexes);
                } else if (newvl == ViewLevel.KINGDOM && basevl == ViewLevel.CONTINENT || newvl == ViewLevel.CONTINENT && basevl == ViewLevel.KINGDOM) {
                    this.mapUI().getMapData().getView().setKingdomFactor(numhexes);
                } else if (newvl == ViewLevel.WORLD && basevl == ViewLevel.CONTINENT || newvl == ViewLevel.CONTINENT && basevl == ViewLevel.WORLD) {
                    this.mapUI().getMapData().getView().setContinentFactor(numhexes);
                }
                new CreateChildMapDialog(this.worldographer).createChildMap(basevl, newvl, numhexes, this.mapUI().getMapData());
            }
        } else {
            StandardDialog.showDialog(this.worldographer.getPrimaryStage(), "Pro Feature", "Switching view levels is only available if using a Pro version license.", "Sorry, some features are reserved for our Pro/paid version. \nIf you find the software useful, considering unlocking these special features and supporting \nthe many hours of work to create Worldographer with a Pro license. \nSee www.worldographer.com for details.\n", null, "");
        }
    }

    private void deleteItemAction() {
        WorldographerMenuBar worldographerMenuBar = this;
        if (worldographerMenuBar.worldographer.getMapUI().getMapData() == null) {
            return;
        }
        WorldographerMenuBar worldographerMenuBar2 = this;
        if (worldographerMenuBar2.worldographer.getMapUI().selectPts.size() > 2) {
            this.worldographer.copyDataHolder = new CopyDataHolder(this.worldographer, this.mapUI().selectPts, this.mapUI().viewLevel, this.mapUI(), this.mapUI().getController().getUndoRedoHandler(), this.excludeTerrainMI.isSelected(), this.excludeExtraTerrainMI.isSelected(), this.excludeFeaturesMI.isSelected(), this.excludeShapesMI.isSelected(), this.excludeLabelsMI.isSelected());
            this.worldographer.copyDataHolder.copyCutData(this.mapUI().getMapData(), this.mapUI().getCurrentObjects(), true, true);
        }
        this.worldographer.featuresToolbox.deleteFeature();
        this.worldographer.labelsToolbox.deleteLabel();
        for (MapObject mo : this.mapUI().getCurrentObjects()) {
            if (!(mo instanceof MapShape)) continue;
            this.mapUI().getController().deleteShape((MapShape)mo, null);
            this.mapUI().hoverObject = null;
            this.mapUI().draw();
        }
        for (MapObject mo : this.mapUI().getCurrentObjects()) {
            if (!(mo instanceof MapShape)) continue;
            MapShape ms = (MapShape)mo;
            this.mapUI().getController().deleteShape(ms, null);
            this.mapUI().draw();
        }
        this.mapUI().draw();
    }

    private void pasteItemAction() {
        if (UserPrefs.FULL) {
            WorldographerMenuBar worldographerMenuBar = this;
            if (worldographerMenuBar.worldographer.getMapUI().getMapData() == null) {
                return;
            }
            WorldographerMenuBar worldographerMenuBar2 = this;
            if (worldographerMenuBar2.worldographer.getMapUI().selectPts.size() == 0) {
                WorldographerMenuBar worldographerMenuBar3 = this;
                Point2D modelXY = worldographerMenuBar3.worldographer.getMapUI().getModelCoordsFromScreenPt(this.worldographer.mouseLocation.getX(), this.worldographer.mouseLocation.getY());
                double x = modelXY.getX();
                double y = modelXY.getY() - 600.0;
                WorldographerMenuBar worldographerMenuBar4 = this;
                WorldographerMenuBar worldographerMenuBar5 = this;
                this.worldographer.copyDataHolder.pasteData(worldographerMenuBar4.worldographer.getMapUI(), new Point2D(x, y), worldographerMenuBar5.worldographer.getMapUI().viewLevel, this.alignPasteWithGridMI.isSelected());
            } else {
                double minx = Double.MAX_VALUE;
                double miny = Double.MAX_VALUE;
                double maxx = Double.MIN_VALUE;
                double maxy = Double.MIN_VALUE;
                WorldographerMenuBar worldographerMenuBar6 = this;
                for (Point2D pt : worldographerMenuBar6.worldographer.getMapUI().selectPts) {
                    if (pt.getX() < minx) {
                        minx = pt.getX();
                    }
                    if (pt.getY() < miny) {
                        miny = pt.getY();
                    }
                    if (pt.getX() > maxx) {
                        maxx = pt.getX();
                    }
                    if (!(pt.getY() > miny)) continue;
                    maxy = pt.getY();
                }
                double x = minx + (maxx - minx) / 2.0;
                double y = miny + (maxy - miny) / 2.0;
                WorldographerMenuBar worldographerMenuBar7 = this;
                WorldographerMenuBar worldographerMenuBar8 = this;
                this.worldographer.copyDataHolder.pasteData(worldographerMenuBar7.worldographer.getMapUI(), new Point2D(x, y), worldographerMenuBar8.worldographer.getMapUI().viewLevel, this.alignPasteWithGridMI.isSelected());
            }
            WorldographerMenuBar worldographerMenuBar9 = this;
            worldographerMenuBar9.worldographer.getMapUI().draw();
        } else {
            StandardDialog.showDialog(this.worldographer.getPrimaryStage(), "Pro Feature", "Cut/Copy/Paste is only available if using a Pro version license.", "Sorry, some features are reserved for our Pro/paid version. \nIf you find the software useful, considering unlocking these special features and supporting \nthe many hours of work to create Worldographer with a Pro license. \nSee www.worldographer.com for details.\n", null, "");
        }
    }

    private void createMenuBarFile(Menu menuFile) {
        MenuItem newMap = new MenuItem("New World/Kingdom Map");
        newMap.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.N, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN}));
        newMap.setOnAction(t -> {
            Stage stage = new Stage();
            SetupWorldRegionScreen ss = new SetupWorldRegionScreen(this.worldographer);
            ss.start(stage);
            stage.show();
        });
        MenuItem newCosmicMap = new MenuItem("New Sub/Sector Cosmic Map");
        newCosmicMap.setOnAction(t -> {
            Stage stage = new Stage();
            SetupCosmicScreen ss = new SetupCosmicScreen(this.worldographer);
            ss.start(stage);
            stage.show();
        });
        MenuItem newCityMap = new MenuItem("New City/Town/Village Map");
        newCityMap.setOnAction(t -> {
            Stage stage = new Stage();
            SetupCityScreen ss = new SetupCityScreen(this.worldographer);
            ss.start(stage);
            stage.show();
        });
        MenuItem newBattlematMap = new MenuItem("New Battlemat/Dungeon Map");
        newBattlematMap.setOnAction(t -> {
            Stage stage = new Stage();
            SetupBattlematScreen ss = new SetupBattlematScreen(this.worldographer);
            ss.start(stage);
            stage.show();
        });
        MenuItem openMap = new MenuItem("Open");
        openMap.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.O, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN}));
        openMap.setOnAction(t -> {
            File f;
            FileChooser fc = new FileChooser();
            FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("Worldographer XML (*.wxx)", new String[]{"*.wxx"});
            fc.getExtensionFilters().add((Object)extFilter);
            File d = FileSaveLoad.getLastUsedDir();
            if (d != null) {
                fc.setInitialDirectory(d);
            }
            if ((f = fc.showOpenDialog((Window)this.worldographer.getPrimaryStage())) != null) {
                new FileSaveLoad(this.worldographer).loadFile(f, false, Integer.MAX_VALUE, Integer.MAX_VALUE, 0, false);
            }
        });
        this.openRecentMap = new Menu("Open Recent");
        this.updateRecentMapsMenu();
        MenuItem openIntoMap = new MenuItem("Open Into This Map...");
        openIntoMap.setOnAction(t -> {
            StyledDialog d2 = new StyledDialog(true, (Window)this.worldographer.getPrimaryStage(), "Open Into Map");
            d2.setHeaderText("Open Into Map");
            d2.setContentText("Loading map...");
            GridPane gp = new GridPane();
            gp.setHgap(5.0);
            gp.setVgap(5.0);
            gp.add((Node)new Label("Note: You'll probably want to expand your map if you haven't yet.\nGo to the tools menu and select \"Expand/Shrink Columns/Rows\"."), 0, 0, 4, 1);
            gp.add((Node)new Label("Anchor upper left corner of new map at which terrain tile?"), 0, 1, 4, 1);
            gp.add((Node)new Label("Upper Left X:"), 0, 2);
            FocusSpinner xspinner = new FocusSpinner(0, 20000, 50);
            xspinner.setEditable(true);
            xspinner.setMaxWidth(100.0);
            gp.add(xspinner, 1, 2);
            gp.add((Node)new Label("Y:"), 2, 2);
            FocusSpinner yspinner = new FocusSpinner(0, 20000, 50);
            yspinner.setEditable(true);
            yspinner.setMaxWidth(100.0);
            gp.add(yspinner, 3, 2);
            gp.add((Node)new Label("Rotate (degrees):"), 0, 3);
            Object[] r = new Integer[]{0, 90, 180, 270};
            ComboBox rotateCombo = new ComboBox(FXCollections.observableArrayList((Object[])r));
            rotateCombo.getSelectionModel().select(0);
            gp.add((Node)rotateCombo, 1, 3);
            CheckBox doubleSizeCB = new CheckBox("Double source map size (make a 10x10 map 20x20)");
            gp.add((Node)doubleSizeCB, 2, 3, 3, 1);
            d2.getDialogPane().setContent((Node)gp);
            ButtonType ok1 = new ButtonType("OK");
            ButtonType cancel = new ButtonType("Cancel");
            d2.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ok1, cancel});
            Optional result = d2.showAndWait();
            if (result.isPresent() && result.get() == ok1) {
                File f;
                FileChooser fc = new FileChooser();
                FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("Worldographer XML (*.wxx)", new String[]{"*.wxx"});
                fc.getExtensionFilters().add((Object)extFilter);
                File d = FileSaveLoad.getLastUsedDir();
                if (d != null) {
                    fc.setInitialDirectory(d);
                }
                if ((f = fc.showOpenDialog((Window)this.worldographer.getPrimaryStage())) != null) {
                    new FileSaveLoad(this.worldographer).loadFile(f, false, (Integer)xspinner.getValue(), (Integer)yspinner.getValue(), (Integer)rotateCombo.getSelectionModel().getSelectedItem(), doubleSizeCB.isSelected());
                }
            }
        });
        MenuItem dungeonGeomorphMap = new MenuItem("Make Dungeon Geomorph Map...");
        dungeonGeomorphMap.setOnAction(t -> {
            StyledDialog d2 = new StyledDialog(true, (Window)this.worldographer.getPrimaryStage(), "Make Dungeon Geomorph Map");
            d2.setHeaderText("Make Dungeon Geomorph Map");
            d2.setContentText("Loading map...");
            GridPane gp = new GridPane();
            gp.setHgap(5.0);
            gp.setVgap(5.0);
            gp.add((Node)new Label("Note: This creates a new map by loading in several maps combined into one large map.\nIt works best if you have a folder with many square dungeon/cave maps of the same size."), 0, 0, 4, 1);
            gp.add((Node)new Label("# tiles across per map:"), 0, 2);
            FocusSpinner xtilesspinner = new FocusSpinner(0, 20000, 20);
            xtilesspinner.setMaxWidth(100.0);
            xtilesspinner.setEditable(true);
            gp.add(xtilesspinner, 1, 2);
            gp.add((Node)new Label("# tiles high per map:"), 2, 2);
            FocusSpinner ytilesspinner = new FocusSpinner(0, 20000, 20);
            ytilesspinner.setMaxWidth(100.0);
            ytilesspinner.setEditable(true);
            gp.add(ytilesspinner, 3, 2);
            gp.add((Node)new Label("# maps across:"), 0, 3);
            FocusSpinner xmapsspinner = new FocusSpinner(0, 20000, 5);
            xmapsspinner.setMaxWidth(100.0);
            xmapsspinner.setEditable(true);
            gp.add(xmapsspinner, 1, 3);
            gp.add((Node)new Label("# maps high:"), 2, 3);
            FocusSpinner ymapsspinner = new FocusSpinner(0, 20000, 4);
            ymapsspinner.setMaxWidth(100.0);
            ymapsspinner.setEditable(true);
            gp.add(ymapsspinner, 3, 3);
            gp.add((Node)new Label("# maps high:"), 2, 3);
            CheckBox doubleSizeCB = new CheckBox("Double source map size (make a 10x10 map 20x20)");
            gp.add((Node)doubleSizeCB, 0, 4, 4, 1);
            d2.getDialogPane().setContent((Node)gp);
            ButtonType ok1 = new ButtonType("OK");
            ButtonType cancel = new ButtonType("Cancel");
            d2.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ok1, cancel});
            Optional result = d2.showAndWait();
            if (result.isPresent() && result.get() == ok1) {
                FileChooser dc = new FileChooser();
                FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("Worldographer XML (*.wxx)", new String[]{"*.wxx"});
                dc.getExtensionFilters().add((Object)extFilter);
                File d = FileSaveLoad.getLastUsedDir();
                if (d != null) {
                    dc.setInitialDirectory(d);
                }
                List files = dc.showOpenMultipleDialog((Window)this.worldographer.getPrimaryStage());
                ArrayList<File> worldographerfiles = new ArrayList<File>();
                if (files == null) {
                    return;
                }
                for (File f : files) {
                    if (!f.getName().toLowerCase().endsWith(".wxx")) continue;
                    worldographerfiles.add(f);
                }
                if (worldographerfiles.size() > 0) {
                    Terrain[][] tx = new Terrain[(Integer)xtilesspinner.getValue() * (Integer)xmapsspinner.getValue()][(Integer)ytilesspinner.getValue() * (Integer)ymapsspinner.getValue()];
                    MapDataSetup setup = new MapDataSetup();
                    for (int y = 0; y < tx[0].length; ++y) {
                        for (int x = 0; x < tx.length; ++x) {
                            tx[x][y] = new Terrain("Empty", true);
                        }
                    }
                    setup.type = MapData.Type.BATTLEMAT;
                    setup.setTerrainByViewLevel(ViewLevel.BATTLEMAT, tx);
                    setup.hexWidth = 50.0;
                    setup.hexHeight = 50.0;
                    setup.hexOrientation = HexOrientation.SQUARE;
                    setup.mapProjection = MapProjection.FLAT;
                    setup.generateOneTerrain = true;
                    setup.solidTerrain = "Blank";
                    setup.battleMatTerrain = tx;
                    new StartNewMapDialog().startNewMap(setup, this.worldographer);
                    for (int x = 0; x < (Integer)xmapsspinner.getValue(); ++x) {
                        for (int y = 0; y < (Integer)ymapsspinner.getValue(); ++y) {
                            File f = (File)worldographerfiles.get((int)(Math.random() * (double)worldographerfiles.size()));
                            new FileSaveLoad(this.worldographer).loadFile(f, false, x * (Integer)xtilesspinner.getValue(), y * (Integer)ytilesspinner.getValue(), (int)(Math.random() * 4.0) * 90, doubleSizeCB.isSelected());
                        }
                    }
                }
            }
        });
        MenuItem saveMap = new MenuItem("Save");
        saveMap.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.S, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
        saveMap.setOnAction(t -> {
            File f = this.mapUI().getMapData().getFile();
            if (f != null) {
                new FileSaveLoad(this.worldographer).saveFile(f, false, true, false);
            } else {
                new FileSaveLoad(this.worldographer).saveAsFile(false);
            }
        });
        MenuItem saveAsMap = new MenuItem("Save As");
        saveMap.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.S, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN, KeyCombination.SHIFT_DOWN}));
        saveAsMap.setOnAction(t -> new FileSaveLoad(this.worldographer).saveAsFile(false));
        MenuItem importMap = new MenuItem("Import Hexographer 1 Map");
        importMap.setOnAction(t -> {
            StyledDialog d2 = new StyledDialog(true, (Window)this.worldographer.getPrimaryStage(), "Import Hexographer 1 Map");
            d2.setHeaderText("Import Hexographer 1 Map");
            d2.setContentText("Loading map...");
            HBox box = new HBox();
            box.getChildren().add((Object)new Label("Import map as view level: "));
            ComboBox viewLevelCombo = new ComboBox(FXCollections.observableArrayList((Object[])this.worldographer.viewLevelBox.levels));
            viewLevelCombo.getSelectionModel().select((Object)ViewLevel.WORLD);
            box.getChildren().add((Object)viewLevelCombo);
            d2.getDialogPane().setContent((Node)box);
            ButtonType ok1 = new ButtonType("OK");
            ButtonType cancel = new ButtonType("Cancel");
            d2.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ok1, cancel});
            Optional result = d2.showAndWait();
            if (result.isPresent() && result.get() == ok1) {
                File f;
                File d = FileSaveLoad.getLastUsedDir();
                FileChooser fc = new FileChooser();
                FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("Hexographer 1 (*.hxm)", new String[]{"*.hxm"});
                fc.getExtensionFilters().add((Object)extFilter);
                if (d != null) {
                    fc.setInitialDirectory(d);
                }
                if ((f = fc.showOpenDialog((Window)this.worldographer.getPrimaryStage())) != null) {
                    new FileSaveLoad(this.worldographer).importFile(f, (ViewLevel)((Object)((Object)viewLevelCombo.getSelectionModel().getSelectedItem())), -1, -1, null);
                }
            }
        });
        MenuItem importIntoMap = new MenuItem("Import Hexographer 1 Map Into Current Map");
        importIntoMap.setOnAction(t -> {
            if (!UserPrefs.FULL) {
                StandardDialog.showDialog(this.worldographer.getPrimaryStage(), "Pro Feature", "Importing maps into existing maps is only available if using a Pro version license.", "Sorry, some features are reserved for our Pro/paid version. \nIf you find the software useful, considering unlocking these special features and supporting \nthe many hours of work to create Worldographer with a Pro license. \nSee www.worldographer.com for details.\n", null, "");
                return;
            }
            StyledDialog d2 = new StyledDialog(true, (Window)this.worldographer.getPrimaryStage(), "Import Hexographer 1 Map");
            d2.setHeaderText("Import Hexographer 1 Map");
            d2.setContentText("Loading map...");
            GridPane gp = new GridPane();
            gp.setHgap(5.0);
            gp.setVgap(5.0);
            gp.add((Node)new Label("Note: You'll probably want to expand your map if you haven't yet.\nGo to the tools menu aand select \"Expand/Shrink Columns/Rows\"."), 0, 0, 4, 1);
            gp.add((Node)new Label("Anchor upper left corner of new map at which terrain hex?"), 0, 1, 4, 1);
            gp.add((Node)new Label("X:"), 0, 2);
            FocusSpinner xspinner = new FocusSpinner(0, 20000, 50);
            xspinner.setEditable(true);
            gp.add(xspinner, 1, 2);
            gp.add((Node)new Label("Y:"), 2, 2);
            FocusSpinner yspinner = new FocusSpinner(0, 20000, 50);
            yspinner.setEditable(true);
            gp.add(yspinner, 3, 2);
            d2.getDialogPane().setContent((Node)gp);
            ButtonType ok1 = new ButtonType("OK");
            ButtonType cancel = new ButtonType("Cancel");
            d2.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ok1, cancel});
            Optional result = d2.showAndWait();
            if (result.isPresent() && result.get() == ok1) {
                File f;
                File d = FileSaveLoad.getLastUsedDir();
                FileChooser fc = new FileChooser();
                FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("Hexographer 1 (*.hxm)", new String[]{"*.hxm"});
                fc.getExtensionFilters().add((Object)extFilter);
                if (d != null) {
                    fc.setInitialDirectory(d);
                }
                if ((f = fc.showOpenDialog((Window)this.worldographer.getPrimaryStage())) != null) {
                    new FileSaveLoad(this.worldographer).importFile(f, this.mapUI().viewLevel, (Integer)xspinner.getValue(), (Integer)yspinner.getValue(), null);
                }
            }
        });
        MenuItem importDungeonMap = new MenuItem("Import Dungeonographer 1 Map");
        importDungeonMap.setOnAction(t -> {
            File f;
            File d = FileSaveLoad.getLastUsedDir();
            FileChooser fc = new FileChooser();
            FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("Dungeonographer 1 (*.dgo)", new String[]{"*.dgo"});
            fc.getExtensionFilters().add((Object)extFilter);
            if (d != null) {
                fc.setInitialDirectory(d);
            }
            if ((f = fc.showOpenDialog((Window)this.worldographer.getPrimaryStage())) != null) {
                new FileSaveLoad(this.worldographer).importFile(f, ViewLevel.BATTLEMAT, -1, -1, HexOrientation.SQUARE);
            }
        });
        MenuItem importCityMap = new MenuItem("Import Cityographer 1 Map");
        importCityMap.setOnAction(t -> {
            File f;
            File d = FileSaveLoad.getLastUsedDir();
            FileChooser fc = new FileChooser();
            FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("Cityographer 1 (*.cgx)", new String[]{"*.cgx"});
            fc.getExtensionFilters().add((Object)extFilter);
            if (d != null) {
                fc.setInitialDirectory(d);
            }
            if ((f = fc.showOpenDialog((Window)this.worldographer.getPrimaryStage())) != null) {
                new FileSaveLoad(this.worldographer).importCityFile(f);
            }
        });
        MenuItem exportMap = new MenuItem("Export Image");
        exportMap.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.E, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN}));
        exportMap.setOnAction(t -> this.saveImage(false));
        MenuItem exportSelectImageMap = new MenuItem("Export Selected Area as Image");
        exportSelectImageMap.setOnAction(t -> {
            if (this.mapUI().selectPts == null || this.mapUI().selectPts.size() < 2) {
                StandardDialog.showDialog(this.worldographer.getPrimaryStage(), "No Selection", "You must first select an area to export.", "To select an area, go to the Edit menu and choose \"Select\" then click one corner of\nthe area you wish to print and drag to the opposite corner to make a rectangular area.\nNext, re-select the \"Export Selected Area as Image\" menu item.\n", null, "");
            } else {
                this.saveImage(true);
            }
        });
        MenuItem exportPdf = new MenuItem("Export to PDF");
        exportPdf.setOnAction(t -> new ExportPDFDialog(this.worldographer, this.mapUI(), "Tiles", false, FileSaveLoad.getLastUsedDir()));
        MenuItem exportSelectPdf = new MenuItem("Export Selected Area as PDF");
        exportSelectPdf.setOnAction(t -> {
            if (this.mapUI().selectPts == null || this.mapUI().selectPts.size() < 2) {
                StandardDialog.showDialog(this.worldographer.getPrimaryStage(), "No Selection", "You must first select an area to export.", "To select an area, go to the Edit menu and choose \"Select\" then click one corner of\nthe area you wish to print and drag to the opposite corner to make a rectangular area.\nNext, re-select the \"Export Selected Area as PDF\" menu item.\n", null, "");
            } else {
                new ExportPDFDialog(this.worldographer, this.mapUI(), "Tiles", true, FileSaveLoad.getLastUsedDir());
            }
        });
        MenuItem exportNotes = new MenuItem("Export Notes/Information");
        exportNotes.setOnAction(t -> {
            StyledDialog d2 = new StyledDialog(true, (Window)this.worldographer.getPrimaryStage(), "Export Notes/Information");
            d2.setHeaderText("Export Notes/Information");
            GridPane gp = new GridPane();
            gp.setHgap(5.0);
            gp.setVgap(5.0);
            gp.add((Node)new Label("If you want to export the notes of only a portion of the map, choose \"Select\nMap Area\" on the Edit menu, then click and drag to select a rectangular area\non your map. Only Notes in that area will be exported."), 0, 0, 4, 1);
            gp.add((Node)new Label("Data to Export:"), 0, 1);
            ToggleGroup infoNotesGroup = new ToggleGroup();
            RadioButton infoNotesRadioButton = new RadioButton("World Info & Notes");
            infoNotesRadioButton.setToggleGroup(infoNotesGroup);
            infoNotesRadioButton.setSelected(true);
            gp.add((Node)infoNotesRadioButton, 1, 1);
            RadioButton infoOnlyRadioButton = new RadioButton("World Info Only");
            infoOnlyRadioButton.setToggleGroup(infoNotesGroup);
            gp.add((Node)infoOnlyRadioButton, 2, 1);
            RadioButton notesOnlyRadioButton = new RadioButton("Notes Only");
            notesOnlyRadioButton.setToggleGroup(infoNotesGroup);
            gp.add((Node)notesOnlyRadioButton, 3, 1);
            ToggleGroup formatGroup = new ToggleGroup();
            gp.add((Node)new Label("Data Format:"), 0, 2);
            RadioButton htmlRadioButton = new RadioButton("HTML");
            htmlRadioButton.setUserData((Object)"HTML");
            htmlRadioButton.setToggleGroup(formatGroup);
            htmlRadioButton.setSelected(true);
            gp.add((Node)htmlRadioButton, 1, 2);
            RadioButton markdownRadioButton = new RadioButton("Markdown");
            markdownRadioButton.setUserData((Object)"MarkDown");
            markdownRadioButton.setToggleGroup(formatGroup);
            gp.add((Node)markdownRadioButton, 2, 2);
            RadioButton plainTextRadioButton = new RadioButton("Plain Text");
            plainTextRadioButton.setUserData((Object)"Plain");
            plainTextRadioButton.setToggleGroup(formatGroup);
            gp.add((Node)plainTextRadioButton, 3, 2);
            CheckBox includeFeatureImages = new CheckBox("Include small images of notes on the map.");
            includeFeatureImages.setSelected(true);
            gp.add((Node)includeFeatureImages, 0, 3, 4, 1);
            gp.add((Node)new Label("      (This may create many small image files; best to save to its own folder.)"), 0, 4, 4, 1);
            d2.getDialogPane().setContent((Node)gp);
            ButtonType ok1 = new ButtonType("OK");
            ButtonType cancel = new ButtonType("Cancel");
            d2.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ok1, cancel});
            Optional result = d2.showAndWait();
            if (result.isPresent() && result.get() == ok1) {
                File f;
                FileChooser fc = new FileChooser();
                File d1 = FileSaveLoad.getLastUsedDir();
                if (d1 != null) {
                    fc.setInitialDirectory(d1);
                }
                if ((f = fc.showSaveDialog((Window)this.worldographer.getPrimaryStage())) != null) {
                    Rectangle rect = this.mapUI().getSnapShotArea(false);
                    Rectangle rectArea = this.mapUI().getSnapShotArea(true);
                    BufferedImage bi = this.mapUI().getSnapShotMapAsImage(rect);
                    ExportNotesTask task = new ExportNotesTask(this.mapUI(), infoNotesRadioButton.isSelected() || infoOnlyRadioButton.isSelected(), infoNotesRadioButton.isSelected() || notesOnlyRadioButton.isSelected(), (String)formatGroup.getSelectedToggle().getUserData(), includeFeatureImages.isSelected(), this.worldographer, f, bi, rectArea);
                    task.setOnSucceeded(t1 -> task.getValue());
                    new Thread((Runnable)((Object)task)).start();
                }
            }
        });
        MenuItem exportUVTT = new MenuItem("Export as UVTT File");
        exportUVTT.setOnAction(t -> this.exportAsUVTT());
        MenuItem licenseMI = new MenuItem("Check/Update Worldographer 2025 License");
        licenseMI.setOnAction(t -> {
            if (UserPrefs.FULL) {
                boolean removeCode = StandardDialog.showYesNoDialog(this.worldographer.getPrimaryStage(), "Worldographer 2025 License", "Remove License Code", "Do you wish to reset/remove your registration code?\n(Make sure you still have the code.)", "Yes (Remove Code)", "No (Just Close Dialog)");
                if (removeCode) {
                    UserPrefs.PREFS.put("lik2025", "");
                    FileSaveLoad.flushPrefs();
                    StandardDialog.showInformationAlert("License Removed", "You'll need to restart Worldographer for the change to take effect.");
                }
            } else {
                new OtherDialog().showOtherDialog(this.worldographer.getPrimaryStage());
            }
        });
        MenuItem exit = new MenuItem("Exit");
        exit.setOnAction(t -> System.exit(0));
        menuFile.getItems().addAll((Object[])new MenuItem[]{newMap, newCityMap, newBattlematMap, newCosmicMap, openMap, this.openRecentMap, openIntoMap, dungeonGeomorphMap, new SeparatorMenuItem(), saveMap, saveAsMap, new SeparatorMenuItem(), importMap, importIntoMap, importDungeonMap, importCityMap, new SeparatorMenuItem(), exportMap, exportSelectImageMap, exportPdf, exportSelectPdf, exportNotes, exportUVTT, new SeparatorMenuItem(), licenseMI, new SeparatorMenuItem(), exit});
    }

    private void exportAsUVTT() {
        File file;
        boolean continueExport = StandardDialog.showYesNoDialog(this.worldographer.getPrimaryStage(), "Export as UVTT File", "Export as UVTT Warnings/Details", "This is still an early version of the UVTT export.  Please look for the Worldographer 2025 UVTT video for more details, but in summary: \n* It is best for Battlemats.\n* Walls are any shapes with the tag 'wall' or 'room'.\n* Wall lines need to stop/not overlap with doors or\n  windows for them to work properly.\n* For doors & windows, any feature with the word\n  'door' in the name is a door and features with\n  'window' in the name are windows.\n* Likewise features with 'torch' or 'fire' in\n  the name or have the tag 'light' are lights.", "Continue Export", "Cancel Export");
        if (!continueExport) {
            return;
        }
        FileChooser fc = new FileChooser();
        FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("Universal VTT (*.uvtt)", new String[]{"*.uvtt"});
        fc.getExtensionFilters().add((Object)extFilter);
        File d1 = FileSaveLoad.getLastUsedDir();
        if (d1 != null) {
            fc.setInitialDirectory(d1);
        }
        if ((file = fc.showSaveDialog((Window)this.worldographer.getPrimaryStage())) != null) {
            try {
                WorldographerMenuBar worldographerMenuBar = this;
                MapData mapData = worldographerMenuBar.worldographer.getMapUI().getMapData();
                WorldographerMenuBar worldographerMenuBar2 = this;
                ViewLevel currentViewLevel = worldographerMenuBar2.worldographer.getMapUI().getViewLevel();
                if (!file.getName().endsWith(".uvtt")) {
                    String filename = file.getAbsolutePath().substring(0, file.getAbsolutePath().length() - 5) + ".uvtt";
                    file = new File(filename);
                }
                FileOutputStream fos = new FileOutputStream(file);
                OutputStreamWriter w = new OutputStreamWriter(fos);
                StringBuilder sb = new StringBuilder("{\n");
                sb.append("\t\"format\": 0.3,\n");
                sb.append("\t\"resolution\": {\n");
                sb.append("\t\t\"map_origin\": {\n");
                sb.append("\t\t\t\"x\": 0,\n");
                sb.append("\t\t\t\"y\": 0\n");
                sb.append("\t\t},\n");
                sb.append("\t\t\"map_size\": {\n");
                sb.append("\t\t\t\"x\": " + mapData.getTerrain(currentViewLevel).length + ",\n");
                sb.append("\t\t\t\"y\": " + mapData.getTerrain(currentViewLevel)[0].length + "\n");
                sb.append("\t\t},\n");
                sb.append("\t\t\"pixels_per_grid\": " + mapData.getTileWidth() + "\n");
                sb.append("\t},\n");
                sb.append("\t\"line_of_sight\": [\n");
                ArrayList<MapShape> shapesToExport = new ArrayList<MapShape>();
                for (MapShape ms : mapData.getShapes()) {
                    if (!ms.getTags().toLowerCase().contains("wall") && !ms.getTags().toLowerCase().contains("room")) continue;
                    shapesToExport.add(ms);
                }
                for (int j = 0; j < shapesToExport.size(); ++j) {
                    sb.append("\t\t[\n");
                    List<Point2D> pts = new ArrayList();
                    PathTransition pt = null;
                    boolean isCurve = false;
                    Object object = ((MapShape)shapesToExport.get(j)).getShape();
                    if (object instanceof Path) {
                        Path path = (Path)object;
                        for (PathElement pe : path.getElements()) {
                            if (!(pe instanceof CubicCurveTo)) continue;
                            isCurve = true;
                        }
                        if (isCurve) {
                            pt = new PathTransition(Duration.ONE, (Shape)path, (Node)new Path());
                        }
                    } else {
                        object = ((MapShape)shapesToExport.get(j)).getShape();
                        if (object instanceof Arc) {
                            Arc arc = (Arc)object;
                            pt = new PathTransition(Duration.ONE, (Shape)arc, (Node)new Arc());
                        }
                    }
                    if (pt != null) {
                        long t0 = System.currentTimeMillis();
                        pt.playFromStart();
                        pt.stop();
                        for (double frac = 0.0; frac <= 1.0; frac += 0.0333333333) {
                            pt.interpolate(frac);
                            pts.add(new Point2D(pt.getNode().getTranslateX(), pt.getNode().getTranslateY()));
                        }
                        long t1 = System.currentTimeMillis();
                        System.out.println("Evaluation took: " + (t1 - t0) + "ms");
                    } else {
                        pts = ((MapShape)shapesToExport.get(j)).getShapePoints();
                        if (((MapShape)shapesToExport.get(j)).getShape() instanceof Polygon) {
                            pts.add(new Point2D(pts.get(0).getX(), pts.get(0).getY()));
                        }
                    }
                    for (int i = 0; i < pts.size(); ++i) {
                        sb.append("\t\t\t{\n");
                        sb.append("\t\t\t\t\"x\": " + pts.get(i).getX() / 300.0 + ",\n");
                        sb.append("\t\t\t\t\"y\": " + pts.get(i).getY() / 300.0 + "\n");
                        sb.append("\t\t\t}");
                        if (i != pts.size() - 1) {
                            sb.append(",\n");
                            continue;
                        }
                        sb.append("\n");
                    }
                    sb.append("\t\t]");
                    if (j != shapesToExport.size() - 1) {
                        sb.append(",\n");
                        continue;
                    }
                    sb.append("\n");
                }
                sb.append("\t],\n");
                ArrayList<Feature> featuresToExport = new ArrayList<Feature>();
                for (Feature f : mapData.getFeatures()) {
                    if (!f.getTypeName().toLowerCase().contains("column") && !f.getTypeName().toLowerCase().contains("pillar") && !f.getTypeName().toLowerCase().contains("wall")) continue;
                    featuresToExport.add(f);
                }
                sb.append("\t\"objects_line_of_sight\": [\n");
                for (int j = 0; j < featuresToExport.size(); ++j) {
                    Feature feature = (Feature)featuresToExport.get(j);
                    Point2D fLoc = feature.getLocation(this.mapUI().viewLevel);
                    sb.append("\t\t[\n");
                    sb.append("\t\t\t{\n");
                    sb.append("\t\t\t\t\"x\": " + (fLoc.getX() / 300.0 - feature.getScaleFallbackType() / 220.0) + ",\n");
                    sb.append("\t\t\t\t\"y\": " + (fLoc.getY() / 300.0 - feature.getScaleHtFallbackType() / 220.0) + "\n");
                    sb.append("\t\t\t},\n");
                    sb.append("\t\t\t{\n");
                    sb.append("\t\t\t\t\"x\": " + (fLoc.getX() / 300.0 - feature.getScaleFallbackType() / 220.0) + ",\n");
                    sb.append("\t\t\t\t\"y\": " + (fLoc.getY() / 300.0 + feature.getScaleHtFallbackType() / 220.0) + "\n");
                    sb.append("\t\t\t},\n");
                    sb.append("\t\t\t{\n");
                    sb.append("\t\t\t\t\"x\": " + (fLoc.getX() / 300.0 + feature.getScaleFallbackType() / 220.0) + ",\n");
                    sb.append("\t\t\t\t\"y\": " + (fLoc.getY() / 300.0 + feature.getScaleHtFallbackType() / 220.0) + "\n");
                    sb.append("\t\t\t},\n");
                    sb.append("\t\t\t{\n");
                    sb.append("\t\t\t\t\"x\": " + (fLoc.getX() / 300.0 + feature.getScaleFallbackType() / 220.0) + ",\n");
                    sb.append("\t\t\t\t\"y\": " + (fLoc.getY() / 300.0 - feature.getScaleHtFallbackType() / 220.0) + "\n");
                    sb.append("\t\t\t},\n");
                    sb.append("\t\t\t{\n");
                    sb.append("\t\t\t\t\"x\": " + (fLoc.getX() / 300.0 - feature.getScaleFallbackType() / 220.0) + ",\n");
                    sb.append("\t\t\t\t\"y\": " + (fLoc.getY() / 300.0 - feature.getScaleHtFallbackType() / 220.0) + "\n");
                    sb.append("\t\t\t}\n");
                    sb.append("\t\t]");
                    if (j != featuresToExport.size() - 1) {
                        sb.append(",\n");
                        continue;
                    }
                    sb.append("\n");
                }
                sb.append("\t],\n");
                sb.append("\t\"portals\": [\n");
                boolean isFirstPortal = true;
                for (Feature feature : mapData.getFeatures()) {
                    if (!feature.getTypeName().toLowerCase().startsWith("door") && !feature.getTypeName().toLowerCase().contains(" door") && !feature.getTypeName().toLowerCase().contains("/door") && !feature.getTypeName().toLowerCase().startsWith("window") && !feature.getTypeName().toLowerCase().contains(" window") && !feature.getTypeName().toLowerCase().contains("/window")) continue;
                    Point2D pt = feature.getLocation(this.mapUI().viewLevel);
                    if (pt == null) {
                        System.out.println("null:" + feature.getTypeName() + ":" + feature.getTags());
                        continue;
                    }
                    Rotate rotation = new Rotate(feature.getRotate(), 0.0, 0.0);
                    Point2D rotatedPoint = rotation.transform(feature.getScaleFallbackType() / 200.0, 0.0);
                    if (!isFirstPortal) {
                        sb.append(",\n");
                    }
                    isFirstPortal = false;
                    sb.append("\t\t{\n");
                    sb.append("\t\t\t\"position\": {\n");
                    sb.append("\t\t\t\t\"x\": " + pt.getX() / 300.0 + ",\n");
                    sb.append("\t\t\t\t\"y\": " + pt.getY() / 300.0 + "\n");
                    sb.append("\t\t\t},\n");
                    sb.append("\t\t\t\"bounds\": [\n");
                    sb.append("\t\t\t\t{\n");
                    sb.append("\t\t\t\t\"x\": " + (pt.getX() / 300.0 - rotatedPoint.getX()) + ",\n");
                    sb.append("\t\t\t\t\"y\": " + (pt.getY() / 300.0 - rotatedPoint.getY()) + "\n");
                    sb.append("\t\t\t\t},\n");
                    sb.append("\t\t\t\t{\n");
                    sb.append("\t\t\t\t\"x\": " + (pt.getX() / 300.0 + rotatedPoint.getX()) + ",\n");
                    sb.append("\t\t\t\t\"y\": " + (pt.getY() / 300.0 + rotatedPoint.getY()) + "\n");
                    sb.append("\t\t\t\t}\n");
                    sb.append("\t\t\t],\n");
                    sb.append("\t\t\t\"rotation\": " + Math.toRadians(feature.getRotate()) + ",\n");
                    boolean closed = feature.getTypeName().toLowerCase().startsWith("door") || feature.getTypeName().toLowerCase().contains(" door") || feature.getTypeName().toLowerCase().contains("/door");
                    sb.append("\t\t\t\"closed\": " + closed + ",\n");
                    sb.append("\t\t\t\"freestanding\": false\n");
                    sb.append("\t\t}");
                }
                sb.append("\n");
                sb.append("\t],\n");
                sb.append("\t\"environment\": {\n");
                sb.append("\t\t\"baked_lighting\": false,\n");
                sb.append("\t\t\"ambient_light\": \"ffffffff\"\n");
                sb.append("\t},\n");
                sb.append("\t\"lights\": [\n");
                boolean isFirstLight = true;
                for (Feature feature : mapData.getFeatures()) {
                    if (!feature.getTypeName().toLowerCase().startsWith("torch") && !feature.getTypeName().toLowerCase().contains(" torch") && !feature.getTypeName().toLowerCase().contains("/torch") && !feature.getTypeName().toLowerCase().contains("fire") && !feature.getTags().toLowerCase().contains("light")) continue;
                    if (!isFirstLight) {
                        sb.append(",\n");
                    }
                    isFirstLight = false;
                    sb.append("\t\t{\n");
                    sb.append("\t\t\t\"position\": {\n");
                    Point2D pt = feature.getLocation(this.mapUI().viewLevel);
                    sb.append("\t\t\t\t\"x\": " + pt.getX() / 300.0 + ",\n");
                    sb.append("\t\t\t\t\"y\": " + pt.getY() / 300.0 + "\n");
                    sb.append("\t\t\t},\n");
                    sb.append("\t\t\t\"range\": 4,\n");
                    sb.append("\t\t\t\"intensity\": 0.5,\n");
                    sb.append("\t\t\t\"color\": \"ffeccd8b\",\n");
                    sb.append("\t\t\t\"shadows\": true\n");
                    sb.append("\t\t}");
                }
                sb.append("\t],\n");
                this.worldographer.addStatus("Creating image.");
                WorldographerMenuBar worldographerMenuBar3 = this;
                Rectangle rect = worldographerMenuBar3.worldographer.getMapUI().getSnapShotArea(false);
                WorldographerMenuBar worldographerMenuBar4 = this;
                BufferedImage bi = worldographerMenuBar4.worldographer.getMapUI().getSnapShotMapAsImage(rect);
                ByteArrayOutputStream bas = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)bi, "png", bas);
                this.worldographer.addStatus("Image written.");
                sb.append("\t\"image\": \"" + Base64.encodeBytes(bas.toByteArray(), 8) + "\"\n");
                sb.append("}");
                w.write(sb.toString());
                w.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                StandardDialog.showException(this.worldographer.getPrimaryStage(), "Save Failed", "UVTT File Not Saved", "There was an error saving your mapimage.", "The exception stacktrace was:", ex);
            }
        }
    }

    private void saveImage(boolean selectedArea) {
        File f;
        boolean confirm = StandardDialog.showYesNoDialog(this.worldographer.getPrimaryStage(), "Export Uses Current Size", "Map Export Uses Current Size Settings", "If you want a 'larger' map (more pixels) change the tile width and/or height (under the mini-map).", "Continue", "Cancel");
        if (!confirm) {
            return;
        }
        File d = FileSaveLoad.getLastUsedDir();
        double dpi = new DPIDialog().promptForDPI(this.worldographer);
        if (dpi == -1.0) {
            return;
        }
        double blue = -1.0;
        if (this.mapUI().getViewLevel() == ViewLevel.BATTLEMAT && this.mapUI().isUseAlternateIcons()) {
            blue = new BlueColorShiftDialog().promptForBlueColorShift(this.worldographer);
        }
        FileChooser fc = new FileChooser();
        fc.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("Portable Network Graphics", new String[]{"*.png"})});
        if (d != null) {
            fc.setInitialDirectory(d);
        }
        if ((f = fc.showSaveDialog((Window)this.worldographer.getPrimaryStage())) != null) {
            Rectangle rect = this.mapUI().getSnapShotArea(selectedArea);
            new FileSaveLoad(this.worldographer).exportImage(this.mapUI(), f, rect, blue, dpi, true);
        }
    }

    public void updateRecentMapsMenu() {
        Preferences prefs = Preferences.userRoot().node("com/inkwellideas/worldographer2025");
        String recents = prefs.get("recent", "");
        this.openRecentMap.getItems().clear();
        if (recents == null || recents.equals("")) {
            this.openRecentMap.getItems().add((Object)new MenuItem("None"));
        } else {
            String[] recentmaps;
            for (String recentmap : recentmaps = recents.split("\\t")) {
                MenuItem mi = new MenuItem(recentmap);
                mi.setOnAction(t -> new FileSaveLoad(this.worldographer).loadFile(new File(mi.getText()), false, Integer.MAX_VALUE, Integer.MAX_VALUE, 0, false));
                this.openRecentMap.getItems().add((Object)mi);
            }
        }
    }

    public void setupWorldKingdomMenu() {
        this.menuBar.getMenus().remove((Object)this.menuGenerateCity);
        if (!this.menuBar.getMenus().contains((Object)this.menuGenerateWorld)) {
            this.menuBar.getMenus().add(5, (Object)this.menuGenerateWorld);
        }
        this.menuTools.getItems().remove((Object)this.switchIconsRealMenuItem);
        this.menuTools.getItems().remove((Object)this.switchIconsSimpleMenuItem);
        this.menuTools.getItems().add(1, (Object)this.switchTerrainIsoMenuItem);
        this.menuTools.getItems().add(2, (Object)this.switchTerrainClassicMenuItem);
    }

    public void setupBattlematMenu() {
        this.menuBar.getMenus().remove((Object)this.menuGenerateWorld);
        this.menuBar.getMenus().remove((Object)this.menuGenerateCity);
        this.menuTools.getItems().remove((Object)this.switchTerrainIsoMenuItem);
        this.menuTools.getItems().remove((Object)this.switchTerrainClassicMenuItem);
        this.menuTools.getItems().add(1, (Object)this.switchIconsRealMenuItem);
        this.menuTools.getItems().add(2, (Object)this.switchIconsSimpleMenuItem);
    }

    public void setupSettlementMenu() {
        this.menuBar.getMenus().remove((Object)this.menuGenerateWorld);
        if (!this.menuBar.getMenus().contains((Object)this.menuGenerateCity)) {
            this.menuBar.getMenus().add(5, (Object)this.menuGenerateCity);
        }
        this.menuTools.getItems().remove((Object)this.switchTerrainIsoMenuItem);
        this.menuTools.getItems().remove((Object)this.switchTerrainClassicMenuItem);
    }
}

