/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.ui.dialog;

import com.inkwellideas.ographer.map.Terrain;
import com.inkwellideas.ographer.model.Feature;
import com.inkwellideas.ographer.model.FeatureType;
import com.inkwellideas.ographer.model.TerrainType;
import com.inkwellideas.ographer.ui.Worldographer;
import com.inkwellideas.ographer.ui.widget.FocusSpinner;
import com.inkwellideas.ographer.ui.widget.StyledDialog;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Spinner;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.PixelReader;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.stage.Window;

public class AddCustomFeatureTerrainTexture {
    public int addCustomFeatureTerrainTexture(Worldographer worldographer, List<File> fs, String ftt, int count, List<String> types) {
        StyledDialog d2 = new StyledDialog(true, (Window)worldographer.getPrimaryStage(), "Set Up Custom " + ftt);
        d2.setHeaderText("Select Prefixes/Categories for " + ftt);
        GridPane gp = new GridPane();
        gp.add((Node)new Label("Prefixes/Categories let you filter by feature groupings."), 0, 0, 10, 1);
        HBox allRow = new HBox();
        allRow.setAlignment(Pos.CENTER);
        Label l1 = new Label("     Apply Category to all:");
        ComboBox allCombo = new ComboBox(FXCollections.observableArrayList(types));
        allCombo.setMaxWidth(120.0);
        Label or = new Label(" or create a new category:");
        TextField allTextField = new TextField();
        allTextField.setMaxWidth(120.0);
        allRow.getChildren().addAll((Object[])new Node[]{l1, allCombo, or, allTextField});
        gp.add((Node)allRow, 0, 1, 10, 1);
        HashMap<String, ComboBox> comboBoxMap = new HashMap<String, ComboBox>();
        HashMap<String, TextField> textFieldMap = new HashMap<String, TextField>();
        allCombo.setOnAction(event -> {
            for (ComboBox combo : comboBoxMap.values()) {
                combo.setValue((Object)((String)allCombo.getValue()));
            }
        });
        allTextField.setOnKeyReleased(event -> {
            for (TextField tf : textFieldMap.values()) {
                tf.setText(allTextField.getText());
            }
        });
        gp.add((Node)new Label("If you don't give a size (as a tile width percentage) Worldographer looks for a size in the filename.\nIf that isn't found it scales the image so 300 pixels = 100%. An image 225 pixels wide = 75%.\nYou can override that with the size settings on each row."), 0, 2, 10, 1);
        HBox sizeRow = new HBox();
        sizeRow.setAlignment(Pos.CENTER);
        Label l2 = new Label("     Apply Size to all: ");
        CheckBox overrideFileSizeAll = new CheckBox("Override File Name and Size: ");
        FocusSpinner allSizeSpinner = new FocusSpinner(1.0, 1000.0, 100.0);
        allSizeSpinner.setMaxWidth(80.0);
        sizeRow.getChildren().addAll((Object[])new Node[]{l2, overrideFileSizeAll, allSizeSpinner, new Label("%")});
        FocusSpinner allHeightSpinner = new FocusSpinner(-1.0, 1000.0, -1.0);
        allHeightSpinner.setMaxWidth(80.0);
        HashMap heightSpinnersMap = new HashMap();
        if (ftt.equals("Features")) {
            sizeRow.getChildren().addAll((Object[])new Node[]{new Label(" Height:"), allHeightSpinner});
            allHeightSpinner.valueProperty().addListener((obs, oldValue, newValue) -> {
                if (overrideFileSizeAll.isSelected()) {
                    for (Spinner spinner : heightSpinnersMap.values()) {
                        spinner.getValueFactory().setValue(newValue);
                    }
                }
            });
        }
        gp.add((Node)sizeRow, 0, 3, 10, 1);
        HashMap sizeSpinnersMap = new HashMap();
        allSizeSpinner.valueProperty().addListener((obs, oldValue, newValue) -> {
            if (overrideFileSizeAll.isSelected()) {
                for (Spinner spinner : sizeSpinnersMap.values()) {
                    spinner.getValueFactory().setValue(newValue);
                }
            }
        });
        final HashMap<String, CheckBox> sizeCheckBoxesMap = new HashMap<String, CheckBox>();
        overrideFileSizeAll.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                for (CheckBox cb : sizeCheckBoxesMap.values()) {
                    cb.setSelected(newValue.booleanValue());
                }
            }
        });
        gp.add((Node)new Label("Some imported icon sets have extra space on one side and not others.  But Worldographer expects the same amount of space on\neach side. Therefore you may need to offset the icon a bit."), 0, 4, 10, 1);
        HBox offsetBox = new HBox();
        Spinner allOffsetXSpinner = new Spinner(-1000.0, 1000.0, 0.0);
        allOffsetXSpinner.setEditable(true);
        allOffsetXSpinner.setMaxWidth(80.0);
        Spinner allOffsetYSpinner = new Spinner(-1000.0, 1000.0, 0.0);
        allOffsetYSpinner.setEditable(true);
        allOffsetYSpinner.setMaxWidth(80.0);
        offsetBox.getChildren().addAll((Object[])new Node[]{new Label("Offset X:"), allOffsetXSpinner, new Label("% tile width   Offset Y:"), allOffsetYSpinner, new Label("% tile height")});
        offsetBox.setAlignment(Pos.CENTER);
        gp.add((Node)offsetBox, 0, 5, 10, 1);
        HashMap<String, Spinner> offsetXSpinnersMap = new HashMap<String, Spinner>();
        allOffsetXSpinner.valueProperty().addListener((obs, oldValue, newValue) -> {
            for (Spinner spinner : offsetXSpinnersMap.values()) {
                spinner.getValueFactory().setValue(newValue);
            }
        });
        HashMap<String, Spinner> offsetYSpinnersMap = new HashMap<String, Spinner>();
        allOffsetYSpinner.valueProperty().addListener((obs, oldValue, newValue) -> {
            for (Spinner spinner : offsetYSpinnersMap.values()) {
                spinner.getValueFactory().setValue(newValue);
            }
        });
        gp.add((Node)new Label("And some imported icon sets need just a specific hexagon area.  Specify it as a series of points (x1,y1,x2,y2,x3,y3,...):"), 0, 6, 10, 1);
        TextField polygonTF = new TextField();
        polygonTF.setMinWidth(400.0);
        if (!fs.isEmpty() && fs.getFirst().getPath().toLowerCase().contains("hex_kit")) {
            polygonTF.setText("185,152, 105,198, 25,152, 25,58, 105,13, 185,58");
        }
        HBox polygonBox = new HBox();
        polygonBox.getChildren().addAll((Object[])new Node[]{new Label("Polygon:"), polygonTF});
        polygonBox.setAlignment(Pos.CENTER);
        gp.add((Node)polygonBox, 0, 7, 10, 1);
        HashMap<String, ColorPicker> backgroundCPs = new HashMap<String, ColorPicker>();
        HashMap<String, Spinner> elevationSpinners = new HashMap<String, Spinner>();
        gp.add((Node)new Label(" "), 0, 8);
        int fCount = 9;
        for (File f : fs) {
            TextField nameTF = new TextField(f.getName());
            nameTF.setMaxWidth(250.0);
            nameTF.setEditable(false);
            gp.add((Node)nameTF, 0, fCount);
            gp.add((Node)new Label(" Category:"), 1, fCount);
            ComboBox typeCombo = new ComboBox(FXCollections.observableArrayList(types));
            typeCombo.setMaxWidth(100.0);
            comboBoxMap.put(f.getName(), typeCombo);
            gp.add((Node)typeCombo, 2, fCount);
            gp.add((Node)new Label(" or new category:"), 3, fCount);
            TextField textField = new TextField();
            textField.setMaxWidth(100.0);
            textFieldMap.put(f.getName(), textField);
            gp.add((Node)textField, 4, fCount);
            gp.add((Node)new Label("   "), 5, fCount);
            CheckBox overrideSizeCB = new CheckBox("Override Size:");
            sizeCheckBoxesMap.put(f.getName(), overrideSizeCB);
            gp.add((Node)overrideSizeCB, 6, fCount);
            FocusSpinner sizeSpinner = new FocusSpinner(0.0, 1000.0, 100.0);
            sizeSpinner.setMaxWidth(80.0);
            sizeSpinnersMap.put(f.getName(), sizeSpinner);
            gp.add(sizeSpinner, 7, fCount);
            if (ftt.equals("Features")) {
                gp.add((Node)new Label(" Height:"), 8, fCount);
                FocusSpinner htSpinner = new FocusSpinner(-1.0, 1000.0, -1.0);
                htSpinner.setMaxWidth(80.0);
                heightSpinnersMap.put(f.getName(), htSpinner);
                gp.add(htSpinner, 9, fCount);
            }
            ColorPicker cp = null;
            if (ftt.equals("Terrain")) {
                Image image = new Image(f.toURI().toString());
                PixelReader pr = image.getPixelReader();
                ArrayList<Color> colors = new ArrayList<Color>();
                for (double i = 0.3; i <= 0.7; i += 0.05) {
                    for (double j = 0.3; j <= 0.7; j += 0.05) {
                        Color c = pr.getColor((int)(image.getWidth() * i), (int)(image.getHeight() * j));
                        if (!(c.getOpacity() > 0.0)) continue;
                        colors.add(c);
                    }
                }
                double red = 0.0;
                double green = 0.0;
                double blue = 0.0;
                for (Color c : colors) {
                    red += c.getRed();
                    green += c.getGreen();
                    blue += c.getBlue();
                }
                red /= (double)colors.size();
                red += (1.0 - red) * 0.2;
                Color color = new Color(red, green /= (double)colors.size(), blue /= (double)colors.size(), 1.0);
                color = color.desaturate();
                cp = new ColorPicker(color);
                System.out.println("Terrain:" + f.getName() + " red:" + color.getRed() + " green:" + color.getGreen() + " blue:" + color.getBlue());
                cp.setMaxWidth(120.0);
                backgroundCPs.put(f.getName(), cp);
            }
            ++fCount;
            Spinner offsetXSpinner = new Spinner(-1000.0, 1000.0, 0.0);
            offsetXSpinner.setEditable(true);
            offsetXSpinner.setMaxWidth(80.0);
            offsetXSpinnersMap.put(f.getName(), offsetXSpinner);
            Spinner offsetYSpinner = new Spinner(-1000.0, 1000.0, 0.0);
            offsetYSpinner.setEditable(true);
            offsetYSpinner.setMaxWidth(80.0);
            offsetYSpinnersMap.put(f.getName(), offsetYSpinner);
            Spinner elevationSpinner = new Spinner(-100000, 100000, 1000, 1000);
            elevationSpinner.setMaxWidth(100.0);
            elevationSpinner.setEditable(true);
            if (f.getName().toLowerCase().contains("mountains")) {
                elevationSpinner.getValueFactory().setValue((Object)6000);
            } else if (f.getName().toLowerCase().contains("mountain")) {
                elevationSpinner.getValueFactory().setValue((Object)5000);
            } else if (f.getName().toLowerCase().contains("hill")) {
                elevationSpinner.getValueFactory().setValue((Object)2000);
            } else if (f.getName().toLowerCase().contains("swamp")) {
                elevationSpinner.getValueFactory().setValue((Object)100);
            } else if (f.getName().toLowerCase().contains("marsh")) {
                elevationSpinner.getValueFactory().setValue((Object)100);
            } else if (f.getName().toLowerCase().contains("sea")) {
                elevationSpinner.getValueFactory().setValue((Object)-1000);
            } else if (f.getName().toLowerCase().contains("ocean")) {
                elevationSpinner.getValueFactory().setValue((Object)-2000);
            }
            elevationSpinners.put(f.getName(), elevationSpinner);
            HBox secondRowBox = ftt.equals("Terrain") ? new HBox(new Node[]{new Label("       "), new Label(" Background:"), cp, new Label("   Offset X:"), offsetXSpinner, new Label("%tile  Offset Y:"), offsetYSpinner, new Label("%tile   Elevation:"), elevationSpinner}) : new HBox(new Node[]{new Label("       "), new Label(" Offset X:"), offsetXSpinner, new Label("%tile  Offset Y:"), offsetYSpinner});
            secondRowBox.setMinWidth(700.0);
            secondRowBox.setAlignment(Pos.CENTER);
            gp.add((Node)secondRowBox, 0, fCount, 10, 1);
            ++fCount;
        }
        ScrollPane sp = new ScrollPane();
        sp.setContent((Node)gp);
        sp.setMinViewportWidth(800.0);
        sp.setMinViewportHeight(600.0);
        sp.setMaxHeight(800.0);
        VBox box = new VBox();
        box.getChildren().add((Object)sp);
        d2.getDialogPane().setContent((Node)box);
        d2.setWidth(800.0);
        d2.setHeight(800.0);
        ButtonType ok1 = new ButtonType("OK");
        ButtonType cancel = new ButtonType("Cancel");
        d2.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ok1, cancel});
        Optional result = d2.showAndWait();
        if (result.isEmpty() || result.get() == cancel) {
            return 0;
        }
        for (File f : fs) {
            String prefix = ((TextField)textFieldMap.get(f.getName())).getText();
            if ("".equals(prefix.trim())) {
                prefix = (String)((ComboBox)comboBoxMap.get(f.getName())).getValue();
            }
            String name = f.getName();
            String lowerCaseName = name.toLowerCase();
            if ("Features".equals(ftt)) {
                if (prefix == null || prefix.equals("No Prefix")) {
                    prefix = "";
                }
                if (!Worldographer.featureCategories.contains((Object)prefix)) {
                    Worldographer.featureCategories.add((Object)prefix);
                }
                FeatureType.loadUserFeatureSingleFile(prefix, Feature.featureTypes, f, null, ((CheckBox)sizeCheckBoxesMap.get(f.getName())).isSelected() ? (Double)((Spinner)sizeSpinnersMap.get(f.getName())).getValue() : -1.0, ((CheckBox)sizeCheckBoxesMap.get(f.getName())).isSelected() ? (Double)((Spinner)heightSpinnersMap.get(f.getName())).getValue() : -1.0, (Double)((Spinner)offsetXSpinnersMap.get(f.getName())).getValue() / 100.0, (Double)((Spinner)offsetYSpinnersMap.get(f.getName())).getValue() / 100.0, polygonTF.getText());
                ++count;
            }
            if (!"Terrain".equals(ftt)) continue;
            switch (prefix) {
                case "Classic": {
                    if (lowerCaseName.contains("classic")) {
                        prefix = "";
                        break;
                    }
                    prefix = "Classic";
                    break;
                }
                case "Cosmic": {
                    if (lowerCaseName.contains("cosmic")) {
                        prefix = "";
                        break;
                    }
                    prefix = "Cosmic";
                    break;
                }
                case "Floor": {
                    if (lowerCaseName.contains("floor")) {
                        prefix = "";
                        break;
                    }
                    prefix = "Floor";
                    break;
                }
                case "Isom. Cols": {
                    if (lowerCaseName.contains("iso cols")) {
                        prefix = "";
                        break;
                    }
                    prefix = "ISO Cols";
                    break;
                }
                case "Isom. Rows": {
                    if (lowerCaseName.contains("iso rows")) {
                        prefix = "";
                        break;
                    }
                    prefix = "ISO Rows";
                    break;
                }
            }
            if (!Worldographer.terrainCategories.contains((Object)prefix)) {
                Worldographer.terrainCategories.add((Object)prefix);
            }
            TerrainType.loadUserTerrainSingleFile(prefix, Terrain.terrainTypes, f, ((CheckBox)sizeCheckBoxesMap.get(f.getName())).isSelected() ? (Double)((Spinner)sizeSpinnersMap.get(f.getName())).getValue() : -1.0, (Color)((ColorPicker)backgroundCPs.get(f.getName())).getValue(), (Double)((Spinner)offsetXSpinnersMap.get(f.getName())).getValue(), (Double)((Spinner)offsetYSpinnersMap.get(f.getName())).getValue(), (Integer)((Spinner)elevationSpinners.get(f.getName())).getValue(), polygonTF.getText());
            ++count;
        }
        return count;
    }
}

