/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.ui.dialog;

import com.inkwellideas.ographer.data.HexOrientation;
import com.inkwellideas.ographer.data.ViewLevel;
import com.inkwellideas.ographer.map.MapData;
import com.inkwellideas.ographer.map.MapLogic;
import com.inkwellideas.ographer.map.Terrain;
import com.inkwellideas.ographer.ui.MapUI;
import com.inkwellideas.ographer.ui.widget.FocusSpinner;
import com.inkwellideas.ographer.ui.widget.StyledDialog;
import java.util.Optional;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.Spinner;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Pair;

public class ExpandShrinkTilesDialog {
    final MapData mapData;
    final MapUI mapPanel;
    final Dialog<ButtonType> mainDialog;
    final String type;
    private final Spinner<Integer> topMargin = new FocusSpinner<Integer>(-1000, 1000, 0);
    private final Spinner<Integer> bottomMargin = new FocusSpinner<Integer>(-1000, 1000, 0);
    private final Spinner<Integer> leftMargin = new FocusSpinner<Integer>(-1000, 1000, 0);
    private final Spinner<Integer> rightMargin = new FocusSpinner<Integer>(-1000, 1000, 0);
    final ViewLevel viewLevel;
    final double oldwidth;
    final double oldheight;

    public ExpandShrinkTilesDialog(Stage parentStage, MapUI mp, String type) {
        this.viewLevel = mp.getViewLevel();
        this.mapData = mp.getMapData();
        this.oldwidth = this.mapData.getTileWidth();
        this.oldheight = this.mapData.getTileHeight();
        this.mapPanel = mp;
        this.type = type;
        this.mainDialog = new StyledDialog<ButtonType>(true, (Window)parentStage, "Worldographer Expand/Shrink Tiles");
        this.mainDialog.setWidth(900.0);
        VBox mainBox = new VBox();
        mainBox.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        Label instructionLabelLine3 = new Label(mp.getMapData().getTileOrientation() == HexOrientation.COLUMNS ? "Because your map is set up so the columns line up, make sure you add/subtract an\neven number of tiles on the left margin--otherwise some map objects/shapes may \nseem to shift due to the staggered nature of hexes." : (mp.getMapData().getTileOrientation() == HexOrientation.ROWS ? "Because your map is set up so the rows line up, make sure you add/subtract an\neven number of tiles on the top margin--otherwise some map objects/shapes may\nseem to shift due to the staggered nature of hexes." : ""));
        mainBox.getChildren().add((Object)new Label("Enter the number of rows and columns of " + type + " you wish to add to each side of the"));
        mainBox.getChildren().add((Object)new Label("highest level (usually world) map. These changes cascade to the other map levels as"));
        mainBox.getChildren().add((Object)new Label("needed. Use negative numbers if you wish to delete rows/columns."));
        mainBox.getChildren().add((Object)instructionLabelLine3);
        BorderPane bp = new BorderPane();
        HBox topBox = new HBox(new Node[]{new Label("Top Margin:"), this.topMargin});
        topBox.setAlignment(Pos.CENTER);
        bp.setTop((Node)topBox);
        this.topMargin.setMaxWidth(80.0);
        HBox bottomBox = new HBox(new Node[]{new HBox(new Node[]{new Label("Bottom Margin:"), this.bottomMargin})});
        bottomBox.setAlignment(Pos.CENTER);
        bp.setBottom((Node)bottomBox);
        this.bottomMargin.setMaxWidth(80.0);
        bp.setLeft((Node)new VBox(new Node[]{new Label("Left Margin:"), this.leftMargin}));
        this.leftMargin.setMaxWidth(80.0);
        bp.setRight((Node)new VBox(new Node[]{new Label("Right Margin:"), this.rightMargin}));
        this.rightMargin.setMaxWidth(80.0);
        mainBox.getChildren().add((Object)bp);
        this.mainDialog.setHeaderText("Worldographer Expand/Shrink Tiles");
        this.mainDialog.getDialogPane().setContent((Node)mainBox);
        this.mainDialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        Optional result = this.mainDialog.showAndWait();
        if (result.isPresent() && result.get() == ButtonType.OK) {
            this.expandMap();
        }
    }

    public void expandMap() {
        ViewLevel[] vls;
        this.mapPanel.totalMapWidthBase = 0.0;
        this.mapPanel.totalMapHeightBase = 0.0;
        if (this.viewLevel == ViewLevel.BATTLEMAT || this.viewLevel == ViewLevel.SETTLEMENT) {
            Terrain[][] t = this.mapData.getTerrain(this.viewLevel);
            int top = (Integer)this.topMargin.getValue();
            int bottom = (Integer)this.bottomMargin.getValue();
            int left = (Integer)this.leftMargin.getValue();
            int right = (Integer)this.rightMargin.getValue();
            if (t != null) {
                Point2D diff = new Point2D((double)(left * 300), (double)(top * 300));
                Pair<Double, Double> wh = this.mapData.getModelPtFromTerrain(t.length + left + right, t[0].length + top + bottom);
                MapLogic.adjustShapesLabelsFeatures(this.mapData, this.mapPanel.viewLevel, diff, this.viewLevel, (Double)wh.getKey() - 1.0, (Double)wh.getValue() - 1.0);
                this.mapData.setTerrain(this.expandTerrainOneLevel(t, top, bottom, left, right), this.viewLevel);
            }
            this.mapPanel.recaclulateMapSize();
            this.mapPanel.draw();
            return;
        }
        int top = (Integer)this.topMargin.getValue();
        int bottom = (Integer)this.bottomMargin.getValue();
        int left = (Integer)this.leftMargin.getValue();
        int right = (Integer)this.rightMargin.getValue();
        for (ViewLevel vl : vls = new ViewLevel[]{ViewLevel.WORLD, ViewLevel.COSMIC, ViewLevel.CONTINENT, ViewLevel.KINGDOM, ViewLevel.PROVINCE}) {
            Terrain[][] t = this.mapData.getTerrain(vl);
            if (t == null) continue;
            int factor = 0;
            if (vl == ViewLevel.CONTINENT) {
                factor = this.mapData.getView().getContinentFactor();
            } else if (vl == ViewLevel.KINGDOM) {
                factor = this.mapData.getView().getKingdomFactor();
            } else if (vl == ViewLevel.PROVINCE) {
                factor = this.mapData.getView().getProvinceFactor();
            }
            if (factor > 0) {
                top *= factor;
                bottom *= factor;
                left *= factor;
                right *= factor;
            }
            Point2D diff = new Point2D((double)(left * 300), (double)(top * 300 * 3) / 4.0);
            if (this.mapData.getTileOrientation() == HexOrientation.COLUMNS) {
                diff = new Point2D((double)(left * 300 * 3) / 4.0, (double)(top * 300));
            } else if (this.mapData.getTileOrientation() == HexOrientation.SQUARE) {
                diff = new Point2D((double)(left * 300), (double)(top * 300));
            }
            Pair<Double, Double> wh = this.mapData.getModelPtFromTerrain(t.length + left + right, t[0].length + top + bottom);
            MapLogic.adjustShapesLabelsFeatures(this.mapData, this.mapPanel.viewLevel, diff, vl, (Double)wh.getKey() - 1.0, (Double)wh.getValue() - 1.0);
            this.mapData.setTerrain(this.expandTerrainOneLevel(t, top, bottom, left, right), vl);
        }
        this.mapPanel.recaclulateMapSize();
        this.mapPanel.draw();
    }

    private Terrain[][] expandTerrainOneLevel(Terrain[][] t, int top, int bottom, int left, int right) {
        Terrain[][] t2 = new Terrain[left + t.length + right][top + t[0].length + bottom];
        for (int x = 0; x < t2.length; ++x) {
            for (int y = 0; y < t2[0].length; ++y) {
                t2[x][y] = x >= t.length + left ? new Terrain("Blank", true) : (x < left ? new Terrain("Blank", true) : (y < top ? new Terrain("Blank", true) : (y >= t[0].length + top ? new Terrain("Blank", true) : t[x - left][y - top])));
            }
        }
        return t2;
    }
}

