/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.ui.dialog;

import com.inkwellideas.ographer.data.HexOrientation;
import com.inkwellideas.ographer.data.ViewLevel;
import com.inkwellideas.ographer.map.MapData;
import com.inkwellideas.ographer.ui.MapUI;
import com.inkwellideas.ographer.ui.Worldographer;
import com.inkwellideas.ographer.ui.dialog.BlueColorShiftDialog;
import com.inkwellideas.ographer.ui.widget.FocusSpinner;
import com.inkwellideas.ographer.ui.widget.StyledDialog;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Spinner;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.shape.Rectangle;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.graphics.image.LosslessFactory;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;

public class ExportPDFDialog
implements Runnable {
    final MapData mapData;
    final MapUI mapUI;
    final Dialog<ButtonType> mainDialog;
    final String type;
    final RadioButton spisRadio;
    final RadioButton fitPageRadio;
    final RadioButton presetPageSize;
    final RadioButton customPageSize;
    final ComboBox<String> pageSizeList;
    final CheckBox rotateCB;
    final Spinner<Double> squaresPerInchTF;
    final boolean isArea;
    final Spinner<Double> pageWidthSpinner;
    final Spinner<Double> pageHeightSpinner;
    final Spinner<Double> rightMarginTF;
    final Spinner<Double> leftMarginTF;
    final Spinner<Double> topMarginTF;
    final Spinner<Double> bottomMarginTF;
    double rightMargin;
    double leftMargin;
    double topMargin;
    double bottomMargin;
    final ComboBox<UNITS> unitCombo;
    final CheckBox trueDimensionsCheckBox;
    int count;
    boolean cancelled = false;
    BufferedImage bi = null;
    File file1 = null;
    final double oldwidth;
    final double oldheight;
    PDRectangle pageSize;
    File lastUsedDir;
    Worldographer worldographer;

    public ExportPDFDialog(Worldographer worldographer, MapUI mp, String type, boolean isarea, File lastuseddir) {
        this.worldographer = worldographer;
        this.mapData = mp.getMapData();
        this.oldwidth = this.mapData.getTileWidth();
        this.oldheight = this.mapData.getTileHeight();
        this.mapUI = mp;
        this.lastUsedDir = lastuseddir;
        this.type = type;
        this.isArea = isarea;
        this.mainDialog = new StyledDialog<ButtonType>(true, (Window)worldographer.getPrimaryStage(), "Worldographer Export to PDF");
        GridPane gp = new GridPane();
        gp.setHgap(5.0);
        gp.setVgap(5.0);
        gp.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        Label instructionlabel = new Label("Helpful notes about the options below:\n" + type + " per inch will determine how many " + type.toLowerCase() + " will be in an inch of your image.\nOr select the \"Scale map to 1 full page...\" option and the map will be sized to fit one page.\n\"Page Size\" sets the paper size.  The resulting image will automatically span multiple pages.\n\"Tiles/inch\" Values < 1 (tiles larger than 1\") may take a while.");
        instructionlabel.setMinWidth(600.0);
        gp.add((Node)instructionlabel, 0, 0, 4, 1);
        this.squaresPerInchTF = new FocusSpinner<Double>(0.0, 10000.0, 4.0);
        this.squaresPerInchTF.setMaxWidth(60.0);
        this.spisRadio = new RadioButton(type + "/inch:");
        this.fitPageRadio = new RadioButton("or Scale map to 1 full page, don't use Tiles/inch  ");
        ToggleGroup toggleGroup = new ToggleGroup();
        this.spisRadio.setToggleGroup(toggleGroup);
        this.fitPageRadio.setToggleGroup(toggleGroup);
        this.spisRadio.setSelected(true);
        HBox row1Box = new HBox(new Node[]{this.spisRadio, this.squaresPerInchTF, this.fitPageRadio});
        gp.add((Node)row1Box, 0, 1, 4, 1);
        gp.add((Node)new Label(" "), 0, 2);
        gp.add((Node)this.fitPageRadio, 0, 2, 3, 1);
        Object[] pss = new String[]{"Letter", "Legal", "A0", "A1", "A2", "A3", "A4", "A5", "ANSI B 11\"x17\"", "ANSI C 17\"x22\"", "ANSI D 22\"x34\"", "ANSI E 34\"x44\"", "Arch A 9\"x12\"", "Arch B 12\"x18\"", "Arch C 18\"x24\"", "Arch D 24\"x36\"", "Arch E 36\"x48\""};
        this.pageSizeList = new ComboBox(FXCollections.observableArrayList((Object[])pss));
        this.pageSizeList.getSelectionModel().select((Object)"Letter");
        ToggleGroup pageSizeToggleGroup = new ToggleGroup();
        this.presetPageSize = new RadioButton("Preset Page Size:");
        this.presetPageSize.setToggleGroup(pageSizeToggleGroup);
        this.presetPageSize.setSelected(true);
        this.rotateCB = new CheckBox("Rotate 90\u00b0");
        HBox presetBox = new HBox(new Node[]{this.pageSizeList, this.rotateCB});
        presetBox.setSpacing(5.0);
        presetBox.setAlignment(Pos.CENTER);
        gp.add((Node)this.presetPageSize, 0, 4, 1, 1);
        gp.add((Node)presetBox, 1, 4, 3, 1);
        this.customPageSize = new RadioButton("or Custom Page Size:");
        this.customPageSize.setToggleGroup(pageSizeToggleGroup);
        gp.add((Node)this.customPageSize, 0, 5, 1, 1);
        HBox customPageSizeBox = new HBox();
        customPageSizeBox.setSpacing(5.0);
        customPageSizeBox.setAlignment(Pos.CENTER);
        Label widthLabel = new Label("Width:");
        widthLabel.setAlignment(Pos.CENTER);
        customPageSizeBox.getChildren().add((Object)widthLabel);
        this.pageWidthSpinner = new FocusSpinner<Double>(1.0, 10000.0, 8.5);
        this.pageWidthSpinner.setMaxWidth(70.0);
        customPageSizeBox.getChildren().add(this.pageWidthSpinner);
        customPageSizeBox.getChildren().add((Object)new Label("Height:"));
        this.pageHeightSpinner = new FocusSpinner<Double>(1.0, 10000.0, 11.0);
        this.pageHeightSpinner.setMaxWidth(70.0);
        customPageSizeBox.getChildren().add(this.pageHeightSpinner);
        gp.add((Node)customPageSizeBox, 1, 5, 3, 1);
        UNITS[] units = new UNITS[]{UNITS.INCH, UNITS.CM};
        this.unitCombo = new ComboBox(FXCollections.observableArrayList((Object[])units));
        this.unitCombo.getSelectionModel().select((Object)UNITS.INCH);
        gp.add((Node)new Label("Page & Margin Units:"), 0, 6, 2, 1);
        gp.add(this.unitCombo, 1, 6, 2, 1);
        Label marginLabel = new Label("Margins:");
        marginLabel.setMinWidth(60.0);
        HBox marginBox = new HBox(new Node[]{marginLabel});
        marginBox.setSpacing(5.0);
        marginBox.setAlignment(Pos.CENTER);
        Label marginTopLabel = new Label("  Top:");
        marginTopLabel.setMinWidth(35.0);
        marginBox.getChildren().add((Object)marginTopLabel);
        this.topMarginTF = new FocusSpinner<Double>(0.0, 10000.0, 1.0);
        this.topMarginTF.setMaxWidth(70.0);
        this.topMarginTF.setMinWidth(70.0);
        marginBox.getChildren().add(this.topMarginTF);
        Label marginBottomLabel = new Label("  Bottom:");
        marginBottomLabel.setMinWidth(60.0);
        marginBox.getChildren().add((Object)marginBottomLabel);
        this.bottomMarginTF = new FocusSpinner<Double>(0.0, 10000.0, 1.0);
        this.bottomMarginTF.setMaxWidth(70.0);
        this.bottomMarginTF.setMinWidth(70.0);
        marginBox.getChildren().add(this.bottomMarginTF);
        Label marginLeftLabel = new Label("  Left:");
        marginLeftLabel.setMinWidth(35.0);
        marginBox.getChildren().add((Object)marginLeftLabel);
        this.leftMarginTF = new FocusSpinner<Double>(0.0, 10000.0, 1.0);
        this.leftMarginTF.setMaxWidth(70.0);
        this.leftMarginTF.setMinWidth(70.0);
        marginBox.getChildren().add(this.leftMarginTF);
        Label marginRightLabel = new Label("  Right:");
        marginRightLabel.setMinWidth(45.0);
        marginBox.getChildren().add((Object)marginRightLabel);
        this.rightMarginTF = new FocusSpinner<Double>(0.0, 10000.0, 1.0);
        this.rightMarginTF.setMaxWidth(70.0);
        this.rightMarginTF.setMinWidth(70.0);
        marginBox.getChildren().add(this.rightMarginTF);
        gp.add((Node)marginBox, 0, 7, 4, 1);
        this.trueDimensionsCheckBox = new CheckBox("Ignore current hex/width ratio and make true hexes.");
        if (type.equalsIgnoreCase("hexes")) {
            gp.add((Node)this.trueDimensionsCheckBox, 0, 6, 4, 1);
        }
        this.mainDialog.setHeaderText("Worldographer Export to PDF");
        this.mainDialog.getDialogPane().setContent((Node)gp);
        this.mainDialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        Optional result = this.mainDialog.showAndWait();
        if (result.isPresent() && result.get() == ButtonType.OK) {
            this.exportImage(worldographer);
        }
    }

    public void exportImage(Worldographer worldographer) {
        double blue = -1.0;
        if (this.mapUI.getViewLevel() == ViewLevel.BATTLEMAT && this.mapUI.isUseAlternateIcons()) {
            blue = new BlueColorShiftDialog().promptForBlueColorShift(worldographer);
        }
        worldographer.addStatus("Export to PDF setting up...");
        this.mapUI.isSelectingArea = false;
        FileChooser fc = new FileChooser();
        fc.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("Portable Document Format", new String[]{"*.pdf"})});
        if (this.lastUsedDir != null) {
            fc.setInitialDirectory(this.lastUsedDir);
        }
        this.file1 = fc.showSaveDialog(null);
        if (this.file1 == null) {
            return;
        }
        this.resizeRepaintMap();
        this.snapShotMap(blue);
        new Thread(this).start();
    }

    public void resizeRepaintMap() {
        double newhexheight;
        double newhexwidth;
        try {
            if (this.customPageSize.isSelected()) {
                float unitFactor = ((UNITS)((Object)this.unitCombo.getSelectionModel().getSelectedItem())).equals((Object)UNITS.CM) ? 0.39370078f : 1.0f;
                this.pageSize = new PDRectangle((float)((Double)this.pageWidthSpinner.getValue() * 72.0 * (double)unitFactor), (float)((Double)this.pageHeightSpinner.getValue() * 72.0 * (double)unitFactor));
            } else {
                String pss;
                switch (pss = (String)this.pageSizeList.getSelectionModel().getSelectedItem()) {
                    case "Legal": {
                        this.pageSize = new PDRectangle(PDRectangle.LEGAL.getWidth(), PDRectangle.LEGAL.getHeight());
                        break;
                    }
                    case "A5": {
                        this.pageSize = new PDRectangle(PDRectangle.A5.getWidth(), PDRectangle.A5.getHeight());
                        break;
                    }
                    case "A4": {
                        this.pageSize = new PDRectangle(PDRectangle.A4.getWidth(), PDRectangle.A4.getHeight());
                        break;
                    }
                    case "A3": {
                        this.pageSize = new PDRectangle(PDRectangle.A3.getWidth(), PDRectangle.A3.getHeight());
                        break;
                    }
                    case "A2": {
                        this.pageSize = new PDRectangle(PDRectangle.A2.getWidth(), PDRectangle.A2.getHeight());
                        break;
                    }
                    case "A1": {
                        this.pageSize = new PDRectangle(PDRectangle.A1.getWidth(), PDRectangle.A1.getHeight());
                        break;
                    }
                    case "A0": {
                        this.pageSize = new PDRectangle(PDRectangle.A0.getWidth(), PDRectangle.A0.getHeight());
                        break;
                    }
                    case "ANSI B 11\"x17\"": {
                        this.pageSize = new PDRectangle(792.0f, 1224.0f);
                        break;
                    }
                    case "ANSI C 17\"x22\"": {
                        this.pageSize = new PDRectangle(1224.0f, 1584.0f);
                        break;
                    }
                    case "ANSI D 22\"x34\"": {
                        this.pageSize = new PDRectangle(1584.0f, 2348.0f);
                        break;
                    }
                    case "ANSI E 34\"x44\"": {
                        this.pageSize = new PDRectangle(1584.0f, 3168.0f);
                        break;
                    }
                    case "Arch A 9\"x12\"": {
                        this.pageSize = new PDRectangle(648.0f, 864.0f);
                        break;
                    }
                    case "Arch B 12\"x18\"": {
                        this.pageSize = new PDRectangle(864.0f, 1296.0f);
                        break;
                    }
                    case "Arch C 18\"x24\"": {
                        this.pageSize = new PDRectangle(1296.0f, 1728.0f);
                        break;
                    }
                    case "Arch D 24\"x36\"": {
                        this.pageSize = new PDRectangle(1728.0f, 2592.0f);
                        break;
                    }
                    case "Arch E 36\"x48\"": {
                        this.pageSize = new PDRectangle(2592.0f, 3456.0f);
                        break;
                    }
                    default: {
                        this.pageSize = new PDRectangle(PDRectangle.LETTER.getWidth(), PDRectangle.LETTER.getHeight());
                    }
                }
            }
            if (this.rotateCB.isSelected()) {
                float x = this.pageSize.getUpperRightX();
                float y = this.pageSize.getUpperRightY();
                this.pageSize.setLowerLeftX(0.0f);
                this.pageSize.setLowerLeftY(0.0f);
                this.pageSize.setUpperRightX(y);
                this.pageSize.setUpperRightY(x);
            }
        }
        catch (Throwable e) {
            if (e instanceof OutOfMemoryError) {
                Alert alert = new Alert(Alert.AlertType.ERROR);
                alert.setTitle("Out of Memory");
                alert.setHeaderText("Out of Memory");
                alert.setContentText("You don't have enough memory to print the map this large.");
                alert.showAndWait();
            } else {
                Alert alert = new Alert(Alert.AlertType.ERROR);
                alert.setTitle("Exception");
                alert.setHeaderText("Exception");
                alert.setContentText("An exception occurred while printing the map:\n" + e.getMessage());
                alert.showAndWait();
            }
            e.printStackTrace();
        }
        double spi = (Double)this.squaresPerInchTF.getValue();
        this.leftMargin = (Double)this.leftMarginTF.getValue();
        this.rightMargin = (Double)this.rightMarginTF.getValue();
        this.topMargin = (Double)this.topMarginTF.getValue();
        this.bottomMargin = (Double)this.bottomMarginTF.getValue();
        if (((UNITS)((Object)this.unitCombo.getSelectionModel().getSelectedItem())).equals((Object)UNITS.CM)) {
            this.leftMargin /= (double)2.54f;
            this.rightMargin /= (double)2.54f;
            this.topMargin /= (double)2.54f;
            this.bottomMargin /= (double)2.54f;
        }
        if (this.fitPageRadio.isSelected()) {
            float leftRightMargin = (float)(this.leftMargin + this.rightMargin) * 300.0f;
            float topBottomMargin = (float)(this.topMargin + this.bottomMargin) * 300.0f;
            double printAreaWidthInPixels = (double)this.pageSize.getWidth() * 300.0 / 72.0 - (double)leftRightMargin - 3.0;
            double printAreaHeightInPixels = (double)this.pageSize.getHeight() * 300.0 / 72.0 - (double)topBottomMargin - 3.0;
            if (this.isArea) {
                Rectangle area = this.mapUI.getSnapShotArea(true);
                double ratio = printAreaWidthInPixels / area.getWidth();
                double ratioH = printAreaHeightInPixels / area.getHeight();
                if (ratioH < ratio) {
                    ratio = ratioH;
                }
                newhexwidth = this.oldwidth * ratio;
                newhexheight = this.oldheight * ratio;
            } else {
                double ratio;
                double mapwidth = this.mapUI.computeTotalMapWidthPixelsCurrentTileSize();
                double mapheight = this.mapUI.computeTotalMapHeightPixelsCurrentTileSize();
                double ratioH = printAreaHeightInPixels / mapheight;
                if (ratioH < (ratio = printAreaWidthInPixels / mapwidth)) {
                    ratio = ratioH;
                }
                newhexwidth = this.oldwidth * ratio;
                newhexheight = this.oldheight * ratio;
            }
        } else if (this.mapData.getTileOrientation() == HexOrientation.COLUMNS) {
            newhexheight = (int)(300.0 / spi);
            newhexwidth = newhexheight * this.oldwidth / this.oldheight;
            if (this.trueDimensionsCheckBox.isSelected()) {
                newhexwidth = (int)(Math.sqrt(newhexheight / 2.0 * (newhexheight / 2.0) + newhexheight / 4.0 * newhexheight / 4.0) * 2.0);
            }
        } else {
            newhexwidth = (int)(300.0 / spi);
            newhexheight = newhexwidth * this.oldheight / this.oldwidth;
            if (this.trueDimensionsCheckBox.isSelected()) {
                newhexheight = (int)(Math.sqrt(newhexwidth / 2.0 * (newhexwidth / 2.0) + newhexwidth / 4.0 * newhexwidth / 4.0) * 2.0);
            }
        }
        this.mapData.setTileWidthHeight(newhexwidth, newhexheight, false);
    }

    public void snapShotMap(double converttoblue) {
        try {
            this.bi = this.mapUI.getSnapShotMapAsImage(this.mapUI.getSnapShotArea(this.isArea));
            converttoblue *= 255.0;
            if (converttoblue >= 0.0) {
                for (int x = 0; x < this.bi.getWidth(); ++x) {
                    for (int y = 0; y < this.bi.getHeight(); ++y) {
                        int rgb = this.bi.getRGB(x, y);
                        Color c = new Color(rgb);
                        int r = c.getRed();
                        int g = c.getGreen();
                        int b = c.getBlue();
                        c = (double)(b = (b + g + r) / 3) < converttoblue ? new Color(44, 153, 206, 255) : new Color(255, 255, 255, 255);
                        this.bi.setRGB(x, y, c.getRGB());
                    }
                }
            }
        }
        catch (Throwable e) {
            if (e instanceof OutOfMemoryError) {
                Alert alert = new Alert(Alert.AlertType.ERROR);
                alert.setTitle("Out of Memory");
                alert.setHeaderText("Out of Memory");
                alert.setContentText("You don't have enough memory to print the map this large.");
                alert.showAndWait();
            } else {
                Alert alert = new Alert(Alert.AlertType.ERROR);
                alert.setTitle("Exception");
                alert.setHeaderText("Exception");
                alert.setContentText("An exception occurred while printing the map:\n" + e.getMessage());
                alert.showAndWait();
            }
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        PDDocument doc = new PDDocument();
        try {
            int h;
            int y;
            int h2;
            double imageWidthInches = (double)this.pageSize.getWidth() / 72.0 - this.rightMargin - this.leftMargin;
            double imageHeightInches = (double)this.pageSize.getHeight() / 72.0 - this.topMargin - this.bottomMargin;
            int totalPages = 0;
            for (y = 0; y < this.bi.getHeight(); y += h2) {
                int w;
                h2 = 0;
                for (int x = 0; x < this.bi.getWidth(); x += w) {
                    w = (int)(300.0 * imageWidthInches);
                    if (x + w > this.bi.getWidth()) {
                        w = this.bi.getWidth() - x;
                    }
                    if (y + (h2 = (int)(300.0 * imageHeightInches)) > this.bi.getHeight()) {
                        h2 = this.bi.getHeight() - y;
                    }
                    ++totalPages;
                }
            }
            int totalPagesF = totalPages;
            this.count = 0;
            float scale = 0.24f;
            for (y = 0; y < this.bi.getHeight(); y += h) {
                int w;
                h = 0;
                for (int x = 0; x < this.bi.getWidth(); x += w) {
                    if (this.cancelled) {
                        return;
                    }
                    Platform.runLater(() -> this.worldographer.addStatus("Exporting PDF: " + (int)((double)this.count * 1.0 / (double)(totalPagesF + 1) * 100.0) + "%"));
                    w = (int)(300.0 * imageWidthInches);
                    if (x + w > this.bi.getWidth()) {
                        w = this.bi.getWidth() - x;
                    }
                    if (y + (h = (int)(300.0 * imageHeightInches)) > this.bi.getHeight()) {
                        h = this.bi.getHeight() - y;
                    }
                    PDPage page = new PDPage(this.pageSize);
                    doc.addPage(page);
                    PDPageContentStream contentStream = new PDPageContentStream(doc, page, PDPageContentStream.AppendMode.APPEND, true);
                    PDImageXObject pdImage = LosslessFactory.createFromImage(doc, this.bi.getSubimage(x, y, w, h));
                    if (this.fitPageRadio.isSelected()) {
                        double left = ((double)this.pageSize.getWidth() - (double)pdImage.getWidth() / 300.0 * 72.0) / 2.0;
                        double bottom = ((double)this.pageSize.getHeight() - (double)pdImage.getHeight() / 300.0 * 72.0) / 2.0;
                        contentStream.drawImage(pdImage, (float)((int)left), (float)((int)bottom), (float)pdImage.getWidth() * scale, (float)pdImage.getHeight() * scale);
                    } else {
                        contentStream.drawImage(pdImage, (float)((int)(this.leftMargin * 72.0)), (float)((int)(this.bottomMargin * 72.0)), (float)pdImage.getWidth() * scale, (float)pdImage.getHeight() * scale);
                    }
                    contentStream.close();
                    ++this.count;
                }
            }
            doc.save(this.file1);
            doc.close();
            Platform.runLater(() -> this.worldographer.addStatus("Export to PDF complete."));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            try {
                doc.close();
            }
            catch (IOException e) {
                Alert alert = new Alert(Alert.AlertType.ERROR);
                alert.setTitle("Exception");
                alert.setHeaderText("Exception");
                alert.setContentText("An exception occurred while printing the map:\n" + e.getMessage());
                alert.showAndWait();
                e.printStackTrace();
            }
        }
        this.mapData.setTileWidthHeight(this.oldwidth, this.oldheight, false);
        this.mapUI.recaclulateMapSize();
        Platform.runLater(() -> this.mapUI.draw());
    }

    static enum UNITS {
        INCH,
        CM;

    }
}

