/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.ui.dialog;

import com.inkwellideas.ographer.ui.Worldographer;
import com.inkwellideas.ographer.ui.widget.StyledDialog;
import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.util.Properties;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javafx.stage.Stage;
import javafx.stage.Window;

public class UpdaterDialog {
    public static final String UPDATE_URL = "https://worldographer.com/world-config-2025.properties";

    public void getUpdateWebView(WebView view, String version) {
        StringBuilder sb;
        block6: {
            sb = new StringBuilder();
            try {
                URL propsURL = new URL(UPDATE_URL);
                Properties props = new Properties();
                BufferedReader in1 = new BufferedReader(new InputStreamReader(propsURL.openStream()));
                props.load(in1);
                String currversion = props.getProperty("current");
                if (currversion == null || currversion.equals(version)) break block6;
                String updaterInfo = "<h2>Update Available</h2>\n<p>You can download the latest version at https://worldographer.com/download/</p>\n<h3>Changes since you last updated:</h3>\n";
                sb.append(updaterInfo);
                String[] versions = props.getProperty("versions").split(";");
                try {
                    String v;
                    double dv;
                    double currv = Double.parseDouble(version);
                    String[] stringArray = versions;
                    int n = stringArray.length;
                    for (int i = 0; i < n && !(currv >= (dv = Double.parseDouble(v = stringArray[i]))); ++i) {
                        String[] changes;
                        sb.append("<p>Version ").append(v).append(":").append("</ul>");
                        for (String c : changes = props.getProperty(v).split(";")) {
                            sb.append("<li>").append(c).append("</li>");
                        }
                        sb.append("</ul></p>");
                    }
                }
                catch (NumberFormatException currv) {
                    // empty catch block
                }
                URI u = new URI("https://www.worldographer.com/download/");
                Desktop.getDesktop().browse(u);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        WebEngine updateTab = view.getEngine();
        updateTab.loadContent("<style type=\"text/css\">p {font-family: Futura,Trebuchet MS,Arial,sans-serif; font-size:0.875em; padding: 0; margin: 0} h1,h2,h3 {font-family: Futura,Trebuchet MS,Arial,sans-serif; padding: 0; margin: 0}</style>" + String.valueOf(sb) + "\n");
    }

    public void getUpdateInfo(Stage parentStage, String version) {
        StyledDialog d = new StyledDialog(true, (Window)parentStage, "Worldographer Update Info");
        d.setHeaderText("Worldographer Update Info");
        WebView view = new WebView();
        view.setMinSize(300.0, 300.0);
        view.setPrefSize(550.0, 350.0);
        this.getUpdateWebView(view, version);
        d.getDialogPane().setContent((Node)view);
        ButtonType yes = new ButtonType("OK");
        d.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{yes});
        d.showAndWait();
    }

    public boolean checkIsOutdated(String version) {
        try {
            URL propsURL = new URL(UPDATE_URL);
            Properties props = new Properties();
            BufferedReader in1 = new BufferedReader(new InputStreamReader(propsURL.openStream()));
            props.load(in1);
            String currversion = props.getProperty("current");
            if (version.equals(currversion)) {
                return false;
            }
            try {
                if (Double.parseDouble(version.trim()) > Double.parseDouble(currversion.trim())) {
                    return false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return true;
        }
        catch (Exception e) {
            Worldographer.REPORTING = false;
            e.printStackTrace();
            return false;
        }
    }
}

