/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.ui.setup;

import com.inkwellideas.ographer.data.HexOrientation;
import com.inkwellideas.ographer.data.LabelStyle;
import com.inkwellideas.ographer.data.MapLayer;
import com.inkwellideas.ographer.data.ViewLevel;
import com.inkwellideas.ographer.generator.battlemat.MakeDungeonGeomorph;
import com.inkwellideas.ographer.generator.battlemat.MakeHouse;
import com.inkwellideas.ographer.generator.battlemat.MakeInn;
import com.inkwellideas.ographer.generator.battlemat.MakeSmith;
import com.inkwellideas.ographer.generator.battlemat.MakeStore;
import com.inkwellideas.ographer.generator.battlemat.MakeTavern;
import com.inkwellideas.ographer.generator.battlemat.ProceduralDungeonGenerator;
import com.inkwellideas.ographer.generator.battlemat.ProceduralDungeonRoom;
import com.inkwellideas.ographer.generator.battlemat.Tower;
import com.inkwellideas.ographer.io.LoadImage;
import com.inkwellideas.ographer.io.UserPrefs;
import com.inkwellideas.ographer.map.MapData;
import com.inkwellideas.ographer.map.MapDataSetup;
import com.inkwellideas.ographer.map.MapLabel;
import com.inkwellideas.ographer.map.MapLogic;
import com.inkwellideas.ographer.map.MapProjection;
import com.inkwellideas.ographer.map.MapShape;
import com.inkwellideas.ographer.map.Terrain;
import com.inkwellideas.ographer.model.Feature;
import com.inkwellideas.ographer.model.Note;
import com.inkwellideas.ographer.model.ShapeStyle;
import com.inkwellideas.ographer.model.TextureType;
import com.inkwellideas.ographer.ui.Worldographer;
import com.inkwellideas.ographer.ui.dialog.StandardDialog;
import com.inkwellideas.ographer.ui.dialog.StartNewMapDialog;
import com.inkwellideas.ographer.ui.widget.FocusSpinner;
import com.inkwellideas.ographer.ui.widget.PopupStage;
import com.inkwellideas.ographer.ui.widget.StyledDialog;
import com.inkwellideas.ographer.util.SafePreferences;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.Spinner;
import javafx.scene.control.TextArea;
import javafx.scene.control.ToggleGroup;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javafx.stage.Stage;
import javafx.stage.Window;

public class SetupBattlematScreen
extends PopupStage {
    private Stage popupStage;
    private final Worldographer worldographer;
    private final Spinner<Integer> hexesWideSpinner = new FocusSpinner<Integer>(1, 10000, 100);
    private final Spinner<Integer> hexesHighSpinner = new FocusSpinner<Integer>(1, 10000, 50);
    private final Spinner<Integer> seedSpinner = new FocusSpinner<Integer>(1, 10000000, (int)(Math.random() * 1000000.0));
    private final Spinner<Integer> seedSpinner2 = new FocusSpinner<Integer>(1, 10000000, (int)(Math.random() * 1000000.0));
    private final Spinner<Integer> sectionsWideSpinner = new FocusSpinner<Integer>(2, 20, 5);
    private final Spinner<Integer> sectionsHighSpinner = new FocusSpinner<Integer>(2, 20, 5);
    private final Spinner<Double> hexWidthSpinner = new FocusSpinner<Double>(1.0, 100000.0, 46.18);
    private final Spinner<Double> hexHeightSpinner = new FocusSpinner<Double>(1.0, 100000.0, 40.0);
    private final RadioButton blankMapButton = new RadioButton("Blank Map");
    private final RadioButton genDungeonButton = new RadioButton("Generate Random Room Dungeon");
    private final RadioButton genDungeonSectionsButton = new RadioButton("Generate Dungeon via Sections:                    ");
    private final RadioButton genHouseButton = new RadioButton("Generate House");
    private final RadioButton genInnButton = new RadioButton("Generate Inn");
    private final RadioButton genSmithButton = new RadioButton("Generate Smith");
    private final RadioButton genStoreButton = new RadioButton("Generate Store");
    private final RadioButton genTavernButton = new RadioButton("Generate Tavern");
    private final RadioButton genTowerButton = new RadioButton("Generate Tower");
    private final ListView<SectionTypes> sectionsListView = new ListView();
    private final ListView<SectionTypes> sectionsExcludeListView = new ListView();
    private ComboBox<TextureType> floorTextureCombo;
    private ComboBox<TextureType> wallTextureCombo;
    private ComboBox<TextureType> deluxeFloorCombo;
    private TextArea proceduralDungeonConfig = new TextArea();
    SafePreferences prefs = new SafePreferences("com/inkwellideas/worldographer2025");
    MapDataSetup setup = null;

    public SetupBattlematScreen(Worldographer ms) {
        this.worldographer = ms;
        this.sectionsListView.setItems(FXCollections.observableArrayList((Object[])SectionTypes.values()));
        this.sectionsListView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.sectionsExcludeListView.setItems(FXCollections.observableArrayList((Object[])SectionTypes.values()));
        this.sectionsExcludeListView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
    }

    public void start(Stage popStage) {
        this.popupStage = popStage;
        this.popupStage.setTitle("Worldographer Battlemat Setup Screen");
        BorderPane border = new BorderPane();
        border.setPadding(new Insets(10.0, 12.0, 10.0, 10.0));
        border.setLeft((Node)this.getSizePane());
        border.setRight(this.getTerrainPane());
        Button generateButton = new Button("Generate Map");
        generateButton.setOnAction(e -> {
            Terrain[][] t = new Terrain[((Integer)this.hexesWideSpinner.getValue()).intValue()][((Integer)this.hexesHighSpinner.getValue()).intValue()];
            this.setup = new MapDataSetup();
            for (int y = 0; y < t[0].length; ++y) {
                for (int x = 0; x < t.length; ++x) {
                    t[x][y] = new Terrain("Empty", true);
                }
            }
            this.setup.type = MapData.Type.BATTLEMAT;
            this.setup.setTerrainByViewLevel(ViewLevel.BATTLEMAT, t);
            this.setup.hexWidth = (Double)this.hexWidthSpinner.getValue();
            this.setup.hexHeight = (Double)this.hexHeightSpinner.getValue();
            this.setup.hexOrientation = HexOrientation.SQUARE;
            this.setup.mapProjection = MapProjection.FLAT;
            this.setup.generateOneTerrain = true;
            this.setup.solidTerrain = "Blank";
            ArrayList<MapLayer> mapLayers = new ArrayList<MapLayer>();
            mapLayers.add(new MapLayer("Labels"));
            mapLayers.add(new MapLayer("Features"));
            mapLayers.add(new MapLayer("Above Terrain"));
            mapLayers.add(new MapLayer("Terrain Land"));
            mapLayers.add(new MapLayer("Above Water"));
            mapLayers.add(new MapLayer("Terrain Water"));
            mapLayers.add(new MapLayer("Below All"));
            this.setup.mapLayers = mapLayers;
            String mapType = "Blank";
            if (this.genDungeonButton.isSelected()) {
                mapType = "DUNGEON";
            }
            if (this.genDungeonSectionsButton.isSelected()) {
                mapType = "DUNGEON SECTIONS";
            }
            if (this.blankMapButton.isSelected()) {
                mapType = "BLANK";
            }
            if (this.genHouseButton.isSelected()) {
                mapType = "HOUSE";
            }
            if (this.genInnButton.isSelected()) {
                mapType = "INN";
            }
            if (this.genSmithButton.isSelected()) {
                mapType = "SMITH";
            }
            if (this.genStoreButton.isSelected()) {
                mapType = "STORE";
            }
            if (this.genTavernButton.isSelected()) {
                mapType = "TAVERN";
            }
            if (this.genTowerButton.isSelected()) {
                mapType = "TOWER";
            }
            this.setup.generate = mapType;
            HashSet<Note> notes = new HashSet<Note>();
            this.setup.notes = notes;
            this.prefs.put("generate", mapType);
            this.prefs.put("tileWidth", String.valueOf(this.hexWidthSpinner.getValue()));
            this.prefs.put("tileHeight", String.valueOf(this.hexHeightSpinner.getValue()));
            this.prefs.put("tilesWide", String.valueOf(this.hexesWideSpinner.getValue()));
            this.prefs.put("tilesHigh", String.valueOf(this.hexesHighSpinner.getValue()));
            this.prefs.put("initialView", String.valueOf((Object)ViewLevel.BATTLEMAT));
            HashMap<ViewLevel, Terrain[][]> terrainmap = new HashMap<ViewLevel, Terrain[][]>();
            Terrain[][] t2 = new Terrain[((Integer)this.hexesWideSpinner.getValue()).intValue()][((Integer)this.hexesHighSpinner.getValue()).intValue()];
            if (this.genDungeonSectionsButton.isSelected()) {
                this.prefs.putInt("sectionsWide", (Integer)this.sectionsWideSpinner.getValue());
                this.prefs.putInt("sectionsHigh", (Integer)this.sectionsHighSpinner.getValue());
                ObservableList sections = this.sectionsListView.getSelectionModel().getSelectedItems();
                String sectionString = this.makeSectionsIntoString((List<SectionTypes>)sections);
                this.prefs.put("sectionsRequired", sectionString);
                ObservableList sectionsExcluded = this.sectionsExcludeListView.getSelectionModel().getSelectedItems();
                String sectionsExcludedString = this.makeSectionsIntoString((List<SectionTypes>)sectionsExcluded);
                this.prefs.put("sectionsExcluded", sectionsExcludedString);
                this.prefs.put("wallTexture", ((TextureType)this.wallTextureCombo.getSelectionModel().getSelectedItem()).getType());
                this.prefs.put("floorTexture", ((TextureType)this.floorTextureCombo.getSelectionModel().getSelectedItem()).getType());
                this.prefs.put("floorDeluxeTexture", ((TextureType)this.deluxeFloorCombo.getSelectionModel().getSelectedItem()).getType());
                t2 = new Terrain[(Integer)this.sectionsWideSpinner.getValue() * 20][(Integer)this.sectionsHighSpinner.getValue() * 20];
            }
            for (int i = 0; i < t2.length; ++i) {
                for (int j = 0; j < t2[i].length; ++j) {
                    t2[i][j] = new Terrain("Blank", true);
                }
            }
            ArrayList<MapShape> shapes = new ArrayList<MapShape>();
            ArrayList<Feature> features = new ArrayList<Feature>();
            ArrayList<MapLabel> labels = new ArrayList<MapLabel>();
            this.setup.shapes = shapes;
            this.setup.features = features;
            this.setup.labels = labels;
            if (this.genInnButton.isSelected()) {
                t2 = MakeInn.generateInn(t2, shapes, features, (MapLayer)mapLayers.get(1), (MapLayer)mapLayers.get(2));
            } else if (this.genDungeonButton.isSelected()) {
                Map<String, ProceduralDungeonRoom> rooms = this.parseProceduralDungeonRoomsSetup();
                if (rooms.containsKey("ERROR")) {
                    StandardDialog.showDialog(this.getPrimaryStage(), "Error Parsing Room Configuration", "Error Parsing Room Configuration", rooms.get((Object)"ERROR").adjacentRooms.get(0), null, "Close");
                    return;
                }
                ProceduralDungeonGenerator dunGen = new ProceduralDungeonGenerator((Integer)this.seedSpinner2.getValue(), t2, shapes, features, labels, notes, (MapLayer)mapLayers.get(2), (MapLayer)mapLayers.get(1), (MapLayer)mapLayers.get(0));
                dunGen.generate(rooms);
            } else if (this.genDungeonSectionsButton.isSelected()) {
                ObservableList selected = this.sectionsListView.getSelectionModel().getSelectedItems();
                ObservableList excluded = this.sectionsExcludeListView.getSelectionModel().getSelectedItems();
                if (excluded.size() == SectionTypes.values().length) {
                    StandardDialog.showDialog(this.worldographer.getPrimaryStage(), "Battlemat Generator", "Incorrect Settings", "You can't exclude all the section types.", null, null);
                    return;
                }
                ArrayList checkselected = new ArrayList(selected);
                for (SectionTypes exclude : excluded) {
                    checkselected.remove((Object)exclude);
                }
                if (excluded.size() > 0 && checkselected.size() == 0) {
                    StandardDialog.showDialog(this.worldographer.getPrimaryStage(), "Battlemat Generator", "Incorrect Settings", "You can't exclude all the selected section types.", null, null);
                    return;
                }
                MakeDungeonGeomorph.generate((Integer)this.seedSpinner2.getValue(), (List<SectionTypes>)selected, (List<SectionTypes>)excluded, ((TextureType)this.wallTextureCombo.getSelectionModel().getSelectedItem()).toString(), ((TextureType)this.floorTextureCombo.getSelectionModel().getSelectedItem()).toString(), ((TextureType)this.deluxeFloorCombo.getSelectionModel().getSelectedItem()).toString(), t2, shapes, features, notes, (Integer)this.sectionsWideSpinner.getValue(), (Integer)this.sectionsHighSpinner.getValue(), (MapLayer)mapLayers.get(1), (MapLayer)mapLayers.get(2));
            } else if (this.genHouseButton.isSelected()) {
                t2 = MakeHouse.generateHouse(t2, shapes, features, (MapLayer)mapLayers.get(1), (MapLayer)mapLayers.get(2));
            } else if (this.genSmithButton.isSelected()) {
                t2 = MakeSmith.generateSmith(t2, shapes, features, (MapLayer)mapLayers.get(1), (MapLayer)mapLayers.get(2));
            } else if (this.genStoreButton.isSelected()) {
                t2 = MakeStore.generateStore(t2, shapes, features, (MapLayer)mapLayers.get(1), (MapLayer)mapLayers.get(2));
            } else if (this.genTavernButton.isSelected()) {
                t2 = MakeTavern.generateTavern(t2, shapes, features, (MapLayer)mapLayers.get(1), (MapLayer)mapLayers.get(2));
            } else if (this.genTowerButton.isSelected()) {
                StyledDialog d = new StyledDialog(true, (Window)this.worldographer.getPrimaryStage(), "Customize Tower (pt 1)");
                d.setHeaderText("Select Tower Options");
                GridPane gp = new GridPane();
                Label info = new Label("Select the number of levels above and below ground here,\nthen pick specific themes per level on the next screen.");
                gp.add((Node)info, 0, 0, 2, 1);
                gp.add((Node)new Label("Number of Levels Above Ground: "), 0, 1);
                FocusSpinner aboveLevelsSpinner = new FocusSpinner(1, 200, 2, 1);
                gp.add(aboveLevelsSpinner, 1, 1);
                gp.add((Node)new Label("Number of Levels Below Ground: "), 0, 2);
                FocusSpinner belowLevelsSpinner = new FocusSpinner(1, 200, 1, 1);
                gp.add(belowLevelsSpinner, 1, 2);
                gp.add((Node)new Label("Number of Levels Before Wrapping: "), 0, 3);
                FocusSpinner levelsBeforeWrapping = new FocusSpinner(1, 200, 2, 1);
                gp.add(levelsBeforeWrapping, 1, 3);
                gp.add((Node)new Label("Width of Each Level: "), 0, 4);
                FocusSpinner levelWidth = new FocusSpinner(4, 200, 5, 1);
                gp.add(levelWidth, 1, 4);
                gp.add((Node)new Label("Stair Location"), 0, 5);
                Object[] stairs = new String[]{"Upper Left", "Upper Right", "Lower Left", "Lower Right"};
                ComboBox stairChoice = new ComboBox(FXCollections.observableArrayList((Object[])stairs));
                int selectionS = (int)(Math.random() * (double)stairs.length);
                stairChoice.getSelectionModel().select(selectionS);
                gp.add((Node)stairChoice, 1, 5);
                gp.add((Node)new Label("Purpose"), 0, 6);
                Object[] purposes = new String[]{"Wizard Tower", "Guard Post"};
                ComboBox purpose = new ComboBox(FXCollections.observableArrayList((Object[])purposes));
                int selectionP = (int)(Math.random() * (double)purposes.length);
                purpose.getSelectionModel().select(selectionP);
                gp.add((Node)purpose, 1, 6);
                d.getDialogPane().setContent((Node)gp);
                ButtonType ok = new ButtonType("OK");
                d.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ok});
                Optional result = d.showAndWait();
                if (result.isPresent() && result.get() == ok) {
                    HashMap<String, Object> options = new HashMap<String, Object>();
                    StyledDialog d2 = new StyledDialog(true, (Window)this.worldographer.getPrimaryStage(), "Customize Tower (pt 2)");
                    d2.setHeaderText("Describe Tower Levels");
                    GridPane gp2 = new GridPane();
                    Label info2 = new Label("Select the purpose of each tower level:\n");
                    gp2.add((Node)info2, 0, 0, 2, 1);
                    Object[] levelTypes = new String[]{"Audience Hall", "Leader's Chambers", "Dining", "Library", "Storage", "Barracks", "Jail"};
                    int count = 0;
                    for (int i = ((Integer)aboveLevelsSpinner.getValue()).intValue(); i > 0; --i) {
                        int finalI = i;
                        Label levelLabel = new Label("Level " + i + ":");
                        levelLabel.setMaxWidth(100.0);
                        levelLabel.setMinWidth(100.0);
                        gp2.add((Node)levelLabel, 0, count + 1);
                        ComboBox levelType = new ComboBox(FXCollections.observableArrayList((Object[])levelTypes));
                        levelType.setMaxWidth(200.0);
                        levelType.setMinWidth(200.0);
                        levelType.setOnAction(t1 -> options.put("levelType" + finalI, levelType.getValue()));
                        int selection = (int)((double)(levelTypes.length - 1) * Math.random());
                        while (selection == 0) {
                            selection = (int)((double)(levelTypes.length - 1) * Math.random());
                        }
                        levelType.getSelectionModel().select(selection);
                        options.put("levelType" + finalI, levelType.getValue());
                        gp2.add((Node)levelType, 1, count + 1);
                        ++count;
                    }
                    int offset = (Integer)aboveLevelsSpinner.getValue();
                    for (int i = 1; i <= (Integer)belowLevelsSpinner.getValue(); ++i) {
                        int finalI = i;
                        Label levelLabel = new Label("Level -" + i + ":");
                        levelLabel.setMaxWidth(100.0);
                        levelLabel.setMinWidth(100.0);
                        gp2.add((Node)levelLabel, 0, i + 1 + offset);
                        ComboBox levelType = new ComboBox(FXCollections.observableArrayList((Object[])levelTypes));
                        levelType.setMaxWidth(200.0);
                        levelType.setMinWidth(200.0);
                        levelType.setOnAction(t12 -> options.put("levelType-" + finalI, levelType.getValue()));
                        int selection = (int)(3.0 * Math.random()) + levelTypes.length - 3;
                        levelType.getSelectionModel().select(selection);
                        options.put("levelType-" + finalI, levelType.getValue());
                        gp2.add((Node)levelType, 1, i + 1 + offset);
                    }
                    d2.getDialogPane().setContent((Node)gp2);
                    ButtonType ok2 = new ButtonType("OK");
                    d2.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ok2});
                    Optional result2 = d2.showAndWait();
                    if (result2.isPresent() && result2.get() == ok2) {
                        options.put("stair location", stairChoice.getValue());
                        options.put("levels above", aboveLevelsSpinner.getValue());
                        options.put("levels below", belowLevelsSpinner.getValue());
                        options.put("levels wrap", levelsBeforeWrapping.getValue());
                        options.put("level width", levelWidth.getValue());
                        options.put("purpose", purpose.getValue());
                        t2 = Tower.generateTower(t2, shapes, features, (MapLayer)mapLayers.get(1), (MapLayer)mapLayers.get(2), options);
                    }
                }
            }
            ArrayList<Rectangle> doorWindowBoundingBoxes = new ArrayList<Rectangle>();
            for (Feature f : this.setup.features) {
                double fh;
                double htFactor;
                Point2D fpt = f.getLocation(ViewLevel.BATTLEMAT);
                if (fpt == null || !f.getTypeName().toLowerCase().contains("door") && !f.getTypeName().toLowerCase().contains("window")) continue;
                double fw = f.getScaleFallbackType() * 1.5;
                if (fw < 5.0) {
                    fw = 10.0;
                }
                if ((htFactor = f.getScaleHt()) <= 0.0 && f.getType().getIconHeight() > 0.0) {
                    htFactor = f.getScale() * f.getType().getIconHeight() / f.getType().getIconSize();
                }
                if (htFactor <= 0.0) {
                    htFactor = f.getScaleHtFallbackType();
                }
                if (htFactor <= 0.0) {
                    htFactor = f.getScaleFallbackType();
                }
                if ((fh = htFactor * 1.5) < 10.0) {
                    fh = 10.0;
                }
                if (f.getRotate() > 45.0 && f.getRotate() < 135.0 || f.getRotate() > 225.0 && f.getRotate() < 315.0) {
                    double temp = fh;
                    fh = fw;
                    fw = temp;
                }
                double fx = fpt.getX() - fw;
                double fy = fpt.getY() - fh;
                doorWindowBoundingBoxes.add(new Rectangle(fx, fy, fw, fh));
            }
            MapLogic.breakUpARoomOrWallForDoorsWindows(this.setup.shapes, doorWindowBoundingBoxes);
            HashMap<String, LabelStyle> labelStyleMap = new HashMap<String, LabelStyle>();
            LabelStyle.setupLabelStyles(labelStyleMap, ViewLevel.BATTLEMAT);
            this.setup.labelStyles = labelStyleMap;
            HashMap<String, ShapeStyle> shapeStyleMap = new HashMap<String, ShapeStyle>();
            ShapeStyle.setupShapeStyles(shapeStyleMap, ViewLevel.BATTLEMAT);
            this.setup.shapeStyles = shapeStyleMap;
            terrainmap.put(ViewLevel.BATTLEMAT, t2);
            this.setup.battleMatTerrain = t2;
            this.setup.mapLayers.add(1, new MapLayer("Grid"));
            new StartNewMapDialog().startNewMap(this.setup, this.worldographer);
            this.popupStage.close();
        });
        GridPane grid = new GridPane();
        grid.setAlignment(Pos.CENTER_RIGHT);
        grid.setHgap(5.0);
        grid.setVgap(5.0);
        grid.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        grid.add((Node)generateButton, 0, 1);
        border.setBottom((Node)grid);
        ScrollPane sp = new ScrollPane();
        sp.setContent((Node)border);
        Pane root = new Pane(new Node[]{sp});
        int width = 800;
        int height = 640;
        this.setLocationAndPopup(root, width, height, this.worldographer, this.popupStage);
    }

    private Map<String, ProceduralDungeonRoom> parseProceduralDungeonRoomsSetup() {
        HashSet<String> allAdjacentRooms = new HashSet<String>();
        String configString = this.proceduralDungeonConfig.getText();
        String[] configLines = configString.split("\n");
        HashMap<String, ProceduralDungeonRoom> rooms = new HashMap<String, ProceduralDungeonRoom>();
        for (String configLine : configLines) {
            int keySplit = configLine.indexOf("=");
            if (keySplit < 1) {
                ArrayList<String> adjRooms = new ArrayList<String>();
                adjRooms.add("Each line must start with a room name followed by an equals sign.");
                ProceduralDungeonRoom room = new ProceduralDungeonRoom("ERROR", 0, 0, 0, 0, adjRooms);
                rooms.put("ERROR", room);
                return rooms;
            }
            String key = configLine.substring(0, keySplit);
            String[] values = configLine.substring(keySplit + 1).split(",");
            ArrayList<String> adjRooms = new ArrayList<String>();
            for (int i = 4; i < values.length; ++i) {
                adjRooms.add(values[i]);
                allAdjacentRooms.add(values[i]);
            }
            int minWidth = 0;
            int minHeight = 0;
            int maxWidth = 0;
            int maxHeight = 0;
            try {
                minWidth = Integer.valueOf(values[0]);
                minHeight = Integer.valueOf(values[1]);
                maxWidth = Integer.valueOf(values[2]);
                maxHeight = Integer.valueOf(values[3]);
            }
            catch (Exception e) {
                adjRooms.clear();
                adjRooms.add("After the equals sign, you must have 4 integers (whole numbers) separated by commas:\nminimum width, minimum height, maximum width, maximum height.");
                ProceduralDungeonRoom room = new ProceduralDungeonRoom("ERROR", 0, 0, 0, 0, adjRooms);
                rooms.put("ERROR", room);
                return rooms;
            }
            ProceduralDungeonRoom room = new ProceduralDungeonRoom(key, minWidth, minHeight, maxWidth, maxHeight, adjRooms);
            rooms.put(key, room);
        }
        if (!rooms.containsKey("Entrance")) {
            ArrayList<String> adjRooms = new ArrayList<String>();
            adjRooms.add("The configuration must have a line starting with 'Entrance=' (not including the ' marks).");
            ProceduralDungeonRoom room = new ProceduralDungeonRoom("ERROR", 0, 0, 0, 0, adjRooms);
            rooms.put("ERROR", room);
            return rooms;
        }
        for (String adjRoom : allAdjacentRooms) {
            if (adjRoom.endsWith("-")) {
                adjRoom = adjRoom.substring(0, adjRoom.length() - 1);
            }
            if (rooms.containsKey(adjRoom)) continue;
            ArrayList<String> adjRooms = new ArrayList<String>();
            adjRooms.add("Each adjacent room listed after the numbers on each line must have a row starting with that room name.\nThe first missing room is: " + adjRoom);
            ProceduralDungeonRoom room = new ProceduralDungeonRoom("ERROR", 0, 0, 0, 0, adjRooms);
            rooms.put("ERROR", room);
            return rooms;
        }
        return rooms;
    }

    private String makeSectionsIntoString(List<SectionTypes> sections) {
        StringBuilder sectionString = new StringBuilder();
        boolean first = true;
        for (SectionTypes st : sections) {
            if (!first) {
                sectionString.append(",");
            } else {
                first = false;
            }
            sectionString.append((Object)st);
        }
        return sectionString.toString();
    }

    private GridPane getSizePane() {
        GridPane grid = new GridPane();
        grid.setAlignment(Pos.CENTER);
        grid.setHgap(5.0);
        grid.setVgap(5.0);
        grid.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        grid.setAlignment(Pos.TOP_CENTER);
        grid.setMinWidth(160.0);
        Label titlelabel = new Label("Map Attributes");
        titlelabel.setFont(Font.font((String)"Tahoma", (FontWeight)FontWeight.NORMAL, (double)20.0));
        grid.add((Node)titlelabel, 0, 0, 2, 1);
        Label wideLabel = new Label("Tiles Wide:");
        grid.add((Node)wideLabel, 0, 1);
        this.hexesWideSpinner.getValueFactory().setValue((Object)Integer.parseInt(this.prefs.get("tilesWide", "100")));
        this.hexesWideSpinner.setMinWidth(70.0);
        this.hexesWideSpinner.setMaxWidth(70.0);
        grid.add(this.hexesWideSpinner, 1, 1);
        Label highLabel = new Label("Tiles High:");
        grid.add((Node)highLabel, 0, 2);
        this.hexesHighSpinner.getValueFactory().setValue((Object)Integer.parseInt(this.prefs.get("tilesHigh", "50")));
        this.hexesHighSpinner.setMinWidth(70.0);
        this.hexesHighSpinner.setMaxWidth(70.0);
        grid.add(this.hexesHighSpinner, 1, 2);
        Label widthLabel = new Label("Tile Width (pixels):");
        grid.add((Node)widthLabel, 0, 6);
        this.hexWidthSpinner.getValueFactory().setValue((Object)Double.valueOf(this.prefs.get("tileWidth", "75")));
        this.hexWidthSpinner.setMinWidth(70.0);
        this.hexWidthSpinner.setMaxWidth(70.0);
        this.hexWidthSpinner.setEditable(true);
        grid.add(this.hexWidthSpinner, 1, 6);
        Label heightLabel = new Label("Tile Height (pixels):");
        grid.add((Node)heightLabel, 0, 7);
        this.hexHeightSpinner.getValueFactory().setValue((Object)Double.valueOf(this.prefs.get("tileHeight", "75")));
        this.hexHeightSpinner.setMinWidth(70.0);
        this.hexHeightSpinner.setMaxWidth(70.0);
        this.hexHeightSpinner.setEditable(true);
        grid.add(this.hexHeightSpinner, 1, 7);
        return grid;
    }

    private Node getTerrainPane() {
        SectionTypes st;
        HBox mainbox = new HBox();
        VBox leftsidebox = new VBox();
        leftsidebox.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        leftsidebox.setAlignment(Pos.TOP_LEFT);
        mainbox.setMinWidth(400.0);
        ToggleGroup tggroup = new ToggleGroup();
        Label scenetitle = new Label("Battlemat Generation");
        scenetitle.setFont(Font.font((String)"Tahoma", (FontWeight)FontWeight.NORMAL, (double)20.0));
        leftsidebox.getChildren().add((Object)scenetitle);
        leftsidebox.getChildren().add((Object)this.blankMapButton);
        this.blankMapButton.setToggleGroup(tggroup);
        this.blankMapButton.setSelected(this.prefs.get("generate", "BLANK").equals("BLANK"));
        this.genHouseButton.setToggleGroup(tggroup);
        leftsidebox.getChildren().add((Object)this.genHouseButton);
        this.genHouseButton.setSelected(this.prefs.get("generate", "BLANK").equals("HOUSE"));
        if (!UserPrefs.FULL) {
            this.genInnButton.setDisable(true);
            this.genInnButton.setText("Generate Inn \n(Need Battlemat License)");
        }
        this.genInnButton.setToggleGroup(tggroup);
        leftsidebox.getChildren().add((Object)this.genInnButton);
        this.genInnButton.setSelected(this.prefs.get("generate", "BLANK").equals("INN"));
        if (!UserPrefs.FULL) {
            this.genSmithButton.setDisable(true);
            this.genSmithButton.setText("Generate Smith \n(Need Battlemat License)");
        }
        this.genSmithButton.setToggleGroup(tggroup);
        leftsidebox.getChildren().add((Object)this.genSmithButton);
        this.genSmithButton.setSelected(this.prefs.get("generate", "BLANK").equals("SMITH"));
        if (!UserPrefs.FULL) {
            this.genStoreButton.setDisable(true);
            this.genStoreButton.setText("Generate Store \n(Need Battlemat License)");
        }
        this.genStoreButton.setToggleGroup(tggroup);
        leftsidebox.getChildren().add((Object)this.genStoreButton);
        this.genStoreButton.setSelected(this.prefs.get("generate", "BLANK").equals("STORE"));
        if (!UserPrefs.FULL) {
            this.genTavernButton.setDisable(true);
            this.genTavernButton.setText("Generate Tavern \n(Need Battlemat License)");
        }
        this.genTavernButton.setToggleGroup(tggroup);
        leftsidebox.getChildren().add((Object)this.genTavernButton);
        this.genTavernButton.setSelected(this.prefs.get("generate", "BLANK").equals("TAVERN"));
        if (!UserPrefs.FULL) {
            this.genTowerButton.setDisable(true);
            this.genTowerButton.setText("Generate Tower \n(Need Battlemat License)");
        }
        this.genTowerButton.setToggleGroup(tggroup);
        leftsidebox.getChildren().add((Object)this.genTowerButton);
        this.genTowerButton.setSelected(this.prefs.get("generate", "BLANK").equals("TOWER"));
        VBox rightsidebox = new VBox();
        rightsidebox.setAlignment(Pos.CENTER);
        rightsidebox.setPadding(new Insets(28.0, 5.0, 5.0, 5.0));
        rightsidebox.setAlignment(Pos.TOP_LEFT);
        HBox gensectionsbox = new HBox();
        gensectionsbox.getChildren().add((Object)this.genDungeonSectionsButton);
        Button helpButton = new Button("", (Node)new ImageView(LoadImage.image("other_imgs/question.png")));
        gensectionsbox.getChildren().add((Object)helpButton);
        helpButton.setPadding(new Insets(1.0, 1.0, 1.0, 1.0));
        helpButton.setOnAction(event -> {
            Dialog d = new Dialog();
            d.setTitle("Generate Dungeon By Sections");
            d.setHeaderText("Instructions");
            WebView view = new WebView();
            view.setMinSize(300.0, 300.0);
            view.setPrefSize(550.0, 350.0);
            String configureText = "<p>Generating a dungeon via sections will add a number of 20x20 sections to the dungeons similar (but not the same) as DungeonMorphs by Inkwell Ideas.</p><ul><li><b># Sections Wide &amp; High:</b> These fields let you specify the map size.  Because each section is 20x20, if you set your map up as 5x4, your map will be 100x80 tiles.</li><li><b>Sections Required &amp; Exclude:</b> Each section has a design which is the purpose of that dungeon area. You can use these multi-select boxes to either require specific sections (if there are enough spots) which will be randomly used or ensure some are not included at all. Note: This is a pro feature--these boxes are disabled in the free version.</li><li><b>Wall, Floor, and Deluxe Floor Texture:</b> These fields are used for the lines &amp; fills of the dungeon.</li><li><b>Random Seed:</b> This generator lets you give it a random seed.  Giving it the same seed with the same other settings will result in the same dungeon.  This will not be true from one update to another if we make changes to the generator.</li></ul>";
            WebEngine textengine = view.getEngine();
            textengine.loadContent("<style type=\"text/css\">p {font-family: Futura,Trebuchet MS,Arial,sans-serif; font-size:0.875em; padding: 0; margin: 0} h1,h2,h3 {font-family: Futura,Trebuchet MS,Arial,sans-serif; padding: 0; margin: 0}</style>" + configureText);
            d.getDialogPane().setContent((Node)view);
            ButtonType yes = new ButtonType("OK");
            d.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{yes});
            d.showAndWait();
        });
        this.genDungeonSectionsButton.setToggleGroup(tggroup);
        String mapType = this.prefs.get("generate", "BLANK");
        this.genDungeonSectionsButton.setSelected(mapType.equals("DUNGEON SECTIONS"));
        rightsidebox.getChildren().add((Object)gensectionsbox);
        GridPane innergrid3 = new GridPane();
        innergrid3.setAlignment(Pos.CENTER);
        innergrid3.setHgap(3.0);
        innergrid3.setVgap(3.0);
        innergrid3.setPadding(new Insets(3.0, 3.0, 3.0, 23.0));
        innergrid3.add((Node)new Label("# Sections Wide:"), 0, 0);
        innergrid3.add(this.sectionsWideSpinner, 1, 0);
        this.sectionsWideSpinner.setMinWidth(80.0);
        this.sectionsWideSpinner.setMaxWidth(80.0);
        this.sectionsWideSpinner.getValueFactory().setValue((Object)this.prefs.getInt("sectionsWide", 5));
        innergrid3.add((Node)new Label("# Sections High:"), 0, 1);
        innergrid3.add(this.sectionsHighSpinner, 1, 1);
        this.sectionsHighSpinner.setMinWidth(80.0);
        this.sectionsHighSpinner.setMaxWidth(80.0);
        this.sectionsHighSpinner.getValueFactory().setValue((Object)this.prefs.getInt("sectionsHigh", 5));
        innergrid3.add((Node)new Label("Sections Required:"), 0, 2);
        String sections = this.prefs.get("sectionsRequired", "");
        for (String s : sections.split(",")) {
            if (s.trim().equals("")) continue;
            s = s.trim().replaceAll(" ", "_");
            st = SectionTypes.valueOf(s);
            this.sectionsListView.getSelectionModel().select((Object)st);
        }
        this.sectionsListView.setMaxHeight(80.0);
        this.sectionsListView.setMinWidth(120.0);
        this.sectionsListView.setMaxWidth(120.0);
        innergrid3.add(this.sectionsListView, 0, 3);
        innergrid3.add((Node)new Label("To Exclude:"), 1, 2);
        sections = this.prefs.get("sectionsExcluded", "");
        for (String s : sections.split(",")) {
            if (s.trim().equals("")) continue;
            s = s.trim().replaceAll(" ", "_");
            st = SectionTypes.valueOf(s);
            this.sectionsExcludeListView.getSelectionModel().select((Object)st);
        }
        this.sectionsExcludeListView.setMaxHeight(80.0);
        this.sectionsExcludeListView.setMinWidth(120.0);
        this.sectionsExcludeListView.setMaxWidth(120.0);
        if (!UserPrefs.FULL) {
            this.sectionsListView.setDisable(true);
            this.sectionsExcludeListView.setDisable(true);
        }
        innergrid3.add(this.sectionsExcludeListView, 1, 3);
        innergrid3.add((Node)new Label("Wall Texture:"), 0, 4);
        ObservableList texturesList = FXCollections.observableArrayList(TextureType.ALL_TEXTURES.values());
        this.wallTextureCombo = new ComboBox(texturesList);
        this.wallTextureCombo.getSelectionModel().select((Object)TextureType.ALL_TEXTURES.get("Rock Dark"));
        String wallTextureName = this.prefs.get("wallTexture", "Rock Dark");
        if (TextureType.ALL_TEXTURES.get(wallTextureName) != null) {
            this.wallTextureCombo.getSelectionModel().select((Object)TextureType.ALL_TEXTURES.get(wallTextureName));
        }
        innergrid3.add(this.wallTextureCombo, 1, 4);
        this.floorTextureCombo = new ComboBox(texturesList);
        this.floorTextureCombo.getSelectionModel().select((Object)TextureType.ALL_TEXTURES.get("Pavers Light"));
        String floorTextureName = this.prefs.get("floorTexture", "Pavers Light");
        if (TextureType.ALL_TEXTURES.get(floorTextureName) != null) {
            this.floorTextureCombo.getSelectionModel().select((Object)TextureType.ALL_TEXTURES.get(floorTextureName));
        }
        innergrid3.add((Node)new Label("Floor Texture:"), 0, 5);
        innergrid3.add(this.floorTextureCombo, 1, 5);
        this.deluxeFloorCombo = new ComboBox(texturesList);
        this.deluxeFloorCombo.getSelectionModel().select((Object)TextureType.ALL_TEXTURES.get("Tile Deluxe"));
        String floorDeluxeTextureName = this.prefs.get("floorDeluxeTexture", "Tile Deluxe");
        if (TextureType.ALL_TEXTURES.get(floorDeluxeTextureName) != null) {
            this.deluxeFloorCombo.getSelectionModel().select((Object)TextureType.ALL_TEXTURES.get(floorDeluxeTextureName));
        }
        innergrid3.add((Node)new Label("Deluxe Fl. Texture:"), 0, 6);
        innergrid3.add(this.deluxeFloorCombo, 1, 6);
        innergrid3.add((Node)new Label("Random Seed:"), 0, 8);
        innergrid3.add(this.seedSpinner2, 1, 8);
        this.seedSpinner2.setMinWidth(80.0);
        this.seedSpinner2.setMaxWidth(80.0);
        rightsidebox.getChildren().add((Object)innergrid3);
        this.genDungeonButton.setToggleGroup(tggroup);
        this.genDungeonButton.setSelected(this.prefs.get("generate", "BLANK").equals("DUNGEON"));
        rightsidebox.getChildren().add((Object)this.genDungeonButton);
        GridPane innergrid2 = new GridPane();
        innergrid2.setAlignment(Pos.CENTER);
        innergrid2.setHgap(5.0);
        innergrid2.setVgap(5.0);
        innergrid2.setPadding(new Insets(3.0, 3.0, 3.0, 23.0));
        innergrid2.add((Node)new Label("Data Setup"), 0, 0);
        Button helpRoomsButton = new Button("", (Node)new ImageView(LoadImage.image("other_imgs/question.png")));
        gensectionsbox.getChildren().add((Object)helpRoomsButton);
        helpRoomsButton.setPadding(new Insets(1.0, 1.0, 1.0, 1.0));
        helpRoomsButton.setOnAction(event -> {
            Dialog d = new Dialog();
            d.setTitle("Generate Dungeon By Rooms");
            d.setHeaderText("Instructions");
            WebView view = new WebView();
            view.setMinSize(300.0, 300.0);
            view.setPrefSize(550.0, 350.0);
            String configureText = "<p>Generating a dungeon via rooms will add rooms to the map.</p><ul><li>The first line should start with 'Entrance=' then list the minimum width and height in squares then maximum of the entrance chamber, followed by the rooms that lead off from it.</li><li>Each room that leads off from the Entrance must have its own line starting with that room name and following the same format. Ex: Hall=2,2,8,8,Hall2,Monks Quarters...</li><li>And each room listed in that line will need its own line, and so on.</li><li>Any room with 'Hall' in the name will be 1 or 2 squares wide or tall even if they are '2,2,8,8'. So it will never be 4x4 for example.</li><li>Any room ending it '-' when referenced in another room's line will be optional--sometimes the algorithm will add it, sometimes not. But do not add the '-' for the beginning of a line.</li><li>Note that the 'Entrance' created won't have an outside door or stairs going up. You should add that as appropriate.<li>Please don't try to make infinite loops. :)</li></ul>";
            WebEngine textEngine = view.getEngine();
            textEngine.loadContent("<style type=\"text/css\">p {font-family: Futura,Trebuchet MS,Arial,sans-serif; font-size:0.875em; padding: 0; margin: 0} h1,h2,h3 {font-family: Futura,Trebuchet MS,Arial,sans-serif; padding: 0; margin: 0}</style>" + configureText);
            d.getDialogPane().setContent((Node)view);
            ButtonType yes = new ButtonType("OK");
            d.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{yes});
            d.showAndWait();
        });
        innergrid2.add((Node)helpRoomsButton, 1, 0);
        this.proceduralDungeonConfig.setText("Entrance=2,2,4,4,Shrine-,Shrine2-,Hall\nShrine=2,2,4,4\nShrine2=2,2,4,4\nHall=2,2,8,8,Hall2,Monks Quarters-,Library-,Study-\nHall2=2,2,8,8,Crypt1-,Crypt2,Great Crypt\nCrypt1=3,3,5,5\nGreat Crypt=4,4,6,6\nCrypt2=3,3,5,5,Secret Exit-\nMonks Quarters=3,3,5,5\nLibrary=3,3,5,5\nStudy=2,2,4,4\nSecret Exit=1,2,1,2");
        this.proceduralDungeonConfig.setMaxWidth(300.0);
        this.proceduralDungeonConfig.setMaxHeight(120.0);
        innergrid2.add((Node)this.proceduralDungeonConfig, 0, 1, 2, 2);
        innergrid2.add((Node)new Label("Random Seed:"), 0, 4);
        innergrid2.add(this.seedSpinner, 1, 4);
        this.seedSpinner.setMinWidth(80.0);
        this.seedSpinner.setMaxWidth(80.0);
        rightsidebox.getChildren().add((Object)innergrid2);
        mainbox.getChildren().add((Object)leftsidebox);
        mainbox.getChildren().add((Object)rightsidebox);
        return mainbox;
    }

    public Stage getPrimaryStage() {
        return this.popupStage;
    }

    public static enum SectionTypes {
        Entrance,
        Dining_Area,
        Great_Hall,
        Living_Area,
        Prison_Block,
        Random_Rooms_1,
        Random_Rooms_2,
        Random_Rooms_3,
        Square_Rooms,
        Throne_Room,
        Worship_Area,
        Vaults;


        public String toString() {
            String s = super.toString();
            s = s.replaceAll("_", " ");
            return s;
        }
    }
}

