/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.ui.setup;

import com.inkwellideas.ographer.data.HexOrientation;
import com.inkwellideas.ographer.data.LabelStyle;
import com.inkwellideas.ographer.data.ViewLevel;
import com.inkwellideas.ographer.map.MapDataSetup;
import com.inkwellideas.ographer.map.MapLogic;
import com.inkwellideas.ographer.map.MapProjection;
import com.inkwellideas.ographer.map.MapShape;
import com.inkwellideas.ographer.map.Terrain;
import com.inkwellideas.ographer.model.Feature;
import com.inkwellideas.ographer.model.Note;
import com.inkwellideas.ographer.model.ShapeStyle;
import com.inkwellideas.ographer.model.TextureType;
import com.inkwellideas.ographer.ui.Worldographer;
import com.inkwellideas.ographer.ui.dialog.StartNewCityDialog;
import com.inkwellideas.ographer.ui.widget.FocusSpinner;
import com.inkwellideas.ographer.ui.widget.PopupStage;
import com.inkwellideas.ographer.util.SafePreferences;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Spinner;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.ImagePattern;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Polygon;
import javafx.scene.shape.Shape;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.stage.Stage;

public class SetupCityScreen
extends PopupStage {
    private Stage popupStage;
    private final Worldographer worldographer;
    private final Spinner<Integer> hexesWideSpinner = new FocusSpinner<Integer>(1, 10000, 100);
    private final Spinner<Integer> hexesHighSpinner = new FocusSpinner<Integer>(1, 10000, 50);
    private final Spinner<Double> hexWidthSpinner = new FocusSpinner<Double>(1.0, 100000.0, 46.18);
    private final Spinner<Double> hexHeightSpinner = new FocusSpinner<Double>(1.0, 100000.0, 40.0);
    private final Spinner<Integer> populationSpinner = new FocusSpinner<Integer>(1, 10000000, 5000);
    private final Spinner<Integer> wallTowerSpinner = new FocusSpinner<Integer>(1, 100, 8);
    private final Spinner<Integer> wallRadiusSpinner = new FocusSpinner<Integer>(1, 1000, 15);
    private final CheckBox useSuggestedPixelSizes = new CheckBox("Use Suggested Pixel Sizes:");
    private RadioButton backgroundTerrainRB;
    private RadioButton backgroundTextureRB;
    private RadioButton roadTextureRB;
    private final ComboBox<String> terrainCombo = new ComboBox(FXCollections.observableArrayList(Terrain.DEFAULT_TERRAIN.keySet()));
    private ComboBox<TextureType> backgroundTextureCombo;
    private ColorPicker backgroundColorPicker;
    private ComboBox<TextureType> roadTextureCombo;
    private ColorPicker roadColorPicker;
    final String[] clocks = new String[]{"12:00", "1:00", "2:00", "3:00", "4:00", "5:00", "6:00", "7:00", "8:00", "9:00", "10:00", "11:00"};
    private final ComboBox<String> mainRoad1StartCombo = new ComboBox(FXCollections.observableArrayList((Object[])this.clocks));
    private final ComboBox<String> mainRoad1EndCombo = new ComboBox(FXCollections.observableArrayList((Object[])this.clocks));
    private final ComboBox<String> mainRoad2StartCombo = new ComboBox(FXCollections.observableArrayList((Object[])this.clocks));
    private final ComboBox<String> mainRoad2EndCombo = new ComboBox(FXCollections.observableArrayList((Object[])this.clocks));
    private final Spinner<Double> windinessSpinner = new FocusSpinner<Double>(0.0, 5.0, 0.1);
    private final CheckBox makeMainRoadsPerpendicular = new CheckBox("Road 2 Perpendicular");
    private final ComboBox<String> coastStartCombo = new ComboBox(FXCollections.observableArrayList((Object[])this.clocks));
    private final ComboBox<String> coastEndCombo = new ComboBox(FXCollections.observableArrayList((Object[])this.clocks));
    private final CheckBox hasCoast = new CheckBox("Has Coast:");
    private final ComboBox<String> riverStartCombo = new ComboBox(FXCollections.observableArrayList((Object[])this.clocks));
    private final ComboBox<String> riverEndCombo = new ComboBox(FXCollections.observableArrayList((Object[])this.clocks));
    private final CheckBox hasRiver = new CheckBox("Has River:");
    private final CheckBox denseCB = new CheckBox("Dense Buildings");
    private final Spinner<Integer> extraPushBackSpinner = new FocusSpinner<Integer>(0, 400, 20);
    private final CheckBox hasWall = new CheckBox("Has Wall:");
    public static final String[] buildingLabelOptions = new String[]{"Name", "Coordinate", "Name & Coord", "None"};
    private final ComboBox<String> buildingLabelCombo = new ComboBox(FXCollections.observableArrayList((Object[])buildingLabelOptions));
    private final ComboBox<LAYOUTS> streetLayoutCombo = new ComboBox(FXCollections.observableArrayList((Object[])LAYOUTS.values()));
    private Spinner<Integer> numStreetsSpinner;
    private final Spinner<Integer> skipChanceSpinner = new FocusSpinner<Integer>(1, 100, 15);
    private final Spinner<Double> streetDistanceSpinner = new FocusSpinner<Double>(1.0, 100.0, 4.0);
    private final Spinner<Integer> deciduousSpinner = new FocusSpinner<Integer>(0, 100, 20);
    private final Spinner<Integer> evergreenSpinner = new FocusSpinner<Integer>(0, 100, 5);
    private final Spinner<Integer> tropicalSpinner = new FocusSpinner<Integer>(0, 100, 0);
    private final ComboBox<HexOrientation> orientationCombo = new ComboBox();
    private final ComboBox<MapProjection> projectionCombo = new ComboBox();
    SafePreferences prefs = new SafePreferences("com/inkwellideas/worldographer2025");
    CheckBox blankMapCheckBox;

    public SetupCityScreen(Worldographer ms) {
        this.worldographer = ms;
    }

    public void start(Stage popStage) {
        this.popupStage = popStage;
        this.popupStage.setTitle("Worldographer City/Town/Village Setup Screen");
        ScrollPane sp = new ScrollPane();
        GridPane grid = new GridPane();
        grid.setPadding(new Insets(1.0, 1.0, 1.0, 1.0));
        grid.add((Node)this.getSizePane(), 0, 0);
        grid.add((Node)this.getSettlementGenPane(), 1, 0);
        Button generateButton = new Button("Generate Map");
        generateButton.setOnAction(e -> {
            String ter = "Border Only";
            if (this.backgroundTerrainRB.isSelected()) {
                ter = (String)this.terrainCombo.getSelectionModel().getSelectedItem();
            }
            Terrain[][] t = new Terrain[((Integer)this.hexesWideSpinner.getValue()).intValue()][((Integer)this.hexesHighSpinner.getValue()).intValue()];
            MapDataSetup setup = new MapDataSetup();
            for (int y = 0; y < t[0].length; ++y) {
                for (int x = 0; x < t.length; ++x) {
                    t[x][y] = new Terrain(ter, true);
                }
            }
            this.worldographer.addStatus("Terrain created.");
            setup.setTerrainByViewLevel(ViewLevel.SETTLEMENT, t);
            setup.hexWidth = (Double)this.hexWidthSpinner.getValue();
            setup.hexHeight = (Double)this.hexHeightSpinner.getValue();
            setup.hexOrientation = (HexOrientation)((Object)((Object)this.orientationCombo.getValue()));
            setup.mapProjection = MapProjection.FLAT;
            setup.generateOneTerrain = true;
            setup.solidTerrain = (String)this.terrainCombo.getSelectionModel().getSelectedItem();
            setup.notes = new HashSet<Note>();
            setup.numNations = 1;
            HashMap<String, LabelStyle> labelStyleMap = new HashMap<String, LabelStyle>();
            LabelStyle.setupLabelStyles(labelStyleMap, ViewLevel.SETTLEMENT);
            setup.labelStyles = labelStyleMap;
            HashMap<String, ShapeStyle> shapeStyleMap = new HashMap<String, ShapeStyle>();
            ShapeStyle.setupShapeStyles(shapeStyleMap, ViewLevel.SETTLEMENT);
            setup.shapeStyles = shapeStyleMap;
            this.worldographer.addStatus("Label & shape styles created.");
            setup.city.population = (Integer)this.populationSpinner.getValue();
            setup.city.dense = this.denseCB.isSelected();
            setup.city.extraPushBack = (Integer)this.extraPushBackSpinner.getValue();
            setup.city.hasCoast = this.hasCoast.isSelected();
            setup.city.coastStart = this.coastStartCombo.getSelectionModel().getSelectedIndex();
            setup.city.coastEnd = this.coastEndCombo.getSelectionModel().getSelectedIndex();
            setup.city.hasRiver = this.hasRiver.isSelected();
            setup.city.riverStart = this.riverStartCombo.getSelectionModel().getSelectedIndex();
            setup.city.riverEnd = this.riverEndCombo.getSelectionModel().getSelectedIndex();
            setup.city.mainRoad1Start = (String)this.mainRoad1StartCombo.getSelectionModel().getSelectedItem();
            setup.city.mainRoad1End = (String)this.mainRoad1EndCombo.getSelectionModel().getSelectedItem();
            setup.city.mainRoad2Start = (String)this.mainRoad2StartCombo.getSelectionModel().getSelectedItem();
            setup.city.mainRoad2End = (String)this.mainRoad2EndCombo.getSelectionModel().getSelectedItem();
            setup.city.mainRoadsPerpendicular = this.makeMainRoadsPerpendicular.isSelected();
            setup.city.windiness = (Double)this.windinessSpinner.getValue();
            setup.city.skipChance = (Integer)this.skipChanceSpinner.getValue();
            setup.city.streetDistance = (Double)this.streetDistanceSpinner.getValue();
            setup.city.streetLayout = (LAYOUTS)((Object)((Object)this.streetLayoutCombo.getSelectionModel().getSelectedItem()));
            setup.city.buildingLabels = (String)this.buildingLabelCombo.getSelectionModel().getSelectedItem();
            setup.city.numStreets = (Integer)this.numStreetsSpinner.getValue();
            setup.city.hasWall = this.hasWall.isSelected();
            setup.city.wallTowers = (Integer)this.wallTowerSpinner.getValue();
            setup.city.wallRadius = (Integer)this.wallRadiusSpinner.getValue();
            setup.city.dontGenerate = this.blankMapCheckBox.isSelected();
            setup.city.deciduous = (Integer)this.deciduousSpinner.getValue();
            setup.city.tropical = (Integer)this.tropicalSpinner.getValue();
            setup.city.evergreen = (Integer)this.evergreenSpinner.getValue();
            setup.city.bgType = this.backgroundTextureRB.isSelected() ? "texture" : (this.backgroundTerrainRB.isSelected() ? "terrain" : "color");
            setup.city.bgTexture = (TextureType)this.backgroundTextureCombo.getValue();
            setup.bgColor = (Color)this.backgroundColorPicker.getValue();
            setup.city.roadtype = this.roadTextureRB.isSelected() ? "texture" : "color";
            setup.city.roadtexture = (TextureType)this.roadTextureCombo.getValue();
            setup.city.roadcolor = (Color)this.roadColorPicker.getValue();
            this.worldographer.addStatus("Data setup complete.");
            this.prefs.put("hexOrientation", String.valueOf(this.orientationCombo.getValue()));
            this.prefs.put("mapProjection", String.valueOf(this.projectionCombo.getSelectionModel().getSelectedItem()));
            this.prefs.put("useSuggestedPixelSizes", "" + this.useSuggestedPixelSizes.isSelected());
            this.prefs.put("hexWidth", String.valueOf(this.hexWidthSpinner.getValue()));
            this.prefs.put("hexHeight", String.valueOf(this.hexHeightSpinner.getValue()));
            this.prefs.put("solidTerrain", ter);
            this.prefs.putInt("population", (Integer)this.populationSpinner.getValue());
            this.prefs.putBoolean("dense", this.denseCB.isSelected());
            this.prefs.putInt("extraPushBack", (Integer)this.extraPushBackSpinner.getValue());
            this.prefs.putBoolean("hasCoast", this.hasCoast.isSelected());
            this.prefs.putInt("coastStart", this.coastStartCombo.getSelectionModel().getSelectedIndex());
            this.prefs.putInt("coastEnd", this.coastEndCombo.getSelectionModel().getSelectedIndex());
            this.prefs.putBoolean("hasRiver", this.hasRiver.isSelected());
            this.prefs.putInt("riverStart", this.riverStartCombo.getSelectionModel().getSelectedIndex());
            this.prefs.putInt("riverEnd", this.riverEndCombo.getSelectionModel().getSelectedIndex());
            this.prefs.put("mainRoad1Start", (String)this.mainRoad1StartCombo.getSelectionModel().getSelectedItem());
            this.prefs.put("mainRoad1End", (String)this.mainRoad1EndCombo.getSelectionModel().getSelectedItem());
            this.prefs.put("mainRoad2Start", (String)this.mainRoad2StartCombo.getSelectionModel().getSelectedItem());
            this.prefs.put("mainRoad2End", (String)this.mainRoad2EndCombo.getSelectionModel().getSelectedItem());
            this.prefs.putBoolean("mainRoadsPerpendicular", this.makeMainRoadsPerpendicular.isSelected());
            this.prefs.putDouble("windiness", (Double)this.windinessSpinner.getValue());
            this.prefs.putInt("skipChance", (Integer)this.skipChanceSpinner.getValue());
            this.prefs.putDouble("streetDistance", (Double)this.streetDistanceSpinner.getValue());
            this.prefs.put("streetLayout", ((LAYOUTS)((Object)((Object)this.streetLayoutCombo.getSelectionModel().getSelectedItem()))).name());
            this.prefs.put("buildingLabels", (String)this.buildingLabelCombo.getSelectionModel().getSelectedItem());
            this.prefs.putInt("numStreets", (Integer)this.numStreetsSpinner.getValue());
            this.prefs.putBoolean("hasWall", this.hasWall.isSelected());
            this.prefs.putInt("wallTowers", (Integer)this.wallTowerSpinner.getValue());
            this.prefs.putInt("wallRadius", (Integer)this.wallRadiusSpinner.getValue());
            this.prefs.putBoolean("dontGenerate", this.blankMapCheckBox.isSelected());
            this.prefs.putInt("deciduous", (Integer)this.deciduousSpinner.getValue());
            this.prefs.putInt("tropical", (Integer)this.tropicalSpinner.getValue());
            this.prefs.putInt("evergreen", (Integer)this.evergreenSpinner.getValue());
            this.prefs.put("bgtype", this.backgroundTextureRB.isSelected() ? "texture" : (this.backgroundTerrainRB.isSelected() ? "terrain" : "color"));
            this.prefs.put("bgtexture", ((TextureType)this.backgroundTextureCombo.getValue()).getType());
            this.prefs.put("bgcolor", ((Color)this.backgroundColorPicker.getValue()).getRed() + "," + ((Color)this.backgroundColorPicker.getValue()).getGreen() + "," + ((Color)this.backgroundColorPicker.getValue()).getBlue());
            this.prefs.put("roadtype", this.roadTextureRB.isSelected() ? "texture" : "color");
            this.prefs.put("roadtexture", ((TextureType)this.roadTextureCombo.getValue()).getType());
            this.prefs.put("roadcolor", ((Color)this.roadColorPicker.getValue()).getRed() + "," + ((Color)this.roadColorPicker.getValue()).getGreen() + "," + ((Color)this.roadColorPicker.getValue()).getBlue());
            this.prefs.put("hexesWide", String.valueOf(this.hexesWideSpinner.getValue()));
            this.prefs.put("hexesHigh", String.valueOf(this.hexesHighSpinner.getValue()));
            this.prefs.put("initialView", String.valueOf((Object)ViewLevel.SETTLEMENT));
            this.worldographer.addStatus("Preferences stored.");
            setup.settlementTerrain = t;
            MapLogic.setElevations(t, (HexOrientation)((Object)((Object)this.orientationCombo.getValue())));
            ArrayList<MapShape> shapes = new ArrayList<MapShape>();
            ArrayList<Feature> features = new ArrayList<Feature>();
            setup.shapes = shapes;
            setup.features = features;
            this.worldographer.addStatus("Starting city map.");
            new StartNewCityDialog().startNewCityMap(setup, this.worldographer);
            if (!this.backgroundTerrainRB.isSelected()) {
                Polygon bgpoly = new Polygon();
                double width = 300.0 * (double)((Integer)this.hexesWideSpinner.getValue()).intValue();
                double height = 300.0 * (double)((Integer)this.hexesHighSpinner.getValue()).intValue();
                if (this.orientationCombo.getValue() == HexOrientation.COLUMNS) {
                    width = width * 3.0 / 4.0 + 75.0;
                    height += 150.0;
                } else if (this.orientationCombo.getValue() == HexOrientation.ROWS) {
                    height = height * 3.0 / 4.0 + 75.0;
                    width += 150.0;
                }
                bgpoly.getPoints().addAll((Object[])new Double[]{0.0, 0.0, width, 0.0, width, height, 0.0, height});
                SetupCityScreen setupCityScreen = this;
                MapShape bg = new MapShape(ViewLevel.SETTLEMENT, ViewLevel.SETTLEMENT, (Shape)bgpoly, MapShape.CreationType.BASIC, MapShape.StrokeType.SIMPLE, false, "background", 0.0, 0.0, 0.0, 0.0, true, true, true, true, setupCityScreen.worldographer.getMapUI().getMapData().getMapLayer("Below All"));
                bgpoly.setStrokeWidth(0.0);
                if (this.backgroundTextureRB.isSelected()) {
                    bg.setFillTexture((TextureType)this.backgroundTextureCombo.getValue());
                    ImagePattern newtexture = new ImagePattern(((TextureType)this.backgroundTextureCombo.getValue()).getIcon(), 0.0, 0.0, 50.0, 25.0, false);
                    bgpoly.setFill((Paint)newtexture);
                } else {
                    bgpoly.setFill((Paint)this.backgroundColorPicker.getValue());
                }
                shapes.add(0, bg);
                this.worldographer.addStatus("background Shape created.");
            }
            this.popupStage.close();
        });
        HBox buttons = new HBox();
        buttons.setAlignment(Pos.CENTER);
        buttons.getChildren().add((Object)generateButton);
        grid.add((Node)buttons, 1, 1);
        sp.setContent((Node)grid);
        Pane root = new Pane(new Node[]{sp});
        int width = 900;
        int height = 600;
        this.setLocationAndPopup(root, width, height, this.worldographer, this.popupStage);
    }

    private GridPane getSizePane() {
        GridPane grid = new GridPane();
        grid.setAlignment(Pos.CENTER);
        grid.setHgap(3.0);
        grid.setVgap(3.0);
        grid.setPadding(new Insets(3.0));
        grid.setAlignment(Pos.TOP_CENTER);
        Label titlelabel = new Label("Map Attributes");
        titlelabel.setFont(Font.font((String)"Tahoma", (FontWeight)FontWeight.NORMAL, (double)20.0));
        grid.add((Node)titlelabel, 0, 0, 2, 1);
        Label orientationLabel = new Label("Hex Orientation:");
        orientationLabel.setMinWidth(100.0);
        this.orientationCombo.getItems().addAll((Object[])new HexOrientation[]{HexOrientation.COLUMNS, HexOrientation.ROWS});
        HexOrientation hor = HexOrientation.COLUMNS;
        String ho = this.prefs.get("hexOrientation", "Columns Line Up");
        if ("Rows Line Up".equals(ho)) {
            hor = HexOrientation.ROWS;
        }
        this.orientationCombo.setValue((Object)hor);
        this.orientationCombo.setMinWidth(100.0);
        this.orientationCombo.valueProperty().addListener(event -> this.updatePixelSizes());
        grid.add((Node)orientationLabel, 0, 1);
        grid.add(this.orientationCombo, 1, 1);
        GridPane orientgrid = new GridPane();
        orientgrid.setAlignment(Pos.CENTER);
        orientgrid.setHgap(0.0);
        orientgrid.setVgap(0.0);
        orientgrid.setPadding(new Insets(0.0, 0.0, 0.0, 0.0));
        orientgrid.setAlignment(Pos.TOP_CENTER);
        orientgrid.add((Node)orientationLabel, 0, 1);
        orientgrid.add(this.orientationCombo, 1, 1);
        grid.add((Node)orientgrid, 0, 1, 2, 1);
        Label wideLabel = new Label("Hexes Wide:");
        grid.add((Node)wideLabel, 0, 3);
        this.hexesWideSpinner.setMaxWidth(80.0);
        this.hexesWideSpinner.getValueFactory().setValue((Object)Integer.parseInt(this.prefs.get("hexesWide", "100")));
        grid.add(this.hexesWideSpinner, 1, 3);
        Label highLabel = new Label("Hexes High:");
        grid.add((Node)highLabel, 0, 4);
        this.hexesHighSpinner.setMaxWidth(80.0);
        this.hexesHighSpinner.getValueFactory().setValue((Object)Integer.parseInt(this.prefs.get("hexesHigh", "50")));
        grid.add(this.hexesHighSpinner, 1, 4);
        Label widthLabel = new Label("Hex Width (pixels):");
        grid.add((Node)widthLabel, 0, 6);
        this.hexWidthSpinner.getValueFactory().setValue((Object)Double.valueOf(this.prefs.get("hexWidth", "46.18")));
        this.hexWidthSpinner.setMinWidth(80.0);
        this.hexWidthSpinner.setMaxWidth(80.0);
        this.hexWidthSpinner.setEditable(true);
        grid.add(this.hexWidthSpinner, 1, 6);
        Label heightLabel = new Label("Hex Height (pixels):");
        grid.add((Node)heightLabel, 0, 7);
        this.hexHeightSpinner.getValueFactory().setValue((Object)Double.valueOf(this.prefs.get("hexHeight", "40")));
        this.hexHeightSpinner.setMinWidth(80.0);
        this.hexHeightSpinner.setMaxWidth(80.0);
        this.hexHeightSpinner.setEditable(true);
        grid.add(this.hexHeightSpinner, 1, 7);
        this.useSuggestedPixelSizes.setSelected(Boolean.parseBoolean(this.prefs.get("useSuggestedPixelSizes", "true")));
        this.useSuggestedPixelSizes.setOnAction(event -> this.updatePixelSizes());
        grid.add((Node)this.useSuggestedPixelSizes, 0, 8, 2, 1);
        Label tipsLabel = new Label("Suggestions:");
        grid.add((Node)tipsLabel, 0, 9, 2, 1);
        Label tips1Label = new Label("* For true hexagons and columns orientation,\n   use width of 46.18 and height of 40.\n* For true hexagons and rows orientation,\n   use with of 40 and height of 46.18.\n* You can change these while viewing.");
        tips1Label.setStyle("-fx-font-size: 10px");
        grid.add((Node)tips1Label, 0, 10, 2, 1);
        return grid;
    }

    private void updatePixelSizes() {
        if (this.useSuggestedPixelSizes.isSelected()) {
            if (this.orientationCombo.getValue() == HexOrientation.COLUMNS) {
                this.hexWidthSpinner.getValueFactory().setValue((Object)46.18);
                this.hexHeightSpinner.getValueFactory().setValue((Object)40.0);
            } else if (this.orientationCombo.getValue() == HexOrientation.ROWS) {
                this.hexWidthSpinner.getValueFactory().setValue((Object)40.0);
                this.hexHeightSpinner.getValueFactory().setValue((Object)46.18);
            }
        }
    }

    private GridPane getSettlementGenPane() {
        GridPane grid = new GridPane();
        grid.setMinWidth(660.0);
        grid.setHgap(3.0);
        grid.setVgap(3.0);
        grid.setPadding(new Insets(3.0));
        Label scenetitle = new Label("Settlement Generation");
        scenetitle.setFont(Font.font((String)"Tahoma", (FontWeight)FontWeight.NORMAL, (double)20.0));
        grid.add((Node)scenetitle, 0, 0, 4, 1);
        this.blankMapCheckBox = new CheckBox("Blank Map (place roads/buildings/etc. later)");
        this.blankMapCheckBox.setTooltip(new Tooltip("Check this if you wish to generate the city by placing everything by hand or using the \n'Generate' menu --which appears after you start a city/village."));
        this.blankMapCheckBox.setSelected(this.prefs.getBoolean("dontGenerate", Boolean.FALSE));
        grid.add((Node)this.blankMapCheckBox, 0, 1, 4, 1);
        ToggleGroup group = new ToggleGroup();
        this.backgroundTerrainRB = new RadioButton("Background Terrain:");
        this.backgroundTerrainRB.setMinWidth(140.0);
        this.backgroundTextureRB = new RadioButton("Texture:");
        this.backgroundTextureRB.setMinWidth(70.0);
        RadioButton backgroundColorRB = new RadioButton("Color:");
        backgroundColorRB.setMinWidth(65.0);
        this.backgroundTerrainRB.setToggleGroup(group);
        this.backgroundTextureRB.setToggleGroup(group);
        backgroundColorRB.setToggleGroup(group);
        if (this.prefs.get("bgtype", "texture").equals("texture")) {
            this.backgroundTextureRB.setSelected(true);
        } else if (this.prefs.get("bgtype", "texture").equals("terrain")) {
            this.backgroundTerrainRB.setSelected(true);
        } else {
            backgroundColorRB.setSelected(true);
        }
        HBox bgbox1 = new HBox();
        bgbox1.getChildren().add((Object)this.backgroundTerrainRB);
        this.terrainCombo.getSelectionModel().select((Object)this.prefs.get("solidTerrain", "ISO Cols Other Grass"));
        bgbox1.getChildren().add(this.terrainCombo);
        grid.add((Node)bgbox1, 0, 2, 4, 1);
        HBox bgbox2 = new HBox();
        bgbox2.setAlignment(Pos.CENTER_LEFT);
        Label orlabel = new Label("   or: ");
        orlabel.setMinWidth(30.0);
        bgbox2.getChildren().add((Object)orlabel);
        bgbox2.getChildren().add((Object)this.backgroundTextureRB);
        ObservableList texturesList = FXCollections.observableArrayList(TextureType.ALL_TEXTURES.values());
        this.backgroundTextureCombo = new ComboBox(texturesList);
        this.backgroundTextureCombo.setMaxWidth(180.0);
        String tt = this.prefs.get("bgtexture", "Forest Floor");
        this.backgroundTextureCombo.getSelectionModel().select((Object)TextureType.ALL_TEXTURES.get(tt));
        bgbox2.getChildren().add(this.backgroundTextureCombo);
        bgbox2.getChildren().add((Object)new Label(" "));
        String[] colorstr = this.prefs.get("bgcolor", "0.659,0.753,0.459").split(",");
        Color color = new Color((double)Float.parseFloat(colorstr[0].trim()), (double)Float.parseFloat(colorstr[1].trim()), (double)Float.parseFloat(colorstr[2].trim()), 1.0);
        this.backgroundColorPicker = new ColorPicker(color);
        bgbox2.getChildren().add((Object)backgroundColorRB);
        bgbox2.getChildren().add((Object)this.backgroundColorPicker);
        grid.add((Node)bgbox2, 0, 3, 4, 1);
        grid.add((Node)new Label("Population:"), 0, 4);
        this.denseCB.setSelected(this.prefs.getBoolean("dense", Boolean.FALSE));
        grid.add((Node)this.denseCB, 1, 4);
        this.populationSpinner.getValueFactory().setValue((Object)this.prefs.getInt("population", 5000));
        this.populationSpinner.setMinWidth(50.0);
        grid.add(this.populationSpinner, 2, 4, 2, 1);
        HBox epbox = new HBox();
        Label buildingRoadDistanceLabel = new Label("Building Road Distance:");
        epbox.setAlignment(Pos.CENTER_LEFT);
        epbox.getChildren().add((Object)buildingRoadDistanceLabel);
        this.extraPushBackSpinner.getValueFactory().setValue((Object)this.prefs.getInt("extraPushBack", 20));
        this.extraPushBackSpinner.setMaxWidth(70.0);
        epbox.getChildren().add(this.extraPushBackSpinner);
        Label percentTile = new Label("% tile");
        epbox.getChildren().add((Object)percentTile);
        Label labelsLabel = new Label(" Labels:");
        epbox.getChildren().add((Object)labelsLabel);
        this.buildingLabelCombo.getSelectionModel().select((Object)this.prefs.get("buildingLabels", "Name"));
        epbox.getChildren().add(this.buildingLabelCombo);
        grid.add((Node)epbox, 0, 5, 4, 1);
        grid.add((Node)this.hasCoast, 0, 6);
        this.hasCoast.setSelected(this.prefs.getBoolean("hasCoast", Boolean.FALSE));
        grid.add((Node)new Label("Coast Begin & End:"), 1, 6);
        int cstart = (int)(Math.random() * 12.0);
        int cend = (cstart + (int)(Math.random() * 12.0)) % 12;
        this.coastStartCombo.getSelectionModel().select(this.prefs.getInt("coastStart", cstart));
        grid.add(this.coastStartCombo, 2, 6);
        this.coastEndCombo.getSelectionModel().select(this.prefs.getInt("coastEnd", cend));
        grid.add(this.coastEndCombo, 3, 6);
        grid.add((Node)this.hasRiver, 0, 7);
        this.hasRiver.setSelected(this.prefs.getBoolean("hasRiver", Boolean.FALSE));
        grid.add((Node)new Label("River Begin & End:"), 1, 7);
        int rstart = (int)(Math.random() * 12.0);
        int rend = (rstart + 3 + (int)(Math.random() * 6.0)) % 12;
        this.riverStartCombo.getSelectionModel().select(this.prefs.getInt("riverStart", rstart));
        grid.add(this.riverStartCombo, 2, 7);
        this.riverEndCombo.getSelectionModel().select(this.prefs.getInt("riverEnd", rend));
        grid.add(this.riverEndCombo, 3, 7);
        int mainroad1start = (int)(Math.random() * 6.0);
        int mainroad1end = (mainroad1start + 4 + (int)(Math.random() * 4.0)) % 12;
        int mainroad2start = mainroad1start + 2 + (int)(Math.random() * 3.0);
        int mainroad2end = (mainroad2start + 4 + (int)(Math.random() * 4.0)) % 12;
        grid.add((Node)new Label("Main Road 1:"), 0, 8);
        this.mainRoad1StartCombo.getSelectionModel().select(this.prefs.getInt("mainRoad1Start", mainroad1start));
        this.mainRoad1EndCombo.getSelectionModel().select(this.prefs.getInt("mainRoad1End", mainroad1end));
        HBox mainroad1box = new HBox();
        mainroad1box.getChildren().add(this.mainRoad1StartCombo);
        mainroad1box.getChildren().add(this.mainRoad1EndCombo);
        grid.add((Node)mainroad1box, 1, 8);
        HBox windinessbox = new HBox();
        Label windynessLabel = new Label("Windy-ness:");
        windynessLabel.setAlignment(Pos.CENTER_LEFT);
        windinessbox.setAlignment(Pos.CENTER_LEFT);
        windinessbox.getChildren().add((Object)windynessLabel);
        this.windinessSpinner.getValueFactory().setValue((Object)this.prefs.getDouble("windiness", 0.1));
        this.windinessSpinner.setMaxWidth(75.0);
        windinessbox.getChildren().add(this.windinessSpinner);
        grid.add((Node)windinessbox, 2, 8, 2, 1);
        grid.add((Node)new Label("Main Road 2:"), 0, 9);
        this.mainRoad2StartCombo.getSelectionModel().select(this.prefs.getInt("mainRoad2Start", mainroad2start));
        this.mainRoad2EndCombo.getSelectionModel().select(this.prefs.getInt("mainRoad2End", mainroad2end));
        HBox mainroad2box = new HBox();
        mainroad2box.getChildren().add(this.mainRoad2StartCombo);
        mainroad2box.getChildren().add(this.mainRoad2EndCombo);
        grid.add((Node)mainroad2box, 1, 9);
        this.makeMainRoadsPerpendicular.setSelected(this.prefs.getBoolean("mainRoadsPerpendicular", false));
        grid.add((Node)this.makeMainRoadsPerpendicular, 2, 9, 2, 1);
        ToggleGroup rgroup = new ToggleGroup();
        this.roadTextureRB = new RadioButton("Road Texture:");
        RadioButton roadColorRB = new RadioButton("Color:");
        roadColorRB.setAlignment(Pos.CENTER_LEFT);
        roadColorRB.setMinWidth(65.0);
        this.roadTextureRB.setToggleGroup(rgroup);
        roadColorRB.setToggleGroup(rgroup);
        if (this.prefs.get("roadtype", "texture").equals("texture")) {
            this.roadTextureRB.setSelected(true);
        } else {
            roadColorRB.setSelected(true);
        }
        grid.add((Node)this.roadTextureRB, 0, 10);
        this.roadTextureCombo = new ComboBox(texturesList);
        String rtt = this.prefs.get("roadtexture", "Cobblestone Light");
        this.roadTextureCombo.getSelectionModel().select((Object)TextureType.ALL_TEXTURES.get(rtt));
        grid.add(this.roadTextureCombo, 1, 10);
        HBox roadcolorbox = new HBox();
        roadcolorbox.getChildren().add((Object)roadColorRB);
        String[] rcolorstr = this.prefs.get("roadcolor", "0.2,0.2,0.2").split(",");
        Color rcolor = new Color((double)Float.parseFloat(rcolorstr[0].trim()), (double)Float.parseFloat(rcolorstr[1].trim()), (double)Float.parseFloat(rcolorstr[2].trim()), 1.0);
        this.roadColorPicker = new ColorPicker(rcolor);
        roadcolorbox.getChildren().add((Object)this.roadColorPicker);
        grid.add((Node)roadcolorbox, 2, 10, 2, 1);
        this.hasWall.setSelected(this.prefs.getBoolean("hasWall", Boolean.FALSE));
        grid.add((Node)this.hasWall, 0, 11);
        HBox wallbox = new HBox();
        wallbox.setAlignment(Pos.CENTER_LEFT);
        Label numtowers = new Label("#Towers:");
        wallbox.getChildren().add((Object)numtowers);
        this.wallTowerSpinner.getValueFactory().setValue((Object)this.prefs.getInt("wallTowers", 8));
        this.wallTowerSpinner.setMaxWidth(70.0);
        wallbox.getChildren().add(this.wallTowerSpinner);
        Label towerradius = new Label(" Radius (#hexes):");
        wallbox.getChildren().add((Object)towerradius);
        this.wallRadiusSpinner.getValueFactory().setValue((Object)this.prefs.getInt("wallRadius", 15));
        wallbox.getChildren().add(this.wallRadiusSpinner);
        this.wallRadiusSpinner.setMaxWidth(70.0);
        grid.add((Node)wallbox, 1, 11, 3, 1);
        grid.add((Node)new Label("Street Layout:"), 0, 12);
        HBox streetoptbox = new HBox();
        streetoptbox.setAlignment(Pos.CENTER_LEFT);
        this.streetLayoutCombo.getSelectionModel().select((Object)LAYOUTS.valueOf(this.prefs.get("streetLayout", "Random")));
        this.streetLayoutCombo.setMinWidth(100.0);
        streetoptbox.getChildren().add(this.streetLayoutCombo);
        this.numStreetsSpinner = new FocusSpinner<Integer>(1, 10000, this.prefs.getInt("numStreets", 150));
        Label numStreetsLabel = new Label(" # Streets:");
        numStreetsLabel.setMinWidth(70.0);
        streetoptbox.getChildren().add((Object)numStreetsLabel);
        this.numStreetsSpinner.setMaxWidth(75.0);
        this.numStreetsSpinner.setMinWidth(75.0);
        streetoptbox.getChildren().add(this.numStreetsSpinner);
        Label skipChanceLabel = new Label(" Skip %:");
        skipChanceLabel.setMinWidth(55.0);
        streetoptbox.getChildren().add((Object)skipChanceLabel);
        this.skipChanceSpinner.setMaxWidth(70.0);
        this.skipChanceSpinner.setMinWidth(70.0);
        this.skipChanceSpinner.getValueFactory().setValue((Object)this.prefs.getInt("skipChance", 15));
        streetoptbox.getChildren().add(this.skipChanceSpinner);
        Label distanceLabel = new Label(" Distance:");
        distanceLabel.setMinWidth(65.0);
        streetoptbox.getChildren().add((Object)distanceLabel);
        this.streetDistanceSpinner.setMaxWidth(70.0);
        this.streetDistanceSpinner.setMinWidth(70.0);
        this.streetDistanceSpinner.getValueFactory().setValue((Object)this.prefs.getDouble("streetDistance", 4.0));
        streetoptbox.getChildren().add(this.streetDistanceSpinner);
        grid.add((Node)streetoptbox, 1, 12, 3, 1);
        grid.add((Node)new Label("Vegetation %:"), 0, 13);
        HBox vegbox = new HBox();
        vegbox.setAlignment(Pos.CENTER_LEFT);
        Label decLabel = new Label("Deciduous:");
        decLabel.setMinWidth(70.0);
        vegbox.getChildren().add((Object)decLabel);
        this.deciduousSpinner.setMinWidth(70.0);
        this.deciduousSpinner.getValueFactory().setValue((Object)this.prefs.getInt("deciduous", 20));
        vegbox.getChildren().add(this.deciduousSpinner);
        Label everLabel = new Label(" Evergreen:");
        everLabel.setMinWidth(70.0);
        vegbox.getChildren().add((Object)everLabel);
        this.evergreenSpinner.setMinWidth(70.0);
        this.evergreenSpinner.getValueFactory().setValue((Object)this.prefs.getInt("evergreen", 5));
        vegbox.getChildren().add(this.evergreenSpinner);
        Label tropLabel = new Label(" Tropical:");
        tropLabel.setMinWidth(60.0);
        vegbox.getChildren().add((Object)tropLabel);
        this.tropicalSpinner.setMinWidth(70.0);
        this.tropicalSpinner.getValueFactory().setValue((Object)this.prefs.getInt("tropical", 0));
        vegbox.getChildren().add(this.tropicalSpinner);
        grid.add((Node)vegbox, 1, 13, 3, 1);
        return grid;
    }

    public Stage getPrimaryStage() {
        return this.popupStage;
    }

    public static enum LAYOUTS {
        Branching,
        Haphazard,
        Ordered,
        Very_Ordered,
        Square,
        Pentagon,
        Hexagon,
        Heptagon,
        Octagon,
        Nonagon,
        Decagon,
        Random;

    }
}

