/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.ui.toolbox;

import com.inkwellideas.ographer.data.FeatureDecoration;
import com.inkwellideas.ographer.data.LabelStyle;
import com.inkwellideas.ographer.data.MapLayer;
import com.inkwellideas.ographer.data.MapObject;
import com.inkwellideas.ographer.data.ViewLevel;
import com.inkwellideas.ographer.io.LoadImage;
import com.inkwellideas.ographer.io.UserPrefs;
import com.inkwellideas.ographer.map.MapLabel;
import com.inkwellideas.ographer.model.Feature;
import com.inkwellideas.ographer.model.FeatureType;
import com.inkwellideas.ographer.model.Note;
import com.inkwellideas.ographer.ui.Worldographer;
import com.inkwellideas.ographer.ui.configure.ConfigureSingleFeatureScreen;
import com.inkwellideas.ographer.ui.dialog.ConfigurationDialog;
import com.inkwellideas.ographer.ui.dialog.StandardDialog;
import com.inkwellideas.ographer.ui.toolbox.Toolbox;
import com.inkwellideas.ographer.ui.widget.ColorPickerWithSelector;
import com.inkwellideas.ographer.ui.widget.FocusSpinner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.OverrunStyle;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Spinner;
import javafx.scene.control.SplitPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.ContextMenuEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;
import javafx.scene.text.TextAlignment;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.kordamp.ikonli.javafx.FontIcon;

public class FeaturesToolbox
extends Toolbox {
    public BorderPane featuresBorderPane;
    private ScrollPane featureButtonsScrollPane = new ScrollPane();
    FlowPane featuresFlowPane = new FlowPane();
    public CheckBox featuresPlaceFreelyCB;
    CheckBox featuresHideTerrainIconCB;
    public CheckBox featuresScaleCB;
    public CheckBox featuresScaleHtCB;
    CheckBox featuresOverrideColorCB;
    CheckBox featuresGMOnlyCB;
    CheckBox featuresFillTileBottomCB;
    ColorPicker featuresOverrideColorBGCP;
    public ColorPicker featuresLabelColorCP;
    ColorPicker featuresLabelBackgroundCP;
    public ColorPicker featuresLabelOutlineColorCP;
    ColorPicker featuresRingColorCP;
    public Spinner<Double> featuresScaleSpinner;
    public Spinner<Double> featuresScaleHtSpinner;
    public Spinner<Double> featuresRotateSpinner;
    Spinner<Double> featuresLabelScale;
    Spinner<Double> featuresLabelOutlineSizeSpinner;
    Spinner<Integer> featuresLabelDistance;
    CheckBox featureFlipHorizontalCB;
    CheckBox featureFlipVerticalCB;
    public ComboBox<MapLayer> featuresMapLayerCombo;
    Spinner<Double> featuresLabelPositionSpinner;
    Spinner<Double> featuresLabelRotationSpinner;
    public ToggleButton featuresSelectButton;
    Button featuresDrawBuildingButton;
    CheckBox featuresLabelBackground;
    CheckBox featuresLabelBold;
    CheckBox featuresLabelItalic;
    CheckBox featuresRing;
    Button featuresNoteButton;
    Button featuresDeleteButton;
    ComboBox<String> featureLabelStyleCombo;
    public ComboBox<String> featuresLabelFontCombo;
    public ComboBox<String> featureFilterComboBox;
    TextField featuresTagsTF;
    TextArea featuresLabelTA;
    ToggleButton useSimilarNamedFeaturesButton;
    private Spinner<Integer> iconSizeSpinner;
    CheckBox featureWorldCB;
    CheckBox featureContinentCB;
    CheckBox featureKingdomCB;
    CheckBox featureProvinceCB;
    final int numFeatureDecorations = 8;
    final CheckBox[] featureDecorationCheckbox = new CheckBox[8];
    final TextField[] featureDecorationStringTF = new TextField[8];
    final Spinner<Double>[] featureDecorationLocationSpinner = new Spinner[8];
    final ColorPicker[] featureDecorationCP = new ColorPicker[8];
    public TextField featureFilterTF;
    GridPane featureIconsGrid;
    final HashMap<String, ToggleButton> featureButtons = new HashMap();
    public ColorPickerWithSelector featuresOverrideColorPickerWSelector;
    public ColorPickerWithSelector featuresRingColorPickerWSelector;
    public ColorPickerWithSelector labelColorPickerWSelector;
    public ColorPickerWithSelector labelOutlineColorPickerWSelector;
    public ColorPickerWithSelector labelBackgroundColorPickerWSelector;

    public FeaturesToolbox(Worldographer worldographer) {
        super(worldographer);
    }

    @Override
    public void setup(ToggleButton toggleButton) {
        this.createToolbox("Features", "other_imgs/features_24.png", this.createFeaturesDrawer(this.worldographer.undoEnabled), 450, 400, true);
        this.stage.show();
        this.stage.setOnCloseRequest(event -> toggleButton.setSelected(false));
    }

    public Node createFeaturesDrawer(boolean undoEnabled) {
        System.out.println("fave features:" + UserPrefs.FAVORITE_FEATURES);
        this.featuresBorderPane = new BorderPane();
        this.featuresBorderPane.setPadding(new Insets(2.0, 2.0, 2.0, 2.0));
        FlowPane topBox = new FlowPane();
        topBox.setHgap(10.0);
        topBox.setVgap(5.0);
        topBox.setPadding(new Insets(5.0, 0.0, 5.0, 0.0));
        HBox filterBox = this.createFilterBox();
        HBox featureSelectBox = this.createSelectNoteConfigureDeleteBox();
        featureSelectBox.setAlignment(Pos.CENTER_LEFT);
        topBox.getChildren().add((Object)filterBox);
        topBox.getChildren().add((Object)featureSelectBox);
        topBox.getChildren().add((Object)this.createSizeBox());
        this.featuresBorderPane.setTop((Node)topBox);
        this.updateFeatureButtons();
        this.featureButtonsScrollPane.setContent((Node)this.featuresFlowPane);
        this.featureButtonsScrollPane.setFitToWidth(true);
        this.featureButtonsScrollPane.setMaxWidth(1000.0);
        this.featureButtonsScrollPane.setPrefWidth(1000.0);
        SplitPane centerSplitPane = new SplitPane();
        centerSplitPane.setOrientation(Orientation.HORIZONTAL);
        centerSplitPane.getItems().add((Object)this.featureButtonsScrollPane);
        this.featuresBorderPane.setCenter((Node)centerSplitPane);
        TabPane featureOptionTabPane = new TabPane();
        featureOptionTabPane.setSide(Side.TOP);
        centerSplitPane.getItems().add((Object)featureOptionTabPane);
        featureOptionTabPane.getTabs().add((Object)new Tab("Details", (Node)this.getFeatureDetailsPane()));
        ScrollPane labelScrollPane = new ScrollPane(this.createFeatureLabelPane());
        featureOptionTabPane.getTabs().add((Object)new Tab("Label", (Node)labelScrollPane));
        ScrollPane decorationScrollPane = new ScrollPane(this.createFeatureDecorationsPane());
        featureOptionTabPane.getTabs().add((Object)new Tab("Decorations", (Node)decorationScrollPane));
        return this.featuresBorderPane;
    }

    private ScrollPane getFeatureDetailsPane() {
        GridPane featuresDetailsPane = new GridPane();
        featuresDetailsPane.setPrefWidth(180.0);
        featuresDetailsPane.setHgap(5.0);
        Label zAxis = new Label("Z-Axis:");
        featuresDetailsPane.add((Node)zAxis, 0, 0);
        HBox zAxisBox = new HBox(0.0);
        zAxisBox.setAlignment(Pos.CENTER_LEFT);
        featuresDetailsPane.add((Node)zAxisBox, 0, 1);
        ImageView movetopImage = new ImageView(LoadImage.image("other_imgs/move_to_top.png"));
        movetopImage.setFitWidth(24.0);
        movetopImage.setFitHeight(24.0);
        Button featuresMoveTopButton = new Button("", (Node)movetopImage);
        featuresMoveTopButton.setTooltip(new Tooltip("Moves the selected LFeature to the top of all the LFeature on this map layer.\n(To move it to another layer look for the layer placement field below.)"));
        featuresMoveTopButton.setOnAction(event -> {
            boolean changed = this.mapUI().getController().moveFeatureTop(this.mapUI().getCurrentObjects());
            if (changed) {
                this.mapUI().draw();
            }
        });
        zAxisBox.getChildren().add((Object)featuresMoveTopButton);
        ImageView moveUpImage = new ImageView(LoadImage.image("other_imgs/move_up.png"));
        moveUpImage.setFitWidth(24.0);
        moveUpImage.setFitHeight(24.0);
        Button featuresMoveUpButton = new Button("", (Node)moveUpImage);
        featuresMoveUpButton.setTooltip(new Tooltip("Moves the selected LFeature above one other overlapping LFeature on this map layer.\n(To move it to another layer look for the layer placement field below.)"));
        featuresMoveUpButton.setOnAction(event -> {
            boolean changed = this.mapUI().getController().moveFeatureUp(this.mapUI().getCurrentObjects());
            if (changed) {
                this.mapUI().draw();
            }
        });
        zAxisBox.getChildren().add((Object)featuresMoveUpButton);
        ImageView moveDownImage = new ImageView(LoadImage.image("other_imgs/move_down.png"));
        moveDownImage.setFitWidth(24.0);
        moveDownImage.setFitHeight(24.0);
        Button featuresMoveDownButton = new Button("", (Node)moveDownImage);
        featuresMoveDownButton.setTooltip(new Tooltip("Moves the selected LFeature below one other overlapping LFeature on this map layer.\n(To move it to another layer look for the layer placement field below.)"));
        featuresMoveDownButton.setOnAction(event -> {
            boolean changed = this.mapUI().getController().moveFeatureDown(this.mapUI().getCurrentObjects());
            if (changed) {
                this.mapUI().draw();
            }
        });
        zAxisBox.getChildren().add((Object)featuresMoveDownButton);
        ImageView moveBottomImage = new ImageView(LoadImage.image("other_imgs/move_to_bottom.png"));
        moveBottomImage.setFitWidth(24.0);
        moveBottomImage.setFitHeight(24.0);
        Button featuresMoveBottomButton = new Button("", (Node)moveBottomImage);
        featuresMoveBottomButton.setTooltip(new Tooltip("Moves the selected LFeature to the bottom of all the LFeature on this map layer.\n(To move it to another layer look for the layer placement field below.)"));
        featuresMoveBottomButton.setOnAction(event -> {
            boolean changed = this.mapUI().getController().moveFeatureBottom(this.mapUI().getCurrentObjects());
            if (changed) {
                this.mapUI().draw();
            }
        });
        zAxisBox.getChildren().add((Object)featuresMoveBottomButton);
        FlowPane layerPane = new FlowPane();
        Label layerlabel = new Label("Layer:");
        layerlabel.setTooltip(new Tooltip("The selected LFeature can be moved among the map's various layers. A map has several layers such\nas Labels, Grid, Features, Above Terrain, & more. Features (and shapes and labels) can actually be placed on any layer.\nSee the Layers drawer/toolbox to turn then on/off or reorder them."));
        layerPane.getChildren().add((Object)layerlabel);
        MapLayer featureslayer = this.mapUI().getMapData().getMapLayer("Features");
        if (featureslayer == null) {
            featureslayer = this.mapUI().getMapData().getMapLayers().get(0);
        }
        this.featuresMapLayerCombo.getSelectionModel().select((Object)featureslayer);
        this.featuresMapLayerCombo.setTooltip(new Tooltip("The selected LFeature can be moved among the map's various layers. A map has several layers such\nas Labels, Grid, Features, Above Terrain, & more. Features (and shapes and labels) can actually be placed on any layer.\nSee the Layers drawer/toolbox to turn then on/off or reorder them."));
        this.featuresMapLayerCombo.setMaxWidth(120.0);
        this.featuresMapLayerCombo.setOnAction(event -> {
            if (this.featuresMapLayerCombo.getSelectionModel().getSelectedItem() != null) {
                for (Object e : this.mapUI().getCurrentObjects()) {
                    if (!(e instanceof Feature)) continue;
                    Feature f = (Feature)e;
                    this.mapUI().getController().updateFeatureMapLayer(this.worldographer.undoEnabled, f, (MapLayer)this.featuresMapLayerCombo.getSelectionModel().getSelectedItem());
                    this.mapUI().draw();
                }
            }
        });
        layerPane.getChildren().add(this.featuresMapLayerCombo);
        featuresDetailsPane.add((Node)layerPane, 0, 2, 2, 1);
        GridPane featureLevelGrid = new GridPane();
        Label levelsLabel = new Label("Levels:");
        levelsLabel.setMinWidth(50.0);
        featureLevelGrid.add((Node)levelsLabel, 0, 0);
        featureLevelGrid.setHgap(2.0);
        featureLevelGrid.setVgap(2.0);
        featureLevelGrid.setPadding(new Insets(2.0, 2.0, 2.0, 2.0));
        this.featureWorldCB.setSelected(true);
        this.featureWorldCB.setMinWidth(90.0);
        this.featureWorldCB.setTooltip(new Tooltip("Toggles if the selected feature should be shown on the World map level.\nNote: you can't toggle this off if it is the map level you're currently viewing."));
        this.featureWorldCB.setOnAction(event -> {
            for (MapObject mo : this.mapUI().getCurrentObjects()) {
                if (!(mo instanceof Feature)) continue;
                if (this.mapUI().viewLevel == ViewLevel.WORLD && !this.featureWorldCB.isSelected()) {
                    this.featureWorldCB.setSelected(true);
                    return;
                }
                this.mapUI().getController().updateFeatureWorld(this.worldographer.undoEnabled, (Feature)mo, this.featureWorldCB.isSelected());
                this.mapUI().draw();
            }
        });
        featureLevelGrid.add((Node)this.featureWorldCB, 1, 0);
        this.featureContinentCB.setSelected(true);
        this.featureContinentCB.setMinWidth(90.0);
        this.featureContinentCB.setTooltip(new Tooltip("Toggles if the selected feature should be shown on the Continent map level.\nNote: you can't toggle this off if it is the map level you're currently viewing."));
        this.featureContinentCB.setOnAction(event -> {
            for (MapObject mo : this.mapUI().getCurrentObjects()) {
                if (!(mo instanceof Feature)) continue;
                if (this.mapUI().viewLevel == ViewLevel.CONTINENT && !this.featureContinentCB.isSelected()) {
                    this.featureContinentCB.setSelected(true);
                    return;
                }
                this.mapUI().getController().updateFeatureContinent(this.worldographer.undoEnabled, (Feature)mo, this.featureContinentCB.isSelected());
                this.mapUI().draw();
            }
        });
        featureLevelGrid.add((Node)this.featureContinentCB, 2, 0);
        this.featureKingdomCB.setSelected(true);
        this.featureKingdomCB.setMinWidth(90.0);
        this.featureKingdomCB.setTooltip(new Tooltip("Toggles if the selected feature should be shown on the Kingdom map level.\nNote: you can't toggle this off if it is the map level you're currently viewing."));
        this.featureKingdomCB.setOnAction(event -> {
            for (MapObject mo : this.mapUI().getCurrentObjects()) {
                if (!(mo instanceof Feature)) continue;
                if (this.mapUI().viewLevel == ViewLevel.KINGDOM && !this.featureKingdomCB.isSelected()) {
                    this.featureKingdomCB.setSelected(true);
                    return;
                }
                this.mapUI().getController().updateFeatureKingdom(this.worldographer.undoEnabled, (Feature)mo, this.featureKingdomCB.isSelected());
                this.mapUI().draw();
            }
        });
        featureLevelGrid.add((Node)this.featureKingdomCB, 1, 1);
        this.featureProvinceCB.setSelected(true);
        this.featureProvinceCB.setMinWidth(90.0);
        this.featureProvinceCB.setTooltip(new Tooltip("Toggles if the selected feature should be shown on the Province map level.\nNote: you can't toggle this off if it is the map level you're currently viewing."));
        this.featureProvinceCB.setOnAction(event -> {
            for (MapObject mo : this.mapUI().getCurrentObjects()) {
                if (!(mo instanceof Feature)) continue;
                if (this.mapUI().viewLevel == ViewLevel.PROVINCE && !this.featureKingdomCB.isSelected()) {
                    this.featureProvinceCB.setSelected(true);
                    return;
                }
                this.mapUI().getController().updateFeatureProvince(this.worldographer.undoEnabled, (Feature)mo, this.featureProvinceCB.isSelected());
                this.mapUI().draw();
            }
        });
        featureLevelGrid.add((Node)this.featureProvinceCB, 2, 1);
        featuresDetailsPane.add((Node)featureLevelGrid, 0, 3, 2, 1);
        Label scaleLabel = new Label("Scale:");
        featuresDetailsPane.add((Node)scaleLabel, 0, 4);
        GridPane scaleGrid = new GridPane();
        scaleGrid.setHgap(3.0);
        scaleGrid.setAlignment(Pos.CENTER_LEFT);
        featuresDetailsPane.add((Node)scaleGrid, 0, 5);
        scaleGrid.add((Node)this.featuresScaleCB, 0, 0);
        this.featuresScaleCB.setTooltip(new Tooltip("Check this box to override the width of the selected LFeature using the value entered in\nthe field below as a percentage of a tile's width. If unchecked the LFeature's default size is used."));
        this.featuresScaleCB.setOnAction(event -> {
            boolean scaleSet = false;
            for (Object e : this.mapUI().getCurrentObjects()) {
                if (!(e instanceof Feature)) continue;
                Feature f = (Feature)e;
                double newval = -1.0;
                if (this.featuresScaleCB.isSelected()) {
                    newval = (Double)this.featuresScaleSpinner.getValue();
                }
                this.mapUI().getController().updateFeatureScale(this.worldographer.undoEnabled, f, newval);
                if (!scaleSet && this.featuresScaleCB.isSelected() && (Double)this.featuresScaleSpinner.getValue() < 0.0) {
                    this.featuresScaleSpinner.getValueFactory().setValue((Object)((Feature)e).getScaleFallbackType());
                    scaleSet = true;
                }
                this.mapUI().draw();
            }
        });
        this.featuresScaleSpinner.setMaxWidth(80.0);
        this.featuresScaleSpinner.setTooltip(new Tooltip("If the scale percent checkbox is selected, the selected LFeature's width is set to\nthe value entered as a percentage of a tile's width."));
        scaleGrid.add(this.featuresScaleSpinner, 1, 0);
        this.featuresScaleSpinner.setEditable(true);
        this.featuresScaleSpinner.valueProperty().addListener((observable, oldValue, newValue) -> {
            for (Object e : this.mapUI().getCurrentObjects()) {
                if (!(e instanceof Feature)) continue;
                Feature f = (Feature)e;
                double newval = -1.0;
                if (this.featuresScaleCB.isSelected()) {
                    newval = (Double)this.featuresScaleSpinner.getValue();
                }
                this.mapUI().getController().updateFeatureScale(this.worldographer.undoEnabled, f, newval);
                this.mapUI().draw();
            }
        });
        Label featuresScaleLabel = new Label("%\nTile");
        scaleGrid.add((Node)featuresScaleLabel, 2, 0);
        scaleGrid.add((Node)this.featuresScaleHtCB, 0, 1);
        this.featuresScaleHtCB.setTooltip(new Tooltip("Check this box to override the height of the selected LFeature using the value entered in\nthe field below as a percentage of a tile's height. If unchecked the LFeature's default size is used.\nBut if the scale % above is checked but this is not, the height is scaled proportionally to the width."));
        this.featuresScaleHtCB.setOnAction(event -> {
            boolean scaleSet = false;
            for (Object e : this.mapUI().getCurrentObjects()) {
                if (!(e instanceof Feature)) continue;
                Feature f = (Feature)e;
                double newval = -1.0;
                if (this.featuresScaleHtCB.isSelected()) {
                    newval = (Double)this.featuresScaleHtSpinner.getValue();
                }
                this.mapUI().getController().updateFeatureScaleHt(this.worldographer.undoEnabled, f, newval);
                if (!scaleSet && this.featuresScaleHtCB.isSelected() && (Double)this.featuresScaleHtSpinner.getValue() < 0.0) {
                    this.featuresScaleHtSpinner.getValueFactory().setValue((Object)((Feature)e).getScaleHtFallbackType());
                    scaleSet = true;
                }
                this.mapUI().draw();
            }
        });
        this.featuresScaleHtSpinner.setMaxWidth(80.0);
        this.featuresScaleHtSpinner.setTooltip(new Tooltip("If the scale height independent checkbox is selected, the selected LFeature's height\nis set to the value entered as a percentage of a tile's height."));
        this.featuresScaleHtSpinner.setEditable(true);
        scaleGrid.add(this.featuresScaleHtSpinner, 1, 1);
        this.featuresScaleHtSpinner.valueProperty().addListener((observable, oldValue, newValue) -> {
            for (Object e : this.mapUI().getCurrentObjects()) {
                if (!(e instanceof Feature)) continue;
                Feature f = (Feature)e;
                double newval = -1.0;
                if (this.featuresScaleHtCB.isSelected()) {
                    newval = (Double)this.featuresScaleHtSpinner.getValue();
                }
                this.mapUI().getController().updateFeatureScaleHt(this.worldographer.undoEnabled, f, newval);
                this.mapUI().draw();
            }
        });
        Label featuresScaleHtLabel = new Label("%\nTile");
        scaleGrid.add((Node)featuresScaleHtLabel, 2, 1);
        GridPane rotateGrid = new GridPane();
        featuresDetailsPane.add((Node)rotateGrid, 0, 7, 2, 2);
        Label featuresRotateLabel = new Label("Rotate (cw):  ");
        featuresRotateLabel.setTooltip(new Tooltip("The selected Feature will be rotated by the chosen number of degrees, clockwise."));
        rotateGrid.add((Node)featuresRotateLabel, 0, 0);
        this.featuresRotateSpinner.setMaxWidth(75.0);
        this.featuresRotateSpinner.setMinWidth(75.0);
        this.featuresRotateSpinner.setTooltip(new Tooltip("The selected LFeature will be rotated by the chosen number of degrees, clockwise."));
        this.featuresRotateSpinner.setEditable(true);
        rotateGrid.add(this.featuresRotateSpinner, 0, 1);
        this.featuresRotateSpinner.valueProperty().addListener((observable, oldValue, newValue) -> {
            for (Object e : this.mapUI().getCurrentObjects()) {
                if (!(e instanceof Feature)) continue;
                Feature f = (Feature)e;
                this.mapUI().getController().updateFeatureRotate(this.worldographer.undoEnabled, f, (Double)this.featuresRotateSpinner.getValue());
                this.mapUI().draw();
            }
        });
        ImageView rotationImage = new ImageView(LoadImage.image("other_imgs/rotation.png"));
        rotationImage.setFitWidth(54.0);
        rotationImage.setFitHeight(54.0);
        StackPane rotatePreSetButton = new StackPane();
        rotatePreSetButton.setMaxHeight(60.0);
        rotatePreSetButton.setMaxWidth(60.0);
        rotatePreSetButton.setMinHeight(60.0);
        rotatePreSetButton.setMinWidth(60.0);
        rotatePreSetButton.getChildren().add((Object)rotationImage);
        Canvas canvas = new Canvas();
        canvas.setHeight(60.0);
        canvas.setWidth(60.0);
        rotatePreSetButton.getChildren().add((Object)canvas);
        rotateGrid.add((Node)rotatePreSetButton, 1, 0, 1, 2);
        rotatePreSetButton.setOnMouseClicked(mouseEvent -> {
            double rise = -(rotatePreSetButton.getHeight() / 2.0 - mouseEvent.getY());
            double run = mouseEvent.getX() - rotatePreSetButton.getWidth() / 2.0;
            double degrees = Math.toDegrees(Math.atan2(rise, run));
            degrees = (int)((degrees + 97.5) / 15.0) * 15;
            degrees = (degrees + 360.0) % 360.0;
            this.featuresRotateSpinner.getValueFactory().setValue((Object)degrees);
            GraphicsContext g = canvas.getGraphicsContext2D();
            g.clearRect(0.0, 0.0, 60.0, 60.0);
            g.setFill((Paint)Color.DARKRED);
            g.setLineWidth(0.0);
            g.fillOval(27.0 + 27.0 * Math.cos(Math.toRadians(degrees - 90.0)), 27.0 + 27.0 * Math.sin(Math.toRadians(degrees - 90.0)), 6.0, 6.0);
        });
        Label featuresFlipLabel = new Label("Flip:");
        featuresFlipLabel.setTooltip(new Tooltip("Flip the selected Feature horizontally or vertically."));
        featuresDetailsPane.add((Node)featuresFlipLabel, 0, 9);
        HBox rotateBox1 = new HBox(5.0);
        featuresDetailsPane.add((Node)rotateBox1, 0, 10);
        rotateBox1.getChildren().add((Object)this.featureFlipVerticalCB);
        this.featureFlipVerticalCB.setOnAction(event -> {
            System.out.println("vert flip:" + this.mapUI().getCurrentObjects().size());
            for (Object e : this.mapUI().getCurrentObjects()) {
                if (!(e instanceof Feature)) continue;
                Feature f = (Feature)e;
                this.mapUI().getController().updateFeatureFlipVertical(this.worldographer.undoEnabled, f, this.featureFlipVerticalCB.isSelected());
                this.mapUI().draw();
            }
        });
        rotateBox1.getChildren().add((Object)this.featureFlipHorizontalCB);
        this.featureFlipHorizontalCB.setOnAction(event -> {
            for (Object e : this.mapUI().getCurrentObjects()) {
                if (!(e instanceof Feature)) continue;
                Feature f = (Feature)e;
                this.mapUI().getController().updateFeatureFlipHorizontal(this.worldographer.undoEnabled, f, this.featureFlipHorizontalCB.isSelected());
                this.mapUI().draw();
            }
        });
        FlowPane overrideColorPane = new FlowPane();
        Tooltip featuresOverrideColorToolTip = new Tooltip("If checked, the Feature's icon will be re-colored to\nmatch the adjacent color chooser's value.");
        featuresOverrideColorToolTip.setFont(new Font("Arial", 11.0));
        this.featuresOverrideColorCB.setMinWidth(70.0);
        this.featuresOverrideColorCB.setTooltip(featuresOverrideColorToolTip);
        this.featuresOverrideColorCB.setOnAction(event -> {
            if (this.featuresOverrideColorBGCP.getValue() != null) {
                for (Object e : this.mapUI().getCurrentObjects()) {
                    if (!(e instanceof Feature)) continue;
                    Feature f = (Feature)e;
                    Color newval = this.featuresOverrideColorCB.isSelected() ? (Color)this.featuresOverrideColorBGCP.getValue() : null;
                    this.mapUI().getController().updateFeatureOverrideColor(f, newval);
                    this.mapUI().draw();
                }
            }
        });
        overrideColorPane.getChildren().add((Object)this.featuresOverrideColorCB);
        this.featuresOverrideColorBGCP.setMaxWidth(120.0);
        this.featuresOverrideColorBGCP.setTooltip(new Tooltip("If the adjacent 'Override Color' checkbox is checked, then the color\nselected with this will be used to recolor the LFeature icon."));
        if (this.featuresOverrideColorBGCP.getCustomColors().size() <= 1) {
            this.featuresOverrideColorBGCP.getCustomColors().addAll((Object[])Worldographer.customColors);
        }
        this.featuresOverrideColorBGCP.setOnAction(event -> {
            for (Object e : this.mapUI().getCurrentObjects()) {
                if (!(e instanceof Feature)) continue;
                Feature f = (Feature)e;
                Color newval = this.featuresOverrideColorCB.isSelected() ? (Color)this.featuresOverrideColorBGCP.getValue() : null;
                this.mapUI().getController().updateFeatureOverrideColor(f, newval);
                this.mapUI().draw();
            }
        });
        overrideColorPane.getChildren().add((Object)this.featuresOverrideColorPickerWSelector.getNode());
        featuresDetailsPane.add((Node)overrideColorPane, 0, 11, 2, 1);
        FlowPane ringPane = new FlowPane();
        ringPane.getChildren().add((Object)this.featuresRing);
        this.featuresRing.setTooltip(new Tooltip("If checked, this will add a colored ring (matching the color of the adjacent color chooser)\naround the LFeature. Useful for emulating a particular star systems map style."));
        this.featuresRing.setOnAction(event -> {
            for (Object e : this.mapUI().getCurrentObjects()) {
                if (!(e instanceof Feature)) continue;
                Feature f = (Feature)e;
                Color c = this.featuresRing.isSelected() ? (Color)this.featuresRingColorCP.getValue() : null;
                this.mapUI().getController().updateFeatureRingColor(f, c);
                this.mapUI().draw();
            }
        });
        this.featuresRingColorCP.setMaxWidth(120.0);
        this.featuresRingColorCP.setTooltip(new Tooltip("If the adjacent Ring checkbox is checked, this will add a colored ring (matching the\nselected color) around the LFeature. Useful for emulating a specific  star systems map style."));
        this.featuresRingColorCP.setOnAction(event -> {
            for (Object e : this.mapUI().getCurrentObjects()) {
                if (!(e instanceof Feature)) continue;
                Feature f = (Feature)e;
                if (!this.featuresRing.isSelected()) continue;
                Color c = this.featuresRing.isSelected() ? (Color)this.featuresRingColorCP.getValue() : null;
                this.mapUI().getController().updateFeatureRingColor(f, c);
                this.mapUI().draw();
            }
        });
        ringPane.getChildren().add((Object)this.featuresRingColorPickerWSelector.getNode());
        featuresDetailsPane.add((Node)ringPane, 0, 13, 2, 1);
        FlowPane tagsPane = new FlowPane();
        Label tagslabel = new Label("Tags:");
        tagslabel.setTooltip(new Tooltip("The selected LFeature will be marked with the tags in the textfield. These tags are used with\nthe 'Show Objs w/' and 'Hide Objs w/' fields in the controls below the map."));
        tagsPane.getChildren().add((Object)tagslabel);
        this.featuresTagsTF.setMaxWidth(120.0);
        this.featuresTagsTF.textProperty().addListener((observable, oldValue, newValue) -> {
            for (Object e : this.mapUI().getCurrentObjects()) {
                if (!(e instanceof Feature)) continue;
                Feature f = (Feature)e;
                this.mapUI().getController().updateFeatureTags(this.worldographer.undoEnabled, f, (String)newValue);
                this.mapUI().draw();
            }
        });
        this.featuresTagsTF.setTooltip(new Tooltip("The selected LFeature will be marked with the tags in the textfield. These tags are used with\nthe 'Show Objs w/' and 'Hide Objs w/' fields in the controls below the map."));
        tagsPane.getChildren().add((Object)this.featuresTagsTF);
        featuresDetailsPane.add((Node)tagsPane, 0, 15, 2, 1);
        featuresDetailsPane.add((Node)this.featuresHideTerrainIconCB, 0, 17);
        Tooltip featuresHideTerrainIconToolTip = new Tooltip("If checked and the LTerrain in this LFeature's tile location has an icon,\nthe LTerrain icon won't be shown. (Makes the LFeature icon easier to see.)");
        featuresHideTerrainIconToolTip.setFont(new Font("Arial", 11.0));
        this.featuresHideTerrainIconCB.setTooltip(featuresHideTerrainIconToolTip);
        this.featuresHideTerrainIconCB.setOnAction(event -> {
            for (Object e : this.mapUI().getCurrentObjects()) {
                if (!(e instanceof Feature)) continue;
                Feature f = (Feature)e;
                this.mapUI().getController().updateFeatureHideTerrainIcon(this.worldographer.undoEnabled, f, this.featuresHideTerrainIconCB.isSelected());
                this.mapUI().draw();
            }
        });
        featuresDetailsPane.add((Node)this.featuresFillTileBottomCB, 0, 18);
        this.featuresFillTileBottomCB.setTooltip(new Tooltip("Fills the bottom portion (about 25%) of the tile with a solid color. This helps\nthe LFeatures stand out & emulates a particular map style."));
        this.featuresFillTileBottomCB.setOnAction(event -> {
            for (Object e : this.mapUI().getCurrentObjects()) {
                if (!(e instanceof Feature)) continue;
                Feature f = (Feature)e;
                this.mapUI().getController().updateFeatureFillHexBottom(this.worldographer.undoEnabled, f, this.featuresFillTileBottomCB.isSelected());
                this.mapUI().draw();
            }
        });
        featuresDetailsPane.add((Node)this.featuresPlaceFreelyCB, 0, 19);
        Tooltip featuresPlaceFreelyToolTip = new Tooltip("If checked, the LFeature icon won't be anchored to the center of a specific tile.");
        featuresPlaceFreelyToolTip.setFont(new Font("Arial", 11.0));
        this.featuresPlaceFreelyCB.setTooltip(featuresPlaceFreelyToolTip);
        this.featuresPlaceFreelyCB.setOnAction(event -> {
            for (Object e : this.mapUI().getCurrentObjects()) {
                if (!(e instanceof Feature)) continue;
                Feature f = (Feature)e;
                this.mapUI().getController().updateFeaturePlaceFreely(this.worldographer.undoEnabled, f, this.featuresPlaceFreelyCB.isSelected());
                this.mapUI().draw();
            }
        });
        featuresDetailsPane.add((Node)this.featuresGMOnlyCB, 0, 20);
        this.featuresGMOnlyCB.setTooltip(new Tooltip("The selected LFeature will be marked as 'GM Only'. So if the 'GM Only' checkbox on\nWorldographer's bottom toolbar is un-checked, the LFeature won't be shown."));
        ScrollPane featureDetailsScrollPane = new ScrollPane((Node)featuresDetailsPane);
        featureDetailsScrollPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        return featureDetailsScrollPane;
    }

    public void clearFeatureButtons() {
        this.featureButtons.clear();
    }

    private void setupFeatureButtonContextMenu(ContextMenuEvent event1, String fave, String typename) {
        ContextMenu cm = new ContextMenu();
        MenuItem editMenuItem = new MenuItem("Configure");
        cm.getItems().add((Object)editMenuItem);
        editMenuItem.setOnAction(event -> {
            Stage stage = new Stage();
            ConfigureSingleFeatureScreen ss = new ConfigureSingleFeatureScreen(this.worldographer, typename);
            ss.start(stage);
            stage.show();
        });
        if (UserPrefs.FAVORITE_FEATURES.contains(fave)) {
            MenuItem mitem = new MenuItem("Remove From Favorites");
            mitem.setOnAction(event -> {
                int index = UserPrefs.FAVORITE_FEATURES.indexOf(fave);
                if (index >= 0) {
                    UserPrefs.FAVORITE_FEATURES = UserPrefs.FAVORITE_FEATURES.substring(0, index) + UserPrefs.FAVORITE_FEATURES.substring(index + fave.length());
                    UserPrefs.PREFS.put("favorites features", UserPrefs.FAVORITE_FEATURES);
                    try {
                        UserPrefs.PREFS.flush();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    this.updateFeatureButtons();
                }
            });
            cm.getItems().add((Object)mitem);
        } else {
            MenuItem mitem = new MenuItem("Add To Favorites");
            mitem.setOnAction(event -> {
                UserPrefs.FAVORITE_FEATURES = UserPrefs.FAVORITE_FEATURES + fave;
                UserPrefs.PREFS.put("favorites features", UserPrefs.FAVORITE_FEATURES);
                try {
                    UserPrefs.PREFS.flush();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
            cm.getItems().add((Object)mitem);
        }
        cm.setAnchorX(event1.getScreenX());
        cm.setAnchorY(event1.getScreenY());
        cm.show((Window)this.worldographer.getPrimaryStage());
    }

    private HBox createFilterBox() {
        HBox filterBox = new HBox();
        filterBox.setAlignment(Pos.CENTER);
        Label filterLabel = new Label("");
        FontIcon filterIcon = new FontIcon();
        filterIcon.setStyle("-fx-icon-code:mdi2f-filter;-fx-icon-size:32;");
        filterLabel.setGraphic((Node)filterIcon);
        filterLabel.setTooltip(new Tooltip("Filter Feature items in the list by name."));
        filterBox.getChildren().add((Object)filterLabel);
        filterBox.getChildren().add((Object)this.featureFilterTF);
        this.featureFilterTF.setOnAction(event -> this.updateFeatureButtons());
        this.featureFilterTF.setMaxWidth(100.0);
        this.featureFilterTF.setTooltip(new Tooltip("Filter Feature items in the list by name."));
        Label spacer = new Label(" ");
        filterBox.getChildren().add((Object)spacer);
        this.featureFilterComboBox.getSelectionModel().select((Object)"All Features");
        this.featureFilterComboBox.setTooltip(new Tooltip("Filter Feature items in the list by type."));
        this.featureFilterComboBox.setOnAction(event -> this.updateFeatureButtons());
        filterBox.getChildren().add(this.featureFilterComboBox);
        return filterBox;
    }

    private HBox createSelectNoteConfigureDeleteBox() {
        HBox featuresSelectBox = new HBox();
        featuresSelectBox.getChildren().add((Object)this.featuresSelectButton);
        featuresSelectBox.getChildren().add((Object)new Label(" "));
        this.featuresNoteButton.setOnAction(event -> {
            FeaturesToolbox featuresToolbox = this;
            this.generateNote(featuresToolbox.worldographer.getMapUI().getViewLevel());
        });
        featuresSelectBox.getChildren().add((Object)this.featuresNoteButton);
        Button configureFeaturesnButton = Toolbox.makeButtonWithStyleIcon("Configure", "mdi2c-cog", 32, "-fx-font-size: 9px", "Configure Features\nOpens a dialog to configure LTerrain (change the icon, size, etc.)", 60, 70);
        configureFeaturesnButton.setOnAction(event -> new ConfigurationDialog().launchConfigureFeatures(this.worldographer));
        featuresSelectBox.getChildren().add((Object)configureFeaturesnButton);
        featuresSelectBox.getChildren().add((Object)this.useSimilarNamedFeaturesButton);
        featuresSelectBox.getChildren().add((Object)this.featuresDeleteButton);
        this.featuresDeleteButton.setOnAction(event -> this.deleteFeature());
        return featuresSelectBox;
    }

    private void generateNote(ViewLevel vl) {
        for (MapObject mo : this.mapUI().getCurrentObjects()) {
            if (!(mo instanceof Feature)) continue;
            Feature f = (Feature)mo;
            Note found = null;
            for (Note n : this.mapUI().getMapData().getNotes()) {
                Feature pf;
                if (n.getParent() == null || n.getParent() == null || (pf = n.getParent()).getUUID() != f.getUUID()) continue;
                found = n;
                break;
            }
            if (found == null) {
                Point2D loc = f.getLocation(this.mapUI().viewLevel);
                found = new Note(this.mapUI().viewLevel, loc.getX(), loc.getY());
                if (found.getDetails() == null || found.getDetails().equals("")) {
                    found.generateNoteInfo(vl, f.getTypeName());
                }
                found.setParent(f);
                this.mapUI().getMapData().getNotes().add(found);
            }
            this.worldographer.popNoteDialog(found);
        }
    }

    public HBox createSizeBox() {
        HBox sizeBox = new HBox();
        sizeBox.setAlignment(Pos.CENTER);
        Label sizeLabel = new Label("Icon Size");
        FontIcon sizeIcon = new FontIcon();
        sizeIcon.setStyle("-fx-icon-code:mdi2i-image-size-select-small;-fx-icon-size:28;");
        sizeLabel.setGraphic((Node)sizeIcon);
        sizeLabel.setStyle("-fx-font-size: 9px");
        sizeLabel.setTextAlignment(TextAlignment.CENTER);
        sizeLabel.setTextOverrun(OverrunStyle.ELLIPSIS);
        sizeLabel.setContentDisplay(ContentDisplay.TOP);
        sizeLabel.setTooltip(new Tooltip("Change icon size."));
        sizeBox.getChildren().add((Object)sizeLabel);
        this.iconSizeSpinner.setTooltip(new Tooltip("Change icon size."));
        this.iconSizeSpinner.setMinWidth(70.0);
        this.iconSizeSpinner.setMaxWidth(70.0);
        this.iconSizeSpinner.setEditable(true);
        this.iconSizeSpinner.valueProperty().addListener((obs, oldValue, newValue) -> Platform.runLater(() -> this.updateFeatureButtons()));
        sizeBox.getChildren().add(this.iconSizeSpinner);
        return sizeBox;
    }

    public Node createFeatureLabelPane() {
        boolean undoEnabled = false;
        GridPane featuresLabelGrid = new GridPane();
        Label labelLabel = new Label("Label:");
        labelLabel.setTooltip(new Tooltip("The text entered here will be placed near (usually below) the selected LFeature."));
        featuresLabelGrid.add((Node)labelLabel, 0, 0, 2, 1);
        this.featuresLabelTA.setMaxWidth(500.0);
        this.featuresLabelTA.setPrefWidth(100.0);
        this.featuresLabelTA.setTooltip(new Tooltip("The text entered here will be placed near (usually below) the selected LFeature."));
        this.featuresLabelTA.textProperty().addListener((observable, oldValue, newValue) -> {
            for (Object e : this.mapUI().getCurrentObjects()) {
                if (!(e instanceof Feature)) continue;
                this.mapUI().getController().createOrUpdateFeatureMapLabel(undoEnabled, (Feature)e, (String)this.featureLabelStyleCombo.getSelectionModel().getSelectedItem(), this.featuresLabelTA.getText(), (String)this.featuresLabelFontCombo.getSelectionModel().getSelectedItem(), (Color)this.featuresLabelColorCP.getValue(), (Double)this.featuresLabelScale.getValue(), (Color)this.featuresLabelOutlineColorCP.getValue(), (Color)this.featuresLabelBackgroundCP.getValue(), 0.0, this.featuresLabelBold.isSelected(), this.featuresLabelItalic.isSelected(), (MapLayer)this.featuresMapLayerCombo.getSelectionModel().getSelectedItem());
                this.mapUI().draw();
            }
        });
        featuresLabelGrid.add((Node)this.featuresLabelTA, 0, 1, 2, 1);
        Label labeldistancelabel = new Label("Distance:");
        labeldistancelabel.setTooltip(new Tooltip("How far away from the LFeature will the text label be placed."));
        featuresLabelGrid.add((Node)labeldistancelabel, 0, 2);
        this.featuresLabelDistance.setMaxWidth(100.0);
        this.featuresLabelDistance.setTooltip(new Tooltip("How far away from the LFeature will the text label be placed."));
        this.featuresLabelDistance.setEditable(true);
        featuresLabelGrid.add(this.featuresLabelDistance, 1, 2);
        this.featuresLabelDistance.valueProperty().addListener((observable, oldValue, newValue) -> {
            for (Object e : this.mapUI().getCurrentObjects()) {
                if (!(e instanceof Feature)) continue;
                this.mapUI().getController().updateFeatureLabelDistance(undoEnabled, (Feature)e, (Integer)this.featuresLabelDistance.getValue());
                this.mapUI().draw();
            }
        });
        Label labelpositionlabel = new Label("Position:");
        labelpositionlabel.setTooltip(new Tooltip("In which direction (based on clock positions) will the text label be placed."));
        featuresLabelGrid.add((Node)labelpositionlabel, 0, 4);
        this.featuresLabelPositionSpinner.setMaxWidth(100.0);
        this.featuresLabelPositionSpinner.setTooltip(new Tooltip("In which direction (based on clock positions) will the text label be placed."));
        featuresLabelGrid.add(this.featuresLabelPositionSpinner, 1, 4);
        this.featuresLabelPositionSpinner.valueProperty().addListener((observable, oldValue, newValue) -> {
            for (Object e : this.mapUI().getCurrentObjects()) {
                if (!(e instanceof Feature)) continue;
                Feature fe = (Feature)e;
                this.mapUI().getController().updateFeatureLabelPosition(undoEnabled, fe, (Double)this.featuresLabelPositionSpinner.getValue());
                this.mapUI().draw();
            }
        });
        Label labelrotationlabel = new Label("Rotation:");
        labelrotationlabel.setTooltip(new Tooltip("How much will the text label be rotated."));
        featuresLabelGrid.add((Node)labelrotationlabel, 0, 5);
        this.featuresLabelRotationSpinner.setMaxWidth(100.0);
        this.featuresLabelRotationSpinner.setTooltip(new Tooltip("How much will the text label be rotated (degrees)."));
        featuresLabelGrid.add(this.featuresLabelRotationSpinner, 1, 5);
        this.featuresLabelRotationSpinner.valueProperty().addListener((observable, oldValue, newValue) -> {
            for (Object e : this.mapUI().getCurrentObjects()) {
                if (!(e instanceof Feature)) continue;
                Feature fe = (Feature)e;
                this.mapUI().getController().updateFeatureLabelRotation(undoEnabled, fe, (Double)this.featuresLabelRotationSpinner.getValue());
                this.mapUI().draw();
            }
        });
        Label labelstylelabel = new Label("Label Style:");
        labelstylelabel.setTooltip(new Tooltip("Select a pre-set style or 'No Preset Style' to use the settings below.\nConfigure label styles using the via the option on the Configure menu."));
        featuresLabelGrid.add((Node)labelstylelabel, 0, 6);
        ArrayList<String> styles = new ArrayList<String>();
        styles.add("No Preset Style");
        styles.addAll(Worldographer.getMapUI().getMapData().getLabelStyles().keySet());
        ObservableList soptions = FXCollections.observableArrayList(styles);
        this.featureLabelStyleCombo = new ComboBox(soptions);
        this.featureLabelStyleCombo.setMaxWidth(100.0);
        this.featureLabelStyleCombo.setTooltip(new Tooltip("Select a pre-set style or 'No Preset Style' to use the settings below.\nConfigure label styles using the via the option on the Configure menu."));
        this.featureLabelStyleCombo.getSelectionModel().select((Object)LabelStyle.CITY.getName());
        this.featureLabelStyleCombo.valueProperty().addListener((observable, oldValue, newValue) -> {
            for (Object e : this.mapUI().getCurrentObjects()) {
                if (!(e instanceof Feature)) continue;
                Feature f = (Feature)e;
                MapLabel label = f.getLabel();
                this.mapUI().getController().updateLabelStyle(undoEnabled, label, (String)newValue);
                this.mapUI().draw();
            }
        });
        featuresLabelGrid.add(this.featureLabelStyleCombo, 1, 6);
        Label featuresLabelHeading = new Label("If Style is \"No Preset Style\":");
        Font fl = featuresLabelHeading.getFont();
        fl = Font.font((String)fl.getFamily(), (FontWeight)FontWeight.BOLD, (FontPosture)FontPosture.REGULAR, (double)(fl.getSize() + 2.0));
        featuresLabelHeading.setFont(fl);
        featuresLabelGrid.add((Node)featuresLabelHeading, 0, 8, 2, 1);
        Label labelfontlabel = new Label("Label Font:");
        featuresLabelGrid.add((Node)labelfontlabel, 0, 9);
        this.featuresLabelFontCombo.setMaxWidth(100.0);
        this.featuresLabelFontCombo.getSelectionModel().select(0);
        featuresLabelGrid.add(this.featuresLabelFontCombo, 1, 9);
        this.featuresLabelFontCombo.valueProperty().addListener((observable, oldValue, newValue) -> {
            for (Object e : this.mapUI().getCurrentObjects()) {
                if (!(e instanceof Feature)) continue;
                this.mapUI().getController().updateLabelFontFace(undoEnabled, ((Feature)e).getLabel(), (String)this.featuresLabelFontCombo.getSelectionModel().getSelectedItem());
                this.mapUI().draw();
            }
        });
        Label labelcolorlabel = new Label("Label Color:");
        featuresLabelGrid.add((Node)labelcolorlabel, 0, 11);
        if (this.featuresOverrideColorBGCP.getCustomColors().size() <= 1) {
            this.featuresOverrideColorBGCP.getCustomColors().addAll((Object[])Worldographer.customColors);
        }
        this.featuresLabelColorCP.setMaxWidth(100.0);
        featuresLabelGrid.add(this.labelColorPickerWSelector.getNode(), 1, 11);
        this.featuresLabelColorCP.setOnAction(event -> {
            for (Object e : this.mapUI().getCurrentObjects()) {
                if (!(e instanceof Feature)) continue;
                Color newval = (Color)this.featuresLabelColorCP.getValue();
                this.mapUI().getController().updateLabelColor(undoEnabled, ((Feature)e).getLabel(), newval);
                this.mapUI().draw();
            }
        });
        featuresLabelGrid.add((Node)new Label("Outline Size:"), 0, 13);
        this.featuresLabelOutlineSizeSpinner.valueProperty().addListener((observable, oldValue, newValue) -> {
            for (Object e : this.mapUI().getCurrentObjects()) {
                if (!(e instanceof Feature)) continue;
                this.mapUI().getController().updateLabelOutlineSize(undoEnabled, ((Feature)e).getLabel(), (Double)this.featuresLabelOutlineSizeSpinner.getValue());
                this.mapUI().draw();
            }
        });
        this.featuresLabelOutlineSizeSpinner.setMaxWidth(100.0);
        featuresLabelGrid.add(this.featuresLabelOutlineSizeSpinner, 1, 13);
        if (this.featuresLabelOutlineColorCP.getCustomColors().size() <= 1) {
            this.featuresLabelOutlineColorCP.getCustomColors().addAll((Object[])Worldographer.customColors);
        }
        featuresLabelGrid.add((Node)new Label("Outline Color:"), 0, 15);
        this.featuresLabelOutlineColorCP.setMaxWidth(100.0);
        featuresLabelGrid.add(this.labelOutlineColorPickerWSelector.getNode(), 1, 15);
        this.featuresLabelOutlineColorCP.setOnAction(event -> {
            for (Object e : this.mapUI().getCurrentObjects()) {
                if (!(e instanceof Feature)) continue;
                Color newval = (Color)this.featuresLabelOutlineColorCP.getValue();
                this.mapUI().getController().updateLabelOutlineColor(undoEnabled, ((Feature)e).getLabel(), newval);
                this.mapUI().draw();
            }
        });
        Label labelscalelabel = new Label("Size (tile ht%):");
        featuresLabelGrid.add((Node)labelscalelabel, 0, 17);
        this.featuresLabelScale.setMaxWidth(80.0);
        featuresLabelGrid.add(this.featuresLabelScale, 1, 17);
        this.featuresLabelScale.valueProperty().addListener((observable, oldValue, newValue) -> {
            for (Object e : this.mapUI().getCurrentObjects()) {
                if (!(e instanceof Feature)) continue;
                this.mapUI().getController().updateLabelScale(undoEnabled, ((Feature)e).getLabel(), ((Feature)e).getLabel().getScale(this.mapUI().viewLevel), (Double)this.featuresLabelScale.getValue());
                this.mapUI().draw();
            }
        });
        Font f = this.featuresLabelBold.getFont();
        f = Font.font((String)f.getFamily(), (FontWeight)FontWeight.BOLD, (FontPosture)FontPosture.REGULAR, (double)f.getSize());
        this.featuresLabelBold.setFont(f);
        this.featuresLabelBold.setOnAction(event -> {
            for (Object e : this.mapUI().getCurrentObjects()) {
                if (!(e instanceof Feature)) continue;
                this.mapUI().getController().updateLabelBold(undoEnabled, ((Feature)e).getLabel(), this.featuresLabelBold.isSelected());
                this.mapUI().draw();
            }
        });
        featuresLabelGrid.add((Node)new Label("Style:"), 0, 19);
        HBox styleBox = new HBox();
        styleBox.getChildren().add((Object)this.featuresLabelBold);
        f = this.featuresLabelItalic.getFont();
        f = Font.font((String)f.getFamily(), (FontWeight)FontWeight.NORMAL, (FontPosture)FontPosture.ITALIC, (double)f.getSize());
        this.featuresLabelItalic.setFont(f);
        this.featuresLabelItalic.setOnAction(event -> {
            for (Object e : this.mapUI().getCurrentObjects()) {
                if (!(e instanceof Feature)) continue;
                this.mapUI().getController().updateLabelItalic(undoEnabled, ((Feature)e).getLabel(), this.featuresLabelItalic.isSelected());
                this.mapUI().draw();
            }
        });
        styleBox.getChildren().add((Object)this.featuresLabelItalic);
        featuresLabelGrid.add((Node)styleBox, 1, 19);
        HBox bgBox = new HBox();
        featuresLabelGrid.add((Node)bgBox, 0, 21, 2, 1);
        bgBox.getChildren().add((Object)this.featuresLabelBackground);
        this.featuresLabelBackground.setAlignment(Pos.CENTER_LEFT);
        this.featuresLabelBackground.setOnAction(event -> {
            for (Object e : this.mapUI().getCurrentObjects()) {
                if (!(e instanceof Feature)) continue;
                Color newval = this.featuresLabelBackground.isSelected() ? (Color)this.featuresLabelBackgroundCP.getValue() : null;
                this.mapUI().getController().updateLabelBackgroundColor(undoEnabled, ((Feature)e).getLabel(), newval);
                this.mapUI().draw();
            }
        });
        this.featuresLabelBackgroundCP.setMaxWidth(100.0);
        bgBox.getChildren().add((Object)this.labelBackgroundColorPickerWSelector.getNode());
        this.featuresLabelBackgroundCP.setOnAction(event -> {
            for (Object e : this.mapUI().getCurrentObjects()) {
                if (!(e instanceof Feature)) continue;
                Color newval = this.featuresLabelBackground.isSelected() ? (Color)this.featuresLabelBackgroundCP.getValue() : null;
                this.mapUI().getController().updateLabelBackgroundColor(undoEnabled, ((Feature)e).getLabel(), newval);
                this.mapUI().draw();
            }
        });
        return featuresLabelGrid;
    }

    public Node createFeatureDecorationsPane() {
        GridPane featuresDecorationGrid = new GridPane();
        featuresDecorationGrid.setAlignment(Pos.CENTER);
        Label featuredeclabel = new Label("Feature Decorations:");
        Font f2 = featuredeclabel.getFont();
        f2 = Font.font((String)f2.getFamily(), (FontWeight)FontWeight.BOLD, (FontPosture)FontPosture.REGULAR, (double)(f2.getSize() + 2.0));
        featuredeclabel.setFont(f2);
        HBox featuredecbox = new HBox();
        HBox.setHgrow((Node)featuredeclabel, (Priority)Priority.ALWAYS);
        featuredeclabel.setMaxWidth(Double.MAX_VALUE);
        featuredecbox.getChildren().add((Object)featuredeclabel);
        Button featureDecHelpButton = new Button("", (Node)new ImageView(LoadImage.image("other_imgs/question.png")));
        featureDecHelpButton.setPadding(new Insets(1.0, 1.0, 1.0, 1.0));
        featureDecHelpButton.setOnAction(event -> StandardDialog.showDialog(this.worldographer.getPrimaryStage(), "Feature Decoration Instructions", "Feature Decoration Instructions", "Feature decorations are symbols or letters which will appear around the feature at a specified clock position.\n\nThey were originally added for some science fiction game maps which use various symbols (such as triangles, \ncircles, etc.) to denote if the star system has a military base, a space station, etc.) But you can also use them \nto denote the strength of a castle, number of troops, etc.\n\nInstructions:\n1. Check the box to include that row as a feature decoration.\n2. Enter text to display in the text box. One character is best.\n3. Select a clock position for the decoration's location.\n4. Choose the text color.\n\nThe settings will be used for any features you add after you set up the above. They will also change for a feature \nthat is currently selected.\n", null, null));
        featuredecbox.getChildren().add((Object)featureDecHelpButton);
        featuresDecorationGrid.add((Node)featuredecbox, 0, 0, 4, 1);
        Label featuredecoptionslabel = new Label("Copy/paste Symbols:");
        featuresDecorationGrid.add((Node)featuredecoptionslabel, 0, 1, 4, 1);
        TextField specialTF = new TextField("\u25a0 \u25a1 \u25b2 \u25b3 \u25c6 \u25c7 \u25cf \u25cb \u03c0 \u272a \u272d \u2191 \u03b1 \u03b2 \u03b3");
        specialTF.setEditable(false);
        featuresDecorationGrid.add((Node)specialTF, 0, 2, 4, 1);
        for (int i = 0; i < 8; ++i) {
            int index = i;
            this.featureDecorationCheckbox[i] = new CheckBox("");
            this.featureDecorationCheckbox[i].setSelected(false);
            this.featureDecorationCheckbox[i].setOnAction(event -> {
                for (Object e : this.mapUI().getCurrentObjects()) {
                    if (!(e instanceof Feature)) continue;
                    Feature fe = (Feature)e;
                    if (this.featureDecorationCheckbox[index].isSelected()) {
                        FeatureDecoration fd = new FeatureDecoration(this.featureDecorationStringTF[index].getText(), (Color)this.featureDecorationCP[index].getValue(), (Double)this.featureDecorationLocationSpinner[index].getValue());
                        this.mapUI().getController().updateFeatureDecoration(this.worldographer.undoEnabled, fe, index, fd);
                    } else {
                        this.mapUI().getController().updateFeatureDecoration(this.worldographer.undoEnabled, fe, index, null);
                    }
                    this.mapUI().draw();
                }
            });
            featuresDecorationGrid.add((Node)this.featureDecorationCheckbox[i], 0, i + 3);
            this.featureDecorationStringTF[i] = new TextField();
            this.featureDecorationStringTF[i].setMaxWidth(35.0);
            this.featureDecorationStringTF[i].setMinWidth(35.0);
            this.featureDecorationStringTF[i].textProperty().addListener((observable, oldValue, newValue) -> {
                for (Object e : this.mapUI().getCurrentObjects()) {
                    if (!(e instanceof Feature)) continue;
                    Feature fe = (Feature)e;
                    if (!this.featureDecorationCheckbox[index].isSelected()) continue;
                    this.mapUI().getController().updateFeatureDecorationString(this.worldographer.undoEnabled, fe, index, this.featureDecorationStringTF[index].getText());
                    this.mapUI().draw();
                }
            });
            featuresDecorationGrid.add((Node)this.featureDecorationStringTF[i], 1, i + 3);
            this.featureDecorationLocationSpinner[i] = new Spinner(0.0, 360.0, 0.0, 15.0);
            this.featureDecorationLocationSpinner[i].setEditable(true);
            this.featureDecorationLocationSpinner[i].setMaxWidth(90.0);
            this.featureDecorationLocationSpinner[i].valueProperty().addListener((observable, oldValue, newValue) -> {
                for (Object e : this.mapUI().getCurrentObjects()) {
                    if (!(e instanceof Feature)) continue;
                    Feature fe = (Feature)e;
                    if (!this.featureDecorationCheckbox[index].isSelected()) continue;
                    this.mapUI().getController().updateFeatureDecorationLocation(this.worldographer.undoEnabled, fe, index, (Double)this.featureDecorationLocationSpinner[index].getValue());
                    this.mapUI().draw();
                }
            });
            featuresDecorationGrid.add(this.featureDecorationLocationSpinner[i], 2, i + 3);
            this.featureDecorationCP[i] = new ColorPicker();
            this.featureDecorationCP[i].setMaxWidth(50.0);
            this.featureDecorationCP[i].setOnAction(event -> {
                for (Object e : this.mapUI().getCurrentObjects()) {
                    if (!(e instanceof Feature)) continue;
                    Feature fe = (Feature)e;
                    if (!this.featureDecorationCheckbox[index].isSelected()) continue;
                    this.mapUI().getController().updateFeatureDecorationColor(this.worldographer.undoEnabled, fe, index, (Color)this.featureDecorationCP[index].getValue());
                    this.mapUI().draw();
                }
            });
            featuresDecorationGrid.add((Node)this.featureDecorationCP[i], 3, i + 3);
        }
        return featuresDecorationGrid;
    }

    public void updateFeatureButtons() {
        int size = (Integer)this.iconSizeSpinner.getValue();
        if (this.featuresFlowPane == null) {
            return;
        }
        this.featuresFlowPane.getChildren().removeAll((Collection)this.featuresFlowPane.getChildren());
        this.featuresFlowPane.setHgap(4.0);
        this.featuresFlowPane.setVgap(4.0);
        String[] filterTokens = this.featureFilterTF.getText().toLowerCase().split(" ");
        Object[] featuretypenames = Feature.featureTypes.keySet().toArray();
        if (featuretypenames.length == 0) {
            Feature.restoreDefaults(null, false);
        }
        for (Object o : featuretypenames = Feature.featureTypes.keySet().toArray()) {
            String typename = ((String)o).toLowerCase();
            Feature f = new Feature((String)o);
            String fave = "\t" + f.getTypeName() + "\t";
            boolean hasAllFilterTokens = true;
            for (String token : filterTokens) {
                if (typename.contains(token)) continue;
                hasAllFilterTokens = false;
                break;
            }
            if (f.type() == null && f.type() != null) {
                f.setType((String)o);
            }
            if (f.type() == null || !hasAllFilterTokens || f.type().getIcon() == null || !"All Features".equals(this.featureFilterComboBox.getSelectionModel().getSelectedItem()) && (!"Favorites".equals(this.featureFilterComboBox.getSelectionModel().getSelectedItem()) || !UserPrefs.FAVORITE_FEATURES.contains(fave)) && !typename.toLowerCase(Locale.ROOT).contains(((String)this.featureFilterComboBox.getSelectionModel().getSelectedItem()).toLowerCase(Locale.ROOT) + "/")) continue;
            ToggleButton button = this.featureButtons.get(f.getTypeName() + ":" + size);
            if (button == null) {
                button = new ToggleButton();
                this.createFeatureButton(f, button, true, size);
                this.featureButtons.put(f.getTypeName() + ":" + size, button);
                button.setOnContextMenuRequested(event1 -> this.setupFeatureButtonContextMenu((ContextMenuEvent)event1, fave, f.getTypeName()));
            }
            button.setMinSize((double)size * 1.2, (double)size * 1.2);
            button.setMaxSize((double)size * 1.2, (double)size * 2.4);
            button.setTextAlignment(TextAlignment.CENTER);
            button.setAlignment(Pos.TOP_CENTER);
            this.featuresFlowPane.getChildren().add((Object)button);
        }
        if (this.mapUI() != null) {
            this.mapUI().lastFeatureFilterCombo = (String)this.featureFilterComboBox.getValue();
            this.mapUI().lastFeatureFilterText = this.featureFilterTF.getText();
        }
    }

    public void setFeatureButtonImage(Feature feature, ToggleButton button, String tn, double size) {
        ImageView iv;
        if (tn.startsWith("ISO Cols ")) {
            iv = new ImageView(feature.type().getIcon());
            iv.setFitHeight(size * 0.9);
            iv.setFitWidth(size * 1.4);
        } else if (tn.startsWith("ISO Rows ")) {
            iv = new ImageView(feature.type().getIcon());
            iv.setFitHeight(size * 1.4);
            iv.setFitWidth(size * 0.9);
        } else {
            Image icon = feature.type().getIcon();
            iv = new ImageView(icon);
            iv.setPreserveRatio(true);
            iv.setFitHeight(size);
            iv.setFitWidth(size);
        }
        button.setGraphic((Node)iv);
    }

    public ToggleButton createFeatureButton(Feature f, ToggleButton button, boolean addToToggleGroup, double size) {
        String tn = f.getTypeName();
        this.setFeatureButtonImage(f, button, tn, size);
        if (tn.contains("/")) {
            tn = tn.substring(tn.lastIndexOf(47) + 1);
        }
        if (tn.startsWith("ISO Cols ") || tn.startsWith("ISO Rows ")) {
            tn = tn.substring(9);
        }
        tn = tn.replace("Deciduous", "Decid.");
        tn = tn.replace("Evergreen", "Evrgr.");
        tn = tn.replace("Mountain", "Mtn");
        tn = tn.replace("Heavy", "Hvy");
        tn = tn.replace("Light", "Lt");
        button.setText(tn);
        button.setWrapText(true);
        button.setStyle("-fx-font-size: 9px");
        button.setUserData((Object)f);
        if (addToToggleGroup) {
            button.setToggleGroup(this.worldographer.toggleGroup);
        }
        button.setTooltip(new Tooltip(f.getTypeName()));
        button.setMinSize(size * 1.2, size * 1.2);
        button.setMaxSize(size * 1.2, size * 2.4);
        button.setTextAlignment(TextAlignment.CENTER);
        button.setAlignment(Pos.TOP_CENTER);
        button.setTextOverrun(OverrunStyle.ELLIPSIS);
        button.setContentDisplay(ContentDisplay.TOP);
        return button;
    }

    public void updateSelectionControls(Feature f) {
        this.featuresHideTerrainIconCB.setSelected(f.isHideTerrainIcon());
        this.featuresPlaceFreelyCB.setSelected(f.isPlaceFreely());
        this.featuresOverrideColorCB.setSelected(f.getOverrideColor() != null);
        this.featuresOverrideColorBGCP.setValue((Object)f.getOverrideColor());
        this.featuresFillTileBottomCB.setSelected(f.isFillHexBottom());
        this.featuresRing.setSelected(f.getRing() != null);
        this.featureFlipHorizontalCB.setSelected(f.isHorizontalFlip());
        this.featureFlipVerticalCB.setSelected(f.isVerticalFlip());
        this.featuresMapLayerCombo.getSelectionModel().select((Object)f.getMapLayer());
        if (f.getRing() != null) {
            this.featuresRingColorCP.setValue((Object)f.getRing());
        }
        this.featuresScaleCB.setSelected(!(f.getScale() < 0.0));
        this.featuresScaleSpinner.getValueFactory().setValue((Object)f.getScale());
        this.featuresScaleHtCB.setSelected(!(f.getScaleHt() < 0.0));
        this.featuresScaleHtSpinner.getValueFactory().setValue((Object)f.getScaleHt());
        this.featuresRotateSpinner.getValueFactory().setValue((Object)(f.getRotate() % 360.0));
        this.featuresGMOnlyCB.setSelected(f.isGmOnly());
        this.featuresTagsTF.setText(f.getTags());
        if (f.getLabel() != null) {
            this.featuresLabelTA.setText(f.getLabel().getText());
        } else {
            this.featuresLabelTA.setText("");
        }
        if (f.getLabel() != null) {
            this.featureLabelStyleCombo.setValue((Object)f.getLabel().getStyle());
            this.featuresLabelFontCombo.setValue((Object)f.getLabel().getFontFace());
            this.featuresLabelColorCP.setValue((Object)f.getLabel().getColor());
            this.featuresLabelOutlineSizeSpinner.getValueFactory().setValue((Object)f.getLabel().getOutlineSize());
            this.featuresLabelOutlineColorCP.setValue((Object)f.getLabel().getOutlineColor());
            FeaturesToolbox featuresToolbox = this;
            if (f.getLabel().getScale(featuresToolbox.worldographer.getMapUI().viewLevel) != null) {
                FeaturesToolbox featuresToolbox2 = this;
                this.featuresLabelScale.getValueFactory().setValue((Object)f.getLabel().getScale(featuresToolbox2.worldographer.getMapUI().viewLevel));
            }
            this.featuresLabelBold.setSelected(f.getLabel().isBold());
            this.featuresLabelItalic.setSelected(f.getLabel().isItalic());
            this.featuresLabelDistance.getValueFactory().setValue((Object)f.getLabelDistance());
            this.featuresLabelPositionSpinner.getValueFactory().setValue((Object)f.getLabelPosition());
            this.featuresLabelBackground.setSelected(f.getLabel().getBackgroundColor() != null);
            if (f.getLabel().getBackgroundColor() != null) {
                this.featuresLabelBackgroundCP.setValue((Object)f.getLabel().getBackgroundColor());
            }
        }
        this.featureContinentCB.setSelected(f.isContinent());
        this.featureKingdomCB.setSelected(f.isKingdom());
        this.featureWorldCB.setSelected(f.isWorld());
        this.featureProvinceCB.setSelected(f.isProvince());
        for (int i = 0; i < f.getFeatureDecorations().length; ++i) {
            if (f.getFeatureDecorations()[i] == null) {
                this.featureDecorationCheckbox[i].setSelected(false);
                continue;
            }
            this.featureDecorationCheckbox[i].setSelected(true);
            this.featureDecorationStringTF[i].setText(f.getFeatureDecorations()[i].getText());
            this.featureDecorationLocationSpinner[i].getValueFactory().setValue((Object)f.getFeatureDecorations()[i].getLocation());
            this.featureDecorationCP[i].setValue((Object)f.getFeatureDecorations()[i].getColor());
        }
    }

    public void handleMouseMoved(double x, double y, Feature f) {
        MapLayer layer;
        Point2D modelpt;
        if (!this.featuresPlaceFreelyCB.isSelected()) {
            FeaturesToolbox featuresToolbox = this;
            modelpt = featuresToolbox.worldographer.getMapUI().getSnapFeatureModelPt(x, y, false);
            if (f.getType().getOffsetX() != 0.0 || f.getType().getOffsetY() != 0.0) {
                modelpt = new Point2D(modelpt.getX() + 300.0 * f.getType().getOffsetX(), modelpt.getY() + 300.0 * f.getType().getOffsetY());
            }
        } else {
            FeaturesToolbox featuresToolbox = this;
            Point2D pt = featuresToolbox.worldographer.getMapUI().getModelCoordsFromScreenPt(x, y);
            x = pt.getX();
            y = pt.getY();
            modelpt = new Point2D(x, y);
        }
        if ((layer = (MapLayer)this.featuresMapLayerCombo.getSelectionModel().getSelectedItem()) == null) {
            FeaturesToolbox featuresToolbox = this;
            layer = featuresToolbox.worldographer.getMapUI().getMapData().getMapLayer("Features");
            if (layer == null) {
                layer = new MapLayer("Features");
                FeaturesToolbox featuresToolbox2 = this;
                featuresToolbox2.worldographer.getMapUI().getMapData().getMapLayers().add(1, layer);
            }
        }
        Color ringcolor = this.featuresRing.isSelected() ? (Color)this.featuresRingColorCP.getValue() : null;
        Color overridecolor = this.featuresOverrideColorCB.isSelected() ? (Color)this.featuresOverrideColorBGCP.getValue() : null;
        FeatureDecoration[] fds = new FeatureDecoration[this.featureDecorationCheckbox.length];
        for (int index = 0; index < this.featureDecorationCheckbox.length; ++index) {
            fds[index] = this.featureDecorationCheckbox[index].isSelected() ? new FeatureDecoration(this.featureDecorationStringTF[index].getText(), (Color)this.featureDecorationCP[index].getValue(), (Double)this.featureDecorationLocationSpinner[index].getValue()) : null;
        }
        Color backgroundColor = this.featuresLabelBackground.isSelected() ? (Color)this.featuresLabelBackgroundCP.getValue() : null;
        FeaturesToolbox featuresToolbox = this;
        Feature hoverFeature = Worldographer.getMapUI().getController().createFeature(featuresToolbox.worldographer.getMapUI().getViewLevel(), f.getTypeName(), this.featuresPlaceFreelyCB.isSelected(), this.featuresHideTerrainIconCB.isSelected(), this.featuresGMOnlyCB.isSelected(), this.featuresFillTileBottomCB.isSelected(), ringcolor, (Double)this.featuresRotateSpinner.getValue(), overridecolor, this.featuresScaleCB.isSelected() ? (Double)this.featuresScaleSpinner.getValue() : -1.0, this.featuresScaleHtCB.isSelected() ? (Double)this.featuresScaleHtSpinner.getValue() : -1.0, this.featureFlipHorizontalCB.isSelected(), this.featureFlipVerticalCB.isSelected(), (Integer)this.featuresLabelDistance.getValue(), (Double)this.featuresLabelPositionSpinner.getValue(), this.featuresTagsTF.getText(), this.featureWorldCB.isSelected(), this.featureContinentCB.isSelected(), this.featureKingdomCB.isSelected(), this.featureProvinceCB.isSelected(), layer, (String)this.featureLabelStyleCombo.getSelectionModel().getSelectedItem(), this.featuresLabelTA.getText(), (String)this.featuresLabelFontCombo.getSelectionModel().getSelectedItem(), (Color)this.featuresLabelColorCP.getValue(), (Double)this.featuresLabelOutlineSizeSpinner.getValue(), (Color)this.featuresLabelOutlineColorCP.getValue(), backgroundColor, (Double)this.featuresLabelRotationSpinner.getValue(), false, false, false, false, this.featuresLabelBold.isSelected(), this.featuresLabelItalic.isSelected(), false, 0.0, "", fds);
        FeaturesToolbox featuresToolbox3 = this;
        hoverFeature.setLocation(featuresToolbox3.worldographer.getMapUI().getViewLevel(), modelpt);
        FeaturesToolbox featuresToolbox4 = this;
        FeaturesToolbox featuresToolbox5 = this;
        hoverFeature.getLabel().setLocationAndScale(featuresToolbox4.worldographer.getMapUI().getViewLevel(), new Point2D(modelpt.getX(), modelpt.getY() + (double)hoverFeature.getLabelDistance() / 100.0 * 300.0 + (Double)this.featuresLabelScale.getValue() / 2.0 * 300.0 / featuresToolbox5.worldographer.getMapUI().getMapData().getTileHeight()), (Double)this.featuresLabelScale.getValue());
        FeaturesToolbox featuresToolbox6 = this;
        featuresToolbox6.worldographer.getMapUI().setPlacingObject(hoverFeature);
        FeaturesToolbox featuresToolbox7 = this;
        featuresToolbox7.worldographer.getMapUI().draw();
    }

    public void updateCB(Feature f) {
        if (f.getOverrideColor() != null) {
            this.featuresOverrideColorCB.setSelected(true);
            this.featuresOverrideColorBGCP.setValue((Object)f.getOverrideColor());
        } else {
            this.featuresOverrideColorCB.setSelected(false);
            this.featuresOverrideColorBGCP.setValue(null);
        }
        this.featuresPlaceFreelyCB.setSelected(f.isPlaceFreely());
        this.featuresHideTerrainIconCB.setSelected(f.isHideTerrainIcon());
        this.featuresGMOnlyCB.setSelected(f.isGmOnly());
        this.featuresFillTileBottomCB.setSelected(f.isFillHexBottom());
    }

    public void placeFeature(MouseEvent t, Feature f) {
        this.placeFeature(t, f, this.featuresScaleCB.isSelected() ? (Double)this.featuresScaleSpinner.getValue() : -1.0, this.featuresScaleHtCB.isSelected() ? (Double)this.featuresScaleHtSpinner.getValue() : -1.0);
    }

    public void placeFeature(MouseEvent t, Feature f, double widthscale, double heightscale) {
        if (this.useSimilarNamedFeaturesButton.isSelected()) {
            ArrayList<FeatureType> matchingfeatures = new ArrayList<FeatureType>();
            if (f.getTypeName().lastIndexOf(32) > 2) {
                for (FeatureType f2 : Feature.featureTypes.values()) {
                    String fname = f.getTypeName().substring(0, f.getTypeName().lastIndexOf(32));
                    if (!f2.getType().startsWith(fname) || Math.abs(f2.getType().length() - f.getTypeName().length()) >= 3) continue;
                    matchingfeatures.add(f2);
                }
            }
            if (matchingfeatures.size() > 1) {
                int i = (int)(Math.random() * (double)matchingfeatures.size());
                f = new Feature(((FeatureType)matchingfeatures.get(i)).getType());
            }
        }
        if (f != null) {
            MapLayer layer;
            Point2D modelpt;
            double x = t.getX();
            double y = t.getY();
            if (!this.featuresPlaceFreelyCB.isSelected()) {
                FeaturesToolbox featuresToolbox = this;
                modelpt = featuresToolbox.worldographer.getMapUI().getSnapFeatureModelPt(x, y, false);
                if (f.getType().getOffsetX() != 0.0 || f.getType().getOffsetY() != 0.0) {
                    modelpt = new Point2D(modelpt.getX() + f.getType().getOffsetX() * 300.0, modelpt.getY() + f.getType().getOffsetY() * 300.0);
                }
            } else {
                FeaturesToolbox featuresToolbox = this;
                Point2D pt = featuresToolbox.worldographer.getMapUI().getModelCoordsFromScreenPt(x, y);
                x = pt.getX();
                y = pt.getY();
                modelpt = new Point2D(x, y);
            }
            if ((layer = (MapLayer)this.featuresMapLayerCombo.getSelectionModel().getSelectedItem()) == null) {
                FeaturesToolbox featuresToolbox = this;
                layer = featuresToolbox.worldographer.getMapUI().getMapData().getMapLayer("Features");
                if (layer == null) {
                    layer = new MapLayer("Features");
                    FeaturesToolbox featuresToolbox2 = this;
                    featuresToolbox2.worldographer.getMapUI().getMapData().getMapLayers().add(1, layer);
                }
            }
            Color ringcolor = this.featuresRing.isSelected() ? (Color)this.featuresRingColorCP.getValue() : null;
            Color overridecolor = this.featuresOverrideColorCB.isSelected() ? (Color)this.featuresOverrideColorBGCP.getValue() : null;
            FeatureDecoration[] fds = new FeatureDecoration[this.featureDecorationCheckbox.length];
            for (int index = 0; index < this.featureDecorationCheckbox.length; ++index) {
                fds[index] = this.featureDecorationCheckbox[index].isSelected() ? new FeatureDecoration(this.featureDecorationStringTF[index].getText(), (Color)this.featureDecorationCP[index].getValue(), (Double)this.featureDecorationLocationSpinner[index].getValue()) : null;
            }
            Color backgroundColor = this.featuresLabelBackground.isSelected() ? (Color)this.featuresLabelBackgroundCP.getValue() : null;
            FeaturesToolbox featuresToolbox = this;
            FeaturesToolbox featuresToolbox3 = this;
            Feature featurePlaced = featuresToolbox.worldographer.getMapUI().getController().placeFeature(featuresToolbox3.worldographer.getMapUI().getViewLevel(), modelpt, f.getTypeName(), this.featuresPlaceFreelyCB.isSelected(), this.featuresHideTerrainIconCB.isSelected(), this.featuresGMOnlyCB.isSelected(), this.featuresFillTileBottomCB.isSelected(), ringcolor, (Double)this.featuresRotateSpinner.getValue(), overridecolor, widthscale, heightscale, this.featureFlipHorizontalCB.isSelected(), this.featureFlipVerticalCB.isSelected(), (Integer)this.featuresLabelDistance.getValue(), (Double)this.featuresLabelPositionSpinner.getValue(), this.featuresTagsTF.getText(), this.featureWorldCB.isSelected(), this.featureContinentCB.isSelected(), this.featureKingdomCB.isSelected(), this.featureProvinceCB.isSelected(), layer, (String)this.featureLabelStyleCombo.getSelectionModel().getSelectedItem(), this.featuresLabelTA.getText(), (String)this.featuresLabelFontCombo.getSelectionModel().getSelectedItem(), (Color)this.featuresLabelColorCP.getValue(), (Double)this.featuresLabelOutlineSizeSpinner.getValue(), (Color)this.featuresLabelOutlineColorCP.getValue(), backgroundColor, (Double)this.featuresLabelRotationSpinner.getValue(), false, false, false, false, this.featuresLabelBold.isSelected(), this.featuresLabelItalic.isSelected(), false, 0.0, "", fds, (Double)this.featuresLabelScale.getValue());
            if (this.worldographer.worldographerMenuBar.selectFeatureWhenPlaced.isSelected()) {
                this.featuresSelectButton.setSelected(true);
                Worldographer.getMapUI().getCurrentObjects().clear();
                Worldographer.getMapUI().getCurrentObjects().add(featurePlaced);
                System.out.println(Worldographer.getMapUI().getCurrentObjects().size());
            }
            Worldographer.getMapUI().draw();
        }
    }

    public void initFeaturesControls(boolean undoEnabled) {
        int buttonW = 60;
        int buttonH = 70;
        this.featureFilterTF = new TextField("");
        this.iconSizeSpinner = new Spinner(24, 200, 40, 1);
        this.featureFilterComboBox = new ComboBox();
        this.featureFilterComboBox.setItems(Worldographer.featureCategories);
        this.featuresSelectButton = Toolbox.makeToggleButtonWithStyleIcon("Select", "mdi2s-selection-ellipse-arrow-inside", 32, "-fx-font-size: 9px", "Select\nClick this, then click a Feature on the map to update all the settings on this panel\nto match that Feature. Also when selected, move it, rotate it, or change any of the\nsettings below. Control-click to select multiple LFeatures--this lets you move several\nat once & a setting change on this panel will apply to all of them.", this.worldographer.toggleGroup, buttonW, buttonH);
        this.featuresNoteButton = Toolbox.makeButtonWithStyleIcon("F. Note", "mdi2n-note-text", 32, "-fx-font-size: 9px", "Notes of Selected Feature\nSelect a Feature on the map first, then click this button to pull up a LNote\nassociated with that Feature. If the Feature doesn't have a Note associated, this\nwill generate a Note for many common world/kingdom or city/village Features.", buttonW, buttonH);
        this.useSimilarNamedFeaturesButton = Toolbox.makeToggleButtonWithStyleIcon("Randomize", "mdi2a-alphabetical-variant", 32, "-fx-font-size: 9px", "Randomize\nClick this, then any feature with a similar name (all but the last letter or two matching)\nmay be placed instead of the one you selected.", null, buttonW, buttonH);
        this.featuresDrawBuildingButton = new Button("Draw\nBuilding", (Node)new ImageView(LoadImage.image("other_imgs/delete_selected.png")));
        this.featuresDeleteButton = FeaturesToolbox.makeButtonWithStyleIcon("Delete", "mdi2d-delete", 28, "-fx-font-size: 9px", "Deletes the currently selected shape(s).", buttonW, buttonH);
        this.featuresHideTerrainIconCB = new CheckBox("Hide Terrain Icon");
        this.featuresPlaceFreelyCB = new CheckBox("Place Freely");
        this.featuresOverrideColorCB = new CheckBox("Override Color:");
        this.featuresOverrideColorBGCP = new ColorPicker();
        this.featuresOverrideColorPickerWSelector = new ColorPickerWithSelector(this.featuresOverrideColorBGCP);
        this.featuresFillTileBottomCB = new CheckBox("Fill Tile Bottom");
        this.featuresRing = new CheckBox("Add Ring:");
        this.featuresRingColorCP = new ColorPicker();
        this.featuresRingColorPickerWSelector = new ColorPickerWithSelector(this.featuresRingColorCP);
        this.featuresScaleCB = new CheckBox("Override\nDefault:");
        this.featuresScaleSpinner = new FocusSpinner<Double>(-1.0, 100000.0, 75.0);
        this.featuresScaleSpinner.setMaxWidth(60.0);
        this.featuresScaleHtCB = new CheckBox("Scale Ht.\nSeparate:");
        this.featuresScaleHtSpinner = new FocusSpinner<Double>(-1.0, 100000.0, 75.0);
        this.featuresScaleHtSpinner.setMaxWidth(60.0);
        this.featuresRotateSpinner = new FocusSpinner<Double>(-360.0, 360.0, 0.0);
        this.featuresRotateSpinner.setMaxWidth(60.0);
        this.featureFlipVerticalCB = new CheckBox("");
        FontIcon flipVerticalIcon = new FontIcon();
        flipVerticalIcon.setStyle("-fx-icon-code:mdi2f-flip-vertical;-fx-icon-size:28;");
        this.featureFlipVerticalCB.setGraphic((Node)flipVerticalIcon);
        this.featureFlipHorizontalCB = new CheckBox("");
        FontIcon flipHorizontalIcon = new FontIcon();
        flipHorizontalIcon.setStyle("-fx-icon-code:mdi2f-flip-horizontal;-fx-icon-size:28;");
        this.featureFlipHorizontalCB.setGraphic((Node)flipHorizontalIcon);
        this.featuresGMOnlyCB = new CheckBox("GM Only");
        this.featuresGMOnlyCB.setOnAction(event -> {
            FeaturesToolbox featuresToolbox = this;
            FeaturesToolbox featuresToolbox2 = this;
            featuresToolbox.worldographer.getMapUI().getController().updateGMOnly(undoEnabled, featuresToolbox2.worldographer.getMapUI().getCurrentObjects(), this.featuresGMOnlyCB.isSelected());
            FeaturesToolbox featuresToolbox3 = this;
            featuresToolbox3.worldographer.getMapUI().draw();
        });
        this.featuresTagsTF = new TextField();
        this.featuresMapLayerCombo = new ComboBox(this.worldographer.observableLayers);
        this.featureWorldCB = new CheckBox("World");
        this.featureWorldCB.setSelected(true);
        this.featureContinentCB = new CheckBox("Continent");
        this.featureContinentCB.setSelected(true);
        this.featureKingdomCB = new CheckBox("Kingdom");
        this.featureKingdomCB.setSelected(true);
        this.featureProvinceCB = new CheckBox("Province");
        this.featureProvinceCB.setSelected(true);
        this.featuresLabelTA = new TextArea();
        this.featuresLabelTA.setMaxHeight(40.0);
        this.featuresLabelDistance = new FocusSpinner<Integer>(-10000, 10000, 50);
        this.featuresLabelPositionSpinner = new FocusSpinner<Double>(0.0, 360.0, 180.0, 5.0);
        this.featuresLabelRotationSpinner = new FocusSpinner<Double>(0.0, 360.0, 0.0, 5.0);
        ArrayList<String> styles = new ArrayList<String>();
        styles.add("No Preset Style");
        ObservableList soptions = FXCollections.observableArrayList(styles);
        this.featureLabelStyleCombo = new ComboBox(soptions);
        ObservableList options = FXCollections.observableArrayList((Collection)Font.getFamilies());
        this.featuresLabelFontCombo = new ComboBox(options);
        this.featuresLabelColorCP = new ColorPicker(Color.BLACK);
        this.labelColorPickerWSelector = new ColorPickerWithSelector(this.featuresLabelColorCP);
        this.featuresLabelOutlineSizeSpinner = new FocusSpinner<Double>(0.0, 100.0, 2.0);
        this.featuresLabelOutlineColorCP = new ColorPicker(Color.BLACK);
        this.labelOutlineColorPickerWSelector = new ColorPickerWithSelector(this.featuresLabelOutlineColorCP);
        this.featuresLabelBackgroundCP = new ColorPicker(Color.BLACK);
        this.labelBackgroundColorPickerWSelector = new ColorPickerWithSelector(this.featuresLabelBackgroundCP);
        this.featuresLabelScale = new FocusSpinner<Double>(1.0, 400.0, 25.0);
        this.featuresLabelBold = new CheckBox("Bold");
        this.featuresLabelItalic = new CheckBox("Italic");
        this.featuresLabelBackground = new CheckBox("Background");
    }

    public void deleteFeature() {
        ArrayList<Feature> todelete = new ArrayList<Feature>();
        for (MapObject mo : this.mapUI().getCurrentObjects()) {
            if (!(mo instanceof Feature)) continue;
            this.mapUI().getController().deleteFeature((Feature)mo, null);
            todelete.add((Feature)mo);
            this.mapUI().hoverObject = null;
            this.mapUI().draw();
        }
        this.mapUI().getCurrentObjects().removeAll(todelete);
    }
}

