/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.ui.toolbox;

import com.inkwellideas.ographer.data.MapLayer;
import com.inkwellideas.ographer.data.MapObject;
import com.inkwellideas.ographer.io.LoadImage;
import com.inkwellideas.ographer.io.UserPrefs;
import com.inkwellideas.ographer.map.MapShape;
import com.inkwellideas.ographer.model.ShapeStyle;
import com.inkwellideas.ographer.model.TextureType;
import com.inkwellideas.ographer.ui.Worldographer;
import com.inkwellideas.ographer.ui.configure.ConfigureTexturesScreen;
import com.inkwellideas.ographer.ui.dialog.ConfigurationDialog;
import com.inkwellideas.ographer.ui.dialog.StandardDialog;
import com.inkwellideas.ographer.ui.toolbox.Toolbox;
import com.inkwellideas.ographer.ui.widget.ColorPickerWithSelector;
import com.inkwellideas.ographer.ui.widget.FocusSpinner;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.OverrunStyle;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Spinner;
import javafx.scene.control.SplitPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.ImagePattern;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Arc;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.Path;
import javafx.scene.shape.Polygon;
import javafx.scene.shape.Shape;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.text.TextAlignment;
import javafx.stage.Stage;

public class ShapesToolbox
extends Toolbox {
    public static ToggleButton shapesSelectButton;
    public CheckBox shapeFractalCB;
    public CheckBox shapeDropShadowCB;
    public CheckBox shapeInnerShadowCB;
    public CheckBox shapeBoxBlurCB;
    public Spinner<Double> shapeDropShadowSpreadTF;
    public Spinner<Double> shapeDropShadowRadiusTF;
    public Spinner<Double> shapeDropShadowOffsetXTF;
    public Spinner<Double> shapeDropShadowOffsetYTF;
    public ColorPicker shapeDropShadowCP;
    public Spinner<Double> shapeInnerShadowChokeTF;
    public Spinner<Double> shapeInnerShadowRadiusTF;
    public Spinner<Double> shapeInnerShadowOffsetXTF;
    public Spinner<Double> shapeInnerShadowOffsetYTF;
    public ColorPicker shapeInnerShadowCP;
    public Spinner<Double> shapeBoxBlurWidthTF;
    public Spinner<Double> shapeBoxBlurHeightTF;
    public Spinner<Integer> shapeBoxBlurIterTF;
    public CheckBox shapesSnapCB;
    public CheckBox shapesMatchTileBordersCB;
    public CheckBox shapesGMOnlyCB;
    public RadioButton shapesColorFillFB;
    public RadioButton shapesTextureFillFB;
    public RadioButton shapesColorStrokeFB;
    public RadioButton shapesTextureStrokeFB;
    public ColorPicker shapesFillCP;
    public ColorPicker shapesStrokeCP;
    public ColorPickerWithSelector shapesFillCPWSelector;
    public ColorPickerWithSelector shapesStrokeCPWSelector;
    public Spinner<Double> shapesOpacitySpinner;
    public Spinner<Double> strokeWidthSpinner;
    public ComboBox<MapLayer> shapesMapLayerCombo;
    public ComboBox<TextureType> shapesTextureStrokeCombo;
    public ComboBox<TextureType> shapesTextureFillCombo;
    public ComboBox<StrokeLineCap> strokeLineCapCombo;
    public ComboBox<StrokeLineJoin> strokeLineJoinCombo;
    public Spinner<Double> arcStartSpinner;
    public Spinner<Double> arcExtentSpinner;
    public Spinner<Double> extraLineWidthSpinner;
    public Spinner<Double> extraLineDistanceSpinner;
    public Spinner<Double> extraLineLengthSpinner;
    public Spinner<Double> extraLineSeparationSpinner;
    public final ComboBox<ArcType> arcTypeCombo = new ComboBox(FXCollections.observableArrayList((Object[])ArcType.values()));
    TitledPane shapesDrawer;
    RadioButton shapesNoFillCB;
    ToggleButton newOvalButton;
    ToggleButton newPolygonButton;
    ToggleButton newLineButton;
    ToggleButton newCurveButton;
    Button shapeConvertToRiverButton;
    Button shapeDeleteButton;
    Button shapesDeselectButton;
    Button shapeJoinButton;
    ComboBox<String> shapePresetFilterBox = new ComboBox();
    TextField shapesTagsTF;
    ComboBox<MapShape.StrokeType> strokeTypeCombo;
    CheckBox shapeWorldCB;
    CheckBox shapeContinentCB;
    CheckBox shapeKingdomCB;
    CheckBox shapeProvinceCB;
    public ObservableList<TextureType> texturesList;
    CheckBox gradientEdgeCB;
    BorderPane mainPane = new BorderPane();

    public ShapesToolbox(Worldographer worldographer) {
        super(worldographer);
    }

    @Override
    public void setup(ToggleButton toggleButton) {
        this.createToolbox("Shapes", "other_imgs/new_polygon_24.png", (Node)this.createShapesDrawer(), 500, 450, true);
        this.stage.show();
        this.stage.setOnCloseRequest(event -> toggleButton.setSelected(false));
    }

    public Pane createShapesDrawer() {
        boolean undoEnabled = this.worldographer.undoEnabled;
        this.mainPane = new BorderPane();
        GridPane topPane = this.makeTopControlsPane();
        this.mainPane.setTop((Node)topPane);
        SplitPane shapeCenterPane = new SplitPane();
        this.mainPane.setCenter((Node)shapeCenterPane);
        shapeCenterPane.setDividerPositions(new double[]{0.66});
        GridPane shapeSettingsPane = this.makeShapeSettingsPane(undoEnabled);
        ScrollPane settingsScrollPane = new ScrollPane((Node)shapeSettingsPane);
        shapeCenterPane.getItems().add((Object)settingsScrollPane);
        TabPane shapesOptionTabPane = new TabPane();
        shapesOptionTabPane.setSide(Side.TOP);
        ScrollPane lineOptionsScrollPane = new ScrollPane((Node)this.makeShapeLineOptionsPane(undoEnabled));
        shapesOptionTabPane.getTabs().add((Object)new Tab("Line Options", (Node)lineOptionsScrollPane));
        ScrollPane shadowOptionsScrollPane = new ScrollPane((Node)this.makeShadowOptionsPane(undoEnabled));
        shapesOptionTabPane.getTabs().add((Object)new Tab("Shadows", (Node)shadowOptionsScrollPane));
        shapeCenterPane.getItems().add((Object)shapesOptionTabPane);
        return this.mainPane;
    }

    private GridPane makeShapeSettingsPane(boolean undoEnabled) {
        GridPane shapeSettingsPane = new GridPane();
        shapeSettingsPane.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        Label typelabel = new Label("Stroke Type");
        typelabel.setTooltip(new Tooltip("Sets the style the shape's stroke (border) has."));
        shapeSettingsPane.add((Node)typelabel, 0, 0);
        this.strokeTypeCombo.getSelectionModel().select((Object)MapShape.StrokeType.SIMPLE);
        this.strokeTypeCombo.setTooltip(new Tooltip("Sets the style the shape's stroke (border) has."));
        this.strokeTypeCombo.setOnAction(event -> {
            this.mapUI().getController().updateShapeStrokeType(undoEnabled, this.mapUI().getCurrentObjects(), (MapShape.StrokeType)((Object)((Object)this.strokeTypeCombo.getValue())));
            this.mapUI().draw();
        });
        shapeSettingsPane.add(this.strokeTypeCombo, 1, 0);
        this.shapeFractalCB.setSelected(false);
        shapeSettingsPane.add((Node)this.shapeFractalCB, 0, 1, 2, 1);
        Label borderDetailsLabel = new Label("Stroke (Border) Details:");
        shapeSettingsPane.add((Node)borderDetailsLabel, 0, 2, 2, 1);
        Label borderwidthlabel = new Label("Width:");
        borderwidthlabel.setTooltip(new Tooltip("Sets the width of the shape's stroke/border as a percentage of a tile's width."));
        shapeSettingsPane.add((Node)borderwidthlabel, 0, 3);
        this.strokeWidthSpinner.setEditable(true);
        this.strokeWidthSpinner.setMaxWidth(70.0);
        shapeSettingsPane.add(this.strokeWidthSpinner, 1, 3);
        this.strokeWidthSpinner.valueProperty().addListener((observable, oldValue, newValue) -> {
            this.mapUI().getController().updateShapeStrokeWidth(undoEnabled, (List<MapObject>)this.mapUI().getCurrentObjects(), (Double)newValue);
            this.mapUI().draw();
        });
        ToggleGroup bordergroup = new ToggleGroup();
        this.shapesColorStrokeFB.setToggleGroup(bordergroup);
        this.shapesColorStrokeFB.setTooltip(new Tooltip("If selected, the shape's stroke/border will have the color\nchosen by the adjacent color picker."));
        this.shapesColorStrokeFB.setSelected(true);
        shapeSettingsPane.add((Node)this.shapesColorStrokeFB, 0, 4);
        this.shapesColorStrokeFB.setOnAction(event -> {
            if (this.shapesColorStrokeFB.isSelected()) {
                this.mapUI().getController().updateShapeColorStroke(undoEnabled, this.mapUI().getCurrentObjects(), (Color)this.shapesStrokeCP.getValue());
                this.mapUI().draw();
            }
        });
        if (this.shapesStrokeCP.getCustomColors().size() <= 1) {
            this.shapesStrokeCP.getCustomColors().addAll((Object[])Worldographer.customColors);
        }
        shapeSettingsPane.add(this.shapesStrokeCPWSelector.getNode(), 1, 4);
        this.shapesStrokeCP.setTooltip(new Tooltip("If the adjacent checkbox is  selected, the shape's stroke/border will have the color\nchosen by this color picker."));
        this.shapesStrokeCP.setOnAction(event -> {
            if (this.shapesColorStrokeFB.isSelected()) {
                this.mapUI().getController().updateShapeColorStroke(undoEnabled, this.mapUI().getCurrentObjects(), (Color)this.shapesStrokeCP.getValue());
                this.mapUI().draw();
            }
        });
        this.shapesTextureStrokeFB.setToggleGroup(bordergroup);
        this.shapesTextureStrokeFB.setTooltip(new Tooltip("If selected, the shape's stroke/border will have the texture\nchosen by the adjacent drop-down list."));
        this.shapesTextureStrokeFB.setOnAction(event -> {
            if (this.shapesTextureStrokeFB.isSelected()) {
                this.mapUI().getController().updateShapeTextureStroke(undoEnabled, this.mapUI().getCurrentObjects(), (TextureType)this.shapesTextureStrokeCombo.getValue());
                this.mapUI().draw();
            }
        });
        Button configureTextureButton = new Button("", (Node)new ImageView(this.worldographer.from("other_imgs/configure.png")));
        configureTextureButton.setPadding(new Insets(1.0, 1.0, 1.0, 1.0));
        configureTextureButton.setOnAction(event -> new ConfigurationDialog().launchConfigureTextures(this.worldographer));
        HBox ctbox = new HBox();
        ctbox.getChildren().add((Object)this.shapesTextureStrokeFB);
        ctbox.getChildren().add((Object)configureTextureButton);
        shapeSettingsPane.add((Node)ctbox, 0, 5);
        this.shapesTextureStrokeCombo.getSelectionModel().select(0);
        this.shapesTextureStrokeCombo.setTooltip(new Tooltip("If the adjacent checkbox is selected, the shape's stroke/border will have the\ntexture chosen by this drop-down list."));
        this.shapesTextureStrokeCombo.setMaxWidth(120.0);
        shapeSettingsPane.add(this.shapesTextureStrokeCombo, 1, 5);
        this.shapesTextureStrokeCombo.setOnAction(event -> {
            if (this.shapesTextureStrokeFB.isSelected()) {
                this.mapUI().getController().updateShapeTextureStroke(undoEnabled, this.mapUI().getCurrentObjects(), (TextureType)this.shapesTextureStrokeCombo.getValue());
                this.mapUI().draw();
            }
        });
        this.shapesTextureStrokeCombo.setCellFactory(c -> new TextureListCell());
        this.shapesTextureStrokeCombo.setButtonCell((ListCell)new TextureListCell());
        Label fillDetailsLabel = new Label("Fill Details:");
        shapeSettingsPane.add((Node)fillDetailsLabel, 0, 6, 2, 1);
        ToggleGroup fillgroup = new ToggleGroup();
        this.shapesNoFillCB.setToggleGroup(fillgroup);
        this.shapesNoFillCB.setTooltip(new Tooltip("If selected, the shape will not be filled with a color or texture."));
        shapeSettingsPane.add((Node)this.shapesNoFillCB, 0, 7);
        this.shapesNoFillCB.setOnAction(event -> {
            if (this.shapesNoFillCB.isSelected()) {
                this.mapUI().getController().updateShapeNoFill(undoEnabled, this.mapUI().getCurrentObjects());
                this.mapUI().draw();
            }
        });
        this.shapesColorFillFB.setToggleGroup(fillgroup);
        this.shapesColorFillFB.setTooltip(new Tooltip("If selected, the shape will be filled by the color\nchosen with adjacent color picker."));
        shapeSettingsPane.add((Node)this.shapesColorFillFB, 0, 8);
        this.shapesColorFillFB.setOnAction(event -> {
            if (this.shapesColorFillFB.isSelected()) {
                this.mapUI().getController().updateShapeColorFill(undoEnabled, this.mapUI().getCurrentObjects(), (Color)this.shapesFillCP.getValue());
                this.mapUI().draw();
            }
        });
        shapeSettingsPane.add(this.shapesFillCPWSelector.getNode(), 1, 8);
        this.shapesFillCP.setTooltip(new Tooltip("If the adjacent checkbox is selected, the shape will be filled by the color\nchosen by this color picker."));
        if (this.shapesFillCP.getCustomColors().size() <= 1) {
            this.shapesFillCP.getCustomColors().addAll((Object[])Worldographer.customColors);
        }
        this.shapesFillCP.setOnAction(event -> {
            if (this.shapesColorFillFB.isSelected()) {
                this.mapUI().getController().updateShapeColorFill(undoEnabled, this.mapUI().getCurrentObjects(), (Color)this.shapesFillCP.getValue());
                this.mapUI().draw();
            }
        });
        this.shapesTextureFillFB.setToggleGroup(fillgroup);
        this.shapesTextureFillFB.setTooltip(new Tooltip("If selected, the shape will be filled by the texture\nchosen with adjacent drop-down list."));
        shapeSettingsPane.add((Node)this.shapesTextureFillFB, 0, 9);
        this.shapesTextureFillFB.setOnAction(event -> {
            if (this.shapesTextureFillFB.isSelected()) {
                this.mapUI().getController().updateShapeTextureFill(undoEnabled, this.mapUI().getCurrentObjects(), (TextureType)this.shapesTextureFillCombo.getValue());
                this.mapUI().draw();
            }
        });
        Button configureTextureButton2 = new Button("", (Node)new ImageView(LoadImage.image("other_imgs/configure.png")));
        configureTextureButton2.setPadding(new Insets(1.0, 1.0, 1.0, 1.0));
        configureTextureButton2.setOnAction(event -> {
            if (UserPrefs.FULL) {
                Stage stage = new Stage();
                ConfigureTexturesScreen ss = new ConfigureTexturesScreen(this.worldographer);
                ss.start(stage);
                stage.show();
            } else {
                StandardDialog.showDialog(this.worldographer.getPrimaryStage(), "Pro Feature", "Configuring textures is only available if using a Pro version license.", "Sorry, some features are reserved for our Pro/paid version. If you find the software useful, considering unlocking these special features and supporting the many hours of work to create Worldographer with a Pro license. See www.worldographer.com for details.", null, "");
            }
        });
        HBox ctbox2 = new HBox();
        ctbox2.getChildren().add((Object)this.shapesTextureFillFB);
        ctbox2.getChildren().add((Object)configureTextureButton2);
        shapeSettingsPane.add((Node)ctbox2, 0, 9);
        this.shapesTextureFillCombo.getSelectionModel().select(0);
        this.shapesTextureFillCombo.setTooltip(new Tooltip("If the adjacent checkbox is selected, the shape will be filled by the\ntexture chosen with this drop-down list."));
        this.shapesTextureFillCombo.setMaxWidth(120.0);
        shapeSettingsPane.add(this.shapesTextureFillCombo, 1, 9);
        this.shapesTextureFillCombo.setOnAction(event -> {
            if (this.shapesTextureFillFB.isSelected()) {
                this.mapUI().getController().updateShapeTextureFill(undoEnabled, this.mapUI().getCurrentObjects(), (TextureType)this.shapesTextureFillCombo.getValue());
                this.mapUI().draw();
            }
        });
        this.shapesTextureFillCombo.setCellFactory(c -> new TextureListCell());
        this.shapesTextureFillCombo.setButtonCell((ListCell)new TextureListCell());
        Label opacitylabel = new Label("Opacity");
        opacitylabel.setTooltip(new Tooltip("Makes the shape semi-transparent: 0 makes it invisible, 100 is opaque."));
        shapeSettingsPane.add((Node)opacitylabel, 0, 10);
        this.shapesOpacitySpinner.setEditable(true);
        this.shapesOpacitySpinner.setMaxWidth(70.0);
        this.shapesOpacitySpinner.setTooltip(new Tooltip("Makes the shape semi-transparent: 0 makes it invisible, 100 is opaque."));
        this.shapesOpacitySpinner.valueProperty().addListener((observable, oldValue, newValue) -> {
            this.mapUI().getController().updateShapeOpacity(undoEnabled, (List<MapObject>)this.mapUI().getCurrentObjects(), (Double)newValue);
            this.mapUI().draw();
        });
        Label opacitypercentlabel = new Label("%");
        HBox shapesopacitybox = new HBox();
        shapesopacitybox.getChildren().add(this.shapesOpacitySpinner);
        shapesopacitybox.getChildren().add((Object)opacitypercentlabel);
        shapeSettingsPane.add((Node)shapesopacitybox, 1, 10);
        Label tagslabel = new Label("Tags");
        tagslabel.setTooltip(new Tooltip("The selected shape will be marked with the tags in the textfield. These tags are used with\nthe 'Show Objs w/' and 'Hide Objs w/' fields in the controls below the map."));
        shapeSettingsPane.add((Node)tagslabel, 0, 11);
        this.shapesTagsTF.setMaxWidth(120.0);
        this.shapesTagsTF.setTooltip(new Tooltip("The selected shape will be marked with the tags in the textfield. These tags are used with\nthe 'Show Objs w/' and 'Hide Objs w/' fields in the controls below the map."));
        this.shapesTagsTF.textProperty().addListener((observable, oldValue, newValue) -> {
            this.mapUI().getController().updateShapeTags(undoEnabled, (List<MapObject>)this.mapUI().getCurrentObjects(), (String)newValue);
            this.mapUI().draw();
        });
        shapeSettingsPane.add((Node)this.shapesTagsTF, 1, 11);
        Label layerlabel = new Label("Layer: ");
        layerlabel.setTooltip(new Tooltip("The selected shape can be moved among the map's various layers. A map has several layers such\nas Labels, Grid, Features, Above Terrain, & more. Shapes (and features and labels) can actually be placed on any layer.\nSee the Layers drawer/toolbox to turn then on/off or reorder them."));
        shapeSettingsPane.add((Node)layerlabel, 0, 13);
        MapLayer shapeslayer = this.mapUI().getMapData().getMapLayer("Above Terrain");
        if (shapeslayer == null) {
            shapeslayer = this.mapUI().getMapData().getMapLayers().get(0);
        }
        this.shapesMapLayerCombo.getSelectionModel().select((Object)shapeslayer);
        this.shapesMapLayerCombo.setTooltip(new Tooltip("The selected shape can be moved among the map's various layers. A map has several layers such\nas Labels, Grid, Features, Above Terrain, & more. Shapes (and features and labels) can actually be placed on any layer.\nSee the Layers drawer/toolbox to turn then on/off or reorder them."));
        shapeSettingsPane.add(this.shapesMapLayerCombo, 1, 13);
        this.shapesMapLayerCombo.setOnAction(event -> {
            if (this.mapUI().getCurrentObjects().isEmpty()) {
                return;
            }
            boolean needToUpdate = false;
            for (MapObject mo : this.mapUI().getCurrentObjects()) {
                MapShape mapShape;
                if (!(mo instanceof MapShape) || (mapShape = (MapShape)mo).getMapLayer() == this.shapesMapLayerCombo.getSelectionModel().getSelectedItem()) continue;
                needToUpdate = true;
            }
            if (needToUpdate) {
                this.mapUI().getController().updateShapeMapLayer(undoEnabled, this.mapUI().getCurrentObjects(), (MapLayer)this.shapesMapLayerCombo.getSelectionModel().getSelectedItem());
                this.mapUI().draw();
            }
        });
        Label levelLabel = new Label("Levels: ");
        levelLabel.setTooltip(new Tooltip("The selected shape can be made visible for only specific levels."));
        shapeSettingsPane.add((Node)levelLabel, 0, 14);
        GridPane levelPane = new GridPane();
        levelPane.add((Node)this.shapeWorldCB, 0, 0);
        levelPane.add((Node)this.shapeContinentCB, 1, 0);
        levelPane.add((Node)this.shapeKingdomCB, 0, 1);
        levelPane.add((Node)this.shapeProvinceCB, 1, 1);
        shapeSettingsPane.add((Node)levelPane, 1, 14);
        shapeSettingsPane.add((Node)this.shapesGMOnlyCB, 0, 15, 2, 1);
        this.shapesGMOnlyCB.setTooltip(new Tooltip("The selected shape will be marked as 'GM Only'. So if the 'GM Only' checkbox on\nWorldographer's bottom toolbar is un-checked, the feature won't be shown."));
        this.shapesSnapCB.setOnAction(event -> {
            this.mapUI().getController().updateShapeSnap(undoEnabled, this.mapUI().getCurrentObjects(), this.shapesSnapCB.isSelected());
            this.mapUI().draw();
        });
        shapeSettingsPane.add((Node)this.shapesSnapCB, 0, 16, 2, 1);
        this.shapesSnapCB.setTooltip(new Tooltip("If checked, any point added to a shape will be snapped to a hex or square's vertex or\na spot 1/4, 1/2, or 3/4 of the way horizontally and vertically across it."));
        this.shapesMatchTileBordersCB.setOnAction(event -> {
            this.mapUI().getController().updateShapeMatchTileBorder(undoEnabled, this.mapUI().getCurrentObjects(), this.shapesMatchTileBordersCB.isSelected());
            this.mapUI().draw();
        });
        shapeSettingsPane.add((Node)this.shapesMatchTileBordersCB, 0, 17, 2, 1);
        return shapeSettingsPane;
    }

    private GridPane makeShapeLineOptionsPane(boolean undoEnabled) {
        GridPane shapeSettingsPane = new GridPane();
        shapeSettingsPane.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        Label linecaplabel = new Label("Line Cap:");
        linecaplabel.setTooltip(new Tooltip("Controls the look of the ends of lines and shape borders."));
        shapeSettingsPane.add((Node)linecaplabel, 0, 18);
        this.strokeLineCapCombo.getSelectionModel().selectFirst();
        this.strokeLineCapCombo.setTooltip(new Tooltip("Controls the look of the ends of lines and shape borders."));
        this.strokeLineCapCombo.setOnAction(event -> {
            this.mapUI().getController().updateShapeStrokeLineCap(undoEnabled, this.mapUI().getCurrentObjects(), (StrokeLineCap)this.strokeLineCapCombo.getSelectionModel().getSelectedItem());
            this.mapUI().draw();
        });
        shapeSettingsPane.add(this.strokeLineCapCombo, 1, 18);
        Label linejoinlabel = new Label("Line Join:");
        linejoinlabel.setTooltip(new Tooltip("Controls the look of spots where line or border segments connect."));
        shapeSettingsPane.add((Node)linejoinlabel, 0, 19);
        this.strokeLineJoinCombo.getSelectionModel().selectLast();
        this.strokeLineJoinCombo.setTooltip(new Tooltip("Controls the look of spots where line or border segments connect."));
        this.strokeLineJoinCombo.setOnAction(event -> {
            this.mapUI().getController().updateShapeStrokeLineJoin(undoEnabled, this.mapUI().getCurrentObjects(), (StrokeLineJoin)this.strokeLineJoinCombo.getSelectionModel().getSelectedItem());
            this.mapUI().draw();
        });
        shapeSettingsPane.add(this.strokeLineJoinCombo, 1, 19);
        Label arclabel = new Label("Arc Options:");
        arclabel.setStyle("-fx-font-weight: bold");
        shapeSettingsPane.add((Node)arclabel, 0, 20);
        Label arcsalabel = new Label("Start Angle:");
        arcsalabel.setTooltip(new Tooltip("For a partial circle, set the Extent Angle to less than 360 and set this to the number of\ndegrees where the circle starts. 0 degrees is the right x-axis and runs counter-clockwise."));
        shapeSettingsPane.add((Node)arcsalabel, 0, 21);
        this.arcStartSpinner.setMaxWidth(80.0);
        this.arcStartSpinner.setTooltip(new Tooltip("For a partial circle, set the Extent Angle to less than 360 and set this to the number of\ndegrees where the circle starts. 0 degrees is the right x-axis and runs counter-clockwise."));
        this.arcStartSpinner.setEditable(true);
        shapeSettingsPane.add(this.arcStartSpinner, 1, 21);
        this.arcStartSpinner.valueProperty().addListener((observable, oldValue, newValue) -> {
            this.mapUI().getController().updateShapeArcStart(undoEnabled, (List<MapObject>)this.mapUI().getCurrentObjects(), (Double)newValue);
            this.mapUI().draw();
        });
        Label arcealabel = new Label("Extent Angle:");
        arcealabel.setTooltip(new Tooltip("For a partial circle, set the extent angle to less than 360. 360 is a full circle, 180 is a\nhalf circle and so on. The Start Angle controls where the circle/arc begins."));
        shapeSettingsPane.add((Node)arcealabel, 0, 22);
        this.arcExtentSpinner.setMaxWidth(80.0);
        this.arcExtentSpinner.setTooltip(new Tooltip("For a partial circle, set the extent angle to less than 360. 360 is a full circle, 180 is a\nhalf circle and so on. The Start Angle controls where the circle/arc begins."));
        this.arcExtentSpinner.setEditable(true);
        shapeSettingsPane.add(this.arcExtentSpinner, 1, 22);
        this.arcExtentSpinner.valueProperty().addListener((observable, oldValue, newValue) -> {
            this.mapUI().getController().updateShapeArcExtent(undoEnabled, (List<MapObject>)this.mapUI().getCurrentObjects(), (Double)newValue);
            this.mapUI().draw();
        });
        Label arctypelabel = new Label("Closure Type:");
        arctypelabel.setTooltip(new Tooltip("For a partial circle, this controls how the non-circular section is completed."));
        shapeSettingsPane.add((Node)arctypelabel, 0, 23);
        shapeSettingsPane.add(this.arcTypeCombo, 1, 23);
        this.arcTypeCombo.setTooltip(new Tooltip("For a partial circle, this controls how the non-circular section is completed."));
        this.arcTypeCombo.getSelectionModel().selectFirst();
        this.arcTypeCombo.setOnAction(event -> {
            this.mapUI().getController().updateShapeArcType(undoEnabled, this.mapUI().getCurrentObjects(), (ArcType)this.arcTypeCombo.getSelectionModel().getSelectedItem());
            this.mapUI().draw();
        });
        Label lineHatchlabel = new Label("Extra Line Options (Elev., Rail):");
        lineHatchlabel.setStyle("-fx-font-weight: bold");
        shapeSettingsPane.add((Node)lineHatchlabel, 0, 24, 2, 1);
        Label extraLineWidthLabel = new Label("Width:");
        extraLineWidthLabel.setTooltip(new Tooltip("Use this to set the thickness of the extra lines, as a percentage of a tile's width."));
        shapeSettingsPane.add((Node)extraLineWidthLabel, 0, 25);
        this.extraLineWidthSpinner.setMaxWidth(80.0);
        this.extraLineWidthSpinner.setTooltip(new Tooltip("Use this to set the thickness of the extra lines, as a percentage of a tile's width."));
        this.extraLineWidthSpinner.setEditable(true);
        this.extraLineWidthSpinner.valueProperty().addListener((observable, oldValue, newValue) -> {
            this.mapUI().getController().updateExtraLineDetail(undoEnabled, (List<MapObject>)this.mapUI().getCurrentObjects(), (double)newValue, "width");
            this.mapUI().draw();
        });
        shapeSettingsPane.add(this.extraLineWidthSpinner, 1, 25);
        Label extraLineDistanceLabel = new Label("Distance:");
        extraLineDistanceLabel.setTooltip(new Tooltip("This setting specifies the distance between the extra lines, as a percentage of a tile's width."));
        shapeSettingsPane.add((Node)extraLineDistanceLabel, 0, 26);
        this.extraLineDistanceSpinner.setMaxWidth(80.0);
        this.extraLineDistanceSpinner.setTooltip(new Tooltip("This setting specifies the distance between the extra lines, as a percentage of a tile's width."));
        this.extraLineDistanceSpinner.setEditable(true);
        this.extraLineDistanceSpinner.valueProperty().addListener((observable, oldValue, newValue) -> {
            this.mapUI().getController().updateExtraLineDetail(undoEnabled, (List<MapObject>)this.mapUI().getCurrentObjects(), (double)newValue, "distance");
            this.mapUI().draw();
        });
        shapeSettingsPane.add(this.extraLineDistanceSpinner, 1, 26);
        Label extraLineLengthLabel = new Label("Length:");
        extraLineLengthLabel.setTooltip(new Tooltip("This determines how far the extra lines will stick out, as a percentage of a tile's width."));
        shapeSettingsPane.add((Node)extraLineLengthLabel, 0, 27);
        this.extraLineLengthSpinner.setMaxWidth(80.0);
        this.extraLineLengthSpinner.setTooltip(new Tooltip("This determines how far the extra lines will stick out, as a percentage of a tile's width."));
        this.extraLineLengthSpinner.setEditable(true);
        this.extraLineLengthSpinner.valueProperty().addListener((observable, oldValue, newValue) -> {
            this.mapUI().getController().updateExtraLineDetail(undoEnabled, (List<MapObject>)this.mapUI().getCurrentObjects(), (double)newValue, "length");
            this.mapUI().draw();
        });
        shapeSettingsPane.add(this.extraLineLengthSpinner, 1, 27);
        Label extraLineSeparationLabel = new Label("Separation:");
        extraLineSeparationLabel.setTooltip(new Tooltip("For railroad lines, this controls the distance between the two main lines, as a percentage of a tile's width."));
        shapeSettingsPane.add((Node)extraLineSeparationLabel, 0, 28);
        this.extraLineSeparationSpinner.setMaxWidth(80.0);
        this.extraLineSeparationSpinner.setTooltip(new Tooltip("For railroad lines, this controls the distance between the two main lines, as a percentage of a tile's width."));
        this.extraLineSeparationSpinner.setEditable(true);
        this.extraLineSeparationSpinner.valueProperty().addListener((observable, oldValue, newValue) -> {
            this.mapUI().getController().updateExtraLineDetail(undoEnabled, (List<MapObject>)this.mapUI().getCurrentObjects(), (double)newValue, "separation");
            this.mapUI().draw();
        });
        shapeSettingsPane.add(this.extraLineSeparationSpinner, 1, 28);
        shapeSettingsPane.add((Node)new Label("  (for railroad lines)"), 0, 29, 2, 1);
        return shapeSettingsPane;
    }

    private GridPane makeShadowOptionsPane(boolean undoEnabled) {
        GridPane gp2 = new GridPane();
        gp2.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        Label optionslabel = new Label("Options:");
        optionslabel.setStyle("-fx-font-weight: bold");
        gp2.add((Node)optionslabel, 0, 2, 2, 1);
        gp2.add((Node)this.shapeDropShadowCB, 0, 3, 2, 1);
        this.shapeDropShadowCB.setOnAction(event -> {
            this.mapUI().getController().updateShapeDropShadow(undoEnabled, this.mapUI().getCurrentObjects(), this.shapeDropShadowCB.isSelected(), (Color)this.shapeDropShadowCP.getValue(), (Double)this.shapeDropShadowOffsetXTF.getValue(), (Double)this.shapeDropShadowOffsetYTF.getValue(), (Double)this.shapeDropShadowSpreadTF.getValue(), (Double)this.shapeDropShadowRadiusTF.getValue());
            this.mapUI().draw();
        });
        Label dsspreadlabel = new Label("Spread:");
        gp2.add((Node)dsspreadlabel, 0, 4);
        this.shapeDropShadowSpreadTF.getValueFactory().setValue((Object)0.2);
        this.shapeDropShadowSpreadTF.setMaxWidth(80.0);
        this.shapeDropShadowSpreadTF.setEditable(true);
        gp2.add(this.shapeDropShadowSpreadTF, 1, 4);
        this.shapeDropShadowSpreadTF.valueProperty().addListener((observable, oldValue, newValue) -> {
            this.mapUI().getController().updateShapeDropShadowSpread(undoEnabled, (List<MapObject>)this.mapUI().getCurrentObjects(), (Double)newValue);
            this.mapUI().draw();
        });
        Label dsradiuslabel = new Label("Radius:");
        gp2.add((Node)dsradiuslabel, 0, 5);
        this.shapeDropShadowRadiusTF.setMaxWidth(80.0);
        this.shapeDropShadowRadiusTF.setEditable(true);
        gp2.add(this.shapeDropShadowRadiusTF, 1, 5);
        this.shapeDropShadowRadiusTF.valueProperty().addListener((observable, oldValue, newValue) -> {
            this.mapUI().getController().updateShapeDropShadowRadius(undoEnabled, (List<MapObject>)this.mapUI().getCurrentObjects(), (Double)newValue);
            this.mapUI().draw();
        });
        Label dsoffsetxlabel = new Label("Offset X:");
        gp2.add((Node)dsoffsetxlabel, 0, 6);
        this.shapeDropShadowOffsetXTF.setMaxWidth(80.0);
        this.shapeDropShadowOffsetXTF.setEditable(true);
        gp2.add(this.shapeDropShadowOffsetXTF, 1, 6);
        this.shapeDropShadowOffsetXTF.valueProperty().addListener((observable, oldValue, newValue) -> {
            this.mapUI().getController().updateShapeDropShadowOffsetX(undoEnabled, (List<MapObject>)this.mapUI().getCurrentObjects(), (Double)newValue);
            this.mapUI().draw();
        });
        Label dsoffsetylabel = new Label("Offset Y:");
        gp2.add((Node)dsoffsetylabel, 0, 7);
        this.shapeDropShadowOffsetYTF.setMaxWidth(80.0);
        this.shapeDropShadowOffsetYTF.setEditable(true);
        gp2.add(this.shapeDropShadowOffsetYTF, 1, 7);
        this.shapeDropShadowOffsetYTF.valueProperty().addListener((observable, oldValue, newValue) -> {
            this.mapUI().getController().updateShapeDropShadowOffsetY(undoEnabled, (List<MapObject>)this.mapUI().getCurrentObjects(), (Double)newValue);
            this.mapUI().draw();
        });
        Label shapedropshadowcolorlabel = new Label("Color:");
        gp2.add((Node)shapedropshadowcolorlabel, 0, 8);
        if (this.shapeDropShadowCP.getCustomColors().size() <= 1) {
            this.shapeDropShadowCP.getCustomColors().addAll((Object[])Worldographer.customColors);
        }
        this.shapeDropShadowCP.setMaxWidth(80.0);
        gp2.add((Node)this.shapeDropShadowCP, 1, 8);
        this.shapeDropShadowCP.setOnAction(event -> {
            this.mapUI().getController().updateShapeDropShadowColor(undoEnabled, this.mapUI().getCurrentObjects(), (Color)this.shapeDropShadowCP.getValue());
            this.mapUI().draw();
        });
        gp2.add((Node)this.shapeInnerShadowCB, 0, 9, 2, 1);
        this.shapeInnerShadowCB.setOnAction(event -> this.mapUI().getController().updateShapeInnerShadow(undoEnabled, this.mapUI().getCurrentObjects(), this.shapeInnerShadowCB.isSelected(), (Color)this.shapeInnerShadowCP.getValue(), (Double)this.shapeInnerShadowOffsetXTF.getValue(), (Double)this.shapeInnerShadowOffsetYTF.getValue(), (Double)this.shapeInnerShadowChokeTF.getValue(), (Double)this.shapeInnerShadowRadiusTF.getValue()));
        Label inschokelabel = new Label("Choke:");
        gp2.add((Node)inschokelabel, 0, 10);
        this.shapeInnerShadowChokeTF.setMaxWidth(80.0);
        this.shapeInnerShadowChokeTF.setEditable(true);
        gp2.add(this.shapeInnerShadowChokeTF, 1, 10);
        this.shapeInnerShadowChokeTF.valueProperty().addListener((observable, oldValue, newValue) -> this.mapUI().getController().updateShapeInnerShadowChoke(undoEnabled, (List<MapObject>)this.mapUI().getCurrentObjects(), (Double)newValue));
        Label insradiuslabel = new Label("Radius:");
        gp2.add((Node)insradiuslabel, 0, 11);
        this.shapeInnerShadowRadiusTF.setMaxWidth(80.0);
        this.shapeInnerShadowRadiusTF.setEditable(true);
        gp2.add(this.shapeInnerShadowRadiusTF, 1, 11);
        this.shapeInnerShadowRadiusTF.valueProperty().addListener((observable, oldValue, newValue) -> this.mapUI().getController().updateShapeInnerShadowRadius(undoEnabled, (List<MapObject>)this.mapUI().getCurrentObjects(), (Double)newValue));
        Label insoffsetxlabel = new Label("Offset X:");
        gp2.add((Node)insoffsetxlabel, 0, 12);
        this.shapeInnerShadowOffsetXTF.setMaxWidth(80.0);
        this.shapeInnerShadowOffsetXTF.setEditable(true);
        gp2.add(this.shapeInnerShadowOffsetXTF, 1, 12);
        this.shapeInnerShadowOffsetXTF.valueProperty().addListener((observable, oldValue, newValue) -> this.mapUI().getController().updateShapeInnerShadowOffsetX(undoEnabled, this.mapUI().getCurrentObjects(), (Double)this.shapeInnerShadowOffsetXTF.getValue()));
        Label insoffsetylabel = new Label("Offset Y:");
        gp2.add((Node)insoffsetylabel, 0, 13);
        this.shapeInnerShadowOffsetYTF.setMaxWidth(80.0);
        this.shapeInnerShadowOffsetYTF.setEditable(true);
        gp2.add(this.shapeInnerShadowOffsetYTF, 1, 13);
        this.shapeInnerShadowOffsetYTF.valueProperty().addListener((observable, oldValue, newValue) -> {
            this.mapUI().getController().updateShapeInnerShadowOffsetY(undoEnabled, this.mapUI().getCurrentObjects(), (Double)this.shapeInnerShadowOffsetYTF.getValue());
            this.mapUI().draw();
        });
        Label shapeinnershadowcolorlabel = new Label("Color:");
        gp2.add((Node)shapeinnershadowcolorlabel, 0, 14);
        if (this.shapeInnerShadowCP.getCustomColors().size() <= 1) {
            this.shapeInnerShadowCP.getCustomColors().addAll((Object[])Worldographer.customColors);
        }
        this.shapeInnerShadowCP.setMaxWidth(80.0);
        gp2.add((Node)this.shapeInnerShadowCP, 1, 14);
        this.shapeInnerShadowCP.setOnAction(event -> {
            this.mapUI().getController().updateShapeInnerShadowColor(undoEnabled, this.mapUI().getCurrentObjects(), (Color)this.shapeInnerShadowCP.getValue());
            this.mapUI().draw();
        });
        gp2.add((Node)this.shapeBoxBlurCB, 0, 15, 2, 1);
        this.shapeBoxBlurCB.setOnAction(event -> {
            this.mapUI().getController().updateShapeBoxBlur(undoEnabled, this.mapUI().getCurrentObjects(), this.shapeBoxBlurCB.isSelected(), (Double)this.shapeBoxBlurWidthTF.getValue(), (Double)this.shapeBoxBlurHeightTF.getValue(), (Integer)this.shapeBoxBlurIterTF.getValue());
            this.mapUI().draw();
        });
        Label bbwidthlabel = new Label("Width:");
        gp2.add((Node)bbwidthlabel, 0, 16);
        this.shapeBoxBlurWidthTF.setMaxWidth(80.0);
        this.shapeBoxBlurWidthTF.setEditable(true);
        gp2.add(this.shapeBoxBlurWidthTF, 1, 16);
        this.shapeBoxBlurWidthTF.valueProperty().addListener((observable, oldValue, newValue) -> {
            this.mapUI().getController().updateShapeBBWidth(undoEnabled, (List<MapObject>)this.mapUI().getCurrentObjects(), (Double)newValue);
            this.mapUI().draw();
        });
        Label bbheightlabel = new Label("Height:");
        gp2.add((Node)bbheightlabel, 0, 17);
        this.shapeBoxBlurHeightTF.setMaxWidth(80.0);
        this.shapeBoxBlurHeightTF.setEditable(true);
        gp2.add(this.shapeBoxBlurHeightTF, 1, 17);
        this.shapeBoxBlurHeightTF.valueProperty().addListener((observable, oldValue, newValue) -> {
            this.mapUI().getController().updateShapeBBHeight(undoEnabled, (List<MapObject>)this.mapUI().getCurrentObjects(), (Double)newValue);
            this.mapUI().draw();
        });
        Label bbiterlabel = new Label("Iterations:");
        gp2.add((Node)bbiterlabel, 0, 18);
        this.shapeBoxBlurIterTF.setMaxWidth(80.0);
        this.shapeBoxBlurIterTF.setEditable(true);
        gp2.add(this.shapeBoxBlurIterTF, 1, 18);
        this.shapeBoxBlurIterTF.valueProperty().addListener((observable, oldValue, newValue) -> {
            this.mapUI().getController().updateShapeBBIterations(undoEnabled, (List<MapObject>)this.mapUI().getCurrentObjects(), (Integer)newValue);
            this.mapUI().draw();
        });
        gp2.add((Node)this.gradientEdgeCB, 0, 19, 2, 1);
        this.gradientEdgeCB.setOnAction(event -> {
            this.mapUI().getController().updateShapeGradientEdge(undoEnabled, this.mapUI().getCurrentObjects(), this.gradientEdgeCB.isSelected());
            this.mapUI().draw();
        });
        return gp2;
    }

    private HBox makeZAxisBox() {
        HBox optionstopbox = new HBox();
        ImageView movetopImage = new ImageView(LoadImage.image("other_imgs/move_to_top.png"));
        movetopImage.setFitWidth(24.0);
        movetopImage.setFitHeight(24.0);
        Button shapesMoveTopButton = new Button("", (Node)movetopImage);
        shapesMoveTopButton.setTooltip(new Tooltip("Moves the selected shape to the top of all the shapes on this map layer.\n(To move it to another layer look for the layer placement field below.)"));
        shapesMoveTopButton.setOnAction(event -> {
            this.mapUI().getController().moveShapeTop(this.mapUI().getCurrentObjects());
            this.mapUI().draw();
        });
        optionstopbox.getChildren().add((Object)shapesMoveTopButton);
        ImageView moveUpImage = new ImageView(LoadImage.image("other_imgs/move_up.png"));
        moveUpImage.setFitWidth(24.0);
        moveUpImage.setFitHeight(24.0);
        Button shapesMoveUpButton = new Button("", (Node)moveUpImage);
        shapesMoveUpButton.setTooltip(new Tooltip("Moves the selected shape above one other overlapping shape on this map layer.\n(To move it to another layer look for the layer placement field below.)"));
        shapesMoveUpButton.setOnAction(event -> {
            this.mapUI().getController().moveShapeUp(this.mapUI().getCurrentObjects());
            this.mapUI().draw();
        });
        optionstopbox.getChildren().add((Object)shapesMoveUpButton);
        ImageView moveDownImage = new ImageView(LoadImage.image("other_imgs/move_down.png"));
        moveDownImage.setFitWidth(24.0);
        moveDownImage.setFitHeight(24.0);
        Button shapesMoveDownButton = new Button("", (Node)moveDownImage);
        shapesMoveDownButton.setTooltip(new Tooltip("Moves the selected shape below one other overlapping shape on this map layer.\n(To move it to another layer look for the layer placement field below.)"));
        shapesMoveDownButton.setOnAction(event -> {
            this.mapUI().getController().moveShapeDown(this.mapUI().getCurrentObjects());
            this.mapUI().draw();
        });
        optionstopbox.getChildren().add((Object)shapesMoveDownButton);
        ImageView moveBottomImage = new ImageView(LoadImage.image("other_imgs/move_to_bottom.png"));
        moveBottomImage.setFitWidth(24.0);
        moveBottomImage.setFitHeight(24.0);
        Button shapesMoveBottomButton = new Button("", (Node)moveBottomImage);
        shapesMoveBottomButton.setTooltip(new Tooltip("Moves the selected feature to the bottom of all the feature on this map layer.\n(To move it to another layer look for the layer placement field below.)"));
        shapesMoveBottomButton.setOnAction(event -> {
            this.mapUI().getController().moveShapeBottom(this.mapUI().getCurrentObjects());
            this.mapUI().draw();
        });
        optionstopbox.getChildren().add((Object)shapesMoveBottomButton);
        return optionstopbox;
    }

    private HBox makePresetBox() {
        HBox presetBox = new HBox();
        this.shapePresetFilterBox.setMaxWidth(120.0);
        this.shapePresetFilterBox.setTooltip(new Tooltip("Sets values for the various controls below based on the selected type."));
        this.shapePresetFilterBox.setOnAction(event -> this.updatePresets((String)this.shapePresetFilterBox.getValue()));
        presetBox.getChildren().add(this.shapePresetFilterBox);
        Button terrainPresetButton = new Button("+");
        terrainPresetButton.setOnAction(event -> {
            Dialog d = new Dialog();
            d.setTitle("Worldographer Add/Replace Shape Preset");
            d.setHeaderText("This will use the current shape settings to create a new preset\nor replace one if the name is already used as a preset.");
            GridPane gp = new GridPane();
            gp.add((Node)new Label("Preset Name:"), 0, 0);
            TextField tf = new TextField();
            gp.add((Node)tf, 1, 0);
            d.getDialogPane().setContent((Node)gp);
            ButtonType yes = new ButtonType("Create");
            ButtonType no = new ButtonType("Cancel");
            d.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{yes, no});
            Optional result = d.showAndWait();
            if (result.isPresent() && result.get() == yes) {
                String name = tf.getText();
                ShapeStyle ss = new ShapeStyle(name, (MapShape.StrokeType)((Object)((Object)this.strokeTypeCombo.getSelectionModel().getSelectedItem())), this.shapeFractalCB.isSelected(), (Double)this.strokeWidthSpinner.getValue(), this.shapesColorStrokeFB.isSelected() ? (Paint)this.shapesStrokeCP.getValue() : null, this.shapesColorFillFB.isSelected() ? (Paint)this.shapesFillCP.getValue() : null, (Double)this.shapesOpacitySpinner.getValue(), this.shapesSnapCB.isSelected(), this.shapesTagsTF.getText(), this.shapeDropShadowCB.isSelected(), this.shapeInnerShadowCB.isSelected(), this.shapeBoxBlurCB.isSelected(), (Double)this.shapeDropShadowSpreadTF.getValue(), (Double)this.shapeDropShadowRadiusTF.getValue(), (Double)this.shapeDropShadowOffsetXTF.getValue(), (Double)this.shapeDropShadowOffsetYTF.getValue(), (Double)this.shapeInnerShadowChokeTF.getValue(), (Double)this.shapeInnerShadowRadiusTF.getValue(), (Double)this.shapeInnerShadowOffsetXTF.getValue(), (Double)this.shapeInnerShadowOffsetYTF.getValue(), (Double)this.shapeBoxBlurWidthTF.getValue(), (Double)this.shapeBoxBlurHeightTF.getValue(), (Integer)this.shapeBoxBlurIterTF.getValue(), (Color)this.shapeDropShadowCP.getValue(), (Color)this.shapeInnerShadowCP.getValue(), this.shapesTextureFillFB.isSelected() ? (TextureType)this.shapesTextureFillCombo.getValue() : null, this.shapesTextureStrokeFB.isSelected() ? (TextureType)this.shapesTextureStrokeCombo.getValue() : null, ((StrokeLineCap)this.strokeLineCapCombo.getSelectionModel().getSelectedItem()).toString(), ((StrokeLineJoin)this.strokeLineJoinCombo.getSelectionModel().getSelectedItem()).toString());
                Worldographer.getMapUI().getMapData().getShapeStyles().put(name, ss);
                if (!this.shapePresetFilterBox.getItems().contains((Object)name)) {
                    this.shapePresetFilterBox.getItems().add((Object)name);
                }
            }
        });
        presetBox.getChildren().add((Object)terrainPresetButton);
        Button shapePresetDeleteButton = new Button("-");
        presetBox.getChildren().add((Object)shapePresetDeleteButton);
        shapePresetDeleteButton.setOnAction(event -> {
            Dialog d = new Dialog();
            d.setTitle("Worldographer Delete Shape Preset");
            d.setHeaderText("This will delete the chosen shape preset");
            GridPane gp = new GridPane();
            gp.add((Node)new Label("Preset Name:"), 0, 0);
            ComboBox shapeDeletePresetFilterBox = new ComboBox(FXCollections.observableArrayList(Worldographer.getMapUI().getMapData().getShapeStyles().keySet()));
            gp.add((Node)shapeDeletePresetFilterBox, 1, 0);
            d.getDialogPane().setContent((Node)gp);
            ButtonType yes = new ButtonType("Delete");
            ButtonType no = new ButtonType("Cancel");
            d.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{yes, no});
            Optional result = d.showAndWait();
            if (result.isPresent() && result.get() == yes && shapeDeletePresetFilterBox.getValue() != null) {
                this.shapePresetFilterBox.getItems().remove(shapeDeletePresetFilterBox.getValue());
                Worldographer.getMapUI().getMapData().getShapeStyles().remove(shapeDeletePresetFilterBox.getValue());
            }
        });
        return presetBox;
    }

    private GridPane makeTopControlsPane() {
        GridPane topPane = new GridPane();
        topPane.setHgap(3.0);
        topPane.setVgap(3.0);
        topPane.setPadding(new Insets(3.0, 3.0, 3.0, 3.0));
        topPane.add((Node)this.newOvalButton, 0, 0);
        topPane.add((Node)this.newPolygonButton, 1, 0);
        topPane.add((Node)this.newLineButton, 2, 0);
        topPane.add((Node)this.newCurveButton, 3, 0);
        topPane.add((Node)new Label("     "), 4, 0);
        topPane.add((Node)this.shapeDeleteButton, 5, 0);
        shapesSelectButton.setStyle("-fx-font-size: 9px");
        topPane.add((Node)shapesSelectButton, 0, 1);
        topPane.add((Node)this.shapesDeselectButton, 1, 1);
        this.shapesDeselectButton.setOnAction(event -> {
            ShapesToolbox shapesToolbox = this;
            shapesToolbox.worldographer.getMapUI().getCurrentObjects().clear();
            ShapesToolbox shapesToolbox2 = this;
            shapesToolbox2.worldographer.getMapUI().hoverObject = null;
            ShapesToolbox shapesToolbox3 = this;
            shapesToolbox3.worldographer.getMapUI().draw();
        });
        this.shapeJoinButton.setOnAction(event -> {
            ShapesToolbox shapesToolbox = this;
            shapesToolbox.worldographer.getMapUI().getController().joinShapes(this.worldographer.undoEnabled);
        });
        topPane.add((Node)this.shapeConvertToRiverButton, 4, 1);
        this.shapeConvertToRiverButton.setOnAction(event -> {
            GridPane gp = new GridPane();
            gp.add((Node)new Label("River Mouth Width (% of tile):"), 0, 0);
            FocusSpinner mouthWidthSpinner = new FocusSpinner(0.0, 1000.0, 35.0, 1.0);
            gp.add(mouthWidthSpinner, 1, 0);
            gp.add((Node)new Label("River End Width (% of tile):"), 0, 1);
            FocusSpinner riverEndSpinner = new FocusSpinner(0.0, 1000.0, 10.0, 1.0);
            riverEndSpinner.getValueFactory().setValue((Object)3.0);
            gp.add(riverEndSpinner, 1, 1);
            gp.add((Node)new Label("Mouth is nearer the:"), 0, 2);
            ObservableList options = FXCollections.observableArrayList((Object[])new String[]{"Top", "Bottom", "Left", "Right"});
            ComboBox mouthBox = new ComboBox(options);
            mouthBox.getSelectionModel().select(0);
            gp.add((Node)mouthBox, 1, 2);
            Dialog d = new Dialog();
            d.setTitle("Worldographer Taper Line Selected");
            d.setHeaderText("This will convert a line into a polygon for better looking rivers.\nIt makes one end (the mouth) wider than the other.");
            d.getDialogPane().setContent((Node)gp);
            ButtonType yes = new ButtonType("Taper");
            ButtonType no = new ButtonType("Cancel");
            d.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{yes, no});
            Optional result = d.showAndWait();
            if (result.isPresent() && result.get() == yes) {
                ShapesToolbox shapesToolbox = this;
                ShapesToolbox shapesToolbox2 = this;
                shapesToolbox.worldographer.getMapUI().getController().updateShapeToRiver(shapesToolbox2.worldographer.getMapUI().getCurrentObjects(), (Double)mouthWidthSpinner.getValue(), (Double)riverEndSpinner.getValue(), (String)mouthBox.getSelectionModel().getSelectedItem());
                ShapesToolbox shapesToolbox3 = this;
                shapesToolbox3.worldographer.getMapUI().draw();
            }
        });
        this.shapeDeleteButton.setAlignment(Pos.CENTER_RIGHT);
        this.shapeDeleteButton.setOnAction(event -> {
            ArrayList<MapShape> todelete = new ArrayList<MapShape>();
            for (Object e : this.mapUI().getCurrentObjects()) {
                if (!(e instanceof MapShape)) continue;
                todelete.add((MapShape)e);
            }
            this.mapUI().getController().deleteShapes(todelete);
            this.mapUI().draw();
        });
        topPane.add((Node)new Label("Edit Shapes Reminder: Select shape: click one of its points.\n  Control-Drag: Move pt; Shift-Click: Delete pt (non-arc/oval);\n  Alt-Click: Add pt to segment middle (non-arc/oval).\n"), 0, 3, 6, 1);
        topPane.add((Node)new Label("Preset: "), 0, 4, 3, 1);
        topPane.add((Node)this.makePresetBox(), 0, 5, 3, 1);
        topPane.add((Node)new Label("Change Z-Axis: "), 3, 4, 3, 1);
        topPane.add((Node)this.makeZAxisBox(), 3, 5, 3, 1);
        return topPane;
    }

    public void updateShapeStyleList() {
        this.shapePresetFilterBox.getItems().clear();
        if (this.mapUI().getMapData().getShapeStyles() != null) {
            this.shapePresetFilterBox.getItems().addAll(this.mapUI().getMapData().getShapeStyles().keySet());
        }
    }

    public void initShapesControls() {
        int buttonSize = 60;
        int buttonHeight = 66;
        this.newOvalButton = ShapesToolbox.makeToggleButtonWithStyleIcon("Arc/Oval", "mdi2s-shape-oval-plus", 28, "-fx-font-size: 9px", "Draw an oval or arc on the map by clicking its center and a point that would represent a\ncorner of a bounding box around the oval. Use the Arc Options below to customize a partial oval.", this.worldographer.toggleGroup, buttonSize, buttonHeight);
        this.newPolygonButton = ShapesToolbox.makeToggleButtonWithStyleIcon("Polygon", "mdi2s-shape-polygon-plus", 28, "-fx-font-size: 9px", "Draw a polygon on the map by clicking its points. Like all shapes,\nuse the controls below to customize it.", this.worldographer.toggleGroup, buttonSize, buttonHeight);
        this.newLineButton = ShapesToolbox.makeToggleButtonWithStyleIcon("Line", "mdi2v-vector-polyline", 28, "-fx-font-size: 9px", "Draw a line that connects point to point on the map by clicking its points.\nLike all shapes, use the controls below to customize it.", this.worldographer.toggleGroup, buttonSize, buttonHeight);
        this.newCurveButton = ShapesToolbox.makeToggleButtonWithStyleIcon("Curve", "mdi2v-vector-curve", 28, "-fx-font-size: 9px", "Draw a line that curves on the map by clicking its points. The first point is an anchor\npoint, then the next two points you click are points that control the bend to the 4th point,\nwhich is another anchor point. Then the next two points are more control points, and so on.\nLike all shapes, use the controls below to customize it.", this.worldographer.toggleGroup, buttonSize, buttonHeight);
        shapesSelectButton = ShapesToolbox.makeToggleButtonWithStyleIcon("Select", "mdi2s-selection-ellipse-arrow-inside", 28, "-fx-font-size: 9px", "Click this and all shape points on the map become small circles. Select any of them\nto select a shape.  Then use the controls below to edit it, or move points by control-dragging\nthem, remove a point by shift-clicking it, and alt-click to add a point within a shape.", this.worldographer.toggleGroup, buttonSize, buttonHeight);
        shapesSelectButton.setOnAction(event -> {
            if (this.mapUI() != null) {
                this.mapUI().selectingShapes = shapesSelectButton.isSelected();
                this.mapUI().draw();
            }
        });
        this.shapesDeselectButton = ShapesToolbox.makeButtonWithStyleIcon("De-select\n(Ctrl-D)", "mdi2s-selection-off", 18, "-fx-font-size: 9px", "De-selects the currently selected shape.", buttonSize, buttonHeight);
        this.shapeJoinButton = ShapesToolbox.makeButtonWithStyleIcon("Join Shapes", "mdi2v-vector-combine", 28, "-fx-font-size: 9px", "Select two or more shapes then click this button to make them one shape.", buttonSize, buttonHeight);
        this.shapeConvertToRiverButton = new Button("Taper Line\nSelected", (Node)new ImageView(LoadImage.image("other_imgs/convert_to_river.png")));
        this.shapeConvertToRiverButton.setTooltip(new Tooltip("Turns a selected line into a polygon with one end wider than the other\nso it looks more like a river. A dialog lets you set the details."));
        this.shapeConvertToRiverButton.setStyle("-fx-font-size: 9px");
        this.shapeConvertToRiverButton.setTextAlignment(TextAlignment.CENTER);
        this.shapeConvertToRiverButton.setTextOverrun(OverrunStyle.ELLIPSIS);
        this.shapeConvertToRiverButton.setContentDisplay(ContentDisplay.TOP);
        this.shapeConvertToRiverButton.setMaxWidth((double)buttonSize);
        this.shapeConvertToRiverButton.setMinWidth((double)buttonSize);
        this.shapeConvertToRiverButton.setMaxHeight((double)buttonHeight);
        this.shapeConvertToRiverButton.setMinHeight((double)buttonHeight);
        this.shapeDeleteButton = ShapesToolbox.makeButtonWithStyleIcon("Delete", "mdi2d-delete", 28, "-fx-font-size: 9px", "Deletes the currently selected shape(s).", buttonSize, buttonHeight);
        this.strokeTypeCombo = new ComboBox(FXCollections.observableArrayList((Object[])MapShape.StrokeType.values()));
        this.shapeFractalCB = new CheckBox("Fractal (Polygon/Line only)");
        this.strokeWidthSpinner = new FocusSpinner<Double>(0.0, 1000.0, 5.0, 1.0);
        this.shapesColorStrokeFB = new RadioButton("Color:");
        this.shapesStrokeCP = new ColorPicker();
        this.shapesStrokeCPWSelector = new ColorPickerWithSelector(this.shapesStrokeCP);
        this.shapesTextureStrokeFB = new RadioButton("Texture: ");
        this.texturesList = FXCollections.observableArrayList(TextureType.ALL_TEXTURES.values());
        this.shapesTextureStrokeCombo = new ComboBox(this.texturesList);
        this.shapesNoFillCB = new RadioButton("No Fill");
        this.shapesColorFillFB = new RadioButton("Color:");
        this.shapesFillCP = new ColorPicker();
        this.shapesFillCPWSelector = new ColorPickerWithSelector(this.shapesFillCP);
        this.shapesTextureFillFB = new RadioButton("Texture: ");
        this.shapesTextureFillCombo = new ComboBox(this.texturesList);
        this.shapesOpacitySpinner = new FocusSpinner<Double>(0.0, 100.0, 100.0, 1.0);
        this.shapesTagsTF = new TextField();
        this.shapesGMOnlyCB = new CheckBox("GM Only");
        this.shapesGMOnlyCB.setOnAction(event -> {
            this.mapUI().getController().updateGMOnly(this.worldographer.undoEnabled, this.mapUI().getCurrentObjects(), this.shapesGMOnlyCB.isSelected());
            this.mapUI().draw();
        });
        this.shapesMapLayerCombo = new ComboBox(this.worldographer.observableLayers);
        this.shapesSnapCB = new CheckBox("Snap Points to Grid (Ctrl-G)");
        this.shapesMatchTileBordersCB = new CheckBox("Add Tile Border to Polygon");
        this.strokeLineCapCombo = new ComboBox(FXCollections.observableArrayList((Object[])StrokeLineCap.values()));
        this.strokeLineJoinCombo = new ComboBox(FXCollections.observableArrayList((Object[])StrokeLineJoin.values()));
        this.arcStartSpinner = new FocusSpinner<Double>(0.0, 360.0, 0.0, 1.0);
        this.arcExtentSpinner = new FocusSpinner<Double>(0.0, 360.0, 360.0, 1.0);
        this.extraLineWidthSpinner = new FocusSpinner<Double>(0.0, 1000.0, 10.0, 1.0);
        this.extraLineDistanceSpinner = new FocusSpinner<Double>(0.0, 1000.0, 30.0, 1.0);
        this.extraLineLengthSpinner = new FocusSpinner<Double>(0.0, 1000.0, 30.0, 1.0);
        this.extraLineSeparationSpinner = new FocusSpinner<Double>(0.0, 1000.0, 15.0, 1.0);
        this.shapeDropShadowCB = new CheckBox("Drop Shadow");
        this.shapeDropShadowSpreadTF = new FocusSpinner<Double>(0.0, 1.0, 0.2, 0.1);
        this.shapeDropShadowRadiusTF = new FocusSpinner<Double>(0.0, 1000.0, 50.0, 1.0);
        this.shapeDropShadowOffsetXTF = new FocusSpinner<Double>(-1000.0, 1000.0, 0.0, 1.0);
        this.shapeDropShadowOffsetYTF = new FocusSpinner<Double>(-1000.0, 1000.0, 0.0, 1.0);
        this.shapeDropShadowCP = new ColorPicker(Color.BISQUE);
        this.shapeInnerShadowCB = new CheckBox("Inner Shadow");
        this.shapeInnerShadowChokeTF = new FocusSpinner<Double>(0.0, 1000.0, 0.2, 0.1);
        this.shapeInnerShadowRadiusTF = new FocusSpinner<Double>(0.0, 1000.0, 50.0, 1.0);
        this.shapeInnerShadowOffsetXTF = new FocusSpinner<Double>(-1000.0, 1000.0, 0.0, 1.0);
        this.shapeInnerShadowOffsetYTF = new FocusSpinner<Double>(-1000.0, 1000.0, 0.0, 1.0);
        this.shapeInnerShadowCP = new ColorPicker(Color.BISQUE);
        this.shapeBoxBlurCB = new CheckBox("Box Blur");
        this.shapeBoxBlurWidthTF = new FocusSpinner<Double>(0.0, 1000.0, 10.0, 1.0);
        this.shapeBoxBlurHeightTF = new FocusSpinner<Double>(0.0, 1000.0, 10.0, 1.0);
        this.shapeBoxBlurIterTF = new FocusSpinner<Integer>(0, 1000, 3, 1);
        this.gradientEdgeCB = new CheckBox("Gradient Edge");
        this.shapeWorldCB = new CheckBox("World");
        this.shapeWorldCB.setSelected(true);
        this.shapeContinentCB = new CheckBox("Continent");
        this.shapeContinentCB.setSelected(true);
        this.shapeKingdomCB = new CheckBox("Kingdom");
        this.shapeKingdomCB.setSelected(true);
        this.shapeProvinceCB = new CheckBox("Province");
        this.shapeProvinceCB.setSelected(true);
    }

    public void updateSelectionControls(MapShape ms) {
        this.shapesMapLayerCombo.getSelectionModel().select((Object)ms.getMapLayer());
        this.shapeContinentCB.setSelected(ms.isContinent());
        this.shapeKingdomCB.setSelected(ms.isKingdom());
        this.shapeWorldCB.setSelected(ms.isWorld());
        this.shapeProvinceCB.setSelected(ms.isProvince());
        this.shapesSnapCB.setSelected(ms.isSnapVertices());
        this.shapesMatchTileBordersCB.setSelected(ms.isMatchTileBorders());
        this.shapesGMOnlyCB.setSelected(ms.isGmOnly());
        this.shapesNoFillCB.setSelected(ms.getShape().getFill() == null);
        this.shapesColorFillFB.setSelected(ms.getShape().getFill() instanceof Color);
        this.shapesTextureFillFB.setSelected(ms.getShape().getFill() instanceof ImagePattern);
        this.shapesColorStrokeFB.setSelected(ms.getShape().getStroke() instanceof Color);
        this.shapesTextureStrokeFB.setSelected(ms.getShape().getStroke() instanceof ImagePattern);
        if (ms.getShape().getFill() instanceof Color) {
            this.shapesFillCP.setValue((Object)((Color)ms.getShape().getFill()));
        }
        if (ms.getShape().getStroke() instanceof Color) {
            this.shapesStrokeCP.setValue((Object)((Color)ms.getShape().getStroke()));
        }
        this.shapesOpacitySpinner.getValueFactory().setValue((Object)(ms.getShape().getOpacity() * 100.0));
        this.strokeWidthSpinner.getValueFactory().setValue((Object)(ms.getShape().getStrokeWidth() * 100.0));
        if (ms.getShape().getStroke() instanceof ImagePattern) {
            this.shapesTextureStrokeCombo.getSelectionModel().select((Object)ms.getStrokeTexture());
        }
        if (ms.getShape().getFill() instanceof ImagePattern) {
            this.shapesTextureFillCombo.getSelectionModel().select((Object)ms.getFillTexture());
        }
        this.shapesTagsTF.setText(ms.getTags());
        this.strokeLineCapCombo.getSelectionModel().select((Object)ms.getShape().getStrokeLineCap());
        this.strokeLineJoinCombo.getSelectionModel().select((Object)ms.getShape().getStrokeLineJoin());
        this.strokeTypeCombo.getSelectionModel().select((Object)ms.getStrokeType());
        if (ms.getShape() instanceof Arc) {
            this.arcStartSpinner.getValueFactory().setValue((Object)((Arc)ms.getShape()).getStartAngle());
            this.arcExtentSpinner.getValueFactory().setValue((Object)((Arc)ms.getShape()).getLength());
            this.arcTypeCombo.getSelectionModel().select((Object)((Arc)ms.getShape()).getType());
        }
        this.shapeDropShadowCB.setSelected(ms.isDropShadow());
        this.shapeInnerShadowCB.setSelected(ms.isInnerShadow());
        this.shapeBoxBlurCB.setSelected(ms.isBoxBlur());
        this.shapeDropShadowSpreadTF.getValueFactory().setValue((Object)ms.getDsSpread());
        this.shapeDropShadowRadiusTF.getValueFactory().setValue((Object)ms.getDsRadius());
        this.shapeDropShadowOffsetXTF.getValueFactory().setValue((Object)ms.getDsOffsetX());
        this.shapeDropShadowOffsetYTF.getValueFactory().setValue((Object)ms.getDsOffsetY());
        this.shapeDropShadowCP.setValue((Object)ms.getDsColor());
        this.shapeInnerShadowChokeTF.getValueFactory().setValue((Object)ms.getInsChoke());
        this.shapeInnerShadowRadiusTF.getValueFactory().setValue((Object)ms.getInsRadius());
        this.shapeInnerShadowOffsetXTF.getValueFactory().setValue((Object)ms.getInsOffsetX());
        this.shapeInnerShadowOffsetYTF.getValueFactory().setValue((Object)ms.getInsOffsetY());
        this.shapeInnerShadowCP.setValue((Object)ms.getInsColor());
        this.shapeBoxBlurWidthTF.getValueFactory().setValue((Object)ms.getBbWidth());
        this.shapeBoxBlurHeightTF.getValueFactory().setValue((Object)ms.getBbHeight());
        this.shapeBoxBlurIterTF.getValueFactory().setValue((Object)ms.getBbIterations());
    }

    public boolean isSelected() {
        return shapesSelectButton.isSelected() || this.newOvalButton.isSelected() || this.newPolygonButton.isSelected() || this.newLineButton.isSelected() || this.newCurveButton.isSelected();
    }

    public void controlGClick() {
        this.shapesSnapCB.setSelected(!this.shapesSnapCB.isSelected());
        ShapesToolbox shapesToolbox = this;
        for (MapObject mo : shapesToolbox.worldographer.getMapUI().getCurrentObjects()) {
            if (!(mo instanceof MapShape)) continue;
            MapShape ms = (MapShape)mo;
            ms.setSnapVertices(this.shapesSnapCB.isSelected());
        }
    }

    public boolean deletePointSelected() {
        return this.newPolygonButton.isSelected() || this.newLineButton.isSelected() || this.newCurveButton.isSelected() || shapesSelectButton.isSelected();
    }

    public boolean addPointsSelected() {
        return shapesSelectButton.isSelected() || this.newOvalButton.isSelected() || this.newPolygonButton.isSelected() || this.newLineButton.isSelected() || this.newCurveButton.isSelected();
    }

    public void placeShapeOrAddPoints(MouseEvent t) {
        Polygon shape = null;
        if (this.newPolygonButton.isSelected()) {
            shape = new Polygon();
        } else if (this.newLineButton.isSelected() || this.newCurveButton.isSelected()) {
            shape = new Path();
        } else if (this.newOvalButton.isSelected()) {
            shape = new Arc();
        }
        MapLayer layer = (MapLayer)this.shapesMapLayerCombo.getSelectionModel().getSelectedItem();
        if (layer == null) {
            layer = this.mapUI().getMapData().getMapLayer("Above Terrain");
            if (layer == null) {
                layer = new MapLayer("Above Terrain");
                this.mapUI().getMapData().getMapLayers().add(4, layer);
            }
            this.shapesMapLayerCombo.getSelectionModel().select((Object)layer);
        }
        Point2D modelpt = this.mapUI().getModelCoordsFromScreenPt(t.getX(), t.getY());
        this.mapUI().getController().placeShapeOrAddPoints(modelpt, this.worldographer.getSnapModelPtFromModelPt(modelpt), t.isAltDown(), t.isControlDown(), (Shape)shape, this.newCurveButton.isSelected() ? MapShape.CreationType.CURVE : MapShape.CreationType.BASIC, (MapShape.StrokeType)((Object)this.strokeTypeCombo.getValue()), this.shapesGMOnlyCB.isSelected(), this.shapesTagsTF.getText(), (Double)this.extraLineDistanceSpinner.getValue(), (Double)this.extraLineLengthSpinner.getValue(), (Double)this.extraLineWidthSpinner.getValue(), (Double)this.extraLineSeparationSpinner.getValue(), this.shapeWorldCB.isSelected(), this.shapeContinentCB.isSelected(), this.shapeKingdomCB.isSelected(), this.shapeProvinceCB.isSelected(), layer, (Double)this.strokeWidthSpinner.getValue() / 100.0, (Double)this.shapesOpacitySpinner.getValue() / 100.0, this.shapesSnapCB.isSelected(), this.shapesMatchTileBordersCB.isSelected(), this.shapeDropShadowCB.isSelected(), (Color)this.shapeDropShadowCP.getValue(), (Double)this.shapeDropShadowOffsetXTF.getValue(), (Double)this.shapeDropShadowOffsetYTF.getValue(), (Double)this.shapeDropShadowSpreadTF.getValue(), (Double)this.shapeDropShadowRadiusTF.getValue(), this.shapeInnerShadowCB.isSelected(), (Color)this.shapeInnerShadowCP.getValue(), (Double)this.shapeInnerShadowOffsetXTF.getValue(), (Double)this.shapeInnerShadowOffsetYTF.getValue(), (Double)this.shapeInnerShadowChokeTF.getValue(), (Double)this.shapeInnerShadowRadiusTF.getValue(), this.shapeBoxBlurCB.isSelected(), (Double)this.shapeBoxBlurWidthTF.getValue(), (Double)this.shapeBoxBlurHeightTF.getValue(), (Integer)this.shapeBoxBlurIterTF.getValue(), (StrokeLineCap)this.strokeLineCapCombo.getSelectionModel().getSelectedItem(), (StrokeLineJoin)this.strokeLineJoinCombo.getSelectionModel().getSelectedItem(), this.shapesColorFillFB.isSelected(), (Color)this.shapesFillCP.getValue(), this.shapesTextureFillFB.isSelected(), (TextureType)this.shapesTextureFillCombo.getSelectionModel().getSelectedItem(), this.shapesColorStrokeFB.isSelected(), (Color)this.shapesStrokeCP.getValue(), this.shapesTextureStrokeFB.isSelected(), (TextureType)this.shapesTextureStrokeCombo.getSelectionModel().getSelectedItem(), this.shapeFractalCB.isSelected(), (Double)this.arcStartSpinner.getValue(), (Double)this.arcExtentSpinner.getValue(), (ArcType)this.arcTypeCombo.getValue());
        this.mapUI().draw();
    }

    public void updatePresets(String stylename) {
        ShapeStyle ss = Worldographer.getMapUI().getMapData().getShapeStyles().get(stylename);
        if (ss == null) {
            return;
        }
        this.strokeWidthSpinner.getValueFactory().setValue((Object)ss.getStrokeWidth());
        this.shapeBoxBlurCB.setSelected(ss.isBoxBlur());
        if (ss.isBoxBlur()) {
            this.shapeBoxBlurHeightTF.getValueFactory().setValue((Object)ss.getBbHeight());
            this.shapeBoxBlurIterTF.getValueFactory().setValue((Object)ss.getBbIterations());
            this.shapeBoxBlurWidthTF.getValueFactory().setValue((Object)ss.getBbWidth());
        }
        this.shapeDropShadowCB.setSelected(ss.isDropShadow());
        if (ss.isDropShadow()) {
            this.shapeDropShadowCP.setValue((Object)ss.getDsColor());
            this.shapeDropShadowOffsetXTF.getValueFactory().setValue((Object)ss.getDsOffsetX());
            this.shapeDropShadowOffsetYTF.getValueFactory().setValue((Object)ss.getDsOffsetY());
            this.shapeDropShadowRadiusTF.getValueFactory().setValue((Object)ss.getDsRadius());
            this.shapeDropShadowSpreadTF.getValueFactory().setValue((Object)ss.getDsSpread());
        }
        this.shapeFractalCB.setSelected(ss.isFractal());
        this.shapeInnerShadowCB.setSelected(ss.isInnerShadow());
        if (ss.isInnerShadow()) {
            this.shapeInnerShadowChokeTF.getValueFactory().setValue((Object)ss.getInsChoke());
            this.shapeInnerShadowCP.setValue((Object)ss.getInsColor());
            this.shapeInnerShadowOffsetXTF.getValueFactory().setValue((Object)ss.getInsOffsetX());
            this.shapeInnerShadowOffsetYTF.getValueFactory().setValue((Object)ss.getInsOffsetY());
            this.shapeInnerShadowRadiusTF.getValueFactory().setValue((Object)ss.getInsRadius());
        }
        StrokeLineCap slc = StrokeLineCap.valueOf((String)ss.getLineCap());
        this.strokeLineCapCombo.getSelectionModel().select((Object)slc);
        StrokeLineJoin slj = StrokeLineJoin.valueOf((String)ss.getLineJoin());
        this.strokeLineJoinCombo.getSelectionModel().select((Object)slj);
        this.strokeTypeCombo.getSelectionModel().select((Object)ss.getStrokeType());
        this.shapesColorFillFB.setSelected(ss.getStrokePaint() instanceof Color);
        if (ss.getStrokePaint() instanceof Color) {
            this.shapesStrokeCP.setValue((Object)((Color)ss.getFillPaint()));
        }
        this.shapesColorStrokeFB.setSelected(ss.getStrokePaint() instanceof Color);
        if (ss.getFillPaint() instanceof Color) {
            this.shapesFillCP.setValue((Object)((Color)ss.getFillPaint()));
        }
        this.shapesNoFillCB.setSelected(ss.getFillPaint() == null);
        this.shapesOpacitySpinner.getValueFactory().setValue((Object)ss.getOpacity());
        this.shapesSnapCB.setSelected(ss.isSnapVertices());
        this.shapesStrokeCP.setValue((Object)((Color)ss.getStrokePaint()));
        this.shapesTagsTF.setText(ss.getTags());
        if (ss.getFillTexture() != null) {
            this.shapesTextureFillCombo.getSelectionModel().select((Object)ss.getFillTexture());
        }
        this.shapesTextureFillFB.setSelected(ss.getFillTexture() != null);
        if (ss.getStrokeTexture() != null) {
            this.shapesTextureStrokeCombo.getSelectionModel().select((Object)ss.getStrokeTexture());
        }
        this.shapesTextureStrokeFB.setSelected(ss.getStrokeTexture() != null);
        for (MapObject mo : this.mapUI().getCurrentObjects()) {
            if (!(mo instanceof MapShape)) continue;
            MapShape ms = (MapShape)mo;
            if (this.shapesColorStrokeFB.isSelected()) {
                ms.getShape().setStroke((Paint)this.shapesStrokeCP.getValue());
                this.mapUI().draw();
            }
            if (this.shapesTextureStrokeFB.isSelected()) {
                Paint oldvaltexture = ms.getShape(this.mapUI().getMapData(), this.mapUI().viewLevel).getStroke();
                ImagePattern newtexture = new ImagePattern(((TextureType)this.shapesTextureStrokeCombo.getSelectionModel().getSelectedItem()).getIcon(), 0.0, 0.0, 50.0, 25.0, false);
                ms.setStrokeTexture((TextureType)this.shapesTextureStrokeCombo.getValue());
                ms.getShape(this.mapUI().getMapData(), this.mapUI().viewLevel).setStroke((Paint)newtexture);
                this.mapUI().draw();
            }
            if (this.shapesColorFillFB.isSelected()) {
                this.mapUI().getController().updateShapeColorFill(this.worldographer.undoEnabled, null, ms, (Color)this.shapesFillCP.getValue());
                this.mapUI().draw();
            }
            if (!this.shapesTextureFillFB.isSelected()) continue;
            this.mapUI().getController().updateShapeTextureFill(this.worldographer.undoEnabled, null, ms, (TextureType)this.shapesTextureStrokeCombo.getValue());
            this.mapUI().draw();
        }
    }

    public void addShapesButtons(HBox topbox2) {
        topbox2.getChildren().add((Object)this.newPolygonButton);
        topbox2.getChildren().add((Object)this.newLineButton);
        topbox2.getChildren().add((Object)this.newCurveButton);
        topbox2.getChildren().add((Object)this.newOvalButton);
    }

    public void updateTextures() {
        if (this.texturesList == null) {
            this.texturesList = FXCollections.observableArrayList(new ArrayList());
        }
        for (TextureType tt : TextureType.ALL_TEXTURES.values()) {
            if (this.texturesList.contains((Object)tt)) continue;
            this.texturesList.add((Object)tt);
        }
        ArrayList<TextureType> toremove = new ArrayList<TextureType>();
        for (TextureType s : this.texturesList) {
            if (TextureType.ALL_TEXTURES.containsValue(s)) continue;
            toremove.add(s);
        }
        this.texturesList.removeAll(toremove);
        if (this.mapUI() != null) {
            Platform.runLater(() -> this.mapUI().draw());
        }
    }

    public static class TextureListCell
    extends ListCell<TextureType> {
        protected void updateItem(TextureType item, boolean empty) {
            super.updateItem((Object)item, empty);
            this.setGraphic(null);
            this.setText(null);
            if (item != null) {
                ImageView imageView = new ImageView(item.getIcon());
                imageView.setFitWidth(40.0);
                imageView.setFitHeight(40.0);
                this.setGraphic((Node)imageView);
                this.setText(item.getType());
            }
        }
    }
}

