/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.ui.toolbox;

import com.inkwellideas.ographer.ui.MapUI;
import com.inkwellideas.ographer.ui.Worldographer;
import com.inkwellideas.ographer.ui.dialog.StandardDialog;
import com.inkwellideas.ographer.util.SafePreferences;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.OverrunStyle;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.BorderPane;
import javafx.scene.text.TextAlignment;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.kordamp.ikonli.javafx.FontIcon;

public abstract class Toolbox {
    protected Stage stage;
    protected final Worldographer worldographer;
    SafePreferences prefs = new SafePreferences("com/inkwellideas/worldographer2025");

    public Toolbox(Worldographer worldographer) {
        this.worldographer = worldographer;
    }

    public abstract void setup(ToggleButton var1);

    protected MapUI mapUI() {
        Toolbox toolbox = this;
        return toolbox.worldographer.getMapUI();
    }

    public void close() {
        if (this.stage != null) {
            this.stage.close();
        }
    }

    public void createToolbox(String name, String imagefilename, Node content, int width, int height, boolean usescrollpane) {
        this.createToolbox(this.worldographer.getPrimaryStage(), name, imagefilename, content, width, height, usescrollpane);
    }

    public void createToolbox(Stage primaryStage, String name, String imagefilename, Node content, double width, double height, boolean usescrollpane) {
        Scene scene;
        this.stage = new Stage();
        this.stage.getIcons().add((Object)this.worldographer.from(imagefilename));
        this.stage.initOwner((Window)primaryStage);
        this.stage.setTitle(name);
        if (usescrollpane) {
            BorderPane border = new BorderPane();
            ScrollPane sp = new ScrollPane();
            sp.setFitToHeight(true);
            sp.setFitToWidth(true);
            sp.setContent(content);
            border.setCenter((Node)sp);
            scene = new Scene((Parent)border);
        } else {
            scene = new Scene((Parent)((BorderPane)content), width, height);
        }
        width = this.prefs.getDouble(this.getClass().getSimpleName() + "-width", width);
        height = this.prefs.getDouble(this.getClass().getSimpleName() + "-height", height);
        this.stage.setWidth(width);
        this.stage.setHeight(height);
        double x = this.prefs.getDouble(this.getClass().getSimpleName() + "-x", primaryStage.getX() + primaryStage.getWidth() / 2.0 - width / 2.0);
        double y = this.prefs.getDouble(this.getClass().getSimpleName() + "-y", primaryStage.getY() + primaryStage.getHeight() / 2.0 - height / 2.0);
        x = Math.min(x, primaryStage.getX() + primaryStage.getWidth() - 60.0);
        y = Math.min(y, primaryStage.getY() + primaryStage.getHeight() - 60.0);
        x = Math.max(x, 0.0);
        y = Math.max(y, 0.0);
        this.stage.setX(x);
        this.stage.setY(y);
        this.stage.setScene(scene);
        this.stage.setOnHiding(event -> {
            this.prefs.putDouble(this.getClass().getSimpleName() + "-width", this.stage.getWidth());
            this.prefs.putDouble(this.getClass().getSimpleName() + "-height", this.stage.getHeight());
            this.prefs.putDouble(this.getClass().getSimpleName() + "-x", this.stage.getX());
            this.prefs.putDouble(this.getClass().getSimpleName() + "-y", this.stage.getY());
        });
    }

    public boolean open() {
        return this.stage != null;
    }

    public void closeIfOpen(ToggleButton toggleButton) {
        if (this.open()) {
            toggleButton.setSelected(false);
            this.close();
        }
    }

    public void openCloseButton(ToggleButton toggleButton, CheckBox toolboxMenuItem) {
        if (!toggleButton.isSelected()) {
            if (this.open()) {
                this.close();
            }
            return;
        }
        if (this.mapUI() == null || this.mapUI().getMapData() == null) {
            toggleButton.setSelected(false);
            StandardDialog.showDialog(this.worldographer.getPrimaryStage(), "Map Needed", null, "You must have a map created/opened to open toolboxes.", null, null);
        } else if (toolboxMenuItem == null || toolboxMenuItem.isSelected()) {
            this.setup(toggleButton);
        } else {
            toggleButton.setSelected(false);
            StandardDialog.showDialog(this.worldographer.getPrimaryStage(), "Use Toolboxes Must Be Checked", null, "The Use Toolboxes not Drawers menu item on the Toolboxes menu must be checked if you want to use toolboxes.", null, null);
        }
    }

    public static ToggleButton makeToggleButtonWithStyleIcon(String label, String styleCode, int size, String style, String tooltip, ToggleGroup toggleGroup, int w, int h) {
        ToggleButton button = new ToggleButton(label);
        button.setToggleGroup(toggleGroup);
        FontIcon fontIcon = new FontIcon();
        fontIcon.setStyle("-fx-icon-code:" + styleCode + ";-fx-icon-size:" + size + ";");
        button.setGraphic((Node)fontIcon);
        button.setStyle(style);
        button.setTooltip(new Tooltip(tooltip));
        button.setTextAlignment(TextAlignment.CENTER);
        button.setTextOverrun(OverrunStyle.ELLIPSIS);
        button.setContentDisplay(ContentDisplay.TOP);
        if (w > 0) {
            button.setMaxWidth((double)w);
            button.setMinWidth((double)w);
        }
        if (h > 0) {
            button.setMaxHeight((double)h);
            button.setMinHeight((double)h);
        }
        return button;
    }

    public static Button makeButtonWithStyleIcon(String label, String styleCode, int size, String style, String tooltip, int w, int h) {
        Button button = new Button(label);
        FontIcon fontIcon = new FontIcon();
        fontIcon.setStyle("-fx-icon-code:" + styleCode + ";-fx-icon-size:" + size + ";");
        button.setGraphic((Node)fontIcon);
        button.setStyle(style);
        button.setTooltip(new Tooltip(tooltip));
        button.setTextAlignment(TextAlignment.CENTER);
        button.setTextOverrun(OverrunStyle.ELLIPSIS);
        button.setContentDisplay(ContentDisplay.TOP);
        if (w > 0) {
            button.setMaxWidth((double)w);
            button.setMinWidth((double)w);
        }
        if (h > 0) {
            button.setMaxHeight((double)h);
            button.setMinHeight((double)h);
        }
        return button;
    }
}

