/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.ui.toolbox;

import com.inkwellideas.ographer.io.UserPrefs;
import com.inkwellideas.ographer.ui.Worldographer;
import com.inkwellideas.ographer.ui.dialog.StandardDialog;
import com.inkwellideas.ographer.ui.toolbox.Toolbox;
import com.inkwellideas.ographer.ui.widget.FocusSpinner;
import java.io.File;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.Spinner;
import javafx.scene.control.ToggleButton;
import javafx.scene.image.Image;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.stage.FileChooser;

public class UnderlayToolbox
extends Toolbox {
    Spinner<Double> traceWidthTF;
    Spinner<Double> traceHeightTF;
    Spinner<Double> opacityTF;

    public UnderlayToolbox(Worldographer worldographer) {
        super(worldographer);
    }

    @Override
    public void setup(ToggleButton toggleButton) {
        this.createToolbox("Trace Underlay", "other_imgs/trace_24.png", (Node)this.createTraceUnderlayDrawer(), 400, 120, true);
        this.stage.show();
        this.stage.setOnCloseRequest(event -> toggleButton.setSelected(false));
    }

    public GridPane createTraceUnderlayDrawer() {
        GridPane grid2 = new GridPane();
        grid2.setAlignment(Pos.CENTER);
        grid2.setHgap(5.0);
        grid2.setVgap(5.0);
        grid2.setPadding(new Insets(3.0, 3.0, 3.0, 3.0));
        HBox box = new HBox();
        Button filebutton = new Button("Select File");
        filebutton.setMinWidth(90.0);
        filebutton.setMaxWidth(90.0);
        filebutton.setOnAction(t -> {
            if (!UserPrefs.FULL) {
                StandardDialog.showDialog(this.worldographer.getPrimaryStage(), "Pro Feature", "Tracing an image is only available if using a Pro version license.", "Sorry, some features are reserved for our Pro/paid version. \nIf you find the software useful, considering unlocking these special features and supporting \nthe many hours of work to create Worldographer with a Pro license. \nSee www.worldographer.com for details.\n", null, "");
                return;
            }
            FileChooser fc = new FileChooser();
            File f = fc.showOpenDialog(null);
            if (f != null) {
                this.mapUI().getMapData().getTrace().setImage(new Image(f.toURI().toString()));
                this.mapUI().getMapData().getTrace().setImageFileName(f.getAbsolutePath());
                filebutton.setText(f.getName());
                this.mapUI().getMapData().getTrace().setHeight(10.0);
                this.mapUI().getMapData().getTrace().setWidth(10.0);
                this.traceWidthTF.getValueFactory().setValue((Object)10.0);
                this.traceHeightTF.getValueFactory().setValue((Object)10.0);
                this.opacityTF.getValueFactory().setValue((Object)50.0);
            } else {
                this.mapUI().getMapData().getTrace().setImage(null);
                this.mapUI().getMapData().getTrace().setImageFileName(null);
                filebutton.setText("Select File");
            }
            this.mapUI().draw();
        });
        box.getChildren().add((Object)filebutton);
        Button removeButton = new Button("Remove");
        removeButton.setMinWidth(80.0);
        removeButton.setMaxWidth(80.0);
        box.getChildren().add((Object)removeButton);
        removeButton.setOnAction(t -> {
            this.mapUI().getMapData().getTrace().setImage(null);
            this.mapUI().getMapData().getTrace().setImageFileName(null);
            filebutton.setText("Select File");
            this.mapUI().draw();
        });
        grid2.add((Node)box, 0, 0, 2, 1);
        Label opacitylabel = new Label("   Opacity (%)");
        grid2.add((Node)opacitylabel, 2, 0);
        this.opacityTF = new FocusSpinner<Double>(0.0, 100.0, Double.valueOf(this.mapUI().getMapData().getTrace().getOpacity()) * 100.0);
        this.opacityTF.setMaxWidth(80.0);
        this.opacityTF.setMinWidth(80.0);
        grid2.add(this.opacityTF, 3, 0);
        this.opacityTF.setEditable(true);
        this.opacityTF.valueProperty().addListener((observable, oldValue, newValue) -> {
            this.mapUI().getMapData().getTrace().setOpacity((Double)this.opacityTF.getValue() / 100.0);
            this.mapUI().draw();
        });
        Label leftlabel = new Label("Top Left X (tiles)");
        grid2.add((Node)leftlabel, 0, 1);
        FocusSpinner traceTopLeftXTF = new FocusSpinner(-1.0E7, Double.MAX_VALUE, this.mapUI().getMapData().getTrace().getTopLeftX());
        traceTopLeftXTF.setMaxWidth(80.0);
        traceTopLeftXTF.setMinWidth(80.0);
        grid2.add(traceTopLeftXTF, 1, 1);
        traceTopLeftXTF.setEditable(true);
        traceTopLeftXTF.valueProperty().addListener((observable, oldValue, newValue) -> {
            this.mapUI().getMapData().getTrace().setTopLeftX((Double)traceTopLeftXTF.getValue());
            this.mapUI().draw();
        });
        Label toplabel = new Label("   Top Left Y (tiles)");
        grid2.add((Node)toplabel, 2, 1);
        FocusSpinner traceTopLeftYTF = new FocusSpinner(-1.0E7, Double.MAX_VALUE, this.mapUI().getMapData().getTrace().getTopLeftY());
        traceTopLeftYTF.setMaxWidth(80.0);
        grid2.add(traceTopLeftYTF, 3, 1);
        traceTopLeftYTF.setEditable(true);
        traceTopLeftYTF.valueProperty().addListener((observable, oldValue, newValue) -> {
            this.mapUI().getMapData().getTrace().setTopLeftY((Double)traceTopLeftYTF.getValue());
            this.mapUI().draw();
        });
        Label wlabel = new Label("Image Width (# tiles)");
        grid2.add((Node)wlabel, 0, 2);
        this.traceWidthTF = new FocusSpinner<Double>(0.0, Double.MAX_VALUE, this.mapUI().getMapData().getTrace().getWidth() * 100.0);
        this.traceWidthTF.setMaxWidth(80.0);
        grid2.add(this.traceWidthTF, 1, 2);
        this.traceWidthTF.setEditable(true);
        this.traceWidthTF.valueProperty().addListener((observable, oldValue, newValue) -> {
            this.mapUI().getMapData().getTrace().setWidth((Double)this.traceWidthTF.getValue() / 100.0);
            this.mapUI().draw();
        });
        Label hlabel = new Label("   Image Height (# tiles)");
        grid2.add((Node)hlabel, 2, 2);
        this.traceHeightTF = new FocusSpinner<Double>(0.0, Double.MAX_VALUE, this.mapUI().getMapData().getTrace().getHeight() * 100.0);
        this.traceHeightTF.setMaxWidth(80.0);
        grid2.add(this.traceHeightTF, 3, 2);
        this.traceHeightTF.setEditable(true);
        this.traceHeightTF.valueProperty().addListener((observable, oldValue, newValue) -> {
            this.mapUI().getMapData().getTrace().setHeight((Double)this.traceHeightTF.getValue() / 100.0);
            this.mapUI().draw();
        });
        return grid2;
    }
}

